# Description

Brief Description of the PR:

Fixes # (issue)

## Type of change

- [ ] Bug fix
- [ ] New Tutorial
- [ ] Updated or additional documentation
- [ ] Additional Testing
- [ ] New Activation and the changes conform to the [activation contribution guidelines](https://github.com/tensorflow/addons/blob/master/tensorflow_addons/activations/README.md#contribution-guidelines)
- [ ] New Callback and the changes conform to the [callback contribution guidelines](https://github.com/tensorflow/addons/blob/master/tensorflow_addons/callbacks/README.md#contribution-guidelines)
- [ ] New Image addition and the changes conform to the [image op contribution guidelines](https://github.com/tensorflow/addons/blob/master/tensorflow_addons/image/README.md#contribution-guidelines)
- [ ] New Layer and the changes conform to the [layer contribution guidelines](https://github.com/tensorflow/addons/blob/master/tensorflow_addons/layers/README.md#contribution-guidelines)
- [ ] New Loss and the changes conform to the [loss contribution guidelines](https://github.com/tensorflow/addons/blob/master/tensorflow_addons/losses/README.md#contribution-guidelines)
- [ ] New Metric and the changes conform to the [metric contribution guidelines](https://github.com/tensorflow/addons/blob/master/tensorflow_addons/metrics/README.md#contribution-guidelines)
- [ ] New Optimizer and the changes conform to the [optimizer contribution guidelines](https://github.com/tensorflow/addons/blob/master/tensorflow_addons/optimizers/README.md#contribution-guidelines)
- [ ] New RNN Cell and the changes conform to the [rnn contribution guidelines](https://github.com/tensorflow/addons/blob/master/tensorflow_addons/rnn/README.md#contribution-guidelines)
- [ ] New Seq2seq addition and the changes conform to the [seq2seq contribution guidelines](https://github.com/tensorflow/addons/blob/master/tensorflow_addons/seq2seq/README.md#contribution-guidelines)
- [ ] New Text addition and the changes conform to the [text op contribution guidelines](https://github.com/tensorflow/addons/blob/master/tensorflow_addons/text/README.md#contribution-guidelines)

# Checklist:

- [ ] I've properly [formatted my code according to the guidelines](https://github.com/tensorflow/addons/blob/master/CONTRIBUTING.md#coding-style)
    - [ ] By running Black + Flake8
    - [ ] By running pre-commit hooks
- [ ] This PR addresses an already submitted issue for TensorFlow Addons
- [ ] I have made corresponding changes to the documentation
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] This PR contains modifications to C++ custom-ops

# How Has This Been Tested?

If you're adding a bugfix or new feature please describe the tests that you ran to verify your changes:
*  
