#!/bin/env python
"""\
Test suite runner
Copyright (C) 2005 Remy Blank

This file is part of SvnReporter.

SvnReporter is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, version 2.

SvnReporter is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with SvnReporter; if not, write to the Free Software Foundation,
Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
"""

from optparse import OptionParser
import os
import sys
import TestCases
import unittest

__version__ = "1.1"
__author__ = "Remy Blank"


def actionDecrement(option, opt, value, parser):
    setattr(parser.values, option.dest, getattr(parser.values, option.dest) - 1)
        

def main(argv):
    """Parse command line and execute tests"""
    parser = OptionParser("%prog [options] [module ...]", version="%prog " + __version__)
    parser.set_defaults(verbosity=1)
    parser.add_option("-q", "--quiet", action="callback", callback=actionDecrement, dest="verbosity",
        help="be less verbose")
    parser.add_option("-v", "--verbose", action="count", dest="verbosity",
        help="be more verbose")
    (options, modules) = parser.parse_args()
    
    suite = unittest.TestSuite()
    loader = unittest.defaultTestLoader
    testCases = ["test" + each for each in modules]
    try:
        sys.path.append(os.path.join(os.path.dirname(__file__), os.path.pardir, "lib"))
        for each in testCases or TestCases.__all__:
            module = getattr(__import__("TestCases." + each), each)
            suite.addTest(loader.loadTestsFromModule(module))
    except ImportError, e:
        parser.error(e.__class__.__name__ + ": " + str(e))
    
    runner = unittest.TextTestRunner(verbosity=options.verbosity)
    result = runner.run(suite)
    return not result.wasSuccessful()


if __name__ == "__main__":
    sys.exit(main(sys.argv))
