"""\
Test cases for Config
Copyright (C) 2005 Remy Blank

This file is part of SvnReporter.

SvnReporter is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, version 2.

SvnReporter is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with SvnReporter; if not, write to the Free Software Foundation,
Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
"""

import ConfigParser
from cStringIO import StringIO
import os
import sys
import unittest

import SvnReporter

sys.path.append(os.path.dirname(__file__))        # To find Imports.py


class ConfigTest(unittest.TestCase):
    def testCompleteConfig(self):
        """Reading of a complete configuration"""
        config = SvnReporter.Config(StringIO("""\
[DEFAULT]
module = Imports.py
generators = 
    Feed("Atom.xml", "/var/www/localhost/htdocs/%(__name__)s.atom", %(entries)s),
    Mail("Mail.elm", "host.domain", "%(mailFrom)s", '''%(mailTo)s''')
mailFrom = me@%(host)s
host = here
entries = 1000
myVar = 1

[All]
match = .*
mailTo =
    admin@nospam.com

[SvnReporter]
entries = 50
GENERATORS = abc
match = 
        Projects/%(__name__)s/.*
        Projects/PyAtom/.*
mailTo = 
    user1@nospam.com
    user2@nospam.com

[PyAtom]
match = Projects/%(__name__)s/.*
mailTo = 
    user2@nospam.com
    user3@nospam.com
"""))
        self.assertEqual(3, len(config.sections))
        feed = config.sections["All"]
        self.assertEqual(1, len(feed.match.regexes))
        self.assertEqual(".*", feed.match.regexes[0].pattern)
        generator = feed.generators[0]
        self.assertEqual("Atom.xml", generator.template)
        self.assertEqual(1000, generator.entries)
        self.assertEqual("/var/www/localhost/htdocs/All.atom", generator.destination)
        generator = feed.generators[1]
        self.assertEqual("Mail.elm", generator.template)
        self.assertEqual("me@here", generator.mailFrom)
        self.assertEqual(1, feed["var"])
        self.assertEqual(1, feed["counter"]())        # Check that every section gets its own module
        self.assertEqual(2, feed["counter"]())
        
        feed = config.sections["SvnReporter"]
        self.assertEqual(2, len(feed.match.regexes))
        self.assertEqual("Projects/SvnReporter/.*", feed.match.regexes[0].pattern)
        self.assertEqual("Projects/PyAtom/.*", feed.match.regexes[1].pattern)
        generator = feed.generators[0]
        self.assertEqual("Atom.xml", generator.template)
        self.assertEqual(50, generator.entries)
        self.assertEqual("/var/www/localhost/htdocs/SvnReporter.atom", generator.destination)
        generator = feed.generators[1]
        self.assertEqual("Mail.elm", generator.template)
        self.assertEqual("me@here", generator.mailFrom)
        self.assertEqual(1, feed["var"])
        self.assertEqual(1, feed["counter"]())        # Check that every section gets its own module
        self.assertEqual(2, feed["counter"]())

        feed = config.sections["PyAtom"]
        self.assertEqual(1, len(feed.match.regexes))
        self.assertEqual("Projects/PyAtom/.*", feed.match.regexes[0].pattern)
        generator = feed.generators[0]
        self.assertEqual("Atom.xml", generator.template)
        self.assertEqual(1000, generator.entries)
        self.assertEqual("/var/www/localhost/htdocs/PyAtom.atom", generator.destination)
        generator = feed.generators[1]
        self.assertEqual("Mail.elm", generator.template)
        self.assertEqual("me@here", generator.mailFrom)
        self.assertEqual(1, feed["var"])
        self.assertEqual(1, feed["counter"]())        # Check that every section gets its own module
        self.assertEqual(2, feed["counter"]())

