"""\
Test cases for ChainDict
Copyright (C) 2005 Remy Blank

This file is part of SvnReporter.

SvnReporter is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, version 2.

SvnReporter is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with SvnReporter; if not, write to the Free Software Foundation,
Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
"""

import unittest

import SvnReporter


class ChainDictTest(unittest.TestCase):
    def testCreation(self):
        """ChainDict creation"""
        d = SvnReporter.ChainDict()
        self.assertEqual({}, d)
        d = SvnReporter.ChainDict(None, a=1, b=2)
        self.assertEqual({"a": 1, "b": 2}, d)
    
    def testDelegation(self):
        """Delegation in a ChainDict"""
        d1 = dict(a=1, b=2)
        d2 = SvnReporter.ChainDict(d1, b=3, c=4)
        self.assert_("a" in d2)
        self.assert_("b" in d2)
        self.assert_("c" in d2)
        self.assert_("d" not in d2)
        self.assertEqual(1, d2["a"])
        self.assertEqual(3, d2["b"])
        self.assertEqual(4, d2["c"])
        self.assertRaises(KeyError, d2.__getitem__, "d")
        
