#!/usr/bin/env python
"""\
Installation script for SvnReporter.py
Copyright (C) 2005  Remy Blank

This file is part of SvnReporter.

SvnReporter is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, version 2.

SvnReporter is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with SvnReporter; if not, write to the Free Software Foundation,
Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
"""

from distutils.core import setup
import os
import sys

if sys.version_info[:2] < (2, 4):
    print "SvnReporter requires version 2.4 or later of python"
    sys.exit(1)

# Import project metadata
sys.path.insert(0, os.path.join(os.path.dirname(__file__), "lib"))
from SvnReporter import _metadata_

setup(
    name = _metadata_.project,
    version = _metadata_.version,
    author = _metadata_.author,
    author_email = _metadata_.email,
    license = _metadata_.license,
    url = _metadata_.url,
    download_url = _metadata_.download,
    description = _metadata_.description,
    long_description = _metadata_.longDescription,
    keywords = _metadata_.keywords,
    platforms = _metadata_.platforms,
    classifiers = _metadata_.classifiers,
    
    package_dir = {"": "lib"},
    py_modules = ["SvnReporter"],
    scripts = ["bin/SvnReporter"],
    data_files = [
        ("share/doc/SvnReporter-%s" % _metadata_.version,
            ["ChangeLog",
             "COPYING",
             "README",
             "doc/SvnReporter.html"]),
        ("share/doc/SvnReporter-%s/examples" % _metadata_.version,
            ["doc/examples/Imports.py",
             "doc/examples/SvnReporter.ini",
             "doc/examples/atom.xml",
             "doc/examples/mail.txt",
             "doc/examples/rss.xml"])
    ]
)

if (_metadata_.version[-1:] == "x") or (_metadata_.date[-2:] == "xx"):
    print "\n*\n* WARNING: release metadata is not set\n*"
