# coding: utf8
from __future__ import unicode_literals

# Original pairs downloaded from http://www.lexiconista.com/datasets/lemmatization/
# Replaced characters using cedillas with the correct ones (ș and ț)

LOOKUP = {
    "abale": "aba",
    "abalei": "aba",
    "abalele": "aba",
    "abalelor": "aba",
    "abaua": "aba",
    "abace": "abac",
    "abacele": "abac",
    "abacelor": "abac",
    "abacul": "abac",
    "abacului": "abac",
    "abaca": "abacă",
    "abace": "abacă",
    "abacei": "abacă",
    "abacele": "abacă",
    "abacelor": "abacă",
    "abagița": "abagiță",
    "abagițe": "abagiță",
    "abagiței": "abagiță",
    "abagițele": "abagiță",
    "abagițelor": "abagiță",
    "abagii": "abagiu",
    "abagiii": "abagiu",
    "abagiilor": "abagiu",
    "abagiul": "abagiu",
    "abagiului": "abagiu",
    "abajurul": "abajur",
    "abajurului": "abajur",
    "abajururi": "abajur",
    "abajururile": "abajur",
    "abajururilor": "abajur",
    "abandonul": "abandon",
    "abandonului": "abandon",
    "abandonuri": "abandon",
    "abandonurile": "abandon",
    "abandonurilor": "abandon",
    "abandonă": "abandona",
    "abandonai": "abandona",
    "abandonam": "abandona",
    "abandonăm": "abandona",
    "abandonând": "abandona",
    "abandonându": "abandona",
    "abandonară": "abandona",
    "abandonarăm": "abandona",
    "abandonarăți": "abandona",
    "abandonase": "abandona",
    "abandonasem": "abandona",
    "abandonaseră": "abandona",
    "abandonaserăm": "abandona",
    "abandonaserăți": "abandona",
    "abandonaseși": "abandona",
    "abandonași": "abandona",
    "abandonat": "abandona",
    "abandonați": "abandona",
    "abandonatu": "abandona",
    "abandonau": "abandona",
    "abandonează": "abandona",
    "abandonez": "abandona",
    "abandoneze": "abandona",
    "abandonezi": "abandona",
    "neabandonând": "abandona",
    "neabandonându": "abandona",
    "nemaiabandonând": "abandona",
    "nemaiabandonându": "abandona",
    "abandonarea": "abandonare",
    "abandonări": "abandonare",
    "abandonării": "abandonare",
    "abandonările": "abandonare",
    "abandonata": "abandonat",
    "abandonată": "abandonat",
    "abandonate": "abandonat",
    "abandonatei": "abandonat",
    "abandonatele": "abandonat",
    "abandonatelor": "abandonat",
    "abandonați": "abandonat",
    "abandonații": "abandonat",
    "abandonaților": "abandonat",
    "abandonatul": "abandonat",
    "abandonatului": "abandonat",
    "abanoși": "abanos",
    "abanoșii": "abanos",
    "abanoșilor": "abanos",
    "abanosul": "abanos",
    "abanosului": "abanos",
    "abataje": "abataj",
    "abatajele": "abataj",
    "abatajelor": "abataj",
    "abatajul": "abataj",
    "abatajului": "abataj",
    "abat": "abate",
    "abată": "abate",
    "abătând": "abate",
    "abătându": "abate",
    "abătea": "abate",
    "abăteai": "abate",
    "abăteam": "abate",
    "abăteați": "abate",
    "abăteau": "abate",
    "abatele": "abate",
    "abatelui": "abate",
    "abatem": "abate",
    "abateți": "abate",
    "abați": "abate",
    "abații": "abate",
    "abaților": "abate",
    "abătu": "abate",
    "abătui": "abate",
    "abătură": "abate",
    "abăturăm": "abate",
    "abăturăți": "abate",
    "abătuse": "abate",
    "abătusem": "abate",
    "abătuseră": "abate",
    "abătuserăm": "abate",
    "abătuserăți": "abate",
    "abătuseși": "abate",
    "abătuși": "abate",
    "abătut": "abate",
    "abătutu": "abate",
    "neabătând": "abate",
    "neabătându": "abate",
    "nemaiabătând": "abate",
    "nemaiabătându": "abate",
    "abaterea": "abatere",
    "abateri": "abatere",
    "abaterii": "abatere",
    "abaterile": "abatere",
    "abația": "abație",
    "abației": "abație",
    "abații": "abație",
    "abațiile": "abație",
    "abațiilor": "abație",
    "abatiza": "abatiză",
    "abatize": "abatiză",
    "abatizei": "abatiză",
    "abatizele": "abatiză",
    "abatizelor": "abatiză",
    "abatoare": "abator",
    "abatoarele": "abator",
    "abatoarelor": "abator",
    "abatorul": "abator",
    "abatorului": "abator",
    "abătuta": "abătut",
    "abătută": "abătut",
    "abătute": "abătut",
    "abătutei": "abătut",
    "abătutele": "abătut",
    "abătutelor": "abătut",
    "abătuți": "abătut",
    "abătuții": "abătut",
    "abătuților": "abătut",
    "abătutul": "abătut",
    "abătutului": "abătut",
    "abcese": "abces",
    "abcesele": "abces",
    "abceselor": "abces",
    "abcesul": "abces",
    "abcesului": "abces",
    "abdic": "abdica",
    "abdică": "abdica",
    "abdicai": "abdica",
    "abdicam": "abdica",
    "abdicăm": "abdica",
    "abdicând": "abdica",
    "abdicându": "abdica",
    "abdicară": "abdica",
    "abdicarăm": "abdica",
    "abdicarăți": "abdica",
    "abdicase": "abdica",
    "abdicasem": "abdica",
    "abdicaseră": "abdica",
    "abdicaserăm": "abdica",
    "abdicaserăți": "abdica",
    "abdicaseși": "abdica",
    "abdicași": "abdica",
    "abdicat": "abdica",
    "abdicați": "abdica",
    "abdicatu": "abdica",
    "abdicau": "abdica",
    "abdice": "abdica",
    "abdici": "abdica",
    "neabdicând": "abdica",
    "neabdicându": "abdica",
    "nemaiabdicând": "abdica",
    "nemaiabdicându": "abdica",
    "abdicarea": "abdicare",
    "abdicări": "abdicare",
    "abdicării": "abdicare",
    "abdicările": "abdicare",
    "abdicata": "abdicat",
    "abdicată": "abdicat",
    "abdicate": "abdicat",
    "abdicatei": "abdicat",
    "abdicatele": "abdicat",
    "abdicatelor": "abdicat",
    "abdicați": "abdicat",
    "abdicații": "abdicat",
    "abdicaților": "abdicat",
    "abdicatul": "abdicat",
    "abdicatului": "abdicat",
    "abdomene": "abdomen",
    "abdomenele": "abdomen",
    "abdomenelor": "abdomen",
    "abdomenul": "abdomen",
    "abdomenului": "abdomen",
    "abdominală": "abdominal",
    "abdominale": "abdominal",
    "abdominalei": "abdominal",
    "abdominalele": "abdominal",
    "abdominalelor": "abdominal",
    "abdominali": "abdominal",
    "abdominalii": "abdominal",
    "abdominalilor": "abdominal",
    "abdominalul": "abdominal",
    "abdominalului": "abdominal",
    "abductori": "abductor",
    "abductorii": "abductor",
    "abductorilor": "abductor",
    "abductorul": "abductor",
    "abductorului": "abductor",
    "abeceu": "abece",
    "abeceu'": "abece",
    "abecedare": "abecedar",
    "abecedarele": "abecedar",
    "abecedarelor": "abecedar",
    "abecedarul": "abecedar",
    "abecedarului": "abecedar",
    "aberanta": "aberant",
    "aberantă": "aberant",
    "aberante": "aberant",
    "aberantei": "aberant",
    "aberantele": "aberant",
    "aberantelor": "aberant",
    "aberanți": "aberant",
    "aberanții": "aberant",
    "aberanților": "aberant",
    "aberantul": "aberant",
    "aberantului": "aberant",
    "aberația": "aberație",
    "aberației": "aberație",
    "aberații": "aberație",
    "aberațiile": "aberație",
    "aberațiilor": "aberație",
    "abila": "abil",
    "abilă": "abil",
    "abile": "abil",
    "abilei": "abil",
    "abilele": "abil",
    "abilelor": "abil",
    "abili": "abil",
    "abilii": "abil",
    "abililor": "abil",
    "abilul": "abil",
    "abilului": "abil",
    "abilită": "abilita",
    "abilitai": "abilita",
    "abilitam": "abilita",
    "abilităm": "abilita",
    "abilitând": "abilita",
    "abilitându": "abilita",
    "abilitară": "abilita",
    "abilitarăm": "abilita",
    "abilitarăți": "abilita",
    "abilitase": "abilita",
    "abilitasem": "abilita",
    "abilitaseră": "abilita",
    "abilitaserăm": "abilita",
    "abilitaserăți": "abilita",
    "abilitaseși": "abilita",
    "abilitași": "abilita",
    "abilitat": "abilita",
    "abilitați": "abilita",
    "abilitatu": "abilita",
    "abilitau": "abilita",
    "abilitează": "abilita",
    "abilitez": "abilita",
    "abiliteze": "abilita",
    "abilitezi": "abilita",
    "neabilitând": "abilita",
    "neabilitându": "abilita",
    "nemaiabilitând": "abilita",
    "nemaiabilitându": "abilita",
    "abilitarea": "abilitare",
    "abilitări": "abilitare",
    "abilitării": "abilitare",
    "abilitările": "abilitare",
    "abilitata": "abilitat",
    "abilitată": "abilitat",
    "abilitate": "abilitat",
    "abilitatei": "abilitat",
    "abilitatele": "abilitat",
    "abilitatelor": "abilitat",
    "abilitați": "abilitat",
    "abilitații": "abilitat",
    "abilitaților": "abilitat",
    "abilitatul": "abilitat",
    "abilitatului": "abilitat",
    "abilitatea": "abilitate",
    "abilități": "abilitate",
    "abilității": "abilitate",
    "abilitățile": "abilitate",
    "abilităților": "abilitate",
    "abiotica": "abiotic",
    "abiotică": "abiotic",
    "abiotice": "abiotic",
    "abioticei": "abiotic",
    "abioticele": "abiotic",
    "abioticelor": "abiotic",
    "abiotici": "abiotic",
    "abioticii": "abiotic",
    "abioticilor": "abiotic",
    "abioticul": "abiotic",
    "abioticului": "abiotic",
    "abisul": "abis",
    "abisului": "abis",
    "abisuri": "abis",
    "abisurile": "abis",
    "abisurilor": "abis",
    "abisala": "abisal",
    "abisală": "abisal",
    "abisale": "abisal",
    "abisalei": "abisal",
    "abisalele": "abisal",
    "abisalelor": "abisal",
    "abisali": "abisal",
    "abisalii": "abisal",
    "abisalilor": "abisal",
    "abisalul": "abisal",
    "abisalului": "abisal",
    "abjecta": "abject",
    "abjectă": "abject",
    "abjecte": "abject",
    "abjectei": "abject",
    "abjectele": "abject",
    "abjectelor": "abject",
    "abjecți": "abject",
    "abjecții": "abject",
    "abjecților": "abject",
    "abjectul": "abject",
    "abjectului": "abject",
    "abjecția": "abjecție",
    "abjecției": "abjecție",
    "abjecții": "abjecție",
    "abjecțiile": "abjecție",
    "abjecțiilor": "abjecție",
    "abjur": "abjura",
    "abjură": "abjura",
    "abjurai": "abjura",
    "abjuram": "abjura",
    "abjurăm": "abjura",
    "abjurând": "abjura",
    "abjurându": "abjura",
    "abjurară": "abjura",
    "abjurarăm": "abjura",
    "abjurarăți": "abjura",
    "abjurase": "abjura",
    "abjurasem": "abjura",
    "abjuraseră": "abjura",
    "abjuraserăm": "abjura",
    "abjuraserăți": "abjura",
    "abjuraseși": "abjura",
    "abjurași": "abjura",
    "abjurat": "abjura",
    "abjurați": "abjura",
    "abjuratu": "abjura",
    "abjurau": "abjura",
    "abjure": "abjura",
    "abjuri": "abjura",
    "abjurarea": "abjurare",
    "abjurări": "abjurare",
    "abjurării": "abjurare",
    "abjurările": "abjurare",
    "abjurărilor": "abjurare",
    "abjurată": "abjurat",
    "abjurate": "abjurat",
    "abjurați": "abjurat",
    "abnegația": "abnegație",
    "abnegației": "abnegație",
    "abnegații": "abnegație",
    "abnegațiile": "abnegație",
    "abnegațiilor": "abnegație",
    "abolea": "aboli",
    "aboleai": "aboli",
    "aboleam": "aboli",
    "abolească": "aboli",
    "aboleați": "aboli",
    "aboleau": "aboli",
    "abolesc": "aboli",
    "abolește": "aboli",
    "abolești": "aboli",
    "abolii": "aboli",
    "abolim": "aboli",
    "abolind": "aboli",
    "abolindu": "aboli",
    "aboliră": "aboli",
    "abolirăm": "aboli",
    "abolirăți": "aboli",
    "abolise": "aboli",
    "abolisem": "aboli",
    "aboliseră": "aboli",
    "aboliserăm": "aboli",
    "aboliserăți": "aboli",
    "aboliseși": "aboli",
    "aboliși": "aboli",
    "abolit": "aboli",
    "aboliți": "aboli",
    "abolitu": "aboli",
    "neabolind": "aboli",
    "neabolindu": "aboli",
    "nemaiabolind": "aboli",
    "nemaiabolindu": "aboli",
    "abolirea": "abolire",
    "aboliri": "abolire",
    "abolirii": "abolire",
    "abolirile": "abolire",
    "abolita": "abolit",
    "abolită": "abolit",
    "abolite": "abolit",
    "abolitei": "abolit",
    "abolitele": "abolit",
    "abolitelor": "abolit",
    "aboliți": "abolit",
    "aboliții": "abolit",
    "aboliților": "abolit",
    "abolitul": "abolit",
    "abolitului": "abolit",
    "aboliționista": "aboliționist",
    "aboliționistă": "aboliționist",
    "aboliționiste": "aboliționist",
    "aboliționistei": "aboliționist",
    "aboliționistele": "aboliționist",
    "aboliționistelor": "aboliționist",
    "aboliționiști": "aboliționist",
    "aboliționiștii": "aboliționist",
    "aboliționiștilor": "aboliționist",
    "aboliționistul": "aboliționist",
    "aboliționistului": "aboliționist",
    "abominabila": "abominabil",
    "abominabilă": "abominabil",
    "abominabile": "abominabil",
    "abominabilei": "abominabil",
    "abominabilele": "abominabil",
    "abominabilelor": "abominabil",
    "abominabili": "abominabil",
    "abominabilii": "abominabil",
    "abominabililor": "abominabil",
    "abominabilul": "abominabil",
    "abominabilului": "abominabil",
    "abonă": "abona",
    "abonai": "abona",
    "abonam": "abona",
    "abonăm": "abona",
    "abonând": "abona",
    "abonându": "abona",
    "abonară": "abona",
    "abonarăm": "abona",
    "abonarăți": "abona",
    "abonase": "abona",
    "abonasem": "abona",
    "abonaseră": "abona",
    "abonaserăm": "abona",
    "abonaserăți": "abona",
    "abonaseși": "abona",
    "abonași": "abona",
    "abonat": "abona",
    "abonați": "abona",
    "abonatu": "abona",
    "abonau": "abona",
    "abonează": "abona",
    "abonez": "abona",
    "aboneze": "abona",
    "abonezi": "abona",
    "neabonând": "abona",
    "neabonându": "abona",
    "nemaiabonând": "abona",
    "nemaiabonându": "abona",
    "abonamente": "abonament",
    "abonamentele": "abonament",
    "abonamentelor": "abonament",
    "abonamentul": "abonament",
    "abonamentului": "abonament",
    "abonarea": "abonare",
    "abonări": "abonare",
    "abonării": "abonare",
    "abonările": "abonare",
    "abonata": "abonat",
    "abonată": "abonat",
    "abonate": "abonat",
    "abonatei": "abonat",
    "abonatele": "abonat",
    "abonatelor": "abonat",
    "abonați": "abonat",
    "abonații": "abonat",
    "abonaților": "abonat",
    "abonatul": "abonat",
    "abonatului": "abonat",
    "abonata": "abonată",
    "abonate": "abonată",
    "abonatei": "abonată",
    "abonatele": "abonată",
    "abonatelor": "abonată",
    "abordă": "aborda",
    "abordai": "aborda",
    "abordam": "aborda",
    "abordăm": "aborda",
    "abordând": "aborda",
    "abordându": "aborda",
    "abordară": "aborda",
    "abordarăm": "aborda",
    "abordarăți": "aborda",
    "abordase": "aborda",
    "abordasem": "aborda",
    "abordaseră": "aborda",
    "abordaserăm": "aborda",
    "abordaserăți": "aborda",
    "abordaseși": "aborda",
    "abordași": "aborda",
    "abordat": "aborda",
    "abordați": "aborda",
    "abordatu": "aborda",
    "abordau": "aborda",
    "abordează": "aborda",
    "abordez": "aborda",
    "abordeze": "aborda",
    "abordezi": "aborda",
    "neabordând": "aborda",
    "neabordându": "aborda",
    "nemaiabordând": "aborda",
    "nemaiabordându": "aborda",
    "abordabila": "abordabil",
    "abordabilă": "abordabil",
    "abordabile": "abordabil",
    "abordabilei": "abordabil",
    "abordabilele": "abordabil",
    "abordabilelor": "abordabil",
    "abordabili": "abordabil",
    "abordabilii": "abordabil",
    "abordabililor": "abordabil",
    "abordabilul": "abordabil",
    "abordabilului": "abordabil",
    "abordarea": "abordare",
    "abordări": "abordare",
    "abordării": "abordare",
    "abordările": "abordare",
    "abordata": "abordat",
    "abordată": "abordat",
    "abordate": "abordat",
    "abordatei": "abordat",
    "abordatele": "abordat",
    "abordatelor": "abordat",
    "abordați": "abordat",
    "abordații": "abordat",
    "abordaților": "abordat",
    "abordatul": "abordat",
    "abordatului": "abordat",
    "aborigeni": "aborigen",
    "aborigenii": "aborigen",
    "aborigenilor": "aborigen",
    "aborigenul": "aborigen",
    "aborigenului": "aborigen",
    "abortiva": "abortiv",
    "abortivă": "abortiv",
    "abortive": "abortiv",
    "abortivei": "abortiv",
    "abortivele": "abortiv",
    "abortivelor": "abortiv",
    "abortivi": "abortiv",
    "abortivii": "abortiv",
    "abortivilor": "abortiv",
    "abortivul": "abortiv",
    "abortivului": "abortiv",
    "abrașa": "abraș",
    "abrașă": "abraș",
    "abrașe": "abraș",
    "abrașei": "abraș",
    "abrașele": "abraș",
    "abrașelor": "abraș",
    "abrași": "abraș",
    "abrașii": "abraș",
    "abrașilor": "abraș",
    "abrașul": "abraș",
    "abrașului": "abraș",
    "abraziunea": "abraziune",
    "abraziuni": "abraziune",
    "abraziunii": "abraziune",
    "abraziunile": "abraziune",
    "abraziunilor": "abraziune",
    "abr.": "abraziv",
    "abraziva": "abraziv",
    "abrazivă": "abraziv",
    "abrazive": "abraziv",
    "abrazivei": "abraziv",
    "abrazivele": "abraziv",
    "abrazivelor": "abraziv",
    "abrazivi": "abraziv",
    "abrazivii": "abraziv",
    "abrazivilor": "abraziv",
    "abrazivul": "abraziv",
    "abrazivului": "abraziv",
    "abreviai": "abrevia",
    "abreviam": "abrevia",
    "abreviară": "abrevia",
    "abreviarăm": "abrevia",
    "abreviarăți": "abrevia",
    "abreviase": "abrevia",
    "abreviasem": "abrevia",
    "abreviaseră": "abrevia",
    "abreviaserăm": "abrevia",
    "abreviaserăți": "abrevia",
    "abreviaseși": "abrevia",
    "abreviași": "abrevia",
    "abreviat": "abrevia",
    "abreviați": "abrevia",
    "abreviatu": "abrevia",
    "abreviau": "abrevia",
    "abreviază": "abrevia",
    "abrevie": "abrevia",
    "abreviem": "abrevia",
    "abreviez": "abrevia",
    "abrevieze": "abrevia",
    "abreviezi": "abrevia",
    "abreviind": "abrevia",
    "abreviindu": "abrevia",
    "neabreviind": "abrevia",
    "neabreviindu": "abrevia",
    "nemaiabreviind": "abrevia",
    "nemaiabreviindu": "abrevia",
    "abreviabilă": "abreviabil",
    "abreviabile": "abreviabil",
    "abreviabili": "abreviabil",
    "abreviata": "abreviat",
    "abreviată": "abreviat",
    "abreviate": "abreviat",
    "abreviatei": "abreviat",
    "abreviatele": "abreviat",
    "abreviatelor": "abreviat",
    "abreviați": "abreviat",
    "abreviații": "abreviat",
    "abreviaților": "abreviat",
    "abreviatul": "abreviat",
    "abreviatului": "abreviat",
    "abreviativa": "abreviativ",
    "abreviativă": "abreviativ",
    "abreviative": "abreviativ",
    "abreviativei": "abreviativ",
    "abreviativele": "abreviativ",
    "abreviativelor": "abreviativ",
    "abreviativi": "abreviativ",
    "abreviativii": "abreviativ",
    "abreviativilor": "abreviativ",
    "abreviativul": "abreviativ",
    "abreviativului": "abreviativ",
    "abr.": "abreviere",
    "abrevierea": "abreviere",
    "abrevieri": "abreviere",
    "abrevierii": "abreviere",
    "abrevierile": "abreviere",
    "abrog": "abroga",
    "abrogă": "abroga",
    "abrogai": "abroga",
    "abrogam": "abroga",
    "abrogăm": "abroga",
    "abrogând": "abroga",
    "abrogându": "abroga",
    "abrogară": "abroga",
    "abrogarăm": "abroga",
    "abrogarăți": "abroga",
    "abrogase": "abroga",
    "abrogasem": "abroga",
    "abrogaseră": "abroga",
    "abrogaserăm": "abroga",
    "abrogaserăți": "abroga",
    "abrogaseși": "abroga",
    "abrogași": "abroga",
    "abrogat": "abroga",
    "abrogați": "abroga",
    "abrogatu": "abroga",
    "abrogau": "abroga",
    "abroge": "abroga",
    "abrogi": "abroga",
    "neabrogând": "abroga",
    "neabrogându": "abroga",
    "nemaiabrogând": "abroga",
    "nemaiabrogându": "abroga",
    "abrogarea": "abrogare",
    "abrogări": "abrogare",
    "abrogării": "abrogare",
    "abrogările": "abrogare",
    "abrogata": "abrogat",
    "abrogată": "abrogat",
    "abrogate": "abrogat",
    "abrogatei": "abrogat",
    "abrogatele": "abrogat",
    "abrogatelor": "abrogat",
    "abrogați": "abrogat",
    "abrogații": "abrogat",
    "abrogaților": "abrogat",
    "abrogatul": "abrogat",
    "abrogatului": "abrogat",
    "abruc": "abruca",
    "abrucă": "abruca",
    "abrucai": "abruca",
    "abrucam": "abruca",
    "abrucăm": "abruca",
    "abrucând": "abruca",
    "abrucându": "abruca",
    "abrucară": "abruca",
    "abrucarăm": "abruca",
    "abrucarăți": "abruca",
    "abrucase": "abruca",
    "abrucasem": "abruca",
    "abrucaseră": "abruca",
    "abrucaserăm": "abruca",
    "abrucaserăți": "abruca",
    "abrucaseși": "abruca",
    "abrucași": "abruca",
    "abrucat": "abruca",
    "abrucați": "abruca",
    "abrucatu": "abruca",
    "abrucau": "abruca",
    "abruce": "abruca",
    "abruci": "abruca",
    "abrucată": "abrucat",
    "abrucate": "abrucat",
    "abrucați": "abrucat",
    "abrupta": "abrupt",
    "abruptă": "abrupt",
    "abrupte": "abrupt",
    "abruptei": "abrupt",
    "abruptele": "abrupt",
    "abruptelor": "abrupt",
    "abrupți": "abrupt",
    "abrupții": "abrupt",
    "abrupților": "abrupt",
    "abrupto": "abrupt",
    "abruptul": "abrupt",
    "abruptului": "abrupt",
    "abrutiză": "abrutiza",
    "abrutizai": "abrutiza",
    "abrutizam": "abrutiza",
    "abrutizăm": "abrutiza",
    "abrutizând": "abrutiza",
    "abrutizându": "abrutiza",
    "abrutizară": "abrutiza",
    "abrutizarăm": "abrutiza",
    "abrutizarăți": "abrutiza",
    "abrutizase": "abrutiza",
    "abrutizasem": "abrutiza",
    "abrutizaseră": "abrutiza",
    "abrutizaserăm": "abrutiza",
    "abrutizaserăți": "abrutiza",
    "abrutizaseși": "abrutiza",
    "abrutizași": "abrutiza",
    "abrutizat": "abrutiza",
    "abrutizați": "abrutiza",
    "abrutizatu": "abrutiza",
    "abrutizau": "abrutiza",
    "abrutizează": "abrutiza",
    "abrutizez": "abrutiza",
    "abrutizeze": "abrutiza",
    "abrutizezi": "abrutiza",
    "neabrutizând": "abrutiza",
    "neabrutizându": "abrutiza",
    "nemaiabrutizând": "abrutiza",
    "nemaiabrutizându": "abrutiza",
    "abrutizanta": "abrutizant",
    "abrutizantă": "abrutizant",
    "abrutizante": "abrutizant",
    "abrutizantei": "abrutizant",
    "abrutizantele": "abrutizant",
    "abrutizantelor": "abrutizant",
    "abrutizanți": "abrutizant",
    "abrutizanții": "abrutizant",
    "abrutizanților": "abrutizant",
    "abrutizantul": "abrutizant",
    "abrutizantului": "abrutizant",
    "abrutizarea": "abrutizare",
    "abrutizări": "abrutizare",
    "abrutizării": "abrutizare",
    "abrutizările": "abrutizare",
    "abrutizata": "abrutizat",
    "abrutizată": "abrutizat",
    "abrutizate": "abrutizat",
    "abrutizatei": "abrutizat",
    "abrutizatele": "abrutizat",
    "abrutizatelor": "abrutizat",
    "abrutizați": "abrutizat",
    "abrutizații": "abrutizat",
    "abrutizaților": "abrutizat",
    "abrutizatul": "abrutizat",
    "abrutizatului": "abrutizat",
    "abrutizata": "abrutizată",
    "abrutizate": "abrutizată",
    "abrutizatei": "abrutizată",
    "abrutizatele": "abrutizată",
    "abrutizatelor": "abrutizată",
    "absconsa": "abscons",
    "absconsă": "abscons",
    "absconse": "abscons",
    "absconsei": "abscons",
    "absconsele": "abscons",
    "absconselor": "abscons",
    "absconși": "abscons",
    "absconșii": "abscons",
    "absconșilor": "abscons",
    "absconsul": "abscons",
    "absconsului": "abscons",
    "absenta": "absent",
    "absentă": "absent",
    "absente": "absent",
    "absentei": "absent",
    "absentele": "absent",
    "absentelor": "absent",
    "absenți": "absent",
    "absenții": "absent",
    "absenților": "absent",
    "absentul": "absent",
    "absentului": "absent",
    "absentă": "absenta",
    "absentai": "absenta",
    "absentam": "absenta",
    "absentăm": "absenta",
    "absentând": "absenta",
    "absentându": "absenta",
    "absentară": "absenta",
    "absentarăm": "absenta",
    "absentarăți": "absenta",
    "absentase": "absenta",
    "absentasem": "absenta",
    "absentaseră": "absenta",
    "absentaserăm": "absenta",
    "absentaserăți": "absenta",
    "absentaseși": "absenta",
    "absentași": "absenta",
    "absentat": "absenta",
    "absentați": "absenta",
    "absentatu": "absenta",
    "absentau": "absenta",
    "absentează": "absenta",
    "absentez": "absenta",
    "absenteze": "absenta",
    "absentezi": "absenta",
    "absența": "absență",
    "absențe": "absență",
    "absenței": "absență",
    "absențele": "absență",
    "absențelor": "absență",
    "absentarea": "absentare",
    "absentări": "absentare",
    "absentării": "absentare",
    "absentările": "absentare",
    "absentărilor": "absentare",
    "absentata": "absentat",
    "absentată": "absentat",
    "absentate": "absentat",
    "absentatei": "absentat",
    "absentatele": "absentat",
    "absentatelor": "absentat",
    "absentați": "absentat",
    "absentații": "absentat",
    "absentaților": "absentat",
    "absentatul": "absentat",
    "absentatului": "absentat",
    "absidiala": "absidial",
    "absidială": "absidial",
    "absidiale": "absidial",
    "absidialele": "absidial",
    "absidialelor": "absidial",
    "absidiali": "absidial",
    "absidialii": "absidial",
    "absidialilor": "absidial",
    "absidialul": "absidial",
    "absidialului": "absidial",
    "absoluta": "absolut",
    "absolută": "absolut",
    "absolute": "absolut",
    "absolutei": "absolut",
    "absolutele": "absolut",
    "absolutelor": "absolut",
    "absoluți": "absolut",
    "absoluții": "absolut",
    "absoluților": "absolut",
    "absolutul": "absolut",
    "absolutului": "absolut",
    "absolutisme": "absolutism",
    "absolutismele": "absolutism",
    "absolutismelor": "absolutism",
    "absolutismul": "absolutism",
    "absolutismului": "absolutism",
    "absolutista": "absolutist",
    "absolutistă": "absolutist",
    "absolutiste": "absolutist",
    "absolutistei": "absolutist",
    "absolutistele": "absolutist",
    "absolutistelor": "absolutist",
    "absolutiști": "absolutist",
    "absolutiștii": "absolutist",
    "absolutiștilor": "absolutist",
    "absolutistul": "absolutist",
    "absolutistului": "absolutist",
    "absolutiză": "absolutiza",
    "absolutizai": "absolutiza",
    "absolutizam": "absolutiza",
    "absolutizăm": "absolutiza",
    "absolutizând": "absolutiza",
    "absolutizându": "absolutiza",
    "absolutizară": "absolutiza",
    "absolutizarăm": "absolutiza",
    "absolutizarăți": "absolutiza",
    "absolutizase": "absolutiza",
    "absolutizasem": "absolutiza",
    "absolutizaseră": "absolutiza",
    "absolutizaserăm": "absolutiza",
    "absolutizaserăți": "absolutiza",
    "absolutizaseși": "absolutiza",
    "absolutizași": "absolutiza",
    "absolutizat": "absolutiza",
    "absolutizați": "absolutiza",
    "absolutizatu": "absolutiza",
    "absolutizau": "absolutiza",
    "absolutizează": "absolutiza",
    "absolutizez": "absolutiza",
    "absolutizeze": "absolutiza",
    "absolutizezi": "absolutiza",
    "neabsolutizând": "absolutiza",
    "neabsolutizându": "absolutiza",
    "nemaiabsolutizând": "absolutiza",
    "nemaiabsolutizându": "absolutiza",
    "absolutizarea": "absolutizare",
    "absolutizări": "absolutizare",
    "absolutizării": "absolutizare",
    "absolutizările": "absolutizare",
    "absolutizata": "absolutizat",
    "absolutizată": "absolutizat",
    "absolutizate": "absolutizat",
    "absolutizatei": "absolutizat",
    "absolutizatele": "absolutizat",
    "absolutizatelor": "absolutizat",
    "absolutizați": "absolutizat",
    "absolutizații": "absolutizat",
    "absolutizaților": "absolutizat",
    "absolutizatul": "absolutizat",
    "absolutizatului": "absolutizat",
    "absolvenți": "absolvent",
    "absolvenții": "absolvent",
    "absolvenților": "absolvent",
    "absolventul": "absolvent",
    "absolventului": "absolvent",
    "absolventa": "absolventă",
    "absolvente": "absolventă",
    "absolventei": "absolventă",
    "absolventele": "absolventă",
    "absolventelor": "absolventă",
    "absolv": "absolvi",
    "absolvă": "absolvi",
    "absolve": "absolvi",
    "absolvea": "absolvi",
    "absolveai": "absolvi",
    "absolveam": "absolvi",
    "absolveați": "absolvi",
    "absolveau": "absolvi",
    "absolvii": "absolvi",
    "absolvim": "absolvi",
    "absolvind": "absolvi",
    "absolvindu": "absolvi",
    "absolviră": "absolvi",
    "absolvirăm": "absolvi",
    "absolvirăți": "absolvi",
    "absolvise": "absolvi",
    "absolvisem": "absolvi",
    "absolviseră": "absolvi",
    "absolviserăm": "absolvi",
    "absolviserăți": "absolvi",
    "absolviseși": "absolvi",
    "absolviși": "absolvi",
    "absolvit": "absolvi",
    "absolviți": "absolvi",
    "absolvitu": "absolvi",
    "neabsolvind": "absolvi",
    "neabsolvindu": "absolvi",
    "nemaiabsolvind": "absolvi",
    "nemaiabsolvindu": "absolvi",
    "absolvirea": "absolvire",
    "absolviri": "absolvire",
    "absolvirii": "absolvire",
    "absolvirile": "absolvire",
    "absolvita": "absolvit",
    "absolvită": "absolvit",
    "absolvite": "absolvit",
    "absolvitei": "absolvit",
    "absolvitele": "absolvit",
    "absolvitelor": "absolvit",
    "absolviți": "absolvit",
    "absolviții": "absolvit",
    "absolviților": "absolvit",
    "absolvitul": "absolvit",
    "absolvitului": "absolvit",
    "absorbanta": "absorbant",
    "absorbantă": "absorbant",
    "absorbante": "absorbant",
    "absorbantei": "absorbant",
    "absorbantele": "absorbant",
    "absorbantelor": "absorbant",
    "absorbanți": "absorbant",
    "absorbanții": "absorbant",
    "absorbanților": "absorbant",
    "absorbantul": "absorbant",
    "absorbantului": "absorbant",
    "absoarbă": "absorbi",
    "absoarbe": "absorbi",
    "absorb": "absorbi",
    "absorbea": "absorbi",
    "absorbeai": "absorbi",
    "absorbeam": "absorbi",
    "absorbeați": "absorbi",
    "absorbeau": "absorbi",
    "absorbii": "absorbi",
    "absorbim": "absorbi",
    "absorbind": "absorbi",
    "absorbindu": "absorbi",
    "absorbiră": "absorbi",
    "absorbirăm": "absorbi",
    "absorbirăți": "absorbi",
    "absorbise": "absorbi",
    "absorbisem": "absorbi",
    "absorbiseră": "absorbi",
    "absorbiserăm": "absorbi",
    "absorbiserăți": "absorbi",
    "absorbiseși": "absorbi",
    "absorbiși": "absorbi",
    "absorbit": "absorbi",
    "absorbiți": "absorbi",
    "absorbitu": "absorbi",
    "neabsorbind": "absorbi",
    "neabsorbindu": "absorbi",
    "nemaiabsorbind": "absorbi",
    "nemaiabsorbindu": "absorbi",
    "absorbirea": "absorbire",
    "absorbiri": "absorbire",
    "absorbirii": "absorbire",
    "absorbirile": "absorbire",
    "absorbita": "absorbit",
    "absorbită": "absorbit",
    "absorbite": "absorbit",
    "absorbitei": "absorbit",
    "absorbitele": "absorbit",
    "absorbitelor": "absorbit",
    "absorbiți": "absorbit",
    "absorbiții": "absorbit",
    "absorbiților": "absorbit",
    "absorbitul": "absorbit",
    "absorbitului": "absorbit",
    "absorbitoare": "absorbitor",
    "absorbitoarea": "absorbitor",
    "absorbitoarei": "absorbitor",
    "absorbitoarele": "absorbitor",
    "absorbitoarelor": "absorbitor",
    "absorbitori": "absorbitor",
    "absorbitorii": "absorbitor",
    "absorbitorilor": "absorbitor",
    "absorbitorul": "absorbitor",
    "absorbitorului": "absorbitor",
    "absorbția": "absorbție",
    "absorbției": "absorbție",
    "absorbții": "absorbție",
    "absorbțiile": "absorbție",
    "absorbțiilor": "absorbție",
    "abstinenta": "abstinent",
    "abstinentă": "abstinent",
    "abstinente": "abstinent",
    "abstinentei": "abstinent",
    "abstinentele": "abstinent",
    "abstinentelor": "abstinent",
    "abstinenți": "abstinent",
    "abstinenții": "abstinent",
    "abstinenților": "abstinent",
    "abstinentul": "abstinent",
    "abstinentului": "abstinent",
    "abstinenta": "abstinentă",
    "abstinente": "abstinentă",
    "abstinentei": "abstinentă",
    "abstinentele": "abstinentă",
    "abstinentelor": "abstinentă",
    "abstinența": "abstinență",
    "abstinențe": "abstinență",
    "abstinenței": "abstinență",
    "abstinențele": "abstinență",
    "abstinențelor": "abstinență",
    "abstracta": "abstract",
    "abstractă": "abstract",
    "abstracte": "abstract",
    "abstractei": "abstract",
    "abstractele": "abstract",
    "abstractelor": "abstract",
    "abstracți": "abstract",
    "abstracții": "abstract",
    "abstracților": "abstract",
    "abstractul": "abstract",
    "abstractului": "abstract",
    "abstracția": "abstracție",
    "abstracției": "abstracție",
    "abstracții": "abstracție",
    "abstracțiile": "abstracție",
    "abstracțiilor": "abstracție",
    "abstracționista": "abstracționist",
    "abstracționistă": "abstracționist",
    "abstracționiste": "abstracționist",
    "abstracționistei": "abstracționist",
    "abstracționistele": "abstracționist",
    "abstracționistelor": "abstracționist",
    "abstracționiști": "abstracționist",
    "abstracționiștii": "abstracționist",
    "abstracționiștilor": "abstracționist",
    "abstracționistul": "abstracționist",
    "abstracționistului": "abstracționist",
    "abstracționista": "abstracționistă",
    "abstracționiste": "abstracționistă",
    "abstracționistei": "abstracționistă",
    "abstracționistele": "abstracționistă",
    "abstracționistelor": "abstracționistă",
    "abstractiză": "abstractiza",
    "abstractizai": "abstractiza",
    "abstractizam": "abstractiza",
    "abstractizăm": "abstractiza",
    "abstractizând": "abstractiza",
    "abstractizându": "abstractiza",
    "abstractizară": "abstractiza",
    "abstractizarăm": "abstractiza",
    "abstractizarăți": "abstractiza",
    "abstractizase": "abstractiza",
    "abstractizasem": "abstractiza",
    "abstractizaseră": "abstractiza",
    "abstractizaserăm": "abstractiza",
    "abstractizaserăți": "abstractiza",
    "abstractizaseși": "abstractiza",
    "abstractizași": "abstractiza",
    "abstractizat": "abstractiza",
    "abstractizați": "abstractiza",
    "abstractizatu": "abstractiza",
    "abstractizau": "abstractiza",
    "abstractizează": "abstractiza",
    "abstractizez": "abstractiza",
    "abstractizeze": "abstractiza",
    "abstractizezi": "abstractiza",
    "neabstractizând": "abstractiza",
    "neabstractizându": "abstractiza",
    "nemaiabstractizând": "abstractiza",
    "nemaiabstractizându": "abstractiza",
    "abstractizarea": "abstractizare",
    "abstractizări": "abstractizare",
    "abstractizării": "abstractizare",
    "abstractizările": "abstractizare",
    "abstractizata": "abstractizat",
    "abstractizată": "abstractizat",
    "abstractizate": "abstractizat",
    "abstractizatei": "abstractizat",
    "abstractizatele": "abstractizat",
    "abstractizatelor": "abstractizat",
    "abstractizați": "abstractizat",
    "abstractizații": "abstractizat",
    "abstractizaților": "abstractizat",
    "abstractizatul": "abstractizat",
    "abstractizatului": "abstractizat",
    "abstrag": "abstrage",
    "abstragă": "abstrage",
    "abstrăgând": "abstrage",
    "abstrăgându": "abstrage",
    "abstrăgea": "abstrage",
    "abstrăgeai": "abstrage",
    "abstrăgeam": "abstrage",
    "abstrăgeați": "abstrage",
    "abstrăgeau": "abstrage",
    "abstragem": "abstrage",
    "abstrageți": "abstrage",
    "abstragi": "abstrage",
    "abstras": "abstrage",
    "abstrase": "abstrage",
    "abstrăsei": "abstrage",
    "abstraseră": "abstrage",
    "abstraserăm": "abstrage",
    "abstraserăți": "abstrage",
    "abstrăsese": "abstrage",
    "abstrăsesem": "abstrage",
    "abstrăseseră": "abstrage",
    "abstrăseserăm": "abstrage",
    "abstrăseserăți": "abstrage",
    "abstrăseseși": "abstrage",
    "abstrăseși": "abstrage",
    "abstrasu": "abstrage",
    "neabstrăgând": "abstrage",
    "neabstrăgându": "abstrage",
    "nemaiabstrăgând": "abstrage",
    "nemaiabstrăgându": "abstrage",
    "abstragerea": "abstragere",
    "abstrageri": "abstragere",
    "abstragerii": "abstragere",
    "abstragerile": "abstragere",
    "abstrasa": "abstras",
    "abstrasă": "abstras",
    "abstrase": "abstras",
    "abstrasei": "abstras",
    "abstrasele": "abstras",
    "abstraselor": "abstras",
    "abstrași": "abstras",
    "abstrașii": "abstras",
    "abstrașilor": "abstras",
    "abstrasul": "abstras",
    "abstrasului": "abstras",
    "absurda": "absurd",
    "absurdă": "absurd",
    "absurde": "absurd",
    "absurdei": "absurd",
    "absurdele": "absurd",
    "absurdelor": "absurd",
    "absurdul": "absurd",
    "absurdului": "absurd",
    "absurzi": "absurd",
    "absurzii": "absurd",
    "absurzilor": "absurd",
    "absurditatea": "absurditate",
    "absurdități": "absurditate",
    "absurdității": "absurditate",
    "absurditățile": "absurditate",
    "absurdităților": "absurditate",
    "abții": "abține",
    "abțin": "abține",
    "abțină": "abține",
    "abținând": "abține",
    "abținându": "abține",
    "abținea": "abține",
    "abțineai": "abține",
    "abțineam": "abține",
    "abțineați": "abține",
    "abțineau": "abține",
    "abținem": "abține",
    "abțineți": "abține",
    "abținu": "abține",
    "abținui": "abține",
    "abținură": "abține",
    "abținurăm": "abține",
    "abținurăți": "abține",
    "abținuse": "abține",
    "abținusem": "abține",
    "abținuseră": "abține",
    "abținuserăm": "abține",
    "abținuserăți": "abține",
    "abținuseși": "abține",
    "abținuși": "abține",
    "abținut": "abține",
    "abținutu": "abține",
    "neabținând": "abține",
    "neabținându": "abține",
    "nemaiabținând": "abține",
    "nemaiabținându": "abține",
    "abținerea": "abținere",
    "abțineri": "abținere",
    "abținerii": "abținere",
    "abținerile": "abținere",
    "abținuta": "abținut",
    "abținută": "abținut",
    "abținute": "abținut",
    "abținutei": "abținut",
    "abținutele": "abținut",
    "abținutelor": "abținut",
    "abținuți": "abținut",
    "abținuții": "abținut",
    "abținuților": "abținut",
    "abținutul": "abținut",
    "abținutului": "abținut",
    "abulica": "abulic",
    "abulică": "abulic",
    "abulice": "abulic",
    "abulicei": "abulic",
    "abulicele": "abulic",
    "abulicelor": "abulic",
    "abulici": "abulic",
    "abulicii": "abulic",
    "abulicilor": "abulic",
    "abulicul": "abulic",
    "abulicului": "abulic",
    "abund": "abunda",
    "abundă": "abunda",
    "abundai": "abunda",
    "abundam": "abunda",
    "abundăm": "abunda",
    "abundând": "abunda",
    "abundându": "abunda",
    "abundară": "abunda",
    "abundarăm": "abunda",
    "abundarăți": "abunda",
    "abundase": "abunda",
    "abundasem": "abunda",
    "abundaseră": "abunda",
    "abundaserăm": "abunda",
    "abundaserăți": "abunda",
    "abundaseși": "abunda",
    "abundași": "abunda",
    "abundat": "abunda",
    "abundați": "abunda",
    "abundatu": "abunda",
    "abundau": "abunda",
    "abunde": "abunda",
    "abunzi": "abunda",
    "neabundând": "abunda",
    "neabundându": "abunda",
    "nemaiabundând": "abunda",
    "nemaiabundându": "abunda",
    "abundată": "abundat",
    "abundate": "abundat",
    "abundați": "abundat",
    "abundenta": "abundent",
    "abundentă": "abundent",
    "abundente": "abundent",
    "abundentei": "abundent",
    "abundentele": "abundent",
    "abundentelor": "abundent",
    "abundenți": "abundent",
    "abundenții": "abundent",
    "abundenților": "abundent",
    "abundentul": "abundent",
    "abundentului": "abundent",
    "abundența": "abundență",
    "abundențe": "abundență",
    "abundenței": "abundență",
    "abundențele": "abundență",
    "aburi": "abur",
    "aburii": "abur",
    "aburilor": "abur",
    "aburul": "abur",
    "aburului": "abur",
    "aburcata": "aburcat",
    "aburcată": "aburcat",
    "aburcate": "aburcat",
    "aburcatei": "aburcat",
    "aburcatele": "aburcat",
    "aburcatelor": "aburcat",
    "aburcați": "aburcat",
    "aburcații": "aburcat",
    "aburcaților": "aburcat",
    "aburcatul": "aburcat",
    "aburcatului": "aburcat",
    "aburea": "aburi",
    "abureai": "aburi",
    "abuream": "aburi",
    "aburească": "aburi",
    "abureați": "aburi",
    "abureau": "aburi",
    "aburesc": "aburi",
    "aburește": "aburi",
    "aburești": "aburi",
    "aburii": "aburi",
    "aburim": "aburi",
    "aburind": "aburi",
    "aburindu": "aburi",
    "aburiră": "aburi",
    "aburirăm": "aburi",
    "aburirăți": "aburi",
    "aburise": "aburi",
    "aburisem": "aburi",
    "aburiseră": "aburi",
    "aburiserăm": "aburi",
    "aburiserăți": "aburi",
    "aburiseși": "aburi",
    "aburiși": "aburi",
    "aburit": "aburi",
    "aburiți": "aburi",
    "aburitu": "aburi",
    "aburinda": "aburind",
    "aburindă": "aburind",
    "aburinde": "aburind",
    "aburindei": "aburind",
    "aburindele": "aburind",
    "aburindelor": "aburind",
    "aburindul": "aburind",
    "aburindului": "aburind",
    "aburinzi": "aburind",
    "aburinzii": "aburind",
    "aburinzilor": "aburind",
    "aburită": "aburit",
    "aburite": "aburit",
    "aburiți": "aburit",
    "abuzul": "abuz",
    "abuzului": "abuz",
    "abuzuri": "abuz",
    "abuzurile": "abuz",
    "abuzurilor": "abuz",
    "abuză": "abuza",
    "abuzai": "abuza",
    "abuzam": "abuza",
    "abuzăm": "abuza",
    "abuzând": "abuza",
    "abuzându": "abuza",
    "abuzară": "abuza",
    "abuzarăm": "abuza",
    "abuzarăți": "abuza",
    "abuzase": "abuza",
    "abuzasem": "abuza",
    "abuzaseră": "abuza",
    "abuzaserăm": "abuza",
    "abuzaserăți": "abuza",
    "abuzaseși": "abuza",
    "abuzași": "abuza",
    "abuzat": "abuza",
    "abuzați": "abuza",
    "abuzatu": "abuza",
    "abuzau": "abuza",
    "abuzează": "abuza",
    "abuzez": "abuza",
    "abuzeze": "abuza",
    "abuzezi": "abuza",
    "neabuzând": "abuza",
    "neabuzându": "abuza",
    "nemaiabuzând": "abuza",
    "nemaiabuzându": "abuza",
    "abuzarea": "abuzare",
    "abuzări": "abuzare",
    "abuzării": "abuzare",
    "abuzările": "abuzare",
    "abuzată": "abuzat",
    "abuzate": "abuzat",
    "abuzați": "abuzat",
    "abuziva": "abuziv",
    "abuzivă": "abuziv",
    "abuzive": "abuziv",
    "abuzivei": "abuziv",
    "abuzivele": "abuziv",
    "abuzivelor": "abuziv",
    "abuzivi": "abuziv",
    "abuzivii": "abuziv",
    "abuzivilor": "abuziv",
    "abuzivul": "abuziv",
    "abuzivului": "abuziv",
    "ace": "ac",
    "acele": "ac",
    "acelor": "ac",
    "acul": "ac",
    "acului": "ac",
    "acadeaua": "acadea",
    "acadele": "acadea",
    "acadelei": "acadea",
    "acadelele": "acadea",
    "acadelelor": "acadea",
    "Academiei_Române": "Academia_Română",
    "academica": "academic",
    "academică": "academic",
    "academice": "academic",
    "academicei": "academic",
    "academicele": "academic",
    "academicelor": "academic",
    "academici": "academic",
    "academicii": "academic",
    "academicilor": "academic",
    "academicul": "academic",
    "academicului": "academic",
    "acad.": "academician",
    "academicianul": "academician",
    "academicianului": "academician",
    "academicieni": "academician",
    "academicienii": "academician",
    "academicienilor": "academician",
    "academiciana": "academiciană",
    "academiciene": "academiciană",
    "academicienei": "academiciană",
    "academicienele": "academiciană",
    "academicienelor": "academiciană",
    "academia": "academie",
    "academiei": "academie",
    "academii": "academie",
    "academiile": "academie",
    "academiilor": "academie",
    "acalmia": "acalmie",
    "acalmiei": "acalmie",
    "acalmii": "acalmie",
    "acalmiile": "acalmie",
    "acalmiilor": "acalmie",
    "acapară": "acapara",
    "acaparai": "acapara",
    "acaparam": "acapara",
    "acaparăm": "acapara",
    "acaparând": "acapara",
    "acaparându": "acapara",
    "acaparară": "acapara",
    "acapararăm": "acapara",
    "acapararăți": "acapara",
    "acaparase": "acapara",
    "acaparasem": "acapara",
    "acaparaseră": "acapara",
    "acaparaserăm": "acapara",
    "acaparaserăți": "acapara",
    "acaparaseși": "acapara",
    "acaparași": "acapara",
    "acaparat": "acapara",
    "acaparați": "acapara",
    "acaparatu": "acapara",
    "acaparau": "acapara",
    "acaparează": "acapara",
    "acaparez": "acapara",
    "acapareze": "acapara",
    "acaparezi": "acapara",
    "neacaparând": "acapara",
    "neacaparându": "acapara",
    "nemaiacaparând": "acapara",
    "nemaiacaparându": "acapara",
    "acapararea": "acaparare",
    "acaparări": "acaparare",
    "acaparării": "acaparare",
    "acaparările": "acaparare",
    "acaparata": "acaparat",
    "acaparată": "acaparat",
    "acaparate": "acaparat",
    "acaparatei": "acaparat",
    "acaparatele": "acaparat",
    "acaparatelor": "acaparat",
    "acaparați": "acaparat",
    "acaparații": "acaparat",
    "acaparaților": "acaparat",
    "acaparatul": "acaparat",
    "acaparatului": "acaparat",
    "acaparatoarea": "acaparatoare",
    "acaparatoarei": "acaparatoare",
    "acaparatoarele": "acaparatoare",
    "acaparatoarelor": "acaparatoare",
    "acaparatoare": "acaparator",
    "acaparatoarea": "acaparator",
    "acaparatoarei": "acaparator",
    "acaparatoarele": "acaparator",
    "acaparatoarelor": "acaparator",
    "acaparatori": "acaparator",
    "acaparatorii": "acaparator",
    "acaparatorilor": "acaparator",
    "acaparatorul": "acaparator",
    "acaparatorului": "acaparator",
    "acari": "acar",
    "acarii": "acar",
    "acarilor": "acar",
    "acarul": "acar",
    "acarului": "acar",
    "acaretul": "acaret",
    "acaretului": "acaret",
    "acareturi": "acaret",
    "acareturile": "acaret",
    "acareturilor": "acaret",
    "acas'": "acasă",
    "acatiste": "acatist",
    "acatistele": "acatist",
    "acatistelor": "acatist",
    "acatistul": "acatist",
    "acatistului": "acatist",
    "neaccedând": "acceda",
    "neaccedându": "acceda",
    "nemaiaccedând": "acceda",
    "nemaiaccedându": "acceda",
    "accedată": "accedat",
    "accedate": "accedat",
    "accedați": "accedat",
    "acceadă": "accede",
    "acced": "accede",
    "accedă": "accede",
    "accedai": "accede",
    "accedând": "accede",
    "accedându": "accede",
    "accedară": "accede",
    "accedarăm": "accede",
    "accedarăți": "accede",
    "accedase": "accede",
    "accedasem": "accede",
    "accedaseră": "accede",
    "accedaserăm": "accede",
    "accedaserăți": "accede",
    "accedaseși": "accede",
    "accedași": "accede",
    "accedat": "accede",
    "accedatu": "accede",
    "accedea": "accede",
    "accedeai": "accede",
    "accedeam": "accede",
    "accedeați": "accede",
    "accedeau": "accede",
    "accedem": "accede",
    "accedeți": "accede",
    "accezi": "accede",
    "acceleră": "accelera",
    "accelerai": "accelera",
    "acceleram": "accelera",
    "accelerăm": "accelera",
    "accelerând": "accelera",
    "accelerându": "accelera",
    "accelerară": "accelera",
    "accelerarăm": "accelera",
    "accelerarăți": "accelera",
    "accelerase": "accelera",
    "accelerasem": "accelera",
    "acceleraseră": "accelera",
    "acceleraserăm": "accelera",
    "acceleraserăți": "accelera",
    "acceleraseși": "accelera",
    "accelerași": "accelera",
    "accelerat": "accelera",
    "accelerați": "accelera",
    "acceleratu": "accelera",
    "accelerau": "accelera",
    "accelerează": "accelera",
    "accelerez": "accelera",
    "accelereze": "accelera",
    "accelerezi": "accelera",
    "neaccelerând": "accelera",
    "neaccelerându": "accelera",
    "nemaiaccelerând": "accelera",
    "nemaiaccelerându": "accelera",
    "accelerarea": "accelerare",
    "accelerări": "accelerare",
    "accelerării": "accelerare",
    "accelerările": "accelerare",
    "accelerata": "accelerat",
    "accelerată": "accelerat",
    "accelerate": "accelerat",
    "acceleratei": "accelerat",
    "acceleratele": "accelerat",
    "acceleratelor": "accelerat",
    "accelerați": "accelerat",
    "accelerații": "accelerat",
    "acceleraților": "accelerat",
    "acceleratul": "accelerat",
    "acceleratului": "accelerat",
    "acceleratoare": "accelerator",
    "acceleratoarea": "accelerator",
    "acceleratoarei": "accelerator",
    "acceleratoarele": "accelerator",
    "acceleratoarelor": "accelerator",
    "acceleratori": "accelerator",
    "acceleratorii": "accelerator",
    "acceleratorilor": "accelerator",
    "acceleratorul": "accelerator",
    "acceleratorului": "accelerator",
    "accente": "accent",
    "accentele": "accent",
    "accentelor": "accent",
    "accentul": "accent",
    "accentului": "accent",
    "accentuă": "accentua",
    "accentuai": "accentua",
    "accentuam": "accentua",
    "accentuăm": "accentua",
    "accentuând": "accentua",
    "accentuându": "accentua",
    "accentuară": "accentua",
    "accentuarăm": "accentua",
    "accentuarăți": "accentua",
    "accentuase": "accentua",
    "accentuasem": "accentua",
    "accentuaseră": "accentua",
    "accentuaserăm": "accentua",
    "accentuaserăți": "accentua",
    "accentuaseși": "accentua",
    "accentuași": "accentua",
    "accentuat": "accentua",
    "accentuați": "accentua",
    "accentuatu": "accentua",
    "accentuau": "accentua",
    "accentuează": "accentua",
    "accentuez": "accentua",
    "accentueze": "accentua",
    "accentuezi": "accentua",
    "neaccentuând": "accentua",
    "neaccentuându": "accentua",
    "nemaiaccentuând": "accentua",
    "nemaiaccentuându": "accentua",
    "accentuarea": "accentuare",
    "accentuări": "accentuare",
    "accentuării": "accentuare",
    "accentuările": "accentuare",
    "acc.": "accentuat",
    "accentuata": "accentuat",
    "accentuată": "accentuat",
    "accentuate": "accentuat",
    "accentuatei": "accentuat",
    "accentuatele": "accentuat",
    "accentuatelor": "accentuat",
    "accentuați": "accentuat",
    "accentuații": "accentuat",
    "accentuaților": "accentuat",
    "accentuatul": "accentuat",
    "accentuatului": "accentuat",
    "accept": "accepta",
    "acceptă": "accepta",
    "acceptai": "accepta",
    "acceptam": "accepta",
    "acceptăm": "accepta",
    "acceptând": "accepta",
    "acceptându": "accepta",
    "acceptară": "accepta",
    "acceptarăm": "accepta",
    "acceptarăți": "accepta",
    "acceptase": "accepta",
    "acceptasem": "accepta",
    "acceptaseră": "accepta",
    "acceptaserăm": "accepta",
    "acceptaserăți": "accepta",
    "acceptaseși": "accepta",
    "acceptași": "accepta",
    "acceptat": "accepta",
    "acceptați": "accepta",
    "acceptatu": "accepta",
    "acceptau": "accepta",
    "accepte": "accepta",
    "accepți": "accepta",
    "neacceptând": "accepta",
    "neacceptându": "accepta",
    "nemaiacceptând": "accepta",
    "nemaiacceptându": "accepta",
    "acceptabilă": "acceptabil",
    "acceptabile": "acceptabil",
    "acceptabili": "acceptabil",
    "acceptarea": "acceptare",
    "acceptări": "acceptare",
    "acceptării": "acceptare",
    "acceptările": "acceptare",
    "acceptata": "acceptat",
    "acceptată": "acceptat",
    "acceptate": "acceptat",
    "acceptatei": "acceptat",
    "acceptatele": "acceptat",
    "acceptatelor": "acceptat",
    "acceptați": "acceptat",
    "acceptații": "acceptat",
    "acceptaților": "acceptat",
    "acceptatul": "acceptat",
    "acceptatului": "acceptat",
    "accepția": "accepție",
    "accepției": "accepție",
    "accepții": "accepție",
    "accepțiile": "accepție",
    "accepțiilor": "accepție",
    "accepțiunea": "accepțiune",
    "accepțiuni": "accepțiune",
    "accepțiunii": "accepțiune",
    "accepțiunile": "accepțiune",
    "accepțiunilor": "accepțiune",
    "accese": "acces",
    "accesele": "acces",
    "acceselor": "acces",
    "accesul": "acces",
    "accesului": "acces",
    "accesibila": "accesibil",
    "accesibilă": "accesibil",
    "accesibile": "accesibil",
    "accesibilei": "accesibil",
    "accesibilele": "accesibil",
    "accesibilelor": "accesibil",
    "accesibili": "accesibil",
    "accesibilii": "accesibil",
    "accesibililor": "accesibil",
    "accesibilul": "accesibil",
    "accesibilului": "accesibil",
    "accesorii": "accesoriu",
    "accesoriile": "accesoriu",
    "accesoriilor": "accesoriu",
    "accesoriul": "accesoriu",
    "accesoriului": "accesoriu",
    "accidente": "accident",
    "accidentele": "accident",
    "accidentelor": "accident",
    "accidentul": "accident",
    "accidentului": "accident",
    "accidentă": "accidenta",
    "accidentai": "accidenta",
    "accidentam": "accidenta",
    "accidentăm": "accidenta",
    "accidentând": "accidenta",
    "accidentându": "accidenta",
    "accidentară": "accidenta",
    "accidentarăm": "accidenta",
    "accidentarăți": "accidenta",
    "accidentase": "accidenta",
    "accidentasem": "accidenta",
    "accidentaseră": "accidenta",
    "accidentaserăm": "accidenta",
    "accidentaserăți": "accidenta",
    "accidentaseși": "accidenta",
    "accidentași": "accidenta",
    "accidentat": "accidenta",
    "accidentați": "accidenta",
    "accidentatu": "accidenta",
    "accidentau": "accidenta",
    "accidentează": "accidenta",
    "accidentez": "accidenta",
    "accidenteze": "accidenta",
    "accidentezi": "accidenta",
    "neaccidentând": "accidenta",
    "neaccidentându": "accidenta",
    "nemaiaccidentând": "accidenta",
    "nemaiaccidentându": "accidenta",
    "accidentala": "accidental",
    "accidentală": "accidental",
    "accidentale": "accidental",
    "accidentalei": "accidental",
    "accidentalele": "accidental",
    "accidentalelor": "accidental",
    "accidentali": "accidental",
    "accidentalii": "accidental",
    "accidentalilor": "accidental",
    "accidentalul": "accidental",
    "accidentalului": "accidental",
    "accidentarea": "accidentare",
    "accidentări": "accidentare",
    "accidentării": "accidentare",
    "accidentările": "accidentare",
    "accidentata": "accidentat",
    "accidentată": "accidentat",
    "accidentate": "accidentat",
    "accidentatei": "accidentat",
    "accidentatele": "accidentat",
    "accidentatelor": "accidentat",
    "accidentați": "accidentat",
    "accidentații": "accidentat",
    "accidentaților": "accidentat",
    "accidentatul": "accidentat",
    "accidentatului": "accidentat",
    "accidentata": "accidentată",
    "accidentate": "accidentată",
    "accidentatei": "accidentată",
    "accidentatele": "accidentată",
    "accidentatelor": "accidentată",
    "acciza": "acciză",
    "accize": "acciză",
    "accizei": "acciză",
    "accizele": "acciză",
    "accizelor": "acciză",
    "ace-de-mare": "ac-de-mare",
    "acele-de-mare": "ac-de-mare",
    "acelor-de-mare": "ac-de-mare",
    "acul-de-mare": "ac-de-mare",
    "acului-de-mare": "ac-de-mare",
    "acefala": "acefal",
    "acefală": "acefal",
    "acefale": "acefal",
    "acefalei": "acefal",
    "acefalele": "acefal",
    "acefalelor": "acefal",
    "acefali": "acefal",
    "acefalii": "acefal",
    "acefalilor": "acefal",
    "acefalul": "acefal",
    "acefalului": "acefal",
    "acea": "acel",
    "acei": "acel",
    "acele": "acel",
    "acelei": "acel",
    "acelor": "acel",
    "acelui": "acel",
    "aceea": "acela",
    "aceia": "acela",
    "acelea": "acela",
    "aceleia": "acela",
    "acelora": "acela",
    "aceluia": "acela",
    "aceeași": "același",
    "aceiași": "același",
    "aceleași": "același",
    "aceleiași": "același",
    "acelorași": "același",
    "aceluiași": "același",
    "acerba": "acerb",
    "acerbă": "acerb",
    "acerbe": "acerb",
    "acerbei": "acerb",
    "acerbele": "acerb",
    "acerbelor": "acerb",
    "acerbi": "acerb",
    "acerbii": "acerb",
    "acerbilor": "acerb",
    "acerbul": "acerb",
    "acerbului": "acerb",
    "această": "acest",
    "aceste": "acest",
    "acestei": "acest",
    "acești": "acest",
    "acestor": "acest",
    "acestui": "acest",
    "aceasta": "acesta",
    "acestea": "acesta",
    "acesteia": "acesta",
    "aceștia": "acesta",
    "acestora": "acesta",
    "acestuia": "acesta",
    "acetica": "acetic",
    "acetică": "acetic",
    "acetice": "acetic",
    "aceticei": "acetic",
    "aceticele": "acetic",
    "aceticelor": "acetic",
    "acetici": "acetic",
    "aceticii": "acetic",
    "aceticilor": "acetic",
    "aceticul": "acetic",
    "aceticului": "acetic",
    "achit": "achita",
    "achită": "achita",
    "achitai": "achita",
    "achitam": "achita",
    "achităm": "achita",
    "achitând": "achita",
    "achitându": "achita",
    "achitară": "achita",
    "achitarăm": "achita",
    "achitarăți": "achita",
    "achitase": "achita",
    "achitasem": "achita",
    "achitaseră": "achita",
    "achitaserăm": "achita",
    "achitaserăți": "achita",
    "achitaseși": "achita",
    "achitași": "achita",
    "achitat": "achita",
    "achitați": "achita",
    "achitatu": "achita",
    "achitau": "achita",
    "achite": "achita",
    "achiți": "achita",
    "neachitând": "achita",
    "neachitându": "achita",
    "nemaiachitând": "achita",
    "nemaiachitându": "achita",
    "achitabilă": "achitabil",
    "achitabile": "achitabil",
    "achitabili": "achitabil",
    "achitarea": "achitare",
    "achitări": "achitare",
    "achitării": "achitare",
    "achitările": "achitare",
    "achitata": "achitat",
    "achitată": "achitat",
    "achitate": "achitat",
    "achitatei": "achitat",
    "achitatele": "achitat",
    "achitatelor": "achitat",
    "achitați": "achitat",
    "achitații": "achitat",
    "achitaților": "achitat",
    "achitatul": "achitat",
    "achitatului": "achitat",
    "achiziția": "achiziție",
    "achiziției": "achiziție",
    "achiziții": "achiziție",
    "achizițiile": "achiziție",
    "achizițiilor": "achiziție",
    "achiziționă": "achiziționa",
    "achiziționai": "achiziționa",
    "achiziționam": "achiziționa",
    "achiziționăm": "achiziționa",
    "achiziționând": "achiziționa",
    "achiziționându": "achiziționa",
    "achiziționară": "achiziționa",
    "achiziționarăm": "achiziționa",
    "achiziționarăți": "achiziționa",
    "achiziționase": "achiziționa",
    "achiziționasem": "achiziționa",
    "achiziționaseră": "achiziționa",
    "achiziționaserăm": "achiziționa",
    "achiziționaserăți": "achiziționa",
    "achiziționaseși": "achiziționa",
    "achiziționași": "achiziționa",
    "achiziționat": "achiziționa",
    "achiziționați": "achiziționa",
    "achiziționatu": "achiziționa",
    "achiziționau": "achiziționa",
    "achiziționează": "achiziționa",
    "achiziționez": "achiziționa",
    "achiziționeze": "achiziționa",
    "achiziționezi": "achiziționa",
    "neachiziționând": "achiziționa",
    "neachiziționându": "achiziționa",
    "nemaiachiziționând": "achiziționa",
    "nemaiachiziționându": "achiziționa",
    "achiziționarea": "achiziționare",
    "achiziționări": "achiziționare",
    "achiziționării": "achiziționare",
    "achiziționările": "achiziționare",
    "achiziționata": "achiziționat",
    "achiziționată": "achiziționat",
    "achiziționate": "achiziționat",
    "achiziționatei": "achiziționat",
    "achiziționatele": "achiziționat",
    "achiziționatelor": "achiziționat",
    "achiziționați": "achiziționat",
    "achiziționații": "achiziționat",
    "achiziționaților": "achiziționat",
    "achiziționatul": "achiziționat",
    "achiziționatului": "achiziționat",
    "achizitoarea": "achizitoare",
    "achizitoarei": "achizitoare",
    "achizitoarele": "achizitoare",
    "achizitoarelor": "achizitoare",
    "achizitori": "achizitor",
    "achizitorii": "achizitor",
    "achizitorilor": "achizitor",
    "achizitorul": "achizitor",
    "achizitorului": "achizitor",
    "aciclica": "aciclic",
    "aciclică": "aciclic",
    "aciclice": "aciclic",
    "aciclicei": "aciclic",
    "aciclicele": "aciclic",
    "aciclicelor": "aciclic",
    "aciclici": "aciclic",
    "aciclicii": "aciclic",
    "aciclicilor": "aciclic",
    "aciclicul": "aciclic",
    "aciclicului": "aciclic",
    "aciculara": "acicular",
    "aciculară": "acicular",
    "aciculare": "acicular",
    "acicularei": "acicular",
    "acicularele": "acicular",
    "acicularelor": "acicular",
    "aciculari": "acicular",
    "acicularii": "acicular",
    "acicularilor": "acicular",
    "acicularul": "acicular",
    "acicularului": "acicular",
    "acida": "acid",
    "acidă": "acid",
    "acide": "acid",
    "acidei": "acid",
    "acidele": "acid",
    "acidelor": "acid",
    "acidul": "acid",
    "acidului": "acid",
    "acizi": "acid",
    "acizii": "acid",
    "acizilor": "acid",
    "acidulă": "acidula",
    "acidulai": "acidula",
    "acidulam": "acidula",
    "acidulăm": "acidula",
    "acidulând": "acidula",
    "acidulându": "acidula",
    "acidulară": "acidula",
    "acidularăm": "acidula",
    "acidularăți": "acidula",
    "acidulase": "acidula",
    "acidulasem": "acidula",
    "acidulaseră": "acidula",
    "acidulaserăm": "acidula",
    "acidulaserăți": "acidula",
    "acidulaseși": "acidula",
    "acidulași": "acidula",
    "acidulat": "acidula",
    "acidulați": "acidula",
    "acidulatu": "acidula",
    "acidulau": "acidula",
    "acidulează": "acidula",
    "acidulez": "acidula",
    "aciduleze": "acidula",
    "acidulezi": "acidula",
    "neacidulând": "acidula",
    "neacidulându": "acidula",
    "nemaiacidulând": "acidula",
    "nemaiacidulându": "acidula",
    "acidularea": "acidulare",
    "acidulări": "acidulare",
    "acidulării": "acidulare",
    "acidulările": "acidulare",
    "acidulata": "acidulat",
    "acidulată": "acidulat",
    "acidulate": "acidulat",
    "acidulatei": "acidulat",
    "acidulatele": "acidulat",
    "acidulatelor": "acidulat",
    "acidulați": "acidulat",
    "acidulații": "acidulat",
    "acidulaților": "acidulat",
    "acidulatul": "acidulat",
    "acidulatului": "acidulat",
    "aciuă": "aciua",
    "aciuai": "aciua",
    "aciuam": "aciua",
    "aciuăm": "aciua",
    "aciuând": "aciua",
    "aciuându": "aciua",
    "aciuară": "aciua",
    "aciuarăm": "aciua",
    "aciuarăți": "aciua",
    "aciuase": "aciua",
    "aciuasem": "aciua",
    "aciuaseră": "aciua",
    "aciuaserăm": "aciua",
    "aciuaserăți": "aciua",
    "aciuaseși": "aciua",
    "aciuași": "aciua",
    "aciuat": "aciua",
    "aciuați": "aciua",
    "aciuatu": "aciua",
    "aciuau": "aciua",
    "aciuează": "aciua",
    "aciuez": "aciua",
    "aciueze": "aciua",
    "aciuezi": "aciua",
    "neaciuând": "aciua",
    "neaciuându": "aciua",
    "nemaiaciuând": "aciua",
    "nemaiaciuându": "aciua",
    "aciuarea": "aciuare",
    "aciuări": "aciuare",
    "aciuării": "aciuare",
    "aciuările": "aciuare",
    "aciuata": "aciuat",
    "aciuată": "aciuat",
    "aciuate": "aciuat",
    "aciuatei": "aciuat",
    "aciuatele": "aciuat",
    "aciuatelor": "aciuat",
    "aciuați": "aciuat",
    "aciuații": "aciuat",
    "aciuaților": "aciuat",
    "aciuatul": "aciuat",
    "aciuatului": "aciuat",
    "aciuea": "aciui",
    "aciueai": "aciui",
    "aciueam": "aciui",
    "aciueați": "aciui",
    "aciueau": "aciui",
    "aciuează": "aciui",
    "aciuez": "aciui",
    "aciueze": "aciui",
    "aciuezi": "aciui",
    "aciuii": "aciui",
    "aciuim": "aciui",
    "aciuind": "aciui",
    "aciuindu": "aciui",
    "aciuiră": "aciui",
    "aciuirăm": "aciui",
    "aciuirăți": "aciui",
    "aciuise": "aciui",
    "aciuisem": "aciui",
    "aciuiseră": "aciui",
    "aciuiserăm": "aciui",
    "aciuiserăți": "aciui",
    "aciuiseși": "aciui",
    "aciuiși": "aciui",
    "aciuit": "aciui",
    "aciuiți": "aciui",
    "aciuitu": "aciui",
    "aciuirea": "aciuire",
    "aciuiri": "aciuire",
    "aciuirii": "aciuire",
    "aciuirile": "aciuire",
    "aciuita": "aciuit",
    "aciuită": "aciuit",
    "aciuite": "aciuit",
    "aciuitei": "aciuit",
    "aciuitele": "aciuit",
    "aciuitelor": "aciuit",
    "aciuiți": "aciuit",
    "aciuiții": "aciuit",
    "aciuiților": "aciuit",
    "aciuitul": "aciuit",
    "aciuitului": "aciuit",
    "aclamă": "aclama",
    "aclamai": "aclama",
    "aclamam": "aclama",
    "aclamăm": "aclama",
    "aclamând": "aclama",
    "aclamându": "aclama",
    "aclamară": "aclama",
    "aclamarăm": "aclama",
    "aclamarăți": "aclama",
    "aclamase": "aclama",
    "aclamasem": "aclama",
    "aclamaseră": "aclama",
    "aclamaserăm": "aclama",
    "aclamaserăți": "aclama",
    "aclamaseși": "aclama",
    "aclamași": "aclama",
    "aclamat": "aclama",
    "aclamați": "aclama",
    "aclamatu": "aclama",
    "aclamau": "aclama",
    "aclamează": "aclama",
    "aclamez": "aclama",
    "aclameze": "aclama",
    "aclamezi": "aclama",
    "neaclamând": "aclama",
    "neaclamându": "aclama",
    "nemaiaclamând": "aclama",
    "nemaiaclamându": "aclama",
    "aclamarea": "aclamare",
    "aclamări": "aclamare",
    "aclamării": "aclamare",
    "aclamările": "aclamare",
    "aclamata": "aclamat",
    "aclamată": "aclamat",
    "aclamate": "aclamat",
    "aclamatei": "aclamat",
    "aclamatele": "aclamat",
    "aclamatelor": "aclamat",
    "aclamați": "aclamat",
    "aclamații": "aclamat",
    "aclamaților": "aclamat",
    "aclamatul": "aclamat",
    "aclamatului": "aclamat",
    "aclimatiză": "aclimatiza",
    "aclimatizai": "aclimatiza",
    "aclimatizam": "aclimatiza",
    "aclimatizăm": "aclimatiza",
    "aclimatizând": "aclimatiza",
    "aclimatizându": "aclimatiza",
    "aclimatizară": "aclimatiza",
    "aclimatizarăm": "aclimatiza",
    "aclimatizarăți": "aclimatiza",
    "aclimatizase": "aclimatiza",
    "aclimatizasem": "aclimatiza",
    "aclimatizaseră": "aclimatiza",
    "aclimatizaserăm": "aclimatiza",
    "aclimatizaserăți": "aclimatiza",
    "aclimatizaseși": "aclimatiza",
    "aclimatizași": "aclimatiza",
    "aclimatizat": "aclimatiza",
    "aclimatizați": "aclimatiza",
    "aclimatizatu": "aclimatiza",
    "aclimatizau": "aclimatiza",
    "aclimatizează": "aclimatiza",
    "aclimatizez": "aclimatiza",
    "aclimatizeze": "aclimatiza",
    "aclimatizezi": "aclimatiza",
    "neaclimatizând": "aclimatiza",
    "neaclimatizându": "aclimatiza",
    "nemaiaclimatizând": "aclimatiza",
    "nemaiaclimatizându": "aclimatiza",
    "aclimatizarea": "aclimatizare",
    "aclimatizări": "aclimatizare",
    "aclimatizării": "aclimatizare",
    "aclimatizările": "aclimatizare",
    "aclimatizata": "aclimatizat",
    "aclimatizată": "aclimatizat",
    "aclimatizate": "aclimatizat",
    "aclimatizatei": "aclimatizat",
    "aclimatizatele": "aclimatizat",
    "aclimatizatelor": "aclimatizat",
    "aclimatizați": "aclimatizat",
    "aclimatizații": "aclimatizat",
    "aclimatizaților": "aclimatizat",
    "aclimatizatul": "aclimatizat",
    "aclimatizatului": "aclimatizat",
    "acneea": "acnee",
    "acneei": "acnee",
    "acneele": "acnee",
    "acneelor": "acnee",
    "acolada": "acoladă",
    "acolade": "acoladă",
    "acoladei": "acoladă",
    "acoladele": "acoladă",
    "acoladelor": "acoladă",
    "acoliți": "acolit",
    "acoliții": "acolit",
    "acoliților": "acolit",
    "acolitul": "acolit",
    "acolitului": "acolit",
    "acomodai": "acomoda",
    "acomodam": "acomoda",
    "acomodând": "acomoda",
    "acomodară": "acomoda",
    "acomodarăm": "acomoda",
    "acomodarăți": "acomoda",
    "acomodase": "acomoda",
    "acomodasem": "acomoda",
    "acomodaseră": "acomoda",
    "acomodaserăm": "acomoda",
    "acomodaserăți": "acomoda",
    "acomodaseși": "acomoda",
    "acomodași": "acomoda",
    "acomodat": "acomoda",
    "acomodați": "acomoda",
    "acomodatu": "acomoda",
    "acomodau": "acomoda",
    "acomodează": "acomoda",
    "acomodez": "acomoda",
    "acomodeze": "acomoda",
    "acomodezi": "acomoda",
    "neacomodând": "acomoda",
    "nemaiacomodând": "acomoda",
    "acomodabila": "acomodabil",
    "acomodabile": "acomodabil",
    "acomodabilei": "acomodabil",
    "acomodabilele": "acomodabil",
    "acomodabilelor": "acomodabil",
    "acomodabili": "acomodabil",
    "acomodabilii": "acomodabil",
    "acomodabililor": "acomodabil",
    "acomodabilul": "acomodabil",
    "acomodabilului": "acomodabil",
    "acomodarea": "acomodare",
    "acomodări": "acomodare",
    "acomodării": "acomodare",
    "acomodările": "acomodare",
    "acomodata": "acomodat",
    "acomodată": "acomodat",
    "acomodate": "acomodat",
    "acomodatei": "acomodat",
    "acomodatele": "acomodat",
    "acomodatelor": "acomodat",
    "acomodați": "acomodat",
    "acomodații": "acomodat",
    "acomodaților": "acomodat",
    "acomodatul": "acomodat",
    "acomodatului": "acomodat",
    "acompaniai": "acompania",
    "acompaniam": "acompania",
    "acompaniară": "acompania",
    "acompaniarăm": "acompania",
    "acompaniarăți": "acompania",
    "acompaniase": "acompania",
    "acompaniasem": "acompania",
    "acompaniaseră": "acompania",
    "acompaniaserăm": "acompania",
    "acompaniaserăți": "acompania",
    "acompaniaseși": "acompania",
    "acompaniași": "acompania",
    "acompaniat": "acompania",
    "acompaniați": "acompania",
    "acompaniatu": "acompania",
    "acompaniau": "acompania",
    "acompaniază": "acompania",
    "acompanie": "acompania",
    "acompaniem": "acompania",
    "acompaniez": "acompania",
    "acompanieze": "acompania",
    "acompaniezi": "acompania",
    "acompaniind": "acompania",
    "acompaniindu": "acompania",
    "neacompaniind": "acompania",
    "neacompaniindu": "acompania",
    "nemaiacompaniind": "acompania",
    "nemaiacompaniindu": "acompania",
    "acompaniamente": "acompaniament",
    "acompaniamentele": "acompaniament",
    "acompaniamentelor": "acompaniament",
    "acompaniamentul": "acompaniament",
    "acompaniamentului": "acompaniament",
    "acompaniata": "acompaniat",
    "acompaniată": "acompaniat",
    "acompaniate": "acompaniat",
    "acompaniatei": "acompaniat",
    "acompaniatele": "acompaniat",
    "acompaniatelor": "acompaniat",
    "acompaniați": "acompaniat",
    "acompaniații": "acompaniat",
    "acompaniaților": "acompaniat",
    "acompaniatul": "acompaniat",
    "acompaniatului": "acompaniat",
    "acompanierea": "acompaniere",
    "acompanieri": "acompaniere",
    "acompanierii": "acompaniere",
    "acompanierile": "acompaniere",
    "acontul": "acont",
    "acontului": "acont",
    "aconturi": "acont",
    "aconturile": "acont",
    "aconturilor": "acont",
    "acopăr": "acoperi",
    "acoperă": "acoperi",
    "acopere": "acoperi",
    "acoperea": "acoperi",
    "acopereai": "acoperi",
    "acopeream": "acoperi",
    "acopereați": "acoperi",
    "acopereau": "acoperi",
    "acoperii": "acoperi",
    "acoperim": "acoperi",
    "acoperind": "acoperi",
    "acoperindu": "acoperi",
    "acoperirăm": "acoperi",
    "acoperirăți": "acoperi",
    "acoperise": "acoperi",
    "acoperisem": "acoperi",
    "acoperiseră": "acoperi",
    "acoperiserăți": "acoperi",
    "acoperiseși": "acoperi",
    "acoperiși": "acoperi",
    "acoperit": "acoperi",
    "acoperiți": "acoperi",
    "acoperitu": "acoperi",
    "neacoperind": "acoperi",
    "neacoperindu": "acoperi",
    "nemaiacoperind": "acoperi",
    "nemaiacoperindu": "acoperi",
    "acoperirea": "acoperire",
    "acoperiri": "acoperire",
    "acoperirii": "acoperire",
    "acoperirile": "acoperire",
    "acoperișul": "acoperiș",
    "acoperișului": "acoperiș",
    "acoperișuri": "acoperiș",
    "acoperișurile": "acoperiș",
    "acoperișurilor": "acoperiș",
    "acoperita": "acoperit",
    "acoperită": "acoperit",
    "acoperite": "acoperit",
    "acoperitei": "acoperit",
    "acoperitele": "acoperit",
    "acoperitelor": "acoperit",
    "acoperiți": "acoperit",
    "acoperiții": "acoperit",
    "acoperiților": "acoperit",
    "acoperitul": "acoperit",
    "acoperitului": "acoperit",
    "acoperitoarea": "acoperitoare",
    "acoperitoarei": "acoperitoare",
    "acoperitoarele": "acoperitoare",
    "acoperitoarelor": "acoperitoare",
    "acoperitori": "acoperitor",
    "acoperitorii": "acoperitor",
    "acoperitorilor": "acoperitor",
    "acoperitorul": "acoperitor",
    "acoperitorului": "acoperitor",
    "acor'": "acord",
    "acordul": "acord",
    "acordului": "acord",
    "acorduri": "acord",
    "acordurile": "acord",
    "acordurilor": "acord",
    "acord": "acorda",
    "acordă": "acorda",
    "acordai": "acorda",
    "acordam": "acorda",
    "acordăm": "acorda",
    "acordând": "acorda",
    "acordându": "acorda",
    "acordară": "acorda",
    "acordarăm": "acorda",
    "acordarăți": "acorda",
    "acordase": "acorda",
    "acordasem": "acorda",
    "acordaseră": "acorda",
    "acordaserăm": "acorda",
    "acordaserăți": "acorda",
    "acordaseși": "acorda",
    "acordași": "acorda",
    "acordat": "acorda",
    "acordați": "acorda",
    "acordatu": "acorda",
    "acordau": "acorda",
    "acorde": "acorda",
    "acordează": "acorda",
    "acordez": "acorda",
    "acordeze": "acorda",
    "acordezi": "acorda",
    "acorzi": "acorda",
    "neacordând": "acorda",
    "neacordându": "acorda",
    "nemaiacordând": "acorda",
    "nemaiacordându": "acorda",
    "acordaje": "acordaj",
    "acordajele": "acordaj",
    "acordajelor": "acordaj",
    "acordajul": "acordaj",
    "acordajului": "acordaj",
    "acordarea": "acordare",
    "acordări": "acordare",
    "acordării": "acordare",
    "acordările": "acordare",
    "acordata": "acordat",
    "acordată": "acordat",
    "acordate": "acordat",
    "acordatei": "acordat",
    "acordatele": "acordat",
    "acordatelor": "acordat",
    "acordați": "acordat",
    "acordații": "acordat",
    "acordaților": "acordat",
    "acordatul": "acordat",
    "acordatului": "acordat",
    "acostă": "acosta",
    "acostai": "acosta",
    "acostam": "acosta",
    "acostăm": "acosta",
    "acostând": "acosta",
    "acostându": "acosta",
    "acostară": "acosta",
    "acostarăm": "acosta",
    "acostarăți": "acosta",
    "acostase": "acosta",
    "acostasem": "acosta",
    "acostaseră": "acosta",
    "acostaserăm": "acosta",
    "acostaserăți": "acosta",
    "acostaseși": "acosta",
    "acostași": "acosta",
    "acostat": "acosta",
    "acostați": "acosta",
    "acostatu": "acosta",
    "acostau": "acosta",
    "acostează": "acosta",
    "acostez": "acosta",
    "acosteze": "acosta",
    "acostezi": "acosta",
    "neacostând": "acosta",
    "neacostându": "acosta",
    "nemaiacostând": "acosta",
    "nemaiacostându": "acosta",
    "acostamente": "acostament",
    "acostamentele": "acostament",
    "acostamentelor": "acostament",
    "acostamentul": "acostament",
    "acostamentului": "acostament",
    "acostarea": "acostare",
    "acostări": "acostare",
    "acostării": "acostare",
    "acostările": "acostare",
    "acostata": "acostat",
    "acostată": "acostat",
    "acostate": "acostat",
    "acostatei": "acostat",
    "acostatele": "acostat",
    "acostatelor": "acostat",
    "acostați": "acostat",
    "acostații": "acostat",
    "acostaților": "acostat",
    "acostatul": "acostat",
    "acostatului": "acostat",
    "acotiledoane": "acotiledon",
    "acotiledoanei": "acotiledon",
    "acotiledoanele": "acotiledon",
    "acotiledoanelor": "acotiledon",
    "acotiledona": "acotiledon",
    "acotiledonă": "acotiledon",
    "acotiledoni": "acotiledon",
    "acotiledonii": "acotiledon",
    "acotiledonilor": "acotiledon",
    "acotiledonul": "acotiledon",
    "acotiledonului": "acotiledon",
    "acotiledonata": "acotiledonat",
    "acotiledonată": "acotiledonat",
    "acotiledonate": "acotiledonat",
    "acotiledonatei": "acotiledonat",
    "acotiledonatele": "acotiledonat",
    "acotiledonatelor": "acotiledonat",
    "acotiledonați": "acotiledonat",
    "acotiledonații": "acotiledonat",
    "acotiledonaților": "acotiledonat",
    "acotiledonatul": "acotiledonat",
    "acotiledonatului": "acotiledonat",
    "acreala": "acreală",
    "acreli": "acreală",
    "acrelii": "acreală",
    "acrelile": "acreală",
    "acrelilor": "acreală",
    "acredită": "acredita",
    "acreditai": "acredita",
    "acreditam": "acredita",
    "acredităm": "acredita",
    "acreditând": "acredita",
    "acreditându": "acredita",
    "acreditară": "acredita",
    "acreditarăm": "acredita",
    "acreditarăți": "acredita",
    "acreditase": "acredita",
    "acreditasem": "acredita",
    "acreditaseră": "acredita",
    "acreditaserăm": "acredita",
    "acreditaserăți": "acredita",
    "acreditaseși": "acredita",
    "acreditași": "acredita",
    "acreditat": "acredita",
    "acreditați": "acredita",
    "acreditatu": "acredita",
    "acreditau": "acredita",
    "acreditează": "acredita",
    "acrediteze": "acredita",
    "acreditezi": "acredita",
    "neacreditând": "acredita",
    "neacreditându": "acredita",
    "nemaiacreditând": "acredita",
    "nemaiacreditându": "acredita",
    "acreditarea": "acreditare",
    "acreditări": "acreditare",
    "acreditării": "acreditare",
    "acreditările": "acreditare",
    "acreditata": "acreditat",
    "acreditată": "acreditat",
    "acreditate": "acreditat",
    "acreditatei": "acreditat",
    "acreditatele": "acreditat",
    "acreditatelor": "acreditat",
    "acreditați": "acreditat",
    "acreditații": "acreditat",
    "acreditaților": "acreditat",
    "acreditatul": "acreditat",
    "acreditatului": "acreditat",
    "acreditata": "acreditată",
    "acreditate": "acreditată",
    "acreditatei": "acreditată",
    "acreditatele": "acreditată",
    "acreditatelor": "acreditată",
    "acreditive": "acreditiv",
    "acreditivele": "acreditiv",
    "acreditivelor": "acreditiv",
    "acreditivul": "acreditiv",
    "acreditivului": "acreditiv",
    "acrea": "acri",
    "acreai": "acri",
    "acream": "acri",
    "acrească": "acri",
    "acreați": "acri",
    "acreau": "acri",
    "acresc": "acri",
    "acrește": "acri",
    "acrești": "acri",
    "acrii": "acri",
    "acrim": "acri",
    "acrind": "acri",
    "acrindu": "acri",
    "acriră": "acri",
    "acrirăm": "acri",
    "acrirăți": "acri",
    "acrise": "acri",
    "acrisem": "acri",
    "acriseră": "acri",
    "acriserăți": "acri",
    "acriseși": "acri",
    "acriși": "acri",
    "acrit": "acri",
    "acriți": "acri",
    "acritu": "acri",
    "neacrind": "acri",
    "neacrindu": "acri",
    "nemaiacrind": "acri",
    "nemaiacrindu": "acri",
    "acrirea": "acrire",
    "acriri": "acrire",
    "acririi": "acrire",
    "acririle": "acrire",
    "acririlor": "acrire",
    "acrita": "acrit",
    "acrită": "acrit",
    "acrite": "acrit",
    "acritei": "acrit",
    "acritele": "acrit",
    "acritelor": "acrit",
    "acriți": "acrit",
    "acriții": "acrit",
    "acriților": "acrit",
    "acritul": "acrit",
    "acritului": "acrit",
    "acritura": "acritură",
    "acrituri": "acritură",
    "acriturii": "acritură",
    "acriturile": "acritură",
    "acriturilor": "acritură",
    "acrobați": "acrobat",
    "acrobații": "acrobat",
    "acrobaților": "acrobat",
    "acrobatul": "acrobat",
    "acrobatului": "acrobat",
    "acrobata": "acrobată",
    "acrobate": "acrobată",
    "acrobatei": "acrobată",
    "acrobatele": "acrobată",
    "acrobatelor": "acrobată",
    "acrobatica": "acrobatic",
    "acrobatică": "acrobatic",
    "acrobatice": "acrobatic",
    "acrobaticei": "acrobatic",
    "acrobaticele": "acrobatic",
    "acrobaticelor": "acrobatic",
    "acrobatici": "acrobatic",
    "acrobaticii": "acrobatic",
    "acrobaticilor": "acrobatic",
    "acrobaticul": "acrobatic",
    "acrobaticului": "acrobatic",
    "acrobația": "acrobație",
    "acrobației": "acrobație",
    "acrobații": "acrobație",
    "acrobațiile": "acrobație",
    "acrobațiilor": "acrobație",
    "acrobaticilor": "acromatic",
    "acromatica": "acromatic",
    "acromatică": "acromatic",
    "acromatice": "acromatic",
    "acromaticei": "acromatic",
    "acromaticele": "acromatic",
    "acromaticelor": "acromatic",
    "acromatici": "acromatic",
    "acromaticii": "acromatic",
    "acromaticul": "acromatic",
    "acromaticului": "acromatic",
    "acrostihul": "acrostih",
    "acrostihului": "acrostih",
    "acrostihuri": "acrostih",
    "acrostihurile": "acrostih",
    "acrostihurilor": "acrostih",
    "acra": "acru",
    "acră": "acru",
    "acre": "acru",
    "acrei": "acru",
    "acrele": "acru",
    "acrelor": "acru",
    "acri": "acru",
    "acrii": "acru",
    "acrilor": "acru",
    "acrul": "acru",
    "acrului": "acru",
    "acte": "act",
    "actele": "act",
    "actelor": "act",
    "actul": "act",
    "actului": "act",
    "acționă": "acționa",
    "acționai": "acționa",
    "acționam": "acționa",
    "acționăm": "acționa",
    "acționând": "acționa",
    "acționându": "acționa",
    "acționară": "acționa",
    "acționarăm": "acționa",
    "acționarăți": "acționa",
    "acționase": "acționa",
    "acționasem": "acționa",
    "acționaseră": "acționa",
    "acționaserăm": "acționa",
    "acționaserăți": "acționa",
    "acționaseși": "acționa",
    "acționași": "acționa",
    "acționat": "acționa",
    "acționați": "acționa",
    "acționatu": "acționa",
    "acționau": "acționa",
    "acționează": "acționa",
    "acționez": "acționa",
    "acționeze": "acționa",
    "acționezi": "acționa",
    "neacționând": "acționa",
    "neacționându": "acționa",
    "nemaiacționând": "acționa",
    "nemaiacționându": "acționa",
    "acționari": "acționar",
    "acționarii": "acționar",
    "acționarilor": "acționar",
    "acționarul": "acționar",
    "acționarului": "acționar",
    "acționara": "acționară",
    "acționare": "acționară",
    "acționarei": "acționară",
    "acționarele": "acționară",
    "acționarelor": "acționară",
    "acționarea": "acționare",
    "acționări": "acționare",
    "acționării": "acționare",
    "acționările": "acționare",
    "acționata": "acționat",
    "acționată": "acționat",
    "acționate": "acționat",
    "acționatei": "acționat",
    "acționatele": "acționat",
    "acționatelor": "acționat",
    "acționați": "acționat",
    "acționații": "acționat",
    "acționaților": "acționat",
    "acționatul": "acționat",
    "acționatului": "acționat",
    "acțiunea": "acțiune",
    "acțiuni": "acțiune",
    "acțiunii": "acțiune",
    "acțiunile": "acțiune",
    "acțiunilor": "acțiune",
    "activa": "activ",
    "activă": "activ",
    "active": "activ",
    "activei": "activ",
    "activele": "activ",
    "activelor": "activ",
    "activi": "activ",
    "activii": "activ",
    "activilor": "activ",
    "activul": "activ",
    "activului": "activ",
    "activă": "activa",
    "activai": "activa",
    "activam": "activa",
    "activăm": "activa",
    "activând": "activa",
    "activându": "activa",
    "activară": "activa",
    "activarăm": "activa",
    "activarăți": "activa",
    "activase": "activa",
    "activasem": "activa",
    "activaseră": "activa",
    "activaserăm": "activa",
    "activaserăți": "activa",
    "activaseși": "activa",
    "activași": "activa",
    "activat": "activa",
    "activați": "activa",
    "activatu": "activa",
    "activau": "activa",
    "activează": "activa",
    "activez": "activa",
    "activeze": "activa",
    "activezi": "activa",
    "neactivând": "activa",
    "neactivându": "activa",
    "nemaiactivând": "activa",
    "nemaiactivându": "activa",
    "activarea": "activare",
    "activări": "activare",
    "activării": "activare",
    "activările": "activare",
    "activata": "activat",
    "activată": "activat",
    "activate": "activat",
    "activatei": "activat",
    "activatele": "activat",
    "activatelor": "activat",
    "activați": "activat",
    "activații": "activat",
    "activaților": "activat",
    "activatul": "activat",
    "activatului": "activat",
    "activiști": "activist",
    "activiștii": "activist",
    "activiștilor": "activist",
    "activistul": "activist",
    "activistului": "activist",
    "activista": "activistă",
    "activiste": "activistă",
    "activistei": "activistă",
    "activistele": "activistă",
    "activistelor": "activistă",
    "activitatea": "activitate",
    "activități": "activitate",
    "activității": "activitate",
    "activitățile": "activitate",
    "activităților": "activitate",
    "activiză": "activiza",
    "activizai": "activiza",
    "activizam": "activiza",
    "activizăm": "activiza",
    "activizând": "activiza",
    "activizându": "activiza",
    "activizară": "activiza",
    "activizarăm": "activiza",
    "activizarăți": "activiza",
    "activizase": "activiza",
    "activizasem": "activiza",
    "activizaseră": "activiza",
    "activizaserăm": "activiza",
    "activizaserăți": "activiza",
    "activizaseși": "activiza",
    "activizași": "activiza",
    "activizat": "activiza",
    "activizați": "activiza",
    "activizatu": "activiza",
    "activizau": "activiza",
    "activizează": "activiza",
    "activizez": "activiza",
    "activizeze": "activiza",
    "activizezi": "activiza",
    "neactivizând": "activiza",
    "neactivizându": "activiza",
    "nemaiactivizând": "activiza",
    "nemaiactivizându": "activiza",
    "activizarea": "activizare",
    "activizări": "activizare",
    "activizării": "activizare",
    "activizările": "activizare",
    "activizata": "activizat",
    "activizată": "activizat",
    "activizate": "activizat",
    "activizatei": "activizat",
    "activizatele": "activizat",
    "activizatelor": "activizat",
    "activizați": "activizat",
    "activizații": "activizat",
    "activizaților": "activizat",
    "activizatul": "activizat",
    "activizatului": "activizat",
    "actori": "actor",
    "actorii": "actor",
    "actorilor": "actor",
    "actorul": "actor",
    "actorului": "actor",
    "actoriceasca": "actoricesc",
    "actoricească": "actoricesc",
    "actoricescul": "actoricesc",
    "actoricescului": "actoricesc",
    "actoricești": "actoricesc",
    "actoriceștii": "actoricesc",
    "actoriceștile": "actoricesc",
    "actoriceștilor": "actoricesc",
    "actoria": "actorie",
    "actoriei": "actorie",
    "actorii": "actorie",
    "actoriile": "actorie",
    "actoriilor": "actorie",
    "actrița": "actriță",
    "actrițe": "actriță",
    "actriței": "actriță",
    "actrițele": "actriță",
    "actrițelor": "actriță",
    "actuala": "actual",
    "actuală": "actual",
    "actuale": "actual",
    "actualei": "actual",
    "actualele": "actual",
    "actualelor": "actual",
    "actuali": "actual",
    "actualii": "actual",
    "actualilor": "actual",
    "actualul": "actual",
    "actualului": "actual",
    "actualitatea": "actualitate",
    "actualități": "actualitate",
    "actualității": "actualitate",
    "actualitățile": "actualitate",
    "actualităților": "actualitate",
    "actualiză": "actualiza",
    "actualizai": "actualiza",
    "actualizam": "actualiza",
    "actualizăm": "actualiza",
    "actualizând": "actualiza",
    "actualizându": "actualiza",
    "actualizară": "actualiza",
    "actualizarăm": "actualiza",
    "actualizarăți": "actualiza",
    "actualizase": "actualiza",
    "actualizasem": "actualiza",
    "actualizaseră": "actualiza",
    "actualizaserăm": "actualiza",
    "actualizaserăți": "actualiza",
    "actualizaseși": "actualiza",
    "actualizași": "actualiza",
    "actualizat": "actualiza",
    "actualizați": "actualiza",
    "actualizatu": "actualiza",
    "actualizau": "actualiza",
    "actualizează": "actualiza",
    "actualizez": "actualiza",
    "actualizeze": "actualiza",
    "actualizezi": "actualiza",
    "neactualizând": "actualiza",
    "neactualizându": "actualiza",
    "nemaiactualizând": "actualiza",
    "nemaiactualizându": "actualiza",
    "actualizarea": "actualizare",
    "actualizări": "actualizare",
    "actualizării": "actualizare",
    "actualizările": "actualizare",
    "actualizata": "actualizat",
    "actualizată": "actualizat",
    "actualizate": "actualizat",
    "actualizatei": "actualizat",
    "actualizatele": "actualizat",
    "actualizatelor": "actualizat",
    "actualizați": "actualizat",
    "actualizații": "actualizat",
    "actualizaților": "actualizat",
    "actualizatul": "actualizat",
    "actualizatului": "actualizat",
    "acuarela": "acuarelă",
    "acuarele": "acuarelă",
    "acuarelei": "acuarelă",
    "acuarelele": "acuarelă",
    "acuarelelor": "acuarelă",
    "acuitatea": "acuitate",
    "acuități": "acuitate",
    "acuității": "acuitate",
    "acuitățile": "acuitate",
    "acuităților": "acuitate",
    "acu'": "acum",
    "acuminata": "acuminat",
    "acuminată": "acuminat",
    "acuminate": "acuminat",
    "acuminatei": "acuminat",
    "acuminatele": "acuminat",
    "acuminatelor": "acuminat",
    "acuminați": "acuminat",
    "acuminații": "acuminat",
    "acuminaților": "acuminat",
    "acuminatul": "acuminat",
    "acuminatului": "acuminat",
    "acumulă": "acumula",
    "acumulai": "acumula",
    "acumulam": "acumula",
    "acumulăm": "acumula",
    "acumulând": "acumula",
    "acumulându": "acumula",
    "acumulară": "acumula",
    "acumularăm": "acumula",
    "acumularăți": "acumula",
    "acumulase": "acumula",
    "acumulasem": "acumula",
    "acumulaseră": "acumula",
    "acumulaserăm": "acumula",
    "acumulaserăți": "acumula",
    "acumulaseși": "acumula",
    "acumulași": "acumula",
    "acumulat": "acumula",
    "acumulați": "acumula",
    "acumulatu": "acumula",
    "acumulau": "acumula",
    "acumulează": "acumula",
    "acumulez": "acumula",
    "acumuleze": "acumula",
    "acumulezi": "acumula",
    "neacumulând": "acumula",
    "neacumulându": "acumula",
    "nemaiacumulând": "acumula",
    "nemaiacumulându": "acumula",
    "acumularea": "acumulare",
    "acumulări": "acumulare",
    "acumulării": "acumulare",
    "acumulările": "acumulare",
    "acumulata": "acumulat",
    "acumulată": "acumulat",
    "acumulate": "acumulat",
    "acumulatei": "acumulat",
    "acumulatele": "acumulat",
    "acumulatelor": "acumulat",
    "acumulați": "acumulat",
    "acumulații": "acumulat",
    "acumulaților": "acumulat",
    "acumulatul": "acumulat",
    "acumulatului": "acumulat",
    "acumulatoare": "acumulator",
    "acumulatoarele": "acumulator",
    "acumulatoarelor": "acumulator",
    "acumulatorul": "acumulator",
    "acumulatorului": "acumulator",
    "acuplă": "acupla",
    "acuplai": "acupla",
    "acuplam": "acupla",
    "acuplăm": "acupla",
    "acuplând": "acupla",
    "acuplându": "acupla",
    "acuplară": "acupla",
    "acuplarăm": "acupla",
    "acuplarăți": "acupla",
    "acuplase": "acupla",
    "acuplasem": "acupla",
    "acuplaseră": "acupla",
    "acuplaserăm": "acupla",
    "acuplaserăți": "acupla",
    "acuplaseși": "acupla",
    "acuplași": "acupla",
    "acuplat": "acupla",
    "acuplați": "acupla",
    "acuplatu": "acupla",
    "acuplau": "acupla",
    "acuplează": "acupla",
    "acuplez": "acupla",
    "acupleze": "acupla",
    "acuplezi": "acupla",
    "acuplată": "acuplat",
    "acuplate": "acuplat",
    "acuplați": "acuplat",
    "acuratețea": "acuratețe",
    "acurateți": "acuratețe",
    "acurateții": "acuratețe",
    "acuratețile": "acuratețe",
    "acurateților": "acuratețe",
    "acustica": "acustic",
    "acustică": "acustic",
    "acustice": "acustic",
    "acusticei": "acustic",
    "acusticele": "acustic",
    "acusticelor": "acustic",
    "acustici": "acustic",
    "acusticii": "acustic",
    "acusticilor": "acustic",
    "acusticul": "acustic",
    "acusticului": "acustic",
    "acuta": "acut",
    "acută": "acut",
    "acute": "acut",
    "acutei": "acut",
    "acutele": "acut",
    "acutelor": "acut",
    "acuți": "acut",
    "acuții": "acut",
    "acuților": "acut",
    "acutul": "acut",
    "acutului": "acut",
    "acutizarea": "acutizare",
    "acuz": "acuza",
    "acuză": "acuza",
    "acuzai": "acuza",
    "acuzam": "acuza",
    "acuzăm": "acuza",
    "acuzând": "acuza",
    "acuzându": "acuza",
    "acuzară": "acuza",
    "acuzarăm": "acuza",
    "acuzarăți": "acuza",
    "acuzase": "acuza",
    "acuzasem": "acuza",
    "acuzaseră": "acuza",
    "acuzaserăm": "acuza",
    "acuzaserăți": "acuza",
    "acuzaseși": "acuza",
    "acuzași": "acuza",
    "acuzat": "acuza",
    "acuzați": "acuza",
    "acuzatu": "acuza",
    "acuzau": "acuza",
    "acuze": "acuza",
    "acuzi": "acuza",
    "neacuzând": "acuza",
    "neacuzându": "acuza",
    "nemaiacuzând": "acuza",
    "nemaiacuzându": "acuza",
    "acuza": "acuză",
    "acuze": "acuză",
    "acuzei": "acuză",
    "acuzele": "acuză",
    "acuzelor": "acuză",
    "acuzarea": "acuzare",
    "acuzări": "acuzare",
    "acuzării": "acuzare",
    "acuzările": "acuzare",
    "acuzata": "acuzat",
    "acuzată": "acuzat",
    "acuzate": "acuzat",
    "acuzatei": "acuzat",
    "acuzatele": "acuzat",
    "acuzatelor": "acuzat",
    "acuzați": "acuzat",
    "acuzații": "acuzat",
    "acuzaților": "acuzat",
    "acuzatul": "acuzat",
    "acuzatului": "acuzat",
    "acuzata": "acuzată",
    "acuzate": "acuzată",
    "acuzatei": "acuzată",
    "acuzatele": "acuzată",
    "acuzatelor": "acuzată",
    "acuzația": "acuzație",
    "acuzației": "acuzație",
    "acuzații": "acuzație",
    "acuzațiile": "acuzație",
    "acuzațiilor": "acuzație",
    "acuzatoarea": "acuzatoare",
    "acuzatoarei": "acuzatoare",
    "acuzatoarele": "acuzatoare",
    "acuzatoarelor": "acuzatoare",
    "acuzatoare": "acuzator",
    "acuzatoarea": "acuzator",
    "acuzatoarei": "acuzator",
    "acuzatoarele": "acuzator",
    "acuzatoarelor": "acuzator",
    "acuzatori": "acuzator",
    "acuzatorii": "acuzator",
    "acuzatorilor": "acuzator",
    "acuzatorul": "acuzator",
    "acuzatorului": "acuzator",
    "acvarii": "acvariu",
    "acvariile": "acvariu",
    "acvariilor": "acvariu",
    "acvariul": "acvariu",
    "acvariului": "acvariu",
    "acvatica": "acvatic",
    "acvatică": "acvatic",
    "acvatice": "acvatic",
    "acvaticei": "acvatic",
    "acvaticele": "acvatic",
    "acvaticelor": "acvatic",
    "acvatici": "acvatic",
    "acvaticii": "acvatic",
    "acvaticilor": "acvatic",
    "acvaticul": "acvatic",
    "acvaticului": "acvatic",
    "acvifera": "acvifer",
    "acviferă": "acvifer",
    "acvifere": "acvifer",
    "acviferei": "acvifer",
    "acviferele": "acvifer",
    "acviferelor": "acvifer",
    "acviferi": "acvifer",
    "acviferii": "acvifer",
    "acviferilor": "acvifer",
    "acviferul": "acvifer",
    "acviferului": "acvifer",
    "acvila": "acvilă",
    "acvile": "acvilă",
    "acvilei": "acvilă",
    "acvilele": "acvilă",
    "acvilelor": "acvilă",
    "acvilina": "acvilin",
    "acvilină": "acvilin",
    "acviline": "acvilin",
    "acvilinei": "acvilin",
    "acvilinele": "acvilin",
    "acvilinelor": "acvilin",
    "acvilini": "acvilin",
    "acvilinii": "acvilin",
    "acvilinilor": "acvilin",
    "acvilinul": "acvilin",
    "acvilinului": "acvilin",
    "a.h.l.": "ad_hunc_locum",
    "a.i.": "ad_interim",
    "ad_us.": "ad_usum",
    "Adei": "Ada",
    "adagii": "adagiu",
    "adagiile": "adagiu",
    "adagiilor": "adagiu",
    "adagiul": "adagiu",
    "adagiului": "adagiu",
    "adamantina": "adamantin",
    "adamantină": "adamantin",
    "adamantine": "adamantin",
    "adamantinei": "adamantin",
    "adamantinele": "adamantin",
    "adamantinelor": "adamantin",
    "adamantini": "adamantin",
    "adamantinii": "adamantin",
    "adamantinilor": "adamantin",
    "adamantinul": "adamantin",
    "adamantinului": "adamantin",
    "adânca": "adânc",
    "adâncă": "adânc",
    "adânci": "adânc",
    "adâncii": "adânc",
    "adâncile": "adânc",
    "adâncilor": "adânc",
    "adâncul": "adânc",
    "adâncului": "adânc",
    "adâncuri": "adânc",
    "adâncurile": "adânc",
    "adâncurilor": "adânc",
    "adâncea": "adânci",
    "adânceai": "adânci",
    "adânceam": "adânci",
    "adâncească": "adânci",
    "adânceați": "adânci",
    "adânceau": "adânci",
    "adâncesc": "adânci",
    "adâncește": "adânci",
    "adâncești": "adânci",
    "adâncii": "adânci",
    "adâncim": "adânci",
    "adâncind": "adânci",
    "adâncindu": "adânci",
    "adânciră": "adânci",
    "adâncirăm": "adânci",
    "adâncirăți": "adânci",
    "adâncise": "adânci",
    "adâncisem": "adânci",
    "adânciseră": "adânci",
    "adânciserăm": "adânci",
    "adânciserăți": "adânci",
    "adânciseși": "adânci",
    "adânciși": "adânci",
    "adâncit": "adânci",
    "adânciți": "adânci",
    "adâncitu": "adânci",
    "neadâncind": "adânci",
    "neadâncindu": "adânci",
    "nemaiadâncind": "adânci",
    "nemaiadâncindu": "adânci",
    "adâncimea": "adâncime",
    "adâncimi": "adâncime",
    "adâncimii": "adâncime",
    "adâncimile": "adâncime",
    "adâncimilor": "adâncime",
    "adâncirea": "adâncire",
    "adânciri": "adâncire",
    "adâncirii": "adâncire",
    "adâncirile": "adâncire",
    "adâncita": "adâncit",
    "adâncită": "adâncit",
    "adâncite": "adâncit",
    "adâncitei": "adâncit",
    "adâncitele": "adâncit",
    "adâncitelor": "adâncit",
    "adânciți": "adâncit",
    "adânciții": "adâncit",
    "adânciților": "adâncit",
    "adâncitul": "adâncit",
    "adâncitului": "adâncit",
    "adâncitura": "adâncitură",
    "adâncituri": "adâncitură",
    "adânciturii": "adâncitură",
    "adânciturile": "adâncitură",
    "adânciturilor": "adâncitură",
    "adaosul": "adaos",
    "adaosului": "adaos",
    "adaosuri": "adaos",
    "adaosurile": "adaos",
    "adaosurilor": "adaos",
    "adăp": "adăpa",
    "adapă": "adăpa",
    "adăpă": "adăpa",
    "adăpai": "adăpa",
    "adăpam": "adăpa",
    "adăpăm": "adăpa",
    "adăpând": "adăpa",
    "adăpându": "adăpa",
    "adăpară": "adăpa",
    "adăparăm": "adăpa",
    "adăparăți": "adăpa",
    "adăpase": "adăpa",
    "adăpasem": "adăpa",
    "adăpaseră": "adăpa",
    "adăpaserăm": "adăpa",
    "adăpaserăți": "adăpa",
    "adăpaseși": "adăpa",
    "adăpași": "adăpa",
    "adăpat": "adăpa",
    "adăpați": "adăpa",
    "adăpatu": "adăpa",
    "adăpau": "adăpa",
    "adape": "adăpa",
    "adăpi": "adăpa",
    "neadăpând": "adăpa",
    "neadăpându": "adăpa",
    "nemaiadăpând": "adăpa",
    "nemaiadăpându": "adăpa",
    "adăparea": "adăpare",
    "adăpări": "adăpare",
    "adăpării": "adăpare",
    "adăpările": "adăpare",
    "adăpata": "adăpat",
    "adăpată": "adăpat",
    "adăpate": "adăpat",
    "adăpatei": "adăpat",
    "adăpatele": "adăpat",
    "adăpatelor": "adăpat",
    "adăpați": "adăpat",
    "adăpații": "adăpat",
    "adăpaților": "adăpat",
    "adăpatul": "adăpat",
    "adăpatului": "adăpat",
    "adăpostul": "adăpost",
    "adăpostului": "adăpost",
    "adăposturi": "adăpost",
    "adăposturile": "adăpost",
    "adăposturilor": "adăpost",
    "adăpostea": "adăposti",
    "adăposteai": "adăposti",
    "adăposteam": "adăposti",
    "adăpostească": "adăposti",
    "adăposteați": "adăposti",
    "adăposteau": "adăposti",
    "adăpostesc": "adăposti",
    "adăpostește": "adăposti",
    "adăpostești": "adăposti",
    "adăpostii": "adăposti",
    "adăpostim": "adăposti",
    "adăpostind": "adăposti",
    "adăpostindu": "adăposti",
    "adăpostiră": "adăposti",
    "adăpostirăm": "adăposti",
    "adăpostirăți": "adăposti",
    "adăpostise": "adăposti",
    "adăpostisem": "adăposti",
    "adăpostiseră": "adăposti",
    "adăpostiserăm": "adăposti",
    "adăpostiserăți": "adăposti",
    "adăpostiseși": "adăposti",
    "adăpostiși": "adăposti",
    "adăpostit": "adăposti",
    "adăpostiți": "adăposti",
    "adăpostitu": "adăposti",
    "neadăpostind": "adăposti",
    "neadăpostindu": "adăposti",
    "nemaiadăpostind": "adăposti",
    "nemaiadăpostindu": "adăposti",
    "adăpostirea": "adăpostire",
    "adăpostiri": "adăpostire",
    "adăpostirii": "adăpostire",
    "adăpostirile": "adăpostire",
    "adăpostita": "adăpostit",
    "adăpostită": "adăpostit",
    "adăpostite": "adăpostit",
    "adăpostitei": "adăpostit",
    "adăpostitele": "adăpostit",
    "adăpostitelor": "adăpostit",
    "adăpostiți": "adăpostit",
    "adăpostiții": "adăpostit",
    "adăpostiților": "adăpostit",
    "adăpostitul": "adăpostit",
    "adăpostitului": "adăpostit",
    "adaptă": "adapta",
    "adaptai": "adapta",
    "adaptam": "adapta",
    "adaptăm": "adapta",
    "adaptând": "adapta",
    "adaptându": "adapta",
    "adaptară": "adapta",
    "adaptarăm": "adapta",
    "adaptarăți": "adapta",
    "adaptase": "adapta",
    "adaptasem": "adapta",
    "adaptaseră": "adapta",
    "adaptaserăm": "adapta",
    "adaptaserăți": "adapta",
    "adaptaseși": "adapta",
    "adaptași": "adapta",
    "adaptat": "adapta",
    "adaptați": "adapta",
    "adaptatu": "adapta",
    "adaptau": "adapta",
    "adaptează": "adapta",
    "adaptez": "adapta",
    "adapteze": "adapta",
    "adaptezi": "adapta",
    "neadaptând": "adapta",
    "neadaptându": "adapta",
    "nemaiadaptând": "adapta",
    "nemaiadaptându": "adapta",
    "adaptabila": "adaptabil",
    "adaptabilă": "adaptabil",
    "adaptabile": "adaptabil",
    "adaptabilei": "adaptabil",
    "adaptabilele": "adaptabil",
    "adaptabilelor": "adaptabil",
    "adaptabili": "adaptabil",
    "adaptabilii": "adaptabil",
    "adaptabililor": "adaptabil",
    "adaptabilul": "adaptabil",
    "adaptabilului": "adaptabil",
    "adaptarea": "adaptare",
    "adaptări": "adaptare",
    "adaptării": "adaptare",
    "adaptările": "adaptare",
    "adaptata": "adaptat",
    "adaptată": "adaptat",
    "adaptate": "adaptat",
    "adaptatei": "adaptat",
    "adaptatele": "adaptat",
    "adaptatelor": "adaptat",
    "adaptați": "adaptat",
    "adaptații": "adaptat",
    "adaptaților": "adaptat",
    "adaptatul": "adaptat",
    "adaptatului": "adaptat",
    "adast": "adăsta",
    "adastă": "adăsta",
    "adăstă": "adăsta",
    "adăstai": "adăsta",
    "adăstam": "adăsta",
    "adăstăm": "adăsta",
    "adăstând": "adăsta",
    "adăstându": "adăsta",
    "adăstară": "adăsta",
    "adăstarăm": "adăsta",
    "adăstarăți": "adăsta",
    "adăstase": "adăsta",
    "adăstasem": "adăsta",
    "adăstaseră": "adăsta",
    "adăstaserăm": "adăsta",
    "adăstaserăți": "adăsta",
    "adăstaseși": "adăsta",
    "adăstași": "adăsta",
    "adăstat": "adăsta",
    "adăstați": "adăsta",
    "adăstatu": "adăsta",
    "adăstau": "adăsta",
    "adaste": "adăsta",
    "adăști": "adăsta",
    "adăstată": "adăstat",
    "adăstate": "adăstat",
    "adăstați": "adăstat",
    "ad.": "adaugă",
    "adaug": "adăuga",
    "adaugă": "adăuga",
    "adăugă": "adăuga",
    "adăugai": "adăuga",
    "adăugam": "adăuga",
    "adăugăm": "adăuga",
    "adăugând": "adăuga",
    "adăugându": "adăuga",
    "adăugară": "adăuga",
    "adăugarăm": "adăuga",
    "adăugarăți": "adăuga",
    "adăugase": "adăuga",
    "adăugasem": "adăuga",
    "adăugaseră": "adăuga",
    "adăugaserăm": "adăuga",
    "adăugaserăți": "adăuga",
    "adăugaseși": "adăuga",
    "adăugași": "adăuga",
    "adăugat": "adăuga",
    "adăugați": "adăuga",
    "adăugatu": "adăuga",
    "adăugau": "adăuga",
    "adauge": "adăuga",
    "adaugi": "adăuga",
    "neadăugând": "adăuga",
    "neadăugându": "adăuga",
    "nemaiadăugând": "adăuga",
    "nemaiadăugându": "adăuga",
    "adăugabilă": "adăugabil",
    "adăugabile": "adăugabil",
    "adăugabili": "adăugabil",
    "adăugarea": "adăugare",
    "adăugări": "adăugare",
    "adăugării": "adăugare",
    "adăugările": "adăugare",
    "adăugata": "adăugat",
    "adăugată": "adăugat",
    "adăugate": "adăugat",
    "adăugatei": "adăugat",
    "adăugatele": "adăugat",
    "adăugatelor": "adăugat",
    "adăugați": "adăugat",
    "adăugații": "adăugat",
    "adăugaților": "adăugat",
    "adăugatul": "adăugat",
    "adăugatului": "adăugat",
    "adăugirea": "adăugire",
    "adăugiri": "adăugire",
    "adăugirii": "adăugire",
    "adăugirile": "adăugire",
    "adăugirilor": "adăugire",
    "adăugită": "adăugit",
    "adăugite": "adăugit",
    "adăugiți": "adăugit",
    "ad.": "addenda",
    "adecuata": "adecuat",
    "adecuată": "adecuat",
    "adecuate": "adecuat",
    "adecuatei": "adecuat",
    "adecuatele": "adecuat",
    "adecuatelor": "adecuat",
    "adecuați": "adecuat",
    "adecuații": "adecuat",
    "adecuaților": "adecuat",
    "adecuatul": "adecuat",
    "adecuatului": "adecuat",
    "adecvata": "adecvat",
    "adecvată": "adecvat",
    "adecvate": "adecvat",
    "adecvatei": "adecvat",
    "adecvatele": "adecvat",
    "adecvatelor": "adecvat",
    "adecvați": "adecvat",
    "adecvații": "adecvat",
    "adecvaților": "adecvat",
    "adecvatul": "adecvat",
    "adecvatului": "adecvat",
    "ademenea": "ademeni",
    "ademeneai": "ademeni",
    "ademeneam": "ademeni",
    "ademenească": "ademeni",
    "ademeneați": "ademeni",
    "ademeneau": "ademeni",
    "ademenesc": "ademeni",
    "ademenește": "ademeni",
    "ademenești": "ademeni",
    "ademenii": "ademeni",
    "ademenim": "ademeni",
    "ademenind": "ademeni",
    "ademenindu": "ademeni",
    "ademeniră": "ademeni",
    "ademenirăm": "ademeni",
    "ademenirăți": "ademeni",
    "ademenise": "ademeni",
    "ademenisem": "ademeni",
    "ademeniseră": "ademeni",
    "ademeniserăm": "ademeni",
    "ademeniserăți": "ademeni",
    "ademeniseși": "ademeni",
    "ademeniși": "ademeni",
    "ademenit": "ademeni",
    "ademeniți": "ademeni",
    "ademenitu": "ademeni",
    "neademenind": "ademeni",
    "neademenindu": "ademeni",
    "nemaiademenind": "ademeni",
    "nemaiademenindu": "ademeni",
    "ademenirea": "ademenire",
    "ademeniri": "ademenire",
    "ademenirii": "ademenire",
    "ademenirile": "ademenire",
    "ademenita": "ademenit",
    "ademenită": "ademenit",
    "ademenite": "ademenit",
    "ademenitei": "ademenit",
    "ademenitele": "ademenit",
    "ademenitelor": "ademenit",
    "ademeniți": "ademenit",
    "ademeniții": "ademenit",
    "ademeniților": "ademenit",
    "ademenitul": "ademenit",
    "ademenitului": "ademenit",
    "ademenitoarea": "ademenitoare",
    "ademenitoarei": "ademenitoare",
    "ademenitoarele": "ademenitoare",
    "ademenitoarelor": "ademenitoare",
    "ademenitoare": "ademenitor",
    "ademenitoarea": "ademenitor",
    "ademenitoarei": "ademenitor",
    "ademenitoarele": "ademenitor",
    "ademenitoarelor": "ademenitor",
    "ademenitori": "ademenitor",
    "ademenitorii": "ademenitor",
    "ademenitorilor": "ademenitor",
    "ademenitorul": "ademenitor",
    "ademenitorului": "ademenitor",
    "adepți": "adept",
    "adepții": "adept",
    "adepților": "adept",
    "adeptul": "adept",
    "adeptului": "adept",
    "adepta": "adeptă",
    "adepte": "adeptă",
    "adeptei": "adeptă",
    "adeptele": "adeptă",
    "adeptelor": "adeptă",
    "ader": "adera",
    "aderă": "adera",
    "aderai": "adera",
    "aderam": "adera",
    "aderăm": "adera",
    "aderând": "adera",
    "aderându": "adera",
    "aderară": "adera",
    "aderarăm": "adera",
    "aderarăți": "adera",
    "aderase": "adera",
    "aderasem": "adera",
    "aderaseră": "adera",
    "aderaserăm": "adera",
    "aderaserăți": "adera",
    "aderaseși": "adera",
    "aderași": "adera",
    "aderat": "adera",
    "aderați": "adera",
    "aderatu": "adera",
    "aderau": "adera",
    "adere": "adera",
    "aderi": "adera",
    "neaderând": "adera",
    "neaderându": "adera",
    "nemaiaderând": "adera",
    "nemaiaderându": "adera",
    "aderarea": "aderare",
    "aderări": "aderare",
    "aderării": "aderare",
    "aderările": "aderare",
    "aderata": "aderat",
    "aderată": "aderat",
    "aderate": "aderat",
    "aderatei": "aderat",
    "aderatele": "aderat",
    "aderatelor": "aderat",
    "aderați": "aderat",
    "aderații": "aderat",
    "aderaților": "aderat",
    "aderatul": "aderat",
    "aderatului": "aderat",
    "aderenta": "aderent",
    "aderentă": "aderent",
    "aderente": "aderent",
    "aderentei": "aderent",
    "aderentele": "aderent",
    "aderentelor": "aderent",
    "aderenți": "aderent",
    "aderenții": "aderent",
    "aderenților": "aderent",
    "aderentul": "aderent",
    "aderentului": "aderent",
    "aderența": "aderență",
    "aderențe": "aderență",
    "aderenței": "aderență",
    "aderențele": "aderență",
    "aderențelor": "aderență",
    "adevărul": "adevăr",
    "adevărului": "adevăr",
    "adevăruri": "adevăr",
    "adevărurile": "adevăr",
    "adevărurilor": "adevăr",
    "adevărata": "adevărat",
    "adevărată": "adevărat",
    "adevărate": "adevărat",
    "adevăratei": "adevărat",
    "adevăratele": "adevărat",
    "adevăratelor": "adevărat",
    "adevărați": "adevărat",
    "adevărații": "adevărat",
    "adevăraților": "adevărat",
    "adevăratul": "adevărat",
    "adevăratului": "adevărat",
    "adeverea": "adeveri",
    "adevereai": "adeveri",
    "adeveream": "adeveri",
    "adeverească": "adeveri",
    "adevereați": "adeveri",
    "adevereau": "adeveri",
    "adeveresc": "adeveri",
    "adeverește": "adeveri",
    "adeverești": "adeveri",
    "adeverii": "adeveri",
    "adeverim": "adeveri",
    "adeverind": "adeveri",
    "adeverindu": "adeveri",
    "adeveriră": "adeveri",
    "adeverirăm": "adeveri",
    "adeverirăți": "adeveri",
    "adeverise": "adeveri",
    "adeverisem": "adeveri",
    "adeveriseră": "adeveri",
    "adeveriserăm": "adeveri",
    "adeveriserăți": "adeveri",
    "adeveriseși": "adeveri",
    "adeveriși": "adeveri",
    "adeverit": "adeveri",
    "adeveriți": "adeveri",
    "adeveritu": "adeveri",
    "neadeverind": "adeveri",
    "neadeverindu": "adeveri",
    "nemaiadeverind": "adeveri",
    "nemaiadeverindu": "adeveri",
    "adeverința": "adeverință",
    "adeverințe": "adeverință",
    "adeverinței": "adeverință",
    "adeverințele": "adeverință",
    "adeverințelor": "adeverință",
    "adeverirea": "adeverire",
    "adeveriri": "adeverire",
    "adeveririi": "adeverire",
    "adeveririle": "adeverire",
    "adeveririlor": "adeverire",
    "adeverita": "adeverit",
    "adeverită": "adeverit",
    "adeverite": "adeverit",
    "adeveritei": "adeverit",
    "adeveritele": "adeverit",
    "adeveritelor": "adeverit",
    "adeveriți": "adeverit",
    "adeveriții": "adeverit",
    "adeveriților": "adeverit",
    "adeveritul": "adeverit",
    "adeveritului": "adeverit",
    "adeveritoarea": "adeveritoare",
    "adeveritoarei": "adeveritoare",
    "adeveritoarele": "adeveritoare",
    "adeveritoarelor": "adeveritoare",
    "adeveritoare": "adeveritor",
    "adeveritoarea": "adeveritor",
    "adeveritoarei": "adeveritor",
    "adeveritoarele": "adeveritor",
    "adeveritoarelor": "adeveritor",
    "adeveritori": "adeveritor",
    "adeveritorii": "adeveritor",
    "adeveritorilor": "adeveritor",
    "adeveritorul": "adeveritor",
    "adeveritorului": "adeveritor",
    "adeziunea": "adeziune",
    "adeziuni": "adeziune",
    "adeziunii": "adeziune",
    "adeziunile": "adeziune",
    "adeziunilor": "adeziune",
    "adeziva": "adeziv",
    "adezivă": "adeziv",
    "adezive": "adeziv",
    "adezivei": "adeziv",
    "adezivele": "adeziv",
    "adezivelor": "adeziv",
    "adezivi": "adeziv",
    "adezivii": "adeziv",
    "adezivilor": "adeziv",
    "adezivul": "adeziv",
    "adezivului": "adeziv",
    "adiase": "adia",
    "adiat": "adia",
    "adie": "adia",
    "adiind": "adia",
    "neadiind": "adia",
    "nemaiadiind": "adia",
    "adiacenta": "adiacent",
    "adiacentă": "adiacent",
    "adiacente": "adiacent",
    "adiacentei": "adiacent",
    "adiacentele": "adiacent",
    "adiacentelor": "adiacent",
    "adiacenți": "adiacent",
    "adiacenții": "adiacent",
    "adiacenților": "adiacent",
    "adiacentul": "adiacent",
    "adiacentului": "adiacent",
    "adiafora": "adiafor",
    "adiaforă": "adiafor",
    "adiafore": "adiafor",
    "adiaforei": "adiafor",
    "adiaforele": "adiafor",
    "adiaforelor": "adiafor",
    "adiafori": "adiafor",
    "adiaforii": "adiafor",
    "adiaforilor": "adiafor",
    "adiaforul": "adiafor",
    "adiaforului": "adiafor",
    "adiată": "adiat",
    "adiate": "adiat",
    "adiați": "adiat",
    "adierea": "adiere",
    "adieri": "adiere",
    "adierii": "adiere",
    "adierile": "adiere",
    "adipoasa": "adipos",
    "adipoasă": "adipos",
    "adipoase": "adipos",
    "adipoasei": "adipos",
    "adipoasele": "adipos",
    "adipoaselor": "adipos",
    "adipoși": "adipos",
    "adipoșii": "adipos",
    "adipoșilor": "adipos",
    "adiposul": "adipos",
    "adiposului": "adipos",
    "adiționala": "adițional",
    "adițională": "adițional",
    "adiționale": "adițional",
    "adiționalei": "adițional",
    "adiționalele": "adițional",
    "adiționalelor": "adițional",
    "adiționali": "adițional",
    "adiționalii": "adițional",
    "adiționalilor": "adițional",
    "adiționalul": "adițional",
    "adiționalului": "adițional",
    "adj.": "adjectiv",
    "adjective": "adjectiv",
    "adjectivele": "adjectiv",
    "adjectivelor": "adjectiv",
    "adjectivul": "adjectiv",
    "adjectivului": "adjectiv",
    "adjectivala": "adjectival",
    "adjectivală": "adjectival",
    "adjectivale": "adjectival",
    "adjectivalei": "adjectival",
    "adjectivalele": "adjectival",
    "adjectivalelor": "adjectival",
    "adjectivali": "adjectival",
    "adjectivalii": "adjectival",
    "adjectivalilor": "adjectival",
    "adjectivalul": "adjectival",
    "adjectivalului": "adjectival",
    "adjudec": "adjudeca",
    "adjudecă": "adjudeca",
    "adjudecai": "adjudeca",
    "adjudecam": "adjudeca",
    "adjudecăm": "adjudeca",
    "adjudecând": "adjudeca",
    "adjudecându": "adjudeca",
    "adjudecară": "adjudeca",
    "adjudecarăm": "adjudeca",
    "adjudecarăți": "adjudeca",
    "adjudecase": "adjudeca",
    "adjudecasem": "adjudeca",
    "adjudecaseră": "adjudeca",
    "adjudecaserăm": "adjudeca",
    "adjudecaserăți": "adjudeca",
    "adjudecaseși": "adjudeca",
    "adjudecași": "adjudeca",
    "adjudecat": "adjudeca",
    "adjudecați": "adjudeca",
    "adjudecatu": "adjudeca",
    "adjudecau": "adjudeca",
    "adjudece": "adjudeca",
    "adjudeci": "adjudeca",
    "neadjudecând": "adjudeca",
    "neadjudecându": "adjudeca",
    "nemaiadjudecând": "adjudeca",
    "nemaiadjudecându": "adjudeca",
    "adjudecarea": "adjudecare",
    "adjudecări": "adjudecare",
    "adjudecării": "adjudecare",
    "adjudecările": "adjudecare",
    "adjudecata": "adjudecat",
    "adjudecată": "adjudecat",
    "adjudecate": "adjudecat",
    "adjudecatei": "adjudecat",
    "adjudecatele": "adjudecat",
    "adjudecatelor": "adjudecat",
    "adjudecați": "adjudecat",
    "adjudecații": "adjudecat",
    "adjudecaților": "adjudecat",
    "adjudecatul": "adjudecat",
    "adjudecatului": "adjudecat",
    "adjuncta": "adjunct",
    "adjunctă": "adjunct",
    "adjuncte": "adjunct",
    "adjunctei": "adjunct",
    "adjunctele": "adjunct",
    "adjunctelor": "adjunct",
    "adjuncți": "adjunct",
    "adjuncții": "adjunct",
    "adjuncților": "adjunct",
    "adjunctul": "adjunct",
    "adjunctului": "adjunct",
    "adjuncta": "adjunctă",
    "adjuncte": "adjunctă",
    "adjunctei": "adjunctă",
    "adjunctele": "adjunctă",
    "adjunctelor": "adjunctă",
    "administră": "administra",
    "administrai": "administra",
    "administram": "administra",
    "administrăm": "administra",
    "administrând": "administra",
    "administrându": "administra",
    "administrară": "administra",
    "administrarăm": "administra",
    "administrarăți": "administra",
    "administrase": "administra",
    "administrasem": "administra",
    "administraseră": "administra",
    "administraserăm": "administra",
    "administraserăți": "administra",
    "administraseși": "administra",
    "administrași": "administra",
    "administrat": "administra",
    "administrați": "administra",
    "administratu": "administra",
    "administrau": "administra",
    "administrează": "administra",
    "administrez": "administra",
    "administreze": "administra",
    "administrezi": "administra",
    "neadministrând": "administra",
    "neadministrându": "administra",
    "nemaiadministrând": "administra",
    "nemaiadministrându": "administra",
    "administrarea": "administrare",
    "administrări": "administrare",
    "administrării": "administrare",
    "administrările": "administrare",
    "administrata": "administrat",
    "administrată": "administrat",
    "administrate": "administrat",
    "administratei": "administrat",
    "administratele": "administrat",
    "administratelor": "administrat",
    "administrați": "administrat",
    "administrații": "administrat",
    "administraților": "administrat",
    "administratul": "administrat",
    "administratului": "administrat",
    "administrația": "administrație",
    "administrației": "administrație",
    "administrații": "administrație",
    "administrațiile": "administrație",
    "administrațiilor": "administrație",
    "administrativa": "administrativ",
    "administrativă": "administrativ",
    "administrative": "administrativ",
    "administrativei": "administrativ",
    "administrativele": "administrativ",
    "administrativelor": "administrativ",
    "administrativi": "administrativ",
    "administrativii": "administrativ",
    "administrativilor": "administrativ",
    "administrativul": "administrativ",
    "administrativului": "administrativ",
    "adtiv": "administrativ",
    "administratoarea": "administratoare",
    "administratoarei": "administratoare",
    "administratoarele": "administratoare",
    "administratoarelor": "administratoare",
    "administratori": "administrator",
    "administratorii": "administrator",
    "administratorilor": "administrator",
    "administratorul": "administrator",
    "administratorului": "administrator",
    "admir": "admira",
    "admiră": "admira",
    "admirai": "admira",
    "admiram": "admira",
    "admirăm": "admira",
    "admirând": "admira",
    "admirându": "admira",
    "admirară": "admira",
    "admirarăm": "admira",
    "admirarăți": "admira",
    "admirase": "admira",
    "admirasem": "admira",
    "admiraseră": "admira",
    "admiraserăm": "admira",
    "admiraserăți": "admira",
    "admiraseși": "admira",
    "admirași": "admira",
    "admirat": "admira",
    "admirați": "admira",
    "admiratu": "admira",
    "admirau": "admira",
    "admire": "admira",
    "admiri": "admira",
    "neadmirând": "admira",
    "neadmirându": "admira",
    "nemaiadmirând": "admira",
    "nemaiadmirându": "admira",
    "admirabilă": "admirabil",
    "admirabile": "admirabil",
    "admirabili": "admirabil",
    "admirarea": "admirare",
    "admirări": "admirare",
    "admirării": "admirare",
    "admirările": "admirare",
    "admirata": "admirat",
    "admirată": "admirat",
    "admirate": "admirat",
    "admiratei": "admirat",
    "admiratele": "admirat",
    "admiratelor": "admirat",
    "admirați": "admirat",
    "admirații": "admirat",
    "admiraților": "admirat",
    "admiratul": "admirat",
    "admiratului": "admirat",
    "admirația": "admirație",
    "admirației": "admirație",
    "admirații": "admirație",
    "admirațiile": "admirație",
    "admirațiilor": "admirație",
    "admirativa": "admirativ",
    "admirativă": "admirativ",
    "admirative": "admirativ",
    "admirativei": "admirativ",
    "admirativele": "admirativ",
    "admirativelor": "admirativ",
    "admirativi": "admirativ",
    "admirativii": "admirativ",
    "admirativilor": "admirativ",
    "admirativul": "admirativ",
    "admirativului": "admirativ",
    "admiratoarea": "admiratoare",
    "admiratoarei": "admiratoare",
    "admiratoarele": "admiratoare",
    "admiratoarelor": "admiratoare",
    "admiratoare": "admirator",
    "admiratoarea": "admirator",
    "admiratoarei": "admirator",
    "admiratoarele": "admirator",
    "admiratoarelor": "admirator",
    "admiratori": "admirator",
    "admiratorii": "admirator",
    "admiratorilor": "admirator",
    "admiratorul": "admirator",
    "admiratorului": "admirator",
    "admisa": "admis",
    "admisă": "admis",
    "admise": "admis",
    "admisei": "admis",
    "admisele": "admis",
    "admiselor": "admis",
    "admiși": "admis",
    "admișii": "admis",
    "admișilor": "admis",
    "admisul": "admis",
    "admisului": "admis",
    "admisa": "admisă",
    "admise": "admisă",
    "admisei": "admisă",
    "admisele": "admisă",
    "admiselor": "admisă",
    "admisibila": "admisibil",
    "admisibilă": "admisibil",
    "admisibile": "admisibil",
    "admisibilei": "admisibil",
    "admisibilele": "admisibil",
    "admisibilelor": "admisibil",
    "admisibili": "admisibil",
    "admisibilii": "admisibil",
    "admisibililor": "admisibil",
    "admisibilul": "admisibil",
    "admisibilului": "admisibil",
    "admis": "admite",
    "admise": "admite",
    "admisei": "admite",
    "admiseră": "admite",
    "admiserăm": "admite",
    "admiserăți": "admite",
    "admisese": "admite",
    "admisesem": "admite",
    "admiseseră": "admite",
    "admiseserăm": "admite",
    "admiseserăți": "admite",
    "admiseseși": "admite",
    "admiseși": "admite",
    "admisu": "admite",
    "admit": "admite",
    "admită": "admite",
    "admițând": "admite",
    "admițându": "admite",
    "admitea": "admite",
    "admiteai": "admite",
    "admiteam": "admite",
    "admiteați": "admite",
    "admiteau": "admite",
    "admitem": "admite",
    "admiteți": "admite",
    "admiți": "admite",
    "neadmițând": "admite",
    "neadmițându": "admite",
    "nemaiadmițând": "admite",
    "nemaiadmițându": "admite",
    "admiterea": "admitere",
    "admiteri": "admitere",
    "admiterii": "admitere",
    "admiterile": "admitere",
    "admonestă": "admonesta",
    "admonestai": "admonesta",
    "admonestam": "admonesta",
    "admonestăm": "admonesta",
    "admonestând": "admonesta",
    "admonestându": "admonesta",
    "admonestară": "admonesta",
    "admonestarăm": "admonesta",
    "admonestarăți": "admonesta",
    "admonestase": "admonesta",
    "admonestasem": "admonesta",
    "admonestaseră": "admonesta",
    "admonestaserăm": "admonesta",
    "admonestaserăți": "admonesta",
    "admonestaseși": "admonesta",
    "admonestași": "admonesta",
    "admonestat": "admonesta",
    "admonestați": "admonesta",
    "admonestatu": "admonesta",
    "admonestau": "admonesta",
    "admonestează": "admonesta",
    "admonestez": "admonesta",
    "admonesteze": "admonesta",
    "admonestezi": "admonesta",
    "neadmonestând": "admonesta",
    "neadmonestându": "admonesta",
    "nemaiadmonestând": "admonesta",
    "nemaiadmonestându": "admonesta",
    "admonestarea": "admonestare",
    "admonestări": "admonestare",
    "admonestării": "admonestare",
    "admonestările": "admonestare",
    "admonestata": "admonestat",
    "admonestată": "admonestat",
    "admonestate": "admonestat",
    "admonestatei": "admonestat",
    "admonestatele": "admonestat",
    "admonestatelor": "admonestat",
    "admonestați": "admonestat",
    "admonestații": "admonestat",
    "admonestaților": "admonestat",
    "admonestatul": "admonestat",
    "admonestatului": "admonestat",
    "adnotă": "adnota",
    "adnotai": "adnota",
    "adnotam": "adnota",
    "adnotăm": "adnota",
    "adnotând": "adnota",
    "adnotându": "adnota",
    "adnotară": "adnota",
    "adnotarăm": "adnota",
    "adnotarăți": "adnota",
    "adnotase": "adnota",
    "adnotasem": "adnota",
    "adnotaseră": "adnota",
    "adnotaserăm": "adnota",
    "adnotaserăți": "adnota",
    "adnotaseși": "adnota",
    "adnotași": "adnota",
    "adnotat": "adnota",
    "adnotați": "adnota",
    "adnotatu": "adnota",
    "adnotau": "adnota",
    "adnotează": "adnota",
    "adnotez": "adnota",
    "adnoteze": "adnota",
    "adnotezi": "adnota",
    "neadnotând": "adnota",
    "neadnotându": "adnota",
    "nemaiadnotând": "adnota",
    "nemaiadnotându": "adnota",
    "adnotarea": "adnotare",
    "adnotări": "adnotare",
    "adnotării": "adnotare",
    "adnotările": "adnotare",
    "adnotata": "adnotat",
    "adnotată": "adnotat",
    "adnotate": "adnotat",
    "adnotatei": "adnotat",
    "adnotatele": "adnotat",
    "adnotatelor": "adnotat",
    "adnotați": "adnotat",
    "adnotații": "adnotat",
    "adnotaților": "adnotat",
    "adnotatul": "adnotat",
    "adnotatului": "adnotat",
    "adolescenta": "adolescent",
    "adolescentă": "adolescent",
    "adolescente": "adolescent",
    "adolescentei": "adolescent",
    "adolescentele": "adolescent",
    "adolescentelor": "adolescent",
    "adolescenți": "adolescent",
    "adolescenții": "adolescent",
    "adolescenților": "adolescent",
    "adolescentul": "adolescent",
    "adolescentului": "adolescent",
    "adolescenta": "adolescentă",
    "adolescente": "adolescentă",
    "adolescentei": "adolescentă",
    "adolescentele": "adolescentă",
    "adolescentelor": "adolescentă",
    "adolescența": "adolescență",
    "adolescențe": "adolescență",
    "adolescenței": "adolescență",
    "adolescențele": "adolescență",
    "adolescențelor": "adolescență",
    "adonice": "adonic",
    "adonicele": "adonic",
    "adonicelor": "adonic",
    "adonicul": "adonic",
    "adonicului": "adonic",
    "adopt": "adopta",
    "adoptă": "adopta",
    "adoptai": "adopta",
    "adoptam": "adopta",
    "adoptăm": "adopta",
    "adoptând": "adopta",
    "adoptându": "adopta",
    "adoptară": "adopta",
    "adoptarăm": "adopta",
    "adoptarăți": "adopta",
    "adoptase": "adopta",
    "adoptasem": "adopta",
    "adoptaseră": "adopta",
    "adoptaserăm": "adopta",
    "adoptaserăți": "adopta",
    "adoptaseși": "adopta",
    "adoptași": "adopta",
    "adoptat": "adopta",
    "adoptați": "adopta",
    "adoptatu": "adopta",
    "adoptau": "adopta",
    "adopte": "adopta",
    "adopți": "adopta",
    "neadoptând": "adopta",
    "neadoptându": "adopta",
    "nemaiadoptând": "adopta",
    "nemaiadoptându": "adopta",
    "adoptarea": "adoptare",
    "adoptări": "adoptare",
    "adoptării": "adoptare",
    "adoptările": "adoptare",
    "adoptata": "adoptat",
    "adoptată": "adoptat",
    "adoptate": "adoptat",
    "adoptatei": "adoptat",
    "adoptatele": "adoptat",
    "adoptatelor": "adoptat",
    "adoptați": "adoptat",
    "adoptații": "adoptat",
    "adoptaților": "adoptat",
    "adoptatul": "adoptat",
    "adoptatului": "adoptat",
    "adoptata": "adoptată",
    "adoptate": "adoptată",
    "adoptatei": "adoptată",
    "adoptatele": "adoptată",
    "adoptatelor": "adoptată",
    "adopția": "adopție",
    "adopției": "adopție",
    "adopții": "adopție",
    "adopțiile": "adopție",
    "adopțiilor": "adopție",
    "adopțiunea": "adopțiune",
    "adopțiuni": "adopțiune",
    "adopțiunii": "adopțiune",
    "adopțiunile": "adopțiune",
    "adopțiunilor": "adopțiune",
    "adoptiva": "adoptiv",
    "adoptivă": "adoptiv",
    "adoptive": "adoptiv",
    "adoptivei": "adoptiv",
    "adoptivele": "adoptiv",
    "adoptivelor": "adoptiv",
    "adoptivi": "adoptiv",
    "adoptivii": "adoptiv",
    "adoptivilor": "adoptiv",
    "adoptivul": "adoptiv",
    "adoptivului": "adoptiv",
    "ador": "adora",
    "adoră": "adora",
    "adorai": "adora",
    "adoram": "adora",
    "adorăm": "adora",
    "adorând": "adora",
    "adorându": "adora",
    "adorară": "adora",
    "adorarăm": "adora",
    "adorarăți": "adora",
    "adorase": "adora",
    "adorasem": "adora",
    "adoraseră": "adora",
    "adoraserăm": "adora",
    "adoraserăți": "adora",
    "adoraseși": "adora",
    "adorași": "adora",
    "adorat": "adora",
    "adorați": "adora",
    "adoratu": "adora",
    "adorau": "adora",
    "adore": "adora",
    "adori": "adora",
    "neadorând": "adora",
    "neadorându": "adora",
    "nemaiadorând": "adora",
    "nemaiadorându": "adora",
    "adorabilă": "adorabil",
    "adorabile": "adorabil",
    "adorabili": "adorabil",
    "adorarea": "adorare",
    "adorări": "adorare",
    "adorării": "adorare",
    "adorările": "adorare",
    "adorata": "adorat",
    "adorată": "adorat",
    "adorate": "adorat",
    "adoratei": "adorat",
    "adoratele": "adorat",
    "adoratelor": "adorat",
    "adorați": "adorat",
    "adorații": "adorat",
    "adoraților": "adorat",
    "adoratul": "adorat",
    "adoratului": "adorat",
    "adorația": "adorație",
    "adorației": "adorație",
    "adorații": "adorație",
    "adorațiile": "adorație",
    "adorațiilor": "adorație",
    "adoratoarea": "adoratoare",
    "adoratoarei": "adoratoare",
    "adoratoarele": "adoratoare",
    "adoratoarelor": "adoratoare",
    "adoratori": "adorator",
    "adoratorii": "adorator",
    "adoratorilor": "adorator",
    "adoratorul": "adorator",
    "adoratorului": "adorator",
    "adoarmă": "adormi",
    "adoarme": "adormi",
    "adorm": "adormi",
    "adormea": "adormi",
    "adormeai": "adormi",
    "adormeam": "adormi",
    "adormeați": "adormi",
    "adormeau": "adormi",
    "adormii": "adormi",
    "adormim": "adormi",
    "adormind": "adormi",
    "adormindu": "adormi",
    "adormiră": "adormi",
    "adormirăm": "adormi",
    "adormirăți": "adormi",
    "adormise": "adormi",
    "adormisem": "adormi",
    "adormiseră": "adormi",
    "adormiserăm": "adormi",
    "adormiserăți": "adormi",
    "adormiseși": "adormi",
    "adormiși": "adormi",
    "adormit": "adormi",
    "adormiți": "adormi",
    "adormitu": "adormi",
    "neadormind": "adormi",
    "neadormindu": "adormi",
    "nemaiadormind": "adormi",
    "nemaiadormindu": "adormi",
    "adormirea": "adormire",
    "adormiri": "adormire",
    "adormirii": "adormire",
    "adormirile": "adormire",
    "adormita": "adormit",
    "adormită": "adormit",
    "adormite": "adormit",
    "adormitei": "adormit",
    "adormitele": "adormit",
    "adormitelor": "adormit",
    "adormiți": "adormit",
    "adormiții": "adormit",
    "adormiților": "adormit",
    "adormitul": "adormit",
    "adormitului": "adormit",
    "adormita": "adormită",
    "adormite": "adormită",
    "adormitei": "adormită",
    "adormitele": "adormită",
    "adormitelor": "adormită",
    "adormitoarea": "adormitoare",
    "adormitoarei": "adormitoare",
    "adormitoarele": "adormitoare",
    "adormitoarelor": "adormitoare",
    "adormitori": "adormitor",
    "adormitorii": "adormitor",
    "adormitorilor": "adormitor",
    "adormitorul": "adormitor",
    "adormitorului": "adormitor",
    "Adrasteii": "Adrasteia",
    "adr.": "adresa",
    "adresă": "adresa",
    "adresai": "adresa",
    "adresam": "adresa",
    "adresăm": "adresa",
    "adresând": "adresa",
    "adresându": "adresa",
    "adresară": "adresa",
    "adresarăm": "adresa",
    "adresarăți": "adresa",
    "adresase": "adresa",
    "adresasem": "adresa",
    "adresaseră": "adresa",
    "adresaserăm": "adresa",
    "adresaserăți": "adresa",
    "adresaseși": "adresa",
    "adresași": "adresa",
    "adresat": "adresa",
    "adresați": "adresa",
    "adresatu": "adresa",
    "adresau": "adresa",
    "adresează": "adresa",
    "adresez": "adresa",
    "adreseze": "adresa",
    "adresezi": "adresa",
    "neadresând": "adresa",
    "neadresându": "adresa",
    "nemaiadresând": "adresa",
    "nemaiadresându": "adresa",
    "adresa": "adresă",
    "adrese": "adresă",
    "adresei": "adresă",
    "adresele": "adresă",
    "adreselor": "adresă",
    "adresanți": "adresant",
    "adresanții": "adresant",
    "adresanților": "adresant",
    "adresantul": "adresant",
    "adresantului": "adresant",
    "adresanta": "adresantă",
    "adresante": "adresantă",
    "adresantei": "adresantă",
    "adresantele": "adresantă",
    "adresantelor": "adresantă",
    "adresarea": "adresare",
    "adresări": "adresare",
    "adresării": "adresare",
    "adresările": "adresare",
    "adresata": "adresat",
    "adresată": "adresat",
    "adresate": "adresat",
    "adresatei": "adresat",
    "adresatele": "adresat",
    "adresatelor": "adresat",
    "adresați": "adresat",
    "adresații": "adresat",
    "adresaților": "adresat",
    "adresatul": "adresat",
    "adresatului": "adresat",
    "Adriană": "Adriana",
    "Adriane": "Adriana",
    "Adrianei": "Adriana",
    "aducătoare": "aducător",
    "aducătoarea": "aducător",
    "aducătoarei": "aducător",
    "aducătoarele": "aducător",
    "aducătoarelor": "aducător",
    "aducători": "aducător",
    "aducătorii": "aducător",
    "aducătorilor": "aducător",
    "aducătorul": "aducător",
    "aducătorului": "aducător",
    "adu": "aduce",
    "aduc": "aduce",
    "aducă": "aduce",
    "aducând": "aduce",
    "aducându": "aduce",
    "aducea": "aduce",
    "aduceai": "aduce",
    "aduceam": "aduce",
    "aduceați": "aduce",
    "aduceau": "aduce",
    "aducem": "aduce",
    "aduceți": "aduce",
    "aduci": "aduce",
    "adus": "aduce",
    "aduse": "aduce",
    "adusei": "aduce",
    "aduseră": "aduce",
    "aduserăm": "aduce",
    "aduserăți": "aduce",
    "adusese": "aduce",
    "adusesem": "aduce",
    "aduseseră": "aduce",
    "aduseserăm": "aduce",
    "aduseserăți": "aduce",
    "aduseseși": "aduce",
    "aduseși": "aduce",
    "adusu": "aduce",
    "neaducând": "aduce",
    "neaducându": "aduce",
    "nemaiaducând": "aduce",
    "nemaiaducându": "aduce",
    "aducerea": "aducere",
    "aduceri": "aducere",
    "aducerii": "aducere",
    "aducerile": "aducere",
    "adulă": "adula",
    "adulai": "adula",
    "adulam": "adula",
    "adulăm": "adula",
    "adulând": "adula",
    "adulându": "adula",
    "adulară": "adula",
    "adularăm": "adula",
    "adularăți": "adula",
    "adulase": "adula",
    "adulasem": "adula",
    "adulaseră": "adula",
    "adulaserăm": "adula",
    "adulaserăți": "adula",
    "adulaseși": "adula",
    "adulași": "adula",
    "adulat": "adula",
    "adulați": "adula",
    "adulatu": "adula",
    "adulau": "adula",
    "adulează": "adula",
    "adulez": "adula",
    "aduleze": "adula",
    "adulezi": "adula",
    "neadulând": "adula",
    "neadulându": "adula",
    "nemaiadulând": "adula",
    "nemaiadulându": "adula",
    "adularea": "adulare",
    "adulări": "adulare",
    "adulării": "adulare",
    "adulările": "adulare",
    "adulata": "adulat",
    "adulată": "adulat",
    "adulate": "adulat",
    "adulatei": "adulat",
    "adulatele": "adulat",
    "adulatelor": "adulat",
    "adulați": "adulat",
    "adulații": "adulat",
    "adulaților": "adulat",
    "adulatul": "adulat",
    "adulatului": "adulat",
    "adulata": "adulată",
    "adulate": "adulată",
    "adulatei": "adulată",
    "adulatele": "adulată",
    "adulatelor": "adulată",
    "adulatoarea": "adulatoare",
    "adulatoarei": "adulatoare",
    "adulatoarele": "adulatoare",
    "adulatoarelor": "adulatoare",
    "adulatoare": "adulator",
    "adulatoarea": "adulator",
    "adulatoarei": "adulator",
    "adulatoarele": "adulator",
    "adulatoarelor": "adulator",
    "adulatori": "adulator",
    "adulatorii": "adulator",
    "adulatorilor": "adulator",
    "adulatorul": "adulator",
    "adulatorului": "adulator",
    "adulmec": "adulmeca",
    "adulmecă": "adulmeca",
    "adulmecai": "adulmeca",
    "adulmecam": "adulmeca",
    "adulmecăm": "adulmeca",
    "adulmecând": "adulmeca",
    "adulmecându": "adulmeca",
    "adulmecară": "adulmeca",
    "adulmecarăm": "adulmeca",
    "adulmecarăți": "adulmeca",
    "adulmecase": "adulmeca",
    "adulmecasem": "adulmeca",
    "adulmecaseră": "adulmeca",
    "adulmecaserăm": "adulmeca",
    "adulmecaserăți": "adulmeca",
    "adulmecaseși": "adulmeca",
    "adulmecași": "adulmeca",
    "adulmecat": "adulmeca",
    "adulmecați": "adulmeca",
    "adulmecatu": "adulmeca",
    "adulmecau": "adulmeca",
    "adulmece": "adulmeca",
    "adulmeci": "adulmeca",
    "neadulmecând": "adulmeca",
    "neadulmecându": "adulmeca",
    "nemaiadulmecând": "adulmeca",
    "nemaiadulmecându": "adulmeca",
    "adulmecarea": "adulmecare",
    "adulmecări": "adulmecare",
    "adulmecării": "adulmecare",
    "adulmecările": "adulmecare",
    "adulmecata": "adulmecat",
    "adulmecată": "adulmecat",
    "adulmecate": "adulmecat",
    "adulmecatei": "adulmecat",
    "adulmecatele": "adulmecat",
    "adulmecatelor": "adulmecat",
    "adulmecați": "adulmecat",
    "adulmecații": "adulmecat",
    "adulmecaților": "adulmecat",
    "adulmecatul": "adulmecat",
    "adulmecatului": "adulmecat",
    "adulmecătoare": "adulmecător",
    "adulmecătoarea": "adulmecător",
    "adulmecătoarei": "adulmecător",
    "adulmecătoarele": "adulmecător",
    "adulmecătoarelor": "adulmecător",
    "adulmecători": "adulmecător",
    "adulmecătorii": "adulmecător",
    "adulmecătorilor": "adulmecător",
    "adulmecătorul": "adulmecător",
    "adulmecătorului": "adulmecător",
    "adulta": "adult",
    "adultă": "adult",
    "adulte": "adult",
    "adultei": "adult",
    "adultele": "adult",
    "adultelor": "adult",
    "adulți": "adult",
    "adulții": "adult",
    "adulților": "adult",
    "adultul": "adult",
    "adultului": "adult",
    "adulta": "adultă",
    "adulte": "adultă",
    "adultei": "adultă",
    "adultele": "adultă",
    "adultelor": "adultă",
    "adultera": "adulter",
    "adulteră": "adulter",
    "adultere": "adulter",
    "adulterei": "adulter",
    "adulterele": "adulter",
    "adulterelor": "adulter",
    "adulteri": "adulter",
    "adulterii": "adulter",
    "adulterilor": "adulter",
    "adulterul": "adulter",
    "adulterului": "adulter",
    "adulterina": "adulterin",
    "adulterină": "adulterin",
    "adulterine": "adulterin",
    "adulterinei": "adulterin",
    "adulterinele": "adulterin",
    "adulterinelor": "adulterin",
    "adulterini": "adulterin",
    "adulterinii": "adulterin",
    "adulterinilor": "adulterin",
    "adulterinul": "adulterin",
    "adulterinului": "adulterin",
    "adumbrea": "adumbri",
    "adumbreai": "adumbri",
    "adumbream": "adumbri",
    "adumbrească": "adumbri",
    "adumbreați": "adumbri",
    "adumbreau": "adumbri",
    "adumbresc": "adumbri",
    "adumbrește": "adumbri",
    "adumbrești": "adumbri",
    "adumbrii": "adumbri",
    "adumbrim": "adumbri",
    "adumbrind": "adumbri",
    "adumbrindu": "adumbri",
    "adumbriră": "adumbri",
    "adumbrirăm": "adumbri",
    "adumbrirăți": "adumbri",
    "adumbrise": "adumbri",
    "adumbrisem": "adumbri",
    "adumbriseră": "adumbri",
    "adumbriserăm": "adumbri",
    "adumbriserăți": "adumbri",
    "adumbriseși": "adumbri",
    "adumbriși": "adumbri",
    "adumbrit": "adumbri",
    "adumbriți": "adumbri",
    "adumbritu": "adumbri",
    "neadumbrind": "adumbri",
    "neadumbrindu": "adumbri",
    "nemaiadumbrind": "adumbri",
    "nemaiadumbrindu": "adumbri",
    "adumbrirea": "adumbrire",
    "adumbriri": "adumbrire",
    "adumbririi": "adumbrire",
    "adumbririle": "adumbrire",
    "adumbrita": "adumbrit",
    "adumbrită": "adumbrit",
    "adumbrite": "adumbrit",
    "adumbritei": "adumbrit",
    "adumbritele": "adumbrit",
    "adumbritelor": "adumbrit",
    "adumbriți": "adumbrit",
    "adumbriții": "adumbrit",
    "adumbriților": "adumbrit",
    "adumbritul": "adumbrit",
    "adumbritului": "adumbrit",
    "adun": "aduna",
    "adună": "aduna",
    "adunai": "aduna",
    "adunam": "aduna",
    "adunăm": "aduna",
    "adunând": "aduna",
    "adunându": "aduna",
    "adunară": "aduna",
    "adunarăm": "aduna",
    "adunarăți": "aduna",
    "adunase": "aduna",
    "adunasem": "aduna",
    "adunaseră": "aduna",
    "adunaserăm": "aduna",
    "adunaserăți": "aduna",
    "adunaseși": "aduna",
    "adunași": "aduna",
    "adunat": "aduna",
    "adunați": "aduna",
    "adunatu": "aduna",
    "adunau": "aduna",
    "adune": "aduna",
    "aduni": "aduna",
    "neadunând": "aduna",
    "neadunându": "aduna",
    "nemaiadunând": "aduna",
    "nemaiadunându": "aduna",
    "adunarea": "adunare",
    "adunări": "adunare",
    "adunării": "adunare",
    "adunările": "adunare",
    "adunărilor": "adunare",
    "adunata": "adunat",
    "adunată": "adunat",
    "adunate": "adunat",
    "adunatei": "adunat",
    "adunatele": "adunat",
    "adunatelor": "adunat",
    "adunați": "adunat",
    "adunații": "adunat",
    "adunaților": "adunat",
    "adunatul": "adunat",
    "adunatului": "adunat",
    "adunătoarea": "adunătoare",
    "adunătoarei": "adunătoare",
    "adunătoarele": "adunătoare",
    "adunătoarelor": "adunătoare",
    "adunătoare": "adunător",
    "adunătoarea": "adunător",
    "adunătoarei": "adunător",
    "adunătoarele": "adunător",
    "adunătoarelor": "adunător",
    "adunători": "adunător",
    "adunătorii": "adunător",
    "adunătorilor": "adunător",
    "adunătorul": "adunător",
    "adunătorului": "adunător",
    "adunătura": "adunătură",
    "adunături": "adunătură",
    "adunăturii": "adunătură",
    "adunăturile": "adunătură",
    "adunăturilor": "adunătură",
    "adusa": "adus",
    "adusă": "adus",
    "aduse": "adus",
    "adusei": "adus",
    "adusele": "adus",
    "aduselor": "adus",
    "aduși": "adus",
    "adușii": "adus",
    "adușilor": "adus",
    "adusul": "adus",
    "adusului": "adus",
    "adventista": "adventist",
    "adventistă": "adventist",
    "adventiste": "adventist",
    "adventistei": "adventist",
    "adventistele": "adventist",
    "adventistelor": "adventist",
    "adventiști": "adventist",
    "adventiștii": "adventist",
    "adventiștilor": "adventist",
    "adventistul": "adventist",
    "adventistului": "adventist",
    "adventiva": "adventiv",
    "adventivă": "adventiv",
    "adventive": "adventiv",
    "adventivei": "adventiv",
    "adventivele": "adventiv",
    "adventivelor": "adventiv",
    "adventivi": "adventiv",
    "adventivii": "adventiv",
    "adventivilor": "adventiv",
    "adventivul": "adventiv",
    "adventivului": "adventiv",
    "adv.": "adverb",
    "adverbe": "adverb",
    "adverbele": "adverb",
    "adverbelor": "adverb",
    "adverbul": "adverb",
    "adverbului": "adverb",
    "adverbiala": "adverbial",
    "adverbială": "adverbial",
    "adverbiale": "adverbial",
    "adverbialei": "adverbial",
    "adverbialele": "adverbial",
    "adverbialelor": "adverbial",
    "adverbiali": "adverbial",
    "adverbialii": "adverbial",
    "adverbialilor": "adverbial",
    "adverbialul": "adverbial",
    "adverbialului": "adverbial",
    "adversă": "advers",
    "adverse": "advers",
    "adverși": "advers",
    "adversari": "adversar",
    "adversarii": "adversar",
    "adversarilor": "adversar",
    "adversarul": "adversar",
    "adversarului": "adversar",
    "adversara": "adversară",
    "adversare": "adversară",
    "adversarei": "adversară",
    "adversarele": "adversară",
    "adversarelor": "adversară",
    "adversativa": "adversativ",
    "adversativă": "adversativ",
    "adversative": "adversativ",
    "adversativei": "adversativ",
    "adversativele": "adversativ",
    "adversativelor": "adversativ",
    "adversativi": "adversativ",
    "adversativii": "adversativ",
    "adversativilor": "adversativ",
    "adversativul": "adversativ",
    "adversativului": "adversativ",
    "aedul": "aed",
    "aedului": "aed",
    "aezi": "aed",
    "aezii": "aed",
    "aezilor": "aed",
    "aere": "aer",
    "aerele": "aer",
    "aerelor": "aer",
    "aerul": "aer",
    "aerului": "aer",
    "aerata": "aerat",
    "aerată": "aerat",
    "aerate": "aerat",
    "aeratei": "aerat",
    "aeratele": "aerat",
    "aeratelor": "aerat",
    "aerați": "aerat",
    "aerații": "aerat",
    "aeraților": "aerat",
    "aeratul": "aerat",
    "aeratului": "aerat",
    "aeriana": "aerian",
    "aeriană": "aerian",
    "aerianul": "aerian",
    "aerianului": "aerian",
    "aeriene": "aerian",
    "aerienei": "aerian",
    "aerienele": "aerian",
    "aerienelor": "aerian",
    "aerieni": "aerian",
    "aerienii": "aerian",
    "aerienilor": "aerian",
    "aeriforma": "aeriform",
    "aeriformă": "aeriform",
    "aeriforme": "aeriform",
    "aeriformei": "aeriform",
    "aeriformele": "aeriform",
    "aeriformelor": "aeriform",
    "aeriformi": "aeriform",
    "aeriformii": "aeriform",
    "aeriformilor": "aeriform",
    "aeriformul": "aeriform",
    "aeriformului": "aeriform",
    "aerisirea": "aerisire",
    "aerisiri": "aerisire",
    "aerisirii": "aerisire",
    "aerisirile": "aerisire",
    "aerisirilor": "aerisire",
    "aeroba": "aerob",
    "aerobă": "aerob",
    "aerobe": "aerob",
    "aerobei": "aerob",
    "aerobele": "aerob",
    "aerobelor": "aerob",
    "aerobi": "aerob",
    "aerobii": "aerob",
    "aerobilor": "aerob",
    "aerobul": "aerob",
    "aerobului": "aerob",
    "aerobaza": "aerobază",
    "aerobaze": "aerobază",
    "aerobazei": "aerobază",
    "aerobazele": "aerobază",
    "aerobazelor": "aerobază",
    "aerobiotica": "aerobiotic",
    "aerobiotică": "aerobiotic",
    "aerobiotice": "aerobiotic",
    "aerobioticei": "aerobiotic",
    "aerobioticele": "aerobiotic",
    "aerobioticelor": "aerobiotic",
    "aerobiotici": "aerobiotic",
    "aerobioticii": "aerobiotic",
    "aerobioticilor": "aerobiotic",
    "aerobioticul": "aerobiotic",
    "aerobioticului": "aerobiotic",
    "aerodina": "aerodină",
    "aerodine": "aerodină",
    "aerodinei": "aerodină",
    "aerodinele": "aerodină",
    "aerodinelor": "aerodină",
    "aerodinamica": "aerodinamic",
    "aerodinamică": "aerodinamic",
    "aerodinamice": "aerodinamic",
    "aerodinamicei": "aerodinamic",
    "aerodinamicele": "aerodinamic",
    "aerodinamicelor": "aerodinamic",
    "aerodinamici": "aerodinamic",
    "aerodinamicii": "aerodinamic",
    "aerodinamicilor": "aerodinamic",
    "aerodinamicul": "aerodinamic",
    "aerodinamicului": "aerodinamic",
    "aerodinamica": "aerodinamică",
    "aerodinamici": "aerodinamică",
    "aerodinamicii": "aerodinamică",
    "aerodinamicile": "aerodinamică",
    "aerodinamicilor": "aerodinamică",
    "aerodromul": "aerodrom",
    "aerodromului": "aerodrom",
    "aerodromuri": "aerodrom",
    "aerodromurile": "aerodrom",
    "aerodromurilor": "aerodrom",
    "aeroliți": "aerolit",
    "aeroliții": "aerolit",
    "aeroliților": "aerolit",
    "aerolitul": "aerolit",
    "aerolitului": "aerolit",
    "aeromodele": "aeromodel",
    "aeromodelele": "aeromodel",
    "aeromodelelor": "aeromodel",
    "aeromodelul": "aeromodel",
    "aeromodelului": "aeromodel",
    "aeromodelismul": "aeromodelism",
    "aeromodelismului": "aeromodelism",
    "aeronauți": "aeronaut",
    "aeronauții": "aeronaut",
    "aeronauților": "aeronaut",
    "aeronautul": "aeronaut",
    "aeronautului": "aeronaut",
    "aeronautica": "aeronautic",
    "aeronautică": "aeronautic",
    "aeronautice": "aeronautic",
    "aeronauticei": "aeronautic",
    "aeronauticele": "aeronautic",
    "aeronauticelor": "aeronautic",
    "aeronautici": "aeronautic",
    "aeronauticii": "aeronautic",
    "aeronauticilor": "aeronautic",
    "aeronauticul": "aeronautic",
    "aeronauticului": "aeronautic",
    "aeronautica": "aeronautică",
    "aeronauticele": "aeronautică",
    "aeronautici": "aeronautică",
    "aeronauticii": "aeronautică",
    "aeronauticilor": "aeronautică",
    "aeroplane": "aeroplan",
    "aeroplanele": "aeroplan",
    "aeroplanelor": "aeroplan",
    "aeroplanul": "aeroplan",
    "aeroplanului": "aeroplan",
    "aeroportul": "aeroport",
    "aeroportului": "aeroport",
    "aeroporturi": "aeroport",
    "aeroporturile": "aeroport",
    "aeroporturilor": "aeroport",
    "aeropurtata": "aeropurtat",
    "aeropurtată": "aeropurtat",
    "aeropurtate": "aeropurtat",
    "aeropurtatei": "aeropurtat",
    "aeropurtatele": "aeropurtat",
    "aeropurtatelor": "aeropurtat",
    "aeropurtați": "aeropurtat",
    "aeropurtații": "aeropurtat",
    "aeropurtaților": "aeropurtat",
    "aeropurtatul": "aeropurtat",
    "aeropurtatului": "aeropurtat",
    "aeroasa": "aeros",
    "aeroasă": "aeros",
    "aeroase": "aeros",
    "aeroasei": "aeros",
    "aeroasele": "aeros",
    "aeroaselor": "aeros",
    "aeroși": "aeros",
    "aeroșii": "aeros",
    "aeroșilor": "aeros",
    "aerosul": "aeros",
    "aerosului": "aeros",
    "aerosoli": "aerosol",
    "aerosolii": "aerosol",
    "aerosolilor": "aerosol",
    "aerosolul": "aerosol",
    "aerosolului": "aerosol",
    "aerostate": "aerostat",
    "aerostatele": "aerostat",
    "aerostatelor": "aerostat",
    "aerostatul": "aerostat",
    "aerostatului": "aerostat",
    "aerostatica": "aerostatic",
    "aerostatică": "aerostatic",
    "aerostatice": "aerostatic",
    "aerostaticei": "aerostatic",
    "aerostaticele": "aerostatic",
    "aerostaticelor": "aerostatic",
    "aerostatici": "aerostatic",
    "aerostaticii": "aerostatic",
    "aerostaticilor": "aerostatic",
    "aerostaticul": "aerostatic",
    "aerostaticului": "aerostatic",
    "aerostatica": "aerostatică",
    "aerostaticele": "aerostatică",
    "aerostatici": "aerostatică",
    "aerostaticii": "aerostatică",
    "aerostaticilor": "aerostatică",
    "afabila": "afabil",
    "afabilă": "afabil",
    "afabile": "afabil",
    "afabilei": "afabil",
    "afabilele": "afabil",
    "afabilelor": "afabil",
    "afabili": "afabil",
    "afabilii": "afabil",
    "afabililor": "afabil",
    "afabilul": "afabil",
    "afabilului": "afabil",
    "afacerea": "afacere",
    "afaceri": "afacere",
    "afacerii": "afacere",
    "afacerile": "afacere",
    "afacerilor": "afacere",
    "afaceriști": "afacerist",
    "afaceriștii": "afacerist",
    "afaceriștilor": "afacerist",
    "afaceristul": "afacerist",
    "afaceristului": "afacerist",
    "afacerista": "afaceristă",
    "afaceriste": "afaceristă",
    "afaceristei": "afaceristă",
    "afaceristele": "afaceristă",
    "afaceristelor": "afaceristă",
    "afână": "afâna",
    "afânai": "afâna",
    "afânam": "afâna",
    "afânăm": "afâna",
    "afânând": "afâna",
    "afânându": "afâna",
    "afânară": "afâna",
    "afânarăm": "afâna",
    "afânarăți": "afâna",
    "afânase": "afâna",
    "afânasem": "afâna",
    "afânaseră": "afâna",
    "afânaserăm": "afâna",
    "afânaserăți": "afâna",
    "afânaseși": "afâna",
    "afânași": "afâna",
    "afânat": "afâna",
    "afânați": "afâna",
    "afânatu": "afâna",
    "afânau": "afâna",
    "afânează": "afâna",
    "afânez": "afâna",
    "afâneze": "afâna",
    "afânezi": "afâna",
    "neafânând": "afâna",
    "neafânându": "afâna",
    "nemaiafânând": "afâna",
    "nemaiafânându": "afâna",
    "afânarea": "afânare",
    "afânări": "afânare",
    "afânării": "afânare",
    "afânările": "afânare",
    "afânata": "afânat",
    "afânată": "afânat",
    "afânate": "afânat",
    "afânatei": "afânat",
    "afânatele": "afânat",
    "afânatelor": "afânat",
    "afânați": "afânat",
    "afânații": "afânat",
    "afânaților": "afânat",
    "afânatul": "afânat",
    "afânatului": "afânat",
    "afânătoare": "afânător",
    "afânătoarele": "afânător",
    "afânătoarelor": "afânător",
    "afânători": "afânător",
    "afânătorii": "afânător",
    "afânătorilor": "afânător",
    "afânătorul": "afânător",
    "afânătorului": "afânător",
    "afazica": "afazic",
    "afazică": "afazic",
    "afazice": "afazic",
    "afazicei": "afazic",
    "afazicele": "afazic",
    "afazicelor": "afazic",
    "afazici": "afazic",
    "afazicii": "afazic",
    "afazicilor": "afazic",
    "afazicul": "afazic",
    "afazicului": "afazic",
    "afazia": "afazie",
    "afaziei": "afazie",
    "afazii": "afazie",
    "afaziile": "afazie",
    "afaziilor": "afazie",
    "afecte": "afect",
    "afectele": "afect",
    "afectelor": "afect",
    "afectul": "afect",
    "afectului": "afect",
    "afectă": "afecta",
    "afectai": "afecta",
    "afectam": "afecta",
    "afectăm": "afecta",
    "afectând": "afecta",
    "afectându": "afecta",
    "afectară": "afecta",
    "afectarăm": "afecta",
    "afectarăți": "afecta",
    "afectase": "afecta",
    "afectasem": "afecta",
    "afectaseră": "afecta",
    "afectaserăm": "afecta",
    "afectaserăți": "afecta",
    "afectaseși": "afecta",
    "afectași": "afecta",
    "afectat": "afecta",
    "afectați": "afecta",
    "afectatu": "afecta",
    "afectau": "afecta",
    "afectează": "afecta",
    "afectez": "afecta",
    "afecteze": "afecta",
    "afectezi": "afecta",
    "neafectând": "afecta",
    "neafectându": "afecta",
    "nemaiafectând": "afecta",
    "nemaiafectându": "afecta",
    "afectarea": "afectare",
    "afectări": "afectare",
    "afectării": "afectare",
    "afectările": "afectare",
    "afectata": "afectat",
    "afectată": "afectat",
    "afectate": "afectat",
    "afectatei": "afectat",
    "afectatele": "afectat",
    "afectatelor": "afectat",
    "afectați": "afectat",
    "afectații": "afectat",
    "afectaților": "afectat",
    "afectatul": "afectat",
    "afectatului": "afectat",
    "afecțiunea": "afecțiune",
    "afecțiuni": "afecțiune",
    "afecțiunii": "afecțiune",
    "afecțiunile": "afecțiune",
    "afecțiunilor": "afecțiune",
    "afectiva": "afectiv",
    "afectivă": "afectiv",
    "afective": "afectiv",
    "afectivei": "afectiv",
    "afectivele": "afectiv",
    "afectivelor": "afectiv",
    "afectivi": "afectiv",
    "afectivii": "afectiv",
    "afectivilor": "afectiv",
    "afectivul": "afectiv",
    "afectivului": "afectiv",
    "afectivitatea": "afectivitate",
    "afectivități": "afectivitate",
    "afectivității": "afectivitate",
    "afectivitățile": "afectivitate",
    "afectivităților": "afectivitate",
    "afectuoasa": "afectuos",
    "afectuoasă": "afectuos",
    "afectuoase": "afectuos",
    "afectuoasei": "afectuos",
    "afectuoasele": "afectuos",
    "afectuoaselor": "afectuos",
    "afectuoși": "afectuos",
    "afectuoșii": "afectuos",
    "afectuoșilor": "afectuos",
    "afectuosul": "afectuos",
    "afectuosului": "afectuos",
    "afemeiați": "afemeiat",
    "afemeiații": "afemeiat",
    "afemeiaților": "afemeiat",
    "afemeiatul": "afemeiat",
    "afemeiatului": "afemeiat",
    "aferata": "aferat",
    "aferată": "aferat",
    "aferate": "aferat",
    "aferatei": "aferat",
    "aferatele": "aferat",
    "aferatelor": "aferat",
    "aferați": "aferat",
    "aferații": "aferat",
    "aferaților": "aferat",
    "aferatul": "aferat",
    "aferatului": "aferat",
    "aferenta": "aferent",
    "aferentă": "aferent",
    "aferente": "aferent",
    "aferentei": "aferent",
    "aferentele": "aferent",
    "aferentelor": "aferent",
    "aferenți": "aferent",
    "aferenții": "aferent",
    "aferenților": "aferent",
    "aferentul": "aferent",
    "aferentului": "aferent",
    "afereza": "afereză",
    "afereze": "afereză",
    "aferezei": "afereză",
    "aferezele": "afereză",
    "aferezelor": "afereză",
    "afetul": "afet",
    "afetului": "afet",
    "afeturi": "afet",
    "afeturile": "afet",
    "afeturilor": "afet",
    "afiliai": "afilia",
    "afiliam": "afilia",
    "afiliară": "afilia",
    "afiliarăm": "afilia",
    "afiliarăți": "afilia",
    "afiliase": "afilia",
    "afiliasem": "afilia",
    "afiliaseră": "afilia",
    "afiliaserăm": "afilia",
    "afiliaserăți": "afilia",
    "afiliaseși": "afilia",
    "afiliași": "afilia",
    "afiliat": "afilia",
    "afiliați": "afilia",
    "afiliatu": "afilia",
    "afiliau": "afilia",
    "afiliază": "afilia",
    "afilie": "afilia",
    "afiliem": "afilia",
    "afiliez": "afilia",
    "afilieze": "afilia",
    "afiliezi": "afilia",
    "afiliind": "afilia",
    "afiliindu": "afilia",
    "neafiliind": "afilia",
    "neafiliindu": "afilia",
    "nemaiafiliind": "afilia",
    "nemaiafiliindu": "afilia",
    "afiliata": "afiliat",
    "afiliată": "afiliat",
    "afiliate": "afiliat",
    "afiliatei": "afiliat",
    "afiliatele": "afiliat",
    "afiliatelor": "afiliat",
    "afiliați": "afiliat",
    "afiliații": "afiliat",
    "afiliaților": "afiliat",
    "afiliatul": "afiliat",
    "afiliatului": "afiliat",
    "afiliata": "afiliată",
    "afiliate": "afiliată",
    "afiliatei": "afiliată",
    "afiliatele": "afiliată",
    "afiliatelor": "afiliată",
    "afilierea": "afiliere",
    "afilieri": "afiliere",
    "afilierii": "afiliere",
    "afilierile": "afiliere",
    "afina": "afină",
    "afine": "afină",
    "afinei": "afină",
    "afinele": "afină",
    "afinelor": "afină",
    "afinitatea": "afinitate",
    "afinități": "afinitate",
    "afinității": "afinitate",
    "afinitățile": "afinitate",
    "afinităților": "afinitate",
    "afirm": "afirma",
    "afirmă": "afirma",
    "afirmai": "afirma",
    "afirmam": "afirma",
    "afirmăm": "afirma",
    "afirmând": "afirma",
    "afirmându": "afirma",
    "afirmară": "afirma",
    "afirmarăm": "afirma",
    "afirmarăți": "afirma",
    "afirmase": "afirma",
    "afirmasem": "afirma",
    "afirmaseră": "afirma",
    "afirmaserăm": "afirma",
    "afirmaserăți": "afirma",
    "afirmaseși": "afirma",
    "afirmași": "afirma",
    "afirmat": "afirma",
    "afirmați": "afirma",
    "afirmatu": "afirma",
    "afirmau": "afirma",
    "afirme": "afirma",
    "afirmi": "afirma",
    "neafirmând": "afirma",
    "neafirmându": "afirma",
    "nemaiafirmând": "afirma",
    "nemaiafirmându": "afirma",
    "afirmarea": "afirmare",
    "afirmări": "afirmare",
    "afirmării": "afirmare",
    "afirmările": "afirmare",
    "afirmata": "afirmat",
    "afirmată": "afirmat",
    "afirmate": "afirmat",
    "afirmatei": "afirmat",
    "afirmatele": "afirmat",
    "afirmatelor": "afirmat",
    "afirmați": "afirmat",
    "afirmații": "afirmat",
    "afirmaților": "afirmat",
    "afirmatul": "afirmat",
    "afirmatului": "afirmat",
    "afirmația": "afirmație",
    "afirmației": "afirmație",
    "afirmații": "afirmație",
    "afirmațiile": "afirmație",
    "afirmațiilor": "afirmație",
    "afirmativa": "afirmativ",
    "afirmativă": "afirmativ",
    "afirmative": "afirmativ",
    "afirmativei": "afirmativ",
    "afirmativele": "afirmativ",
    "afirmativelor": "afirmativ",
    "afirmativi": "afirmativ",
    "afirmativii": "afirmativ",
    "afirmativilor": "afirmativ",
    "afirmativul": "afirmativ",
    "afirmativului": "afirmativ",
    "afișe": "afiș",
    "afișele": "afiș",
    "afișelor": "afiș",
    "afișul": "afiș",
    "afișului": "afiș",
    "afișă": "afișa",
    "afișai": "afișa",
    "afișam": "afișa",
    "afișăm": "afișa",
    "afișând": "afișa",
    "afișându": "afișa",
    "afișară": "afișa",
    "afișarăm": "afișa",
    "afișarăți": "afișa",
    "afișase": "afișa",
    "afișasem": "afișa",
    "afișaseră": "afișa",
    "afișaserăm": "afișa",
    "afișaserăți": "afișa",
    "afișaseși": "afișa",
    "afișași": "afișa",
    "afișat": "afișa",
    "afișați": "afișa",
    "afișatu": "afișa",
    "afișau": "afișa",
    "afișează": "afișa",
    "afișez": "afișa",
    "afișeze": "afișa",
    "afișezi": "afișa",
    "neafișând": "afișa",
    "neafișându": "afișa",
    "nemaiafișând": "afișa",
    "nemaiafișându": "afișa",
    "afișaje": "afișaj",
    "afișajele": "afișaj",
    "afișajelor": "afișaj",
    "afișajul": "afișaj",
    "afișajului": "afișaj",
    "afișarea": "afișare",
    "afișări": "afișare",
    "afișării": "afișare",
    "afișările": "afișare",
    "afișata": "afișat",
    "afișată": "afișat",
    "afișate": "afișat",
    "afișatei": "afișat",
    "afișatele": "afișat",
    "afișatelor": "afișat",
    "afișați": "afișat",
    "afișații": "afișat",
    "afișaților": "afișat",
    "afișatul": "afișat",
    "afișatului": "afișat",
    "afișiere": "afișier",
    "afișierele": "afișier",
    "afișierelor": "afișier",
    "afișierul": "afișier",
    "afișierului": "afișier",
    "afixe": "afix",
    "afixele": "afix",
    "afixelor": "afix",
    "afixul": "afix",
    "afixului": "afix",
    "află": "afla",
    "aflai": "afla",
    "aflam": "afla",
    "aflăm": "afla",
    "aflând": "afla",
    "aflându": "afla",
    "aflară": "afla",
    "aflarăm": "afla",
    "aflarăți": "afla",
    "aflase": "afla",
    "aflasem": "afla",
    "aflaseră": "afla",
    "aflaserăm": "afla",
    "aflaserăți": "afla",
    "aflaseși": "afla",
    "aflași": "afla",
    "aflat": "afla",
    "aflați": "afla",
    "aflatu": "afla",
    "aflau": "afla",
    "afle": "afla",
    "afli": "afla",
    "aflu": "afla",
    "neaflând": "afla",
    "neaflându": "afla",
    "nemaiaflând": "afla",
    "nemaiaflându": "afla",
    "aflarea": "aflare",
    "aflări": "aflare",
    "aflării": "aflare",
    "aflările": "aflare",
    "aflata": "aflat",
    "aflată": "aflat",
    "aflate": "aflat",
    "aflatei": "aflat",
    "aflatele": "aflat",
    "aflatelor": "aflat",
    "aflați": "aflat",
    "aflații": "aflat",
    "aflaților": "aflat",
    "aflatul": "aflat",
    "aflatului": "aflat",
    "aflătoare": "aflător",
    "aflătoarea": "aflător",
    "aflătoarei": "aflător",
    "aflătoarele": "aflător",
    "aflătoarelor": "aflător",
    "aflători": "aflător",
    "aflătorii": "aflător",
    "aflătorilor": "aflător",
    "aflătorul": "aflător",
    "aflătorului": "aflător",
    "afluenți": "afluent",
    "afluenții": "afluent",
    "afluenților": "afluent",
    "afluentul": "afluent",
    "afluentului": "afluent",
    "afluența": "afluență",
    "afluențe": "afluență",
    "afluenței": "afluență",
    "afluențele": "afluență",
    "afluențelor": "afluență",
    "afluxul": "aflux",
    "afluxului": "aflux",
    "afluxuri": "aflux",
    "afluxurile": "aflux",
    "afluxurilor": "aflux",
    "afocale": "afocal",
    "afocalele": "afocal",
    "afocalelor": "afocal",
    "afocalul": "afocal",
    "afocalului": "afocal",
    "afona": "afon",
    "afonă": "afon",
    "afone": "afon",
    "afonei": "afon",
    "afonele": "afon",
    "afonelor": "afon",
    "afoni": "afon",
    "afonii": "afon",
    "afonilor": "afon",
    "afonul": "afon",
    "afonului": "afon",
    "aforisme": "aforism",
    "aforismele": "aforism",
    "aforismelor": "aforism",
    "aforismul": "aforism",
    "aforismului": "aforism",
    "aforistica": "aforistic",
    "aforistică": "aforistic",
    "aforistice": "aforistic",
    "aforisticei": "aforistic",
    "aforisticele": "aforistic",
    "aforisticelor": "aforistic",
    "aforistici": "aforistic",
    "aforisticii": "aforistic",
    "aforisticilor": "aforistic",
    "aforisticul": "aforistic",
    "aforisticului": "aforistic",
    "Africă": "Africa",
    "Africi": "Africa",
    "Africii": "Africa",
    "africana": "african",
    "africană": "african",
    "africane": "african",
    "africanei": "african",
    "africanele": "african",
    "africanelor": "african",
    "africani": "african",
    "africanii": "african",
    "africanilor": "african",
    "africanul": "african",
    "africanului": "african",
    "Afrodită": "Afrodita",
    "Afrodite": "Afrodita",
    "Afroditei": "Afrodita",
    "afrodiziaca": "afrodiziac",
    "afrodiziacă": "afrodiziac",
    "afrodiziace": "afrodiziac",
    "afrodiziacei": "afrodiziac",
    "afrodiziacele": "afrodiziac",
    "afrodiziacelor": "afrodiziac",
    "afrodiziaci": "afrodiziac",
    "afrodiziacii": "afrodiziac",
    "afrodiziacilor": "afrodiziac",
    "afrodiziacul": "afrodiziac",
    "afrodiziacului": "afrodiziac",
    "afrontul": "afront",
    "afrontului": "afront",
    "afronturi": "afront",
    "afronturile": "afront",
    "afronturilor": "afront",
    "afta": "aftă",
    "afte": "aftă",
    "aftei": "aftă",
    "aftele": "aftă",
    "aftelor": "aftă",
    "afum": "afuma",
    "afumă": "afuma",
    "afumai": "afuma",
    "afumam": "afuma",
    "afumăm": "afuma",
    "afumând": "afuma",
    "afumându": "afuma",
    "afumară": "afuma",
    "afumarăm": "afuma",
    "afumarăți": "afuma",
    "afumase": "afuma",
    "afumasem": "afuma",
    "afumaseră": "afuma",
    "afumaserăm": "afuma",
    "afumaserăți": "afuma",
    "afumaseși": "afuma",
    "afumași": "afuma",
    "afumat": "afuma",
    "afumați": "afuma",
    "afumatu": "afuma",
    "afumau": "afuma",
    "afume": "afuma",
    "afumi": "afuma",
    "afumată": "afumat",
    "afumate": "afumat",
    "afumați": "afumat",
    "afunda": "afund",
    "afundă": "afund",
    "afunde": "afund",
    "afundei": "afund",
    "afundele": "afund",
    "afundelor": "afund",
    "afundul": "afund",
    "afundului": "afund",
    "afunzi": "afund",
    "afunzii": "afund",
    "afunzilor": "afund",
    "afund": "afunda",
    "afundă": "afunda",
    "afundai": "afunda",
    "afundam": "afunda",
    "afundăm": "afunda",
    "afundând": "afunda",
    "afundându": "afunda",
    "afundară": "afunda",
    "afundarăm": "afunda",
    "afundarăți": "afunda",
    "afundase": "afunda",
    "afundasem": "afunda",
    "afundaseră": "afunda",
    "afundaserăm": "afunda",
    "afundaserăți": "afunda",
    "afundaseși": "afunda",
    "afundași": "afunda",
    "afundat": "afunda",
    "afundați": "afunda",
    "afundatu": "afunda",
    "afundau": "afunda",
    "afunde": "afunda",
    "afunzi": "afunda",
    "neafundând": "afunda",
    "neafundându": "afunda",
    "nemaiafundând": "afunda",
    "nemaiafundându": "afunda",
    "afundarea": "afundare",
    "afundări": "afundare",
    "afundării": "afundare",
    "afundările": "afundare",
    "afundata": "afundat",
    "afundată": "afundat",
    "afundate": "afundat",
    "afundatei": "afundat",
    "afundatele": "afundat",
    "afundatelor": "afundat",
    "afundați": "afundat",
    "afundații": "afundat",
    "afundaților": "afundat",
    "afundatul": "afundat",
    "afundatului": "afundat",
    "afundătura": "afundătură",
    "afundături": "afundătură",
    "afundăturii": "afundătură",
    "afundăturile": "afundătură",
    "afundăturilor": "afundătură",
    "afurisiți": "afurisit",
    "aga": "agă",
    "agapelor": "agă",
    "agi": "agă",
    "agii": "agă",
    "agilor": "agă",
    "agapa": "agapă",
    "agape": "agapă",
    "agapei": "agapă",
    "agapele": "agapă",
    "agasă": "agasa",
    "agasai": "agasa",
    "agasam": "agasa",
    "agasăm": "agasa",
    "agasând": "agasa",
    "agasându": "agasa",
    "agasară": "agasa",
    "agasarăm": "agasa",
    "agasarăți": "agasa",
    "agasase": "agasa",
    "agasasem": "agasa",
    "agasaseră": "agasa",
    "agasaserăm": "agasa",
    "agasaserăți": "agasa",
    "agasaseși": "agasa",
    "agasași": "agasa",
    "agasat": "agasa",
    "agasați": "agasa",
    "agasatu": "agasa",
    "agasau": "agasa",
    "agasează": "agasa",
    "agasez": "agasa",
    "agaseze": "agasa",
    "agasezi": "agasa",
    "neagasând": "agasa",
    "neagasându": "agasa",
    "nemaiagasând": "agasa",
    "nemaiagasându": "agasa",
    "agasanta": "agasant",
    "agasantă": "agasant",
    "agasante": "agasant",
    "agasantei": "agasant",
    "agasantele": "agasant",
    "agasantelor": "agasant",
    "agasanți": "agasant",
    "agasanții": "agasant",
    "agasantul": "agasant",
    "agasantului": "agasant",
    "agasarea": "agasare",
    "agasări": "agasare",
    "agasării": "agasare",
    "agasările": "agasare",
    "agasanților": "agasat",
    "agasata": "agasat",
    "agasată": "agasat",
    "agasate": "agasat",
    "agasatei": "agasat",
    "agasatele": "agasat",
    "agasatelor": "agasat",
    "agasați": "agasat",
    "agasații": "agasat",
    "agasaților": "agasat",
    "agasatul": "agasat",
    "agasatului": "agasat",
    "agate": "agat",
    "agatele": "agat",
    "agatelor": "agat",
    "agatul": "agat",
    "agatului": "agat",
    "agăț": "agăța",
    "agață": "agăța",
    "agăță": "agăța",
    "agățai": "agăța",
    "agățam": "agăța",
    "agățăm": "agăța",
    "agățând": "agăța",
    "agățându": "agăța",
    "agățară": "agăța",
    "agățarăm": "agăța",
    "agățarăți": "agăța",
    "agățase": "agăța",
    "agățasem": "agăța",
    "agățaseră": "agăța",
    "agățaserăm": "agăța",
    "agățaserăți": "agăța",
    "agățaseși": "agăța",
    "agățași": "agăța",
    "agățat": "agăța",
    "agățați": "agăța",
    "agățatu": "agăța",
    "agățau": "agăța",
    "agațe": "agăța",
    "agăți": "agăța",
    "neagățând": "agăța",
    "neagățându": "agăța",
    "nemaiagățând": "agăța",
    "nemaiagățându": "agăța",
    "agățarea": "agățare",
    "agățări": "agățare",
    "agățării": "agățare",
    "agățările": "agățare",
    "agățata": "agățat",
    "agățată": "agățat",
    "agățate": "agățat",
    "agățatei": "agățat",
    "agățatele": "agățat",
    "agățatelor": "agățat",
    "agățați": "agățat",
    "agățații": "agățat",
    "agățaților": "agățat",
    "agățatul": "agățat",
    "agățatului": "agățat",
    "agățătoarea": "agățătoare",
    "agățătoarei": "agățătoare",
    "agățătoarele": "agățătoare",
    "agățătoarelor": "agățătoare",
    "agățătoare": "agățător",
    "agățătoarea": "agățător",
    "agățătoarei": "agățător",
    "agățătoarele": "agățător",
    "agățătoarelor": "agățător",
    "agățători": "agățător",
    "agățătorii": "agățător",
    "agățătorilor": "agățător",
    "agățătorul": "agățător",
    "agățătorului": "agățător",
    "ageamia": "ageamie",
    "ageamiei": "ageamie",
    "ageamii": "ageamie",
    "ageamiile": "ageamie",
    "ageamiilor": "ageamie",
    "ageamie": "ageamiu",
    "ageamiei": "ageamiu",
    "ageamii": "ageamiu",
    "ageamiii": "ageamiu",
    "ageamiile": "ageamiu",
    "ageamiilor": "ageamiu",
    "ageamiul": "ageamiu",
    "ageamiului": "ageamiu",
    "agenda": "agendă",
    "agende": "agendă",
    "agendei": "agendă",
    "agendele": "agendă",
    "agendelor": "agendă",
    "agenți": "agent",
    "agenții": "agent",
    "agenților": "agent",
    "agentul": "agent",
    "agentului": "agent",
    "agenta": "agentă",
    "agente": "agentă",
    "agentei": "agentă",
    "agentele": "agentă",
    "agentelor": "agentă",
    "C.I.A.": "Agenția_Centrală_de_Informații",
    "agenția": "agenție",
    "agenției": "agenție",
    "agenții": "agenție",
    "agențiile": "agenție",
    "agențiilor": "agenție",
    "agentura": "agentură",
    "agenturi": "agentură",
    "agenturii": "agentură",
    "agenturile": "agentură",
    "agenturilor": "agentură",
    "agera": "ager",
    "ageră": "ager",
    "agere": "ager",
    "agerei": "ager",
    "agerele": "ager",
    "agerelor": "ager",
    "ageri": "ager",
    "agerii": "ager",
    "agerilor": "ager",
    "agerul": "ager",
    "agerului": "ager",
    "agerimea": "agerime",
    "agerimi": "agerime",
    "agerimii": "agerime",
    "agerimile": "agerime",
    "agerimilor": "agerime",
    "agia": "agie",
    "agiei": "agie",
    "agii": "agie",
    "agiile": "agie",
    "agiilor": "agie",
    "agila": "agil",
    "agilă": "agil",
    "agile": "agil",
    "agilei": "agil",
    "agilele": "agil",
    "agilelor": "agil",
    "agili": "agil",
    "agilii": "agil",
    "agililor": "agil",
    "agilul": "agil",
    "agilului": "agil",
    "agit": "agita",
    "agită": "agita",
    "agitai": "agita",
    "agitam": "agita",
    "agităm": "agita",
    "agitând": "agita",
    "agitându": "agita",
    "agitară": "agita",
    "agitarăm": "agita",
    "agitarăți": "agita",
    "agitase": "agita",
    "agitasem": "agita",
    "agitaseră": "agita",
    "agitaserăm": "agita",
    "agitaserăți": "agita",
    "agitaseși": "agita",
    "agitași": "agita",
    "agitat": "agita",
    "agitați": "agita",
    "agitatu": "agita",
    "agitau": "agita",
    "agite": "agita",
    "agiți": "agita",
    "neagitând": "agita",
    "neagitându": "agita",
    "nemaiagitând": "agita",
    "nemaiagitându": "agita",
    "agitarea": "agitare",
    "agitări": "agitare",
    "agitării": "agitare",
    "agitările": "agitare",
    "agitata": "agitat",
    "agitată": "agitat",
    "agitate": "agitat",
    "agitatei": "agitat",
    "agitatele": "agitat",
    "agitatelor": "agitat",
    "agitați": "agitat",
    "agitații": "agitat",
    "agitaților": "agitat",
    "agitatul": "agitat",
    "agitatului": "agitat",
    "agitata": "agitată",
    "agitate": "agitată",
    "agitatei": "agitată",
    "agitatele": "agitată",
    "agitatelor": "agitată",
    "agitația": "agitație",
    "agitației": "agitație",
    "agitații": "agitație",
    "agitațiile": "agitație",
    "agitațiilor": "agitație",
    "agitatoarea": "agitatoare",
    "agitatoarei": "agitatoare",
    "agitatoarele": "agitatoare",
    "agitatoarelor": "agitatoare",
    "agitatori": "agitator",
    "agitatorii": "agitator",
    "agitatorilor": "agitator",
    "agitatorul": "agitator",
    "agitatorului": "agitator",
    "agitatorica": "agitatoric",
    "agitatorică": "agitatoric",
    "agitatorice": "agitatoric",
    "agitatoricei": "agitatoric",
    "agitatoricele": "agitatoric",
    "agitatoricelor": "agitatoric",
    "agitatorici": "agitatoric",
    "agitatoricii": "agitatoric",
    "agitatoricilor": "agitatoric",
    "agitatoricul": "agitatoric",
    "agitatoricului": "agitatoric",
    "aglomeră": "aglomera",
    "aglomerai": "aglomera",
    "aglomeram": "aglomera",
    "aglomerăm": "aglomera",
    "aglomerând": "aglomera",
    "aglomerându": "aglomera",
    "aglomerară": "aglomera",
    "aglomerarăm": "aglomera",
    "aglomerarăți": "aglomera",
    "aglomerase": "aglomera",
    "aglomerasem": "aglomera",
    "aglomeraseră": "aglomera",
    "aglomeraserăm": "aglomera",
    "aglomeraserăți": "aglomera",
    "aglomeraseși": "aglomera",
    "aglomerași": "aglomera",
    "aglomerat": "aglomera",
    "aglomerați": "aglomera",
    "aglomeratu": "aglomera",
    "aglomerau": "aglomera",
    "aglomerează": "aglomera",
    "aglomerez": "aglomera",
    "aglomereze": "aglomera",
    "aglomerezi": "aglomera",
    "neaglomerând": "aglomera",
    "neaglomerându": "aglomera",
    "nemaiaglomerând": "aglomera",
    "nemaiaglomerându": "aglomera",
    "aglomerarea": "aglomerare",
    "aglomerări": "aglomerare",
    "aglomerării": "aglomerare",
    "aglomerările": "aglomerare",
    "aglomerata": "aglomerat",
    "aglomerată": "aglomerat",
    "aglomerate": "aglomerat",
    "aglomeratei": "aglomerat",
    "aglomeratele": "aglomerat",
    "aglomeratelor": "aglomerat",
    "aglomerați": "aglomerat",
    "aglomerații": "aglomerat",
    "aglomeraților": "aglomerat",
    "aglomeratul": "aglomerat",
    "aglomeratului": "aglomerat",
    "aglomerația": "aglomerație",
    "aglomerației": "aglomerație",
    "aglomerații": "aglomerație",
    "aglomerațiile": "aglomerație",
    "aglomerațiilor": "aglomerație",
    "aglutină": "aglutina",
    "aglutinai": "aglutina",
    "aglutinam": "aglutina",
    "aglutinăm": "aglutina",
    "aglutinând": "aglutina",
    "aglutinându": "aglutina",
    "aglutinară": "aglutina",
    "aglutinarăm": "aglutina",
    "aglutinarăți": "aglutina",
    "aglutinase": "aglutina",
    "aglutinasem": "aglutina",
    "aglutinaserăm": "aglutina",
    "aglutinaserăți": "aglutina",
    "aglutinaseși": "aglutina",
    "aglutinași": "aglutina",
    "aglutinat": "aglutina",
    "aglutinați": "aglutina",
    "aglutinatu": "aglutina",
    "aglutinau": "aglutina",
    "aglutinează": "aglutina",
    "aglutinez": "aglutina",
    "aglutineze": "aglutina",
    "aglutinezi": "aglutina",
    "neaglutinând": "aglutina",
    "neaglutinându": "aglutina",
    "nemaiaglutinând": "aglutina",
    "nemaiaglutinându": "aglutina",
    "aglutinanta": "aglutinant",
    "aglutinantă": "aglutinant",
    "aglutinante": "aglutinant",
    "aglutinantei": "aglutinant",
    "aglutinantele": "aglutinant",
    "aglutinantelor": "aglutinant",
    "aglutinanți": "aglutinant",
    "aglutinanții": "aglutinant",
    "aglutinanților": "aglutinant",
    "aglutinantul": "aglutinant",
    "aglutinantului": "aglutinant",
    "aglutinarea": "aglutinare",
    "aglutinări": "aglutinare",
    "aglutinării": "aglutinare",
    "aglutinările": "aglutinare",
    "aglutinata": "aglutinat",
    "aglutinate": "aglutinat",
    "aglutinați": "aglutinat",
    "aglutinații": "aglutinat",
    "aglutinaților": "aglutinat",
    "aglutinatul": "aglutinat",
    "aglutinatului": "aglutinat",
    "agnostica": "agnostic",
    "agnostice": "agnostic",
    "agnosticei": "agnostic",
    "agnosticele": "agnostic",
    "agnosticelor": "agnostic",
    "agnostici": "agnostic",
    "agnosticii": "agnostic",
    "agnosticilor": "agnostic",
    "agnosticul": "agnostic",
    "agnosticului": "agnostic",
    "agnosticisme": "agnosticism",
    "agnosticismele": "agnosticism",
    "agnosticismelor": "agnosticism",
    "agnosticismul": "agnosticism",
    "agnosticismului": "agnosticism",
    "agonica": "agonic",
    "agonică": "agonic",
    "agonice": "agonic",
    "agonicei": "agonic",
    "agonicele": "agonic",
    "agonicelor": "agonic",
    "agonici": "agonic",
    "agonicii": "agonic",
    "agonicilor": "agonic",
    "agonicul": "agonic",
    "agonicului": "agonic",
    "agonia": "agonie",
    "agoniei": "agonie",
    "agonii": "agonie",
    "agoniile": "agonie",
    "agoniilor": "agonie",
    "agoniseala": "agoniseală",
    "agoniseli": "agoniseală",
    "agoniselii": "agoniseală",
    "agoniselile": "agoniseală",
    "agoniselilor": "agoniseală",
    "agonisea": "agonisi",
    "agoniseai": "agonisi",
    "agoniseam": "agonisi",
    "agonisească": "agonisi",
    "agoniseați": "agonisi",
    "agoniseau": "agonisi",
    "agonisesc": "agonisi",
    "agonisește": "agonisi",
    "agonisești": "agonisi",
    "agonisii": "agonisi",
    "agonisim": "agonisi",
    "agonisind": "agonisi",
    "agonisindu": "agonisi",
    "agonisiră": "agonisi",
    "agonisirăm": "agonisi",
    "agonisirăți": "agonisi",
    "agonisise": "agonisi",
    "agonisisem": "agonisi",
    "agonisiseră": "agonisi",
    "agonisiserăm": "agonisi",
    "agonisiserăți": "agonisi",
    "agonisiseși": "agonisi",
    "agonisiși": "agonisi",
    "agonisit": "agonisi",
    "agonisiți": "agonisi",
    "agonisitu": "agonisi",
    "neagonisind": "agonisi",
    "neagonisindu": "agonisi",
    "nemaiagonisind": "agonisi",
    "nemaiagonisindu": "agonisi",
    "agonisirea": "agonisire",
    "agonisiri": "agonisire",
    "agonisirii": "agonisire",
    "agonisirile": "agonisire",
    "agonisita": "agonisit",
    "agonisită": "agonisit",
    "agonisite": "agonisit",
    "agonisitei": "agonisit",
    "agonisitele": "agonisit",
    "agonisitelor": "agonisit",
    "agonisiți": "agonisit",
    "agonisiții": "agonisit",
    "agonisiților": "agonisit",
    "agonisitul": "agonisit",
    "agonisitului": "agonisit",
    "agoniză": "agoniza",
    "agonizai": "agoniza",
    "agonizam": "agoniza",
    "agonizăm": "agoniza",
    "agonizând": "agoniza",
    "agonizându": "agoniza",
    "agonizară": "agoniza",
    "agonizarăm": "agoniza",
    "agonizarăți": "agoniza",
    "agonizase": "agoniza",
    "agonizasem": "agoniza",
    "agonizaseră": "agoniza",
    "agonizaserăm": "agoniza",
    "agonizaserăți": "agoniza",
    "agonizaseși": "agoniza",
    "agonizași": "agoniza",
    "agonizat": "agoniza",
    "agonizați": "agoniza",
    "agonizatu": "agoniza",
    "agonizau": "agoniza",
    "agonizează": "agoniza",
    "agonizez": "agoniza",
    "agonizeze": "agoniza",
    "agonizezi": "agoniza",
    "neagonizând": "agoniza",
    "neagonizându": "agoniza",
    "nemaiagonizând": "agoniza",
    "nemaiagonizându": "agoniza",
    "agonizanta": "agonizant",
    "agonizantă": "agonizant",
    "agonizante": "agonizant",
    "agonizantei": "agonizant",
    "agonizantele": "agonizant",
    "agonizantelor": "agonizant",
    "agonizanți": "agonizant",
    "agonizanții": "agonizant",
    "agonizanților": "agonizant",
    "agonizantul": "agonizant",
    "agonizantului": "agonizant",
    "agonizată": "agonizat",
    "agonizate": "agonizat",
    "agonizați": "agonizat",
    "agramata": "agramat",
    "agramată": "agramat",
    "agramate": "agramat",
    "agramatei": "agramat",
    "agramatele": "agramat",
    "agramatelor": "agramat",
    "agramați": "agramat",
    "agramații": "agramat",
    "agramaților": "agramat",
    "agramatul": "agramat",
    "agramatului": "agramat",
    "agramatisme": "agramatism",
    "agramatismele": "agramatism",
    "agramatismelor": "agramatism",
    "agramatismul": "agramatism",
    "agramatismului": "agramatism",
    "agrara": "agrar",
    "agrară": "agrar",
    "agrare": "agrar",
    "agrarei": "agrar",
    "agrarele": "agrar",
    "agrarelor": "agrar",
    "agrari": "agrar",
    "agrarii": "agrar",
    "agrarilor": "agrar",
    "agrarul": "agrar",
    "agrarului": "agrar",
    "agrariana": "agrarian",
    "agrariană": "agrarian",
    "agrarianul": "agrarian",
    "agrarianului": "agrarian",
    "agrariene": "agrarian",
    "agrarienei": "agrarian",
    "agrarienele": "agrarian",
    "agrarienelor": "agrarian",
    "agrarieni": "agrarian",
    "agrarienii": "agrarian",
    "agrarienilor": "agrarian",
    "agrariana": "agrariană",
    "agrariene": "agrariană",
    "agrarienei": "agrariană",
    "agrarienele": "agrariană",
    "agrarienelor": "agrariană",
    "agravă": "agrava",
    "agravai": "agrava",
    "agravam": "agrava",
    "agravăm": "agrava",
    "agravând": "agrava",
    "agravându": "agrava",
    "agravară": "agrava",
    "agravarăm": "agrava",
    "agravarăți": "agrava",
    "agravase": "agrava",
    "agravasem": "agrava",
    "agravaseră": "agrava",
    "agravaserăm": "agrava",
    "agravaserăți": "agrava",
    "agravaseși": "agrava",
    "agravași": "agrava",
    "agravat": "agrava",
    "agravați": "agrava",
    "agravatu": "agrava",
    "agravau": "agrava",
    "agravează": "agrava",
    "agravez": "agrava",
    "agraveze": "agrava",
    "agravezi": "agrava",
    "neagravând": "agrava",
    "neagravându": "agrava",
    "nemaiagravând": "agrava",
    "nemaiagravându": "agrava",
    "agravanta": "agravant",
    "agravantă": "agravant",
    "agravante": "agravant",
    "agravantei": "agravant",
    "agravantele": "agravant",
    "agravantelor": "agravant",
    "agravanți": "agravant",
    "agravanții": "agravant",
    "agravanților": "agravant",
    "agravantul": "agravant",
    "agravantului": "agravant",
    "agravarea": "agravare",
    "agravări": "agravare",
    "agravării": "agravare",
    "agravările": "agravare",
    "agravata": "agravat",
    "agravată": "agravat",
    "agravate": "agravat",
    "agravatei": "agravat",
    "agravatele": "agravat",
    "agravatelor": "agravat",
    "agravați": "agravat",
    "agravații": "agravat",
    "agravaților": "agravat",
    "agravatul": "agravat",
    "agravatului": "agravat",
    "agreă": "agrea",
    "agreai": "agrea",
    "agream": "agrea",
    "agreăm": "agrea",
    "agreară": "agrea",
    "agrearăm": "agrea",
    "agrearăți": "agrea",
    "agrease": "agrea",
    "agreasem": "agrea",
    "agreaseră": "agrea",
    "agreaserăm": "agrea",
    "agreaserăți": "agrea",
    "agreaseși": "agrea",
    "agreași": "agrea",
    "agreat": "agrea",
    "agreați": "agrea",
    "agreatu": "agrea",
    "agreau": "agrea",
    "agreează": "agrea",
    "agreez": "agrea",
    "agreeze": "agrea",
    "agreezi": "agrea",
    "agreind": "agrea",
    "agreindu": "agrea",
    "neagreând": "agrea",
    "neagreându": "agrea",
    "nemaiagreând": "agrea",
    "nemaiagreându": "agrea",
    "agreabilă": "agreabil",
    "agreabile": "agreabil",
    "agreabili": "agreabil",
    "agreata": "agreat",
    "agreată": "agreat",
    "agreate": "agreat",
    "agreatei": "agreat",
    "agreatele": "agreat",
    "agreatelor": "agreat",
    "agreați": "agreat",
    "agreații": "agreat",
    "agreaților": "agreat",
    "agreatul": "agreat",
    "agreatului": "agreat",
    "agreerea": "agreere",
    "agreeri": "agreere",
    "agreerii": "agreere",
    "agreerile": "agreere",
    "agreg": "agrega",
    "agregă": "agrega",
    "agregai": "agrega",
    "agregam": "agrega",
    "agregăm": "agrega",
    "agregând": "agrega",
    "agregându": "agrega",
    "agregară": "agrega",
    "agregarăm": "agrega",
    "agregarăți": "agrega",
    "agregase": "agrega",
    "agregasem": "agrega",
    "agregaseră": "agrega",
    "agregaserăm": "agrega",
    "agregaserăți": "agrega",
    "agregaseși": "agrega",
    "agregași": "agrega",
    "agregat": "agrega",
    "agregați": "agrega",
    "agregatu": "agrega",
    "agregau": "agrega",
    "agrege": "agrega",
    "agregi": "agrega",
    "neagregând": "agrega",
    "neagregându": "agrega",
    "nemaiagregând": "agrega",
    "nemaiagregându": "agrega",
    "agregarea": "agregare",
    "agregări": "agregare",
    "agregării": "agregare",
    "agregările": "agregare",
    "agregata": "agregat",
    "agregată": "agregat",
    "agregate": "agregat",
    "agregatei": "agregat",
    "agregatele": "agregat",
    "agregatelor": "agregat",
    "agregați": "agregat",
    "agregații": "agregat",
    "agregaților": "agregat",
    "agregatul": "agregat",
    "agregatului": "agregat",
    "agremente": "agrement",
    "agrementele": "agrement",
    "agrementelor": "agrement",
    "agrementul": "agrement",
    "agrementului": "agrement",
    "agresă": "agresa",
    "agresai": "agresa",
    "agresam": "agresa",
    "agresăm": "agresa",
    "agresând": "agresa",
    "agresându": "agresa",
    "agresară": "agresa",
    "agresarăm": "agresa",
    "agresarăți": "agresa",
    "agresase": "agresa",
    "agresasem": "agresa",
    "agresaseră": "agresa",
    "agresaserăm": "agresa",
    "agresaserăți": "agresa",
    "agresaseși": "agresa",
    "agresași": "agresa",
    "agresat": "agresa",
    "agresați": "agresa",
    "agresatu": "agresa",
    "agresau": "agresa",
    "agresează": "agresa",
    "agresez": "agresa",
    "agreseze": "agresa",
    "agresezi": "agresa",
    "agresarea": "agresare",
    "agresări": "agresare",
    "agresării": "agresare",
    "agresările": "agresare",
    "agresata": "agresat",
    "agresată": "agresat",
    "agresate": "agresat",
    "agresatei": "agresat",
    "agresatele": "agresat",
    "agresatelor": "agresat",
    "agresați": "agresat",
    "agresații": "agresat",
    "agresaților": "agresat",
    "agresatul": "agresat",
    "agresatului": "agresat",
    "agresiunea": "agresiune",
    "agresiuni": "agresiune",
    "agresiunii": "agresiune",
    "agresiunile": "agresiune",
    "agresiunilor": "agresiune",
    "agresiva": "agresiv",
    "agresivă": "agresiv",
    "agresive": "agresiv",
    "agresivei": "agresiv",
    "agresivele": "agresiv",
    "agresivelor": "agresiv",
    "agresivi": "agresiv",
    "agresivii": "agresiv",
    "agresivilor": "agresiv",
    "agresivul": "agresiv",
    "agresivului": "agresiv",
    "agresivitatea": "agresivitate",
    "agresivități": "agresivitate",
    "agresivității": "agresivitate",
    "agresivitățile": "agresivitate",
    "agresivităților": "agresivitate",
    "agresoarea": "agresoare",
    "agresoarei": "agresoare",
    "agresoarele": "agresoare",
    "agresoarelor": "agresoare",
    "agresori": "agresor",
    "agresorii": "agresor",
    "agresorilor": "agresor",
    "agresorul": "agresor",
    "agresorului": "agresor",
    "agricola": "agricol",
    "agricolă": "agricol",
    "agricole": "agricol",
    "agricolei": "agricol",
    "agricolele": "agricol",
    "agricolelor": "agricol",
    "agricoli": "agricol",
    "agricolii": "agricol",
    "agricolilor": "agricol",
    "agricolul": "agricol",
    "agricolului": "agricol",
    "agricultoarea": "agricultoare",
    "agricultoarei": "agricultoare",
    "agricultoarele": "agricultoare",
    "agricultoarelor": "agricultoare",
    "agricultori": "agricultor",
    "agricultorii": "agricultor",
    "agricultorilor": "agricultor",
    "agricultorul": "agricultor",
    "agricultorului": "agricultor",
    "agric.": "agricultură",
    "agricultura": "agricultură",
    "agriculturi": "agricultură",
    "agriculturii": "agricultură",
    "agriculturile": "agricultură",
    "agriculturilor": "agricultură",
    "Agripină": "Agripina",
    "Agripinei": "Agripina",
    "agroalimentară": "agroalimentar",
    "agroalimentare": "agroalimentar",
    "agroalimentari": "agroalimentar",
    "agroalimentarea": "agroalimentare",
    "agroalimentări": "agroalimentare",
    "agroalimentării": "agroalimentare",
    "agroalimentările": "agroalimentare",
    "agroalimentărilor": "agroalimentare",
    "agrobiologica": "agrobiologic",
    "agrobiologică": "agrobiologic",
    "agrobiologice": "agrobiologic",
    "agrobiologicei": "agrobiologic",
    "agrobiologicele": "agrobiologic",
    "agrobiologicelor": "agrobiologic",
    "agrobiologici": "agrobiologic",
    "agrobiologicii": "agrobiologic",
    "agrobiologicilor": "agrobiologic",
    "agrobiologicul": "agrobiologic",
    "agrobiologicului": "agrobiologic",
    "agr.": "agronom",
    "agronomi": "agronom",
    "agronomii": "agronom",
    "agronomilor": "agronom",
    "agronomul": "agronom",
    "agronomului": "agronom",
    "agronoma": "agronomă",
    "agronome": "agronomă",
    "agronomei": "agronomă",
    "agronomele": "agronomă",
    "agronomelor": "agronomă",
    "agronomica": "agronomic",
    "agronomică": "agronomic",
    "agronomice": "agronomic",
    "agronomicei": "agronomic",
    "agronomicele": "agronomic",
    "agronomicelor": "agronomic",
    "agronomici": "agronomic",
    "agronomicii": "agronomic",
    "agronomicilor": "agronomic",
    "agronomicul": "agronomic",
    "agronomicului": "agronomic",
    "agron.": "agronomie",
    "agronomia": "agronomie",
    "agronomiei": "agronomie",
    "agronomii": "agronomie",
    "agronomiile": "agronomie",
    "agronomiilor": "agronomie",
    "agrotehnica": "agrotehnic",
    "agrotehnică": "agrotehnic",
    "agrotehnice": "agrotehnic",
    "agrotehnicei": "agrotehnic",
    "agrotehnicele": "agrotehnic",
    "agrotehnicelor": "agrotehnic",
    "agrotehnici": "agrotehnic",
    "agrotehnicii": "agrotehnic",
    "agrotehnicilor": "agrotehnic",
    "agrotehnicul": "agrotehnic",
    "agrotehnicului": "agrotehnic",
    "agrotehnica": "agrotehnică",
    "agrotehnici": "agrotehnică",
    "agrotehnicii": "agrotehnică",
    "agrotehnicile": "agrotehnică",
    "agrotehnicilor": "agrotehnică",
    "agrozootehnica": "agrozootehnic",
    "agrozootehnică": "agrozootehnic",
    "agrozootehnice": "agrozootehnic",
    "agrozootehnicei": "agrozootehnic",
    "agrozootehnicele": "agrozootehnic",
    "agrozootehnicelor": "agrozootehnic",
    "agrozootehnici": "agrozootehnic",
    "agrozootehnicii": "agrozootehnic",
    "agrozootehnicilor": "agrozootehnic",
    "agrozootehnicul": "agrozootehnic",
    "agrozootehnicului": "agrozootehnic",
    "agurida": "aguridă",
    "aguride": "aguridă",
    "aguridei": "aguridă",
    "aguridele": "aguridă",
    "aguridelor": "aguridă",
    "ahei": "aheu",
    "aheii": "aheu",
    "aheilor": "aheu",
    "aheul": "aheu",
    "aheului": "aheu",
    "ahotnica": "ahotnic",
    "ahotnică": "ahotnic",
    "ahotnice": "ahotnic",
    "ahotnicei": "ahotnic",
    "ahotnicele": "ahotnic",
    "ahotnicelor": "ahotnic",
    "ahotnici": "ahotnic",
    "ahotnicii": "ahotnic",
    "ahotnicilor": "ahotnic",
    "ahotnicul": "ahotnic",
    "ahotnicului": "ahotnic",
    "ahtiai": "ahtia",
    "ahtiam": "ahtia",
    "ahtiară": "ahtia",
    "ahtiarăm": "ahtia",
    "ahtiarăți": "ahtia",
    "ahtiase": "ahtia",
    "ahtiasem": "ahtia",
    "ahtiaseră": "ahtia",
    "ahtiaserăm": "ahtia",
    "ahtiaserăți": "ahtia",
    "ahtiaseși": "ahtia",
    "ahtiași": "ahtia",
    "ahtiat": "ahtia",
    "ahtiați": "ahtia",
    "ahtiatu": "ahtia",
    "ahtiau": "ahtia",
    "ahtiază": "ahtia",
    "ahtie": "ahtia",
    "ahtiem": "ahtia",
    "ahtiez": "ahtia",
    "ahtieze": "ahtia",
    "ahtiezi": "ahtia",
    "ahtiind": "ahtia",
    "ahtiindu": "ahtia",
    "neahtiind": "ahtia",
    "neahtiindu": "ahtia",
    "nemaiahtiind": "ahtia",
    "nemaiahtiindu": "ahtia",
    "ahtiata": "ahtiat",
    "ahtiată": "ahtiat",
    "ahtiate": "ahtiat",
    "ahtiatei": "ahtiat",
    "ahtiatele": "ahtiat",
    "ahtiatelor": "ahtiat",
    "ahtiați": "ahtiat",
    "ahtiații": "ahtiat",
    "ahtiaților": "ahtiat",
    "ahtiatul": "ahtiat",
    "ahtiatului": "ahtiat",
    "ahtiata": "ahtiată",
    "ahtiate": "ahtiată",
    "ahtiatei": "ahtiată",
    "ahtiatele": "ahtiată",
    "ahtiatelor": "ahtiată",
    "ahtierea": "ahtiere",
    "ahtieri": "ahtiere",
    "ahtierii": "ahtiere",
    "ahtierile": "ahtiere",
    "aisbergul": "aisberg",
    "aisbergului": "aisberg",
    "aisberguri": "aisberg",
    "aisbergurile": "aisberg",
    "aisbergurilor": "aisberg",
    "Aiudul": "Aiud",
    "Aiudului": "Aiud",
    "aiură": "aiura",
    "aiurai": "aiura",
    "aiuram": "aiura",
    "aiurăm": "aiura",
    "aiurând": "aiura",
    "aiurându": "aiura",
    "aiurară": "aiura",
    "aiurarăm": "aiura",
    "aiurarăți": "aiura",
    "aiurase": "aiura",
    "aiurasem": "aiura",
    "aiuraseră": "aiura",
    "aiuraserăm": "aiura",
    "aiuraserăți": "aiura",
    "aiuraseși": "aiura",
    "aiurași": "aiura",
    "aiurat": "aiura",
    "aiurați": "aiura",
    "aiuratu": "aiura",
    "aiurau": "aiura",
    "aiurează": "aiura",
    "aiurez": "aiura",
    "aiureze": "aiura",
    "aiurezi": "aiura",
    "neaiurând": "aiura",
    "neaiurându": "aiura",
    "nemaiaiurând": "aiura",
    "nemaiaiurându": "aiura",
    "aiurarea": "aiurare",
    "aiurări": "aiurare",
    "aiurării": "aiurare",
    "aiurările": "aiurare",
    "aiurată": "aiurat",
    "aiurate": "aiurat",
    "aiurați": "aiurat",
    "aiurații": "aiurat",
    "aiuraților": "aiurat",
    "aiuratul": "aiurat",
    "aiuratului": "aiurat",
    "aiureala": "aiureală",
    "aiureli": "aiureală",
    "aiurelii": "aiureală",
    "aiurelile": "aiureală",
    "aiurelilor": "aiureală",
    "aiurita": "aiurit",
    "aiurită": "aiurit",
    "aiurite": "aiurit",
    "aiuritei": "aiurit",
    "aiuritele": "aiurit",
    "aiuritelor": "aiurit",
    "aiuriți": "aiurit",
    "aiuriții": "aiurit",
    "aiuriților": "aiurit",
    "aiuritul": "aiurit",
    "aiuritului": "aiurit",
    "aiurita": "aiurită",
    "aiurite": "aiurită",
    "aiuritei": "aiurită",
    "aiuritele": "aiurită",
    "aiuritelor": "aiurită",
    "ajung": "ajunge",
    "ajungă": "ajunge",
    "ajungând": "ajunge",
    "ajungându": "ajunge",
    "ajungea": "ajunge",
    "ajungeai": "ajunge",
    "ajungeam": "ajunge",
    "ajungeați": "ajunge",
    "ajungeau": "ajunge",
    "ajungem": "ajunge",
    "ajungeți": "ajunge",
    "ajungi": "ajunge",
    "ajuns": "ajunge",
    "ajunse": "ajunge",
    "ajunsei": "ajunge",
    "ajunseră": "ajunge",
    "ajunserăm": "ajunge",
    "ajunserăți": "ajunge",
    "ajunsese": "ajunge",
    "ajunsesem": "ajunge",
    "ajunseseră": "ajunge",
    "ajunseserăm": "ajunge",
    "ajunseserăți": "ajunge",
    "ajunseseși": "ajunge",
    "ajunseși": "ajunge",
    "ajunsu": "ajunge",
    "neajungând": "ajunge",
    "neajungându": "ajunge",
    "nemaiajungând": "ajunge",
    "nemaiajungându": "ajunge",
    "ajungerea": "ajungere",
    "ajungeri": "ajungere",
    "ajungerii": "ajungere",
    "ajungerile": "ajungere",
    "ajunsa": "ajuns",
    "ajunsă": "ajuns",
    "ajunse": "ajuns",
    "ajunsei": "ajuns",
    "ajunsele": "ajuns",
    "ajunselor": "ajuns",
    "ajunși": "ajuns",
    "ajunșii": "ajuns",
    "ajunșilor": "ajuns",
    "ajunsul": "ajuns",
    "ajunsului": "ajuns",
    "ajustă": "ajusta",
    "ajustai": "ajusta",
    "ajustam": "ajusta",
    "ajustăm": "ajusta",
    "ajustând": "ajusta",
    "ajustându": "ajusta",
    "ajustară": "ajusta",
    "ajustarăm": "ajusta",
    "ajustarăți": "ajusta",
    "ajustase": "ajusta",
    "ajustasem": "ajusta",
    "ajustaseră": "ajusta",
    "ajustaserăm": "ajusta",
    "ajustaserăți": "ajusta",
    "ajustaseși": "ajusta",
    "ajustași": "ajusta",
    "ajustat": "ajusta",
    "ajustați": "ajusta",
    "ajustatu": "ajusta",
    "ajustau": "ajusta",
    "ajustează": "ajusta",
    "ajustez": "ajusta",
    "ajusteze": "ajusta",
    "ajustezi": "ajusta",
    "neajustând": "ajusta",
    "neajustându": "ajusta",
    "nemaiajustând": "ajusta",
    "nemaiajustându": "ajusta",
    "ajustarea": "ajustare",
    "ajustări": "ajustare",
    "ajustării": "ajustare",
    "ajustările": "ajustare",
    "ajustata": "ajustat",
    "ajustată": "ajustat",
    "ajustate": "ajustat",
    "ajustatei": "ajustat",
    "ajustatele": "ajustat",
    "ajustatelor": "ajustat",
    "ajustați": "ajustat",
    "ajustații": "ajustat",
    "ajustaților": "ajustat",
    "ajustatul": "ajustat",
    "ajustatului": "ajustat",
    "ajut": "ajuta",
    "ajută": "ajuta",
    "ajutai": "ajuta",
    "ajutam": "ajuta",
    "ajutăm": "ajuta",
    "ajutând": "ajuta",
    "ajutându": "ajuta",
    "ajutară": "ajuta",
    "ajutarăm": "ajuta",
    "ajutarăți": "ajuta",
    "ajutase": "ajuta",
    "ajutasem": "ajuta",
    "ajutaseră": "ajuta",
    "ajutaserăm": "ajuta",
    "ajutaserăți": "ajuta",
    "ajutaseși": "ajuta",
    "ajutași": "ajuta",
    "ajutat": "ajuta",
    "ajutați": "ajuta",
    "ajutatu": "ajuta",
    "ajutau": "ajuta",
    "ajute": "ajuta",
    "ajuți": "ajuta",
    "neajutând": "ajuta",
    "neajutându": "ajuta",
    "nemaiajutând": "ajuta",
    "nemaiajutându": "ajuta",
    "ajutarea": "ajutare",
    "ajutări": "ajutare",
    "ajutării": "ajutare",
    "ajutările": "ajutare",
    "ajutași": "ajutat",
    "ajutata": "ajutat",
    "ajutată": "ajutat",
    "ajutate": "ajutat",
    "ajutatei": "ajutat",
    "ajutatele": "ajutat",
    "ajutatelor": "ajutat",
    "ajutați": "ajutat",
    "ajutații": "ajutat",
    "ajutaților": "ajutat",
    "ajutatul": "ajutat",
    "ajutatului": "ajutat",
    "ajutătoare": "ajutător",
    "ajutătoarea": "ajutător",
    "ajutătoarei": "ajutător",
    "ajutătoarele": "ajutător",
    "ajutătoarelor": "ajutător",
    "ajutători": "ajutător",
    "ajutătorii": "ajutător",
    "ajutătorilor": "ajutător",
    "ajutătorul": "ajutător",
    "ajutătorului": "ajutător",
    "ajutoarea": "ajutoare",
    "ajutoarei": "ajutoare",
    "ajutoarele": "ajutoare",
    "ajutoarelor": "ajutoare",
    "ajutoare": "ajutor",
    "ajutoarele": "ajutor",
    "ajutoarelor": "ajutor",
    "ajutori": "ajutor",
    "ajutorii": "ajutor",
    "ajutorilor": "ajutor",
    "ajutorul": "ajutor",
    "ajutorului": "ajutor",
    "ajutorarea": "ajutorare",
    "ajutorări": "ajutorare",
    "ajutorării": "ajutorare",
    "ajutorările": "ajutorare",
    "ajutorărilor": "ajutorare",
    "a": "al",
    "ai": "al",
    "ale": "al",
    "alor": "al",
    "ăi": "ăl",
    "ălei": "ăl",
    "ălor": "ăl",
    "ălui": "ăl",
    "ăi": "ăla",
    "aia": "ăla",
    "ăia": "ăla",
    "alea": "ăla",
    "ăleia": "ăla",
    "ălora": "ăla",
    "ăluia": "ăla",
    "alaiul": "alai",
    "alaiului": "alai",
    "alaiuri": "alai",
    "alaiurile": "alai",
    "alaiurilor": "alai",
    "alama": "alamă",
    "alame": "alamă",
    "alamei": "alamă",
    "alamele": "alamă",
    "alamelor": "alamă",
    "alămuri": "alamă",
    "alămurile": "alamă",
    "alămurilor": "alamă",
    "alambicul": "alambic",
    "alambicului": "alambic",
    "alambicuri": "alambic",
    "alambicurile": "alambic",
    "alambicurilor": "alambic",
    "alambică": "alambica",
    "alambicai": "alambica",
    "alambicam": "alambica",
    "alambicând": "alambica",
    "alambicându": "alambica",
    "alambicară": "alambica",
    "alambicarăm": "alambica",
    "alambicarăți": "alambica",
    "alambicase": "alambica",
    "alambicasem": "alambica",
    "alambicaseră": "alambica",
    "alambicaserăm": "alambica",
    "alambicaserăți": "alambica",
    "alambicaseși": "alambica",
    "alambicași": "alambica",
    "alambicat": "alambica",
    "alambicați": "alambica",
    "alambicatu": "alambica",
    "alambicau": "alambica",
    "alambichează": "alambica",
    "alambichez": "alambica",
    "alambicheze": "alambica",
    "alambichezi": "alambica",
    "nealambicând": "alambica",
    "nealambicându": "alambica",
    "nemaialambicând": "alambica",
    "nemaialambicându": "alambica",
    "alambicarea": "alambicare",
    "alambicări": "alambicare",
    "alambicării": "alambicare",
    "alambicările": "alambicare",
    "alambicata": "alambicat",
    "alambicată": "alambicat",
    "alambicate": "alambicat",
    "alambicatei": "alambicat",
    "alambicatele": "alambicat",
    "alambicatelor": "alambicat",
    "alambicați": "alambicat",
    "alambicații": "alambicat",
    "alambicaților": "alambicat",
    "alambicatul": "alambicat",
    "alambicatului": "alambicat",
    "alăptă": "alăpta",
    "alăptai": "alăpta",
    "alăptam": "alăpta",
    "alăptăm": "alăpta",
    "alăptând": "alăpta",
    "alăptându": "alăpta",
    "alăptară": "alăpta",
    "alăptarăm": "alăpta",
    "alăptarăți": "alăpta",
    "alăptase": "alăpta",
    "alăptasem": "alăpta",
    "alăptaseră": "alăpta",
    "alăptaserăm": "alăpta",
    "alăptaserăți": "alăpta",
    "alăptaseși": "alăpta",
    "alăptași": "alăpta",
    "alăptat": "alăpta",
    "alăptați": "alăpta",
    "alăptatu": "alăpta",
    "alăptau": "alăpta",
    "alăptează": "alăpta",
    "alăptez": "alăpta",
    "alăpteze": "alăpta",
    "alăptezi": "alăpta",
    "alăptarea": "alăptare",
    "alăptări": "alăptare",
    "alăptării": "alăptare",
    "alăptările": "alăptare",
    "alăptărilor": "alăptare",
    "alăptata": "alăptat",
    "alăptată": "alăptat",
    "alăptate": "alăptat",
    "alăptatei": "alăptat",
    "alăptatele": "alăptat",
    "alăptatelor": "alăptat",
    "alăptați": "alăptat",
    "alăptații": "alăptat",
    "alăptaților": "alăptat",
    "alăptatul": "alăptat",
    "alăptatului": "alăptat",
    "alarmă": "alarma",
    "alarmai": "alarma",
    "alarmam": "alarma",
    "alarmăm": "alarma",
    "alarmând": "alarma",
    "alarmându": "alarma",
    "alarmară": "alarma",
    "alarmarăm": "alarma",
    "alarmarăți": "alarma",
    "alarmase": "alarma",
    "alarmasem": "alarma",
    "alarmaseră": "alarma",
    "alarmaserăm": "alarma",
    "alarmaserăți": "alarma",
    "alarmaseși": "alarma",
    "alarmași": "alarma",
    "alarmat": "alarma",
    "alarmați": "alarma",
    "alarmatu": "alarma",
    "alarmau": "alarma",
    "alarmează": "alarma",
    "alarmez": "alarma",
    "alarmeze": "alarma",
    "alarmezi": "alarma",
    "nealarmând": "alarma",
    "nealarmându": "alarma",
    "nemaialarmând": "alarma",
    "nemaialarmându": "alarma",
    "alarma": "alarmă",
    "alarme": "alarmă",
    "alarmei": "alarmă",
    "alarmele": "alarmă",
    "alarmelor": "alarmă",
    "alarmanta": "alarmant",
    "alarmantă": "alarmant",
    "alarmante": "alarmant",
    "alarmantei": "alarmant",
    "alarmantele": "alarmant",
    "alarmantelor": "alarmant",
    "alarmanți": "alarmant",
    "alarmanții": "alarmant",
    "alarmanților": "alarmant",
    "alarmantul": "alarmant",
    "alarmantului": "alarmant",
    "alarmanta": "alarmantă",
    "alarmante": "alarmantă",
    "alarmantei": "alarmantă",
    "alarmantele": "alarmantă",
    "alarmantelor": "alarmantă",
    "alarmarea": "alarmare",
    "alarmări": "alarmare",
    "alarmării": "alarmare",
    "alarmările": "alarmare",
    "alarmata": "alarmat",
    "alarmată": "alarmat",
    "alarmate": "alarmat",
    "alarmatei": "alarmat",
    "alarmatele": "alarmat",
    "alarmatelor": "alarmat",
    "alarmați": "alarmat",
    "alarmații": "alarmat",
    "alarmaților": "alarmat",
    "alarmatul": "alarmat",
    "alarmatului": "alarmat",
    "alarmiști": "alarmist",
    "alarmiștii": "alarmist",
    "alarmiștilor": "alarmist",
    "alarmistul": "alarmist",
    "alarmistului": "alarmist",
    "alarmista": "alarmistă",
    "alarmiste": "alarmistă",
    "alarmistei": "alarmistă",
    "alarmistele": "alarmistă",
    "alarmistelor": "alarmistă",
    "alătur": "alătura",
    "alătură": "alătura",
    "alăturai": "alătura",
    "alăturam": "alătura",
    "alăturăm": "alătura",
    "alăturând": "alătura",
    "alăturându": "alătura",
    "alăturară": "alătura",
    "alăturarăm": "alătura",
    "alăturarăți": "alătura",
    "alăturase": "alătura",
    "alăturasem": "alătura",
    "alăturaseră": "alătura",
    "alăturaserăm": "alătura",
    "alăturaserăți": "alătura",
    "alăturaseși": "alătura",
    "alăturași": "alătura",
    "alăturat": "alătura",
    "alăturați": "alătura",
    "alăturatu": "alătura",
    "alăturau": "alătura",
    "alăture": "alătura",
    "alături": "alătura",
    "nealăturând": "alătura",
    "nealăturându": "alătura",
    "nemaialăturând": "alătura",
    "nemaialăturându": "alătura",
    "alăturarea": "alăturare",
    "alăturări": "alăturare",
    "alăturării": "alăturare",
    "alăturările": "alăturare",
    "alăturata": "alăturat",
    "alăturată": "alăturat",
    "alăturate": "alăturat",
    "alăturatele": "alăturat",
    "alăturatelor": "alăturat",
    "alăturați": "alăturat",
    "alăturații": "alăturat",
    "alăturaților": "alăturat",
    "alăturatul": "alăturat",
    "alăturatului": "alăturat",
    "alăuta": "alăută",
    "alăute": "alăută",
    "alăutei": "alăută",
    "alăutele": "alăută",
    "alăutelor": "alăută",
    "alba": "alb",
    "albă": "alb",
    "albe": "alb",
    "albei": "alb",
    "albele": "alb",
    "albelor": "alb",
    "albi": "alb",
    "albii": "alb",
    "albilor": "alb",
    "albul": "alb",
    "albului": "alb",
    "albaneza": "albanez",
    "albaneză": "albanez",
    "albaneze": "albanez",
    "albanezei": "albanez",
    "albanezele": "albanez",
    "albanezelor": "albanez",
    "albanezi": "albanez",
    "albanezii": "albanez",
    "albanezilor": "albanez",
    "albanezul": "albanez",
    "albanezului": "albanez",
    "alb.": "albaneză",
    "albăstreaua": "albăstrea",
    "albăstrele": "albăstrea",
    "albăstrelei": "albăstrea",
    "albăstrelele": "albăstrea",
    "albăstrelelor": "albăstrea",
    "albăstrea": "albăstrel",
    "albăstreaua": "albăstrel",
    "albăstrei": "albăstrel",
    "albăstreii": "albăstrel",
    "albăstreilor": "albăstrel",
    "albăstrele": "albăstrel",
    "albăstrelei": "albăstrel",
    "albăstrelele": "albăstrel",
    "albăstrelelor": "albăstrel",
    "albăstrelul": "albăstrel",
    "albăstrelului": "albăstrel",
    "albăstrica": "albăstrel",
    "albăstrică": "albăstrel",
    "albăstricei": "albăstrel",
    "albăstricii": "albăstrel",
    "albăstricile": "albăstrel",
    "albăstricilor": "albăstrel",
    "albăstrioara": "albăstrior",
    "albăstrioară": "albăstrior",
    "albăstrioare": "albăstrior",
    "albăstrioarei": "albăstrior",
    "albăstrioarele": "albăstrior",
    "albăstrioarelor": "albăstrior",
    "albăstriori": "albăstrior",
    "albăstriorii": "albăstrior",
    "albăstriorilor": "albăstrior",
    "albăstriorul": "albăstrior",
    "albăstriorului": "albăstrior",
    "albăstrita": "albăstrit",
    "albăstrită": "albăstrit",
    "albăstrite": "albăstrit",
    "albăstritei": "albăstrit",
    "albăstritele": "albăstrit",
    "albăstritelor": "albăstrit",
    "albăstriți": "albăstrit",
    "albăstriții": "albăstrit",
    "albăstriților": "albăstrit",
    "albăstritul": "albăstrit",
    "albăstritului": "albăstrit",
    "albăstria": "albăstriu",
    "albăstrie": "albăstriu",
    "albăstriei": "albăstriu",
    "albăstrii": "albăstriu",
    "albăstriii": "albăstriu",
    "albăstriile": "albăstriu",
    "albăstriilor": "albăstriu",
    "albăstrioarelor": "albăstriu",
    "albăstriul": "albăstriu",
    "albăstriului": "albăstriu",
    "albastra": "albastru",
    "albastră": "albastru",
    "albastre": "albastru",
    "albastrei": "albastru",
    "albastrele": "albastru",
    "albastrelor": "albastru",
    "albaștri": "albastru",
    "albaștrii": "albastru",
    "albaștrilor": "albastru",
    "albastrul": "albastru",
    "albastrului": "albastru",
    "albeața": "albeață",
    "albețele": "albeață",
    "albeți": "albeață",
    "albeții": "albeață",
    "albeților": "albeață",
    "albea": "albi",
    "albeai": "albi",
    "albeam": "albi",
    "albească": "albi",
    "albeați": "albi",
    "albeau": "albi",
    "albesc": "albi",
    "albește": "albi",
    "albești": "albi",
    "albii": "albi",
    "albim": "albi",
    "albind": "albi",
    "albindu": "albi",
    "albiră": "albi",
    "albirăm": "albi",
    "albirăți": "albi",
    "albise": "albi",
    "albisem": "albi",
    "albiseră": "albi",
    "albiserăm": "albi",
    "albiserăți": "albi",
    "albiseși": "albi",
    "albiși": "albi",
    "albit": "albi",
    "albiți": "albi",
    "albitu": "albi",
    "nealbind": "albi",
    "nealbindu": "albi",
    "nemaialbind": "albi",
    "nemaialbindu": "albi",
    "albicioasa": "albicios",
    "albicioasă": "albicios",
    "albicioase": "albicios",
    "albicioasei": "albicios",
    "albicioasele": "albicios",
    "albicioaselor": "albicios",
    "albicioși": "albicios",
    "albicioșii": "albicios",
    "albicioșilor": "albicios",
    "albiciosul": "albicios",
    "albiciosului": "albicios",
    "albia": "albie",
    "albiei": "albie",
    "albii": "albie",
    "albiile": "albie",
    "albiilor": "albie",
    "albina": "albină",
    "albine": "albină",
    "albinei": "albină",
    "albinele": "albină",
    "albinelor": "albină",
    "albirea": "albire",
    "albiri": "albire",
    "albirii": "albire",
    "albirile": "albire",
    "albita": "albit",
    "albită": "albit",
    "albite": "albit",
    "albitei": "albit",
    "albitele": "albit",
    "albitelor": "albit",
    "albiți": "albit",
    "albiții": "albit",
    "albiților": "albit",
    "albitul": "albit",
    "albitului": "albit",
    "albitoarea": "albitoare",
    "albitoarei": "albitoare",
    "albitoarele": "albitoare",
    "albitoarelor": "albitoare",
    "albitori": "albitor",
    "albitorii": "albitor",
    "albitorilor": "albitor",
    "albitorul": "albitor",
    "albitorului": "albitor",
    "albume": "album",
    "albumele": "album",
    "albumelor": "album",
    "albumul": "album",
    "albumului": "album",
    "albumina": "albumină",
    "albumine": "albumină",
    "albuminei": "albumină",
    "albuminele": "albumină",
    "albuminelor": "albumină",
    "albuminoida": "albuminoid",
    "albuminoidă": "albuminoid",
    "albuminoide": "albuminoid",
    "albuminoidei": "albuminoid",
    "albuminoidele": "albuminoid",
    "albuminoidelor": "albuminoid",
    "albuminoidul": "albuminoid",
    "albuminoidului": "albuminoid",
    "albuminoizi": "albuminoid",
    "albuminoizii": "albuminoid",
    "albuminoizilor": "albuminoid",
    "albuminoasa": "albuminos",
    "albuminoasă": "albuminos",
    "albuminoase": "albuminos",
    "albuminoasei": "albuminos",
    "albuminoasele": "albuminos",
    "albuminoaselor": "albuminos",
    "albuminoși": "albuminos",
    "albuminoșii": "albuminos",
    "albuminoșilor": "albuminos",
    "albuminosul": "albuminos",
    "albuminosului": "albuminos",
    "albuminuria": "albuminurie",
    "albuminuriei": "albuminurie",
    "albuminurii": "albuminurie",
    "albuminuriile": "albuminurie",
    "albuminuriilor": "albuminurie",
    "alburia": "alburiu",
    "alburie": "alburiu",
    "alburiei": "alburiu",
    "alburii": "alburiu",
    "alburiii": "alburiu",
    "alburiile": "alburiu",
    "alburiilor": "alburiu",
    "alburiul": "alburiu",
    "alburiului": "alburiu",
    "alc.": "alcalin",
    "alcalina": "alcalin",
    "alcalină": "alcalin",
    "alcaline": "alcalin",
    "alcalinei": "alcalin",
    "alcalinele": "alcalin",
    "alcalinelor": "alcalin",
    "alcalini": "alcalin",
    "alcalinii": "alcalin",
    "alcalinilor": "alcalin",
    "alcalinul": "alcalin",
    "alcalinului": "alcalin",
    "alcătuia": "alcătui",
    "alcătuiai": "alcătui",
    "alcătuiam": "alcătui",
    "alcătuiască": "alcătui",
    "alcătuiați": "alcătui",
    "alcătuiau": "alcătui",
    "alcătuiesc": "alcătui",
    "alcătuiește": "alcătui",
    "alcătuiești": "alcătui",
    "alcătuii": "alcătui",
    "alcătuim": "alcătui",
    "alcătuind": "alcătui",
    "alcătuindu": "alcătui",
    "alcătuiră": "alcătui",
    "alcătuirăm": "alcătui",
    "alcătuirăți": "alcătui",
    "alcătuise": "alcătui",
    "alcătuisem": "alcătui",
    "alcătuiseră": "alcătui",
    "alcătuiserăm": "alcătui",
    "alcătuiserăți": "alcătui",
    "alcătuiseși": "alcătui",
    "alcătuiși": "alcătui",
    "alcătuit": "alcătui",
    "alcătuiți": "alcătui",
    "alcătuitu": "alcătui",
    "nealcătuind": "alcătui",
    "nealcătuindu": "alcătui",
    "nemaialcătuind": "alcătui",
    "nemaialcătuindu": "alcătui",
    "alcătuirea": "alcătuire",
    "alcătuiri": "alcătuire",
    "alcătuirii": "alcătuire",
    "alcătuirile": "alcătuire",
    "alcătuita": "alcătuit",
    "alcătuită": "alcătuit",
    "alcătuite": "alcătuit",
    "alcătuitei": "alcătuit",
    "alcătuitele": "alcătuit",
    "alcătuitelor": "alcătuit",
    "alcătuiți": "alcătuit",
    "alcătuiții": "alcătuit",
    "alcătuiților": "alcătuit",
    "alcătuitul": "alcătuit",
    "alcătuitului": "alcătuit",
    "alcătuitoare": "alcătuitor",
    "alcătuitoarea": "alcătuitor",
    "alcătuitoarei": "alcătuitor",
    "alcătuitoarele": "alcătuitor",
    "alcătuitoarelor": "alcătuitor",
    "alcătuitori": "alcătuitor",
    "alcătuitorii": "alcătuitor",
    "alcătuitorilor": "alcătuitor",
    "alcătuitorul": "alcătuitor",
    "alcătuitorului": "alcătuitor",
    "alchimia": "alchimie",
    "alchimiei": "alchimie",
    "alchimii": "alchimie",
    "alchimiile": "alchimie",
    "alchimiilor": "alchimie",
    "alcooli": "alcool",
    "alcoolii": "alcool",
    "alcoolilor": "alcool",
    "alcoolul": "alcool",
    "alcoolului": "alcool",
    "alcooluri": "alcool",
    "alcoolurile": "alcool",
    "alcoolurilor": "alcool",
    "alcoolica": "alcoolic",
    "alcoolică": "alcoolic",
    "alcoolice": "alcoolic",
    "alcoolicei": "alcoolic",
    "alcoolicele": "alcoolic",
    "alcoolicelor": "alcoolic",
    "alcoolici": "alcoolic",
    "alcoolicii": "alcoolic",
    "alcoolicilor": "alcoolic",
    "alcoolicul": "alcoolic",
    "alcoolicului": "alcoolic",
    "alcoolica": "alcoolică",
    "alcoolice": "alcoolică",
    "alcoolicei": "alcoolică",
    "alcoolicele": "alcoolică",
    "alcoolicelor": "alcoolică",
    "alcoolismul": "alcoolism",
    "alcoolismului": "alcoolism",
    "alcoolizata": "alcoolizat",
    "alcoolizată": "alcoolizat",
    "alcoolizate": "alcoolizat",
    "alcoolizatei": "alcoolizat",
    "alcoolizatele": "alcoolizat",
    "alcoolizatelor": "alcoolizat",
    "alcoolizați": "alcoolizat",
    "alcoolizații": "alcoolizat",
    "alcoolizaților": "alcoolizat",
    "alcoolizatul": "alcoolizat",
    "alcoolizatului": "alcoolizat",
    "alcovul": "alcov",
    "alcovului": "alcov",
    "alcovuri": "alcov",
    "alcovurile": "alcov",
    "alcovurilor": "alcov",
    "aldămașul": "aldămaș",
    "aldămașului": "aldămaș",
    "aldămașuri": "aldămaș",
    "aldămașurile": "aldămaș",
    "aldămașurilor": "aldămaș",
    "aldina": "aldin",
    "aldină": "aldin",
    "aldine": "aldin",
    "aldinei": "aldin",
    "aldinele": "aldin",
    "aldinelor": "aldin",
    "aldinul": "aldin",
    "aldinului": "aldin",
    "aldina": "aldină",
    "aldine": "aldină",
    "aldinei": "aldină",
    "aldinele": "aldină",
    "aldinelor": "aldină",
    "aleanul": "alean",
    "aleanului": "alean",
    "aleanuri": "alean",
    "aleanurile": "alean",
    "aleanurilor": "alean",
    "aleasa": "aleasă",
    "alese": "aleasă",
    "alesei": "aleasă",
    "alesele": "aleasă",
    "aleselor": "aleasă",
    "aleatoria": "aleatoriu",
    "aleatorie": "aleatoriu",
    "aleatoriei": "aleatoriu",
    "aleatorii": "aleatoriu",
    "aleatoriii": "aleatoriu",
    "aleatoriile": "aleatoriu",
    "aleatoriilor": "aleatoriu",
    "aleatoriul": "aleatoriu",
    "aleatoriului": "aleatoriu",
    "aleea": "alee",
    "alei": "alee",
    "aleii": "alee",
    "aleile": "alee",
    "aleilor": "alee",
    "alegătoarea": "alegătoare",
    "alegătoarei": "alegătoare",
    "alegătoarele": "alegătoare",
    "alegătoarelor": "alegătoare",
    "alegători": "alegător",
    "alegătorii": "alegător",
    "alegătorilor": "alegător",
    "alegătorul": "alegător",
    "alegătorului": "alegător",
    "aleagă": "alege",
    "aleg": "alege",
    "alegând": "alege",
    "alegându": "alege",
    "alegea": "alege",
    "alegeai": "alege",
    "alegeam": "alege",
    "alegeați": "alege",
    "alegeau": "alege",
    "alegem": "alege",
    "alegeți": "alege",
    "alegi": "alege",
    "ales": "alege",
    "alese": "alege",
    "alesei": "alege",
    "aleseră": "alege",
    "aleserăm": "alege",
    "aleserăți": "alege",
    "alesese": "alege",
    "alesesem": "alege",
    "aleseseră": "alege",
    "aleseserăm": "alege",
    "aleseserăți": "alege",
    "aleseseși": "alege",
    "aleseși": "alege",
    "alesu": "alege",
    "nealegând": "alege",
    "nealegându": "alege",
    "nemaialegând": "alege",
    "nemaialegându": "alege",
    "alegerea": "alegere",
    "alegeri": "alegere",
    "alegerii": "alegere",
    "alegerile": "alegere",
    "alegerilor": "alegere",
    "alegorica": "alegoric",
    "alegorică": "alegoric",
    "alegorice": "alegoric",
    "alegoricei": "alegoric",
    "alegoricele": "alegoric",
    "alegoricelor": "alegoric",
    "alegorici": "alegoric",
    "alegoricii": "alegoric",
    "alegoricilor": "alegoric",
    "alegoricul": "alegoric",
    "alegoricului": "alegoric",
    "alegoria": "alegorie",
    "alegoriei": "alegorie",
    "alegorii": "alegorie",
    "alegoriile": "alegorie",
    "alegoriilor": "alegorie",
    "alegra": "alegru",
    "alegră": "alegru",
    "alegre": "alegru",
    "alegrei": "alegru",
    "alegrele": "alegru",
    "alegrelor": "alegru",
    "alegri": "alegru",
    "alegrii": "alegru",
    "alegrilor": "alegru",
    "alegrul": "alegru",
    "alegrului": "alegru",
    "alandala": "alene",
    "aleargă": "alerga",
    "alerg": "alerga",
    "alergă": "alerga",
    "alergai": "alerga",
    "alergam": "alerga",
    "alergăm": "alerga",
    "alergând": "alerga",
    "alergându": "alerga",
    "alergase": "alerga",
    "alergasem": "alerga",
    "alergaseră": "alerga",
    "alergaserăm": "alerga",
    "alergaserăți": "alerga",
    "alergaseși": "alerga",
    "alergași": "alerga",
    "alergat": "alerga",
    "alergați": "alerga",
    "alergatu": "alerga",
    "alergau": "alerga",
    "alerge": "alerga",
    "alergi": "alerga",
    "nealergând": "alerga",
    "nealergându": "alerga",
    "nemaialergând": "alerga",
    "nemaialergându": "alerga",
    "alergarea": "alergare",
    "alergări": "alergare",
    "alergării": "alergare",
    "alergările": "alergare",
    "alergata": "alergat",
    "alergată": "alergat",
    "alergate": "alergat",
    "alergatei": "alergat",
    "alergatele": "alergat",
    "alergatelor": "alergat",
    "alergați": "alergat",
    "alergații": "alergat",
    "alergaților": "alergat",
    "alergatul": "alergat",
    "alergatului": "alergat",
    "alergătoarea": "alergătoare",
    "alergătoarei": "alergătoare",
    "alergătoarele": "alergătoare",
    "alergătoarelor": "alergătoare",
    "alergători": "alergător",
    "alergătorii": "alergător",
    "alergătorilor": "alergător",
    "alergătorul": "alergător",
    "alergătorului": "alergător",
    "alergătura": "alergătură",
    "alergături": "alergătură",
    "alergăturii": "alergătură",
    "alergăturile": "alergătură",
    "alergăturilor": "alergătură",
    "alergia": "alergie",
    "alergiei": "alergie",
    "alergii": "alergie",
    "alergiile": "alergie",
    "alergiilor": "alergie",
    "alerta": "alert",
    "alertă": "alert",
    "alerte": "alert",
    "alertei": "alert",
    "alertele": "alert",
    "alertelor": "alert",
    "alerți": "alert",
    "alerții": "alert",
    "alerților": "alert",
    "alertul": "alert",
    "alertului": "alert",
    "alertat": "alerta",
    "alerta": "alertă",
    "alerte": "alertă",
    "alertei": "alertă",
    "alertele": "alertă",
    "alertelor": "alertă",
    "alertată": "alertat",
    "alertate": "alertat",
    "alertați": "alertat",
    "aleasa": "ales",
    "aleasă": "ales",
    "alese": "ales",
    "alesei": "ales",
    "alesele": "ales",
    "aleselor": "ales",
    "aleși": "ales",
    "aleșii": "ales",
    "aleșilor": "ales",
    "alesul": "ales",
    "alesului": "ales",
    "alexandrina": "alexandrin",
    "alexandrină": "alexandrin",
    "alexandrinul": "alexandrin",
    "alexandrinului": "alexandrin",
    "Al.": "Alexandru",
    "aleză": "aleza",
    "alezai": "aleza",
    "alezam": "aleza",
    "alezăm": "aleza",
    "alezând": "aleza",
    "alezându": "aleza",
    "alezară": "aleza",
    "alezarăm": "aleza",
    "alezarăți": "aleza",
    "alezase": "aleza",
    "alezasem": "aleza",
    "alezaseră": "aleza",
    "alezaserăm": "aleza",
    "alezaserăți": "aleza",
    "alezaseși": "aleza",
    "alezași": "aleza",
    "alezat": "aleza",
    "alezați": "aleza",
    "alezatu": "aleza",
    "alezau": "aleza",
    "alezează": "aleza",
    "alezez": "aleza",
    "alezeze": "aleza",
    "alezezi": "aleza",
    "nealezând": "aleza",
    "nealezându": "aleza",
    "nemaialezând": "aleza",
    "nemaialezându": "aleza",
    "alezarea": "alezare",
    "alezări": "alezare",
    "alezării": "alezare",
    "alezările": "alezare",
    "alezata": "alezat",
    "alezată": "alezat",
    "alezate": "alezat",
    "alezatei": "alezat",
    "alezatele": "alezat",
    "alezatelor": "alezat",
    "alezați": "alezat",
    "alezații": "alezat",
    "alezaților": "alezat",
    "alezatul": "alezat",
    "alezatului": "alezat",
    "alfabetul": "alfabet",
    "alfabetului": "alfabet",
    "alfabeturi": "alfabet",
    "alfabeturile": "alfabet",
    "alfabeturilor": "alfabet",
    "alfabetica": "alfabetic",
    "alfabetică": "alfabetic",
    "alfabeticul": "alfabetic",
    "alfabeticului": "alfabetic",
    "alfabetiză": "alfabetiza",
    "alfabetizai": "alfabetiza",
    "alfabetizam": "alfabetiza",
    "alfabetizăm": "alfabetiza",
    "alfabetizând": "alfabetiza",
    "alfabetizându": "alfabetiza",
    "alfabetizară": "alfabetiza",
    "alfabetizarăm": "alfabetiza",
    "alfabetizarăți": "alfabetiza",
    "alfabetizase": "alfabetiza",
    "alfabetizasem": "alfabetiza",
    "alfabetizaseră": "alfabetiza",
    "alfabetizaserăm": "alfabetiza",
    "alfabetizaserăți": "alfabetiza",
    "alfabetizaseși": "alfabetiza",
    "alfabetizași": "alfabetiza",
    "alfabetizat": "alfabetiza",
    "alfabetizați": "alfabetiza",
    "alfabetizatu": "alfabetiza",
    "alfabetizau": "alfabetiza",
    "alfabetizează": "alfabetiza",
    "alfabetizez": "alfabetiza",
    "alfabetizeze": "alfabetiza",
    "alfabetizezi": "alfabetiza",
    "nealfabetizând": "alfabetiza",
    "nealfabetizându": "alfabetiza",
    "nemaialfabetizând": "alfabetiza",
    "nemaialfabetizându": "alfabetiza",
    "alfabetizarea": "alfabetizare",
    "alfabetizări": "alfabetizare",
    "alfabetizării": "alfabetizare",
    "alfabetizările": "alfabetizare",
    "alfabetizata": "alfabetizat",
    "alfabetizată": "alfabetizat",
    "alfabetizate": "alfabetizat",
    "alfabetizatei": "alfabetizat",
    "alfabetizatele": "alfabetizat",
    "alfabetizatelor": "alfabetizat",
    "alfabetizați": "alfabetizat",
    "alfabetizații": "alfabetizat",
    "alfabetizaților": "alfabetizat",
    "alfabetizatul": "alfabetizat",
    "alfabetizatului": "alfabetizat",
    "alga": "algă",
    "alge": "algă",
    "algei": "algă",
    "algele": "algă",
    "algelor": "algă",
    "algebra": "algebră",
    "algebre": "algebră",
    "algebrei": "algebră",
    "algebrele": "algebră",
    "algebrelor": "algebră",
    "algebrica": "algebric",
    "algebrică": "algebric",
    "algebrice": "algebric",
    "algebricei": "algebric",
    "algebricele": "algebric",
    "algebricelor": "algebric",
    "algebrici": "algebric",
    "algebricii": "algebric",
    "algebricilor": "algebric",
    "algebricul": "algebric",
    "algebricului": "algebric",
    "algeriana": "algerian",
    "algeriană": "algerian",
    "algerianul": "algerian",
    "algerianului": "algerian",
    "algeriene": "algerian",
    "algerienei": "algerian",
    "algerienele": "algerian",
    "algerienelor": "algerian",
    "algerieni": "algerian",
    "algerienii": "algerian",
    "algerienilor": "algerian",
    "algoritme": "algoritm",
    "algoritmele": "algoritm",
    "algoritmelor": "algoritm",
    "algoritmi": "algoritm",
    "algoritmii": "algoritm",
    "algoritmilor": "algoritm",
    "algoritmul": "algoritm",
    "algoritmului": "algoritm",
    "aliai": "alia",
    "aliam": "alia",
    "aliară": "alia",
    "aliarăm": "alia",
    "aliarăți": "alia",
    "aliase": "alia",
    "aliasem": "alia",
    "aliaseră": "alia",
    "aliaserăm": "alia",
    "aliaserăți": "alia",
    "aliaseși": "alia",
    "aliași": "alia",
    "aliat": "alia",
    "aliați": "alia",
    "aliatu": "alia",
    "aliau": "alia",
    "aliază": "alia",
    "alie": "alia",
    "aliem": "alia",
    "aliez": "alia",
    "alieze": "alia",
    "aliezi": "alia",
    "aliind": "alia",
    "aliindu": "alia",
    "nealiind": "alia",
    "nealiindu": "alia",
    "nemaialiind": "alia",
    "nemaialiindu": "alia",
    "al.e.": "alia_editio",
    "aliaje": "aliaj",
    "aliajele": "aliaj",
    "aliajelor": "aliaj",
    "aliajul": "aliaj",
    "aliajului": "aliaj",
    "alianța": "alianță",
    "alianțe": "alianță",
    "alianței": "alianță",
    "alianțele": "alianță",
    "alianțelor": "alianță",
    "aliata": "aliat",
    "aliată": "aliat",
    "aliate": "aliat",
    "aliatei": "aliat",
    "aliatele": "aliat",
    "aliatelor": "aliat",
    "aliați": "aliat",
    "aliații": "aliat",
    "aliaților": "aliat",
    "aliatul": "aliat",
    "aliatului": "aliat",
    "aliata": "aliată",
    "aliate": "aliată",
    "aliatei": "aliată",
    "aliatele": "aliată",
    "aliatelor": "aliată",
    "alibiul": "alibi",
    "alibiului": "alibi",
    "alibiuri": "alibi",
    "alibiurile": "alibi",
    "alibiurilor": "alibi",
    "alica": "alică",
    "alice": "alică",
    "alicei": "alică",
    "alicele": "alică",
    "alicelor": "alică",
    "alienă": "aliena",
    "alienai": "aliena",
    "alienam": "aliena",
    "alienăm": "aliena",
    "alienând": "aliena",
    "alienându": "aliena",
    "alienară": "aliena",
    "alienarăm": "aliena",
    "alienarăți": "aliena",
    "alienase": "aliena",
    "alienasem": "aliena",
    "alienaseră": "aliena",
    "alienaserăm": "aliena",
    "alienaserăți": "aliena",
    "alienaseși": "aliena",
    "alienași": "aliena",
    "alienat": "aliena",
    "alienați": "aliena",
    "alienatu": "aliena",
    "alienau": "aliena",
    "alienează": "aliena",
    "alienez": "aliena",
    "alieneze": "aliena",
    "alienezi": "aliena",
    "nealienând": "aliena",
    "nealienându": "aliena",
    "nemaialienând": "aliena",
    "nemaialienându": "aliena",
    "alienabila": "alienabil",
    "alienabilă": "alienabil",
    "alienabile": "alienabil",
    "alienabilei": "alienabil",
    "alienabilele": "alienabil",
    "alienabilelor": "alienabil",
    "alienabili": "alienabil",
    "alienabilii": "alienabil",
    "alienabililor": "alienabil",
    "alienabilul": "alienabil",
    "alienabilului": "alienabil",
    "alienarea": "alienare",
    "alienări": "alienare",
    "alienării": "alienare",
    "alienările": "alienare",
    "alienata": "alienat",
    "alienată": "alienat",
    "alienate": "alienat",
    "alienatei": "alienat",
    "alienatele": "alienat",
    "alienatelor": "alienat",
    "alienați": "alienat",
    "alienații": "alienat",
    "alienaților": "alienat",
    "alienatul": "alienat",
    "alienatului": "alienat",
    "alienata": "alienată",
    "alienate": "alienată",
    "alienatei": "alienată",
    "alienatele": "alienată",
    "alienatelor": "alienată",
    "alienista": "alienist",
    "alienistă": "alienist",
    "alieniste": "alienist",
    "alienistei": "alienist",
    "alienistele": "alienist",
    "alienistelor": "alienist",
    "alieniști": "alienist",
    "alieniștii": "alienist",
    "alieniștilor": "alienist",
    "alienistul": "alienist",
    "alienistului": "alienist",
    "alierea": "aliere",
    "alieri": "aliere",
    "alierii": "aliere",
    "alierile": "aliere",
    "alifia": "alifie",
    "alifiei": "alifie",
    "alifii": "alifie",
    "alifiile": "alifie",
    "alifiilor": "alifie",
    "alilodidactica": "alilodidactic",
    "alilodidactică": "alilodidactic",
    "alilodidactice": "alilodidactic",
    "alilodidacticei": "alilodidactic",
    "alilodidacticele": "alilodidactic",
    "alilodidacticelor": "alilodidactic",
    "alilodidactici": "alilodidactic",
    "alilodidacticii": "alilodidactic",
    "alilodidacticilor": "alilodidactic",
    "alilodidacticul": "alilodidactic",
    "alilodidacticului": "alilodidactic",
    "alimane": "aliman",
    "alimanele": "aliman",
    "alimanelor": "aliman",
    "alimanul": "aliman",
    "alimanului": "aliman",
    "alimente": "aliment",
    "alimentele": "aliment",
    "alimentelor": "aliment",
    "alimentul": "aliment",
    "alimentului": "aliment",
    "alimentă": "alimenta",
    "alimentai": "alimenta",
    "alimentam": "alimenta",
    "alimentăm": "alimenta",
    "alimentând": "alimenta",
    "alimentându": "alimenta",
    "alimentară": "alimenta",
    "alimentarăm": "alimenta",
    "alimentarăți": "alimenta",
    "alimentase": "alimenta",
    "alimentasem": "alimenta",
    "alimentaseră": "alimenta",
    "alimentaserăm": "alimenta",
    "alimentaserăți": "alimenta",
    "alimentaseși": "alimenta",
    "alimentași": "alimenta",
    "alimentat": "alimenta",
    "alimentați": "alimenta",
    "alimentatu": "alimenta",
    "alimentau": "alimenta",
    "alimentează": "alimenta",
    "alimentez": "alimenta",
    "alimenteze": "alimenta",
    "alimentezi": "alimenta",
    "nealimentând": "alimenta",
    "nealimentându": "alimenta",
    "nemaialimentând": "alimenta",
    "nemaialimentându": "alimenta",
    "alimentara": "alimentar",
    "alimentară": "alimentar",
    "alimentare": "alimentar",
    "alimentarul": "alimentar",
    "alimentarului": "alimentar",
    "alim.": "alimentară",
    "alimentara": "alimentară",
    "alimentare": "alimentară",
    "alimentarea": "alimentare",
    "alimentări": "alimentare",
    "alimentării": "alimentare",
    "alimentările": "alimentare",
    "alimentata": "alimentat",
    "alimentată": "alimentat",
    "alimentate": "alimentat",
    "alimentatei": "alimentat",
    "alimentatele": "alimentat",
    "alimentatelor": "alimentat",
    "alimentați": "alimentat",
    "alimentații": "alimentat",
    "alimentaților": "alimentat",
    "alimentatul": "alimentat",
    "alimentatului": "alimentat",
    "alimentația": "alimentație",
    "alimentației": "alimentație",
    "alimentații": "alimentație",
    "alimentațiile": "alimentație",
    "alimentațiilor": "alimentație",
    "alin": "alina",
    "alină": "alina",
    "alinai": "alina",
    "alinam": "alina",
    "alinăm": "alina",
    "alinând": "alina",
    "alinându": "alina",
    "alinară": "alina",
    "alinarăm": "alina",
    "alinarăți": "alina",
    "alinase": "alina",
    "alinasem": "alina",
    "alinaseră": "alina",
    "alinaserăm": "alina",
    "alinaserăți": "alina",
    "alinaseși": "alina",
    "alinași": "alina",
    "alinat": "alina",
    "alinați": "alina",
    "alinatu": "alina",
    "alinau": "alina",
    "aline": "alina",
    "Alinei": "Alina",
    "alini": "alina",
    "nealinând": "alina",
    "nealinându": "alina",
    "nemaialinând": "alina",
    "nemaialinându": "alina",
    "alinarea": "alinare",
    "alinări": "alinare",
    "alinării": "alinare",
    "alinările": "alinare",
    "alinata": "alinat",
    "alinată": "alinat",
    "alinate": "alinat",
    "alinatei": "alinat",
    "alinatele": "alinat",
    "alinatelor": "alinat",
    "alinați": "alinat",
    "alinații": "alinat",
    "alinaților": "alinat",
    "alinatul": "alinat",
    "alinatului": "alinat",
    "alinătoarea": "alinătoare",
    "alinătoarei": "alinătoare",
    "alinătoarele": "alinătoare",
    "alinătoarelor": "alinătoare",
    "alinătoare": "alinător",
    "alinătoarea": "alinător",
    "alinătoarei": "alinător",
    "alinătoarele": "alinător",
    "alinătoarelor": "alinător",
    "alinători": "alinător",
    "alinătorii": "alinător",
    "alinătorilor": "alinător",
    "alinătorul": "alinător",
    "alinătorului": "alinător",
    "alinătura": "alinătură",
    "alinături": "alinătură",
    "alinăturii": "alinătură",
    "alinăturile": "alinătură",
    "alinăturilor": "alinătură",
    "alineate": "alineat",
    "alineatele": "alineat",
    "alineatelor": "alineat",
    "alineatul": "alineat",
    "alineatului": "alineat",
    "aliniai": "alinia",
    "aliniam": "alinia",
    "aliniară": "alinia",
    "aliniarăm": "alinia",
    "aliniarăți": "alinia",
    "aliniase": "alinia",
    "aliniasem": "alinia",
    "aliniaseră": "alinia",
    "aliniaserăm": "alinia",
    "aliniaserăți": "alinia",
    "aliniaseși": "alinia",
    "aliniași": "alinia",
    "aliniat": "alinia",
    "aliniați": "alinia",
    "aliniatu": "alinia",
    "aliniau": "alinia",
    "aliniază": "alinia",
    "alinie": "alinia",
    "aliniem": "alinia",
    "aliniez": "alinia",
    "alinieze": "alinia",
    "aliniezi": "alinia",
    "aliniind": "alinia",
    "aliniindu": "alinia",
    "nealiniind": "alinia",
    "nealiniindu": "alinia",
    "nemaialiniind": "alinia",
    "nemaialiniindu": "alinia",
    "aliniata": "aliniat",
    "aliniată": "aliniat",
    "aliniate": "aliniat",
    "aliniatei": "aliniat",
    "aliniatele": "aliniat",
    "aliniatelor": "aliniat",
    "aliniați": "aliniat",
    "aliniații": "aliniat",
    "aliniaților": "aliniat",
    "aliniatul": "aliniat",
    "aliniatului": "aliniat",
    "alinierea": "aliniere",
    "alinieri": "aliniere",
    "alinierii": "aliniere",
    "alinierile": "aliniere",
    "alintul": "alint",
    "alintului": "alint",
    "alinturi": "alint",
    "alinturile": "alint",
    "alinturilor": "alint",
    "alint": "alinta",
    "alintă": "alinta",
    "alintai": "alinta",
    "alintam": "alinta",
    "alintăm": "alinta",
    "alintând": "alinta",
    "alintându": "alinta",
    "alintară": "alinta",
    "alintarăm": "alinta",
    "alintarăți": "alinta",
    "alintase": "alinta",
    "alintasem": "alinta",
    "alintaseră": "alinta",
    "alintaserăm": "alinta",
    "alintaserăți": "alinta",
    "alintaseși": "alinta",
    "alintași": "alinta",
    "alintat": "alinta",
    "alintați": "alinta",
    "alintatu": "alinta",
    "alintau": "alinta",
    "alinte": "alinta",
    "alinți": "alinta",
    "nealintând": "alinta",
    "nealintându": "alinta",
    "nemaialintând": "alinta",
    "nemaialintându": "alinta",
    "alintarea": "alintare",
    "alintări": "alintare",
    "alintării": "alintare",
    "alintările": "alintare",
    "alintata": "alintat",
    "alintată": "alintat",
    "alintate": "alintat",
    "alintatei": "alintat",
    "alintatele": "alintat",
    "alintatelor": "alintat",
    "alintați": "alintat",
    "alintații": "alintat",
    "alintaților": "alintat",
    "alintatul": "alintat",
    "alintatului": "alintat",
    "alintata": "alintată",
    "alintate": "alintată",
    "alintatei": "alintată",
    "alintatele": "alintată",
    "alintatelor": "alintată",
    "alintătoarea": "alintătoare",
    "alintătoarei": "alintătoare",
    "alintătoarele": "alintătoare",
    "alintătoarelor": "alintătoare",
    "alintătoare": "alintător",
    "alintătoarea": "alintător",
    "alintătoarei": "alintător",
    "alintătoarele": "alintător",
    "alintătoarelor": "alintător",
    "alintători": "alintător",
    "alintătorii": "alintător",
    "alintătorilor": "alintător",
    "alintătorul": "alintător",
    "alintătorului": "alintător",
    "alintătura": "alintătură",
    "alintături": "alintătură",
    "alintăturii": "alintătură",
    "alintăturile": "alintătură",
    "alintăturilor": "alintătură",
    "aliotmani": "aliotman",
    "aliotmanii": "aliotman",
    "aliotmanilor": "aliotman",
    "aliotmanul": "aliotman",
    "aliotmanului": "aliotman",
    "alipea": "alipi",
    "alipeai": "alipi",
    "alipeam": "alipi",
    "alipească": "alipi",
    "alipeați": "alipi",
    "alipeau": "alipi",
    "alipesc": "alipi",
    "alipește": "alipi",
    "alipești": "alipi",
    "alipii": "alipi",
    "alipim": "alipi",
    "alipind": "alipi",
    "alipindu": "alipi",
    "alipiră": "alipi",
    "alipirăm": "alipi",
    "alipirăți": "alipi",
    "alipise": "alipi",
    "alipisem": "alipi",
    "alipiseră": "alipi",
    "alipiserăm": "alipi",
    "alipiserăți": "alipi",
    "alipiseși": "alipi",
    "alipiși": "alipi",
    "alipit": "alipi",
    "alipiți": "alipi",
    "alipitu": "alipi",
    "alipirea": "alipire",
    "alipiri": "alipire",
    "alipirii": "alipire",
    "alipirile": "alipire",
    "alipirilor": "alipire",
    "alipita": "alipit",
    "alipită": "alipit",
    "alipite": "alipit",
    "alipitei": "alipit",
    "alipitele": "alipit",
    "alipitelor": "alipit",
    "alipiți": "alipit",
    "alipiții": "alipit",
    "alipiților": "alipit",
    "alipitul": "alipit",
    "alipitului": "alipit",
    "aliterația": "aliterație",
    "aliterației": "aliterație",
    "aliterații": "aliterație",
    "aliterațiile": "aliterație",
    "aliterațiilor": "aliterație",
    "alizee": "alizeu",
    "alizeele": "alizeu",
    "alizeelor": "alizeu",
    "alizeul": "alizeu",
    "alizeului": "alizeu",
    "almanahul": "almanah",
    "almanahului": "almanah",
    "almanahuri": "almanah",
    "almanahurile": "almanah",
    "almanahurilor": "almanah",
    "aloc": "aloca",
    "alocă": "aloca",
    "alocai": "aloca",
    "alocam": "aloca",
    "alocăm": "aloca",
    "alocând": "aloca",
    "alocându": "aloca",
    "alocară": "aloca",
    "alocarăm": "aloca",
    "alocarăți": "aloca",
    "alocase": "aloca",
    "alocasem": "aloca",
    "alocaseră": "aloca",
    "alocaserăm": "aloca",
    "alocaserăți": "aloca",
    "alocaseși": "aloca",
    "alocași": "aloca",
    "alocat": "aloca",
    "alocați": "aloca",
    "alocatu": "aloca",
    "alocau": "aloca",
    "aloce": "aloca",
    "aloci": "aloca",
    "nealocând": "aloca",
    "nealocându": "aloca",
    "nemaialocând": "aloca",
    "nemaialocându": "aloca",
    "alocarea": "alocare",
    "alocări": "alocare",
    "alocării": "alocare",
    "alocările": "alocare",
    "alocata": "alocat",
    "alocată": "alocat",
    "alocate": "alocat",
    "alocatei": "alocat",
    "alocatele": "alocat",
    "alocatelor": "alocat",
    "alocați": "alocat",
    "alocații": "alocat",
    "alocaților": "alocat",
    "alocatul": "alocat",
    "alocatului": "alocat",
    "alocația": "alocație",
    "alocației": "alocație",
    "alocații": "alocație",
    "alocațiile": "alocație",
    "alocațiilor": "alocație",
    "alocuțiunea": "alocuțiune",
    "alocuțiuni": "alocuțiune",
    "alocuțiunii": "alocuțiune",
    "alocuțiunile": "alocuțiune",
    "alocuțiunilor": "alocuțiune",
    "alogena": "alogen",
    "alogenă": "alogen",
    "alogenul": "alogen",
    "alogenului": "alogen",
    "alotropica": "alotropic",
    "alotropică": "alotropic",
    "alotropice": "alotropic",
    "alotropicei": "alotropic",
    "alotropicele": "alotropic",
    "alotropicelor": "alotropic",
    "alotropici": "alotropic",
    "alotropicii": "alotropic",
    "alotropicilor": "alotropic",
    "alotropicul": "alotropic",
    "alotropicului": "alotropic",
    "alotropia": "alotropie",
    "alotropiei": "alotropie",
    "alotropii": "alotropie",
    "alotropiile": "alotropie",
    "alotropiilor": "alotropie",
    "alpacale": "alpaca",
    "alpacalei": "alpaca",
    "alpacalele": "alpaca",
    "alpacalelor": "alpaca",
    "alpacaua": "alpaca",
    "alpenștocul": "alpenștoc",
    "alpenștocului": "alpenștoc",
    "alpenștocuri": "alpenștoc",
    "alpenștocurile": "alpenștoc",
    "alpenștocurilor": "alpenștoc",
    "alpestra": "alpestru",
    "alpestră": "alpestru",
    "alpestre": "alpestru",
    "alpestrei": "alpestru",
    "alpestrele": "alpestru",
    "alpestrelor": "alpestru",
    "alpeștri": "alpestru",
    "alpeștrii": "alpestru",
    "alpeștrilor": "alpestru",
    "alpestrul": "alpestru",
    "alpestrului": "alpestru",
    "alpina": "alpin",
    "alpină": "alpin",
    "alpine": "alpin",
    "alpinei": "alpin",
    "alpinele": "alpin",
    "alpinelor": "alpin",
    "alpini": "alpin",
    "alpinii": "alpin",
    "alpinilor": "alpin",
    "alpinul": "alpin",
    "alpinului": "alpin",
    "alpinismul": "alpinism",
    "alpinismului": "alpinism",
    "altă": "alt",
    "alte": "alt",
    "altei": "alt",
    "alți": "alt",
    "altor": "alt",
    "altui": "alt",
    "altaica": "altaic",
    "altaică": "altaic",
    "altaice": "altaic",
    "altaicei": "altaic",
    "altaicele": "altaic",
    "altaicelor": "altaic",
    "altaici": "altaic",
    "altaicii": "altaic",
    "altaicilor": "altaic",
    "altaicul": "altaic",
    "altaicului": "altaic",
    "altare": "altar",
    "altarele": "altar",
    "altarelor": "altar",
    "altarul": "altar",
    "altarului": "altar",
    "al'ceva": "altceva",
    "altcuiva": "altcineva",
    "alteră": "altera",
    "alterai": "altera",
    "alteram": "altera",
    "alterăm": "altera",
    "alterând": "altera",
    "alterându": "altera",
    "alterară": "altera",
    "alterarăm": "altera",
    "alterarăți": "altera",
    "alterase": "altera",
    "alterasem": "altera",
    "alteraseră": "altera",
    "alteraserăm": "altera",
    "alteraserăți": "altera",
    "alteraseși": "altera",
    "alterași": "altera",
    "alterat": "altera",
    "alterați": "altera",
    "alteratu": "altera",
    "alterau": "altera",
    "alterează": "altera",
    "alterez": "altera",
    "altereze": "altera",
    "alterezi": "altera",
    "nealterând": "altera",
    "nealterându": "altera",
    "nemaialterând": "altera",
    "nemaialterându": "altera",
    "alterabila": "alterabil",
    "alterabilă": "alterabil",
    "alterabile": "alterabil",
    "alterabilei": "alterabil",
    "alterabilele": "alterabil",
    "alterabilelor": "alterabil",
    "alterabili": "alterabil",
    "alterabilii": "alterabil",
    "alterabililor": "alterabil",
    "alterabilul": "alterabil",
    "alterabilului": "alterabil",
    "alterarea": "alterare",
    "alterări": "alterare",
    "alterării": "alterare",
    "alterările": "alterare",
    "alterata": "alterat",
    "alterată": "alterat",
    "alterate": "alterat",
    "alteratei": "alterat",
    "alteratele": "alterat",
    "alteratelor": "alterat",
    "alterați": "alterat",
    "alterații": "alterat",
    "alteraților": "alterat",
    "alteratul": "alterat",
    "alteratului": "alterat",
    "altercația": "altercație",
    "altercației": "altercație",
    "altercații": "altercație",
    "altercațiile": "altercație",
    "altercațiilor": "altercație",
    "alterna": "altern",
    "alternă": "altern",
    "alterne": "altern",
    "alternei": "altern",
    "alternele": "altern",
    "alternelor": "altern",
    "alterni": "altern",
    "alternii": "altern",
    "alternilor": "altern",
    "alternul": "altern",
    "alternului": "altern",
    "alternă": "alterna",
    "alternai": "alterna",
    "alternam": "alterna",
    "alternăm": "alterna",
    "alternând": "alterna",
    "alternându": "alterna",
    "alternară": "alterna",
    "alternarăm": "alterna",
    "alternarăți": "alterna",
    "alternase": "alterna",
    "alternasem": "alterna",
    "alternaseră": "alterna",
    "alternaserăm": "alterna",
    "alternaserăți": "alterna",
    "alternaseși": "alterna",
    "alternași": "alterna",
    "alternat": "alterna",
    "alternați": "alterna",
    "alternatu": "alterna",
    "alternau": "alterna",
    "alternează": "alterna",
    "alternez": "alterna",
    "alterneze": "alterna",
    "alternezi": "alterna",
    "nealternând": "alterna",
    "nealternându": "alterna",
    "nemaialternând": "alterna",
    "nemaialternându": "alterna",
    "alternanța": "alternanță",
    "alternarea": "alternare",
    "alternări": "alternare",
    "alternării": "alternare",
    "alternările": "alternare",
    "alternata": "alternat",
    "alternată": "alternat",
    "alternate": "alternat",
    "alternatei": "alternat",
    "alternatele": "alternat",
    "alternatelor": "alternat",
    "alternați": "alternat",
    "alternații": "alternat",
    "alternaților": "alternat",
    "alternatul": "alternat",
    "alternatului": "alternat",
    "alternativa": "alternativ",
    "alternativă": "alternativ",
    "alternative": "alternativ",
    "alternativei": "alternativ",
    "alternativele": "alternativ",
    "alternativelor": "alternativ",
    "alternativi": "alternativ",
    "alternativii": "alternativ",
    "alternativilor": "alternativ",
    "alternativul": "alternativ",
    "alternativului": "alternativ",
    "alternativa": "alternativă",
    "alternative": "alternativă",
    "alternativei": "alternativă",
    "alternativele": "alternativă",
    "alternativelor": "alternativă",
    "alteța": "alteță",
    "altețe": "alteță",
    "alteței": "alteță",
    "altețele": "alteță",
    "altețelor": "alteță",
    "altimetre": "altimetru",
    "altimetrele": "altimetru",
    "altimetrelor": "altimetru",
    "altimetrul": "altimetru",
    "altimetrului": "altimetru",
    "altista": "altist",
    "altistă": "altist",
    "altiste": "altist",
    "altistei": "altist",
    "altistele": "altist",
    "altistelor": "altist",
    "altiști": "altist",
    "altiștii": "altist",
    "altiștilor": "altist",
    "altistul": "altist",
    "altistului": "altist",
    "alt.": "altitudine",
    "altitudinea": "altitudine",
    "altitudini": "altitudine",
    "altitudinii": "altitudine",
    "altitudinile": "altitudine",
    "altitudinilor": "altitudine",
    "altruismul": "altruism",
    "altruismului": "altruism",
    "altruista": "altruist",
    "altruistă": "altruist",
    "altruiste": "altruist",
    "altruistei": "altruist",
    "altruistele": "altruist",
    "altruistelor": "altruist",
    "altruiști": "altruist",
    "altruiștii": "altruist",
    "altruiștilor": "altruist",
    "altruistul": "altruist",
    "altruistului": "altruist",
    "alta": "altul",
    "alteia": "altul",
    "altele": "altul",
    "alții": "altul",
    "altora": "altul",
    "altuia": "altul",
    "alumina": "alumină",
    "aluminiul": "aluminiu",
    "aluminiului": "aluminiu",
    "aluni": "alun",
    "alunii": "alun",
    "alunilor": "alun",
    "alunul": "alun",
    "alunului": "alun",
    "aluna": "alună",
    "alune": "alună",
    "alunei": "alună",
    "alunele": "alună",
    "alunelor": "alună",
    "alunec": "aluneca",
    "alunecă": "aluneca",
    "alunecai": "aluneca",
    "alunecam": "aluneca",
    "alunecăm": "aluneca",
    "alunecând": "aluneca",
    "alunecându": "aluneca",
    "alunecară": "aluneca",
    "alunecarăm": "aluneca",
    "alunecarăți": "aluneca",
    "alunecase": "aluneca",
    "alunecasem": "aluneca",
    "alunecaseră": "aluneca",
    "alunecaserăm": "aluneca",
    "alunecaserăți": "aluneca",
    "alunecaseși": "aluneca",
    "alunecași": "aluneca",
    "alunecat": "aluneca",
    "alunecați": "aluneca",
    "alunecatu": "aluneca",
    "alunecau": "aluneca",
    "alunece": "aluneca",
    "aluneci": "aluneca",
    "nealunecând": "aluneca",
    "nealunecându": "aluneca",
    "nemaialunecând": "aluneca",
    "nemaialunecându": "aluneca",
    "alunecarea": "alunecare",
    "alunecări": "alunecare",
    "alunecării": "alunecare",
    "alunecările": "alunecare",
    "alunecata": "alunecat",
    "alunecată": "alunecat",
    "alunecate": "alunecat",
    "alunecatei": "alunecat",
    "alunecatele": "alunecat",
    "alunecatelor": "alunecat",
    "alunecați": "alunecat",
    "alunecații": "alunecat",
    "alunecaților": "alunecat",
    "alunecatul": "alunecat",
    "alunecatului": "alunecat",
    "alunecătoare": "alunecător",
    "alunecătoarea": "alunecător",
    "alunecătoarei": "alunecător",
    "alunecătoarele": "alunecător",
    "alunecătoarelor": "alunecător",
    "alunecători": "alunecător",
    "alunecătorii": "alunecător",
    "alunecătorilor": "alunecător",
    "alunecătorul": "alunecător",
    "alunecătorului": "alunecător",
    "alunecătura": "alunecătură",
    "alunecături": "alunecătură",
    "alunecăturii": "alunecătură",
    "alunecăturile": "alunecătură",
    "alunecăturilor": "alunecătură",
    "alunecoasa": "alunecos",
    "alunecoasă": "alunecos",
    "alunecoase": "alunecos",
    "alunecoasei": "alunecos",
    "alunecoasele": "alunecos",
    "alunecoaselor": "alunecos",
    "alunecoși": "alunecos",
    "alunecoșii": "alunecos",
    "alunecoșilor": "alunecos",
    "alunecosul": "alunecos",
    "alunecosului": "alunecos",
    "alung": "alunga",
    "alungă": "alunga",
    "alungai": "alunga",
    "alungam": "alunga",
    "alungăm": "alunga",
    "alungând": "alunga",
    "alungându": "alunga",
    "alungară": "alunga",
    "alungarăm": "alunga",
    "alungarăți": "alunga",
    "alungase": "alunga",
    "alungasem": "alunga",
    "alungaseră": "alunga",
    "alungaserăm": "alunga",
    "alungaserăți": "alunga",
    "alungaseși": "alunga",
    "alungași": "alunga",
    "alungat": "alunga",
    "alungați": "alunga",
    "alungatu": "alunga",
    "alungau": "alunga",
    "alunge": "alunga",
    "alungi": "alunga",
    "nealungând": "alunga",
    "nealungându": "alunga",
    "nemaialungând": "alunga",
    "nemaialungându": "alunga",
    "alungarea": "alungare",
    "alungări": "alungare",
    "alungării": "alungare",
    "alungările": "alungare",
    "alungata": "alungat",
    "alungată": "alungat",
    "alungate": "alungat",
    "alungatei": "alungat",
    "alungatele": "alungat",
    "alungatelor": "alungat",
    "alungați": "alungat",
    "alungații": "alungat",
    "alungaților": "alungat",
    "alungatul": "alungat",
    "alungatului": "alungat",
    "alungătoarea": "alungătoare",
    "alungătoarei": "alungătoare",
    "alungătoarele": "alungătoare",
    "alungătoarelor": "alungătoare",
    "alungătoare": "alungător",
    "alungătoarea": "alungător",
    "alungătoarei": "alungător",
    "alungătoarele": "alungător",
    "alungătoarelor": "alungător",
    "alungători": "alungător",
    "alungătorii": "alungător",
    "alungătorilor": "alungător",
    "alungătorul": "alungător",
    "alungătorului": "alungător",
    "alungea": "alungi",
    "alungeai": "alungi",
    "alungeam": "alungi",
    "alungească": "alungi",
    "alungeați": "alungi",
    "alungeau": "alungi",
    "alungesc": "alungi",
    "alungește": "alungi",
    "alungești": "alungi",
    "alungii": "alungi",
    "alungim": "alungi",
    "alungind": "alungi",
    "alungindu": "alungi",
    "alungiră": "alungi",
    "alungirăm": "alungi",
    "alungirăți": "alungi",
    "alungise": "alungi",
    "alungisem": "alungi",
    "alungiseră": "alungi",
    "alungiserăm": "alungi",
    "alungiserăți": "alungi",
    "alungiseși": "alungi",
    "alungiși": "alungi",
    "alungit": "alungi",
    "alungiți": "alungi",
    "alungitu": "alungi",
    "alungita": "alungit",
    "alungită": "alungit",
    "alungite": "alungit",
    "alungitei": "alungit",
    "alungitele": "alungit",
    "alungitelor": "alungit",
    "alungiți": "alungit",
    "alungiții": "alungit",
    "alungiților": "alungit",
    "alungitul": "alungit",
    "alungitului": "alungit",
    "alunișul": "aluniș",
    "alunișului": "aluniș",
    "alunișuri": "aluniș",
    "alunișurile": "aluniș",
    "alunișurilor": "aluniș",
    "alunia": "aluniu",
    "alunie": "aluniu",
    "aluniei": "aluniu",
    "alunii": "aluniu",
    "aluniii": "aluniu",
    "aluniile": "aluniu",
    "aluniilor": "aluniu",
    "aluniul": "aluniu",
    "aluniului": "aluniu",
    "aluniză": "aluniza",
    "alunizai": "aluniza",
    "alunizam": "aluniza",
    "alunizăm": "aluniza",
    "alunizând": "aluniza",
    "alunizându": "aluniza",
    "alunizară": "aluniza",
    "alunizarăm": "aluniza",
    "alunizarăți": "aluniza",
    "alunizase": "aluniza",
    "alunizasem": "aluniza",
    "alunizaseră": "aluniza",
    "alunizaserăm": "aluniza",
    "alunizaserăți": "aluniza",
    "alunizaseși": "aluniza",
    "alunizași": "aluniza",
    "alunizat": "aluniza",
    "alunizați": "aluniza",
    "alunizatu": "aluniza",
    "alunizau": "aluniza",
    "alunizează": "aluniza",
    "alunizez": "aluniza",
    "alunizeze": "aluniza",
    "alunizezi": "aluniza",
    "nealunizând": "aluniza",
    "nealunizându": "aluniza",
    "nemaialunizând": "aluniza",
    "nemaialunizându": "aluniza",
    "alunizarea": "alunizare",
    "alunizări": "alunizare",
    "alunizării": "alunizare",
    "alunizările": "alunizare",
    "alunizata": "alunizat",
    "alunizată": "alunizat",
    "alunizate": "alunizat",
    "alunizatei": "alunizat",
    "alunizatele": "alunizat",
    "alunizatelor": "alunizat",
    "alunizați": "alunizat",
    "alunizații": "alunizat",
    "alunizaților": "alunizat",
    "alunizatul": "alunizat",
    "alunizatului": "alunizat",
    "alura": "alură",
    "aluri": "alură",
    "alurii": "alură",
    "alurile": "alură",
    "alurilor": "alură",
    "aluviala": "aluvial",
    "aluvială": "aluvial",
    "aluviale": "aluvial",
    "aluvialei": "aluvial",
    "aluvialele": "aluvial",
    "aluvialelor": "aluvial",
    "aluviali": "aluvial",
    "aluvialii": "aluvial",
    "aluvialilor": "aluvial",
    "aluvialul": "aluvial",
    "aluvialului": "aluvial",
    "aluvionara": "aluvionar",
    "aluvionară": "aluvionar",
    "aluvionare": "aluvionar",
    "aluvionarei": "aluvionar",
    "aluvionarele": "aluvionar",
    "aluvionarelor": "aluvionar",
    "aluvionari": "aluvionar",
    "aluvionarii": "aluvionar",
    "aluvionarilor": "aluvionar",
    "aluvionarul": "aluvionar",
    "aluvionarului": "aluvionar",
    "aluviunea": "aluviune",
    "aluviuni": "aluviune",
    "aluviunii": "aluviune",
    "aluviunile": "aluviune",
    "aluviunilor": "aluviune",
    "aluzia": "aluzie",
    "aluzii": "aluzie",
    "aluziii": "aluzie",
    "aluziile": "aluzie",
    "aluziilor": "aluzie",
    "alveolara": "alveolar",
    "alveolară": "alveolar",
    "alveolare": "alveolar",
    "alveolarei": "alveolar",
    "alveolarele": "alveolar",
    "alveolarelor": "alveolar",
    "alveolari": "alveolar",
    "alveolarii": "alveolar",
    "alveolarilor": "alveolar",
    "alveolarul": "alveolar",
    "alveolarului": "alveolar",
    "amabila": "amabil",
    "amabilă": "amabil",
    "amabile": "amabil",
    "amabilei": "amabil",
    "amabilele": "amabil",
    "amabilelor": "amabil",
    "amabili": "amabil",
    "amabilii": "amabil",
    "amabililor": "amabil",
    "amabilul": "amabil",
    "amabilului": "amabil",
    "amabilitatea": "amabilitate",
    "amabilități": "amabilitate",
    "amabilității": "amabilitate",
    "amabilitățile": "amabilitate",
    "amabilităților": "amabilitate",
    "amăgea": "amăgi",
    "amăgeai": "amăgi",
    "amăgeam": "amăgi",
    "amăgească": "amăgi",
    "amăgeați": "amăgi",
    "amăgeau": "amăgi",
    "amăgesc": "amăgi",
    "amăgește": "amăgi",
    "amăgești": "amăgi",
    "amăgii": "amăgi",
    "amăgim": "amăgi",
    "amăgind": "amăgi",
    "amăgindu": "amăgi",
    "amăgiră": "amăgi",
    "amăgirăm": "amăgi",
    "amăgirăți": "amăgi",
    "amăgise": "amăgi",
    "amăgisem": "amăgi",
    "amăgiseră": "amăgi",
    "amăgiserăm": "amăgi",
    "amăgiserăți": "amăgi",
    "amăgiseși": "amăgi",
    "amăgiși": "amăgi",
    "amăgit": "amăgi",
    "amăgiți": "amăgi",
    "amăgitu": "amăgi",
    "neamăgind": "amăgi",
    "neamăgindu": "amăgi",
    "nemaiamăgind": "amăgi",
    "nemaiamăgindu": "amăgi",
    "amăgirea": "amăgire",
    "amăgiri": "amăgire",
    "amăgirii": "amăgire",
    "amăgirile": "amăgire",
    "amăgita": "amăgit",
    "amăgită": "amăgit",
    "amăgite": "amăgit",
    "amăgitei": "amăgit",
    "amăgitele": "amăgit",
    "amăgitelor": "amăgit",
    "amăgiți": "amăgit",
    "amăgiții": "amăgit",
    "amăgiților": "amăgit",
    "amăgitul": "amăgit",
    "amăgitului": "amăgit",
    "amăgita": "amăgită",
    "amăgite": "amăgită",
    "amăgitei": "amăgită",
    "amăgitele": "amăgită",
    "amăgitelor": "amăgită",
    "amăgitoare": "amăgitor",
    "amăgitoarea": "amăgitor",
    "amăgitoarei": "amăgitor",
    "amăgitoarele": "amăgitor",
    "amăgitoarelor": "amăgitor",
    "amăgitori": "amăgitor",
    "amăgitorii": "amăgitor",
    "amăgitorilor": "amăgitor",
    "amăgitorul": "amăgitor",
    "amăgitorului": "amăgitor",
    "amalgame": "amalgam",
    "amalgamele": "amalgam",
    "amalgamelor": "amalgam",
    "amalgamul": "amalgam",
    "amalgamului": "amalgam",
    "amân": "amâna",
    "amână": "amâna",
    "amânai": "amâna",
    "amânam": "amâna",
    "amânăm": "amâna",
    "amânând": "amâna",
    "amânându": "amâna",
    "amânară": "amâna",
    "amânarăm": "amâna",
    "amânarăți": "amâna",
    "amânase": "amâna",
    "amânasem": "amâna",
    "amânaseră": "amâna",
    "amânaserăm": "amâna",
    "amânaserăți": "amâna",
    "amânaseși": "amâna",
    "amânași": "amâna",
    "amânat": "amâna",
    "amânați": "amâna",
    "amânatu": "amâna",
    "amânau": "amâna",
    "amâne": "amâna",
    "amâni": "amâna",
    "neamânând": "amâna",
    "neamânându": "amâna",
    "nemaiamânând": "amâna",
    "nemaiamânându": "amâna",
    "amânarea": "amânare",
    "amânări": "amânare",
    "amânării": "amânare",
    "amânările": "amânare",
    "amânata": "amânat",
    "amânată": "amânat",
    "amânate": "amânat",
    "amânatei": "amânat",
    "amânatele": "amânat",
    "amânatelor": "amânat",
    "amânați": "amânat",
    "amânații": "amânat",
    "amânaților": "amânat",
    "amânatul": "amânat",
    "amânatului": "amânat",
    "amândouă": "amândoi",
    "amânduror": "amândoi",
    "amândurora": "amândoi",
    "amanete": "amanet",
    "amanetele": "amanet",
    "amanetelor": "amanet",
    "amanetul": "amanet",
    "amanetului": "amanet",
    "amanetă": "amaneta",
    "amanetai": "amaneta",
    "amanetam": "amaneta",
    "amanetăm": "amaneta",
    "amanetând": "amaneta",
    "amanetându": "amaneta",
    "amanetară": "amaneta",
    "amanetarăm": "amaneta",
    "amanetarăți": "amaneta",
    "amanetase": "amaneta",
    "amanetasem": "amaneta",
    "amanetaseră": "amaneta",
    "amanetaserăm": "amaneta",
    "amanetaserăți": "amaneta",
    "amanetaseși": "amaneta",
    "amanetași": "amaneta",
    "amanetat": "amaneta",
    "amanetați": "amaneta",
    "amanetatu": "amaneta",
    "amanetau": "amaneta",
    "amanetează": "amaneta",
    "amanetez": "amaneta",
    "amaneteze": "amaneta",
    "amanetezi": "amaneta",
    "neamanetând": "amaneta",
    "neamanetându": "amaneta",
    "nemaiamanetând": "amaneta",
    "nemaiamanetându": "amaneta",
    "amanetarea": "amanetare",
    "amanetări": "amanetare",
    "amanetării": "amanetare",
    "amanetările": "amanetare",
    "amanetata": "amanetat",
    "amanetată": "amanetat",
    "amanetate": "amanetat",
    "amanetatei": "amanetat",
    "amanetatele": "amanetat",
    "amanetatelor": "amanetat",
    "amanetați": "amanetat",
    "amanetații": "amanetat",
    "amanetaților": "amanetat",
    "amanetatul": "amanetat",
    "amanetatului": "amanetat",
    "amanți": "amant",
    "amanții": "amant",
    "amanților": "amant",
    "amantul": "amant",
    "amantului": "amant",
    "amanta": "amantă",
    "amante": "amantă",
    "amantei": "amantă",
    "amantele": "amantă",
    "amantelor": "amantă",
    "amănunte": "amănunt",
    "amănuntele": "amănunt",
    "amănuntelor": "amănunt",
    "amănuntul": "amănunt",
    "amănuntului": "amănunt",
    "amănunțea": "amănunți",
    "amănunțeai": "amănunți",
    "amănunțeam": "amănunți",
    "amănunțească": "amănunți",
    "amănunțeați": "amănunți",
    "amănunțeau": "amănunți",
    "amănunțesc": "amănunți",
    "amănunțește": "amănunți",
    "amănunțești": "amănunți",
    "amănunții": "amănunți",
    "amănunțim": "amănunți",
    "amănunțind": "amănunți",
    "amănunțindu": "amănunți",
    "amănunțiră": "amănunți",
    "amănunțirăm": "amănunți",
    "amănunțirăți": "amănunți",
    "amănunțise": "amănunți",
    "amănunțisem": "amănunți",
    "amănunțiseră": "amănunți",
    "amănunțiserăm": "amănunți",
    "amănunțiserăți": "amănunți",
    "amănunțiseși": "amănunți",
    "amănunțiși": "amănunți",
    "amănunțit": "amănunți",
    "amănunțiți": "amănunți",
    "amănunțitu": "amănunți",
    "amănunțirea": "amănunțire",
    "amănunțiri": "amănunțire",
    "amănunțirii": "amănunțire",
    "amănunțirile": "amănunțire",
    "amănunțirilor": "amănunțire",
    "amănunțita": "amănunțit",
    "amănunțită": "amănunțit",
    "amănunțite": "amănunțit",
    "amănunțitei": "amănunțit",
    "amănunțitele": "amănunțit",
    "amănunțitelor": "amănunțit",
    "amănunțiți": "amănunțit",
    "amănunțiții": "amănunțit",
    "amănunțiților": "amănunțit",
    "amănunțitul": "amănunțit",
    "amănunțitului": "amănunțit",
    "amara": "amar",
    "amară": "amar",
    "amare": "amar",
    "amarei": "amar",
    "amarele": "amar",
    "amarelor": "amar",
    "amari": "amar",
    "amarii": "amar",
    "amarilor": "amar",
    "amarul": "amar",
    "amarului": "amar",
    "amărăciunea": "amărăciune",
    "amărăciuni": "amărăciune",
    "amărăciunii": "amărăciune",
    "amărăciunile": "amărăciune",
    "amărăciunilor": "amărăciune",
    "amărârea": "amărâre",
    "amărâri": "amărâre",
    "amărârii": "amărâre",
    "amărârile": "amărâre",
    "amărâta": "amărât",
    "amărâtă": "amărât",
    "amărâte": "amărât",
    "amărâtei": "amărât",
    "amărâtele": "amărât",
    "amărâtelor": "amărât",
    "amărâți": "amărât",
    "amărâții": "amărât",
    "amărâților": "amărât",
    "amărâtu": "amărât",
    "amărâtu-": "amărât",
    "amărâtul": "amărât",
    "amărâtului": "amărât",
    "amărâta": "amărâtă",
    "amărâte": "amărâtă",
    "amărâtei": "amărâtă",
    "amărâtele": "amărâtă",
    "amărâtelor": "amărâtă",
    "amăra": "amărî",
    "amărai": "amărî",
    "amărâi": "amărî",
    "amăram": "amărî",
    "amărâm": "amărî",
    "amărând": "amărî",
    "amărându": "amărî",
    "amărâră": "amărî",
    "amărârăm": "amărî",
    "amărârăți": "amărî",
    "amărăsc": "amărî",
    "amărască": "amărî",
    "amărâse": "amărî",
    "amărâsem": "amărî",
    "amărâseră": "amărî",
    "amărâserăm": "amărî",
    "amărâserăți": "amărî",
    "amărâseși": "amărî",
    "amărâși": "amărî",
    "amărăște": "amărî",
    "amărăști": "amărî",
    "amărât": "amărî",
    "amărați": "amărî",
    "amărâți": "amărî",
    "amărâtu": "amărî",
    "amărau": "amărî",
    "neamărând": "amărî",
    "neamărându": "amărî",
    "nemaiamărând": "amărî",
    "nemaiamărându": "amărî",
    "amarnica": "amarnic",
    "amarnică": "amarnic",
    "amarnice": "amarnic",
    "amarnicei": "amarnic",
    "amarnicele": "amarnic",
    "amarnicelor": "amarnic",
    "amarnici": "amarnic",
    "amarnicii": "amarnic",
    "amarnicilor": "amarnic",
    "amarnicul": "amarnic",
    "amarnicului": "amarnic",
    "amăruia": "amărui",
    "amăruie": "amărui",
    "amăruiei": "amărui",
    "amăruiele": "amărui",
    "amăruielor": "amărui",
    "amăruii": "amărui",
    "amăruilor": "amărui",
    "amăruiul": "amărui",
    "amăruiului": "amărui",
    "amatoarea": "amatoare",
    "amatoarei": "amatoare",
    "amatoarele": "amatoare",
    "amatoarelor": "amatoare",
    "amatoare": "amator",
    "amatoarea": "amator",
    "amatoarei": "amator",
    "amatoarele": "amator",
    "amatoarelor": "amator",
    "amatori": "amator",
    "amatorii": "amator",
    "amatorilor": "amator",
    "amatorul": "amator",
    "amatorului": "amator",
    "amazoana": "amazoană",
    "amazoane": "amazoană",
    "amazoanei": "amazoană",
    "amazoanele": "amazoană",
    "amazoanelor": "amazoană",
    "amazoniana": "amazonian",
    "amazoniană": "amazonian",
    "amazoniane": "amazonian",
    "amazonianei": "amazonian",
    "amazonianele": "amazonian",
    "amazonianelor": "amazonian",
    "amazonianul": "amazonian",
    "amazonianului": "amazonian",
    "amazonieni": "amazonian",
    "amazonienii": "amazonian",
    "amazonienilor": "amazonian",
    "amazoniana": "amazoniană",
    "amazoniene": "amazoniană",
    "amazonienei": "amazoniană",
    "amazonienele": "amazoniană",
    "amazonienelor": "amazoniană",
    "ambală": "ambala",
    "ambalai": "ambala",
    "ambalam": "ambala",
    "ambalăm": "ambala",
    "ambalând": "ambala",
    "ambalându": "ambala",
    "ambalară": "ambala",
    "ambalarăm": "ambala",
    "ambalarăți": "ambala",
    "ambalase": "ambala",
    "ambalasem": "ambala",
    "ambalaseră": "ambala",
    "ambalaserăm": "ambala",
    "ambalaserăți": "ambala",
    "ambalaseși": "ambala",
    "ambalași": "ambala",
    "ambalat": "ambala",
    "ambalați": "ambala",
    "ambalatu": "ambala",
    "ambalau": "ambala",
    "ambalează": "ambala",
    "ambalez": "ambala",
    "ambaleze": "ambala",
    "ambalezi": "ambala",
    "neambalând": "ambala",
    "neambalându": "ambala",
    "nemaiambalând": "ambala",
    "nemaiambalându": "ambala",
    "ambalaje": "ambalaj",
    "ambalajelor": "ambalaj",
    "ambalajul": "ambalaj",
    "ambalajului": "ambalaj",
    "ambalarea": "ambalare",
    "ambalări": "ambalare",
    "ambalării": "ambalare",
    "ambalările": "ambalare",
    "ambalata": "ambalat",
    "ambalată": "ambalat",
    "ambalate": "ambalat",
    "ambalatei": "ambalat",
    "ambalatele": "ambalat",
    "ambalatelor": "ambalat",
    "ambalați": "ambalat",
    "ambalații": "ambalat",
    "ambalaților": "ambalat",
    "ambalatul": "ambalat",
    "ambalatului": "ambalat",
    "ambarcadere": "ambarcader",
    "ambarcaderele": "ambarcader",
    "ambarcaderelor": "ambarcader",
    "ambarcaderul": "ambarcader",
    "ambarcaderului": "ambarcader",
    "ambarcația": "ambarcație",
    "ambarcației": "ambarcație",
    "ambarcații": "ambarcație",
    "ambarcațiile": "ambarcație",
    "ambarcațiilor": "ambarcație",
    "ambarcațiunea": "ambarcațiune",
    "ambarcațiuni": "ambarcațiune",
    "ambarcațiunii": "ambarcațiune",
    "ambarcațiunile": "ambarcațiune",
    "ambarcațiunilor": "ambarcațiune",
    "ambasada": "ambasadă",
    "ambasade": "ambasadă",
    "ambasadei": "ambasadă",
    "ambasadele": "ambasadă",
    "ambasadelor": "ambasadă",
    "ambasadoarea": "ambasadoare",
    "ambasadoarei": "ambasadoare",
    "ambasadoarele": "ambasadoare",
    "ambasadoarelor": "ambasadoare",
    "Amb.": "ambasador",
    "ambasadori": "ambasador",
    "ambasadorii": "ambasador",
    "ambasadorilor": "ambasador",
    "ambasadorul": "ambasador",
    "ambasadorului": "ambasador",
    "ambianta": "ambiant",
    "ambiantă": "ambiant",
    "ambiante": "ambiant",
    "ambiantei": "ambiant",
    "ambiantele": "ambiant",
    "ambiantelor": "ambiant",
    "ambianți": "ambiant",
    "ambianții": "ambiant",
    "ambianților": "ambiant",
    "ambiantul": "ambiant",
    "ambiantului": "ambiant",
    "ambianța": "ambianță",
    "ambianțe": "ambianță",
    "ambianței": "ambianță",
    "ambianțele": "ambianță",
    "ambianțelor": "ambianță",
    "ambidextra": "ambidextru",
    "ambidextră": "ambidextru",
    "ambidextre": "ambidextru",
    "ambidextrei": "ambidextru",
    "ambidextrele": "ambidextru",
    "ambidextrelor": "ambidextru",
    "ambidextri": "ambidextru",
    "ambidextrii": "ambidextru",
    "ambidextrilor": "ambidextru",
    "ambidextrul": "ambidextru",
    "ambidextrului": "ambidextru",
    "ambientul": "ambient",
    "ambientului": "ambient",
    "ambigena": "ambigen",
    "ambigenă": "ambigen",
    "ambigene": "ambigen",
    "ambigenei": "ambigen",
    "ambigenele": "ambigen",
    "ambigenelor": "ambigen",
    "ambigeni": "ambigen",
    "ambigenii": "ambigen",
    "ambigenilor": "ambigen",
    "ambigenul": "ambigen",
    "ambigenului": "ambigen",
    "ambiguitatea": "ambiguitate",
    "ambiguități": "ambiguitate",
    "ambiguității": "ambiguitate",
    "ambiguitățile": "ambiguitate",
    "ambiguităților": "ambiguitate",
    "ambigua": "ambiguu",
    "ambiguă": "ambiguu",
    "ambigue": "ambiguu",
    "ambiguei": "ambiguu",
    "ambiguele": "ambiguu",
    "ambiguelor": "ambiguu",
    "ambigui": "ambiguu",
    "ambiguii": "ambiguu",
    "ambiguilor": "ambiguu",
    "ambiguul": "ambiguu",
    "ambiguului": "ambiguu",
    "ambele": "ambii",
    "ambelor": "ambii",
    "ambilor": "ambii",
    "ambiția": "ambiție",
    "ambiției": "ambiție",
    "ambiții": "ambiție",
    "ambițiile": "ambiție",
    "ambițiilor": "ambiție",
    "ambiționă": "ambiționa",
    "ambiționai": "ambiționa",
    "ambiționam": "ambiționa",
    "ambiționăm": "ambiționa",
    "ambiționând": "ambiționa",
    "ambiționându": "ambiționa",
    "ambiționară": "ambiționa",
    "ambiționarăm": "ambiționa",
    "ambiționarăți": "ambiționa",
    "ambiționase": "ambiționa",
    "ambiționasem": "ambiționa",
    "ambiționaseră": "ambiționa",
    "ambiționaserăm": "ambiționa",
    "ambiționaserăți": "ambiționa",
    "ambiționaseși": "ambiționa",
    "ambiționași": "ambiționa",
    "ambiționat": "ambiționa",
    "ambiționați": "ambiționa",
    "ambiționatu": "ambiționa",
    "ambiționau": "ambiționa",
    "ambiționează": "ambiționa",
    "ambiționez": "ambiționa",
    "ambiționeze": "ambiționa",
    "ambiționezi": "ambiționa",
    "neambiționând": "ambiționa",
    "neambiționându": "ambiționa",
    "nemaiambiționând": "ambiționa",
    "nemaiambiționându": "ambiționa",
    "ambiționarea": "ambiționare",
    "ambiționări": "ambiționare",
    "ambiționării": "ambiționare",
    "ambiționările": "ambiționare",
    "ambiționata": "ambiționat",
    "ambiționată": "ambiționat",
    "ambiționate": "ambiționat",
    "ambiționatei": "ambiționat",
    "ambiționatele": "ambiționat",
    "ambiționatelor": "ambiționat",
    "ambiționați": "ambiționat",
    "ambiționații": "ambiționat",
    "ambiționaților": "ambiționat",
    "ambiționatul": "ambiționat",
    "ambiționatului": "ambiționat",
    "ambițioasa": "ambițios",
    "ambițioasă": "ambițios",
    "ambițioase": "ambițios",
    "ambițioasei": "ambițios",
    "ambițioasele": "ambițios",
    "ambițioaselor": "ambițios",
    "ambițioși": "ambițios",
    "ambițioșii": "ambițios",
    "ambițioșilor": "ambițios",
    "ambițiosul": "ambițios",
    "ambițiosului": "ambițios",
    "ambivalenta": "ambivalent",
    "ambivalentă": "ambivalent",
    "ambivalente": "ambivalent",
    "ambivalentei": "ambivalent",
    "ambivalentele": "ambivalent",
    "ambivalentelor": "ambivalent",
    "ambivalenți": "ambivalent",
    "ambivalenții": "ambivalent",
    "ambivalenților": "ambivalent",
    "ambivalentul": "ambivalent",
    "ambivalentului": "ambivalent",
    "ambivalența": "ambivalență",
    "ambivalențe": "ambivalență",
    "ambivalenței": "ambivalență",
    "ambivalențele": "ambivalență",
    "ambivalențelor": "ambivalență",
    "ambra": "ambră",
    "ambre": "ambră",
    "ambrei": "ambră",
    "ambrele": "ambră",
    "ambrelor": "ambră",
    "ambreiaje": "ambreiaj",
    "ambreiajele": "ambreiaj",
    "ambreiajelor": "ambreiaj",
    "ambreiajul": "ambreiaj",
    "ambreiajului": "ambreiaj",
    "ambroziaca": "ambroziac",
    "ambroziacă": "ambroziac",
    "ambroziace": "ambroziac",
    "ambroziacei": "ambroziac",
    "ambroziacele": "ambroziac",
    "ambroziacelor": "ambroziac",
    "ambroziaci": "ambroziac",
    "ambroziacii": "ambroziac",
    "ambroziacilor": "ambroziac",
    "ambroziacul": "ambroziac",
    "ambroziacului": "ambroziac",
    "ambrozia": "ambrozie",
    "ambroziei": "ambrozie",
    "ambulanta": "ambulant",
    "ambulantă": "ambulant",
    "ambulante": "ambulant",
    "ambulantei": "ambulant",
    "ambulantele": "ambulant",
    "ambulantelor": "ambulant",
    "ambulanți": "ambulant",
    "ambulanții": "ambulant",
    "ambulanților": "ambulant",
    "ambulantul": "ambulant",
    "ambulantului": "ambulant",
    "ambulanța": "ambulanță",
    "ambulanțe": "ambulanță",
    "ambulanței": "ambulanță",
    "ambulanțele": "ambulanță",
    "ambulanțelor": "ambulanță",
    "ambulanțieri": "ambulanțier",
    "ambulanțierii": "ambulanțier",
    "ambulanțierilor": "ambulanțier",
    "ambulanțierul": "ambulanțier",
    "ambulanțierului": "ambulanțier",
    "ambulanțiera": "ambulanțieră",
    "ambulanțiere": "ambulanțieră",
    "ambulanțierei": "ambulanțieră",
    "ambulanțierele": "ambulanțieră",
    "ambulanțierelor": "ambulanțieră",
    "ambulatoria": "ambulatoriu",
    "ambulatorie": "ambulatoriu",
    "ambulatoriei": "ambulatoriu",
    "ambulatorii": "ambulatoriu",
    "ambulatoriii": "ambulatoriu",
    "ambulatoriile": "ambulatoriu",
    "ambulatoriilor": "ambulatoriu",
    "ambulatoriul": "ambulatoriu",
    "ambulatoriului": "ambulatoriu",
    "ambuscada": "ambuscadă",
    "ambuscade": "ambuscadă",
    "ambuscadei": "ambuscadă",
    "ambuscadele": "ambuscadă",
    "ambuscadelor": "ambuscadă",
    "amelioră": "ameliora",
    "ameliorai": "ameliora",
    "amelioram": "ameliora",
    "ameliorăm": "ameliora",
    "ameliorând": "ameliora",
    "ameliorându": "ameliora",
    "ameliorară": "ameliora",
    "ameliorarăm": "ameliora",
    "ameliorarăți": "ameliora",
    "ameliorase": "ameliora",
    "ameliorasem": "ameliora",
    "amelioraseră": "ameliora",
    "amelioraserăm": "ameliora",
    "amelioraserăți": "ameliora",
    "amelioraseși": "ameliora",
    "ameliorași": "ameliora",
    "ameliorat": "ameliora",
    "ameliorați": "ameliora",
    "amelioratu": "ameliora",
    "ameliorau": "ameliora",
    "ameliorează": "ameliora",
    "ameliorez": "ameliora",
    "amelioreze": "ameliora",
    "ameliorezi": "ameliora",
    "neameliorând": "ameliora",
    "neameliorându": "ameliora",
    "nemaiameliorând": "ameliora",
    "nemaiameliorându": "ameliora",
    "ameliorarea": "ameliorare",
    "ameliorări": "ameliorare",
    "ameliorării": "ameliorare",
    "ameliorările": "ameliorare",
    "ameliorata": "ameliorat",
    "ameliorată": "ameliorat",
    "ameliorate": "ameliorat",
    "amelioratei": "ameliorat",
    "amelioratele": "ameliorat",
    "amelioratelor": "ameliorat",
    "ameliorați": "ameliorat",
    "ameliorații": "ameliorat",
    "amelioraților": "ameliorat",
    "amelioratul": "ameliorat",
    "amelioratului": "ameliorat",
    "amenajă": "amenaja",
    "amenajai": "amenaja",
    "amenajam": "amenaja",
    "amenajăm": "amenaja",
    "amenajând": "amenaja",
    "amenajându": "amenaja",
    "amenajară": "amenaja",
    "amenajarăm": "amenaja",
    "amenajarăți": "amenaja",
    "amenajase": "amenaja",
    "amenajasem": "amenaja",
    "amenajaseră": "amenaja",
    "amenajaserăm": "amenaja",
    "amenajaserăți": "amenaja",
    "amenajaseși": "amenaja",
    "amenajași": "amenaja",
    "amenajat": "amenaja",
    "amenajați": "amenaja",
    "amenajatu": "amenaja",
    "amenajau": "amenaja",
    "amenajează": "amenaja",
    "amenajez": "amenaja",
    "amenajeze": "amenaja",
    "amenajezi": "amenaja",
    "neamenajând": "amenaja",
    "neamenajându": "amenaja",
    "nemaiamenajând": "amenaja",
    "nemaiamenajându": "amenaja",
    "amenajarea": "amenajare",
    "amenajări": "amenajare",
    "amenajării": "amenajare",
    "amenajările": "amenajare",
    "amenajata": "amenajat",
    "amenajată": "amenajat",
    "amenajate": "amenajat",
    "amenajatei": "amenajat",
    "amenajatele": "amenajat",
    "amenajatelor": "amenajat",
    "amenajați": "amenajat",
    "amenajații": "amenajat",
    "amenajaților": "amenajat",
    "amenajatul": "amenajat",
    "amenajatului": "amenajat",
    "amendă": "amenda",
    "amendai": "amenda",
    "amendam": "amenda",
    "amendăm": "amenda",
    "amendând": "amenda",
    "amendându": "amenda",
    "amendară": "amenda",
    "amendarăm": "amenda",
    "amendarăți": "amenda",
    "amendase": "amenda",
    "amendasem": "amenda",
    "amendaseră": "amenda",
    "amendaserăm": "amenda",
    "amendaserăți": "amenda",
    "amendaseși": "amenda",
    "amendași": "amenda",
    "amendat": "amenda",
    "amendați": "amenda",
    "amendatu": "amenda",
    "amendau": "amenda",
    "amendează": "amenda",
    "amendez": "amenda",
    "amendeze": "amenda",
    "amendezi": "amenda",
    "neamendând": "amenda",
    "neamendându": "amenda",
    "nemaiamendând": "amenda",
    "nemaiamendându": "amenda",
    "amenda": "amendă",
    "amenzi": "amendă",
    "amenzii": "amendă",
    "amenzile": "amendă",
    "amenzilor": "amendă",
    "amendabila": "amendabil",
    "amendabilă": "amendabil",
    "amendabile": "amendabil",
    "amendabilei": "amendabil",
    "amendabilele": "amendabil",
    "amendabilelor": "amendabil",
    "amendabili": "amendabil",
    "amendabilii": "amendabil",
    "amendabililor": "amendabil",
    "amendabilul": "amendabil",
    "amendabilului": "amendabil",
    "amendamente": "amendament",
    "amendamentele": "amendament",
    "amendamentelor": "amendament",
    "amendamentul": "amendament",
    "amendamentului": "amendament",
    "amendarea": "amendare",
    "amendări": "amendare",
    "amendării": "amendare",
    "amendările": "amendare",
    "amendata": "amendat",
    "amendată": "amendat",
    "amendate": "amendat",
    "amendatei": "amendat",
    "amendatele": "amendat",
    "amendatelor": "amendat",
    "amendați": "amendat",
    "amendații": "amendat",
    "amendaților": "amendat",
    "amendatul": "amendat",
    "amendatului": "amendat",
    "amendata": "amendată",
    "amendate": "amendată",
    "amendatei": "amendată",
    "amendatele": "amendată",
    "amendatelor": "amendată",
    "ameninț": "amenința",
    "amenință": "amenința",
    "amenințai": "amenința",
    "amenințam": "amenința",
    "amenințăm": "amenința",
    "amenințând": "amenința",
    "amenințându": "amenința",
    "amenințară": "amenința",
    "amenințarăm": "amenința",
    "amenințarăți": "amenința",
    "amenințase": "amenința",
    "amenințasem": "amenința",
    "amenințaseră": "amenința",
    "amenințaserăm": "amenința",
    "amenințaserăți": "amenința",
    "amenințaseși": "amenința",
    "amenințași": "amenința",
    "amenințat": "amenința",
    "amenințați": "amenința",
    "amenințatu": "amenința",
    "amenințau": "amenința",
    "amenințe": "amenința",
    "ameninți": "amenința",
    "neamenințând": "amenința",
    "neamenințându": "amenința",
    "nemaiamenințând": "amenința",
    "nemaiamenințându": "amenința",
    "amenințarea": "amenințare",
    "amenințări": "amenințare",
    "amenințării": "amenințare",
    "amenințările": "amenințare",
    "amenințărilor": "amenințare",
    "amenințata": "amenințat",
    "amenințată": "amenințat",
    "amenințate": "amenințat",
    "amenințatei": "amenințat",
    "amenințatele": "amenințat",
    "amenințatelor": "amenințat",
    "amenințați": "amenințat",
    "amenințații": "amenințat",
    "amenințaților": "amenințat",
    "amenințatul": "amenințat",
    "amenințatului": "amenințat",
    "amenințata": "amenințată",
    "amenințate": "amenințată",
    "amenințatei": "amenințată",
    "amenințatele": "amenințată",
    "amenințatelor": "amenințată",
    "amenințătoare": "amenințător",
    "amenințătoarea": "amenințător",
    "amenințătoarei": "amenințător",
    "amenințătoarele": "amenințător",
    "amenințătoarelor": "amenințător",
    "amenințători": "amenințător",
    "amenințătorii": "amenințător",
    "amenințătorilor": "amenințător",
    "amenințătorul": "amenințător",
    "amenințătorului": "amenințător",
    "amenorea": "amenoree",
    "Americă": "America",
    "Americi": "America",
    "Americii": "America",
    "americana": "american",
    "americană": "american",
    "americane": "american",
    "americanei": "american",
    "americanele": "american",
    "americanelor": "american",
    "americani": "american",
    "americanii": "american",
    "americanilor": "american",
    "americanul": "american",
    "americanului": "american",
    "americanca": "americancă",
    "americance": "americancă",
    "americancei": "americancă",
    "americancele": "americancă",
    "americancelor": "americancă",
    "amestecul": "amestec",
    "amestecului": "amestec",
    "amestecuri": "amestec",
    "amestecurile": "amestec",
    "amestecurilor": "amestec",
    "amestec": "amesteca",
    "amestecă": "amesteca",
    "amestecai": "amesteca",
    "amestecam": "amesteca",
    "amestecăm": "amesteca",
    "amestecând": "amesteca",
    "amestecându": "amesteca",
    "amestecară": "amesteca",
    "amestecarăm": "amesteca",
    "amestecarăți": "amesteca",
    "amestecase": "amesteca",
    "amestecasem": "amesteca",
    "amestecaseră": "amesteca",
    "amestecaserăm": "amesteca",
    "amestecaserăți": "amesteca",
    "amestecaseși": "amesteca",
    "amestecași": "amesteca",
    "amestecat": "amesteca",
    "amestecați": "amesteca",
    "amestecatu": "amesteca",
    "amestecau": "amesteca",
    "amestece": "amesteca",
    "amesteci": "amesteca",
    "neamestecând": "amesteca",
    "neamestecându": "amesteca",
    "nemaiamestecând": "amesteca",
    "nemaiamestecându": "amesteca",
    "amestecarea": "amestecare",
    "amestecări": "amestecare",
    "amestecării": "amestecare",
    "amestecările": "amestecare",
    "amestecata": "amestecat",
    "amestecată": "amestecat",
    "amestecate": "amestecat",
    "amestecatei": "amestecat",
    "amestecatele": "amestecat",
    "amestecatelor": "amestecat",
    "amestecați": "amestecat",
    "amestecații": "amestecat",
    "amestecaților": "amestecat",
    "amestecatul": "amestecat",
    "amestecatului": "amestecat",
    "amestecătoare": "amestecător",
    "amestecătoarele": "amestecător",
    "amestecătoarelor": "amestecător",
    "amestecători": "amestecător",
    "amestecătorii": "amestecător",
    "amestecătorilor": "amestecător",
    "amestecătorul": "amestecător",
    "amestecătorului": "amestecător",
    "amestecătura": "amestecătură",
    "amestecături": "amestecătură",
    "amestecăturii": "amestecătură",
    "amestecăturile": "amestecătură",
    "amestecăturilor": "amestecătură",
    "amețeala": "amețeală",
    "amețeli": "amețeală",
    "amețelii": "amețeală",
    "amețelile": "amețeală",
    "amețelilor": "amețeală",
    "amețea": "ameți",
    "amețeai": "ameți",
    "amețeam": "ameți",
    "amețească": "ameți",
    "amețeați": "ameți",
    "amețeau": "ameți",
    "amețesc": "ameți",
    "amețește": "ameți",
    "amețești": "ameți",
    "ameții": "ameți",
    "amețim": "ameți",
    "amețind": "ameți",
    "amețindu": "ameți",
    "amețiră": "ameți",
    "amețirăm": "ameți",
    "amețirăți": "ameți",
    "amețise": "ameți",
    "amețisem": "ameți",
    "amețiseră": "ameți",
    "amețiserăm": "ameți",
    "amețiserăți": "ameți",
    "amețiseși": "ameți",
    "amețiși": "ameți",
    "amețit": "ameți",
    "amețiți": "ameți",
    "amețitu": "ameți",
    "neamețind": "ameți",
    "neamețindu": "ameți",
    "nemaiamețind": "ameți",
    "nemaiamețindu": "ameți",
    "amețirea": "amețire",
    "amețiri": "amețire",
    "amețirii": "amețire",
    "amețirile": "amețire",
    "ametiste": "ametist",
    "ametistele": "ametist",
    "ametistelor": "ametist",
    "ametistul": "ametist",
    "ametistului": "ametist",
    "amețita": "amețit",
    "amețită": "amețit",
    "amețite": "amețit",
    "amețitei": "amețit",
    "amețitele": "amețit",
    "amețitelor": "amețit",
    "amețiți": "amețit",
    "amețiții": "amețit",
    "amețiților": "amețit",
    "amețitul": "amețit",
    "amețitului": "amețit",
    "amețita": "amețită",
    "amețite": "amețită",
    "amețitei": "amețită",
    "amețitele": "amețită",
    "amețitelor": "amețită",
    "amețitoare": "amețitor",
    "amețitoarea": "amețitor",
    "amețitoarei": "amețitor",
    "amețitoarele": "amețitor",
    "amețitoarelor": "amețitor",
    "amețitori": "amețitor",
    "amețitorii": "amețitor",
    "amețitorilor": "amețitor",
    "amețitorul": "amețitor",
    "amețitorului": "amețitor",
    "amfibia": "amfibiu",
    "amfibie": "amfibiu",
    "amfibiei": "amfibiu",
    "amfibii": "amfibiu",
    "amfibiii": "amfibiu",
    "amfibiile": "amfibiu",
    "amfibiilor": "amfibiu",
    "amfibiul": "amfibiu",
    "amfibiului": "amfibiu",
    "amfibrahi": "amfibrah",
    "amfibrahii": "amfibrah",
    "amfibrahilor": "amfibrah",
    "amfibrahul": "amfibrah",
    "amfibrahului": "amfibrah",
    "amfiteatre": "amfiteatru",
    "amfiteatrele": "amfiteatru",
    "amfiteatrelor": "amfiteatru",
    "amfiteatrul": "amfiteatru",
    "amfiteatrului": "amfiteatru",
    "amfitrioana": "amfitrioană",
    "amfitrioane": "amfitrioană",
    "amfitrioanei": "amfitrioană",
    "amfitrioanele": "amfitrioană",
    "amfitrioanelor": "amfitrioană",
    "amfitrioni": "amfitrion",
    "amfitrionii": "amfitrion",
    "amfitrionilor": "amfitrion",
    "amfitrionul": "amfitrion",
    "amfitrionului": "amfitrion",
    "amfora": "amforă",
    "amfore": "amforă",
    "amforei": "amforă",
    "amforele": "amforă",
    "amforelor": "amforă",
    "amiabila": "amiabil",
    "amiabilă": "amiabil",
    "amiabile": "amiabil",
    "amiabilei": "amiabil",
    "amiabilele": "amiabil",
    "amiabilelor": "amiabil",
    "amiabili": "amiabil",
    "amiabilii": "amiabil",
    "amiabililor": "amiabil",
    "amiabilul": "amiabil",
    "amiabilului": "amiabil",
    "amiaza": "amiază",
    "amiezele": "amiază",
    "amiezelor": "amiază",
    "amiezi": "amiază",
    "amiezii": "amiază",
    "amici": "amic",
    "amicii": "amic",
    "amicilor": "amic",
    "amicul": "amic",
    "amicului": "amic",
    "amica": "amică",
    "amice": "amică",
    "amicei": "amică",
    "amicele": "amică",
    "amicelor": "amică",
    "amicala": "amical",
    "amicală": "amical",
    "amicale": "amical",
    "amicalei": "amical",
    "amicalele": "amical",
    "amicalelor": "amical",
    "amicali": "amical",
    "amicalii": "amical",
    "amicalilor": "amical",
    "amicalul": "amical",
    "amicalului": "amical",
    "amiciția": "amiciție",
    "amiciției": "amiciție",
    "amiciții": "amiciție",
    "amicițiile": "amiciție",
    "amicițiilor": "amiciție",
    "amid.": "amidon",
    "amidonul": "amidon",
    "amidonului": "amidon",
    "amilacee": "amilaceu",
    "amilaceele": "amilaceu",
    "amilaceelor": "amilaceu",
    "amilaceul": "amilaceu",
    "amilaceului": "amilaceu",
    "aminoacidul": "aminoacid",
    "aminoacidului": "aminoacid",
    "aminoacizi": "aminoacid",
    "aminoacizii": "aminoacid",
    "aminoacizilor": "aminoacid",
    "amintea": "aminti",
    "aminteai": "aminti",
    "aminteam": "aminti",
    "amintească": "aminti",
    "aminteați": "aminti",
    "aminteau": "aminti",
    "amintesc": "aminti",
    "amintește": "aminti",
    "amintești": "aminti",
    "amintii": "aminti",
    "amintim": "aminti",
    "amintind": "aminti",
    "amintindu": "aminti",
    "amintiră": "aminti",
    "amintirăm": "aminti",
    "amintirăți": "aminti",
    "amintise": "aminti",
    "amintisem": "aminti",
    "amintiseră": "aminti",
    "amintiserăm": "aminti",
    "amintiserăți": "aminti",
    "amintiseși": "aminti",
    "amintiși": "aminti",
    "amintit": "aminti",
    "amintiți": "aminti",
    "amintitu": "aminti",
    "neamintind": "aminti",
    "neamintindu": "aminti",
    "nemaiamintind": "aminti",
    "nemaiamintindu": "aminti",
    "amintirea": "amintire",
    "amintiri": "amintire",
    "amintirii": "amintire",
    "amintirile": "amintire",
    "amintirilor": "amintire",
    "amintita": "amintit",
    "amintită": "amintit",
    "amintite": "amintit",
    "amintitei": "amintit",
    "amintitele": "amintit",
    "amintitelor": "amintit",
    "amintiți": "amintit",
    "amintiții": "amintit",
    "amintiților": "amintit",
    "amintitul": "amintit",
    "amintitului": "amintit",
    "amirali": "amiral",
    "amiralii": "amiral",
    "amiralilor": "amiral",
    "amiralul": "amiral",
    "amiralului": "amiral",
    "amiralitatea": "amiralitate",
    "amiralități": "amiralitate",
    "amiralității": "amiralitate",
    "amiralitățile": "amiralitate",
    "amiralităților": "amiralitate",
    "amnare": "amnar",
    "amnarele": "amnar",
    "amnarelor": "amnar",
    "amnarul": "amnar",
    "amnarului": "amnar",
    "amniotica": "amniotic",
    "amniotică": "amniotic",
    "amniotice": "amniotic",
    "amnioticei": "amniotic",
    "amnioticele": "amniotic",
    "amnioticelor": "amniotic",
    "amniotici": "amniotic",
    "amnioticii": "amniotic",
    "amnioticilor": "amniotic",
    "amnioticul": "amniotic",
    "amnioticului": "amniotic",
    "amnistiai": "amnistia",
    "amnistiam": "amnistia",
    "amnistiară": "amnistia",
    "amnistiarăm": "amnistia",
    "amnistiarăți": "amnistia",
    "amnistiase": "amnistia",
    "amnistiasem": "amnistia",
    "amnistiaseră": "amnistia",
    "amnistiaserăm": "amnistia",
    "amnistiaserăți": "amnistia",
    "amnistiaseși": "amnistia",
    "amnistiași": "amnistia",
    "amnistiat": "amnistia",
    "amnistiați": "amnistia",
    "amnistiatu": "amnistia",
    "amnistiau": "amnistia",
    "amnistiază": "amnistia",
    "amnistie": "amnistia",
    "amnistiem": "amnistia",
    "amnistiez": "amnistia",
    "amnistieze": "amnistia",
    "amnistiezi": "amnistia",
    "amnistiind": "amnistia",
    "amnistiindu": "amnistia",
    "neamnistiind": "amnistia",
    "neamnistiindu": "amnistia",
    "nemaiamnistiind": "amnistia",
    "nemaiamnistiindu": "amnistia",
    "amnistiabilă": "amnistiabil",
    "amnistiabile": "amnistiabil",
    "amnistiabili": "amnistiabil",
    "amnistiata": "amnistiat",
    "amnistiată": "amnistiat",
    "amnistiate": "amnistiat",
    "amnistiatei": "amnistiat",
    "amnistiatele": "amnistiat",
    "amnistiatelor": "amnistiat",
    "amnistiați": "amnistiat",
    "amnistiații": "amnistiat",
    "amnistiaților": "amnistiat",
    "amnistiatul": "amnistiat",
    "amnistiatului": "amnistiat",
    "amnistiata": "amnistiată",
    "amnistiate": "amnistiată",
    "amnistiatei": "amnistiată",
    "amnistiatele": "amnistiată",
    "amnistiatelor": "amnistiată",
    "amnistierea": "amnistiere",
    "amnistieri": "amnistiere",
    "amnistierii": "amnistiere",
    "amnistierile": "amnistiere",
    "amoniacul": "amoniac",
    "amoniacului": "amoniac",
    "amoniacala": "amoniacal",
    "amoniacală": "amoniacal",
    "amoniacale": "amoniacal",
    "amoniacalei": "amoniacal",
    "amoniacalele": "amoniacal",
    "amoniacalelor": "amoniacal",
    "amoniacali": "amoniacal",
    "amoniacalii": "amoniacal",
    "amoniacalilor": "amoniacal",
    "amoniacalul": "amoniacal",
    "amoniacalului": "amoniacal",
    "amorul": "amor",
    "amorului": "amor",
    "amoruri": "amor",
    "amorurile": "amor",
    "amorurilor": "amor",
    "amorala": "amoral",
    "amorală": "amoral",
    "amorale": "amoral",
    "amoralei": "amoral",
    "amoralele": "amoral",
    "amoralelor": "amoral",
    "amorali": "amoral",
    "amoralii": "amoral",
    "amoralilor": "amoral",
    "amoralul": "amoral",
    "amoralului": "amoral",
    "amorezata": "amorezat",
    "amorezată": "amorezat",
    "amorezate": "amorezat",
    "amorezatei": "amorezat",
    "amorezatele": "amorezat",
    "amorezatelor": "amorezat",
    "amorezați": "amorezat",
    "amorezații": "amorezat",
    "amorezaților": "amorezat",
    "amorezatul": "amorezat",
    "amorezatului": "amorezat",
    "amorfa": "amorf",
    "amorfă": "amorf",
    "amorfe": "amorf",
    "amorfei": "amorf",
    "amorfele": "amorf",
    "amorfelor": "amorf",
    "amorfi": "amorf",
    "amorfii": "amorf",
    "amorfilor": "amorf",
    "amorful": "amorf",
    "amorfului": "amorf",
    "amoroasa": "amoros",
    "amoroasă": "amoros",
    "amoroase": "amoros",
    "amoroasei": "amoros",
    "amoroasele": "amoros",
    "amoroaselor": "amoros",
    "amoroși": "amoros",
    "amoroșii": "amoros",
    "amoroșilor": "amoros",
    "amorosul": "amoros",
    "amorosului": "amoros",
    "amorul-propriu": "amor-propriu",
    "amorului-propriu": "amor-propriu",
    "amorsa": "amorsă",
    "amorse": "amorsă",
    "amorsei": "amorsă",
    "amorsele": "amorsă",
    "amorselor": "amorsă",
    "amorțeala": "amorțeală",
    "amorțeli": "amorțeală",
    "amorțelii": "amorțeală",
    "amorțelile": "amorțeală",
    "amorțelilor": "amorțeală",
    "amorțea": "amorți",
    "amorțeai": "amorți",
    "amorțeam": "amorți",
    "amorțească": "amorți",
    "amorțeați": "amorți",
    "amorțeau": "amorți",
    "amorțesc": "amorți",
    "amorțește": "amorți",
    "amorțești": "amorți",
    "amorții": "amorți",
    "amorțim": "amorți",
    "amorțind": "amorți",
    "amorțindu": "amorți",
    "amorțiră": "amorți",
    "amorțirăm": "amorți",
    "amorțirăți": "amorți",
    "amorțise": "amorți",
    "amorțisem": "amorți",
    "amorțiseră": "amorți",
    "amorțiserăm": "amorți",
    "amorțiserăți": "amorți",
    "amorțiseși": "amorți",
    "amorțiși": "amorți",
    "amorțit": "amorți",
    "amorțiți": "amorți",
    "amorțitu": "amorți",
    "neamorțind": "amorți",
    "neamorțindu": "amorți",
    "nemaiamorțind": "amorți",
    "nemaiamorțindu": "amorți",
    "amorțirea": "amorțire",
    "amorțiri": "amorțire",
    "amorțirii": "amorțire",
    "amortismente": "amortisment",
    "amortismentele": "amortisment",
    "amortismentelor": "amortisment",
    "amortismentul": "amortisment",
    "amortismentului": "amortisment",
    "amorțita": "amorțit",
    "amorțită": "amorțit",
    "amorțite": "amorțit",
    "amorțitei": "amorțit",
    "amorțitele": "amorțit",
    "amorțitelor": "amorțit",
    "amorțiți": "amorțit",
    "amorțiții": "amorțit",
    "amorțiților": "amorțit",
    "amorțitul": "amorțit",
    "amorțitului": "amorțit",
    "amorțita": "amorțită",
    "amorțite": "amorțită",
    "amorțitei": "amorțită",
    "amorțitele": "amorțită",
    "amorțitelor": "amorțită",
    "amortiză": "amortiza",
    "amortizai": "amortiza",
    "amortizam": "amortiza",
    "amortizăm": "amortiza",
    "amortizând": "amortiza",
    "amortizându": "amortiza",
    "amortizară": "amortiza",
    "amortizarăm": "amortiza",
    "amortizarăți": "amortiza",
    "amortizase": "amortiza",
    "amortizasem": "amortiza",
    "amortizaseră": "amortiza",
    "amortizaserăm": "amortiza",
    "amortizaserăți": "amortiza",
    "amortizaseși": "amortiza",
    "amortizași": "amortiza",
    "amortizat": "amortiza",
    "amortizați": "amortiza",
    "amortizatu": "amortiza",
    "amortizau": "amortiza",
    "amortizează": "amortiza",
    "amortizez": "amortiza",
    "amortizeze": "amortiza",
    "amortizezi": "amortiza",
    "neamortizând": "amortiza",
    "neamortizându": "amortiza",
    "nemaiamortizând": "amortiza",
    "nemaiamortizându": "amortiza",
    "amortizabilă": "amortizabil",
    "amortizabile": "amortizabil",
    "amortizabili": "amortizabil",
    "amortizarea": "amortizare",
    "amortizări": "amortizare",
    "amortizării": "amortizare",
    "amortizările": "amortizare",
    "amortizata": "amortizat",
    "amortizată": "amortizat",
    "amortizate": "amortizat",
    "amortizatei": "amortizat",
    "amortizatele": "amortizat",
    "amortizatelor": "amortizat",
    "amortizați": "amortizat",
    "amortizații": "amortizat",
    "amortizaților": "amortizat",
    "amortizatul": "amortizat",
    "amortizatului": "amortizat",
    "amovibila": "amovibil",
    "amovibilă": "amovibil",
    "amovibile": "amovibil",
    "amovibilei": "amovibil",
    "amovibilele": "amovibil",
    "amovibilelor": "amovibil",
    "amovibili": "amovibil",
    "amovibilii": "amovibil",
    "amovibililor": "amovibil",
    "amovibilul": "amovibil",
    "amovibilului": "amovibil",
    "amperi": "amper",
    "amperii": "amper",
    "amperilor": "amper",
    "amperul": "amper",
    "amperului": "amper",
    "amper-ora": "amper-oră",
    "amper-ore": "amper-oră",
    "amper-orei": "amper-oră",
    "amper-orele": "amper-oră",
    "amper-orelor": "amper-oră",
    "amper-spira": "amper-spiră",
    "amper-spire": "amper-spiră",
    "amper-spirei": "amper-spiră",
    "amper-spirele": "amper-spiră",
    "amper-spirelor": "amper-spiră",
    "amplasă": "amplasa",
    "amplasai": "amplasa",
    "amplasam": "amplasa",
    "amplasăm": "amplasa",
    "amplasând": "amplasa",
    "amplasându": "amplasa",
    "amplasară": "amplasa",
    "amplasarăm": "amplasa",
    "amplasarăți": "amplasa",
    "amplasase": "amplasa",
    "amplasasem": "amplasa",
    "amplasaseră": "amplasa",
    "amplasaserăm": "amplasa",
    "amplasaserăți": "amplasa",
    "amplasaseși": "amplasa",
    "amplasași": "amplasa",
    "amplasat": "amplasa",
    "amplasați": "amplasa",
    "amplasatu": "amplasa",
    "amplasau": "amplasa",
    "amplasează": "amplasa",
    "amplasez": "amplasa",
    "amplaseze": "amplasa",
    "amplasezi": "amplasa",
    "neamplasând": "amplasa",
    "neamplasându": "amplasa",
    "nemaiamplasând": "amplasa",
    "nemaiamplasându": "amplasa",
    "amplasabilă": "amplasabil",
    "amplasabile": "amplasabil",
    "amplasabili": "amplasabil",
    "amplasamente": "amplasament",
    "amplasamentele": "amplasament",
    "amplasamentelor": "amplasament",
    "amplasamentul": "amplasament",
    "amplasamentului": "amplasament",
    "amplasarea": "amplasare",
    "amplasări": "amplasare",
    "amplasării": "amplasare",
    "amplasările": "amplasare",
    "amplasata": "amplasat",
    "amplasată": "amplasat",
    "amplasate": "amplasat",
    "amplasatei": "amplasat",
    "amplasatele": "amplasat",
    "amplasatelor": "amplasat",
    "amplasați": "amplasat",
    "amplasații": "amplasat",
    "amplasaților": "amplasat",
    "amplasatul": "amplasat",
    "amplasatului": "amplasat",
    "amplific": "amplifica",
    "amplifică": "amplifica",
    "amplificai": "amplifica",
    "amplificam": "amplifica",
    "amplificăm": "amplifica",
    "amplificând": "amplifica",
    "amplificându": "amplifica",
    "amplificară": "amplifica",
    "amplificarăm": "amplifica",
    "amplificarăți": "amplifica",
    "amplificase": "amplifica",
    "amplificasem": "amplifica",
    "amplificaseră": "amplifica",
    "amplificaserăm": "amplifica",
    "amplificaserăți": "amplifica",
    "amplificaseși": "amplifica",
    "amplificași": "amplifica",
    "amplificat": "amplifica",
    "amplificați": "amplifica",
    "amplificatu": "amplifica",
    "amplificau": "amplifica",
    "amplifice": "amplifica",
    "amplifici": "amplifica",
    "neamplificând": "amplifica",
    "neamplificându": "amplifica",
    "nemaiamplificând": "amplifica",
    "nemaiamplificându": "amplifica",
    "amplificabilă": "amplificabil",
    "amplificabile": "amplificabil",
    "amplificabili": "amplificabil",
    "amplificarea": "amplificare",
    "amplificări": "amplificare",
    "amplificării": "amplificare",
    "amplificările": "amplificare",
    "amplificata": "amplificat",
    "amplificată": "amplificat",
    "amplificate": "amplificat",
    "amplificatei": "amplificat",
    "amplificatele": "amplificat",
    "amplificatelor": "amplificat",
    "amplificați": "amplificat",
    "amplificații": "amplificat",
    "amplificaților": "amplificat",
    "amplificatul": "amplificat",
    "amplificatului": "amplificat",
    "amplificatoare": "amplificator",
    "amplificatoarea": "amplificator",
    "amplificatoarei": "amplificator",
    "amplificatoarele": "amplificator",
    "amplificatoarelor": "amplificator",
    "amplificatori": "amplificator",
    "amplificatorii": "amplificator",
    "amplificatorilor": "amplificator",
    "amplificatorul": "amplificator",
    "amplificatorului": "amplificator",
    "amplitudinea": "amplitudine",
    "amplitudini": "amplitudine",
    "amplitudinii": "amplitudine",
    "amplitudinile": "amplitudine",
    "amplitudinilor": "amplitudine",
    "amploaiați": "amploaia",
    "amploaiații": "amploaia",
    "amploaiaților": "amploaia",
    "amploaiatul": "amploaia",
    "amploaiatului": "amploaia",
    "amploarea": "amploare",
    "amplori": "amploare",
    "amplorii": "amploare",
    "amplorile": "amploare",
    "amplorilor": "amploare",
    "amploiați": "amploiat",
    "amploiații": "amploiat",
    "amploiaților": "amploiat",
    "amploiata": "amploiată",
    "amploiate": "amploiată",
    "amploiatei": "amploiată",
    "amploiatele": "amploiată",
    "amploiatelor": "amploiată",
    "amploiatul": "amploiată",
    "amploiatului": "amploiată",
    "ampla": "amplu",
    "amplă": "amplu",
    "ample": "amplu",
    "amplei": "amplu",
    "amplele": "amplu",
    "amplelor": "amplu",
    "ampli": "amplu",
    "amplii": "amplu",
    "amplilor": "amplu",
    "amplul": "amplu",
    "amplului": "amplu",
    "amprenta": "amprentă",
    "amprente": "amprentă",
    "amprentei": "amprentă",
    "amprentele": "amprentă",
    "amprentelor": "amprentă",
    "ampută": "amputa",
    "amputai": "amputa",
    "amputam": "amputa",
    "amputăm": "amputa",
    "amputând": "amputa",
    "amputându": "amputa",
    "amputară": "amputa",
    "amputarăm": "amputa",
    "amputarăți": "amputa",
    "amputase": "amputa",
    "amputasem": "amputa",
    "amputaseră": "amputa",
    "amputaserăm": "amputa",
    "amputaserăți": "amputa",
    "amputaseși": "amputa",
    "amputași": "amputa",
    "amputat": "amputa",
    "amputați": "amputa",
    "amputatu": "amputa",
    "amputau": "amputa",
    "amputează": "amputa",
    "amputez": "amputa",
    "amputeze": "amputa",
    "amputezi": "amputa",
    "neamputând": "amputa",
    "neamputându": "amputa",
    "nemaiamputând": "amputa",
    "nemaiamputându": "amputa",
    "amputabilă": "amputabil",
    "amputabile": "amputabil",
    "amputabili": "amputabil",
    "amputarea": "amputare",
    "amputări": "amputare",
    "amputării": "amputare",
    "amputările": "amputare",
    "amputata": "amputat",
    "amputată": "amputat",
    "amputate": "amputat",
    "amputatei": "amputat",
    "amputatele": "amputat",
    "amputatelor": "amputat",
    "amputați": "amputat",
    "amputații": "amputat",
    "amputaților": "amputat",
    "amputatul": "amputat",
    "amputatului": "amputat",
    "amputata": "amputată",
    "amputate": "amputată",
    "amputatei": "amputată",
    "amputatele": "amputată",
    "amputatelor": "amputată",
    "amuleta": "amuletă",
    "amulete": "amuletă",
    "amuletei": "amuletă",
    "amuletele": "amuletă",
    "amuletelor": "amuletă",
    "amurgul": "amurg",
    "amurgului": "amurg",
    "amurguri": "amurg",
    "amurgurile": "amurg",
    "amurgurilor": "amurg",
    "amurgea": "amurgi",
    "amurgească": "amurgi",
    "amurgește": "amurgi",
    "amurgind": "amurgi",
    "amurgise": "amurgi",
    "amurgit": "amurgi",
    "neamurgind": "amurgi",
    "nemaiamurgind": "amurgi",
    "amurgirea": "amurgire",
    "amurgiri": "amurgire",
    "amurgirii": "amurgire",
    "amurgirile": "amurgire",
    "amuțirile": "amurgire",
    "amurgita": "amurgit",
    "amurgită": "amurgit",
    "amurgite": "amurgit",
    "amurgitei": "amurgit",
    "amurgitele": "amurgit",
    "amurgitelor": "amurgit",
    "amurgiți": "amurgit",
    "amurgiții": "amurgit",
    "amurgiților": "amurgit",
    "amurgitul": "amurgit",
    "amurgitului": "amurgit",
    "amuțea": "amuți",
    "amuțeai": "amuți",
    "amuțeam": "amuți",
    "amuțească": "amuți",
    "amuțeați": "amuți",
    "amuțeau": "amuți",
    "amuțesc": "amuți",
    "amuțește": "amuți",
    "amuțești": "amuți",
    "amuții": "amuți",
    "amuțim": "amuți",
    "amuțind": "amuți",
    "amuțindu": "amuți",
    "amuțiră": "amuți",
    "amuțirăm": "amuți",
    "amuțirăți": "amuți",
    "amuțise": "amuți",
    "amuțisem": "amuți",
    "amuțiseră": "amuți",
    "amuțiserăm": "amuți",
    "amuțiserăți": "amuți",
    "amuțiseși": "amuți",
    "amuțiși": "amuți",
    "amuțit": "amuți",
    "amuțiți": "amuți",
    "amuțitu": "amuți",
    "neamuțind": "amuți",
    "neamuțindu": "amuți",
    "nemaiamuțind": "amuți",
    "nemaiamuțindu": "amuți",
    "amuțirea": "amuțire",
    "amuțiri": "amuțire",
    "amuțirii": "amuțire",
    "amuțita": "amuțit",
    "amuțită": "amuțit",
    "amuțite": "amuțit",
    "amuțitei": "amuțit",
    "amuțitele": "amuțit",
    "amuțitelor": "amuțit",
    "amuțiți": "amuțit",
    "amuțiții": "amuțit",
    "amuțiților": "amuțit",
    "amuțitul": "amuțit",
    "amuțitului": "amuțit",
    "amuz": "amuza",
    "amuză": "amuza",
    "amuzai": "amuza",
    "amuzam": "amuza",
    "amuzăm": "amuza",
    "amuzând": "amuza",
    "amuzându": "amuza",
    "amuzară": "amuza",
    "amuzarăm": "amuza",
    "amuzarăți": "amuza",
    "amuzase": "amuza",
    "amuzasem": "amuza",
    "amuzaseră": "amuza",
    "amuzaserăm": "amuza",
    "amuzaserăți": "amuza",
    "amuzaseși": "amuza",
    "amuzași": "amuza",
    "amuzat": "amuza",
    "amuzați": "amuza",
    "amuzatu": "amuza",
    "amuzau": "amuza",
    "amuze": "amuza",
    "amuzi": "amuza",
    "neamuzând": "amuza",
    "neamuzându": "amuza",
    "nemaiamuzând": "amuza",
    "nemaiamuzându": "amuza",
    "amuzamente": "amuzament",
    "amuzamentele": "amuzament",
    "amuzamentelor": "amuzament",
    "amuzamentul": "amuzament",
    "amuzamentului": "amuzament",
    "amuzanta": "amuzant",
    "amuzantă": "amuzant",
    "amuzante": "amuzant",
    "amuzantei": "amuzant",
    "amuzantele": "amuzant",
    "amuzantelor": "amuzant",
    "amuzanți": "amuzant",
    "amuzanții": "amuzant",
    "amuzanților": "amuzant",
    "amuzantul": "amuzant",
    "amuzantului": "amuzant",
    "amuzarea": "amuzare",
    "amuzări": "amuzare",
    "amuzării": "amuzare",
    "amuzările": "amuzare",
    "amuzata": "amuzat",
    "amuzată": "amuzat",
    "amuzate": "amuzat",
    "amuzatei": "amuzat",
    "amuzatele": "amuzat",
    "amuzatelor": "amuzat",
    "amuzați": "amuzat",
    "amuzații": "amuzat",
    "amuzaților": "amuzat",
    "amuzatul": "amuzat",
    "amuzatului": "amuzat",
    "amvoane": "amvon",
    "amvoanele": "amvon",
    "amvoanelor": "amvon",
    "amvonul": "amvon",
    "amvonului": "amvon",
    "ani": "an",
    "anii": "an",
    "anilor": "an",
    "anu": "an",
    "anul": "an",
    "anului": "an",
    "Ană": "Ana",
    "Ane": "Ana",
    "Anei": "Ana",
    "anabaptista": "anabaptist",
    "anabaptistă": "anabaptist",
    "anabaptiste": "anabaptist",
    "anabaptistei": "anabaptist",
    "anabaptistele": "anabaptist",
    "anabaptistelor": "anabaptist",
    "anabaptiști": "anabaptist",
    "anabaptiștii": "anabaptist",
    "anabaptiștilor": "anabaptist",
    "anabaptistul": "anabaptist",
    "anabaptistului": "anabaptist",
    "anabolisme": "anabolism",
    "anabolismele": "anabolism",
    "anabolismelor": "anabolism",
    "anabolismul": "anabolism",
    "anabolismului": "anabolism",
    "anacolute": "anacolut",
    "anacolutele": "anacolut",
    "anacolutelor": "anacolut",
    "anacolutul": "anacolut",
    "anacolutului": "anacolut",
    "anacoluturi": "anacolut",
    "anacoluturile": "anacolut",
    "anacoluturilor": "anacolut",
    "anacreontica": "anacreontic",
    "anacreontică": "anacreontic",
    "anacreontice": "anacreontic",
    "anacreonticei": "anacreontic",
    "anacreonticele": "anacreontic",
    "anacreonticelor": "anacreontic",
    "anacreontici": "anacreontic",
    "anacreonticii": "anacreontic",
    "anacreonticilor": "anacreontic",
    "anacreonticul": "anacreontic",
    "anacreonticului": "anacreontic",
    "anacronica": "anacronic",
    "anacronică": "anacronic",
    "anacronice": "anacronic",
    "anacronicei": "anacronic",
    "anacronicele": "anacronic",
    "anacronicelor": "anacronic",
    "anacronici": "anacronic",
    "anacronicii": "anacronic",
    "anacronicilor": "anacronic",
    "anacronicul": "anacronic",
    "anacronicului": "anacronic",
    "anacronisme": "anacronism",
    "anacronismele": "anacronism",
    "anacronismelor": "anacronism",
    "anacronismul": "anacronism",
    "anacronismului": "anacronism",
    "anacronistica": "anacronistic",
    "anacronistică": "anacronistic",
    "anacronistice": "anacronistic",
    "anacronisticei": "anacronistic",
    "anacronisticele": "anacronistic",
    "anacronisticelor": "anacronistic",
    "anacronistici": "anacronistic",
    "anacronisticii": "anacronistic",
    "anacronisticilor": "anacronistic",
    "anacronisticul": "anacronistic",
    "anacronisticului": "anacronistic",
    "anaeroba": "anaerob",
    "anaerobă": "anaerob",
    "anaerobe": "anaerob",
    "anaerobei": "anaerob",
    "anaerobele": "anaerob",
    "anaerobelor": "anaerob",
    "anaerobi": "anaerob",
    "anaerobii": "anaerob",
    "anaerobilor": "anaerob",
    "anaerobul": "anaerob",
    "anaerobului": "anaerob",
    "anaerobiotica": "anaerobiotic",
    "anaerobiotică": "anaerobiotic",
    "anaerobiotice": "anaerobiotic",
    "anaerobioticei": "anaerobiotic",
    "anaerobioticele": "anaerobiotic",
    "anaerobioticelor": "anaerobiotic",
    "anaerobiotici": "anaerobiotic",
    "anaerobioticii": "anaerobiotic",
    "anaerobioticilor": "anaerobiotic",
    "anaerobioticul": "anaerobiotic",
    "anaerobioticului": "anaerobiotic",
    "anafilactica": "anafilactic",
    "anafilactică": "anafilactic",
    "anafilactice": "anafilactic",
    "anafilacticei": "anafilactic",
    "anafilacticele": "anafilactic",
    "anafilacticelor": "anafilactic",
    "anafilactici": "anafilactic",
    "anafilacticii": "anafilactic",
    "anafilacticilor": "anafilactic",
    "anafilacticul": "anafilactic",
    "anafilacticului": "anafilactic",
    "anafora": "anaforă",
    "anafore": "anaforă",
    "anaforei": "anaforă",
    "anaforele": "anaforă",
    "anaforelor": "anaforă",
    "anagrama": "anagramă",
    "anagrame": "anagramă",
    "anagramei": "anagramă",
    "anagramele": "anagramă",
    "anagramelor": "anagramă",
    "anahoretica": "anahoretic",
    "anahoretică": "anahoretic",
    "anahoretice": "anahoretic",
    "anahoreticei": "anahoretic",
    "anahoreticele": "anahoretic",
    "anahoreticelor": "anahoretic",
    "anahoretici": "anahoretic",
    "anahoreticii": "anahoretic",
    "anahoreticilor": "anahoretic",
    "anahoreticul": "anahoretic",
    "anahoreticului": "anahoretic",
    "anala": "anal",
    "anală": "anal",
    "anale": "anal",
    "analei": "anal",
    "analele": "anal",
    "analelor": "anal",
    "anali": "anal",
    "analii": "anal",
    "analilor": "anal",
    "analul": "anal",
    "analului": "anal",
    "analele": "anale",
    "analelor": "anale",
    "analfabeți": "analfabet",
    "analfabeții": "analfabet",
    "analfabeților": "analfabet",
    "analfabetul": "analfabet",
    "analfabetului": "analfabet",
    "analfabeta": "analfabetă",
    "analfabete": "analfabetă",
    "analfabetei": "analfabetă",
    "analfabetele": "analfabetă",
    "analfabetelor": "analfabetă",
    "analfabetismul": "analfabetism",
    "analfabetismului": "analfabetism",
    "analgezica": "analgezic",
    "analgezică": "analgezic",
    "analgezice": "analgezic",
    "analgezicei": "analgezic",
    "analgezicele": "analgezic",
    "analgezicelor": "analgezic",
    "analgezici": "analgezic",
    "analgezicii": "analgezic",
    "analgezicilor": "analgezic",
    "analgezicul": "analgezic",
    "analgezicului": "analgezic",
    "analiști": "analist",
    "analiștii": "analist",
    "analiștilor": "analist",
    "analistul": "analist",
    "analistului": "analist",
    "analitica": "analitic",
    "analitică": "analitic",
    "analitice": "analitic",
    "analiticei": "analitic",
    "analiticele": "analitic",
    "analiticelor": "analitic",
    "analitici": "analitic",
    "analiticii": "analitic",
    "analiticilor": "analitic",
    "analiticul": "analitic",
    "analiticului": "analitic",
    "analitica": "analitică",
    "analitice": "analitică",
    "analiticele": "analitică",
    "analiticelor": "analitică",
    "analiticii": "analitică",
    "analiză": "analiza",
    "analizai": "analiza",
    "analizam": "analiza",
    "analizăm": "analiza",
    "analizând": "analiza",
    "analizându": "analiza",
    "analizară": "analiza",
    "analizarăm": "analiza",
    "analizarăți": "analiza",
    "analizase": "analiza",
    "analizasem": "analiza",
    "analizaseră": "analiza",
    "analizaserăm": "analiza",
    "analizaserăți": "analiza",
    "analizaseși": "analiza",
    "analizași": "analiza",
    "analizat": "analiza",
    "analizați": "analiza",
    "analizatu": "analiza",
    "analizau": "analiza",
    "analizează": "analiza",
    "analizez": "analiza",
    "analizeze": "analiza",
    "analizezi": "analiza",
    "neanalizând": "analiza",
    "neanalizându": "analiza",
    "nemaianalizând": "analiza",
    "nemaianalizându": "analiza",
    "analiza": "analiză",
    "analize": "analiză",
    "analizei": "analiză",
    "analizele": "analiză",
    "analizelor": "analiză",
    "analizabila": "analizabil",
    "analizabilă": "analizabil",
    "analizabile": "analizabil",
    "analizabilei": "analizabil",
    "analizabilele": "analizabil",
    "analizabilelor": "analizabil",
    "analizabili": "analizabil",
    "analizabilii": "analizabil",
    "analizabililor": "analizabil",
    "analizabilul": "analizabil",
    "analizabilului": "analizabil",
    "analizarea": "analizare",
    "analizări": "analizare",
    "analizării": "analizare",
    "analizările": "analizare",
    "analizata": "analizat",
    "analizată": "analizat",
    "analizate": "analizat",
    "analizatei": "analizat",
    "analizatele": "analizat",
    "analizatelor": "analizat",
    "analizați": "analizat",
    "analizații": "analizat",
    "analizaților": "analizat",
    "analizatul": "analizat",
    "analizatului": "analizat",
    "analizatoare": "analizator",
    "analizatoarele": "analizator",
    "analizatoarelor": "analizator",
    "analizatorul": "analizator",
    "analizatorului": "analizator",
    "analoga": "analog",
    "analogă": "analog",
    "analoge": "analog",
    "analogei": "analog",
    "analogele": "analog",
    "analogelor": "analog",
    "analogi": "analog",
    "analogii": "analog",
    "analogilor": "analog",
    "analogul": "analog",
    "analogului": "analog",
    "analogica": "analogic",
    "analogică": "analogic",
    "analogice": "analogic",
    "analogicele": "analogic",
    "analogicelor": "analogic",
    "analogici": "analogic",
    "analogicii": "analogic",
    "analogicilor": "analogic",
    "analogicul": "analogic",
    "analogicului": "analogic",
    "analogia": "analogie",
    "analogiei": "analogie",
    "analogii": "analogie",
    "analogiile": "analogie",
    "analogiilor": "analogie",
    "ananghia": "ananghie",
    "ananghiei": "ananghie",
    "ananghii": "ananghie",
    "ananghiile": "ananghie",
    "ananghiilor": "ananghie",
    "anapești": "anapest",
    "anapeștii": "anapest",
    "anapeștilor": "anapest",
    "anapestul": "anapest",
    "anapestului": "anapest",
    "anapestica": "anapestic",
    "anapestică": "anapestic",
    "anapestice": "anapestic",
    "anapesticele": "anapestic",
    "anapesticelor": "anapestic",
    "anapestici": "anapestic",
    "anapesticii": "anapestic",
    "anapesticilor": "anapestic",
    "anapesticul": "anapestic",
    "anapesticului": "anapestic",
    "anarhica": "anarhic",
    "anarhică": "anarhic",
    "anarhice": "anarhic",
    "anarhicei": "anarhic",
    "anarhicele": "anarhic",
    "anarhicelor": "anarhic",
    "anarhici": "anarhic",
    "anarhicii": "anarhic",
    "anarhicilor": "anarhic",
    "anarhicul": "anarhic",
    "anarhicului": "anarhic",
    "anarhia": "anarhie",
    "anarhiei": "anarhie",
    "anarhii": "anarhie",
    "anarhiile": "anarhie",
    "anarhiilor": "anarhie",
    "anarhismul": "anarhism",
    "anarhismului": "anarhism",
    "anarhiști": "anarhist",
    "anarhiștii": "anarhist",
    "anarhiștilor": "anarhist",
    "anarhistul": "anarhist",
    "anarhistului": "anarhist",
    "anarhista": "anarhistă",
    "anarhiste": "anarhistă",
    "anarhistei": "anarhistă",
    "anarhistele": "anarhistă",
    "anarhistelor": "anarhistă",
    "anarhizarea": "anarhizare",
    "anarhizări": "anarhizare",
    "anarhizării": "anarhizare",
    "anarhizările": "anarhizare",
    "anarhizărilor": "anarhizare",
    "Anastasie": "Anastasia",
    "Anastasiei": "Anastasia",
    "Anastasii": "Anastasia",
    "anastatica": "anastatic",
    "anastatică": "anastatic",
    "anastatice": "anastatic",
    "anastaticei": "anastatic",
    "anastaticele": "anastatic",
    "anastaticelor": "anastatic",
    "anastatici": "anastatic",
    "anastaticii": "anastatic",
    "anastaticilor": "anastatic",
    "anastaticul": "anastatic",
    "anastaticului": "anastatic",
    "anastrofa": "anastrofă",
    "anastrofe": "anastrofă",
    "anastrofei": "anastrofă",
    "anastrofele": "anastrofă",
    "anastrofelor": "anastrofă",
    "anatema": "anatemă",
    "anateme": "anatemă",
    "anatemei": "anatemă",
    "anatemele": "anatemă",
    "anatemelor": "anatemă",
    "anatomica": "anatomic",
    "anatomică": "anatomic",
    "anatomice": "anatomic",
    "anatomicei": "anatomic",
    "anatomicele": "anatomic",
    "anatomicelor": "anatomic",
    "anatomici": "anatomic",
    "anatomicii": "anatomic",
    "anatomicilor": "anatomic",
    "anatomicul": "anatomic",
    "anatomicului": "anatomic",
    "anatomia": "anatomie",
    "anatomiei": "anatomie",
    "anatomii": "anatomie",
    "anatomiile": "anatomie",
    "anatomiilor": "anatomie",
    "Ancăi": "Anca",
    "ancestrala": "ancestral",
    "ancestrală": "ancestral",
    "ancestrale": "ancestral",
    "ancestralei": "ancestral",
    "ancestralele": "ancestral",
    "ancestralelor": "ancestral",
    "ancestrali": "ancestral",
    "ancestralii": "ancestral",
    "ancestralilor": "ancestral",
    "ancestralul": "ancestral",
    "ancestralului": "ancestral",
    "anchetă": "ancheta",
    "anchetai": "ancheta",
    "anchetam": "ancheta",
    "anchetăm": "ancheta",
    "anchetând": "ancheta",
    "anchetându": "ancheta",
    "anchetară": "ancheta",
    "anchetarăm": "ancheta",
    "anchetarăți": "ancheta",
    "anchetase": "ancheta",
    "anchetasem": "ancheta",
    "anchetaseră": "ancheta",
    "anchetaserăm": "ancheta",
    "anchetaserăți": "ancheta",
    "anchetaseși": "ancheta",
    "anchetași": "ancheta",
    "anchetat": "ancheta",
    "anchetați": "ancheta",
    "anchetatu": "ancheta",
    "anchetau": "ancheta",
    "anchetează": "ancheta",
    "anchetez": "ancheta",
    "ancheteze": "ancheta",
    "anchetezi": "ancheta",
    "neanchetând": "ancheta",
    "neanchetându": "ancheta",
    "nemaianchetând": "ancheta",
    "nemaianchetându": "ancheta",
    "ancheta": "anchetă",
    "anchete": "anchetă",
    "anchetei": "anchetă",
    "anchetele": "anchetă",
    "anchetelor": "anchetă",
    "anchetarea": "anchetare",
    "anchetări": "anchetare",
    "anchetării": "anchetare",
    "anchetările": "anchetare",
    "anchetata": "anchetat",
    "anchetată": "anchetat",
    "anchetate": "anchetat",
    "anchetatei": "anchetat",
    "anchetatele": "anchetat",
    "anchetatelor": "anchetat",
    "anchetați": "anchetat",
    "anchetații": "anchetat",
    "anchetaților": "anchetat",
    "anchetatul": "anchetat",
    "anchetatului": "anchetat",
    "anchetata": "anchetată",
    "anchetate": "anchetată",
    "anchetatei": "anchetată",
    "anchetatele": "anchetată",
    "anchetatelor": "anchetată",
    "anchetatoarea": "anchetatoare",
    "anchetatoarei": "anchetatoare",
    "anchetatoarele": "anchetatoare",
    "anchetatoarelor": "anchetatoare",
    "anchetatori": "anchetator",
    "anchetatorii": "anchetator",
    "anchetatorilor": "anchetator",
    "anchetatorul": "anchetator",
    "anchetatorului": "anchetator",
    "anchiloză": "anchiloza",
    "anchilozai": "anchiloza",
    "anchilozam": "anchiloza",
    "anchilozăm": "anchiloza",
    "anchilozând": "anchiloza",
    "anchilozându": "anchiloza",
    "anchilozară": "anchiloza",
    "anchilozarăm": "anchiloza",
    "anchilozarăți": "anchiloza",
    "anchilozase": "anchiloza",
    "anchilozasem": "anchiloza",
    "anchilozaseră": "anchiloza",
    "anchilozaserăm": "anchiloza",
    "anchilozaserăți": "anchiloza",
    "anchilozaseși": "anchiloza",
    "anchilozași": "anchiloza",
    "anchilozat": "anchiloza",
    "anchilozați": "anchiloza",
    "anchilozatu": "anchiloza",
    "anchilozau": "anchiloza",
    "anchilozează": "anchiloza",
    "anchilozez": "anchiloza",
    "anchilozeze": "anchiloza",
    "anchilozezi": "anchiloza",
    "neanchilozând": "anchiloza",
    "neanchilozându": "anchiloza",
    "nemaianchilozând": "anchiloza",
    "nemaianchilozându": "anchiloza",
    "anchiloza": "anchiloză",
    "anchiloze": "anchiloză",
    "anchilozei": "anchiloză",
    "anchilozele": "anchiloză",
    "anchilozelor": "anchiloză",
    "anchilozarea": "anchilozare",
    "anchilozări": "anchilozare",
    "anchilozării": "anchilozare",
    "anchilozările": "anchilozare",
    "anchilozata": "anchilozat",
    "anchilozată": "anchilozat",
    "anchilozate": "anchilozat",
    "anchilozatei": "anchilozat",
    "anchilozatele": "anchilozat",
    "anchilozatelor": "anchilozat",
    "anchilozați": "anchilozat",
    "anchilozații": "anchilozat",
    "anchilozaților": "anchilozat",
    "anchilozatul": "anchilozat",
    "anchilozatului": "anchilozat",
    "anchilozata": "anchilozată",
    "anchilozate": "anchilozată",
    "anchilozatei": "anchilozată",
    "anchilozatele": "anchilozată",
    "anchilozatelor": "anchilozată",
    "ancoră": "ancora",
    "ancorai": "ancora",
    "ancoram": "ancora",
    "ancorăm": "ancora",
    "ancorând": "ancora",
    "ancorându": "ancora",
    "ancorară": "ancora",
    "ancorarăm": "ancora",
    "ancorarăți": "ancora",
    "ancorase": "ancora",
    "ancorasem": "ancora",
    "ancoraseră": "ancora",
    "ancoraserăm": "ancora",
    "ancoraserăți": "ancora",
    "ancoraseși": "ancora",
    "ancorași": "ancora",
    "ancorat": "ancora",
    "ancorați": "ancora",
    "ancoratu": "ancora",
    "ancorau": "ancora",
    "ancorează": "ancora",
    "ancorez": "ancora",
    "ancoreze": "ancora",
    "ancorezi": "ancora",
    "neancorând": "ancora",
    "neancorându": "ancora",
    "nemaiancorând": "ancora",
    "nemaiancorându": "ancora",
    "ancora": "ancoră",
    "ancore": "ancoră",
    "ancorei": "ancoră",
    "ancorele": "ancoră",
    "ancorelor": "ancoră",
    "ancorarea": "ancorare",
    "ancorări": "ancorare",
    "ancorării": "ancorare",
    "ancorările": "ancorare",
    "ancorata": "ancorat",
    "ancorată": "ancorat",
    "ancorate": "ancorat",
    "ancoratei": "ancorat",
    "ancoratele": "ancorat",
    "ancoratelor": "ancorat",
    "ancorați": "ancorat",
    "ancorații": "ancorat",
    "ancoraților": "ancorat",
    "ancoratul": "ancorat",
    "ancoratului": "ancorat",
    "Andă": "Anda",
    "Ande": "Anda",
    "Andei": "Anda",
    "androgina": "androgin",
    "androgină": "androgin",
    "androgine": "androgin",
    "androginei": "androgin",
    "androginele": "androgin",
    "androginelor": "androgin",
    "androgini": "androgin",
    "androginii": "androgin",
    "androginilor": "androgin",
    "androginul": "androgin",
    "androginului": "androgin",
    "anduranța": "anduranță",
    "anduranțe": "anduranță",
    "anduranței": "anduranță",
    "anduranțele": "anduranță",
    "anduranțelor": "anduranță",
    "anecdota": "anecdotă",
    "anecdote": "anecdotă",
    "anecdotei": "anecdotă",
    "anecdotele": "anecdotă",
    "anecdotelor": "anecdotă",
    "anecdotica": "anecdotic",
    "anecdotică": "anecdotic",
    "anecdotice": "anecdotic",
    "anecdoticei": "anecdotic",
    "anecdoticele": "anecdotic",
    "anecdoticelor": "anecdotic",
    "anecdotici": "anecdotic",
    "anecdoticii": "anecdotic",
    "anecdoticilor": "anecdotic",
    "anecdoticul": "anecdotic",
    "anecdoticului": "anecdotic",
    "anemiai": "anemia",
    "anemiam": "anemia",
    "anemiară": "anemia",
    "anemiarăm": "anemia",
    "anemiarăți": "anemia",
    "anemiase": "anemia",
    "anemiasem": "anemia",
    "anemiaseră": "anemia",
    "anemiaserăm": "anemia",
    "anemiaserăți": "anemia",
    "anemiaseși": "anemia",
    "anemiași": "anemia",
    "anemiat": "anemia",
    "anemiați": "anemia",
    "anemiatu": "anemia",
    "anemiau": "anemia",
    "anemiază": "anemia",
    "anemie": "anemia",
    "anemiem": "anemia",
    "anemiez": "anemia",
    "anemieze": "anemia",
    "anemiezi": "anemia",
    "anemiind": "anemia",
    "anemiindu": "anemia",
    "neanemiind": "anemia",
    "neanemiindu": "anemia",
    "nemaianemiind": "anemia",
    "nemaianemiindu": "anemia",
    "anemiata": "anemiat",
    "anemiată": "anemiat",
    "anemiate": "anemiat",
    "anemiatei": "anemiat",
    "anemiatele": "anemiat",
    "anemiatelor": "anemiat",
    "anemiați": "anemiat",
    "anemiații": "anemiat",
    "anemiaților": "anemiat",
    "anemiatul": "anemiat",
    "anemiatului": "anemiat",
    "anemiata": "anemiată",
    "anemiate": "anemiată",
    "anemiatei": "anemiată",
    "anemiatele": "anemiată",
    "anemiatelor": "anemiată",
    "anemica": "anemic",
    "anemică": "anemic",
    "anemice": "anemic",
    "anemicei": "anemic",
    "anemicele": "anemic",
    "anemicelor": "anemic",
    "anemici": "anemic",
    "anemicii": "anemic",
    "anemicilor": "anemic",
    "anemicul": "anemic",
    "anemicului": "anemic",
    "anemia": "anemie",
    "anemiei": "anemie",
    "anemii": "anemie",
    "anemiile": "anemie",
    "anemiilor": "anemie",
    "anemierea": "anemiere",
    "anemieri": "anemiere",
    "anemierii": "anemiere",
    "anemierile": "anemiere",
    "anemometre": "anemometru",
    "anemometrele": "anemometru",
    "anemometrelor": "anemometru",
    "anemometrul": "anemometru",
    "anemometrului": "anemometru",
    "anemona": "anemonă",
    "anemone": "anemonă",
    "anemonei": "anemonă",
    "anemonele": "anemonă",
    "anemonelor": "anemonă",
    "anemoscoape": "anemoscop",
    "anemoscoapele": "anemoscop",
    "anemoscoapelor": "anemoscop",
    "anemoscopul": "anemoscop",
    "anemoscopului": "anemoscop",
    "anemostate": "anemostat",
    "anemostatele": "anemostat",
    "anemostatelor": "anemostat",
    "anemostatul": "anemostat",
    "anemostatului": "anemostat",
    "aneroide": "aneroid",
    "aneroidele": "aneroid",
    "aneroidelor": "aneroid",
    "aneroidul": "aneroid",
    "aneroidului": "aneroid",
    "anestezica": "anestezic",
    "anestezică": "anestezic",
    "anestezice": "anestezic",
    "anestezicei": "anestezic",
    "anestezicele": "anestezic",
    "anestezicelor": "anestezic",
    "anestezici": "anestezic",
    "anestezicii": "anestezic",
    "anestezicilor": "anestezic",
    "anestezicul": "anestezic",
    "anestezicului": "anestezic",
    "anestezia": "anestezie",
    "anesteziei": "anestezie",
    "anestezii": "anestezie",
    "anesteziile": "anestezie",
    "anesteziilor": "anestezie",
    "anevoioasa": "anevoios",
    "anevoioasă": "anevoios",
    "anevoioase": "anevoios",
    "anevoioasei": "anevoios",
    "anevoioasele": "anevoios",
    "anevoioaselor": "anevoios",
    "anevoioși": "anevoios",
    "anevoioșii": "anevoios",
    "anevoioșilor": "anevoios",
    "anevoiosul": "anevoios",
    "anevoiosului": "anevoios",
    "anexă": "anexa",
    "anexai": "anexa",
    "anexam": "anexa",
    "anexăm": "anexa",
    "anexând": "anexa",
    "anexându": "anexa",
    "anexară": "anexa",
    "anexarăm": "anexa",
    "anexarăți": "anexa",
    "anexase": "anexa",
    "anexasem": "anexa",
    "anexaseră": "anexa",
    "anexaserăm": "anexa",
    "anexaserăți": "anexa",
    "anexaseși": "anexa",
    "anexași": "anexa",
    "anexat": "anexa",
    "anexați": "anexa",
    "anexatu": "anexa",
    "anexau": "anexa",
    "anexează": "anexa",
    "anexez": "anexa",
    "anexeze": "anexa",
    "anexezi": "anexa",
    "neanexând": "anexa",
    "neanexându": "anexa",
    "nemaianexând": "anexa",
    "nemaianexându": "anexa",
    "anexa": "anexă",
    "anexe": "anexă",
    "anexei": "anexă",
    "anexele": "anexă",
    "anexelor": "anexă",
    "anexarea": "anexare",
    "anexări": "anexare",
    "anexării": "anexare",
    "anexările": "anexare",
    "anexata": "anexat",
    "anexată": "anexat",
    "anexate": "anexat",
    "anexatei": "anexat",
    "anexatele": "anexat",
    "anexatelor": "anexat",
    "anexați": "anexat",
    "anexații": "anexat",
    "anexaților": "anexat",
    "anexatul": "anexat",
    "anexatului": "anexat",
    "anexionista": "anexionist",
    "anexionistă": "anexionist",
    "anexioniste": "anexionist",
    "anexionistei": "anexionist",
    "anexionistele": "anexionist",
    "anexionistelor": "anexionist",
    "anexioniști": "anexionist",
    "anexioniștii": "anexionist",
    "anexioniștilor": "anexionist",
    "anexionistul": "anexionist",
    "anexionistului": "anexionist",
    "anexiunea": "anexiune",
    "anexiuni": "anexiune",
    "anexiunii": "anexiune",
    "anexiunile": "anexiune",
    "anexiunilor": "anexiune",
    "angajă": "angaja",
    "angajai": "angaja",
    "angajam": "angaja",
    "angajăm": "angaja",
    "angajând": "angaja",
    "angajându": "angaja",
    "angajară": "angaja",
    "angajarăm": "angaja",
    "angajarăți": "angaja",
    "angajase": "angaja",
    "angajasem": "angaja",
    "angajaseră": "angaja",
    "angajaserăm": "angaja",
    "angajaserăți": "angaja",
    "angajaseși": "angaja",
    "angajași": "angaja",
    "angajat": "angaja",
    "angajați": "angaja",
    "angajatu": "angaja",
    "angajau": "angaja",
    "angajează": "angaja",
    "angajez": "angaja",
    "angajeze": "angaja",
    "angajezi": "angaja",
    "neangajând": "angaja",
    "neangajându": "angaja",
    "nemaiangajând": "angaja",
    "nemaiangajându": "angaja",
    "angajamente": "angajament",
    "angajamentele": "angajament",
    "angajamentelor": "angajament",
    "angajamentul": "angajament",
    "angajamentului": "angajament",
    "angajarea": "angajare",
    "angajări": "angajare",
    "angajării": "angajare",
    "angajările": "angajare",
    "angajărilor": "angajare",
    "angajata": "angajat",
    "angajată": "angajat",
    "angajate": "angajat",
    "angajatei": "angajat",
    "angajatele": "angajat",
    "angajatelor": "angajat",
    "angajați": "angajat",
    "angajații": "angajat",
    "angajaților": "angajat",
    "angajatul": "angajat",
    "angajatului": "angajat",
    "angajata": "angajată",
    "angajate": "angajată",
    "angajatei": "angajată",
    "angajatele": "angajată",
    "angajatelor": "angajată",
    "angarale": "angara",
    "angaralei": "angara",
    "angaralele": "angara",
    "angaralelor": "angara",
    "angaraua": "angara",
    "Angelă": "Angela",
    "Angele": "Angela",
    "Angelei": "Angela",
    "angelica": "angelic",
    "angelică": "angelic",
    "angelice": "angelic",
    "angelicei": "angelic",
    "angelicele": "angelic",
    "angelicelor": "angelic",
    "angelici": "angelic",
    "angelicii": "angelic",
    "angelicilor": "angelic",
    "angelicul": "angelic",
    "angelicului": "angelic",
    "anghina": "anghină",
    "anghine": "anghină",
    "anghinei": "anghină",
    "anghinele": "anghină",
    "anghinelor": "anghină",
    "angiosperma": "angiosperm",
    "angiospermă": "angiosperm",
    "angiosperme": "angiosperm",
    "angiospermei": "angiosperm",
    "angiospermele": "angiosperm",
    "angiospermelor": "angiosperm",
    "angiospermi": "angiosperm",
    "angiospermii": "angiosperm",
    "angiospermilor": "angiosperm",
    "angiospermul": "angiosperm",
    "angiospermului": "angiosperm",
    "Anglie": "Anglia",
    "Angliei": "Anglia",
    "Anglii": "Anglia",
    "anglicana": "anglican",
    "anglicană": "anglican",
    "anglicane": "anglican",
    "anglicanei": "anglican",
    "anglicanele": "anglican",
    "anglicanelor": "anglican",
    "anglicani": "anglican",
    "anglicanii": "anglican",
    "anglicanilor": "anglican",
    "anglicanul": "anglican",
    "anglicanului": "anglican",
    "anglista": "anglist",
    "anglistă": "anglist",
    "angliste": "anglist",
    "anglistei": "anglist",
    "anglistele": "anglist",
    "anglistelor": "anglist",
    "angliști": "anglist",
    "angliștii": "anglist",
    "angliștilor": "anglist",
    "anglistul": "anglist",
    "anglistului": "anglist",
    "anglista": "anglistă",
    "angliste": "anglistă",
    "anglistei": "anglistă",
    "anglistele": "anglistă",
    "anglistelor": "anglistă",
    "anglistul": "anglistă",
    "anglistului": "anglistă",
    "angoasa": "angoasă",
    "angoase": "angoasă",
    "angoasei": "angoasă",
    "angoasele": "angoasă",
    "angoaselor": "angoasă",
    "angrenă": "angrena",
    "angrenai": "angrena",
    "angrenam": "angrena",
    "angrenăm": "angrena",
    "angrenând": "angrena",
    "angrenându": "angrena",
    "angrenară": "angrena",
    "angrenarăm": "angrena",
    "angrenarăți": "angrena",
    "angrenase": "angrena",
    "angrenasem": "angrena",
    "angrenaseră": "angrena",
    "angrenaserăm": "angrena",
    "angrenaserăți": "angrena",
    "angrenaseși": "angrena",
    "angrenași": "angrena",
    "angrenat": "angrena",
    "angrenați": "angrena",
    "angrenatu": "angrena",
    "angrenau": "angrena",
    "angrenează": "angrena",
    "angrenez": "angrena",
    "angreneze": "angrena",
    "angrenezi": "angrena",
    "neangrenând": "angrena",
    "neangrenându": "angrena",
    "nemaiangrenând": "angrena",
    "nemaiangrenându": "angrena",
    "angrenaje": "angrenaj",
    "angrenajele": "angrenaj",
    "angrenajelor": "angrenaj",
    "angrenajul": "angrenaj",
    "angrenajului": "angrenaj",
    "angrenarea": "angrenare",
    "angrenări": "angrenare",
    "angrenării": "angrenare",
    "angrenările": "angrenare",
    "angrenata": "angrenat",
    "angrenată": "angrenat",
    "angrenate": "angrenat",
    "angrenatei": "angrenat",
    "angrenatele": "angrenat",
    "angrenatelor": "angrenat",
    "angrenați": "angrenat",
    "angrenații": "angrenat",
    "angrenaților": "angrenat",
    "angrenatul": "angrenat",
    "angrenatului": "angrenat",
    "angrosiști": "angrosist",
    "angrosiștii": "angrosist",
    "angrosiștilor": "angrosist",
    "angrosistul": "angrosist",
    "angrosistului": "angrosist",
    "angroul": "angrou",
    "angroului": "angrou",
    "angrouri": "angrou",
    "angrourile": "angrou",
    "angrourilor": "angrou",
    "angstromi": "angstrom",
    "angstromii": "angstrom",
    "angstromilor": "angstrom",
    "angstromul": "angstrom",
    "angstromului": "angstrom",
    "angulara": "angular",
    "angulară": "angular",
    "angulare": "angular",
    "angularei": "angular",
    "angularele": "angular",
    "angularelor": "angular",
    "angulari": "angular",
    "angularii": "angular",
    "angularilor": "angular",
    "angularul": "angular",
    "angularului": "angular",
    "anguloasa": "angulos",
    "anguloasă": "angulos",
    "anguloase": "angulos",
    "anguloasei": "angulos",
    "anguloasele": "angulos",
    "anguloaselor": "angulos",
    "anguloși": "angulos",
    "anguloșii": "angulos",
    "anguloșilor": "angulos",
    "angulosul": "angulos",
    "angulosului": "angulos",
    "anhidra": "anhidru",
    "anhidră": "anhidru",
    "anhidre": "anhidru",
    "anhidrei": "anhidru",
    "anhidrele": "anhidru",
    "anhidrelor": "anhidru",
    "anhidri": "anhidru",
    "anhidrii": "anhidru",
    "anhidrilor": "anhidru",
    "anhidrul": "anhidru",
    "anhidrului": "anhidru",
    "anihilă": "anihila",
    "anihilai": "anihila",
    "anihilam": "anihila",
    "anihilăm": "anihila",
    "anihilând": "anihila",
    "anihilându": "anihila",
    "anihilară": "anihila",
    "anihilarăm": "anihila",
    "anihilarăți": "anihila",
    "anihilase": "anihila",
    "anihilasem": "anihila",
    "anihilaseră": "anihila",
    "anihilaserăm": "anihila",
    "anihilaserăți": "anihila",
    "anihilaseși": "anihila",
    "anihilași": "anihila",
    "anihilat": "anihila",
    "anihilați": "anihila",
    "anihilatu": "anihila",
    "anihilau": "anihila",
    "anihilează": "anihila",
    "anihilez": "anihila",
    "anihileze": "anihila",
    "anihilezi": "anihila",
    "neanihilând": "anihila",
    "neanihilându": "anihila",
    "nemaianihilând": "anihila",
    "nemaianihilându": "anihila",
    "anihilanta": "anihilant",
    "anihilantă": "anihilant",
    "anihilante": "anihilant",
    "anihilantei": "anihilant",
    "anihilantele": "anihilant",
    "anihilantelor": "anihilant",
    "anihilanți": "anihilant",
    "anihilanții": "anihilant",
    "anihilanților": "anihilant",
    "anihilantul": "anihilant",
    "anihilantului": "anihilant",
    "anihilarea": "anihilare",
    "anihilări": "anihilare",
    "anihilării": "anihilare",
    "anihilările": "anihilare",
    "anihilata": "anihilat",
    "anihilată": "anihilat",
    "anihilate": "anihilat",
    "anihilatei": "anihilat",
    "anihilatele": "anihilat",
    "anihilatelor": "anihilat",
    "anihilați": "anihilat",
    "anihilații": "anihilat",
    "anihilaților": "anihilat",
    "anihilatul": "anihilat",
    "anihilatului": "anihilat",
    "anihilatoare": "anihilator",
    "anihilatoarea": "anihilator",
    "anihilatoarei": "anihilator",
    "anihilatoarele": "anihilator",
    "anihilatoarelor": "anihilator",
    "anihilatori": "anihilator",
    "anihilatorii": "anihilator",
    "anihilatorilor": "anihilator",
    "anihilatorul": "anihilator",
    "anihilatorului": "anihilator",
    "animă": "anima",
    "animai": "anima",
    "animam": "anima",
    "animăm": "anima",
    "animând": "anima",
    "animându": "anima",
    "animară": "anima",
    "animarăm": "anima",
    "animarăți": "anima",
    "animase": "anima",
    "animasem": "anima",
    "animaseră": "anima",
    "animaserăm": "anima",
    "animaserăți": "anima",
    "animaseși": "anima",
    "animași": "anima",
    "animat": "anima",
    "animați": "anima",
    "animatu": "anima",
    "animau": "anima",
    "animează": "anima",
    "animeze": "anima",
    "animezi": "anima",
    "neanimând": "anima",
    "neanimându": "anima",
    "nemaianimând": "anima",
    "nemaianimându": "anima",
    "animale": "animal",
    "animalele": "animal",
    "animalelor": "animal",
    "animalul": "animal",
    "animalului": "animal",
    "animalica": "animalic",
    "animalică": "animalic",
    "animalice": "animalic",
    "animalicei": "animalic",
    "animalicele": "animalic",
    "animalicelor": "animalic",
    "animalici": "animalic",
    "animalicii": "animalic",
    "animalicilor": "animalic",
    "animalicul": "animalic",
    "animalicului": "animalic",
    "animaliera": "animalier",
    "animalieră": "animalier",
    "animaliere": "animalier",
    "animalierei": "animalier",
    "animalierele": "animalier",
    "animalierelor": "animalier",
    "animalieri": "animalier",
    "animalierii": "animalier",
    "animalierilor": "animalier",
    "animalierul": "animalier",
    "animalierului": "animalier",
    "animalitatea": "animalitate",
    "animalități": "animalitate",
    "animalității": "animalitate",
    "animalitățile": "animalitate",
    "animalităților": "animalitate",
    "animalizata": "animalizat",
    "animalizată": "animalizat",
    "animalizate": "animalizat",
    "animalizatei": "animalizat",
    "animalizatele": "animalizat",
    "animalizatelor": "animalizat",
    "animalizați": "animalizat",
    "animalizații": "animalizat",
    "animalizaților": "animalizat",
    "animalizatul": "animalizat",
    "animalizatului": "animalizat",
    "animarea": "animare",
    "animări": "animare",
    "animării": "animare",
    "animările": "animare",
    "animata": "animat",
    "animată": "animat",
    "animate": "animat",
    "animatei": "animat",
    "animatele": "animat",
    "animatelor": "animat",
    "animați": "animat",
    "animații": "animat",
    "animaților": "animat",
    "animatul": "animat",
    "animatului": "animat",
    "animația": "animație",
    "animației": "animație",
    "animații": "animație",
    "animațiile": "animație",
    "animațiilor": "animație",
    "animatoarea": "animatoare",
    "animatoarei": "animatoare",
    "animatoarele": "animatoare",
    "animatoarelor": "animatoare",
    "animatoare": "animator",
    "animatoarea": "animator",
    "animatoarei": "animator",
    "animatoarele": "animator",
    "animatoarelor": "animator",
    "animatori": "animator",
    "animatorii": "animator",
    "animatorilor": "animator",
    "animatorul": "animator",
    "animatorului": "animator",
    "animisme": "animism",
    "animismele": "animism",
    "animismelor": "animism",
    "animismul": "animism",
    "animismului": "animism",
    "animista": "animist",
    "animistă": "animist",
    "animiste": "animist",
    "animistei": "animist",
    "animistele": "animist",
    "animistelor": "animist",
    "animiști": "animist",
    "animiștii": "animist",
    "animiștilor": "animist",
    "animistul": "animist",
    "animistului": "animist",
    "animozitatea": "animozitate",
    "animozități": "animozitate",
    "animozității": "animozitate",
    "animozitățile": "animozitate",
    "animozităților": "animozitate",
    "anin": "anina",
    "anină": "anina",
    "aninai": "anina",
    "aninam": "anina",
    "aninăm": "anina",
    "aninând": "anina",
    "aninându": "anina",
    "aninară": "anina",
    "aninarăm": "anina",
    "aninarăți": "anina",
    "aninase": "anina",
    "aninasem": "anina",
    "aninaseră": "anina",
    "aninaserăm": "anina",
    "aninaserăți": "anina",
    "aninaseși": "anina",
    "aninași": "anina",
    "aninat": "anina",
    "aninați": "anina",
    "aninatu": "anina",
    "aninau": "anina",
    "anine": "anina",
    "anini": "anina",
    "aninată": "aninat",
    "aninate": "aninat",
    "aninați": "aninat",
    "aniversă": "aniversa",
    "aniversai": "aniversa",
    "aniversam": "aniversa",
    "aniversăm": "aniversa",
    "aniversând": "aniversa",
    "aniversându": "aniversa",
    "aniversară": "aniversa",
    "aniversarăm": "aniversa",
    "aniversarăți": "aniversa",
    "aniversase": "aniversa",
    "aniversasem": "aniversa",
    "aniversaseră": "aniversa",
    "aniversaserăm": "aniversa",
    "aniversaserăți": "aniversa",
    "aniversaseși": "aniversa",
    "aniversași": "aniversa",
    "aniversat": "aniversa",
    "aniversați": "aniversa",
    "aniversatu": "aniversa",
    "aniversau": "aniversa",
    "aniversează": "aniversa",
    "aniversez": "aniversa",
    "aniverseze": "aniversa",
    "aniversezi": "aniversa",
    "neaniversând": "aniversa",
    "neaniversându": "aniversa",
    "nemaianiversând": "aniversa",
    "nemaianiversându": "aniversa",
    "aniversara": "aniversar",
    "aniversară": "aniversar",
    "aniversare": "aniversar",
    "aniversarei": "aniversar",
    "aniversarele": "aniversar",
    "aniversarelor": "aniversar",
    "aniversari": "aniversar",
    "aniversarii": "aniversar",
    "aniversarilor": "aniversar",
    "aniversarul": "aniversar",
    "aniversarului": "aniversar",
    "aniversarea": "aniversare",
    "aniversări": "aniversare",
    "aniversării": "aniversare",
    "aniversările": "aniversare",
    "aniversata": "aniversat",
    "aniversată": "aniversat",
    "aniversate": "aniversat",
    "aniversatei": "aniversat",
    "aniversatele": "aniversat",
    "aniversatelor": "aniversat",
    "aniversați": "aniversat",
    "aniversații": "aniversat",
    "aniversaților": "aniversat",
    "aniversatul": "aniversat",
    "aniversatului": "aniversat",
    "aniversata": "aniversată",
    "aniversate": "aniversată",
    "aniversatei": "aniversată",
    "aniversatele": "aniversată",
    "aniversatelor": "aniversată",
    "Ankară": "Ankara",
    "Ankare": "Ankara",
    "Ankarei": "Ankara",
    "anii-lumină": "an-lumină",
    "anilor-lumină": "an-lumină",
    "ani-lumină": "an-lumină",
    "anul-lumină": "an-lumină",
    "anului-lumină": "an-lumină",
    "a.p.": "anni_praeteriti",
    "a.D.": "anno_Domini",
    "anodica": "anodic",
    "anodică": "anodic",
    "anodice": "anodic",
    "anodicei": "anodic",
    "anodicele": "anodic",
    "anodicelor": "anodic",
    "anodici": "anodic",
    "anodicii": "anodic",
    "anodicilor": "anodic",
    "anodicul": "anodic",
    "anodicului": "anodic",
    "anodina": "anodin",
    "anodină": "anodin",
    "anodine": "anodin",
    "anodinei": "anodin",
    "anodinele": "anodin",
    "anodinelor": "anodin",
    "anodini": "anodin",
    "anodinii": "anodin",
    "anodinilor": "anodin",
    "anodinul": "anodin",
    "anodinului": "anodin",
    "anofeli": "anofel",
    "anofelii": "anofel",
    "anofelilor": "anofel",
    "anofelul": "anofel",
    "anofelului": "anofel",
    "anofelogena": "anofelogen",
    "anofelogenă": "anofelogen",
    "anofelogene": "anofelogen",
    "anofelogenei": "anofelogen",
    "anofelogenele": "anofelogen",
    "anofelogenelor": "anofelogen",
    "anofelogeni": "anofelogen",
    "anofelogenii": "anofelogen",
    "anofelogenilor": "anofelogen",
    "anofelogenul": "anofelogen",
    "anofelogenului": "anofelogen",
    "anomalia": "anomalie",
    "anomaliei": "anomalie",
    "anomalii": "anomalie",
    "anomaliile": "anomalie",
    "anomaliilor": "anomalie",
    "anonima": "anonim",
    "anonimă": "anonim",
    "anonime": "anonim",
    "anonimei": "anonim",
    "anonimele": "anonim",
    "anonimelor": "anonim",
    "anonimi": "anonim",
    "anonimii": "anonim",
    "anonimilor": "anonim",
    "anonimul": "anonim",
    "anonimului": "anonim",
    "anonima": "anonimă",
    "anonime": "anonimă",
    "anonimei": "anonimă",
    "anonimele": "anonimă",
    "anonimelor": "anonimă",
    "anonimate": "anonimat",
    "anonimatele": "anonimat",
    "anonimatelor": "anonimat",
    "anonimatul": "anonimat",
    "anonimatului": "anonimat",
    "anorganica": "anorganic",
    "anorganică": "anorganic",
    "anorganice": "anorganic",
    "anorganicei": "anorganic",
    "anorganicele": "anorganic",
    "anorganicelor": "anorganic",
    "anorganici": "anorganic",
    "anorganicii": "anorganic",
    "anorganicilor": "anorganic",
    "anorganicul": "anorganic",
    "anorganicului": "anorganic",
    "anormala": "anormal",
    "anormală": "anormal",
    "anormale": "anormal",
    "anormalei": "anormal",
    "anormalele": "anormal",
    "anormalelor": "anormal",
    "anormali": "anormal",
    "anormalii": "anormal",
    "anormalilor": "anormal",
    "anormalul": "anormal",
    "anormalului": "anormal",
    "anosta": "anost",
    "anostă": "anost",
    "anoste": "anost",
    "anostei": "anost",
    "anostele": "anost",
    "anostelor": "anost",
    "anoști": "anost",
    "anoștii": "anost",
    "anoștilor": "anost",
    "anostul": "anost",
    "anostului": "anost",
    "anotimpul": "anotimp",
    "anotimpului": "anotimp",
    "anotimpuri": "anotimp",
    "anotimpurile": "anotimp",
    "anotimpurilor": "anotimp",
    "ansamblul": "ansamblu",
    "ansamblului": "ansamblu",
    "ansambluri": "ansamblu",
    "ansamblurile": "ansamblu",
    "ansamblurilor": "ansamblu",
    "antagonica": "antagonic",
    "antagonică": "antagonic",
    "antagonice": "antagonic",
    "antagonicei": "antagonic",
    "antagonicele": "antagonic",
    "antagonicelor": "antagonic",
    "antagonici": "antagonic",
    "antagonicii": "antagonic",
    "antagonicilor": "antagonic",
    "antagonicul": "antagonic",
    "antagonicului": "antagonic",
    "antagonisme": "antagonism",
    "antagonismele": "antagonism",
    "antagonismelor": "antagonism",
    "antagonismul": "antagonism",
    "antagonismului": "antagonism",
    "antagonista": "antagonist",
    "antagonistă": "antagonist",
    "antagoniste": "antagonist",
    "antagonistei": "antagonist",
    "antagonistele": "antagonist",
    "antagonistelor": "antagonist",
    "antagoniști": "antagonist",
    "antagoniștii": "antagonist",
    "antagoniștilor": "antagonist",
    "antagonistul": "antagonist",
    "antagonistului": "antagonist",
    "antale": "antal",
    "antalele": "antal",
    "antalelor": "antal",
    "antalul": "antal",
    "antalului": "antal",
    "anii-tampon": "an-tampon",
    "anilor-tampon": "an-tampon",
    "ani-tampon": "an-tampon",
    "anul-tampon": "an-tampon",
    "anului-tampon": "an-tampon",
    "antarctică": "antarctic",
    "antarctice": "antarctic",
    "antarctici": "antarctic",
    "Antarctică": "Antarctica",
    "Antarctici": "Antarctica",
    "Antarcticii": "Antarctica",
    "a.d.": "ante_diem",
    "a.m.": "ante_meridiem",
    "antebelica": "antebelic",
    "antebelică": "antebelic",
    "antebelice": "antebelic",
    "antebelicei": "antebelic",
    "antebelicele": "antebelic",
    "antebelicelor": "antebelic",
    "antebelici": "antebelic",
    "antebelicii": "antebelic",
    "antebelicilor": "antebelic",
    "antebelicul": "antebelic",
    "antebelicului": "antebelic",
    "antebrațe": "antebraț",
    "antebrațele": "antebraț",
    "antebrațelor": "antebraț",
    "antebrațul": "antebraț",
    "antebrațului": "antebraț",
    "antecedente": "antecedent",
    "antecedentele": "antecedent",
    "antecedentelor": "antecedent",
    "antecedentul": "antecedent",
    "antecedentului": "antecedent",
    "antecesoarea": "antecesoare",
    "antecesoarei": "antecesoare",
    "antecesoarele": "antecesoare",
    "antecesoarelor": "antecesoare",
    "antecesorul": "antecesor",
    "antecesorului": "antecesor",
    "anteclasați": "anteclasat",
    "anteclasații": "anteclasat",
    "anteclasaților": "anteclasat",
    "anteclasatul": "anteclasat",
    "anteclasatului": "anteclasat",
    "anteclasata": "anteclasată",
    "anteclasate": "anteclasată",
    "anteclasatei": "anteclasată",
    "anteclasatele": "anteclasată",
    "anteclasatelor": "anteclasată",
    "antedată": "antedata",
    "antedatai": "antedata",
    "antedatam": "antedata",
    "antedatăm": "antedata",
    "antedatând": "antedata",
    "antedatându": "antedata",
    "antedatară": "antedata",
    "antedatarăm": "antedata",
    "antedatarăți": "antedata",
    "antedatase": "antedata",
    "antedatasem": "antedata",
    "antedataseră": "antedata",
    "antedataserăm": "antedata",
    "antedataserăți": "antedata",
    "antedataseși": "antedata",
    "antedatași": "antedata",
    "antedatat": "antedata",
    "antedatați": "antedata",
    "antedatatu": "antedata",
    "antedatau": "antedata",
    "antedatează": "antedata",
    "antedatez": "antedata",
    "antedateze": "antedata",
    "antedatezi": "antedata",
    "antedatarea": "antedatare",
    "antedatări": "antedatare",
    "antedatării": "antedatare",
    "antedatările": "antedatare",
    "antedatărilor": "antedatare",
    "antedatata": "antedatat",
    "antedatată": "antedatat",
    "antedatate": "antedatat",
    "antedatatei": "antedatat",
    "antedatatele": "antedatat",
    "antedatatelor": "antedatat",
    "antedatați": "antedatat",
    "antedatații": "antedatat",
    "antedataților": "antedatat",
    "antedatato": "antedatat",
    "antedatatul": "antedatat",
    "antedatatule": "antedatat",
    "antedatatului": "antedatat",
    "antediluviana": "antediluvian",
    "antediluviană": "antediluvian",
    "antediluvianul": "antediluvian",
    "antediluvianului": "antediluvian",
    "antediluviene": "antediluvian",
    "antediluvienei": "antediluvian",
    "antediluvienele": "antediluvian",
    "antediluvienelor": "antediluvian",
    "antediluvieni": "antediluvian",
    "antediluvienii": "antediluvian",
    "antediluvienilor": "antediluvian",
    "antemergători": "antemergător",
    "antemergătorii": "antemergător",
    "antemergătorilor": "antemergător",
    "antemergătorul": "antemergător",
    "antemergătorului": "antemergător",
    "antemeridiana": "antemeridian",
    "antemeridiană": "antemeridian",
    "antemeridiane": "antemeridian",
    "antemeridianei": "antemeridian",
    "antemeridianele": "antemeridian",
    "antemeridianelor": "antemeridian",
    "antemeridiani": "antemeridian",
    "antemeridianii": "antemeridian",
    "antemeridianilor": "antemeridian",
    "antemeridianul": "antemeridian",
    "antemeridianului": "antemeridian",
    "antena": "antenă",
    "antene": "antenă",
    "antenei": "antenă",
    "antenele": "antenă",
    "antenelor": "antenă",
    "antepenultima": "antepenultim",
    "antepenultimă": "antepenultim",
    "antepenultime": "antepenultim",
    "antepenultimei": "antepenultim",
    "antepenultimele": "antepenultim",
    "antepenultimelor": "antepenultim",
    "antepenultimi": "antepenultim",
    "antepenultimii": "antepenultim",
    "antepenultimilor": "antepenultim",
    "antepenultimul": "antepenultim",
    "antepenultimului": "antepenultim",
    "anteprimirea": "anteprimire",
    "anteprimiri": "anteprimire",
    "anteprimirii": "anteprimire",
    "anteprimirile": "anteprimire",
    "anteprimirilor": "anteprimire",
    "anterioara": "anterior",
    "anterioară": "anterior",
    "anterioare": "anterior",
    "anterioarei": "anterior",
    "anterioarele": "anterior",
    "anterioarelor": "anterior",
    "anteriori": "anterior",
    "anteriorii": "anterior",
    "anteriorilor": "anterior",
    "anteriorul": "anterior",
    "anteriorului": "anterior",
    "anterie": "anteriu",
    "anteriele": "anteriu",
    "anterielor": "anteriu",
    "anteriul": "anteriu",
    "anteriului": "anteriu",
    "antete": "antet",
    "antetele": "antet",
    "antetelor": "antet",
    "antetul": "antet",
    "antetului": "antet",
    "antiaeriana": "antiaerian",
    "antiaeriană": "antiaerian",
    "antiaerianul": "antiaerian",
    "antiaerianului": "antiaerian",
    "antiaeriene": "antiaerian",
    "antiaerienei": "antiaerian",
    "antiaerienele": "antiaerian",
    "antiaerienelor": "antiaerian",
    "antiaerieni": "antiaerian",
    "antiaerienii": "antiaerian",
    "antiaerienilor": "antiaerian",
    "antialcoolica": "antialcoolic",
    "antialcoolică": "antialcoolic",
    "antialcoolice": "antialcoolic",
    "antialcoolicei": "antialcoolic",
    "antialcoolicele": "antialcoolic",
    "antialcoolicelor": "antialcoolic",
    "antialcoolici": "antialcoolic",
    "antialcoolicii": "antialcoolic",
    "antialcoolicilor": "antialcoolic",
    "antialcoolicul": "antialcoolic",
    "antialcoolicului": "antialcoolic",
    "antibacteriana": "antibacterian",
    "antibacteriană": "antibacterian",
    "antibacterianul": "antibacterian",
    "antibacterianului": "antibacterian",
    "antibacteriene": "antibacterian",
    "antibacterienei": "antibacterian",
    "antibacterienele": "antibacterian",
    "antibacterienelor": "antibacterian",
    "antibacterieni": "antibacterian",
    "antibacterienii": "antibacterian",
    "antibacterienilor": "antibacterian",
    "antibiotica": "antibiotic",
    "antibiotică": "antibiotic",
    "antibiotice": "antibiotic",
    "antibioticei": "antibiotic",
    "antibioticele": "antibiotic",
    "antibioticelor": "antibiotic",
    "antibiotici": "antibiotic",
    "antibioticii": "antibiotic",
    "antibioticilor": "antibiotic",
    "antibioticul": "antibiotic",
    "antibioticului": "antibiotic",
    "antibolșevica": "antibolșevic",
    "antibolșevică": "antibolșevic",
    "antibolșevice": "antibolșevic",
    "antibolșevicei": "antibolșevic",
    "antibolșevicele": "antibolșevic",
    "antibolșevicelor": "antibolșevic",
    "antibolșevici": "antibolșevic",
    "antibolșevicii": "antibolșevic",
    "antibolșevicilor": "antibolșevic",
    "antibolșevicul": "antibolșevic",
    "antibolșevicului": "antibolșevic",
    "antibolșevica": "antibolșevică",
    "antibolșevice": "antibolșevică",
    "antibolșevicei": "antibolșevică",
    "antibolșevicele": "antibolșevică",
    "antibolșevicelor": "antibolșevică",
    "antica": "antic",
    "antică": "antic",
    "antice": "antic",
    "anticei": "antic",
    "anticele": "antic",
    "anticelor": "antic",
    "antici": "antic",
    "anticii": "antic",
    "anticilor": "antic",
    "anticul": "antic",
    "anticului": "antic",
    "anticamera": "anticameră",
    "anticamere": "anticameră",
    "anticamerei": "anticameră",
    "anticamerele": "anticameră",
    "anticamerelor": "anticameră",
    "anticari": "anticar",
    "anticarii": "anticar",
    "anticarilor": "anticar",
    "anticarul": "anticar",
    "anticarului": "anticar",
    "anticariate": "anticariat",
    "anticariatele": "anticariat",
    "anticariatelor": "anticariat",
    "anticariatul": "anticariat",
    "anticariatului": "anticariat",
    "antic.": "antichitate",
    "antichitatea": "antichitate",
    "antichități": "antichitate",
    "antichității": "antichitate",
    "antichitățile": "antichitate",
    "antichităților": "antichitate",
    "anticipă": "anticipa",
    "anticipai": "anticipa",
    "anticipam": "anticipa",
    "anticipăm": "anticipa",
    "anticipând": "anticipa",
    "anticipându": "anticipa",
    "anticipară": "anticipa",
    "anticiparăm": "anticipa",
    "anticiparăți": "anticipa",
    "anticipase": "anticipa",
    "anticipasem": "anticipa",
    "anticipaseră": "anticipa",
    "anticipaserăm": "anticipa",
    "anticipaserăți": "anticipa",
    "anticipaseși": "anticipa",
    "anticipași": "anticipa",
    "anticipat": "anticipa",
    "anticipați": "anticipa",
    "anticipatu": "anticipa",
    "anticipau": "anticipa",
    "anticipează": "anticipa",
    "anticipez": "anticipa",
    "anticipeze": "anticipa",
    "anticipezi": "anticipa",
    "neanticipând": "anticipa",
    "neanticipându": "anticipa",
    "nemaianticipând": "anticipa",
    "nemaianticipându": "anticipa",
    "anticiparea": "anticipare",
    "anticipări": "anticipare",
    "anticipării": "anticipare",
    "anticipările": "anticipare",
    "anticipata": "anticipat",
    "anticipată": "anticipat",
    "anticipate": "anticipat",
    "anticipatei": "anticipat",
    "anticipatele": "anticipat",
    "anticipatelor": "anticipat",
    "anticipați": "anticipat",
    "anticipații": "anticipat",
    "anticipaților": "anticipat",
    "anticipatul": "anticipat",
    "anticipatului": "anticipat",
    "anticipata": "anticipată",
    "anticipate": "anticipată",
    "anticipatei": "anticipată",
    "anticipatele": "anticipată",
    "anticipatelor": "anticipată",
    "anticipația": "anticipație",
    "anticipației": "anticipație",
    "anticipații": "anticipație",
    "anticipațiile": "anticipație",
    "anticipațiilor": "anticipație",
    "anticlericala": "anticlerical",
    "anticlericală": "anticlerical",
    "anticlericale": "anticlerical",
    "anticlericalei": "anticlerical",
    "anticlericalele": "anticlerical",
    "anticlericalelor": "anticlerical",
    "anticlericali": "anticlerical",
    "anticlericalii": "anticlerical",
    "anticlericalilor": "anticlerical",
    "anticlericalul": "anticlerical",
    "anticlericalului": "anticlerical",
    "anticomunista": "anticomunist",
    "anticomunistă": "anticomunist",
    "anticomuniste": "anticomunist",
    "anticomunistei": "anticomunist",
    "anticomunistele": "anticomunist",
    "anticomunistelor": "anticomunist",
    "anticomuniști": "anticomunist",
    "anticomuniștii": "anticomunist",
    "anticomuniștilor": "anticomunist",
    "anticomunistul": "anticomunist",
    "anticomunistului": "anticomunist",
    "anticomunista": "anticomunistă",
    "anticomuniste": "anticomunistă",
    "anticomunistei": "anticomunistă",
    "anticomunistele": "anticomunistă",
    "anticomunistelor": "anticomunistă",
    "anticonstituționala": "anticonstituțional",
    "anticonstituțională": "anticonstituțional",
    "anticonstituționale": "anticonstituțional",
    "anticonstituționalei": "anticonstituțional",
    "anticonstituționalele": "anticonstituțional",
    "anticonstituționalelor": "anticonstituțional",
    "anticonstituționali": "anticonstituțional",
    "anticonstituționalii": "anticonstituțional",
    "anticonstituționalilor": "anticonstituțional",
    "anticonstituționalul": "anticonstituțional",
    "anticonstituționalului": "anticonstituțional",
    "anticorpi": "anticorp",
    "anticorpii": "anticorp",
    "anticorpilor": "anticorp",
    "anticorpul": "anticorp",
    "anticorpului": "anticorp",
    "anticreștina": "anticreștin",
    "anticreștină": "anticreștin",
    "anticreștine": "anticreștin",
    "anticreștinei": "anticreștin",
    "anticreștinele": "anticreștin",
    "anticreștinelor": "anticreștin",
    "anticreștini": "anticreștin",
    "anticreștinii": "anticreștin",
    "anticreștinilor": "anticreștin",
    "anticreștinul": "anticreștin",
    "anticreștinului": "anticreștin",
    "anticreștina": "anticreștină",
    "anticreștine": "anticreștină",
    "anticreștinei": "anticreștină",
    "anticreștinele": "anticreștină",
    "anticreștinelor": "anticreștină",
    "anticrista": "anticrist",
    "anticristă": "anticrist",
    "anticriste": "anticrist",
    "anticristei": "anticrist",
    "anticristele": "anticrist",
    "anticristelor": "anticrist",
    "anticriști": "anticrist",
    "anticriștii": "anticrist",
    "anticriștilor": "anticrist",
    "anticristul": "anticrist",
    "anticristului": "anticrist",
    "anticrista": "anticristă",
    "anticriste": "anticristă",
    "anticristei": "anticristă",
    "anticristele": "anticristă",
    "anticristelor": "anticristă",
    "antiderapanta": "antiderapant",
    "antiderapantă": "antiderapant",
    "antiderapante": "antiderapant",
    "antiderapantei": "antiderapant",
    "antiderapantele": "antiderapant",
    "antiderapantelor": "antiderapant",
    "antiderapanți": "antiderapant",
    "antiderapanții": "antiderapant",
    "antiderapanților": "antiderapant",
    "antiderapantul": "antiderapant",
    "antiderapantului": "antiderapant",
    "antidiareica": "antidiareic",
    "antidiareică": "antidiareic",
    "antidiareice": "antidiareic",
    "antidiareicei": "antidiareic",
    "antidiareicele": "antidiareic",
    "antidiareicelor": "antidiareic",
    "antidiareici": "antidiareic",
    "antidiareicii": "antidiareic",
    "antidiareicilor": "antidiareic",
    "antidiareicul": "antidiareic",
    "antidiareicului": "antidiareic",
    "antidinastica": "antidinastic",
    "antidinastică": "antidinastic",
    "antidinastice": "antidinastic",
    "antidinasticei": "antidinastic",
    "antidinasticele": "antidinastic",
    "antidinasticelor": "antidinastic",
    "antidinastici": "antidinastic",
    "antidinasticii": "antidinastic",
    "antidinasticilor": "antidinastic",
    "antidinasticul": "antidinastic",
    "antidinasticului": "antidinastic",
    "antidotul": "antidot",
    "antidotului": "antidot",
    "antidoturi": "antidot",
    "antidoturile": "antidot",
    "antidoturilor": "antidot",
    "antieducativa": "antieducativ",
    "antieducativă": "antieducativ",
    "antieducative": "antieducativ",
    "antieducativei": "antieducativ",
    "antieducativele": "antieducativ",
    "antieducativelor": "antieducativ",
    "antieducativi": "antieducativ",
    "antieducativii": "antieducativ",
    "antieducativilor": "antieducativ",
    "antieducativul": "antieducativ",
    "antieducativului": "antieducativ",
    "antiepidemica": "antiepidemic",
    "antiepidemică": "antiepidemic",
    "antiepidemice": "antiepidemic",
    "antiepidemicei": "antiepidemic",
    "antiepidemicele": "antiepidemic",
    "antiepidemicelor": "antiepidemic",
    "antiepidemici": "antiepidemic",
    "antiepidemicii": "antiepidemic",
    "antiepidemicilor": "antiepidemic",
    "antiepidemicul": "antiepidemic",
    "antiepidemicului": "antiepidemic",
    "antiestetica": "antiestetic",
    "antiestetică": "antiestetic",
    "antiestetice": "antiestetic",
    "antiesteticei": "antiestetic",
    "antiesteticele": "antiestetic",
    "antiesteticelor": "antiestetic",
    "antiestetici": "antiestetic",
    "antiesteticii": "antiestetic",
    "antiesteticilor": "antiestetic",
    "antiesteticul": "antiestetic",
    "antiesteticului": "antiestetic",
    "antifascista": "antifascist",
    "antifascistă": "antifascist",
    "antifasciste": "antifascist",
    "antifascistei": "antifascist",
    "antifascistele": "antifascist",
    "antifascistelor": "antifascist",
    "antifasciști": "antifascist",
    "antifasciștii": "antifascist",
    "antifasciștilor": "antifascist",
    "antifascistul": "antifascist",
    "antifascistului": "antifascist",
    "antifraza": "antifrază",
    "antifraze": "antifrază",
    "antifrazei": "antifrază",
    "antifrazele": "antifrază",
    "antifrazelor": "antifrază",
    "antigenul": "antigen",
    "antigenului": "antigen",
    "antiguvernamentala": "antiguvernamental",
    "antiguvernamentală": "antiguvernamental",
    "antiguvernamentale": "antiguvernamental",
    "antiguvernamentalei": "antiguvernamental",
    "antiguvernamentalele": "antiguvernamental",
    "antiguvernamentalelor": "antiguvernamental",
    "antiguvernamentali": "antiguvernamental",
    "antiguvernamentalii": "antiguvernamental",
    "antiguvernamentalilor": "antiguvernamental",
    "antiguvernamentalul": "antiguvernamental",
    "antiguvernamentalului": "antiguvernamental",
    "antiinflamatoare": "antiinflamator",
    "antiinflamatoarea": "antiinflamator",
    "antiinflamatoarei": "antiinflamator",
    "antiinflamatoarele": "antiinflamator",
    "antiinflamatoarelor": "antiinflamator",
    "antiinflamatori": "antiinflamator",
    "antiinflamatorii": "antiinflamator",
    "antiinflamatorilor": "antiinflamator",
    "antiinflamatorul": "antiinflamator",
    "antiinflamatorului": "antiinflamator",
    "antiintelectuala": "antiintelectual",
    "antiintelectuală": "antiintelectual",
    "antiintelectuale": "antiintelectual",
    "antiintelectualei": "antiintelectual",
    "antiintelectualele": "antiintelectual",
    "antiintelectualelor": "antiintelectual",
    "antiintelectuali": "antiintelectual",
    "antiintelectualii": "antiintelectual",
    "antiintelectualilor": "antiintelectual",
    "antiintelectualul": "antiintelectual",
    "antiintelectualului": "antiintelectual",
    "antiintelectuala": "antiintelectuală",
    "antiintelectuale": "antiintelectuală",
    "antiintelectualei": "antiintelectuală",
    "antiintelectualele": "antiintelectuală",
    "antiintelectualelor": "antiintelectuală",
    "antiiperialista": "antiiperialist",
    "antiiperialistă": "antiiperialist",
    "antiiperialiste": "antiiperialist",
    "antiiperialistei": "antiiperialist",
    "antiiperialistele": "antiiperialist",
    "antiiperialistelor": "antiiperialist",
    "antiiperialiști": "antiiperialist",
    "antiiperialiștii": "antiiperialist",
    "antiiperialiștilor": "antiiperialist",
    "antiiperialistul": "antiiperialist",
    "antiiperialistului": "antiiperialist",
    "antilogia": "antilogie",
    "antilogiei": "antilogie",
    "antilogii": "antilogie",
    "antilogiile": "antilogie",
    "antilogiilor": "antilogie",
    "antimaghiară": "antimaghiar",
    "antimaghiare": "antimaghiar",
    "antimaghiari": "antimaghiar",
    "antimarxista": "antimarxist",
    "antimarxistă": "antimarxist",
    "antimarxiste": "antimarxist",
    "antimarxistei": "antimarxist",
    "antimarxistele": "antimarxist",
    "antimarxistelor": "antimarxist",
    "antimarxiști": "antimarxist",
    "antimarxiștii": "antimarxist",
    "antimarxiștilor": "antimarxist",
    "antimarxistul": "antimarxist",
    "antimarxistului": "antimarxist",
    "antimonarhica": "antimonarhic",
    "antimonarhică": "antimonarhic",
    "antimonarhice": "antimonarhic",
    "antimonarhicei": "antimonarhic",
    "antimonarhicele": "antimonarhic",
    "antimonarhicelor": "antimonarhic",
    "antimonarhici": "antimonarhic",
    "antimonarhicii": "antimonarhic",
    "antimonarhicilor": "antimonarhic",
    "antimonarhicul": "antimonarhic",
    "antimonarhicului": "antimonarhic",
    "antimonica": "antimonic",
    "antimonică": "antimonic",
    "antimonice": "antimonic",
    "antimonicei": "antimonic",
    "antimonicele": "antimonic",
    "antimonicelor": "antimonic",
    "antimonici": "antimonic",
    "antimonicii": "antimonic",
    "antimonicilor": "antimonic",
    "antimonicul": "antimonic",
    "antimonicului": "antimonic",
    "antimuncitoreasca": "antimuncitoresc",
    "antimuncitorească": "antimuncitoresc",
    "antimuncitorescul": "antimuncitoresc",
    "antimuncitorescului": "antimuncitoresc",
    "antimuncitorești": "antimuncitoresc",
    "antimuncitoreștii": "antimuncitoresc",
    "antimuncitoreștile": "antimuncitoresc",
    "antimuncitoreștilor": "antimuncitoresc",
    "antinaționala": "antinațional",
    "antinațională": "antinațional",
    "antinaționale": "antinațional",
    "antinaționalei": "antinațional",
    "antinaționalele": "antinațional",
    "antinaționalelor": "antinațional",
    "antinaționali": "antinațional",
    "antinaționalii": "antinațional",
    "antinaționalilor": "antinațional",
    "antinaționalul": "antinațional",
    "antinaționalului": "antinațional",
    "antinaționala": "antinațională",
    "antinaționale": "antinațională",
    "antinaționalei": "antinațională",
    "antinaționalele": "antinațională",
    "antinaționalelor": "antinațională",
    "antinevralgica": "antinevralgic",
    "antinevralgică": "antinevralgic",
    "antinevralgice": "antinevralgic",
    "antinevralgicei": "antinevralgic",
    "antinevralgicele": "antinevralgic",
    "antinevralgicelor": "antinevralgic",
    "antinevralgici": "antinevralgic",
    "antinevralgicii": "antinevralgic",
    "antinevralgicilor": "antinevralgic",
    "antinevralgicul": "antinevralgic",
    "antinevralgicului": "antinevralgic",
    "antinomica": "antinomic",
    "antinomică": "antinomic",
    "antinomice": "antinomic",
    "antinomicei": "antinomic",
    "antinomicele": "antinomic",
    "antinomicelor": "antinomic",
    "antinomici": "antinomic",
    "antinomicii": "antinomic",
    "antinomicilor": "antinomic",
    "antinomicul": "antinomic",
    "antinomicului": "antinomic",
    "antinomia": "antinomie",
    "antinomiei": "antinomie",
    "antinomii": "antinomie",
    "antinomiile": "antinomie",
    "antinomiilor": "antinomie",
    "antioccidentală": "antioccidental",
    "antioccidentale": "antioccidental",
    "antioccidentali": "antioccidental",
    "antiparalela": "antiparalel",
    "antiparalelă": "antiparalel",
    "antiparalele": "antiparalel",
    "antiparalelei": "antiparalel",
    "antiparalelele": "antiparalel",
    "antiparalelelor": "antiparalel",
    "antiparaleli": "antiparalel",
    "antiparalelii": "antiparalel",
    "antiparalelilor": "antiparalel",
    "antiparalelul": "antiparalel",
    "antiparalelului": "antiparalel",
    "antipartinica": "antipartinic",
    "antipartinică": "antipartinic",
    "antipartinice": "antipartinic",
    "antipartinicei": "antipartinic",
    "antipartinicele": "antipartinic",
    "antipartinicelor": "antipartinic",
    "antipartinici": "antipartinic",
    "antipartinicii": "antipartinic",
    "antipartinicilor": "antipartinic",
    "antipartinicul": "antipartinic",
    "antipartinicului": "antipartinic",
    "antipatica": "antipatic",
    "antipatică": "antipatic",
    "antipatice": "antipatic",
    "antipaticei": "antipatic",
    "antipaticele": "antipatic",
    "antipaticelor": "antipatic",
    "antipatici": "antipatic",
    "antipaticii": "antipatic",
    "antipaticilor": "antipatic",
    "antipaticul": "antipatic",
    "antipaticului": "antipatic",
    "antipatia": "antipatie",
    "antipatiei": "antipatie",
    "antipatii": "antipatie",
    "antipatiile": "antipatie",
    "antipatiilor": "antipatie",
    "antipedagogia": "antipedagogie",
    "antipedagogiei": "antipedagogie",
    "antipedagogii": "antipedagogie",
    "antipedagogiile": "antipedagogie",
    "antipedagogiilor": "antipedagogie",
    "antipiretica": "antipiretic",
    "antipiretică": "antipiretic",
    "antipiretice": "antipiretic",
    "antipireticei": "antipiretic",
    "antipireticele": "antipiretic",
    "antipireticelor": "antipiretic",
    "antipiretici": "antipiretic",
    "antipireticii": "antipiretic",
    "antipireticilor": "antipiretic",
    "antipireticul": "antipiretic",
    "antipireticului": "antipiretic",
    "antipodul": "antipod",
    "antipodului": "antipod",
    "antipozi": "antipod",
    "antipozii": "antipod",
    "antipozilor": "antipod",
    "antipopulara": "antipopular",
    "antipopulară": "antipopular",
    "antipopulare": "antipopular",
    "antipopularei": "antipopular",
    "antipopularele": "antipopular",
    "antipopularelor": "antipopular",
    "antipopulari": "antipopular",
    "antipopularii": "antipopular",
    "antipopularilor": "antipopular",
    "antipopularul": "antipopular",
    "antipopularului": "antipopular",
    "antiprezidențiala": "antiprezidențial",
    "antiprezidențială": "antiprezidențial",
    "antiprezidențiale": "antiprezidențial",
    "antiprezidențialei": "antiprezidențial",
    "antiprezidențialele": "antiprezidențial",
    "antiprezidențialelor": "antiprezidențial",
    "antiprezidențiali": "antiprezidențial",
    "antiprezidențialii": "antiprezidențial",
    "antiprezidențialilor": "antiprezidențial",
    "antiprezidențialul": "antiprezidențial",
    "antiprezidențialului": "antiprezidențial",
    "antirabica": "antirabic",
    "antirabică": "antirabic",
    "antirabice": "antirabic",
    "antirabicei": "antirabic",
    "antirabicele": "antirabic",
    "antirabicelor": "antirabic",
    "antirabici": "antirabic",
    "antirabicii": "antirabic",
    "antirabicilor": "antirabic",
    "antirabicul": "antirabic",
    "antirabicului": "antirabic",
    "antirealista": "antirealist",
    "antirealistă": "antirealist",
    "antirealiste": "antirealist",
    "antirealistei": "antirealist",
    "antirealistele": "antirealist",
    "antirealistelor": "antirealist",
    "antirealiști": "antirealist",
    "antirealiștii": "antirealist",
    "antirealiștilor": "antirealist",
    "antirealistul": "antirealist",
    "antirealistului": "antirealist",
    "antiregalista": "antiregalist",
    "antiregalistă": "antiregalist",
    "antiregaliste": "antiregalist",
    "antiregalistei": "antiregalist",
    "antiregalistele": "antiregalist",
    "antiregalistelor": "antiregalist",
    "antiregaliști": "antiregalist",
    "antiregaliștii": "antiregalist",
    "antiregaliștilor": "antiregalist",
    "antiregalistul": "antiregalist",
    "antiregalistului": "antiregalist",
    "antireligioasa": "antireligios",
    "antireligioasă": "antireligios",
    "antireligioase": "antireligios",
    "antireligioasei": "antireligios",
    "antireligioasele": "antireligios",
    "antireligioaselor": "antireligios",
    "antireligioși": "antireligios",
    "antireligioșii": "antireligios",
    "antireligioșilor": "antireligios",
    "antireligiosul": "antireligios",
    "antireligiosului": "antireligios",
    "anti-româneasca": "anti-românesc",
    "anti-românească": "anti-românesc",
    "anti-românescul": "anti-românesc",
    "anti-românescului": "anti-românesc",
    "anti-românești": "anti-românesc",
    "anti-româneștii": "anti-românesc",
    "anti-româneștile": "anti-românesc",
    "anti-româneștilor": "anti-românesc",
    "antisemita": "antisemit",
    "antisemită": "antisemit",
    "antisemite": "antisemit",
    "antisemitei": "antisemit",
    "antisemitele": "antisemit",
    "antisemitelor": "antisemit",
    "antisemiți": "antisemit",
    "antisemiții": "antisemit",
    "antisemiților": "antisemit",
    "antisemitul": "antisemit",
    "antisemitului": "antisemit",
    "antisemitisme": "antisemitism",
    "antisemitismele": "antisemitism",
    "antisemitismelor": "antisemitism",
    "antisemitismul": "antisemitism",
    "antisemitismului": "antisemitism",
    "antiseptica": "antiseptic",
    "antiseptică": "antiseptic",
    "antiseptice": "antiseptic",
    "antisepticei": "antiseptic",
    "antisepticele": "antiseptic",
    "antisepticelor": "antiseptic",
    "antiseptici": "antiseptic",
    "antisepticii": "antiseptic",
    "antisepticilor": "antiseptic",
    "antisepticul": "antiseptic",
    "antisepticului": "antiseptic",
    "Anti-Sexul": "Anti-Sex",
    "Anti-Sexului": "Anti-Sex",
    "antisimți": "antisimț",
    "antisimții": "antisimț",
    "antisimților": "antisimț",
    "antisimțul": "antisimț",
    "antisimțului": "antisimț",
    "antisociala": "antisocial",
    "antisocială": "antisocial",
    "antisociale": "antisocial",
    "antisocialei": "antisocial",
    "antisocialele": "antisocial",
    "antisocialelor": "antisocial",
    "antisociali": "antisocial",
    "antisocialii": "antisocial",
    "antisocialilor": "antisocial",
    "antisocialul": "antisocial",
    "antisocialului": "antisocial",
    "antispasmodica": "antispasmodic",
    "antispasmodică": "antispasmodic",
    "antispasmodice": "antispasmodic",
    "antispasmodicei": "antispasmodic",
    "antispasmodicele": "antispasmodic",
    "antispasmodicelor": "antispasmodic",
    "antispasmodici": "antispasmodic",
    "antispasmodicii": "antispasmodic",
    "antispasmodicilor": "antispasmodic",
    "antispasmodicul": "antispasmodic",
    "antispasmodicului": "antispasmodic",
    "antistatala": "antistatal",
    "antistatală": "antistatal",
    "antistatale": "antistatal",
    "antistatalei": "antistatal",
    "antistatalele": "antistatal",
    "antistatalelor": "antistatal",
    "antistatali": "antistatal",
    "antistatalii": "antistatal",
    "antistatalilor": "antistatal",
    "antistatalul": "antistatal",
    "antistatalului": "antistatal",
    "antiștiițifica": "antiștiițific",
    "antiștiițifică": "antiștiițific",
    "antiștiițifice": "antiștiițific",
    "antiștiițificei": "antiștiițific",
    "antiștiițificele": "antiștiițific",
    "antiștiițificelor": "antiștiițific",
    "antiștiițifici": "antiștiițific",
    "antiștiițificii": "antiștiițific",
    "antiștiițificilor": "antiștiițific",
    "antiștiițificul": "antiștiițific",
    "antiștiițificului": "antiștiițific",
    "antistrofa": "antistrofă",
    "antistrofe": "antistrofă",
    "antistrofei": "antistrofă",
    "antistrofele": "antistrofă",
    "antistrofelor": "antistrofă",
    "antiterorista": "antiterorist",
    "antiteroristă": "antiterorist",
    "antiteroriste": "antiterorist",
    "antiteroristei": "antiterorist",
    "antiteroristele": "antiterorist",
    "antiteroristelor": "antiterorist",
    "antiteroriști": "antiterorist",
    "antiteroriștii": "antiterorist",
    "antiteroriștilor": "antiterorist",
    "antiteroristul": "antiterorist",
    "antiteroristului": "antiterorist",
    "antiterorista": "antiteroristă",
    "antiteroriste": "antiteroristă",
    "antiteroristei": "antiteroristă",
    "antiteroristele": "antiteroristă",
    "antiteroristelor": "antiteroristă",
    "antitetica": "antitetic",
    "antitetică": "antitetic",
    "antitetice": "antitetic",
    "antiteticei": "antitetic",
    "antiteticele": "antitetic",
    "antiteticelor": "antitetic",
    "antitetici": "antitetic",
    "antiteticii": "antitetic",
    "antiteticilor": "antitetic",
    "antiteticul": "antitetic",
    "antiteticului": "antitetic",
    "antiteza": "antiteză",
    "antiteze": "antiteză",
    "antitezei": "antiteză",
    "antitezele": "antiteză",
    "antitezelor": "antiteză",
    "antitrinitara": "antitrinitar",
    "antitrinitară": "antitrinitar",
    "antitrinitare": "antitrinitar",
    "antitrinitarei": "antitrinitar",
    "antitrinitarele": "antitrinitar",
    "antitrinitarelor": "antitrinitar",
    "antitrinitari": "antitrinitar",
    "antitrinitarii": "antitrinitar",
    "antitrinitarilor": "antitrinitar",
    "antitrinitarul": "antitrinitar",
    "antitrinitarului": "antitrinitar",
    "antiumana": "antiuman",
    "antiumană": "antiuman",
    "antiumane": "antiuman",
    "antiumanei": "antiuman",
    "antiumanele": "antiuman",
    "antiumanelor": "antiuman",
    "antiumani": "antiuman",
    "antiumanii": "antiuman",
    "antiumanilor": "antiuman",
    "antiumanul": "antiuman",
    "antiumanului": "antiuman",
    "antivirala": "antiviral",
    "antivirală": "antiviral",
    "antivirale": "antiviral",
    "antiviralei": "antiviral",
    "antiviralele": "antiviral",
    "antiviralelor": "antiviral",
    "antivirali": "antiviral",
    "antiviralii": "antiviral",
    "antiviralilor": "antiviral",
    "antiviralul": "antiviral",
    "antiviralului": "antiviral",
    "antologica": "antologic",
    "antologică": "antologic",
    "antologice": "antologic",
    "antologicei": "antologic",
    "antologicele": "antologic",
    "antologicelor": "antologic",
    "antologici": "antologic",
    "antologicii": "antologic",
    "antologicilor": "antologic",
    "antologicul": "antologic",
    "antologicului": "antologic",
    "antologia": "antologie",
    "antologiei": "antologie",
    "antologii": "antologie",
    "antologiile": "antologie",
    "antologiilor": "antologie",
    "antonime": "antonim",
    "antonimele": "antonim",
    "antonimelor": "antonim",
    "antonimul": "antonim",
    "antonimului": "antonim",
    "antonimica": "antonimic",
    "antonimică": "antonimic",
    "antonimice": "antonimic",
    "antonimicei": "antonimic",
    "antonimicele": "antonimic",
    "antonimicelor": "antonimic",
    "antonimici": "antonimic",
    "antonimicii": "antonimic",
    "antonimicilor": "antonimic",
    "antonimicul": "antonimic",
    "antonimicului": "antonimic",
    "antonomaza": "antonomază",
    "antonomaze": "antonomază",
    "antonomazei": "antonomază",
    "antonomazele": "antonomază",
    "antonomazelor": "antonomază",
    "antracitul": "antracit",
    "antracitului": "antracit",
    "antracte": "antract",
    "antractele": "antract",
    "antractelor": "antract",
    "antractul": "antract",
    "antractului": "antract",
    "antraxe": "antrax",
    "antraxele": "antrax",
    "antraxelor": "antrax",
    "antraxul": "antrax",
    "antraxului": "antrax",
    "antraxuri": "antrax",
    "antraxurile": "antrax",
    "antraxurilor": "antrax",
    "antrenul": "antren",
    "antrenului": "antren",
    "antrenuri": "antren",
    "antrenurile": "antren",
    "antrenurilor": "antren",
    "antrenă": "antrena",
    "antrenai": "antrena",
    "antrenam": "antrena",
    "antrenăm": "antrena",
    "antrenând": "antrena",
    "antrenându": "antrena",
    "antrenară": "antrena",
    "antrenarăm": "antrena",
    "antrenarăți": "antrena",
    "antrenase": "antrena",
    "antrenasem": "antrena",
    "antrenaseră": "antrena",
    "antrenaserăm": "antrena",
    "antrenaserăți": "antrena",
    "antrenaseși": "antrena",
    "antrenași": "antrena",
    "antrenat": "antrena",
    "antrenați": "antrena",
    "antrenatu": "antrena",
    "antrenau": "antrena",
    "antrenează": "antrena",
    "antrenez": "antrena",
    "antreneze": "antrena",
    "antrenezi": "antrena",
    "neantrenând": "antrena",
    "neantrenându": "antrena",
    "nemaiantrenând": "antrena",
    "nemaiantrenându": "antrena",
    "antrenamente": "antrenament",
    "antrenamentele": "antrenament",
    "antrenamentelor": "antrenament",
    "antrenamentul": "antrenament",
    "antrenamentului": "antrenament",
    "antrenanta": "antrenant",
    "antrenantă": "antrenant",
    "antrenante": "antrenant",
    "antrenantei": "antrenant",
    "antrenantele": "antrenant",
    "antrenantelor": "antrenant",
    "antrenanți": "antrenant",
    "antrenanții": "antrenant",
    "antrenanților": "antrenant",
    "antrenantul": "antrenant",
    "antrenantului": "antrenant",
    "antrenarea": "antrenare",
    "antrenări": "antrenare",
    "antrenării": "antrenare",
    "antrenările": "antrenare",
    "antrenata": "antrenat",
    "antrenată": "antrenat",
    "antrenate": "antrenat",
    "antrenatei": "antrenat",
    "antrenatele": "antrenat",
    "antrenatelor": "antrenat",
    "antrenați": "antrenat",
    "antrenații": "antrenat",
    "antrenaților": "antrenat",
    "antrenatul": "antrenat",
    "antrenatului": "antrenat",
    "antrenoarea": "antrenoare",
    "antrenoarei": "antrenoare",
    "antrenoarele": "antrenoare",
    "antrenoarelor": "antrenoare",
    "antrenori": "antrenor",
    "antrenorii": "antrenor",
    "antrenorilor": "antrenor",
    "antrenorul": "antrenor",
    "antrenorului": "antrenor",
    "antrepozite": "antrepozit",
    "antrepozitele": "antrepozit",
    "antrepozitelor": "antrepozit",
    "antrepozitul": "antrepozit",
    "antrepozitului": "antrepozit",
    "antreprenori": "antreprenor",
    "antreprenorii": "antreprenor",
    "antreprenorilor": "antreprenor",
    "antreprenorul": "antreprenor",
    "antreprenorului": "antreprenor",
    "antrepriza": "antrepriză",
    "antreprize": "antrepriză",
    "antreprizei": "antrepriză",
    "antreprizele": "antrepriză",
    "antreprizelor": "antrepriză",
    "antretul": "antret",
    "antretului": "antret",
    "antreturi": "antret",
    "antreturile": "antret",
    "antreturilor": "antret",
    "antreul": "antreu",
    "antreului": "antreu",
    "antreuri": "antreu",
    "antreurile": "antreu",
    "antreurilor": "antreu",
    "antricoate": "antricot",
    "antricoatele": "antricot",
    "antricoatelor": "antricot",
    "antricotul": "antricot",
    "antricotului": "antricot",
    "antropocentrica": "antropocentric",
    "antropocentrică": "antropocentric",
    "antropocentrice": "antropocentric",
    "antropocentricei": "antropocentric",
    "antropocentricele": "antropocentric",
    "antropocentricelor": "antropocentric",
    "antropocentrici": "antropocentric",
    "antropocentricii": "antropocentric",
    "antropocentricilor": "antropocentric",
    "antropocentricul": "antropocentric",
    "antropocentricului": "antropocentric",
    "antropofaga": "antropofag",
    "antropofagă": "antropofag",
    "antropofage": "antropofag",
    "antropofagei": "antropofag",
    "antropofagele": "antropofag",
    "antropofagelor": "antropofag",
    "antropofagi": "antropofag",
    "antropofagii": "antropofag",
    "antropofagilor": "antropofag",
    "antropofagul": "antropofag",
    "antropofagului": "antropofag",
    "antropogeneza": "antropogeneză",
    "antropogeneze": "antropogeneză",
    "antropogenezei": "antropogeneză",
    "antropogenezele": "antropogeneză",
    "antropogenezelor": "antropogeneză",
    "antropoida": "antropoid",
    "antropoidă": "antropoid",
    "antropoide": "antropoid",
    "antropoidei": "antropoid",
    "antropoidele": "antropoid",
    "antropoidelor": "antropoid",
    "antropoidul": "antropoid",
    "antropoidului": "antropoid",
    "antropoizi": "antropoid",
    "antropoizii": "antropoid",
    "antropoizilor": "antropoid",
    "antropologica": "antropologic",
    "antropologică": "antropologic",
    "antropologice": "antropologic",
    "antropologicei": "antropologic",
    "antropologicele": "antropologic",
    "antropologicelor": "antropologic",
    "antropologici": "antropologic",
    "antropologicii": "antropologic",
    "antropologicilor": "antropologic",
    "antropologicul": "antropologic",
    "antropologicului": "antropologic",
    "antropologia": "antropologie",
    "antropologiei": "antropologie",
    "antropologii": "antropologie",
    "antropologiile": "antropologie",
    "antropologiilor": "antropologie",
    "antropometrica": "antropometric",
    "antropometrică": "antropometric",
    "antropometrice": "antropometric",
    "antropometricei": "antropometric",
    "antropometricele": "antropometric",
    "antropometricelor": "antropometric",
    "antropometrici": "antropometric",
    "antropometricii": "antropometric",
    "antropometricilor": "antropometric",
    "antropometricul": "antropometric",
    "antropometricului": "antropometric",
    "antropomorfa": "antropomorf",
    "antropomorfă": "antropomorf",
    "antropomorfe": "antropomorf",
    "antropomorfei": "antropomorf",
    "antropomorfele": "antropomorf",
    "antropomorfelor": "antropomorf",
    "antropomorfi": "antropomorf",
    "antropomorfii": "antropomorf",
    "antropomorfilor": "antropomorf",
    "antropomorful": "antropomorf",
    "antropomorfului": "antropomorf",
    "antropozofica": "antropozofic",
    "antropozofică": "antropozofic",
    "antropozofice": "antropozofic",
    "antropozoficei": "antropozofic",
    "antropozoficele": "antropozofic",
    "antropozoficelor": "antropozofic",
    "antropozofici": "antropozofic",
    "antropozoficii": "antropozofic",
    "antropozoficilor": "antropozofic",
    "antropozoficul": "antropozofic",
    "antropozoficului": "antropozofic",
    "antropozofia": "antropozofie",
    "antropozofiei": "antropozofie",
    "antropozofii": "antropozofie",
    "antropozofiile": "antropozofie",
    "antropozofiilor": "antropozofie",
    "antuma": "antum",
    "antumă": "antum",
    "antume": "antum",
    "antumei": "antum",
    "antumele": "antum",
    "antumelor": "antum",
    "antumi": "antum",
    "antumii": "antum",
    "antumilor": "antum",
    "antumul": "antum",
    "antumului": "antum",
    "anturaje": "anturaj",
    "anturajele": "anturaj",
    "anturajelor": "anturaj",
    "anturajul": "anturaj",
    "anturajului": "anturaj",
    "anuala": "anual",
    "anuală": "anual",
    "anuale": "anual",
    "anualei": "anual",
    "anualele": "anual",
    "anualelor": "anual",
    "anuali": "anual",
    "anualii": "anual",
    "anualilor": "anual",
    "anualul": "anual",
    "anualului": "anual",
    "anualizată": "anualizat",
    "anualizate": "anualizat",
    "anualizați": "anualizat",
    "anuare": "anuar",
    "anuarele": "anuar",
    "anuarelor": "anuar",
    "anuarul": "anuar",
    "anuarului": "anuar",
    "anu'": "anul",
    "a.c.": "anul_curent",
    "anulă": "anula",
    "anulai": "anula",
    "anulam": "anula",
    "anulăm": "anula",
    "anulând": "anula",
    "anulându": "anula",
    "anulară": "anula",
    "anularăm": "anula",
    "anularăți": "anula",
    "anulase": "anula",
    "anulasem": "anula",
    "anulaseră": "anula",
    "anulaserăm": "anula",
    "anulaserăți": "anula",
    "anulaseși": "anula",
    "anulași": "anula",
    "anulat": "anula",
    "anulați": "anula",
    "anulatu": "anula",
    "anulau": "anula",
    "anulează": "anula",
    "anulez": "anula",
    "anuleze": "anula",
    "anulezi": "anula",
    "neanulând": "anula",
    "neanulându": "anula",
    "nemaianulând": "anula",
    "nemaianulându": "anula",
    "anularea": "anulare",
    "anulări": "anulare",
    "anulării": "anulare",
    "anulările": "anulare",
    "anulata": "anulat",
    "anulată": "anulat",
    "anulate": "anulat",
    "anulatei": "anulat",
    "anulatele": "anulat",
    "anulatelor": "anulat",
    "anulați": "anulat",
    "anulații": "anulat",
    "anulaților": "anulat",
    "anulatul": "anulat",
    "anulatului": "anulat",
    "anumită": "anumit",
    "anumite": "anumit",
    "anumiți": "anumit",
    "anumitor": "anumit",
    "anunțul": "anunț",
    "anunțului": "anunț",
    "anunțuri": "anunț",
    "anunțurile": "anunț",
    "anunțurilor": "anunț",
    "anunț": "anunța",
    "anunță": "anunța",
    "anunțai": "anunța",
    "anunțam": "anunța",
    "anunțăm": "anunța",
    "anunțând": "anunța",
    "anunțându": "anunța",
    "anunțară": "anunța",
    "anunțarăm": "anunța",
    "anunțarăți": "anunța",
    "anunțase": "anunța",
    "anunțasem": "anunța",
    "anunțaseră": "anunța",
    "anunțaserăm": "anunța",
    "anunțaserăți": "anunța",
    "anunțaseși": "anunța",
    "anunțași": "anunța",
    "anunțat": "anunța",
    "anunțați": "anunța",
    "anunțau": "anunța",
    "anunțe": "anunța",
    "anunți": "anunța",
    "neanunțând": "anunța",
    "neanunțându": "anunța",
    "nemaianunțând": "anunța",
    "nemaianunțându": "anunța",
    "anunțarea": "anunțare",
    "anunțări": "anunțare",
    "anunțării": "anunțare",
    "anunțările": "anunțare",
    "anunțata": "anunțat",
    "anunțată": "anunțat",
    "anunțate": "anunțat",
    "anunțatei": "anunțat",
    "anunțatele": "anunțat",
    "anunțatelor": "anunțat",
    "anunțați": "anunțat",
    "anunțații": "anunțat",
    "anunțaților": "anunțat",
    "anunțatul": "anunțat",
    "anunțatului": "anunțat",
    "anunțători": "anunțător",
    "anunțătorii": "anunțător",
    "anunțătorilor": "anunțător",
    "anunțătorul": "anunțător",
    "anunțătorului": "anunțător",
    "anuria": "anurie",
    "anuriei": "anurie",
    "anurii": "anurie",
    "anuriile": "anurie",
    "anuriilor": "anurie",
    "anusul": "anus",
    "anusului": "anus",
    "anusuri": "anus",
    "anusurile": "anus",
    "anusurilor": "anus",
    "anvelopa": "anvelopă",
    "anvelope": "anvelopă",
    "anvelopei": "anvelopă",
    "anvelopele": "anvelopă",
    "anvelopelor": "anvelopă",
    "anvergura": "anvergură",
    "anverguri": "anvergură",
    "anvergurii": "anvergură",
    "anvergurile": "anvergură",
    "anvergurilor": "anvergură",
    "anxietatea": "anxietate",
    "anxietăți": "anxietate",
    "anxietății": "anxietate",
    "anxietățile": "anxietate",
    "anxietăților": "anxietate",
    "aor.": "aorist",
    "aoristul": "aorist",
    "aoristului": "aorist",
    "aorta": "aortă",
    "aorte": "aortă",
    "aortei": "aortă",
    "aortele": "aortă",
    "aortelor": "aortă",
    "apa": "apă",
    "ape": "apă",
    "apei": "apă",
    "apele": "apă",
    "apelor": "apă",
    "apanaje": "apanaj",
    "apanajele": "apanaj",
    "apanajelor": "apanaj",
    "apanajul": "apanaj",
    "apanajului": "apanaj",
    "apăr": "apăra",
    "apără": "apăra",
    "apărai": "apăra",
    "apăram": "apăra",
    "apărăm": "apăra",
    "apărând": "apăra",
    "apărându": "apăra",
    "apărară": "apăra",
    "apărarăm": "apăra",
    "apărarăți": "apăra",
    "apărase": "apăra",
    "apărasem": "apăra",
    "apăraseră": "apăra",
    "apăraserăm": "apăra",
    "apăraserăți": "apăra",
    "apăraseși": "apăra",
    "apărași": "apăra",
    "apărat": "apăra",
    "apărați": "apăra",
    "apăratu": "apăra",
    "apărau": "apăra",
    "apere": "apăra",
    "aperi": "apăra",
    "neapărând": "apăra",
    "neapărându": "apăra",
    "nemaiapărând": "apăra",
    "nemaiapărându": "apăra",
    "apărabilă": "apărabil",
    "apărabile": "apărabil",
    "apărabili": "apărabil",
    "apărarea": "apărare",
    "apărări": "apărare",
    "apărării": "apărare",
    "apărările": "apărare",
    "aparate": "aparat",
    "aparatele": "aparat",
    "aparatelor": "aparat",
    "aparatul": "aparat",
    "aparatului": "aparat",
    "apărata": "apărat",
    "apărată": "apărat",
    "apărate": "apărat",
    "apăratei": "apărat",
    "apăratele": "apărat",
    "apăratelor": "apărat",
    "apărați": "apărat",
    "apărații": "apărat",
    "apăraților": "apărat",
    "apăratul": "apărat",
    "apăratului": "apărat",
    "aparataje": "aparataj",
    "aparatajele": "aparataj",
    "aparatajelor": "aparataj",
    "aparatajul": "aparataj",
    "aparatajului": "aparataj",
    "apărătoarea": "apărătoare",
    "apărătoarei": "apărătoare",
    "apărătoarele": "apărătoare",
    "apărătoarelor": "apărătoare",
    "apărătoare": "apărător",
    "apărătoarea": "apărător",
    "apărătoarei": "apărător",
    "apărătoarele": "apărător",
    "apărătoarelor": "apărător",
    "apărători": "apărător",
    "apărătorii": "apărător",
    "apărătorilor": "apărător",
    "apărătorul": "apărător",
    "apărătorului": "apărător",
    "aparatura": "aparatură",
    "aparaturi": "aparatură",
    "aparaturii": "aparatură",
    "aparaturile": "aparatură",
    "aparaturilor": "aparatură",
    "apar": "apărea",
    "apară": "apărea",
    "apărând": "apărea",
    "apărându": "apărea",
    "apare": "apărea",
    "apăreai": "apărea",
    "apăream": "apărea",
    "apăreați": "apărea",
    "apăreau": "apărea",
    "apărem": "apărea",
    "apăreți": "apărea",
    "apari": "apărea",
    "apăru": "apărea",
    "apărui": "apărea",
    "apărură": "apărea",
    "apărurăm": "apărea",
    "apărurăți": "apărea",
    "apăruse": "apărea",
    "apărusem": "apărea",
    "apăruseră": "apărea",
    "apăruserăm": "apărea",
    "apăruserăți": "apărea",
    "apăruseși": "apărea",
    "apăruși": "apărea",
    "apărut": "apărea",
    "apărutu": "apărea",
    "neapărând": "apărea",
    "neapărându": "apărea",
    "nemaiapărând": "apărea",
    "nemaiapărându": "apărea",
    "aparenta": "aparent",
    "aparentă": "aparent",
    "aparente": "aparent",
    "aparentei": "aparent",
    "aparentele": "aparent",
    "aparentelor": "aparent",
    "aparenți": "aparent",
    "aparenții": "aparent",
    "aparenților": "aparent",
    "aparentul": "aparent",
    "aparentului": "aparent",
    "aparența": "aparență",
    "aparențe": "aparență",
    "aparenței": "aparență",
    "aparențele": "aparență",
    "aparențelor": "aparență",
    "apariția": "apariție",
    "apariției": "apariție",
    "apariții": "apariție",
    "aparițiile": "apariție",
    "aparițiilor": "apariție",
    "ap.": "apartament",
    "apartamente": "apartament",
    "apartamentele": "apartament",
    "apartamentelor": "apartament",
    "apartamentul": "apartament",
    "apartamentului": "apartament",
    "apartenența": "apartenență",
    "apartenențe": "apartenență",
    "apartenenței": "apartenență",
    "apartenențele": "apartenență",
    "apartenențelor": "apartenență",
    "apartheidul": "apartheid",
    "apartheidului": "apartheid",
    "aparții": "aparține",
    "aparțin": "aparține",
    "aparțină": "aparține",
    "aparținând": "aparține",
    "aparținându": "aparține",
    "aparținea": "aparține",
    "aparțineai": "aparține",
    "aparțineam": "aparține",
    "aparțineați": "aparține",
    "aparțineau": "aparține",
    "aparținem": "aparține",
    "aparțineți": "aparține",
    "aparținu": "aparține",
    "aparținui": "aparține",
    "aparținură": "aparține",
    "aparținurăm": "aparține",
    "aparținurăți": "aparține",
    "aparținuse": "aparține",
    "aparținusem": "aparține",
    "aparținuseră": "aparține",
    "aparținuserăm": "aparține",
    "aparținuserăți": "aparține",
    "aparținuseși": "aparține",
    "aparținuși": "aparține",
    "aparținut": "aparține",
    "aparținutu": "aparține",
    "neaparținând": "aparține",
    "neaparținându": "aparține",
    "nemaiaparținând": "aparține",
    "nemaiaparținându": "aparține",
    "aparținuta": "aparținut",
    "aparținută": "aparținut",
    "aparținute": "aparținut",
    "aparținutei": "aparținut",
    "aparținutele": "aparținut",
    "aparținutelor": "aparținut",
    "aparținuți": "aparținut",
    "aparținuții": "aparținut",
    "aparținuților": "aparținut",
    "aparținutul": "aparținut",
    "aparținutului": "aparținut",
    "apăruta": "apărut",
    "apărută": "apărut",
    "apărute": "apărut",
    "apărutei": "apărut",
    "apărutele": "apărut",
    "apărutelor": "apărut",
    "apăruți": "apărut",
    "apăruții": "apărut",
    "apăruților": "apărut",
    "apărutul": "apărut",
    "apărutului": "apărut",
    "apași": "apaș",
    "apașii": "apaș",
    "apașilor": "apaș",
    "apașul": "apaș",
    "apașului": "apaș",
    "apăs": "apăsa",
    "apasă": "apăsa",
    "apăsă": "apăsa",
    "apăsai": "apăsa",
    "apăsam": "apăsa",
    "apăsăm": "apăsa",
    "apăsând": "apăsa",
    "apăsându": "apăsa",
    "apăsară": "apăsa",
    "apăsarăm": "apăsa",
    "apăsarăți": "apăsa",
    "apăsase": "apăsa",
    "apăsasem": "apăsa",
    "apăsaseră": "apăsa",
    "apăsaserăm": "apăsa",
    "apăsaserăți": "apăsa",
    "apăsaseși": "apăsa",
    "apăsași": "apăsa",
    "apăsat": "apăsa",
    "apăsați": "apăsa",
    "apăsatu": "apăsa",
    "apăsau": "apăsa",
    "apese": "apăsa",
    "apeși": "apăsa",
    "neapăsând": "apăsa",
    "neapăsându": "apăsa",
    "nemaiapăsând": "apăsa",
    "nemaiapăsându": "apăsa",
    "apăsabilă": "apăsabil",
    "apăsabile": "apăsabil",
    "apăsabili": "apăsabil",
    "apăsarea": "apăsare",
    "apăsări": "apăsare",
    "apăsării": "apăsare",
    "apăsările": "apăsare",
    "apăsata": "apăsat",
    "apăsată": "apăsat",
    "apăsate": "apăsat",
    "apăsatei": "apăsat",
    "apăsatele": "apăsat",
    "apăsatelor": "apăsat",
    "apăsați": "apăsat",
    "apăsații": "apăsat",
    "apăsaților": "apăsat",
    "apăsatul": "apăsat",
    "apăsatului": "apăsat",
    "apăsătoare": "apăsător",
    "apăsătoarea": "apăsător",
    "apăsătoarei": "apăsător",
    "apăsătoarele": "apăsător",
    "apăsătoarelor": "apăsător",
    "apăsători": "apăsător",
    "apăsătorii": "apăsător",
    "apăsătorilor": "apăsător",
    "apăsătorul": "apăsător",
    "apăsătorului": "apăsător",
    "apăsătura": "apăsătură",
    "apăsături": "apăsătură",
    "apăsăturii": "apăsătură",
    "apăsăturile": "apăsătură",
    "apăsăturilor": "apăsătură",
    "apatica": "apatic",
    "apatică": "apatic",
    "apatice": "apatic",
    "apaticei": "apatic",
    "apaticele": "apatic",
    "apaticelor": "apatic",
    "apatici": "apatic",
    "apaticii": "apatic",
    "apaticilor": "apatic",
    "apaticul": "apatic",
    "apaticului": "apatic",
    "apatia": "apatie",
    "apatiei": "apatie",
    "apatii": "apatie",
    "apatiile": "apatie",
    "apatiilor": "apatie",
    "apătoasa": "apătos",
    "apătoasă": "apătos",
    "apătoase": "apătos",
    "apătoasei": "apătos",
    "apătoasele": "apătos",
    "apătoaselor": "apătos",
    "apătoși": "apătos",
    "apătoșii": "apătos",
    "apătoșilor": "apătos",
    "apătosul": "apătos",
    "apătosului": "apătos",
    "apeducte": "apeduct",
    "apeductele": "apeduct",
    "apeductelor": "apeduct",
    "apeductul": "apeduct",
    "apeductului": "apeduct",
    "apelul": "apel",
    "apelului": "apel",
    "apeluri": "apel",
    "apelurile": "apel",
    "apelurilor": "apel",
    "apelă": "apela",
    "apelai": "apela",
    "apelam": "apela",
    "apelăm": "apela",
    "apelând": "apela",
    "apelându": "apela",
    "apelară": "apela",
    "apelarăm": "apela",
    "apelarăți": "apela",
    "apelase": "apela",
    "apelasem": "apela",
    "apelaseră": "apela",
    "apelaserăm": "apela",
    "apelaserăți": "apela",
    "apelaseși": "apela",
    "apelași": "apela",
    "apelat": "apela",
    "apelați": "apela",
    "apelatu": "apela",
    "apelau": "apela",
    "apelează": "apela",
    "apelez": "apela",
    "apeleze": "apela",
    "apelezi": "apela",
    "neapelând": "apela",
    "neapelându": "apela",
    "nemaiapelând": "apela",
    "nemaiapelându": "apela",
    "apelarea": "apelare",
    "apelări": "apelare",
    "apelării": "apelare",
    "apelările": "apelare",
    "apelata": "apelat",
    "apelată": "apelat",
    "apelate": "apelat",
    "apelatei": "apelat",
    "apelatele": "apelat",
    "apelatelor": "apelat",
    "apelați": "apelat",
    "apelații": "apelat",
    "apelaților": "apelat",
    "apelatul": "apelat",
    "apelatului": "apelat",
    "ap.": "apelativ",
    "apelativa": "apelativ",
    "apelativă": "apelativ",
    "apelative": "apelativ",
    "apelativei": "apelativ",
    "apelativele": "apelativ",
    "apelativelor": "apelativ",
    "apelativi": "apelativ",
    "apelativii": "apelativ",
    "apelativilor": "apelativ",
    "apelativul": "apelativ",
    "apelativului": "apelativ",
    "apelpisita": "apelpisit",
    "apelpisită": "apelpisit",
    "apelpisite": "apelpisit",
    "apelpisitei": "apelpisit",
    "apelpisitele": "apelpisit",
    "apelpisitelor": "apelpisit",
    "apelpisiți": "apelpisit",
    "apelpisiții": "apelpisit",
    "apelpisiților": "apelpisit",
    "apelpisitul": "apelpisit",
    "apelpisitului": "apelpisit",
    "apendicele": "apendice",
    "apendicelor": "apendice",
    "apendicelui": "apendice",
    "apendicita": "apendicită",
    "apendicite": "apendicită",
    "apendicitei": "apendicită",
    "apendicitele": "apendicită",
    "apendicitelor": "apendicită",
    "aperceptiva": "aperceptiv",
    "aperceptivă": "aperceptiv",
    "aperceptive": "aperceptiv",
    "aperceptivei": "aperceptiv",
    "aperceptivele": "aperceptiv",
    "aperceptivelor": "aperceptiv",
    "aperceptivi": "aperceptiv",
    "aperceptivii": "aperceptiv",
    "aperceptivilor": "aperceptiv",
    "aperceptivul": "aperceptiv",
    "aperceptivului": "aperceptiv",
    "aperiodica": "aperiodic",
    "aperiodică": "aperiodic",
    "aperiodice": "aperiodic",
    "aperiodicei": "aperiodic",
    "aperiodicele": "aperiodic",
    "aperiodicelor": "aperiodic",
    "aperiodici": "aperiodic",
    "aperiodicii": "aperiodic",
    "aperiodicilor": "aperiodic",
    "aperiodicul": "aperiodic",
    "aperiodicului": "aperiodic",
    "apetala": "apetal",
    "apetală": "apetal",
    "apetale": "apetal",
    "apetalei": "apetal",
    "apetalele": "apetal",
    "apetalelor": "apetal",
    "apetali": "apetal",
    "apetalii": "apetal",
    "apetalilor": "apetal",
    "apetalul": "apetal",
    "apetalului": "apetal",
    "apetenta": "apetent",
    "apetentă": "apetent",
    "apetente": "apetent",
    "apetentei": "apetent",
    "apetentele": "apetent",
    "apetentelor": "apetent",
    "apetenți": "apetent",
    "apetenții": "apetent",
    "apetenților": "apetent",
    "apetentul": "apetent",
    "apetentului": "apetent",
    "apetența": "apetență",
    "apetențe": "apetență",
    "apetenței": "apetență",
    "apetențele": "apetență",
    "apetențelor": "apetență",
    "apetisanta": "apetisant",
    "apetisantă": "apetisant",
    "apetisante": "apetisant",
    "apetisantei": "apetisant",
    "apetisantele": "apetisant",
    "apetisantelor": "apetisant",
    "apetisanți": "apetisant",
    "apetisanții": "apetisant",
    "apetisanților": "apetisant",
    "apetisantul": "apetisant",
    "apetisantului": "apetisant",
    "apetitul": "apetit",
    "apetitului": "apetit",
    "apetituri": "apetit",
    "apetiturile": "apetit",
    "apetiturilor": "apetit",
    "apicala": "apical",
    "apicală": "apical",
    "apicale": "apical",
    "apicalei": "apical",
    "apicalele": "apical",
    "apicalelor": "apical",
    "apicali": "apical",
    "apicalii": "apical",
    "apicalilor": "apical",
    "apicalul": "apical",
    "apicalului": "apical",
    "apicola": "apicol",
    "apicolă": "apicol",
    "apicole": "apicol",
    "apicolei": "apicol",
    "apicolele": "apicol",
    "apicolelor": "apicol",
    "apicoli": "apicol",
    "apicolii": "apicol",
    "apicolilor": "apicol",
    "apicolul": "apicol",
    "apicolului": "apicol",
    "apicultori": "apicultor",
    "apicultorii": "apicultor",
    "apicultorilor": "apicultor",
    "apicultorul": "apicultor",
    "apicultorului": "apicultor",
    "apicultura": "apicultură",
    "apiculturi": "apicultură",
    "apiculturii": "apicultură",
    "apiculturile": "apicultură",
    "apiculturilor": "apicultură",
    "aplană": "aplana",
    "aplanai": "aplana",
    "aplanam": "aplana",
    "aplanăm": "aplana",
    "aplanând": "aplana",
    "aplanară": "aplana",
    "aplanarăm": "aplana",
    "aplanarăți": "aplana",
    "aplanase": "aplana",
    "aplanasem": "aplana",
    "aplanaseră": "aplana",
    "aplanaserăm": "aplana",
    "aplanaserăți": "aplana",
    "aplanaseși": "aplana",
    "aplanași": "aplana",
    "aplanat": "aplana",
    "aplanați": "aplana",
    "aplanatu": "aplana",
    "aplanau": "aplana",
    "aplanează": "aplana",
    "aplanez": "aplana",
    "aplaneze": "aplana",
    "aplanezi": "aplana",
    "neaplanând": "aplana",
    "nemaiaplanând": "aplana",
    "aplanarea": "aplanare",
    "aplanări": "aplanare",
    "aplanării": "aplanare",
    "aplanările": "aplanare",
    "aplanata": "aplanat",
    "aplanată": "aplanat",
    "aplanate": "aplanat",
    "aplanatei": "aplanat",
    "aplanatele": "aplanat",
    "aplanatelor": "aplanat",
    "aplanați": "aplanat",
    "aplanații": "aplanat",
    "aplanaților": "aplanat",
    "aplanatul": "aplanat",
    "aplanatului": "aplanat",
    "aplatiză": "aplatiza",
    "aplatizai": "aplatiza",
    "aplatizam": "aplatiza",
    "aplatizăm": "aplatiza",
    "aplatizând": "aplatiza",
    "aplatizându": "aplatiza",
    "aplatizară": "aplatiza",
    "aplatizarăm": "aplatiza",
    "aplatizarăți": "aplatiza",
    "aplatizase": "aplatiza",
    "aplatizasem": "aplatiza",
    "aplatizaseră": "aplatiza",
    "aplatizaserăm": "aplatiza",
    "aplatizaserăți": "aplatiza",
    "aplatizaseși": "aplatiza",
    "aplatizași": "aplatiza",
    "aplatizat": "aplatiza",
    "aplatizați": "aplatiza",
    "aplatizatu": "aplatiza",
    "aplatizau": "aplatiza",
    "aplatizează": "aplatiza",
    "aplatizez": "aplatiza",
    "aplatizeze": "aplatiza",
    "aplatizezi": "aplatiza",
    "neaplatizând": "aplatiza",
    "neaplatizându": "aplatiza",
    "nemaiaplatizând": "aplatiza",
    "nemaiaplatizându": "aplatiza",
    "aplatizarea": "aplatizare",
    "aplatizări": "aplatizare",
    "aplatizării": "aplatizare",
    "aplatizările": "aplatizare",
    "aplatizata": "aplatizat",
    "aplatizată": "aplatizat",
    "aplatizate": "aplatizat",
    "aplatizatei": "aplatizat",
    "aplatizatele": "aplatizat",
    "aplatizatelor": "aplatizat",
    "aplatizați": "aplatizat",
    "aplatizații": "aplatizat",
    "aplatizaților": "aplatizat",
    "aplatizatul": "aplatizat",
    "aplatizatului": "aplatizat",
    "aplaud": "aplauda",
    "aplaudă": "aplauda",
    "aplaudai": "aplauda",
    "aplaudam": "aplauda",
    "aplaudăm": "aplauda",
    "aplaudând": "aplauda",
    "aplaudându": "aplauda",
    "aplaudară": "aplauda",
    "aplaudarăm": "aplauda",
    "aplaudarăți": "aplauda",
    "aplaudase": "aplauda",
    "aplaudasem": "aplauda",
    "aplaudaseră": "aplauda",
    "aplaudaserăm": "aplauda",
    "aplaudaserăți": "aplauda",
    "aplaudaseși": "aplauda",
    "aplaudași": "aplauda",
    "aplaudat": "aplauda",
    "aplaudați": "aplauda",
    "aplaudatu": "aplauda",
    "aplaudau": "aplauda",
    "aplaude": "aplauda",
    "aplauzi": "aplauda",
    "neaplaudând": "aplauda",
    "neaplaudându": "aplauda",
    "nemaiaplaudând": "aplauda",
    "nemaiaplaudându": "aplauda",
    "aplaudarea": "aplaudare",
    "aplaudări": "aplaudare",
    "aplaudării": "aplaudare",
    "aplaudările": "aplaudare",
    "aplaudata": "aplaudat",
    "aplaudată": "aplaudat",
    "aplaudate": "aplaudat",
    "aplaudatei": "aplaudat",
    "aplaudatele": "aplaudat",
    "aplaudatelor": "aplaudat",
    "aplaudați": "aplaudat",
    "aplaudații": "aplaudat",
    "aplaudaților": "aplaudat",
    "aplaudatul": "aplaudat",
    "aplaudatului": "aplaudat",
    "aplauzele": "aplauze",
    "aplauzelor": "aplauze",
    "apleacă": "apleca",
    "aplec": "apleca",
    "aplecă": "apleca",
    "aplecai": "apleca",
    "aplecam": "apleca",
    "aplecăm": "apleca",
    "aplecând": "apleca",
    "aplecându": "apleca",
    "aplecară": "apleca",
    "aplecarăm": "apleca",
    "aplecarăți": "apleca",
    "aplecase": "apleca",
    "aplecasem": "apleca",
    "aplecaseră": "apleca",
    "aplecaserăm": "apleca",
    "aplecaserăți": "apleca",
    "aplecaseși": "apleca",
    "aplecași": "apleca",
    "aplecat": "apleca",
    "aplecați": "apleca",
    "aplecatu": "apleca",
    "aplecau": "apleca",
    "aplece": "apleca",
    "apleci": "apleca",
    "neaplecând": "apleca",
    "neaplecându": "apleca",
    "nemaiaplecând": "apleca",
    "nemaiaplecându": "apleca",
    "aplecarea": "aplecare",
    "aplecări": "aplecare",
    "aplecării": "aplecare",
    "aplecările": "aplecare",
    "aplecata": "aplecat",
    "aplecată": "aplecat",
    "aplecate": "aplecat",
    "aplecatei": "aplecat",
    "aplecatele": "aplecat",
    "aplecatelor": "aplecat",
    "aplecați": "aplecat",
    "aplecații": "aplecat",
    "aplecaților": "aplecat",
    "aplecatul": "aplecat",
    "aplecatului": "aplecat",
    "aplic": "aplica",
    "aplică": "aplica",
    "aplicai": "aplica",
    "aplicam": "aplica",
    "aplicăm": "aplica",
    "aplicând": "aplica",
    "aplicându": "aplica",
    "aplicară": "aplica",
    "aplicarăm": "aplica",
    "aplicarăți": "aplica",
    "aplicase": "aplica",
    "aplicasem": "aplica",
    "aplicaseră": "aplica",
    "aplicaserăm": "aplica",
    "aplicaserăți": "aplica",
    "aplicaseși": "aplica",
    "aplicași": "aplica",
    "aplicat": "aplica",
    "aplicați": "aplica",
    "aplicatu": "aplica",
    "aplicau": "aplica",
    "aplice": "aplica",
    "aplici": "aplica",
    "neaplicând": "aplica",
    "neaplicându": "aplica",
    "nemaiaplicând": "aplica",
    "nemaiaplicându": "aplica",
    "aplicabilă": "aplicabil",
    "aplicabile": "aplicabil",
    "aplicabili": "aplicabil",
    "aplicarea": "aplicare",
    "aplicări": "aplicare",
    "aplicării": "aplicare",
    "aplicările": "aplicare",
    "aplicata": "aplicat",
    "aplicată": "aplicat",
    "aplicate": "aplicat",
    "aplicatei": "aplicat",
    "aplicatele": "aplicat",
    "aplicatelor": "aplicat",
    "aplicați": "aplicat",
    "aplicații": "aplicat",
    "aplicaților": "aplicat",
    "aplicatul": "aplicat",
    "aplicatului": "aplicat",
    "aplicația": "aplicație",
    "aplicației": "aplicație",
    "aplicații": "aplicație",
    "aplicațiile": "aplicație",
    "aplicațiilor": "aplicație",
    "aplicativa": "aplicativ",
    "aplicativă": "aplicativ",
    "aplicative": "aplicativ",
    "aplicativei": "aplicativ",
    "aplicativele": "aplicativ",
    "aplicativelor": "aplicativ",
    "aplicativi": "aplicativ",
    "aplicativii": "aplicativ",
    "aplicativilor": "aplicativ",
    "aplicativul": "aplicativ",
    "aplicativului": "aplicativ",
    "aplombul": "aplomb",
    "aplombului": "aplomb",
    "aplomburi": "aplomb",
    "aplomburile": "aplomb",
    "aplomburilor": "aplomb",
    "apneea": "apnee",
    "apocaliptica": "apocaliptic",
    "apocaliptică": "apocaliptic",
    "apocaliptice": "apocaliptic",
    "apocalipticei": "apocaliptic",
    "apocalipticele": "apocaliptic",
    "apocalipticelor": "apocaliptic",
    "apocaliptici": "apocaliptic",
    "apocalipticii": "apocaliptic",
    "apocalipticilor": "apocaliptic",
    "apocalipticul": "apocaliptic",
    "apocalipticului": "apocaliptic",
    "apocopa": "apocopă",
    "apocope": "apocopă",
    "apocopei": "apocopă",
    "apocopele": "apocopă",
    "apocopelor": "apocopă",
    "apocrifa": "apocrif",
    "apocrifă": "apocrif",
    "apocrife": "apocrif",
    "apocrifei": "apocrif",
    "apocrifele": "apocrif",
    "apocrifelor": "apocrif",
    "apocrifi": "apocrif",
    "apocrifii": "apocrif",
    "apocrifilor": "apocrif",
    "apocriful": "apocrif",
    "apocrifului": "apocrif",
    "apodictica": "apodictic",
    "apodictică": "apodictic",
    "apodictice": "apodictic",
    "apodicticei": "apodictic",
    "apodicticele": "apodictic",
    "apodicticelor": "apodictic",
    "apodictici": "apodictic",
    "apodicticii": "apodictic",
    "apodicticilor": "apodictic",
    "apodicticul": "apodictic",
    "apodicticului": "apodictic",
    "apogee": "apogeu",
    "apogeele": "apogeu",
    "apogeelor": "apogeu",
    "apogeul": "apogeu",
    "apogeului": "apogeu",
    "apolitica": "apolitic",
    "apolitică": "apolitic",
    "apolitice": "apolitic",
    "apoliticei": "apolitic",
    "apoliticele": "apolitic",
    "apoliticelor": "apolitic",
    "apolitici": "apolitic",
    "apoliticii": "apolitic",
    "apoliticilor": "apolitic",
    "apoliticul": "apolitic",
    "apoliticului": "apolitic",
    "apologeți": "apologet",
    "apologeții": "apologet",
    "apologeților": "apologet",
    "apologetul": "apologet",
    "apologetului": "apologet",
    "apologetica": "apologetic",
    "apologetică": "apologetic",
    "apologetice": "apologetic",
    "apologeticei": "apologetic",
    "apologeticele": "apologetic",
    "apologeticelor": "apologetic",
    "apologetici": "apologetic",
    "apologeticii": "apologetic",
    "apologeticilor": "apologetic",
    "apologeticul": "apologetic",
    "apologeticului": "apologetic",
    "apologia": "apologie",
    "apologiei": "apologie",
    "apologii": "apologie",
    "apologiile": "apologie",
    "apologiilor": "apologie",
    "apometre": "apometru",
    "apometrele": "apometru",
    "apometrelor": "apometru",
    "apometrul": "apometru",
    "apometrului": "apometru",
    "aponevrotica": "aponevrotic",
    "aponevrotică": "aponevrotic",
    "aponevrotice": "aponevrotic",
    "aponevroticei": "aponevrotic",
    "aponevroticele": "aponevrotic",
    "aponevroticelor": "aponevrotic",
    "aponevrotici": "aponevrotic",
    "aponevroticii": "aponevrotic",
    "aponevroticilor": "aponevrotic",
    "aponevroticul": "aponevrotic",
    "aponevroticului": "aponevrotic",
    "apoplectica": "apoplectic",
    "apoplectică": "apoplectic",
    "apoplectice": "apoplectic",
    "apoplecticei": "apoplectic",
    "apoplecticele": "apoplectic",
    "apoplecticelor": "apoplectic",
    "apoplectici": "apoplectic",
    "apoplecticii": "apoplectic",
    "apoplecticilor": "apoplectic",
    "apoplecticul": "apoplectic",
    "apoplecticului": "apoplectic",
    "apoplexia": "apoplexie",
    "apoplexiei": "apoplexie",
    "apoplexii": "apoplexie",
    "apoplexiile": "apoplexie",
    "apoplexiilor": "apoplexie",
    "aporetică": "aporetic",
    "aporetice": "aporetic",
    "aporetici": "aporetic",
    "aportul": "aport",
    "aportului": "aport",
    "aporturi": "aport",
    "aporturile": "aport",
    "aporturilor": "aport",
    "apoasa": "apos",
    "apoasă": "apos",
    "apoase": "apos",
    "apoasei": "apos",
    "apoasele": "apos",
    "apoaselor": "apos",
    "apoaso": "apos",
    "apoși": "apos",
    "apoșii": "apos",
    "apoșilor": "apos",
    "aposul": "apos",
    "aposule": "apos",
    "aposului": "apos",
    "apostata": "apostat",
    "apostată": "apostat",
    "apostate": "apostat",
    "apostatei": "apostat",
    "apostatele": "apostat",
    "apostatelor": "apostat",
    "apostați": "apostat",
    "apostații": "apostat",
    "apostaților": "apostat",
    "apostatul": "apostat",
    "apostatului": "apostat",
    "apostazia": "apostazie",
    "apostaziei": "apostazie",
    "apostazii": "apostazie",
    "apostaziile": "apostazie",
    "apostaziilor": "apostazie",
    "apostila": "apostilă",
    "apostile": "apostilă",
    "apostilei": "apostilă",
    "apostilele": "apostilă",
    "apostilelor": "apostilă",
    "apostoli": "apostol",
    "apostolii": "apostol",
    "apostolilor": "apostol",
    "apostolul": "apostol",
    "apostolului": "apostol",
    "apostolate": "apostolat",
    "apostolatele": "apostolat",
    "apostolatelor": "apostolat",
    "apostolatul": "apostolat",
    "apostolatului": "apostolat",
    "apostolica": "apostolic",
    "apostolică": "apostolic",
    "apostolice": "apostolic",
    "apostolicei": "apostolic",
    "apostolicele": "apostolic",
    "apostolicelor": "apostolic",
    "apostolici": "apostolic",
    "apostolicii": "apostolic",
    "apostolicilor": "apostolic",
    "apostolicul": "apostolic",
    "apostolicului": "apostolic",
    "apostroful": "apostrof",
    "apostrofului": "apostrof",
    "apostrofuri": "apostrof",
    "apostrofurile": "apostrof",
    "apostrofurilor": "apostrof",
    "apostrofă": "apostrofa",
    "apostrofai": "apostrofa",
    "apostrofam": "apostrofa",
    "apostrofăm": "apostrofa",
    "apostrofând": "apostrofa",
    "apostrofându": "apostrofa",
    "apostrofară": "apostrofa",
    "apostrofarăm": "apostrofa",
    "apostrofarăți": "apostrofa",
    "apostrofase": "apostrofa",
    "apostrofasem": "apostrofa",
    "apostrofaseră": "apostrofa",
    "apostrofaserăm": "apostrofa",
    "apostrofaserăți": "apostrofa",
    "apostrofaseși": "apostrofa",
    "apostrofași": "apostrofa",
    "apostrofat": "apostrofa",
    "apostrofați": "apostrofa",
    "apostrofatu": "apostrofa",
    "apostrofau": "apostrofa",
    "apostrofează": "apostrofa",
    "apostrofez": "apostrofa",
    "apostrofeze": "apostrofa",
    "apostrofezi": "apostrofa",
    "neapostrofând": "apostrofa",
    "neapostrofându": "apostrofa",
    "nemaiapostrofând": "apostrofa",
    "nemaiapostrofându": "apostrofa",
    "apostrofa": "apostrofă",
    "apostrofe": "apostrofă",
    "apostrofei": "apostrofă",
    "apostrofele": "apostrofă",
    "apostrofelor": "apostrofă",
    "apostrofarea": "apostrofare",
    "apostrofări": "apostrofare",
    "apostrofării": "apostrofare",
    "apostrofările": "apostrofare",
    "apostrofata": "apostrofat",
    "apostrofată": "apostrofat",
    "apostrofate": "apostrofat",
    "apostrofatei": "apostrofat",
    "apostrofatele": "apostrofat",
    "apostrofatelor": "apostrofat",
    "apostrofați": "apostrofat",
    "apostrofații": "apostrofat",
    "apostrofaților": "apostrofat",
    "apostrofatul": "apostrofat",
    "apostrofatului": "apostrofat",
    "apoteotica": "apoteotic",
    "apoteotică": "apoteotic",
    "apoteotice": "apoteotic",
    "apoteoticei": "apoteotic",
    "apoteoticele": "apoteotic",
    "apoteoticelor": "apoteotic",
    "apoteotici": "apoteotic",
    "apoteoticii": "apoteotic",
    "apoteoticilor": "apoteotic",
    "apoteoticul": "apoteotic",
    "apoteoticului": "apoteotic",
    "apoteoza": "apoteoză",
    "apoteoze": "apoteoză",
    "apoteozei": "apoteoză",
    "apoteozele": "apoteoză",
    "apoteozelor": "apoteoză",
    "apoziția": "apoziție",
    "apoziției": "apoziție",
    "apoziții": "apoziție",
    "apozițiile": "apoziție",
    "apozițiilor": "apoziție",
    "apreciai": "aprecia",
    "apreciam": "aprecia",
    "apreciară": "aprecia",
    "apreciarăm": "aprecia",
    "apreciarăți": "aprecia",
    "apreciase": "aprecia",
    "apreciasem": "aprecia",
    "apreciaseră": "aprecia",
    "apreciaserăm": "aprecia",
    "apreciaserăți": "aprecia",
    "apreciaseși": "aprecia",
    "apreciași": "aprecia",
    "apreciat": "aprecia",
    "apreciați": "aprecia",
    "apreciatu": "aprecia",
    "apreciau": "aprecia",
    "apreciază": "aprecia",
    "aprecie": "aprecia",
    "apreciem": "aprecia",
    "apreciez": "aprecia",
    "aprecieze": "aprecia",
    "apreciezi": "aprecia",
    "apreciind": "aprecia",
    "apreciindu": "aprecia",
    "neapreciind": "aprecia",
    "neapreciindu": "aprecia",
    "nemaiapreciind": "aprecia",
    "nemaiapreciindu": "aprecia",
    "apreciabilă": "apreciabil",
    "apreciabile": "apreciabil",
    "apreciabili": "apreciabil",
    "apreciata": "apreciat",
    "apreciată": "apreciat",
    "apreciate": "apreciat",
    "apreciatei": "apreciat",
    "apreciatele": "apreciat",
    "apreciatelor": "apreciat",
    "apreciați": "apreciat",
    "apreciații": "apreciat",
    "apreciaților": "apreciat",
    "apreciatul": "apreciat",
    "apreciatului": "apreciat",
    "apreciativa": "apreciativ",
    "apreciativă": "apreciativ",
    "apreciative": "apreciativ",
    "apreciativei": "apreciativ",
    "apreciativele": "apreciativ",
    "apreciativelor": "apreciativ",
    "apreciativi": "apreciativ",
    "apreciativii": "apreciativ",
    "apreciativilor": "apreciativ",
    "apreciativul": "apreciativ",
    "apreciativului": "apreciativ",
    "apreciatoarea": "apreciatoare",
    "apreciatoarei": "apreciatoare",
    "apreciatoarele": "apreciatoare",
    "apreciatoarelor": "apreciatoare",
    "apreciatoare": "apreciator",
    "apreciatoarea": "apreciator",
    "apreciatoarei": "apreciator",
    "apreciatoarele": "apreciator",
    "apreciatoarelor": "apreciator",
    "apreciatori": "apreciator",
    "apreciatorii": "apreciator",
    "apreciatorilor": "apreciator",
    "apreciatorul": "apreciator",
    "apreciatorului": "apreciator",
    "aprecierea": "apreciere",
    "aprecieri": "apreciere",
    "aprecierii": "apreciere",
    "aprecierile": "apreciere",
    "aprehensiunea": "aprehensiune",
    "aprehensiuni": "aprehensiune",
    "aprehensiunii": "aprehensiune",
    "aprehensiunile": "aprehensiune",
    "aprehensiunilor": "aprehensiune",
    "apretai": "apreta",
    "apretam": "apreta",
    "apretăm": "apreta",
    "apretând": "apreta",
    "apretându": "apreta",
    "apretară": "apreta",
    "apretarăm": "apreta",
    "apretarăți": "apreta",
    "apretase": "apreta",
    "apretasem": "apreta",
    "apretaseră": "apreta",
    "apretaserăm": "apreta",
    "apretaserăți": "apreta",
    "apretaseși": "apreta",
    "apretași": "apreta",
    "apretat": "apreta",
    "apretați": "apreta",
    "apretatu": "apreta",
    "apretarea": "apretare",
    "apretări": "apretare",
    "apretării": "apretare",
    "apretările": "apretare",
    "apretata": "apretat",
    "apretată": "apretat",
    "apretate": "apretat",
    "apretatei": "apretat",
    "apretatele": "apretat",
    "apretatelor": "apretat",
    "apretați": "apretat",
    "apretații": "apretat",
    "apretaților": "apretat",
    "apretatul": "apretat",
    "apretatului": "apretat",
    "apriata": "apriat",
    "apriată": "apriat",
    "apriate": "apriat",
    "apriatei": "apriat",
    "apriatele": "apriat",
    "apriatelor": "apriat",
    "apriați": "apriat",
    "apriații": "apriat",
    "apriaților": "apriat",
    "apriatul": "apriat",
    "apriatului": "apriat",
    "apriga": "aprig",
    "aprigă": "aprig",
    "aprige": "aprig",
    "aprigei": "aprig",
    "aprigele": "aprig",
    "aprigelor": "aprig",
    "aprigi": "aprig",
    "aprigii": "aprig",
    "aprigilor": "aprig",
    "aprigul": "aprig",
    "aprigului": "aprig",
    "april'": "aprilie",
    "aprind": "aprinde",
    "aprindă": "aprinde",
    "aprindea": "aprinde",
    "aprindeai": "aprinde",
    "aprindeam": "aprinde",
    "aprindeați": "aprinde",
    "aprindeau": "aprinde",
    "aprindem": "aprinde",
    "aprindeți": "aprinde",
    "aprins": "aprinde",
    "aprinse": "aprinde",
    "aprinsei": "aprinde",
    "aprinseră": "aprinde",
    "aprinserăm": "aprinde",
    "aprinserăți": "aprinde",
    "aprinsese": "aprinde",
    "aprinsesem": "aprinde",
    "aprinseseră": "aprinde",
    "aprinseserăm": "aprinde",
    "aprinseserăți": "aprinde",
    "aprinseseși": "aprinde",
    "aprinseși": "aprinde",
    "aprinsu": "aprinde",
    "aprinzând": "aprinde",
    "aprinzându": "aprinde",
    "aprinzi": "aprinde",
    "neaprinzând": "aprinde",
    "neaprinzându": "aprinde",
    "nemaiaprinzând": "aprinde",
    "nemaiaprinzându": "aprinde",
    "aprinderea": "aprindere",
    "aprinderi": "aprindere",
    "aprinderii": "aprindere",
    "aprinderile": "aprindere",
    "aprinsa": "aprins",
    "aprinsă": "aprins",
    "aprinse": "aprins",
    "aprinsei": "aprins",
    "aprinsele": "aprins",
    "aprinselor": "aprins",
    "aprinși": "aprins",
    "aprinșii": "aprins",
    "aprinșilor": "aprins",
    "aprinsul": "aprins",
    "aprinsului": "aprins",
    "aprinzătoare": "aprinzător",
    "aprinzătoarele": "aprinzător",
    "aprinzătoarelor": "aprinzător",
    "aprinzători": "aprinzător",
    "aprinzătorii": "aprinzător",
    "aprinzătorilor": "aprinzător",
    "aprinzătorul": "aprinzător",
    "aprinzătorului": "aprinzător",
    "apriorica": "aprioric",
    "apriorică": "aprioric",
    "apriorice": "aprioric",
    "aprioricei": "aprioric",
    "aprioricele": "aprioric",
    "aprioricelor": "aprioric",
    "apriorici": "aprioric",
    "aprioricii": "aprioric",
    "aprioricilor": "aprioric",
    "aprioricul": "aprioric",
    "aprioricului": "aprioric",
    "aproapele": "aproape",
    "aproapelui": "aproape",
    "aproapelui": "aproapele",
    "aprob": "aproba",
    "aprobă": "aproba",
    "aprobai": "aproba",
    "aprobam": "aproba",
    "aprobăm": "aproba",
    "aprobând": "aproba",
    "aprobându": "aproba",
    "aprobară": "aproba",
    "aprobarăm": "aproba",
    "aprobarăți": "aproba",
    "aprobase": "aproba",
    "aprobasem": "aproba",
    "aprobaseră": "aproba",
    "aprobaserăm": "aproba",
    "aprobaserăți": "aproba",
    "aprobaseși": "aproba",
    "aprobași": "aproba",
    "aprobat": "aproba",
    "aprobați": "aproba",
    "aprobatu": "aproba",
    "aprobau": "aproba",
    "aprobe": "aproba",
    "aprobi": "aproba",
    "neaprobând": "aproba",
    "neaprobându": "aproba",
    "nemaiaprobând": "aproba",
    "nemaiaprobându": "aproba",
    "aprobarea": "aprobare",
    "aprobări": "aprobare",
    "aprobării": "aprobare",
    "aprobările": "aprobare",
    "aprobata": "aprobat",
    "aprobată": "aprobat",
    "aprobate": "aprobat",
    "aprobatei": "aprobat",
    "aprobatele": "aprobat",
    "aprobatelor": "aprobat",
    "aprobați": "aprobat",
    "aprobații": "aprobat",
    "aprobaților": "aprobat",
    "aprobatul": "aprobat",
    "aprobatului": "aprobat",
    "aprobativa": "aprobativ",
    "aprobativă": "aprobativ",
    "aprobative": "aprobativ",
    "aprobativei": "aprobativ",
    "aprobativele": "aprobativ",
    "aprobativelor": "aprobativ",
    "aprobativi": "aprobativ",
    "aprobativii": "aprobativ",
    "aprobativilor": "aprobativ",
    "aprobativul": "aprobativ",
    "aprobativului": "aprobativ",
    "aprobatoare": "aprobator",
    "aprobatoarea": "aprobator",
    "aprobatoarei": "aprobator",
    "aprobatoarele": "aprobator",
    "aprobatoarelor": "aprobator",
    "aprobatori": "aprobator",
    "aprobatorii": "aprobator",
    "aprobatorilor": "aprobator",
    "aprobatorul": "aprobator",
    "aprobatorului": "aprobator",
    "aprodul": "aprod",
    "aprodului": "aprod",
    "aprozi": "aprod",
    "aprozii": "aprod",
    "aprozilor": "aprod",
    "aprofundă": "aprofunda",
    "aprofundai": "aprofunda",
    "aprofundam": "aprofunda",
    "aprofundăm": "aprofunda",
    "aprofundând": "aprofunda",
    "aprofundându": "aprofunda",
    "aprofundară": "aprofunda",
    "aprofundarăm": "aprofunda",
    "aprofundarăți": "aprofunda",
    "aprofundase": "aprofunda",
    "aprofundasem": "aprofunda",
    "aprofundaseră": "aprofunda",
    "aprofundaserăm": "aprofunda",
    "aprofundaserăți": "aprofunda",
    "aprofundaseși": "aprofunda",
    "aprofundași": "aprofunda",
    "aprofundat": "aprofunda",
    "aprofundați": "aprofunda",
    "aprofundatu": "aprofunda",
    "aprofundau": "aprofunda",
    "aprofundează": "aprofunda",
    "aprofundez": "aprofunda",
    "aprofundeze": "aprofunda",
    "aprofundezi": "aprofunda",
    "neaprofundând": "aprofunda",
    "neaprofundându": "aprofunda",
    "nemaiaprofundând": "aprofunda",
    "nemaiaprofundându": "aprofunda",
    "aprofundarea": "aprofundare",
    "aprofundări": "aprofundare",
    "aprofundării": "aprofundare",
    "aprofundările": "aprofundare",
    "aprofundata": "aprofundat",
    "aprofundată": "aprofundat",
    "aprofundate": "aprofundat",
    "aprofundatei": "aprofundat",
    "aprofundatele": "aprofundat",
    "aprofundatelor": "aprofundat",
    "aprofundați": "aprofundat",
    "aprofundații": "aprofundat",
    "aprofundaților": "aprofundat",
    "aprofundatul": "aprofundat",
    "aprofundatului": "aprofundat",
    "apropiai": "apropia",
    "apropiam": "apropia",
    "apropiară": "apropia",
    "apropiarăm": "apropia",
    "apropiarăți": "apropia",
    "apropiase": "apropia",
    "apropiasem": "apropia",
    "apropiaseră": "apropia",
    "apropiaserăm": "apropia",
    "apropiaserăți": "apropia",
    "apropiaseși": "apropia",
    "apropiași": "apropia",
    "apropiat": "apropia",
    "apropiați": "apropia",
    "apropiatu": "apropia",
    "apropiau": "apropia",
    "apropie": "apropia",
    "apropiem": "apropia",
    "apropii": "apropia",
    "apropiind": "apropia",
    "apropiindu": "apropia",
    "neapropiind": "apropia",
    "neapropiindu": "apropia",
    "nemaiapropiind": "apropia",
    "nemaiapropiindu": "apropia",
    "apropiata": "apropiat",
    "apropiată": "apropiat",
    "apropiate": "apropiat",
    "apropiatei": "apropiat",
    "apropiatele": "apropiat",
    "apropiatelor": "apropiat",
    "apropiați": "apropiat",
    "apropiații": "apropiat",
    "apropiaților": "apropiat",
    "apropiatul": "apropiat",
    "apropiatului": "apropiat",
    "apropiata": "apropiată",
    "apropiate": "apropiată",
    "apropiatei": "apropiată",
    "apropiatele": "apropiată",
    "apropiatelor": "apropiată",
    "apropierea": "apropiere",
    "apropieri": "apropiere",
    "apropierii": "apropiere",
    "apropierile": "apropiere",
    "apropoul": "apropo",
    "apropoului": "apropo",
    "apropouri": "apropo",
    "apropourile": "apropo",
    "apropourilor": "apropo",
    "aprovizionă": "aproviziona",
    "aprovizionai": "aproviziona",
    "aprovizionam": "aproviziona",
    "aprovizionăm": "aproviziona",
    "aprovizionând": "aproviziona",
    "aprovizionându": "aproviziona",
    "aprovizionară": "aproviziona",
    "aprovizionarăm": "aproviziona",
    "aprovizionarăți": "aproviziona",
    "aprovizionase": "aproviziona",
    "aprovizionasem": "aproviziona",
    "aprovizionaseră": "aproviziona",
    "aprovizionaserăm": "aproviziona",
    "aprovizionaserăți": "aproviziona",
    "aprovizionaseși": "aproviziona",
    "aprovizionași": "aproviziona",
    "aprovizionat": "aproviziona",
    "aprovizionați": "aproviziona",
    "aprovizionatu": "aproviziona",
    "aprovizionau": "aproviziona",
    "aprovizionează": "aproviziona",
    "aprovizionez": "aproviziona",
    "aprovizioneze": "aproviziona",
    "aprovizionezi": "aproviziona",
    "neaprovizionând": "aproviziona",
    "neaprovizionându": "aproviziona",
    "nemaiaprovizionând": "aproviziona",
    "nemaiaprovizionându": "aproviziona",
    "aprovizionarea": "aprovizionare",
    "aprovizionări": "aprovizionare",
    "aprovizionării": "aprovizionare",
    "aprovizionările": "aprovizionare",
    "aprovizionărilor": "aprovizionare",
    "aprovizionata": "aprovizionat",
    "aprovizionată": "aprovizionat",
    "aprovizionate": "aprovizionat",
    "aprovizionatei": "aprovizionat",
    "aprovizionatele": "aprovizionat",
    "aprovizionatelor": "aprovizionat",
    "aprovizionați": "aprovizionat",
    "aprovizionații": "aprovizionat",
    "aprovizionaților": "aprovizionat",
    "aprovizionatul": "aprovizionat",
    "aprovizionatului": "aprovizionat",
    "aproximarea": "aproximare",
    "aproximări": "aproximare",
    "aproximării": "aproximare",
    "aproximările": "aproximare",
    "aproximărilor": "aproximare",
    "aproximația": "aproximație",
    "aproximației": "aproximație",
    "aproximații": "aproximație",
    "aproximațiile": "aproximație",
    "aproximațiilor": "aproximație",
    "aprox.": "aproximativ",
    "aproximativa": "aproximativ",
    "aproximativă": "aproximativ",
    "aproximative": "aproximativ",
    "aproximativei": "aproximativ",
    "aproximativele": "aproximativ",
    "aproximativelor": "aproximativ",
    "aproximativi": "aproximativ",
    "aproximativii": "aproximativ",
    "aproximativilor": "aproximativ",
    "aproximativul": "aproximativ",
    "aproximativului": "aproximativ",
    "apta": "apt",
    "aptă": "apt",
    "apte": "apt",
    "aptei": "apt",
    "aptele": "apt",
    "aptelor": "apt",
    "apți": "apt",
    "apții": "apt",
    "apților": "apt",
    "aptul": "apt",
    "aptului": "apt",
    "aptera": "apter",
    "apteră": "apter",
    "aptere": "apter",
    "apterei": "apter",
    "apterele": "apter",
    "apterelor": "apter",
    "apteri": "apter",
    "apterii": "apter",
    "apterilor": "apter",
    "apterul": "apter",
    "apterului": "apter",
    "aptitudinea": "aptitudine",
    "aptitudini": "aptitudine",
    "aptitudinii": "aptitudine",
    "aptitudinile": "aptitudine",
    "aptitudinilor": "aptitudine",
    "apuc": "apuca",
    "apucă": "apuca",
    "apucai": "apuca",
    "apucam": "apuca",
    "apucăm": "apuca",
    "apucând": "apuca",
    "apucându": "apuca",
    "apucară": "apuca",
    "apucarăm": "apuca",
    "apucarăți": "apuca",
    "apucase": "apuca",
    "apucasem": "apuca",
    "apucaseră": "apuca",
    "apucaserăm": "apuca",
    "apucaserăți": "apuca",
    "apucaseși": "apuca",
    "apucași": "apuca",
    "apucat": "apuca",
    "apucați": "apuca",
    "apucatu": "apuca",
    "apucau": "apuca",
    "apuce": "apuca",
    "apuci": "apuca",
    "neapucând": "apuca",
    "neapucându": "apuca",
    "nemaiapucând": "apuca",
    "nemaiapucându": "apuca",
    "apucarea": "apucare",
    "apucări": "apucare",
    "apucării": "apucare",
    "apucările": "apucare",
    "apucata": "apucat",
    "apucată": "apucat",
    "apucate": "apucat",
    "apucatei": "apucat",
    "apucatele": "apucat",
    "apucatelor": "apucat",
    "apucați": "apucat",
    "apucații": "apucat",
    "apucaților": "apucat",
    "apucatul": "apucat",
    "apucatului": "apucat",
    "apucata": "apucată",
    "apucate": "apucată",
    "apucatei": "apucată",
    "apucatele": "apucată",
    "apucatelor": "apucată",
    "apucătoarea": "apucătoare",
    "apucătoarei": "apucătoare",
    "apucătoarele": "apucătoare",
    "apucătoarelor": "apucătoare",
    "apucătoare": "apucător",
    "apucătoarea": "apucător",
    "apucătoarei": "apucător",
    "apucătoarele": "apucător",
    "apucătoarelor": "apucător",
    "apucători": "apucător",
    "apucătorii": "apucător",
    "apucătorilor": "apucător",
    "apucătorul": "apucător",
    "apucătorului": "apucător",
    "apucătura": "apucătură",
    "apucături": "apucătură",
    "apucăturii": "apucătură",
    "apucăturile": "apucătură",
    "apucăturilor": "apucătură",
    "apui": "apune",
    "apun": "apune",
    "apună": "apune",
    "apunând": "apune",
    "apunându": "apune",
    "apunea": "apune",
    "apuneai": "apune",
    "apuneam": "apune",
    "apuneați": "apune",
    "apuneau": "apune",
    "apunem": "apune",
    "apuneți": "apune",
    "apus": "apune",
    "apuse": "apune",
    "apusei": "apune",
    "apuseră": "apune",
    "apuserăm": "apune",
    "apuserăți": "apune",
    "apusese": "apune",
    "apusesem": "apune",
    "apuseseră": "apune",
    "apuseserăm": "apune",
    "apuseserăți": "apune",
    "apuseseși": "apune",
    "apuseși": "apune",
    "apusu": "apune",
    "neapunând": "apune",
    "neapunându": "apune",
    "nemaiapunând": "apune",
    "nemaiapunându": "apune",
    "apunerea": "apunere",
    "apuneri": "apunere",
    "apunerii": "apunere",
    "apunerile": "apunere",
    "apusa": "apus",
    "apusă": "apus",
    "apuse": "apus",
    "apusei": "apus",
    "apusele": "apus",
    "apuselor": "apus",
    "apuși": "apus",
    "apușii": "apus",
    "apușilor": "apus",
    "apusul": "apus",
    "apusului": "apus",
    "apuseana": "apusean",
    "apuseană": "apusean",
    "apuseanul": "apusean",
    "apuseanului": "apusean",
    "apusene": "apusean",
    "apusenei": "apusean",
    "apusenele": "apusean",
    "apusenelor": "apusean",
    "apuseni": "apusean",
    "apusenii": "apusean",
    "apusenilor": "apusean",
    "aq.": "aqua",
    "ari": "ar",
    "arii": "ar",
    "arilor": "ar",
    "arul": "ar",
    "arului": "ar",
    "ar": "ara",
    "ară": "ara",
    "arai": "ara",
    "aram": "ara",
    "arăm": "ara",
    "arând": "ara",
    "arându": "ara",
    "arară": "ara",
    "ararăm": "ara",
    "ararăți": "ara",
    "arase": "ara",
    "arasem": "ara",
    "araseră": "ara",
    "araserăm": "ara",
    "araserăți": "ara",
    "araseși": "ara",
    "arași": "ara",
    "arat": "ara",
    "arați": "ara",
    "aratu": "ara",
    "arau": "ara",
    "are": "ara",
    "ari": "ara",
    "nearând": "ara",
    "nearându": "ara",
    "nemaiarând": "ara",
    "nemaiarându": "ara",
    "araba": "arab",
    "arabă": "arab",
    "arabe": "arab",
    "arabei": "arab",
    "arabele": "arab",
    "arabelor": "arab",
    "arabi": "arab",
    "arabii": "arab",
    "arabilor": "arab",
    "arabul": "arab",
    "arabului": "arab",
    "arabescul": "arabesc",
    "arabescului": "arabesc",
    "arabescuri": "arabesc",
    "arabescurile": "arabesc",
    "arabescurilor": "arabesc",
    "arabica": "arabic",
    "arabică": "arabic",
    "arabice": "arabic",
    "arabicei": "arabic",
    "arabicele": "arabic",
    "arabicelor": "arabic",
    "arabici": "arabic",
    "arabicii": "arabic",
    "arabicilor": "arabic",
    "arabicul": "arabic",
    "arabicului": "arabic",
    "arabila": "arabil",
    "arabilă": "arabil",
    "arabile": "arabil",
    "arabilei": "arabil",
    "arabilele": "arabil",
    "arabilelor": "arabil",
    "arabili": "arabil",
    "arabilii": "arabil",
    "arabililor": "arabil",
    "arabilul": "arabil",
    "arabilului": "arabil",
    "Aradul": "Arad",
    "Aradului": "Arad",
    "arădeana": "arădean",
    "arădeană": "arădean",
    "arădeanul": "arădean",
    "arădeanului": "arădean",
    "arădene": "arădean",
    "arădenei": "arădean",
    "arădenele": "arădean",
    "arădenelor": "arădean",
    "arădeni": "arădean",
    "arădenii": "arădean",
    "arădenilor": "arădean",
    "aragazul": "aragaz",
    "aragazului": "aragaz",
    "aragazuri": "aragaz",
    "aragazurile": "aragaz",
    "aragazurilor": "aragaz",
    "arahida": "arahidă",
    "arahide": "arahidă",
    "arahidei": "arahidă",
    "arahidele": "arahidă",
    "arahidelor": "arahidă",
    "arahnida": "arahnidă",
    "arahnide": "arahnidă",
    "arahnidei": "arahnidă",
    "arahnidele": "arahnidă",
    "arahnidelor": "arahnidă",
    "arama": "aramă",
    "arame": "aramă",
    "aramei": "aramă",
    "aramele": "aramă",
    "aramelor": "aramă",
    "arămia": "arămiu",
    "arămie": "arămiu",
    "arămiei": "arămiu",
    "arămii": "arămiu",
    "arămiii": "arămiu",
    "arămiile": "arămiu",
    "arămiilor": "arămiu",
    "arămiul": "arămiu",
    "arămiului": "arămiu",
    "aranjă": "aranja",
    "aranjai": "aranja",
    "aranjam": "aranja",
    "aranjăm": "aranja",
    "aranjând": "aranja",
    "aranjară": "aranja",
    "aranjarăm": "aranja",
    "aranjarăți": "aranja",
    "aranjase": "aranja",
    "aranjasem": "aranja",
    "aranjaseră": "aranja",
    "aranjaserăm": "aranja",
    "aranjaserăți": "aranja",
    "aranjaseși": "aranja",
    "aranjași": "aranja",
    "aranjat": "aranja",
    "aranjați": "aranja",
    "aranjau": "aranja",
    "aranjează": "aranja",
    "aranjez": "aranja",
    "aranjeze": "aranja",
    "aranjezi": "aranja",
    "nearanjând": "aranja",
    "nemaiaranjând": "aranja",
    "aranjamente": "aranjament",
    "aranjamentele": "aranjament",
    "aranjamentelor": "aranjament",
    "aranjamentul": "aranjament",
    "aranjamentului": "aranjament",
    "aranjarea": "aranjare",
    "aranjări": "aranjare",
    "aranjării": "aranjare",
    "aranjările": "aranjare",
    "aranjata": "aranjat",
    "aranjată": "aranjat",
    "aranjate": "aranjat",
    "aranjatei": "aranjat",
    "aranjatele": "aranjat",
    "aranjatelor": "aranjat",
    "aranjați": "aranjat",
    "aranjații": "aranjat",
    "aranjaților": "aranjat",
    "aranjatul": "aranjat",
    "aranjatului": "aranjat",
    "arata": "arat",
    "arată": "arat",
    "arate": "arat",
    "aratei": "arat",
    "aratele": "arat",
    "aratelor": "arat",
    "arați": "arat",
    "arații": "arat",
    "araților": "arat",
    "aratul": "arat",
    "aratului": "arat",
    "arăt": "arăta",
    "arată": "arăta",
    "arăta'": "arăta",
    "arătă": "arăta",
    "arătai": "arăta",
    "arătam": "arăta",
    "arătăm": "arăta",
    "arătând": "arăta",
    "arătându": "arăta",
    "arătară": "arăta",
    "arătarăm": "arăta",
    "arătarăți": "arăta",
    "arătase": "arăta",
    "arătasem": "arăta",
    "arătaseră": "arăta",
    "arătaserăm": "arăta",
    "arătaserăți": "arăta",
    "arătaseși": "arăta",
    "arătași": "arăta",
    "arătat": "arăta",
    "arătați": "arăta",
    "arătatu": "arăta",
    "arătau": "arăta",
    "arate": "arăta",
    "arăți": "arăta",
    "nearătând": "arăta",
    "nearătându": "arăta",
    "nemaiarătând": "arăta",
    "nemaiarătându": "arăta",
    "arătarea": "arătare",
    "arătări": "arătare",
    "arătării": "arătare",
    "arătările": "arătare",
    "arătărilor": "arătare",
    "arăta'": "arătat",
    "arătata": "arătat",
    "arătată": "arătat",
    "arătate": "arătat",
    "arătatei": "arătat",
    "arătatele": "arătat",
    "arătatelor": "arătat",
    "arătați": "arătat",
    "arătații": "arătat",
    "arătaților": "arătat",
    "arătatul": "arătat",
    "arătatului": "arătat",
    "arătătoare": "arătător",
    "arătătoarele": "arătător",
    "arătătoarelor": "arătător",
    "arătătorul": "arătător",
    "arătătorului": "arătător",
    "arătoare": "arător",
    "arătoarea": "arător",
    "arătoarei": "arător",
    "arătoarele": "arător",
    "arătoarelor": "arător",
    "arători": "arător",
    "arătorii": "arător",
    "arătorilor": "arător",
    "arătorul": "arător",
    "arătorului": "arător",
    "arătoasa": "arătos",
    "arătoasă": "arătos",
    "arătoase": "arătos",
    "arătoasei": "arătos",
    "arătoasele": "arătos",
    "arătoaselor": "arătos",
    "arătoși": "arătos",
    "arătoșii": "arătos",
    "arătoșilor": "arătos",
    "arătosul": "arătos",
    "arătosului": "arătos",
    "arătura": "arătură",
    "arături": "arătură",
    "arăturii": "arătură",
    "arăturile": "arătură",
    "arăturilor": "arătură",
    "arbaleta": "arbaletă",
    "arbalete": "arbaletă",
    "arbaletei": "arbaletă",
    "arbaletele": "arbaletă",
    "arbaletelor": "arbaletă",
    "arbitră": "arbitra",
    "arbitrai": "arbitra",
    "arbitram": "arbitra",
    "arbitrăm": "arbitra",
    "arbitrând": "arbitra",
    "arbitrându": "arbitra",
    "arbitrară": "arbitra",
    "arbitrarăm": "arbitra",
    "arbitrarăți": "arbitra",
    "arbitrase": "arbitra",
    "arbitrasem": "arbitra",
    "arbitraseră": "arbitra",
    "arbitraserăm": "arbitra",
    "arbitraserăți": "arbitra",
    "arbitraseși": "arbitra",
    "arbitrași": "arbitra",
    "arbitrat": "arbitra",
    "arbitrați": "arbitra",
    "arbitratu": "arbitra",
    "arbitrau": "arbitra",
    "arbitrează": "arbitra",
    "arbitrez": "arbitra",
    "arbitreze": "arbitra",
    "arbitrezi": "arbitra",
    "arbitraje": "arbitraj",
    "arbitrajele": "arbitraj",
    "arbitrajelor": "arbitraj",
    "arbitrajul": "arbitraj",
    "arbitrajului": "arbitraj",
    "arbitrala": "arbitral",
    "arbitrală": "arbitral",
    "arbitrale": "arbitral",
    "arbitralei": "arbitral",
    "arbitralele": "arbitral",
    "arbitralelor": "arbitral",
    "arbitrali": "arbitral",
    "arbitralii": "arbitral",
    "arbitralilor": "arbitral",
    "arbitralul": "arbitral",
    "arbitralului": "arbitral",
    "arbitrara": "arbitrar",
    "arbitrară": "arbitrar",
    "arbitrare": "arbitrar",
    "arbitrarei": "arbitrar",
    "arbitrarele": "arbitrar",
    "arbitrarelor": "arbitrar",
    "arbitrari": "arbitrar",
    "arbitrarii": "arbitrar",
    "arbitrarilor": "arbitrar",
    "arbitrarul": "arbitrar",
    "arbitrarului": "arbitrar",
    "arbitrată": "arbitrat",
    "arbitrate": "arbitrat",
    "arbitrați": "arbitrat",
    "arbitri": "arbitru",
    "arbitrii": "arbitru",
    "arbitrilor": "arbitru",
    "arbitrul": "arbitru",
    "arbitrului": "arbitru",
    "arboră": "arbora",
    "arborai": "arbora",
    "arboram": "arbora",
    "arborăm": "arbora",
    "arborând": "arbora",
    "arborându": "arbora",
    "arborară": "arbora",
    "arborarăm": "arbora",
    "arborarăți": "arbora",
    "arborase": "arbora",
    "arborasem": "arbora",
    "arboraseră": "arbora",
    "arboraserăm": "arbora",
    "arboraserăți": "arbora",
    "arboraseși": "arbora",
    "arborași": "arbora",
    "arborat": "arbora",
    "arborați": "arbora",
    "arboratu": "arbora",
    "arborau": "arbora",
    "arborează": "arbora",
    "arborez": "arbora",
    "arboreze": "arbora",
    "arborezi": "arbora",
    "nearborând": "arbora",
    "nearborându": "arbora",
    "nemaiarborând": "arbora",
    "nemaiarborându": "arbora",
    "arborada": "arboradă",
    "arborade": "arboradă",
    "arboradei": "arboradă",
    "arboradele": "arboradă",
    "arboradelor": "arboradă",
    "arborarea": "arborare",
    "arborări": "arborare",
    "arborării": "arborare",
    "arborările": "arborare",
    "arborata": "arborat",
    "arborată": "arborat",
    "arborate": "arborat",
    "arboratei": "arborat",
    "arboratele": "arborat",
    "arboratelor": "arborat",
    "arborați": "arborat",
    "arborații": "arborat",
    "arboraților": "arborat",
    "arboratul": "arborat",
    "arboratului": "arborat",
    "arborele": "arbore",
    "arborelui": "arbore",
    "arbori": "arbore",
    "arborii": "arbore",
    "arborilor": "arbore",
    "arborescenta": "arborescent",
    "arborescentă": "arborescent",
    "arborescente": "arborescent",
    "arborescentei": "arborescent",
    "arborescentele": "arborescent",
    "arborescentelor": "arborescent",
    "arborescenți": "arborescent",
    "arborescenții": "arborescent",
    "arborescenților": "arborescent",
    "arborescentul": "arborescent",
    "arborescentului": "arborescent",
    "arbuști": "arbust",
    "arbuștii": "arbust",
    "arbuștilor": "arbust",
    "arbustul": "arbust",
    "arbustului": "arbust",
    "arce": "arc",
    "arcele": "arc",
    "arcelor": "arc",
    "arcul": "arc",
    "arcului": "arc",
    "arcuri": "arc",
    "arcurile": "arc",
    "arcurilor": "arc",
    "arca": "arcă",
    "arcada": "arcadă",
    "arcade": "arcadă",
    "arcadei": "arcadă",
    "arcadele": "arcadă",
    "arcadelor": "arcadă",
    "arcane": "arcan",
    "arcanele": "arcan",
    "arcanelor": "arcan",
    "arcanul": "arcan",
    "arcanului": "arcan",
    "arcași": "arcaș",
    "arcașii": "arcaș",
    "arcașilor": "arcaș",
    "arcașul": "arcaș",
    "arcașului": "arcaș",
    "arcata": "arcat",
    "arcată": "arcat",
    "arcate": "arcat",
    "arcatei": "arcat",
    "arcatele": "arcat",
    "arcatelor": "arcat",
    "arcați": "arcat",
    "arcații": "arcat",
    "arcaților": "arcat",
    "arcatul": "arcat",
    "arcatului": "arcat",
    "archebuza": "archebuză",
    "archebuze": "archebuză",
    "archebuzei": "archebuză",
    "archebuzele": "archebuză",
    "archebuzelor": "archebuză",
    "arctica": "arctic",
    "arctică": "arctic",
    "arctice": "arctic",
    "arcticei": "arctic",
    "arcticele": "arctic",
    "arcticelor": "arctic",
    "arctici": "arctic",
    "arcticii": "arctic",
    "arcticilor": "arctic",
    "arcticul": "arctic",
    "arcticului": "arctic",
    "arcuia": "arcui",
    "arcuiai": "arcui",
    "arcuiam": "arcui",
    "arcuiască": "arcui",
    "arcuiați": "arcui",
    "arcuiau": "arcui",
    "arcuiesc": "arcui",
    "arcuiește": "arcui",
    "arcuiești": "arcui",
    "arcuii": "arcui",
    "arcuim": "arcui",
    "arcuind": "arcui",
    "arcuindu": "arcui",
    "arcuiră": "arcui",
    "arcuirăm": "arcui",
    "arcuirăți": "arcui",
    "arcuise": "arcui",
    "arcuisem": "arcui",
    "arcuiseră": "arcui",
    "arcuiserăm": "arcui",
    "arcuiserăți": "arcui",
    "arcuiseși": "arcui",
    "arcuiși": "arcui",
    "arcuit": "arcui",
    "arcuiți": "arcui",
    "arcuitu": "arcui",
    "arcuirea": "arcuire",
    "arcuiri": "arcuire",
    "arcuirii": "arcuire",
    "arcuirile": "arcuire",
    "arcuita": "arcuit",
    "arcuită": "arcuit",
    "arcuite": "arcuit",
    "arcuitei": "arcuit",
    "arcuitele": "arcuit",
    "arcuitelor": "arcuit",
    "arcuiți": "arcuit",
    "arcuiții": "arcuit",
    "arcuiților": "arcuit",
    "arcuitul": "arcuit",
    "arcuitului": "arcuit",
    "ard": "arde",
    "ardă": "arde",
    "ardea": "arde",
    "ardeai": "arde",
    "ardeam": "arde",
    "ardeați": "arde",
    "ardeau": "arde",
    "ardem": "arde",
    "ardeți": "arde",
    "ars": "arde",
    "arse": "arde",
    "arsei": "arde",
    "arseră": "arde",
    "arserăm": "arde",
    "arserăți": "arde",
    "arsese": "arde",
    "arsesem": "arde",
    "arseseră": "arde",
    "arseserăm": "arde",
    "arseserăți": "arde",
    "arseseși": "arde",
    "arseși": "arde",
    "arzând": "arde",
    "arzându": "arde",
    "arzi": "arde",
    "nearzând": "arde",
    "nearzându": "arde",
    "nemaiarzând": "arde",
    "nemaiarzându": "arde",
    "Ardealul": "Ardeal",
    "Ardealului": "Ardeal",
    "ardeleana": "ardelean",
    "ardeleană": "ardelean",
    "ardeleanul": "ardelean",
    "ardeleanului": "ardelean",
    "ardelene": "ardelean",
    "ardelenei": "ardelean",
    "ardelenele": "ardelean",
    "ardelenelor": "ardelean",
    "ardeleni": "ardelean",
    "ardelenii": "ardelean",
    "ardelenilor": "ardelean",
    "ardeleneasca": "ardelenesc",
    "ardelenească": "ardelenesc",
    "ardelenescul": "ardelenesc",
    "ardelenescului": "ardelenesc",
    "ardelenești": "ardelenesc",
    "ardeleneștii": "ardelenesc",
    "ardeleneștile": "ardelenesc",
    "ardeleneștilor": "ardelenesc",
    "ardenta": "ardent",
    "ardentă": "ardent",
    "ardente": "ardent",
    "ardentei": "ardent",
    "ardentele": "ardent",
    "ardentelor": "ardent",
    "ardenți": "ardent",
    "ardenții": "ardent",
    "ardenților": "ardent",
    "ardentul": "ardent",
    "ardentului": "ardent",
    "arderea": "ardere",
    "arderi": "ardere",
    "arderii": "ardere",
    "arderile": "ardere",
    "ardezia": "ardezie",
    "ardeziei": "ardezie",
    "ardezii": "ardezie",
    "ardeziile": "ardezie",
    "ardeziilor": "ardezie",
    "ardoarea": "ardoare",
    "ardori": "ardoare",
    "ardorii": "ardoare",
    "ardorile": "ardoare",
    "ardorilor": "ardoare",
    "arealul": "areal",
    "arealului": "areal",
    "arealuri": "areal",
    "arealurile": "areal",
    "arealurilor": "areal",
    "arena": "arenă",
    "arene": "arenă",
    "arenei": "arenă",
    "arenele": "arenă",
    "arenelor": "arenă",
    "arendă": "arenda",
    "arendai": "arenda",
    "arendam": "arenda",
    "arendăm": "arenda",
    "arendând": "arenda",
    "arendară": "arenda",
    "arendarăm": "arenda",
    "arendarăți": "arenda",
    "arendase": "arenda",
    "arendasem": "arenda",
    "arendaseră": "arenda",
    "arendaserăm": "arenda",
    "arendaserăți": "arenda",
    "arendaseși": "arenda",
    "arendași": "arenda",
    "arendat": "arenda",
    "arendați": "arenda",
    "arendau": "arenda",
    "arendează": "arenda",
    "arendez": "arenda",
    "arendeze": "arenda",
    "arendezi": "arenda",
    "nearendând": "arenda",
    "nemaiarendând": "arenda",
    "arenda": "arendă",
    "arenzi": "arendă",
    "arenzii": "arendă",
    "arenzile": "arendă",
    "arenzilor": "arendă",
    "arendarea": "arendare",
    "arendări": "arendare",
    "arendării": "arendare",
    "arendările": "arendare",
    "arendași": "arendaș",
    "arendașii": "arendaș",
    "arendașilor": "arendaș",
    "arendașul": "arendaș",
    "arendașului": "arendaș",
    "arendata": "arendat",
    "arendată": "arendat",
    "arendate": "arendat",
    "arendatei": "arendat",
    "arendatele": "arendat",
    "arendatelor": "arendat",
    "arendați": "arendat",
    "arendații": "arendat",
    "arendaților": "arendat",
    "arendatul": "arendat",
    "arendatului": "arendat",
    "areometre": "areometru",
    "areometrele": "areometru",
    "areometrelor": "areometru",
    "areometrul": "areometru",
    "areometrului": "areometru",
    "areopagul": "areopag",
    "areopagului": "areopag",
    "areopaguri": "areopag",
    "areopagurile": "areopag",
    "areopagurilor": "areopag",
    "arestul": "arest",
    "arestului": "arest",
    "aresturi": "arest",
    "aresturile": "arest",
    "aresturilor": "arest",
    "arestă": "aresta",
    "arestai": "aresta",
    "arestam": "aresta",
    "arestăm": "aresta",
    "arestând": "aresta",
    "arestându": "aresta",
    "arestară": "aresta",
    "arestarăm": "aresta",
    "arestarăți": "aresta",
    "arestase": "aresta",
    "arestasem": "aresta",
    "arestaseră": "aresta",
    "arestaserăm": "aresta",
    "arestaserăți": "aresta",
    "arestaseși": "aresta",
    "arestași": "aresta",
    "arestat": "aresta",
    "arestați": "aresta",
    "arestatu": "aresta",
    "arestau": "aresta",
    "arestează": "aresta",
    "arestez": "aresta",
    "aresteze": "aresta",
    "arestezi": "aresta",
    "nearestând": "aresta",
    "nearestându": "aresta",
    "nemaiarestând": "aresta",
    "nemaiarestându": "aresta",
    "arestarea": "arestare",
    "arestări": "arestare",
    "arestării": "arestare",
    "arestările": "arestare",
    "arestata": "arestat",
    "arestată": "arestat",
    "arestate": "arestat",
    "arestatei": "arestat",
    "arestatele": "arestat",
    "arestatelor": "arestat",
    "arestați": "arestat",
    "arestații": "arestat",
    "arestaților": "arestat",
    "arestatul": "arestat",
    "arestatului": "arestat",
    "arestata": "arestată",
    "arestate": "arestată",
    "arestatei": "arestată",
    "arestatele": "arestată",
    "arestatelor": "arestată",
    "argăsea": "argăsi",
    "argăseai": "argăsi",
    "argăseam": "argăsi",
    "argăsească": "argăsi",
    "argăseați": "argăsi",
    "argăseau": "argăsi",
    "argăsesc": "argăsi",
    "argăsește": "argăsi",
    "argăsești": "argăsi",
    "argăsii": "argăsi",
    "argăsim": "argăsi",
    "argăsind": "argăsi",
    "argăsindu": "argăsi",
    "argăsiră": "argăsi",
    "argăsirăm": "argăsi",
    "argăsirăți": "argăsi",
    "argăsise": "argăsi",
    "argăsisem": "argăsi",
    "argăsiseră": "argăsi",
    "argăsiserăm": "argăsi",
    "argăsiserăți": "argăsi",
    "argăsiseși": "argăsi",
    "argăsiși": "argăsi",
    "argăsit": "argăsi",
    "argăsiți": "argăsi",
    "argăsitu": "argăsi",
    "neargăsind": "argăsi",
    "neargăsindu": "argăsi",
    "nemaiargăsind": "argăsi",
    "nemaiargăsindu": "argăsi",
    "argăsirea": "argăsire",
    "argăsiri": "argăsire",
    "argăsirii": "argăsire",
    "argăsirile": "argăsire",
    "argăsita": "argăsit",
    "argăsită": "argăsit",
    "argăsite": "argăsit",
    "argăsitei": "argăsit",
    "argăsitele": "argăsit",
    "argăsitelor": "argăsit",
    "argăsiți": "argăsit",
    "argăsiții": "argăsit",
    "argăsiților": "argăsit",
    "argăsitul": "argăsit",
    "argăsitului": "argăsit",
    "argați": "argat",
    "argații": "argat",
    "argaților": "argat",
    "argatul": "argat",
    "argatului": "argat",
    "argentifera": "argentifer",
    "argentiferă": "argentifer",
    "argentifere": "argentifer",
    "argentiferei": "argentifer",
    "argentiferele": "argentifer",
    "argentiferelor": "argentifer",
    "argentiferi": "argentifer",
    "argentiferii": "argentifer",
    "argentiferilor": "argentifer",
    "argentiferul": "argentifer",
    "argentiferului": "argentifer",
    "Ar.": "Argentina",
    "Argentină": "Argentina",
    "Argentinei": "Argentina",
    "Argentini": "Argentina",
    "Argeșul": "Argeș",
    "Argeșului": "Argeș",
    "argeșeana": "argeșean",
    "argeșeană": "argeșean",
    "argeșeanul": "argeșean",
    "argeșeanului": "argeșean",
    "argeșene": "argeșean",
    "argeșenei": "argeșean",
    "argeșenele": "argeșean",
    "argeșenelor": "argeșean",
    "argeșeni": "argeșean",
    "argeșenii": "argeșean",
    "argeșenilor": "argeșean",
    "argeșeanca": "argeșeancă",
    "argeșence": "argeșeancă",
    "argeșencei": "argeșeancă",
    "argeșencele": "argeșeancă",
    "argeșencelor": "argeșeancă",
    "arghirofilia": "arghirofilie",
    "arghirofiliei": "arghirofilie",
    "arghirofilii": "arghirofilie",
    "arghirofiliile": "arghirofilie",
    "arghirofiliilor": "arghirofilie",
    "argianii": "argian",
    "argianilor": "argian",
    "argianul": "argian",
    "argianului": "argian",
    "argieni": "argian",
    "argiloasa": "argilos",
    "argiloasă": "argilos",
    "argiloase": "argilos",
    "argiloasei": "argilos",
    "argiloasele": "argilos",
    "argiloaselor": "argilos",
    "argiloși": "argilos",
    "argiloșii": "argilos",
    "argiloșilor": "argilos",
    "argilosul": "argilos",
    "argilosului": "argilos",
    "Ag": "argint",
    "arginți": "argint",
    "arginții": "argint",
    "arginților": "argint",
    "argintul": "argint",
    "argintului": "argint",
    "argintăria": "argintărie",
    "argintăriei": "argintărie",
    "argintării": "argintărie",
    "argintăriile": "argintărie",
    "argintăriilor": "argintărie",
    "argintia": "argintiu",
    "argintie": "argintiu",
    "argintiei": "argintiu",
    "argintii": "argintiu",
    "argintiii": "argintiu",
    "argintiile": "argintiu",
    "argintiilor": "argintiu",
    "argintiul": "argintiu",
    "argintiului": "argintiu",
    "argintoasa": "argintos",
    "argintoasă": "argintos",
    "argintoase": "argintos",
    "argintoasei": "argintos",
    "argintoasele": "argintos",
    "argintoaselor": "argintos",
    "argintoși": "argintos",
    "argintoșii": "argintos",
    "argintoșilor": "argintos",
    "argintosul": "argintos",
    "argintosului": "argintos",
    "argintuita": "argintuit",
    "argintuită": "argintuit",
    "argintuite": "argintuit",
    "argintuitei": "argintuit",
    "argintuitele": "argintuit",
    "argintuitelor": "argintuit",
    "argintuiți": "argintuit",
    "argintuiții": "argintuit",
    "argintuiților": "argintuit",
    "argintuitul": "argintuit",
    "argintuitului": "argintuit",
    "argintului-viu": "argint-viu",
    "argintul-viu": "argint-viu",
    "Ar": "argon",
    "argonul": "argon",
    "argonului": "argon",
    "arg.": "argotic",
    "argotica": "argotic",
    "argotică": "argotic",
    "argotice": "argotic",
    "argoticei": "argotic",
    "argoticele": "argotic",
    "argoticelor": "argotic",
    "argotici": "argotic",
    "argoticii": "argotic",
    "argoticilor": "argotic",
    "argoticul": "argotic",
    "argoticului": "argotic",
    "argoul": "argou",
    "argoului": "argou",
    "argouri": "argou",
    "argourile": "argou",
    "argourilor": "argou",
    "argumente": "argument",
    "argumentele": "argument",
    "argumentelor": "argument",
    "argumentul": "argument",
    "argumentului": "argument",
    "argumentă": "argumenta",
    "argumentai": "argumenta",
    "argumentam": "argumenta",
    "argumentăm": "argumenta",
    "argumentând": "argumenta",
    "argumentându": "argumenta",
    "argumentară": "argumenta",
    "argumentarăm": "argumenta",
    "argumentarăți": "argumenta",
    "argumentase": "argumenta",
    "argumentasem": "argumenta",
    "argumentaseră": "argumenta",
    "argumentaserăm": "argumenta",
    "argumentaserăți": "argumenta",
    "argumentaseși": "argumenta",
    "argumentași": "argumenta",
    "argumentat": "argumenta",
    "argumentați": "argumenta",
    "argumentatu": "argumenta",
    "argumentau": "argumenta",
    "argumentează": "argumenta",
    "argumentez": "argumenta",
    "argumenteze": "argumenta",
    "argumentezi": "argumenta",
    "neargumentând": "argumenta",
    "neargumentându": "argumenta",
    "nemaiargumentând": "argumenta",
    "nemaiargumentându": "argumenta",
    "argumentarea": "argumentare",
    "argumentări": "argumentare",
    "argumentării": "argumentare",
    "argumentările": "argumentare",
    "argumentata": "argumentat",
    "argumentată": "argumentat",
    "argumentate": "argumentat",
    "argumentatei": "argumentat",
    "argumentatele": "argumentat",
    "argumentatelor": "argumentat",
    "argumentați": "argumentat",
    "argumentații": "argumentat",
    "argumentaților": "argumentat",
    "argumentatul": "argumentat",
    "argumentatului": "argumentat",
    "argumentația": "argumentație",
    "argumentației": "argumentație",
    "argumentații": "argumentație",
    "argumentațiile": "argumentație",
    "argumentațiilor": "argumentație",
    "argumentativa": "argumentativ",
    "argumentativă": "argumentativ",
    "argumentative": "argumentativ",
    "argumentativei": "argumentativ",
    "argumentativele": "argumentativ",
    "argumentativelor": "argumentativ",
    "argumentativi": "argumentativ",
    "argumentativii": "argumentativ",
    "argumentativilor": "argumentativ",
    "argumentativul": "argumentativ",
    "argumentativului": "argumentativ",
    "arhaica": "arhaic",
    "arhaică": "arhaic",
    "arhaice": "arhaic",
    "arhaicei": "arhaic",
    "arhaicele": "arhaic",
    "arhaicelor": "arhaic",
    "arhaici": "arhaic",
    "arhaicii": "arhaic",
    "arhaicilor": "arhaic",
    "arhaicul": "arhaic",
    "arhaicului": "arhaic",
    "arhaisme": "arhaism",
    "arhaismele": "arhaism",
    "arhaismelor": "arhaism",
    "arhaismul": "arhaism",
    "arhaismului": "arhaism",
    "arh.": "arhaizant",
    "arhaizantă": "arhaizant",
    "arhaizante": "arhaizant",
    "arhaizanți": "arhaizant",
    "arhangheli": "arhanghel",
    "arhanghelii": "arhanghel",
    "arhanghelilor": "arhanghel",
    "arhanghelul": "arhanghel",
    "arhanghelului": "arhanghel",
    "arheologi": "arheolog",
    "arheologii": "arheolog",
    "arheologilor": "arheolog",
    "arheologul": "arheolog",
    "arheologului": "arheolog",
    "arheologica": "arheologic",
    "arheologică": "arheologic",
    "arheologice": "arheologic",
    "arheologicei": "arheologic",
    "arheologicele": "arheologic",
    "arheologicelor": "arheologic",
    "arheologici": "arheologic",
    "arheologicii": "arheologic",
    "arheologicilor": "arheologic",
    "arheologicul": "arheologic",
    "arheologicului": "arheologic",
    "arheol.": "arheologie",
    "arheologia": "arheologie",
    "arheologiei": "arheologie",
    "arheologii": "arheologie",
    "arheologiile": "arheologie",
    "arheologiilor": "arheologie",
    "arhetipul": "arhetip",
    "arhetipului": "arhetip",
    "arhetipuri": "arhetip",
    "arhetipurile": "arhetip",
    "arhetipurilor": "arhetip",
    "arhicunoscuta": "arhicunoscut",
    "arhicunoscută": "arhicunoscut",
    "arhicunoscute": "arhicunoscut",
    "arhicunoscutei": "arhicunoscut",
    "arhicunoscutele": "arhicunoscut",
    "arhicunoscutelor": "arhicunoscut",
    "arhicunoscuți": "arhicunoscut",
    "arhicunoscuții": "arhicunoscut",
    "arhicunoscuților": "arhicunoscut",
    "arhicunoscutul": "arhicunoscut",
    "arhicunoscutului": "arhicunoscut",
    "arhidiecezana": "arhidiecezan",
    "arhidiecezană": "arhidiecezan",
    "arhidiecezane": "arhidiecezan",
    "arhidiecezanei": "arhidiecezan",
    "arhidiecezanele": "arhidiecezan",
    "arhidiecezanelor": "arhidiecezan",
    "arhidiecezani": "arhidiecezan",
    "arhidiecezanii": "arhidiecezan",
    "arhidiecezanilor": "arhidiecezan",
    "arhidiecezanul": "arhidiecezan",
    "arhidiecezanului": "arhidiecezan",
    "arhiepiscopala": "arhiepiscopal",
    "arhiepiscopală": "arhiepiscopal",
    "arhiepiscopale": "arhiepiscopal",
    "arhiepiscopalei": "arhiepiscopal",
    "arhiepiscopalele": "arhiepiscopal",
    "arhiepiscopalelor": "arhiepiscopal",
    "arhiepiscopali": "arhiepiscopal",
    "arhiepiscopalii": "arhiepiscopal",
    "arhiepiscopalilor": "arhiepiscopal",
    "arhiepiscopalul": "arhiepiscopal",
    "arhiepiscopalului": "arhiepiscopal",
    "arhiepiscopia": "arhiepiscopie",
    "arhiepiscopiei": "arhiepiscopie",
    "arhiepiscopii": "arhiepiscopie",
    "arhiepiscopiile": "arhiepiscopie",
    "arhiepiscopiilor": "arhiepiscopie",
    "arhierei": "arhiereu",
    "arhiereii": "arhiereu",
    "arhiereilor": "arhiereu",
    "arhiereul": "arhiereu",
    "arhiereului": "arhiereu",
    "arhimandriți": "arhimandrit",
    "arhimandriții": "arhimandrit",
    "arhimandriților": "arhimandrit",
    "arhimandritul": "arhimandrit",
    "arhimandritului": "arhimandrit",
    "arhimulțumea": "arhimulțumi",
    "arhimulțumeai": "arhimulțumi",
    "arhimulțumeam": "arhimulțumi",
    "arhimulțumească": "arhimulțumi",
    "arhimulțumeați": "arhimulțumi",
    "arhimulțumeau": "arhimulțumi",
    "arhimulțumesc": "arhimulțumi",
    "arhimulțumește": "arhimulțumi",
    "arhimulțumești": "arhimulțumi",
    "arhimulțumii": "arhimulțumi",
    "arhimulțumim": "arhimulțumi",
    "arhimulțumind": "arhimulțumi",
    "arhimulțumindu": "arhimulțumi",
    "arhimulțumiră": "arhimulțumi",
    "arhimulțumirăm": "arhimulțumi",
    "arhimulțumirăți": "arhimulțumi",
    "arhimulțumise": "arhimulțumi",
    "arhimulțumisem": "arhimulțumi",
    "arhimulțumiseră": "arhimulțumi",
    "arhimulțumiserăm": "arhimulțumi",
    "arhimulțumiserăți": "arhimulțumi",
    "arhimulțumiseși": "arhimulțumi",
    "arhimulțumiși": "arhimulțumi",
    "arhimulțumit": "arhimulțumi",
    "arhimulțumiți": "arhimulțumi",
    "arhimulțumitu": "arhimulțumi",
    "arhimulțumită": "arhimulțumit",
    "arhimulțumite": "arhimulțumit",
    "arhimulțumiți": "arhimulțumit",
    "arhipelagul": "arhipelag",
    "arhipelagului": "arhipelag",
    "arhipelaguri": "arhipelag",
    "arhipelagurile": "arhipelag",
    "arhipelagurilor": "arhipelag",
    "arhiplina": "arhiplin",
    "arhiplină": "arhiplin",
    "arhipline": "arhiplin",
    "arhiplinei": "arhiplin",
    "arhiplinele": "arhiplin",
    "arhiplinelor": "arhiplin",
    "arhiplini": "arhiplin",
    "arhiplinii": "arhiplin",
    "arhiplinilor": "arhiplin",
    "arhiplinul": "arhiplin",
    "arhiplinului": "arhiplin",
    "arh.": "arhitect",
    "arhitecți": "arhitect",
    "arhitecții": "arhitect",
    "arhitecților": "arhitect",
    "arhitectul": "arhitect",
    "arhitectului": "arhitect",
    "arhitectonica": "arhitectonic",
    "arhitectonică": "arhitectonic",
    "arhitectonice": "arhitectonic",
    "arhitectonicei": "arhitectonic",
    "arhitectonicele": "arhitectonic",
    "arhitectonicelor": "arhitectonic",
    "arhitectonici": "arhitectonic",
    "arhitectonicii": "arhitectonic",
    "arhitectonicilor": "arhitectonic",
    "arhitectonicul": "arhitectonic",
    "arhitectonicului": "arhitectonic",
    "arhit.": "arhitectură",
    "arhitectura": "arhitectură",
    "arhitecturi": "arhitectură",
    "arhitecturii": "arhitectură",
    "arhitecturile": "arhitectură",
    "arhitecturilor": "arhitectură",
    "arhitecturala": "arhitectural",
    "arhitecturală": "arhitectural",
    "arhitecturale": "arhitectural",
    "arhitecturalei": "arhitectural",
    "arhitecturalele": "arhitectural",
    "arhitecturalelor": "arhitectural",
    "arhitecturali": "arhitectural",
    "arhitecturalii": "arhitectural",
    "arhitecturalilor": "arhitectural",
    "arhitecturalul": "arhitectural",
    "arhitecturalului": "arhitectural",
    "arhivai": "arhiva",
    "arhivam": "arhiva",
    "arhivând": "arhiva",
    "arhivându": "arhiva",
    "arhivară": "arhiva",
    "arhivarăm": "arhiva",
    "arhivarăți": "arhiva",
    "arhivase": "arhiva",
    "arhivasem": "arhiva",
    "arhivaseră": "arhiva",
    "arhivaserăm": "arhiva",
    "arhivaserăți": "arhiva",
    "arhivaseși": "arhiva",
    "arhivași": "arhiva",
    "arhivat": "arhiva",
    "arhivați": "arhiva",
    "arhivatu": "arhiva",
    "arhivau": "arhiva",
    "arhive": "arhiva",
    "arhivi": "arhiva",
    "arhiva": "arhivă",
    "arhive": "arhivă",
    "arhivei": "arhivă",
    "arhivele": "arhivă",
    "arhivelor": "arhivă",
    "arhivari": "arhivar",
    "arhivarii": "arhivar",
    "arhivarilor": "arhivar",
    "arhivarul": "arhivar",
    "arhivarului": "arhivar",
    "arhivarea": "arhivare",
    "arhivată": "arhivat",
    "arhivate": "arhivat",
    "arhivați": "arhivat",
    "arhivatul": "arhivat",
    "arhivatului": "arhivat",
    "arhiviști": "arhivist",
    "arhiviștii": "arhivist",
    "arhiviștilor": "arhivist",
    "arhivistul": "arhivist",
    "arhivistului": "arhivist",
    "arhivista": "arhivistă",
    "arhiviste": "arhivistă",
    "arhivistei": "arhivistă",
    "arhivistele": "arhivistă",
    "arhivistelor": "arhivistă",
    "ariana": "arian",
    "ariană": "arian",
    "ariani": "arian",
    "arianii": "arian",
    "arianilor": "arian",
    "arianul": "arian",
    "arianului": "arian",
    "ariene": "arian",
    "arienei": "arian",
    "arienele": "arian",
    "arienelor": "arian",
    "arieni": "arian",
    "arienii": "arian",
    "arienilor": "arian",
    "aricii": "arici",
    "aricilor": "arici",
    "ariciul": "arici",
    "ariciului": "arici",
    "aricii-de-mare": "arici-de-mare",
    "aricilor-de-mare": "arici-de-mare",
    "ariciul-de-mare": "arici-de-mare",
    "ariciului-de-mare": "arici-de-mare",
    "arida": "arid",
    "aridă": "arid",
    "aride": "arid",
    "aridei": "arid",
    "aridele": "arid",
    "aridelor": "arid",
    "aridul": "arid",
    "aridului": "arid",
    "arizi": "arid",
    "arizii": "arid",
    "arizilor": "arid",
    "aria": "arie",
    "ariei": "arie",
    "arii": "arie",
    "ariile": "arie",
    "ariilor": "arie",
    "arierata": "arierat",
    "arierată": "arierat",
    "arierate": "arierat",
    "arieratei": "arierat",
    "arieratele": "arierat",
    "arieratelor": "arierat",
    "arierați": "arierat",
    "arierații": "arierat",
    "arieraților": "arierat",
    "arieratul": "arierat",
    "arieratului": "arierat",
    "arierata": "arierată",
    "arierate": "arierată",
    "arieratei": "arierată",
    "arieratele": "arierată",
    "arieratelor": "arierată",
    "arietatea": "arietate",
    "arietăți": "arietate",
    "arietății": "arietate",
    "arietățile": "arietate",
    "arietăților": "arietate",
    "arinoasa": "arinos",
    "arinoasă": "arinos",
    "arinoase": "arinos",
    "arinoasei": "arinos",
    "arinoasele": "arinos",
    "arinoaselor": "arinos",
    "arinoși": "arinos",
    "arinoșii": "arinos",
    "arinoșilor": "arinos",
    "arinosul": "arinos",
    "arinosului": "arinos",
    "aripa": "aripă",
    "aripi": "aripă",
    "aripii": "aripă",
    "aripile": "aripă",
    "aripilor": "aripă",
    "aripata": "aripat",
    "aripată": "aripat",
    "aripate": "aripat",
    "aripatei": "aripat",
    "aripatele": "aripat",
    "aripatelor": "aripat",
    "aripați": "aripat",
    "aripații": "aripat",
    "aripaților": "aripat",
    "aripatul": "aripat",
    "aripatului": "aripat",
    "aripioara": "aripioară",
    "aripioare": "aripioară",
    "aripioarei": "aripioară",
    "aripioarele": "aripioară",
    "aripioarelor": "aripioară",
    "aristocrata": "aristocrat",
    "aristocrată": "aristocrat",
    "aristocrate": "aristocrat",
    "aristocratei": "aristocrat",
    "aristocratele": "aristocrat",
    "aristocratelor": "aristocrat",
    "aristocrați": "aristocrat",
    "aristocrații": "aristocrat",
    "aristocraților": "aristocrat",
    "aristocratul": "aristocrat",
    "aristocratului": "aristocrat",
    "aristocrata": "aristocrată",
    "aristocrate": "aristocrată",
    "aristocratele": "aristocrată",
    "aristocratelor": "aristocrată",
    "aristocratica": "aristocratic",
    "aristocratică": "aristocratic",
    "aristocratice": "aristocratic",
    "aristocraticei": "aristocratic",
    "aristocraticele": "aristocratic",
    "aristocraticelor": "aristocratic",
    "aristocratici": "aristocratic",
    "aristocraticii": "aristocratic",
    "aristocraticilor": "aristocratic",
    "aristocraticul": "aristocratic",
    "aristocraticului": "aristocratic",
    "aristocrația": "aristocrație",
    "aristocrației": "aristocrație",
    "aristocrații": "aristocrație",
    "aristocrațiile": "aristocrație",
    "aristocrațiilor": "aristocrație",
    "aristotelică": "aristotelic",
    "aristotelice": "aristotelic",
    "aristotelici": "aristotelic",
    "aristotelicianul": "aristotelician",
    "aristotelicianului": "aristotelician",
    "aristotelicieni": "aristotelician",
    "aristotelicienii": "aristotelician",
    "aristotelicienilor": "aristotelician",
    "aritmetica": "aritmetic",
    "aritmetică": "aritmetic",
    "aritmetice": "aritmetic",
    "aritmeticei": "aritmetic",
    "aritmeticele": "aritmetic",
    "aritmeticelor": "aritmetic",
    "aritmetici": "aritmetic",
    "aritmeticii": "aritmetic",
    "aritmeticilor": "aritmetic",
    "aritmeticul": "aritmetic",
    "aritmeticului": "aritmetic",
    "aritmetica": "aritmetică",
    "aritmetici": "aritmetică",
    "aritmeticii": "aritmetică",
    "aritmeticile": "aritmetică",
    "aritmeticilor": "aritmetică",
    "aritmeticienii": "aritmetician",
    "aritmica": "aritmic",
    "aritmică": "aritmic",
    "aritmice": "aritmic",
    "aritmicei": "aritmic",
    "aritmicelor": "aritmic",
    "aritmici": "aritmic",
    "aritmicii": "aritmic",
    "aritmicilor": "aritmic",
    "aritmicul": "aritmic",
    "aritmicului": "aritmic",
    "aritmia": "aritmie",
    "aritmiei": "aritmie",
    "aritmii": "aritmie",
    "aritmiile": "aritmie",
    "aritmiilor": "aritmie",
    "arivista": "arivist",
    "arivistă": "arivist",
    "ariviste": "arivist",
    "arivistei": "arivist",
    "arivistele": "arivist",
    "arivistelor": "arivist",
    "ariviști": "arivist",
    "ariviștii": "arivist",
    "ariviștilor": "arivist",
    "arivistul": "arivist",
    "arivistului": "arivist",
    "arivista": "arivistă",
    "ariviste": "arivistă",
    "arivistei": "arivistă",
    "arivistele": "arivistă",
    "arivistelor": "arivistă",
    "arlechini": "arlechin",
    "arlechinii": "arlechin",
    "arlechinilor": "arlechin",
    "arlechinul": "arlechin",
    "arlechinului": "arlechin",
    "armă": "arma",
    "armai": "arma",
    "armam": "arma",
    "armăm": "arma",
    "armând": "arma",
    "armându": "arma",
    "armară": "arma",
    "armarăm": "arma",
    "armarăți": "arma",
    "armase": "arma",
    "armasem": "arma",
    "armaseră": "arma",
    "armaserăm": "arma",
    "armaserăți": "arma",
    "armaseși": "arma",
    "armași": "arma",
    "armat": "arma",
    "armați": "arma",
    "armatu": "arma",
    "armau": "arma",
    "armează": "arma",
    "armez": "arma",
    "armeze": "arma",
    "armezi": "arma",
    "nearmând": "arma",
    "nearmându": "arma",
    "nemaiarmând": "arma",
    "nemaiarmându": "arma",
    "arma": "armă",
    "arme": "armă",
    "armei": "armă",
    "armele": "armă",
    "armelor": "armă",
    "armamente": "armament",
    "armamentele": "armament",
    "armamentul": "armament",
    "armamentului": "armament",
    "armâna": "armân",
    "armână": "armân",
    "armâne": "armân",
    "armânei": "armân",
    "armânele": "armân",
    "armânelor": "armân",
    "armâni": "armân",
    "armânii": "armân",
    "armânilor": "armân",
    "armânul": "armân",
    "armânului": "armân",
    "armarea": "armare",
    "armări": "armare",
    "armării": "armare",
    "armările": "armare",
    "armamentelor": "armaș",
    "armași": "armaș",
    "armașii": "armaș",
    "armașilor": "armaș",
    "armașul": "armaș",
    "armașului": "armaș",
    "armata": "armat",
    "armată": "armat",
    "armate": "armat",
    "armatei": "armat",
    "armatele": "armat",
    "armatelor": "armat",
    "armați": "armat",
    "armații": "armat",
    "armaților": "armat",
    "armatul": "armat",
    "armatului": "armat",
    "armata": "armată",
    "armate": "armată",
    "armatei": "armată",
    "armatele": "armată",
    "armatelor": "armată",
    "armatori": "armator",
    "armatorii": "armator",
    "armatorilor": "armator",
    "armatorul": "armator",
    "armatorului": "armator",
    "armătura": "armătură",
    "armături": "armătură",
    "armăturii": "armătură",
    "armăturile": "armătură",
    "armăturilor": "armătură",
    "armeana": "armean",
    "armeană": "armean",
    "armeanul": "armean",
    "armeanului": "armean",
    "armene": "armean",
    "armenei": "armean",
    "armenele": "armean",
    "armenelor": "armean",
    "armeni": "armean",
    "armenii": "armean",
    "armenilor": "armean",
    "armeneasca": "armenesc",
    "armenească": "armenesc",
    "armenescul": "armenesc",
    "armenescului": "armenesc",
    "armenești": "armenesc",
    "armeneștii": "armenesc",
    "armeneștile": "armenesc",
    "armeneștilor": "armenesc",
    "Armenie": "Armenia",
    "Armeniei": "Armenia",
    "Armenii": "Armenia",
    "armindeni": "arminden",
    "armindenii": "arminden",
    "armindenilor": "arminden",
    "armindenul": "arminden",
    "armindenului": "arminden",
    "armistiții": "armistițiu",
    "armistițiile": "armistițiu",
    "armistițiilor": "armistițiu",
    "armistițiul": "armistițiu",
    "armistițiului": "armistițiu",
    "armonica": "armonic",
    "armonică": "armonic",
    "armonice": "armonic",
    "armonicei": "armonic",
    "armonicele": "armonic",
    "armonicelor": "armonic",
    "armonici": "armonic",
    "armonicii": "armonic",
    "armonicilor": "armonic",
    "armonicul": "armonic",
    "armonicului": "armonic",
    "armonica": "armonică",
    "armonici": "armonică",
    "armonicii": "armonică",
    "armonicile": "armonică",
    "armonicilor": "armonică",
    "armonia": "armonie",
    "armoniei": "armonie",
    "armonii": "armonie",
    "armoniile": "armonie",
    "armoniilor": "armonie",
    "armonioasa": "armonios",
    "armonioasă": "armonios",
    "armonioase": "armonios",
    "armonioasei": "armonios",
    "armonioasele": "armonios",
    "armonioaselor": "armonios",
    "armonioși": "armonios",
    "armonioșii": "armonios",
    "armonioșilor": "armonios",
    "armoniosul": "armonios",
    "armoniosului": "armonios",
    "armoniză": "armoniza",
    "armonizai": "armoniza",
    "armonizam": "armoniza",
    "armonizăm": "armoniza",
    "armonizând": "armoniza",
    "armonizându": "armoniza",
    "armonizară": "armoniza",
    "armonizarăm": "armoniza",
    "armonizarăți": "armoniza",
    "armonizase": "armoniza",
    "armonizasem": "armoniza",
    "armonizaseră": "armoniza",
    "armonizaserăm": "armoniza",
    "armonizaserăți": "armoniza",
    "armonizaseși": "armoniza",
    "armonizași": "armoniza",
    "armonizat": "armoniza",
    "armonizați": "armoniza",
    "armonizatu": "armoniza",
    "armonizau": "armoniza",
    "armonizează": "armoniza",
    "armonizez": "armoniza",
    "armonizeze": "armoniza",
    "armonizezi": "armoniza",
    "nearmonizând": "armoniza",
    "nearmonizându": "armoniza",
    "nemaiarmonizând": "armoniza",
    "nemaiarmonizându": "armoniza",
    "armonizarea": "armonizare",
    "armonizări": "armonizare",
    "armonizării": "armonizare",
    "armonizările": "armonizare",
    "armonizata": "armonizat",
    "armonizată": "armonizat",
    "armonizate": "armonizat",
    "armonizatei": "armonizat",
    "armonizatele": "armonizat",
    "armonizatelor": "armonizat",
    "armonizați": "armonizat",
    "armonizații": "armonizat",
    "armonizaților": "armonizat",
    "armonizatul": "armonizat",
    "armonizatului": "armonizat",
    "armura": "armură",
    "armuri": "armură",
    "armurii": "armură",
    "armurile": "armură",
    "armurilor": "armură",
    "armurieri": "armurier",
    "armurierii": "armurier",
    "armurierilor": "armurier",
    "armurierul": "armurier",
    "armurierului": "armurier",
    "arnăuți": "arnăut",
    "arnăuții": "arnăut",
    "arnăuților": "arnăut",
    "arnăutul": "arnăut",
    "arnăutului": "arnăut",
    "arnăuțeasca": "arnăuțesc",
    "arnăuțească": "arnăuțesc",
    "arnăuțescul": "arnăuțesc",
    "arnăuțescului": "arnăuțesc",
    "arnăuțești": "arnăuțesc",
    "arnăuțeștii": "arnăuțesc",
    "arnăuțeștile": "arnăuțesc",
    "arnăuțeștilor": "arnăuțesc",
    "arog": "aroga",
    "arogă": "aroga",
    "arogai": "aroga",
    "arogam": "aroga",
    "arogăm": "aroga",
    "arogând": "aroga",
    "arogându": "aroga",
    "arogară": "aroga",
    "arogarăm": "aroga",
    "arogarăți": "aroga",
    "arogase": "aroga",
    "arogasem": "aroga",
    "arogaseră": "aroga",
    "arogaserăm": "aroga",
    "arogaserăți": "aroga",
    "arogaseși": "aroga",
    "arogași": "aroga",
    "arogat": "aroga",
    "arogați": "aroga",
    "arogatu": "aroga",
    "arogau": "aroga",
    "aroge": "aroga",
    "arogi": "aroga",
    "nearogând": "aroga",
    "nearogându": "aroga",
    "nemaiarogând": "aroga",
    "nemaiarogându": "aroga",
    "aroganta": "arogant",
    "arogantă": "arogant",
    "arogante": "arogant",
    "arogantei": "arogant",
    "arogantele": "arogant",
    "arogantelor": "arogant",
    "aroganți": "arogant",
    "aroganții": "arogant",
    "aroganților": "arogant",
    "arogantul": "arogant",
    "arogantului": "arogant",
    "aroganța": "aroganță",
    "aroganțe": "aroganță",
    "aroganței": "aroganță",
    "aroganțele": "aroganță",
    "aroganțelor": "aroganță",
    "arogarea": "arogare",
    "arogări": "arogare",
    "arogării": "arogare",
    "arogările": "arogare",
    "arogata": "arogat",
    "arogată": "arogat",
    "arogate": "arogat",
    "arogatei": "arogat",
    "arogatele": "arogat",
    "arogatelor": "arogat",
    "arogați": "arogat",
    "arogații": "arogat",
    "arogaților": "arogat",
    "arogatul": "arogat",
    "arogatului": "arogat",
    "aroma": "aromă",
    "arome": "aromă",
    "aromei": "aromă",
    "aromele": "aromă",
    "aromelor": "aromă",
    "aromâna": "aromân",
    "aromână": "aromân",
    "aromâne": "aromân",
    "aromânei": "aromân",
    "aromânele": "aromân",
    "aromânelor": "aromân",
    "aromâni": "aromân",
    "aromânii": "aromân",
    "aromânilor": "aromân",
    "aromânul": "aromân",
    "aromânului": "aromân",
    "aromânca": "aromâncă",
    "aromânce": "aromâncă",
    "aromâncei": "aromâncă",
    "aromâncele": "aromâncă",
    "aromâncelor": "aromâncă",
    "aromata": "aromat",
    "aromată": "aromat",
    "aromate": "aromat",
    "aromatei": "aromat",
    "aromatele": "aromat",
    "aromatelor": "aromat",
    "aromați": "aromat",
    "aromații": "aromat",
    "aromaților": "aromat",
    "aromatul": "aromat",
    "aromatului": "aromat",
    "aromatica": "aromatic",
    "aromatică": "aromatic",
    "aromatice": "aromatic",
    "aromaticei": "aromatic",
    "aromaticele": "aromatic",
    "aromaticelor": "aromatic",
    "aromatici": "aromatic",
    "aromaticii": "aromatic",
    "aromaticilor": "aromatic",
    "aromaticul": "aromatic",
    "aromaticului": "aromatic",
    "aromatizata": "aromatizat",
    "aromatizată": "aromatizat",
    "aromatizate": "aromatizat",
    "aromatizatei": "aromatizat",
    "aromatizatele": "aromatizat",
    "aromatizatelor": "aromatizat",
    "aromatizați": "aromatizat",
    "aromatizații": "aromatizat",
    "aromatizaților": "aromatizat",
    "aromatizatul": "aromatizat",
    "aromatizatului": "aromatizat",
    "aromeala": "aromeală",
    "aromeli": "aromeală",
    "aromelii": "aromeală",
    "aromelile": "aromeală",
    "arondarea": "arondare",
    "arondări": "arondare",
    "arondării": "arondare",
    "arondările": "arondare",
    "arondărilor": "arondare",
    "arondată": "arondat",
    "arondate": "arondat",
    "arondați": "arondat",
    "arpagicul": "arpagic",
    "arpagicului": "arpagic",
    "arsa": "ars",
    "arsă": "ars",
    "arse": "ars",
    "arsei": "ars",
    "arsele": "ars",
    "arselor": "ars",
    "arși": "ars",
    "arșii": "ars",
    "arșilor": "ars",
    "arsul": "ars",
    "arsului": "ars",
    "arsenale": "arsenal",
    "arsenalele": "arsenal",
    "arsenalelor": "arsenal",
    "arsenalul": "arsenal",
    "arsenalului": "arsenal",
    "arsenice": "arsenic",
    "arsenicele": "arsenic",
    "arsenicelor": "arsenic",
    "arsenici": "arsenic",
    "arsenicii": "arsenic",
    "arsenicilor": "arsenic",
    "arsenicul": "arsenic",
    "arsenicului": "arsenic",
    "arsenicala": "arsenical",
    "arsenicală": "arsenical",
    "arsenicale": "arsenical",
    "arsenicalei": "arsenical",
    "arsenicalele": "arsenical",
    "arsenicalelor": "arsenical",
    "arsenicali": "arsenical",
    "arsenicalii": "arsenical",
    "arsenicalilor": "arsenical",
    "arsenicalul": "arsenical",
    "arsenicalului": "arsenical",
    "arsenioși": "arsenios",
    "arsenioșii": "arsenios",
    "arsenioșilor": "arsenios",
    "arseniosul": "arsenios",
    "arseniosului": "arsenios",
    "arșice": "arșic",
    "arșicele": "arșic",
    "arșicelor": "arșic",
    "arșicul": "arșic",
    "arșicului": "arșic",
    "arșini": "arșin",
    "arșinii": "arșin",
    "arșinilor": "arșin",
    "arșinul": "arșin",
    "arșinului": "arșin",
    "arșița": "arșiță",
    "arșițe": "arșiță",
    "arșiței": "arșiță",
    "arșițele": "arșiță",
    "arșițelor": "arșiță",
    "arsura": "arsură",
    "arsuri": "arsură",
    "arsurii": "arsură",
    "arsurile": "arsură",
    "arsurilor": "arsură",
    "arta": "artă",
    "arte": "artă",
    "artei": "artă",
    "artele": "artă",
    "artelor": "artă",
    "arțagul": "arțag",
    "arțagului": "arțag",
    "arțaguri": "arțag",
    "arțagurile": "arțag",
    "arțagurilor": "arțag",
    "arțăgoasa": "arțăgos",
    "arțăgoasă": "arțăgos",
    "arțăgoase": "arțăgos",
    "arțăgoasei": "arțăgos",
    "arțăgoasele": "arțăgos",
    "arțăgoaselor": "arțăgos",
    "arțăgoși": "arțăgos",
    "arțăgoșii": "arțăgos",
    "arțăgoșilor": "arțăgos",
    "arțăgosul": "arțăgos",
    "arțăgosului": "arțăgos",
    "artera": "arteră",
    "artere": "arteră",
    "arterei": "arteră",
    "arterele": "arteră",
    "arterelor": "arteră",
    "arteriala": "arterial",
    "arterială": "arterial",
    "arteriale": "arterial",
    "arterialei": "arterial",
    "arterialele": "arterial",
    "arterialelor": "arterial",
    "arteriali": "arterial",
    "arterialii": "arterial",
    "arterialilor": "arterial",
    "arterialul": "arterial",
    "arterialului": "arterial",
    "arteriola": "arteriolă",
    "arteriole": "arteriolă",
    "arteriolei": "arteriolă",
    "arteriolele": "arteriolă",
    "arteriolelor": "arteriolă",
    "arterioscleroza": "arterioscleroză",
    "arterioscleroze": "arterioscleroză",
    "arteriosclerozei": "arterioscleroză",
    "arteriosclerozele": "arterioscleroză",
    "arteriosclerozelor": "arterioscleroză",
    "arterita": "arterită",
    "arterite": "arterită",
    "arteritei": "arterită",
    "arteritele": "arterită",
    "arteritelor": "arterită",
    "arteziana": "artezian",
    "arteziană": "artezian",
    "artezianul": "artezian",
    "artezianului": "artezian",
    "arteziene": "artezian",
    "artezienei": "artezian",
    "artezienele": "artezian",
    "artezienelor": "artezian",
    "artezieni": "artezian",
    "artezienii": "artezian",
    "artezienilor": "artezian",
    "art.": "articol",
    "articole": "articol",
    "articolele": "articol",
    "articolelor": "articol",
    "articolul": "articol",
    "articolului": "articol",
    "articulă": "articula",
    "articulai": "articula",
    "articulam": "articula",
    "articulăm": "articula",
    "articulând": "articula",
    "articulându": "articula",
    "articulară": "articula",
    "articularăm": "articula",
    "articularăți": "articula",
    "articulase": "articula",
    "articulasem": "articula",
    "articulaseră": "articula",
    "articulaserăm": "articula",
    "articulaserăți": "articula",
    "articulaseși": "articula",
    "articulași": "articula",
    "articulat": "articula",
    "articulați": "articula",
    "articulatu": "articula",
    "articulau": "articula",
    "articulează": "articula",
    "articulez": "articula",
    "articuleze": "articula",
    "articulezi": "articula",
    "nearticulând": "articula",
    "nearticulându": "articula",
    "nemaiarticulând": "articula",
    "nemaiarticulându": "articula",
    "articulara": "articular",
    "articulară": "articular",
    "articulare": "articular",
    "articularei": "articular",
    "articularele": "articular",
    "articularelor": "articular",
    "articulari": "articular",
    "articularii": "articular",
    "articularilor": "articular",
    "articularul": "articular",
    "articularului": "articular",
    "articularea": "articulare",
    "articulări": "articulare",
    "articulării": "articulare",
    "articulările": "articulare",
    "articulata": "articulat",
    "articulată": "articulat",
    "articulate": "articulat",
    "articulatei": "articulat",
    "articulatele": "articulat",
    "articulatelor": "articulat",
    "articulați": "articulat",
    "articulații": "articulat",
    "articulaților": "articulat",
    "articulatul": "articulat",
    "articulatului": "articulat",
    "articulația": "articulație",
    "articulației": "articulație",
    "articulații": "articulație",
    "articulațiile": "articulație",
    "articulațiilor": "articulație",
    "artificiala": "artificial",
    "artificială": "artificial",
    "artificiale": "artificial",
    "artificialei": "artificial",
    "artificialele": "artificial",
    "artificialelor": "artificial",
    "artificiali": "artificial",
    "artificialii": "artificial",
    "artificialilor": "artificial",
    "artificialul": "artificial",
    "artificialului": "artificial",
    "artificieri": "artificier",
    "artificierii": "artificier",
    "artificierilor": "artificier",
    "artificierul": "artificier",
    "artificierului": "artificier",
    "artificioasa": "artificios",
    "artificioasă": "artificios",
    "artificioase": "artificios",
    "artificioasei": "artificios",
    "artificioasele": "artificios",
    "artificioaselor": "artificios",
    "artificioși": "artificios",
    "artificioșii": "artificios",
    "artificioșilor": "artificios",
    "artificiosul": "artificios",
    "artificiosului": "artificios",
    "artificii": "artificiu",
    "artificiile": "artificiu",
    "artificiilor": "artificiu",
    "artificiul": "artificiu",
    "artificiului": "artificiu",
    "artileria": "artilerie",
    "artileriei": "artilerie",
    "artilerii": "artilerie",
    "artileriile": "artilerie",
    "artileriilor": "artilerie",
    "artileriști": "artilerist",
    "artileriștii": "artilerist",
    "artileriștilor": "artilerist",
    "artileristul": "artilerist",
    "artileristului": "artilerist",
    "artilerista": "artileristă",
    "artileriste": "artileristă",
    "artileristei": "artileristă",
    "artileristele": "artileristă",
    "artileristelor": "artileristă",
    "artiști": "artist",
    "artiștii": "artist",
    "artiștilor": "artist",
    "artistul": "artist",
    "artistului": "artist",
    "artista": "artistă",
    "artiste": "artistă",
    "artistei": "artistă",
    "artistele": "artistă",
    "artistelor": "artistă",
    "artistica": "artistic",
    "artistică": "artistic",
    "artistice": "artistic",
    "artisticei": "artistic",
    "artisticele": "artistic",
    "artisticelor": "artistic",
    "artistici": "artistic",
    "artisticii": "artistic",
    "artisticilor": "artistic",
    "artisticul": "artistic",
    "artisticului": "artistic",
    "artizani": "artizan",
    "artizanii": "artizan",
    "artizanilor": "artizan",
    "artizanul": "artizan",
    "artizanului": "artizan",
    "artizanate": "artizanat",
    "artizanatele": "artizanat",
    "artizanatelor": "artizanat",
    "artizanatul": "artizanat",
    "artizanatului": "artizanat",
    "artrita": "artrită",
    "artrite": "artrită",
    "artritei": "artrită",
    "artritele": "artrită",
    "artritelor": "artrită",
    "artritica": "artritic",
    "artritică": "artritic",
    "artritice": "artritic",
    "artriticei": "artritic",
    "artriticele": "artritic",
    "artriticelor": "artritic",
    "artritici": "artritic",
    "artriticii": "artritic",
    "artriticilor": "artritic",
    "artriticul": "artritic",
    "artriticului": "artritic",
    "artroza": "artroză",
    "artroze": "artroză",
    "artrozei": "artroză",
    "artrozele": "artroză",
    "artrozelor": "artroză",
    "arunc": "arunca",
    "aruncă": "arunca",
    "aruncai": "arunca",
    "aruncam": "arunca",
    "aruncăm": "arunca",
    "aruncând": "arunca",
    "aruncându": "arunca",
    "aruncară": "arunca",
    "aruncarăm": "arunca",
    "aruncarăți": "arunca",
    "aruncase": "arunca",
    "aruncasem": "arunca",
    "aruncaseră": "arunca",
    "aruncaserăm": "arunca",
    "aruncaserăți": "arunca",
    "aruncaseși": "arunca",
    "aruncași": "arunca",
    "aruncat": "arunca",
    "aruncați": "arunca",
    "aruncatu": "arunca",
    "aruncau": "arunca",
    "arunce": "arunca",
    "arunci": "arunca",
    "nearuncând": "arunca",
    "nearuncându": "arunca",
    "nemaiaruncând": "arunca",
    "nemaiaruncându": "arunca",
    "aruncarea": "aruncare",
    "aruncări": "aruncare",
    "aruncării": "aruncare",
    "aruncările": "aruncare",
    "aruncata": "aruncat",
    "aruncată": "aruncat",
    "aruncate": "aruncat",
    "aruncatei": "aruncat",
    "aruncatele": "aruncat",
    "aruncatelor": "aruncat",
    "aruncați": "aruncat",
    "aruncații": "aruncat",
    "aruncaților": "aruncat",
    "aruncatul": "aruncat",
    "aruncatului": "aruncat",
    "aruncătoare": "aruncător",
    "aruncătoarele": "aruncător",
    "aruncătoarelor": "aruncător",
    "aruncătorul": "aruncător",
    "aruncătorului": "aruncător",
    "aruncătura": "aruncătură",
    "aruncături": "aruncătură",
    "aruncăturii": "aruncătură",
    "aruncăturile": "aruncătură",
    "aruncăturilor": "aruncătură",
    "arvanita": "arvanit",
    "arvanită": "arvanit",
    "arvanite": "arvanit",
    "arvanitei": "arvanit",
    "arvanitele": "arvanit",
    "arvanitelor": "arvanit",
    "arvaniți": "arvanit",
    "arvaniții": "arvanit",
    "arvaniților": "arvanit",
    "arvanitul": "arvanit",
    "arvanitului": "arvanit",
    "arvuna": "arvună",
    "arvune": "arvună",
    "arvunei": "arvună",
    "arvunele": "arvună",
    "arvunelor": "arvună",
    "arzătoare": "arzător",
    "arzătoarea": "arzător",
    "arzătoarei": "arzător",
    "arzătoarele": "arzător",
    "arzătoarelor": "arzător",
    "arzători": "arzător",
    "arzătorii": "arzător",
    "arzătorilor": "arzător",
    "arzătorul": "arzător",
    "arzătorului": "arzător",
    "ași": "as",
    "așii": "as",
    "așilor": "as",
    "asul": "as",
    "asului": "as",
    "așa-": "așa",
    "asaltul": "asalt",
    "asaltului": "asalt",
    "asalturi": "asalt",
    "asalturile": "asalt",
    "asalturilor": "asalt",
    "asaltă": "asalta",
    "asaltai": "asalta",
    "asaltam": "asalta",
    "asaltăm": "asalta",
    "asaltând": "asalta",
    "asaltându": "asalta",
    "asaltară": "asalta",
    "asaltarăm": "asalta",
    "asaltarăți": "asalta",
    "asaltase": "asalta",
    "asaltasem": "asalta",
    "asaltaseră": "asalta",
    "asaltaserăm": "asalta",
    "asaltaserăți": "asalta",
    "asaltaseși": "asalta",
    "asaltași": "asalta",
    "asaltat": "asalta",
    "asaltați": "asalta",
    "asaltatu": "asalta",
    "asaltau": "asalta",
    "asaltează": "asalta",
    "asaltez": "asalta",
    "asalteze": "asalta",
    "asaltezi": "asalta",
    "neasaltând": "asalta",
    "neasaltându": "asalta",
    "nemaiasaltând": "asalta",
    "nemaiasaltându": "asalta",
    "asaltarea": "asaltare",
    "asaltări": "asaltare",
    "asaltării": "asaltare",
    "asaltările": "asaltare",
    "asaltata": "asaltat",
    "asaltată": "asaltat",
    "asaltate": "asaltat",
    "asaltatei": "asaltat",
    "asaltatele": "asaltat",
    "asaltatelor": "asaltat",
    "asaltați": "asaltat",
    "asaltații": "asaltat",
    "asaltaților": "asaltat",
    "asaltatul": "asaltat",
    "asaltatului": "asaltat",
    "asamblă": "asambla",
    "asamblai": "asambla",
    "asamblam": "asambla",
    "asamblăm": "asambla",
    "asamblând": "asambla",
    "asamblându": "asambla",
    "asamblară": "asambla",
    "asamblarăm": "asambla",
    "asamblarăți": "asambla",
    "asamblase": "asambla",
    "asamblasem": "asambla",
    "asamblaseră": "asambla",
    "asamblaserăm": "asambla",
    "asamblaserăți": "asambla",
    "asamblaseși": "asambla",
    "asamblași": "asambla",
    "asamblat": "asambla",
    "asamblați": "asambla",
    "asamblatu": "asambla",
    "asamblau": "asambla",
    "asamblează": "asambla",
    "asamblez": "asambla",
    "asambleze": "asambla",
    "asamblezi": "asambla",
    "neasamblând": "asambla",
    "neasamblându": "asambla",
    "nemaiasamblând": "asambla",
    "nemaiasamblându": "asambla",
    "asamblarea": "asamblare",
    "asamblări": "asamblare",
    "asamblării": "asamblare",
    "asamblările": "asamblare",
    "asamblata": "asamblat",
    "asamblată": "asamblat",
    "asamblate": "asamblat",
    "asamblatei": "asamblat",
    "asamblatele": "asamblat",
    "asamblatelor": "asamblat",
    "asamblați": "asamblat",
    "asamblații": "asamblat",
    "asamblaților": "asamblat",
    "asamblatul": "asamblat",
    "asamblatului": "asamblat",
    "asană": "asana",
    "asanai": "asana",
    "asanam": "asana",
    "asanăm": "asana",
    "asanând": "asana",
    "asanându": "asana",
    "asanară": "asana",
    "asanarăm": "asana",
    "asanarăți": "asana",
    "asanase": "asana",
    "asanasem": "asana",
    "asanaseră": "asana",
    "asanaserăm": "asana",
    "asanaserăți": "asana",
    "asanaseși": "asana",
    "asanași": "asana",
    "asanat": "asana",
    "asanați": "asana",
    "asanatu": "asana",
    "asanau": "asana",
    "asanează": "asana",
    "asanez": "asana",
    "asaneze": "asana",
    "asanezi": "asana",
    "neasanând": "asana",
    "neasanându": "asana",
    "nemaiasanând": "asana",
    "nemaiasanându": "asana",
    "asana": "asană",
    "asane": "asană",
    "asanei": "asană",
    "asanele": "asană",
    "asanelor": "asană",
    "asanarea": "asanare",
    "asanări": "asanare",
    "asanării": "asanare",
    "asanările": "asanare",
    "asanata": "asanat",
    "asanată": "asanat",
    "asanate": "asanat",
    "asanatei": "asanat",
    "asanatele": "asanat",
    "asanatelor": "asanat",
    "asanați": "asanat",
    "asanații": "asanat",
    "asanaților": "asanat",
    "asanatul": "asanat",
    "asanatului": "asanat",
    "așa-numita": "așa-numit",
    "așa-numită": "așa-numit",
    "așa-numite": "așa-numit",
    "așa-numitei": "așa-numit",
    "așa-numitele": "așa-numit",
    "așa-numitelor": "așa-numit",
    "așa-numiți": "așa-numit",
    "așa-numiții": "așa-numit",
    "așa-numiților": "așa-numit",
    "așa-numitul": "așa-numit",
    "așa-numitului": "așa-numit",
    "asasini": "asasin",
    "asasinii": "asasin",
    "asasinilor": "asasin",
    "asasinul": "asasin",
    "asasinului": "asasin",
    "asasină": "asasina",
    "asasinai": "asasina",
    "asasinam": "asasina",
    "asasinăm": "asasina",
    "asasinând": "asasina",
    "asasinându": "asasina",
    "asasinară": "asasina",
    "asasinarăm": "asasina",
    "asasinarăți": "asasina",
    "asasinase": "asasina",
    "asasinasem": "asasina",
    "asasinaseră": "asasina",
    "asasinaserăm": "asasina",
    "asasinaserăți": "asasina",
    "asasinaseși": "asasina",
    "asasinași": "asasina",
    "asasinat": "asasina",
    "asasinați": "asasina",
    "asasinatu": "asasina",
    "asasinau": "asasina",
    "asasinează": "asasina",
    "asasinez": "asasina",
    "asasineze": "asasina",
    "asasinezi": "asasina",
    "neasasinând": "asasina",
    "neasasinându": "asasina",
    "nemaiasasinând": "asasina",
    "nemaiasasinându": "asasina",
    "asasina": "asasină",
    "asasine": "asasină",
    "asasinei": "asasină",
    "asasinele": "asasină",
    "asasinelor": "asasină",
    "asasinarea": "asasinare",
    "asasinări": "asasinare",
    "asasinării": "asasinare",
    "asasinările": "asasinare",
    "asasinata": "asasinat",
    "asasinată": "asasinat",
    "asasinate": "asasinat",
    "asasinatei": "asasinat",
    "asasinatele": "asasinat",
    "asasinatelor": "asasinat",
    "asasinați": "asasinat",
    "asasinații": "asasinat",
    "asasinaților": "asasinat",
    "asasinatul": "asasinat",
    "asasinatului": "asasinat",
    "așa-zisa": "așa-zis",
    "așa-zisă": "așa-zis",
    "așa-zise": "așa-zis",
    "așa-zisei": "așa-zis",
    "așa-zisele": "așa-zis",
    "așa-ziselor": "așa-zis",
    "așa-ziși": "așa-zis",
    "așa-zișii": "așa-zis",
    "așa-zișilor": "așa-zis",
    "așa-zisul": "așa-zis",
    "așa-zisului": "așa-zis",
    "ascendenta": "ascendent",
    "ascendentă": "ascendent",
    "ascendente": "ascendent",
    "ascendentei": "ascendent",
    "ascendentele": "ascendent",
    "ascendentelor": "ascendent",
    "ascendenți": "ascendent",
    "ascendenții": "ascendent",
    "ascendenților": "ascendent",
    "ascendentul": "ascendent",
    "ascendentului": "ascendent",
    "ascendența": "ascendență",
    "ascendențe": "ascendență",
    "ascendenței": "ascendență",
    "ascendențele": "ascendență",
    "ascendențelor": "ascendență",
    "ascensionala": "ascensional",
    "ascensională": "ascensional",
    "ascensionale": "ascensional",
    "ascensionalei": "ascensional",
    "ascensionalele": "ascensional",
    "ascensionalelor": "ascensional",
    "ascensionali": "ascensional",
    "ascensionalii": "ascensional",
    "ascensionalilor": "ascensional",
    "ascensionalul": "ascensional",
    "ascensionalului": "ascensional",
    "ascensiunea": "ascensiune",
    "ascensiuni": "ascensiune",
    "ascensiunii": "ascensiune",
    "ascensiunile": "ascensiune",
    "ascensiunilor": "ascensiune",
    "ascensoare": "ascensor",
    "ascensoarele": "ascensor",
    "ascensoarelor": "ascensor",
    "ascensorul": "ascensor",
    "ascensorului": "ascensor",
    "asceți": "ascet",
    "asceții": "ascet",
    "asceților": "ascet",
    "ascetul": "ascet",
    "ascetului": "ascet",
    "asceta": "ascetă",
    "ascete": "ascetă",
    "ascetei": "ascetă",
    "ascetele": "ascetă",
    "ascetelor": "ascetă",
    "ascetica": "ascetic",
    "ascetică": "ascetic",
    "ascetice": "ascetic",
    "asceticei": "ascetic",
    "asceticele": "ascetic",
    "asceticelor": "ascetic",
    "ascetici": "ascetic",
    "asceticii": "ascetic",
    "asceticilor": "ascetic",
    "asceticul": "ascetic",
    "asceticului": "ascetic",
    "ascetisme": "ascetism",
    "ascetismele": "ascetism",
    "ascetismelor": "ascetism",
    "ascetismul": "ascetism",
    "ascetismului": "ascetism",
    "asceza": "asceză",
    "asceze": "asceză",
    "ascezei": "asceză",
    "ascezele": "asceză",
    "ascezelor": "asceză",
    "așchia": "așchie",
    "așchiei": "așchie",
    "așchii": "așchie",
    "așchiile": "așchie",
    "așchiilor": "așchie",
    "așchioasa": "așchios",
    "așchioasă": "așchios",
    "așchioase": "așchios",
    "așchioasei": "așchios",
    "așchioasele": "așchios",
    "așchioaselor": "așchios",
    "așchioși": "așchios",
    "așchioșii": "așchios",
    "așchioșilor": "așchios",
    "așchiosul": "așchios",
    "așchiosului": "așchios",
    "asclepiade": "asclepiad",
    "asclepiadele": "asclepiad",
    "asclepiadelor": "asclepiad",
    "asclepiadul": "asclepiad",
    "asclepiadului": "asclepiad",
    "asclepiazi": "asclepiad",
    "Asclepiazii": "Asclepiad",
    "asclepiazilor": "asclepiad",
    "ascult": "asculta",
    "ascultă": "asculta",
    "ascultai": "asculta",
    "ascultam": "asculta",
    "ascultăm": "asculta",
    "ascultând": "asculta",
    "ascultându": "asculta",
    "ascultară": "asculta",
    "ascultarăm": "asculta",
    "ascultarăți": "asculta",
    "ascultase": "asculta",
    "ascultasem": "asculta",
    "ascultaseră": "asculta",
    "ascultaserăm": "asculta",
    "ascultaserăți": "asculta",
    "ascultaseși": "asculta",
    "ascultași": "asculta",
    "ascultat": "asculta",
    "ascultați": "asculta",
    "ascultatu": "asculta",
    "ascultau": "asculta",
    "asculte": "asculta",
    "asculți": "asculta",
    "neascultând": "asculta",
    "neascultându": "asculta",
    "nemaiascultând": "asculta",
    "nemaiascultându": "asculta",
    "ascultarea": "ascultare",
    "ascultări": "ascultare",
    "ascultării": "ascultare",
    "ascultările": "ascultare",
    "ascultata": "ascultat",
    "ascultată": "ascultat",
    "ascultate": "ascultat",
    "ascultatei": "ascultat",
    "ascultatele": "ascultat",
    "ascultatelor": "ascultat",
    "ascultați": "ascultat",
    "ascultații": "ascultat",
    "ascultaților": "ascultat",
    "ascultatul": "ascultat",
    "ascultatului": "ascultat",
    "ascultătoarea": "ascultătoare",
    "ascultătoarei": "ascultătoare",
    "ascultătoarele": "ascultătoare",
    "ascultătoarelor": "ascultătoare",
    "ascultătoare": "ascultător",
    "ascultătoarea": "ascultător",
    "ascultătoarei": "ascultător",
    "ascultătoarele": "ascultător",
    "ascultătoarelor": "ascultător",
    "ascultători": "ascultător",
    "ascultătorii": "ascultător",
    "ascultătorilor": "ascultător",
    "ascultătorul": "ascultător",
    "ascultătorului": "ascultător",
    "ascund": "ascunde",
    "ascundă": "ascunde",
    "ascundea": "ascunde",
    "ascundeai": "ascunde",
    "ascundeam": "ascunde",
    "ascundeați": "ascunde",
    "ascundeau": "ascunde",
    "ascundem": "ascunde",
    "ascundeți": "ascunde",
    "ascuns": "ascunde",
    "ascunse": "ascunde",
    "ascunsei": "ascunde",
    "ascunseră": "ascunde",
    "ascunserăm": "ascunde",
    "ascunserăți": "ascunde",
    "ascunsese": "ascunde",
    "ascunsesem": "ascunde",
    "ascunseseră": "ascunde",
    "ascunseserăm": "ascunde",
    "ascunseserăți": "ascunde",
    "ascunseseși": "ascunde",
    "ascunseși": "ascunde",
    "ascunsu": "ascunde",
    "ascunzând": "ascunde",
    "ascunzându": "ascunde",
    "ascunzi": "ascunde",
    "neascunzând": "ascunde",
    "neascunzându": "ascunde",
    "nemaiascunzând": "ascunde",
    "nemaiascunzându": "ascunde",
    "ascunderea": "ascundere",
    "ascunderi": "ascundere",
    "ascunderii": "ascundere",
    "ascunderile": "ascundere",
    "ascunsa": "ascuns",
    "ascunsă": "ascuns",
    "ascunse": "ascuns",
    "ascunsei": "ascuns",
    "ascunsele": "ascuns",
    "ascunselor": "ascuns",
    "ascunși": "ascuns",
    "ascunșii": "ascuns",
    "ascunșilor": "ascuns",
    "ascunsul": "ascuns",
    "ascunsului": "ascuns",
    "ascunzătoarea": "ascunzătoare",
    "ascunzătoarei": "ascunzătoare",
    "ascunzători": "ascunzătoare",
    "ascunzătorile": "ascunzătoare",
    "ascunzătorilor": "ascunzătoare",
    "ascunzișul": "ascunziș",
    "ascunzișului": "ascunziș",
    "ascunzișuri": "ascunziș",
    "ascunzișurile": "ascunziș",
    "ascunzișurilor": "ascunziș",
    "ascut": "ascuți",
    "ascută": "ascuți",
    "ascute": "ascuți",
    "ascuțea": "ascuți",
    "ascuțeai": "ascuți",
    "ascuțeam": "ascuți",
    "ascuțeați": "ascuți",
    "ascuțeau": "ascuți",
    "ascuții": "ascuți",
    "ascuțim": "ascuți",
    "ascuțind": "ascuți",
    "ascuțindu": "ascuți",
    "ascuțiră": "ascuți",
    "ascuțirăm": "ascuți",
    "ascuțirăți": "ascuți",
    "ascuțise": "ascuți",
    "ascuțisem": "ascuți",
    "ascuțiseră": "ascuți",
    "ascuțiserăm": "ascuți",
    "ascuțiserăți": "ascuți",
    "ascuțiseși": "ascuți",
    "ascuțiși": "ascuți",
    "ascuțit": "ascuți",
    "ascuțiți": "ascuți",
    "ascuțitu": "ascuți",
    "neascuțind": "ascuți",
    "neascuțindu": "ascuți",
    "nemaiascuțind": "ascuți",
    "nemaiascuțindu": "ascuți",
    "ascuțimea": "ascuțime",
    "ascuțimi": "ascuțime",
    "ascuțimii": "ascuțime",
    "ascuțimile": "ascuțime",
    "ascuțimilor": "ascuțime",
    "ascuțirea": "ascuțire",
    "ascuțiri": "ascuțire",
    "ascuțirii": "ascuțire",
    "ascuțirile": "ascuțire",
    "ascunși": "ascuțit",
    "ascuțita": "ascuțit",
    "ascuțită": "ascuțit",
    "ascuțite": "ascuțit",
    "ascuțitei": "ascuțit",
    "ascuțitele": "ascuțit",
    "ascuțitelor": "ascuțit",
    "ascuțiți": "ascuțit",
    "ascuțiții": "ascuțit",
    "ascuțiților": "ascuțit",
    "ascuțitul": "ascuțit",
    "ascuțitului": "ascuțit",
    "ascuțitoarea": "ascuțitoare",
    "ascuțitoarei": "ascuțitoare",
    "ascuțitori": "ascuțitoare",
    "ascuțitorile": "ascuțitoare",
    "ascuțitorilor": "ascuțitoare",
    "ascuțitori": "ascuțitor",
    "ascuțitorii": "ascuțitor",
    "ascuțitorilor": "ascuțitor",
    "ascuțitorul": "ascuțitor",
    "ascuțitorului": "ascuțitor",
    "asediai": "asedia",
    "asediam": "asedia",
    "asediară": "asedia",
    "asediarăm": "asedia",
    "asediarăți": "asedia",
    "asediase": "asedia",
    "asediasem": "asedia",
    "asediaseră": "asedia",
    "asediaserăm": "asedia",
    "asediaserăți": "asedia",
    "asediaseși": "asedia",
    "asediași": "asedia",
    "asediat": "asedia",
    "asediați": "asedia",
    "asediatu": "asedia",
    "asediau": "asedia",
    "asediază": "asedia",
    "asedie": "asedia",
    "asediem": "asedia",
    "asediez": "asedia",
    "asedieze": "asedia",
    "asediezi": "asedia",
    "asediind": "asedia",
    "asediindu": "asedia",
    "neasediind": "asedia",
    "neasediindu": "asedia",
    "nemaiasediind": "asedia",
    "nemaiasediindu": "asedia",
    "asediata": "asediat",
    "asediată": "asediat",
    "asediate": "asediat",
    "asediatei": "asediat",
    "asediatele": "asediat",
    "asediatelor": "asediat",
    "asediați": "asediat",
    "asediații": "asediat",
    "asediaților": "asediat",
    "asediatul": "asediat",
    "asediatului": "asediat",
    "asedierea": "asediere",
    "asedieri": "asediere",
    "asedierii": "asediere",
    "asedierile": "asediere",
    "asedii": "asediu",
    "asediile": "asediu",
    "asediilor": "asediu",
    "asediul": "asediu",
    "asediului": "asediu",
    "aseleniză": "aseleniza",
    "aselenizai": "aseleniza",
    "aselenizam": "aseleniza",
    "aselenizăm": "aseleniza",
    "aselenizând": "aseleniza",
    "aselenizară": "aseleniza",
    "aselenizarăm": "aseleniza",
    "aselenizarăți": "aseleniza",
    "aselenizase": "aseleniza",
    "aselenizasem": "aseleniza",
    "aselenizaseră": "aseleniza",
    "aselenizaserăm": "aseleniza",
    "aselenizaserăți": "aseleniza",
    "aselenizaseși": "aseleniza",
    "aselenizași": "aseleniza",
    "aselenizat": "aseleniza",
    "aselenizați": "aseleniza",
    "aselenizau": "aseleniza",
    "aselenizează": "aseleniza",
    "aselenizeze": "aseleniza",
    "aselenizezi": "aseleniza",
    "neaselenizând": "aseleniza",
    "nemaiaselenizând": "aseleniza",
    "aselenizarea": "aselenizare",
    "aselenizări": "aselenizare",
    "aselenizării": "aselenizare",
    "aselenizările": "aselenizare",
    "aselenizata": "aselenizat",
    "aselenizată": "aselenizat",
    "aselenizate": "aselenizat",
    "aselenizatei": "aselenizat",
    "aselenizatele": "aselenizat",
    "aselenizatelor": "aselenizat",
    "aselenizați": "aselenizat",
    "aselenizații": "aselenizat",
    "aselenizaților": "aselenizat",
    "aselenizatul": "aselenizat",
    "aselenizatului": "aselenizat",
    "aseamănă": "asemăna",
    "asemăn": "asemăna",
    "asemănă": "asemăna",
    "asemănai": "asemăna",
    "asemănam": "asemăna",
    "asemănăm": "asemăna",
    "asemănând": "asemăna",
    "asemănându": "asemăna",
    "asemănară": "asemăna",
    "asemănarăm": "asemăna",
    "asemănarăți": "asemăna",
    "asemănase": "asemăna",
    "asemănasem": "asemăna",
    "asemănaseră": "asemăna",
    "asemănaserăm": "asemăna",
    "asemănaserăți": "asemăna",
    "asemănaseși": "asemăna",
    "asemănași": "asemăna",
    "asemănat": "asemăna",
    "asemănați": "asemăna",
    "asemănatu": "asemăna",
    "asemănau": "asemăna",
    "asemene": "asemăna",
    "asemeni": "asemăna",
    "neasemănând": "asemăna",
    "neasemănându": "asemăna",
    "nemaiasemănând": "asemăna",
    "nemaiasemănându": "asemăna",
    "asemănarea": "asemănare",
    "asemănări": "asemănare",
    "asemănării": "asemănare",
    "asemănările": "asemănare",
    "asemănărilor": "asemănare",
    "asemănata": "asemănat",
    "asemănată": "asemănat",
    "asemănate": "asemănat",
    "asemănatei": "asemănat",
    "asemănatele": "asemănat",
    "asemănatelor": "asemănat",
    "asemănați": "asemănat",
    "asemănații": "asemănat",
    "asemănaților": "asemănat",
    "asemănatul": "asemănat",
    "asemănatului": "asemănat",
    "asemănătoare": "asemănător",
    "asemănătoarea": "asemănător",
    "asemănătoarei": "asemănător",
    "asemănătoarele": "asemănător",
    "asemănătoarelor": "asemănător",
    "asemănători": "asemănător",
    "asemănătorii": "asemănător",
    "asemănătorilor": "asemănător",
    "asemănătorul": "asemănător",
    "asemănătorului": "asemănător",
    "asemuia": "asemui",
    "asemuiai": "asemui",
    "asemuiam": "asemui",
    "asemuiască": "asemui",
    "asemuiați": "asemui",
    "asemuiau": "asemui",
    "asemuie": "asemui",
    "asemuiesc": "asemui",
    "asemuiește": "asemui",
    "asemuiești": "asemui",
    "asemuii": "asemui",
    "asemuim": "asemui",
    "asemuind": "asemui",
    "asemuindu": "asemui",
    "asemuiră": "asemui",
    "asemuirăm": "asemui",
    "asemuirăți": "asemui",
    "asemuise": "asemui",
    "asemuisem": "asemui",
    "asemuiseră": "asemui",
    "asemuiserăm": "asemui",
    "asemuiserăți": "asemui",
    "asemuiseși": "asemui",
    "asemuiși": "asemui",
    "asemuit": "asemui",
    "asemuiți": "asemui",
    "asemuitu": "asemui",
    "neasemuind": "asemui",
    "neasemuindu": "asemui",
    "nemaiasemuind": "asemui",
    "nemaiasemuindu": "asemui",
    "asemuirea": "asemuire",
    "asemuiri": "asemuire",
    "asemuirii": "asemuire",
    "asemuirile": "asemuire",
    "asemuirilor": "asemuire",
    "asemuita": "asemuit",
    "asemuită": "asemuit",
    "asemuite": "asemuit",
    "asemuitei": "asemuit",
    "asemuitele": "asemuit",
    "asemuitelor": "asemuit",
    "asemuiți": "asemuit",
    "asemuiții": "asemuit",
    "asemuiților": "asemuit",
    "asemuitul": "asemuit",
    "asemuitului": "asemuit",
    "asentimente": "asentiment",
    "asentimentele": "asentiment",
    "asentimentelor": "asentiment",
    "asentimentul": "asentiment",
    "asentimentului": "asentiment",
    "aseptica": "aseptic",
    "aseptică": "aseptic",
    "aseptice": "aseptic",
    "asepticei": "aseptic",
    "asepticele": "aseptic",
    "asepticelor": "aseptic",
    "aseptici": "aseptic",
    "asepticii": "aseptic",
    "asepticilor": "aseptic",
    "asepticul": "aseptic",
    "asepticului": "aseptic",
    "aserțiunea": "aserțiune",
    "aserțiuni": "aserțiune",
    "aserțiunii": "aserțiune",
    "aserțiunile": "aserțiune",
    "aserțiunilor": "aserțiune",
    "asertorica": "asertoric",
    "asertorică": "asertoric",
    "asertorice": "asertoric",
    "asertoricei": "asertoric",
    "asertoricele": "asertoric",
    "asertoricelor": "asertoric",
    "asertorici": "asertoric",
    "asertoricii": "asertoric",
    "asertoricilor": "asertoric",
    "asertoricul": "asertoric",
    "asertoricului": "asertoric",
    "aservea": "aservi",
    "aserveai": "aservi",
    "aserveam": "aservi",
    "aservească": "aservi",
    "aserveați": "aservi",
    "aserveau": "aservi",
    "aservesc": "aservi",
    "aservește": "aservi",
    "aservești": "aservi",
    "aservii": "aservi",
    "aservim": "aservi",
    "aservind": "aservi",
    "aservindu": "aservi",
    "aserviră": "aservi",
    "aservirăm": "aservi",
    "aservirăți": "aservi",
    "aservise": "aservi",
    "aservisem": "aservi",
    "aserviseră": "aservi",
    "aserviserăm": "aservi",
    "aserviserăți": "aservi",
    "aserviseși": "aservi",
    "aserviși": "aservi",
    "aservit": "aservi",
    "aserviți": "aservi",
    "aservitu": "aservi",
    "neaservind": "aservi",
    "neaservindu": "aservi",
    "nemaiaservind": "aservi",
    "nemaiaservindu": "aservi",
    "aservirea": "aservire",
    "aserviri": "aservire",
    "aservirii": "aservire",
    "aservirile": "aservire",
    "aservita": "aservit",
    "aservită": "aservit",
    "aservite": "aservit",
    "aservitei": "aservit",
    "aservitele": "aservit",
    "aservitelor": "aservit",
    "aserviți": "aservit",
    "aserviții": "aservit",
    "aserviților": "aservit",
    "aservitul": "aservit",
    "aservitului": "aservit",
    "aservita": "aservită",
    "aservite": "aservită",
    "aservitei": "aservită",
    "aservitele": "aservită",
    "aservitelor": "aservită",
    "asesoarea": "asesoare",
    "asesoarei": "asesoare",
    "asesoarele": "asesoare",
    "asesoarelor": "asesoare",
    "asesori": "asesor",
    "asesorii": "asesor",
    "asesorilor": "asesor",
    "asesorul": "asesor",
    "asesorului": "asesor",
    "asexuata": "asexuat",
    "asexuată": "asexuat",
    "asexuate": "asexuat",
    "asexuatei": "asexuat",
    "asexuatele": "asexuat",
    "asexuatelor": "asexuat",
    "asexuați": "asexuat",
    "asexuații": "asexuat",
    "asexuaților": "asexuat",
    "asexuatul": "asexuat",
    "asexuatului": "asexuat",
    "așază": "așeza",
    "așează": "așeza",
    "așez": "așeza",
    "așeză": "așeza",
    "așezai": "așeza",
    "așezam": "așeza",
    "așezăm": "așeza",
    "așezând": "așeza",
    "așezându": "așeza",
    "așezară": "așeza",
    "așezarăm": "așeza",
    "așezarăți": "așeza",
    "așezase": "așeza",
    "așezasem": "așeza",
    "așezaseră": "așeza",
    "așezaserăm": "așeza",
    "așezaserăți": "așeza",
    "așezaseși": "așeza",
    "așezași": "așeza",
    "așezat": "așeza",
    "așezați": "așeza",
    "așezatu": "așeza",
    "așezau": "așeza",
    "așeze": "așeza",
    "așezi": "așeza",
    "neașezând": "așeza",
    "neașezându": "așeza",
    "nemaiașezând": "așeza",
    "nemaiașezându": "așeza",
    "așezământul": "așezământ",
    "așezământului": "așezământ",
    "așezăminte": "așezământ",
    "așezămintele": "așezământ",
    "așezămintelor": "așezământ",
    "așezarea": "așezare",
    "așezări": "așezare",
    "așezării": "așezare",
    "așezările": "așezare",
    "așezata": "așezat",
    "așezată": "așezat",
    "așezate": "așezat",
    "așezatei": "așezat",
    "așezatele": "așezat",
    "așezatelor": "așezat",
    "așezați": "așezat",
    "așezații": "așezat",
    "așezaților": "așezat",
    "așezatul": "așezat",
    "așezatului": "așezat",
    "asezonă": "asezona",
    "asezonai": "asezona",
    "asezonam": "asezona",
    "asezonăm": "asezona",
    "asezonând": "asezona",
    "asezonându": "asezona",
    "asezonară": "asezona",
    "asezonarăm": "asezona",
    "asezonarăți": "asezona",
    "asezonase": "asezona",
    "asezonasem": "asezona",
    "asezonaseră": "asezona",
    "asezonaserăm": "asezona",
    "asezonaserăți": "asezona",
    "asezonaseși": "asezona",
    "asezonași": "asezona",
    "asezonat": "asezona",
    "asezonați": "asezona",
    "asezonatu": "asezona",
    "asezonau": "asezona",
    "asezonează": "asezona",
    "asezonez": "asezona",
    "asezoneze": "asezona",
    "asezonezi": "asezona",
    "neasezonând": "asezona",
    "neasezonându": "asezona",
    "nemaiasezonând": "asezona",
    "nemaiasezonându": "asezona",
    "asezonarea": "asezonare",
    "asezonări": "asezonare",
    "asezonării": "asezonare",
    "asezonările": "asezonare",
    "asezonata": "asezonat",
    "asezonată": "asezonat",
    "asezonate": "asezonat",
    "asezonatei": "asezonat",
    "asezonatele": "asezonat",
    "asezonatelor": "asezonat",
    "asezonați": "asezonat",
    "asezonații": "asezonat",
    "asezonaților": "asezonat",
    "asezonatul": "asezonat",
    "asezonatului": "asezonat",
    "asfaltul": "asfalt",
    "asfaltului": "asfalt",
    "asfalturi": "asfalt",
    "asfalturile": "asfalt",
    "asfalturilor": "asfalt",
    "asfaltica": "asfaltic",
    "asfaltică": "asfaltic",
    "asfaltice": "asfaltic",
    "asfalticei": "asfaltic",
    "asfalticele": "asfaltic",
    "asfalticelor": "asfaltic",
    "asfaltici": "asfaltic",
    "asfalticii": "asfaltic",
    "asfalticilor": "asfaltic",
    "asfalticul": "asfaltic",
    "asfalticului": "asfaltic",
    "asfințita": "asfințit",
    "asfințită": "asfințit",
    "asfințite": "asfințit",
    "asfințitei": "asfințit",
    "asfințitele": "asfințit",
    "asfințitelor": "asfințit",
    "asfințiți": "asfințit",
    "asfințiții": "asfințit",
    "asfințiților": "asfințit",
    "asfințitul": "asfințit",
    "asfințitului": "asfințit",
    "asfințituri": "asfințit",
    "asfințiturile": "asfințit",
    "asfințiturilor": "asfințit",
    "asfixiai": "asfixia",
    "asfixiam": "asfixia",
    "asfixiară": "asfixia",
    "asfixiarăm": "asfixia",
    "asfixiarăți": "asfixia",
    "asfixiase": "asfixia",
    "asfixiasem": "asfixia",
    "asfixiaseră": "asfixia",
    "asfixiaserăm": "asfixia",
    "asfixiaserăți": "asfixia",
    "asfixiaseși": "asfixia",
    "asfixiași": "asfixia",
    "asfixiat": "asfixia",
    "asfixiați": "asfixia",
    "asfixiau": "asfixia",
    "asfixiază": "asfixia",
    "asfixie": "asfixia",
    "asfixiem": "asfixia",
    "asfixiez": "asfixia",
    "asfixieze": "asfixia",
    "asfixiezi": "asfixia",
    "asfixiind": "asfixia",
    "neasfixiind": "asfixia",
    "nemaiasfixiind": "asfixia",
    "asfixianta": "asfixiant",
    "asfixiantă": "asfixiant",
    "asfixiante": "asfixiant",
    "asfixiantei": "asfixiant",
    "asfixiantele": "asfixiant",
    "asfixiantelor": "asfixiant",
    "asfixianți": "asfixiant",
    "asfixianții": "asfixiant",
    "asfixianților": "asfixiant",
    "asfixiantul": "asfixiant",
    "asfixiantului": "asfixiant",
    "asfixiata": "asfixiat",
    "asfixiată": "asfixiat",
    "asfixiate": "asfixiat",
    "asfixiatei": "asfixiat",
    "asfixiatele": "asfixiat",
    "asfixiatelor": "asfixiat",
    "asfixiați": "asfixiat",
    "asfixiații": "asfixiat",
    "asfixiaților": "asfixiat",
    "asfixiatul": "asfixiat",
    "asfixiatului": "asfixiat",
    "asfixiata": "asfixiată",
    "asfixiate": "asfixiată",
    "asfixiatei": "asfixiată",
    "asfixiatele": "asfixiată",
    "asfixiatelor": "asfixiată",
    "asfixiatul": "asfixiată",
    "asfixiatului": "asfixiată",
    "asfixia": "asfixie",
    "asfixiei": "asfixie",
    "asfixii": "asfixie",
    "asfixiile": "asfixie",
    "asfixiilor": "asfixie",
    "asfixierea": "asfixiere",
    "asfixieri": "asfixiere",
    "asfixierii": "asfixiere",
    "asfixierile": "asfixiere",
    "Asie": "Asia",
    "Asiei": "Asia",
    "Asii": "Asia",
    "asiatica": "asiatic",
    "asiatică": "asiatic",
    "asiatice": "asiatic",
    "asiaticei": "asiatic",
    "asiaticele": "asiatic",
    "asiaticelor": "asiatic",
    "asiatici": "asiatic",
    "asiaticii": "asiatic",
    "asiaticilor": "asiatic",
    "asiaticul": "asiatic",
    "asiaticului": "asiatic",
    "asiatica": "asiatică",
    "asiatice": "asiatică",
    "asiaticei": "asiatică",
    "asiaticele": "asiatică",
    "asiaticelor": "asiatică",
    "asiduitatea": "asiduitate",
    "asiduități": "asiduitate",
    "asiduității": "asiduitate",
    "asiduitățile": "asiduitate",
    "asiduităților": "asiduitate",
    "asidua": "asiduu",
    "asiduă": "asiduu",
    "asidue": "asiduu",
    "asiduei": "asiduu",
    "asiduele": "asiduu",
    "asiduelor": "asiduu",
    "asidui": "asiduu",
    "asiduii": "asiduu",
    "asiduilor": "asiduu",
    "asiduul": "asiduu",
    "asiduului": "asiduu",
    "asigur": "asigura",
    "asigură": "asigura",
    "asigurai": "asigura",
    "asiguram": "asigura",
    "asigurăm": "asigura",
    "asigurând": "asigura",
    "asigurându": "asigura",
    "asigurară": "asigura",
    "asigurarăm": "asigura",
    "asigurarăți": "asigura",
    "asigurase": "asigura",
    "asigurasem": "asigura",
    "asiguraseră": "asigura",
    "asiguraserăm": "asigura",
    "asiguraserăți": "asigura",
    "asiguraseși": "asigura",
    "asigurași": "asigura",
    "asigurat": "asigura",
    "asigurați": "asigura",
    "asiguratu": "asigura",
    "asigurau": "asigura",
    "asigure": "asigura",
    "asiguri": "asigura",
    "neasigurând": "asigura",
    "neasigurându": "asigura",
    "nemaiasigurând": "asigura",
    "nemaiasigurându": "asigura",
    "asigurarea": "asigurare",
    "asigurări": "asigurare",
    "asigurării": "asigurare",
    "asigurările": "asigurare",
    "asigurărilor": "asigurare",
    "asigurata": "asigurat",
    "asigurată": "asigurat",
    "asigurate": "asigurat",
    "asiguratei": "asigurat",
    "asiguratele": "asigurat",
    "asiguratelor": "asigurat",
    "asigurați": "asigurat",
    "asigurații": "asigurat",
    "asiguraților": "asigurat",
    "asiguratul": "asigurat",
    "asiguratului": "asigurat",
    "asigurata": "asigurată",
    "asigurate": "asigurată",
    "asiguratei": "asigurată",
    "asiguratele": "asigurată",
    "asiguratelor": "asigurată",
    "asigurătoare": "asigurător",
    "asigurătoarea": "asigurător",
    "asigurătoarei": "asigurător",
    "asigurătoarele": "asigurător",
    "asigurătoarelor": "asigurător",
    "asigurători": "asigurător",
    "asigurătorii": "asigurător",
    "asigurătorilor": "asigurător",
    "asigurătorul": "asigurător",
    "asigurătorului": "asigurător",
    "asimetrica": "asimetric",
    "asimetrică": "asimetric",
    "asimetrice": "asimetric",
    "asimetricei": "asimetric",
    "asimetricele": "asimetric",
    "asimetricelor": "asimetric",
    "asimetrici": "asimetric",
    "asimetricii": "asimetric",
    "asimetricilor": "asimetric",
    "asimetricul": "asimetric",
    "asimetricului": "asimetric",
    "asimilă": "asimila",
    "asimilai": "asimila",
    "asimilam": "asimila",
    "asimilăm": "asimila",
    "asimilând": "asimila",
    "asimilându": "asimila",
    "asimilară": "asimila",
    "asimilarăm": "asimila",
    "asimilarăți": "asimila",
    "asimilase": "asimila",
    "asimilasem": "asimila",
    "asimilaseră": "asimila",
    "asimilaserăm": "asimila",
    "asimilaserăți": "asimila",
    "asimilaseși": "asimila",
    "asimilași": "asimila",
    "asimilat": "asimila",
    "asimilați": "asimila",
    "asimilatu": "asimila",
    "asimilau": "asimila",
    "asimilează": "asimila",
    "asimilez": "asimila",
    "asimileze": "asimila",
    "asimilezi": "asimila",
    "neasimilând": "asimila",
    "neasimilându": "asimila",
    "nemaiasimilând": "asimila",
    "nemaiasimilându": "asimila",
    "asimilabilă": "asimilabil",
    "asimilabile": "asimilabil",
    "asimilabili": "asimilabil",
    "asimilarea": "asimilare",
    "asimilări": "asimilare",
    "asimilării": "asimilare",
    "asimilările": "asimilare",
    "asimilata": "asimilat",
    "asimilată": "asimilat",
    "asimilate": "asimilat",
    "asimilatei": "asimilat",
    "asimilatele": "asimilat",
    "asimilatelor": "asimilat",
    "asimilați": "asimilat",
    "asimilații": "asimilat",
    "asimilaților": "asimilat",
    "asimilatul": "asimilat",
    "asimilatului": "asimilat",
    "asimilația": "asimilație",
    "asimilației": "asimilație",
    "asimilații": "asimilație",
    "asimilațiile": "asimilație",
    "asimilațiilor": "asimilație",
    "asini": "asin",
    "asinii": "asin",
    "asinilor": "asin",
    "asinul": "asin",
    "asinului": "asin",
    "asiriana": "asirian",
    "asiriană": "asirian",
    "asirianul": "asirian",
    "asirianului": "asirian",
    "asiriene": "asirian",
    "asirienei": "asirian",
    "asirienele": "asirian",
    "asirienelor": "asirian",
    "asirieni": "asirian",
    "asirienii": "asirian",
    "asirienilor": "asirian",
    "asist": "asista",
    "asistă": "asista",
    "asistai": "asista",
    "asistam": "asista",
    "asistăm": "asista",
    "asistând": "asista",
    "asistându": "asista",
    "asistară": "asista",
    "asistarăm": "asista",
    "asistarăți": "asista",
    "asistase": "asista",
    "asistasem": "asista",
    "asistaseră": "asista",
    "asistaserăm": "asista",
    "asistaserăți": "asista",
    "asistaseși": "asista",
    "asistași": "asista",
    "asistat": "asista",
    "asistați": "asista",
    "asistatu": "asista",
    "asistau": "asista",
    "asiste": "asista",
    "asiști": "asista",
    "neasistând": "asista",
    "neasistându": "asista",
    "nemaiasistând": "asista",
    "nemaiasistându": "asista",
    "asistarea": "asistare",
    "asistări": "asistare",
    "asistării": "asistare",
    "asistările": "asistare",
    "asistata": "asistat",
    "asistată": "asistat",
    "asistate": "asistat",
    "asistatei": "asistat",
    "asistatele": "asistat",
    "asistatelor": "asistat",
    "asistați": "asistat",
    "asistații": "asistat",
    "asistaților": "asistat",
    "asistatul": "asistat",
    "asistatului": "asistat",
    "asist.": "asistent",
    "asistenta": "asistent",
    "asistentă": "asistent",
    "asistente": "asistent",
    "asistentei": "asistent",
    "asistentele": "asistent",
    "asistentelor": "asistent",
    "asistenți": "asistent",
    "asistenții": "asistent",
    "asistenților": "asistent",
    "asistentul": "asistent",
    "asistentului": "asistent",
    "asistenta": "asistentă",
    "asistente": "asistentă",
    "asistentei": "asistentă",
    "asistentele": "asistentă",
    "asistentelor": "asistentă",
    "asistența": "asistență",
    "asistențe": "asistență",
    "asistenței": "asistență",
    "asistențele": "asistență",
    "asistențelor": "asistență",
    "asmut": "asmuți",
    "asmută": "asmuți",
    "asmute": "asmuți",
    "asmuțea": "asmuți",
    "asmuțeai": "asmuți",
    "asmuțeam": "asmuți",
    "asmuțeați": "asmuți",
    "asmuțeau": "asmuți",
    "asmuții": "asmuți",
    "asmuțim": "asmuți",
    "asmuțind": "asmuți",
    "asmuțindu": "asmuți",
    "asmuțiră": "asmuți",
    "asmuțirăm": "asmuți",
    "asmuțirăți": "asmuți",
    "asmuțise": "asmuți",
    "asmuțisem": "asmuți",
    "asmuțiseră": "asmuți",
    "asmuțiserăm": "asmuți",
    "asmuțiserăți": "asmuți",
    "asmuțiseși": "asmuți",
    "asmuțiși": "asmuți",
    "asmuțit": "asmuți",
    "asmuțiți": "asmuți",
    "asmuțitu": "asmuți",
    "neasmuțind": "asmuți",
    "neasmuțindu": "asmuți",
    "nemaiasmuțind": "asmuți",
    "nemaiasmuțindu": "asmuți",
    "asmuțirea": "asmuțire",
    "asmuțiri": "asmuțire",
    "asmuțirii": "asmuțire",
    "asmuțirile": "asmuțire",
    "asmuțita": "asmuțit",
    "asmuțită": "asmuțit",
    "asmuțite": "asmuțit",
    "asmuțitei": "asmuțit",
    "asmuțitele": "asmuțit",
    "asmuțitelor": "asmuțit",
    "asmuțiți": "asmuțit",
    "asmuțiții": "asmuțit",
    "asmuțiților": "asmuțit",
    "asmuțitul": "asmuțit",
    "asmuțitului": "asmuțit",
    "asociai": "asocia",
    "asociam": "asocia",
    "asociară": "asocia",
    "asociarăm": "asocia",
    "asociarăți": "asocia",
    "asociase": "asocia",
    "asociasem": "asocia",
    "asociaseră": "asocia",
    "asociaserăm": "asocia",
    "asociaserăți": "asocia",
    "asociaseși": "asocia",
    "asociași": "asocia",
    "asociat": "asocia",
    "asociați": "asocia",
    "asociatu": "asocia",
    "asociau": "asocia",
    "asociază": "asocia",
    "asocie": "asocia",
    "asociem": "asocia",
    "asociez": "asocia",
    "asocieze": "asocia",
    "asociezi": "asocia",
    "asociind": "asocia",
    "asociindu": "asocia",
    "neasociind": "asocia",
    "neasociindu": "asocia",
    "nemaiasociind": "asocia",
    "nemaiasociindu": "asocia",
    "asociata": "asociat",
    "asociată": "asociat",
    "asociate": "asociat",
    "asociatei": "asociat",
    "asociatele": "asociat",
    "asociatelor": "asociat",
    "asociați": "asociat",
    "asociații": "asociat",
    "asociaților": "asociat",
    "asociatu": "asociat",
    "asociatul": "asociat",
    "asociatului": "asociat",
    "asociata": "asociată",
    "asociate": "asociată",
    "asociatei": "asociată",
    "asociatele": "asociată",
    "asociatelor": "asociată",
    "asociația": "asociație",
    "asociației": "asociație",
    "asociații": "asociație",
    "asociațiile": "asociație",
    "asociațiilor": "asociație",
    "asociaționista": "asociaționist",
    "asociaționistă": "asociaționist",
    "asociaționiste": "asociaționist",
    "asociaționistei": "asociaționist",
    "asociaționistele": "asociaționist",
    "asociaționistelor": "asociaționist",
    "asociaționiști": "asociaționist",
    "asociaționiștii": "asociaționist",
    "asociaționiștilor": "asociaționist",
    "asociaționistul": "asociaționist",
    "asociaționistului": "asociaționist",
    "asociativa": "asociativ",
    "asociativă": "asociativ",
    "asociative": "asociativ",
    "asociativei": "asociativ",
    "asociativele": "asociativ",
    "asociativelor": "asociativ",
    "asociativi": "asociativ",
    "asociativii": "asociativ",
    "asociativilor": "asociativ",
    "asociativul": "asociativ",
    "asociativului": "asociativ",
    "asocierea": "asociere",
    "asocieri": "asociere",
    "asocierii": "asociere",
    "asocierile": "asociere",
    "asonanța": "asonanță",
    "asonanțe": "asonanță",
    "asonanței": "asonanță",
    "asonanțele": "asonanță",
    "asonanțelor": "asonanță",
    "asortă": "asorta",
    "asortai": "asorta",
    "asortam": "asorta",
    "asortăm": "asorta",
    "asortând": "asorta",
    "asortară": "asorta",
    "asortarăm": "asorta",
    "asortarăți": "asorta",
    "asortase": "asorta",
    "asortasem": "asorta",
    "asortaseră": "asorta",
    "asortaserăm": "asorta",
    "asortaserăți": "asorta",
    "asortaseși": "asorta",
    "asortași": "asorta",
    "asortat": "asorta",
    "asortați": "asorta",
    "asortau": "asorta",
    "asortează": "asorta",
    "asortez": "asorta",
    "asorteze": "asorta",
    "asortezi": "asorta",
    "neasortând": "asorta",
    "nemaiasortând": "asorta",
    "asortarea": "asortare",
    "asortări": "asortare",
    "asortării": "asortare",
    "asortările": "asortare",
    "asortata": "asortat",
    "asortată": "asortat",
    "asortate": "asortat",
    "asortatei": "asortat",
    "asortatele": "asortat",
    "asortatelor": "asortat",
    "asortați": "asortat",
    "asortații": "asortat",
    "asortaților": "asortat",
    "asortatul": "asortat",
    "asortatului": "asortat",
    "asortimente": "asortiment",
    "asortimentele": "asortiment",
    "asortimentelor": "asortiment",
    "asortimentul": "asortiment",
    "asortimentului": "asortiment",
    "aspecte": "aspect",
    "aspectele": "aspect",
    "aspectelor": "aspect",
    "aspectul": "aspect",
    "aspectului": "aspect",
    "aspectuoasa": "aspectuos",
    "aspectuoasă": "aspectuos",
    "aspectuoase": "aspectuos",
    "aspectuoasei": "aspectuos",
    "aspectuoasele": "aspectuos",
    "aspectuoaselor": "aspectuos",
    "aspectuoși": "aspectuos",
    "aspectuoșii": "aspectuos",
    "aspectuoșilor": "aspectuos",
    "aspectuosul": "aspectuos",
    "aspectuosului": "aspectuos",
    "asperitatea": "asperitate",
    "asperități": "asperitate",
    "asperității": "asperitate",
    "asperitățile": "asperitate",
    "asperităților": "asperitate",
    "aspersiunea": "aspersiune",
    "aspersiuni": "aspersiune",
    "aspersiunii": "aspersiune",
    "aspersiunile": "aspersiune",
    "aspersiunilor": "aspersiune",
    "aspicul": "aspic",
    "aspicului": "aspic",
    "aspicuri": "aspic",
    "aspicurile": "aspic",
    "aspicurilor": "aspic",
    "aspida": "aspidă",
    "aspide": "aspidă",
    "aspidei": "aspidă",
    "aspidele": "aspidă",
    "aspidelor": "aspidă",
    "aspir": "aspira",
    "aspiră": "aspira",
    "aspirai": "aspira",
    "aspiram": "aspira",
    "aspirăm": "aspira",
    "aspirând": "aspira",
    "aspirându": "aspira",
    "aspirară": "aspira",
    "aspirarăm": "aspira",
    "aspirarăți": "aspira",
    "aspirase": "aspira",
    "aspirasem": "aspira",
    "aspiraseră": "aspira",
    "aspiraserăm": "aspira",
    "aspiraserăți": "aspira",
    "aspiraseși": "aspira",
    "aspirași": "aspira",
    "aspirat": "aspira",
    "aspirați": "aspira",
    "aspiratu": "aspira",
    "aspirau": "aspira",
    "aspire": "aspira",
    "aspiri": "aspira",
    "neaspirând": "aspira",
    "neaspirându": "aspira",
    "nemaiaspirând": "aspira",
    "nemaiaspirându": "aspira",
    "aspiranta": "aspirant",
    "aspirantă": "aspirant",
    "aspirante": "aspirant",
    "aspirantei": "aspirant",
    "aspirantele": "aspirant",
    "aspirantelor": "aspirant",
    "aspiranți": "aspirant",
    "aspiranții": "aspirant",
    "aspiranților": "aspirant",
    "aspirantul": "aspirant",
    "aspirantului": "aspirant",
    "aspirarea": "aspirare",
    "aspirări": "aspirare",
    "aspirării": "aspirare",
    "aspirările": "aspirare",
    "aspirata": "aspirat",
    "aspirată": "aspirat",
    "aspirate": "aspirat",
    "aspiratei": "aspirat",
    "aspiratele": "aspirat",
    "aspiratelor": "aspirat",
    "aspirați": "aspirat",
    "aspirații": "aspirat",
    "aspiraților": "aspirat",
    "aspiratul": "aspirat",
    "aspiratului": "aspirat",
    "aspirația": "aspirație",
    "aspirației": "aspirație",
    "aspirații": "aspirație",
    "aspirațiile": "aspirație",
    "aspirațiilor": "aspirație",
    "aspiratoare": "aspirator",
    "aspiratoarea": "aspirator",
    "aspiratoarei": "aspirator",
    "aspiratoarele": "aspirator",
    "aspiratoarelor": "aspirator",
    "aspiratori": "aspirator",
    "aspiratorii": "aspirator",
    "aspiratorilor": "aspirator",
    "aspiratorul": "aspirator",
    "aspiratorului": "aspirator",
    "asprea": "aspri",
    "aspreai": "aspri",
    "aspream": "aspri",
    "asprească": "aspri",
    "aspreați": "aspri",
    "aspreau": "aspri",
    "aspresc": "aspri",
    "asprește": "aspri",
    "asprești": "aspri",
    "asprii": "aspri",
    "asprim": "aspri",
    "asprind": "aspri",
    "asprindu": "aspri",
    "aspriră": "aspri",
    "asprirăm": "aspri",
    "asprirăți": "aspri",
    "asprise": "aspri",
    "asprisem": "aspri",
    "aspriseră": "aspri",
    "aspriserăm": "aspri",
    "aspriserăți": "aspri",
    "aspriseși": "aspri",
    "aspriși": "aspri",
    "asprit": "aspri",
    "aspriți": "aspri",
    "aspritu": "aspri",
    "asprimea": "asprime",
    "asprimi": "asprime",
    "asprimii": "asprime",
    "asprimile": "asprime",
    "asprimilor": "asprime",
    "asprita": "asprit",
    "asprită": "asprit",
    "asprite": "asprit",
    "aspritei": "asprit",
    "aspritele": "asprit",
    "aspritelor": "asprit",
    "aspriți": "asprit",
    "aspriții": "asprit",
    "aspriților": "asprit",
    "aspritul": "asprit",
    "aspritului": "asprit",
    "aspra": "aspru",
    "aspră": "aspru",
    "aspre": "aspru",
    "asprei": "aspru",
    "asprele": "aspru",
    "asprelor": "aspru",
    "aspri": "aspru",
    "asprii": "aspru",
    "asprilor": "aspru",
    "asprul": "aspru",
    "asprului": "aspru",
    "astă": "ăst",
    "aste": "ăst",
    "ăstei": "ăst",
    "ăști": "ăst",
    "ăstor": "ăst",
    "ăstui": "ăst",
    "ast": "asta",
    "ast-": "ăsta",
    "asta": "ăsta",
    "astea": "ăsta",
    "ăsteia": "ăsta",
    "ăștia": "ăsta",
    "ăstora": "ăsta",
    "ăstuia": "ăsta",
    "astâmpărul": "astâmpăr",
    "astâmpărului": "astâmpăr",
    "astâmpăr": "astâmpăra",
    "astâmpără": "astâmpăra",
    "astâmpărai": "astâmpăra",
    "astâmpăram": "astâmpăra",
    "astâmpărăm": "astâmpăra",
    "astâmpărând": "astâmpăra",
    "astâmpărându": "astâmpăra",
    "astâmpărară": "astâmpăra",
    "astâmpărarăm": "astâmpăra",
    "astâmpărarăți": "astâmpăra",
    "astâmpărase": "astâmpăra",
    "astâmpărasem": "astâmpăra",
    "astâmpăraseră": "astâmpăra",
    "astâmpăraserăm": "astâmpăra",
    "astâmpăraserăți": "astâmpăra",
    "astâmpăraseși": "astâmpăra",
    "astâmpărași": "astâmpăra",
    "astâmpărat": "astâmpăra",
    "astâmpărați": "astâmpăra",
    "astâmpăratu": "astâmpăra",
    "astâmpărau": "astâmpăra",
    "astâmpăre": "astâmpăra",
    "astâmpere": "astâmpăra",
    "astâmperi": "astâmpăra",
    "astâmpărarea": "astâmpărare",
    "astâmpărări": "astâmpărare",
    "astâmpărării": "astâmpărare",
    "astâmpărările": "astâmpărare",
    "astâmpărărilor": "astâmpărare",
    "astâmpărată": "astâmpărat",
    "astâmpărate": "astâmpărat",
    "astâmpărați": "astâmpărat",
    "astenica": "astenic",
    "astenică": "astenic",
    "astenice": "astenic",
    "astenicei": "astenic",
    "astenicele": "astenic",
    "astenicelor": "astenic",
    "astenici": "astenic",
    "astenicii": "astenic",
    "astenicilor": "astenic",
    "astenicul": "astenic",
    "astenicului": "astenic",
    "astenia": "astenie",
    "asteniei": "astenie",
    "astenii": "astenie",
    "asteniile": "astenie",
    "asteniilor": "astenie",
    "așteaptă": "aștepta",
    "aștept": "aștepta",
    "așteptă": "aștepta",
    "așteptai": "aștepta",
    "așteptam": "aștepta",
    "așteptăm": "aștepta",
    "așteptând": "aștepta",
    "așteptându": "aștepta",
    "așteptară": "aștepta",
    "așteptarăm": "aștepta",
    "așteptarăți": "aștepta",
    "așteptase": "aștepta",
    "așteptasem": "aștepta",
    "așteptaseră": "aștepta",
    "așteptaserăm": "aștepta",
    "așteptaserăți": "aștepta",
    "așteptaseși": "aștepta",
    "așteptași": "aștepta",
    "așteptat": "aștepta",
    "așteptați": "aștepta",
    "așteptatu": "aștepta",
    "așteptau": "aștepta",
    "aștepte": "aștepta",
    "aștepți": "aștepta",
    "neașteptând": "aștepta",
    "neașteptându": "aștepta",
    "nemaiașteptând": "aștepta",
    "nemaiașteptându": "aștepta",
    "așteptarea": "așteptare",
    "așteptări": "așteptare",
    "așteptării": "așteptare",
    "așteptările": "așteptare",
    "așteptărilor": "așteptare",
    "așteptata": "așteptat",
    "așteptată": "așteptat",
    "așteptate": "așteptat",
    "așteptatei": "așteptat",
    "așteptatele": "așteptat",
    "așteptatelor": "așteptat",
    "așteptați": "așteptat",
    "așteptații": "așteptat",
    "așteptaților": "așteptat",
    "așteptatul": "așteptat",
    "așteptatului": "așteptat",
    "asteriscul": "asterisc",
    "asteriscului": "asterisc",
    "asteriscuri": "asterisc",
    "asteriscurile": "asterisc",
    "asteriscurilor": "asterisc",
    "aștearnă": "așterne",
    "aștern": "așterne",
    "așternând": "așterne",
    "așternându": "așterne",
    "așternea": "așterne",
    "așterneai": "așterne",
    "așterneam": "așterne",
    "așterneați": "așterne",
    "așterneau": "așterne",
    "așternem": "așterne",
    "așterneți": "așterne",
    "așterni": "așterne",
    "așternu": "așterne",
    "așternui": "așterne",
    "așternură": "așterne",
    "așternurăm": "așterne",
    "așternurăți": "așterne",
    "așternuse": "așterne",
    "așternusem": "așterne",
    "așternuseră": "așterne",
    "așternuserăm": "așterne",
    "așternuserăți": "așterne",
    "așternuseși": "așterne",
    "așternuși": "așterne",
    "așternut": "așterne",
    "așternutu": "așterne",
    "neașternând": "așterne",
    "neașternându": "așterne",
    "nemaiașternând": "așterne",
    "nemaiașternându": "așterne",
    "așternerea": "așternere",
    "așterneri": "așternere",
    "așternerii": "așternere",
    "așternerile": "așternere",
    "așternuta": "așternut",
    "așternută": "așternut",
    "așternute": "așternut",
    "așternutei": "așternut",
    "așternutele": "așternut",
    "așternutelor": "așternut",
    "așternuți": "așternut",
    "așternuții": "așternut",
    "așternuților": "așternut",
    "așternutul": "așternut",
    "așternutului": "așternut",
    "așternuturi": "așternut",
    "așternuturile": "așternut",
    "așternuturilor": "așternut",
    "asteroidul": "asteroid",
    "asteroidului": "asteroid",
    "asteroizi": "asteroid",
    "asteroizii": "asteroid",
    "asteroizilor": "asteroid",
    "astigmatica": "astigmatic",
    "astigmatică": "astigmatic",
    "astigmatice": "astigmatic",
    "astigmaticei": "astigmatic",
    "astigmaticele": "astigmatic",
    "astigmaticelor": "astigmatic",
    "astigmatici": "astigmatic",
    "astigmaticii": "astigmatic",
    "astigmaticilor": "astigmatic",
    "astigmaticul": "astigmatic",
    "astigmaticului": "astigmatic",
    "astmul": "astm",
    "astmului": "astm",
    "astma": "astmă",
    "astme": "astmă",
    "astmei": "astmă",
    "astmele": "astmă",
    "astmelor": "astmă",
    "astmatica": "astmatic",
    "astmatică": "astmatic",
    "astmatice": "astmatic",
    "astmaticei": "astmatic",
    "astmaticele": "astmatic",
    "astmatici": "astmatic",
    "astmaticii": "astmatic",
    "astmaticilor": "astmatic",
    "astmaticul": "astmatic",
    "astmaticului": "astmatic",
    "astrala": "astral",
    "astrală": "astral",
    "astrale": "astral",
    "astralei": "astral",
    "astralele": "astral",
    "astralelor": "astral",
    "astrali": "astral",
    "astralii": "astral",
    "astralilor": "astral",
    "astralul": "astral",
    "astralului": "astral",
    "astringenta": "astringent",
    "astringentă": "astringent",
    "astringente": "astringent",
    "astringentei": "astringent",
    "astringentele": "astringent",
    "astringentelor": "astringent",
    "astringenți": "astringent",
    "astringenții": "astringent",
    "astringenților": "astringent",
    "astringentul": "astringent",
    "astringentului": "astringent",
    "astrologica": "astrologic",
    "astrologică": "astrologic",
    "astrologice": "astrologic",
    "astrologicei": "astrologic",
    "astrologicele": "astrologic",
    "astrologicelor": "astrologic",
    "astrologici": "astrologic",
    "astrologicii": "astrologic",
    "astrologicilor": "astrologic",
    "astrologicul": "astrologic",
    "astrologicului": "astrologic",
    "astronauți": "astronaut",
    "astronauții": "astronaut",
    "astronauților": "astronaut",
    "astronautul": "astronaut",
    "astronautului": "astronaut",
    "astronautica": "astronautică",
    "astronautici": "astronautică",
    "astronauticii": "astronautică",
    "astronauticile": "astronautică",
    "astronauticilor": "astronautică",
    "astronava": "astronavă",
    "astronave": "astronavă",
    "astronavei": "astronavă",
    "astronavele": "astronavă",
    "astronavelor": "astronavă",
    "astronomi": "astronom",
    "astronomii": "astronom",
    "astronomilor": "astronom",
    "astronomul": "astronom",
    "astronomului": "astronom",
    "astr.": "astronomic",
    "astronomica": "astronomic",
    "astronomică": "astronomic",
    "astronomice": "astronomic",
    "astronomicei": "astronomic",
    "astronomicele": "astronomic",
    "astronomicelor": "astronomic",
    "astronomici": "astronomic",
    "astronomicii": "astronomic",
    "astronomicilor": "astronomic",
    "astronomicul": "astronomic",
    "astronomicului": "astronomic",
    "astron.": "astronomie",
    "astronomia": "astronomie",
    "astronomiei": "astronomie",
    "astronomii": "astronomie",
    "astre": "astru",
    "astrele": "astru",
    "astrelor": "astru",
    "aștri": "astru",
    "aștrii": "astru",
    "aștrilor": "astru",
    "astrul": "astru",
    "astrului": "astru",
    "astup": "astupa",
    "astupă": "astupa",
    "astupai": "astupa",
    "astupam": "astupa",
    "astupăm": "astupa",
    "astupând": "astupa",
    "astupându": "astupa",
    "astupară": "astupa",
    "astuparăm": "astupa",
    "astuparăți": "astupa",
    "astupase": "astupa",
    "astupasem": "astupa",
    "astupaseră": "astupa",
    "astupaserăm": "astupa",
    "astupaserăți": "astupa",
    "astupaseși": "astupa",
    "astupași": "astupa",
    "astupat": "astupa",
    "astupați": "astupa",
    "astupatu": "astupa",
    "astupau": "astupa",
    "astupe": "astupa",
    "astupi": "astupa",
    "neastupând": "astupa",
    "neastupându": "astupa",
    "nemaiastupând": "astupa",
    "nemaiastupându": "astupa",
    "astuparea": "astupare",
    "astupări": "astupare",
    "astupării": "astupare",
    "astupările": "astupare",
    "astupata": "astupat",
    "astupată": "astupat",
    "astupate": "astupat",
    "astupatei": "astupat",
    "astupatele": "astupat",
    "astupatelor": "astupat",
    "astupați": "astupat",
    "astupații": "astupat",
    "astupaților": "astupat",
    "astupatul": "astupat",
    "astupatului": "astupat",
    "astupătoarea": "astupătoare",
    "astupătoarei": "astupătoare",
    "astupătorile": "astupătoare",
    "astupătorilor": "astupătoare",
    "asud": "asuda",
    "asudă": "asuda",
    "asudai": "asuda",
    "asudam": "asuda",
    "asudăm": "asuda",
    "asudând": "asuda",
    "asudându": "asuda",
    "asudară": "asuda",
    "asudarăm": "asuda",
    "asudarăți": "asuda",
    "asudase": "asuda",
    "asudasem": "asuda",
    "asudaseră": "asuda",
    "asudaserăm": "asuda",
    "asudaserăți": "asuda",
    "asudaseși": "asuda",
    "asudași": "asuda",
    "asudat": "asuda",
    "asudați": "asuda",
    "asudatu": "asuda",
    "asudau": "asuda",
    "asude": "asuda",
    "asuzi": "asuda",
    "asudată": "asudat",
    "asudate": "asudat",
    "asudați": "asudat",
    "asum": "asuma",
    "asumă": "asuma",
    "asumai": "asuma",
    "asumam": "asuma",
    "asumăm": "asuma",
    "asumând": "asuma",
    "asumându": "asuma",
    "asumară": "asuma",
    "asumarăm": "asuma",
    "asumarăți": "asuma",
    "asumase": "asuma",
    "asumasem": "asuma",
    "asumaseră": "asuma",
    "asumaserăm": "asuma",
    "asumaserăți": "asuma",
    "asumaseși": "asuma",
    "asumași": "asuma",
    "asumat": "asuma",
    "asumați": "asuma",
    "asumatu": "asuma",
    "asumau": "asuma",
    "asume": "asuma",
    "asumi": "asuma",
    "neasumând": "asuma",
    "neasumându": "asuma",
    "nemaiasumând": "asuma",
    "nemaiasumându": "asuma",
    "asumarea": "asumare",
    "asumări": "asumare",
    "asumării": "asumare",
    "asumările": "asumare",
    "asumata": "asumat",
    "asumată": "asumat",
    "asumate": "asumat",
    "asumatei": "asumat",
    "asumatele": "asumat",
    "asumatelor": "asumat",
    "asumați": "asumat",
    "asumații": "asumat",
    "asumaților": "asumat",
    "asumatul": "asumat",
    "asumatului": "asumat",
    "as.": "asupra",
    "asupră": "asupra",
    "asupreala": "asupreală",
    "asupreli": "asupreală",
    "asuprelii": "asupreală",
    "asuprelile": "asupreală",
    "asuprelilor": "asupreală",
    "asuprea": "asupri",
    "asupreai": "asupri",
    "asupream": "asupri",
    "asuprească": "asupri",
    "asupreați": "asupri",
    "asupreau": "asupri",
    "asupresc": "asupri",
    "asuprește": "asupri",
    "asuprești": "asupri",
    "asuprii": "asupri",
    "asuprim": "asupri",
    "asuprind": "asupri",
    "asuprindu": "asupri",
    "asupriră": "asupri",
    "asuprirăm": "asupri",
    "asuprirăți": "asupri",
    "asuprise": "asupri",
    "asuprisem": "asupri",
    "asupriseră": "asupri",
    "asupriserăm": "asupri",
    "asupriserăți": "asupri",
    "asupriseși": "asupri",
    "asupriși": "asupri",
    "asuprit": "asupri",
    "asupriți": "asupri",
    "asupritu": "asupri",
    "neasuprind": "asupri",
    "neasuprindu": "asupri",
    "nemaiasuprind": "asupri",
    "nemaiasuprindu": "asupri",
    "asuprirea": "asuprire",
    "asupriri": "asuprire",
    "asupririi": "asuprire",
    "asupririle": "asuprire",
    "asuprita": "asuprit",
    "asuprită": "asuprit",
    "asuprite": "asuprit",
    "asupritei": "asuprit",
    "asupritele": "asuprit",
    "asupritelor": "asuprit",
    "asupriți": "asuprit",
    "asupriții": "asuprit",
    "asupriților": "asuprit",
    "asupritul": "asuprit",
    "asupritului": "asuprit",
    "asuprita": "asuprită",
    "asuprite": "asuprită",
    "asupritei": "asuprită",
    "asupritele": "asuprită",
    "asupritelor": "asuprită",
    "asupritoarea": "asupritoare",
    "asupritoarei": "asupritoare",
    "asupritoarele": "asupritoare",
    "asupritoarelor": "asupritoare",
    "asupritoare": "asupritor",
    "asupritoarea": "asupritor",
    "asupritoarei": "asupritor",
    "asupritoarele": "asupritor",
    "asupritoarelor": "asupritor",
    "asupritori": "asupritor",
    "asupritorii": "asupritor",
    "asupritorilor": "asupritor",
    "asupritorul": "asupritor",
    "asupritorului": "asupritor",
    "asurzea": "asurzi",
    "asurzeai": "asurzi",
    "asurzeam": "asurzi",
    "asurzească": "asurzi",
    "asurzeați": "asurzi",
    "asurzeau": "asurzi",
    "asurzesc": "asurzi",
    "asurzește": "asurzi",
    "asurzești": "asurzi",
    "asurzii": "asurzi",
    "asurzim": "asurzi",
    "asurzind": "asurzi",
    "asurzindu": "asurzi",
    "asurziră": "asurzi",
    "asurzirăm": "asurzi",
    "asurzirăți": "asurzi",
    "asurzise": "asurzi",
    "asurzisem": "asurzi",
    "asurziseră": "asurzi",
    "asurziserăm": "asurzi",
    "asurziserăți": "asurzi",
    "asurziseși": "asurzi",
    "asurziși": "asurzi",
    "asurzit": "asurzi",
    "asurziți": "asurzi",
    "asurzitu": "asurzi",
    "neasurzind": "asurzi",
    "neasurzindu": "asurzi",
    "nemaiasurzind": "asurzi",
    "nemaiasurzindu": "asurzi",
    "asurzirea": "asurzire",
    "asurziri": "asurzire",
    "asurzirii": "asurzire",
    "asurzirile": "asurzire",
    "asurzita": "asurzit",
    "asurzită": "asurzit",
    "asurzite": "asurzit",
    "asurzitei": "asurzit",
    "asurzitele": "asurzit",
    "asurzitelor": "asurzit",
    "asurziți": "asurzit",
    "asurziții": "asurzit",
    "asurziților": "asurzit",
    "asurzitul": "asurzit",
    "asurzitului": "asurzit",
    "asurzitoare": "asurzitor",
    "asurzitoarea": "asurzitor",
    "asurzitoarei": "asurzitor",
    "asurzitoarele": "asurzitor",
    "asurzitoarelor": "asurzitor",
    "asurzitori": "asurzitor",
    "asurzitorii": "asurzitor",
    "asurzitorilor": "asurzitor",
    "asurzitorul": "asurzitor",
    "asurzitorului": "asurzitor",
    "ața": "ață",
    "ațe": "ață",
    "aței": "ață",
    "ațele": "ață",
    "ațelor": "ață",
    "atacul": "atac",
    "atacului": "atac",
    "atacuri": "atac",
    "atacurile": "atac",
    "atacurilor": "atac",
    "atac": "ataca",
    "atacă": "ataca",
    "atacai": "ataca",
    "atacam": "ataca",
    "atacăm": "ataca",
    "atacând": "ataca",
    "atacându": "ataca",
    "atacară": "ataca",
    "atacarăm": "ataca",
    "atacarăți": "ataca",
    "atacase": "ataca",
    "atacasem": "ataca",
    "atacaseră": "ataca",
    "atacaserăm": "ataca",
    "atacaserăți": "ataca",
    "atacaseși": "ataca",
    "atacași": "ataca",
    "atacat": "ataca",
    "atacați": "ataca",
    "atacatu": "ataca",
    "atacau": "ataca",
    "atace": "ataca",
    "ataci": "ataca",
    "neatacând": "ataca",
    "neatacându": "ataca",
    "nemaiatacând": "ataca",
    "nemaiatacându": "ataca",
    "atacabila": "atacabil",
    "atacabilă": "atacabil",
    "atacabile": "atacabil",
    "atacabilei": "atacabil",
    "atacabilele": "atacabil",
    "atacabilelor": "atacabil",
    "atacabili": "atacabil",
    "atacabilii": "atacabil",
    "atacabililor": "atacabil",
    "atacabilul": "atacabil",
    "atacabilului": "atacabil",
    "atacanți": "atacant",
    "atacanții": "atacant",
    "atacantul": "atacant",
    "atacantului": "atacant",
    "atacanta": "atacantă",
    "atacante": "atacantă",
    "atacantele": "atacantă",
    "atacantelor": "atacantă",
    "atacantey": "atacantă",
    "atacarea": "atacare",
    "atacări": "atacare",
    "atacării": "atacare",
    "atacările": "atacare",
    "atacata": "atacat",
    "atacată": "atacat",
    "atacate": "atacat",
    "atacatei": "atacat",
    "atacatele": "atacat",
    "atacatelor": "atacat",
    "atacați": "atacat",
    "atacații": "atacat",
    "atacaților": "atacat",
    "atacatul": "atacat",
    "atacatului": "atacat",
    "atacatoarea": "atacatoare",
    "atacatoarei": "atacatoare",
    "atacatoarele": "atacatoare",
    "atacatoarelor": "atacatoare",
    "atacatoare": "atacator",
    "atacatoarea": "atacator",
    "atacatoarei": "atacator",
    "atacatoarele": "atacator",
    "atacatoarelor": "atacator",
    "atacatori": "atacator",
    "atacatorii": "atacator",
    "atacatorilor": "atacator",
    "atacatorul": "atacator",
    "atacatorului": "atacator",
    "Atalantei": "Atalanta",
    "ataror": "atare",
    "atârn": "atârna",
    "atârnă": "atârna",
    "atârnai": "atârna",
    "atârnam": "atârna",
    "atârnăm": "atârna",
    "atârnând": "atârna",
    "atârnându": "atârna",
    "atârnară": "atârna",
    "atârnarăm": "atârna",
    "atârnarăți": "atârna",
    "atârnase": "atârna",
    "atârnasem": "atârna",
    "atârnaseră": "atârna",
    "atârnaserăm": "atârna",
    "atârnaserăți": "atârna",
    "atârnaseși": "atârna",
    "atârnași": "atârna",
    "atârnat": "atârna",
    "atârnați": "atârna",
    "atârnatu": "atârna",
    "atârnau": "atârna",
    "atârne": "atârna",
    "atârni": "atârna",
    "neatârnând": "atârna",
    "neatârnându": "atârna",
    "nemaiatârnând": "atârna",
    "nemaiatârnându": "atârna",
    "atârnarea": "atârnare",
    "atârnări": "atârnare",
    "atârnării": "atârnare",
    "atârnările": "atârnare",
    "atârnata": "atârnat",
    "atârnată": "atârnat",
    "atârnate": "atârnat",
    "atârnatei": "atârnat",
    "atârnatele": "atârnat",
    "atârnatelor": "atârnat",
    "atârnați": "atârnat",
    "atârnații": "atârnat",
    "atârnaților": "atârnat",
    "atârnatul": "atârnat",
    "atârnatului": "atârnat",
    "atârnători": "atârnător",
    "atârnătorii": "atârnător",
    "atârnătorilor": "atârnător",
    "atârnătorul": "atârnător",
    "atârnătorului": "atârnător",
    "atașe": "ataș",
    "atașele": "ataș",
    "atașelor": "ataș",
    "atașul": "ataș",
    "atașului": "ataș",
    "atașă": "atașa",
    "atașai": "atașa",
    "atașam": "atașa",
    "atașăm": "atașa",
    "atașând": "atașa",
    "atașându": "atașa",
    "atașară": "atașa",
    "atașarăm": "atașa",
    "atașarăți": "atașa",
    "atașase": "atașa",
    "atașasem": "atașa",
    "atașaseră": "atașa",
    "atașaserăm": "atașa",
    "atașaserăți": "atașa",
    "atașaseși": "atașa",
    "atașași": "atașa",
    "atașat": "atașa",
    "atașați": "atașa",
    "atașatu": "atașa",
    "atașau": "atașa",
    "atașează": "atașa",
    "atașez": "atașa",
    "atașeze": "atașa",
    "atașezi": "atașa",
    "neatașând": "atașa",
    "neatașându": "atașa",
    "nemaiatașând": "atașa",
    "nemaiatașându": "atașa",
    "atașamente": "atașament",
    "atașamentele": "atașament",
    "atașamentelor": "atașament",
    "atașamentul": "atașament",
    "atașamentului": "atașament",
    "atașarea": "atașare",
    "atașări": "atașare",
    "atașării": "atașare",
    "atașările": "atașare",
    "atașata": "atașat",
    "atașată": "atașat",
    "atașate": "atașat",
    "atașatei": "atașat",
    "atașatele": "atașat",
    "atașatelor": "atașat",
    "atașați": "atașat",
    "atașații": "atașat",
    "atașaților": "atașat",
    "atașatul": "atașat",
    "atașatului": "atașat",
    "atașata": "atașată",
    "atașate": "atașată",
    "atașatei": "atașată",
    "atașatele": "atașată",
    "atașatelor": "atașată",
    "atâta": "atât",
    "atâtea": "atât",
    "atâți": "atât",
    "atâția": "atât",
    "atâtor": "atât",
    "atâtora": "atât",
    "ațâț": "ațâța",
    "ațâță": "ațâța",
    "ațâțai": "ațâța",
    "ațâțam": "ațâța",
    "ațâțăm": "ațâța",
    "ațâțând": "ațâța",
    "ațâțându": "ațâța",
    "ațâțară": "ațâța",
    "ațâțarăm": "ațâța",
    "ațâțarăți": "ațâța",
    "ațâțase": "ațâța",
    "ațâțasem": "ațâța",
    "ațâțaseră": "ațâța",
    "ațâțaserăm": "ațâța",
    "ațâțaserăți": "ațâța",
    "ațâțaseși": "ațâța",
    "ațâțași": "ațâța",
    "ațâțat": "ațâța",
    "ațâțați": "ațâța",
    "ațâțatu": "ațâța",
    "ațâțau": "ațâța",
    "ațâțe": "ațâța",
    "ațâți": "ațâța",
    "neațâțând": "ațâța",
    "neațâțându": "ațâța",
    "nemaiațâțând": "ațâța",
    "nemaiațâțându": "ațâța",
    "ațâțarea": "ațâțare",
    "ațâțări": "ațâțare",
    "ațâțării": "ațâțare",
    "ațâțările": "ațâțare",
    "ațâțata": "ațâțat",
    "ațâțată": "ațâțat",
    "ațâțate": "ațâțat",
    "ațâțatei": "ațâțat",
    "ațâțatele": "ațâțat",
    "ațâțatelor": "ațâțat",
    "ațâțați": "ațâțat",
    "ațâțații": "ațâțat",
    "ațâțaților": "ațâțat",
    "ațâțatul": "ațâțat",
    "ațâțatului": "ațâțat",
    "ațâțătoare": "ațâțător",
    "ațâțătoarea": "ațâțător",
    "ațâțătoarei": "ațâțător",
    "ațâțătoarele": "ațâțător",
    "ațâțătoarelor": "ațâțător",
    "ațâțători": "ațâțător",
    "ațâțătorii": "ațâțător",
    "ațâțătorilor": "ațâțător",
    "ațâțătorul": "ațâțător",
    "ațâțătorului": "ațâțător",
    "atavica": "atavic",
    "atavică": "atavic",
    "atavice": "atavic",
    "atavicei": "atavic",
    "atavicele": "atavic",
    "atavicelor": "atavic",
    "atavici": "atavic",
    "atavicii": "atavic",
    "atavicilor": "atavic",
    "atavicul": "atavic",
    "atavicului": "atavic",
    "atavisme": "atavism",
    "atavismele": "atavism",
    "atavismelor": "atavism",
    "atavismul": "atavism",
    "atavismului": "atavism",
    "atea": "atee",
    "ateei": "atee",
    "ateelor": "atee",
    "ateisme": "ateism",
    "ateismele": "ateism",
    "ateismelor": "ateism",
    "ateismul": "ateism",
    "ateismului": "ateism",
    "ateista": "ateist",
    "ateistă": "ateist",
    "ateiste": "ateist",
    "ateistei": "ateist",
    "ateistele": "ateist",
    "ateistelor": "ateist",
    "ateiști": "ateist",
    "ateiștii": "ateist",
    "ateiștilor": "ateist",
    "ateistul": "ateist",
    "ateistului": "ateist",
    "ateizarea": "ateizare",
    "ateizări": "ateizare",
    "ateizării": "ateizare",
    "ateizările": "ateizare",
    "ateizărilor": "ateizare",
    "ateliere": "atelier",
    "atelierele": "atelier",
    "atelierelor": "atelier",
    "atelierul": "atelier",
    "atelierului": "atelier",
    "Atenei": "Atena",
    "atenansa": "atenansă",
    "atenanse": "atenansă",
    "atenansei": "atenansă",
    "atenansele": "atenansă",
    "atenanselor": "atenansă",
    "atenee": "ateneu",
    "ateneele": "ateneu",
    "ateneelor": "ateneu",
    "ateneul": "ateneu",
    "ateneului": "ateneu",
    "ateniana": "atenian",
    "ateniană": "atenian",
    "atenianul": "atenian",
    "atenianului": "atenian",
    "ateniene": "atenian",
    "atenienei": "atenian",
    "atenienele": "atenian",
    "atenienelor": "atenian",
    "atenieni": "atenian",
    "atenienii": "atenian",
    "atenienilor": "atenian",
    "atenta": "atent",
    "atentă": "atent",
    "atente": "atent",
    "atentei": "atent",
    "atentele": "atent",
    "atentelor": "atent",
    "atenți": "atent",
    "atenții": "atent",
    "atenților": "atent",
    "atentul": "atent",
    "atentului": "atent",
    "atentă": "atenta",
    "atentai": "atenta",
    "atentam": "atenta",
    "atentăm": "atenta",
    "atentând": "atenta",
    "atentându": "atenta",
    "atentară": "atenta",
    "atentarăm": "atenta",
    "atentarăți": "atenta",
    "atentase": "atenta",
    "atentasem": "atenta",
    "atentaseră": "atenta",
    "atentaserăm": "atenta",
    "atentaserăți": "atenta",
    "atentaseși": "atenta",
    "atentași": "atenta",
    "atentat": "atenta",
    "atentați": "atenta",
    "atentatu": "atenta",
    "atentau": "atenta",
    "atentează": "atenta",
    "atentez": "atenta",
    "atenteze": "atenta",
    "atentezi": "atenta",
    "neatentând": "atenta",
    "neatentându": "atenta",
    "nemaiatentând": "atenta",
    "nemaiatentându": "atenta",
    "atentarea": "atentare",
    "atentări": "atentare",
    "atentării": "atentare",
    "atentările": "atentare",
    "atentata": "atentat",
    "atentată": "atentat",
    "atentate": "atentat",
    "atentatei": "atentat",
    "atentatele": "atentat",
    "atentatelor": "atentat",
    "atentați": "atentat",
    "atentații": "atentat",
    "atentaților": "atentat",
    "atentatul": "atentat",
    "atentatului": "atentat",
    "atentatoarea": "atentatoare",
    "atentatoarei": "atentatoare",
    "atentatoarele": "atentatoare",
    "atentatoarelor": "atentatoare",
    "atentatori": "atentator",
    "atentatorii": "atentator",
    "atentatorilor": "atentator",
    "atentatorul": "atentator",
    "atentatorului": "atentator",
    "atenția": "atenție",
    "atenției": "atenție",
    "atenții": "atenție",
    "atențiile": "atenție",
    "atențiilor": "atenție",
    "atenționă": "atenționa",
    "atenționai": "atenționa",
    "atenționam": "atenționa",
    "atenționăm": "atenționa",
    "atenționând": "atenționa",
    "atenționându": "atenționa",
    "atenționară": "atenționa",
    "atenționarăm": "atenționa",
    "atenționarăți": "atenționa",
    "atenționase": "atenționa",
    "atenționasem": "atenționa",
    "atenționaseră": "atenționa",
    "atenționaserăm": "atenționa",
    "atenționaserăți": "atenționa",
    "atenționaseși": "atenționa",
    "atenționași": "atenționa",
    "atenționat": "atenționa",
    "atenționați": "atenționa",
    "atenționatu": "atenționa",
    "atenționau": "atenționa",
    "atenționează": "atenționa",
    "atenționez": "atenționa",
    "atenționeze": "atenționa",
    "atenționezi": "atenționa",
    "atenționarea": "atenționare",
    "atenționări": "atenționare",
    "atenționării": "atenționare",
    "atenționările": "atenționare",
    "atenționărilor": "atenționare",
    "atenționata": "atenționat",
    "atenționată": "atenționat",
    "atenționate": "atenționat",
    "atenționatei": "atenționat",
    "atenționatele": "atenționat",
    "atenționatelor": "atenționat",
    "atenționați": "atenționat",
    "atenționații": "atenționat",
    "atenționaților": "atenționat",
    "atenționatul": "atenționat",
    "atenționatului": "atenționat",
    "atențiunea": "atențiune",
    "atențiuni": "atențiune",
    "atențiunii": "atențiune",
    "atențiunile": "atențiune",
    "atențiunilor": "atențiune",
    "atenuă": "atenua",
    "atenuai": "atenua",
    "atenuam": "atenua",
    "atenuăm": "atenua",
    "atenuând": "atenua",
    "atenuându": "atenua",
    "atenuară": "atenua",
    "atenuarăm": "atenua",
    "atenuarăți": "atenua",
    "atenuase": "atenua",
    "atenuasem": "atenua",
    "atenuaseră": "atenua",
    "atenuaserăm": "atenua",
    "atenuaserăți": "atenua",
    "atenuaseși": "atenua",
    "atenuași": "atenua",
    "atenuat": "atenua",
    "atenuați": "atenua",
    "atenuatu": "atenua",
    "atenuau": "atenua",
    "atenuează": "atenua",
    "atenuez": "atenua",
    "atenueze": "atenua",
    "atenuezi": "atenua",
    "neatenuând": "atenua",
    "neatenuându": "atenua",
    "nemaiatenuând": "atenua",
    "nemaiatenuându": "atenua",
    "atenuanta": "atenuant",
    "atenuantă": "atenuant",
    "atenuante": "atenuant",
    "atenuantei": "atenuant",
    "atenuantele": "atenuant",
    "atenuantelor": "atenuant",
    "atenuanți": "atenuant",
    "atenuanții": "atenuant",
    "atenuanților": "atenuant",
    "atenuantul": "atenuant",
    "atenuantului": "atenuant",
    "atenuarea": "atenuare",
    "atenuări": "atenuare",
    "atenuării": "atenuare",
    "atenuările": "atenuare",
    "atenuata": "atenuat",
    "atenuată": "atenuat",
    "atenuate": "atenuat",
    "atenuatei": "atenuat",
    "atenuatele": "atenuat",
    "atenuatelor": "atenuat",
    "atenuați": "atenuat",
    "atenuații": "atenuat",
    "atenuaților": "atenuat",
    "atenuatul": "atenuat",
    "atenuatului": "atenuat",
    "ateriză": "ateriza",
    "aterizai": "ateriza",
    "aterizam": "ateriza",
    "aterizăm": "ateriza",
    "aterizând": "ateriza",
    "aterizându": "ateriza",
    "aterizară": "ateriza",
    "aterizarăm": "ateriza",
    "aterizarăți": "ateriza",
    "aterizase": "ateriza",
    "aterizasem": "ateriza",
    "aterizaseră": "ateriza",
    "aterizaserăm": "ateriza",
    "aterizaserăți": "ateriza",
    "aterizaseși": "ateriza",
    "aterizași": "ateriza",
    "aterizat": "ateriza",
    "aterizați": "ateriza",
    "aterizatu": "ateriza",
    "aterizau": "ateriza",
    "aterizează": "ateriza",
    "aterizez": "ateriza",
    "aterizeze": "ateriza",
    "aterizezi": "ateriza",
    "neaterizând": "ateriza",
    "neaterizându": "ateriza",
    "nemaiaterizând": "ateriza",
    "nemaiaterizându": "ateriza",
    "aterizarea": "aterizare",
    "aterizări": "aterizare",
    "aterizării": "aterizare",
    "aterizările": "aterizare",
    "aterizata": "aterizat",
    "aterizată": "aterizat",
    "aterizate": "aterizat",
    "aterizatei": "aterizat",
    "aterizatele": "aterizat",
    "aterizatelor": "aterizat",
    "aterizați": "aterizat",
    "aterizații": "aterizat",
    "aterizaților": "aterizat",
    "aterizatul": "aterizat",
    "aterizatului": "aterizat",
    "atermana": "aterman",
    "atermană": "aterman",
    "atermane": "aterman",
    "atermanei": "aterman",
    "atermanele": "aterman",
    "atermanelor": "aterman",
    "atermani": "aterman",
    "atermanii": "aterman",
    "atermanilor": "aterman",
    "atermanul": "aterman",
    "atermanului": "aterman",
    "atest": "atesta",
    "atestă": "atesta",
    "atestai": "atesta",
    "atestam": "atesta",
    "atestăm": "atesta",
    "atestând": "atesta",
    "atestându": "atesta",
    "atestară": "atesta",
    "atestarăm": "atesta",
    "atestarăți": "atesta",
    "atestase": "atesta",
    "atestasem": "atesta",
    "atestaseră": "atesta",
    "atestaserăm": "atesta",
    "atestaserăți": "atesta",
    "atestaseși": "atesta",
    "atestași": "atesta",
    "atestat": "atesta",
    "atestați": "atesta",
    "atestatu": "atesta",
    "atestau": "atesta",
    "ateste": "atesta",
    "atești": "atesta",
    "neatestând": "atesta",
    "neatestându": "atesta",
    "nemaiatestând": "atesta",
    "nemaiatestându": "atesta",
    "atestarea": "atestare",
    "atestări": "atestare",
    "atestării": "atestare",
    "atestările": "atestare",
    "atestata": "atestat",
    "atestată": "atestat",
    "atestate": "atestat",
    "atestatei": "atestat",
    "atestatele": "atestat",
    "atestatelor": "atestat",
    "atestați": "atestat",
    "atestații": "atestat",
    "atestaților": "atestat",
    "atestatul": "atestat",
    "atestatului": "atestat",
    "atei": "ateu",
    "ateii": "ateu",
    "ateilor": "ateu",
    "ateul": "ateu",
    "ateului": "ateu",
    "athoniți": "athonit",
    "athoniții": "athonit",
    "athoniților": "athonit",
    "athonitul": "athonit",
    "athonitului": "athonit",
    "atica": "atic",
    "atică": "atic",
    "atice": "atic",
    "aticei": "atic",
    "aticele": "atic",
    "aticelor": "atic",
    "atici": "atic",
    "aticii": "atic",
    "aticilor": "atic",
    "aticul": "atic",
    "aticului": "atic",
    "ații": "aține",
    "ațin": "aține",
    "ațină": "aține",
    "aținând": "aține",
    "aținându": "aține",
    "aținea": "aține",
    "ațineai": "aține",
    "ațineam": "aține",
    "ațineați": "aține",
    "ațineau": "aține",
    "aținem": "aține",
    "ațineți": "aține",
    "aținu": "aține",
    "aținui": "aține",
    "aținură": "aține",
    "aținurăm": "aține",
    "aținurăți": "aține",
    "aținuse": "aține",
    "aținusem": "aține",
    "aținuseră": "aține",
    "aținuserăm": "aține",
    "aținuserăți": "aține",
    "aținuseși": "aține",
    "aținuși": "aține",
    "aținut": "aține",
    "aținutu": "aține",
    "neaținând": "aține",
    "neaținându": "aține",
    "nemaiaținând": "aține",
    "nemaiaținându": "aține",
    "aținerea": "aținere",
    "ațineri": "aținere",
    "aținerii": "aținere",
    "aținerile": "aținere",
    "ating": "atinge",
    "atingă": "atinge",
    "atingând": "atinge",
    "atingându": "atinge",
    "atingea": "atinge",
    "atingeai": "atinge",
    "atingeam": "atinge",
    "atingeați": "atinge",
    "atingeau": "atinge",
    "atingem": "atinge",
    "atingeți": "atinge",
    "atingi": "atinge",
    "atins": "atinge",
    "atinse": "atinge",
    "atinsei": "atinge",
    "atinseră": "atinge",
    "atinserăm": "atinge",
    "atinserăți": "atinge",
    "atinsese": "atinge",
    "atinsesem": "atinge",
    "atinseseră": "atinge",
    "atinseserăm": "atinge",
    "atinseserăți": "atinge",
    "atinseseși": "atinge",
    "atinseși": "atinge",
    "atinsu": "atinge",
    "neatingând": "atinge",
    "neatingându": "atinge",
    "nemaiatingând": "atinge",
    "nemaiatingându": "atinge",
    "atingerea": "atingere",
    "atingeri": "atingere",
    "atingerii": "atingere",
    "atingerile": "atingere",
    "atinsa": "atins",
    "atinsă": "atins",
    "atinse": "atins",
    "atinsei": "atins",
    "atinsele": "atins",
    "atinselor": "atins",
    "atinși": "atins",
    "atinșii": "atins",
    "atinșilor": "atins",
    "atinsul": "atins",
    "atinsului": "atins",
    "ațintea": "aținti",
    "aținteai": "aținti",
    "aținteam": "aținti",
    "ațintească": "aținti",
    "aținteați": "aținti",
    "aținteau": "aținti",
    "ațintesc": "aținti",
    "ațintește": "aținti",
    "ațintești": "aținti",
    "ațintii": "aținti",
    "ațintim": "aținti",
    "ațintind": "aținti",
    "ațintindu": "aținti",
    "ațintiră": "aținti",
    "ațintirăm": "aținti",
    "ațintirăți": "aținti",
    "ațintise": "aținti",
    "ațintisem": "aținti",
    "ațintiseră": "aținti",
    "ațintiserăm": "aținti",
    "ațintiserăți": "aținti",
    "ațintiseși": "aținti",
    "ațintiși": "aținti",
    "ațintit": "aținti",
    "ațintiți": "aținti",
    "ațintitu": "aținti",
    "ațintirea": "ațintire",
    "ațintiri": "ațintire",
    "ațintirii": "ațintire",
    "ațintirile": "ațintire",
    "ațintirilor": "ațintire",
    "ațintita": "ațintit",
    "ațintită": "ațintit",
    "ațintite": "ațintit",
    "ațintitei": "ațintit",
    "ațintitele": "ațintit",
    "ațintitelor": "ațintit",
    "ațintiți": "ațintit",
    "ațintiții": "ațintit",
    "ațintiților": "ațintit",
    "ațintitul": "ațintit",
    "ațintitului": "ațintit",
    "aținuta": "aținut",
    "aținută": "aținut",
    "aținute": "aținut",
    "aținutei": "aținut",
    "aținutele": "aținut",
    "aținutelor": "aținut",
    "aținuți": "aținut",
    "aținuții": "aținut",
    "aținuților": "aținut",
    "aținutul": "aținut",
    "aținutului": "aținut",
    "ațipea": "ațipi",
    "ațipeai": "ațipi",
    "ațipeam": "ațipi",
    "ațipească": "ațipi",
    "ațipeați": "ațipi",
    "ațipeau": "ațipi",
    "ațipesc": "ațipi",
    "ațipește": "ațipi",
    "ațipești": "ațipi",
    "ațipii": "ațipi",
    "ațipim": "ațipi",
    "ațipind": "ațipi",
    "ațipindu": "ațipi",
    "ațipiră": "ațipi",
    "ațipirăm": "ațipi",
    "ațipirăți": "ațipi",
    "ațipise": "ațipi",
    "ațipisem": "ațipi",
    "ațipiseră": "ațipi",
    "ațipiserăm": "ațipi",
    "ațipiserăți": "ațipi",
    "ațipiseși": "ațipi",
    "ațipiși": "ațipi",
    "ațipit": "ațipi",
    "ațipiți": "ațipi",
    "ațipitu": "ațipi",
    "neațipind": "ațipi",
    "neațipindu": "ațipi",
    "nemaiațipind": "ațipi",
    "nemaiațipindu": "ațipi",
    "atipică": "atipic",
    "atipice": "atipic",
    "atipici": "atipic",
    "ațipirea": "ațipire",
    "ațipiri": "ațipire",
    "ațipirii": "ațipire",
    "ațipirile": "ațipire",
    "ațipita": "ațipit",
    "ațipită": "ațipit",
    "ațipite": "ațipit",
    "ațipitei": "ațipit",
    "ațipitele": "ațipit",
    "ațipitelor": "ațipit",
    "ațipiți": "ațipit",
    "ațipiții": "ațipit",
    "ațipiților": "ațipit",
    "ațipitul": "ațipit",
    "ațipitului": "ațipit",
    "atitudinea": "atitudine",
    "atitudini": "atitudine",
    "atitudinii": "atitudine",
    "atitudinile": "atitudine",
    "atitudinilor": "atitudine",
    "Atlantă": "Atlanta",
    "Atlante": "Atlanta",
    "Atlantei": "Atlanta",
    "atlantica": "atlantic",
    "atlantică": "atlantic",
    "atlantice": "atlantic",
    "atlanticei": "atlantic",
    "atlanticele": "atlantic",
    "atlanticelor": "atlantic",
    "atlantici": "atlantic",
    "atlanticii": "atlantic",
    "atlanticilor": "atlantic",
    "atlanticul": "atlantic",
    "Atlanticului": "Atlantic",
    "atlase": "atlas",
    "atlasele": "atlas",
    "atlaselor": "atlas",
    "atlasul": "atlas",
    "atlasului": "atlas",
    "atlazul": "atlaz",
    "atlazului": "atlaz",
    "atlazuri": "atlaz",
    "atlazurile": "atlaz",
    "atlazurilor": "atlaz",
    "atleți": "atlet",
    "atleții": "atlet",
    "atleților": "atlet",
    "atletul": "atlet",
    "atletului": "atlet",
    "atleta": "atletă",
    "atlete": "atletă",
    "atletei": "atletă",
    "atletele": "atletă",
    "atletelor": "atletă",
    "atletica": "atletic",
    "atletică": "atletic",
    "atletice": "atletic",
    "atleticei": "atletic",
    "atleticele": "atletic",
    "atleticelor": "atletic",
    "atletici": "atletic",
    "atleticii": "atletic",
    "atleticilor": "atletic",
    "atleticul": "atletic",
    "atleticului": "atletic",
    "atletisme": "atletism",
    "atletismele": "atletism",
    "atletismelor": "atletism",
    "atletismul": "atletism",
    "atletismului": "atletism",
    "atmosfera": "atmosferă",
    "atmosfere": "atmosferă",
    "atmosferei": "atmosferă",
    "atmosferele": "atmosferă",
    "atmosferelor": "atmosferă",
    "ata": "atmosferă_absolută",
    "at": "atmosferă_tehnică",
    "atmosferica": "atmosferic",
    "atmosferică": "atmosferic",
    "atmosferice": "atmosferic",
    "atmosfericei": "atmosferic",
    "atmosfericele": "atmosferic",
    "atmosfericelor": "atmosferic",
    "atmosferici": "atmosferic",
    "atmosfericii": "atmosferic",
    "atmosfericilor": "atmosferic",
    "atmosfericul": "atmosferic",
    "atmosfericului": "atmosferic",
    "atoatestăpânitoarea": "atoatestăpânitoare",
    "atoatestăpânitoarei": "atoatestăpânitoare",
    "atoatestăpânitoarele": "atoatestăpânitoare",
    "atoatestăpânitoarelor": "atoatestăpânitoare",
    "atoatestăpânitoare": "atoatestăpânitor",
    "atoatestăpânitoarea": "atoatestăpânitor",
    "atoatestăpânitoarei": "atoatestăpânitor",
    "atoatestăpânitoarele": "atoatestăpânitor",
    "atoatestăpânitoarelor": "atoatestăpânitor",
    "atoatestăpânitori": "atoatestăpânitor",
    "atoatestăpânitorii": "atoatestăpânitor",
    "atoatestăpânitorilor": "atoatestăpânitor",
    "atoatestăpânitorul": "atoatestăpânitor",
    "atoatestăpânitorului": "atoatestăpânitor",
    "atoatevăzătoare": "atoatevăzător",
    "atoatevăzătoarea": "atoatevăzător",
    "atoatevăzătoarei": "atoatevăzător",
    "atoatevăzătoarele": "atoatevăzător",
    "atoatevăzătoarelor": "atoatevăzător",
    "atoatevăzători": "atoatevăzător",
    "atoatevăzătorii": "atoatevăzător",
    "atoatevăzătorilor": "atoatevăzător",
    "atoatevăzătorul": "atoatevăzător",
    "atoatevăzătorului": "atoatevăzător",
    "atoli": "atol",
    "atolii": "atol",
    "atolilor": "atol",
    "atolul": "atol",
    "atolului": "atol",
    "atomi": "atom",
    "atomii": "atom",
    "atomilor": "atom",
    "atomul": "atom",
    "atomului": "atom",
    "atomica": "atomic",
    "atomică": "atomic",
    "atomice": "atomic",
    "atomicei": "atomic",
    "atomicele": "atomic",
    "atomicelor": "atomic",
    "atomici": "atomic",
    "atomicii": "atomic",
    "atomicilor": "atomic",
    "atomicul": "atomic",
    "atomicului": "atomic",
    "atomista": "atomist",
    "atomistă": "atomist",
    "atomiste": "atomist",
    "atomistei": "atomist",
    "atomistele": "atomist",
    "atomistelor": "atomist",
    "atomiști": "atomist",
    "atomiștii": "atomist",
    "atomiștilor": "atomist",
    "atomistul": "atomist",
    "atomistului": "atomist",
    "atona": "aton",
    "atonă": "aton",
    "atone": "aton",
    "atonei": "aton",
    "atonele": "aton",
    "atonelor": "aton",
    "atoni": "aton",
    "atonii": "aton",
    "atonilor": "aton",
    "atonul": "aton",
    "atonului": "aton",
    "atonica": "atonic",
    "atonică": "atonic",
    "atonice": "atonic",
    "atonicei": "atonic",
    "atonicele": "atonic",
    "atonicelor": "atonic",
    "atonici": "atonic",
    "atonicii": "atonic",
    "atonicilor": "atonic",
    "atonicul": "atonic",
    "atonicului": "atonic",
    "ațoasa": "ațos",
    "ațoasă": "ațos",
    "ațoase": "ațos",
    "ațoasei": "ațos",
    "ațoasele": "ațos",
    "ațoaselor": "ațos",
    "ațoși": "ațos",
    "ațoșii": "ațos",
    "ațoșilor": "ațos",
    "ațosul": "ațos",
    "ațosului": "ațos",
    "atotbiruitoare": "atotbiruitor",
    "atotbiruitoarea": "atotbiruitor",
    "atotbiruitoarei": "atotbiruitor",
    "atotbiruitoarele": "atotbiruitor",
    "atotbiruitoarelor": "atotbiruitor",
    "atotbiruitori": "atotbiruitor",
    "atotbiruitorii": "atotbiruitor",
    "atotbiruitorilor": "atotbiruitor",
    "atotbiruitorul": "atotbiruitor",
    "atotbiruitorului": "atotbiruitor",
    "atotcunoscătoarea": "atotcunoscătoare",
    "atotcunoscătoarei": "atotcunoscătoare",
    "atotcunoscătoarele": "atotcunoscătoare",
    "atotcunoscătoarelor": "atotcunoscătoare",
    "atotcunoscătoare": "atotcunoscător",
    "atotcunoscătoarea": "atotcunoscător",
    "atotcunoscătoarei": "atotcunoscător",
    "atotcunoscătoarele": "atotcunoscător",
    "atotcunoscătoarelor": "atotcunoscător",
    "atotcunoscători": "atotcunoscător",
    "atotcunoscătorii": "atotcunoscător",
    "atotcunoscătorilor": "atotcunoscător",
    "atotcunoscătorul": "atotcunoscător",
    "atotcunoscătorului": "atotcunoscător",
    "atotcuprinderea": "atotcuprindere",
    "atotcuprinderi": "atotcuprindere",
    "atotcuprinderii": "atotcuprindere",
    "atotcuprinderile": "atotcuprindere",
    "atotcuprinderilor": "atotcuprindere",
    "atotcuprinzătoare": "atotcuprinzător",
    "atotcuprinzătoarea": "atotcuprinzător",
    "atotcuprinzătoarei": "atotcuprinzător",
    "atotcuprinzătoarele": "atotcuprinzător",
    "atotcuprinzătoarelor": "atotcuprinzător",
    "atotcuprinzători": "atotcuprinzător",
    "atotcuprinzătorii": "atotcuprinzător",
    "atotcuprinzătorilor": "atotcuprinzător",
    "atotcuprinzătorul": "atotcuprinzător",
    "atotcuprinzătorului": "atotcuprinzător",
    "atotînțelegătoarea": "atotînțelegătoare",
    "atotînțelegătoarei": "atotînțelegătoare",
    "atotînțelegătoarele": "atotînțelegătoare",
    "atotînțelegătoarelor": "atotînțelegătoare",
    "atotînțelegătoare": "atotînțelegător",
    "atotînțelegătoarea": "atotînțelegător",
    "atotînțelegătoarei": "atotînțelegător",
    "atotînțelegătoarele": "atotînțelegător",
    "atotînțelegătoarelor": "atotînțelegător",
    "atotînțelegători": "atotînțelegător",
    "atotînțelegătorii": "atotînțelegător",
    "atotînțelegătorilor": "atotînțelegător",
    "atotînțelegătorul": "atotînțelegător",
    "atotînțelegătorului": "atotînțelegător",
    "atotputernica": "atotputernic",
    "atotputernică": "atotputernic",
    "atotputernice": "atotputernic",
    "atotputernicei": "atotputernic",
    "atotputernicele": "atotputernic",
    "atotputernicelor": "atotputernic",
    "atotputernici": "atotputernic",
    "atotputernicii": "atotputernic",
    "atotputernicilor": "atotputernic",
    "atotputernicul": "atotputernic",
    "atotputernicului": "atotputernic",
    "atotputernica": "atotputernică",
    "atotputernice": "atotputernică",
    "atotputernicei": "atotputernică",
    "atotputernicele": "atotputernică",
    "atotputernicelor": "atotputernică",
    "atotputernicia": "atotputernicie",
    "atotputerniciei": "atotputernicie",
    "atotputernicii": "atotputernicie",
    "atotștiutoare": "atotștiutor",
    "atotștiutoarea": "atotștiutor",
    "atotștiutoarei": "atotștiutor",
    "atotștiutoarele": "atotștiutor",
    "atotștiutoarelor": "atotștiutor",
    "atotștiutori": "atotștiutor",
    "atotștiutorii": "atotștiutor",
    "atotștiutorilor": "atotștiutor",
    "atotștiutorul": "atotștiutor",
    "atotștiutorului": "atotștiutor",
    "atotvăzătoare": "atotvăzător",
    "atotvăzătoarea": "atotvăzător",
    "atotvăzătoarei": "atotvăzător",
    "atotvăzătoarele": "atotvăzător",
    "atotvăzătoarelor": "atotvăzător",
    "atotvăzători": "atotvăzător",
    "atotvăzătorii": "atotvăzător",
    "atotvăzătorilor": "atotvăzător",
    "atotvăzătorul": "atotvăzător",
    "atotvăzătorului": "atotvăzător",
    "atracția": "atracție",
    "atracției": "atracție",
    "atracții": "atracție",
    "atracțiile": "atracție",
    "atracțiilor": "atracție",
    "atractiva": "atractiv",
    "atractivă": "atractiv",
    "atractive": "atractiv",
    "atractivei": "atractiv",
    "atractivele": "atractiv",
    "atractivelor": "atractiv",
    "atractivi": "atractiv",
    "atractivii": "atractiv",
    "atractivilor": "atractiv",
    "atractivul": "atractiv",
    "atractivului": "atractiv",
    "atrăgătoare": "atrăgător",
    "atrăgătoarea": "atrăgător",
    "atrăgătoarei": "atrăgător",
    "atrăgătoarele": "atrăgător",
    "atrăgătoarelor": "atrăgător",
    "atrăgători": "atrăgător",
    "atrăgătorii": "atrăgător",
    "atrăgătorilor": "atrăgător",
    "atrăgătorul": "atrăgător",
    "atrăgătorului": "atrăgător",
    "atrag": "atrage",
    "atragă": "atrage",
    "atrăgând": "atrage",
    "atrăgându": "atrage",
    "atrăgea": "atrage",
    "atrăgeai": "atrage",
    "atrăgeam": "atrage",
    "atrăgeați": "atrage",
    "atrăgeau": "atrage",
    "atragem": "atrage",
    "atrageți": "atrage",
    "atragi": "atrage",
    "atras": "atrage",
    "atrase": "atrage",
    "atrăsei": "atrage",
    "atraseră": "atrage",
    "atraserăm": "atrage",
    "atraserăți": "atrage",
    "atrăsese": "atrage",
    "atrăsesem": "atrage",
    "atrăseseră": "atrage",
    "atrăseserăm": "atrage",
    "atrăseserăți": "atrage",
    "atrăseseși": "atrage",
    "atrăseși": "atrage",
    "atrasu": "atrage",
    "neatrăgând": "atrage",
    "neatrăgându": "atrage",
    "nemaiatrăgând": "atrage",
    "nemaiatrăgându": "atrage",
    "atragerea": "atragere",
    "atrageri": "atragere",
    "atragerii": "atragere",
    "atragerile": "atragere",
    "atrasa": "atras",
    "atrasă": "atras",
    "atrase": "atras",
    "atrasei": "atras",
    "atrasele": "atras",
    "atraselor": "atras",
    "atrași": "atras",
    "atrașii": "atras",
    "atrașilor": "atras",
    "atrasul": "atras",
    "atrasului": "atras",
    "atribuia": "atribui",
    "atribuiai": "atribui",
    "atribuiam": "atribui",
    "atribuiați": "atribui",
    "atribuiau": "atribui",
    "atribuie": "atribui",
    "atribuii": "atribui",
    "atribuim": "atribui",
    "atribuind": "atribui",
    "atribuindu": "atribui",
    "atribuiră": "atribui",
    "atribuirăm": "atribui",
    "atribuirăți": "atribui",
    "atribuise": "atribui",
    "atribuisem": "atribui",
    "atribuiseră": "atribui",
    "atribuiserăm": "atribui",
    "atribuiserăți": "atribui",
    "atribuiseși": "atribui",
    "atribuiși": "atribui",
    "atribuit": "atribui",
    "atribuiți": "atribui",
    "atribuitu": "atribui",
    "neatribuind": "atribui",
    "neatribuindu": "atribui",
    "nemaiatribuind": "atribui",
    "nemaiatribuindu": "atribui",
    "atribuirea": "atribuire",
    "atribuiri": "atribuire",
    "atribuirii": "atribuire",
    "atribuirile": "atribuire",
    "atribuita": "atribuit",
    "atribuită": "atribuit",
    "atribuite": "atribuit",
    "atribuitei": "atribuit",
    "atribuitele": "atribuit",
    "atribuitelor": "atribuit",
    "atribuiți": "atribuit",
    "atribuiții": "atribuit",
    "atribuiților": "atribuit",
    "atribuitul": "atribuit",
    "atribuitului": "atribuit",
    "atribute": "atribut",
    "atributele": "atribut",
    "atributelor": "atribut",
    "atributul": "atribut",
    "atributului": "atribut",
    "atribuția": "atribuție",
    "atribuției": "atribuție",
    "atribuții": "atribuție",
    "atribuțiile": "atribuție",
    "atribuțiilor": "atribuție",
    "atribuțiunea": "atribuțiune",
    "atribuțiuni": "atribuțiune",
    "atribuțiunii": "atribuțiune",
    "atribuțiunile": "atribuțiune",
    "atribuțiunilor": "atribuțiune",
    "atributiva": "atributiv",
    "atributivă": "atributiv",
    "atributive": "atributiv",
    "atributivei": "atributiv",
    "atributivele": "atributiv",
    "atributivelor": "atributiv",
    "atributivi": "atributiv",
    "atributivii": "atributiv",
    "atributivilor": "atributiv",
    "atributivul": "atributiv",
    "atributivului": "atributiv",
    "Atrizi": "Atrid",
    "atrocitatea": "atrocitate",
    "atrocități": "atrocitate",
    "atrocității": "atrocitate",
    "atrocitățile": "atrocitate",
    "atrocităților": "atrocitate",
    "atrofiai": "atrofia",
    "atrofiam": "atrofia",
    "atrofiară": "atrofia",
    "atrofiarăm": "atrofia",
    "atrofiarăți": "atrofia",
    "atrofiase": "atrofia",
    "atrofiasem": "atrofia",
    "atrofiaseră": "atrofia",
    "atrofiaserăm": "atrofia",
    "atrofiaserăți": "atrofia",
    "atrofiaseși": "atrofia",
    "atrofiași": "atrofia",
    "atrofiat": "atrofia",
    "atrofiați": "atrofia",
    "atrofiatu": "atrofia",
    "atrofiau": "atrofia",
    "atrofiază": "atrofia",
    "atrofie": "atrofia",
    "atrofiem": "atrofia",
    "atrofiez": "atrofia",
    "atrofieze": "atrofia",
    "atrofiezi": "atrofia",
    "atrofiind": "atrofia",
    "atrofiindu": "atrofia",
    "neatrofiind": "atrofia",
    "neatrofiindu": "atrofia",
    "nemaiatrofiind": "atrofia",
    "nemaiatrofiindu": "atrofia",
    "atrofiata": "atrofiat",
    "atrofiată": "atrofiat",
    "atrofiate": "atrofiat",
    "atrofiatei": "atrofiat",
    "atrofiatele": "atrofiat",
    "atrofiatelor": "atrofiat",
    "atrofiați": "atrofiat",
    "atrofiații": "atrofiat",
    "atrofiaților": "atrofiat",
    "atrofiatul": "atrofiat",
    "atrofiatului": "atrofiat",
    "atrofiata": "atrofiată",
    "atrofiate": "atrofiată",
    "atrofiatei": "atrofiată",
    "atrofiatele": "atrofiată",
    "atrofiatelor": "atrofiată",
    "atrofia": "atrofie",
    "atrofiei": "atrofie",
    "atrofii": "atrofie",
    "atrofiile": "atrofie",
    "atrofiilor": "atrofie",
    "atrofierea": "atrofiere",
    "atrofieri": "atrofiere",
    "atrofierii": "atrofiere",
    "atrofierile": "atrofiere",
    "atuul": "atu",
    "atuului": "atu",
    "atuuri": "atu",
    "atuurile": "atu",
    "atuurilor": "atu",
    "auz": "aud",
    "audiai": "audia",
    "audiam": "audia",
    "audiară": "audia",
    "audiarăm": "audia",
    "audiarăți": "audia",
    "audiase": "audia",
    "audiasem": "audia",
    "audiaseră": "audia",
    "audiaserăm": "audia",
    "audiaserăți": "audia",
    "audiaseși": "audia",
    "audiași": "audia",
    "audiat": "audia",
    "audiați": "audia",
    "audiatu": "audia",
    "audiau": "audia",
    "audiază": "audia",
    "audie": "audia",
    "audiem": "audia",
    "audiez": "audia",
    "audieze": "audia",
    "audiezi": "audia",
    "audiind": "audia",
    "audiindu": "audia",
    "neaudiind": "audia",
    "neaudiindu": "audia",
    "nemaiaudiind": "audia",
    "nemaiaudiindu": "audia",
    "audiata": "audiat",
    "audiată": "audiat",
    "audiate": "audiat",
    "audiatei": "audiat",
    "audiatele": "audiat",
    "audiatelor": "audiat",
    "audiați": "audiat",
    "audiații": "audiat",
    "audiaților": "audiat",
    "audiatul": "audiat",
    "audiatului": "audiat",
    "audibila": "audibil",
    "audibilă": "audibil",
    "audibile": "audibil",
    "audibilei": "audibil",
    "audibilele": "audibil",
    "audibilelor": "audibil",
    "audibili": "audibil",
    "audibilii": "audibil",
    "audibililor": "audibil",
    "audibilul": "audibil",
    "audibilului": "audibil",
    "audiența": "audiență",
    "audiențe": "audiență",
    "audienței": "audiență",
    "audiențele": "audiență",
    "audierea": "audiere",
    "audieri": "audiere",
    "audierii": "audiere",
    "audierile": "audiere",
    "auditul": "audit",
    "auditului": "audit",
    "audiția": "audiție",
    "audiției": "audiție",
    "audiții": "audiție",
    "audițiile": "audiție",
    "audițiilor": "audiție",
    "auditiva": "auditiv",
    "auditivă": "auditiv",
    "auditive": "auditiv",
    "auditivei": "auditiv",
    "auditivele": "auditiv",
    "auditivelor": "auditiv",
    "auditivi": "auditiv",
    "auditivii": "auditiv",
    "auditivilor": "auditiv",
    "auditivul": "auditiv",
    "auditivului": "auditiv",
    "auditoarea": "auditoare",
    "auditoarei": "auditoare",
    "auditoarele": "auditoare",
    "auditoarelor": "auditoare",
    "auditoare": "auditor",
    "auditoarea": "auditor",
    "auditoarei": "auditor",
    "auditoarele": "auditor",
    "auditoarelor": "auditor",
    "auditori": "auditor",
    "auditorii": "auditor",
    "auditorilor": "auditor",
    "auditorul": "auditor",
    "auditorului": "auditor",
    "auditorii": "auditoriu",
    "auditoriile": "auditoriu",
    "auditoriilor": "auditoriu",
    "auditoriul": "auditoriu",
    "auditoriului": "auditoriu",
    "augmentă": "augmenta",
    "augmentai": "augmenta",
    "augmentam": "augmenta",
    "augmentăm": "augmenta",
    "augmentând": "augmenta",
    "augmentându": "augmenta",
    "augmentară": "augmenta",
    "augmentarăm": "augmenta",
    "augmentarăți": "augmenta",
    "augmentase": "augmenta",
    "augmentasem": "augmenta",
    "augmentaseră": "augmenta",
    "augmentaserăm": "augmenta",
    "augmentaserăți": "augmenta",
    "augmentaseși": "augmenta",
    "augmentași": "augmenta",
    "augmentat": "augmenta",
    "augmentați": "augmenta",
    "augmentatu": "augmenta",
    "augmentau": "augmenta",
    "augmentează": "augmenta",
    "augmentez": "augmenta",
    "augmenteze": "augmenta",
    "augmentezi": "augmenta",
    "neaugmentând": "augmenta",
    "neaugmentându": "augmenta",
    "nemaiaugmentând": "augmenta",
    "nemaiaugmentându": "augmenta",
    "augmentarea": "augmentare",
    "augmentări": "augmentare",
    "augmentării": "augmentare",
    "augmentările": "augmentare",
    "augmentata": "augmentat",
    "augmentată": "augmentat",
    "augmentate": "augmentat",
    "augmentatei": "augmentat",
    "augmentatele": "augmentat",
    "augmentatelor": "augmentat",
    "augmentați": "augmentat",
    "augmentații": "augmentat",
    "augmentaților": "augmentat",
    "augmentatul": "augmentat",
    "augmentatului": "augmentat",
    "augmentative": "augmentativ",
    "augmentativele": "augmentativ",
    "augmentativelor": "augmentativ",
    "augmentativi": "augmentativ",
    "augmentativul": "augmentativ",
    "augmentativului": "augmentativ",
    "augure": "augur",
    "augurele": "augur",
    "augurelor": "augur",
    "auguri": "augur",
    "augurii": "augur",
    "augurilor": "augur",
    "augurul": "augur",
    "augurului": "augur",
    "aug.": "august",
    "augusta": "august",
    "augustă": "august",
    "auguste": "august",
    "augustei": "august",
    "augustele": "august",
    "augustelor": "august",
    "auguști": "august",
    "auguștii": "august",
    "auguștilor": "august",
    "augustul": "august",
    "augustului": "august",
    "aula": "aulă",
    "aule": "aulă",
    "aulei": "aulă",
    "aulele": "aulă",
    "aulelor": "aulă",
    "Au": "aur",
    "aurul": "aur",
    "aurului": "aur",
    "aura": "aură",
    "aure": "aură",
    "aurei": "aură",
    "aurele": "aură",
    "aurelor": "aură",
    "Aurele": "Aurel",
    "aureola": "aureolă",
    "aureole": "aureolă",
    "aureolei": "aureolă",
    "aureolele": "aureolă",
    "aureolelor": "aureolă",
    "aureolata": "aureolat",
    "aureolată": "aureolat",
    "aureolate": "aureolat",
    "aureolatei": "aureolat",
    "aureolatele": "aureolat",
    "aureolatelor": "aureolat",
    "aureolați": "aureolat",
    "aureolații": "aureolat",
    "aureolaților": "aureolat",
    "aureolatul": "aureolat",
    "aureolatului": "aureolat",
    "aurea": "auri",
    "aureai": "auri",
    "auream": "auri",
    "aurească": "auri",
    "aureați": "auri",
    "aureau": "auri",
    "auresc": "auri",
    "aurește": "auri",
    "aurești": "auri",
    "aurii": "auri",
    "aurim": "auri",
    "aurind": "auri",
    "aurindu": "auri",
    "auriră": "auri",
    "aurirăm": "auri",
    "aurirăți": "auri",
    "aurise": "auri",
    "aurisem": "auri",
    "auriseră": "auri",
    "auriserăm": "auri",
    "auriserăți": "auri",
    "auriseși": "auri",
    "auriși": "auri",
    "aurit": "auri",
    "auriți": "auri",
    "auritu": "auri",
    "neaurind": "auri",
    "neaurindu": "auri",
    "nemaiaurind": "auri",
    "nemaiaurindu": "auri",
    "auricule": "auricul",
    "auriculele": "auricul",
    "auriculelor": "auricul",
    "auriculul": "auricul",
    "auriculului": "auricul",
    "auriculara": "auricular",
    "auriculară": "auricular",
    "auriculare": "auricular",
    "auricularei": "auricular",
    "auricularele": "auricular",
    "auricularelor": "auricular",
    "auriculari": "auricular",
    "auricularii": "auricular",
    "auricularilor": "auricular",
    "auricularul": "auricular",
    "auricularului": "auricular",
    "aurifera": "aurifer",
    "auriferă": "aurifer",
    "aurifere": "aurifer",
    "auriferei": "aurifer",
    "auriferele": "aurifer",
    "auriferelor": "aurifer",
    "auriferi": "aurifer",
    "auriferii": "aurifer",
    "auriferilor": "aurifer",
    "auriferul": "aurifer",
    "auriferului": "aurifer",
    "aurirea": "aurire",
    "auriri": "aurire",
    "auririi": "aurire",
    "auririle": "aurire",
    "aurita": "aurit",
    "aurită": "aurit",
    "aurite": "aurit",
    "auritei": "aurit",
    "auritele": "aurit",
    "auritelor": "aurit",
    "auriți": "aurit",
    "auriții": "aurit",
    "auriților": "aurit",
    "auritul": "aurit",
    "auritului": "aurit",
    "auziții": "aurit",
    "auria": "auriu",
    "aurie": "auriu",
    "auriei": "auriu",
    "auriele": "auriu",
    "aurielor": "auriu",
    "aurii": "auriu",
    "auriii": "auriu",
    "auriilor": "auriu",
    "auriul": "auriu",
    "auriului": "auriu",
    "auriu-cenușiu-verzuie": "auriu-cenușiu-verzui",
    "aurolaci": "aurolac",
    "aurolacii": "aurolac",
    "aurolacilor": "aurolac",
    "aurolacul": "aurolac",
    "aurolacului": "aurolac",
    "aurolaca": "aurolacă",
    "aurolace": "aurolacă",
    "aurolacei": "aurolacă",
    "aurolacele": "aurolacă",
    "aurolacelor": "aurolacă",
    "aurora": "auroră",
    "aurore": "auroră",
    "aurorei": "auroră",
    "aurorele": "auroră",
    "aurorelor": "auroră",
    "auspicii": "auspiciu",
    "auspiciile": "auspiciu",
    "auspiciilor": "auspiciu",
    "auspiciul": "auspiciu",
    "auspiciului": "auspiciu",
    "austera": "auster",
    "austeră": "auster",
    "austere": "auster",
    "austerei": "auster",
    "austerele": "auster",
    "austerelor": "auster",
    "austeri": "auster",
    "austerii": "auster",
    "austerilor": "auster",
    "austerul": "auster",
    "austerului": "auster",
    "austeritatea": "austeritate",
    "austerități": "austeritate",
    "austerității": "austeritate",
    "austeritățile": "austeritate",
    "austerităților": "austeritate",
    "australa": "austral",
    "australă": "austral",
    "australe": "austral",
    "australei": "austral",
    "australele": "austral",
    "australelor": "austral",
    "australi": "austral",
    "australii": "austral",
    "australilor": "austral",
    "australul": "austral",
    "australului": "austral",
    "Austr.": "Australia",
    "Australie": "Australia",
    "Australiei": "Australia",
    "Australii": "Australia",
    "australiana": "australian",
    "australiană": "australian",
    "australianul": "australian",
    "australianului": "australian",
    "australiene": "australian",
    "australienei": "australian",
    "australienele": "australian",
    "australienelor": "australian",
    "australieni": "australian",
    "australienii": "australian",
    "australienilor": "australian",
    "australianca": "australiancă",
    "australience": "australiancă",
    "australiencei": "australiancă",
    "australiencele": "australiancă",
    "australiencelor": "australiancă",
    "Aus.": "Austria",
    "Austrie": "Austria",
    "Austriei": "Austria",
    "Austrii": "Austria",
    "austriaca": "austriac",
    "austriacă": "austriac",
    "austriacul": "austriac",
    "austriacului": "austriac",
    "austriece": "austriac",
    "austriecei": "austriac",
    "austriecele": "austriac",
    "austriecelor": "austriac",
    "austrieci": "austriac",
    "austriecii": "austriac",
    "austriecilor": "austriac",
    "austriaca": "austriacă",
    "austriece": "austriacă",
    "austriecei": "austriacă",
    "austriecele": "austriacă",
    "austriecelor": "austriacă",
    "austro-ungară": "austro-ungar",
    "austro-ungare": "austro-ungar",
    "austro-ungari": "austro-ungar",
    "austre": "austru",
    "austrele": "austru",
    "austrelor": "austru",
    "austrul": "austru",
    "austrului": "austru",
    "autarhica": "autarhic",
    "autarhică": "autarhic",
    "autarhice": "autarhic",
    "autarhicei": "autarhic",
    "autarhicele": "autarhic",
    "autarhicelor": "autarhic",
    "autarhici": "autarhic",
    "autarhicii": "autarhic",
    "autarhicilor": "autarhic",
    "autarhicul": "autarhic",
    "autarhicului": "autarhic",
    "autentica": "autentic",
    "autentică": "autentic",
    "autentice": "autentic",
    "autenticei": "autentic",
    "autenticele": "autentic",
    "autenticelor": "autentic",
    "autentici": "autentic",
    "autenticii": "autentic",
    "autenticilor": "autentic",
    "autenticul": "autentic",
    "autenticului": "autentic",
    "autentific": "autentifica",
    "autentifică": "autentifica",
    "autentificai": "autentifica",
    "autentificam": "autentifica",
    "autentificăm": "autentifica",
    "autentificând": "autentifica",
    "autentificându": "autentifica",
    "autentificară": "autentifica",
    "autentificarăm": "autentifica",
    "autentificarăți": "autentifica",
    "autentificase": "autentifica",
    "autentificasem": "autentifica",
    "autentificaseră": "autentifica",
    "autentificaserăm": "autentifica",
    "autentificaserăți": "autentifica",
    "autentificaseși": "autentifica",
    "autentificași": "autentifica",
    "autentificat": "autentifica",
    "autentificați": "autentifica",
    "autentificatu": "autentifica",
    "autentificau": "autentifica",
    "autentifice": "autentifica",
    "autentifici": "autentifica",
    "neautentificând": "autentifica",
    "neautentificându": "autentifica",
    "nemaiautentificând": "autentifica",
    "nemaiautentificându": "autentifica",
    "autentificarea": "autentificare",
    "autentificări": "autentificare",
    "autentificării": "autentificare",
    "autentificările": "autentificare",
    "autentificata": "autentificat",
    "autentificată": "autentificat",
    "autentificate": "autentificat",
    "autentificatei": "autentificat",
    "autentificatele": "autentificat",
    "autentificatelor": "autentificat",
    "autentificați": "autentificat",
    "autentificații": "autentificat",
    "autentificaților": "autentificat",
    "autentificatul": "autentificat",
    "autentificatului": "autentificat",
    "autoamăgirea": "autoamăgire",
    "autoamăgiri": "autoamăgire",
    "autoamăgirii": "autoamăgire",
    "autoamăgirile": "autoamăgire",
    "autoamăgirilor": "autoamăgire",
    "autoanaliza": "autoanaliză",
    "autoanalize": "autoanaliză",
    "autoanalizei": "autoanaliză",
    "autoanalizele": "autoanaliză",
    "autoanalizelor": "autoanaliză",
    "auto-anihilarea": "auto-anihilare",
    "auto-anihilări": "auto-anihilare",
    "auto-anihilării": "auto-anihilare",
    "auto-anihilările": "auto-anihilare",
    "auto-anihilărilor": "auto-anihilare",
    "autoapăr": "autoapăra",
    "autoapără": "autoapăra",
    "autoapărai": "autoapăra",
    "autoapăram": "autoapăra",
    "autoapărăm": "autoapăra",
    "autoapărând": "autoapăra",
    "autoapărându": "autoapăra",
    "autoapărară": "autoapăra",
    "autoapărarăm": "autoapăra",
    "autoapărarăți": "autoapăra",
    "autoapărase": "autoapăra",
    "autoapărasem": "autoapăra",
    "autoapăraseră": "autoapăra",
    "autoapăraserăm": "autoapăra",
    "autoapăraserăți": "autoapăra",
    "autoapăraseși": "autoapăra",
    "autoapărași": "autoapăra",
    "autoapărat": "autoapăra",
    "autoapărați": "autoapăra",
    "autoapăratu": "autoapăra",
    "autoapărau": "autoapăra",
    "autoapărabilă": "autoapărabil",
    "autoapărabile": "autoapărabil",
    "autoapărabili": "autoapărabil",
    "autoapărarea": "autoapărare",
    "autoapărări": "autoapărare",
    "autoapărării": "autoapărare",
    "autoapărările": "autoapărare",
    "autoapărata": "autoapărat",
    "autoapărată": "autoapărat",
    "autoapărate": "autoapărat",
    "autoapăratei": "autoapărat",
    "autoapăratele": "autoapărat",
    "autoapăratelor": "autoapărat",
    "autoapărați": "autoapărat",
    "autoapărații": "autoapărat",
    "autoapăraților": "autoapărat",
    "autoapăratul": "autoapărat",
    "autoapăratului": "autoapărat",
    "autoapărătoarea": "autoapărătoare",
    "autoapărătoarei": "autoapărătoare",
    "autoapărătoarele": "autoapărătoare",
    "autoapărătoarelor": "autoapărătoare",
    "autoapărătoare": "autoapărător",
    "autoapărătoarea": "autoapărător",
    "autoapărătoarei": "autoapărător",
    "autoapărătoarele": "autoapărător",
    "autoapărătoarelor": "autoapărător",
    "autoapărători": "autoapărător",
    "autoapărătorii": "autoapărător",
    "autoapărătorilor": "autoapărător",
    "autoapărătorul": "autoapărător",
    "autoapărătorului": "autoapărător",
    "autoarea": "autoare",
    "autoarei": "autoare",
    "autoarele": "autoare",
    "autoarelor": "autoare",
    "auto-asigur": "auto-asigura",
    "auto-asigură": "auto-asigura",
    "auto-asigurai": "auto-asigura",
    "auto-asiguram": "auto-asigura",
    "auto-asigurăm": "auto-asigura",
    "auto-asigurând": "auto-asigura",
    "auto-asigurându": "auto-asigura",
    "auto-asigurară": "auto-asigura",
    "auto-asigurarăm": "auto-asigura",
    "auto-asigurarăți": "auto-asigura",
    "auto-asigurase": "auto-asigura",
    "auto-asigurasem": "auto-asigura",
    "auto-asiguraseră": "auto-asigura",
    "auto-asiguraserăm": "auto-asigura",
    "auto-asiguraserăți": "auto-asigura",
    "auto-asiguraseși": "auto-asigura",
    "auto-asigurași": "auto-asigura",
    "auto-asigurat": "auto-asigura",
    "auto-asigurați": "auto-asigura",
    "auto-asiguratu": "auto-asigura",
    "auto-asigurau": "auto-asigura",
    "auto-asigure": "auto-asigura",
    "auto-asiguri": "auto-asigura",
    "auto-asigurată": "auto-asigurat",
    "auto-asigurate": "auto-asigurat",
    "auto-asigurați": "auto-asigurat",
    "autobaza": "autobază",
    "autobaze": "autobază",
    "autobazei": "autobază",
    "autobazele": "autobază",
    "autobazelor": "autobază",
    "autobiografica": "autobiografic",
    "autobiografică": "autobiografic",
    "autobiografice": "autobiografic",
    "autobiograficei": "autobiografic",
    "autobiograficele": "autobiografic",
    "autobiograficelor": "autobiografic",
    "autobiografici": "autobiografic",
    "autobiograficii": "autobiografic",
    "autobiograficilor": "autobiografic",
    "autobiograficul": "autobiografic",
    "autobiograficului": "autobiografic",
    "autobiografia": "autobiografie",
    "autobiografiei": "autobiografie",
    "autobiografii": "autobiografie",
    "autobiografiile": "autobiografie",
    "autobiografiilor": "autobiografie",
    "autoblindate": "autoblindat",
    "autoblindatele": "autoblindat",
    "autoblindatelor": "autoblindat",
    "autoblindatul": "autoblindat",
    "autoblindatului": "autoblindat",
    "autobuze": "autobuz",
    "autobuzele": "autobuz",
    "autobuzelor": "autobuz",
    "autobuzul": "autobuz",
    "autobuzului": "autobuz",
    "autocare": "autocar",
    "autocarele": "autocar",
    "autocarelor": "autocar",
    "autocarul": "autocar",
    "autocarului": "autocar",
    "autocefala": "autocefal",
    "autocefală": "autocefal",
    "autocefale": "autocefal",
    "autocefalei": "autocefal",
    "autocefalele": "autocefal",
    "autocefalelor": "autocefal",
    "autocefali": "autocefal",
    "autocefalii": "autocefal",
    "autocefalilor": "autocefal",
    "autocefalul": "autocefal",
    "autocefalului": "autocefal",
    "autocompătimirii": "autocompătimire",
    "autocontrazicerea": "autocontrazicere",
    "autocontraziceri": "autocontrazicere",
    "autocontrazicerii": "autocontrazicere",
    "autocontrazicerile": "autocontrazicere",
    "autocontrazicerilor": "autocontrazicere",
    "auto-conving": "auto-convinge",
    "auto-convingă": "auto-convinge",
    "auto-convingând": "auto-convinge",
    "auto-convingându": "auto-convinge",
    "auto-convingea": "auto-convinge",
    "auto-convingeai": "auto-convinge",
    "auto-convingeam": "auto-convinge",
    "auto-convingeați": "auto-convinge",
    "auto-convingeau": "auto-convinge",
    "auto-convingem": "auto-convinge",
    "auto-convingeți": "auto-convinge",
    "auto-convingi": "auto-convinge",
    "auto-convins": "auto-convinge",
    "auto-convinse": "auto-convinge",
    "auto-convinsei": "auto-convinge",
    "auto-convinseră": "auto-convinge",
    "auto-convinserăm": "auto-convinge",
    "auto-convinserăți": "auto-convinge",
    "auto-convinsese": "auto-convinge",
    "auto-convinsesem": "auto-convinge",
    "auto-convinseseră": "auto-convinge",
    "auto-convinseserăm": "auto-convinge",
    "auto-convinseserăți": "auto-convinge",
    "auto-convinseseși": "auto-convinge",
    "auto-convinseși": "auto-convinge",
    "auto-convinsu": "auto-convinge",
    "autoconvingerea": "autoconvingere",
    "autoconvingeri": "autoconvingere",
    "autoconvingerii": "autoconvingere",
    "autoconvingerile": "autoconvingere",
    "autoconvingerilor": "autoconvingere",
    "auto-convinsă": "auto-convins",
    "auto-convinse": "auto-convins",
    "auto-convinși": "auto-convins",
    "autocratica": "autocratic",
    "autocratică": "autocratic",
    "autocratice": "autocratic",
    "autocraticei": "autocratic",
    "autocraticele": "autocratic",
    "autocraticelor": "autocratic",
    "autocratici": "autocratic",
    "autocraticii": "autocratic",
    "autocraticilor": "autocratic",
    "autocraticul": "autocratic",
    "autocraticului": "autocratic",
    "autocritica": "autocritic",
    "autocritică": "autocritic",
    "autocritice": "autocritic",
    "autocriticei": "autocritic",
    "autocriticele": "autocritic",
    "autocriticelor": "autocritic",
    "autocritici": "autocritic",
    "autocriticii": "autocritic",
    "autocriticilor": "autocritic",
    "autocriticul": "autocritic",
    "autocriticului": "autocritic",
    "autocunoașterea": "autocunoaștere",
    "autocunoașteri": "autocunoaștere",
    "autocunoașterii": "autocunoaștere",
    "autocunoașterile": "autocunoaștere",
    "autocunoașterilor": "autocunoaștere",
    "autodafeul": "autodafe",
    "autodafeului": "autodafe",
    "autodafeuri": "autodafe",
    "autodafeurile": "autodafe",
    "autodafeurilor": "autodafe",
    "autodefinea": "autodefini",
    "autodefineai": "autodefini",
    "autodefineam": "autodefini",
    "autodefinească": "autodefini",
    "autodefineați": "autodefini",
    "autodefineau": "autodefini",
    "autodefinesc": "autodefini",
    "autodefinește": "autodefini",
    "autodefinești": "autodefini",
    "autodefinii": "autodefini",
    "autodefinim": "autodefini",
    "autodefinind": "autodefini",
    "autodefinindu": "autodefini",
    "autodefiniră": "autodefini",
    "autodefinirăm": "autodefini",
    "autodefinirăți": "autodefini",
    "autodefinise": "autodefini",
    "autodefinisem": "autodefini",
    "autodefiniseră": "autodefini",
    "autodefiniserăm": "autodefini",
    "autodefiniserăți": "autodefini",
    "autodefiniseși": "autodefini",
    "autodefiniși": "autodefini",
    "autodefinit": "autodefini",
    "autodefiniți": "autodefini",
    "autodefinitu": "autodefini",
    "autodefinită": "autodefinit",
    "autodefinite": "autodefinit",
    "autodefiniți": "autodefinit",
    "autodenunțătoarea": "autodenunțătoare",
    "autodenunțătoarei": "autodenunțătoare",
    "autodenunțătoarele": "autodenunțătoare",
    "autodenunțătoarelor": "autodenunțătoare",
    "autodenunțătoare": "autodenunțător",
    "autodenunțătoarea": "autodenunțător",
    "autodenunțătoarei": "autodenunțător",
    "autodenunțătoarele": "autodenunțător",
    "autodenunțătoarelor": "autodenunțător",
    "autodenunțători": "autodenunțător",
    "autodenunțătorii": "autodenunțător",
    "autodenunțătorilor": "autodenunțător",
    "autodenunțătorul": "autodenunțător",
    "autodenunțătorului": "autodenunțător",
    "autodezvăluirea": "autodezvăluire",
    "autodezvăluiri": "autodezvăluire",
    "autodezvăluirii": "autodezvăluire",
    "autodezvăluirile": "autodezvăluire",
    "autodezvăluirilor": "autodezvăluire",
    "autodidacta": "autodidact",
    "autodidactă": "autodidact",
    "autodidacte": "autodidact",
    "autodidactei": "autodidact",
    "autodidactele": "autodidact",
    "autodidactelor": "autodidact",
    "autodidacți": "autodidact",
    "autodidacții": "autodidact",
    "autodidacților": "autodidact",
    "autodidactul": "autodidact",
    "autodidactului": "autodidact",
    "autodisciplina": "autodisciplină",
    "autodiscipline": "autodisciplină",
    "autodisciplinei": "autodisciplină",
    "autodisciplinele": "autodisciplină",
    "autodisciplinelor": "autodisciplină",
    "autodisponibilizarea": "autodisponibilizare",
    "autodisponibilizări": "autodisponibilizare",
    "autodisponibilizării": "autodisponibilizare",
    "autodisponibilizările": "autodisponibilizare",
    "autodisponibilizați": "autodisponibilizat",
    "autodisponibilizații": "autodisponibilizat",
    "autodisponibilizaților": "autodisponibilizat",
    "autodisponibilizatul": "autodisponibilizat",
    "autodisponibilizatului": "autodisponibilizat",
    "autodistrugerea": "autodistrugere",
    "autodistrugeri": "autodistrugere",
    "autodistrugerii": "autodistrugere",
    "autodistrugerile": "autodistrugere",
    "autodistrugerilor": "autodistrugere",
    "auto-examinarea": "auto-examinare",
    "auto-examinări": "auto-examinare",
    "auto-examinării": "auto-examinare",
    "auto-examinările": "auto-examinare",
    "auto-examinărilor": "auto-examinare",
    "autoflagelarea": "autoflagelare",
    "autoflagelări": "autoflagelare",
    "autoflagelării": "autoflagelare",
    "autoflagelările": "autoflagelare",
    "autoflagelărilor": "autoflagelare",
    "autoformarea": "autoformare",
    "autoformări": "autoformare",
    "autoformării": "autoformare",
    "autoformările": "autoformare",
    "autoformărilor": "autoformare",
    "autogena": "autogen",
    "autogenă": "autogen",
    "autogene": "autogen",
    "autogenei": "autogen",
    "autogenele": "autogen",
    "autogenelor": "autogen",
    "autogeni": "autogen",
    "autogenii": "autogen",
    "autogenilor": "autogen",
    "autogenul": "autogen",
    "autogenului": "autogen",
    "autogestionara": "autogestionar",
    "autogestionară": "autogestionar",
    "autogestionare": "autogestionar",
    "autogestionarei": "autogestionar",
    "autogestionarele": "autogestionar",
    "autogestionarelor": "autogestionar",
    "autogestionari": "autogestionar",
    "autogestionarii": "autogestionar",
    "autogestionarilor": "autogestionar",
    "autogestionarul": "autogestionar",
    "autogestionarului": "autogestionar",
    "autografa": "autograf",
    "autografă": "autograf",
    "autografe": "autograf",
    "autografei": "autograf",
    "autografele": "autograf",
    "autografelor": "autograf",
    "autografi": "autograf",
    "autografii": "autograf",
    "autografilor": "autograf",
    "autograful": "autograf",
    "autografului": "autograf",
    "auto-hipnoza": "auto-hipnoză",
    "auto-hipnoze": "auto-hipnoză",
    "auto-hipnozei": "auto-hipnoză",
    "auto-hipnozele": "auto-hipnoză",
    "auto-hipnozelor": "auto-hipnoză",
    "autohtona": "autohton",
    "autohtonă": "autohton",
    "autohtone": "autohton",
    "autohtonei": "autohton",
    "autohtonele": "autohton",
    "autohtonelor": "autohton",
    "autohtoni": "autohton",
    "autohtonii": "autohton",
    "autohtonilor": "autohton",
    "autohtonul": "autohton",
    "autohtonului": "autohton",
    "autoiluzionarea": "autoiluzionare",
    "autoiluzionări": "autoiluzionare",
    "autoiluzionării": "autoiluzionare",
    "autoiluzionările": "autoiluzionare",
    "autoiluzionărilor": "autoiluzionare",
    "autoimpusa": "autoimpus",
    "autoimpusă": "autoimpus",
    "autoimpuse": "autoimpus",
    "autoimpusei": "autoimpus",
    "autoimpusele": "autoimpus",
    "autoimpuselor": "autoimpus",
    "autoimpuși": "autoimpus",
    "autoimpușii": "autoimpus",
    "autoimpușilor": "autoimpus",
    "autoimpusul": "autoimpus",
    "autoimpusului": "autoimpus",
    "auto-învinovățea": "auto-învinovăți",
    "auto-învinovățeai": "auto-învinovăți",
    "auto-învinovățeam": "auto-învinovăți",
    "auto-învinovățească": "auto-învinovăți",
    "auto-învinovățeați": "auto-învinovăți",
    "auto-învinovățeau": "auto-învinovăți",
    "auto-învinovățesc": "auto-învinovăți",
    "auto-învinovățește": "auto-învinovăți",
    "auto-învinovățești": "auto-învinovăți",
    "auto-învinovății": "auto-învinovăți",
    "auto-învinovățim": "auto-învinovăți",
    "auto-învinovățind": "auto-învinovăți",
    "auto-învinovățindu": "auto-învinovăți",
    "auto-învinovățiră": "auto-învinovăți",
    "auto-învinovățirăm": "auto-învinovăți",
    "auto-învinovățirăți": "auto-învinovăți",
    "auto-învinovățise": "auto-învinovăți",
    "auto-învinovățisem": "auto-învinovăți",
    "auto-învinovățiseră": "auto-învinovăți",
    "auto-învinovățiserăm": "auto-învinovăți",
    "auto-învinovățiserăți": "auto-învinovăți",
    "auto-învinovățiseși": "auto-învinovăți",
    "auto-învinovățiși": "auto-învinovăți",
    "auto-învinovățit": "auto-învinovăți",
    "auto-învinovățiți": "auto-învinovăți",
    "auto-învinovățitu": "auto-învinovăți",
    "auto-învinovățită": "auto-învinovățit",
    "auto-învinovățite": "auto-învinovățit",
    "auto-învinovățiți": "auto-învinovățit",
    "autoînvinuia": "autoînvinui",
    "autoînvinuiai": "autoînvinui",
    "autoînvinuiam": "autoînvinui",
    "autoînvinuiască": "autoînvinui",
    "autoînvinuiați": "autoînvinui",
    "autoînvinuiau": "autoînvinui",
    "autoînvinuiește": "autoînvinui",
    "autoînvinuiești": "autoînvinui",
    "autoînvinuii": "autoînvinui",
    "autoînvinuim": "autoînvinui",
    "autoînvinuind": "autoînvinui",
    "autoînvinuindu": "autoînvinui",
    "autoînvinuiră": "autoînvinui",
    "autoînvinuirăm": "autoînvinui",
    "autoînvinuirăți": "autoînvinui",
    "autoînvinuisc": "autoînvinui",
    "autoînvinuise": "autoînvinui",
    "autoînvinuisem": "autoînvinui",
    "autoînvinuiseră": "autoînvinui",
    "autoînvinuiserăm": "autoînvinui",
    "autoînvinuiserăți": "autoînvinui",
    "autoînvinuiseși": "autoînvinui",
    "autoînvinuiși": "autoînvinui",
    "autoînvinuit": "autoînvinui",
    "autoînvinuiți": "autoînvinui",
    "autoînvinuitu": "autoînvinui",
    "autoînvinuită": "autoînvinuit",
    "autoînvinuite": "autoînvinuit",
    "autoînvinuiți": "autoînvinuit",
    "automata": "automat",
    "automată": "automat",
    "automate": "automat",
    "automatei": "automat",
    "automatele": "automat",
    "automatelor": "automat",
    "automați": "automat",
    "automații": "automat",
    "automaților": "automat",
    "automatul": "automat",
    "automatului": "automat",
    "automatica": "automatic",
    "automatică": "automatic",
    "automatice": "automatic",
    "automaticei": "automatic",
    "automaticele": "automatic",
    "automaticelor": "automatic",
    "automatici": "automatic",
    "automaticii": "automatic",
    "automaticilor": "automatic",
    "automaticul": "automatic",
    "automaticului": "automatic",
    "automatisme": "automatism",
    "automatismele": "automatism",
    "automatismelor": "automatism",
    "automatismul": "automatism",
    "automatismului": "automatism",
    "automobila": "automobil",
    "automobilă": "automobil",
    "automobile": "automobil",
    "automobilei": "automobil",
    "automobilele": "automobil",
    "automobilelor": "automobil",
    "automobili": "automobil",
    "automobilii": "automobil",
    "automobililor": "automobil",
    "automobilul": "automobil",
    "automobilului": "automobil",
    "automobilistica": "automobilistic",
    "automobilistică": "automobilistic",
    "automobilistice": "automobilistic",
    "automobilisticei": "automobilistic",
    "automobilisticele": "automobilistic",
    "automobilisticelor": "automobilistic",
    "automobilistici": "automobilistic",
    "automobilisticii": "automobilistic",
    "automobilisticilor": "automobilistic",
    "automobilisticul": "automobilistic",
    "automobilisticului": "automobilistic",
    "automulțumirea": "automulțumire",
    "automulțumiri": "automulțumire",
    "automulțumirii": "automulțumire",
    "automulțumirile": "automulțumire",
    "automulțumirilor": "automulțumire",
    "autonegarea": "autonegare",
    "autonegări": "autonegare",
    "autonegării": "autonegare",
    "autonegările": "autonegare",
    "autonegărilor": "autonegare",
    "autonoma": "autonom",
    "autonomă": "autonom",
    "autonome": "autonom",
    "autonomei": "autonom",
    "autonomele": "autonom",
    "autonomelor": "autonom",
    "autonomi": "autonom",
    "autonomii": "autonom",
    "autonomilor": "autonom",
    "autonomul": "autonom",
    "autonomului": "autonom",
    "autonomia": "autonomie",
    "autonomiei": "autonomie",
    "autonomii": "autonomie",
    "autonomiile": "autonomie",
    "autonomiilor": "autonomie",
    "autoproclamata": "autoproclamat",
    "autoproclamată": "autoproclamat",
    "autoproclamate": "autoproclamat",
    "autoproclamatei": "autoproclamat",
    "autoproclamatele": "autoproclamat",
    "autoproclamatelor": "autoproclamat",
    "autoproclamați": "autoproclamat",
    "autoproclamații": "autoproclamat",
    "autoproclamaților": "autoproclamat",
    "autoproclamatul": "autoproclamat",
    "autoproclamatului": "autoproclamat",
    "autopropulsata": "autopropulsat",
    "autopropulsată": "autopropulsat",
    "autopropulsate": "autopropulsat",
    "autopropulsatei": "autopropulsat",
    "autopropulsatele": "autopropulsat",
    "autopropulsatelor": "autopropulsat",
    "autopropulsați": "autopropulsat",
    "autopropulsații": "autopropulsat",
    "autopropulsaților": "autopropulsat",
    "autopropulsatul": "autopropulsat",
    "autopropulsatului": "autopropulsat",
    "autopsia": "autopsie",
    "autopsiei": "autopsie",
    "autopsii": "autopsie",
    "autopsiile": "autopsie",
    "autopsiilor": "autopsie",
    "autopsierea": "autopsiere",
    "autopsieri": "autopsiere",
    "autopsierii": "autopsiere",
    "autopsierile": "autopsiere",
    "autori": "autor",
    "autorii": "autor",
    "autorilor": "autor",
    "autorul": "autor",
    "autorului": "autor",
    "autoritara": "autoritar",
    "autoritară": "autoritar",
    "autoritare": "autoritar",
    "autoritarei": "autoritar",
    "autoritarele": "autoritar",
    "autoritarelor": "autoritar",
    "autoritari": "autoritar",
    "autoritarii": "autoritar",
    "autoritarilor": "autoritar",
    "autoritarul": "autoritar",
    "autoritarului": "autoritar",
    "autoritatea": "autoritate",
    "autorități": "autoritate",
    "autorității": "autoritate",
    "autoritățile": "autoritate",
    "autorităților": "autoritate",
    "autoriză": "autoriza",
    "autorizai": "autoriza",
    "autorizam": "autoriza",
    "autorizăm": "autoriza",
    "autorizând": "autoriza",
    "autorizându": "autoriza",
    "autorizară": "autoriza",
    "autorizarăm": "autoriza",
    "autorizarăți": "autoriza",
    "autorizase": "autoriza",
    "autorizasem": "autoriza",
    "autorizaseră": "autoriza",
    "autorizaserăm": "autoriza",
    "autorizaserăți": "autoriza",
    "autorizaseși": "autoriza",
    "autorizași": "autoriza",
    "autorizat": "autoriza",
    "autorizați": "autoriza",
    "autorizatu": "autoriza",
    "autorizau": "autoriza",
    "autorizează": "autoriza",
    "autorizez": "autoriza",
    "autorizeze": "autoriza",
    "autorizezi": "autoriza",
    "neautorizând": "autoriza",
    "neautorizându": "autoriza",
    "nemaiautorizând": "autoriza",
    "nemaiautorizându": "autoriza",
    "autorizarea": "autorizare",
    "autorizări": "autorizare",
    "autorizării": "autorizare",
    "autorizările": "autorizare",
    "autorizata": "autorizat",
    "autorizată": "autorizat",
    "autorizate": "autorizat",
    "autorizatei": "autorizat",
    "autorizatele": "autorizat",
    "autorizatelor": "autorizat",
    "autorizați": "autorizat",
    "autorizații": "autorizat",
    "autorizaților": "autorizat",
    "autorizatul": "autorizat",
    "autorizatului": "autorizat",
    "autorizația": "autorizație",
    "autorizației": "autorizație",
    "autorizații": "autorizație",
    "autorizațiile": "autorizație",
    "autorizațiilor": "autorizație",
    "autostrada": "autostradă",
    "autostrăzi": "autostradă",
    "autostrăzii": "autostradă",
    "autostrăzile": "autostradă",
    "autostrăzilor": "autostradă",
    "autotrenul": "autotren",
    "autotrenului": "autotren",
    "autotrenuri": "autotren",
    "autotrenurile": "autotren",
    "autotrenurilor": "autotren",
    "autoturisme": "autoturism",
    "autoturismele": "autoturism",
    "autoturismelor": "autoturism",
    "autoturismul": "autoturism",
    "autoturismului": "autoturism",
    "autoumilirea": "autoumilire",
    "autoumiliri": "autoumilire",
    "autoumilirii": "autoumilire",
    "autoumilirile": "autoumilire",
    "autoumilirilor": "autoumilire",
    "autovehicule": "autovehicul",
    "autovehiculele": "autovehicul",
    "autovehiculelor": "autovehicul",
    "autovehiculul": "autovehicul",
    "autovehiculului": "autovehicul",
    "autumnala": "autumnal",
    "autumnală": "autumnal",
    "autumnale": "autumnal",
    "autumnalei": "autumnal",
    "autumnalele": "autumnal",
    "autumnalelor": "autumnal",
    "autumnali": "autumnal",
    "autumnalii": "autumnal",
    "autumnalilor": "autumnal",
    "autumnalul": "autumnal",
    "autumnalului": "autumnal",
    "auxiliara": "auxiliar",
    "auxiliară": "auxiliar",
    "auxiliare": "auxiliar",
    "auxiliarei": "auxiliar",
    "auxiliarele": "auxiliar",
    "auxiliarelor": "auxiliar",
    "auxiliari": "auxiliar",
    "auxiliarii": "auxiliar",
    "auxiliarilor": "auxiliar",
    "auxiliarul": "auxiliar",
    "auxiliarului": "auxiliar",
    "auzul": "auz",
    "auzului": "auz",
    "aud": "auzi",
    "audă": "auzi",
    "aude": "auzi",
    "auzea": "auzi",
    "auzeai": "auzi",
    "auzeam": "auzi",
    "auzeați": "auzi",
    "auzeau": "auzi",
    "auzii": "auzi",
    "auzim": "auzi",
    "auzind": "auzi",
    "auzindu": "auzi",
    "auziră": "auzi",
    "auzirăm": "auzi",
    "auzirăți": "auzi",
    "auzise": "auzi",
    "auzisem": "auzi",
    "auziseră": "auzi",
    "auziserăm": "auzi",
    "auziserăți": "auzi",
    "auziseși": "auzi",
    "auziși": "auzi",
    "auzit": "auzi",
    "auziți": "auzi",
    "auzitu": "auzi",
    "neauzind": "auzi",
    "neauzindu": "auzi",
    "nemaiauzind": "auzi",
    "nemaiauzindu": "auzi",
    "auzirea": "auzire",
    "auziri": "auzire",
    "auzirii": "auzire",
    "auzirile": "auzire",
    "auzirilor": "auzire",
    "auzita": "auzit",
    "auzită": "auzit",
    "auzite": "auzit",
    "auzitei": "auzit",
    "auzitele": "auzit",
    "auzitelor": "auzit",
    "auziți": "auzit",
    "auziții": "auzit",
    "auziților": "auzit",
    "auzitul": "auzit",
    "auzitului": "auzit",
    "avalanșa": "avalanșă",
    "avalanșe": "avalanșă",
    "avalanșei": "avalanșă",
    "avalanșele": "avalanșă",
    "avalanșelor": "avalanșă",
    "avaliști": "avalist",
    "avaliștii": "avalist",
    "avaliștilor": "avalist",
    "avalistul": "avalist",
    "avalistului": "avalist",
    "avalista": "avalistă",
    "avaliste": "avalistă",
    "avalistei": "avalistă",
    "avalistele": "avalistă",
    "avalistelor": "avalistă",
    "avaliză": "avaliza",
    "avalizai": "avaliza",
    "avalizam": "avaliza",
    "avalizăm": "avaliza",
    "avalizând": "avaliza",
    "avalizându": "avaliza",
    "avalizară": "avaliza",
    "avalizarăm": "avaliza",
    "avalizarăți": "avaliza",
    "avalizase": "avaliza",
    "avalizasem": "avaliza",
    "avalizaseră": "avaliza",
    "avalizaserăm": "avaliza",
    "avalizaserăți": "avaliza",
    "avalizaseși": "avaliza",
    "avalizași": "avaliza",
    "avalizat": "avaliza",
    "avalizați": "avaliza",
    "avalizatu": "avaliza",
    "avalizau": "avaliza",
    "avalizează": "avaliza",
    "avalizez": "avaliza",
    "avalizeze": "avaliza",
    "avalizezi": "avaliza",
    "avalizarea": "avalizare",
    "avalizări": "avalizare",
    "avalizării": "avalizare",
    "avalizările": "avalizare",
    "avalizata": "avalizat",
    "avalizată": "avalizat",
    "avalizate": "avalizat",
    "avalizatei": "avalizat",
    "avalizatele": "avalizat",
    "avalizatelor": "avalizat",
    "avalizați": "avalizat",
    "avalizații": "avalizat",
    "avalizaților": "avalizat",
    "avalizatul": "avalizat",
    "avalizatului": "avalizat",
    "avana": "avan",
    "avană": "avan",
    "avane": "avan",
    "avanei": "avan",
    "avanele": "avan",
    "avanelor": "avan",
    "avani": "avan",
    "avanii": "avan",
    "avanilor": "avan",
    "avanul": "avan",
    "avanului": "avan",
    "avangarda": "avangardă",
    "avangardei": "avangardă",
    "avangărzi": "avangardă",
    "avangărzii": "avangardă",
    "avangărzile": "avangardă",
    "avangărzilor": "avangardă",
    "avangardismul": "avangardism",
    "avangardismului": "avangardism",
    "avangardista": "avangardist",
    "avangardistă": "avangardist",
    "avangardiste": "avangardist",
    "avangardistei": "avangardist",
    "avangardistele": "avangardist",
    "avangardistelor": "avangardist",
    "avangardiști": "avangardist",
    "avangardiștii": "avangardist",
    "avangardiștilor": "avangardist",
    "avangardistul": "avangardist",
    "avangardistului": "avangardist",
    "avangardista": "avangardistă",
    "avangardiste": "avangardistă",
    "avangardistei": "avangardistă",
    "avangardistele": "avangardistă",
    "avangardistelor": "avangardistă",
    "avanpostul": "avanpost",
    "avanpostului": "avanpost",
    "avanposturi": "avanpost",
    "avanposturile": "avanpost",
    "avanposturilor": "avanpost",
    "avanpremiera": "avanpremieră",
    "avanpremiere": "avanpremieră",
    "avanpremierei": "avanpremieră",
    "avanpremierele": "avanpremieră",
    "avanpremierelor": "avanpremieră",
    "avansul": "avans",
    "avansului": "avans",
    "avansuri": "avans",
    "avansurile": "avans",
    "avansurilor": "avans",
    "avansă": "avansa",
    "avansai": "avansa",
    "avansam": "avansa",
    "avansăm": "avansa",
    "avansând": "avansa",
    "avansându": "avansa",
    "avansară": "avansa",
    "avansarăm": "avansa",
    "avansarăți": "avansa",
    "avansase": "avansa",
    "avansasem": "avansa",
    "avansaseră": "avansa",
    "avansaserăm": "avansa",
    "avansaserăți": "avansa",
    "avansaseși": "avansa",
    "avansași": "avansa",
    "avansat": "avansa",
    "avansați": "avansa",
    "avansatu": "avansa",
    "avansau": "avansa",
    "avansează": "avansa",
    "avansez": "avansa",
    "avanseze": "avansa",
    "avansezi": "avansa",
    "neavansând": "avansa",
    "neavansându": "avansa",
    "nemaiavansând": "avansa",
    "nemaiavansându": "avansa",
    "avansarea": "avansare",
    "avansări": "avansare",
    "avansării": "avansare",
    "avansările": "avansare",
    "avansata": "avansat",
    "avansată": "avansat",
    "avansate": "avansat",
    "avansatei": "avansat",
    "avansatele": "avansat",
    "avansatelor": "avansat",
    "avansați": "avansat",
    "avansații": "avansat",
    "avansaților": "avansat",
    "avansatul": "avansat",
    "avansatului": "avansat",
    "avansata": "avansată",
    "avansate": "avansată",
    "avansatei": "avansată",
    "avansatele": "avansată",
    "avansatelor": "avansată",
    "avanscena": "avanscenă",
    "avanscene": "avanscenă",
    "avanscenei": "avanscenă",
    "avanscenele": "avanscenă",
    "avanscenelor": "avanscenă",
    "avântul": "avânt",
    "avântului": "avânt",
    "avânturi": "avânt",
    "avânturile": "avânt",
    "avânturilor": "avânt",
    "avânt": "avânta",
    "avântă": "avânta",
    "avântai": "avânta",
    "avântam": "avânta",
    "avântăm": "avânta",
    "avântând": "avânta",
    "avântându": "avânta",
    "avântară": "avânta",
    "avântarăm": "avânta",
    "avântarăți": "avânta",
    "avântase": "avânta",
    "avântasem": "avânta",
    "avântaseră": "avânta",
    "avântaserăm": "avânta",
    "avântaserăți": "avânta",
    "avântaseși": "avânta",
    "avântași": "avânta",
    "avântat": "avânta",
    "avântați": "avânta",
    "avântatu": "avânta",
    "avântau": "avânta",
    "avânte": "avânta",
    "avânți": "avânta",
    "avantaje": "avantaj",
    "avantajele": "avantaj",
    "avantajelor": "avantaj",
    "avantajul": "avantaj",
    "avantajului": "avantaj",
    "avantajai": "avantaja",
    "avantajam": "avantaja",
    "avantajând": "avantaja",
    "avantajându": "avantaja",
    "avantajară": "avantaja",
    "avantajarăm": "avantaja",
    "avantajarăți": "avantaja",
    "avantajase": "avantaja",
    "avantajasem": "avantaja",
    "avantajaseră": "avantaja",
    "avantajaserăm": "avantaja",
    "avantajaserăți": "avantaja",
    "avantajaseși": "avantaja",
    "avantajași": "avantaja",
    "avantajat": "avantaja",
    "avantajați": "avantaja",
    "avantajatu": "avantaja",
    "avantajau": "avantaja",
    "avantaje": "avantaja",
    "avantajează": "avantaja",
    "avantaji": "avantaja",
    "avantajarea": "avantajare",
    "avantajată": "avantajat",
    "avantajate": "avantajat",
    "avantajați": "avantajat",
    "avantajatul": "avantajat",
    "avantajatului": "avantajat",
    "avantajoasa": "avantajos",
    "avantajoasă": "avantajos",
    "avantajoase": "avantajos",
    "avantajoasei": "avantajos",
    "avantajoasele": "avantajos",
    "avantajoaselor": "avantajos",
    "avantajoși": "avantajos",
    "avantajoșii": "avantajos",
    "avantajoșilor": "avantajos",
    "avantajosul": "avantajos",
    "avantajosului": "avantajos",
    "avântași": "avântat",
    "avântată": "avântat",
    "avântate": "avântat",
    "avara": "avar",
    "avară": "avar",
    "avare": "avar",
    "avarei": "avar",
    "avarele": "avar",
    "avarelor": "avar",
    "avari": "avar",
    "avarii": "avar",
    "avarilor": "avar",
    "avarul": "avar",
    "avarului": "avar",
    "avara": "avară",
    "avare": "avară",
    "avarei": "avară",
    "avarele": "avară",
    "avarelor": "avară",
    "avariai": "avaria",
    "avariam": "avaria",
    "avariară": "avaria",
    "avariarăm": "avaria",
    "avariarăți": "avaria",
    "avariase": "avaria",
    "avariasem": "avaria",
    "avariaseră": "avaria",
    "avariaserăm": "avaria",
    "avariaserăți": "avaria",
    "avariaseși": "avaria",
    "avariași": "avaria",
    "avariat": "avaria",
    "avariați": "avaria",
    "avariatu": "avaria",
    "avariau": "avaria",
    "avariază": "avaria",
    "avarie": "avaria",
    "avariem": "avaria",
    "avariez": "avaria",
    "avarieze": "avaria",
    "avariezi": "avaria",
    "avariind": "avaria",
    "avariindu": "avaria",
    "neavariind": "avaria",
    "neavariindu": "avaria",
    "nemaiavariind": "avaria",
    "nemaiavariindu": "avaria",
    "avariata": "avariat",
    "avariată": "avariat",
    "avariate": "avariat",
    "avariatei": "avariat",
    "avariatele": "avariat",
    "avariatelor": "avariat",
    "avariați": "avariat",
    "avariații": "avariat",
    "avariaților": "avariat",
    "avariatul": "avariat",
    "avariatului": "avariat",
    "avaria": "avarie",
    "avariei": "avarie",
    "avarii": "avarie",
    "avariile": "avarie",
    "avariilor": "avarie",
    "avarierea": "avariere",
    "avarieri": "avariere",
    "avarierii": "avariere",
    "avarierile": "avariere",
    "avariția": "avariție",
    "avariției": "avariție",
    "avariții": "avariție",
    "avarițiile": "avariție",
    "avarițiilor": "avariție",
    "avatarul": "avatar",
    "avatarului": "avatar",
    "avataruri": "avatar",
    "avatarurile": "avatar",
    "avatarurilor": "avatar",
    "a": "avea",
    "a-": "avea",
    "ai": "avea",
    "aibă": "avea",
    "am": "avea",
    "ar": "avea",
    "are": "avea",
    "aș": "avea",
    "ați": "avea",
    "au": "avea",
    "având": "avea",
    "avându": "avea",
    "aveai": "avea",
    "aveam": "avea",
    "aveați": "avea",
    "aveau": "avea",
    "avem": "avea",
    "aveți": "avea",
    "avu": "avea",
    "avui": "avea",
    "avură": "avea",
    "avurăm": "avea",
    "avurăți": "avea",
    "avuse": "avea",
    "avusei": "avea",
    "avuseră": "avea",
    "avuserăm": "avea",
    "avuserăți": "avea",
    "avusese": "avea",
    "avusesei": "avea",
    "avusesem": "avea",
    "avuseseră": "avea",
    "avuseserăm": "avea",
    "avuseserăți": "avea",
    "avuseseși": "avea",
    "avuseși": "avea",
    "avuși": "avea",
    "avut": "avea",
    "avutu": "avea",
    "neavând": "avea",
    "neavându": "avea",
    "nemaiavând": "avea",
    "nemaiavându": "avea",
    "aventură": "aventura",
    "aventurai": "aventura",
    "aventuram": "aventura",
    "aventurăm": "aventura",
    "aventurând": "aventura",
    "aventurându": "aventura",
    "aventurară": "aventura",
    "aventurarăm": "aventura",
    "aventurarăți": "aventura",
    "aventurase": "aventura",
    "aventurasem": "aventura",
    "aventuraseră": "aventura",
    "aventuraserăm": "aventura",
    "aventuraserăți": "aventura",
    "aventuraseși": "aventura",
    "aventurași": "aventura",
    "aventurat": "aventura",
    "aventurați": "aventura",
    "aventuratu": "aventura",
    "aventurau": "aventura",
    "aventurează": "aventura",
    "aventurez": "aventura",
    "aventureze": "aventura",
    "aventurezi": "aventura",
    "neaventurând": "aventura",
    "neaventurându": "aventura",
    "nemaiaventurând": "aventura",
    "nemaiaventurându": "aventura",
    "aventura": "aventură",
    "aventuri": "aventură",
    "aventurii": "aventură",
    "aventurile": "aventură",
    "aventurilor": "aventură",
    "aventurarea": "aventurare",
    "aventurări": "aventurare",
    "aventurării": "aventurare",
    "aventurările": "aventurare",
    "aventurata": "aventurat",
    "aventurată": "aventurat",
    "aventurate": "aventurat",
    "aventuratei": "aventurat",
    "aventuratele": "aventurat",
    "aventuratelor": "aventurat",
    "aventurați": "aventurat",
    "aventurații": "aventurat",
    "aventuraților": "aventurat",
    "aventuratul": "aventurat",
    "aventuratului": "aventurat",
    "aventurieri": "aventurier",
    "aventurierii": "aventurier",
    "aventurierilor": "aventurier",
    "aventurierul": "aventurier",
    "aventurierului": "aventurier",
    "aventuriera": "aventurieră",
    "aventuriere": "aventurieră",
    "aventurierei": "aventurieră",
    "aventurierele": "aventurieră",
    "aventurierelor": "aventurieră",
    "aventuroasa": "aventuros",
    "aventuroasă": "aventuros",
    "aventuroase": "aventuros",
    "aventuroasei": "aventuros",
    "aventuroasele": "aventuros",
    "aventuroaselor": "aventuros",
    "aventuroși": "aventuros",
    "aventuroșii": "aventuros",
    "aventuroșilor": "aventuros",
    "aventurosul": "aventuros",
    "aventurosului": "aventuros",
    "Av.": "avenue",
    "Ave.": "avenue",
    "averea": "avere",
    "averi": "avere",
    "averii": "avere",
    "averile": "avere",
    "averilor": "avere",
    "aversul": "avers",
    "aversului": "avers",
    "aversuri": "avers",
    "aversurile": "avers",
    "aversurilor": "avers",
    "aversa": "aversă",
    "averse": "aversă",
    "aversei": "aversă",
    "aversele": "aversă",
    "averselor": "aversă",
    "aversiunea": "aversiune",
    "aversiuni": "aversiune",
    "aversiunii": "aversiune",
    "aversiunile": "aversiune",
    "aversiunilor": "aversiune",
    "avertismente": "avertisment",
    "avertismentele": "avertisment",
    "avertismentelor": "avertisment",
    "avertismentul": "avertisment",
    "avertismentului": "avertisment",
    "avertiză": "avertiza",
    "avertizai": "avertiza",
    "avertizam": "avertiza",
    "avertizăm": "avertiza",
    "avertizând": "avertiza",
    "avertizându": "avertiza",
    "avertizară": "avertiza",
    "avertizarăm": "avertiza",
    "avertizarăți": "avertiza",
    "avertizase": "avertiza",
    "avertizasem": "avertiza",
    "avertizaseră": "avertiza",
    "avertizaserăm": "avertiza",
    "avertizaserăți": "avertiza",
    "avertizaseși": "avertiza",
    "avertizași": "avertiza",
    "avertizat": "avertiza",
    "avertizați": "avertiza",
    "avertizatu": "avertiza",
    "avertizau": "avertiza",
    "avertizează": "avertiza",
    "avertizez": "avertiza",
    "avertizeze": "avertiza",
    "avertizezi": "avertiza",
    "neavertizând": "avertiza",
    "neavertizându": "avertiza",
    "nemaiavertizând": "avertiza",
    "nemaiavertizându": "avertiza",
    "avertizarea": "avertizare",
    "avertizări": "avertizare",
    "avertizării": "avertizare",
    "avertizările": "avertizare",
    "avertizata": "avertizat",
    "avertizată": "avertizat",
    "avertizate": "avertizat",
    "avertizatei": "avertizat",
    "avertizatele": "avertizat",
    "avertizatelor": "avertizat",
    "avertizați": "avertizat",
    "avertizații": "avertizat",
    "avertizaților": "avertizat",
    "avertizatul": "avertizat",
    "avertizatului": "avertizat",
    "aviatica": "aviatic",
    "aviatică": "aviatic",
    "aviatice": "aviatic",
    "aviaticei": "aviatic",
    "aviaticele": "aviatic",
    "aviaticelor": "aviatic",
    "aviatici": "aviatic",
    "aviaticii": "aviatic",
    "aviaticilor": "aviatic",
    "aviaticul": "aviatic",
    "aviaticului": "aviatic",
    "aviația": "aviație",
    "aviației": "aviație",
    "aviații": "aviație",
    "aviațiile": "aviație",
    "aviațiilor": "aviație",
    "aviatoarea": "aviatoare",
    "aviatoarei": "aviatoare",
    "aviatoarele": "aviatoare",
    "aviatoarelor": "aviatoare",
    "aviatori": "aviator",
    "aviatorii": "aviator",
    "aviatorilor": "aviator",
    "aviatorul": "aviator",
    "aviatorului": "aviator",
    "avicola": "avicol",
    "avicolă": "avicol",
    "avicole": "avicol",
    "avicolei": "avicol",
    "avicolele": "avicol",
    "avicolelor": "avicol",
    "avicoli": "avicol",
    "avicolii": "avicol",
    "avicolilor": "avicol",
    "avicolul": "avicol",
    "avicolului": "avicol",
    "avicultoarea": "avicultoare",
    "avicultoarei": "avicultoare",
    "avicultoarele": "avicultoare",
    "avicultoarelor": "avicultoare",
    "avicultori": "avicultor",
    "avicultorii": "avicultor",
    "avicultorilor": "avicultor",
    "avicultorul": "avicultor",
    "avicultorului": "avicultor",
    "av.": "avicultură",
    "avicultura": "avicultură",
    "aviculturi": "avicultură",
    "aviculturii": "avicultură",
    "aviculturile": "avicultură",
    "aviculturilor": "avicultură",
    "avida": "avid",
    "avidă": "avid",
    "avide": "avid",
    "avidei": "avid",
    "avidele": "avid",
    "avidelor": "avid",
    "avidul": "avid",
    "avidului": "avid",
    "avizi": "avid",
    "avizii": "avid",
    "avizilor": "avid",
    "avioane": "avion",
    "avioanele": "avion",
    "avioanelor": "avion",
    "avionul": "avion",
    "avionului": "avion",
    "avioneta": "avionetă",
    "avionete": "avionetă",
    "avionetei": "avionetă",
    "avionetele": "avionetă",
    "avionetelor": "avionetă",
    "avitaminoza": "avitaminoză",
    "avitaminoze": "avitaminoză",
    "avitaminozei": "avitaminoză",
    "avitaminozele": "avitaminoză",
    "avitaminozelor": "avitaminoză",
    "avize": "aviz",
    "avizele": "aviz",
    "avizelor": "aviz",
    "avizul": "aviz",
    "avizului": "aviz",
    "aviză": "aviza",
    "avizai": "aviza",
    "avizam": "aviza",
    "avizăm": "aviza",
    "avizând": "aviza",
    "avizându": "aviza",
    "avizară": "aviza",
    "avizarăm": "aviza",
    "avizarăți": "aviza",
    "avizase": "aviza",
    "avizasem": "aviza",
    "avizaseră": "aviza",
    "avizaserăm": "aviza",
    "avizaserăți": "aviza",
    "avizaseși": "aviza",
    "avizași": "aviza",
    "avizat": "aviza",
    "avizați": "aviza",
    "avizatu": "aviza",
    "avizau": "aviza",
    "avizează": "aviza",
    "avizez": "aviza",
    "avizeze": "aviza",
    "avizezi": "aviza",
    "neavizând": "aviza",
    "neavizându": "aviza",
    "nemaiavizând": "aviza",
    "nemaiavizându": "aviza",
    "avizarea": "avizare",
    "avizări": "avizare",
    "avizării": "avizare",
    "avizările": "avizare",
    "avizata": "avizat",
    "avizată": "avizat",
    "avizate": "avizat",
    "avizatei": "avizat",
    "avizatele": "avizat",
    "avizatelor": "avizat",
    "avizați": "avizat",
    "avizații": "avizat",
    "avizaților": "avizat",
    "avizatul": "avizat",
    "avizatului": "avizat",
    "aviziere": "avizier",
    "avizierele": "avizier",
    "avizierelor": "avizier",
    "avizierul": "avizier",
    "avizierului": "avizier",
    "avocați": "avocat",
    "avocații": "avocat",
    "avocaților": "avocat",
    "avocatul": "avocat",
    "avocatului": "avocat",
    "avortă": "avorta",
    "avortai": "avorta",
    "avortam": "avorta",
    "avortăm": "avorta",
    "avortând": "avorta",
    "avortându": "avorta",
    "avortară": "avorta",
    "avortarăm": "avorta",
    "avortarăți": "avorta",
    "avortase": "avorta",
    "avortasem": "avorta",
    "avortaseră": "avorta",
    "avortaserăm": "avorta",
    "avortaserăți": "avorta",
    "avortaseși": "avorta",
    "avortași": "avorta",
    "avortat": "avorta",
    "avortați": "avorta",
    "avortatu": "avorta",
    "avortau": "avorta",
    "avortează": "avorta",
    "avortez": "avorta",
    "avorteze": "avorta",
    "avortezi": "avorta",
    "neavortând": "avorta",
    "neavortându": "avorta",
    "nemaiavortând": "avorta",
    "nemaiavortându": "avorta",
    "avortarea": "avortare",
    "avortări": "avortare",
    "avortării": "avortare",
    "avortările": "avortare",
    "avortata": "avortat",
    "avortată": "avortat",
    "avortate": "avortat",
    "avortatei": "avortat",
    "avortatele": "avortat",
    "avortatelor": "avortat",
    "avortați": "avortat",
    "avortații": "avortat",
    "avortaților": "avortat",
    "avortatul": "avortat",
    "avortatului": "avortat",
    "avortoni": "avorton",
    "avortonii": "avorton",
    "avortonilor": "avorton",
    "avortonul": "avorton",
    "avortonului": "avorton",
    "avuabila": "avuabil",
    "avuabilă": "avuabil",
    "avuabile": "avuabil",
    "avuabilei": "avuabil",
    "avuabilele": "avuabil",
    "avuabilelor": "avuabil",
    "avuabili": "avuabil",
    "avuabilii": "avuabil",
    "avuabililor": "avuabil",
    "avuabilul": "avuabil",
    "avuabilului": "avuabil",
    "avuta": "avut",
    "avută": "avut",
    "avute": "avut",
    "avutei": "avut",
    "avutele": "avut",
    "avutelor": "avut",
    "avuți": "avut",
    "avuții": "avut",
    "avuților": "avut",
    "avutul": "avut",
    "avutului": "avut",
    "avuta": "avută",
    "avute": "avută",
    "avutei": "avută",
    "avutele": "avută",
    "avutelor": "avută",
    "avuția": "avuție",
    "avuției": "avuție",
    "avuții": "avuție",
    "avuțiile": "avuție",
    "avuțiilor": "avuție",
    "axe": "ax",
    "axele": "ax",
    "axelor": "ax",
    "axul": "ax",
    "axului": "ax",
    "axă": "axa",
    "axai": "axa",
    "axam": "axa",
    "axăm": "axa",
    "axând": "axa",
    "axându": "axa",
    "axară": "axa",
    "axarăm": "axa",
    "axarăți": "axa",
    "axase": "axa",
    "axasem": "axa",
    "axaseră": "axa",
    "axaserăm": "axa",
    "axaserăți": "axa",
    "axaseși": "axa",
    "axași": "axa",
    "axat": "axa",
    "axați": "axa",
    "axatu": "axa",
    "axau": "axa",
    "axează": "axa",
    "axez": "axa",
    "axeze": "axa",
    "axezi": "axa",
    "neaxând": "axa",
    "neaxându": "axa",
    "nemaiaxând": "axa",
    "nemaiaxându": "axa",
    "axa": "axă",
    "axe": "axă",
    "axei": "axă",
    "axele": "axă",
    "axelor": "axă",
    "axarea": "axare",
    "axări": "axare",
    "axării": "axare",
    "axările": "axare",
    "axata": "axat",
    "axată": "axat",
    "axate": "axat",
    "axatei": "axat",
    "axatele": "axat",
    "axatelor": "axat",
    "axați": "axat",
    "axații": "axat",
    "axaților": "axat",
    "axatul": "axat",
    "axatului": "axat",
    "axiala": "axial",
    "axială": "axial",
    "axiale": "axial",
    "axialei": "axial",
    "axialele": "axial",
    "axialelor": "axial",
    "axiali": "axial",
    "axialii": "axial",
    "axialilor": "axial",
    "axialul": "axial",
    "axialului": "axial",
    "axilara": "axilar",
    "axilară": "axilar",
    "axilare": "axilar",
    "axilarei": "axilar",
    "axilarele": "axilar",
    "axilarelor": "axilar",
    "axilari": "axilar",
    "axilarii": "axilar",
    "axilarilor": "axilar",
    "axilarul": "axilar",
    "axilarului": "axilar",
    "axiologia": "axiologie",
    "axiologiei": "axiologie",
    "axiologii": "axiologie",
    "axiologiile": "axiologie",
    "axiologiilor": "axiologie",
    "axioma": "axiomă",
    "axiome": "axiomă",
    "axiomei": "axiomă",
    "axiomele": "axiomă",
    "axiomelor": "axiomă",
    "axiomatica": "axiomatic",
    "axiomatică": "axiomatic",
    "axiomatice": "axiomatic",
    "axiomaticei": "axiomatic",
    "axiomaticele": "axiomatic",
    "axiomaticelor": "axiomatic",
    "axiomatici": "axiomatic",
    "axiomaticii": "axiomatic",
    "axiomaticilor": "axiomatic",
    "axiomaticul": "axiomatic",
    "axiomaticului": "axiomatic",
    "axiomatizarea": "axiomatizare",
    "axiomatizări": "axiomatizare",
    "axiomatizării": "axiomatizare",
    "axiomatizările": "axiomatizare",
    "axiomatizărilor": "axiomatizare",
    "axiomatizată": "axiomatizat",
    "axiomatizate": "axiomatizat",
    "axiomatizați": "axiomatizat",
    "azbestul": "azbest",
    "azbestului": "azbest",
    "azbesturi": "azbest",
    "azbesturile": "azbest",
    "azbesturilor": "azbest",
    "azbocimente": "azbociment",
    "azbocimentele": "azbociment",
    "azbocimentelor": "azbociment",
    "azbocimentul": "azbociment",
    "azbocimentului": "azbociment",
    "azilul": "azil",
    "azilului": "azil",
    "aziluri": "azil",
    "azilurile": "azil",
    "azilurilor": "azil",
    "azimutala": "azimutal",
    "azimutală": "azimutal",
    "azimutale": "azimutal",
    "azimutalei": "azimutal",
    "azimutalele": "azimutal",
    "azimutalelor": "azimutal",
    "azimutali": "azimutal",
    "azimutalii": "azimutal",
    "azimutalilor": "azimutal",
    "azimutalul": "azimutal",
    "azimutalului": "azimutal",
    "azotul": "azot",
    "azotului": "azot",
    "azotica": "azotic",
    "azotică": "azotic",
    "azotice": "azotic",
    "azoticei": "azotic",
    "azoticele": "azotic",
    "azoticelor": "azotic",
    "azotici": "azotic",
    "azoticii": "azotic",
    "azoticilor": "azotic",
    "azoticul": "azotic",
    "azoticului": "azotic",
    "azotoasa": "azotos",
    "azotoasă": "azotos",
    "azotoase": "azotos",
    "azotoasei": "azotos",
    "azotoasele": "azotos",
    "azotoaselor": "azotos",
    "azotoși": "azotos",
    "azotoșii": "azotos",
    "azotoșilor": "azotos",
    "azotosul": "azotos",
    "azotosului": "azotos",
    "azurul": "azur",
    "azurului": "azur",
    "azurata": "azurat",
    "azurată": "azurat",
    "azurate": "azurat",
    "azuratei": "azurat",
    "azuratele": "azurat",
    "azuratelor": "azurat",
    "azurați": "azurat",
    "azurații": "azurat",
    "azuraților": "azurat",
    "azuratul": "azurat",
    "azuratului": "azurat",
    "azuria": "azuriu",
    "azurie": "azuriu",
    "azuriei": "azuriu",
    "azurii": "azuriu",
    "azuriii": "azuriu",
    "azuriile": "azuriu",
    "azuriilor": "azuriu",
    "azuriul": "azuriu",
    "azuriului": "azuriu",
    "azvârl": "azvârli",
    "azvârle": "azvârli",
    "azvârlea": "azvârli",
    "azvârleai": "azvârli",
    "azvârleam": "azvârli",
    "azvârleați": "azvârli",
    "azvârleau": "azvârli",
    "azvârlii": "azvârli",
    "azvârlim": "azvârli",
    "azvârlind": "azvârli",
    "azvârlindu": "azvârli",
    "azvârliră": "azvârli",
    "azvârlirăm": "azvârli",
    "azvârlirăți": "azvârli",
    "azvârlise": "azvârli",
    "azvârlisem": "azvârli",
    "azvârliseră": "azvârli",
    "azvârliserăm": "azvârli",
    "azvârliserăți": "azvârli",
    "azvârliseși": "azvârli",
    "azvârliși": "azvârli",
    "azvârlit": "azvârli",
    "azvârliți": "azvârli",
    "azvârlitu": "azvârli",
    "neazvârlind": "azvârli",
    "neazvârlindu": "azvârli",
    "nemaiazvârlind": "azvârli",
    "nemaiazvârlindu": "azvârli",
    "azvârlirea": "azvârlire",
    "azvârliri": "azvârlire",
    "azvârlirii": "azvârlire",
    "azvârlirile": "azvârlire",
    "azvârlita": "azvârlit",
    "azvârlită": "azvârlit",
    "azvârlite": "azvârlit",
    "azvârlitei": "azvârlit",
    "azvârlitele": "azvârlit",
    "azvârlitelor": "azvârlit",
    "azvârliți": "azvârlit",
    "azvârliții": "azvârlit",
    "azvârliților": "azvârlit",
    "azvârlitul": "azvârlit",
    "azvârlitului": "azvârlit",
    "baba": "babă",
    "babe": "babă",
    "babei": "babă",
    "babele": "babă",
    "babelor": "babă",
    "babo": "babă",
    "babilonia": "babilonie",
    "babiloniei": "babilonie",
    "babilonii": "babilonie",
    "babiloniile": "babilonie",
    "babiloniilor": "babilonie",
    "babordul": "babord",
    "babordului": "babord",
    "baborduri": "babord",
    "babordurile": "babord",
    "babordurilor": "babord",
    "bacul": "bac",
    "bacului": "bac",
    "bacuri": "bac",
    "bacurile": "bac",
    "bacurilor": "bac",
    "bacalaureate": "bacalaureat",
    "bacalaureatele": "bacalaureat",
    "bacalaureatelor": "bacalaureat",
    "bacalaureatul": "bacalaureat",
    "bacalaureatului": "bacalaureat",
    "bacanta": "bacantă",
    "bacante": "bacantă",
    "bacantei": "bacantă",
    "bacantele": "bacantă",
    "bacantelor": "bacantă",
    "Bacăul": "Bacău",
    "Bacăului": "Bacău",
    "bachelita": "bachelită",
    "bachelite": "bachelită",
    "bachelitei": "bachelită",
    "bachelitele": "bachelită",
    "bachelitelor": "bachelită",
    "bacii": "baci",
    "bacilor": "baci",
    "baciul": "baci",
    "baciului": "baci",
    "bacili": "bacil",
    "bacilii": "bacil",
    "bacililor": "bacil",
    "bacilul": "bacil",
    "bacilului": "bacil",
    "bacteria": "bacterie",
    "bacteriei": "bacterie",
    "bacterii": "bacterie",
    "bacteriile": "bacterie",
    "bacteriilor": "bacterie",
    "bacteriologia": "bacteriologie",
    "bacteriologiei": "bacteriologie",
    "bacteriologii": "bacteriologie",
    "bacteriologiile": "bacteriologie",
    "bacteriologiilor": "bacteriologie",
    "Badahșanul": "Badahșan",
    "Badahșanului": "Badahșan",
    "bădărani": "bădăran",
    "bădăranii": "bădăran",
    "bădăranilor": "bădăran",
    "bădăranul": "bădăran",
    "bădăranului": "bădăran",
    "bădărana": "bădărană",
    "bădărane": "bădărană",
    "bădăranei": "bădărană",
    "bădăranele": "bădărană",
    "bădăranelor": "bădărană",
    "bădia": "bădie",
    "bădiei": "bădie",
    "bădii": "bădie",
    "bădiii": "bădie",
    "bădiilor": "bădie",
    "badijonă": "badijona",
    "badijonai": "badijona",
    "badijonam": "badijona",
    "badijonăm": "badijona",
    "badijonând": "badijona",
    "badijonându": "badijona",
    "badijonară": "badijona",
    "badijonarăm": "badijona",
    "badijonarăți": "badijona",
    "badijonase": "badijona",
    "badijonasem": "badijona",
    "badijonaseră": "badijona",
    "badijonaserăm": "badijona",
    "badijonaserăți": "badijona",
    "badijonaseși": "badijona",
    "badijonași": "badijona",
    "badijonat": "badijona",
    "badijonați": "badijona",
    "badijonatu": "badijona",
    "badijonau": "badijona",
    "badijonează": "badijona",
    "badijonez": "badijona",
    "badijoneze": "badijona",
    "badijonezi": "badijona",
    "nebadijonând": "badijona",
    "nebadijonându": "badijona",
    "nemaibadijonând": "badijona",
    "nemaibadijonându": "badijona",
    "badijonarea": "badijonare",
    "badijonări": "badijonare",
    "badijonării": "badijonare",
    "badijonările": "badijonare",
    "badijonata": "badijonat",
    "badijonată": "badijonat",
    "badijonate": "badijonat",
    "badijonatei": "badijonat",
    "badijonatele": "badijonat",
    "badijonatelor": "badijonat",
    "badijonați": "badijonat",
    "badijonații": "badijonat",
    "badijonaților": "badijonat",
    "badijonatul": "badijonat",
    "badijonatului": "badijonat",
    "bag": "băga",
    "bagă": "băga",
    "băgă": "băga",
    "băgai": "băga",
    "băgam": "băga",
    "băgăm": "băga",
    "băgând": "băga",
    "băgându": "băga",
    "băgară": "băga",
    "băgarăm": "băga",
    "băgarăți": "băga",
    "băgase": "băga",
    "băgasem": "băga",
    "băgaseră": "băga",
    "băgaserăm": "băga",
    "băgaserăți": "băga",
    "băgaseși": "băga",
    "băgași": "băga",
    "băgat": "băga",
    "băgați": "băga",
    "băgatu": "băga",
    "băgau": "băga",
    "bage": "băga",
    "bagi": "băga",
    "nebăgând": "băga",
    "nebăgându": "băga",
    "nemaibăgând": "băga",
    "nemaibăgându": "băga",
    "bagaje": "bagaj",
    "bagajele": "bagaj",
    "bagajelor": "bagaj",
    "bagajul": "bagaj",
    "bagajului": "bagaj",
    "băgarea": "băgare",
    "băgareo": "băgare",
    "băgări": "băgare",
    "băgării": "băgare",
    "băgările": "băgare",
    "băgărilor": "băgare",
    "băgăreți": "băgăreț",
    "băgăreții": "băgăreț",
    "băgăreților": "băgăreț",
    "băgărețul": "băgăreț",
    "băgărețului": "băgăreț",
    "băgata": "băgat",
    "băgată": "băgat",
    "băgate": "băgat",
    "băgatei": "băgat",
    "băgatele": "băgat",
    "băgatelor": "băgat",
    "băgați": "băgat",
    "băgații": "băgat",
    "băgaților": "băgat",
    "băgato": "băgat",
    "băgatul": "băgat",
    "băgatule": "băgat",
    "băgatului": "băgat",
    "bagatela": "bagatelă",
    "bagatele": "bagatelă",
    "bagatelei": "bagatelă",
    "bagatelele": "bagatelă",
    "bagatelelor": "bagatelă",
    "bagateliză": "bagateliza",
    "bagatelizai": "bagateliza",
    "bagatelizam": "bagateliza",
    "bagatelizăm": "bagateliza",
    "bagatelizând": "bagateliza",
    "bagatelizându": "bagateliza",
    "bagatelizară": "bagateliza",
    "bagatelizarăm": "bagateliza",
    "bagatelizarăți": "bagateliza",
    "bagatelizase": "bagateliza",
    "bagatelizasem": "bagateliza",
    "bagatelizaseră": "bagateliza",
    "bagatelizaserăm": "bagateliza",
    "bagatelizaserăți": "bagateliza",
    "bagatelizaseși": "bagateliza",
    "bagatelizași": "bagateliza",
    "bagatelizat": "bagateliza",
    "bagatelizați": "bagateliza",
    "bagatelizatu": "bagateliza",
    "bagatelizau": "bagateliza",
    "bagatelizează": "bagateliza",
    "bagatelizez": "bagateliza",
    "bagatelizeze": "bagateliza",
    "bagatelizezi": "bagateliza",
    "nebagatelizând": "bagateliza",
    "nebagatelizându": "bagateliza",
    "nemaibagatelizând": "bagateliza",
    "nemaibagatelizându": "bagateliza",
    "bagatelizarea": "bagatelizare",
    "bagatelizări": "bagatelizare",
    "bagatelizării": "bagatelizare",
    "bagatelizările": "bagatelizare",
    "bagatelizata": "bagatelizat",
    "bagatelizată": "bagatelizat",
    "bagatelizate": "bagatelizat",
    "bagatelizatei": "bagatelizat",
    "bagatelizatele": "bagatelizat",
    "bagatelizatelor": "bagatelizat",
    "bagatelizați": "bagatelizat",
    "bagatelizații": "bagatelizat",
    "bagatelizaților": "bagatelizat",
    "bagatelizatul": "bagatelizat",
    "bagatelizatului": "bagatelizat",
    "bagheta": "baghetă",
    "baghete": "baghetă",
    "baghetei": "baghetă",
    "baghetele": "baghetă",
    "baghetelor": "baghetă",
    "bahica": "bahic",
    "bahică": "bahic",
    "bahice": "bahic",
    "bahicei": "bahic",
    "bahicele": "bahic",
    "bahicelor": "bahic",
    "bahici": "bahic",
    "bahicii": "bahic",
    "bahicilor": "bahic",
    "bahicul": "bahic",
    "bahicului": "bahic",
    "băhnita": "băhnit",
    "băhnită": "băhnit",
    "băhnite": "băhnit",
    "băhnitei": "băhnit",
    "băhnitele": "băhnit",
    "băhnitelor": "băhnit",
    "băhnito": "băhnit",
    "băhnitul": "băhnit",
    "băhnitule": "băhnit",
    "băhnitului": "băhnit",
    "băhnita": "băhnită",
    "băhnite": "băhnită",
    "băhnitei": "băhnită",
    "băhnitele": "băhnită",
    "băhnitelor": "băhnită",
    "băhnito": "băhnită",
    "Bahrinul": "Bahrin",
    "Bahrinului": "Bahrin",
    "baiul": "bai",
    "baiului": "bai",
    "baiuri": "bai",
    "baiurile": "bai",
    "baiurilor": "bai",
    "baiadera": "baiaderă",
    "baiadere": "baiaderă",
    "baiaderei": "baiaderă",
    "baiaderele": "baiaderă",
    "baiaderelor": "baiaderă",
    "băiatul": "băiat",
    "băiatule": "băiat",
    "băiatului": "băiat",
    "băieți": "băiat",
    "băieții": "băiat",
    "băieților": "băiat",
    "băi": "baie",
    "baia": "baie",
    "băii": "baie",
    "băile": "baie",
    "băilor": "baie",
    "baiera": "baieră",
    "baiere": "baieră",
    "baierei": "baieră",
    "baierele": "baieră",
    "baierelor": "baieră",
    "băieși": "băieș",
    "băieșii": "băieș",
    "băieșilor": "băieș",
    "băieșul": "băieș",
    "băieșului": "băieș",
    "băietani": "băietan",
    "băietanii": "băietan",
    "băietanilor": "băietan",
    "băietanul": "băietan",
    "băietanului": "băietan",
    "băiețandri": "băiețandru",
    "băiețandrii": "băiețandru",
    "băiețandrilor": "băiețandru",
    "băiețandrul": "băiețandru",
    "băiețandrului": "băiețandru",
    "băiețași": "băiețaș",
    "băiețașii": "băiețaș",
    "băiețașilor": "băiețaș",
    "băiețașul": "băiețaș",
    "băiețașule": "băiețaș",
    "băiețașului": "băiețaș",
    "băieței": "băiețel",
    "băiețeii": "băiețel",
    "băiețeilor": "băiețel",
    "băiețelul": "băiețel",
    "băiețelule": "băiețel",
    "băiețelului": "băiețel",
    "băiețeasca": "băiețesc",
    "băiețească": "băiețesc",
    "băiețescul": "băiețesc",
    "băiețescului": "băiețesc",
    "băiețești": "băiețesc",
    "băiețeștii": "băiețesc",
    "băiețeștile": "băiețesc",
    "băiețeștilor": "băiețesc",
    "băiețoaica": "băiețoaică",
    "băiețoaice": "băiețoaică",
    "băiețoaicei": "băiețoaică",
    "băiețoaicele": "băiețoaică",
    "băiețoaicelor": "băiețoaică",
    "băiețoii": "băiețoi",
    "băiețoilor": "băiețoi",
    "băiețoiul": "băiețoi",
    "băiețoiule": "băiețoi",
    "băiețoiului": "băiețoi",
    "bâiguia": "bâigui",
    "bâiguiai": "bâigui",
    "bâiguiam": "bâigui",
    "bâiguiați": "bâigui",
    "bâiguiau": "bâigui",
    "bâiguie": "bâigui",
    "bâiguiește": "bâigui",
    "bâiguii": "bâigui",
    "bâiguim": "bâigui",
    "bâiguind": "bâigui",
    "bâiguindu": "bâigui",
    "bâiguiră": "bâigui",
    "bâiguirăm": "bâigui",
    "bâiguirăți": "bâigui",
    "bâiguise": "bâigui",
    "bâiguisem": "bâigui",
    "bâiguiseră": "bâigui",
    "bâiguiserăm": "bâigui",
    "bâiguiserăți": "bâigui",
    "bâiguiseși": "bâigui",
    "bâiguiși": "bâigui",
    "bâiguit": "bâigui",
    "bâiguiți": "bâigui",
    "bâiguitu": "bâigui",
    "bâiguită": "bâiguit",
    "bâiguite": "bâiguit",
    "bâiguiți": "bâiguit",
    "baioneta": "baionetă",
    "baionete": "baionetă",
    "baionetei": "baionetă",
    "baionetele": "baionetă",
    "baionetelor": "baionetă",
    "bâjbâia": "bâjbâi",
    "bâjbâiai": "bâjbâi",
    "bâjbâiam": "bâjbâi",
    "bâjbâiați": "bâjbâi",
    "bâjbâiau": "bâjbâi",
    "bâjbâie": "bâjbâi",
    "bâjbâiește": "bâjbâi",
    "bâjbâii": "bâjbâi",
    "bâjbâim": "bâjbâi",
    "bâjbâind": "bâjbâi",
    "bâjbâindu": "bâjbâi",
    "bâjbâiră": "bâjbâi",
    "bâjbâirăm": "bâjbâi",
    "bâjbâirăți": "bâjbâi",
    "bâjbâise": "bâjbâi",
    "bâjbâisem": "bâjbâi",
    "bâjbâiseră": "bâjbâi",
    "bâjbâiserăm": "bâjbâi",
    "bâjbâiserăți": "bâjbâi",
    "bâjbâiseși": "bâjbâi",
    "bâjbâiși": "bâjbâi",
    "bâjbâit": "bâjbâi",
    "bâjbâiți": "bâjbâi",
    "bâjbâitu": "bâjbâi",
    "bâjbâiala": "bâjbâială",
    "bâjbâieli": "bâjbâială",
    "bâjbâielii": "bâjbâială",
    "bâjbâielile": "bâjbâială",
    "bâjbâielilor": "bâjbâială",
    "bâjbâita": "bâjbâit",
    "bâjbâită": "bâjbâit",
    "bâjbâite": "bâjbâit",
    "bâjbâitei": "bâjbâit",
    "bâjbâitele": "bâjbâit",
    "bâjbâitelor": "bâjbâit",
    "bâjbâiți": "bâjbâit",
    "bâjbâiții": "bâjbâit",
    "bâjbâiților": "bâjbâit",
    "bâjbâitul": "bâjbâit",
    "bâjbâitului": "bâjbâit",
    "băjenari": "băjenar",
    "băjenarii": "băjenar",
    "băjenarilor": "băjenar",
    "băjenarul": "băjenar",
    "băjenarului": "băjenar",
    "băjenia": "băjenie",
    "băjeniei": "băjenie",
    "băjenii": "băjenie",
    "băjeniile": "băjenie",
    "băjeniilor": "băjenie",
    "balul": "bal",
    "balului": "bal",
    "baluri": "bal",
    "balurile": "bal",
    "balurilor": "bal",
    "bălăbăneala": "bălăbăneală",
    "bălăbănealo": "bălăbăneală",
    "bălăbăneli": "bălăbăneală",
    "bălăbănelii": "bălăbăneală",
    "bălăbănelile": "bălăbăneală",
    "bălăbănelilor": "bălăbăneală",
    "bălăbănea": "bălăbăni",
    "bălăbăneai": "bălăbăni",
    "bălăbăneam": "bălăbăni",
    "bălăbănească": "bălăbăni",
    "bălăbăneați": "bălăbăni",
    "bălăbăneau": "bălăbăni",
    "bălăbănesc": "bălăbăni",
    "bălăbănește": "bălăbăni",
    "bălăbănești": "bălăbăni",
    "bălăbănii": "bălăbăni",
    "bălăbănim": "bălăbăni",
    "bălăbănind": "bălăbăni",
    "bălăbănindu": "bălăbăni",
    "bălăbăniră": "bălăbăni",
    "bălăbănirăm": "bălăbăni",
    "bălăbănirăți": "bălăbăni",
    "bălăbănise": "bălăbăni",
    "bălăbănisem": "bălăbăni",
    "bălăbăniseră": "bălăbăni",
    "bălăbăniserăm": "bălăbăni",
    "bălăbăniserăți": "bălăbăni",
    "bălăbăniseși": "bălăbăni",
    "bălăbăniși": "bălăbăni",
    "bălăbănit": "bălăbăni",
    "bălăbăniți": "bălăbăni",
    "bălăbănitu": "bălăbăni",
    "nebălăbănind": "bălăbăni",
    "nebălăbănindu": "bălăbăni",
    "nemaibălăbănind": "bălăbăni",
    "nemaibălăbănindu": "bălăbăni",
    "bălăbănita": "bălăbănit",
    "bălăbănită": "bălăbănit",
    "bălăbănite": "bălăbănit",
    "bălăbănitei": "bălăbănit",
    "bălăbănitele": "bălăbănit",
    "bălăbănitelor": "bălăbănit",
    "bălăbăniți": "bălăbănit",
    "bălăbăniții": "bălăbănit",
    "bălăbăniților": "bălăbănit",
    "bălăbănitul": "bălăbănit",
    "bălăbănitule": "bălăbănit",
    "bălăbănitului": "bălăbănit",
    "bălăceala": "bălăceală",
    "bălăcealo": "bălăceală",
    "bălăceli": "bălăceală",
    "bălăcelii": "bălăceală",
    "bălăcelile": "bălăceală",
    "bălăcelilor": "bălăceală",
    "bălăcea": "bălăci",
    "bălăceai": "bălăci",
    "bălăceam": "bălăci",
    "bălăcească": "bălăci",
    "bălăceați": "bălăci",
    "bălăceau": "bălăci",
    "bălăcesc": "bălăci",
    "bălăcește": "bălăci",
    "bălăcești": "bălăci",
    "bălăcii": "bălăci",
    "bălăcim": "bălăci",
    "bălăcind": "bălăci",
    "bălăcindu": "bălăci",
    "bălăciră": "bălăci",
    "bălăcirăm": "bălăci",
    "bălăcirăți": "bălăci",
    "bălăcise": "bălăci",
    "bălăcisem": "bălăci",
    "bălăciseră": "bălăci",
    "bălăciserăm": "bălăci",
    "bălăciserăți": "bălăci",
    "bălăciseși": "bălăci",
    "bălăciși": "bălăci",
    "bălăcit": "bălăci",
    "bălăciți": "bălăci",
    "bălăcitu": "bălăci",
    "nebălăcind": "bălăci",
    "nebălăcindu": "bălăci",
    "nemaibălăcind": "bălăci",
    "nemaibălăcindu": "bălăci",
    "bălăcirea": "bălăcire",
    "bălăcireo": "bălăcire",
    "bălăciri": "bălăcire",
    "bălăcirii": "bălăcire",
    "bălăcirile": "bălăcire",
    "bălăcirilor": "bălăcire",
    "bălăcita": "bălăcit",
    "bălăcită": "bălăcit",
    "bălăcite": "bălăcit",
    "bălăcitei": "bălăcit",
    "bălăcitele": "bălăcit",
    "bălăcitelor": "bălăcit",
    "bălăciți": "bălăcit",
    "bălăciții": "bălăcit",
    "bălăciților": "bălăcit",
    "bălăcito": "bălăcit",
    "bălăcitul": "bălăcit",
    "bălăcitule": "bălăcit",
    "bălăcitului": "bălăcit",
    "balada": "baladă",
    "balade": "baladă",
    "baladei": "baladă",
    "baladele": "baladă",
    "baladelor": "baladă",
    "bălaia": "bălai",
    "bălaie": "bălai",
    "bălaiei": "bălai",
    "bălaiele": "bălai",
    "bălaielor": "bălai",
    "bălaii": "bălai",
    "bălailor": "bălai",
    "bălaiul": "bălai",
    "bălaiului": "bălai",
    "bălăiori": "bălăior",
    "bălăiorii": "bălăior",
    "bălăiorilor": "bălăior",
    "bălăiorul": "bălăior",
    "bălăiorului": "bălăior",
    "balamale": "balama",
    "balamalei": "balama",
    "balamalele": "balama",
    "balamalelor": "balama",
    "balamao": "balama",
    "balamaua": "balama",
    "balamucul": "balamuc",
    "balamucului": "balamuc",
    "balamucuri": "balamuc",
    "balamucurile": "balamuc",
    "balamucurilor": "balamuc",
    "bălana": "bălan",
    "bălană": "bălan",
    "bălane": "bălan",
    "bălanei": "bălan",
    "bălanele": "bălan",
    "bălanelor": "bălan",
    "bălani": "bălan",
    "bălanii": "bălan",
    "bălanilor": "bălan",
    "bălanul": "bălan",
    "bălanului": "bălan",
    "balansă": "balansa",
    "balansai": "balansa",
    "balansam": "balansa",
    "balansăm": "balansa",
    "balansând": "balansa",
    "balansându": "balansa",
    "balansară": "balansa",
    "balansarăm": "balansa",
    "balansarăți": "balansa",
    "balansase": "balansa",
    "balansasem": "balansa",
    "balansaseră": "balansa",
    "balansaserăm": "balansa",
    "balansaserăți": "balansa",
    "balansaseși": "balansa",
    "balansași": "balansa",
    "balansat": "balansa",
    "balansați": "balansa",
    "balansatu": "balansa",
    "balansau": "balansa",
    "balansează": "balansa",
    "balansez": "balansa",
    "balanseze": "balansa",
    "balansezi": "balansa",
    "balansarea": "balansare",
    "balansări": "balansare",
    "balansării": "balansare",
    "balansările": "balansare",
    "balansată": "balansat",
    "balansate": "balansat",
    "balansați": "balansat",
    "balansoare": "balansoar",
    "balansoarele": "balansoar",
    "balansoarelor": "balansoar",
    "balansoarul": "balansoar",
    "balansoarului": "balansoar",
    "balanța": "balanță",
    "balanțe": "balanță",
    "balanței": "balanță",
    "balanțele": "balanță",
    "balanțelor": "balanță",
    "balanțo": "balanță",
    "bălăriei": "bălărie",
    "bălării": "bălărie",
    "bălăriile": "bălărie",
    "bălăriilor": "bălărie",
    "balastul": "balast",
    "balastului": "balast",
    "balasturi": "balast",
    "balasturile": "balast",
    "balasturilor": "balast",
    "balastiera": "balastieră",
    "balastiere": "balastieră",
    "balastierei": "balastieră",
    "balastierele": "balastieră",
    "balastierelor": "balastieră",
    "balauri": "balaur",
    "balaurii": "balaur",
    "balaurilor": "balaur",
    "balaurul": "balaur",
    "balaurului": "balaur",
    "bâlba": "bâlbă",
    "bâlbe": "bâlbă",
    "bâlbei": "bâlbă",
    "bâlbele": "bâlbă",
    "bâlbelor": "bâlbă",
    "bâlbâia": "bâlbâi",
    "bâlbâiai": "bâlbâi",
    "bâlbâiam": "bâlbâi",
    "bâlbâiați": "bâlbâi",
    "bâlbâiau": "bâlbâi",
    "bâlbâie": "bâlbâi",
    "bâlbâii": "bâlbâi",
    "bâlbâim": "bâlbâi",
    "bâlbâind": "bâlbâi",
    "bâlbâindu": "bâlbâi",
    "bâlbâiră": "bâlbâi",
    "bâlbâirăm": "bâlbâi",
    "bâlbâirăți": "bâlbâi",
    "bâlbâise": "bâlbâi",
    "bâlbâisem": "bâlbâi",
    "bâlbâiseră": "bâlbâi",
    "bâlbâiserăm": "bâlbâi",
    "bâlbâiserăți": "bâlbâi",
    "bâlbâiseși": "bâlbâi",
    "bâlbâiși": "bâlbâi",
    "bâlbâit": "bâlbâi",
    "bâlbâiți": "bâlbâi",
    "bâlbâitu": "bâlbâi",
    "bâlbâiala": "bâlbâială",
    "bâlbâieli": "bâlbâială",
    "bâlbâielii": "bâlbâială",
    "bâlbâielile": "bâlbâială",
    "bâlbâielilor": "bâlbâială",
    "bâlbâită": "bâlbâit",
    "bâlbâite": "bâlbâit",
    "bâlbâiți": "bâlbâit",
    "balcanica": "balcanic",
    "balcanică": "balcanic",
    "balcanice": "balcanic",
    "balcanicei": "balcanic",
    "balcanicele": "balcanic",
    "balcanicelor": "balcanic",
    "balcanici": "balcanic",
    "balcanicii": "balcanic",
    "balcanicilor": "balcanic",
    "balcanicul": "balcanic",
    "balcanicului": "balcanic",
    "bâlciul": "bâlci",
    "bâlciului": "bâlci",
    "bâlciuri": "bâlci",
    "bâlciurile": "bâlci",
    "bâlciurilor": "bâlci",
    "balcoane": "balcon",
    "balcoanele": "balcon",
    "balcoanelor": "balcon",
    "balconul": "balcon",
    "balconului": "balcon",
    "baldachine": "baldachin",
    "baldachinele": "baldachin",
    "baldachinelor": "baldachin",
    "baldachinul": "baldachin",
    "baldachinului": "baldachin",
    "balega": "balegă",
    "balegi": "balegă",
    "balegii": "balegă",
    "balegile": "balegă",
    "balegilor": "balegă",
    "bălegarul": "bălegar",
    "bălegarului": "bălegar",
    "balena": "balenă",
    "balene": "balenă",
    "balenei": "balenă",
    "balenele": "balenă",
    "balenelor": "balenă",
    "baleniera": "balenieră",
    "baleniere": "balenieră",
    "balenierei": "balenieră",
    "balenierele": "balenieră",
    "balenierelor": "balenieră",
    "balerini": "balerin",
    "balerinii": "balerin",
    "balerinilor": "balerin",
    "balerinul": "balerin",
    "balerinului": "balerin",
    "balerina": "balerină",
    "balerine": "balerină",
    "balerinei": "balerină",
    "balerinele": "balerină",
    "balerinelor": "balerină",
    "balete": "balet",
    "baletele": "balet",
    "baletelor": "balet",
    "baletul": "balet",
    "baletului": "balet",
    "balistica": "balistic",
    "balistică": "balistic",
    "balistice": "balistic",
    "balisticei": "balistic",
    "balisticele": "balistic",
    "balisticelor": "balistic",
    "balistici": "balistic",
    "balisticii": "balistic",
    "balisticilor": "balistic",
    "balisticul": "balistic",
    "balisticului": "balistic",
    "baliverna": "balivernă",
    "baliverne": "balivernă",
    "balivernei": "balivernă",
    "balivernele": "balivernă",
    "balivernelor": "balivernă",
    "baliza": "baliză",
    "balize": "baliză",
    "balizei": "baliză",
    "balizele": "baliză",
    "balizelor": "baliză",
    "bălmăjeala": "bălmăjeală",
    "bălmăjealo": "bălmăjeală",
    "bălmăjeli": "bălmăjeală",
    "bălmăjelii": "bălmăjeală",
    "bălmăjelile": "bălmăjeală",
    "bălmăjelilor": "bălmăjeală",
    "bălmăjea": "bălmăji",
    "bălmăjeai": "bălmăji",
    "bălmăjeam": "bălmăji",
    "bălmăjească": "bălmăji",
    "bălmăjeați": "bălmăji",
    "bălmăjeau": "bălmăji",
    "bălmăjesc": "bălmăji",
    "bălmăjește": "bălmăji",
    "bălmăjești": "bălmăji",
    "bălmăjii": "bălmăji",
    "bălmăjim": "bălmăji",
    "bălmăjind": "bălmăji",
    "bălmăjindu": "bălmăji",
    "bălmăjiră": "bălmăji",
    "bălmăjirăm": "bălmăji",
    "bălmăjirăți": "bălmăji",
    "bălmăjise": "bălmăji",
    "bălmăjisem": "bălmăji",
    "bălmăjiseră": "bălmăji",
    "bălmăjiserăm": "bălmăji",
    "bălmăjiserăți": "bălmăji",
    "bălmăjiseși": "bălmăji",
    "bălmăjiși": "bălmăji",
    "bălmăjit": "bălmăji",
    "bălmăjiți": "bălmăji",
    "bălmăjitu": "bălmăji",
    "nebălmăjind": "bălmăji",
    "nebălmăjindu": "bălmăji",
    "nemaibălmăjind": "bălmăji",
    "nemaibălmăjindu": "bălmăji",
    "bălmăjirea": "bălmăjire",
    "bălmăjireo": "bălmăjire",
    "bălmăjiri": "bălmăjire",
    "bălmăjirii": "bălmăjire",
    "bălmăjirile": "bălmăjire",
    "bălmăjirilor": "bălmăjire",
    "bălmăjita": "bălmăjit",
    "bălmăjită": "bălmăjit",
    "bălmăjite": "bălmăjit",
    "bălmăjitei": "bălmăjit",
    "bălmăjitele": "bălmăjit",
    "bălmăjitelor": "bălmăjit",
    "bălmăjiți": "bălmăjit",
    "bălmăjiții": "bălmăjit",
    "bălmăjiților": "bălmăjit",
    "bălmăjito": "bălmăjit",
    "bălmăjitul": "bălmăjit",
    "bălmăjitule": "bălmăjit",
    "bălmăjitului": "bălmăjit",
    "balneara": "balnear",
    "balneară": "balnear",
    "balneare": "balnear",
    "balnearei": "balnear",
    "balnearele": "balnear",
    "balnearelor": "balnear",
    "balneari": "balnear",
    "balnearii": "balnear",
    "balnearilor": "balnear",
    "balnearul": "balnear",
    "balnearului": "balnear",
    "balneologi": "balneolog",
    "balneologii": "balneolog",
    "balneologilor": "balneolog",
    "balneologul": "balneolog",
    "balneologului": "balneolog",
    "balneologa": "balneologă",
    "balneologe": "balneologă",
    "balneologei": "balneologă",
    "balneologele": "balneologă",
    "balneologelor": "balneologă",
    "balneologia": "balneologie",
    "balneologiei": "balneologie",
    "balneologii": "balneologie",
    "balneologiile": "balneologie",
    "balneologiilor": "balneologie",
    "balneoterapica": "balneoterapic",
    "balneoterapică": "balneoterapic",
    "balneoterapice": "balneoterapic",
    "balneoterapicei": "balneoterapic",
    "balneoterapicele": "balneoterapic",
    "balneoterapicelor": "balneoterapic",
    "balneoterapici": "balneoterapic",
    "balneoterapicii": "balneoterapic",
    "balneoterapicilor": "balneoterapic",
    "balneoterapicul": "balneoterapic",
    "balneoterapicului": "balneoterapic",
    "balneoterapia": "balneoterapie",
    "balneoterapiei": "balneoterapie",
    "balneoterapii": "balneoterapie",
    "balneoterapiile": "balneoterapie",
    "balneoterapiilor": "balneoterapie",
    "baloane": "balon",
    "baloanele": "balon",
    "baloanelor": "balon",
    "balonul": "balon",
    "balonului": "balon",
    "balonă": "balona",
    "balonai": "balona",
    "balonam": "balona",
    "balonăm": "balona",
    "balonând": "balona",
    "balonându": "balona",
    "balonară": "balona",
    "balonarăm": "balona",
    "balonarăți": "balona",
    "balonase": "balona",
    "balonasem": "balona",
    "balonaseră": "balona",
    "balonaserăm": "balona",
    "balonaserăți": "balona",
    "balonaseși": "balona",
    "balonași": "balona",
    "balonat": "balona",
    "balonați": "balona",
    "balonatu": "balona",
    "balonau": "balona",
    "balonează": "balona",
    "balonez": "balona",
    "baloneze": "balona",
    "balonezi": "balona",
    "nebalonând": "balona",
    "nebalonându": "balona",
    "nemaibalonând": "balona",
    "nemaibalonându": "balona",
    "balonarea": "balonare",
    "balonări": "balonare",
    "balonării": "balonare",
    "balonările": "balonare",
    "balonata": "balonat",
    "balonată": "balonat",
    "balonate": "balonat",
    "balonatei": "balonat",
    "balonatele": "balonat",
    "balonatelor": "balonat",
    "balonați": "balonat",
    "balonații": "balonat",
    "balonaților": "balonat",
    "balonatul": "balonat",
    "balonatului": "balonat",
    "băloasa": "bălos",
    "băloasă": "bălos",
    "băloase": "bălos",
    "băloasei": "bălos",
    "băloasele": "bălos",
    "băloaselor": "bălos",
    "băloaso": "bălos",
    "băloși": "bălos",
    "băloșii": "bălos",
    "băloșilor": "bălos",
    "bălosul": "bălos",
    "bălosule": "bălos",
    "bălosului": "bălos",
    "balotul": "balot",
    "balotului": "balot",
    "baloturi": "balot",
    "baloturile": "balot",
    "baloturilor": "balot",
    "balotaje": "balotaj",
    "balotajele": "balotaj",
    "balotajelor": "balotaj",
    "balotajul": "balotaj",
    "balotajului": "balotaj",
    "Baloteștiul": "Balotești",
    "Baloteștiului": "Balotești",
    "balsamul": "balsam",
    "balsamului": "balsam",
    "balsamuri": "balsam",
    "balsamurile": "balsam",
    "balsamurilor": "balsam",
    "balta": "baltă",
    "bălți": "baltă",
    "bălții": "baltă",
    "bălțile": "baltă",
    "bălților": "baltă",
    "balto": "baltă",
    "baltagul": "baltag",
    "baltagului": "baltag",
    "baltaguri": "baltag",
    "baltagurile": "baltag",
    "baltagurilor": "baltag",
    "băltăreața": "băltăreț",
    "băltăreață": "băltăreț",
    "băltărețe": "băltăreț",
    "băltăreței": "băltăreț",
    "băltărețele": "băltăreț",
    "băltărețelor": "băltăreț",
    "băltăreți": "băltăreț",
    "băltăreții": "băltăreț",
    "băltăreților": "băltăreț",
    "băltărețul": "băltăreț",
    "băltărețului": "băltăreț",
    "bălțata": "bălțat",
    "bălțată": "bălțat",
    "bălțate": "bălțat",
    "bălțatei": "bălțat",
    "bălțatele": "bălțat",
    "bălțatelor": "bălțat",
    "bălțați": "bălțat",
    "bălțații": "bălțat",
    "bălțaților": "bălțat",
    "bălțatul": "bălțat",
    "bălțatului": "bălțat",
    "bălțata": "bălțată",
    "bălțate": "bălțată",
    "bălțatei": "bălțată",
    "bălțatele": "bălțată",
    "bălțatelor": "bălțată",
    "băltea": "bălti",
    "bălteai": "bălti",
    "bălteam": "bălti",
    "băltească": "bălti",
    "bălteați": "bălti",
    "bălteau": "bălti",
    "băltesc": "bălti",
    "băltește": "bălti",
    "băltești": "bălti",
    "băltii": "bălti",
    "băltim": "bălti",
    "băltind": "bălti",
    "băltindu": "bălti",
    "băltiră": "bălti",
    "băltirăm": "bălti",
    "băltirăți": "bălti",
    "băltise": "bălti",
    "băltisem": "bălti",
    "băltiseră": "bălti",
    "băltiserăm": "bălti",
    "băltiserăți": "bălti",
    "băltiseși": "bălti",
    "băltiși": "bălti",
    "băltit": "bălti",
    "băltiți": "bălti",
    "băltitu": "bălti",
    "baltică": "baltic",
    "baltice": "baltic",
    "baltici": "baltic",
    "băltită": "băltit",
    "băltite": "băltit",
    "băltiți": "băltit",
    "băltoaca": "băltoacă",
    "băltoace": "băltoacă",
    "băltoacei": "băltoacă",
    "băltoacele": "băltoacă",
    "băltoacelor": "băltoacă",
    "băltoaco": "băltoacă",
    "bani": "ban",
    "banii": "ban",
    "banilor": "ban",
    "banul": "ban",
    "banului": "ban",
    "banala": "banal",
    "banală": "banal",
    "banale": "banal",
    "banalei": "banal",
    "banalele": "banal",
    "banalelor": "banal",
    "banali": "banal",
    "banalii": "banal",
    "banalilor": "banal",
    "banalul": "banal",
    "banalului": "banal",
    "banalitatea": "banalitate",
    "banalitateo": "banalitate",
    "banalități": "banalitate",
    "banalității": "banalitate",
    "banalitățile": "banalitate",
    "banalităților": "banalitate",
    "banana": "banană",
    "banane": "banană",
    "bananei": "banană",
    "bananele": "banană",
    "bananelor": "banană",
    "Banatul": "Banat",
    "Banatului": "Banat",
    "bănatul": "bănat",
    "bănatului": "bănat",
    "bănaturi": "bănat",
    "bănaturile": "bănat",
    "bănaturilor": "bănat",
    "bănățeana": "bănățean",
    "bănățeană": "bănățean",
    "bănățeanul": "bănățean",
    "bănățeanului": "bănățean",
    "bănățene": "bănățean",
    "bănățenei": "bănățean",
    "bănățenele": "bănățean",
    "bănățenelor": "bănățean",
    "bănățeni": "bănățean",
    "bănățenii": "bănățean",
    "bănățenilor": "bănățean",
    "bănățeanca": "bănățeancă",
    "bănățence": "bănățeancă",
    "bănățencei": "bănățeancă",
    "bănățencele": "bănățeancă",
    "bănățencelor": "bănățeancă",
    "bancul": "banc",
    "bancului": "banc",
    "bancuri": "banc",
    "bancurile": "banc",
    "bancurilor": "banc",
    "banca": "bancă",
    "bănci": "bancă",
    "băncii": "bancă",
    "băncile": "bancă",
    "băncilor": "bancă",
    "BCR": "Banca_Comercială_Română",
    "B.D.F.": "Banca_Dacia_Felix",
    "BERD": "Banca_Europeană_de_Reconstrucție_și_Dezvoltare",
    "BIR": "Banca_Internațională_a_Religiilor",
    "BIRD": "Banca_Internațională_de_Reconstrucție_și_Dezvoltare",
    "B.N.R.": "Banca_Națională_a_României",
    "Băncii_Naționale_a_României": "Banca_Națională_a_României",
    "BNR": "Banca_Națională_a_României",
    "BRCE": "Banca_Română_de_Comerț_Exterior",
    "BRD": "Banca_Română_de_Dezvoltare",
    "bancara": "bancar",
    "bancară": "bancar",
    "bancare": "bancar",
    "bancarei": "bancar",
    "bancarele": "bancar",
    "bancarelor": "bancar",
    "bancari": "bancar",
    "bancarii": "bancar",
    "bancarilor": "bancar",
    "bancarul": "bancar",
    "bancarului": "bancar",
    "bancheri": "bancher",
    "bancherii": "bancher",
    "bancherilor": "bancher",
    "bancherul": "bancher",
    "bancherului": "bancher",
    "banchete": "banchet",
    "banchetele": "banchet",
    "banchetelor": "banchet",
    "banchetul": "banchet",
    "banchetului": "banchet",
    "bancheta": "banchetă",
    "banchete": "banchetă",
    "banchetei": "banchetă",
    "banchetele": "banchetă",
    "banchetelor": "banchetă",
    "bancheto": "banchetă",
    "banchiza": "banchiză",
    "banchize": "banchiză",
    "banchizei": "banchiză",
    "banchizele": "banchiză",
    "banchizelor": "banchiză",
    "bancnota": "bancnotă",
    "bancnote": "bancnotă",
    "bancnotei": "bancnotă",
    "bancnotele": "bancnotă",
    "bancnotelor": "bancnotă",
    "bancruta": "bancrută",
    "bancrute": "bancrută",
    "bancrutei": "bancrută",
    "bancrutele": "bancrută",
    "bancrutelor": "bancrută",
    "banda": "bandă",
    "bande": "bandă",
    "bandei": "bandă",
    "bandele": "bandă",
    "bandelor": "bandă",
    "bando": "bandă",
    "bandajă": "bandaja",
    "bandajai": "bandaja",
    "bandajam": "bandaja",
    "bandajăm": "bandaja",
    "bandajând": "bandaja",
    "bandajându": "bandaja",
    "bandajară": "bandaja",
    "bandajarăm": "bandaja",
    "bandajarăți": "bandaja",
    "bandajase": "bandaja",
    "bandajasem": "bandaja",
    "bandajaseră": "bandaja",
    "bandajaserăm": "bandaja",
    "bandajaserăți": "bandaja",
    "bandajaseși": "bandaja",
    "bandajași": "bandaja",
    "bandajat": "bandaja",
    "bandajați": "bandaja",
    "bandajatu": "bandaja",
    "bandajau": "bandaja",
    "bandajează": "bandaja",
    "bandajez": "bandaja",
    "bandajeze": "bandaja",
    "bandajezi": "bandaja",
    "nebandajând": "bandaja",
    "nebandajându": "bandaja",
    "nemaibandajând": "bandaja",
    "nemaibandajându": "bandaja",
    "bandajarea": "bandajare",
    "bandajareo": "bandajare",
    "bandajări": "bandajare",
    "bandajării": "bandajare",
    "bandajările": "bandajare",
    "bandajărilor": "bandajare",
    "bandajata": "bandajat",
    "bandajată": "bandajat",
    "bandajate": "bandajat",
    "bandajatei": "bandajat",
    "bandajatele": "bandajat",
    "bandajatelor": "bandajat",
    "bandajați": "bandajat",
    "bandajații": "bandajat",
    "bandajaților": "bandajat",
    "bandajato": "bandajat",
    "bandajatul": "bandajat",
    "bandajatule": "bandajat",
    "bandajatului": "bandajat",
    "banderola": "banderolă",
    "banderole": "banderolă",
    "banderolei": "banderolă",
    "banderolele": "banderolă",
    "banderolelor": "banderolă",
    "bandiți": "bandit",
    "bandiții": "bandit",
    "bandiților": "bandit",
    "banditul": "bandit",
    "banditule": "bandit",
    "banditului": "bandit",
    "banduliera": "bandulieră",
    "banduliere": "bandulieră",
    "bandulierei": "bandulieră",
    "bandulierele": "bandulieră",
    "bandulierelor": "bandulieră",
    "băneasca": "bănesc",
    "bănească": "bănesc",
    "bănescul": "bănesc",
    "bănescului": "bănesc",
    "bănești": "bănesc",
    "băneștii": "bănesc",
    "băneștile": "bănesc",
    "băneștilor": "bănesc",
    "bănetul": "bănet",
    "bănetului": "bănet",
    "banița": "baniță",
    "banițe": "baniță",
    "baniței": "baniță",
    "banițele": "baniță",
    "banițelor": "baniță",
    "bănoasa": "bănos",
    "bănoasă": "bănos",
    "bănoase": "bănos",
    "bănoasei": "bănos",
    "bănoasele": "bănos",
    "bănoaselor": "bănos",
    "bănoaso": "bănos",
    "bănoși": "bănos",
    "bănoșii": "bănos",
    "bănoșilor": "bănos",
    "bănosul": "bănos",
    "bănosule": "bănos",
    "bănosului": "bănos",
    "bântuia": "bântui",
    "bântuiai": "bântui",
    "bântuiam": "bântui",
    "bântuiați": "bântui",
    "bântuiau": "bântui",
    "bântuie": "bântui",
    "bântuii": "bântui",
    "bântuim": "bântui",
    "bântuind": "bântui",
    "bântuindu": "bântui",
    "bântuiră": "bântui",
    "bântuirăm": "bântui",
    "bântuirăți": "bântui",
    "bântuise": "bântui",
    "bântuisem": "bântui",
    "bântuiseră": "bântui",
    "bântuiserăm": "bântui",
    "bântuiserăți": "bântui",
    "bântuiseși": "bântui",
    "bântuiși": "bântui",
    "bântuit": "bântui",
    "bântuiți": "bântui",
    "bântuitu": "bântui",
    "nebântuind": "bântui",
    "nebântuindu": "bântui",
    "nemaibântuind": "bântui",
    "nemaibântuindu": "bântui",
    "bântuirea": "bântuire",
    "bântuiri": "bântuire",
    "bântuirii": "bântuire",
    "bântuirile": "bântuire",
    "bântuita": "bântuit",
    "bântuită": "bântuit",
    "bântuite": "bântuit",
    "bântuitei": "bântuit",
    "bântuitele": "bântuit",
    "bântuitelor": "bântuit",
    "bântuiți": "bântuit",
    "bântuiții": "bântuit",
    "bântuiților": "bântuit",
    "bântuitul": "bântuit",
    "bântuitului": "bântuit",
    "bănuia": "bănui",
    "bănuiai": "bănui",
    "bănuiam": "bănui",
    "bănuiască": "bănui",
    "bănuiați": "bănui",
    "bănuiau": "bănui",
    "bănuie": "bănui",
    "bănuiesc": "bănui",
    "bănuiește": "bănui",
    "bănuiești": "bănui",
    "bănuii": "bănui",
    "bănuim": "bănui",
    "bănuind": "bănui",
    "bănuindu": "bănui",
    "bănuiră": "bănui",
    "bănuirăm": "bănui",
    "bănuirăți": "bănui",
    "bănuise": "bănui",
    "bănuisem": "bănui",
    "bănuiseră": "bănui",
    "bănuiserăm": "bănui",
    "bănuiserăți": "bănui",
    "bănuiseși": "bănui",
    "bănuiși": "bănui",
    "bănuit": "bănui",
    "bănuiți": "bănui",
    "bănuitu": "bănui",
    "nebănuind": "bănui",
    "nebănuindu": "bănui",
    "nemaibănuind": "bănui",
    "nemaibănuindu": "bănui",
    "bănuiala": "bănuială",
    "bănuieli": "bănuială",
    "bănuielii": "bănuială",
    "bănuielile": "bănuială",
    "bănuirea": "bănuire",
    "bănuiri": "bănuire",
    "bănuirii": "bănuire",
    "bănuirile": "bănuire",
    "bănuita": "bănuit",
    "bănuită": "bănuit",
    "bănuite": "bănuit",
    "bănuitei": "bănuit",
    "bănuitele": "bănuit",
    "bănuitelor": "bănuit",
    "bănuiți": "bănuit",
    "bănuiții": "bănuit",
    "bănuiților": "bănuit",
    "bănuitul": "bănuit",
    "bănuitului": "bănuit",
    "bănuita": "bănuită",
    "bănuite": "bănuită",
    "bănuitei": "bănuită",
    "bănuitele": "bănuită",
    "bănuitelor": "bănuită",
    "bănuitoare": "bănuitor",
    "bănuitoarea": "bănuitor",
    "bănuitoarei": "bănuitor",
    "bănuitoarele": "bănuitor",
    "bănuitoarelor": "bănuitor",
    "bănuitori": "bănuitor",
    "bănuitorii": "bănuitor",
    "bănuitorilor": "bănuitor",
    "bănuitorul": "bănuitor",
    "bănuitorului": "bănuitor",
    "bănuți": "bănuț",
    "bănuții": "bănuț",
    "bănuților": "bănuț",
    "bănuțul": "bănuț",
    "bănuțului": "bănuț",
    "baptista": "baptist",
    "baptistă": "baptist",
    "baptiste": "baptist",
    "baptistei": "baptist",
    "baptistele": "baptist",
    "baptistelor": "baptist",
    "baptiști": "baptist",
    "baptiștii": "baptist",
    "baptiștilor": "baptist",
    "baptistul": "baptist",
    "baptistului": "baptist",
    "baptista": "baptistă",
    "baptiste": "baptistă",
    "baptistei": "baptistă",
    "baptistele": "baptistă",
    "baptistelor": "baptistă",
    "barul": "bar",
    "barule": "bar",
    "barului": "bar",
    "baruri": "bar",
    "barurile": "bar",
    "barurilor": "bar",
    "bară": "bara",
    "barai": "bara",
    "baram": "bara",
    "barăm": "bara",
    "barând": "bara",
    "barându": "bara",
    "barară": "bara",
    "bararăm": "bara",
    "bararăți": "bara",
    "barase": "bara",
    "barasem": "bara",
    "baraseră": "bara",
    "baraserăm": "bara",
    "baraserăți": "bara",
    "baraseși": "bara",
    "barași": "bara",
    "barat": "bara",
    "barați": "bara",
    "baratu": "bara",
    "barau": "bara",
    "barează": "bara",
    "barez": "bara",
    "bareze": "bara",
    "barezi": "bara",
    "nebarând": "bara",
    "nebarându": "bara",
    "nemaibarând": "bara",
    "nemaibarându": "bara",
    "bara": "bară",
    "bare": "bară",
    "barei": "bară",
    "barele": "bară",
    "barelor": "bară",
    "baraca": "baracă",
    "barăci": "baracă",
    "barăcii": "baracă",
    "barăcile": "baracă",
    "barăcilor": "baracă",
    "bărăcuța": "bărăcuță",
    "bărăcuțe": "bărăcuță",
    "bărăcuței": "bărăcuță",
    "bărăcuțele": "bărăcuță",
    "bărăcuțelor": "bărăcuță",
    "baraje": "baraj",
    "barajele": "baraj",
    "barajelor": "baraj",
    "barajul": "baraj",
    "barajului": "baraj",
    "bararea": "barare",
    "barări": "barare",
    "barării": "barare",
    "barările": "barare",
    "barata": "barat",
    "barată": "barat",
    "barate": "barat",
    "baratei": "barat",
    "baratele": "barat",
    "baratelor": "barat",
    "barați": "barat",
    "barații": "barat",
    "baraților": "barat",
    "baratul": "barat",
    "baratului": "barat",
    "barba": "barbă",
    "bărbi": "barbă",
    "bărbii": "barbă",
    "bărbile": "barbă",
    "bărbilor": "barbă",
    "barbo": "barbă",
    "barbara": "barbar",
    "barbară": "barbar",
    "barbare": "barbar",
    "barbarei": "barbar",
    "barbarele": "barbar",
    "barbarelor": "barbar",
    "barbari": "barbar",
    "barbarii": "barbar",
    "barbarilor": "barbar",
    "barbarul": "barbar",
    "barbarului": "barbar",
    "barbara": "barbară",
    "barbare": "barbară",
    "barbarei": "barbară",
    "barbarele": "barbară",
    "barbarelor": "barbară",
    "barbaria": "barbarie",
    "barbariei": "barbarie",
    "barbarii": "barbarie",
    "barbariile": "barbarie",
    "barbariilor": "barbarie",
    "barbarisme": "barbarism",
    "barbarismele": "barbarism",
    "barbarismelor": "barbarism",
    "barbarismul": "barbarism",
    "barbarismului": "barbarism",
    "bărbați": "bărbat",
    "bărbații": "bărbat",
    "bărbaților": "bărbat",
    "bărbatul": "bărbat",
    "bărbatului": "bărbat",
    "bărbăteasca": "bărbătesc",
    "bărbătească": "bărbătesc",
    "bărbătescul": "bărbătesc",
    "bărbătescului": "bărbătesc",
    "bărbătești": "bărbătesc",
    "bărbăteștii": "bărbătesc",
    "bărbăteștile": "bărbătesc",
    "bărbăteștilor": "bărbătesc",
    "bărbăția": "bărbăție",
    "bărbăției": "bărbăție",
    "bărbății": "bărbăție",
    "bărbățiile": "bărbăție",
    "bărbățiilor": "bărbăție",
    "bărbătoasa": "bărbătos",
    "bărbătoasă": "bărbătos",
    "bărbătoase": "bărbătos",
    "bărbătoasei": "bărbătos",
    "bărbătoasele": "bărbătos",
    "bărbătoaselor": "bărbătos",
    "bărbătoși": "bărbătos",
    "bărbătoșii": "bărbătos",
    "bărbătoșilor": "bărbătos",
    "bărbătosul": "bărbătos",
    "bărbătosului": "bărbătos",
    "barbeta": "barbetă",
    "barbete": "barbetă",
    "barbetei": "barbetă",
    "barbetele": "barbetă",
    "barbetelor": "barbetă",
    "bărbia": "bărbie",
    "bărbiei": "bărbie",
    "bărbii": "bărbie",
    "bărbiile": "bărbie",
    "bărbiilor": "bărbie",
    "bărbio": "bărbie",
    "bărbieri": "bărbier",
    "bărbierii": "bărbier",
    "bărbierilor": "bărbier",
    "bărbieru": "bărbier",
    "bărbierul": "bărbier",
    "bărbierule": "bărbier",
    "bărbierului": "bărbier",
    "bărbiereala": "bărbiereală",
    "bărbierealo": "bărbiereală",
    "bărbiereli": "bărbiereală",
    "bărbierelii": "bărbiereală",
    "bărbierelile": "bărbiereală",
    "bărbierelilor": "bărbiereală",
    "bărbierea": "bărbieri",
    "bărbiereai": "bărbieri",
    "bărbieream": "bărbieri",
    "bărbierească": "bărbieri",
    "bărbiereați": "bărbieri",
    "bărbiereau": "bărbieri",
    "bărbieresc": "bărbieri",
    "bărbierește": "bărbieri",
    "bărbierești": "bărbieri",
    "bărbierii": "bărbieri",
    "bărbierim": "bărbieri",
    "bărbierind": "bărbieri",
    "bărbierindu": "bărbieri",
    "bărbieriră": "bărbieri",
    "bărbierirăm": "bărbieri",
    "bărbierirăți": "bărbieri",
    "bărbierise": "bărbieri",
    "bărbierisem": "bărbieri",
    "bărbieriseră": "bărbieri",
    "bărbieriserăm": "bărbieri",
    "bărbieriserăți": "bărbieri",
    "bărbieriseși": "bărbieri",
    "bărbieriși": "bărbieri",
    "bărbierit": "bărbieri",
    "bărbieriți": "bărbieri",
    "bărbieritu": "bărbieri",
    "nebărbierind": "bărbieri",
    "nebărbierindu": "bărbieri",
    "nemaibărbierind": "bărbieri",
    "nemaibărbierindu": "bărbieri",
    "bărbierirea": "bărbierire",
    "bărbierireo": "bărbierire",
    "bărbieriri": "bărbierire",
    "bărbieririi": "bărbierire",
    "bărbieririle": "bărbierire",
    "bărbieririlor": "bărbierire",
    "bărbierita": "bărbierit",
    "bărbierită": "bărbierit",
    "bărbierite": "bărbierit",
    "bărbieritei": "bărbierit",
    "bărbieritele": "bărbierit",
    "bărbieritelor": "bărbierit",
    "bărbieriți": "bărbierit",
    "bărbieriții": "bărbierit",
    "bărbieriților": "bărbierit",
    "bărbierito": "bărbierit",
    "bărbieritul": "bărbierit",
    "bărbieritule": "bărbierit",
    "bărbieritului": "bărbierit",
    "barbișoane": "barbișon",
    "barbișoanele": "barbișon",
    "barbișoanelor": "barbișon",
    "barbișonul": "barbișon",
    "barbișonului": "barbișon",
    "bărboasa": "bărboasă",
    "bărboase": "bărboasă",
    "bărboasei": "bărboasă",
    "bărboasele": "bărboasă",
    "bărboaselor": "bărboasă",
    "bărboasa": "bărbos",
    "bărboasă": "bărbos",
    "bărboase": "bărbos",
    "bărboasei": "bărbos",
    "bărboasele": "bărbos",
    "bărboaselor": "bărbos",
    "bărboși": "bărbos",
    "bărboșii": "bărbos",
    "bărboșilor": "bărbos",
    "bărbosul": "bărbos",
    "bărbosului": "bărbos",
    "barca": "barcă",
    "bărci": "barcă",
    "bărcii": "barcă",
    "bărcile": "barcă",
    "bărcilor": "barcă",
    "barco": "barcă",
    "Barcelonă": "Barcelona",
    "Barcelone": "Barcelona",
    "Barcelonei": "Barcelona",
    "bărcuța": "bărcuță",
    "bărcuțe": "bărcuță",
    "bărcuței": "bărcuță",
    "bărcuțele": "bărcuță",
    "bărcuțelor": "bărcuță",
    "bardul": "bard",
    "bardului": "bard",
    "barzi": "bard",
    "barzii": "bard",
    "barzilor": "bard",
    "barda": "bardă",
    "barde": "bardă",
    "bardei": "bardă",
    "bardele": "bardă",
    "bardelor": "bardă",
    "baremul": "barem",
    "baremului": "barem",
    "baremuri": "barem",
    "baremurile": "barem",
    "baremurilor": "barem",
    "bareta": "baretă",
    "barete": "baretă",
    "baretei": "baretă",
    "baretele": "baretă",
    "baretelor": "baretă",
    "bârfea": "bârfi",
    "bârfeai": "bârfi",
    "bârfeam": "bârfi",
    "bârfească": "bârfi",
    "bârfeați": "bârfi",
    "bârfeau": "bârfi",
    "bârfesc": "bârfi",
    "bârfește": "bârfi",
    "bârfești": "bârfi",
    "bârfii": "bârfi",
    "bârfim": "bârfi",
    "bârfind": "bârfi",
    "bârfindu": "bârfi",
    "bârfiră": "bârfi",
    "bârfirăm": "bârfi",
    "bârfirăți": "bârfi",
    "bârfise": "bârfi",
    "bârfisem": "bârfi",
    "bârfiseră": "bârfi",
    "bârfiserăm": "bârfi",
    "bârfiserăți": "bârfi",
    "bârfiseși": "bârfi",
    "bârfiși": "bârfi",
    "bârfit": "bârfi",
    "bârfiți": "bârfi",
    "bârfitu": "bârfi",
    "bârfita": "bârfit",
    "bârfită": "bârfit",
    "bârfite": "bârfit",
    "bârfitei": "bârfit",
    "bârfitele": "bârfit",
    "bârfitelor": "bârfit",
    "bârfiți": "bârfit",
    "bârfiții": "bârfit",
    "bârfiților": "bârfit",
    "bârfitul": "bârfit",
    "bârfitului": "bârfit",
    "bârfitoarea": "bârfitoare",
    "bârfitoarei": "bârfitoare",
    "bârfitoarele": "bârfitoare",
    "bârfitoarelor": "bârfitoare",
    "bârfitori": "bârfitor",
    "bârfitorii": "bârfitor",
    "bârfitorilor": "bârfitor",
    "bârfitorul": "bârfitor",
    "bârfitorului": "bârfitor",
    "barica": "baric",
    "barică": "baric",
    "barice": "baric",
    "baricei": "baric",
    "baricele": "baric",
    "baricelor": "baric",
    "barici": "baric",
    "baricii": "baric",
    "baricilor": "baric",
    "baricul": "baric",
    "baricului": "baric",
    "batantă": "baric",
    "baricada": "baricadă",
    "baricade": "baricadă",
    "baricadei": "baricadă",
    "baricadele": "baricadă",
    "baricadelor": "baricadă",
    "bariera": "barieră",
    "bariere": "barieră",
    "barierei": "barieră",
    "barierele": "barieră",
    "barierelor": "barieră",
    "bariero": "barieră",
    "barili": "baril",
    "barilii": "baril",
    "barililor": "baril",
    "barilul": "baril",
    "barilului": "baril",
    "barisfera": "barisferă",
    "barisfere": "barisferă",
    "barisferei": "barisferă",
    "barisferele": "barisferă",
    "barisferelor": "barisferă",
    "baritoni": "bariton",
    "baritonii": "bariton",
    "baritonilor": "bariton",
    "baritonul": "bariton",
    "baritonului": "bariton",
    "bariul": "bariu",
    "bariului": "bariu",
    "Bârladul": "Bârlad",
    "Bârladului": "Bârlad",
    "bârlogul": "bârlog",
    "bârlogului": "bârlog",
    "bârloguri": "bârlog",
    "bârlogurile": "bârlog",
    "bârlogurilor": "bârlog",
    "barmani": "barman",
    "barmanii": "barman",
    "barmanilor": "barman",
    "barmanul": "barman",
    "barmanule": "barman",
    "barmanului": "barman",
    "baroana": "baroană",
    "baroane": "baroană",
    "baroanei": "baroană",
    "baroanele": "baroană",
    "baroanelor": "baroană",
    "baroca": "baroc",
    "barocă": "baroc",
    "baroce": "baroc",
    "barocei": "baroc",
    "barocele": "baroc",
    "barocelor": "baroc",
    "baroci": "baroc",
    "barocii": "baroc",
    "barocilor": "baroc",
    "barocul": "baroc",
    "barocului": "baroc",
    "barocuri": "baroc",
    "barocurile": "baroc",
    "barocurilor": "baroc",
    "barometre": "barometru",
    "barometrele": "barometru",
    "barometrelor": "barometru",
    "barometrul": "barometru",
    "barometrului": "barometru",
    "baroni": "baron",
    "baronii": "baron",
    "baronilor": "baron",
    "baronul": "baron",
    "baronului": "baron",
    "baroase": "baros",
    "baroasele": "baros",
    "baroaselor": "baros",
    "barosul": "baros",
    "barosului": "baros",
    "baroul": "barou",
    "baroului": "barou",
    "barouri": "barou",
    "barourile": "barou",
    "barourilor": "barou",
    "bârsana": "bârsan",
    "bârsană": "bârsan",
    "bârsane": "bârsan",
    "bârsanei": "bârsan",
    "bârsanele": "bârsan",
    "bârsanelor": "bârsan",
    "bârsani": "bârsan",
    "bârsanii": "bârsan",
    "bârsanilor": "bârsan",
    "bârsanul": "bârsan",
    "bârsanului": "bârsan",
    "bărulețe": "băruleț",
    "bărulețele": "băruleț",
    "bărulețelor": "băruleț",
    "bărulețul": "băruleț",
    "bărulețule": "băruleț",
    "bărulețului": "băruleț",
    "basul": "bas",
    "basului": "bas",
    "basuri": "bas",
    "basurile": "bas",
    "basurilor": "bas",
    "baș-agale": "baș-aga",
    "basarabeana": "basarabean",
    "basarabeană": "basarabean",
    "basarabeanul": "basarabean",
    "basarabeanului": "basarabean",
    "basarabene": "basarabean",
    "basarabenei": "basarabean",
    "basarabenele": "basarabean",
    "basarabenelor": "basarabean",
    "basarabeni": "basarabean",
    "basarabenii": "basarabean",
    "basarabenilor": "basarabean",
    "basarabeanca": "basarabeancă",
    "basarabence": "basarabeancă",
    "basarabencei": "basarabeancă",
    "basarabencele": "basarabeancă",
    "basarabencelor": "basarabeancă",
    "Basarabie": "Basarabia",
    "Basarabiei": "Basarabia",
    "Basarabii": "Basarabia",
    "baș-boieri": "baș-boier",
    "baș-boierilor": "baș-boier",
    "baș-boierul": "baș-boier",
    "baș-boierului": "baș-boier",
    "baș-caimacami": "baș-caimacam",
    "baș-caimacamilor": "baș-caimacam",
    "baș-caimacamul": "baș-caimacam",
    "baș-caimacamului": "baș-caimacam",
    "baschetul": "baschet",
    "baschetului": "baschet",
    "baș-ciohodari": "baș-ciohodar",
    "baș-ciohodarilor": "baș-ciohodar",
    "baș-ciohodarul": "baș-ciohodar",
    "baș-ciohodarului": "baș-ciohodar",
    "bascula": "basculă",
    "bascule": "basculă",
    "basculei": "basculă",
    "basculele": "basculă",
    "basculelor": "basculă",
    "basculanta": "basculantă",
    "basculante": "basculantă",
    "basculantei": "basculantă",
    "basculantele": "basculantă",
    "basculantelor": "basculantă",
    "basme": "basm",
    "basmele": "basm",
    "basmelor": "basm",
    "basmul": "basm",
    "basmului": "basm",
    "basmale": "basma",
    "basmalei": "basma",
    "basmalele": "basma",
    "basmalelor": "basma",
    "basmaua": "basma",
    "băsmuirea": "băsmuire",
    "băsmuiri": "băsmuire",
    "băsmuirii": "băsmuire",
    "băsmuirile": "băsmuire",
    "băsmuirilor": "băsmuire",
    "băsmuitoare": "băsmuitor",
    "băsmuitoarea": "băsmuitor",
    "băsmuitoarei": "băsmuitor",
    "băsmuitoarele": "băsmuitor",
    "băsmuitoarelor": "băsmuitor",
    "băsmuitori": "băsmuitor",
    "băsmuitorii": "băsmuitor",
    "băsmuitorilor": "băsmuitor",
    "băsmuitorul": "băsmuitor",
    "băsmuitorului": "băsmuitor",
    "basna": "basnă",
    "basorelieful": "basorelief",
    "basoreliefului": "basorelief",
    "basoreliefuri": "basorelief",
    "basoreliefurile": "basorelief",
    "basoreliefurilor": "basorelief",
    "bastarda": "bastard",
    "bastardă": "bastard",
    "bastarde": "bastard",
    "bastardei": "bastard",
    "bastardele": "bastard",
    "bastardelor": "bastard",
    "bastardul": "bastard",
    "bastardului": "bastard",
    "bastarzi": "bastard",
    "bastarzii": "bastard",
    "bastarzilor": "bastard",
    "bastarda": "bastardă",
    "bastarde": "bastardă",
    "bastardei": "bastardă",
    "bastardele": "bastardă",
    "bastardelor": "bastardă",
    "bastimente": "bastiment",
    "bastimentele": "bastiment",
    "bastimentelor": "bastiment",
    "bastimentul": "bastiment",
    "bastimentului": "bastiment",
    "băștinașa": "băștinaș",
    "băștinașă": "băștinaș",
    "băștinașe": "băștinaș",
    "băștinașei": "băștinaș",
    "băștinașele": "băștinaș",
    "băștinașelor": "băștinaș",
    "băștinași": "băștinaș",
    "băștinașii": "băștinaș",
    "băștinașilor": "băștinaș",
    "băștinașul": "băștinaș",
    "băștinașului": "băștinaș",
    "bastioane": "bastion",
    "bastioanele": "bastion",
    "bastioanelor": "bastion",
    "bastionul": "bastion",
    "bastionului": "bastion",
    "bastoane": "baston",
    "bastoanele": "baston",
    "bastoanelor": "baston",
    "bastonul": "baston",
    "bastonule": "baston",
    "bastonului": "baston",
    "bățul": "băț",
    "bățule": "băț",
    "bățului": "băț",
    "bețe": "băț",
    "bețele": "băț",
    "bețelor": "băț",
    "bâta": "bâtă",
    "bâte": "bâtă",
    "bâtei": "bâtă",
    "bâtele": "bâtă",
    "bâtelor": "bâtă",
    "bâțâia": "bâțâi",
    "bâțâiai": "bâțâi",
    "bâțâiam": "bâțâi",
    "bâțâiați": "bâțâi",
    "bâțâiau": "bâțâi",
    "bâțâie": "bâțâi",
    "bâțâii": "bâțâi",
    "bâțâim": "bâțâi",
    "bâțâind": "bâțâi",
    "bâțâindu": "bâțâi",
    "bâțâiră": "bâțâi",
    "bâțâirăm": "bâțâi",
    "bâțâirăți": "bâțâi",
    "bâțâise": "bâțâi",
    "bâțâisem": "bâțâi",
    "bâțâiseră": "bâțâi",
    "bâțâiserăm": "bâțâi",
    "bâțâiserăți": "bâțâi",
    "bâțâiseși": "bâțâi",
    "bâțâiși": "bâțâi",
    "bâțâit": "bâțâi",
    "bâțâiți": "bâțâi",
    "bâțâitu": "bâțâi",
    "nebâțâind": "bâțâi",
    "nebâțâindu": "bâțâi",
    "nemaibâțâind": "bâțâi",
    "nemaibâțâindu": "bâțâi",
    "bâțâiala": "bâțâială",
    "bâțâialo": "bâțâială",
    "bâțâieli": "bâțâială",
    "bâțâielii": "bâțâială",
    "bâțâielile": "bâțâială",
    "bâțâielilor": "bâțâială",
    "bătăi": "bătaie",
    "bătaia": "bătaie",
    "bătăii": "bătaie",
    "bătăile": "bătaie",
    "bătăilor": "bătaie",
    "bătaio": "bătaie",
    "bătăioasa": "bătăioasă",
    "bătăioase": "bătăioasă",
    "bătăioasei": "bătăioasă",
    "bătăioasele": "bătăioasă",
    "bătăioaselor": "bătăioasă",
    "bătăioasa": "bătăios",
    "bătăioasă": "bătăios",
    "bătăioase": "bătăios",
    "bătăioasei": "bătăios",
    "bătăioasele": "bătăios",
    "bătăioaselor": "bătăios",
    "bătăioși": "bătăios",
    "bătăioșii": "bătăios",
    "bătăioșilor": "bătăios",
    "bătăiosul": "bătăios",
    "bătăiosului": "bătăios",
    "bâțâirea": "bâțâire",
    "bâțâireo": "bâțâire",
    "bâțâiri": "bâțâire",
    "bâțâirii": "bâțâire",
    "bâțâirile": "bâțâire",
    "bâțâirilor": "bâțâire",
    "bâțâita": "bâțâit",
    "bâțâită": "bâțâit",
    "bâțâite": "bâțâit",
    "bâțâitei": "bâțâit",
    "bâțâitele": "bâțâit",
    "bâțâitelor": "bâțâit",
    "bâțâiți": "bâțâit",
    "bâțâiții": "bâțâit",
    "bâțâiților": "bâțâit",
    "bâțâito": "bâțâit",
    "bâțâitul": "bâțâit",
    "bâțâitule": "bâțâit",
    "bâțâitului": "bâțâit",
    "bâțâitoarea": "bâțâitoare",
    "bâțâitoarei": "bâțâitoare",
    "bâțâitoarele": "bâțâitoare",
    "bâțâitoarelor": "bâțâitoare",
    "bâțâitoareo": "bâțâitoare",
    "bâțâitoare": "bâțâitor",
    "bâțâitoarea": "bâțâitor",
    "bâțâitoarei": "bâțâitor",
    "bâțâitoarele": "bâțâitor",
    "bâțâitoarelor": "bâțâitor",
    "bâțâitoareo": "bâțâitor",
    "bâțâitori": "bâțâitor",
    "bâțâitorii": "bâțâitor",
    "bâțâitorilor": "bâțâitor",
    "bâțâitorul": "bâțâitor",
    "bâțâitorule": "bâțâitor",
    "bâțâitorului": "bâțâitor",
    "batali": "batal",
    "batalii": "batal",
    "batalilor": "batal",
    "batalul": "batal",
    "batalului": "batal",
    "bătălia": "bătălie",
    "bătăliei": "bătălie",
    "bătălii": "bătălie",
    "bătăliile": "bătălie",
    "bătăliilor": "bătălie",
    "bătălio": "bătălie",
    "batalioane": "batalion",
    "batalioanele": "batalion",
    "batalioanelor": "batalion",
    "batalionul": "batalion",
    "batalionului": "batalion",
    "batanta": "batant",
    "batante": "batant",
    "batantei": "batant",
    "batantele": "batant",
    "batantelor": "batant",
    "batanți": "batant",
    "batanții": "batant",
    "batanților": "batant",
    "batantul": "batant",
    "batantule": "batant",
    "batantului": "batant",
    "bătătorita": "bătătorit",
    "bătătorită": "bătătorit",
    "bătătorite": "bătătorit",
    "bătătoritei": "bătătorit",
    "bătătoritele": "bătătorit",
    "bătătoritelor": "bătătorit",
    "bătătoriți": "bătătorit",
    "bătătoriții": "bătătorit",
    "bătătoriților": "bătătorit",
    "bătătoritul": "bătătorit",
    "bătătoritului": "bătătorit",
    "bătătura": "bătătură",
    "bătături": "bătătură",
    "bătăturii": "bătătură",
    "bătăturile": "bătătură",
    "bătăturilor": "bătătură",
    "bătăuși": "bătăuș",
    "bătăușii": "bătăuș",
    "bătăușilor": "bătăuș",
    "bătăușul": "bătăuș",
    "bătăușului": "bătăuș",
    "bat": "bate",
    "bată": "bate",
    "bătând": "bate",
    "bătându": "bate",
    "bătea": "bate",
    "băteai": "bate",
    "băteam": "bate",
    "băteați": "bate",
    "băteau": "bate",
    "batem": "bate",
    "bateți": "bate",
    "bați": "bate",
    "bătu": "bate",
    "bătui": "bate",
    "bătură": "bate",
    "băturăm": "bate",
    "băturăți": "bate",
    "bătuse": "bate",
    "bătusem": "bate",
    "bătuseră": "bate",
    "bătuserăm": "bate",
    "bătuserăți": "bate",
    "bătuseși": "bate",
    "bătuși": "bate",
    "bătut": "bate",
    "bătutu": "bate",
    "nebătând": "bate",
    "nebătându": "bate",
    "nemaibătând": "bate",
    "nemaibătându": "bate",
    "baterea": "batere",
    "batereo": "batere",
    "bateri": "batere",
    "baterii": "batere",
    "baterile": "batere",
    "baterilor": "batere",
    "bateria": "baterie",
    "bateriei": "baterie",
    "baterii": "baterie",
    "bateriile": "baterie",
    "bateriilor": "baterie",
    "batista": "batistă",
    "batiste": "batistă",
    "batistei": "batistă",
    "batistele": "batistă",
    "batistelor": "batistă",
    "batjocoreala": "batjocoreală",
    "batjocorealo": "batjocoreală",
    "batjocoreli": "batjocoreală",
    "batjocorelii": "batjocoreală",
    "batjocorelile": "batjocoreală",
    "batjocorelilor": "batjocoreală",
    "batjocorea": "batjocori",
    "batjocoreai": "batjocori",
    "batjocoream": "batjocori",
    "batjocorească": "batjocori",
    "batjocoreați": "batjocori",
    "batjocoreau": "batjocori",
    "batjocoresc": "batjocori",
    "batjocorește": "batjocori",
    "batjocorești": "batjocori",
    "batjocorii": "batjocori",
    "batjocorim": "batjocori",
    "batjocorind": "batjocori",
    "batjocorindu": "batjocori",
    "batjocoriră": "batjocori",
    "batjocorirăm": "batjocori",
    "batjocorirăți": "batjocori",
    "batjocorise": "batjocori",
    "batjocorisem": "batjocori",
    "batjocoriseră": "batjocori",
    "batjocoriserăm": "batjocori",
    "batjocoriserăți": "batjocori",
    "batjocoriseși": "batjocori",
    "batjocoriși": "batjocori",
    "batjocorit": "batjocori",
    "batjocoriți": "batjocori",
    "batjocoritu": "batjocori",
    "nebatjocorind": "batjocori",
    "nebatjocorindu": "batjocori",
    "nemaibatjocorind": "batjocori",
    "nemaibatjocorindu": "batjocori",
    "batjocorirea": "batjocorire",
    "batjocorireo": "batjocorire",
    "batjocoriri": "batjocorire",
    "batjocoririi": "batjocorire",
    "batjocoririle": "batjocorire",
    "batjocoririlor": "batjocorire",
    "batjocorita": "batjocorit",
    "batjocorită": "batjocorit",
    "batjocorite": "batjocorit",
    "batjocoritei": "batjocorit",
    "batjocoritele": "batjocorit",
    "batjocoritelor": "batjocorit",
    "batjocoriți": "batjocorit",
    "batjocoriții": "batjocorit",
    "batjocoriților": "batjocorit",
    "batjocorito": "batjocorit",
    "batjocoritul": "batjocorit",
    "batjocoritule": "batjocorit",
    "batjocoritului": "batjocorit",
    "batjocoritoarea": "batjocoritoare",
    "batjocoritoarei": "batjocoritoare",
    "batjocoritoarele": "batjocoritoare",
    "batjocoritoarelor": "batjocoritoare",
    "batjocoritoareo": "batjocoritoare",
    "batjocoritoare": "batjocoritor",
    "batjocoritoarea": "batjocoritor",
    "batjocoritoarei": "batjocoritor",
    "batjocoritoarele": "batjocoritor",
    "batjocoritoarelor": "batjocoritor",
    "batjocoritoareo": "batjocoritor",
    "batjocoritori": "batjocoritor",
    "batjocoritorii": "batjocoritor",
    "batjocoritorilor": "batjocoritor",
    "batjocoritorul": "batjocoritor",
    "batjocoritorule": "batjocoritor",
    "batjocoritorului": "batjocoritor",
    "batjocura": "batjocură",
    "batjocuri": "batjocură",
    "batjocurii": "batjocură",
    "batjocurile": "batjocură",
    "batjocurilor": "batjocură",
    "batoane": "baton",
    "batoanele": "baton",
    "batoanelor": "baton",
    "batonul": "baton",
    "batonule": "baton",
    "batonului": "baton",
    "bățoasa": "bățos",
    "bățoasă": "bățos",
    "bățoase": "bățos",
    "bățoasei": "bățos",
    "bățoasele": "bățos",
    "bățoaselor": "bățos",
    "bățoaso": "bățos",
    "bățoși": "bățos",
    "bățoșii": "bățos",
    "bățoșilor": "bățos",
    "bățosul": "bățos",
    "bățosule": "bățos",
    "bățosului": "bățos",
    "bătrâna": "bătrân",
    "bătrână": "bătrân",
    "bătrâne": "bătrân",
    "bătrânei": "bătrân",
    "bătrânele": "bătrân",
    "bătrânelor": "bătrân",
    "bătrâni": "bătrân",
    "bătrânii": "bătrân",
    "bătrânilor": "bătrân",
    "bătrânul": "bătrân",
    "bătrânule": "bătrân",
    "bătrânului": "bătrân",
    "bătrâna": "bătrână",
    "bătrâne": "bătrână",
    "bătrânei": "bătrână",
    "bătrânele": "bătrână",
    "bătrânelor": "bătrână",
    "bătrâno": "bătrână",
    "bătrânei": "bătrânel",
    "bătrâneii": "bătrânel",
    "bătrâneilor": "bătrânel",
    "bătrânelul": "bătrânel",
    "bătrânelule": "bătrânel",
    "bătrânelului": "bătrânel",
    "bătrânica": "bătrânel",
    "bătrânică": "bătrânel",
    "bătrânice": "bătrânel",
    "bătrânici": "bătrânel",
    "bătrânicii": "bătrânel",
    "bătrânicile": "bătrânel",
    "bătrânicilor": "bătrânel",
    "bătrânețea": "bătrânețe",
    "bătrâneți": "bătrânețe",
    "bătrâneții": "bătrânețe",
    "bătrânețile": "bătrânețe",
    "bătrâneților": "bătrânețe",
    "bătrânica": "bătrânică",
    "bătrânice": "bătrânică",
    "bătrânici": "bătrânică",
    "bătrânicii": "bătrânică",
    "bătrânicile": "bătrânică",
    "bătrânicilor": "bătrânică",
    "bătucita": "bătucit",
    "bătucită": "bătucit",
    "bătucite": "bătucit",
    "bătucitei": "bătucit",
    "bătucitele": "bătucit",
    "bătucitelor": "bătucit",
    "bătuciți": "bătucit",
    "bătuciții": "bătucit",
    "bătuciților": "bătucit",
    "bătucitul": "bătucit",
    "bătucitului": "bătucit",
    "bătuta": "bătut",
    "bătută": "bătut",
    "bătute": "bătut",
    "bătutei": "bătut",
    "bătutele": "bătut",
    "bătutelor": "bătut",
    "bătuți": "bătut",
    "bătuții": "bătut",
    "bătuților": "bătut",
    "bătuto": "bătut",
    "bătutul": "bătut",
    "bătutule": "bătut",
    "bătutului": "bătut",
    "bătuta": "bătută",
    "bătute": "bătută",
    "bătutei": "bătută",
    "bătutele": "bătută",
    "bătutelor": "bătută",
    "bătuto": "bătută",
    "băubilă": "băubil",
    "băubile": "băubil",
    "băubili": "băubil",
    "băuta": "băut",
    "băută": "băut",
    "băute": "băut",
    "băutei": "băut",
    "băutele": "băut",
    "băutelor": "băut",
    "băuți": "băut",
    "băuții": "băut",
    "băuților": "băut",
    "băutul": "băut",
    "băutului": "băut",
    "băuta": "băută",
    "băute": "băută",
    "băutei": "băută",
    "băutele": "băută",
    "băutelor": "băută",
    "băutoarea": "băutoare",
    "băutoarei": "băutoare",
    "băutoarele": "băutoare",
    "băutoarelor": "băutoare",
    "băutoare": "băutor",
    "băutoarea": "băutor",
    "băutoarei": "băutor",
    "băutoarele": "băutor",
    "băutoarelor": "băutor",
    "băutori": "băutor",
    "băutorii": "băutor",
    "băutorilor": "băutor",
    "băutorul": "băutor",
    "băutorului": "băutor",
    "băutura": "băutură",
    "băuturi": "băutură",
    "băuturii": "băutură",
    "băuturile": "băutură",
    "băuturilor": "băutură",
    "bază": "baza",
    "bazai": "baza",
    "bazam": "baza",
    "bazăm": "baza",
    "bazând": "baza",
    "bazându": "baza",
    "bazară": "baza",
    "bazarăm": "baza",
    "bazarăți": "baza",
    "bazase": "baza",
    "bazasem": "baza",
    "bazaseră": "baza",
    "bazaserăm": "baza",
    "bazaserăți": "baza",
    "bazaseși": "baza",
    "bazași": "baza",
    "bazat": "baza",
    "bazați": "baza",
    "bazatu": "baza",
    "bazau": "baza",
    "bazează": "baza",
    "bazez": "baza",
    "bazeze": "baza",
    "bazezi": "baza",
    "nebazând": "baza",
    "nebazându": "baza",
    "nemaibazând": "baza",
    "nemaibazându": "baza",
    "baza": "bază",
    "baze": "bază",
    "bazei": "bază",
    "bazele": "bază",
    "bazelor": "bază",
    "bazaconia": "bazaconie",
    "bazaconiei": "bazaconie",
    "bazaconii": "bazaconie",
    "bazaconiile": "bazaconie",
    "bazaconiilor": "bazaconie",
    "bâzâia": "bâzâi",
    "bâzâiai": "bâzâi",
    "bâzâiam": "bâzâi",
    "bâzâiați": "bâzâi",
    "bâzâiau": "bâzâi",
    "bâzâie": "bâzâi",
    "bâzâii": "bâzâi",
    "bâzâim": "bâzâi",
    "bâzâind": "bâzâi",
    "bâzâindu": "bâzâi",
    "bâzâiră": "bâzâi",
    "bâzâirăm": "bâzâi",
    "bâzâirăți": "bâzâi",
    "bâzâise": "bâzâi",
    "bâzâisem": "bâzâi",
    "bâzâiseră": "bâzâi",
    "bâzâiserăm": "bâzâi",
    "bâzâiserăți": "bâzâi",
    "bâzâiseși": "bâzâi",
    "bâzâiși": "bâzâi",
    "bâzâit": "bâzâi",
    "bâzâiți": "bâzâi",
    "bâzâitu": "bâzâi",
    "nebâzâind": "bâzâi",
    "nebâzâindu": "bâzâi",
    "nemaibâzâind": "bâzâi",
    "nemaibâzâindu": "bâzâi",
    "bâzâiala": "bâzâială",
    "bâzâialo": "bâzâială",
    "bâzâieli": "bâzâială",
    "bâzâielii": "bâzâială",
    "bâzâielile": "bâzâială",
    "bâzâielilor": "bâzâială",
    "bâzâirea": "bâzâire",
    "bâzâireo": "bâzâire",
    "bâzâiri": "bâzâire",
    "bâzâirii": "bâzâire",
    "bâzâirile": "bâzâire",
    "bâzâirilor": "bâzâire",
    "bâzâita": "bâzâit",
    "bâzâită": "bâzâit",
    "bâzâite": "bâzâit",
    "bâzâitei": "bâzâit",
    "bâzâitele": "bâzâit",
    "bâzâitelor": "bâzâit",
    "bâzâiți": "bâzâit",
    "bâzâiții": "bâzâit",
    "bâzâiților": "bâzâit",
    "bâzâito": "bâzâit",
    "bâzâitul": "bâzâit",
    "bâzâitule": "bâzâit",
    "bâzâitului": "bâzâit",
    "bâzâita": "bâzâită",
    "bâzâite": "bâzâită",
    "bâzâitei": "bâzâită",
    "bâzâitele": "bâzâită",
    "bâzâitelor": "bâzâită",
    "bâzâito": "bâzâită",
    "bâzâitoarea": "bâzâitoare",
    "bâzâitoarei": "bâzâitoare",
    "bâzâitoarele": "bâzâitoare",
    "bâzâitoarelor": "bâzâitoare",
    "bâzâitoareo": "bâzâitoare",
    "bâzâitoare": "bâzâitor",
    "bâzâitoarea": "bâzâitor",
    "bâzâitoarei": "bâzâitor",
    "bâzâitoarele": "bâzâitor",
    "bâzâitoarelor": "bâzâitor",
    "bâzâitoareo": "bâzâitor",
    "bâzâitori": "bâzâitor",
    "bâzâitorii": "bâzâitor",
    "bâzâitorilor": "bâzâitor",
    "bâzâitorul": "bâzâitor",
    "bâzâitorule": "bâzâitor",
    "bâzâitorului": "bâzâitor",
    "bazarul": "bazar",
    "bazarului": "bazar",
    "bazaruri": "bazar",
    "bazarurile": "bazar",
    "bazarurilor": "bazar",
    "bazarea": "bazare",
    "bazări": "bazare",
    "bazării": "bazare",
    "bazările": "bazare",
    "bazata": "bazat",
    "bazată": "bazat",
    "bazate": "bazat",
    "bazatei": "bazat",
    "bazatele": "bazat",
    "bazatelor": "bazat",
    "bazați": "bazat",
    "bazații": "bazat",
    "bazaților": "bazat",
    "bazatul": "bazat",
    "bazatului": "bazat",
    "bazilica": "bazilică",
    "bazilici": "bazilică",
    "bazilicii": "bazilică",
    "bazilicile": "bazilică",
    "bazilicilor": "bazilică",
    "bazine": "bazin",
    "bazinele": "bazin",
    "bazinelor": "bazin",
    "bazinul": "bazin",
    "bazinului": "bazin",
    "bând": "bea",
    "bându": "bea",
    "bău": "bea",
    "băui": "bea",
    "băură": "bea",
    "băurăm": "bea",
    "băurăți": "bea",
    "băuse": "bea",
    "băusem": "bea",
    "băuseră": "bea",
    "băuserăm": "bea",
    "băuserăți": "bea",
    "băuseși": "bea",
    "băuși": "bea",
    "băut": "bea",
    "băutu": "bea",
    "beai": "bea",
    "beam": "bea",
    "beați": "bea",
    "beau": "bea",
    "bei": "bea",
    "bem": "bea",
    "beți": "bea",
    "nebând": "bea",
    "nebându": "bea",
    "nemaibând": "bea",
    "nemaibându": "bea",
    "beata": "beat",
    "beată": "beat",
    "beatul": "beat",
    "beatului": "beat",
    "bete": "beat",
    "betei": "beat",
    "betele": "beat",
    "betelor": "beat",
    "beți": "beat",
    "beții": "beat",
    "beților": "beat",
    "beatitudinea": "beatitudine",
    "beatitudini": "beatitudine",
    "beatitudinii": "beatitudine",
    "beatitudinile": "beatitudine",
    "beatitudinilor": "beatitudine",
    "bebeluși": "bebeluș",
    "bebelușii": "bebeluș",
    "bebelușilor": "bebeluș",
    "bebelușul": "bebeluș",
    "bebelușului": "bebeluș",
    "becul": "bec",
    "becului": "bec",
    "becuri": "bec",
    "becurile": "bec",
    "becurilor": "bec",
    "beciul": "beci",
    "beciule": "beci",
    "beciului": "beci",
    "beciuri": "beci",
    "beciurile": "beci",
    "beciurilor": "beci",
    "becisnica": "becisnic",
    "becisnică": "becisnic",
    "becisnice": "becisnic",
    "becisnicei": "becisnic",
    "becisnicele": "becisnic",
    "becisnicelor": "becisnic",
    "becisnici": "becisnic",
    "becisnicii": "becisnic",
    "becisnicilor": "becisnic",
    "becisnicul": "becisnic",
    "becisnicului": "becisnic",
    "beduina": "beduin",
    "beduină": "beduin",
    "beduine": "beduin",
    "beduinei": "beduin",
    "beduinele": "beduin",
    "beduinelor": "beduin",
    "beduini": "beduin",
    "beduinii": "beduin",
    "beduinilor": "beduin",
    "beduinul": "beduin",
    "beduinului": "beduin",
    "behăia": "behăi",
    "behăiai": "behăi",
    "behăiam": "behăi",
    "behăiați": "behăi",
    "behăiau": "behăi",
    "behăie": "behăi",
    "behăii": "behăi",
    "behăim": "behăi",
    "behăind": "behăi",
    "behăindu": "behăi",
    "behăiră": "behăi",
    "behăirăm": "behăi",
    "behăirăți": "behăi",
    "behăise": "behăi",
    "behăisem": "behăi",
    "behăiseră": "behăi",
    "behăiserăm": "behăi",
    "behăiserăți": "behăi",
    "behăiseși": "behăi",
    "behăiși": "behăi",
    "behăit": "behăi",
    "behăiți": "behăi",
    "behăitu": "behăi",
    "nebehăind": "behăi",
    "nebehăindu": "behăi",
    "nemaibehăind": "behăi",
    "nemaibehăindu": "behăi",
    "behăiala": "behăială",
    "behăialo": "behăială",
    "behăieli": "behăială",
    "behăielii": "behăială",
    "behăielile": "behăială",
    "behăielilor": "behăială",
    "behăirea": "behăire",
    "behăireo": "behăire",
    "behăiri": "behăire",
    "behăirii": "behăire",
    "behăirile": "behăire",
    "behăirilor": "behăire",
    "behăita": "behăit",
    "behăită": "behăit",
    "behăite": "behăit",
    "behăitei": "behăit",
    "behăitele": "behăit",
    "behăitelor": "behăit",
    "behăiți": "behăit",
    "behăiții": "behăit",
    "behăiților": "behăit",
    "behăito": "behăit",
    "behăitul": "behăit",
    "behăitule": "behăit",
    "behăitului": "behăit",
    "behăitoarea": "behăitoare",
    "behăitoarei": "behăitoare",
    "behăitoarele": "behăitoare",
    "behăitoarelor": "behăitoare",
    "behăitoareo": "behăitoare",
    "behăitoare": "behăitor",
    "behăitoarea": "behăitor",
    "behăitoarei": "behăitor",
    "behăitoarele": "behăitor",
    "behăitoarelor": "behăitor",
    "behăitoareo": "behăitor",
    "behăitori": "behăitor",
    "behăitorii": "behăitor",
    "behăitorilor": "behăitor",
    "behăitorul": "behăitor",
    "behăitorule": "behăitor",
    "behăitorului": "behăitor",
    "beii": "bei",
    "beilor": "bei",
    "beiul": "bei",
    "beiului": "bei",
    "Beijingul": "Beijing",
    "Beijingului": "Beijing",
    "beilicul": "beilic",
    "beilicului": "beilic",
    "beilicuri": "beilic",
    "beilicurile": "beilic",
    "beilicurilor": "beilic",
    "Beirutul": "Beirut",
    "Beirutului": "Beirut",
    "beizadeaua": "beizadea",
    "beizadele": "beizadea",
    "beizadelei": "beizadea",
    "beizadelele": "beizadea",
    "beizadelelor": "beizadea",
    "bejenia": "bejenie",
    "bejeniei": "bejenie",
    "bejenii": "bejenie",
    "bejeniile": "bejenie",
    "bejeniilor": "bejenie",
    "bejeniți": "bejenit",
    "bejeniții": "bejenit",
    "bejeniților": "bejenit",
    "bejenitul": "bejenit",
    "bejenitului": "bejenit",
    "B": "bel",
    "beli": "bel",
    "belii": "bel",
    "belilor": "bel",
    "belul": "bel",
    "belului": "bel",
    "beladona": "beladonă",
    "beladone": "beladonă",
    "beladonei": "beladonă",
    "beladonele": "beladonă",
    "beladonelor": "beladonă",
    "Belarusul": "Belarus",
    "Belarusului": "Belarus",
    "bele-artele": "bele-arte",
    "bele-artelor": "bele-arte",
    "Bel.": "Belgia",
    "Belgie": "Belgia",
    "Belgiei": "Belgia",
    "Belgii": "Belgia",
    "belgiana": "belgian",
    "belgiană": "belgian",
    "belgianul": "belgian",
    "belgianului": "belgian",
    "belgiene": "belgian",
    "belgienei": "belgian",
    "belgienele": "belgian",
    "belgienelor": "belgian",
    "belgieni": "belgian",
    "belgienii": "belgian",
    "belgienilor": "belgian",
    "belgianca": "belgiancă",
    "belgience": "belgiancă",
    "belgiencei": "belgiancă",
    "belgiencele": "belgiancă",
    "belgiencelor": "belgiancă",
    "belicoasa": "belicos",
    "belicoasă": "belicos",
    "belicoase": "belicos",
    "belicoasei": "belicos",
    "belicoasele": "belicos",
    "belicoaselor": "belicos",
    "belicoși": "belicos",
    "belicoșii": "belicos",
    "belicoșilor": "belicos",
    "belicosul": "belicos",
    "belicosului": "belicos",
    "beligeranta": "beligerant",
    "beligerantă": "beligerant",
    "beligerante": "beligerant",
    "beligerantei": "beligerant",
    "beligerantele": "beligerant",
    "beligerantelor": "beligerant",
    "beligeranți": "beligerant",
    "beligeranții": "beligerant",
    "beligeranților": "beligerant",
    "beligerantul": "beligerant",
    "beligerantului": "beligerant",
    "belinografe": "belinograf",
    "belinografele": "belinograf",
    "belinografelor": "belinograf",
    "belinograful": "belinograf",
    "belinografului": "belinograf",
    "belșugul": "belșug",
    "belșugului": "belșug",
    "belșuguri": "belșug",
    "belșugurile": "belșug",
    "belșugurilor": "belșug",
    "belvederea": "belvedere",
    "belvederi": "belvedere",
    "belvederii": "belvedere",
    "belvederile": "belvedere",
    "belvederilor": "belvedere",
    "bena": "benă",
    "bene": "benă",
    "benei": "benă",
    "benele": "benă",
    "benelor": "benă",
    "benchetuia": "benchetui",
    "benchetuiai": "benchetui",
    "benchetuiam": "benchetui",
    "benchetuiască": "benchetui",
    "benchetuiați": "benchetui",
    "benchetuiau": "benchetui",
    "benchetuiesc": "benchetui",
    "benchetuiește": "benchetui",
    "benchetuiești": "benchetui",
    "benchetuii": "benchetui",
    "benchetuim": "benchetui",
    "benchetuind": "benchetui",
    "benchetuindu": "benchetui",
    "benchetuiră": "benchetui",
    "benchetuirăm": "benchetui",
    "benchetuirăți": "benchetui",
    "benchetuise": "benchetui",
    "benchetuisem": "benchetui",
    "benchetuiseră": "benchetui",
    "benchetuiserăm": "benchetui",
    "benchetuiserăți": "benchetui",
    "benchetuiseși": "benchetui",
    "benchetuiși": "benchetui",
    "benchetuit": "benchetui",
    "benchetuiți": "benchetui",
    "benchetuirea": "benchetuire",
    "benchetuiri": "benchetuire",
    "benchetuirii": "benchetuire",
    "benchetuirile": "benchetuire",
    "benefica": "benefic",
    "benefică": "benefic",
    "benefice": "benefic",
    "beneficei": "benefic",
    "beneficele": "benefic",
    "beneficelor": "benefic",
    "benefici": "benefic",
    "beneficii": "benefic",
    "beneficilor": "benefic",
    "beneficul": "benefic",
    "beneficului": "benefic",
    "beneficiai": "beneficia",
    "beneficiam": "beneficia",
    "beneficiară": "beneficia",
    "beneficiarăm": "beneficia",
    "beneficiarăți": "beneficia",
    "beneficiase": "beneficia",
    "beneficiasem": "beneficia",
    "beneficiaseră": "beneficia",
    "beneficiaserăm": "beneficia",
    "beneficiaserăți": "beneficia",
    "beneficiaseși": "beneficia",
    "beneficiași": "beneficia",
    "beneficiat": "beneficia",
    "beneficiați": "beneficia",
    "beneficiatu": "beneficia",
    "beneficiau": "beneficia",
    "beneficiază": "beneficia",
    "beneficie": "beneficia",
    "beneficiem": "beneficia",
    "beneficiez": "beneficia",
    "beneficieze": "beneficia",
    "beneficiezi": "beneficia",
    "beneficiind": "beneficia",
    "beneficiindu": "beneficia",
    "nebeneficiind": "beneficia",
    "nebeneficiindu": "beneficia",
    "nemaibeneficiind": "beneficia",
    "nemaibeneficiindu": "beneficia",
    "beneficiari": "beneficiar",
    "beneficiarii": "beneficiar",
    "beneficiarilor": "beneficiar",
    "beneficiarul": "beneficiar",
    "beneficiarului": "beneficiar",
    "beneficiara": "beneficiară",
    "beneficiare": "beneficiară",
    "beneficiarei": "beneficiară",
    "beneficiarele": "beneficiară",
    "beneficiarelor": "beneficiară",
    "beneficiata": "beneficiat",
    "beneficiată": "beneficiat",
    "beneficiate": "beneficiat",
    "beneficiatei": "beneficiat",
    "beneficiatele": "beneficiat",
    "beneficiatelor": "beneficiat",
    "beneficiați": "beneficiat",
    "beneficiații": "beneficiat",
    "beneficiaților": "beneficiat",
    "beneficiatul": "beneficiat",
    "beneficiatului": "beneficiat",
    "beneficierea": "beneficiere",
    "beneficieri": "beneficiere",
    "beneficierii": "beneficiere",
    "beneficierile": "beneficiere",
    "beneficii": "beneficiu",
    "beneficiile": "beneficiu",
    "beneficiilor": "beneficiu",
    "beneficiul": "beneficiu",
    "beneficiului": "beneficiu",
    "benevola": "benevol",
    "benevolă": "benevol",
    "benevole": "benevol",
    "benevolei": "benevol",
    "benevolele": "benevol",
    "benevolelor": "benevol",
    "benevoli": "benevol",
    "benevolii": "benevol",
    "benevolilor": "benevol",
    "benevolul": "benevol",
    "benevolului": "benevol",
    "bengale": "bengal",
    "bengalele": "bengal",
    "bengalelor": "bengal",
    "bengalul": "bengal",
    "bengalului": "bengal",
    "bengaleza": "bengalez",
    "bengaleză": "bengalez",
    "bengaleze": "bengalez",
    "bengalezei": "bengalez",
    "bengalezele": "bengalez",
    "bengalezelor": "bengalez",
    "bengalezi": "bengalez",
    "bengalezii": "bengalez",
    "bengalezilor": "bengalez",
    "bengalezul": "bengalez",
    "bengalezului": "bengalez",
    "bengaleza": "bengaleză",
    "bengaleze": "bengaleză",
    "bengalezei": "bengaleză",
    "bengalezele": "bengaleză",
    "bengalezelor": "bengaleză",
    "Bengalie": "Bengalia",
    "Bengaliei": "Bengalia",
    "Bengalii": "Bengalia",
    "benghiul": "benghi",
    "benghiului": "benghi",
    "benghiuri": "benghi",
    "benghiurile": "benghi",
    "benghiurilor": "benghi",
    "benigna": "benign",
    "benignă": "benign",
    "benigne": "benign",
    "benignei": "benign",
    "benignele": "benign",
    "benignelor": "benign",
    "benigni": "benign",
    "benignii": "benign",
    "benignilor": "benign",
    "benignul": "benign",
    "benignului": "benign",
    "benzina": "benzină",
    "benzine": "benzină",
    "benzinei": "benzină",
    "benzinele": "benzină",
    "benzinelor": "benzină",
    "benzinăria": "benzinărie",
    "benzinăriei": "benzinărie",
    "benzinării": "benzinărie",
    "benzinăriile": "benzinărie",
    "benzinăriilor": "benzinărie",
    "berăria": "berărie",
    "berăriei": "berărie",
    "berării": "berărie",
    "berăriile": "berărie",
    "berăriilor": "berărie",
    "berbanți": "berbant",
    "berbanții": "berbant",
    "berbanților": "berbant",
    "berbantul": "berbant",
    "berbantului": "berbant",
    "berbecuți": "berbecuț",
    "berbecuții": "berbecuț",
    "berbecuților": "berbecuț",
    "berbecuțul": "berbecuț",
    "berbecuțului": "berbecuț",
    "bearca": "berc",
    "bearcă": "berc",
    "berce": "berc",
    "bercei": "berc",
    "bercele": "berc",
    "bercelor": "berc",
    "berci": "berc",
    "bercii": "berc",
    "bercilor": "berc",
    "bercul": "berc",
    "bercului": "berc",
    "berea": "bere",
    "bereo": "bere",
    "beri": "bere",
    "berii": "bere",
    "berile": "bere",
    "berilor": "bere",
    "berecheți": "berechet",
    "berecheții": "berechet",
    "berecheților": "berechet",
    "berechetul": "berechet",
    "berechetului": "berechet",
    "beregata": "beregată",
    "beregate": "beregată",
    "beregatei": "beregată",
    "beregatele": "beregată",
    "beregatelor": "beregată",
    "Be": "beriliu",
    "beriliul": "beriliu",
    "beriliului": "beriliu",
    "Berlinul": "Berlin",
    "Berlinului": "Berlin",
    "berna": "bernă",
    "berne": "bernă",
    "bernei": "bernă",
    "bernele": "bernă",
    "bernelor": "bernă",
    "beșica": "beșică",
    "beșici": "beșică",
    "beșicii": "beșică",
    "beșicile": "beșică",
    "beșicilor": "beșică",
    "beșico": "beșică",
    "beștelea": "beșteli",
    "beșteleai": "beșteli",
    "beșteleam": "beșteli",
    "beștelească": "beșteli",
    "beșteleați": "beșteli",
    "beșteleau": "beșteli",
    "beștelesc": "beșteli",
    "beștelește": "beșteli",
    "beștelești": "beșteli",
    "beștelii": "beșteli",
    "beștelim": "beșteli",
    "beștelind": "beșteli",
    "beștelindu": "beșteli",
    "beșteliră": "beșteli",
    "beștelirăm": "beșteli",
    "beștelirăți": "beșteli",
    "beștelise": "beșteli",
    "beștelisem": "beșteli",
    "beșteliseră": "beșteli",
    "beșteliserăm": "beșteli",
    "beșteliserăți": "beșteli",
    "beșteliseși": "beșteli",
    "beșteliși": "beșteli",
    "beștelit": "beșteli",
    "beșteliți": "beșteli",
    "beștelitu": "beșteli",
    "beștelită": "beștelit",
    "beștelite": "beștelit",
    "beșteliți": "beștelit",
    "bestiala": "bestial",
    "bestială": "bestial",
    "bestiale": "bestial",
    "bestialei": "bestial",
    "bestialele": "bestial",
    "bestialelor": "bestial",
    "bestiali": "bestial",
    "bestialii": "bestial",
    "bestialilor": "bestial",
    "bestialul": "bestial",
    "bestialului": "bestial",
    "bestialitatea": "bestialitate",
    "bestialități": "bestialitate",
    "bestialității": "bestialitate",
    "bestialitățile": "bestialitate",
    "bestialităților": "bestialitate",
    "bestia": "bestie",
    "bestiei": "bestie",
    "bestii": "bestie",
    "bestiile": "bestie",
    "bestiilor": "bestie",
    "beteaga": "beteag",
    "beteagă": "beteag",
    "beteagul": "beteag",
    "beteagului": "beteag",
    "betege": "beteag",
    "betegei": "beteag",
    "betegele": "beteag",
    "betegelor": "beteag",
    "betegi": "beteag",
    "betegii": "beteag",
    "betegilor": "beteag",
    "beteala": "beteală",
    "beteli": "beteală",
    "betelii": "beteală",
    "betelile": "beteală",
    "betelilor": "beteală",
    "betegea": "betegi",
    "betegeai": "betegi",
    "betegeam": "betegi",
    "betegească": "betegi",
    "betegeați": "betegi",
    "betegeau": "betegi",
    "betegesc": "betegi",
    "betegește": "betegi",
    "betegești": "betegi",
    "betegii": "betegi",
    "betegim": "betegi",
    "betegind": "betegi",
    "betegindu": "betegi",
    "betegiră": "betegi",
    "betegirăm": "betegi",
    "betegirăți": "betegi",
    "betegise": "betegi",
    "betegisem": "betegi",
    "betegiseră": "betegi",
    "betegiserăm": "betegi",
    "betegiserăți": "betegi",
    "betegiseși": "betegi",
    "betegiși": "betegi",
    "betegit": "betegi",
    "betegiți": "betegi",
    "betegitu": "betegi",
    "betegită": "betegit",
    "betegite": "betegit",
    "betegiți": "betegit",
    "betelia": "betelie",
    "beteliei": "betelie",
    "betelii": "betelie",
    "beteliile": "betelie",
    "beteliilor": "betelie",
    "beteșugul": "beteșug",
    "beteșugului": "beteșug",
    "beteșuguri": "beteșug",
    "beteșugurile": "beteșug",
    "beteșugurilor": "beteșug",
    "beția": "beție",
    "beției": "beție",
    "beții": "beție",
    "bețiile": "beție",
    "bețiilor": "beție",
    "bețiva": "bețiv",
    "bețivă": "bețiv",
    "bețive": "bețiv",
    "bețivei": "bețiv",
    "bețivele": "bețiv",
    "bețivelor": "bețiv",
    "bețivi": "bețiv",
    "bețivii": "bețiv",
    "bețivilor": "bețiv",
    "bețivo": "bețiv",
    "bețivul": "bețiv",
    "bețivule": "bețiv",
    "bețivului": "bețiv",
    "bețiva": "bețivă",
    "bețive": "bețivă",
    "bețivei": "bețivă",
    "bețivele": "bețivă",
    "bețivelor": "bețivă",
    "bețivo": "bețivă",
    "betoane": "beton",
    "betoanele": "beton",
    "betoanelor": "beton",
    "betonul": "beton",
    "betonului": "beton",
    "betoniera": "betonieră",
    "betoniere": "betonieră",
    "betonierei": "betonieră",
    "betonierele": "betonieră",
    "betonierelor": "betonieră",
    "bezeaua": "bezea",
    "bezele": "bezea",
    "bezelei": "bezea",
    "bezelele": "bezea",
    "bezelelor": "bezea",
    "besmetice": "bezmetic",
    "bezmetica": "bezmetic",
    "bezmetică": "bezmetic",
    "bezmetice": "bezmetic",
    "bezmeticei": "bezmetic",
    "bezmeticele": "bezmetic",
    "bezmeticelor": "bezmetic",
    "bezmetici": "bezmetic",
    "bezmeticii": "bezmetic",
    "bezmeticilor": "bezmetic",
    "bezmeticul": "bezmetic",
    "bezmeticului": "bezmetic",
    "bezna": "beznă",
    "bezne": "beznă",
    "beznei": "beznă",
    "beznele": "beznă",
    "beznelor": "beznă",
    "bietei": "biata",
    "bietele": "biata",
    "bietelor": "biata",
    "biatloane": "biatlon",
    "biatloanele": "biatlon",
    "biatloanelor": "biatlon",
    "biatlonul": "biatlon",
    "biatlonului": "biatlon",
    "bibeloul": "bibelou",
    "bibeloului": "bibelou",
    "bibelouri": "bibelou",
    "bibelourile": "bibelou",
    "bibelourilor": "bibelou",
    "biblica": "biblic",
    "biblică": "biblic",
    "biblice": "biblic",
    "biblicei": "biblic",
    "biblicele": "biblic",
    "biblicelor": "biblic",
    "biblici": "biblic",
    "biblicii": "biblic",
    "biblicilor": "biblic",
    "biblicul": "biblic",
    "biblicului": "biblic",
    "biblia": "biblie",
    "bibliei": "biblie",
    "biblii": "biblie",
    "bibliile": "biblie",
    "bibliilor": "biblie",
    "bibliografia": "bibliografie",
    "bibliografiei": "bibliografie",
    "bibliografii": "bibliografie",
    "bibliografiile": "bibliografie",
    "bibliografiilor": "bibliografie",
    "biblioraftul": "biblioraft",
    "biblioraftului": "biblioraft",
    "bibliorafturi": "biblioraft",
    "bibliorafturile": "biblioraft",
    "bibliorafturilor": "biblioraft",
    "biblioteca": "bibliotecă",
    "biblioteci": "bibliotecă",
    "bibliotecii": "bibliotecă",
    "bibliotecile": "bibliotecă",
    "bibliotecilor": "bibliotecă",
    "biblioteco": "bibliotecă",
    "bibliotecari": "bibliotecar",
    "bibliotecarii": "bibliotecar",
    "bibliotecarilor": "bibliotecar",
    "bibliotecarul": "bibliotecar",
    "bibliotecarului": "bibliotecar",
    "bibliotecara": "bibliotecară",
    "bibliotecare": "bibliotecară",
    "bibliotecarei": "bibliotecară",
    "bibliotecarele": "bibliotecară",
    "bibliotecarelor": "bibliotecară",
    "bibliotecuța": "bibliotecuță",
    "bibliotecuțe": "bibliotecuță",
    "bibliotecuței": "bibliotecuță",
    "bibliotecuțele": "bibliotecuță",
    "bibliotecuțelor": "bibliotecuță",
    "bibliotecuțo": "bibliotecuță",
    "Bicazul": "Bicaz",
    "Bicazului": "Bicaz",
    "bicefala": "bicefal",
    "bicefală": "bicefal",
    "bicefale": "bicefal",
    "bicefalei": "bicefal",
    "bicefalele": "bicefal",
    "bicefalelor": "bicefal",
    "bicefali": "bicefal",
    "bicefalii": "bicefal",
    "bicefalilor": "bicefal",
    "bicefalul": "bicefal",
    "bicefalului": "bicefal",
    "bicepși": "biceps",
    "bicepșii": "biceps",
    "bicepșilor": "biceps",
    "bicepsul": "biceps",
    "bicepsule": "biceps",
    "bicepsului": "biceps",
    "bice": "bici",
    "bicele": "bici",
    "bicelor": "bici",
    "biciul": "bici",
    "biciule": "bici",
    "biciului": "bici",
    "bicicleta": "bicicletă",
    "biciclete": "bicicletă",
    "bicicletei": "bicicletă",
    "bicicletele": "bicicletă",
    "bicicletelor": "bicicletă",
    "bicicleto": "bicicletă",
    "bicicliști": "biciclist",
    "bicicliștii": "biciclist",
    "bicicliștilor": "biciclist",
    "biciclistul": "biciclist",
    "biciclistului": "biciclist",
    "bicisnica": "bicisnic",
    "bicisnică": "bicisnic",
    "bicisnice": "bicisnic",
    "bicisnicei": "bicisnic",
    "bicisnicele": "bicisnic",
    "bicisnicelor": "bicisnic",
    "bicisnici": "bicisnic",
    "bicisnicii": "bicisnic",
    "bicisnicilor": "bicisnic",
    "bicisnicul": "bicisnic",
    "bicisnicului": "bicisnic",
    "biciuia": "biciui",
    "biciuiai": "biciui",
    "biciuiam": "biciui",
    "biciuiască": "biciui",
    "biciuiați": "biciui",
    "biciuiau": "biciui",
    "biciuiesc": "biciui",
    "biciuiește": "biciui",
    "biciuiești": "biciui",
    "biciuii": "biciui",
    "biciuim": "biciui",
    "biciuind": "biciui",
    "biciuindu": "biciui",
    "biciuiră": "biciui",
    "biciuirăm": "biciui",
    "biciuirăți": "biciui",
    "biciuise": "biciui",
    "biciuisem": "biciui",
    "biciuiseră": "biciui",
    "biciuiserăm": "biciui",
    "biciuiserăți": "biciui",
    "biciuiseși": "biciui",
    "biciuiși": "biciui",
    "biciuit": "biciui",
    "biciuiți": "biciui",
    "biciuitu": "biciui",
    "nebiciuind": "biciui",
    "nebiciuindu": "biciui",
    "nemaibiciuind": "biciui",
    "nemaibiciuindu": "biciui",
    "biciuiala": "biciuială",
    "biciuialo": "biciuială",
    "biciuieli": "biciuială",
    "biciuielii": "biciuială",
    "biciuielile": "biciuială",
    "biciuielilor": "biciuială",
    "biciuirea": "biciuire",
    "biciuireo": "biciuire",
    "biciuiri": "biciuire",
    "biciuirii": "biciuire",
    "biciuirile": "biciuire",
    "biciuirilor": "biciuire",
    "biciuita": "biciuit",
    "biciuită": "biciuit",
    "biciuite": "biciuit",
    "biciuitei": "biciuit",
    "biciuitele": "biciuit",
    "biciuitelor": "biciuit",
    "biciuiți": "biciuit",
    "biciuiții": "biciuit",
    "biciuiților": "biciuit",
    "biciuito": "biciuit",
    "biciuitul": "biciuit",
    "biciuitule": "biciuit",
    "biciuitului": "biciuit",
    "biciuitoare": "biciuitor",
    "biciuitoarea": "biciuitor",
    "biciuitoarei": "biciuitor",
    "biciuitoarele": "biciuitor",
    "biciuitoarelor": "biciuitor",
    "biciuitoareo": "biciuitor",
    "biciuitori": "biciuitor",
    "biciuitorii": "biciuitor",
    "biciuitorilor": "biciuitor",
    "biciuitorul": "biciuitor",
    "biciuitorule": "biciuitor",
    "biciuitorului": "biciuitor",
    "biconcava": "biconcav",
    "biconcavă": "biconcav",
    "biconcave": "biconcav",
    "biconcavei": "biconcav",
    "biconcavele": "biconcav",
    "biconcavelor": "biconcav",
    "biconcavi": "biconcav",
    "biconcavii": "biconcav",
    "biconcavilor": "biconcav",
    "biconcavul": "biconcav",
    "biconcavului": "biconcav",
    "bidimensională": "bidimensional",
    "bidimensionale": "bidimensional",
    "bidimensionali": "bidimensional",
    "bidivii": "bidiviu",
    "bidiviii": "bidiviu",
    "bidiviilor": "bidiviu",
    "bidiviul": "bidiviu",
    "bidiviului": "bidiviu",
    "bieful": "bief",
    "biefului": "bief",
    "biefuri": "bief",
    "biefurile": "bief",
    "biefurilor": "bief",
    "biela": "bielă",
    "biele": "bielă",
    "bielei": "bielă",
    "bielele": "bielă",
    "bielelor": "bielă",
    "bienala": "bienal",
    "bienală": "bienal",
    "bienale": "bienal",
    "bienalei": "bienal",
    "bienalele": "bienal",
    "bienalelor": "bienal",
    "bienali": "bienal",
    "bienalii": "bienal",
    "bienalilor": "bienal",
    "bienalul": "bienal",
    "bienalului": "bienal",
    "biata": "biet",
    "biată": "biet",
    "biete": "biet",
    "bietei": "biet",
    "bietele": "biet",
    "bietelor": "biet",
    "bieți": "biet",
    "bieții": "biet",
    "bieților": "biet",
    "bietul": "biet",
    "bietului": "biet",
    "bieții": "bietul",
    "bieților": "bietul",
    "bietului": "bietul",
    "bifă": "bifa",
    "bifai": "bifa",
    "bifam": "bifa",
    "bifăm": "bifa",
    "bifând": "bifa",
    "bifându": "bifa",
    "bifară": "bifa",
    "bifarăm": "bifa",
    "bifarăți": "bifa",
    "bifase": "bifa",
    "bifasem": "bifa",
    "bifaseră": "bifa",
    "bifaserăm": "bifa",
    "bifaserăți": "bifa",
    "bifaseși": "bifa",
    "bifași": "bifa",
    "bifat": "bifa",
    "bifați": "bifa",
    "bifatu": "bifa",
    "bifau": "bifa",
    "bifează": "bifa",
    "bifez": "bifa",
    "bifeze": "bifa",
    "bifezi": "bifa",
    "nebifând": "bifa",
    "nebifându": "bifa",
    "nemaibifând": "bifa",
    "nemaibifându": "bifa",
    "bifarea": "bifare",
    "bifări": "bifare",
    "bifării": "bifare",
    "bifările": "bifare",
    "bifata": "bifat",
    "bifată": "bifat",
    "bifate": "bifat",
    "bifatei": "bifat",
    "bifatele": "bifat",
    "bifatelor": "bifat",
    "bifați": "bifat",
    "bifații": "bifat",
    "bifaților": "bifat",
    "bifatul": "bifat",
    "bifatului": "bifat",
    "biftecul": "biftec",
    "biftecului": "biftec",
    "biftecuri": "biftec",
    "biftecurile": "biftec",
    "biftecurilor": "biftec",
    "bifurc": "bifurca",
    "bifurcă": "bifurca",
    "bifurcai": "bifurca",
    "bifurcam": "bifurca",
    "bifurcăm": "bifurca",
    "bifurcând": "bifurca",
    "bifurcându": "bifurca",
    "bifurcară": "bifurca",
    "bifurcarăm": "bifurca",
    "bifurcarăți": "bifurca",
    "bifurcase": "bifurca",
    "bifurcasem": "bifurca",
    "bifurcaseră": "bifurca",
    "bifurcaserăm": "bifurca",
    "bifurcaserăți": "bifurca",
    "bifurcaseși": "bifurca",
    "bifurcași": "bifurca",
    "bifurcat": "bifurca",
    "bifurcați": "bifurca",
    "bifurcatu": "bifurca",
    "bifurcau": "bifurca",
    "bifurce": "bifurca",
    "bifurci": "bifurca",
    "nebifurcând": "bifurca",
    "nebifurcându": "bifurca",
    "nemaibifurcând": "bifurca",
    "nemaibifurcându": "bifurca",
    "bifurcarea": "bifurcare",
    "bifurcări": "bifurcare",
    "bifurcării": "bifurcare",
    "bifurcările": "bifurcare",
    "bifurcata": "bifurcat",
    "bifurcată": "bifurcat",
    "bifurcate": "bifurcat",
    "bifurcatei": "bifurcat",
    "bifurcatele": "bifurcat",
    "bifurcatelor": "bifurcat",
    "bifurcați": "bifurcat",
    "bifurcații": "bifurcat",
    "bifurcaților": "bifurcat",
    "bifurcatul": "bifurcat",
    "bifurcatului": "bifurcat",
    "bigami": "bigam",
    "bigamii": "bigam",
    "bigamilor": "bigam",
    "bigamul": "bigam",
    "bigamului": "bigam",
    "bigama": "bigamă",
    "bigame": "bigamă",
    "bigamei": "bigamă",
    "bigamele": "bigamă",
    "bigamelor": "bigamă",
    "bigoți": "bigot",
    "bigoții": "bigot",
    "bigoților": "bigot",
    "bigotul": "bigot",
    "bigotului": "bigot",
    "bigota": "bigotă",
    "bigote": "bigotă",
    "bigotei": "bigotă",
    "bigotele": "bigotă",
    "bigotelor": "bigotă",
    "bigotisme": "bigotism",
    "bigotismele": "bigotism",
    "bigotismelor": "bigotism",
    "bigotismul": "bigotism",
    "bigotismului": "bigotism",
    "bigudiul": "bigudiu",
    "bigudiului": "bigudiu",
    "bigudiuri": "bigudiu",
    "bigudiurile": "bigudiu",
    "bigudiurilor": "bigudiu",
    "bijuteria": "bijuterie",
    "bijuteriei": "bijuterie",
    "bijuterii": "bijuterie",
    "bijuteriile": "bijuterie",
    "bijuteriilor": "bijuterie",
    "bijutieri": "bijutier",
    "bijutierii": "bijutier",
    "bijutierilor": "bijutier",
    "bijutierul": "bijutier",
    "bijutierului": "bijutier",
    "bila": "bilă",
    "bile": "bilă",
    "bilei": "bilă",
    "bilele": "bilă",
    "bilelor": "bilă",
    "bilo": "bilă",
    "bilanțul": "bilanț",
    "bilanțului": "bilanț",
    "bilanțuri": "bilanț",
    "bilanțurile": "bilanț",
    "bilanțurilor": "bilanț",
    "bilaterala": "bilateral",
    "bilaterală": "bilateral",
    "bilaterale": "bilateral",
    "bilateralei": "bilateral",
    "bilateralele": "bilateral",
    "bilateralelor": "bilateral",
    "bilaterali": "bilateral",
    "bilateralii": "bilateral",
    "bilateralilor": "bilateral",
    "bilateralul": "bilateral",
    "bilateralului": "bilateral",
    "bilete": "bilet",
    "biletele": "bilet",
    "biletelor": "bilet",
    "biletul": "bilet",
    "biletule": "bilet",
    "biletului": "bilet",
    "bilețele": "bilețel",
    "bilețelele": "bilețel",
    "bilețelelor": "bilețel",
    "bilețelul": "bilețel",
    "bilețelule": "bilețel",
    "bilețelului": "bilețel",
    "bilingva": "bilingv",
    "bilingvă": "bilingv",
    "bilingve": "bilingv",
    "bilingvei": "bilingv",
    "bilingvele": "bilingv",
    "bilingvelor": "bilingv",
    "bilingvi": "bilingv",
    "bilingvii": "bilingv",
    "bilingvilor": "bilingv",
    "bilingvul": "bilingv",
    "bilingvului": "bilingv",
    "bilingvismul": "bilingvism",
    "bilingvismului": "bilingvism",
    "bilunara": "bilunar",
    "bilunară": "bilunar",
    "bilunare": "bilunar",
    "bilunarei": "bilunar",
    "bilunarele": "bilunar",
    "bilunarelor": "bilunar",
    "bilunari": "bilunar",
    "bilunarii": "bilunar",
    "bilunarilor": "bilunar",
    "bilunarul": "bilunar",
    "bilunarului": "bilunar",
    "bimana": "biman",
    "bimană": "biman",
    "bimane": "biman",
    "bimanei": "biman",
    "bimanele": "biman",
    "bimanelor": "biman",
    "bimani": "biman",
    "bimanii": "biman",
    "bimanilor": "biman",
    "bimanul": "biman",
    "bimanului": "biman",
    "bimilenara": "bimilenar",
    "bimilenară": "bimilenar",
    "bimilenare": "bimilenar",
    "bimilenarei": "bimilenar",
    "bimilenarele": "bimilenar",
    "bimilenarelor": "bimilenar",
    "bimilenari": "bimilenar",
    "bimilenarii": "bimilenar",
    "bimilenarilor": "bimilenar",
    "bimilenarul": "bimilenar",
    "bimilenarului": "bimilenar",
    "binale": "bina",
    "binara": "binar",
    "binară": "binar",
    "binare": "binar",
    "binarei": "binar",
    "binarele": "binar",
    "binarelor": "binar",
    "binari": "binar",
    "binarii": "binar",
    "binarilor": "binar",
    "binarul": "binar",
    "binarului": "binar",
    "binele": "bine",
    "binelui": "bine",
    "bine_credincioasa": "bine_credincios",
    "bine_credincioasă": "bine_credincios",
    "bine_credincioase": "bine_credincios",
    "bine_credincioasei": "bine_credincios",
    "bine_credincioasele": "bine_credincios",
    "bine_credincioaselor": "bine_credincios",
    "bine_credincioși": "bine_credincios",
    "bine_credincioșii": "bine_credincios",
    "bine_credincioșilor": "bine_credincios",
    "bine_credinciosul": "bine_credincios",
    "bine_credinciosului": "bine_credincios",
    "bine_crescută": "bine_crescut",
    "bine_crescute": "bine_crescut",
    "bine_crescuți": "bine_crescut",
    "bine_cunoscuta": "bine_cunoscut",
    "bine_cunoscută": "bine_cunoscut",
    "bine_cunoscute": "bine_cunoscut",
    "bine_cunoscutei": "bine_cunoscut",
    "bine_cunoscutele": "bine_cunoscut",
    "bine_cunoscutelor": "bine_cunoscut",
    "bine_cunoscuți": "bine_cunoscut",
    "bine_cunoscuții": "bine_cunoscut",
    "bine_cunoscuților": "bine_cunoscut",
    "bine_cunoscutul": "bine_cunoscut",
    "bine_cunoscutului": "bine_cunoscut",
    "binecunoscutele": "bine_cunoscut",
    "bine-crescută": "bine-crescut",
    "bine-crescute": "bine-crescut",
    "bine-crescuți": "bine-crescut",
    "binecunoscutele": "binecunoscut",
    "bine-cunoscuta": "bine-cunoscut",
    "bine-cunoscută": "bine-cunoscut",
    "bine-cunoscute": "bine-cunoscut",
    "bine-cunoscutei": "bine-cunoscut",
    "bine-cunoscutele": "bine-cunoscut",
    "bine-cunoscutelor": "bine-cunoscut",
    "bine-cunoscuți": "bine-cunoscut",
    "bine-cunoscuții": "bine-cunoscut",
    "bine-cunoscuților": "bine-cunoscut",
    "bine-cunoscutul": "bine-cunoscut",
    "bine-cunoscutului": "bine-cunoscut",
    "binecuvântă": "binecuvânta",
    "binecuvântai": "binecuvânta",
    "binecuvântam": "binecuvânta",
    "binecuvântăm": "binecuvânta",
    "binecuvântând": "binecuvânta",
    "binecuvântându": "binecuvânta",
    "binecuvântară": "binecuvânta",
    "binecuvântarăm": "binecuvânta",
    "binecuvântarăți": "binecuvânta",
    "binecuvântase": "binecuvânta",
    "binecuvântasem": "binecuvânta",
    "binecuvântaseră": "binecuvânta",
    "binecuvântaserăm": "binecuvânta",
    "binecuvântaserăți": "binecuvânta",
    "binecuvântaseși": "binecuvânta",
    "binecuvântași": "binecuvânta",
    "binecuvântat": "binecuvânta",
    "binecuvântați": "binecuvânta",
    "binecuvântatu": "binecuvânta",
    "binecuvântau": "binecuvânta",
    "binecuvântează": "binecuvânta",
    "binecuvântez": "binecuvânta",
    "binecuvânteze": "binecuvânta",
    "binecuvântezi": "binecuvânta",
    "binecuvântarea": "binecuvântare",
    "binecuvântări": "binecuvântare",
    "binecuvântării": "binecuvântare",
    "binecuvântările": "binecuvântare",
    "binecuvântărilor": "binecuvântare",
    "binecuvântata": "binecuvântat",
    "binecuvântată": "binecuvântat",
    "binecuvântate": "binecuvântat",
    "binecuvântatei": "binecuvântat",
    "binecuvântatele": "binecuvântat",
    "binecuvântatelor": "binecuvântat",
    "binecuvântați": "binecuvântat",
    "binecuvântații": "binecuvântat",
    "binecuvântaților": "binecuvântat",
    "binecuvântatul": "binecuvântat",
    "binecuvântatului": "binecuvântat",
    "binedispui": "binedispune",
    "binedispun": "binedispune",
    "binedispună": "binedispune",
    "binedispunând": "binedispune",
    "binedispunându": "binedispune",
    "binedispunea": "binedispune",
    "binedispuneai": "binedispune",
    "binedispuneam": "binedispune",
    "binedispuneați": "binedispune",
    "binedispuneau": "binedispune",
    "binedispunem": "binedispune",
    "binedispuneți": "binedispune",
    "binedispus": "binedispune",
    "binedispuse": "binedispune",
    "binedispusei": "binedispune",
    "binedispuseră": "binedispune",
    "binedispuserăm": "binedispune",
    "binedispuserăți": "binedispune",
    "binedispusese": "binedispune",
    "binedispusesem": "binedispune",
    "binedispuseseră": "binedispune",
    "binedispuseserăm": "binedispune",
    "binedispuseserăți": "binedispune",
    "binedispuseseși": "binedispune",
    "binedispuseși": "binedispune",
    "binedispusu": "binedispune",
    "binedispusă": "binedispus",
    "binedispuse": "binedispus",
    "binedispuși": "binedispus",
    "binefăcătoarea": "binefăcătoare",
    "binefăcătoarei": "binefăcătoare",
    "binefăcătoarele": "binefăcătoare",
    "binefăcătoarelor": "binefăcătoare",
    "binefăcătoareo": "binefăcătoare",
    "binefăcătoare": "binefăcător",
    "binefăcători": "binefăcător",
    "binefăcătorii": "binefăcător",
    "binefăcătorilor": "binefăcător",
    "binefăcătorul": "binefăcător",
    "binefăcătorule": "binefăcător",
    "binefăcătorului": "binefăcător",
    "binefacerea": "binefacere",
    "binefaceri": "binefacere",
    "binefacerii": "binefacere",
    "binefacerile": "binefacere",
    "binefacerilor": "binefacere",
    "binemerit": "binemerita",
    "binemerită": "binemerita",
    "binemeritai": "binemerita",
    "binemeritam": "binemerita",
    "binemerităm": "binemerita",
    "binemeritând": "binemerita",
    "binemeritându": "binemerita",
    "binemeritară": "binemerita",
    "binemeritarăm": "binemerita",
    "binemeritarăți": "binemerita",
    "binemeritase": "binemerita",
    "binemeritasem": "binemerita",
    "binemeritaseră": "binemerita",
    "binemeritaserăm": "binemerita",
    "binemeritaserăți": "binemerita",
    "binemeritaseși": "binemerita",
    "binemeritași": "binemerita",
    "binemeritat": "binemerita",
    "binemeritați": "binemerita",
    "binemeritatu": "binemerita",
    "binemeritau": "binemerita",
    "binemerite": "binemerita",
    "binemeriți": "binemerita",
    "nebinemeritând": "binemerita",
    "nebinemeritându": "binemerita",
    "nemaibinemeritând": "binemerita",
    "nemaibinemeritându": "binemerita",
    "binemeritarea": "binemeritare",
    "binemeritări": "binemeritare",
    "binemeritării": "binemeritare",
    "binemeritările": "binemeritare",
    "binemeritata": "binemeritat",
    "binemeritată": "binemeritat",
    "binemeritate": "binemeritat",
    "binemeritatei": "binemeritat",
    "binemeritatele": "binemeritat",
    "binemeritatelor": "binemeritat",
    "binemeritați": "binemeritat",
    "binemeritații": "binemeritat",
    "binemeritaților": "binemeritat",
    "binemeritatul": "binemeritat",
    "binemeritatului": "binemeritat",
    "binevoită": "binemeritat",
    "bineplăcuta": "bineplăcut",
    "bineplăcută": "bineplăcut",
    "bineplăcute": "bineplăcut",
    "bineplăcutei": "bineplăcut",
    "bineplăcutele": "bineplăcut",
    "bineplăcutelor": "bineplăcut",
    "bineplăcuți": "bineplăcut",
    "bineplăcuții": "bineplăcut",
    "bineplăcuților": "bineplăcut",
    "bineplăcutul": "bineplăcut",
    "bineplăcutului": "bineplăcut",
    "bineștiuta": "bineștiut",
    "bineștiută": "bineștiut",
    "bineștiute": "bineștiut",
    "bineștiutei": "bineștiut",
    "bineștiutele": "bineștiut",
    "bineștiutelor": "bineștiut",
    "bineștiuți": "bineștiut",
    "bineștiuții": "bineștiut",
    "bineștiuților": "bineștiut",
    "bineștiutul": "bineștiut",
    "bineștiutului": "bineștiut",
    "binețea": "binețe",
    "binețele": "binețe",
    "binețelor": "binețe",
    "bineți": "binețe",
    "bineții": "binețe",
    "binevenita": "binevenit",
    "binevenită": "binevenit",
    "binevenite": "binevenit",
    "binevenitei": "binevenit",
    "binevenitele": "binevenit",
    "binevenitelor": "binevenit",
    "bineveniți": "binevenit",
    "bineveniții": "binevenit",
    "bineveniților": "binevenit",
    "binevenitul": "binevenit",
    "binevenitului": "binevenit",
    "binevoia": "binevoi",
    "binevoiai": "binevoi",
    "binevoiam": "binevoi",
    "binevoiască": "binevoi",
    "binevoiați": "binevoi",
    "binevoiau": "binevoi",
    "binevoiesc": "binevoi",
    "binevoiește": "binevoi",
    "binevoiești": "binevoi",
    "binevoii": "binevoi",
    "binevoim": "binevoi",
    "binevoind": "binevoi",
    "binevoindu": "binevoi",
    "binevoiră": "binevoi",
    "binevoirăm": "binevoi",
    "binevoirăți": "binevoi",
    "binevoise": "binevoi",
    "binevoisem": "binevoi",
    "binevoiseră": "binevoi",
    "binevoiserăm": "binevoi",
    "binevoiserăți": "binevoi",
    "binevoiseși": "binevoi",
    "binevoiși": "binevoi",
    "binevoit": "binevoi",
    "binevoiți": "binevoi",
    "binevoitu": "binevoi",
    "nebinevoind": "binevoi",
    "nebinevoindu": "binevoi",
    "nemaibinevoind": "binevoi",
    "nemaibinevoindu": "binevoi",
    "binevoirea": "binevoire",
    "binevoiri": "binevoire",
    "binevoirii": "binevoire",
    "binevoirile": "binevoire",
    "binevoita": "binevoit",
    "binevoită": "binevoit",
    "binevoite": "binevoit",
    "binevoitei": "binevoit",
    "binevoitele": "binevoit",
    "binevoitelor": "binevoit",
    "binevoiți": "binevoit",
    "binevoiții": "binevoit",
    "binevoiților": "binevoit",
    "binevoitul": "binevoit",
    "binevoitului": "binevoit",
    "binevoitoarea": "binevoitoare",
    "binevoitoarei": "binevoitoare",
    "binevoitoarele": "binevoitoare",
    "binevoitoarelor": "binevoitoare",
    "binevoitoareo": "binevoitoare",
    "binevoitoare": "binevoitor",
    "binevoitoarea": "binevoitor",
    "binevoitoarei": "binevoitor",
    "binevoitoarele": "binevoitor",
    "binevoitoarelor": "binevoitor",
    "binevoitoareo": "binevoitor",
    "binevoitori": "binevoitor",
    "binevoitorii": "binevoitor",
    "binevoitorilor": "binevoitor",
    "binevoitorul": "binevoitor",
    "binevoitorule": "binevoitor",
    "binevoitorului": "binevoitor",
    "binoclul": "binoclu",
    "binoclului": "binoclu",
    "binocluri": "binoclu",
    "binoclurile": "binoclu",
    "binoclurilor": "binoclu",
    "biobibliografia": "biobibliografie",
    "biobibliografiei": "biobibliografie",
    "biobibliografii": "biobibliografie",
    "biobibliografiile": "biobibliografie",
    "biobibliografiilor": "biobibliografie",
    "biocenoza": "biocenoză",
    "biocenoze": "biocenoză",
    "biocenozei": "biocenoză",
    "biocenozele": "biocenoză",
    "biocenozelor": "biocenoză",
    "biochim.": "biochimie",
    "biochimia": "biochimie",
    "biochimiei": "biochimie",
    "biochimii": "biochimie",
    "biochimiile": "biochimie",
    "biochimiilor": "biochimie",
    "bioenergetica": "bioenergetic",
    "bioenergetică": "bioenergetic",
    "bioenergetice": "bioenergetic",
    "bioenergeticei": "bioenergetic",
    "bioenergeticele": "bioenergetic",
    "bioenergeticelor": "bioenergetic",
    "bioenergetici": "bioenergetic",
    "bioenergeticii": "bioenergetic",
    "bioenergeticilor": "bioenergetic",
    "bioenergetico": "bioenergetic",
    "bioenergeticul": "bioenergetic",
    "bioenergeticule": "bioenergetic",
    "bioenergeticului": "bioenergetic",
    "bioenergetica": "bioenergetică",
    "bioenergetici": "bioenergetică",
    "bioenergeticii": "bioenergetică",
    "bioenergetico": "bioenergetică",
    "bioenergia": "bioenergie",
    "bioenergiei": "bioenergie",
    "bioenergii": "bioenergie",
    "bioenergiile": "bioenergie",
    "bioenergiilor": "bioenergie",
    "biofizica": "biofizică",
    "biofizici": "biofizică",
    "biofizicii": "biofizică",
    "biofizicile": "biofizică",
    "biofizicilor": "biofizică",
    "biogena": "biogen",
    "biogenă": "biogen",
    "biogene": "biogen",
    "biogenei": "biogen",
    "biogenele": "biogen",
    "biogenelor": "biogen",
    "biogeni": "biogen",
    "biogenii": "biogen",
    "biogenilor": "biogen",
    "biogenul": "biogen",
    "biogenului": "biogen",
    "biogeneza": "biogeneză",
    "biogeneze": "biogeneză",
    "biogenezei": "biogeneză",
    "biogenezele": "biogeneză",
    "biogenezelor": "biogeneză",
    "biografica": "biografic",
    "biografică": "biografic",
    "biografice": "biografic",
    "biograficei": "biografic",
    "biograficele": "biografic",
    "biograficelor": "biografic",
    "biografici": "biografic",
    "biograficii": "biografic",
    "biograficilor": "biografic",
    "biograficul": "biografic",
    "biograficului": "biografic",
    "biografia": "biografie",
    "biografiei": "biografie",
    "biografii": "biografie",
    "biografiile": "biografie",
    "biografiilor": "biografie",
    "biologi": "biolog",
    "biologii": "biolog",
    "biologilor": "biolog",
    "biologul": "biolog",
    "biologule": "biolog",
    "biologului": "biolog",
    "biologa": "biologă",
    "biologe": "biologă",
    "biologei": "biologă",
    "biologele": "biologă",
    "biologelor": "biologă",
    "biologo": "biologă",
    "biologica": "biologic",
    "biologică": "biologic",
    "biologice": "biologic",
    "biologicei": "biologic",
    "biologicele": "biologic",
    "biologicelor": "biologic",
    "biologici": "biologic",
    "biologicii": "biologic",
    "biologicilor": "biologic",
    "biologico": "biologic",
    "biologicul": "biologic",
    "biologicule": "biologic",
    "biologicului": "biologic",
    "biol.": "biologie",
    "biologia": "biologie",
    "biologiei": "biologie",
    "biologii": "biologie",
    "biologiile": "biologie",
    "biologiilor": "biologie",
    "bionica": "bionică",
    "bionici": "bionică",
    "bionicii": "bionică",
    "bionicile": "bionică",
    "bionicilor": "bionică",
    "biopsia": "biopsie",
    "biopsiei": "biopsie",
    "biopsii": "biopsie",
    "biopsiile": "biopsie",
    "biopsiilor": "biopsie",
    "biosfera": "biosferă",
    "biosfere": "biosferă",
    "biosferei": "biosferă",
    "biosferele": "biosferă",
    "biosferelor": "biosferă",
    "bioterapeutica": "bioterapeutic",
    "bioterapeutică": "bioterapeutic",
    "bioterapeutice": "bioterapeutic",
    "bioterapeuticei": "bioterapeutic",
    "bioterapeuticele": "bioterapeutic",
    "bioterapeuticelor": "bioterapeutic",
    "bioterapeutici": "bioterapeutic",
    "bioterapeuticii": "bioterapeutic",
    "bioterapeuticilor": "bioterapeutic",
    "bioterapeuticul": "bioterapeutic",
    "bioterapeuticului": "bioterapeutic",
    "bioterapia": "bioterapie",
    "bioterapiei": "bioterapie",
    "bioterapii": "bioterapie",
    "bioterapiile": "bioterapie",
    "bioterapiilor": "bioterapie",
    "biovindecătoare": "biovindecător",
    "biovindecătoarea": "biovindecător",
    "biovindecătoarei": "biovindecător",
    "biovindecătoarele": "biovindecător",
    "biovindecătoarelor": "biovindecător",
    "biovindecători": "biovindecător",
    "biovindecătorii": "biovindecător",
    "biovindecătorilor": "biovindecător",
    "biovindecătorul": "biovindecător",
    "biovindecătorului": "biovindecător",
    "bioxidul": "bioxid",
    "bioxidului": "bioxid",
    "bioxizi": "bioxid",
    "bioxizii": "bioxid",
    "bioxizilor": "bioxid",
    "bipartita": "bipartit",
    "bipartită": "bipartit",
    "bipartite": "bipartit",
    "bipartitei": "bipartit",
    "bipartitele": "bipartit",
    "bipartitelor": "bipartit",
    "bipartiți": "bipartit",
    "bipartiții": "bipartit",
    "bipartiților": "bipartit",
    "bipartitul": "bipartit",
    "bipartitului": "bipartit",
    "birul": "bir",
    "birului": "bir",
    "biruri": "bir",
    "birurile": "bir",
    "birurilor": "bir",
    "birja": "birjă",
    "birje": "birjă",
    "birjei": "birjă",
    "birjele": "birjă",
    "birjelor": "birjă",
    "birlici": "birlic",
    "birlicii": "birlic",
    "birlicilor": "birlic",
    "birlicul": "birlic",
    "birlicului": "birlic",
    "birlicuri": "birlic",
    "birlicurile": "birlic",
    "birlicurilor": "birlic",
    "Birmanie": "Birmania",
    "Birmaniei": "Birmania",
    "Birmanii": "Birmania",
    "birocrata": "birocrat",
    "birocrată": "birocrat",
    "birocrate": "birocrat",
    "birocratei": "birocrat",
    "birocratele": "birocrat",
    "birocratelor": "birocrat",
    "birocrați": "birocrat",
    "birocrații": "birocrat",
    "birocraților": "birocrat",
    "birocratul": "birocrat",
    "birocratului": "birocrat",
    "birocrata": "birocrată",
    "birocrate": "birocrată",
    "birocratei": "birocrată",
    "birocratele": "birocrată",
    "birocratelor": "birocrată",
    "birocrația": "birocrație",
    "birocrației": "birocrație",
    "birocrații": "birocrație",
    "birocrațiile": "birocrație",
    "birocrațiilor": "birocrație",
    "birocratisme": "birocratism",
    "birocratismele": "birocratism",
    "birocratismelor": "birocratism",
    "birocratismul": "birocratism",
    "birocratismului": "birocratism",
    "bir.": "birou",
    "biroul": "birou",
    "biroului": "birou",
    "birouri": "birou",
    "birourile": "birou",
    "birourilor": "birou",
    "birtul": "birt",
    "birtului": "birt",
    "birturi": "birt",
    "birturile": "birt",
    "birturilor": "birt",
    "biruia": "birui",
    "biruiai": "birui",
    "biruiam": "birui",
    "biruiască": "birui",
    "biruiați": "birui",
    "biruiau": "birui",
    "biruie": "birui",
    "biruiesc": "birui",
    "biruiește": "birui",
    "biruiești": "birui",
    "biruii": "birui",
    "biruim": "birui",
    "biruind": "birui",
    "biruindu": "birui",
    "biruiră": "birui",
    "biruirăm": "birui",
    "biruirăți": "birui",
    "biruise": "birui",
    "biruisem": "birui",
    "biruiseră": "birui",
    "biruiserăm": "birui",
    "biruiserăți": "birui",
    "biruiseși": "birui",
    "biruiși": "birui",
    "biruit": "birui",
    "biruiți": "birui",
    "biruitu": "birui",
    "nebiruind": "birui",
    "nebiruindu": "birui",
    "nemaibiruind": "birui",
    "nemaibiruindu": "birui",
    "biruința": "biruință",
    "biruințe": "biruință",
    "biruinței": "biruință",
    "biruințele": "biruință",
    "biruirea": "biruire",
    "biruiri": "biruire",
    "biruirii": "biruire",
    "biruirile": "biruire",
    "biruirilor": "biruire",
    "biruita": "biruit",
    "biruită": "biruit",
    "biruite": "biruit",
    "biruitei": "biruit",
    "biruitele": "biruit",
    "biruitelor": "biruit",
    "biruiți": "biruit",
    "biruiții": "biruit",
    "biruiților": "biruit",
    "biruitul": "biruit",
    "biruitului": "biruit",
    "biruita": "biruită",
    "biruite": "biruită",
    "biruitei": "biruită",
    "biruitele": "biruită",
    "biruitelor": "biruită",
    "biruitoarea": "biruitoare",
    "biruitoarei": "biruitoare",
    "biruitoarele": "biruitoare",
    "biruitoarelor": "biruitoare",
    "biruitoare": "biruitor",
    "biruitoarea": "biruitor",
    "biruitoarei": "biruitor",
    "biruitoarele": "biruitor",
    "biruitoarelor": "biruitor",
    "biruitori": "biruitor",
    "biruitorii": "biruitor",
    "biruitorilor": "biruitor",
    "biruitorul": "biruitor",
    "biruitorului": "biruitor",
    "bisă": "bisa",
    "bisai": "bisa",
    "bisam": "bisa",
    "bisăm": "bisa",
    "bisând": "bisa",
    "bisându": "bisa",
    "bisară": "bisa",
    "bisarăm": "bisa",
    "bisarăți": "bisa",
    "bisase": "bisa",
    "bisasem": "bisa",
    "bisaseră": "bisa",
    "bisaserăm": "bisa",
    "bisaserăți": "bisa",
    "bisaseși": "bisa",
    "bisași": "bisa",
    "bisat": "bisa",
    "bisați": "bisa",
    "bisatu": "bisa",
    "bisau": "bisa",
    "bisează": "bisa",
    "bisez": "bisa",
    "biseze": "bisa",
    "bisezi": "bisa",
    "nebisând": "bisa",
    "nebisându": "bisa",
    "nemaibisând": "bisa",
    "nemaibisându": "bisa",
    "bisarea": "bisare",
    "bisări": "bisare",
    "bisării": "bisare",
    "bisările": "bisare",
    "bisata": "bisat",
    "bisată": "bisat",
    "bisate": "bisat",
    "bisatei": "bisat",
    "bisatele": "bisat",
    "bisatelor": "bisat",
    "bisați": "bisat",
    "bisații": "bisat",
    "bisaților": "bisat",
    "bisatul": "bisat",
    "bisatului": "bisat",
    "bisecți": "bisect",
    "bisecții": "bisect",
    "bisecților": "bisect",
    "bisectul": "bisect",
    "bisectului": "bisect",
    "biserica": "biserică",
    "biserici": "biserică",
    "bisericii": "biserică",
    "bisericile": "biserică",
    "bisericilor": "biserică",
    "biserico": "biserică",
    "bis.": "bisericesc",
    "bisericeasca": "bisericesc",
    "bisericească": "bisericesc",
    "bisericescul": "bisericesc",
    "bisericescului": "bisericesc",
    "bisericești": "bisericesc",
    "bisericeștii": "bisericesc",
    "bisericeștile": "bisericesc",
    "bisericeștilor": "bisericesc",
    "bisericuța": "bisericuță",
    "bisericuțe": "bisericuță",
    "bisericuței": "bisericuță",
    "bisericuțele": "bisericuță",
    "bisericuțelor": "bisericuță",
    "bisextila": "bisextil",
    "bisextilă": "bisextil",
    "bisextile": "bisextil",
    "bisextilei": "bisextil",
    "bisextilele": "bisextil",
    "bisextilelor": "bisextil",
    "bisextili": "bisextil",
    "bisextilii": "bisextil",
    "bisextililor": "bisextil",
    "bisextilul": "bisextil",
    "bisextilului": "bisextil",
    "bisexuata": "bisexuat",
    "bisexuată": "bisexuat",
    "bisexuate": "bisexuat",
    "bisexuatei": "bisexuat",
    "bisexuatele": "bisexuat",
    "bisexuatelor": "bisexuat",
    "bisexuați": "bisexuat",
    "bisexuații": "bisexuat",
    "bisexuaților": "bisexuat",
    "bisexuatul": "bisexuat",
    "bisexuatului": "bisexuat",
    "Bi": "bismut",
    "bismutul": "bismut",
    "bismutului": "bismut",
    "bișnița": "bișniță",
    "bișnițe": "bișniță",
    "bișniței": "bișniță",
    "bișnițele": "bișniță",
    "bișnițelor": "bișniță",
    "Bistriță": "Bistrița",
    "Bistrițe": "Bistrița",
    "Bistriței": "Bistrița",
    "bistrițeana": "bistrițean",
    "bistrițeană": "bistrițean",
    "bistrițeanul": "bistrițean",
    "bistrițeanului": "bistrițean",
    "bistrițene": "bistrițean",
    "bistrițenei": "bistrițean",
    "bistrițenele": "bistrițean",
    "bistrițenelor": "bistrițean",
    "bistrițeni": "bistrițean",
    "bistrițenii": "bistrițean",
    "bistrițenilor": "bistrițean",
    "bistrițeanca": "bistrițeancă",
    "bistrițence": "bistrițeancă",
    "bistrițencei": "bistrițeancă",
    "bistrițencele": "bistrițeancă",
    "bistrițencelor": "bistrițeancă",
    "bisturie": "bisturiu",
    "bisturiele": "bisturiu",
    "bisturielor": "bisturiu",
    "bisturiul": "bisturiu",
    "bisturiului": "bisturiu",
    "bitumul": "bitum",
    "bitumului": "bitum",
    "bivoli": "bivol",
    "bivolii": "bivol",
    "bivolilor": "bivol",
    "bivolul": "bivol",
    "bivolului": "bivol",
    "bivuacul": "bivuac",
    "bivuacului": "bivuac",
    "bivuacuri": "bivuac",
    "bivuacurile": "bivuac",
    "bivuacurilor": "bivuac",
    "Bizanțul": "Bizanț",
    "Bizanțului": "Bizanț",
    "bizantina": "bizantin",
    "bizantină": "bizantin",
    "bizantine": "bizantin",
    "bizantinei": "bizantin",
    "bizantinele": "bizantin",
    "bizantinelor": "bizantin",
    "bizantini": "bizantin",
    "bizantinii": "bizantin",
    "bizantinilor": "bizantin",
    "bizantinul": "bizantin",
    "bizantinului": "bizantin",
    "bizantina": "bizantină",
    "bizantine": "bizantină",
    "bizantinei": "bizantină",
    "bizantinele": "bizantină",
    "bizantinelor": "bizantină",
    "bizantinologi": "bizantinolog",
    "bizantinologii": "bizantinolog",
    "bizantinologilor": "bizantinolog",
    "bizantinologul": "bizantinolog",
    "bizantinologului": "bizantinolog",
    "bizara": "bizar",
    "bizară": "bizar",
    "bizare": "bizar",
    "bizarei": "bizar",
    "bizarele": "bizar",
    "bizarelor": "bizar",
    "bizari": "bizar",
    "bizarii": "bizar",
    "bizarilor": "bizar",
    "bizarul": "bizar",
    "bizarului": "bizar",
    "bizoni": "bizon",
    "bizonii": "bizon",
    "bizonilor": "bizon",
    "bizonul": "bizon",
    "bizonule": "bizon",
    "bizonului": "bizon",
    "bizuia": "bizui",
    "bizuiai": "bizui",
    "bizuiam": "bizui",
    "bizuiască": "bizui",
    "bizuiați": "bizui",
    "bizuiau": "bizui",
    "bizuie": "bizui",
    "bizuiesc": "bizui",
    "bizuiește": "bizui",
    "bizuiești": "bizui",
    "bizuii": "bizui",
    "bizuim": "bizui",
    "bizuind": "bizui",
    "bizuindu": "bizui",
    "bizuiră": "bizui",
    "bizuirăm": "bizui",
    "bizuirăți": "bizui",
    "bizuise": "bizui",
    "bizuisem": "bizui",
    "bizuiseră": "bizui",
    "bizuiserăm": "bizui",
    "bizuiserăți": "bizui",
    "bizuiseși": "bizui",
    "bizuiși": "bizui",
    "bizuit": "bizui",
    "bizuiți": "bizui",
    "bizuitu": "bizui",
    "nebizuind": "bizui",
    "nebizuindu": "bizui",
    "nemaibizuind": "bizui",
    "nemaibizuindu": "bizui",
    "bizuiala": "bizuială",
    "bizuialo": "bizuială",
    "bizuieli": "bizuială",
    "bizuielii": "bizuială",
    "bizuielile": "bizuială",
    "bizuielilor": "bizuială",
    "bizuirea": "bizuire",
    "bizuireo": "bizuire",
    "bizuiri": "bizuire",
    "bizuirii": "bizuire",
    "bizuirile": "bizuire",
    "bizuirilor": "bizuire",
    "bizuita": "bizuit",
    "bizuită": "bizuit",
    "bizuite": "bizuit",
    "bizuitei": "bizuit",
    "bizuitele": "bizuit",
    "bizuitelor": "bizuit",
    "bizuiți": "bizuit",
    "bizuiții": "bizuit",
    "bizuiților": "bizuit",
    "bizuito": "bizuit",
    "bizuitul": "bizuit",
    "bizuitule": "bizuit",
    "bizuitului": "bizuit",
    "bizuitoare": "bizuitor",
    "bizuitoarea": "bizuitor",
    "bizuitoarei": "bizuitor",
    "bizuitoarele": "bizuitor",
    "bizuitoarelor": "bizuitor",
    "bizuitoareo": "bizuitor",
    "bizuitori": "bizuitor",
    "bizuitorii": "bizuitor",
    "bizuitorilor": "bizuitor",
    "bizuitorul": "bizuitor",
    "bizuitorule": "bizuitor",
    "bizuitorului": "bizuitor",
    "blachei": "blacheu",
    "blacheii": "blacheu",
    "blacheilor": "blacheu",
    "blacheul": "blacheu",
    "blacheului": "blacheu",
    "blagoslovita": "blagoslovit",
    "blagoslovită": "blagoslovit",
    "blagoslovite": "blagoslovit",
    "blagoslovitei": "blagoslovit",
    "blagoslovitele": "blagoslovit",
    "blagoslovitelor": "blagoslovit",
    "blagosloviți": "blagoslovit",
    "blagosloviții": "blagoslovit",
    "blagosloviților": "blagoslovit",
    "blagoslovitul": "blagoslovit",
    "blagoslovitului": "blagoslovit",
    "Blajul": "Blaj",
    "Blajului": "Blaj",
    "blajina": "blajin",
    "blajină": "blajin",
    "blajine": "blajin",
    "blajinei": "blajin",
    "blajinele": "blajin",
    "blajinelor": "blajin",
    "blajini": "blajin",
    "blajinii": "blajin",
    "blajinilor": "blajin",
    "blajinul": "blajin",
    "blajinului": "blajin",
    "blamul": "blam",
    "blamului": "blam",
    "blamuri": "blam",
    "blamurile": "blam",
    "blamurilor": "blam",
    "blamă": "blama",
    "blamai": "blama",
    "blamam": "blama",
    "blamăm": "blama",
    "blamând": "blama",
    "blamându": "blama",
    "blamară": "blama",
    "blamarăm": "blama",
    "blamarăți": "blama",
    "blamase": "blama",
    "blamasem": "blama",
    "blamaseră": "blama",
    "blamaserăm": "blama",
    "blamaserăți": "blama",
    "blamaseși": "blama",
    "blamași": "blama",
    "blamat": "blama",
    "blamați": "blama",
    "blamatu": "blama",
    "blamau": "blama",
    "blamează": "blama",
    "blamez": "blama",
    "blameze": "blama",
    "blamezi": "blama",
    "neblamând": "blama",
    "neblamându": "blama",
    "nemaiblamând": "blama",
    "nemaiblamându": "blama",
    "blamabila": "blamabil",
    "blamabilă": "blamabil",
    "blamabile": "blamabil",
    "blamabilei": "blamabil",
    "blamabilele": "blamabil",
    "blamabilelor": "blamabil",
    "blamabili": "blamabil",
    "blamabilii": "blamabil",
    "blamabililor": "blamabil",
    "blamabilul": "blamabil",
    "blamabilului": "blamabil",
    "blamarea": "blamare",
    "blamări": "blamare",
    "blamării": "blamare",
    "blamările": "blamare",
    "blamata": "blamat",
    "blamată": "blamat",
    "blamate": "blamat",
    "blamatei": "blamat",
    "blamatele": "blamat",
    "blamatelor": "blamat",
    "blamați": "blamat",
    "blamații": "blamat",
    "blamaților": "blamat",
    "blamatul": "blamat",
    "blamatului": "blamat",
    "blamata": "blamată",
    "blamate": "blamată",
    "blamatei": "blamată",
    "blamatele": "blamată",
    "blamatelor": "blamată",
    "blana": "blană",
    "blăni": "blană",
    "blănii": "blană",
    "blănile": "blană",
    "blănilor": "blană",
    "blănuri": "blană",
    "blănurile": "blană",
    "blănurilor": "blană",
    "blancheta": "blanchetă",
    "blanchete": "blanchetă",
    "blanchetei": "blanchetă",
    "blanchetele": "blanchetă",
    "blanchetelor": "blanchetă",
    "blânda": "blând",
    "blândă": "blând",
    "blânde": "blând",
    "blândei": "blând",
    "blândele": "blând",
    "blândelor": "blând",
    "blândo": "blând",
    "blândul": "blând",
    "blândule": "blând",
    "blândului": "blând",
    "blânzi": "blând",
    "blânzii": "blând",
    "blânzilor": "blând",
    "blândețea": "blândețe",
    "blândețeo": "blândețe",
    "blândeți": "blândețe",
    "blândeții": "blândețe",
    "blândețile": "blândețe",
    "blândeților": "blândețe",
    "blasfemia": "blasfemie",
    "blasfemiei": "blasfemie",
    "blasfemii": "blasfemie",
    "blasfemiile": "blasfemie",
    "blasfemiilor": "blasfemie",
    "blasfemio": "blasfemie",
    "blatista": "blatist",
    "blatistă": "blatist",
    "blatiste": "blatist",
    "blatistei": "blatist",
    "blatistele": "blatist",
    "blatistelor": "blatist",
    "blatiști": "blatist",
    "blatiștii": "blatist",
    "blatiștilor": "blatist",
    "blatistul": "blatist",
    "blatistului": "blatist",
    "blatista": "blatistă",
    "blatiste": "blatistă",
    "blatistei": "blatistă",
    "blatistele": "blatistă",
    "blatistelor": "blatistă",
    "blază": "blaza",
    "blazai": "blaza",
    "blazam": "blaza",
    "blazăm": "blaza",
    "blazând": "blaza",
    "blazându": "blaza",
    "blazară": "blaza",
    "blazarăm": "blaza",
    "blazarăți": "blaza",
    "blazase": "blaza",
    "blazasem": "blaza",
    "blazaseră": "blaza",
    "blazaserăm": "blaza",
    "blazaserăți": "blaza",
    "blazaseși": "blaza",
    "blazași": "blaza",
    "blazat": "blaza",
    "blazați": "blaza",
    "blazatu": "blaza",
    "blazau": "blaza",
    "blazează": "blaza",
    "blazez": "blaza",
    "blazeze": "blaza",
    "blazezi": "blaza",
    "neblazând": "blaza",
    "neblazându": "blaza",
    "nemaiblazând": "blaza",
    "nemaiblazându": "blaza",
    "blazarea": "blazare",
    "blazări": "blazare",
    "blazării": "blazare",
    "blazările": "blazare",
    "blazata": "blazat",
    "blazată": "blazat",
    "blazate": "blazat",
    "blazatei": "blazat",
    "blazatele": "blazat",
    "blazatelor": "blazat",
    "blazați": "blazat",
    "blazații": "blazat",
    "blazaților": "blazat",
    "blazatul": "blazat",
    "blazatului": "blazat",
    "blazata": "blazată",
    "blazate": "blazată",
    "blazatei": "blazată",
    "blazatele": "blazată",
    "blazatelor": "blazată",
    "blazoane": "blazon",
    "blazoanele": "blazon",
    "blazoanelor": "blazon",
    "blazonul": "blazon",
    "blazonului": "blazon",
    "blefarita": "blefarită",
    "blefarite": "blefarită",
    "blefaritei": "blefarită",
    "blefaritele": "blefarită",
    "blefaritelor": "blefarită",
    "blenoragia": "blenoragie",
    "blenoragiei": "blenoragie",
    "blenoragii": "blenoragie",
    "blenoragiile": "blenoragie",
    "blenoragiilor": "blenoragie",
    "bleotocăreala": "bleotocăreală",
    "bleotocărealo": "bleotocăreală",
    "bleotocăreli": "bleotocăreală",
    "bleotocărelii": "bleotocăreală",
    "bleotocărelile": "bleotocăreală",
    "bleotocărelilor": "bleotocăreală",
    "bleotocărea": "bleotocări",
    "bleotocăreai": "bleotocări",
    "bleotocăream": "bleotocări",
    "bleotocărească": "bleotocări",
    "bleotocăreați": "bleotocări",
    "bleotocăreau": "bleotocări",
    "bleotocăresc": "bleotocări",
    "bleotocărește": "bleotocări",
    "bleotocărești": "bleotocări",
    "bleotocării": "bleotocări",
    "bleotocărim": "bleotocări",
    "bleotocărind": "bleotocări",
    "bleotocărindu": "bleotocări",
    "bleotocăriră": "bleotocări",
    "bleotocărirăm": "bleotocări",
    "bleotocărirăți": "bleotocări",
    "bleotocărise": "bleotocări",
    "bleotocărisem": "bleotocări",
    "bleotocăriseră": "bleotocări",
    "bleotocăriserăm": "bleotocări",
    "bleotocăriserăți": "bleotocări",
    "bleotocăriseși": "bleotocări",
    "bleotocăriși": "bleotocări",
    "bleotocărit": "bleotocări",
    "bleotocăriți": "bleotocări",
    "bleotocăritu": "bleotocări",
    "nebleotocărind": "bleotocări",
    "nebleotocărindu": "bleotocări",
    "nemaibleotocărind": "bleotocări",
    "nemaibleotocărindu": "bleotocări",
    "bleotocărirea": "bleotocărire",
    "bleotocărireo": "bleotocărire",
    "bleotocăriri": "bleotocărire",
    "bleotocăririi": "bleotocărire",
    "bleotocăririle": "bleotocărire",
    "bleotocăririlor": "bleotocărire",
    "bleotocărita": "bleotocărit",
    "bleotocărită": "bleotocărit",
    "bleotocărite": "bleotocărit",
    "bleotocăritei": "bleotocărit",
    "bleotocăritele": "bleotocărit",
    "bleotocăritelor": "bleotocărit",
    "bleotocăriți": "bleotocărit",
    "bleotocăriții": "bleotocărit",
    "bleotocăriților": "bleotocărit",
    "bleotocărito": "bleotocărit",
    "bleotocăritul": "bleotocărit",
    "bleotocăritule": "bleotocărit",
    "bleotocăritului": "bleotocărit",
    "blesteme": "blestem",
    "blestemele": "blestem",
    "blestemelor": "blestem",
    "blestemul": "blestem",
    "blestemului": "blestem",
    "blestemata": "blestemat",
    "blestemată": "blestemat",
    "blestemate": "blestemat",
    "blestematei": "blestemat",
    "blestematele": "blestemat",
    "blestematelor": "blestemat",
    "blestemați": "blestemat",
    "blestemații": "blestemat",
    "blestemaților": "blestemat",
    "blestematul": "blestemat",
    "blestematului": "blestemat",
    "blide": "blid",
    "blidele": "blid",
    "blidelor": "blid",
    "blidul": "blid",
    "blidule": "blid",
    "blidului": "blid",
    "blindaje": "blindaj",
    "blindajele": "blindaj",
    "blindajelor": "blindaj",
    "blindajul": "blindaj",
    "blindajului": "blindaj",
    "blindata": "blindat",
    "blindată": "blindat",
    "blindate": "blindat",
    "blindatei": "blindat",
    "blindatele": "blindat",
    "blindatelor": "blindat",
    "blindați": "blindat",
    "blindații": "blindat",
    "blindaților": "blindat",
    "blindatul": "blindat",
    "blindatului": "blindat",
    "blocul": "bloc",
    "blocului": "bloc",
    "blocuri": "bloc",
    "blocurile": "bloc",
    "blocurilor": "bloc",
    "blocă": "bloca",
    "blocai": "bloca",
    "blocam": "bloca",
    "blocăm": "bloca",
    "blocând": "bloca",
    "blocându": "bloca",
    "blocară": "bloca",
    "blocarăm": "bloca",
    "blocarăți": "bloca",
    "blocase": "bloca",
    "blocasem": "bloca",
    "blocaseră": "bloca",
    "blocaserăm": "bloca",
    "blocaserăți": "bloca",
    "blocaseși": "bloca",
    "blocași": "bloca",
    "blocat": "bloca",
    "blocați": "bloca",
    "blocatu": "bloca",
    "blocau": "bloca",
    "blochează": "bloca",
    "blochez": "bloca",
    "blocheze": "bloca",
    "blochezi": "bloca",
    "neblocând": "bloca",
    "neblocându": "bloca",
    "nemaiblocând": "bloca",
    "nemaiblocându": "bloca",
    "blocada": "blocadă",
    "blocade": "blocadă",
    "blocadei": "blocadă",
    "blocadele": "blocadă",
    "blocadelor": "blocadă",
    "blocaje": "blocaj",
    "blocajele": "blocaj",
    "blocajelor": "blocaj",
    "blocajul": "blocaj",
    "blocajului": "blocaj",
    "blocarea": "blocare",
    "blocări": "blocare",
    "blocării": "blocare",
    "blocările": "blocare",
    "blocata": "blocat",
    "blocată": "blocat",
    "blocate": "blocat",
    "blocatei": "blocat",
    "blocatele": "blocat",
    "blocatelor": "blocat",
    "blocați": "blocat",
    "blocații": "blocat",
    "blocaților": "blocat",
    "blocatul": "blocat",
    "blocatului": "blocat",
    "blocnotesul": "blocnotes",
    "blocnotesului": "blocnotes",
    "blocnotesuri": "blocnotes",
    "blocnotesurile": "blocnotes",
    "blocnotesurilor": "blocnotes",
    "bl.": "blocul",
    "BNS": "Blocul_Național_Sindical",
    "blonda": "blond",
    "blondă": "blond",
    "blonde": "blond",
    "blondei": "blond",
    "blondele": "blond",
    "blondelor": "blond",
    "blondo": "blond",
    "blondul": "blond",
    "blondule": "blond",
    "blondului": "blond",
    "blonzi": "blond",
    "blonzii": "blond",
    "blonzilor": "blond",
    "bluful": "bluf",
    "blufului": "bluf",
    "blufuri": "bluf",
    "blufurile": "bluf",
    "blufurilor": "bluf",
    "blugii": "blugi",
    "blugilor": "blugi",
    "blumul": "blum",
    "blumului": "blum",
    "blumuri": "blum",
    "blumurile": "blum",
    "blumurilor": "blum",
    "blumingul": "bluming",
    "blumingului": "bluming",
    "bluminguri": "bluming",
    "blumingurile": "bluming",
    "blumingurilor": "bluming",
    "bluza": "bluză",
    "bluze": "bluză",
    "bluzei": "bluză",
    "bluzele": "bluză",
    "bluzelor": "bluză",
    "boaba": "boabă",
    "boabe": "boabă",
    "boabei": "boabă",
    "boabele": "boabă",
    "boabelor": "boabă",
    "boacăna": "boacănă",
    "boacăne": "boacănă",
    "boacănei": "boacănă",
    "boacănele": "boacănă",
    "boacănelor": "boacănă",
    "boaita": "boaită",
    "boaite": "boaită",
    "boaitei": "boaită",
    "boaitele": "boaită",
    "boaitelor": "boaită",
    "boala": "boală",
    "boalo": "boală",
    "boli": "boală",
    "bolii": "boală",
    "bolile": "boală",
    "bolilor": "boală",
    "boarea": "boare",
    "bori": "boare",
    "borii": "boare",
    "borile": "boare",
    "borilor": "boare",
    "boabe": "bob",
    "boabele": "bob",
    "boabelor": "bob",
    "bobul": "bob",
    "bobule": "bob",
    "bobului": "bob",
    "boburi": "bob",
    "boburile": "bob",
    "boburilor": "bob",
    "bobârnace": "bobârnac",
    "bobârnacele": "bobârnac",
    "bobârnacelor": "bobârnac",
    "bobârnacul": "bobârnac",
    "bobârnacului": "bobârnac",
    "bobină": "bobina",
    "bobinai": "bobina",
    "bobinam": "bobina",
    "bobinăm": "bobina",
    "bobinând": "bobina",
    "bobinându": "bobina",
    "bobinară": "bobina",
    "bobinarăm": "bobina",
    "bobinarăți": "bobina",
    "bobinase": "bobina",
    "bobinasem": "bobina",
    "bobinaseră": "bobina",
    "bobinaserăm": "bobina",
    "bobinaserăți": "bobina",
    "bobinaseși": "bobina",
    "bobinași": "bobina",
    "bobinat": "bobina",
    "bobinați": "bobina",
    "bobinatu": "bobina",
    "bobinau": "bobina",
    "bobinează": "bobina",
    "bobinez": "bobina",
    "bobineze": "bobina",
    "bobinezi": "bobina",
    "nebobinând": "bobina",
    "nebobinându": "bobina",
    "nemaibobinând": "bobina",
    "nemaibobinându": "bobina",
    "bobina": "bobină",
    "bobine": "bobină",
    "bobinei": "bobină",
    "bobinele": "bobină",
    "bobinelor": "bobină",
    "bobinarea": "bobinare",
    "bobinări": "bobinare",
    "bobinării": "bobinare",
    "bobinările": "bobinare",
    "bobinata": "bobinat",
    "bobinată": "bobinat",
    "bobinate": "bobinat",
    "bobinatei": "bobinat",
    "bobinatele": "bobinat",
    "bobinatelor": "bobinat",
    "bobinați": "bobinat",
    "bobinații": "bobinat",
    "bobinaților": "bobinat",
    "bobinatul": "bobinat",
    "bobinatului": "bobinat",
    "boboaca": "boboacă",
    "boboace": "boboacă",
    "boboacei": "boboacă",
    "boboacele": "boboacă",
    "boboacelor": "boboacă",
    "boboaco": "boboacă",
    "boboci": "boboc",
    "bobocii": "boboc",
    "bobocilor": "boboc",
    "bobocul": "boboc",
    "bobocule": "boboc",
    "bobocului": "boboc",
    "bobocei": "bobocel",
    "boboceii": "bobocel",
    "boboceilor": "bobocel",
    "bobocelul": "bobocel",
    "bobocelule": "bobocel",
    "bobocelului": "bobocel",
    "bocanci": "bocanc",
    "bocancii": "bocanc",
    "bocancilor": "bocanc",
    "bocancul": "bocanc",
    "bocancului": "bocanc",
    "bocete": "bocet",
    "bocetele": "bocet",
    "bocetelor": "bocet",
    "bocetul": "bocet",
    "bocetului": "bocet",
    "bocea": "boci",
    "boceai": "boci",
    "boceam": "boci",
    "bocească": "boci",
    "boceați": "boci",
    "boceau": "boci",
    "bocesc": "boci",
    "bocește": "boci",
    "bocești": "boci",
    "bocii": "boci",
    "bocim": "boci",
    "bocind": "boci",
    "bocindu": "boci",
    "bociră": "boci",
    "bocirăm": "boci",
    "bocirăți": "boci",
    "bocise": "boci",
    "bocisem": "boci",
    "bociseră": "boci",
    "bociserăm": "boci",
    "bociserăți": "boci",
    "bociseși": "boci",
    "bociși": "boci",
    "bocit": "boci",
    "bociți": "boci",
    "bocitu": "boci",
    "bocirea": "bocire",
    "bociri": "bocire",
    "bocirii": "bocire",
    "bocirile": "bocire",
    "bocirilor": "bocire",
    "bocită": "bocit",
    "bocite": "bocit",
    "bociți": "bocit",
    "bocna": "bocnă",
    "bocne": "bocnă",
    "bocnei": "bocnă",
    "bocnele": "bocnă",
    "bocnelor": "bocnă",
    "bodega": "bodegă",
    "bodegi": "bodegă",
    "bodegii": "bodegă",
    "bodegile": "bodegă",
    "bodegilor": "bodegă",
    "bodogăneala": "bodogăneală",
    "bodogănealo": "bodogăneală",
    "bodogăneli": "bodogăneală",
    "bodogănelii": "bodogăneală",
    "bodogănelile": "bodogăneală",
    "bodogănelilor": "bodogăneală",
    "bodogănea": "bodogăni",
    "bodogăneai": "bodogăni",
    "bodogăneam": "bodogăni",
    "bodogănească": "bodogăni",
    "bodogăneați": "bodogăni",
    "bodogăneau": "bodogăni",
    "bodogănesc": "bodogăni",
    "bodogănește": "bodogăni",
    "bodogănești": "bodogăni",
    "bodogănii": "bodogăni",
    "bodogănim": "bodogăni",
    "bodogănind": "bodogăni",
    "bodogănindu": "bodogăni",
    "bodogăniră": "bodogăni",
    "bodogănirăm": "bodogăni",
    "bodogănirăți": "bodogăni",
    "bodogănise": "bodogăni",
    "bodogănisem": "bodogăni",
    "bodogăniseră": "bodogăni",
    "bodogăniserăm": "bodogăni",
    "bodogăniserăți": "bodogăni",
    "bodogăniseși": "bodogăni",
    "bodogăniși": "bodogăni",
    "bodogănit": "bodogăni",
    "bodogăniți": "bodogăni",
    "bodogănitu": "bodogăni",
    "nebodogănind": "bodogăni",
    "nebodogănindu": "bodogăni",
    "nemaibodogănind": "bodogăni",
    "nemaibodogănindu": "bodogăni",
    "bodogănirea": "bodogănire",
    "bodogănireo": "bodogănire",
    "bodogăniri": "bodogănire",
    "bodogănirii": "bodogănire",
    "bodogănirile": "bodogănire",
    "bodogănirilor": "bodogănire",
    "bodogănita": "bodogănit",
    "bodogănită": "bodogănit",
    "bodogănite": "bodogănit",
    "bodogănitei": "bodogănit",
    "bodogănitele": "bodogănit",
    "bodogănitelor": "bodogănit",
    "bodogăniți": "bodogănit",
    "bodogăniții": "bodogănit",
    "bodogăniților": "bodogănit",
    "bodogănito": "bodogănit",
    "bodogănitul": "bodogănit",
    "bodogănitule": "bodogănit",
    "bodogănitului": "bodogănit",
    "boemi": "boem",
    "boemii": "boem",
    "boemilor": "boem",
    "boemul": "boem",
    "boemului": "boem",
    "boema": "boemă",
    "boeme": "boemă",
    "boemei": "boemă",
    "boemele": "boemă",
    "boemelor": "boemă",
    "bogata": "bogat",
    "bogată": "bogat",
    "bogate": "bogat",
    "bogatei": "bogat",
    "bogatele": "bogat",
    "bogatelor": "bogat",
    "bogați": "bogat",
    "bogații": "bogat",
    "bogaților": "bogat",
    "bogato": "bogat",
    "bogatul": "bogat",
    "bogatule": "bogat",
    "bogatului": "bogat",
    "bogătani": "bogătan",
    "bogătanii": "bogătan",
    "bogătanilor": "bogătan",
    "bogătanul": "bogătan",
    "bogătanului": "bogătan",
    "bogăția": "bogăție",
    "bogăției": "bogăție",
    "bogății": "bogăție",
    "bogățiile": "bogăție",
    "bogățiilor": "bogăție",
    "bogheta": "boghet",
    "boghetă": "boghet",
    "boghete": "boghet",
    "boghetei": "boghet",
    "boghetele": "boghet",
    "boghetelor": "boghet",
    "bogheți": "boghet",
    "bogheții": "boghet",
    "bogheților": "boghet",
    "boghetul": "boghet",
    "boghetului": "boghet",
    "boiangeria": "boiangerie",
    "boiangeriei": "boiangerie",
    "boiangerii": "boiangerie",
    "boiangeriile": "boiangerie",
    "boiangeriilor": "boiangerie",
    "boiangii": "boiangiu",
    "boiangiii": "boiangiu",
    "boiangiilor": "boiangiu",
    "boiangiul": "boiangiu",
    "boiangiului": "boiangiu",
    "boicotul": "boicot",
    "boicotului": "boicot",
    "boicoturi": "boicot",
    "boicoturile": "boicot",
    "boicoturilor": "boicot",
    "boicotă": "boicota",
    "boicotai": "boicota",
    "boicotam": "boicota",
    "boicotăm": "boicota",
    "boicotând": "boicota",
    "boicotându": "boicota",
    "boicotară": "boicota",
    "boicotarăm": "boicota",
    "boicotarăți": "boicota",
    "boicotase": "boicota",
    "boicotasem": "boicota",
    "boicotaseră": "boicota",
    "boicotaserăm": "boicota",
    "boicotaserăți": "boicota",
    "boicotaseși": "boicota",
    "boicotași": "boicota",
    "boicotat": "boicota",
    "boicotați": "boicota",
    "boicotatu": "boicota",
    "boicotau": "boicota",
    "boicotează": "boicota",
    "boicotez": "boicota",
    "boicoteze": "boicota",
    "boicotezi": "boicota",
    "neboicotând": "boicota",
    "neboicotându": "boicota",
    "nemaiboicotând": "boicota",
    "nemaiboicotându": "boicota",
    "boicotarea": "boicotare",
    "boicotări": "boicotare",
    "boicotării": "boicotare",
    "boicotările": "boicotare",
    "boicotata": "boicotat",
    "boicotată": "boicotat",
    "boicotate": "boicotat",
    "boicotatei": "boicotat",
    "boicotatele": "boicotat",
    "boicotatelor": "boicotat",
    "boicotați": "boicotat",
    "boicotații": "boicotat",
    "boicotaților": "boicotat",
    "boicotatul": "boicotat",
    "boicotatului": "boicotat",
    "boieri": "boier",
    "boierii": "boier",
    "boierilor": "boier",
    "boierul": "boier",
    "boierului": "boier",
    "boiereasca": "boieresc",
    "boierească": "boieresc",
    "boierescul": "boieresc",
    "boierescului": "boieresc",
    "boierești": "boieresc",
    "boiereștii": "boieresc",
    "boiereștile": "boieresc",
    "boiereștilor": "boieresc",
    "boierimea": "boierime",
    "boierimi": "boierime",
    "boierimii": "boierime",
    "boierimile": "boierime",
    "boierimilor": "boierime",
    "boieroaica": "boieroaică",
    "boieroaice": "boieroaică",
    "boieroaicei": "boieroaică",
    "boieroaicele": "boieroaică",
    "boieroaicelor": "boieroaică",
    "boilere": "boiler",
    "boilerele": "boiler",
    "boilerelor": "boiler",
    "boilerul": "boiler",
    "boilerului": "boiler",
    "boiștea": "boiște",
    "boiști": "boiște",
    "boiștii": "boiște",
    "boiștile": "boiște",
    "boiștilor": "boiște",
    "boita": "boit",
    "boită": "boit",
    "boite": "boit",
    "boitei": "boit",
    "boitele": "boit",
    "boitelor": "boit",
    "boiți": "boit",
    "boiții": "boit",
    "boiților": "boit",
    "boitul": "boit",
    "boitului": "boit",
    "boita": "boită",
    "boite": "boită",
    "boitei": "boită",
    "boitele": "boită",
    "boitelor": "boită",
    "bojdeuca": "bojdeucă",
    "bojdeuci": "bojdeucă",
    "bojdeucii": "bojdeucă",
    "bojdeucile": "bojdeucă",
    "bojdeucilor": "bojdeucă",
    "bolul": "bol",
    "bolului": "bol",
    "boluri": "bol",
    "bolurile": "bol",
    "bolurilor": "bol",
    "bolboroseala": "bolboroseală",
    "bolborosealo": "bolboroseală",
    "bolboroseli": "bolboroseală",
    "bolboroselii": "bolboroseală",
    "bolboroselile": "bolboroseală",
    "bolboroselilor": "bolboroseală",
    "bolborosea": "bolborosi",
    "bolboroseai": "bolborosi",
    "bolboroseam": "bolborosi",
    "bolborosească": "bolborosi",
    "bolboroseați": "bolborosi",
    "bolboroseau": "bolborosi",
    "bolborosesc": "bolborosi",
    "bolborosește": "bolborosi",
    "bolborosești": "bolborosi",
    "bolborosii": "bolborosi",
    "bolborosim": "bolborosi",
    "bolborosind": "bolborosi",
    "bolborosindu": "bolborosi",
    "bolborosiră": "bolborosi",
    "bolborosirăm": "bolborosi",
    "bolborosirăți": "bolborosi",
    "bolborosise": "bolborosi",
    "bolborosisem": "bolborosi",
    "bolborosiseră": "bolborosi",
    "bolborosiserăm": "bolborosi",
    "bolborosiserăți": "bolborosi",
    "bolborosiseși": "bolborosi",
    "bolborosiși": "bolborosi",
    "bolborosit": "bolborosi",
    "bolborosiți": "bolborosi",
    "bolborositu": "bolborosi",
    "nebolborosind": "bolborosi",
    "nebolborosindu": "bolborosi",
    "nemaibolborosind": "bolborosi",
    "nemaibolborosindu": "bolborosi",
    "bolborosirea": "bolborosire",
    "bolborosireo": "bolborosire",
    "bolborosiri": "bolborosire",
    "bolborosirii": "bolborosire",
    "bolborosirile": "bolborosire",
    "bolborosirilor": "bolborosire",
    "bolborosita": "bolborosit",
    "bolborosită": "bolborosit",
    "bolborosite": "bolborosit",
    "bolborositei": "bolborosit",
    "bolborositele": "bolborosit",
    "bolborositelor": "bolborosit",
    "bolborosiți": "bolborosit",
    "bolborosiții": "bolborosit",
    "bolborosiților": "bolborosit",
    "bolborosito": "bolborosit",
    "bolborositul": "bolborosit",
    "bolborositule": "bolborosit",
    "bolborositului": "bolborosit",
    "boldul": "bold",
    "boldului": "bold",
    "bolduri": "bold",
    "boldurile": "bold",
    "boldurilor": "bold",
    "boleroul": "bolero",
    "boleroului": "bolero",
    "bolerouri": "bolero",
    "bolerourile": "bolero",
    "bolerourilor": "bolero",
    "bolea": "boli",
    "boleai": "boli",
    "boleam": "boli",
    "bolească": "boli",
    "boleați": "boli",
    "boleau": "boli",
    "bolesc": "boli",
    "bolește": "boli",
    "bolești": "boli",
    "bolii": "boli",
    "bolim": "boli",
    "bolind": "boli",
    "bolindu": "boli",
    "boliră": "boli",
    "bolirăm": "boli",
    "bolirăți": "boli",
    "bolise": "boli",
    "bolisem": "boli",
    "boliseră": "boli",
    "boliserăm": "boli",
    "boliserăți": "boli",
    "boliseși": "boli",
    "boliși": "boli",
    "bolit": "boli",
    "boliți": "boli",
    "bolitu": "boli",
    "bolidul": "bolid",
    "bolidului": "bolid",
    "bolizi": "bolid",
    "bolizii": "bolid",
    "bolizilor": "bolid",
    "bolirea": "bolire",
    "boliri": "bolire",
    "bolirii": "bolire",
    "bolirile": "bolire",
    "bolirilor": "bolire",
    "bolită": "bolit",
    "bolite": "bolit",
    "boliți": "bolit",
    "bolnava": "bolnav",
    "bolnavă": "bolnav",
    "bolnave": "bolnav",
    "bolnavei": "bolnav",
    "bolnavele": "bolnav",
    "bolnavelor": "bolnav",
    "bolnavi": "bolnav",
    "bolnavii": "bolnav",
    "bolnavilor": "bolnav",
    "bolnavo": "bolnav",
    "bolnavul": "bolnav",
    "bolnavule": "bolnav",
    "bolnavului": "bolnav",
    "bolnava": "bolnavă",
    "bolnave": "bolnavă",
    "bolnavei": "bolnavă",
    "bolnavele": "bolnavă",
    "bolnavelor": "bolnavă",
    "bolnavo": "bolnavă",
    "bolnăvicioasa": "bolnăvicios",
    "bolnăvicioasă": "bolnăvicios",
    "bolnăvicioase": "bolnăvicios",
    "bolnăvicioasei": "bolnăvicios",
    "bolnăvicioasele": "bolnăvicios",
    "bolnăvicioaselor": "bolnăvicios",
    "bolnăvicioaso": "bolnăvicios",
    "bolnăvicioși": "bolnăvicios",
    "bolnăvicioșii": "bolnăvicios",
    "bolnăvicioșilor": "bolnăvicios",
    "bolnăviciosul": "bolnăvicios",
    "bolnăviciosule": "bolnăvicios",
    "bolnăviciosului": "bolnăvicios",
    "bolovani": "bolovan",
    "bolovanii": "bolovan",
    "bolovanilor": "bolovan",
    "bolovanul": "bolovan",
    "bolovanule": "bolovan",
    "bolovanului": "bolovan",
    "bolovănoasa": "bolovănos",
    "bolovănoasă": "bolovănos",
    "bolovănoase": "bolovănos",
    "bolovănoasei": "bolovănos",
    "bolovănoasele": "bolovănos",
    "bolovănoaselor": "bolovănos",
    "bolovănoaso": "bolovănos",
    "bolovănoși": "bolovănos",
    "bolovănoșii": "bolovănos",
    "bolovănoșilor": "bolovănos",
    "bolovănosul": "bolovănos",
    "bolovănosule": "bolovănos",
    "bolovănosului": "bolovănos",
    "bolșevica": "bolșevică",
    "bolșevice": "bolșevică",
    "bolșevicei": "bolșevică",
    "bolșevicele": "bolșevică",
    "bolșevicelor": "bolșevică",
    "bolșevisme": "bolșevism",
    "bolșevismele": "bolșevism",
    "bolșevismelor": "bolșevism",
    "bolșevismul": "bolșevism",
    "bolșevismului": "bolșevism",
    "bolta": "boltă",
    "bolți": "boltă",
    "bolții": "boltă",
    "bolțile": "boltă",
    "bolților": "boltă",
    "boltirea": "boltire",
    "boltiri": "boltire",
    "boltirii": "boltire",
    "boltirile": "boltire",
    "boltirilor": "boltire",
    "boltita": "boltit",
    "boltită": "boltit",
    "boltite": "boltit",
    "boltitei": "boltit",
    "boltitele": "boltit",
    "boltitelor": "boltit",
    "boltiți": "boltit",
    "boltiții": "boltit",
    "boltiților": "boltit",
    "boltitul": "boltit",
    "boltitului": "boltit",
    "bombă": "bomba",
    "bombai": "bomba",
    "bombam": "bomba",
    "bombăm": "bomba",
    "bombând": "bomba",
    "bombându": "bomba",
    "bombară": "bomba",
    "bombarăm": "bomba",
    "bombarăți": "bomba",
    "bombase": "bomba",
    "bombasem": "bomba",
    "bombaseră": "bomba",
    "bombaserăm": "bomba",
    "bombaserăți": "bomba",
    "bombaseși": "bomba",
    "bombași": "bomba",
    "bombat": "bomba",
    "bombați": "bomba",
    "bombatu": "bomba",
    "bombau": "bomba",
    "bombează": "bomba",
    "bombez": "bomba",
    "bombeze": "bomba",
    "bombezi": "bomba",
    "nebombând": "bomba",
    "nebombându": "bomba",
    "nemaibombând": "bomba",
    "nemaibombându": "bomba",
    "bomba": "bombă",
    "bombe": "bombă",
    "bombei": "bombă",
    "bombele": "bombă",
    "bombelor": "bombă",
    "bombănea": "bombăni",
    "bombăneai": "bombăni",
    "bombăneam": "bombăni",
    "bombănească": "bombăni",
    "bombăneați": "bombăni",
    "bombăneau": "bombăni",
    "bombănesc": "bombăni",
    "bombănește": "bombăni",
    "bombănești": "bombăni",
    "bombănii": "bombăni",
    "bombănim": "bombăni",
    "bombănind": "bombăni",
    "bombănindu": "bombăni",
    "bombăniră": "bombăni",
    "bombănirăm": "bombăni",
    "bombănirăți": "bombăni",
    "bombănise": "bombăni",
    "bombănisem": "bombăni",
    "bombăniseră": "bombăni",
    "bombăniserăm": "bombăni",
    "bombăniserăți": "bombăni",
    "bombăniseși": "bombăni",
    "bombăniși": "bombăni",
    "bombănit": "bombăni",
    "bombăniți": "bombăni",
    "bombănitu": "bombăni",
    "bombănită": "bombănit",
    "bombănite": "bombănit",
    "bombăniți": "bombănit",
    "bombardă": "bombarda",
    "bombardai": "bombarda",
    "bombardam": "bombarda",
    "bombardăm": "bombarda",
    "bombardând": "bombarda",
    "bombardându": "bombarda",
    "bombardară": "bombarda",
    "bombardarăm": "bombarda",
    "bombardarăți": "bombarda",
    "bombardase": "bombarda",
    "bombardasem": "bombarda",
    "bombardaseră": "bombarda",
    "bombardaserăm": "bombarda",
    "bombardaserăți": "bombarda",
    "bombardaseși": "bombarda",
    "bombardași": "bombarda",
    "bombardat": "bombarda",
    "bombardați": "bombarda",
    "bombardatu": "bombarda",
    "bombardau": "bombarda",
    "bombardează": "bombarda",
    "bombardez": "bombarda",
    "bombardeze": "bombarda",
    "bombardezi": "bombarda",
    "nebombardând": "bombarda",
    "nebombardându": "bombarda",
    "nemaibombardând": "bombarda",
    "nemaibombardându": "bombarda",
    "bombarda": "bombardă",
    "bombarde": "bombardă",
    "bombardei": "bombardă",
    "bombardele": "bombardă",
    "bombardelor": "bombardă",
    "bombardamente": "bombardament",
    "bombardamentele": "bombardament",
    "bombardamentelor": "bombardament",
    "bombardamentul": "bombardament",
    "bombardamentului": "bombardament",
    "bombardarea": "bombardare",
    "bombardări": "bombardare",
    "bombardării": "bombardare",
    "bombardările": "bombardare",
    "bombardata": "bombardat",
    "bombardată": "bombardat",
    "bombardate": "bombardat",
    "bombardatei": "bombardat",
    "bombardatele": "bombardat",
    "bombardatelor": "bombardat",
    "bombardați": "bombardat",
    "bombardații": "bombardat",
    "bombardaților": "bombardat",
    "bombardatul": "bombardat",
    "bombardatului": "bombardat",
    "bombardiere": "bombardier",
    "bombardierele": "bombardier",
    "bombardierelor": "bombardier",
    "bombardierul": "bombardier",
    "bombardierului": "bombardier",
    "bombarea": "bombare",
    "bombări": "bombare",
    "bombării": "bombare",
    "bombările": "bombare",
    "bombastica": "bombastic",
    "bombastică": "bombastic",
    "bombastice": "bombastic",
    "bombasticei": "bombastic",
    "bombasticele": "bombastic",
    "bombasticelor": "bombastic",
    "bombastici": "bombastic",
    "bombasticii": "bombastic",
    "bombasticilor": "bombastic",
    "bombasticul": "bombastic",
    "bombasticului": "bombastic",
    "bombata": "bombat",
    "bombată": "bombat",
    "bombate": "bombat",
    "bombatei": "bombat",
    "bombatele": "bombat",
    "bombatelor": "bombat",
    "bombați": "bombat",
    "bombații": "bombat",
    "bombaților": "bombat",
    "bombatul": "bombat",
    "bombatului": "bombat",
    "bombeul": "bombeu",
    "bombeului": "bombeu",
    "bombeuri": "bombeu",
    "bombeurile": "bombeu",
    "bombeurilor": "bombeu",
    "bomboana": "bomboană",
    "bomboane": "bomboană",
    "bomboanei": "bomboană",
    "bomboanele": "bomboană",
    "bomboanelor": "bomboană",
    "bomfaiere": "bomfaier",
    "bomfaierele": "bomfaier",
    "bomfaierelor": "bomfaier",
    "bomfaierul": "bomfaier",
    "bomfaierului": "bomfaier",
    "bonul": "bon",
    "bonului": "bon",
    "bonuri": "bon",
    "bonurile": "bon",
    "bonurilor": "bon",
    "bona": "bonă",
    "bone": "bonă",
    "bonei": "bonă",
    "bonele": "bonă",
    "bonelor": "bonă",
    "bondari": "bondar",
    "bondarii": "bondar",
    "bondarilor": "bondar",
    "bondarul": "bondar",
    "bondarului": "bondar",
    "bondoaca": "bondoc",
    "bondoacă": "bondoc",
    "bondoace": "bondoc",
    "bondoacei": "bondoc",
    "bondoacele": "bondoc",
    "bondoacelor": "bondoc",
    "bondoci": "bondoc",
    "bondocii": "bondoc",
    "bondocilor": "bondoc",
    "bondocul": "bondoc",
    "bondocului": "bondoc",
    "boniere": "bonier",
    "bonierele": "bonier",
    "bonierelor": "bonier",
    "bonierul": "bonier",
    "bonierului": "bonier",
    "bonific": "bonifica",
    "bonifică": "bonifica",
    "bonificai": "bonifica",
    "bonificam": "bonifica",
    "bonificăm": "bonifica",
    "bonificând": "bonifica",
    "bonificându": "bonifica",
    "bonificară": "bonifica",
    "bonificarăm": "bonifica",
    "bonificarăți": "bonifica",
    "bonificase": "bonifica",
    "bonificasem": "bonifica",
    "bonificaseră": "bonifica",
    "bonificaserăm": "bonifica",
    "bonificaserăți": "bonifica",
    "bonificaseși": "bonifica",
    "bonificași": "bonifica",
    "bonificat": "bonifica",
    "bonificați": "bonifica",
    "bonificatu": "bonifica",
    "bonificau": "bonifica",
    "bonifice": "bonifica",
    "bonifici": "bonifica",
    "nebonificând": "bonifica",
    "nebonificându": "bonifica",
    "nemaibonificând": "bonifica",
    "nemaibonificându": "bonifica",
    "bonificarea": "bonificare",
    "bonificări": "bonificare",
    "bonificării": "bonificare",
    "bonificările": "bonificare",
    "bonificata": "bonificat",
    "bonificată": "bonificat",
    "bonificate": "bonificat",
    "bonificatei": "bonificat",
    "bonificatele": "bonificat",
    "bonificatelor": "bonificat",
    "bonificați": "bonificat",
    "bonificații": "bonificat",
    "bonificaților": "bonificat",
    "bonificatul": "bonificat",
    "bonificatului": "bonificat",
    "bonificația": "bonificație",
    "bonificației": "bonificație",
    "bonificații": "bonificație",
    "bonificațiile": "bonificație",
    "bonificațiilor": "bonificație",
    "bonitatea": "bonitate",
    "bonități": "bonitate",
    "bonității": "bonitate",
    "bonitățile": "bonitate",
    "bonităților": "bonitate",
    "bonoma": "bonom",
    "bonomă": "bonom",
    "bonome": "bonom",
    "bonomei": "bonom",
    "bonomele": "bonom",
    "bonomelor": "bonom",
    "bonomi": "bonom",
    "bonomii": "bonom",
    "bonomilor": "bonom",
    "bonomul": "bonom",
    "bonomului": "bonom",
    "boanta": "bont",
    "boantă": "bont",
    "boante": "bont",
    "boantei": "bont",
    "boantele": "bont",
    "boantelor": "bont",
    "bonți": "bont",
    "bonții": "bont",
    "bonților": "bont",
    "bontul": "bont",
    "bontului": "bont",
    "bontonul": "bonton",
    "bontonului": "bonton",
    "bontonuri": "bonton",
    "bontonurile": "bonton",
    "bontonurilor": "bonton",
    "bonusul": "bonus",
    "bonusului": "bonus",
    "bonusuri": "bonus",
    "bonusurile": "bonus",
    "bonusurilor": "bonus",
    "B": "bor",
    "borul": "bor",
    "borului": "bor",
    "borcane": "borcan",
    "borcanele": "borcan",
    "borcanelor": "borcan",
    "borcanul": "borcan",
    "borcanule": "borcan",
    "borcanului": "borcan",
    "borcănele": "borcănel",
    "borcănelele": "borcănel",
    "borcănelelor": "borcănel",
    "borcănelul": "borcănel",
    "borcănelule": "borcănel",
    "borcănelului": "borcănel",
    "bordul": "bord",
    "bordului": "bord",
    "borduri": "bord",
    "bordurile": "bord",
    "bordurilor": "bord",
    "bordeie": "bordei",
    "bordeiele": "bordei",
    "bordeielor": "bordei",
    "bordeiul": "bordei",
    "bordeiului": "bordei",
    "bordelul": "bordel",
    "bordelului": "bordel",
    "bordeluri": "bordel",
    "bordelurile": "bordel",
    "bordelurilor": "bordel",
    "borderoul": "borderou",
    "borderoului": "borderou",
    "borderouri": "borderou",
    "borderourile": "borderou",
    "borderourilor": "borderou",
    "bordura": "bordură",
    "borduri": "bordură",
    "bordurii": "bordură",
    "bordurile": "bordură",
    "bordurilor": "bordură",
    "boreala": "boreal",
    "boreală": "boreal",
    "boreale": "boreal",
    "borealei": "boreal",
    "borealele": "boreal",
    "borealelor": "boreal",
    "boreali": "boreal",
    "borealii": "boreal",
    "borealilor": "boreal",
    "borealul": "boreal",
    "borealului": "boreal",
    "borfași": "borfaș",
    "borfașii": "borfaș",
    "borfașilor": "borfaș",
    "borfașul": "borfaș",
    "borfașului": "borfaș",
    "borfășia": "borfășie",
    "borfășiei": "borfășie",
    "borfășii": "borfășie",
    "borfășiile": "borfășie",
    "borfășiilor": "borfășie",
    "bormașina": "bormașină",
    "bormașini": "bormașină",
    "bormașinii": "bormașină",
    "bormașinile": "bormașină",
    "bormașinilor": "bormașină",
    "borna": "bornă",
    "borne": "bornă",
    "bornei": "bornă",
    "bornele": "bornă",
    "bornelor": "bornă",
    "boroana": "boroană",
    "boroane": "boroană",
    "boroanei": "boroană",
    "boroanele": "boroană",
    "boroanelor": "boroană",
    "borșul": "borș",
    "borșului": "borș",
    "borșuri": "borș",
    "borșurile": "borș",
    "borșurilor": "borș",
    "borvize": "borviz",
    "borvizele": "borviz",
    "borvizelor": "borviz",
    "borvizul": "borviz",
    "borvizului": "borviz",
    "boscari": "boscar",
    "boscarii": "boscar",
    "boscarilor": "boscar",
    "boscarul": "boscar",
    "boscarului": "boscar",
    "boschete": "boschet",
    "boschetele": "boschet",
    "boschetelor": "boschet",
    "boschetul": "boschet",
    "boschetului": "boschet",
    "boschetari": "boschetar",
    "boschetarii": "boschetar",
    "boschetarilor": "boschetar",
    "boschetarul": "boschetar",
    "boschetarului": "boschetar",
    "boscorodea": "boscorodi",
    "boscorodeai": "boscorodi",
    "boscorodeam": "boscorodi",
    "boscorodească": "boscorodi",
    "boscorodeați": "boscorodi",
    "boscorodeau": "boscorodi",
    "boscorodesc": "boscorodi",
    "boscorodește": "boscorodi",
    "boscorodești": "boscorodi",
    "boscorodii": "boscorodi",
    "boscorodim": "boscorodi",
    "boscorodind": "boscorodi",
    "boscorodindu": "boscorodi",
    "boscorodiră": "boscorodi",
    "boscorodirăm": "boscorodi",
    "boscorodirăți": "boscorodi",
    "boscorodise": "boscorodi",
    "boscorodisem": "boscorodi",
    "boscorodiseră": "boscorodi",
    "boscorodiserăm": "boscorodi",
    "boscorodiserăți": "boscorodi",
    "boscorodiseși": "boscorodi",
    "boscorodiși": "boscorodi",
    "boscorodit": "boscorodi",
    "boscorodiți": "boscorodi",
    "boscoroditu": "boscorodi",
    "neboscorodind": "boscorodi",
    "neboscorodindu": "boscorodi",
    "nemaiboscorodind": "boscorodi",
    "nemaiboscorodindu": "boscorodi",
    "boscorodirea": "boscorodire",
    "boscorodiri": "boscorodire",
    "boscorodirii": "boscorodire",
    "boscorodirile": "boscorodire",
    "boscorodita": "boscorodit",
    "boscorodită": "boscorodit",
    "boscorodite": "boscorodit",
    "boscoroditei": "boscorodit",
    "boscoroditele": "boscorodit",
    "boscoroditelor": "boscorodit",
    "boscorodiți": "boscorodit",
    "boscorodiții": "boscorodit",
    "boscorodiților": "boscorodit",
    "boscoroditul": "boscorodit",
    "boscoroditului": "boscorodit",
    "bosniaca": "bosniac",
    "bosniacă": "bosniac",
    "bosniace": "bosniac",
    "bosniacei": "bosniac",
    "bosniacele": "bosniac",
    "bosniacelor": "bosniac",
    "bosniaci": "bosniac",
    "bosniacii": "bosniac",
    "bosniacilor": "bosniac",
    "bosniacul": "bosniac",
    "bosniacului": "bosniac",
    "bosniece": "bosniac",
    "bosniecei": "bosniac",
    "bosniecele": "bosniac",
    "bosniecelor": "bosniac",
    "bosnieci": "bosniac",
    "bosniecii": "bosniac",
    "bosniecilor": "bosniac",
    "bosniaca": "bosniacă",
    "bosniece": "bosniacă",
    "bosniecei": "bosniacă",
    "bosniecele": "bosniacă",
    "bosniecelor": "bosniacă",
    "bosumflă": "bosumfla",
    "bosumflai": "bosumfla",
    "bosumflam": "bosumfla",
    "bosumflăm": "bosumfla",
    "bosumflând": "bosumfla",
    "bosumflându": "bosumfla",
    "bosumflară": "bosumfla",
    "bosumflarăm": "bosumfla",
    "bosumflarăți": "bosumfla",
    "bosumflase": "bosumfla",
    "bosumflasem": "bosumfla",
    "bosumflaseră": "bosumfla",
    "bosumflaserăm": "bosumfla",
    "bosumflaserăți": "bosumfla",
    "bosumflaseși": "bosumfla",
    "bosumflași": "bosumfla",
    "bosumflat": "bosumfla",
    "bosumflați": "bosumfla",
    "bosumflau": "bosumfla",
    "bosumfle": "bosumfla",
    "bosumfli": "bosumfla",
    "bosumflu": "bosumfla",
    "bosumflarea": "bosumflare",
    "bosumflări": "bosumflare",
    "bosumflării": "bosumflare",
    "bosumflările": "bosumflare",
    "bosumflărilor": "bosumflare",
    "bosumflata": "bosumflat",
    "bosumflată": "bosumflat",
    "bosumflate": "bosumflat",
    "bosumflatei": "bosumflat",
    "bosumflatele": "bosumflat",
    "bosumflatelor": "bosumflat",
    "bosumflați": "bosumflat",
    "bosumflații": "bosumflat",
    "bosumflaților": "bosumflat",
    "bosumflato": "bosumflat",
    "bosumflatul": "bosumflat",
    "bosumflatule": "bosumflat",
    "bosumflatului": "bosumflat",
    "botu'": "bot",
    "botul": "bot",
    "botule": "bot",
    "botului": "bot",
    "boturi": "bot",
    "boturile": "bot",
    "boturilor": "bot",
    "bot.": "botanică",
    "botanica": "botanică",
    "botanicele": "botanică",
    "botanicelor": "botanică",
    "botanici": "botanică",
    "botanicii": "botanică",
    "botezul": "botez",
    "botezului": "botez",
    "botezuri": "botez",
    "botezurile": "botez",
    "botezurilor": "botez",
    "botez": "boteza",
    "boteză": "boteza",
    "botezai": "boteza",
    "botezam": "boteza",
    "botezăm": "boteza",
    "botezând": "boteza",
    "botezându": "boteza",
    "botezară": "boteza",
    "botezarăm": "boteza",
    "botezarăți": "boteza",
    "botezase": "boteza",
    "botezasem": "boteza",
    "botezaseră": "boteza",
    "botezaserăm": "boteza",
    "botezaserăți": "boteza",
    "botezaseși": "boteza",
    "botezași": "boteza",
    "botezat": "boteza",
    "botezați": "boteza",
    "botezatu": "boteza",
    "botezau": "boteza",
    "boteze": "boteza",
    "botezi": "boteza",
    "botezata": "botezat",
    "botezată": "botezat",
    "botezate": "botezat",
    "botezatei": "botezat",
    "botezatele": "botezat",
    "botezatelor": "botezat",
    "botezați": "botezat",
    "botezații": "botezat",
    "botezaților": "botezat",
    "botezatul": "botezat",
    "botezatului": "botezat",
    "botezata": "botezată",
    "botezate": "botezată",
    "botezatei": "botezată",
    "botezatele": "botezată",
    "botezatelor": "botezată",
    "botoasa": "botoasă",
    "botoase": "botoasă",
    "botoasei": "botoasă",
    "botoasele": "botoasă",
    "botoaselor": "botoasă",
    "botoasa": "botos",
    "botoasă": "botos",
    "botoase": "botos",
    "botoasei": "botos",
    "botoasele": "botos",
    "botoaselor": "botos",
    "botoși": "botos",
    "botoșii": "botos",
    "botoșilor": "botos",
    "botosul": "botos",
    "botosului": "botos",
    "Botoșaniul": "Botoșani",
    "Botoșaniului": "Botoșani",
    "boi": "bou",
    "boii": "bou",
    "boilor": "bou",
    "boul": "bou",
    "boule": "bou",
    "boului": "bou",
    "boi-de-apă": "bou-de-apă",
    "boi-de-baltă": "bou-de-baltă",
    "boi-de-mare": "bou-de-mare",
    "boii-Domnului": "boul-Domnului",
    "boii-lui-Dumnezeu": "boul-lui-Dumnezeu",
    "boii-popii": "boul-popii",
    "bouri": "bour",
    "bourii": "bour",
    "bourilor": "bour",
    "bourul": "bour",
    "bourului": "bour",
    "bovina": "bovin",
    "bovină": "bovin",
    "bovine": "bovin",
    "bovinei": "bovin",
    "bovinele": "bovin",
    "bovinelor": "bovin",
    "bovini": "bovin",
    "bovinii": "bovin",
    "bovinilor": "bovin",
    "bovinul": "bovin",
    "bovinului": "bovin",
    "boxul": "box",
    "boxule": "box",
    "boxului": "box",
    "boxă": "boxa",
    "boxai": "boxa",
    "boxam": "boxa",
    "boxăm": "boxa",
    "boxând": "boxa",
    "boxându": "boxa",
    "boxară": "boxa",
    "boxarăm": "boxa",
    "boxarăți": "boxa",
    "boxase": "boxa",
    "boxasem": "boxa",
    "boxaseră": "boxa",
    "boxaserăm": "boxa",
    "boxaserăți": "boxa",
    "boxaseși": "boxa",
    "boxași": "boxa",
    "boxat": "boxa",
    "boxați": "boxa",
    "boxatu": "boxa",
    "boxau": "boxa",
    "boxează": "boxa",
    "boxez": "boxa",
    "boxeze": "boxa",
    "boxezi": "boxa",
    "neboxând": "boxa",
    "neboxându": "boxa",
    "nemaiboxând": "boxa",
    "nemaiboxându": "boxa",
    "boxa": "boxă",
    "boxe": "boxă",
    "boxei": "boxă",
    "boxele": "boxă",
    "boxelor": "boxă",
    "boxarea": "boxare",
    "boxareo": "boxare",
    "boxări": "boxare",
    "boxării": "boxare",
    "boxările": "boxare",
    "boxărilor": "boxare",
    "boxata": "boxat",
    "boxată": "boxat",
    "boxate": "boxat",
    "boxatei": "boxat",
    "boxatele": "boxat",
    "boxatelor": "boxat",
    "boxați": "boxat",
    "boxații": "boxat",
    "boxaților": "boxat",
    "boxato": "boxat",
    "boxatul": "boxat",
    "boxatule": "boxat",
    "boxatului": "boxat",
    "boxeri": "boxer",
    "boxerii": "boxer",
    "boxerilor": "boxer",
    "boxerul": "boxer",
    "boxerule": "boxer",
    "boxerului": "boxer",
    "braconaje": "braconaj",
    "braconajele": "braconaj",
    "braconajelor": "braconaj",
    "braconajul": "braconaj",
    "braconajului": "braconaj",
    "bracteea": "bractee",
    "bracteei": "bractee",
    "bracteele": "bractee",
    "bracteelor": "bractee",
    "bradul": "brad",
    "bradului": "brad",
    "brazi": "brad",
    "brazii": "brad",
    "brazilor": "brad",
    "brădetul": "brădet",
    "brădetului": "brădet",
    "brădeturi": "brădet",
    "brădeturile": "brădet",
    "brădeturilor": "brădet",
    "brazi-roșii": "brad-roșu",
    "brahiala": "brahial",
    "brahială": "brahial",
    "brahiale": "brahial",
    "brahialei": "brahial",
    "brahialele": "brahial",
    "brahialelor": "brahial",
    "brahiali": "brahial",
    "brahialii": "brahial",
    "brahialilor": "brahial",
    "brahialul": "brahial",
    "brahialului": "brahial",
    "Brăilă": "Brăila",
    "Brăile": "Brăila",
    "Brăilei": "Brăila",
    "brambureala": "brambureală",
    "brambureli": "brambureală",
    "bramburelii": "brambureală",
    "bramburelile": "brambureală",
    "bramburelilor": "brambureală",
    "brânca": "brâncă",
    "brânci": "brâncă",
    "brâncii": "brâncă",
    "brâncile": "brâncă",
    "brâncilor": "brâncă",
    "brancarda": "brancardă",
    "brancarde": "brancardă",
    "brancardei": "brancardă",
    "brancardele": "brancardă",
    "brancardelor": "brancardă",
    "brancardieri": "brancardier",
    "brancardierii": "brancardier",
    "brancardierilor": "brancardier",
    "brancardierul": "brancardier",
    "brancardierului": "brancardier",
    "brânciul": "brânci",
    "brânciului": "brânci",
    "brandul": "brand",
    "brandului": "brand",
    "branduri": "brand",
    "brandurile": "brand",
    "brandurilor": "brand",
    "Brândușe": "Brândușa",
    "Brândușei": "Brândușa",
    "braniștea": "braniște",
    "braniști": "braniște",
    "braniștii": "braniște",
    "braniștile": "braniște",
    "braniștilor": "braniște",
    "branșă": "branșa",
    "branșai": "branșa",
    "branșam": "branșa",
    "branșăm": "branșa",
    "branșând": "branșa",
    "branșându": "branșa",
    "branșară": "branșa",
    "branșarăm": "branșa",
    "branșarăți": "branșa",
    "branșase": "branșa",
    "branșasem": "branșa",
    "branșaseră": "branșa",
    "branșaserăm": "branșa",
    "branșaserăți": "branșa",
    "branșaseși": "branșa",
    "branșași": "branșa",
    "branșat": "branșa",
    "branșați": "branșa",
    "branșatu": "branșa",
    "branșau": "branșa",
    "branșează": "branșa",
    "branșez": "branșa",
    "branșeze": "branșa",
    "branșezi": "branșa",
    "branșa": "branșă",
    "branșe": "branșă",
    "branșei": "branșă",
    "branșele": "branșă",
    "branșelor": "branșă",
    "branșamente": "branșament",
    "branșamentele": "branșament",
    "branșamentelor": "branșament",
    "branșamentul": "branșament",
    "branșamentului": "branșament",
    "branșarea": "branșare",
    "branșări": "branșare",
    "branșării": "branșare",
    "branșările": "branșare",
    "branșata": "branșat",
    "branșată": "branșat",
    "branșate": "branșat",
    "branșatei": "branșat",
    "branșatele": "branșat",
    "branșatelor": "branșat",
    "branșați": "branșat",
    "branșații": "branșat",
    "branșaților": "branșat",
    "branșatul": "branșat",
    "branșatului": "branșat",
    "branțul": "branț",
    "branțului": "branț",
    "branțuri": "branț",
    "branțurile": "branț",
    "branțurilor": "branț",
    "brânza": "brânză",
    "brânze": "brânză",
    "brânzei": "brânză",
    "brânzii": "brânză",
    "brânzo": "brânză",
    "brasarda": "brasardă",
    "brasarde": "brasardă",
    "brasardei": "brasardă",
    "brasardele": "brasardă",
    "brasardelor": "brasardă",
    "braseria": "braserie",
    "braseriei": "braserie",
    "braserii": "braserie",
    "braseriile": "braserie",
    "braseriilor": "braserie",
    "brasiera": "brasieră",
    "brasiere": "brasieră",
    "brasierei": "brasieră",
    "brasierele": "brasieră",
    "brasierelor": "brasieră",
    "brașoava": "brașoavă",
    "brașoave": "brașoavă",
    "brașoavei": "brașoavă",
    "brașoavele": "brașoavă",
    "brașoavelor": "brașoavă",
    "Brașovul": "Brașov",
    "Brașovului": "Brașov",
    "brațe": "braț",
    "brațele": "braț",
    "brațelor": "braț",
    "brațul": "braț",
    "brațului": "braț",
    "brățara": "brățară",
    "brățări": "brățară",
    "brățării": "brățară",
    "brățările": "brățară",
    "brățărilor": "brățară",
    "brâie": "brâu",
    "brâiele": "brâu",
    "brâielor": "brâu",
    "brâul": "brâu",
    "brâule": "brâu",
    "brâului": "brâu",
    "brava": "brav",
    "bravă": "brav",
    "brave": "brav",
    "bravei": "brav",
    "bravele": "brav",
    "bravelor": "brav",
    "bravi": "brav",
    "bravii": "brav",
    "bravilor": "brav",
    "bravul": "brav",
    "bravului": "brav",
    "bravada": "bravadă",
    "bravade": "bravadă",
    "bravadei": "bravadă",
    "bravadele": "bravadă",
    "bravadelor": "bravadă",
    "bravura": "bravură",
    "bravuri": "bravură",
    "bravurii": "bravură",
    "bravurile": "bravură",
    "bravurilor": "bravură",
    "brazda": "brazdă",
    "brazde": "brazdă",
    "brazdei": "brazdă",
    "brazdele": "brazdă",
    "brazdelor": "brazdă",
    "brăzdă": "brăzda",
    "brăzdai": "brăzda",
    "brăzdam": "brăzda",
    "brăzdăm": "brăzda",
    "brăzdând": "brăzda",
    "brăzdându": "brăzda",
    "brăzdară": "brăzda",
    "brăzdarăm": "brăzda",
    "brăzdarăți": "brăzda",
    "brăzdase": "brăzda",
    "brăzdasem": "brăzda",
    "brăzdaseră": "brăzda",
    "brăzdaserăm": "brăzda",
    "brăzdaserăți": "brăzda",
    "brăzdaseși": "brăzda",
    "brăzdași": "brăzda",
    "brăzdat": "brăzda",
    "brăzdați": "brăzda",
    "brăzdatu": "brăzda",
    "brăzdau": "brăzda",
    "brăzdează": "brăzda",
    "brăzdez": "brăzda",
    "brăzdeze": "brăzda",
    "brăzdezi": "brăzda",
    "nebrăzdând": "brăzda",
    "nebrăzdându": "brăzda",
    "nemaibrăzdând": "brăzda",
    "nemaibrăzdându": "brăzda",
    "brăzdarea": "brăzdare",
    "brăzdareo": "brăzdare",
    "brăzdări": "brăzdare",
    "brăzdării": "brăzdare",
    "brăzdările": "brăzdare",
    "brăzdărilor": "brăzdare",
    "brăzdata": "brăzdat",
    "brăzdată": "brăzdat",
    "brăzdate": "brăzdat",
    "brăzdatei": "brăzdat",
    "brăzdatele": "brăzdat",
    "brăzdatelor": "brăzdat",
    "brăzdați": "brăzdat",
    "brăzdații": "brăzdat",
    "brăzdaților": "brăzdat",
    "brăzdato": "brăzdat",
    "brăzdatul": "brăzdat",
    "brăzdatule": "brăzdat",
    "brăzdatului": "brăzdat",
    "Braziul": "Brazi",
    "Brazilie": "Brazilia",
    "Braziliei": "Brazilia",
    "Brazilii": "Brazilia",
    "braziliana": "brazilian",
    "braziliană": "brazilian",
    "braziliano": "brazilian",
    "brazilianul": "brazilian",
    "brazilianule": "brazilian",
    "brazilianului": "brazilian",
    "braziliene": "brazilian",
    "brazilienei": "brazilian",
    "brazilienele": "brazilian",
    "brazilienelor": "brazilian",
    "brazilieni": "brazilian",
    "brazilienii": "brazilian",
    "brazilienilor": "brazilian",
    "brazilianca": "braziliancă",
    "brazilianco": "braziliancă",
    "brazilience": "braziliancă",
    "braziliencei": "braziliancă",
    "braziliencele": "braziliancă",
    "braziliencelor": "braziliancă",
    "breasla": "breaslă",
    "bresle": "breaslă",
    "breslei": "breaslă",
    "breslele": "breaslă",
    "breslelor": "breaslă",
    "breaza": "breaz",
    "brează": "breaz",
    "breazul": "breaz",
    "breazului": "breaz",
    "breji": "breaz",
    "brejii": "breaz",
    "brejilor": "breaz",
    "breze": "breaz",
    "brezei": "breaz",
    "brezele": "breaz",
    "brezelor": "breaz",
    "brelocul": "breloc",
    "brelocului": "breloc",
    "brelocuri": "breloc",
    "brelocurile": "breloc",
    "brelocurilor": "breloc",
    "breșa": "breșă",
    "breșe": "breșă",
    "breșei": "breșă",
    "breșele": "breșă",
    "breșelor": "breșă",
    "brevete": "brevet",
    "brevetele": "brevet",
    "brevetelor": "brevet",
    "brevetul": "brevet",
    "brevetului": "brevet",
    "brevetă": "breveta",
    "brevetai": "breveta",
    "brevetam": "breveta",
    "brevetăm": "breveta",
    "brevetând": "breveta",
    "brevetându": "breveta",
    "brevetară": "breveta",
    "brevetarăm": "breveta",
    "brevetarăți": "breveta",
    "brevetase": "breveta",
    "brevetasem": "breveta",
    "brevetaseră": "breveta",
    "brevetaserăm": "breveta",
    "brevetaserăți": "breveta",
    "brevetaseși": "breveta",
    "brevetași": "breveta",
    "brevetat": "breveta",
    "brevetați": "breveta",
    "brevetatu": "breveta",
    "brevetau": "breveta",
    "brevetează": "breveta",
    "brevetez": "breveta",
    "breveteze": "breveta",
    "brevetezi": "breveta",
    "nebrevetând": "breveta",
    "nebrevetându": "breveta",
    "nemaibrevetând": "breveta",
    "nemaibrevetându": "breveta",
    "brevetarea": "brevetare",
    "brevetări": "brevetare",
    "brevetării": "brevetare",
    "brevetările": "brevetare",
    "brevetata": "brevetat",
    "brevetată": "brevetat",
    "brevetate": "brevetat",
    "brevetatei": "brevetat",
    "brevetatele": "brevetat",
    "brevetatelor": "brevetat",
    "brevetați": "brevetat",
    "brevetații": "brevetat",
    "brevetaților": "brevetat",
    "brevetatul": "brevetat",
    "brevetatului": "brevetat",
    "breviare": "breviar",
    "breviarele": "breviar",
    "breviarelor": "breviar",
    "breviarul": "breviar",
    "breviarului": "breviar",
    "brianta": "briant",
    "briantă": "briant",
    "briante": "briant",
    "briantei": "briant",
    "briantele": "briant",
    "briantelor": "briant",
    "brianți": "briant",
    "brianții": "briant",
    "brianților": "briant",
    "briantul": "briant",
    "briantului": "briant",
    "bricul": "bric",
    "bricului": "bric",
    "bricuri": "bric",
    "bricurile": "bric",
    "bricurilor": "bric",
    "briceagul": "briceag",
    "briceagule": "briceag",
    "briceagului": "briceag",
    "bricege": "briceag",
    "bricegele": "briceag",
    "bricegelor": "briceag",
    "bricheta": "brichetă",
    "brichete": "brichetă",
    "brichetei": "brichetă",
    "brichetele": "brichetă",
    "brichetelor": "brichetă",
    "brice": "brici",
    "bricele": "brici",
    "bricelor": "brici",
    "briciul": "brici",
    "briciului": "brici",
    "brigada": "brigadă",
    "brigăzi": "brigadă",
    "brigăzii": "brigadă",
    "brigăzile": "brigadă",
    "brigăzilor": "brigadă",
    "brigadieri": "brigadier",
    "brigadierii": "brigadier",
    "brigadierilor": "brigadier",
    "brigadierul": "brigadier",
    "brigadierului": "brigadier",
    "brigadiera": "brigadieră",
    "brigadiere": "brigadieră",
    "brigadierei": "brigadieră",
    "brigadierele": "brigadieră",
    "brigadierelor": "brigadieră",
    "brigandul": "brigand",
    "brigandului": "brigand",
    "briganzi": "brigand",
    "briganzii": "brigand",
    "briganzilor": "brigand",
    "briliante": "briliant",
    "briliantele": "briliant",
    "briliantelor": "briliant",
    "briliantul": "briliant",
    "briliantului": "briliant",
    "brișca": "brișcă",
    "briști": "brișcă",
    "briștii": "brișcă",
    "briștile": "brișcă",
    "briștilor": "brișcă",
    "britanica": "britanic",
    "britanică": "britanic",
    "britanice": "britanic",
    "britanicei": "britanic",
    "britanicele": "britanic",
    "britanicelor": "britanic",
    "britanici": "britanic",
    "britanicii": "britanic",
    "britanicilor": "britanic",
    "britanicul": "britanic",
    "britanicule": "britanic",
    "britanicului": "britanic",
    "britanica": "britanică",
    "britanice": "britanică",
    "britanicei": "britanică",
    "britanicele": "britanică",
    "britanicelor": "britanică",
    "briza": "briză",
    "brize": "briză",
    "brizei": "briză",
    "brizele": "briză",
    "brizelor": "briză",
    "brizbizul": "brizbiz",
    "brizbizului": "brizbiz",
    "brizbizuri": "brizbiz",
    "brizbizurile": "brizbiz",
    "brizbizurilor": "brizbiz",
    "broasca": "broască",
    "broasco": "broască",
    "broaște": "broască",
    "broaștei": "broască",
    "broaștele": "broască",
    "broaștelor": "broască",
    "broasca-țestoasă": "broască-țestoasă",
    "broaștei-țestoase": "broască-țestoasă",
    "broaștele-țestoase": "broască-țestoasă",
    "broaștelor-țestoase": "broască-țestoasă",
    "broaște-țestoase": "broască-țestoasă",
    "broboada": "broboadă",
    "broboade": "broboadă",
    "broboadei": "broboadă",
    "broboadele": "broboadă",
    "broboadelor": "broboadă",
    "broboana": "broboană",
    "broboane": "broboană",
    "broboanei": "broboană",
    "broboanele": "broboană",
    "broboanelor": "broboană",
    "brocartul": "brocart",
    "brocartului": "brocart",
    "brocarturi": "brocart",
    "brocarturile": "brocart",
    "brocarturilor": "brocart",
    "brodă": "broda",
    "brodai": "broda",
    "brodam": "broda",
    "brodăm": "broda",
    "brodând": "broda",
    "brodându": "broda",
    "brodară": "broda",
    "brodarăm": "broda",
    "brodarăți": "broda",
    "brodase": "broda",
    "brodasem": "broda",
    "brodaseră": "broda",
    "brodaserăm": "broda",
    "brodaserăți": "broda",
    "brodaseși": "broda",
    "brodași": "broda",
    "brodat": "broda",
    "brodați": "broda",
    "brodatu": "broda",
    "brodau": "broda",
    "brodează": "broda",
    "brodez": "broda",
    "brodeze": "broda",
    "brodezi": "broda",
    "nebrodând": "broda",
    "nebrodându": "broda",
    "nemaibrodând": "broda",
    "nemaibrodându": "broda",
    "brodată": "brodat",
    "brodate": "brodat",
    "brodați": "brodat",
    "broderia": "broderie",
    "broderiei": "broderie",
    "broderii": "broderie",
    "broderiile": "broderie",
    "broderiilor": "broderie",
    "brokeri": "broker",
    "brokerii": "broker",
    "brokerilor": "broker",
    "brokerul": "broker",
    "brokerului": "broker",
    "Br": "brom",
    "bromul": "brom",
    "bromului": "brom",
    "bronhia": "bronhie",
    "bronhiei": "bronhie",
    "bronhii": "bronhie",
    "bronhiile": "bronhie",
    "bronhiilor": "bronhie",
    "bronhopneumonia": "bronhopneumonie",
    "bronhopneumoniei": "bronhopneumonie",
    "bronhopneumonii": "bronhopneumonie",
    "bronhopneumoniile": "bronhopneumonie",
    "bronhopneumoniilor": "bronhopneumonie",
    "bronhopneumopatia": "bronhopneumopatie",
    "bronhopneumopatiei": "bronhopneumopatie",
    "bronhopneumopatii": "bronhopneumopatie",
    "bronhopneumopatiile": "bronhopneumopatie",
    "bronhopneumopatiilor": "bronhopneumopatie",
    "bronșica": "bronșic",
    "bronșică": "bronșic",
    "bronșice": "bronșic",
    "bronșicei": "bronșic",
    "bronșicele": "bronșic",
    "bronșicelor": "bronșic",
    "bronșici": "bronșic",
    "bronșicii": "bronșic",
    "bronșicilor": "bronșic",
    "bronșicul": "bronșic",
    "bronșicului": "bronșic",
    "bronșita": "bronșită",
    "bronșite": "bronșită",
    "bronșitei": "bronșită",
    "bronșitele": "bronșită",
    "bronșitelor": "bronșită",
    "bronzul": "bronz",
    "bronzului": "bronz",
    "bronzuri": "bronz",
    "bronzurile": "bronz",
    "bronzurilor": "bronz",
    "broșă": "broșa",
    "broșai": "broșa",
    "broșam": "broșa",
    "broșăm": "broșa",
    "broșând": "broșa",
    "broșându": "broșa",
    "broșară": "broșa",
    "broșarăm": "broșa",
    "broșarăți": "broșa",
    "broșase": "broșa",
    "broșasem": "broșa",
    "broșaseră": "broșa",
    "broșaserăm": "broșa",
    "broșaserăți": "broșa",
    "broșaseși": "broșa",
    "broșași": "broșa",
    "broșat": "broșa",
    "broșați": "broșa",
    "broșatu": "broșa",
    "broșau": "broșa",
    "broșează": "broșa",
    "broșez": "broșa",
    "broșeze": "broșa",
    "broșezi": "broșa",
    "nebroșând": "broșa",
    "nebroșându": "broșa",
    "nemaibroșând": "broșa",
    "nemaibroșându": "broșa",
    "broșa": "broșă",
    "broșe": "broșă",
    "broșei": "broșă",
    "broșele": "broșă",
    "broșelor": "broșă",
    "broșo": "broșă",
    "broșarea": "broșare",
    "broșări": "broșare",
    "broșării": "broșare",
    "broșările": "broșare",
    "broșata": "broșat",
    "broșată": "broșat",
    "broșate": "broșat",
    "broșatei": "broșat",
    "broșatele": "broșat",
    "broșatelor": "broșat",
    "broșați": "broșat",
    "broșații": "broșat",
    "broșaților": "broșat",
    "broșatul": "broșat",
    "broșatului": "broșat",
    "broșura": "broșură",
    "broșuri": "broșură",
    "broșurii": "broșură",
    "broșurile": "broșură",
    "broșurilor": "broșură",
    "broșurele": "broșurică",
    "broșurelei": "broșurică",
    "broșurelele": "broșurică",
    "broșurelelor": "broșurică",
    "broșurica": "broșurică",
    "bruftuluia": "bruftului",
    "bruftuluiai": "bruftului",
    "bruftuluiam": "bruftului",
    "bruftuluiască": "bruftului",
    "bruftuluiați": "bruftului",
    "bruftuluiau": "bruftului",
    "bruftuluiesc": "bruftului",
    "bruftuluiește": "bruftului",
    "bruftuluiești": "bruftului",
    "bruftuluii": "bruftului",
    "bruftuluim": "bruftului",
    "bruftuluind": "bruftului",
    "bruftuluindu": "bruftului",
    "bruftuluiră": "bruftului",
    "bruftuluirăm": "bruftului",
    "bruftuluirăți": "bruftului",
    "bruftuluise": "bruftului",
    "bruftuluisem": "bruftului",
    "bruftuluiseră": "bruftului",
    "bruftuluiserăm": "bruftului",
    "bruftuluiserăți": "bruftului",
    "bruftuluiseși": "bruftului",
    "bruftuluiși": "bruftului",
    "bruftuluit": "bruftului",
    "bruftuluiți": "bruftului",
    "bruftuluitu": "bruftului",
    "nebruftuluind": "bruftului",
    "nebruftuluindu": "bruftului",
    "nemaibruftuluind": "bruftului",
    "nemaibruftuluindu": "bruftului",
    "bruftuluiala": "bruftuluială",
    "bruftuluialo": "bruftuluială",
    "bruftuluieli": "bruftuluială",
    "bruftuluielii": "bruftuluială",
    "bruftuluielile": "bruftuluială",
    "bruftuluielilor": "bruftuluială",
    "bruftuluirea": "bruftuluire",
    "bruftuluireo": "bruftuluire",
    "bruftuluiri": "bruftuluire",
    "bruftuluirii": "bruftuluire",
    "bruftuluirile": "bruftuluire",
    "bruftuluirilor": "bruftuluire",
    "bruftuluita": "bruftuluit",
    "bruftuluită": "bruftuluit",
    "bruftuluite": "bruftuluit",
    "bruftuluitei": "bruftuluit",
    "bruftuluitele": "bruftuluit",
    "bruftuluitelor": "bruftuluit",
    "bruftuluiți": "bruftuluit",
    "bruftuluiții": "bruftuluit",
    "bruftuluiților": "bruftuluit",
    "bruftuluito": "bruftuluit",
    "bruftuluitul": "bruftuluit",
    "bruftuluitule": "bruftuluit",
    "bruftuluitului": "bruftuluit",
    "bruftuluitoarea": "bruftuluitoare",
    "bruftuluitoarei": "bruftuluitoare",
    "bruftuluitoarele": "bruftuluitoare",
    "bruftuluitoarelor": "bruftuluitoare",
    "bruftuluitoareo": "bruftuluitoare",
    "bruftuluitoare": "bruftuluitor",
    "bruftuluitoarea": "bruftuluitor",
    "bruftuluitoarei": "bruftuluitor",
    "bruftuluitoarele": "bruftuluitor",
    "bruftuluitoarelor": "bruftuluitor",
    "bruftuluitoareo": "bruftuluitor",
    "bruftuluitori": "bruftuluitor",
    "bruftuluitorii": "bruftuluitor",
    "bruftuluitorilor": "bruftuluitor",
    "bruftuluitorul": "bruftuluitor",
    "bruftuluitorule": "bruftuluitor",
    "bruftuluitorului": "bruftuluitor",
    "bruiai": "bruia",
    "bruiam": "bruia",
    "bruiară": "bruia",
    "bruiarăm": "bruia",
    "bruiarăți": "bruia",
    "bruiase": "bruia",
    "bruiasem": "bruia",
    "bruiaseră": "bruia",
    "bruiaserăm": "bruia",
    "bruiaserăți": "bruia",
    "bruiaseși": "bruia",
    "bruiași": "bruia",
    "bruiat": "bruia",
    "bruiați": "bruia",
    "bruiatu": "bruia",
    "bruiau": "bruia",
    "bruiază": "bruia",
    "bruie": "bruia",
    "bruiem": "bruia",
    "bruiez": "bruia",
    "bruieze": "bruia",
    "bruiezi": "bruia",
    "bruind": "bruia",
    "bruindu": "bruia",
    "nebruiind": "bruia",
    "nebruiindu": "bruia",
    "nemaibruiind": "bruia",
    "nemaibruiindu": "bruia",
    "bruiata": "bruiat",
    "bruiată": "bruiat",
    "bruiate": "bruiat",
    "bruiatei": "bruiat",
    "bruiatele": "bruiat",
    "bruiatelor": "bruiat",
    "bruiați": "bruiat",
    "bruiații": "bruiat",
    "bruiaților": "bruiat",
    "bruiatul": "bruiat",
    "bruiatului": "bruiat",
    "bruierea": "bruiere",
    "bruieri": "bruiere",
    "bruierii": "bruiere",
    "bruierile": "bruiere",
    "bruma": "brumă",
    "brume": "brumă",
    "brumei": "brumă",
    "brumele": "brumă",
    "brumelor": "brumă",
    "brumata": "brumat",
    "brumată": "brumat",
    "brumate": "brumat",
    "brumatei": "brumat",
    "brumatele": "brumat",
    "brumatelor": "brumat",
    "brumați": "brumat",
    "brumații": "brumat",
    "brumaților": "brumat",
    "brumatul": "brumat",
    "brumatului": "brumat",
    "brumata": "brumată",
    "brumate": "brumată",
    "brumatei": "brumată",
    "brumatele": "brumată",
    "brumatelor": "brumată",
    "bruna": "brun",
    "brună": "brun",
    "brune": "brun",
    "brunei": "brun",
    "brunele": "brun",
    "brunelor": "brun",
    "bruni": "brun",
    "brunii": "brun",
    "brunilor": "brun",
    "brunul": "brun",
    "brunului": "brun",
    "bruneta": "brunet",
    "brunetă": "brunet",
    "brunete": "brunet",
    "brunetei": "brunet",
    "brunetele": "brunet",
    "brunetelor": "brunet",
    "bruneți": "brunet",
    "bruneții": "brunet",
    "bruneților": "brunet",
    "bruneto": "brunet",
    "brunetul": "brunet",
    "brunetule": "brunet",
    "brunetului": "brunet",
    "bruneta": "brunetă",
    "brunete": "brunetă",
    "brunetei": "brunetă",
    "brunetele": "brunetă",
    "brunetelor": "brunetă",
    "bruneto": "brunetă",
    "brusca": "brusc",
    "bruscă": "brusc",
    "bruscul": "brusc",
    "bruscului": "brusc",
    "bruște": "brusc",
    "bruștei": "brusc",
    "bruștele": "brusc",
    "bruștelor": "brusc",
    "bruști": "brusc",
    "bruștii": "brusc",
    "bruștilor": "brusc",
    "bruscăm": "brusca",
    "bruscând": "brusca",
    "bruscându": "brusca",
    "bruscat": "brusca",
    "bruscați": "brusca",
    "bruscatu": "brusca",
    "bruschează": "brusca",
    "bruschez": "brusca",
    "bruscheze": "brusca",
    "bruschezi": "brusca",
    "nebruscând": "brusca",
    "nebruscându": "brusca",
    "nemaibruscând": "brusca",
    "nemaibruscându": "brusca",
    "bruscarea": "bruscare",
    "bruscări": "bruscare",
    "bruscării": "bruscare",
    "bruscările": "bruscare",
    "bruscata": "bruscat",
    "bruscată": "bruscat",
    "bruscate": "bruscat",
    "bruscatei": "bruscat",
    "bruscatele": "bruscat",
    "bruscatelor": "bruscat",
    "bruscați": "bruscat",
    "bruscații": "bruscat",
    "bruscaților": "bruscat",
    "bruscatul": "bruscat",
    "bruscatului": "bruscat",
    "bruscata": "bruscată",
    "bruscate": "bruscată",
    "bruscatei": "bruscată",
    "bruscatele": "bruscată",
    "bruscatelor": "bruscată",
    "bruschețea": "bruschețe",
    "bruscheți": "bruschețe",
    "bruscheții": "bruschețe",
    "bruschețile": "bruschețe",
    "bruscheților": "bruschețe",
    "bruta": "brut",
    "brută": "brut",
    "brute": "brut",
    "brutei": "brut",
    "brutele": "brut",
    "brutelor": "brut",
    "bruți": "brut",
    "bruții": "brut",
    "bruților": "brut",
    "brutul": "brut",
    "brutului": "brut",
    "bruta": "brută",
    "brute": "brută",
    "brutei": "brută",
    "brutele": "brută",
    "brutelor": "brută",
    "brutala": "brutal",
    "brutală": "brutal",
    "brutale": "brutal",
    "brutalei": "brutal",
    "brutalele": "brutal",
    "brutalelor": "brutal",
    "brutali": "brutal",
    "brutalii": "brutal",
    "brutalilor": "brutal",
    "brutalul": "brutal",
    "brutalului": "brutal",
    "brutalitatea": "brutalitate",
    "brutalități": "brutalitate",
    "brutalității": "brutalitate",
    "brutalitățile": "brutalitate",
    "brutalităților": "brutalitate",
    "buba": "bubă",
    "bube": "bubă",
    "bubei": "bubă",
    "bubele": "bubă",
    "bubelor": "bubă",
    "buba-neagră": "bubă-neagră",
    "bubei-negre": "bubă-neagră",
    "bubele-negre": "bubă-neagră",
    "bubelor-negre": "bubă-neagră",
    "bube-negre": "bubă-neagră",
    "buboaie": "buboi",
    "buboaiele": "buboi",
    "buboaielor": "buboi",
    "buboiul": "buboi",
    "buboiului": "buboi",
    "bubuia": "bubui",
    "bubuiai": "bubui",
    "bubuiam": "bubui",
    "bubuiască": "bubui",
    "bubuiați": "bubui",
    "bubuiau": "bubui",
    "bubuiesc": "bubui",
    "bubuiește": "bubui",
    "bubuiești": "bubui",
    "bubuii": "bubui",
    "bubuim": "bubui",
    "bubuind": "bubui",
    "bubuindu": "bubui",
    "bubuiră": "bubui",
    "bubuirăm": "bubui",
    "bubuirăți": "bubui",
    "bubuise": "bubui",
    "bubuisem": "bubui",
    "bubuiseră": "bubui",
    "bubuiserăm": "bubui",
    "bubuiserăți": "bubui",
    "bubuiseși": "bubui",
    "bubuiși": "bubui",
    "bubuit": "bubui",
    "bubuiți": "bubui",
    "bubuitu": "bubui",
    "nebubuind": "bubui",
    "nebubuindu": "bubui",
    "nemaibubuind": "bubui",
    "nemaibubuindu": "bubui",
    "bubuiala": "bubuială",
    "bubuialo": "bubuială",
    "bubuieli": "bubuială",
    "bubuielii": "bubuială",
    "bubuielile": "bubuială",
    "bubuielilor": "bubuială",
    "bubuirea": "bubuire",
    "bubuireo": "bubuire",
    "bubuiri": "bubuire",
    "bubuirii": "bubuire",
    "bubuirile": "bubuire",
    "bubuirilor": "bubuire",
    "bubuita": "bubuit",
    "bubuită": "bubuit",
    "bubuite": "bubuit",
    "bubuiți": "bubuit",
    "bubuiții": "bubuit",
    "bubuiților": "bubuit",
    "bubuitul": "bubuit",
    "bubuitule": "bubuit",
    "bubuitului": "bubuit",
    "bubuitoare": "bubuitor",
    "bubuitoarea": "bubuitor",
    "bubuitoarei": "bubuitor",
    "bubuitoarele": "bubuitor",
    "bubuitoarelor": "bubuitor",
    "bubuitori": "bubuitor",
    "bubuitorii": "bubuitor",
    "bubuitorilor": "bubuitor",
    "bubuitorul": "bubuitor",
    "bubuitorule": "bubuitor",
    "bubuitorului": "bubuitor",
    "bubuitura": "bubuitură",
    "bubuituri": "bubuitură",
    "bubuiturii": "bubuitură",
    "bubuiturile": "bubuitură",
    "bubuiturilor": "bubuitură",
    "buburuza": "buburuză",
    "buburuze": "buburuză",
    "buburuzei": "buburuză",
    "buburuzele": "buburuză",
    "buburuzelor": "buburuză",
    "buca": "bucă",
    "buci": "bucă",
    "bucii": "bucă",
    "bucile": "bucă",
    "bucilor": "bucă",
    "buco": "bucă",
    "bucala": "bucal",
    "bucală": "bucal",
    "bucale": "bucal",
    "bucalei": "bucal",
    "bucalele": "bucal",
    "bucalelor": "bucal",
    "bucali": "bucal",
    "bucalii": "bucal",
    "bucalilor": "bucal",
    "bucalul": "bucal",
    "bucalului": "bucal",
    "buc.": "bucată",
    "bucata": "bucată",
    "bucate": "bucată",
    "bucatele": "bucată",
    "bucatelor": "bucată",
    "bucăți": "bucată",
    "bucății": "bucată",
    "bucățile": "bucată",
    "bucăților": "bucată",
    "bucato": "bucată",
    "bucătari": "bucătar",
    "bucătarii": "bucătar",
    "bucătarilor": "bucătar",
    "bucătarul": "bucătar",
    "bucătarului": "bucătar",
    "bucătăreasa": "bucătăreasă",
    "bucătărese": "bucătăreasă",
    "bucătăresei": "bucătăreasă",
    "bucătăresele": "bucătăreasă",
    "bucătăreselor": "bucătăreasă",
    "bucătăria": "bucătărie",
    "bucătăriei": "bucătărie",
    "bucătării": "bucătărie",
    "bucătăriile": "bucătărie",
    "bucătăriilor": "bucătărie",
    "bucătărio": "bucătărie",
    "bucățele": "bucățică",
    "bucățelei": "bucățică",
    "bucățelele": "bucățică",
    "bucățelelor": "bucățică",
    "bucățica": "bucățică",
    "bucățico": "bucățică",
    "buceaua": "bucea",
    "bucele": "bucea",
    "bucelei": "bucea",
    "bucelele": "bucea",
    "bucelelor": "bucea",
    "buchea": "buche",
    "buchi": "buche",
    "buchii": "buche",
    "buchile": "buche",
    "buchilor": "buche",
    "buchete": "buchet",
    "buchetele": "buchet",
    "buchetelor": "buchet",
    "buchetul": "buchet",
    "buchetule": "buchet",
    "buchetului": "buchet",
    "buchețele": "buchețel",
    "buchețelele": "buchețel",
    "buchețelelor": "buchețel",
    "buchețelul": "buchețel",
    "buchețelule": "buchețel",
    "buchețelului": "buchețel",
    "buchetiera": "buchetieră",
    "buchetiere": "buchetieră",
    "buchetierei": "buchetieră",
    "buchetierele": "buchetieră",
    "buchetierelor": "buchetieră",
    "buchiseala": "buchiseală",
    "buchiseli": "buchiseală",
    "buchiselii": "buchiseală",
    "buchiselile": "buchiseală",
    "buchisirea": "buchisire",
    "buchisiri": "buchisire",
    "buchisirii": "buchisire",
    "buchisirile": "buchisire",
    "buchisita": "buchisit",
    "buchisită": "buchisit",
    "buchisite": "buchisit",
    "buchisitei": "buchisit",
    "buchisitele": "buchisit",
    "buchisitelor": "buchisit",
    "buchisiți": "buchisit",
    "buchisiții": "buchisit",
    "buchisiților": "buchisit",
    "buchisitul": "buchisit",
    "buchisitului": "buchisit",
    "buciume": "bucium",
    "buciumele": "bucium",
    "buciumelor": "bucium",
    "buciumul": "bucium",
    "buciumului": "bucium",
    "bucium": "buciuma",
    "buciumă": "buciuma",
    "buciumai": "buciuma",
    "buciumam": "buciuma",
    "buciumăm": "buciuma",
    "buciumând": "buciuma",
    "buciumându": "buciuma",
    "buciumară": "buciuma",
    "buciumarăm": "buciuma",
    "buciumarăți": "buciuma",
    "buciumase": "buciuma",
    "buciumasem": "buciuma",
    "buciumaseră": "buciuma",
    "buciumaserăm": "buciuma",
    "buciumaserăți": "buciuma",
    "buciumaseși": "buciuma",
    "buciumași": "buciuma",
    "buciumat": "buciuma",
    "buciumați": "buciuma",
    "buciumatu": "buciuma",
    "buciumau": "buciuma",
    "buciume": "buciuma",
    "buciumi": "buciuma",
    "nebuciumând": "buciuma",
    "nebuciumându": "buciuma",
    "nemaibuciumând": "buciuma",
    "nemaibuciumându": "buciuma",
    "buciumarea": "buciumare",
    "buciumări": "buciumare",
    "buciumării": "buciumare",
    "buciumările": "buciumare",
    "buciumata": "buciumat",
    "buciumată": "buciumat",
    "buciumate": "buciumat",
    "buciumatei": "buciumat",
    "buciumatele": "buciumat",
    "buciumatelor": "buciumat",
    "buciumați": "buciumat",
    "buciumații": "buciumat",
    "buciumaților": "buciumat",
    "buciumatul": "buciumat",
    "buciumatului": "buciumat",
    "bucla": "buclă",
    "bucle": "buclă",
    "buclei": "buclă",
    "buclele": "buclă",
    "buclelor": "buclă",
    "buclo": "buclă",
    "bucoavna": "bucoavnă",
    "bucoavne": "bucoavnă",
    "bucoavnei": "bucoavnă",
    "bucoavnele": "bucoavnă",
    "bucoavnelor": "bucoavnă",
    "bucolica": "bucolică",
    "bucolice": "bucolică",
    "bucolicei": "bucolică",
    "bucolicele": "bucolică",
    "bucolicelor": "bucolică",
    "Bucovină": "Bucovina",
    "Bucovine": "Bucovina",
    "Bucovinei": "Bucovina",
    "bucovineana": "bucovinean",
    "bucovineană": "bucovinean",
    "bucovineanul": "bucovinean",
    "bucovineanului": "bucovinean",
    "bucovinene": "bucovinean",
    "bucovinenei": "bucovinean",
    "bucovinenele": "bucovinean",
    "bucovinenelor": "bucovinean",
    "bucovineni": "bucovinean",
    "bucovinenii": "bucovinean",
    "bucovinenilor": "bucovinean",
    "bucovineanca": "bucovineancă",
    "bucovinence": "bucovineancă",
    "bucovinencei": "bucovineancă",
    "bucovinencele": "bucovineancă",
    "bucovinencelor": "bucovineancă",
    "bucșa": "bucșă",
    "bucșe": "bucșă",
    "bucșei": "bucșă",
    "bucșele": "bucșă",
    "bucșelor": "bucșă",
    "bucur": "bucura",
    "bucură": "bucura",
    "bucurai": "bucura",
    "bucuram": "bucura",
    "bucurăm": "bucura",
    "bucurând": "bucura",
    "bucurându": "bucura",
    "bucurară": "bucura",
    "bucurarăm": "bucura",
    "bucurarăți": "bucura",
    "bucurase": "bucura",
    "bucurasem": "bucura",
    "bucuraseră": "bucura",
    "bucuraserăm": "bucura",
    "bucuraserăți": "bucura",
    "bucuraseși": "bucura",
    "bucurași": "bucura",
    "bucurat": "bucura",
    "bucurați": "bucura",
    "bucuratu": "bucura",
    "bucurau": "bucura",
    "bucure": "bucura",
    "bucuri": "bucura",
    "nebucurând": "bucura",
    "nebucurându": "bucura",
    "nemaibucurând": "bucura",
    "nemaibucurându": "bucura",
    "bucurarea": "bucurare",
    "bucurareo": "bucurare",
    "bucurări": "bucurare",
    "bucurării": "bucurare",
    "bucurările": "bucurare",
    "bucurărilor": "bucurare",
    "bucurata": "bucurat",
    "bucurată": "bucurat",
    "bucurate": "bucurat",
    "bucuratei": "bucurat",
    "bucuratele": "bucurat",
    "bucuratelor": "bucurat",
    "bucurați": "bucurat",
    "bucurații": "bucurat",
    "bucuraților": "bucurat",
    "bucurato": "bucurat",
    "bucuratul": "bucurat",
    "bucuratule": "bucurat",
    "bucuratului": "bucurat",
    "bucureșteana": "bucureștean",
    "bucureșteană": "bucureștean",
    "bucureșteanul": "bucureștean",
    "bucureșteanului": "bucureștean",
    "bucureștene": "bucureștean",
    "bucureștenei": "bucureștean",
    "bucureștenele": "bucureștean",
    "bucureștenelor": "bucureștean",
    "bucureșteni": "bucureștean",
    "bucureștenii": "bucureștean",
    "bucureștenilor": "bucureștean",
    "bucureșteanca": "bucureșteancă",
    "bucureștence": "bucureșteancă",
    "bucureștencei": "bucureșteancă",
    "bucureștencele": "bucureșteancă",
    "bucureștencelor": "bucureșteancă",
    "Bucureștii": "București",
    "Bucureștilor": "București",
    "Bucureștiul": "București",
    "Bucureștiului": "București",
    "bucuria": "bucurie",
    "bucuriei": "bucurie",
    "bucurii": "bucurie",
    "bucuriile": "bucurie",
    "bucuriilor": "bucurie",
    "bucurio": "bucurie",
    "bucuroasa": "bucuros",
    "bucuroasă": "bucuros",
    "bucuroase": "bucuros",
    "bucuroasei": "bucuros",
    "bucuroasele": "bucuros",
    "bucuroaselor": "bucuros",
    "bucuroaso": "bucuros",
    "bucuroși": "bucuros",
    "bucuroșii": "bucuros",
    "bucuroșilor": "bucuros",
    "bucurosul": "bucuros",
    "bucurosule": "bucuros",
    "bucurosului": "bucuros",
    "Budapestă": "Budapesta",
    "Budapeste": "Budapesta",
    "Budapestei": "Budapesta",
    "budapestană": "budapestan",
    "budapestanii": "budapestan",
    "budismul": "budism",
    "budismului": "budism",
    "budoare": "budoar",
    "budoarele": "budoar",
    "budoarelor": "budoar",
    "budoarul": "budoar",
    "budoarului": "budoar",
    "bufa": "buf",
    "bufă": "buf",
    "bufe": "buf",
    "bufei": "buf",
    "bufele": "buf",
    "bufelor": "buf",
    "bufi": "buf",
    "bufii": "buf",
    "bufilor": "buf",
    "buful": "buf",
    "bufului": "buf",
    "bufanta": "bufant",
    "bufantă": "bufant",
    "bufante": "bufant",
    "bufantei": "bufant",
    "bufantele": "bufant",
    "bufantelor": "bufant",
    "bufanți": "bufant",
    "bufanții": "bufant",
    "bufanților": "bufant",
    "bufantul": "bufant",
    "bufantului": "bufant",
    "bufete": "bufet",
    "bufetele": "bufet",
    "bufetelor": "bufet",
    "bufetul": "bufet",
    "bufetului": "bufet",
    "bufneala": "bufneală",
    "bufnealo": "bufneală",
    "bufneli": "bufneală",
    "bufnelii": "bufneală",
    "bufnelile": "bufneală",
    "bufnelilor": "bufneală",
    "bufnea": "bufni",
    "bufneai": "bufni",
    "bufneam": "bufni",
    "bufnească": "bufni",
    "bufneați": "bufni",
    "bufneau": "bufni",
    "bufnesc": "bufni",
    "bufnește": "bufni",
    "bufnești": "bufni",
    "bufnii": "bufni",
    "bufnim": "bufni",
    "bufnind": "bufni",
    "bufnindu": "bufni",
    "bufniră": "bufni",
    "bufnirăm": "bufni",
    "bufnirăți": "bufni",
    "bufnise": "bufni",
    "bufnisem": "bufni",
    "bufniseră": "bufni",
    "bufniserăm": "bufni",
    "bufniserăți": "bufni",
    "bufniseși": "bufni",
    "bufniși": "bufni",
    "bufnit": "bufni",
    "bufniți": "bufni",
    "bufnitu": "bufni",
    "nebufnind": "bufni",
    "nebufnindu": "bufni",
    "nemaibufnind": "bufni",
    "nemaibufnindu": "bufni",
    "bufnirea": "bufnire",
    "bufnireo": "bufnire",
    "bufniri": "bufnire",
    "bufnirii": "bufnire",
    "bufnirile": "bufnire",
    "bufnirilor": "bufnire",
    "bufniți": "bufnit",
    "bufniții": "bufnit",
    "bufniților": "bufnit",
    "bufnitul": "bufnit",
    "bufnitului": "bufnit",
    "bufnitura": "bufnitură",
    "bufnituri": "bufnitură",
    "bufniturii": "bufnitură",
    "bufniturile": "bufnitură",
    "bufniturilor": "bufnitură",
    "bufoni": "bufon",
    "bufonii": "bufon",
    "bufonilor": "bufon",
    "bufonul": "bufon",
    "bufonului": "bufon",
    "bugete": "buget",
    "bugetele": "buget",
    "bugetelor": "buget",
    "bugetul": "buget",
    "bugetului": "buget",
    "bugetara": "bugetar",
    "bugetară": "bugetar",
    "bugetare": "bugetar",
    "bugetarei": "bugetar",
    "bugetarele": "bugetar",
    "bugetarelor": "bugetar",
    "bugetari": "bugetar",
    "bugetarii": "bugetar",
    "bugetarilor": "bugetar",
    "bugetarul": "bugetar",
    "bugetarului": "bugetar",
    "buhul": "buh",
    "buhului": "buh",
    "buhuri": "buh",
    "buhurile": "buh",
    "buhurilor": "buh",
    "buhăia": "buhăi",
    "buhăiai": "buhăi",
    "buhăiam": "buhăi",
    "buhăiască": "buhăi",
    "buhăiați": "buhăi",
    "buhăiau": "buhăi",
    "buhăiesc": "buhăi",
    "buhăiește": "buhăi",
    "buhăiești": "buhăi",
    "buhăii": "buhăi",
    "buhăim": "buhăi",
    "buhăind": "buhăi",
    "buhăindu": "buhăi",
    "buhăiră": "buhăi",
    "buhăirăm": "buhăi",
    "buhăirăți": "buhăi",
    "buhăise": "buhăi",
    "buhăisem": "buhăi",
    "buhăiseră": "buhăi",
    "buhăiserăm": "buhăi",
    "buhăiserăți": "buhăi",
    "buhăiseși": "buhăi",
    "buhăiși": "buhăi",
    "buhăit": "buhăi",
    "buhăiți": "buhăi",
    "buhăitu": "buhăi",
    "nebuhăind": "buhăi",
    "nebuhăindu": "buhăi",
    "nemaibuhăind": "buhăi",
    "nemaibuhăindu": "buhăi",
    "buhăiala": "buhăială",
    "buhăialo": "buhăială",
    "buhăieli": "buhăială",
    "buhăielii": "buhăială",
    "buhăielile": "buhăială",
    "buhăielilor": "buhăială",
    "buhăirea": "buhăire",
    "buhăireo": "buhăire",
    "buhăiri": "buhăire",
    "buhăirii": "buhăire",
    "buhăirile": "buhăire",
    "buhăirilor": "buhăire",
    "buhăita": "buhăit",
    "buhăită": "buhăit",
    "buhăite": "buhăit",
    "buhăitei": "buhăit",
    "buhăitele": "buhăit",
    "buhăitelor": "buhăit",
    "buhăiți": "buhăit",
    "buhăiții": "buhăit",
    "buhăiților": "buhăit",
    "buhăito": "buhăit",
    "buhăitul": "buhăit",
    "buhăitule": "buhăit",
    "buhăitului": "buhăit",
    "buhăita": "buhăită",
    "buhăite": "buhăită",
    "buhăitei": "buhăită",
    "buhăitele": "buhăită",
    "buhăitelor": "buhăită",
    "buhăito": "buhăită",
    "buiandrugi": "buiandrug",
    "buiandrugii": "buiandrug",
    "buiandrugilor": "buiandrug",
    "buiandrugul": "buiandrug",
    "buiandrugului": "buiandrug",
    "buiestrași": "buiestraș",
    "buiestrașii": "buiestraș",
    "buiestrașilor": "buiestraș",
    "buiestrașul": "buiestraș",
    "buiestrașului": "buiestraș",
    "buiastra": "buiestru",
    "buiastră": "buiestru",
    "buiestre": "buiestru",
    "buiestrei": "buiestru",
    "buiestrele": "buiestru",
    "buiestrelor": "buiestru",
    "buieștri": "buiestru",
    "buieștrii": "buiestru",
    "buieștrilor": "buiestru",
    "buiestrul": "buiestru",
    "buiestrului": "buiestru",
    "buimaca": "buimac",
    "buimacă": "buimac",
    "buimace": "buimac",
    "buimacei": "buimac",
    "buimacele": "buimac",
    "buimacelor": "buimac",
    "buimaci": "buimac",
    "buimacii": "buimac",
    "buimacilor": "buimac",
    "buimacul": "buimac",
    "buimacului": "buimac",
    "buimăceala": "buimăceală",
    "buimăcealo": "buimăceală",
    "buimăceli": "buimăceală",
    "buimăcelii": "buimăceală",
    "buimăcelile": "buimăceală",
    "buimăcelilor": "buimăceală",
    "buimăcea": "buimăci",
    "buimăceai": "buimăci",
    "buimăceam": "buimăci",
    "buimăcească": "buimăci",
    "buimăceați": "buimăci",
    "buimăceau": "buimăci",
    "buimăcesc": "buimăci",
    "buimăcește": "buimăci",
    "buimăcești": "buimăci",
    "buimăcii": "buimăci",
    "buimăcim": "buimăci",
    "buimăcind": "buimăci",
    "buimăcindu": "buimăci",
    "buimăciră": "buimăci",
    "buimăcirăm": "buimăci",
    "buimăcirăți": "buimăci",
    "buimăcise": "buimăci",
    "buimăcisem": "buimăci",
    "buimăciseră": "buimăci",
    "buimăciserăm": "buimăci",
    "buimăciserăți": "buimăci",
    "buimăciseși": "buimăci",
    "buimăciși": "buimăci",
    "buimăcit": "buimăci",
    "buimăciți": "buimăci",
    "buimăcitu": "buimăci",
    "nebuimăcind": "buimăci",
    "nebuimăcindu": "buimăci",
    "nemaibuimăcind": "buimăci",
    "nemaibuimăcindu": "buimăci",
    "buimăcirea": "buimăcire",
    "buimăcireo": "buimăcire",
    "buimăciri": "buimăcire",
    "buimăcirii": "buimăcire",
    "buimăcirile": "buimăcire",
    "buimăcirilor": "buimăcire",
    "buimăcita": "buimăcit",
    "buimăcită": "buimăcit",
    "buimăcite": "buimăcit",
    "buimăcitei": "buimăcit",
    "buimăcitele": "buimăcit",
    "buimăcitelor": "buimăcit",
    "buimăciți": "buimăcit",
    "buimăciții": "buimăcit",
    "buimăciților": "buimăcit",
    "buimăcito": "buimăcit",
    "buimăcitul": "buimăcit",
    "buimăcitule": "buimăcit",
    "buimăcitului": "buimăcit",
    "bujia": "bujie",
    "bujiei": "bujie",
    "bujii": "bujie",
    "bujiile": "bujie",
    "bujiilor": "bujie",
    "bula": "bulă",
    "bule": "bulă",
    "bulei": "bulă",
    "bulele": "bulă",
    "bulelor": "bulă",
    "bulboana": "bulboană",
    "bulboane": "bulboană",
    "bulboanei": "bulboană",
    "bulboanele": "bulboană",
    "bulboanelor": "bulboană",
    "bulbuci": "bulbuc",
    "bulbucii": "bulbuc",
    "bulbucilor": "bulbuc",
    "bulbucul": "bulbuc",
    "bulbucului": "bulbuc",
    "bulbuc": "bulbuca",
    "bulbucă": "bulbuca",
    "bulbucai": "bulbuca",
    "bulbucam": "bulbuca",
    "bulbucăm": "bulbuca",
    "bulbucând": "bulbuca",
    "bulbucându": "bulbuca",
    "bulbucară": "bulbuca",
    "bulbucarăm": "bulbuca",
    "bulbucarăți": "bulbuca",
    "bulbucase": "bulbuca",
    "bulbucasem": "bulbuca",
    "bulbucaseră": "bulbuca",
    "bulbucaserăm": "bulbuca",
    "bulbucaserăți": "bulbuca",
    "bulbucaseși": "bulbuca",
    "bulbucași": "bulbuca",
    "bulbucat": "bulbuca",
    "bulbucați": "bulbuca",
    "bulbucatu": "bulbuca",
    "bulbucau": "bulbuca",
    "bulbuce": "bulbuca",
    "bulbuci": "bulbuca",
    "nebulbucând": "bulbuca",
    "nebulbucându": "bulbuca",
    "nemaibulbucând": "bulbuca",
    "nemaibulbucându": "bulbuca",
    "bulbucarea": "bulbucare",
    "bulbucări": "bulbucare",
    "bulbucării": "bulbucare",
    "bulbucările": "bulbucare",
    "bulbucata": "bulbucat",
    "bulbucată": "bulbucat",
    "bulbucate": "bulbucat",
    "bulbucatei": "bulbucat",
    "bulbucatele": "bulbucat",
    "bulbucatelor": "bulbucat",
    "bulbucați": "bulbucat",
    "bulbucații": "bulbucat",
    "bulbucaților": "bulbucat",
    "bulbucatul": "bulbucat",
    "bulbucatului": "bulbucat",
    "bulbucata": "bulbucată",
    "bulbucate": "bulbucată",
    "bulbucatei": "bulbucată",
    "bulbucatele": "bulbucată",
    "bulbucatelor": "bulbucată",
    "buldogi": "buldog",
    "buldogii": "buldog",
    "buldogilor": "buldog",
    "buldogul": "buldog",
    "buldogului": "buldog",
    "buldozere": "buldozer",
    "buldozerele": "buldozer",
    "buldozerelor": "buldozer",
    "buldozerul": "buldozer",
    "buldozerului": "buldozer",
    "buletine": "buletin",
    "buletinele": "buletin",
    "buletinelor": "buletin",
    "buletinul": "buletin",
    "buletinului": "buletin",
    "B.I.": "Buletin_de_Identitate",
    "Bd.": "bulevard",
    "bulevarde": "bulevard",
    "bulevardele": "bulevard",
    "bulevardelor": "bulevard",
    "bulevardul": "bulevard",
    "bulevardului": "bulevard",
    "bulevardiera": "bulevardier",
    "bulevardieră": "bulevardier",
    "bulevardiere": "bulevardier",
    "bulevardierei": "bulevardier",
    "bulevardierele": "bulevardier",
    "bulevardierelor": "bulevardier",
    "bulevardieri": "bulevardier",
    "bulevardierii": "bulevardier",
    "bulevardierilor": "bulevardier",
    "bulevardierul": "bulevardier",
    "bulevardierului": "bulevardier",
    "bd.": "bulevardul",
    "b-dul": "bulevardul",
    "bulgara": "bulgar",
    "bulgară": "bulgar",
    "bulgare": "bulgar",
    "bulgarei": "bulgar",
    "bulgarele": "bulgar",
    "bulgarelor": "bulgar",
    "bulgari": "bulgar",
    "bulgarii": "bulgar",
    "bulgarilor": "bulgar",
    "bulgarul": "bulgar",
    "bulgarului": "bulgar",
    "bulgărele": "bulgăre",
    "bulgărelui": "bulgăre",
    "bulgări": "bulgăre",
    "bulgării": "bulgăre",
    "bulgărilor": "bulgăre",
    "Bulgarie": "Bulgaria",
    "Bulgariei": "Bulgaria",
    "Bulgarii": "Bulgaria",
    "bulgăroaica": "bulgăroaică",
    "bulgăroaice": "bulgăroaică",
    "bulgăroaicei": "bulgăroaică",
    "bulgăroaicele": "bulgăroaică",
    "bulgăroaicelor": "bulgăroaică",
    "bulibășeala": "bulibășeală",
    "bulibășeli": "bulibășeală",
    "bulibășelii": "bulibășeală",
    "bulibășelile": "bulibășeală",
    "bulibășelilor": "bulibășeală",
    "buline": "bulin",
    "bulinele": "bulin",
    "bulinelor": "bulin",
    "bulinul": "bulin",
    "bulinului": "bulin",
    "bulionul": "bulion",
    "bulionului": "bulion",
    "buloane": "bulon",
    "buloanele": "bulon",
    "buloanelor": "bulon",
    "bulonul": "bulon",
    "bulonului": "bulon",
    "bulucul": "buluc",
    "bulucului": "buluc",
    "bulucuri": "buluc",
    "bulucurile": "buluc",
    "bulucurilor": "buluc",
    "bulumaci": "bulumac",
    "bulumacii": "bulumac",
    "bulumacilor": "bulumac",
    "bulumacul": "bulumac",
    "bulumacului": "bulumac",
    "bulversă": "bulversa",
    "bulversai": "bulversa",
    "bulversam": "bulversa",
    "bulversăm": "bulversa",
    "bulversând": "bulversa",
    "bulversându": "bulversa",
    "bulversară": "bulversa",
    "bulversarăm": "bulversa",
    "bulversarăți": "bulversa",
    "bulversase": "bulversa",
    "bulversasem": "bulversa",
    "bulversaseră": "bulversa",
    "bulversaserăm": "bulversa",
    "bulversaserăți": "bulversa",
    "bulversaseși": "bulversa",
    "bulversași": "bulversa",
    "bulversat": "bulversa",
    "bulversați": "bulversa",
    "bulversatu": "bulversa",
    "bulversau": "bulversa",
    "bulversează": "bulversa",
    "bulversez": "bulversa",
    "bulverseze": "bulversa",
    "bulversezi": "bulversa",
    "bulversarea": "bulversare",
    "bulversări": "bulversare",
    "bulversării": "bulversare",
    "bulversările": "bulversare",
    "bulversata": "bulversat",
    "bulversată": "bulversat",
    "bulversate": "bulversat",
    "bulversatei": "bulversat",
    "bulversatele": "bulversat",
    "bulversatelor": "bulversat",
    "bulversați": "bulversat",
    "bulversații": "bulversat",
    "bulversaților": "bulversat",
    "bulversatul": "bulversat",
    "bulversatului": "bulversat",
    "bulzi": "bulz",
    "bulzii": "bulz",
    "bulzilor": "bulz",
    "bulzul": "bulz",
    "bulzului": "bulz",
    "bumb.": "bumbac",
    "bumbacul": "bumbac",
    "bumbacului": "bumbac",
    "bumerangul": "bumerang",
    "bumerangului": "bumerang",
    "bumeranguri": "bumerang",
    "bumerangurile": "bumerang",
    "bumerangurilor": "bumerang",
    "buna": "bun",
    "bună": "bun",
    "bune": "bun",
    "bunei": "bun",
    "bunele": "bun",
    "bunelor": "bun",
    "buni": "bun",
    "bunii": "bun",
    "bunilor": "bun",
    "bunul": "bun",
    "bunului": "bun",
    "bunuri": "bun",
    "bunurile": "bun",
    "bunurilor": "bun",
    "buna": "bună",
    "bune": "bună",
    "bunei": "bună",
    "bunele": "bună",
    "bunelor": "bună",
    "buna-credință": "bună-credință",
    "bunei-credințe": "bună-credință",
    "buna-cuviință": "bună-cuviință",
    "bunei-cuviințe": "bună-cuviință",
    "bunăstarea": "bunăstare",
    "bunăstareo": "bunăstare",
    "bunăstări": "bunăstare",
    "bunăstării": "bunăstare",
    "bunăstările": "bunăstare",
    "bunăstărilor": "bunăstare",
    "bunăștiința": "bunăștiință",
    "bunăștiințe": "bunăștiință",
    "bunăștiinței": "bunăștiință",
    "bunăștiințele": "bunăștiință",
    "bunăștiințelor": "bunăștiință",
    "bunătatea": "bunătate",
    "bunătateo": "bunătate",
    "bunătăți": "bunătate",
    "bunătății": "bunătate",
    "bunătățile": "bunătate",
    "bunătăților": "bunătate",
    "bunăvoia": "bunăvoie",
    "bunăvoința": "bunăvoință",
    "bunăvoințe": "bunăvoință",
    "bunăvoinței": "bunăvoință",
    "bunăvoințele": "bunăvoință",
    "bunăvoințelor": "bunăvoință",
    "buncăre": "buncăr",
    "buncărele": "buncăr",
    "buncărelor": "buncăr",
    "buncărul": "buncăr",
    "buncărului": "buncăr",
    "bungândind": "bungândi",
    "bungândit": "bungândi",
    "bungânditoare": "bungânditor",
    "bunul-gust": "bun-gust",
    "bunului-gust": "bun-gust",
    "bunică-": "bunic",
    "bunici": "bunic",
    "bunicii": "bunic",
    "bunicilor": "bunic",
    "bunicul": "bunic",
    "bunicule": "bunic",
    "bunicului": "bunic",
    "bunica": "bunică",
    "bunică-": "bunică",
    "bunice": "bunică",
    "bunici": "bunică",
    "bunicii": "bunică",
    "bunicile": "bunică",
    "bunicilor": "bunică",
    "bunul-plac": "bun-plac",
    "bunului-plac": "bun-plac",
    "bunul-simț": "bun-simț",
    "bunului-simț": "bun-simț",
    "bunuța": "bunuț",
    "bunuță": "bunuț",
    "bunuțe": "bunuț",
    "bunuței": "bunuț",
    "bunuțele": "bunuț",
    "bunuțelor": "bunuț",
    "bunuți": "bunuț",
    "bunuții": "bunuț",
    "bunuților": "bunuț",
    "bunuțul": "bunuț",
    "bunuțului": "bunuț",
    "burdușeala": "burdușeală",
    "burdușeli": "burdușeală",
    "burdușelii": "burdușeală",
    "burdușelile": "burdușeală",
    "burdușea": "burduși",
    "burdușeai": "burduși",
    "burdușeam": "burduși",
    "burdușească": "burduși",
    "burdușeați": "burduși",
    "burdușeau": "burduși",
    "burdușesc": "burduși",
    "burdușește": "burduși",
    "burdușești": "burduși",
    "burdușii": "burduși",
    "burdușim": "burduși",
    "burdușind": "burduși",
    "burdușindu": "burduși",
    "burdușiră": "burduși",
    "burdușirăm": "burduși",
    "burdușirăți": "burduși",
    "burdușise": "burduși",
    "burdușisem": "burduși",
    "burdușiseră": "burduși",
    "burdușiserăm": "burduși",
    "burdușiserăți": "burduși",
    "burdușiseși": "burduși",
    "burdușiși": "burduși",
    "burdușit": "burduși",
    "burdușiți": "burduși",
    "burdușitu": "burduși",
    "neburdușind": "burduși",
    "neburdușindu": "burduși",
    "nemaiburdușind": "burduși",
    "nemaiburdușindu": "burduși",
    "burdușirea": "burdușire",
    "burdușiri": "burdușire",
    "burdușirii": "burdușire",
    "burdușirile": "burdușire",
    "burdușita": "burdușit",
    "burdușită": "burdușit",
    "burdușite": "burdușit",
    "burdușitei": "burdușit",
    "burdușitele": "burdușit",
    "burdușitelor": "burdușit",
    "burdușiți": "burdușit",
    "burdușiții": "burdușit",
    "burdușiților": "burdușit",
    "burdușitul": "burdușit",
    "burdușitului": "burdușit",
    "buretul": "buret",
    "buretului": "buret",
    "buretele": "burete",
    "buretelui": "burete",
    "bureți": "burete",
    "bureții": "burete",
    "bureților": "burete",
    "burgul": "burg",
    "burgului": "burg",
    "burguri": "burg",
    "burgurile": "burg",
    "burgurilor": "burg",
    "burghezi": "burghez",
    "burghezii": "burghez",
    "burghezilor": "burghez",
    "burghezul": "burghez",
    "burghezului": "burghez",
    "burgheza": "burgheză",
    "burgheze": "burgheză",
    "burghezei": "burgheză",
    "burghezele": "burgheză",
    "burghezelor": "burgheză",
    "burghezia": "burghezie",
    "burgheziei": "burghezie",
    "burghezii": "burghezie",
    "burgheziile": "burghezie",
    "burgheziilor": "burghezie",
    "burghezo-democratică": "burghezo-democratic",
    "burghezo-democratice": "burghezo-democratic",
    "burghezo-democratici": "burghezo-democratic",
    "burghezo-moșierească": "burghezo-moșieresc",
    "burghezo-moșierești": "burghezo-moșieresc",
    "burghezo-moșierimea": "burghezo-moșierime",
    "burghezo-moșierimi": "burghezo-moșierime",
    "burghezo-moșierimii": "burghezo-moșierime",
    "burghie": "burghiu",
    "burghiele": "burghiu",
    "burghielor": "burghiu",
    "burghiul": "burghiu",
    "burghiului": "burghiu",
    "burice": "buric",
    "buricele": "buric",
    "buricelor": "buric",
    "buricul": "buric",
    "buricului": "buric",
    "burlaci": "burlac",
    "burlacii": "burlac",
    "burlacilor": "burlac",
    "burlacul": "burlac",
    "burlacului": "burlac",
    "burlane": "burlan",
    "burlanele": "burlan",
    "burlanelor": "burlan",
    "burlanul": "burlan",
    "burlanule": "burlan",
    "burlanului": "burlan",
    "burlesca": "burlesc",
    "burlescul": "burlesc",
    "burlescului": "burlesc",
    "burlești": "burlesc",
    "burleștii": "burlesc",
    "burleștile": "burlesc",
    "burleștilor": "burlesc",
    "burnițai": "burnița",
    "burnițam": "burnița",
    "burnițăm": "burnița",
    "burnițând": "burnița",
    "burnițându": "burnița",
    "burnițară": "burnița",
    "burnițarăm": "burnița",
    "burnițarăți": "burnița",
    "burnițase": "burnița",
    "burnițasem": "burnița",
    "burnițaseră": "burnița",
    "burnițaserăm": "burnița",
    "burnițaserăți": "burnița",
    "burnițaseși": "burnița",
    "burnițași": "burnița",
    "burnițat": "burnița",
    "burnițați": "burnița",
    "burnițatu": "burnița",
    "burnițau": "burnița",
    "burnițe": "burnița",
    "burnițează": "burnița",
    "burnițez": "burnița",
    "burnițeze": "burnița",
    "burnițezi": "burnița",
    "neburnițând": "burnița",
    "neburnițându": "burnița",
    "nemaiburnițând": "burnița",
    "nemaiburnițându": "burnița",
    "burnița": "burniță",
    "burnițe": "burniță",
    "burniței": "burniță",
    "burnițele": "burniță",
    "burnițelor": "burniță",
    "burnițarea": "burnițare",
    "burnițări": "burnițare",
    "burnițării": "burnițare",
    "burnițările": "burnițare",
    "burnițata": "burnițat",
    "burnițată": "burnițat",
    "burnițate": "burnițat",
    "burnițatei": "burnițat",
    "burnițatele": "burnițat",
    "burnițatelor": "burnițat",
    "burnițați": "burnițat",
    "burnițații": "burnițat",
    "burnițaților": "burnițat",
    "burnițatul": "burnițat",
    "burnițatului": "burnițat",
    "bursa": "bursă",
    "burse": "bursă",
    "bursei": "bursă",
    "bursele": "bursă",
    "burselor": "bursă",
    "BVB": "Bursa_de_Valori_București",
    "bursiera": "bursier",
    "bursieră": "bursier",
    "bursiere": "bursier",
    "bursierei": "bursier",
    "bursierele": "bursier",
    "bursierelor": "bursier",
    "bursieri": "bursier",
    "bursierii": "bursier",
    "bursierilor": "bursier",
    "bursierul": "bursier",
    "bursierului": "bursier",
    "bursiera": "bursieră",
    "bursiere": "bursieră",
    "bursierei": "bursieră",
    "bursierele": "bursieră",
    "bursierelor": "bursieră",
    "burta": "burtă",
    "burți": "burtă",
    "burții": "burtă",
    "burțile": "burtă",
    "burților": "burtă",
    "neburtăsimt": "burtăsimți",
    "buruiana": "buruiană",
    "buruiano": "buruiană",
    "buruieni": "buruiană",
    "buruienii": "buruiană",
    "buruienile": "buruiană",
    "buruienilor": "buruiană",
    "burzuluia": "burzului",
    "burzuluiai": "burzului",
    "burzuluiam": "burzului",
    "burzuluiască": "burzului",
    "burzuluiați": "burzului",
    "burzuluiau": "burzului",
    "burzuluiesc": "burzului",
    "burzuluiește": "burzului",
    "burzuluiești": "burzului",
    "burzuluii": "burzului",
    "burzuluim": "burzului",
    "burzuluind": "burzului",
    "burzuluindu": "burzului",
    "burzuluiră": "burzului",
    "burzuluirăm": "burzului",
    "burzuluirăți": "burzului",
    "burzuluise": "burzului",
    "burzuluisem": "burzului",
    "burzuluiseră": "burzului",
    "burzuluiserăm": "burzului",
    "burzuluiserăți": "burzului",
    "burzuluiseși": "burzului",
    "burzuluiși": "burzului",
    "burzuluit": "burzului",
    "burzuluiți": "burzului",
    "burzuluitu": "burzului",
    "neburzuluind": "burzului",
    "neburzuluindu": "burzului",
    "nemaiburzuluind": "burzului",
    "nemaiburzuluindu": "burzului",
    "burzuluiala": "burzuluială",
    "burzuluieli": "burzuluială",
    "burzuluielii": "burzuluială",
    "burzuluielile": "burzuluială",
    "burzuluirea": "burzuluire",
    "burzuluiri": "burzuluire",
    "burzuluirii": "burzuluire",
    "burzuluirile": "burzuluire",
    "burzuluita": "burzuluit",
    "burzuluită": "burzuluit",
    "burzuluite": "burzuluit",
    "burzuluitei": "burzuluit",
    "burzuluitele": "burzuluit",
    "burzuluitelor": "burzuluit",
    "burzuluiți": "burzuluit",
    "burzuluiții": "burzuluit",
    "burzuluiților": "burzuluit",
    "burzuluitul": "burzuluit",
    "burzuluitului": "burzuluit",
    "busculada": "busculadă",
    "busculade": "busculadă",
    "busculadei": "busculadă",
    "busculadele": "busculadă",
    "busculadelor": "busculadă",
    "bușeala": "bușeală",
    "bușealo": "bușeală",
    "bușeli": "bușeală",
    "bușelii": "bușeală",
    "bușelile": "bușeală",
    "bușelilor": "bușeală",
    "bușea": "buși",
    "bușeai": "buși",
    "bușeam": "buși",
    "bușească": "buși",
    "bușeați": "buși",
    "bușeau": "buși",
    "bușesc": "buși",
    "bușește": "buși",
    "bușești": "buși",
    "bușii": "buși",
    "bușim": "buși",
    "bușind": "buși",
    "bușindu": "buși",
    "bușiră": "buși",
    "bușirăm": "buși",
    "bușirăți": "buși",
    "bușise": "buși",
    "bușisem": "buși",
    "bușiseră": "buși",
    "bușiserăm": "buși",
    "bușiserăți": "buși",
    "bușiseși": "buși",
    "bușiși": "buși",
    "bușit": "buși",
    "bușiți": "buși",
    "bușitu": "buși",
    "nebușind": "buși",
    "nebușindu": "buși",
    "nemaibușind": "buși",
    "nemaibușindu": "buși",
    "bușirea": "bușire",
    "bușireo": "bușire",
    "bușiri": "bușire",
    "bușirii": "bușire",
    "bușirile": "bușire",
    "bușirilor": "bușire",
    "bușita": "bușit",
    "bușită": "bușit",
    "bușite": "bușit",
    "bușitei": "bușit",
    "bușitele": "bușit",
    "bușitelor": "bușit",
    "bușiți": "bușit",
    "bușiții": "bușit",
    "bușiților": "bușit",
    "bușito": "bușit",
    "bușitul": "bușit",
    "bușitule": "bușit",
    "bușitului": "bușit",
    "bușitura": "bușitură",
    "bușituri": "bușitură",
    "bușiturii": "bușitură",
    "bușiturile": "bușitură",
    "bușiturilor": "bușitură",
    "busola": "busolă",
    "busole": "busolă",
    "busolei": "busolă",
    "busolele": "busolă",
    "busolelor": "busolă",
    "bușoane": "bușon",
    "bușoanele": "bușon",
    "bușoanelor": "bușon",
    "bușonul": "bușon",
    "bușonului": "bușon",
    "bustul": "bust",
    "bustului": "bust",
    "busturi": "bust",
    "busturile": "bust",
    "busturilor": "bust",
    "bușteanul": "buștean",
    "bușteanului": "buștean",
    "bușteni": "buștean",
    "buștenii": "buștean",
    "buștenilor": "buștean",
    "busuiocul": "busuioc",
    "busuiocului": "busuioc",
    "butada": "butadă",
    "butade": "butadă",
    "butadei": "butadă",
    "butadele": "butadă",
    "butadelor": "butadă",
    "butășită": "butășit",
    "butășite": "butășit",
    "butășiți": "butășit",
    "butelia": "butelie",
    "buteliei": "butelie",
    "butelii": "butelie",
    "buteliile": "butelie",
    "buteliilor": "butelie",
    "butoaie": "butoi",
    "butoaiele": "butoi",
    "butoaielor": "butoi",
    "butoiul": "butoi",
    "butoiului": "butoi",
    "butoane": "buton",
    "butoanele": "buton",
    "butoanelor": "buton",
    "butonul": "buton",
    "butonule": "buton",
    "butonului": "buton",
    "butoniera": "butonieră",
    "butoniere": "butonieră",
    "butonierei": "butonieră",
    "butonierele": "butonieră",
    "butonierelor": "butonieră",
    "butuci": "butuc",
    "butucii": "butuc",
    "butucilor": "butuc",
    "butucul": "butuc",
    "butucului": "butuc",
    "butucănoasa": "butucănos",
    "butucănoasă": "butucănos",
    "butucănoase": "butucănos",
    "butucănoasei": "butucănos",
    "butucănoasele": "butucănos",
    "butucănoaselor": "butucănos",
    "butucănoaso": "butucănos",
    "butucănoși": "butucănos",
    "butucănoșii": "butucănos",
    "butucănoșilor": "butucănos",
    "butucănosul": "butucănos",
    "butucănosule": "butucănos",
    "butucănosului": "butucănos",
    "butura": "butură",
    "buturi": "butură",
    "buturii": "butură",
    "buturile": "butură",
    "buturilor": "butură",
    "buza": "buză",
    "buze": "buză",
    "buzei": "buză",
    "buzele": "buză",
    "buzelor": "buză",
    "buzo": "buză",
    "Buzăul": "Buzău",
    "Buzăului": "Buzău",
    "buzdugane": "buzdugan",
    "buzduganele": "buzdugan",
    "buzduganelor": "buzdugan",
    "buzduganul": "buzdugan",
    "buzduganului": "buzdugan",
    "buzunare": "buzunar",
    "buzunarele": "buzunar",
    "buzunarelor": "buzunar",
    "buzunarul": "buzunar",
    "buzunarule": "buzunar",
    "buzunarului": "buzunar",
    "buzunărea": "buzunări",
    "buzunăreai": "buzunări",
    "buzunăream": "buzunări",
    "buzunărească": "buzunări",
    "buzunăreați": "buzunări",
    "buzunăreau": "buzunări",
    "buzunăresc": "buzunări",
    "buzunărește": "buzunări",
    "buzunărești": "buzunări",
    "buzunării": "buzunări",
    "buzunărim": "buzunări",
    "buzunărind": "buzunări",
    "buzunărindu": "buzunări",
    "buzunăriră": "buzunări",
    "buzunărirăm": "buzunări",
    "buzunărirăți": "buzunări",
    "buzunărise": "buzunări",
    "buzunărisem": "buzunări",
    "buzunăriseră": "buzunări",
    "buzunăriserăm": "buzunări",
    "buzunăriserăți": "buzunări",
    "buzunăriseși": "buzunări",
    "buzunăriși": "buzunări",
    "buzunărit": "buzunări",
    "buzunăriți": "buzunări",
    "buzunăritu": "buzunări",
    "buzunărită": "buzunărit",
    "buzunărite": "buzunărit",
    "buzunăriți": "buzunărit",
    "buzunăritul": "buzunărit",
    "buzunăritului": "buzunărit",
    "c-": "că",
    "cabala": "cabală",
    "cabale": "cabală",
    "cabalei": "cabală",
    "cabalele": "cabală",
    "cabalelor": "cabală",
    "cabalo": "cabală",
    "cabalina": "cabalin",
    "cabalină": "cabalin",
    "cabaline": "cabalin",
    "cabalinei": "cabalin",
    "cabalinele": "cabalin",
    "cabalinelor": "cabalin",
    "cabalina": "cabalină",
    "cabaline": "cabalină",
    "cabalinei": "cabalină",
    "cabalinele": "cabalină",
    "cabalinelor": "cabalină",
    "cabalino": "cabalină",
    "cabalistă": "cabalist",
    "cabaliste": "cabalist",
    "cabalistei": "cabalist",
    "cabalistele": "cabalist",
    "cabalistelor": "cabalist",
    "cabaliști": "cabalist",
    "cabaliștii": "cabalist",
    "cabaliștilor": "cabalist",
    "cabalisto": "cabalist",
    "cabalistul": "cabalist",
    "cabalistule": "cabalist",
    "cabalistului": "cabalist",
    "cabalistica": "cabalistic",
    "cabalistică": "cabalistic",
    "cabalistice": "cabalistic",
    "cabalisticei": "cabalistic",
    "cabalisticele": "cabalistic",
    "cabalisticelor": "cabalistic",
    "cabalistici": "cabalistic",
    "cabalisticii": "cabalistic",
    "cabalisticilor": "cabalistic",
    "cabalistico": "cabalistic",
    "cabalisticul": "cabalistic",
    "cabalisticule": "cabalistic",
    "cabalisticului": "cabalistic",
    "cabana": "cabană",
    "cabane": "cabană",
    "cabanei": "cabană",
    "cabanele": "cabană",
    "cabanelor": "cabană",
    "cabano": "cabană",
    "cabanieri": "cabanier",
    "cabanierii": "cabanier",
    "cabanierilor": "cabanier",
    "cabanierul": "cabanier",
    "cabanierule": "cabanier",
    "cabanierului": "cabanier",
    "cabaniera": "cabanieră",
    "cabaniere": "cabanieră",
    "cabanierei": "cabanieră",
    "cabanierele": "cabanieră",
    "cabanierelor": "cabanieră",
    "cabaniero": "cabanieră",
    "cabanoși": "cabanos",
    "cabanoșii": "cabanos",
    "cabanoșilor": "cabanos",
    "cabanosul": "cabanos",
    "cabanosule": "cabanos",
    "cabanosului": "cabanos",
    "cabarete": "cabaret",
    "cabaretele": "cabaret",
    "cabaretelor": "cabaret",
    "cabaretul": "cabaret",
    "cabaretule": "cabaret",
    "cabaretului": "cabaret",
    "cabestane": "cabestan",
    "cabestanele": "cabestan",
    "cabestanelor": "cabestan",
    "cabestanul": "cabestan",
    "cabestanule": "cabestan",
    "cabestanului": "cabestan",
    "cabina": "cabină",
    "cabine": "cabină",
    "cabinei": "cabină",
    "cabinele": "cabină",
    "cabinelor": "cabină",
    "cabino": "cabină",
    "cab.": "cabinet",
    "cabinete": "cabinet",
    "cabinetele": "cabinet",
    "cabinetelor": "cabinet",
    "cabinetul": "cabinet",
    "cabinetule": "cabinet",
    "cabinetului": "cabinet",
    "cablaje": "cablaj",
    "cablajele": "cablaj",
    "cablajelor": "cablaj",
    "cablajul": "cablaj",
    "cablajule": "cablaj",
    "cablajului": "cablaj",
    "cablograma": "cablogramă",
    "cablograme": "cablogramă",
    "cablogramei": "cablogramă",
    "cablogramele": "cablogramă",
    "cablogramelor": "cablogramă",
    "cablogramo": "cablogramă",
    "cablul": "cablu",
    "cablule": "cablu",
    "cablului": "cablu",
    "cabluri": "cablu",
    "cablurile": "cablu",
    "cablurilor": "cablu",
    "cabotaje": "cabotaj",
    "cabotajele": "cabotaj",
    "cabotajelor": "cabotaj",
    "cabotajul": "cabotaj",
    "cabotajule": "cabotaj",
    "cabotajului": "cabotaj",
    "cabotiere": "cabotier",
    "cabotierele": "cabotier",
    "cabotierelor": "cabotier",
    "cabotierul": "cabotier",
    "cabotierule": "cabotier",
    "cabotierului": "cabotier",
    "cabotini": "cabotin",
    "cabotinii": "cabotin",
    "cabotinilor": "cabotin",
    "cabotinul": "cabotin",
    "cabotinule": "cabotin",
    "cabotinului": "cabotin",
    "cabotina": "cabotină",
    "cabotine": "cabotină",
    "cabotinei": "cabotină",
    "cabotinele": "cabotină",
    "cabotinelor": "cabotină",
    "cabotino": "cabotină",
    "cabotinaje": "cabotinaj",
    "cabotinajele": "cabotinaj",
    "cabotinajelor": "cabotinaj",
    "cabotinajul": "cabotinaj",
    "cabotinajule": "cabotinaj",
    "cabotinajului": "cabotinaj",
    "cabotinisme": "cabotinism",
    "cabotinismele": "cabotinism",
    "cabotinismelor": "cabotinism",
    "cabotinismul": "cabotinism",
    "cabotinismule": "cabotinism",
    "cabotinismului": "cabotinism",
    "cabră": "cabra",
    "cabrai": "cabra",
    "cabram": "cabra",
    "cabrăm": "cabra",
    "cabrând": "cabra",
    "cabrându": "cabra",
    "cabrară": "cabra",
    "cabrarăm": "cabra",
    "cabrarăți": "cabra",
    "cabrase": "cabra",
    "cabrasem": "cabra",
    "cabraseră": "cabra",
    "cabraserăm": "cabra",
    "cabraserăți": "cabra",
    "cabraseși": "cabra",
    "cabrași": "cabra",
    "cabrat": "cabra",
    "cabrați": "cabra",
    "cabratu": "cabra",
    "cabrau": "cabra",
    "cabrează": "cabra",
    "cabrez": "cabra",
    "cabreze": "cabra",
    "cabrezi": "cabra",
    "necabrând": "cabra",
    "necabrându": "cabra",
    "nemaicabrând": "cabra",
    "nemaicabrându": "cabra",
    "cabraje": "cabraj",
    "cabrajele": "cabraj",
    "cabrajelor": "cabraj",
    "cabrajul": "cabraj",
    "cabrajule": "cabraj",
    "cabrajului": "cabraj",
    "cabrarea": "cabrare",
    "cabrareo": "cabrare",
    "cabrări": "cabrare",
    "cabrării": "cabrare",
    "cabrările": "cabrare",
    "cabrărilor": "cabrare",
    "cabrată": "cabrat",
    "cabrate": "cabrat",
    "cabrați": "cabrat",
    "cabrioleta": "cabrioletă",
    "cabriolete": "cabrioletă",
    "cabrioletei": "cabrioletă",
    "cabrioletele": "cabrioletă",
    "cabrioletelor": "cabrioletă",
    "cabrioleto": "cabrioletă",
    "cacealmale": "cacealma",
    "cacealmalei": "cacealma",
    "cacealmalele": "cacealma",
    "cacealmalelor": "cacealma",
    "cacealmao": "cacealma",
    "cacealmaua": "cacealma",
    "căciula": "căciulă",
    "căciuli": "căciulă",
    "căciulii": "căciulă",
    "căciulile": "căciulă",
    "căciulilor": "căciulă",
    "căciulo": "căciulă",
    "căciuleala": "căciuleală",
    "căciulealo": "căciuleală",
    "căciuleli": "căciuleală",
    "căciulelii": "căciuleală",
    "căciulelile": "căciuleală",
    "căciulelilor": "căciuleală",
    "căciulea": "căciuli",
    "căciuleai": "căciuli",
    "căciuleam": "căciuli",
    "căciulească": "căciuli",
    "căciuleați": "căciuli",
    "căciuleau": "căciuli",
    "căciulesc": "căciuli",
    "căciulește": "căciuli",
    "căciulești": "căciuli",
    "căciulii": "căciuli",
    "căciulim": "căciuli",
    "căciulind": "căciuli",
    "căciulindu": "căciuli",
    "căciuliră": "căciuli",
    "căciulirăm": "căciuli",
    "căciulirăți": "căciuli",
    "căciulise": "căciuli",
    "căciulisem": "căciuli",
    "căciuliseră": "căciuli",
    "căciuliserăm": "căciuli",
    "căciuliserăți": "căciuli",
    "căciuliseși": "căciuli",
    "căciuliși": "căciuli",
    "căciulit": "căciuli",
    "căciuliți": "căciuli",
    "căciulitu": "căciuli",
    "necăciulind": "căciuli",
    "necăciulindu": "căciuli",
    "nemaicăciulind": "căciuli",
    "nemaicăciulindu": "căciuli",
    "căciulirea": "căciulire",
    "căciulireo": "căciulire",
    "căciuliri": "căciulire",
    "căciulirii": "căciulire",
    "căciulirile": "căciulire",
    "căciulirilor": "căciulire",
    "căciulită": "căciulit",
    "căciulite": "căciulit",
    "căciuliți": "căciulit",
    "căciulița": "căciuliță",
    "căciulițe": "căciuliță",
    "căciuliței": "căciuliță",
    "căciulițele": "căciuliță",
    "căciulițelor": "căciuliță",
    "căciulițo": "căciuliță",
    "căciuloaie": "căciuloi",
    "căciuloaiele": "căciuloi",
    "căciuloaielor": "căciuloi",
    "căciuloiul": "căciuloi",
    "căciuloiule": "căciuloi",
    "căciuloiului": "căciuloi",
    "cacofonica": "cacofonic",
    "cacofonică": "cacofonic",
    "cacofonice": "cacofonic",
    "cacofonicei": "cacofonic",
    "cacofonicele": "cacofonic",
    "cacofonicelor": "cacofonic",
    "cacofonici": "cacofonic",
    "cacofonicii": "cacofonic",
    "cacofonicilor": "cacofonic",
    "cacofonico": "cacofonic",
    "cacofonicul": "cacofonic",
    "cacofonicule": "cacofonic",
    "cacofonicului": "cacofonic",
    "cacofonia": "cacofonie",
    "cacofoniei": "cacofonie",
    "cacofonii": "cacofonie",
    "cacofoniile": "cacofonie",
    "cacofoniilor": "cacofonie",
    "cacofonio": "cacofonie",
    "cactuși": "cactus",
    "cactușii": "cactus",
    "cactușilor": "cactus",
    "cactusul": "cactus",
    "cactusule": "cactus",
    "cactusului": "cactus",
    "cada": "cadă",
    "cado": "cadă",
    "căzi": "cadă",
    "căzii": "cadă",
    "căzile": "cadă",
    "căzilor": "cadă",
    "cadâna": "cadână",
    "cadâne": "cadână",
    "cadânei": "cadână",
    "cadânele": "cadână",
    "cadânelor": "cadână",
    "cadâno": "cadână",
    "cadastră": "cadastra",
    "cadastrai": "cadastra",
    "cadastram": "cadastra",
    "cadastrăm": "cadastra",
    "cadastrând": "cadastra",
    "cadastrându": "cadastra",
    "cadastrară": "cadastra",
    "cadastrarăm": "cadastra",
    "cadastrarăți": "cadastra",
    "cadastrase": "cadastra",
    "cadastrasem": "cadastra",
    "cadastraseră": "cadastra",
    "cadastraserăm": "cadastra",
    "cadastraserăți": "cadastra",
    "cadastraseși": "cadastra",
    "cadastrași": "cadastra",
    "cadastrat": "cadastra",
    "cadastrați": "cadastra",
    "cadastratu": "cadastra",
    "cadastrau": "cadastra",
    "cadastrează": "cadastra",
    "cadastrez": "cadastra",
    "cadastreze": "cadastra",
    "cadastrezi": "cadastra",
    "necadastrând": "cadastra",
    "necadastrându": "cadastra",
    "nemaicadastrând": "cadastra",
    "nemaicadastrându": "cadastra",
    "cadastrala": "cadastral",
    "cadastrală": "cadastral",
    "cadastrale": "cadastral",
    "cadastralei": "cadastral",
    "cadastralele": "cadastral",
    "cadastralelor": "cadastral",
    "cadastrali": "cadastral",
    "cadastralii": "cadastral",
    "cadastralilor": "cadastral",
    "cadastralo": "cadastral",
    "cadastralul": "cadastral",
    "cadastralule": "cadastral",
    "cadastralului": "cadastral",
    "cadastrarea": "cadastrare",
    "cadastrareo": "cadastrare",
    "cadastrări": "cadastrare",
    "cadastrării": "cadastrare",
    "cadastrările": "cadastrare",
    "cadastrărilor": "cadastrare",
    "cadastrată": "cadastrat",
    "cadastrate": "cadastrat",
    "cadastrați": "cadastrat",
    "cadastrul": "cadastru",
    "cadastrule": "cadastru",
    "cadastrului": "cadastru",
    "cadaverica": "cadaveric",
    "cadaverică": "cadaveric",
    "cadaverice": "cadaveric",
    "cadavericei": "cadaveric",
    "cadavericele": "cadaveric",
    "cadavericelor": "cadaveric",
    "cadaverici": "cadaveric",
    "cadavericii": "cadaveric",
    "cadavericilor": "cadaveric",
    "cadaverico": "cadaveric",
    "cadavericul": "cadaveric",
    "cadavericule": "cadaveric",
    "cadavericului": "cadaveric",
    "cadavre": "cadavru",
    "cadavrele": "cadavru",
    "cadavrelor": "cadavru",
    "cadavrul": "cadavru",
    "cadavrule": "cadavru",
    "cadavrului": "cadavru",
    "cad": "cădea",
    "cadă": "cădea",
    "cade": "cădea",
    "cădeai": "cădea",
    "cădeam": "cădea",
    "cădeați": "cădea",
    "cădeau": "cădea",
    "cădem": "cădea",
    "cădeți": "cădea",
    "căzând": "cădea",
    "căzându": "cădea",
    "cazi": "cădea",
    "căzu": "cădea",
    "căzui": "cădea",
    "căzură": "cădea",
    "căzurăm": "cădea",
    "căzurăți": "cădea",
    "căzuse": "cădea",
    "căzusem": "cădea",
    "căzuseră": "cădea",
    "căzuserăm": "cădea",
    "căzuserăți": "cădea",
    "căzuseși": "cădea",
    "căzuși": "cădea",
    "căzut": "cădea",
    "căzutu": "cădea",
    "necăzând": "cădea",
    "necăzându": "cădea",
    "nemaicăzând": "cădea",
    "nemaicăzându": "cădea",
    "cădelniță": "cădelnița",
    "cădelnițai": "cădelnița",
    "cădelnițam": "cădelnița",
    "cădelnițăm": "cădelnița",
    "cădelnițând": "cădelnița",
    "cădelnițându": "cădelnița",
    "cădelnițară": "cădelnița",
    "cădelnițarăm": "cădelnița",
    "cădelnițarăți": "cădelnița",
    "cădelnițase": "cădelnița",
    "cădelnițasem": "cădelnița",
    "cădelnițaseră": "cădelnița",
    "cădelnițaserăm": "cădelnița",
    "cădelnițaserăți": "cădelnița",
    "cădelnițaseși": "cădelnița",
    "cădelnițași": "cădelnița",
    "cădelnițat": "cădelnița",
    "cădelnițați": "cădelnița",
    "cădelnițatu": "cădelnița",
    "cădelnițau": "cădelnița",
    "cădelnițează": "cădelnița",
    "cădelnițez": "cădelnița",
    "cădelnițeze": "cădelnița",
    "cădelnițezi": "cădelnița",
    "necădelnițând": "cădelnița",
    "necădelnițându": "cădelnița",
    "nemaicădelnițând": "cădelnița",
    "nemaicădelnițându": "cădelnița",
    "cădelnița": "cădelniță",
    "cădelnițe": "cădelniță",
    "cădelniței": "cădelniță",
    "cădelnițele": "cădelniță",
    "cădelnițelor": "cădelniță",
    "cădelnițo": "cădelniță",
    "cădelnițată": "cădelnițat",
    "cădelnițate": "cădelnițat",
    "cădelnițați": "cădelnițat",
    "cadență": "cadența",
    "cadențai": "cadența",
    "cadențam": "cadența",
    "cadențăm": "cadența",
    "cadențând": "cadența",
    "cadențându": "cadența",
    "cadențară": "cadența",
    "cadențarăm": "cadența",
    "cadențarăți": "cadența",
    "cadențase": "cadența",
    "cadențasem": "cadența",
    "cadențaseră": "cadența",
    "cadențaserăm": "cadența",
    "cadențaserăți": "cadența",
    "cadențaseși": "cadența",
    "cadențași": "cadența",
    "cadențat": "cadența",
    "cadențați": "cadența",
    "cadențatu": "cadența",
    "cadențau": "cadența",
    "cadențează": "cadența",
    "cadențez": "cadența",
    "cadențeze": "cadența",
    "cadențezi": "cadența",
    "necadențând": "cadența",
    "necadențându": "cadența",
    "nemaicadențând": "cadența",
    "nemaicadențându": "cadența",
    "cadența": "cadență",
    "cadențe": "cadență",
    "cadenței": "cadență",
    "cadențele": "cadență",
    "cadențelor": "cadență",
    "cadențo": "cadență",
    "cadențata": "cadențat",
    "cadențată": "cadențat",
    "cadențate": "cadențat",
    "cadențatei": "cadențat",
    "cadențatele": "cadențat",
    "cadențatelor": "cadențat",
    "cadențați": "cadențat",
    "cadențații": "cadențat",
    "cadențaților": "cadențat",
    "cadențato": "cadențat",
    "cadențatul": "cadențat",
    "cadențatule": "cadențat",
    "cadențatului": "cadențat",
    "căderea": "cădere",
    "cădereo": "cădere",
    "căderi": "cădere",
    "căderii": "cădere",
    "căderile": "cădere",
    "căderilor": "cădere",
    "cadeți": "cadet",
    "cadeții": "cadet",
    "cadeților": "cadet",
    "cadetul": "cadet",
    "cadetule": "cadet",
    "cadetului": "cadet",
    "cadii": "cadiu",
    "cadiii": "cadiu",
    "cadiilor": "cadiu",
    "cadiul": "cadiu",
    "cadiule": "cadiu",
    "cadiului": "cadiu",
    "cadmiai": "cadmia",
    "cadmiam": "cadmia",
    "cadmiară": "cadmia",
    "cadmiarăm": "cadmia",
    "cadmiarăți": "cadmia",
    "cadmiase": "cadmia",
    "cadmiasem": "cadmia",
    "cadmiaseră": "cadmia",
    "cadmiaserăm": "cadmia",
    "cadmiaserăți": "cadmia",
    "cadmiaseși": "cadmia",
    "cadmiași": "cadmia",
    "cadmiat": "cadmia",
    "cadmiați": "cadmia",
    "cadmiatu": "cadmia",
    "cadmiau": "cadmia",
    "cadmiază": "cadmia",
    "cadmie": "cadmia",
    "cadmiem": "cadmia",
    "cadmiez": "cadmia",
    "cadmieze": "cadmia",
    "cadmiezi": "cadmia",
    "cadmiind": "cadmia",
    "cadmiindu": "cadmia",
    "necadmiind": "cadmia",
    "necadmiindu": "cadmia",
    "nemaicadmiind": "cadmia",
    "nemaicadmiindu": "cadmia",
    "cadmiată": "cadmiat",
    "cadmiate": "cadmiat",
    "cadmiați": "cadmiat",
    "cadmierea": "cadmiere",
    "cadmiereo": "cadmiere",
    "cadmieri": "cadmiere",
    "cadmierii": "cadmiere",
    "cadmierile": "cadmiere",
    "cadmierilor": "cadmiere",
    "cadmiul": "cadmiu",
    "cadmiule": "cadmiu",
    "cadmiului": "cadmiu",
    "Cd": "cadmiu",
    "cadoul": "cadou",
    "cadoule": "cadou",
    "cadoului": "cadou",
    "cadouri": "cadou",
    "cadourile": "cadou",
    "cadourilor": "cadou",
    "cadră": "cadra",
    "cadrai": "cadra",
    "cadram": "cadra",
    "cadrăm": "cadra",
    "cadrând": "cadra",
    "cadrându": "cadra",
    "cadrară": "cadra",
    "cadrarăm": "cadra",
    "cadrarăți": "cadra",
    "cadrase": "cadra",
    "cadrasem": "cadra",
    "cadraseră": "cadra",
    "cadraserăm": "cadra",
    "cadraserăți": "cadra",
    "cadraseși": "cadra",
    "cadrași": "cadra",
    "cadrat": "cadra",
    "cadrați": "cadra",
    "cadratu": "cadra",
    "cadrau": "cadra",
    "cadrează": "cadra",
    "cadrez": "cadra",
    "cadreze": "cadra",
    "cadrezi": "cadra",
    "necadrând": "cadra",
    "necadrându": "cadra",
    "nemaicadrând": "cadra",
    "nemaicadrându": "cadra",
    "cadrane": "cadran",
    "cadranele": "cadran",
    "cadranelor": "cadran",
    "cadranul": "cadran",
    "cadranule": "cadran",
    "cadranului": "cadran",
    "cadrată": "cadrat",
    "cadrate": "cadrat",
    "cadrați": "cadrat",
    "cadrilul": "cadril",
    "cadrilule": "cadril",
    "cadrilului": "cadril",
    "cadriluri": "cadril",
    "cadrilurile": "cadril",
    "cadrilurilor": "cadril",
    "cadrilata": "cadrilat",
    "cadrilată": "cadrilat",
    "cadrilate": "cadrilat",
    "cadrilatei": "cadrilat",
    "cadrilatele": "cadrilat",
    "cadrilatelor": "cadrilat",
    "cadrilați": "cadrilat",
    "cadrilații": "cadrilat",
    "cadrilaților": "cadrilat",
    "cadrilato": "cadrilat",
    "cadrilatul": "cadrilat",
    "cadrilatule": "cadrilat",
    "cadrilatului": "cadrilat",
    "cadre": "cadru",
    "cadrele": "cadru",
    "cadrelor": "cadru",
    "cadrul": "cadru",
    "cadrule": "cadru",
    "cadrului": "cadru",
    "caduca": "caduc",
    "caducă": "caduc",
    "caduce": "caduc",
    "caducei": "caduc",
    "caducele": "caduc",
    "caducelor": "caduc",
    "caduci": "caduc",
    "caducii": "caduc",
    "caducilor": "caduc",
    "caduco": "caduc",
    "caducul": "caduc",
    "caducule": "caduc",
    "caducului": "caduc",
    "caducitatea": "caducitate",
    "caducitateo": "caducitate",
    "caducități": "caducitate",
    "caducității": "caducitate",
    "caducitățile": "caducitate",
    "caducităților": "caducitate",
    "cafeao": "cafea",
    "cafeaua": "cafea",
    "cafele": "cafea",
    "cafelei": "cafea",
    "cafelele": "cafea",
    "cafelelor": "cafea",
    "cafegioaica": "cafegioaică",
    "cafegioaice": "cafegioaică",
    "cafegioaicei": "cafegioaică",
    "cafegioaicele": "cafegioaică",
    "cafegioaicelor": "cafegioaică",
    "cafegioaico": "cafegioaică",
    "cafegii": "cafegiu",
    "cafegiii": "cafegiu",
    "cafegiilor": "cafegiu",
    "cafegiul": "cafegiu",
    "cafegiule": "cafegiu",
    "cafegiului": "cafegiu",
    "cafeina": "cafeină",
    "cafeine": "cafeină",
    "cafeinei": "cafeină",
    "cafeinele": "cafeină",
    "cafeinelor": "cafeină",
    "cafeino": "cafeină",
    "cafeluța": "cafeluță",
    "cafeluțe": "cafeluță",
    "cafeluței": "cafeluță",
    "cafeluțele": "cafeluță",
    "cafeluțelor": "cafeluță",
    "cafeluțo": "cafeluță",
    "cafeneao": "cafenea",
    "cafeneaua": "cafenea",
    "cafenele": "cafenea",
    "cafenelei": "cafenea",
    "cafenelele": "cafenea",
    "cafenelelor": "cafenea",
    "cafenie": "cafeniu",
    "cafenii": "cafeniu",
    "caftane": "caftan",
    "caftanele": "caftan",
    "caftanelor": "caftan",
    "caftanul": "caftan",
    "caftanule": "caftan",
    "caftanului": "caftan",
    "căftănele": "căftănel",
    "căftănelele": "căftănel",
    "căftănelelor": "căftănel",
    "căftănelul": "căftănel",
    "căftănelule": "căftănel",
    "căftănelului": "căftănel",
    "cagula": "cagulă",
    "cagule": "cagulă",
    "cagulei": "cagulă",
    "cagulele": "cagulă",
    "cagulelor": "cagulă",
    "cagulo": "cagulă",
    "cahla": "cahlă",
    "cahle": "cahlă",
    "cahlei": "cahlă",
    "cahlele": "cahlă",
    "cahlelor": "cahlă",
    "cahlo": "cahlă",
    "căia": "căi",
    "căiai": "căi",
    "căiam": "căi",
    "căiască": "căi",
    "căiați": "căi",
    "căiau": "căi",
    "căiesc": "căi",
    "căiește": "căi",
    "căiești": "căi",
    "căii": "căi",
    "căim": "căi",
    "căind": "căi",
    "căindu": "căi",
    "căiră": "căi",
    "căirăm": "căi",
    "căirăți": "căi",
    "căise": "căi",
    "căisem": "căi",
    "căiseră": "căi",
    "căiserăm": "căi",
    "căiserăți": "căi",
    "căiseși": "căi",
    "căiși": "căi",
    "căit": "căi",
    "căiți": "căi",
    "căitu": "căi",
    "necăind": "căi",
    "necăindu": "căi",
    "nemaicăind": "căi",
    "nemaicăindu": "căi",
    "caiao": "caia",
    "caiaua": "caia",
    "caiele": "caia",
    "caielei": "caia",
    "caielele": "caia",
    "caielelor": "caia",
    "caiace": "caiac",
    "caiacele": "caiac",
    "caiacelor": "caiac",
    "caiacul": "caiac",
    "caiacule": "caiac",
    "caiacului": "caiac",
    "caiafa": "caiafă",
    "caiafe": "caiafă",
    "caiafei": "caiafă",
    "caiafele": "caiafă",
    "caiafelor": "caiafă",
    "caiafo": "caiafă",
    "caice": "caic",
    "caicele": "caic",
    "caicelor": "caic",
    "caicul": "caic",
    "caicule": "caic",
    "caicului": "caic",
    "caiere": "caier",
    "caierele": "caier",
    "caierelor": "caier",
    "caierul": "caier",
    "caierule": "caier",
    "caierului": "caier",
    "caiete": "caiet",
    "caietele": "caiet",
    "caietelor": "caiet",
    "caietul": "caiet",
    "caietule": "caiet",
    "caietului": "caiet",
    "caiețele": "caiețel",
    "caiețelele": "caiețel",
    "caiețelelor": "caiețel",
    "caiețelul": "caiețel",
    "caiețelule": "caiețel",
    "caiețelului": "caiețel",
    "C.F.R.": "Căile_Ferate_Române",
    "Căilor_Ferate_Române": "Căile_Ferate_Române",
    "CFR": "Căile_Ferate_Române",
    "caimacul": "caimac",
    "caimacule": "caimac",
    "caimacului": "caimac",
    "caimacuri": "caimac",
    "caimacurile": "caimac",
    "caimacurilor": "caimac",
    "caimacami": "caimacam",
    "caimacamii": "caimacam",
    "caimacamilor": "caimacam",
    "caimacamul": "caimacam",
    "caimacamule": "caimacam",
    "caimacamului": "caimacam",
    "căimăcămia": "căimăcămie",
    "căimăcămiei": "căimăcămie",
    "căimăcămii": "căimăcămie",
    "căimăcămiile": "căimăcămie",
    "căimăcămiilor": "căimăcămie",
    "căimăcămio": "căimăcămie",
    "caimani": "caiman",
    "caimanii": "caiman",
    "caimanilor": "caiman",
    "caimanul": "caiman",
    "caimanule": "caiman",
    "caimanului": "caiman",
    "căină": "căina",
    "căinai": "căina",
    "căinam": "căina",
    "căinăm": "căina",
    "căinând": "căina",
    "căinându": "căina",
    "căinară": "căina",
    "căinarăm": "căina",
    "căinarăți": "căina",
    "căinase": "căina",
    "căinasem": "căina",
    "căinaseră": "căina",
    "căinaserăm": "căina",
    "căinaserăți": "căina",
    "căinaseși": "căina",
    "căinași": "căina",
    "căinat": "căina",
    "căinați": "căina",
    "căinatu": "căina",
    "căinau": "căina",
    "căinează": "căina",
    "căinez": "căina",
    "căineze": "căina",
    "căinezi": "căina",
    "necăinând": "căina",
    "necăinându": "căina",
    "nemaicăinând": "căina",
    "nemaicăinându": "căina",
    "căinarea": "căinare",
    "căinareo": "căinare",
    "căinări": "căinare",
    "căinării": "căinare",
    "căinările": "căinare",
    "căinărilor": "căinare",
    "căinată": "căinat",
    "căinate": "căinat",
    "căinați": "căinat",
    "câinele": "câine",
    "câinelui": "câine",
    "câini": "câine",
    "câinii": "câine",
    "câinilor": "câine",
    "câini-de-mare": "câine-de-mare",
    "câineasca": "câinesc",
    "câinească": "câinesc",
    "câineasco": "câinesc",
    "câinescul": "câinesc",
    "câinescule": "câinesc",
    "câinescului": "câinesc",
    "câinești": "câinesc",
    "câineștii": "câinesc",
    "câineștile": "câinesc",
    "câineștilor": "câinesc",
    "câinoșenia": "câinoșenie",
    "câinoșeniei": "câinoșenie",
    "câinoșenii": "câinoșenie",
    "câinoșeniile": "câinoșenie",
    "câinoșeniilor": "câinoșenie",
    "câinoșenio": "câinoșenie",
    "cainozoica": "cainozoic",
    "cainozoică": "cainozoic",
    "cainozoice": "cainozoic",
    "cainozoicei": "cainozoic",
    "cainozoicele": "cainozoic",
    "cainozoicelor": "cainozoic",
    "cainozoici": "cainozoic",
    "cainozoicii": "cainozoic",
    "cainozoicilor": "cainozoic",
    "cainozoico": "cainozoic",
    "cainozoicul": "cainozoic",
    "cainozoicule": "cainozoic",
    "cainozoicului": "cainozoic",
    "căința": "căință",
    "căințe": "căință",
    "căinței": "căință",
    "căințele": "căință",
    "căințelor": "căință",
    "căințo": "căință",
    "caiși": "cais",
    "caișii": "cais",
    "caișilor": "cais",
    "caisul": "cais",
    "caisule": "cais",
    "caisului": "cais",
    "caisa": "caisă",
    "caise": "caisă",
    "caisei": "caisă",
    "caisele": "caisă",
    "caiselor": "caisă",
    "caiso": "caisă",
    "căită": "căit",
    "căite": "căit",
    "căiți": "căit",
    "cai": "cal",
    "caii": "cal",
    "cailor": "cal",
    "calul": "cal",
    "calule": "cal",
    "calului": "cal",
    "CP": "Cal_Putere",
    "cală": "cala",
    "calai": "cala",
    "calam": "cala",
    "calăm": "cala",
    "calând": "cala",
    "calându": "cala",
    "calară": "cala",
    "calarăm": "cala",
    "calarăți": "cala",
    "calase": "cala",
    "calasem": "cala",
    "calaseră": "cala",
    "calaserăm": "cala",
    "calaserăți": "cala",
    "calaseși": "cala",
    "calași": "cala",
    "calat": "cala",
    "calați": "cala",
    "calatu": "cala",
    "calau": "cala",
    "calează": "cala",
    "calez": "cala",
    "caleze": "cala",
    "calezi": "cala",
    "necalând": "cala",
    "necalându": "cala",
    "nemaicalând": "cala",
    "nemaicalându": "cala",
    "cala": "cală",
    "cale": "cală",
    "calei": "cală",
    "calele": "cală",
    "calelor": "cală",
    "calo": "cală",
    "calabalâcul": "calabalâc",
    "calabalâcule": "calabalâc",
    "calabalâcului": "calabalâc",
    "calabalâcuri": "calabalâc",
    "calabalâcurile": "calabalâc",
    "calabalâcurilor": "calabalâc",
    "calafatul": "calafat",
    "calafatule": "calafat",
    "calafatului": "calafat",
    "calafaturi": "calafat",
    "calafaturile": "calafat",
    "calafaturilor": "calafat",
    "călăfătuia": "călăfătui",
    "călăfătuiai": "călăfătui",
    "călăfătuiam": "călăfătui",
    "călăfătuiască": "călăfătui",
    "călăfătuiați": "călăfătui",
    "călăfătuiau": "călăfătui",
    "călăfătuiesc": "călăfătui",
    "călăfătuiește": "călăfătui",
    "călăfătuiești": "călăfătui",
    "călăfătuii": "călăfătui",
    "călăfătuim": "călăfătui",
    "călăfătuind": "călăfătui",
    "călăfătuindu": "călăfătui",
    "călăfătuiră": "călăfătui",
    "călăfătuirăm": "călăfătui",
    "călăfătuirăți": "călăfătui",
    "călăfătuise": "călăfătui",
    "călăfătuisem": "călăfătui",
    "călăfătuiseră": "călăfătui",
    "călăfătuiserăm": "călăfătui",
    "călăfătuiserăți": "călăfătui",
    "călăfătuiseși": "călăfătui",
    "călăfătuiși": "călăfătui",
    "călăfătuit": "călăfătui",
    "călăfătuiți": "călăfătui",
    "călăfătuitu": "călăfătui",
    "necălăfătuind": "călăfătui",
    "necălăfătuindu": "călăfătui",
    "nemaicălăfătuind": "călăfătui",
    "nemaicălăfătuindu": "călăfătui",
    "călăfătuită": "călăfătuit",
    "călăfătuite": "călăfătuit",
    "călăfătuiți": "călăfătuit",
    "calaicanul": "calaican",
    "calaicanule": "calaican",
    "calaicanului": "calaican",
    "calaje": "calaj",
    "calajele": "calaj",
    "calajelor": "calaj",
    "calajul": "calaj",
    "calajule": "calaj",
    "calajului": "calaj",
    "calamburul": "calambur",
    "calamburule": "calambur",
    "calamburului": "calambur",
    "calambururi": "calambur",
    "calambururile": "calambur",
    "calambururilor": "calambur",
    "calamina": "calamină",
    "calamine": "calamină",
    "calaminei": "calamină",
    "calaminele": "calamină",
    "calaminelor": "calamină",
    "calamino": "calamină",
    "calamitatea": "calamitate",
    "calamitateo": "calamitate",
    "calamități": "calamitate",
    "calamității": "calamitate",
    "calamitățile": "calamitate",
    "calamităților": "calamitate",
    "calandre": "calandru",
    "calandrele": "calandru",
    "calandrelor": "calandru",
    "calandrul": "calandru",
    "calandrule": "calandru",
    "calandrului": "calandru",
    "calapoade": "calapod",
    "calapoadele": "calapod",
    "calapoadelor": "calapod",
    "calapodul": "calapod",
    "calapodule": "calapod",
    "calapodului": "calapod",
    "călărași": "călăraș",
    "călărașii": "călăraș",
    "călărașilor": "călăraș",
    "călărașul": "călăraș",
    "călărașule": "călăraș",
    "călărașului": "călăraș",
    "călăreața": "călăreață",
    "călăreațo": "călăreață",
    "călărețe": "călăreață",
    "călăreței": "călăreață",
    "călărețele": "călăreață",
    "călărețelor": "călăreață",
    "călăreți": "călăreț",
    "călăreții": "călăreț",
    "călăreților": "călăreț",
    "călărețul": "călăreț",
    "călărețule": "călăreț",
    "călărețului": "călăreț",
    "călărea": "călări",
    "călăreai": "călări",
    "călăream": "călări",
    "călărească": "călări",
    "călăreați": "călări",
    "călăreau": "călări",
    "călăresc": "călări",
    "călărește": "călări",
    "călărești": "călări",
    "călării": "călări",
    "călărim": "călări",
    "călărind": "călări",
    "călărindu": "călări",
    "călăriră": "călări",
    "călărirăm": "călări",
    "călărirăți": "călări",
    "călărise": "călări",
    "călărisem": "călări",
    "călăriseră": "călări",
    "călăriserăm": "călări",
    "călăriserăți": "călări",
    "călăriseși": "călări",
    "călăriși": "călări",
    "călărit": "călări",
    "călăriți": "călări",
    "călăritu": "călări",
    "necălărind": "călări",
    "necălărindu": "călări",
    "nemaicălărind": "călări",
    "nemaicălărindu": "călări",
    "călăria": "călărie",
    "călăriei": "călărie",
    "călării": "călărie",
    "călărio": "călărie",
    "călărimea": "călărime",
    "călărimeo": "călărime",
    "călărimi": "călărime",
    "călărimii": "călărime",
    "călărimile": "călărime",
    "călărimilor": "călărime",
    "călărită": "călărit",
    "călărite": "călărit",
    "călăriți": "călărit",
    "calată": "calat",
    "calate": "calat",
    "calați": "calat",
    "călătoarea": "călătoare",
    "călătoarei": "călătoare",
    "călătoarele": "călătoare",
    "călătoarelor": "călătoare",
    "călătoareo": "călătoare",
    "călătoare": "călător",
    "călătoarea": "călător",
    "călătoarei": "călător",
    "călătoarele": "călător",
    "călătoarelor": "călător",
    "călătoareo": "călător",
    "călători": "călător",
    "călătorii": "călător",
    "călătorilor": "călător",
    "călătorul": "călător",
    "călătorule": "călător",
    "călătorului": "călător",
    "călăuzitori": "călător",
    "călătorea": "călători",
    "călătoreai": "călători",
    "călătoream": "călători",
    "călătorească": "călători",
    "călătoreați": "călători",
    "călătoreau": "călători",
    "călătoresc": "călători",
    "călătorește": "călători",
    "călătorești": "călători",
    "călătorii": "călători",
    "călătorim": "călători",
    "călătorind": "călători",
    "călătorindu": "călători",
    "călătoriră": "călători",
    "călătorirăm": "călători",
    "călătorirăți": "călători",
    "călătorise": "călători",
    "călătorisem": "călători",
    "călătoriseră": "călători",
    "călătoriserăm": "călători",
    "călătoriserăți": "călători",
    "călătoriseși": "călători",
    "călătoriși": "călători",
    "călătorit": "călători",
    "călătoriți": "călători",
    "călătoritu": "călători",
    "necălătorind": "călători",
    "necălătorindu": "călători",
    "nemaicălătorind": "călători",
    "nemaicălătorindu": "călători",
    "călătoria": "călătorie",
    "călătoriei": "călătorie",
    "călătorii": "călătorie",
    "călătoriile": "călătorie",
    "călătoriilor": "călătorie",
    "călătorio": "călătorie",
    "călătorita": "călătorit",
    "călătorită": "călătorit",
    "călătorite": "călătorit",
    "călătoritei": "călătorit",
    "călătoritele": "călătorit",
    "călătoritelor": "călătorit",
    "călătoriți": "călătorit",
    "călătoriții": "călătorit",
    "călătoriților": "călătorit",
    "călătorito": "călătorit",
    "călătoritul": "călătorit",
    "călătoritule": "călătorit",
    "călătoritului": "călătorit",
    "călăi": "călău",
    "călăii": "călău",
    "călăilor": "călău",
    "călăul": "călău",
    "călăule": "călău",
    "călăului": "călău",
    "călăuza": "călăuză",
    "călăuze": "călăuză",
    "călăuzei": "călăuză",
    "călăuzele": "călăuză",
    "călăuzelor": "călăuză",
    "călăuzo": "călăuză",
    "călăuzea": "călăuzi",
    "călăuzeai": "călăuzi",
    "călăuzeam": "călăuzi",
    "călăuzească": "călăuzi",
    "călăuzeați": "călăuzi",
    "călăuzeau": "călăuzi",
    "călăuzesc": "călăuzi",
    "călăuzește": "călăuzi",
    "călăuzești": "călăuzi",
    "călăuzii": "călăuzi",
    "călăuzim": "călăuzi",
    "călăuzind": "călăuzi",
    "călăuzindu": "călăuzi",
    "călăuziră": "călăuzi",
    "călăuzirăm": "călăuzi",
    "călăuzirăți": "călăuzi",
    "călăuzise": "călăuzi",
    "călăuzisem": "călăuzi",
    "călăuziseră": "călăuzi",
    "călăuziserăm": "călăuzi",
    "călăuziserăți": "călăuzi",
    "călăuziseși": "călăuzi",
    "călăuziși": "călăuzi",
    "călăuzit": "călăuzi",
    "călăuziți": "călăuzi",
    "călăuzitu": "călăuzi",
    "necălăuzind": "călăuzi",
    "necălăuzindu": "călăuzi",
    "nemaicălăuzind": "călăuzi",
    "nemaicălăuzindu": "călăuzi",
    "călăuzirea": "călăuzire",
    "călăuzireo": "călăuzire",
    "călăuziri": "călăuzire",
    "călăuzirii": "călăuzire",
    "călăuzirile": "călăuzire",
    "călăuzirilor": "călăuzire",
    "călăuzita": "călăuzit",
    "călăuzită": "călăuzit",
    "călăuzite": "călăuzit",
    "călăuzitei": "călăuzit",
    "călăuzitele": "călăuzit",
    "călăuzitelor": "călăuzit",
    "călăuziți": "călăuzit",
    "călăuziții": "călăuzit",
    "călăuziților": "călăuzit",
    "călăuzito": "călăuzit",
    "călăuzitul": "călăuzit",
    "călăuzitule": "călăuzit",
    "călăuzitului": "călăuzit",
    "călăuzitoarea": "călăuzitoare",
    "călăuzitoarei": "călăuzitoare",
    "călăuzitoarele": "călăuzitoare",
    "călăuzitoarelor": "călăuzitoare",
    "călăuzitoareo": "călăuzitoare",
    "călăuzitoare": "călăuzitor",
    "călăuzitoarea": "călăuzitor",
    "călăuzitoarei": "călăuzitor",
    "călăuzitoarele": "călăuzitor",
    "călăuzitoarelor": "călăuzitor",
    "călăuzitoareo": "călăuzitor",
    "călăuzitorii": "călăuzitor",
    "călăuzitorilor": "călăuzitor",
    "călăuzitorul": "călăuzitor",
    "călăuzitorule": "călăuzitor",
    "călăuzitorului": "călăuzitor",
    "calcul": "calc",
    "calcului": "calc",
    "calcuri": "calc",
    "calcurile": "calc",
    "calcurilor": "calc",
    "calc": "călca",
    "calcă": "călca",
    "călcă": "călca",
    "călcai": "călca",
    "călcam": "călca",
    "călcăm": "călca",
    "călcând": "călca",
    "călcându": "călca",
    "călcară": "călca",
    "călcarăm": "călca",
    "călcarăți": "călca",
    "călcase": "călca",
    "călcasem": "călca",
    "călcaseră": "călca",
    "călcaserăm": "călca",
    "călcaserăți": "călca",
    "călcaseși": "călca",
    "călcași": "călca",
    "călcat": "călca",
    "călcați": "călca",
    "călcatu": "călca",
    "călcau": "călca",
    "calce": "călca",
    "calci": "călca",
    "necălcând": "călca",
    "necălcându": "călca",
    "nemaicălcând": "călca",
    "nemaicălcându": "călca",
    "călcâie": "călcâi",
    "călcâiele": "călcâi",
    "călcâielor": "călcâi",
    "călcâiul": "călcâi",
    "călcâiule": "călcâi",
    "călcâiului": "călcâi",
    "călcâiașe": "călcâiaș",
    "călcâiașele": "călcâiaș",
    "călcâiașelor": "călcâiaș",
    "călcâiașul": "călcâiaș",
    "călcâiașule": "călcâiaș",
    "călcâiașului": "călcâiaș",
    "calcani": "calcan",
    "calcanii": "calcan",
    "calcanilor": "calcan",
    "calcanul": "calcan",
    "calcanule": "calcan",
    "calcanului": "calcan",
    "calcanee": "calcaneu",
    "calcaneele": "calcaneu",
    "calcaneelor": "calcaneu",
    "calcaneul": "calcaneu",
    "calcaneule": "calcaneu",
    "calcaneului": "calcaneu",
    "calcare": "calcar",
    "calcarele": "calcar",
    "calcarelor": "calcar",
    "calcarul": "calcar",
    "calcarule": "calcar",
    "calcarului": "calcar",
    "călcarea": "călcare",
    "călcareo": "călcare",
    "călcări": "călcare",
    "călcării": "călcare",
    "călcările": "călcare",
    "călcărilor": "călcare",
    "călcată": "călcat",
    "călcate": "călcat",
    "călcați": "călcat",
    "călcatul": "călcat",
    "călcatule": "călcat",
    "călcatului": "călcat",
    "călcătoarea": "călcătoare",
    "călcătoarei": "călcătoare",
    "călcătoarele": "călcătoare",
    "călcătoarelor": "călcătoare",
    "călcătoareo": "călcătoare",
    "călcători": "călcător",
    "călcătorii": "călcător",
    "călcătorilor": "călcător",
    "călcătorul": "călcător",
    "călcătorule": "călcător",
    "călcătorului": "călcător",
    "călcătoreasa": "călcătoreasă",
    "călcătoreaso": "călcătoreasă",
    "călcătorese": "călcătoreasă",
    "călcătoresei": "călcătoreasă",
    "călcătoresele": "călcătoreasă",
    "călcătoreselor": "călcătoreasă",
    "călcătoria": "călcătorie",
    "călcătoriei": "călcătorie",
    "călcătorii": "călcătorie",
    "călcătoriile": "călcătorie",
    "călcătoriilor": "călcătorie",
    "călcătorio": "călcătorie",
    "călcătura": "călcătură",
    "călcături": "călcătură",
    "călcăturii": "călcătură",
    "călcăturile": "călcătură",
    "călcăturilor": "călcătură",
    "călcăturo": "călcătură",
    "calchiai": "calchia",
    "calchiam": "calchia",
    "calchiară": "calchia",
    "calchiarăm": "calchia",
    "calchiarăți": "calchia",
    "calchiase": "calchia",
    "calchiasem": "calchia",
    "calchiaseră": "calchia",
    "calchiaserăm": "calchia",
    "calchiaserăți": "calchia",
    "calchiaseși": "calchia",
    "calchiași": "calchia",
    "calchiat": "calchia",
    "calchiați": "calchia",
    "calchiatu": "calchia",
    "calchiau": "calchia",
    "calchiază": "calchia",
    "calchie": "calchia",
    "calchiem": "calchia",
    "calchiez": "calchia",
    "calchieze": "calchia",
    "calchiezi": "calchia",
    "calchiind": "calchia",
    "calchiindu": "calchia",
    "necalchiind": "calchia",
    "necalchiindu": "calchia",
    "nemaicalchiind": "calchia",
    "nemaicalchiindu": "calchia",
    "calchiată": "calchiat",
    "calchiate": "calchiat",
    "calchiați": "calchiat",
    "calcifiai": "calcifia",
    "calcifiam": "calcifia",
    "calcifiară": "calcifia",
    "calcifiarăm": "calcifia",
    "calcifiarăți": "calcifia",
    "calcifiase": "calcifia",
    "calcifiasem": "calcifia",
    "calcifiaseră": "calcifia",
    "calcifiaserăm": "calcifia",
    "calcifiaserăți": "calcifia",
    "calcifiaseși": "calcifia",
    "calcifiași": "calcifia",
    "calcifiat": "calcifia",
    "calcifiați": "calcifia",
    "calcifiatu": "calcifia",
    "calcifiau": "calcifia",
    "calcifiază": "calcifia",
    "calcifie": "calcifia",
    "calcifiem": "calcifia",
    "calcifiez": "calcifia",
    "calcifieze": "calcifia",
    "calcifiezi": "calcifia",
    "calcifiind": "calcifia",
    "calcifiindu": "calcifia",
    "necalcifiind": "calcifia",
    "necalcifiindu": "calcifia",
    "nemaicalcifiind": "calcifia",
    "nemaicalcifiindu": "calcifia",
    "calcifiata": "calcifiat",
    "calcifiată": "calcifiat",
    "calcifiate": "calcifiat",
    "calcifiatei": "calcifiat",
    "calcifiatele": "calcifiat",
    "calcifiatelor": "calcifiat",
    "calcifiați": "calcifiat",
    "calcifiații": "calcifiat",
    "calcifiaților": "calcifiat",
    "calcifiato": "calcifiat",
    "calcifiatul": "calcifiat",
    "calcifiatule": "calcifiat",
    "calcifiatului": "calcifiat",
    "calcific": "calcifica",
    "calcifică": "calcifica",
    "calcificai": "calcifica",
    "calcificam": "calcifica",
    "calcificăm": "calcifica",
    "calcificând": "calcifica",
    "calcificându": "calcifica",
    "calcificară": "calcifica",
    "calcificarăm": "calcifica",
    "calcificarăți": "calcifica",
    "calcificase": "calcifica",
    "calcificasem": "calcifica",
    "calcificaseră": "calcifica",
    "calcificaserăm": "calcifica",
    "calcificaserăți": "calcifica",
    "calcificaseși": "calcifica",
    "calcificași": "calcifica",
    "calcificat": "calcifica",
    "calcificați": "calcifica",
    "calcificatu": "calcifica",
    "calcificau": "calcifica",
    "calcifice": "calcifica",
    "calcifici": "calcifica",
    "necalcificând": "calcifica",
    "necalcificându": "calcifica",
    "nemaicalcificând": "calcifica",
    "nemaicalcificându": "calcifica",
    "calcificata": "calcificat",
    "calcificată": "calcificat",
    "calcificate": "calcificat",
    "calcificatei": "calcificat",
    "calcificatele": "calcificat",
    "calcificatelor": "calcificat",
    "calcificați": "calcificat",
    "calcificații": "calcificat",
    "calcificaților": "calcificat",
    "calcificato": "calcificat",
    "calcificatul": "calcificat",
    "calcificatule": "calcificat",
    "calcificatului": "calcificat",
    "calcină": "calcina",
    "calcinai": "calcina",
    "calcinam": "calcina",
    "calcinăm": "calcina",
    "calcinând": "calcina",
    "calcinându": "calcina",
    "calcinară": "calcina",
    "calcinarăm": "calcina",
    "calcinarăți": "calcina",
    "calcinase": "calcina",
    "calcinasem": "calcina",
    "calcinaseră": "calcina",
    "calcinaserăm": "calcina",
    "calcinaserăți": "calcina",
    "calcinaseși": "calcina",
    "calcinași": "calcina",
    "calcinat": "calcina",
    "calcinați": "calcina",
    "calcinatu": "calcina",
    "calcinau": "calcina",
    "calcinează": "calcina",
    "calcinez": "calcina",
    "calcineze": "calcina",
    "calcinezi": "calcina",
    "necalcinând": "calcina",
    "necalcinându": "calcina",
    "nemaicalcinând": "calcina",
    "nemaicalcinându": "calcina",
    "calcinata": "calcinat",
    "calcinată": "calcinat",
    "calcinate": "calcinat",
    "calcinatei": "calcinat",
    "calcinatele": "calcinat",
    "calcinatelor": "calcinat",
    "calcinați": "calcinat",
    "calcinații": "calcinat",
    "calcinaților": "calcinat",
    "calcinato": "calcinat",
    "calcinatul": "calcinat",
    "calcinatule": "calcinat",
    "calcinatului": "calcinat",
    "calcinatoarea": "calcinatoare",
    "calcinatoarei": "calcinatoare",
    "calcinatoarele": "calcinatoare",
    "calcinatoarelor": "calcinatoare",
    "calcinatoareo": "calcinatoare",
    "calcinatori": "calcinator",
    "calcinatorii": "calcinator",
    "calcinatorilor": "calcinator",
    "calcinatorul": "calcinator",
    "calcinatorule": "calcinator",
    "calcinatorului": "calcinator",
    "calcitul": "calcit",
    "calcitule": "calcit",
    "calcitului": "calcit",
    "Ca": "calciu",
    "calciul": "calciu",
    "calciule": "calciu",
    "calciului": "calciu",
    "calcografi": "calcograf",
    "calcografii": "calcograf",
    "calcografilor": "calcograf",
    "calcograful": "calcograf",
    "calcografule": "calcograf",
    "calcografului": "calcograf",
    "calcografia": "calcografie",
    "calcografiei": "calcografie",
    "calcografii": "calcografie",
    "calcografiile": "calcografie",
    "calcografiilor": "calcografie",
    "calcografio": "calcografie",
    "calcopirita": "calcopirită",
    "calcopirite": "calcopirită",
    "calcopiritei": "calcopirită",
    "calcopirito": "calcopirită",
    "calcule": "calcul",
    "calculele": "calcul",
    "calculelor": "calcul",
    "calculi": "calcul",
    "calculii": "calcul",
    "calculilor": "calcul",
    "calculul": "calcul",
    "calculule": "calcul",
    "calculului": "calcul",
    "calculă": "calcula",
    "calculai": "calcula",
    "calculam": "calcula",
    "calculăm": "calcula",
    "calculând": "calcula",
    "calculându": "calcula",
    "calculară": "calcula",
    "calcularăm": "calcula",
    "calcularăți": "calcula",
    "calculase": "calcula",
    "calculasem": "calcula",
    "calculaseră": "calcula",
    "calculaserăm": "calcula",
    "calculaserăți": "calcula",
    "calculaseși": "calcula",
    "calculași": "calcula",
    "calculat": "calcula",
    "calculați": "calcula",
    "calculatu": "calcula",
    "calculau": "calcula",
    "calculează": "calcula",
    "calculez": "calcula",
    "calculeze": "calcula",
    "calculezi": "calcula",
    "necalculând": "calcula",
    "necalculându": "calcula",
    "nemaicalculând": "calcula",
    "nemaicalculându": "calcula",
    "calculabila": "calculabil",
    "calculabilă": "calculabil",
    "calculabile": "calculabil",
    "calculabilei": "calculabil",
    "calculabilele": "calculabil",
    "calculabilelor": "calculabil",
    "calculabili": "calculabil",
    "calculabilii": "calculabil",
    "calculabililor": "calculabil",
    "calculabilo": "calculabil",
    "calculabilul": "calculabil",
    "calculabilule": "calculabil",
    "calculabilului": "calculabil",
    "calcularea": "calculare",
    "calculareo": "calculare",
    "calculări": "calculare",
    "calculării": "calculare",
    "calculările": "calculare",
    "calculărilor": "calculare",
    "calculata": "calculat",
    "calculată": "calculat",
    "calculate": "calculat",
    "calculatei": "calculat",
    "calculatele": "calculat",
    "calculatelor": "calculat",
    "calculați": "calculat",
    "calculații": "calculat",
    "calculaților": "calculat",
    "calculato": "calculat",
    "calculatul": "calculat",
    "calculatule": "calculat",
    "calculatului": "calculat",
    "calculația": "calculație",
    "calculației": "calculație",
    "calculații": "calculație",
    "calculațiile": "calculație",
    "calculațiilor": "calculație",
    "calculațio": "calculație",
    "calculatoarea": "calculatoare",
    "calculatoarei": "calculatoare",
    "calculatoarele": "calculatoare",
    "calculatoarelor": "calculatoare",
    "calculatoareo": "calculatoare",
    "calculatoare": "calculator",
    "calculatoarele": "calculator",
    "calculatoarelor": "calculator",
    "calculatori": "calculator",
    "calculatorii": "calculator",
    "calculatorilor": "calculator",
    "calculatorul": "calculator",
    "calculatorule": "calculator",
    "calculatorului": "calculator",
    "Calcuttă": "Calcutta",
    "Calcutte": "Calcutta",
    "Calcuttei": "Calcutta",
    "calda": "cald",
    "caldă": "cald",
    "calde": "cald",
    "caldei": "cald",
    "caldele": "cald",
    "caldelor": "cald",
    "caldo": "cald",
    "caldul": "cald",
    "caldule": "cald",
    "caldului": "cald",
    "calzi": "cald",
    "calzii": "cald",
    "calzilor": "cald",
    "caldarâmul": "caldarâm",
    "caldarâmule": "caldarâm",
    "caldarâmului": "caldarâm",
    "caldarâmuri": "caldarâm",
    "caldarâmurile": "caldarâm",
    "caldarâmurilor": "caldarâm",
    "căldărari": "căldărar",
    "căldărarii": "căldărar",
    "căldărarilor": "căldărar",
    "căldărarul": "căldărar",
    "căldărarule": "căldărar",
    "căldărarului": "căldărar",
    "căldarea": "căldare",
    "căldareo": "căldare",
    "căldări": "căldare",
    "căldării": "căldare",
    "căldările": "căldare",
    "căldărilor": "căldare",
    "căldăroaie": "căldăroi",
    "căldăroaiele": "căldăroi",
    "căldăroaielor": "căldăroi",
    "căldăroiul": "căldăroi",
    "căldăroiule": "căldăroi",
    "căldăroiului": "căldăroi",
    "căldărușa": "căldărușă",
    "căldărușe": "căldărușă",
    "căldărușei": "căldărușă",
    "căldărușele": "căldărușă",
    "căldărușelor": "căldărușă",
    "căldărușo": "căldărușă",
    "Căldărușanii": "Căldărușani",
    "Căldărușanilor": "Căldărușani",
    "Căldărușaniul": "Căldărușani",
    "Căldărușaniului": "Căldărușani",
    "căldicei": "căldicel",
    "căldiceii": "căldicel",
    "căldiceilor": "căldicel",
    "căldicele": "căldicel",
    "căldicelei": "căldicel",
    "căldicelele": "căldicel",
    "căldicelelor": "căldicel",
    "căldicelul": "căldicel",
    "căldicelule": "căldicel",
    "căldicelului": "căldicel",
    "căldicica": "căldicel",
    "căldicică": "căldicel",
    "căldicico": "căldicel",
    "căldișoara": "căldișor",
    "căldișoară": "căldișor",
    "căldișoare": "căldișor",
    "căldișoarei": "căldișor",
    "căldișoarele": "căldișor",
    "căldișoarelor": "căldișor",
    "căldișoaro": "căldișor",
    "căldișori": "căldișor",
    "căldișorii": "căldișor",
    "căldișorilor": "căldișor",
    "căldișorul": "căldișor",
    "căldișorule": "căldișor",
    "căldișorului": "căldișor",
    "căldura": "căldură",
    "călduri": "căldură",
    "căldurii": "căldură",
    "căldurile": "căldură",
    "căldurilor": "căldură",
    "călduro": "căldură",
    "căldurica": "căldurică",
    "căldurici": "căldurică",
    "călduricii": "căldurică",
    "călduricile": "căldurică",
    "călduricilor": "căldurică",
    "căldurico": "căldurică",
    "călduroasa": "călduros",
    "călduroasă": "călduros",
    "călduroase": "călduros",
    "călduroasei": "călduros",
    "călduroasele": "călduros",
    "călduroaselor": "călduros",
    "călduroaso": "călduros",
    "călduroși": "călduros",
    "călduroșii": "călduros",
    "călduroșilor": "călduros",
    "căldurosul": "călduros",
    "căldurosule": "călduros",
    "căldurosului": "călduros",
    "călduța": "călduț",
    "călduță": "călduț",
    "călduțe": "călduț",
    "călduței": "călduț",
    "călduțele": "călduț",
    "călduțelor": "călduț",
    "călduți": "călduț",
    "călduții": "călduț",
    "călduților": "călduț",
    "călduțo": "călduț",
    "călduțul": "călduț",
    "călduțule": "călduț",
    "călduțului": "călduț",
    "căi": "cale",
    "căii": "cale",
    "căile": "cale",
    "căilor": "cale",
    "calea": "cale",
    "caleo": "cale",
    "Cl.": "calea",
    "Căii_Lactee": "Calea_Lactee",
    "caleașca": "caleașcă",
    "caleașco": "caleașcă",
    "calești": "caleașcă",
    "caleștii": "caleașcă",
    "caleștile": "caleașcă",
    "caleștilor": "caleașcă",
    "caleidoscoape": "caleidoscop",
    "caleidoscoapele": "caleidoscop",
    "caleidoscoapelor": "caleidoscop",
    "caleidoscopul": "caleidoscop",
    "caleidoscopule": "caleidoscop",
    "caleidoscopului": "caleidoscop",
    "caleidoscopuri": "caleidoscop",
    "caleidoscopurile": "caleidoscop",
    "caleidoscopurilor": "caleidoscop",
    "calendare": "calendar",
    "calendarele": "calendar",
    "calendarelor": "calendar",
    "calendarul": "calendar",
    "calendarule": "calendar",
    "calendarului": "calendar",
    "calendaristica": "calendaristic",
    "calendaristică": "calendaristic",
    "calendaristice": "calendaristic",
    "calendaristicei": "calendaristic",
    "calendaristicele": "calendaristic",
    "calendaristicelor": "calendaristic",
    "calendaristici": "calendaristic",
    "calendaristicii": "calendaristic",
    "calendaristicilor": "calendaristic",
    "calendaristico": "calendaristic",
    "calendaristicul": "calendaristic",
    "calendaristicule": "calendaristic",
    "calendaristicului": "calendaristic",
    "calendele": "calende",
    "calendelor": "calende",
    "calfa": "calfă",
    "calfe": "calfă",
    "calfei": "calfă",
    "calfele": "calfă",
    "calfelor": "calfă",
    "calfo": "calfă",
    "calfată": "calfata",
    "calfatai": "calfata",
    "calfatam": "calfata",
    "calfatăm": "calfata",
    "calfatând": "calfata",
    "calfatându": "calfata",
    "calfatară": "calfata",
    "calfatarăm": "calfata",
    "calfatarăți": "calfata",
    "calfatase": "calfata",
    "calfatasem": "calfata",
    "calfataseră": "calfata",
    "calfataserăm": "calfata",
    "calfataserăți": "calfata",
    "calfataseși": "calfata",
    "calfatași": "calfata",
    "calfatat": "calfata",
    "calfatați": "calfata",
    "calfatatu": "calfata",
    "calfatau": "calfata",
    "calfatează": "calfata",
    "calfatez": "calfata",
    "calfateze": "calfata",
    "calfatezi": "calfata",
    "necalfatând": "calfata",
    "necalfatându": "calfata",
    "nemaicalfatând": "calfata",
    "nemaicalfatându": "calfata",
    "calfatată": "calfatat",
    "calfatate": "calfatat",
    "calfatați": "calfatat",
    "călea": "căli",
    "căleai": "căli",
    "căleam": "căli",
    "călească": "căli",
    "căleați": "căli",
    "căleau": "căli",
    "călesc": "căli",
    "călește": "căli",
    "călești": "căli",
    "călii": "căli",
    "călim": "căli",
    "călind": "căli",
    "călindu": "căli",
    "căliră": "căli",
    "călirăm": "căli",
    "călirăți": "căli",
    "călise": "căli",
    "călisem": "căli",
    "căliseră": "căli",
    "căliserăm": "căli",
    "căliserăți": "căli",
    "căliseși": "căli",
    "căliși": "căli",
    "călit": "căli",
    "căliți": "căli",
    "călitu": "căli",
    "necălind": "căli",
    "necălindu": "căli",
    "nemaicălind": "căli",
    "nemaicălindu": "căli",
    "calibră": "calibra",
    "calibrai": "calibra",
    "calibram": "calibra",
    "calibrăm": "calibra",
    "calibrând": "calibra",
    "calibrându": "calibra",
    "calibrară": "calibra",
    "calibrarăm": "calibra",
    "calibrarăți": "calibra",
    "calibrase": "calibra",
    "calibrasem": "calibra",
    "calibraseră": "calibra",
    "calibraserăm": "calibra",
    "calibraserăți": "calibra",
    "calibraseși": "calibra",
    "calibrași": "calibra",
    "calibrat": "calibra",
    "calibrați": "calibra",
    "calibratu": "calibra",
    "calibrau": "calibra",
    "calibrează": "calibra",
    "calibrez": "calibra",
    "calibreze": "calibra",
    "calibrezi": "calibra",
    "necalibrând": "calibra",
    "necalibrându": "calibra",
    "nemaicalibrând": "calibra",
    "nemaicalibrându": "calibra",
    "calibrarea": "calibrare",
    "calibrareo": "calibrare",
    "calibrări": "calibrare",
    "calibrării": "calibrare",
    "calibrările": "calibrare",
    "calibrărilor": "calibrare",
    "calibrată": "calibrat",
    "calibrate": "calibrat",
    "calibrați": "calibrat",
    "calibroare": "calibror",
    "calibroarea": "calibror",
    "calibroarei": "calibror",
    "calibroarele": "calibror",
    "calibroarelor": "calibror",
    "calibroareo": "calibror",
    "calibrori": "calibror",
    "calibrorii": "calibror",
    "calibrorilor": "calibror",
    "calibrorul": "calibror",
    "calibrorule": "calibror",
    "calibrorului": "calibror",
    "calibre": "calibru",
    "calibrele": "calibru",
    "calibrelor": "calibru",
    "calibrul": "calibru",
    "calibrule": "calibru",
    "calibrului": "calibru",
    "calica": "calic",
    "calică": "calic",
    "calice": "calic",
    "calicei": "calic",
    "calicele": "calic",
    "calicelor": "calic",
    "calici": "calic",
    "calicii": "calic",
    "calicilor": "calic",
    "calico": "calic",
    "calicul": "calic",
    "calicule": "calic",
    "calicului": "calic",
    "caliceasca": "calicesc",
    "calicească": "calicesc",
    "caliceasco": "calicesc",
    "calicescul": "calicesc",
    "calicescule": "calicesc",
    "calicescului": "calicesc",
    "calicești": "calicesc",
    "caliceștii": "calicesc",
    "caliceștile": "calicesc",
    "caliceștilor": "calicesc",
    "calicea": "calici",
    "caliceai": "calici",
    "caliceam": "calici",
    "calicească": "calici",
    "caliceați": "calici",
    "caliceau": "calici",
    "calicesc": "calici",
    "calicește": "calici",
    "calicești": "calici",
    "calicii": "calici",
    "calicim": "calici",
    "calicind": "calici",
    "calicindu": "calici",
    "caliciră": "calici",
    "calicirăm": "calici",
    "calicirăți": "calici",
    "calicise": "calici",
    "calicisem": "calici",
    "caliciseră": "calici",
    "caliciserăm": "calici",
    "caliciserăți": "calici",
    "caliciseși": "calici",
    "caliciși": "calici",
    "calicit": "calici",
    "caliciți": "calici",
    "calicitu": "calici",
    "necalicind": "calici",
    "necalicindu": "calici",
    "nemaicalicind": "calici",
    "nemaicalicindu": "calici",
    "calicirea": "calicire",
    "calicireo": "calicire",
    "caliciri": "calicire",
    "calicirii": "calicire",
    "calicirile": "calicire",
    "calicirilor": "calicire",
    "calicită": "calicit",
    "calicite": "calicit",
    "caliciți": "calicit",
    "calicii": "caliciu",
    "caliciile": "caliciu",
    "caliciilor": "caliciu",
    "caliciul": "caliciu",
    "caliciule": "caliciu",
    "caliciului": "caliciu",
    "califi": "calif",
    "califii": "calif",
    "califilor": "calif",
    "califul": "calif",
    "califule": "calif",
    "califului": "calif",
    "călifari": "călifar",
    "călifarii": "călifar",
    "călifarilor": "călifar",
    "călifarul": "călifar",
    "călifarule": "călifar",
    "călifarului": "călifar",
    "califate": "califat",
    "califatele": "califat",
    "califatelor": "califat",
    "califatul": "califat",
    "califatule": "califat",
    "califatului": "califat",
    "calific": "califica",
    "califică": "califica",
    "calificai": "califica",
    "calificam": "califica",
    "calificăm": "califica",
    "calificând": "califica",
    "calificându": "califica",
    "calificară": "califica",
    "calificarăm": "califica",
    "calificarăți": "califica",
    "calificase": "califica",
    "calificasem": "califica",
    "calificaseră": "califica",
    "calificaserăm": "califica",
    "calificaserăți": "califica",
    "calificaseși": "califica",
    "calificași": "califica",
    "calificat": "califica",
    "calificați": "califica",
    "calificatu": "califica",
    "calificau": "califica",
    "califice": "califica",
    "califici": "califica",
    "necalificând": "califica",
    "necalificându": "califica",
    "nemaicalificând": "califica",
    "nemaicalificându": "califica",
    "calificarea": "calificare",
    "calificareo": "calificare",
    "calificări": "calificare",
    "calificării": "calificare",
    "calificările": "calificare",
    "calificărilor": "calificare",
    "calificata": "calificat",
    "calificată": "calificat",
    "calificate": "calificat",
    "calificatei": "calificat",
    "calificatele": "calificat",
    "calificatelor": "calificat",
    "calificați": "calificat",
    "calificații": "calificat",
    "calificaților": "calificat",
    "calificato": "calificat",
    "calificatul": "calificat",
    "calificatule": "calificat",
    "calificatului": "calificat",
    "calificativa": "calificativ",
    "calificativă": "calificativ",
    "calificative": "calificativ",
    "calificativei": "calificativ",
    "calificativele": "calificativ",
    "calificativelor": "calificativ",
    "calificativi": "calificativ",
    "calificativii": "calificativ",
    "calificativilor": "calificativ",
    "calificativo": "calificativ",
    "calificativul": "calificativ",
    "calificativule": "calificativ",
    "calificativului": "calificativ",
    "Cal.": "California",
    "caligrafi": "caligraf",
    "caligrafii": "caligraf",
    "caligrafilor": "caligraf",
    "caligraful": "caligraf",
    "caligrafule": "caligraf",
    "caligrafului": "caligraf",
    "caligrafa": "caligrafă",
    "caligrafe": "caligrafă",
    "caligrafei": "caligrafă",
    "caligrafele": "caligrafă",
    "caligrafelor": "caligrafă",
    "caligrafo": "caligrafă",
    "caligrafiai": "caligrafia",
    "caligrafiam": "caligrafia",
    "caligrafiară": "caligrafia",
    "caligrafiarăm": "caligrafia",
    "caligrafiarăți": "caligrafia",
    "caligrafiase": "caligrafia",
    "caligrafiasem": "caligrafia",
    "caligrafiaseră": "caligrafia",
    "caligrafiaserăm": "caligrafia",
    "caligrafiaserăți": "caligrafia",
    "caligrafiaseși": "caligrafia",
    "caligrafiași": "caligrafia",
    "caligrafiat": "caligrafia",
    "caligrafiați": "caligrafia",
    "caligrafiatu": "caligrafia",
    "caligrafiau": "caligrafia",
    "caligrafiază": "caligrafia",
    "caligrafie": "caligrafia",
    "caligrafiem": "caligrafia",
    "caligrafiez": "caligrafia",
    "caligrafieze": "caligrafia",
    "caligrafiezi": "caligrafia",
    "caligrafiind": "caligrafia",
    "caligrafiindu": "caligrafia",
    "necaligrafiind": "caligrafia",
    "necaligrafiindu": "caligrafia",
    "nemaicaligrafiind": "caligrafia",
    "nemaicaligrafiindu": "caligrafia",
    "caligrafiată": "caligrafiat",
    "caligrafiate": "caligrafiat",
    "caligrafiați": "caligrafiat",
    "caligrafica": "caligrafic",
    "caligrafică": "caligrafic",
    "caligrafice": "caligrafic",
    "caligraficei": "caligrafic",
    "caligraficele": "caligrafic",
    "caligraficelor": "caligrafic",
    "caligrafici": "caligrafic",
    "caligraficii": "caligrafic",
    "caligraficilor": "caligrafic",
    "caligrafico": "caligrafic",
    "caligraficul": "caligrafic",
    "caligraficule": "caligrafic",
    "caligraficului": "caligrafic",
    "caligrafia": "caligrafie",
    "caligrafiei": "caligrafie",
    "caligrafii": "caligrafie",
    "caligrafiile": "caligrafie",
    "caligrafiilor": "caligrafie",
    "caligrafio": "caligrafie",
    "Călimăneștii": "Călimănești",
    "Călimăneștilor": "Călimănești",
    "Călimăneștiul": "Călimănești",
    "Călimăneștiului": "Călimănești",
    "călimara": "călimară",
    "călimări": "călimară",
    "călimării": "călimară",
    "călimările": "călimară",
    "călimărilor": "călimară",
    "călimaro": "călimară",
    "călirea": "călire",
    "călireo": "călire",
    "căliri": "călire",
    "călirii": "călire",
    "călirile": "călire",
    "călirilor": "călire",
    "călita": "călit",
    "călită": "călit",
    "călite": "călit",
    "călitei": "călit",
    "călitele": "călit",
    "călitelor": "călit",
    "căliți": "călit",
    "căliții": "călit",
    "căliților": "călit",
    "călito": "călit",
    "călitul": "călit",
    "călitule": "călit",
    "călitului": "călit",
    "calitatea": "calitate",
    "calitateo": "calitate",
    "calități": "calitate",
    "calității": "calitate",
    "calitățile": "calitate",
    "calităților": "calitate",
    "calitativa": "calitativ",
    "calitativă": "calitativ",
    "calitative": "calitativ",
    "calitativei": "calitativ",
    "calitativele": "calitativ",
    "calitativelor": "calitativ",
    "calitativi": "calitativ",
    "calitativii": "calitativ",
    "calitativilor": "calitativ",
    "calitativo": "calitativ",
    "calitativul": "calitativ",
    "calitativule": "calitativ",
    "calitativului": "calitativ",
    "calma": "calm",
    "calmă": "calm",
    "calme": "calm",
    "calmei": "calm",
    "calmele": "calm",
    "calmelor": "calm",
    "calmi": "calm",
    "calmii": "calm",
    "calmilor": "calm",
    "calmo": "calm",
    "calmul": "calm",
    "calmule": "calm",
    "calmului": "calm",
    "calmuri": "calm",
    "calmurile": "calm",
    "calmurilor": "calm",
    "calmă": "calma",
    "calmai": "calma",
    "calmam": "calma",
    "calmăm": "calma",
    "calmând": "calma",
    "calmându": "calma",
    "calmară": "calma",
    "calmarăm": "calma",
    "calmarăți": "calma",
    "calmase": "calma",
    "calmasem": "calma",
    "calmaseră": "calma",
    "calmaserăm": "calma",
    "calmaserăți": "calma",
    "calmaseși": "calma",
    "calmași": "calma",
    "calmat": "calma",
    "calmați": "calma",
    "calmatu": "calma",
    "calmau": "calma",
    "calmează": "calma",
    "calmez": "calma",
    "calmeze": "calma",
    "calmezi": "calma",
    "necalmând": "calma",
    "necalmându": "calma",
    "nemaicalmând": "calma",
    "nemaicalmându": "calma",
    "calmanta": "calmant",
    "calmantă": "calmant",
    "calmante": "calmant",
    "calmantei": "calmant",
    "calmantele": "calmant",
    "calmantelor": "calmant",
    "calmanți": "calmant",
    "calmanții": "calmant",
    "calmanților": "calmant",
    "calmanto": "calmant",
    "calmantul": "calmant",
    "calmantule": "calmant",
    "calmantului": "calmant",
    "calmarea": "calmare",
    "calmareo": "calmare",
    "calmări": "calmare",
    "calmării": "calmare",
    "calmările": "calmare",
    "calmărilor": "calmare",
    "Călmășenii": "Călmășeni",
    "Călmășenilor": "Călmășeni",
    "Călmășeniul": "Călmășeni",
    "Călmășeniului": "Călmășeni",
    "calmată": "calmat",
    "calmate": "calmat",
    "calmați": "calmat",
    "Călmățuiului": "Călmățui",
    "calomelul": "calomel",
    "calomelule": "calomel",
    "calomelului": "calomel",
    "calomfiri": "calomfir",
    "calomfirii": "calomfir",
    "calomfirilor": "calomfir",
    "calomfirul": "calomfir",
    "calomfirule": "calomfir",
    "calomfirului": "calomfir",
    "calomniai": "calomnia",
    "calomniam": "calomnia",
    "calomniară": "calomnia",
    "calomniarăm": "calomnia",
    "calomniarăți": "calomnia",
    "calomniase": "calomnia",
    "calomniasem": "calomnia",
    "calomniaseră": "calomnia",
    "calomniaserăm": "calomnia",
    "calomniaserăți": "calomnia",
    "calomniaseși": "calomnia",
    "calomniași": "calomnia",
    "calomniat": "calomnia",
    "calomniați": "calomnia",
    "calomniatu": "calomnia",
    "calomniau": "calomnia",
    "calomniază": "calomnia",
    "calomnie": "calomnia",
    "calomniem": "calomnia",
    "calomniez": "calomnia",
    "calomnieze": "calomnia",
    "calomniezi": "calomnia",
    "calomniind": "calomnia",
    "calomniindu": "calomnia",
    "necalomniind": "calomnia",
    "necalomniindu": "calomnia",
    "nemaicalomniind": "calomnia",
    "nemaicalomniindu": "calomnia",
    "calomniată": "calomniat",
    "calomniate": "calomniat",
    "calomniați": "calomniat",
    "calomniatoarea": "calomniatoare",
    "calomniatoarei": "calomniatoare",
    "calomniatoarele": "calomniatoare",
    "calomniatoarelor": "calomniatoare",
    "calomniatoareo": "calomniatoare",
    "calomniatoare": "calomniator",
    "calomniatoarea": "calomniator",
    "calomniatoarei": "calomniator",
    "calomniatoarele": "calomniator",
    "calomniatoarelor": "calomniator",
    "calomniatoareo": "calomniator",
    "calomniatori": "calomniator",
    "calomniatorii": "calomniator",
    "calomniatorilor": "calomniator",
    "calomniatorul": "calomniator",
    "calomniatorule": "calomniator",
    "calomniatorului": "calomniator",
    "calomnia": "calomnie",
    "calomniei": "calomnie",
    "calomnii": "calomnie",
    "calomniile": "calomnie",
    "calomniilor": "calomnie",
    "calomnio": "calomnie",
    "calomnierea": "calomniere",
    "calomniereo": "calomniere",
    "calomnieri": "calomniere",
    "calomnierii": "calomniere",
    "calomnierile": "calomniere",
    "calomnierilor": "calomniere",
    "calomnioasa": "calomnios",
    "calomnioasă": "calomnios",
    "calomnioase": "calomnios",
    "calomnioasei": "calomnios",
    "calomnioasele": "calomnios",
    "calomnioaselor": "calomnios",
    "calomnioaso": "calomnios",
    "calomnioși": "calomnios",
    "calomnioșii": "calomnios",
    "calomnioșilor": "calomnios",
    "calomniosul": "calomnios",
    "calomniosule": "calomnios",
    "calomniosului": "calomnios",
    "calorica": "caloric",
    "calorică": "caloric",
    "calorice": "caloric",
    "caloricei": "caloric",
    "caloricele": "caloric",
    "caloricelor": "caloric",
    "calorici": "caloric",
    "caloricii": "caloric",
    "caloricilor": "caloric",
    "calorico": "caloric",
    "caloricul": "caloric",
    "caloricule": "caloric",
    "caloricului": "caloric",
    "cal.": "calorie",
    "caloria": "calorie",
    "caloriei": "calorie",
    "calorii": "calorie",
    "caloriile": "calorie",
    "caloriilor": "calorie",
    "calorio": "calorie",
    "calorifere": "calorifer",
    "caloriferele": "calorifer",
    "caloriferelor": "calorifer",
    "caloriferul": "calorifer",
    "caloriferule": "calorifer",
    "caloriferului": "calorifer",
    "caloriferiști": "caloriferist",
    "caloriferiștii": "caloriferist",
    "caloriferiștilor": "caloriferist",
    "caloriferistul": "caloriferist",
    "caloriferistule": "caloriferist",
    "caloriferistului": "caloriferist",
    "calorifica": "calorific",
    "calorifică": "calorific",
    "calorifice": "calorific",
    "calorificei": "calorific",
    "calorificele": "calorific",
    "calorificelor": "calorific",
    "calorifici": "calorific",
    "calorificii": "calorific",
    "calorificilor": "calorific",
    "calorifico": "calorific",
    "calorificul": "calorific",
    "calorificule": "calorific",
    "calorificului": "calorific",
    "calorigena": "calorigen",
    "calorigenă": "calorigen",
    "calorigene": "calorigen",
    "calorigenei": "calorigen",
    "calorigenele": "calorigen",
    "calorigenelor": "calorigen",
    "calorigeni": "calorigen",
    "calorigenii": "calorigen",
    "calorigenilor": "calorigen",
    "calorigeno": "calorigen",
    "calorigenul": "calorigen",
    "calorigenule": "calorigen",
    "calorigenului": "calorigen",
    "calorimetrica": "calorimetric",
    "calorimetrică": "calorimetric",
    "calorimetrice": "calorimetric",
    "calorimetricei": "calorimetric",
    "calorimetricele": "calorimetric",
    "calorimetricelor": "calorimetric",
    "calorimetrici": "calorimetric",
    "calorimetricii": "calorimetric",
    "calorimetricilor": "calorimetric",
    "calorimetrico": "calorimetric",
    "calorimetricul": "calorimetric",
    "calorimetricule": "calorimetric",
    "calorimetricului": "calorimetric",
    "calorimetria": "calorimetrie",
    "calorimetriei": "calorimetrie",
    "calorimetrii": "calorimetrie",
    "calorimetriile": "calorimetrie",
    "calorimetriilor": "calorimetrie",
    "calorimetrio": "calorimetrie",
    "calorimetre": "calorimetru",
    "calorimetrele": "calorimetru",
    "calorimetrelor": "calorimetru",
    "calorimetrul": "calorimetru",
    "calorimetrule": "calorimetru",
    "calorimetrului": "calorimetru",
    "caloasa": "calos",
    "caloasă": "calos",
    "caloase": "calos",
    "caloasei": "calos",
    "caloasele": "calos",
    "caloaselor": "calos",
    "caloaso": "calos",
    "caloși": "calos",
    "caloșii": "calos",
    "caloșilor": "calos",
    "calosul": "calos",
    "calosule": "calos",
    "calosului": "calos",
    "calota": "calotă",
    "calote": "calotă",
    "calotei": "calotă",
    "calotele": "calotă",
    "calotelor": "calotă",
    "caloto": "calotă",
    "calpa": "calp",
    "calpă": "calp",
    "calpe": "calp",
    "calpei": "calp",
    "calpele": "calp",
    "calpelor": "calp",
    "calpi": "calp",
    "calpii": "calp",
    "calpilor": "calp",
    "calpo": "calp",
    "calpul": "calp",
    "calpule": "calp",
    "calpului": "calp",
    "caltaboși": "caltaboș",
    "caltaboșii": "caltaboș",
    "caltaboșilor": "caltaboș",
    "caltaboșul": "caltaboș",
    "caltaboșule": "caltaboș",
    "caltaboșului": "caltaboș",
    "câlții": "câlți",
    "câlților": "câlți",
    "câlțișorii": "câlțișori",
    "câlțișorilor": "câlțișori",
    "câlțoasa": "câlțos",
    "câlțoasă": "câlțos",
    "câlțoase": "câlțos",
    "câlțoasei": "câlțos",
    "câlțoasele": "câlțos",
    "câlțoaselor": "câlțos",
    "câlțoaso": "câlțos",
    "câlțoși": "câlțos",
    "câlțoșii": "câlțos",
    "câlțoșilor": "câlțos",
    "câlțosul": "câlțos",
    "câlțosule": "câlțos",
    "câlțosului": "câlțos",
    "călugări": "călugăr",
    "călugării": "călugăr",
    "călugărilor": "călugăr",
    "călugărul": "călugăr",
    "călugărule": "călugăr",
    "călugărului": "călugăr",
    "călugărași": "călugăraș",
    "călugărașii": "călugăraș",
    "călugărașilor": "călugăraș",
    "călugărașul": "călugăraș",
    "călugărașule": "călugăraș",
    "călugărașului": "călugăraș",
    "călugăreasca": "călugăresc",
    "călugărească": "călugăresc",
    "călugăreasco": "călugăresc",
    "călugărescul": "călugăresc",
    "călugărescule": "călugăresc",
    "călugărescului": "călugăresc",
    "călugărești": "călugăresc",
    "călugăreștii": "călugăresc",
    "călugăreștile": "călugăresc",
    "călugăreștilor": "călugăresc",
    "călugărea": "călugări",
    "călugăreai": "călugări",
    "călugăream": "călugări",
    "călugărească": "călugări",
    "călugăreați": "călugări",
    "călugăreau": "călugări",
    "călugăresc": "călugări",
    "călugărește": "călugări",
    "călugărești": "călugări",
    "călugării": "călugări",
    "călugărim": "călugări",
    "călugărind": "călugări",
    "călugărindu": "călugări",
    "călugăriră": "călugări",
    "călugărirăm": "călugări",
    "călugărirăți": "călugări",
    "călugărise": "călugări",
    "călugărisem": "călugări",
    "călugăriseră": "călugări",
    "călugăriserăm": "călugări",
    "călugăriserăți": "călugări",
    "călugăriseși": "călugări",
    "călugăriși": "călugări",
    "călugărit": "călugări",
    "călugăriți": "călugări",
    "călugăritu": "călugări",
    "necălugărind": "călugări",
    "necălugărindu": "călugări",
    "nemaicălugărind": "călugări",
    "nemaicălugărindu": "călugări",
    "călugăria": "călugărie",
    "călugăriei": "călugărie",
    "călugării": "călugărie",
    "călugăriile": "călugărie",
    "călugăriilor": "călugărie",
    "călugărio": "călugărie",
    "călugărirea": "călugărire",
    "călugărireo": "călugărire",
    "călugăriri": "călugărire",
    "călugăririi": "călugărire",
    "călugăririle": "călugărire",
    "călugăririlor": "călugărire",
    "călugărită": "călugărit",
    "călugărite": "călugărit",
    "călugăriți": "călugărit",
    "călugărița": "călugăriță",
    "călugărițe": "călugăriță",
    "călugăriței": "călugăriță",
    "călugărițele": "călugăriță",
    "călugărițelor": "călugăriță",
    "călugărițo": "călugăriță",
    "caii-dracului": "calul-dracului",
    "calupul": "calup",
    "calupule": "calup",
    "calupului": "calup",
    "calupuri": "calup",
    "calupurile": "calup",
    "calupurilor": "calup",
    "călușul": "căluș",
    "călușule": "căluș",
    "călușului": "căluș",
    "călușuri": "căluș",
    "călușurile": "căluș",
    "călușurilor": "căluș",
    "călușari": "călușar",
    "călușarii": "călușar",
    "călușarilor": "călușar",
    "călușarul": "călușar",
    "călușarule": "călușar",
    "călușarului": "călușar",
    "călușei": "călușel",
    "călușeii": "călușel",
    "călușeilor": "călușel",
    "călușelul": "călușel",
    "călușelule": "călușel",
    "călușelului": "călușel",
    "căluți": "căluț",
    "căluții": "căluț",
    "căluților": "căluț",
    "căluțul": "căluț",
    "căluțule": "căluț",
    "căluțului": "căluț",
    "calvarul": "calvar",
    "calvarule": "calvar",
    "calvarului": "calvar",
    "calvaruri": "calvar",
    "calvarurile": "calvar",
    "calvarurilor": "calvar",
    "calvina": "calvin",
    "calvină": "calvin",
    "calvine": "calvin",
    "calvinei": "calvin",
    "calvinele": "calvin",
    "calvinelor": "calvin",
    "calvini": "calvin",
    "calvinii": "calvin",
    "calvinilor": "calvin",
    "calvino": "calvin",
    "calvinul": "calvin",
    "calvinule": "calvin",
    "calvinului": "calvin",
    "calvina": "calvină",
    "calvine": "calvină",
    "calvinei": "calvină",
    "calvinele": "calvină",
    "calvinelor": "calvină",
    "calvino": "calvină",
    "calvinisme": "calvinism",
    "calvinismele": "calvinism",
    "calvinismelor": "calvinism",
    "calvinismul": "calvinism",
    "calvinismule": "calvinism",
    "calvinismului": "calvinism",
    "calvinista": "calvinist",
    "calvinistă": "calvinist",
    "calviniste": "calvinist",
    "calvinistei": "calvinist",
    "calvinistele": "calvinist",
    "calvinistelor": "calvinist",
    "calviniști": "calvinist",
    "calviniștii": "calvinist",
    "calviniștilor": "calvinist",
    "calvinisto": "calvinist",
    "calvinistul": "calvinist",
    "calvinistule": "calvinist",
    "calvinistului": "calvinist",
    "calvinista": "calvinistă",
    "calviniste": "calvinistă",
    "calvinistei": "calvinistă",
    "calvinistele": "calvinistă",
    "calvinistelor": "calvinistă",
    "calvinisto": "calvinistă",
    "calviția": "calviție",
    "calviției": "calviție",
    "calviții": "calviție",
    "calvițiile": "calviție",
    "calvițiilor": "calviție",
    "calvițio": "calviție",
    "cama": "camă",
    "came": "camă",
    "camei": "camă",
    "camele": "camă",
    "camelor": "camă",
    "camo": "camă",
    "cămara": "cămară",
    "cămări": "cămară",
    "cămării": "cămară",
    "cămările": "cămară",
    "cămărilor": "cămară",
    "cămaro": "cămară",
    "camaradul": "camarad",
    "camaradule": "camarad",
    "camaradului": "camarad",
    "camarazi": "camarad",
    "camarazii": "camarad",
    "camarazilor": "camarad",
    "camarada": "camaradă",
    "camarade": "camaradă",
    "camaradei": "camaradă",
    "camaradele": "camaradă",
    "camaradelor": "camaradă",
    "camarado": "camaradă",
    "camaradereasca": "camaraderesc",
    "camaraderească": "camaraderesc",
    "camaradereasco": "camaraderesc",
    "camaraderescul": "camaraderesc",
    "camaraderescule": "camaraderesc",
    "camaraderescului": "camaraderesc",
    "camaraderești": "camaraderesc",
    "camaradereștii": "camaraderesc",
    "camaradereștile": "camaraderesc",
    "camaradereștilor": "camaraderesc",
    "camaraderia": "camaraderie",
    "camaraderiei": "camaraderie",
    "camaraderii": "camaraderie",
    "camaraderiile": "camaraderie",
    "camaraderiilor": "camaraderie",
    "camaraderio": "camaraderie",
    "camarila": "camarilă",
    "camarile": "camarilă",
    "camarilei": "camarilă",
    "camarilele": "camarilă",
    "camarilelor": "camarilă",
    "camarilo": "camarilă",
    "cămărui": "cămăruie",
    "cămăruia": "cămăruie",
    "cămăruii": "cămăruie",
    "cămăruile": "cămăruie",
    "cămăruilor": "cămăruie",
    "cămăruio": "cămăruie",
    "cămăruța": "cămăruță",
    "cămăruțe": "cămăruță",
    "cămăruței": "cămăruță",
    "cămăruțele": "cămăruță",
    "cămăruțelor": "cămăruță",
    "cămăruțo": "cămăruță",
    "cămașa": "cămașă",
    "cămăși": "cămașă",
    "cămășii": "cămașă",
    "cămășile": "cămașă",
    "cămășilor": "cămașă",
    "cămașo": "cămașă",
    "cămășuța": "cămășuță",
    "cămășuțe": "cămășuță",
    "cămășuței": "cămășuță",
    "cămășuțele": "cămășuță",
    "cămășuțelor": "cămășuță",
    "cămășuțo": "cămășuță",
    "camăta": "camătă",
    "camăto": "camătă",
    "camete": "camătă",
    "cametei": "camătă",
    "cametele": "camătă",
    "cametelor": "camătă",
    "cămătari": "cămătar",
    "cămătarii": "cămătar",
    "cămătarilor": "cămătar",
    "cămătarul": "cămătar",
    "cămătarule": "cămătar",
    "cămătarului": "cămătar",
    "cămătăreasa": "cămătăreasă",
    "cămătăreaso": "cămătăreasă",
    "cămătărese": "cămătăreasă",
    "cămătăresei": "cămătăreasă",
    "cămătăresele": "cămătăreasă",
    "cămătăreselor": "cămătăreasă",
    "cămătăreasca": "cămătăresc",
    "cămătărească": "cămătăresc",
    "cămătăreasco": "cămătăresc",
    "cămătărescul": "cămătăresc",
    "cămătărescule": "cămătăresc",
    "cămătărescului": "cămătăresc",
    "cămătărești": "cămătăresc",
    "cămătăreștii": "cămătăresc",
    "cămătăreștile": "cămătăresc",
    "cămătăreștilor": "cămătăresc",
    "cămătăria": "cămătărie",
    "cămătăriei": "cămătărie",
    "cămătării": "cămătărie",
    "cămătăriile": "cămătărie",
    "cămătăriilor": "cămătărie",
    "cămătărio": "cămătărie",
    "cambiala": "cambial",
    "cambială": "cambial",
    "cambiale": "cambial",
    "cambialei": "cambial",
    "cambialele": "cambial",
    "cambialelor": "cambial",
    "cambiali": "cambial",
    "cambialii": "cambial",
    "cambialilor": "cambial",
    "cambialo": "cambial",
    "cambialul": "cambial",
    "cambialule": "cambial",
    "cambialului": "cambial",
    "cambia": "cambie",
    "cambiei": "cambie",
    "cambii": "cambie",
    "cambiile": "cambie",
    "cambiilor": "cambie",
    "cambio": "cambie",
    "Cambodgie": "Cambodgia",
    "Cambodgiei": "Cambodgia",
    "Cambodgii": "Cambodgia",
    "cambrianul": "cambrian",
    "cambrianule": "cambrian",
    "cambrianului": "cambrian",
    "cambuza": "cambuză",
    "cambuze": "cambuză",
    "cambuzei": "cambuză",
    "cambuzele": "cambuză",
    "cambuzelor": "cambuză",
    "cambuzo": "cambuză",
    "cameea": "camee",
    "cameei": "camee",
    "cameele": "camee",
    "cameelor": "camee",
    "cameo": "camee",
    "cameleoni": "cameleon",
    "cameleonii": "cameleon",
    "cameleonilor": "cameleon",
    "cameleonul": "cameleon",
    "cameleonule": "cameleon",
    "cameleonului": "cameleon",
    "cameleonisme": "cameleonism",
    "cameleonismele": "cameleonism",
    "cameleonismelor": "cameleonism",
    "cameleonismul": "cameleonism",
    "cameleonismule": "cameleonism",
    "cameleonismului": "cameleonism",
    "Camelie": "Camelia",
    "Cameliei": "Camelia",
    "Camelii": "Camelia",
    "camelia": "camelie",
    "cameliei": "camelie",
    "camelii": "camelie",
    "cameliile": "camelie",
    "cameliilor": "camelie",
    "camelio": "camelie",
    "camera": "cameră",
    "camere": "cameră",
    "camerei": "cameră",
    "camerele": "cameră",
    "camerelor": "cameră",
    "camero": "cameră",
    "cameramani": "cameraman",
    "cameramanii": "cameraman",
    "cameramanilor": "cameraman",
    "cameramanul": "cameraman",
    "cameramanule": "cameraman",
    "cameramanului": "cameraman",
    "camerieri": "camerier",
    "camerierii": "camerier",
    "camerierilor": "camerier",
    "camerierul": "camerier",
    "camerierule": "camerier",
    "camerierului": "camerier",
    "cameriști": "camerist",
    "cameriștii": "camerist",
    "cameriștilor": "camerist",
    "cameristul": "camerist",
    "cameristule": "camerist",
    "cameristului": "camerist",
    "camerista": "cameristă",
    "cameriste": "cameristă",
    "cameristei": "cameristă",
    "cameristele": "cameristă",
    "cameristelor": "cameristă",
    "cameristo": "cameristă",
    "camertonul": "camerton",
    "camertonule": "camerton",
    "camertonului": "camerton",
    "camertonuri": "camerton",
    "camertonurile": "camerton",
    "camertonurilor": "camerton",
    "cămeșoaie": "cămeșoi",
    "cămeșoaiele": "cămeșoi",
    "cămeșoaielor": "cămeșoi",
    "cămeșoiul": "cămeșoi",
    "cămeșoiule": "cămeșoi",
    "cămeșoiului": "cămeșoi",
    "camforul": "camfor",
    "camforule": "camfor",
    "camforului": "camfor",
    "camforata": "camforat",
    "camforată": "camforat",
    "camforate": "camforat",
    "camforatei": "camforat",
    "camforatele": "camforat",
    "camforatelor": "camforat",
    "camforați": "camforat",
    "camforații": "camforat",
    "camforaților": "camforat",
    "camforato": "camforat",
    "camforatul": "camforat",
    "camforatule": "camforat",
    "camforatului": "camforat",
    "cămila": "cămilă",
    "cămile": "cămilă",
    "cămilei": "cămilă",
    "cămilele": "cămilă",
    "cămilelor": "cămilă",
    "cămilo": "cămilă",
    "cămine": "cămin",
    "căminele": "cămin",
    "căminelor": "cămin",
    "căminul": "cămin",
    "căminule": "cămin",
    "căminului": "cămin",
    "căminuri": "cămin",
    "căminurile": "cămin",
    "căminurilor": "cămin",
    "căminista": "căminist",
    "căministă": "căminist",
    "căministe": "căminist",
    "căministei": "căminist",
    "căministele": "căminist",
    "căministelor": "căminist",
    "căminiști": "căminist",
    "căminiștii": "căminist",
    "căminiștilor": "căminist",
    "căministo": "căminist",
    "căministul": "căminist",
    "căministule": "căminist",
    "căministului": "căminist",
    "căminista": "căministă",
    "căministe": "căministă",
    "căministei": "căministă",
    "căministele": "căministă",
    "căministelor": "căministă",
    "căministo": "căministă",
    "camioane": "camion",
    "camioanele": "camion",
    "camioanelor": "camion",
    "camionul": "camion",
    "camionule": "camion",
    "camionului": "camion",
    "camionagii": "camionagiu",
    "camionagiii": "camionagiu",
    "camionagiilor": "camionagiu",
    "camionagiul": "camionagiu",
    "camionagiule": "camionagiu",
    "camionagiului": "camionagiu",
    "camioneta": "camionetă",
    "camionete": "camionetă",
    "camionetei": "camionetă",
    "camionetele": "camionetă",
    "camionetelor": "camionetă",
    "camioneto": "camionetă",
    "câmpi": "câmp",
    "câmpii": "câmp",
    "câmpilor": "câmp",
    "câmpul": "câmp",
    "câmpule": "câmp",
    "câmpului": "câmp",
    "câmpuri": "câmp",
    "câmpurile": "câmp",
    "câmpurilor": "câmp",
    "campă": "campa",
    "campai": "campa",
    "campam": "campa",
    "campăm": "campa",
    "campând": "campa",
    "campându": "campa",
    "campară": "campa",
    "camparăm": "campa",
    "camparăți": "campa",
    "campase": "campa",
    "campasem": "campa",
    "campaseră": "campa",
    "campaserăm": "campa",
    "campaserăți": "campa",
    "campaseși": "campa",
    "campași": "campa",
    "campat": "campa",
    "campați": "campa",
    "campatu": "campa",
    "campau": "campa",
    "campează": "campa",
    "campez": "campa",
    "campeze": "campa",
    "campezi": "campa",
    "necampând": "campa",
    "necampându": "campa",
    "nemaicampând": "campa",
    "nemaicampându": "campa",
    "campamente": "campament",
    "campamentele": "campament",
    "campamentelor": "campament",
    "campamentul": "campament",
    "campamentule": "campament",
    "campamentului": "campament",
    "campania": "campanie",
    "campaniei": "campanie",
    "campanii": "campanie",
    "campaniile": "campanie",
    "campaniilor": "campanie",
    "campanio": "campanie",
    "campanula": "campanulă",
    "campanule": "campanulă",
    "campanulei": "campanulă",
    "campanulele": "campanulă",
    "campanulelor": "campanulă",
    "campanulo": "campanulă",
    "campată": "campat",
    "campate": "campat",
    "campați": "campat",
    "câmpeanul": "câmpean",
    "câmpeanule": "câmpean",
    "câmpeanului": "câmpean",
    "câmpeni": "câmpean",
    "câmpenii": "câmpean",
    "câmpenilor": "câmpean",
    "câmpeanca": "câmpeancă",
    "câmpeanco": "câmpeancă",
    "câmpence": "câmpeancă",
    "câmpencei": "câmpeancă",
    "câmpencele": "câmpeancă",
    "câmpencelor": "câmpeancă",
    "câmpeneasca": "câmpenesc",
    "câmpenească": "câmpenesc",
    "câmpeneasco": "câmpenesc",
    "câmpenescul": "câmpenesc",
    "câmpenescule": "câmpenesc",
    "câmpenescului": "câmpenesc",
    "câmpenești": "câmpenesc",
    "câmpeneștii": "câmpenesc",
    "câmpeneștile": "câmpenesc",
    "câmpeneștilor": "câmpenesc",
    "Câmpiei_Turzii": "Câmpia_Turzii",
    "câmpia": "câmpie",
    "câmpiei": "câmpie",
    "câmpii": "câmpie",
    "câmpiile": "câmpie",
    "câmpiilor": "câmpie",
    "câmpio": "câmpie",
    "campioana": "campioană",
    "campioane": "campioană",
    "campioanei": "campioană",
    "campioanele": "campioană",
    "campioanelor": "campioană",
    "campioano": "campioană",
    "campioni": "campion",
    "campionii": "campion",
    "campionilor": "campion",
    "campionul": "campion",
    "campionule": "campion",
    "campionului": "campion",
    "campionate": "campionat",
    "campionatele": "campionat",
    "campionatelor": "campionat",
    "campionatul": "campionat",
    "campionatule": "campionat",
    "campionatului": "campionat",
    "CM": "Campionat_Mondial",
    "C.M.": "Campionatul_Mondial",
    "Câmpulungul": "Câmpulung",
    "Câmpulungului": "Câmpulung",
    "campusul": "campus",
    "campusule": "campus",
    "campusului": "campus",
    "campusuri": "campus",
    "campusurile": "campus",
    "campusurilor": "campus",
    "câmpușoare": "câmpușor",
    "câmpușoarele": "câmpușor",
    "câmpușoarelor": "câmpușor",
    "câmpușorul": "câmpușor",
    "câmpușorule": "câmpușor",
    "câmpușorului": "câmpușor",
    "camuflă": "camufla",
    "camuflai": "camufla",
    "camuflam": "camufla",
    "camuflăm": "camufla",
    "camuflând": "camufla",
    "camuflându": "camufla",
    "camuflară": "camufla",
    "camuflarăm": "camufla",
    "camuflarăți": "camufla",
    "camuflase": "camufla",
    "camuflasem": "camufla",
    "camuflaseră": "camufla",
    "camuflaserăm": "camufla",
    "camuflaserăți": "camufla",
    "camuflaseși": "camufla",
    "camuflași": "camufla",
    "camuflat": "camufla",
    "camuflați": "camufla",
    "camuflatu": "camufla",
    "camuflau": "camufla",
    "camuflează": "camufla",
    "camuflez": "camufla",
    "camufleze": "camufla",
    "camuflezi": "camufla",
    "necamuflând": "camufla",
    "necamuflându": "camufla",
    "nemaicamuflând": "camufla",
    "nemaicamuflându": "camufla",
    "camuflaje": "camuflaj",
    "camuflajele": "camuflaj",
    "camuflajelor": "camuflaj",
    "camuflajul": "camuflaj",
    "camuflajule": "camuflaj",
    "camuflajului": "camuflaj",
    "camuflarea": "camuflare",
    "camuflareo": "camuflare",
    "camuflări": "camuflare",
    "camuflării": "camuflare",
    "camuflările": "camuflare",
    "camuflărilor": "camuflare",
    "camuflata": "camuflat",
    "camuflată": "camuflat",
    "camuflate": "camuflat",
    "camuflatei": "camuflat",
    "camuflatele": "camuflat",
    "camuflatelor": "camuflat",
    "camuflați": "camuflat",
    "camuflații": "camuflat",
    "camuflaților": "camuflat",
    "camuflato": "camuflat",
    "camuflatul": "camuflat",
    "camuflatule": "camuflat",
    "camuflatului": "camuflat",
    "cana": "cană",
    "căni": "cană",
    "cănii": "cană",
    "cănile": "cană",
    "cănilor": "cană",
    "cano": "cană",
    "Ca.": "Canada",
    "Canadă": "Canada",
    "Canade": "Canada",
    "Canadei": "Canada",
    "canadiana": "canadian",
    "canadiană": "canadian",
    "canadiano": "canadian",
    "canadianul": "canadian",
    "canadianule": "canadian",
    "canadianului": "canadian",
    "canadiene": "canadian",
    "canadienei": "canadian",
    "canadienele": "canadian",
    "canadienelor": "canadian",
    "canadieni": "canadian",
    "canadienii": "canadian",
    "canadienilor": "canadian",
    "canadiana": "canadiană",
    "canadiene": "canadiană",
    "canadienei": "canadiană",
    "canadienele": "canadiană",
    "canadienelor": "canadiană",
    "canadianca": "canadiancă",
    "canadianco": "canadiancă",
    "canadience": "canadiancă",
    "canadiencei": "canadiancă",
    "canadiencele": "canadiancă",
    "canadiencelor": "canadiancă",
    "canale": "canal",
    "canalele": "canal",
    "canalelor": "canal",
    "canalul": "canal",
    "canalule": "canal",
    "canalului": "canal",
    "canaluri": "canal",
    "canalurile": "canal",
    "canalurilor": "canal",
    "canalia": "canalie",
    "canaliei": "canalie",
    "canalii": "canalie",
    "canaliile": "canalie",
    "canaliilor": "canalie",
    "canalio": "canalie",
    "canaliză": "canaliza",
    "canalizai": "canaliza",
    "canalizam": "canaliza",
    "canalizăm": "canaliza",
    "canalizând": "canaliza",
    "canalizându": "canaliza",
    "canalizară": "canaliza",
    "canalizarăm": "canaliza",
    "canalizarăți": "canaliza",
    "canalizase": "canaliza",
    "canalizasem": "canaliza",
    "canalizaseră": "canaliza",
    "canalizaserăm": "canaliza",
    "canalizaserăți": "canaliza",
    "canalizaseși": "canaliza",
    "canalizași": "canaliza",
    "canalizat": "canaliza",
    "canalizați": "canaliza",
    "canalizatu": "canaliza",
    "canalizau": "canaliza",
    "canalizează": "canaliza",
    "canalizez": "canaliza",
    "canalizeze": "canaliza",
    "canalizezi": "canaliza",
    "necanalizând": "canaliza",
    "necanalizându": "canaliza",
    "nemaicanalizând": "canaliza",
    "nemaicanalizându": "canaliza",
    "canalizabila": "canalizabil",
    "canalizabilă": "canalizabil",
    "canalizabile": "canalizabil",
    "canalizabilei": "canalizabil",
    "canalizabilele": "canalizabil",
    "canalizabilelor": "canalizabil",
    "canalizabili": "canalizabil",
    "canalizabilii": "canalizabil",
    "canalizabililor": "canalizabil",
    "canalizabilo": "canalizabil",
    "canalizabilul": "canalizabil",
    "canalizabilule": "canalizabil",
    "canalizabilului": "canalizabil",
    "canalizarea": "canalizare",
    "canalizareo": "canalizare",
    "canalizări": "canalizare",
    "canalizării": "canalizare",
    "canalizările": "canalizare",
    "canalizărilor": "canalizare",
    "canalizata": "canalizat",
    "canalizată": "canalizat",
    "canalizate": "canalizat",
    "canalizatei": "canalizat",
    "canalizatele": "canalizat",
    "canalizatelor": "canalizat",
    "canalizați": "canalizat",
    "canalizații": "canalizat",
    "canalizaților": "canalizat",
    "canalizato": "canalizat",
    "canalizatul": "canalizat",
    "canalizatule": "canalizat",
    "canalizatului": "canalizat",
    "canalizația": "canalizație",
    "canalizației": "canalizație",
    "canalizații": "canalizație",
    "canalizațiile": "canalizație",
    "canalizațiilor": "canalizație",
    "canalizațio": "canalizație",
    "canalizatoare": "canalizator",
    "canalizatoarea": "canalizator",
    "canalizatoarei": "canalizator",
    "canalizatoarele": "canalizator",
    "canalizatoarelor": "canalizator",
    "canalizatoareo": "canalizator",
    "canalizatori": "canalizator",
    "canalizatorii": "canalizator",
    "canalizatorilor": "canalizator",
    "canalizatorul": "canalizator",
    "canalizatorule": "canalizator",
    "canalizatorului": "canalizator",
    "canapeao": "canapea",
    "canapeaua": "canapea",
    "canapele": "canapea",
    "canapelei": "canapea",
    "canapelele": "canapea",
    "canapelelor": "canapea",
    "canapeluța": "canapeluță",
    "canapeluțe": "canapeluță",
    "canapeluței": "canapeluță",
    "canapeluțele": "canapeluță",
    "canapeluțelor": "canapeluță",
    "canapeluțo": "canapeluță",
    "canari": "canar",
    "canarii": "canar",
    "canarilor": "canar",
    "canarul": "canar",
    "canarule": "canar",
    "canarului": "canar",
    "cănărași": "cănăraș",
    "cănărașii": "cănăraș",
    "cănărașilor": "cănăraș",
    "cănărașul": "cănăraș",
    "cănărașule": "cănăraș",
    "cănărașului": "cănăraș",
    "cănărița": "cănăriță",
    "cănărițe": "cănăriță",
    "cănăriței": "cănăriță",
    "cănărițele": "cănăriță",
    "cănărițelor": "cănăriță",
    "cănărițo": "cănăriță",
    "cănăruți": "cănăruț",
    "cănăruții": "cănăruț",
    "cănăruților": "cănăruț",
    "cănăruțul": "cănăruț",
    "cănăruțule": "cănăruț",
    "cănăruțului": "cănăruț",
    "canate": "canat",
    "canatele": "canat",
    "canatelor": "canat",
    "canatul": "canat",
    "canatule": "canat",
    "canatului": "canat",
    "canaturi": "canat",
    "canaturile": "canat",
    "canaturilor": "canat",
    "canavale": "canava",
    "canavalei": "canava",
    "canavalele": "canava",
    "canavalelor": "canava",
    "canavao": "canava",
    "canavaua": "canava",
    "cancanul": "cancan",
    "cancanule": "cancan",
    "cancanului": "cancan",
    "cancanuri": "cancan",
    "cancanurile": "cancan",
    "cancanurilor": "cancan",
    "cancelari": "cancelar",
    "cancelarii": "cancelar",
    "cancelarilor": "cancelar",
    "cancelarul": "cancelar",
    "cancelarule": "cancelar",
    "cancelarului": "cancelar",
    "cancelariate": "cancelariat",
    "cancelariatele": "cancelariat",
    "cancelariatelor": "cancelariat",
    "cancelariatul": "cancelariat",
    "cancelariatule": "cancelariat",
    "cancelariatului": "cancelariat",
    "cancelaria": "cancelarie",
    "cancelariei": "cancelarie",
    "cancelarii": "cancelarie",
    "cancelariile": "cancelarie",
    "cancelariilor": "cancelarie",
    "cancelario": "cancelarie",
    "cancere": "cancer",
    "cancerele": "cancer",
    "cancerelor": "cancer",
    "cancerul": "cancer",
    "cancerule": "cancer",
    "cancerului": "cancer",
    "cancerologia": "cancerologie",
    "cancerologiei": "cancerologie",
    "cancerologii": "cancerologie",
    "cancerologio": "cancerologie",
    "canceroasa": "canceros",
    "canceroasă": "canceros",
    "canceroase": "canceros",
    "canceroasei": "canceros",
    "canceroasele": "canceros",
    "canceroaselor": "canceros",
    "canceroaso": "canceros",
    "canceroși": "canceros",
    "canceroșii": "canceros",
    "canceroșilor": "canceros",
    "cancerosul": "canceros",
    "cancerosule": "canceros",
    "cancerosului": "canceros",
    "cân'": "când",
    "candelul": "candel",
    "candelule": "candel",
    "candelului": "candel",
    "candela": "candelă",
    "candele": "candelă",
    "candelei": "candelă",
    "candelele": "candelă",
    "candelelor": "candelă",
    "candelo": "candelă",
    "cd.": "candelă",
    "candelabre": "candelabru",
    "candelabrele": "candelabru",
    "candelabrelor": "candelabru",
    "candelabrul": "candelabru",
    "candelabrule": "candelabru",
    "candelabrului": "candelabru",
    "candida": "candid",
    "candidă": "candid",
    "candide": "candid",
    "candidei": "candid",
    "candidele": "candid",
    "candidelor": "candid",
    "candido": "candid",
    "candidul": "candid",
    "candidule": "candid",
    "candidului": "candid",
    "candizi": "candid",
    "candizii": "candid",
    "candizilor": "candid",
    "candidă": "candida",
    "candidai": "candida",
    "candidam": "candida",
    "candidăm": "candida",
    "candidând": "candida",
    "candidându": "candida",
    "candidară": "candida",
    "candidarăm": "candida",
    "candidarăți": "candida",
    "candidase": "candida",
    "candidasem": "candida",
    "candidaseră": "candida",
    "candidaserăm": "candida",
    "candidaserăți": "candida",
    "candidaseși": "candida",
    "candidași": "candida",
    "candidat": "candida",
    "candidați": "candida",
    "candidatu": "candida",
    "candidau": "candida",
    "candidează": "candida",
    "candidez": "candida",
    "candideze": "candida",
    "candidezi": "candida",
    "necandidând": "candida",
    "necandidându": "candida",
    "nemaicandidând": "candida",
    "nemaicandidându": "candida",
    "candidată": "candidat",
    "candidate": "candidat",
    "candidați": "candidat",
    "candidații": "candidat",
    "candidaților": "candidat",
    "candidatul": "candidat",
    "candidatule": "candidat",
    "candidatului": "candidat",
    "candidata": "candidată",
    "candidate": "candidată",
    "candidatei": "candidată",
    "candidatele": "candidată",
    "candidatelor": "candidată",
    "candidato": "candidată",
    "candidatura": "candidatură",
    "candidaturi": "candidatură",
    "candidaturii": "candidatură",
    "candidaturile": "candidatură",
    "candidaturilor": "candidatură",
    "candidaturo": "candidatură",
    "candoarea": "candoare",
    "candoareo": "candoare",
    "candori": "candoare",
    "candorii": "candoare",
    "candorile": "candoare",
    "candorilor": "candoare",
    "candria": "candriu",
    "candrie": "candriu",
    "candriei": "candriu",
    "candrii": "candriu",
    "candriii": "candriu",
    "candriile": "candriu",
    "candriilor": "candriu",
    "candrio": "candriu",
    "candriul": "candriu",
    "candriule": "candriu",
    "candriului": "candriu",
    "caneao": "canea",
    "caneaua": "canea",
    "canele": "canea",
    "canelei": "canea",
    "canelele": "canea",
    "canelelor": "canea",
    "căneala": "căneală",
    "cănealo": "căneală",
    "căneli": "căneală",
    "cănelii": "căneală",
    "cănelile": "căneală",
    "cănelilor": "căneală",
    "canelata": "canelat",
    "canelată": "canelat",
    "canelate": "canelat",
    "canelatei": "canelat",
    "canelatele": "canelat",
    "canelatelor": "canelat",
    "canelați": "canelat",
    "canelații": "canelat",
    "canelaților": "canelat",
    "canelato": "canelat",
    "canelatul": "canelat",
    "canelatule": "canelat",
    "canelatului": "canelat",
    "canelura": "canelură",
    "caneluri": "canelură",
    "canelurii": "canelură",
    "canelurile": "canelură",
    "canelurilor": "canelură",
    "caneluro": "canelură",
    "cânepa": "cânepă",
    "cânepei": "cânepă",
    "cânepi": "cânepă",
    "cânepo": "cânepă",
    "cânepari": "cânepar",
    "câneparii": "cânepar",
    "câneparilor": "cânepar",
    "câneparul": "cânepar",
    "câneparule": "cânepar",
    "câneparului": "cânepar",
    "cânepăria": "cânepărie",
    "cânepăriei": "cânepărie",
    "cânepării": "cânepărie",
    "cânepăriile": "cânepărie",
    "cânepăriilor": "cânepărie",
    "cânepărio": "cânepărie",
    "cânepioara": "cânepioară",
    "cânepioare": "cânepioară",
    "cânepioarei": "cânepioară",
    "cânepioarele": "cânepioară",
    "cânepioarelor": "cânepioară",
    "cânepioaro": "cânepioară",
    "cânepiștea": "cânepiște",
    "cânepișteo": "cânepiște",
    "cânepiști": "cânepiște",
    "cânepiștii": "cânepiște",
    "cânepiștile": "cânepiște",
    "cânepiștilor": "cânepiște",
    "cânepie": "cânepiu",
    "cânepiei": "cânepiu",
    "cânepii": "cânepiu",
    "cangea": "cange",
    "cangeo": "cange",
    "căngi": "cange",
    "căngii": "cange",
    "căngile": "cange",
    "căngilor": "cange",
    "cangrenă": "cangrena",
    "cangrenai": "cangrena",
    "cangrenam": "cangrena",
    "cangrenăm": "cangrena",
    "cangrenând": "cangrena",
    "cangrenându": "cangrena",
    "cangrenară": "cangrena",
    "cangrenarăm": "cangrena",
    "cangrenarăți": "cangrena",
    "cangrenase": "cangrena",
    "cangrenasem": "cangrena",
    "cangrenaseră": "cangrena",
    "cangrenaserăm": "cangrena",
    "cangrenaserăți": "cangrena",
    "cangrenaseși": "cangrena",
    "cangrenași": "cangrena",
    "cangrenat": "cangrena",
    "cangrenați": "cangrena",
    "cangrenatu": "cangrena",
    "cangrenau": "cangrena",
    "cangrenează": "cangrena",
    "cangrenez": "cangrena",
    "cangreneze": "cangrena",
    "cangrenezi": "cangrena",
    "necangrenând": "cangrena",
    "necangrenându": "cangrena",
    "nemaicangrenând": "cangrena",
    "nemaicangrenându": "cangrena",
    "cangrena": "cangrenă",
    "cangrene": "cangrenă",
    "cangrenei": "cangrenă",
    "cangrenele": "cangrenă",
    "cangrenelor": "cangrenă",
    "cangreno": "cangrenă",
    "cangrenata": "cangrenat",
    "cangrenată": "cangrenat",
    "cangrenate": "cangrenat",
    "cangrenatei": "cangrenat",
    "cangrenatele": "cangrenat",
    "cangrenatelor": "cangrenat",
    "cangrenați": "cangrenat",
    "cangrenații": "cangrenat",
    "cangrenaților": "cangrenat",
    "cangrenato": "cangrenat",
    "cangrenatul": "cangrenat",
    "cangrenatule": "cangrenat",
    "cangrenatului": "cangrenat",
    "cangrenoasa": "cangrenos",
    "cangrenoasă": "cangrenos",
    "cangrenoase": "cangrenos",
    "cangrenoasei": "cangrenos",
    "cangrenoasele": "cangrenos",
    "cangrenoaselor": "cangrenos",
    "cangrenoaso": "cangrenos",
    "cangrenoși": "cangrenos",
    "cangrenoșii": "cangrenos",
    "cangrenoșilor": "cangrenos",
    "cangrenosul": "cangrenos",
    "cangrenosule": "cangrenos",
    "cangrenosului": "cangrenos",
    "canguri": "cangur",
    "cangurii": "cangur",
    "cangurilor": "cangur",
    "cangurul": "cangur",
    "cangurule": "cangur",
    "cangurului": "cangur",
    "cănea": "căni",
    "căneai": "căni",
    "căneam": "căni",
    "cănească": "căni",
    "căneați": "căni",
    "căneau": "căni",
    "cănesc": "căni",
    "cănește": "căni",
    "cănești": "căni",
    "cănii": "căni",
    "cănim": "căni",
    "cănind": "căni",
    "cănindu": "căni",
    "căniră": "căni",
    "cănirăm": "căni",
    "cănirăți": "căni",
    "cănise": "căni",
    "cănisem": "căni",
    "căniseră": "căni",
    "căniserăm": "căni",
    "căniserăți": "căni",
    "căniseși": "căni",
    "căniși": "căni",
    "cănit": "căni",
    "căniți": "căni",
    "cănitu": "căni",
    "necănind": "căni",
    "necănindu": "căni",
    "nemaicănind": "căni",
    "nemaicănindu": "căni",
    "canibali": "canibal",
    "canibalii": "canibal",
    "canibalilor": "canibal",
    "canibalul": "canibal",
    "canibalule": "canibal",
    "canibalului": "canibal",
    "canibala": "canibală",
    "canibale": "canibală",
    "canibalei": "canibală",
    "canibalele": "canibală",
    "canibalelor": "canibală",
    "canibalo": "canibală",
    "canibalica": "canibalic",
    "canibalică": "canibalic",
    "canibalice": "canibalic",
    "canibalicei": "canibalic",
    "canibalicele": "canibalic",
    "canibalicelor": "canibalic",
    "canibalici": "canibalic",
    "canibalicii": "canibalic",
    "canibalicilor": "canibalic",
    "canibalico": "canibalic",
    "canibalicul": "canibalic",
    "canibalicule": "canibalic",
    "canibalicului": "canibalic",
    "canibalismul": "canibalism",
    "canibalismule": "canibalism",
    "canibalismului": "canibalism",
    "canicula": "caniculă",
    "canicule": "caniculă",
    "caniculei": "caniculă",
    "caniculele": "caniculă",
    "caniculelor": "caniculă",
    "caniculo": "caniculă",
    "caniculara": "canicular",
    "caniculară": "canicular",
    "caniculare": "canicular",
    "canicularei": "canicular",
    "canicularele": "canicular",
    "canicularelor": "canicular",
    "caniculari": "canicular",
    "canicularii": "canicular",
    "canicularilor": "canicular",
    "canicularo": "canicular",
    "canicularul": "canicular",
    "canicularule": "canicular",
    "canicularului": "canicular",
    "canina": "canin",
    "canină": "canin",
    "canine": "canin",
    "caninei": "canin",
    "caninele": "canin",
    "caninelor": "canin",
    "canini": "canin",
    "caninii": "canin",
    "caninilor": "canin",
    "canino": "canin",
    "caninul": "canin",
    "caninule": "canin",
    "caninului": "canin",
    "cănirea": "cănire",
    "cănireo": "cănire",
    "căniri": "cănire",
    "cănirii": "cănire",
    "cănirile": "cănire",
    "cănirilor": "cănire",
    "canistra": "canistră",
    "canistre": "canistră",
    "canistrei": "canistră",
    "canistrele": "canistră",
    "canistrelor": "canistră",
    "canistro": "canistră",
    "cănită": "cănit",
    "cănite": "cănit",
    "căniți": "cănit",
    "cănița": "căniță",
    "cănițe": "căniță",
    "căniței": "căniță",
    "cănițele": "căniță",
    "cănițelor": "căniță",
    "cănițo": "căniță",
    "canoea": "canoe",
    "canoei": "canoe",
    "canoele": "canoe",
    "canoelor": "canoe",
    "canoeo": "canoe",
    "canoane": "canon",
    "canoanele": "canon",
    "canoanelor": "canon",
    "canonul": "canon",
    "canonule": "canon",
    "canonului": "canon",
    "canonada": "canonadă",
    "canonade": "canonadă",
    "canonadei": "canonadă",
    "canonadele": "canonadă",
    "canonadelor": "canonadă",
    "canonado": "canonadă",
    "canonea": "canoni",
    "canoneai": "canoni",
    "canoneam": "canoni",
    "canonească": "canoni",
    "canoneați": "canoni",
    "canoneau": "canoni",
    "canonesc": "canoni",
    "canonește": "canoni",
    "canonești": "canoni",
    "canonii": "canoni",
    "canonim": "canoni",
    "canonind": "canoni",
    "canonindu": "canoni",
    "canoniră": "canoni",
    "canonirăm": "canoni",
    "canonirăți": "canoni",
    "canonise": "canoni",
    "canonisem": "canoni",
    "canoniseră": "canoni",
    "canoniserăm": "canoni",
    "canoniserăți": "canoni",
    "canoniseși": "canoni",
    "canoniși": "canoni",
    "canonit": "canoni",
    "canoniți": "canoni",
    "canonitu": "canoni",
    "necanonind": "canoni",
    "necanonindu": "canoni",
    "nemaicanonind": "canoni",
    "nemaicanonindu": "canoni",
    "canonica": "canonic",
    "canonică": "canonic",
    "canonice": "canonic",
    "canonicei": "canonic",
    "canonicele": "canonic",
    "canonicelor": "canonic",
    "canonici": "canonic",
    "canonicii": "canonic",
    "canonicilor": "canonic",
    "canonico": "canonic",
    "canonicul": "canonic",
    "canonicule": "canonic",
    "canonicului": "canonic",
    "canonicatul": "canonicat",
    "canonicatule": "canonicat",
    "canonicatului": "canonicat",
    "canoniera": "canonieră",
    "canoniere": "canonieră",
    "canonierei": "canonieră",
    "canonierele": "canonieră",
    "canonierelor": "canonieră",
    "canoniero": "canonieră",
    "canonită": "canonit",
    "canonite": "canonit",
    "canoniți": "canonit",
    "canoniză": "canoniza",
    "canonizai": "canoniza",
    "canonizam": "canoniza",
    "canonizăm": "canoniza",
    "canonizând": "canoniza",
    "canonizându": "canoniza",
    "canonizară": "canoniza",
    "canonizarăm": "canoniza",
    "canonizarăți": "canoniza",
    "canonizase": "canoniza",
    "canonizasem": "canoniza",
    "canonizaseră": "canoniza",
    "canonizaserăm": "canoniza",
    "canonizaserăți": "canoniza",
    "canonizaseși": "canoniza",
    "canonizași": "canoniza",
    "canonizat": "canoniza",
    "canonizați": "canoniza",
    "canonizatu": "canoniza",
    "canonizau": "canoniza",
    "canonizează": "canoniza",
    "canonizez": "canoniza",
    "canonizeze": "canoniza",
    "canonizezi": "canoniza",
    "necanonizând": "canoniza",
    "necanonizându": "canoniza",
    "nemaicanonizând": "canoniza",
    "nemaicanonizându": "canoniza",
    "canonizarea": "canonizare",
    "canonizareo": "canonizare",
    "canonizări": "canonizare",
    "canonizării": "canonizare",
    "canonizările": "canonizare",
    "canonizărilor": "canonizare",
    "canonizată": "canonizat",
    "canonizate": "canonizat",
    "canonizați": "canonizat",
    "canotaje": "canotaj",
    "canotajele": "canotaj",
    "canotajelor": "canotaj",
    "canotajul": "canotaj",
    "canotajule": "canotaj",
    "canotajului": "canotaj",
    "canotiera": "canotieră",
    "canotiere": "canotieră",
    "canotierei": "canotieră",
    "canotierele": "canotieră",
    "canotierelor": "canotieră",
    "canotiero": "canotieră",
    "canotoarea": "canotoare",
    "canotoarei": "canotoare",
    "canotoarele": "canotoare",
    "canotoarelor": "canotoare",
    "canotoareo": "canotoare",
    "canotori": "canotor",
    "canotorii": "canotor",
    "canotorilor": "canotor",
    "canotorul": "canotor",
    "canotorule": "canotor",
    "canotorului": "canotor",
    "cantul": "cant",
    "cantule": "cant",
    "cantului": "cant",
    "canturi": "cant",
    "canturile": "cant",
    "canturilor": "cant",
    "cântul": "cânt",
    "cântule": "cânt",
    "cântului": "cânt",
    "cânturi": "cânt",
    "cânturile": "cânt",
    "cânturilor": "cânt",
    "cânt": "cânta",
    "cântă": "cânta",
    "cântai": "cânta",
    "cântam": "cânta",
    "cântăm": "cânta",
    "cântând": "cânta",
    "cântându": "cânta",
    "cântară": "cânta",
    "cântarăm": "cânta",
    "cântarăți": "cânta",
    "cântase": "cânta",
    "cântasem": "cânta",
    "cântaseră": "cânta",
    "cântaserăm": "cânta",
    "cântaserăți": "cânta",
    "cântaseși": "cânta",
    "cântași": "cânta",
    "cântat": "cânta",
    "cântați": "cânta",
    "cântatu": "cânta",
    "cântau": "cânta",
    "cânte": "cânta",
    "cânți": "cânta",
    "necântând": "cânta",
    "necântându": "cânta",
    "nemaicântând": "cânta",
    "nemaicântându": "cânta",
    "cantalupi": "cantalup",
    "cantalupii": "cantalup",
    "cantalupilor": "cantalup",
    "cantalupul": "cantalup",
    "cantalupule": "cantalup",
    "cantalupului": "cantalup",
    "cântare": "cântar",
    "cântarele": "cântar",
    "cântarelor": "cântar",
    "cântarul": "cântar",
    "cântarule": "cântar",
    "cântarului": "cântar",
    "cântarea": "cântare",
    "cântareo": "cântare",
    "cântări": "cântare",
    "cântării": "cântare",
    "cântările": "cântare",
    "cântărilor": "cântare",
    "cântăreala": "cântăreală",
    "cântărealo": "cântăreală",
    "cântăreli": "cântăreală",
    "cântărelii": "cântăreală",
    "cântărelile": "cântăreală",
    "cântărelilor": "cântăreală",
    "cântăreața": "cântăreață",
    "cântăreațo": "cântăreață",
    "cântărețe": "cântăreață",
    "cântăreței": "cântăreață",
    "cântărețele": "cântăreață",
    "cântărețelor": "cântăreață",
    "cântăreți": "cântăreț",
    "cântăreții": "cântăreț",
    "cântăreților": "cântăreț",
    "cântărețul": "cântăreț",
    "cântărețule": "cântăreț",
    "cântărețului": "cântăreț",
    "cântărea": "cântări",
    "cântăreai": "cântări",
    "cântăream": "cântări",
    "cântărească": "cântări",
    "cântăreați": "cântări",
    "cântăreau": "cântări",
    "cântăresc": "cântări",
    "cântărește": "cântări",
    "cântărești": "cântări",
    "cântării": "cântări",
    "cântărim": "cântări",
    "cântărind": "cântări",
    "cântărindu": "cântări",
    "cântăriră": "cântări",
    "cântărirăm": "cântări",
    "cântărirăți": "cântări",
    "cântărise": "cântări",
    "cântărisem": "cântări",
    "cântăriseră": "cântări",
    "cântăriserăm": "cântări",
    "cântăriserăți": "cântări",
    "cântăriseși": "cântări",
    "cântăriși": "cântări",
    "cântărit": "cântări",
    "cântăriți": "cântări",
    "cântăritu": "cântări",
    "necântărind": "cântări",
    "necântărindu": "cântări",
    "nemaicântărind": "cântări",
    "nemaicântărindu": "cântări",
    "cantarida": "cantaridă",
    "cantaride": "cantaridă",
    "cantaridei": "cantaridă",
    "cantaridele": "cantaridă",
    "cantaridelor": "cantaridă",
    "cantarido": "cantaridă",
    "cântărirea": "cântărire",
    "cântărireo": "cântărire",
    "cântăriri": "cântărire",
    "cântăririi": "cântărire",
    "cântăririle": "cântărire",
    "cântăririlor": "cântărire",
    "cântărita": "cântărit",
    "cântărită": "cântărit",
    "cântărite": "cântărit",
    "cântăritei": "cântărit",
    "cântăritele": "cântărit",
    "cântăritelor": "cântărit",
    "cântăriți": "cântărit",
    "cântăriții": "cântărit",
    "cântăriților": "cântărit",
    "cântărito": "cântărit",
    "cântăritul": "cântărit",
    "cântăritule": "cântărit",
    "cântăritului": "cântărit",
    "cântată": "cântat",
    "cântate": "cântat",
    "cântați": "cântat",
    "cântatul": "cântat",
    "cântatule": "cântat",
    "cântatului": "cântat",
    "cantata": "cantată",
    "cantate": "cantată",
    "cantatei": "cantată",
    "cantatele": "cantată",
    "cantatelor": "cantată",
    "cantato": "cantată",
    "cântătoare": "cântător",
    "cântătoarea": "cântător",
    "cântătoarei": "cântător",
    "cântătoarele": "cântător",
    "cântătoarelor": "cântător",
    "cântătoareo": "cântător",
    "cântători": "cântător",
    "cântătorii": "cântător",
    "cântătorilor": "cântător",
    "cântătorul": "cântător",
    "cântătorule": "cântător",
    "cântătorului": "cântător",
    "cântece": "cântec",
    "cântecele": "cântec",
    "cântecelor": "cântec",
    "cântecul": "cântec",
    "cântecule": "cântec",
    "cântecului": "cântec",
    "cânticele": "cântec",
    "cântecele": "cântecel",
    "cântecelele": "cântecel",
    "cântecelelor": "cântecel",
    "cântecelul": "cântecel",
    "cântecelule": "cântecel",
    "cântecelului": "cântecel",
    "cânticele": "cântecel",
    "cantina": "cantină",
    "cantine": "cantină",
    "cantinei": "cantină",
    "cantinele": "cantină",
    "cantinelor": "cantină",
    "cantino": "cantină",
    "cantinieri": "cantinier",
    "cantinierii": "cantinier",
    "cantinierilor": "cantinier",
    "cantinierul": "cantinier",
    "cantinierule": "cantinier",
    "cantinierului": "cantinier",
    "cantiniera": "cantinieră",
    "cantiniere": "cantinieră",
    "cantinierei": "cantinieră",
    "cantinierele": "cantinieră",
    "cantinierelor": "cantinieră",
    "cantiniero": "cantinieră",
    "cantitatea": "cantitate",
    "cantitateo": "cantitate",
    "cantități": "cantitate",
    "cantității": "cantitate",
    "cantitățile": "cantitate",
    "cantităților": "cantitate",
    "cantitativa": "cantitativ",
    "cantitativă": "cantitativ",
    "cantitative": "cantitativ",
    "cantitativei": "cantitativ",
    "cantitativele": "cantitativ",
    "cantitativelor": "cantitativ",
    "cantitativi": "cantitativ",
    "cantitativii": "cantitativ",
    "cantitativilor": "cantitativ",
    "cantitativo": "cantitativ",
    "cantitativul": "cantitativ",
    "cantitativule": "cantitativ",
    "cantitativului": "cantitativ",
    "cantoane": "canton",
    "cantoanele": "canton",
    "cantoanelor": "canton",
    "cantonul": "canton",
    "cantonule": "canton",
    "cantonului": "canton",
    "canțoneta": "canțonetă",
    "canțonete": "canțonetă",
    "canțonetei": "canțonetă",
    "canțonetele": "canțonetă",
    "canțonetelor": "canțonetă",
    "canțoneto": "canțonetă",
    "cantonieri": "cantonier",
    "cantonierii": "cantonier",
    "cantonierilor": "cantonier",
    "cantonierul": "cantonier",
    "cantonierule": "cantonier",
    "cantonierului": "cantonier",
    "cantoniera": "cantonieră",
    "cantoniere": "cantonieră",
    "cantonierei": "cantonieră",
    "cantonierele": "cantonieră",
    "cantonierelor": "cantonieră",
    "cantoniero": "cantonieră",
    "cantori": "cantor",
    "cantorii": "cantor",
    "cantorilor": "cantor",
    "cantorul": "cantor",
    "cantorule": "cantor",
    "cantorului": "cantor",
    "caol.": "caolin",
    "caolini": "caolin",
    "caolinii": "caolin",
    "caolinilor": "caolin",
    "caolinul": "caolin",
    "caolinule": "caolin",
    "caolinului": "caolin",
    "capete": "cap",
    "capetele": "cap",
    "capetelor": "cap",
    "capi": "cap",
    "capii": "cap",
    "capilor": "cap",
    "capu'": "cap",
    "capu-": "cap",
    "capul": "cap",
    "capule": "cap",
    "capului": "cap",
    "capuri": "cap",
    "capurile": "cap",
    "capurilor": "cap",
    "capa": "capă",
    "cape": "capă",
    "capei": "capă",
    "capele": "capă",
    "capelor": "capă",
    "capo": "capă",
    "capabila": "capabil",
    "capabilă": "capabil",
    "capabile": "capabil",
    "capabilei": "capabil",
    "capabilele": "capabil",
    "capabilelor": "capabil",
    "capabili": "capabil",
    "capabilii": "capabil",
    "capabililor": "capabil",
    "capabilo": "capabil",
    "capabilul": "capabil",
    "capabilule": "capabil",
    "capabilului": "capabil",
    "capace": "capac",
    "capacele": "capac",
    "capacelor": "capac",
    "capacul": "capac",
    "capacule": "capac",
    "capacului": "capac",
    "căpăcele": "căpăcel",
    "căpăcelele": "căpăcel",
    "căpăcelelor": "căpăcel",
    "căpăcelul": "căpăcel",
    "căpăcelule": "căpăcel",
    "căpăcelului": "căpăcel",
    "capacitatea": "capacitate",
    "capacitateo": "capacitate",
    "capacități": "capacitate",
    "capacității": "capacitate",
    "capacitățile": "capacitate",
    "capacităților": "capacitate",
    "căpăstrul": "căpăstru",
    "căpăstrule": "căpăstru",
    "căpăstrului": "căpăstru",
    "căpestre": "căpăstru",
    "căpestrele": "căpăstru",
    "căpestrelor": "căpăstru",
    "capătul": "capăt",
    "capătule": "capăt",
    "capătului": "capăt",
    "capete": "capăt",
    "capetele": "capăt",
    "capetelor": "capăt",
    "capăt": "căpăta",
    "capătă": "căpăta",
    "căpătă": "căpăta",
    "căpătai": "căpăta",
    "căpătam": "căpăta",
    "căpătăm": "căpăta",
    "căpătând": "căpăta",
    "căpătându": "căpăta",
    "căpătară": "căpăta",
    "căpătarăm": "căpăta",
    "căpătarăți": "căpăta",
    "căpătase": "căpăta",
    "căpătasem": "căpăta",
    "căpătaseră": "căpăta",
    "căpătaserăm": "căpăta",
    "căpătaserăți": "căpăta",
    "căpătaseși": "căpăta",
    "căpătași": "căpăta",
    "căpătat": "căpăta",
    "căpătați": "căpăta",
    "căpătatu": "căpăta",
    "căpătau": "căpăta",
    "capete": "căpăta",
    "capeți": "căpăta",
    "necăpătând": "căpăta",
    "necăpătându": "căpăta",
    "nemaicăpătând": "căpăta",
    "nemaicăpătându": "căpăta",
    "căpătâie": "căpătâi",
    "căpătâiele": "căpătâi",
    "căpătâielor": "căpătâi",
    "căpătâiul": "căpătâi",
    "căpătâiule": "căpătâi",
    "căpătâiului": "căpătâi",
    "căpățâna": "căpățână",
    "căpățâni": "căpățână",
    "căpățânii": "căpățână",
    "căpățânile": "căpățână",
    "căpățânilor": "căpățână",
    "căpățâno": "căpățână",
    "căpățânoasa": "căpățânos",
    "căpățânoasă": "căpățânos",
    "căpățânoase": "căpățânos",
    "căpățânoasei": "căpățânos",
    "căpățânoasele": "căpățânos",
    "căpățânoaselor": "căpățânos",
    "căpățânoaso": "căpățânos",
    "căpățânoși": "căpățânos",
    "căpățânoșii": "căpățânos",
    "căpățânoșilor": "căpățânos",
    "căpățânosul": "căpățânos",
    "căpățânosule": "căpățânos",
    "căpățânosului": "căpățânos",
    "căpătarea": "căpătare",
    "căpătareo": "căpătare",
    "căpătări": "căpătare",
    "căpătării": "căpătare",
    "căpătările": "căpătare",
    "căpătărilor": "căpătare",
    "căpătată": "căpătat",
    "căpătate": "căpătat",
    "căpătați": "căpătat",
    "căpătatul": "căpătat",
    "căpătatule": "căpătat",
    "căpătatului": "căpătat",
    "căpătuia": "căpătui",
    "căpătuiai": "căpătui",
    "căpătuiam": "căpătui",
    "căpătuiască": "căpătui",
    "căpătuiați": "căpătui",
    "căpătuiau": "căpătui",
    "căpătuiesc": "căpătui",
    "căpătuiește": "căpătui",
    "căpătuiești": "căpătui",
    "căpătuii": "căpătui",
    "căpătuim": "căpătui",
    "căpătuind": "căpătui",
    "căpătuindu": "căpătui",
    "căpătuiră": "căpătui",
    "căpătuirăm": "căpătui",
    "căpătuirăți": "căpătui",
    "căpătuise": "căpătui",
    "căpătuisem": "căpătui",
    "căpătuiseră": "căpătui",
    "căpătuiserăm": "căpătui",
    "căpătuiserăți": "căpătui",
    "căpătuiseși": "căpătui",
    "căpătuiși": "căpătui",
    "căpătuit": "căpătui",
    "căpătuiți": "căpătui",
    "căpătuitu": "căpătui",
    "necăpătuind": "căpătui",
    "necăpătuindu": "căpătui",
    "nemaicăpătuind": "căpătui",
    "nemaicăpătuindu": "căpătui",
    "căpătuiala": "căpătuială",
    "căpătuialo": "căpătuială",
    "căpătuieli": "căpătuială",
    "căpătuielii": "căpătuială",
    "căpătuielile": "căpătuială",
    "căpătuielilor": "căpătuială",
    "căpătuirea": "căpătuire",
    "căpătuireo": "c