#!/usr/local/bin/python
#
# Copyright (c) 2003 Neil Blakey-Milner
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#

import cgi
import re
import urlparse

import config

def genericSearch(referers, prefixes = config.SEARCH_PREFIXES):
    searches = {}

    for url in referers:
        o = None
        info = urlparse.urlsplit(url)
        query = info[3]
        c = cgi.parse_qs(query)
        for chance in prefixes:
            if c.has_key(chance):
                o = c[chance][0].lower()
        if o is None:
            print "%s -> None" % (url)
            continue
        o = o.strip()

        if o in config.EXCLUDESEARCHES:
            continue

        #print "%s -> %s" % (url, o)

        searches.setdefault(o, 0)
        searches[o] = searches[o] + 1

    return searches

def getSearches(referers):
    """From a dictionary of with simplified referers and keys, and a
    list of URLs as values, determine the search terms used."""
    searches = {}

    allurls = []
    for sr, urls in referers.items():
        for url in urls:
            allurls.append(url)
        
    thissearch = genericSearch(allurls)
    for search, num in thissearch.items():
        searches.setdefault(search, 0)
        searches[search] = searches[search] + num

    return searches
