/*
compile with 
    g++ ann_test.cpp -I../.. -L../../../lib -lANN -o ann_test
*/

#include <ANN/ANN.h>
#import <iostream>
#import <math.h>

#define PTS_N 58
#define PTS_M 3

using namespace std;
    
int main(int argc, char **argv) {
    
    double pts[] = {0.32548598756858171, 0.27136764092071997, 0.76212938521332818, 0.26336903907458842, 0.46859320967187634, 0.41827095582474028, 0.77755350863283268, 0.0073673231113967619, 0.70649806198342435, 0.54316391339918391, 0.61362243304565012, 0.9160356345045072, 0.41330158063931322, 0.34923589790530007, 0.88333126369747006, 0.60276213260751077, 0.81872898705671404, 0.16524512256939972, 0.51560092648346001, 0.14763410188365145, 0.99811859724626184, 0.55992167425190031, 0.50504312965949549, 0.83562533307984355, 0.18804051785745568, 0.9047826100166465, 0.59247150997371201, 0.53275358762931202, 0.6061054759731791, 0.37741496623728221, 0.74722172706331236, 0.48482032543138165, 0.97365727041548855, 0.80356689837773665, 0.86263676478430307, 0.94434023698487668, 0.96292953766712719, 0.90656130414832603, 0.55393211260507957, 0.89555948757345549, 0.78826641814117804, 0.4605263571318825, 0.60929718817831402, 0.71506561225186771, 0.46561831241025153, 0.31141152593704535, 0.46616011969547122, 0.43818065706820575, 0.38235163238578318, 0.4202391435102073, 0.48454733078614298, 0.22160526454826002, 0.3130711474399519, 0.11859838865908867, 0.6429102794865601, 0.24134973435051932, 0.96183534384931801, 0.12556761271892725, 0.21663270335950946, 0.16558003134202481, 0.15565363507737728, 0.11901035223188883, 0.53401621920979181, 0.94955854053848154, 0.13870608762947023, 0.82131053964084266, 0.6115724642376964, 0.76685699456195544, 0.25987472708359138, 0.84187352538551685, 0.75993698593763925, 0.53851655993746439, 0.75800595372130031, 0.19641939601763525, 0.32984123001257537, 0.20308247155669212, 0.58199359380268778, 0.6892489349949299, 0.71381860165199162, 0.256379136031887, 0.73230116752507524, 0.091740388555981434, 0.59321476864541944, 0.060506692474113444, 0.7339500014165089, 0.024652478399712408, 0.042051130761412314, 0.23292582301984832, 0.28456553343218505, 0.96753383660029701, 0.47350689141831159, 0.38615561809810139, 0.7067979688331818, 0.22769926983559163, 0.46293186959450461, 0.29183968130112414, 0.92491943493406303, 0.96746070948284946, 0.079256502623437752, 0.66089175344674933, 0.61169728645828236, 0.94972050619028203, 0.00505457464445358, 0.54844734325031408, 0.66681983186499427, 0.17277009292224543, 0.1008972455385998, 0.81292988255435461, 0.54065139928356643, 0.96448290845420126, 0.39514390647107922, 0.12286288570272053, 0.74403335989410979, 0.26051679081245038, 0.40438538006816216, 0.89014494134649746, 0.95199865583080412, 0.92488112143241374, 0.37670751540092007, 0.91817077794226587, 0.88302485756708671, 0.33847973318381142, 0.97775126953163716, 0.54698718594155737, 0.88719025205634527, 0.69987558861644072, 0.17185192513553504, 0.12018973717603598, 0.60934268497854593, 0.25343699673342523, 0.71184132741856176, 0.22588412579138994, 0.58693246430492918, 0.67590538004942757, 0.25614160391205198, 0.68363091081788896, 0.69804313630127424, 0.74257119555806095, 0.24880347014922333, 0.80519962311136051, 0.26542713605673285, 0.20114891582426719, 0.44100385870113545, 0.43102492889832, 0.17580188566724564, 0.094751211924065992, 0.83662575105905368, 0.44955475770094899, 0.083919518134501825, 0.12260546980731901, 0.69174488341943186, 0.26415172766841433, 0.74638748699384783, 0.10024026900710914, 0.044982125529644534, 0.7418923008192766, 0.70047072689823819, 0.82605326861921524, 0.072813351123696024, 0.26923846088360703, 0.5379838529407357, 0.044235727510310574, 0.73463376573413075, 0.4130492211954514, 0.19807829040741509, 0.33540957176075925, 0.042693183920400002, 0.037385912262865029, 0.34869444760839163, 0.81983849720696267, 0.33602224356194865, 0.99827584648210765, 0.40759649334482095, 0.45582787186328688};
    
    ANNpointArray ptsArr = annAllocPts(PTS_N,PTS_M);
    for(int i=0; i<PTS_N; i++) {
        for(int j=0; j<PTS_M; j++) {
            ptsArr[i][j] = pts[i*PTS_M+j];
        }
    }
    
    ANNkd_tree tree(ptsArr, PTS_N, PTS_M);
    
    ANNdist sqDist;
    ANNidx idx;
    for(int i=0; i<PTS_N; i++) {
        tree.annkSearch(ptsArr[i], 1 , &idx, &sqDist);
        cout << i << ": " << sqDist << '\n';
    }
    
    return 0;
}