#!/usr/bin/env python

import sys
import saga

def main():

    try:
        # Your ssh identity on the remote machine.
        ctx = saga.Context("ssh")

        session = saga.Session()
        session.add_context(ctx)

        # open home directory on a remote machine
        remote_dir = saga.filesystem.Directory('sftp://gw68.quarry.iu.teragrid.org/home/oweidner/test',
                                               session=session)

        for entry in remote_dir.list():
            print "- %12s %s" % (remote_dir.get_size(entry), entry)

            remote_dir = saga.filesystem.Directory('sftp://gw68.quarry.iu.teragrid.org/home/oweidner/test/',
                                                   session=session)

            remote_dir.copy(entry, 'file://localhost/tmp/%s' % entry)

        return 0

    except saga.SagaException, ex:
        # Catch all saga exceptions
        print "An exception occured: (%s) %s " % (ex.type, (str(ex)))
        # Trace back the exception. That can be helpful for debugging.
        print " \n*** Backtrace:\n %s" % ex.traceback
        return -1

if __name__ == "__main__":
    sys.exit(main())
