/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.FormFieldWithNameHistory;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlButton
extends HtmlElement
implements DisabledElement,
SubmittableElement,
FormFieldWithNameHistory {
    private static final Log LOG = LogFactory.getLog(HtmlButton.class);
    public static final String TAG_NAME = "button";
    private String originalName_;
    private Collection<String> newNames_ = Collections.emptySet();

    HtmlButton(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        this.originalName_ = this.getNameAttribute();
        if ((attributes == null || !attributes.containsKey("type")) && this.hasFeature(BrowserVersionFeatures.BUTTON_EMPTY_TYPE_BUTTON) && page instanceof HtmlPage && !((HtmlPage)page).isQuirksMode()) {
            this.setAttribute("type", "submit");
        }
    }

    public void setValueAttribute(String newValue) {
        this.setAttribute("value", newValue);
    }

    @Override
    protected boolean doClickStateUpdate() throws IOException {
        String type = this.getTypeAttribute().toLowerCase(Locale.ENGLISH);
        HtmlForm form = this.getEnclosingForm();
        if (form != null) {
            if (TAG_NAME.equals(type)) {
                return false;
            }
            if ("submit".equals(type)) {
                form.submit(this);
                return false;
            }
            if ("reset".equals(type)) {
                form.reset();
                return false;
            }
            if (this.hasFeature(BrowserVersionFeatures.BUTTON_UNKNOWN_TYPE_DOES_NOT_SUBMIT)) {
                return false;
            }
            form.submit(this);
            return false;
        }
        super.doClickStateUpdate();
        return false;
    }

    @Override
    public final boolean isDisabled() {
        return this.hasAttribute("disabled");
    }

    @Override
    public NameValuePair[] getSubmitKeyValuePairs() {
        return new NameValuePair[]{new NameValuePair(this.getNameAttribute(), this.getValueAttribute())};
    }

    @Override
    public void reset() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("reset() not implemented for this element");
        }
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setDefaultValue() not implemented for this element");
        }
    }

    @Override
    public String getDefaultValue() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getDefaultValue() not implemented for this element");
        }
        return "";
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public boolean isDefaultChecked() {
        return false;
    }

    public final String getNameAttribute() {
        return this.getAttribute("name");
    }

    public final String getValueAttribute() {
        return this.getAttribute("value");
    }

    @Override
    public String getAttribute(String attributeName) {
        String type = super.getAttribute(attributeName);
        if (type == DomElement.ATTRIBUTE_NOT_DEFINED && "type".equalsIgnoreCase(attributeName)) {
            type = this.hasFeature(BrowserVersionFeatures.BUTTON_EMPTY_TYPE_BUTTON) ? TAG_NAME : "submit";
        }
        return type;
    }

    public final String getTypeAttribute() {
        return this.getAttribute("type");
    }

    @Override
    public final String getDisabledAttribute() {
        return this.getAttribute("disabled");
    }

    public final String getTabIndexAttribute() {
        return this.getAttribute("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttribute("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttribute("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttribute("onblur");
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        if ("name".equals(qualifiedName)) {
            if (this.newNames_.isEmpty()) {
                this.newNames_ = new HashSet<String>();
            }
            this.newNames_.add(attributeValue);
        }
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue);
    }

    @Override
    public String getOriginalName() {
        return this.originalName_;
    }

    @Override
    public Collection<String> getNewNames() {
        return this.newNames_;
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE_BLOCK;
    }
}

