import CFNetwork
from PyObjCTools.TestSupport import TestCase, min_os_level


class TestCFNetwork(TestCase):
    @min_os_level("10.5")
    def testConstants10_5(self):
        self.assertIsInstance(CFNetwork.kCFErrorDomainCFNetwork, str)
        self.assertIsInstance(CFNetwork.kCFErrorDomainWinSock, str)
        self.assertIsInstance(CFNetwork.kCFGetAddrInfoFailureKey, str)
        self.assertIsInstance(CFNetwork.kCFSOCKSStatusCodeKey, str)
        self.assertIsInstance(CFNetwork.kCFSOCKSVersionKey, str)
        self.assertIsInstance(CFNetwork.kCFSOCKSNegotiationMethodKey, str)
        self.assertIsInstance(CFNetwork.kCFDNSServiceFailureKey, str)
        self.assertIsInstance(CFNetwork.kCFFTPStatusCodeKey, str)
        self.assertIsInstance(CFNetwork.kCFURLErrorFailingURLErrorKey, str)
        self.assertIsInstance(CFNetwork.kCFURLErrorFailingURLStringErrorKey, str)

    @min_os_level("10.6")
    def testConstants10_6(self):
        self.assertEqual(CFNetwork.kCFErrorPACFileAuth, 309)
        self.assertEqual(CFNetwork.kCFErrorHTTPSProxyConnectionFailure, 310)

        self.assertEqual(CFNetwork.kCFURLErrorUnknown, -998)
        self.assertEqual(CFNetwork.kCFURLErrorCancelled, -999)
        self.assertEqual(CFNetwork.kCFURLErrorBadURL, -1000)
        self.assertEqual(CFNetwork.kCFURLErrorTimedOut, -1001)
        self.assertEqual(CFNetwork.kCFURLErrorUnsupportedURL, -1002)
        self.assertEqual(CFNetwork.kCFURLErrorCannotFindHost, -1003)
        self.assertEqual(CFNetwork.kCFURLErrorCannotConnectToHost, -1004)
        self.assertEqual(CFNetwork.kCFURLErrorNetworkConnectionLost, -1005)
        self.assertEqual(CFNetwork.kCFURLErrorDNSLookupFailed, -1006)
        self.assertEqual(CFNetwork.kCFURLErrorHTTPTooManyRedirects, -1007)
        self.assertEqual(CFNetwork.kCFURLErrorResourceUnavailable, -1008)
        self.assertEqual(CFNetwork.kCFURLErrorNotConnectedToInternet, -1009)
        self.assertEqual(CFNetwork.kCFURLErrorRedirectToNonExistentLocation, -1010)
        self.assertEqual(CFNetwork.kCFURLErrorBadServerResponse, -1011)
        self.assertEqual(CFNetwork.kCFURLErrorUserCancelledAuthentication, -1012)
        self.assertEqual(CFNetwork.kCFURLErrorUserAuthenticationRequired, -1013)
        self.assertEqual(CFNetwork.kCFURLErrorZeroByteResource, -1014)
        self.assertEqual(CFNetwork.kCFURLErrorCannotDecodeRawData, -1015)
        self.assertEqual(CFNetwork.kCFURLErrorCannotDecodeContentData, -1016)
        self.assertEqual(CFNetwork.kCFURLErrorCannotParseResponse, -1017)
        self.assertEqual(CFNetwork.kCFURLErrorInternationalRoamingOff, -1018)
        self.assertEqual(CFNetwork.kCFURLErrorCallIsActive, -1019)
        self.assertEqual(CFNetwork.kCFURLErrorDataNotAllowed, -1020)
        self.assertEqual(CFNetwork.kCFURLErrorRequestBodyStreamExhausted, -1021)
        self.assertEqual(CFNetwork.kCFURLErrorFileDoesNotExist, -1100)
        self.assertEqual(CFNetwork.kCFURLErrorFileIsDirectory, -1101)
        self.assertEqual(CFNetwork.kCFURLErrorNoPermissionsToReadFile, -1102)
        self.assertEqual(CFNetwork.kCFURLErrorDataLengthExceedsMaximum, -1103)
        self.assertEqual(CFNetwork.kCFURLErrorSecureConnectionFailed, -1200)
        self.assertEqual(CFNetwork.kCFURLErrorServerCertificateHasBadDate, -1201)
        self.assertEqual(CFNetwork.kCFURLErrorServerCertificateUntrusted, -1202)
        self.assertEqual(CFNetwork.kCFURLErrorServerCertificateHasUnknownRoot, -1203)
        self.assertEqual(CFNetwork.kCFURLErrorServerCertificateNotYetValid, -1204)
        self.assertEqual(CFNetwork.kCFURLErrorClientCertificateRejected, -1205)
        self.assertEqual(CFNetwork.kCFURLErrorClientCertificateRequired, -1206)
        self.assertEqual(CFNetwork.kCFURLErrorCannotLoadFromNetwork, -2000)
        self.assertEqual(CFNetwork.kCFURLErrorCannotCreateFile, -3000)
        self.assertEqual(CFNetwork.kCFURLErrorCannotOpenFile, -3001)
        self.assertEqual(CFNetwork.kCFURLErrorCannotCloseFile, -3002)
        self.assertEqual(CFNetwork.kCFURLErrorCannotWriteToFile, -3003)
        self.assertEqual(CFNetwork.kCFURLErrorCannotRemoveFile, -3004)
        self.assertEqual(CFNetwork.kCFURLErrorCannotMoveFile, -3005)
        self.assertEqual(CFNetwork.kCFURLErrorDownloadDecodingFailedMidStream, -3006)
        self.assertEqual(CFNetwork.kCFURLErrorDownloadDecodingFailedToComplete, -3007)
        self.assertEqual(CFNetwork.kCFHTTPCookieCannotParseCookieFile, -4000)

    def testConstants(self):
        self.assertEqual(CFNetwork.kCFHostErrorHostNotFound, 1)
        self.assertEqual(CFNetwork.kCFHostErrorUnknown, 2)
        self.assertEqual(CFNetwork.kCFSOCKSErrorUnknownClientVersion, 100)
        self.assertEqual(CFNetwork.kCFSOCKSErrorUnsupportedServerVersion, 101)
        self.assertEqual(CFNetwork.kCFSOCKS4ErrorRequestFailed, 110)
        self.assertEqual(CFNetwork.kCFSOCKS4ErrorIdentdFailed, 111)
        self.assertEqual(CFNetwork.kCFSOCKS4ErrorIdConflict, 112)
        self.assertEqual(CFNetwork.kCFSOCKS4ErrorUnknownStatusCode, 113)
        self.assertEqual(CFNetwork.kCFSOCKS5ErrorBadState, 120)
        self.assertEqual(CFNetwork.kCFSOCKS5ErrorBadResponseAddr, 121)
        self.assertEqual(CFNetwork.kCFSOCKS5ErrorBadCredentials, 122)
        self.assertEqual(CFNetwork.kCFSOCKS5ErrorUnsupportedNegotiationMethod, 123)
        self.assertEqual(CFNetwork.kCFSOCKS5ErrorNoAcceptableMethod, 124)
        self.assertEqual(CFNetwork.kCFNetServiceErrorUnknown, -72000)
        self.assertEqual(CFNetwork.kCFNetServiceErrorCollision, -72001)
        self.assertEqual(CFNetwork.kCFNetServiceErrorNotFound, -72002)
        self.assertEqual(CFNetwork.kCFNetServiceErrorInProgress, -72003)
        self.assertEqual(CFNetwork.kCFNetServiceErrorBadArgument, -72004)
        self.assertEqual(CFNetwork.kCFNetServiceErrorCancel, -72005)
        self.assertEqual(CFNetwork.kCFNetServiceErrorInvalid, -72006)
        self.assertEqual(CFNetwork.kCFNetServiceErrorTimeout, -72007)
        self.assertEqual(CFNetwork.kCFNetServiceErrorDNSServiceFailure, -73000)
        self.assertEqual(CFNetwork.kCFFTPErrorUnexpectedStatusCode, 200)
        self.assertEqual(CFNetwork.kCFErrorHTTPAuthenticationTypeUnsupported, 300)
        self.assertEqual(CFNetwork.kCFErrorHTTPBadCredentials, 301)
        self.assertEqual(CFNetwork.kCFErrorHTTPConnectionLost, 302)
        self.assertEqual(CFNetwork.kCFErrorHTTPParseFailure, 303)
        self.assertEqual(CFNetwork.kCFErrorHTTPRedirectionLoopDetected, 304)
        self.assertEqual(CFNetwork.kCFErrorHTTPBadURL, 305)
        self.assertEqual(CFNetwork.kCFErrorHTTPProxyConnectionFailure, 306)
        self.assertEqual(CFNetwork.kCFErrorHTTPBadProxyCredentials, 307)
        self.assertEqual(CFNetwork.kCFErrorPACFileError, 308)

        self.assertEqual(
            CFNetwork.kCFURLErrorBackgroundSessionInUseByAnotherProcess, -996
        )
        self.assertEqual(CFNetwork.kCFURLErrorBackgroundSessionWasDisconnected, -997)
        self.assertEqual(
            CFNetwork.kCFURLErrorAppTransportSecurityRequiresSecureConnection, -1022
        )
        self.assertEqual(CFNetwork.kCFURLErrorFileOutsideSafeArea, -1104)

    @min_os_level("10.8")
    def testConstants10_8(self):
        self.assertEqual(
            CFNetwork.kCFStreamErrorHTTPSProxyFailureUnexpectedResponseToCONNECTMethod,
            311,
        )
