from PyObjCTools.TestSupport import *

import CoreServices


class TestResources(TestCase):
    def assert_not_wrapped(self, name):
        self.assertTrue(
            not hasattr(CoreServices, name), "%r exposed in bindings" % (name,)
        )

    def test_not_wrapped(self):
        self.assert_not_wrapped("resSysRefBit")
        self.assert_not_wrapped("resSysHeapBit")
        self.assert_not_wrapped("resPurgeableBit")
        self.assert_not_wrapped("resLockedBit")
        self.assert_not_wrapped("resProtectedBit")
        self.assert_not_wrapped("resPreloadBit")
        self.assert_not_wrapped("resChangedBit")
        self.assert_not_wrapped("resSysHeap")
        self.assert_not_wrapped("resPurgeable")
        self.assert_not_wrapped("resLocked")
        self.assert_not_wrapped("resProtected")
        self.assert_not_wrapped("resPreload")
        self.assert_not_wrapped("resChanged")
        self.assert_not_wrapped("mapReadOnlyBit")
        self.assert_not_wrapped("mapCompactBit")
        self.assert_not_wrapped("mapChangedBit")
        self.assert_not_wrapped("mapReadOnly")
        self.assert_not_wrapped("mapCompact")
        self.assert_not_wrapped("mapChanged")
        self.assert_not_wrapped("kResFileNotOpened")
        self.assert_not_wrapped("kSystemResFile")
        self.assert_not_wrapped("NewResErrUPP")
        self.assert_not_wrapped("DisposeResErrUPP")
        self.assert_not_wrapped("InvokeResErrUPP")
        self.assert_not_wrapped("CloseResFile")
        self.assert_not_wrapped("ResError")
        self.assert_not_wrapped("CurResFile")
        self.assert_not_wrapped("HomeResFile")
        self.assert_not_wrapped("UseResFile")
        self.assert_not_wrapped("CountTypes")
        self.assert_not_wrapped("Count1Types")
        self.assert_not_wrapped("GetIndType")
        self.assert_not_wrapped("Get1IndType")
        self.assert_not_wrapped("SetResLoad")
        self.assert_not_wrapped("CountResources")
        self.assert_not_wrapped("Count1Resources")
        self.assert_not_wrapped("GetIndResource")
        self.assert_not_wrapped("Get1IndResource")
        self.assert_not_wrapped("GetResource")
        self.assert_not_wrapped("Get1Resource")
        self.assert_not_wrapped("GetNamedResource")
        self.assert_not_wrapped("Get1NamedResource")
        self.assert_not_wrapped("LoadResource")
        self.assert_not_wrapped("MacLoadResource")
        self.assert_not_wrapped("ReleaseResource")
        self.assert_not_wrapped("DetachResource")
        self.assert_not_wrapped("UniqueID")
        self.assert_not_wrapped("Unique1ID")
        self.assert_not_wrapped("GetResAttrs")
        self.assert_not_wrapped("GetResInfo")
        self.assert_not_wrapped("SetResInfo")
        self.assert_not_wrapped("AddResource")
        self.assert_not_wrapped("GetResourceSizeOnDisk")
        self.assert_not_wrapped("GetMaxResourceSize")
        self.assert_not_wrapped("SetResAttrs")
        self.assert_not_wrapped("ChangedResource")
        self.assert_not_wrapped("RemoveResource")
        self.assert_not_wrapped("UpdateResFile")
        self.assert_not_wrapped("WriteResource")
        self.assert_not_wrapped("SetResPurge")
        self.assert_not_wrapped("GetResFileAttrs")
        self.assert_not_wrapped("SetResFileAttrs")
        self.assert_not_wrapped("ReadPartialResource")
        self.assert_not_wrapped("WritePartialResource")
        self.assert_not_wrapped("SetResourceSize")
        self.assert_not_wrapped("GetNextFOND")
        self.assert_not_wrapped("kRsrcChainBelowSystemMap")
        self.assert_not_wrapped("kRsrcChainBelowApplicationMap")
        self.assert_not_wrapped("kRsrcChainAboveApplicationMap")
        self.assert_not_wrapped("kRsrcChainAboveAllMaps")
        self.assert_not_wrapped("InsertResourceFile")
        self.assert_not_wrapped("DetachResourceFile")
        self.assert_not_wrapped("GetTopResourceFile")
        self.assert_not_wrapped("GetNextResourceFile")
        self.assert_not_wrapped("FSOpenResFile")
        self.assert_not_wrapped("FSCreateResFile")
        self.assert_not_wrapped("FSResourceFileAlreadyOpen")
        self.assert_not_wrapped("FSOpenOrphanResFile")
        self.assert_not_wrapped("FSCreateResourceFile")
        self.assert_not_wrapped("FSCreateResourceFork")
        self.assert_not_wrapped("FSOpenResourceFile")
        self.assert_not_wrapped("OpenRFPerm")
        self.assert_not_wrapped("HOpenResFile")
        self.assert_not_wrapped("HCreateResFile")
        self.assert_not_wrapped("FSpOpenResFile")
        self.assert_not_wrapped("FSpCreateResFile")
        self.assert_not_wrapped("FSpResourceFileAlreadyOpen")
        self.assert_not_wrapped("FSpOpenOrphanResFile")
        self.assert_not_wrapped("SizeResource")
        self.assert_not_wrapped("MaxSizeRsrc")
        self.assert_not_wrapped("RmveResource")


if __name__ == "__main__":
    main()
