from PyObjCTools.TestSupport import *

import Security

class TestSecBase (TestCase):
    def test_types(self):
        self.assertIsCFType(Security.SecCertificateRef)
        self.assertIsCFType(Security.SecIdentityRef)
        self.assertIsCFType(Security.SecKeyRef)
        self.assertIsCFType(Security.SecPolicyRef)
        self.assertIsCFType(Security.SecTrustedApplicationRef)
        self.assertIsCFType(Security.SecAccessRef)
        self.assertIsCFType(Security.SecACLRef)

    @min_os_level('10.10')
    def test_types_10_10(self):
        self.assertIsCFType(Security.SecAccessControlRef)

    @expectedFailure
    def test_types_not_unique(self):
        self.assertIsCFType(Security.SecKeychainRef)
        self.assertIsCFType(Security.SecKeychainItemRef)
        self.assertIsCFType(Security.SecPasswordRef)

    def test_constants(self):
        self.assertEqual(Security.errSecSuccess, 0)
        self.assertEqual(Security.errSecUnimplemented, -4)
        self.assertEqual(Security.errSecDskFull, -34)
        self.assertEqual(Security.errSecIO, -36)
        self.assertEqual(Security.errSecOpWr, -49)
        self.assertEqual(Security.errSecParam, -50)
        self.assertEqual(Security.errSecWrPerm, -61)
        self.assertEqual(Security.errSecAllocate, -108)
        self.assertEqual(Security.errSecUserCanceled, -128)
        self.assertEqual(Security.errSecBadReq, -909)
        self.assertEqual(Security.errSecInternalComponent, -2070)
        self.assertEqual(Security.errSecCoreFoundationUnknown, -4960)
        self.assertEqual(Security.errSecMissingEntitlement, -34018)
        self.assertEqual(Security.errSecNotAvailable, -25291)
        self.assertEqual(Security.errSecReadOnly, -25292)
        self.assertEqual(Security.errSecAuthFailed, -25293)
        self.assertEqual(Security.errSecNoSuchKeychain, -25294)
        self.assertEqual(Security.errSecInvalidKeychain, -25295)
        self.assertEqual(Security.errSecDuplicateKeychain, -25296)
        self.assertEqual(Security.errSecDuplicateCallback, -25297)
        self.assertEqual(Security.errSecInvalidCallback, -25298)
        self.assertEqual(Security.errSecDuplicateItem, -25299)
        self.assertEqual(Security.errSecItemNotFound, -25300)
        self.assertEqual(Security.errSecBufferTooSmall, -25301)
        self.assertEqual(Security.errSecDataTooLarge, -25302)
        self.assertEqual(Security.errSecNoSuchAttr, -25303)
        self.assertEqual(Security.errSecInvalidItemRef, -25304)
        self.assertEqual(Security.errSecInvalidSearchRef, -25305)
        self.assertEqual(Security.errSecNoSuchClass, -25306)
        self.assertEqual(Security.errSecNoDefaultKeychain, -25307)
        self.assertEqual(Security.errSecInteractionNotAllowed, -25308)
        self.assertEqual(Security.errSecReadOnlyAttr, -25309)
        self.assertEqual(Security.errSecWrongSecVersion, -25310)
        self.assertEqual(Security.errSecKeySizeNotAllowed, -25311)
        self.assertEqual(Security.errSecNoStorageModule, -25312)
        self.assertEqual(Security.errSecNoCertificateModule, -25313)
        self.assertEqual(Security.errSecNoPolicyModule, -25314)
        self.assertEqual(Security.errSecInteractionRequired, -25315)
        self.assertEqual(Security.errSecDataNotAvailable, -25316)
        self.assertEqual(Security.errSecDataNotModifiable, -25317)
        self.assertEqual(Security.errSecCreateChainFailed, -25318)
        self.assertEqual(Security.errSecInvalidPrefsDomain, -25319)
        self.assertEqual(Security.errSecInDarkWake, -25320)
        self.assertEqual(Security.errSecACLNotSimple, -25240)
        self.assertEqual(Security.errSecPolicyNotFound, -25241)
        self.assertEqual(Security.errSecInvalidTrustSetting, -25242)
        self.assertEqual(Security.errSecNoAccessForItem, -25243)
        self.assertEqual(Security.errSecInvalidOwnerEdit, -25244)
        self.assertEqual(Security.errSecTrustNotAvailable, -25245)
        self.assertEqual(Security.errSecUnsupportedFormat, -25256)
        self.assertEqual(Security.errSecUnknownFormat, -25257)
        self.assertEqual(Security.errSecKeyIsSensitive, -25258)
        self.assertEqual(Security.errSecMultiplePrivKeys, -25259)
        self.assertEqual(Security.errSecPassphraseRequired, -25260)
        self.assertEqual(Security.errSecInvalidPasswordRef, -25261)
        self.assertEqual(Security.errSecInvalidTrustSettings, -25262)
        self.assertEqual(Security.errSecNoTrustSettings, -25263)
        self.assertEqual(Security.errSecPkcs12VerifyFailure, -25264)
        self.assertEqual(Security.errSecNotSigner, -26267)
        self.assertEqual(Security.errSecDecode, -26275)
        self.assertEqual(Security.errSecServiceNotAvailable, -67585)
        self.assertEqual(Security.errSecInsufficientClientID, -67586)
        self.assertEqual(Security.errSecDeviceReset, -67587)
        self.assertEqual(Security.errSecDeviceFailed, -67588)
        self.assertEqual(Security.errSecAppleAddAppACLSubject, -67589)
        self.assertEqual(Security.errSecApplePublicKeyIncomplete, -67590)
        self.assertEqual(Security.errSecAppleSignatureMismatch, -67591)
        self.assertEqual(Security.errSecAppleInvalidKeyStartDate, -67592)
        self.assertEqual(Security.errSecAppleInvalidKeyEndDate, -67593)
        self.assertEqual(Security.errSecConversionError, -67594)
        self.assertEqual(Security.errSecAppleSSLv2Rollback, -67595)
        self.assertEqual(Security.errSecDiskFull, -34)
        self.assertEqual(Security.errSecQuotaExceeded, -67596)
        self.assertEqual(Security.errSecFileTooBig, -67597)
        self.assertEqual(Security.errSecInvalidDatabaseBlob, -67598)
        self.assertEqual(Security.errSecInvalidKeyBlob, -67599)
        self.assertEqual(Security.errSecIncompatibleDatabaseBlob, -67600)
        self.assertEqual(Security.errSecIncompatibleKeyBlob, -67601)
        self.assertEqual(Security.errSecHostNameMismatch, -67602)
        self.assertEqual(Security.errSecUnknownCriticalExtensionFlag, -67603)
        self.assertEqual(Security.errSecNoBasicConstraints, -67604)
        self.assertEqual(Security.errSecNoBasicConstraintsCA, -67605)
        self.assertEqual(Security.errSecInvalidAuthorityKeyID, -67606)
        self.assertEqual(Security.errSecInvalidSubjectKeyID, -67607)
        self.assertEqual(Security.errSecInvalidKeyUsageForPolicy, -67608)
        self.assertEqual(Security.errSecInvalidExtendedKeyUsage, -67609)
        self.assertEqual(Security.errSecInvalidIDLinkage, -67610)
        self.assertEqual(Security.errSecPathLengthConstraintExceeded, -67611)
        self.assertEqual(Security.errSecInvalidRoot, -67612)
        self.assertEqual(Security.errSecCRLExpired, -67613)
        self.assertEqual(Security.errSecCRLNotValidYet, -67614)
        self.assertEqual(Security.errSecCRLNotFound, -67615)
        self.assertEqual(Security.errSecCRLServerDown, -67616)
        self.assertEqual(Security.errSecCRLBadURI, -67617)
        self.assertEqual(Security.errSecUnknownCertExtension, -67618)
        self.assertEqual(Security.errSecUnknownCRLExtension, -67619)
        self.assertEqual(Security.errSecCRLNotTrusted, -67620)
        self.assertEqual(Security.errSecCRLPolicyFailed, -67621)
        self.assertEqual(Security.errSecIDPFailure, -67622)
        self.assertEqual(Security.errSecSMIMEEmailAddressesNotFound, -67623)
        self.assertEqual(Security.errSecSMIMEBadExtendedKeyUsage, -67624)
        self.assertEqual(Security.errSecSMIMEBadKeyUsage, -67625)
        self.assertEqual(Security.errSecSMIMEKeyUsageNotCritical, -67626)
        self.assertEqual(Security.errSecSMIMENoEmailAddress, -67627)
        self.assertEqual(Security.errSecSMIMESubjAltNameNotCritical, -67628)
        self.assertEqual(Security.errSecSSLBadExtendedKeyUsage, -67629)
        self.assertEqual(Security.errSecOCSPBadResponse, -67630)
        self.assertEqual(Security.errSecOCSPBadRequest, -67631)
        self.assertEqual(Security.errSecOCSPUnavailable, -67632)
        self.assertEqual(Security.errSecOCSPStatusUnrecognized, -67633)
        self.assertEqual(Security.errSecEndOfData, -67634)
        self.assertEqual(Security.errSecIncompleteCertRevocationCheck, -67635)
        self.assertEqual(Security.errSecNetworkFailure, -67636)
        self.assertEqual(Security.errSecOCSPNotTrustedToAnchor, -67637)
        self.assertEqual(Security.errSecRecordModified, -67638)
        self.assertEqual(Security.errSecOCSPSignatureError, -67639)
        self.assertEqual(Security.errSecOCSPNoSigner, -67640)
        self.assertEqual(Security.errSecOCSPResponderMalformedReq, -67641)
        self.assertEqual(Security.errSecOCSPResponderInternalError, -67642)
        self.assertEqual(Security.errSecOCSPResponderTryLater, -67643)
        self.assertEqual(Security.errSecOCSPResponderSignatureRequired, -67644)
        self.assertEqual(Security.errSecOCSPResponderUnauthorized, -67645)
        self.assertEqual(Security.errSecOCSPResponseNonceMismatch, -67646)
        self.assertEqual(Security.errSecCodeSigningBadCertChainLength, -67647)
        self.assertEqual(Security.errSecCodeSigningNoBasicConstraints, -67648)
        self.assertEqual(Security.errSecCodeSigningBadPathLengthConstraint, -67649)
        self.assertEqual(Security.errSecCodeSigningNoExtendedKeyUsage, -67650)
        self.assertEqual(Security.errSecCodeSigningDevelopment, -67651)
        self.assertEqual(Security.errSecResourceSignBadCertChainLength, -67652)
        self.assertEqual(Security.errSecResourceSignBadExtKeyUsage, -67653)
        self.assertEqual(Security.errSecTrustSettingDeny, -67654)
        self.assertEqual(Security.errSecInvalidSubjectName, -67655)
        self.assertEqual(Security.errSecUnknownQualifiedCertStatement, -67656)
        self.assertEqual(Security.errSecMobileMeRequestQueued, -67657)
        self.assertEqual(Security.errSecMobileMeRequestRedirected, -67658)
        self.assertEqual(Security.errSecMobileMeServerError, -67659)
        self.assertEqual(Security.errSecMobileMeServerNotAvailable, -67660)
        self.assertEqual(Security.errSecMobileMeServerAlreadyExists, -67661)
        self.assertEqual(Security.errSecMobileMeServerServiceErr, -67662)
        self.assertEqual(Security.errSecMobileMeRequestAlreadyPending, -67663)
        self.assertEqual(Security.errSecMobileMeNoRequestPending, -67664)
        self.assertEqual(Security.errSecMobileMeCSRVerifyFailure, -67665)
        self.assertEqual(Security.errSecMobileMeFailedConsistencyCheck, -67666)
        self.assertEqual(Security.errSecNotInitialized, -67667)
        self.assertEqual(Security.errSecInvalidHandleUsage, -67668)
        self.assertEqual(Security.errSecPVCReferentNotFound, -67669)
        self.assertEqual(Security.errSecFunctionIntegrityFail, -67670)
        self.assertEqual(Security.errSecInternalError, -67671)
        self.assertEqual(Security.errSecMemoryError, -67672)
        self.assertEqual(Security.errSecInvalidData, -67673)
        self.assertEqual(Security.errSecMDSError, -67674)
        self.assertEqual(Security.errSecInvalidPointer, -67675)
        self.assertEqual(Security.errSecSelfCheckFailed, -67676)
        self.assertEqual(Security.errSecFunctionFailed, -67677)
        self.assertEqual(Security.errSecModuleManifestVerifyFailed, -67678)
        self.assertEqual(Security.errSecInvalidGUID, -67679)
        self.assertEqual(Security.errSecInvalidHandle, -67680)
        self.assertEqual(Security.errSecInvalidDBList, -67681)
        self.assertEqual(Security.errSecInvalidPassthroughID, -67682)
        self.assertEqual(Security.errSecInvalidNetworkAddress, -67683)
        self.assertEqual(Security.errSecCRLAlreadySigned, -67684)
        self.assertEqual(Security.errSecInvalidNumberOfFields, -67685)
        self.assertEqual(Security.errSecVerificationFailure, -67686)
        self.assertEqual(Security.errSecUnknownTag, -67687)
        self.assertEqual(Security.errSecInvalidSignature, -67688)
        self.assertEqual(Security.errSecInvalidName, -67689)
        self.assertEqual(Security.errSecInvalidCertificateRef, -67690)
        self.assertEqual(Security.errSecInvalidCertificateGroup, -67691)
        self.assertEqual(Security.errSecTagNotFound, -67692)
        self.assertEqual(Security.errSecInvalidQuery, -67693)
        self.assertEqual(Security.errSecInvalidValue, -67694)
        self.assertEqual(Security.errSecCallbackFailed, -67695)
        self.assertEqual(Security.errSecACLDeleteFailed, -67696)
        self.assertEqual(Security.errSecACLReplaceFailed, -67697)
        self.assertEqual(Security.errSecACLAddFailed, -67698)
        self.assertEqual(Security.errSecACLChangeFailed, -67699)
        self.assertEqual(Security.errSecInvalidAccessCredentials, -67700)
        self.assertEqual(Security.errSecInvalidRecord, -67701)
        self.assertEqual(Security.errSecInvalidACL, -67702)
        self.assertEqual(Security.errSecInvalidSampleValue, -67703)
        self.assertEqual(Security.errSecIncompatibleVersion, -67704)
        self.assertEqual(Security.errSecPrivilegeNotGranted, -67705)
        self.assertEqual(Security.errSecInvalidScope, -67706)
        self.assertEqual(Security.errSecPVCAlreadyConfigured, -67707)
        self.assertEqual(Security.errSecInvalidPVC, -67708)
        self.assertEqual(Security.errSecEMMLoadFailed, -67709)
        self.assertEqual(Security.errSecEMMUnloadFailed, -67710)
        self.assertEqual(Security.errSecAddinLoadFailed, -67711)
        self.assertEqual(Security.errSecInvalidKeyRef, -67712)
        self.assertEqual(Security.errSecInvalidKeyHierarchy, -67713)
        self.assertEqual(Security.errSecAddinUnloadFailed, -67714)
        self.assertEqual(Security.errSecLibraryReferenceNotFound, -67715)
        self.assertEqual(Security.errSecInvalidAddinFunctionTable, -67716)
        self.assertEqual(Security.errSecInvalidServiceMask, -67717)
        self.assertEqual(Security.errSecModuleNotLoaded, -67718)
        self.assertEqual(Security.errSecInvalidSubServiceID, -67719)
        self.assertEqual(Security.errSecAttributeNotInContext, -67720)
        self.assertEqual(Security.errSecModuleManagerInitializeFailed, -67721)
        self.assertEqual(Security.errSecModuleManagerNotFound, -67722)
        self.assertEqual(Security.errSecEventNotificationCallbackNotFound, -67723)
        self.assertEqual(Security.errSecInputLengthError, -67724)
        self.assertEqual(Security.errSecOutputLengthError, -67725)
        self.assertEqual(Security.errSecPrivilegeNotSupported, -67726)
        self.assertEqual(Security.errSecDeviceError, -67727)
        self.assertEqual(Security.errSecAttachHandleBusy, -67728)
        self.assertEqual(Security.errSecNotLoggedIn, -67729)
        self.assertEqual(Security.errSecAlgorithmMismatch, -67730)
        self.assertEqual(Security.errSecKeyUsageIncorrect, -67731)
        self.assertEqual(Security.errSecKeyBlobTypeIncorrect, -67732)
        self.assertEqual(Security.errSecKeyHeaderInconsistent, -67733)
        self.assertEqual(Security.errSecUnsupportedKeyFormat, -67734)
        self.assertEqual(Security.errSecUnsupportedKeySize, -67735)
        self.assertEqual(Security.errSecInvalidKeyUsageMask, -67736)
        self.assertEqual(Security.errSecUnsupportedKeyUsageMask, -67737)
        self.assertEqual(Security.errSecInvalidKeyAttributeMask, -67738)
        self.assertEqual(Security.errSecUnsupportedKeyAttributeMask, -67739)
        self.assertEqual(Security.errSecInvalidKeyLabel, -67740)
        self.assertEqual(Security.errSecUnsupportedKeyLabel, -67741)
        self.assertEqual(Security.errSecInvalidKeyFormat, -67742)
        self.assertEqual(Security.errSecUnsupportedVectorOfBuffers, -67743)
        self.assertEqual(Security.errSecInvalidInputVector, -67744)
        self.assertEqual(Security.errSecInvalidOutputVector, -67745)
        self.assertEqual(Security.errSecInvalidContext, -67746)
        self.assertEqual(Security.errSecInvalidAlgorithm, -67747)
        self.assertEqual(Security.errSecInvalidAttributeKey, -67748)
        self.assertEqual(Security.errSecMissingAttributeKey, -67749)
        self.assertEqual(Security.errSecInvalidAttributeInitVector, -67750)
        self.assertEqual(Security.errSecMissingAttributeInitVector, -67751)
        self.assertEqual(Security.errSecInvalidAttributeSalt, -67752)
        self.assertEqual(Security.errSecMissingAttributeSalt, -67753)
        self.assertEqual(Security.errSecInvalidAttributePadding, -67754)
        self.assertEqual(Security.errSecMissingAttributePadding, -67755)
        self.assertEqual(Security.errSecInvalidAttributeRandom, -67756)
        self.assertEqual(Security.errSecMissingAttributeRandom, -67757)
        self.assertEqual(Security.errSecInvalidAttributeSeed, -67758)
        self.assertEqual(Security.errSecMissingAttributeSeed, -67759)
        self.assertEqual(Security.errSecInvalidAttributePassphrase, -67760)
        self.assertEqual(Security.errSecMissingAttributePassphrase, -67761)
        self.assertEqual(Security.errSecInvalidAttributeKeyLength, -67762)
        self.assertEqual(Security.errSecMissingAttributeKeyLength, -67763)
        self.assertEqual(Security.errSecInvalidAttributeBlockSize, -67764)
        self.assertEqual(Security.errSecMissingAttributeBlockSize, -67765)
        self.assertEqual(Security.errSecInvalidAttributeOutputSize, -67766)
        self.assertEqual(Security.errSecMissingAttributeOutputSize, -67767)
        self.assertEqual(Security.errSecInvalidAttributeRounds, -67768)
        self.assertEqual(Security.errSecMissingAttributeRounds, -67769)
        self.assertEqual(Security.errSecInvalidAlgorithmParms, -67770)
        self.assertEqual(Security.errSecMissingAlgorithmParms, -67771)
        self.assertEqual(Security.errSecInvalidAttributeLabel, -67772)
        self.assertEqual(Security.errSecMissingAttributeLabel, -67773)
        self.assertEqual(Security.errSecInvalidAttributeKeyType, -67774)
        self.assertEqual(Security.errSecMissingAttributeKeyType, -67775)
        self.assertEqual(Security.errSecInvalidAttributeMode, -67776)
        self.assertEqual(Security.errSecMissingAttributeMode, -67777)
        self.assertEqual(Security.errSecInvalidAttributeEffectiveBits, -67778)
        self.assertEqual(Security.errSecMissingAttributeEffectiveBits, -67779)
        self.assertEqual(Security.errSecInvalidAttributeStartDate, -67780)
        self.assertEqual(Security.errSecMissingAttributeStartDate, -67781)
        self.assertEqual(Security.errSecInvalidAttributeEndDate, -67782)
        self.assertEqual(Security.errSecMissingAttributeEndDate, -67783)
        self.assertEqual(Security.errSecInvalidAttributeVersion, -67784)
        self.assertEqual(Security.errSecMissingAttributeVersion, -67785)
        self.assertEqual(Security.errSecInvalidAttributePrime, -67786)
        self.assertEqual(Security.errSecMissingAttributePrime, -67787)
        self.assertEqual(Security.errSecInvalidAttributeBase, -67788)
        self.assertEqual(Security.errSecMissingAttributeBase, -67789)
        self.assertEqual(Security.errSecInvalidAttributeSubprime, -67790)
        self.assertEqual(Security.errSecMissingAttributeSubprime, -67791)
        self.assertEqual(Security.errSecInvalidAttributeIterationCount, -67792)
        self.assertEqual(Security.errSecMissingAttributeIterationCount, -67793)
        self.assertEqual(Security.errSecInvalidAttributeDLDBHandle, -67794)
        self.assertEqual(Security.errSecMissingAttributeDLDBHandle, -67795)
        self.assertEqual(Security.errSecInvalidAttributeAccessCredentials, -67796)
        self.assertEqual(Security.errSecMissingAttributeAccessCredentials, -67797)
        self.assertEqual(Security.errSecInvalidAttributePublicKeyFormat, -67798)
        self.assertEqual(Security.errSecMissingAttributePublicKeyFormat, -67799)
        self.assertEqual(Security.errSecInvalidAttributePrivateKeyFormat, -67800)
        self.assertEqual(Security.errSecMissingAttributePrivateKeyFormat, -67801)
        self.assertEqual(Security.errSecInvalidAttributeSymmetricKeyFormat, -67802)
        self.assertEqual(Security.errSecMissingAttributeSymmetricKeyFormat, -67803)
        self.assertEqual(Security.errSecInvalidAttributeWrappedKeyFormat, -67804)
        self.assertEqual(Security.errSecMissingAttributeWrappedKeyFormat, -67805)
        self.assertEqual(Security.errSecStagedOperationInProgress, -67806)
        self.assertEqual(Security.errSecStagedOperationNotStarted, -67807)
        self.assertEqual(Security.errSecVerifyFailed, -67808)
        self.assertEqual(Security.errSecQuerySizeUnknown, -67809)
        self.assertEqual(Security.errSecBlockSizeMismatch, -67810)
        self.assertEqual(Security.errSecPublicKeyInconsistent, -67811)
        self.assertEqual(Security.errSecDeviceVerifyFailed, -67812)
        self.assertEqual(Security.errSecInvalidLoginName, -67813)
        self.assertEqual(Security.errSecAlreadyLoggedIn, -67814)
        self.assertEqual(Security.errSecInvalidDigestAlgorithm, -67815)
        self.assertEqual(Security.errSecInvalidCRLGroup, -67816)
        self.assertEqual(Security.errSecCertificateCannotOperate, -67817)
        self.assertEqual(Security.errSecCertificateExpired, -67818)
        self.assertEqual(Security.errSecCertificateNotValidYet, -67819)
        self.assertEqual(Security.errSecCertificateRevoked, -67820)
        self.assertEqual(Security.errSecCertificateSuspended, -67821)
        self.assertEqual(Security.errSecInsufficientCredentials, -67822)
        self.assertEqual(Security.errSecInvalidAction, -67823)
        self.assertEqual(Security.errSecInvalidAuthority, -67824)
        self.assertEqual(Security.errSecVerifyActionFailed, -67825)
        self.assertEqual(Security.errSecInvalidCertAuthority, -67826)
        self.assertEqual(Security.errSecInvaldCRLAuthority, -67827)
        self.assertEqual(Security.errSecInvalidCRLEncoding, -67828)
        self.assertEqual(Security.errSecInvalidCRLType, -67829)
        self.assertEqual(Security.errSecInvalidCRL, -67830)
        self.assertEqual(Security.errSecInvalidFormType, -67831)
        self.assertEqual(Security.errSecInvalidID, -67832)
        self.assertEqual(Security.errSecInvalidIdentifier, -67833)
        self.assertEqual(Security.errSecInvalidIndex, -67834)
        self.assertEqual(Security.errSecInvalidPolicyIdentifiers, -67835)
        self.assertEqual(Security.errSecInvalidTimeString, -67836)
        self.assertEqual(Security.errSecInvalidReason, -67837)
        self.assertEqual(Security.errSecInvalidRequestInputs, -67838)
        self.assertEqual(Security.errSecInvalidResponseVector, -67839)
        self.assertEqual(Security.errSecInvalidStopOnPolicy, -67840)
        self.assertEqual(Security.errSecInvalidTuple, -67841)
        self.assertEqual(Security.errSecMultipleValuesUnsupported, -67842)
        self.assertEqual(Security.errSecNotTrusted, -67843)
        self.assertEqual(Security.errSecNoDefaultAuthority, -67844)
        self.assertEqual(Security.errSecRejectedForm, -67845)
        self.assertEqual(Security.errSecRequestLost, -67846)
        self.assertEqual(Security.errSecRequestRejected, -67847)
        self.assertEqual(Security.errSecUnsupportedAddressType, -67848)
        self.assertEqual(Security.errSecUnsupportedService, -67849)
        self.assertEqual(Security.errSecInvalidTupleGroup, -67850)
        self.assertEqual(Security.errSecInvalidBaseACLs, -67851)
        self.assertEqual(Security.errSecInvalidTupleCredendtials, -67852)
        self.assertEqual(Security.errSecInvalidEncoding, -67853)
        self.assertEqual(Security.errSecInvalidValidityPeriod, -67854)
        self.assertEqual(Security.errSecInvalidRequestor, -67855)
        self.assertEqual(Security.errSecRequestDescriptor, -67856)
        self.assertEqual(Security.errSecInvalidBundleInfo, -67857)
        self.assertEqual(Security.errSecInvalidCRLIndex, -67858)
        self.assertEqual(Security.errSecNoFieldValues, -67859)
        self.assertEqual(Security.errSecUnsupportedFieldFormat, -67860)
        self.assertEqual(Security.errSecUnsupportedIndexInfo, -67861)
        self.assertEqual(Security.errSecUnsupportedLocality, -67862)
        self.assertEqual(Security.errSecUnsupportedNumAttributes, -67863)
        self.assertEqual(Security.errSecUnsupportedNumIndexes, -67864)
        self.assertEqual(Security.errSecUnsupportedNumRecordTypes, -67865)
        self.assertEqual(Security.errSecFieldSpecifiedMultiple, -67866)
        self.assertEqual(Security.errSecIncompatibleFieldFormat, -67867)
        self.assertEqual(Security.errSecInvalidParsingModule, -67868)
        self.assertEqual(Security.errSecDatabaseLocked, -67869)
        self.assertEqual(Security.errSecDatastoreIsOpen, -67870)
        self.assertEqual(Security.errSecMissingValue, -67871)
        self.assertEqual(Security.errSecUnsupportedQueryLimits, -67872)
        self.assertEqual(Security.errSecUnsupportedNumSelectionPreds, -67873)
        self.assertEqual(Security.errSecUnsupportedOperator, -67874)
        self.assertEqual(Security.errSecInvalidDBLocation, -67875)
        self.assertEqual(Security.errSecInvalidAccessRequest, -67876)
        self.assertEqual(Security.errSecInvalidIndexInfo, -67877)
        self.assertEqual(Security.errSecInvalidNewOwner, -67878)
        self.assertEqual(Security.errSecInvalidModifyMode, -67879)
        self.assertEqual(Security.errSecMissingRequiredExtension, -67880)
        self.assertEqual(Security.errSecExtendedKeyUsageNotCritical, -67881)
        self.assertEqual(Security.errSecTimestampMissing, -67882)
        self.assertEqual(Security.errSecTimestampInvalid, -67883)
        self.assertEqual(Security.errSecTimestampNotTrusted, -67884)
        self.assertEqual(Security.errSecTimestampServiceNotAvailable, -67885)
        self.assertEqual(Security.errSecTimestampBadAlg, -67886)
        self.assertEqual(Security.errSecTimestampBadRequest, -67887)
        self.assertEqual(Security.errSecTimestampBadDataFormat, -67888)
        self.assertEqual(Security.errSecTimestampTimeNotAvailable, -67889)
        self.assertEqual(Security.errSecTimestampUnacceptedPolicy, -67890)
        self.assertEqual(Security.errSecTimestampUnacceptedExtension, -67891)
        self.assertEqual(Security.errSecTimestampAddInfoNotAvailable, -67892)
        self.assertEqual(Security.errSecTimestampSystemFailure, -67893)
        self.assertEqual(Security.errSecSigningTimeMissing, -67894)
        self.assertEqual(Security.errSecTimestampRejection, -67895)
        self.assertEqual(Security.errSecTimestampWaiting, -67896)
        self.assertEqual(Security.errSecTimestampRevocationWarning, -67897)
        self.assertEqual(Security.errSecTimestampRevocationNotification, -67898)


    def test_functions(self):
        self.assertResultHasType(Security.SecCopyErrorMessageString, objc._C_ID)
        self.assertResultIsCFRetained(Security.SecCopyErrorMessageString)
        self.assertArgHasType(Security.SecCopyErrorMessageString, 0, objc._C_INT)
        self.assertArgHasType(Security.SecCopyErrorMessageString, 1, objc._C_PTR + objc._C_VOID)


if __name__ == "__main__":
    main()
