
from PyObjCTools.TestSupport import *
from Quartz.PDFKit import *

class TestPDFAnnotation (TestCase):
    def testMethods(self):
        self.assertResultIsBOOL(PDFAnnotation.shouldDisplay)
        self.assertArgIsBOOL(PDFAnnotation.setShouldDisplay_, 0)
        self.assertResultIsBOOL(PDFAnnotation.shouldPrint)
        self.assertArgIsBOOL(PDFAnnotation.setShouldPrint_, 0)
        self.assertResultIsBOOL(PDFAnnotation.hasAppearanceStream)

    @min_os_level('10.12')
    def testMethods10_12(self):
        self.assertResultIsBOOL(PDFAnnotation.setValue_forAnnotationKey_)
        self.assertResultIsBOOL(PDFAnnotation.setBoolean_forAnnotationKey_)
        self.assertArgIsBOOL(PDFAnnotation.setBoolean_forAnnotationKey_, 0)
        self.assertResultIsBOOL(PDFAnnotation.setRect_forAnnotationKey_)

    @min_os_level('10.13')
    def testMethods10_13(self):
        self.assertResultIsBOOL(PDFAnnotation.isHighlighted)
        self.assertArgIsBOOL(PDFAnnotation.setHighlighted_, 0)

    @min_os_level('10.12')
    def testConstants(self):
        self.assertIsInstance(kPDFAnnotationKey_AppearanceDictionary, unicode)
        self.assertIsInstance(kPDFAnnotationKey_AppearanceState, unicode)
        self.assertIsInstance(kPDFAnnotationKey_Border, unicode)
        self.assertIsInstance(kPDFAnnotationKey_Color, unicode)
        self.assertIsInstance(kPDFAnnotationKey_Contents, unicode)
        self.assertIsInstance(kPDFAnnotationKey_Flags, unicode)
        self.assertIsInstance(kPDFAnnotationKey_Date, unicode)
        self.assertIsInstance(kPDFAnnotationKey_Name, unicode)
        self.assertIsInstance(kPDFAnnotationKey_Page, unicode)
        self.assertIsInstance(kPDFAnnotationKey_Rect, unicode)
        self.assertIsInstance(kPDFAnnotationKey_Subtype, unicode)
        self.assertIsInstance(kPDFAnnotationKey_Action, unicode)
        self.assertIsInstance(kPDFAnnotationKey_AdditionalActions, unicode)
        self.assertIsInstance(kPDFAnnotationKey_BorderStyle, unicode)
        self.assertIsInstance(kPDFAnnotationKey_DefaultAppearance, unicode)
        self.assertIsInstance(kPDFAnnotationKey_Destination, unicode)
        self.assertIsInstance(kPDFAnnotationKey_HighlightingMode, unicode)
        self.assertIsInstance(kPDFAnnotationKey_Inklist, unicode)
        self.assertIsInstance(kPDFAnnotationKey_InteriorColor, unicode)
        self.assertIsInstance(kPDFAnnotationKey_LinePoints, unicode)
        self.assertIsInstance(kPDFAnnotationKey_LineEndingStyles, unicode)
        self.assertIsInstance(kPDFAnnotationKey_IconName, unicode)
        self.assertIsInstance(kPDFAnnotationKey_Open, unicode)
        self.assertIsInstance(kPDFAnnotationKey_Parent, unicode)
        self.assertIsInstance(kPDFAnnotationKey_Popup, unicode)
        self.assertIsInstance(kPDFAnnotationKey_Quadding, unicode)
        self.assertIsInstance(kPDFAnnotationKey_QuadPoints, unicode)
        self.assertIsInstance(kPDFAnnotationKey_TextLabel, unicode)
        self.assertIsInstance(kPDFAnnotationKey_WidgetDefaultValue, unicode)
        self.assertIsInstance(kPDFAnnotationKey_WidgetFieldFlags, unicode)
        self.assertIsInstance(kPDFAnnotationKey_WidgetFieldType, unicode)
        self.assertIsInstance(kPDFAnnotationKey_WidgetAppearanceDictionary, unicode)
        self.assertIsInstance(kPDFAnnotationKey_WidgetMaxLen, unicode)
        self.assertIsInstance(kPDFAnnotationKey_WidgetOptions, unicode)
        self.assertIsInstance(kPDFAnnotationKey_WidgetTextLabelUI, unicode)
        self.assertIsInstance(kPDFAnnotationKey_WidgetValue, unicode)


        # Not present in most recent SDK:
        #self.assertIsInstance(kPDFAnnotationKey_AppleExtras, unicode)

    @min_os_level('10.13')
    def testConstants10_13(self):
        self.assertIsInstance(PDFAnnotationKeyAppearanceDictionary, unicode)
        self.assertIsInstance(PDFAnnotationKeyAppearanceState, unicode)
        self.assertIsInstance(PDFAnnotationKeyBorder, unicode)
        self.assertIsInstance(PDFAnnotationKeyColor, unicode)
        self.assertIsInstance(PDFAnnotationKeyContents, unicode)
        self.assertIsInstance(PDFAnnotationKeyFlags, unicode)
        self.assertIsInstance(PDFAnnotationKeyDate, unicode)
        self.assertIsInstance(PDFAnnotationKeyName, unicode)
        self.assertIsInstance(PDFAnnotationKeyPage, unicode)
        self.assertIsInstance(PDFAnnotationKeyRect, unicode)
        self.assertIsInstance(PDFAnnotationKeySubtype, unicode)

        self.assertIsInstance(PDFAnnotationKeyAction, unicode)
        self.assertIsInstance(PDFAnnotationKeyAdditionalActions, unicode)
        self.assertIsInstance(PDFAnnotationKeyBorderStyle, unicode)
        self.assertIsInstance(PDFAnnotationKeyDefaultAppearance, unicode)
        self.assertIsInstance(PDFAnnotationKeyDestination, unicode)
        self.assertIsInstance(PDFAnnotationKeyHighlightingMode, unicode)
        self.assertIsInstance(PDFAnnotationKeyInklist, unicode)
        self.assertIsInstance(PDFAnnotationKeyInteriorColor, unicode)
        self.assertIsInstance(PDFAnnotationKeyLinePoints, unicode)
        self.assertIsInstance(PDFAnnotationKeyLineEndingStyles, unicode)
        self.assertIsInstance(PDFAnnotationKeyIconName, unicode)
        self.assertIsInstance(PDFAnnotationKeyOpen, unicode)
        self.assertIsInstance(PDFAnnotationKeyParent, unicode)
        self.assertIsInstance(PDFAnnotationKeyPopup, unicode)
        self.assertIsInstance(PDFAnnotationKeyQuadding, unicode)
        self.assertIsInstance(PDFAnnotationKeyQuadPoints, unicode)
        self.assertIsInstance(PDFAnnotationKeyTextLabel, unicode)

        self.assertIsInstance(PDFAnnotationKeyWidgetDownCaption, unicode)
        self.assertIsInstance(PDFAnnotationKeyWidgetBorderColor, unicode)
        self.assertIsInstance(PDFAnnotationKeyWidgetBackgroundColor, unicode)
        self.assertIsInstance(PDFAnnotationKeyWidgetCaption, unicode)
        self.assertIsInstance(PDFAnnotationKeyWidgetDefaultValue, unicode)
        self.assertIsInstance(PDFAnnotationKeyWidgetFieldFlags, unicode)
        self.assertIsInstance(PDFAnnotationKeyWidgetFieldType, unicode)
        self.assertIsInstance(PDFAnnotationKeyWidgetAppearanceDictionary, unicode)
        self.assertIsInstance(PDFAnnotationKeyWidgetMaxLen, unicode)
        self.assertIsInstance(PDFAnnotationKeyWidgetOptions, unicode)
        self.assertIsInstance(PDFAnnotationKeyWidgetRotation, unicode)
        self.assertIsInstance(PDFAnnotationKeyWidgetRolloverCaption, unicode)
        self.assertIsInstance(PDFAnnotationKeyWidgetTextLabelUI, unicode)
        self.assertIsInstance(PDFAnnotationKeyWidgetValue, unicode)


if __name__ == "__main__":
    main()
