'''
Wrappers for the "ExternalAccessory" framework on macOS.

These wrappers don't include documentation, please check Apple's documention
for information on how to use this framework and PyObjC's documentation
for general tips and tricks regarding the translation between Python
and (Objective-)C frameworks
'''

from pyobjc_setup import setup, Extension
import os

VERSION="5.1.2"

setup(
    name='pyobjc-framework-ExternalAccessory',
    description = "Wrappers for the framework ExternalAccessory on macOS",
    min_os_level="10.13",
    packages = [ "ExternalAccessory" ],
    ext_modules = [
        Extension("ExternalAccessory._ExternalAccessory",
            [ "Modules/_ExternalAccessory.m" ],
            extra_link_args=["-framework", "ExternalAccessory"],
            depends=[
                os.path.join('Modules', fn)
                for fn in os.listdir('Modules')
                if fn.startswith('_ExternalAccessory')
            ]
        ),
    ],
    version=VERSION,
    install_requires = [
        'pyobjc-core>='+VERSION,
        'pyobjc-framework-Cocoa>='+VERSION,
    ],
    long_description=__doc__,
)
