from PyObjCTools.TestSupport import *
from CFNetwork import *


class TestCFSocketStream (TestCase):
    @min_os_level('10.12')
    def testConstants10_12(self):
        self.assertIsInstance(kCFStreamNetworkServiceTypeCallSignaling, unicode)

    @min_os_level('10.9')
    def testConstants10_9(self):
        self.assertIsInstance(kCFStreamPropertySSLContext, unicode)

    @min_os_level('10.8')
    def testConstants10_8(self):
        self.assertIsInstance(kCFStreamPropertyNoCellular, unicode)
        self.assertIsInstance(kCFStreamPropertyConnectionIsCellular, unicode)
        self.assertIsInstance(kCFStreamNetworkServiceTypeResponsiveData, unicode)

    @min_os_level('10.7')
    def testConstants10_7(self):
        self.assertIsInstance(kCFStreamNetworkServiceType, unicode)
        self.assertIsInstance(kCFStreamNetworkServiceTypeVoIP, unicode)
        self.assertIsInstance(kCFStreamNetworkServiceTypeVideo, unicode)
        self.assertIsInstance(kCFStreamNetworkServiceTypeBackground, unicode)
        self.assertIsInstance(kCFStreamNetworkServiceTypeVoice, unicode)

    @min_os_level('10.5')
    def testConstants10_5(self):
        self.assertIsInstance(kCFStreamPropertySSLPeerTrust, unicode)
        self.assertIsInstance(kCFStreamErrorDomainWinSock, (int, long))

    def testConstants(self):
        self.assertIsInstance(kCFStreamPropertySSLPeerCertificates, unicode)
        self.assertIsInstance(kCFStreamPropertySSLSettings, unicode)
        self.assertIsInstance(kCFStreamSSLLevel, unicode)
        self.assertIsInstance(kCFStreamSSLAllowsExpiredCertificates, unicode)
        self.assertIsInstance(kCFStreamSSLAllowsExpiredRoots, unicode)
        self.assertIsInstance(kCFStreamSSLAllowsAnyRoot, unicode)
        self.assertIsInstance(kCFStreamSSLValidatesCertificateChain, unicode)
        self.assertIsInstance(kCFStreamSSLPeerName, unicode)
        self.assertIsInstance(kCFStreamSSLCertificates, unicode)
        self.assertIsInstance(kCFStreamSSLIsServer, unicode)


        self.assertEqual(kCFStreamErrorSOCKSSubDomainNone, 0)
        self.assertEqual(kCFStreamErrorSOCKSSubDomainVersionCode, 1)
        self.assertEqual(kCFStreamErrorSOCKS4SubDomainResponse, 2)
        self.assertEqual(kCFStreamErrorSOCKS5SubDomainUserPass, 3)
        self.assertEqual(kCFStreamErrorSOCKS5SubDomainMethod, 4)
        self.assertEqual(kCFStreamErrorSOCKS5SubDomainResponse, 5)
        self.assertEqual(kCFStreamErrorSOCKS5BadResponseAddr, 1)
        self.assertEqual(kCFStreamErrorSOCKS5BadState, 2)
        self.assertEqual(kCFStreamErrorSOCKSUnknownClientVersion, 3)
        self.assertEqual(kCFStreamErrorSOCKS4RequestFailed, 91)
        self.assertEqual(kCFStreamErrorSOCKS4IdentdFailed, 92)
        self.assertEqual(kCFStreamErrorSOCKS4IdConflict, 93)
        self.assertEqual(kSOCKS5NoAcceptableMethod, 0xFF)

        # Moved to CoreFoundation in 10.14, still testing here for backward
        # compat reasons.
        self.assertIsInstance(kCFStreamErrorDomainSOCKS, (int, long))
        self.assertIsInstance(kCFStreamPropertySOCKSProxy, unicode)
        self.assertIsInstance(kCFStreamPropertySOCKSProxyHost, unicode)
        self.assertIsInstance(kCFStreamPropertySOCKSProxyPort, unicode)
        self.assertIsInstance(kCFStreamPropertySOCKSVersion, unicode)
        self.assertIsInstance(kCFStreamSocketSOCKSVersion4, unicode)
        self.assertIsInstance(kCFStreamSocketSOCKSVersion5, unicode)
        self.assertIsInstance(kCFStreamPropertySOCKSUser, unicode)
        self.assertIsInstance(kCFStreamPropertySOCKSPassword, unicode)
        self.assertIsInstance(kCFStreamErrorDomainSSL, (int, long))
        self.assertIsInstance(kCFStreamPropertySocketSecurityLevel, unicode)
        self.assertIsInstance(kCFStreamSocketSecurityLevelNone, unicode)
        self.assertIsInstance(kCFStreamSocketSecurityLevelSSLv2, unicode)
        self.assertIsInstance(kCFStreamSocketSecurityLevelSSLv3, unicode)
        self.assertIsInstance(kCFStreamSocketSecurityLevelTLSv1, unicode)
        self.assertIsInstance(kCFStreamSocketSecurityLevelNegotiatedSSL, unicode)
        self.assertIsInstance(kCFStreamPropertyShouldCloseNativeSocket, unicode)
        #

        self.assertIsInstance(kCFStreamPropertySocketRemoteHost, unicode)
        self.assertIsInstance(kCFStreamPropertySocketRemoteNetService, unicode)
        self.assertEqual(kCFStreamSocketSecurityNone, 0)
        self.assertEqual(kCFStreamSocketSecuritySSLv2, 1)
        self.assertEqual(kCFStreamSocketSecuritySSLv3, 2)
        self.assertEqual(kCFStreamSocketSecuritySSLv23, 3)
        self.assertEqual(kCFStreamSocketSecurityTLSv1, 4)

        self.assertIsInstance(kCFStreamPropertyProxyLocalBypass, unicode)

    def testFunctions(self):
        err = CFStreamError()
        err.error = (1<<16)+2

        v = CFSocketStreamSOCKSGetErrorSubdomain(err)
        self.assertEqual(v, 1)

        v = CFSocketStreamSOCKSGetError(err)
        self.assertEqual(v, 2)

        self.assertArgIsCFRetained(CFStreamCreatePairWithSocketToCFHost, 3)
        self.assertArgIsCFRetained(CFStreamCreatePairWithSocketToCFHost, 4)
        self.assertArgIsOut(CFStreamCreatePairWithSocketToCFHost, 3)
        self.assertArgIsOut(CFStreamCreatePairWithSocketToCFHost, 4)

        host = CFHostCreateWithName(None, "connect.apple.com")
        rd, wr = CFStreamCreatePairWithSocketToCFHost(None, host, 443, None, None)
        self.assertIsInstance(rd, CFReadStreamRef)
        self.assertIsInstance(wr, CFWriteStreamRef)

        if os_level_key(os_release()) < os_level_key('10.10'):
            self.assertResultIsBOOL(CFSocketStreamPairSetSecurityProtocol)
            v = CFSocketStreamPairSetSecurityProtocol(rd, wr, kCFStreamSocketSecuritySSLv23)
            self.assertIsInstance(v, bool)

        self.assertArgIsCFRetained(CFStreamCreatePairWithSocketToNetService, 2)
        self.assertArgIsCFRetained(CFStreamCreatePairWithSocketToNetService, 3)
        self.assertArgIsOut(CFStreamCreatePairWithSocketToNetService, 2)
        self.assertArgIsOut(CFStreamCreatePairWithSocketToNetService, 3)
        service = CFNetServiceCreate(None, "pyobjc.local", "ssh", "pyobjc.test.local", 9999)
        rd, wr = CFStreamCreatePairWithSocketToNetService(None, service, None, None)
        self.assertIsInstance(rd, CFReadStreamRef)
        self.assertIsInstance(wr, CFWriteStreamRef)

    @min_os_level('10.8')
    def testConstants10_8(self):
        # XXX: iOS only:
        #self.assertIsInstance(kCFStreamPropertySSLContext, unicode)
        self.assertIsInstance(kCFStreamPropertyNoCellular, unicode)
        self.assertIsInstance(kCFStreamPropertyConnectionIsCellular, unicode)

    @min_os_level('10.11')
    def testConstants10_11(self):
        self.assertIsInstance(kCFStreamPropertySocketExtendedBackgroundIdleMode, unicode)

if __name__ == "__main__":
    main()
