"""Encoding DIMSE-N messages for use in testing."""


n_er_rq_cmd = (
    # Message control header byte: command set, last fragment
    b"\x03"
    # Command Group Length, length 4, value 110
    b"\x00\x00\x00\x00\x04\x00\x00\x00\x6e\x00\x00\x00"
    # Affected SOP Class UID, length 26, value 1.2.840.10008.5.1.4.1.1.2
    b"\x00\x00\x02\x00\x1a\x00\x00\x00\x31\x2e\x32\x2e\x38\x34\x30\x2e\x31"
    b"\x30\x30\x30\x38\x2e\x35\x2e\x31\x2e\x34\x2e\x31\x2e\x31\x2e\x32\x00"
    # Command Field   | length 2      | value 0x0100
    b"\x00\x00\x00\x01\x02\x00\x00\x00\x00\x01"
    # Message ID      | length 2      | value 7
    b"\x00\x00\x10\x01\x02\x00\x00\x00\x07\x00"
    # Command Data Set Type, length 2 | value 0x0001
    b"\x00\x00\x00\x08\x02\x00\x00\x00\x01\x00"
    # Affected SOP Instance UID, length 28, value 1.2.392.200036.9116.2.6.1.48
    b"\x00\x00\x00\x10\x1c\x00\x00\x00\x31\x2e\x32\x2e\x33\x39\x32\x2e\x32"
    b"\x30\x30\x30\x33\x36\x2e\x39\x31\x31\x36\x2e\x32\x2e\x36\x2e\x31\x2e"
    b"\x34\x38"
    # Event Type ID   | length 2      | value 2
    b"\x00\x00\x02\x10\x02\x00\x00\x00\x02\x00"
)

n_er_rq_ds = (
    # Message control header byte: dataset, last fragment
    b"\x02"
    # (0010, 0020) PatientName = "Tube HeNe"
    b"\x10\x00\x10\x00\x0a\x00\x00\x00\x54\x75\x62\x65\x20\x48\x65\x4e\x65"
    b"\x20"
    # (0010, 0010) PatientID = 'Test1101'
    b"\x10\x00\x20\x00\x08\x00\x00\x00\x54\x65\x73\x74\x31\x31\x30\x31"
)

n_er_rsp_cmd = (
    b"\x03"
    # Command Group Length, length 4, value 76
    b"\x00\x00\x00\x00\x04\x00\x00\x00\x56\x00\x00\x00"
    # Affected SOP Class UID, length 8, value 1.2.4.10
    b"\x00\x00\x02\x00\x08\x00\x00\x00\x31\x2e\x32\x2e\x34\x2e\x31\x30"
    # Command Field   | length 2      | value 0x8100
    b"\x00\x00\x00\x01\x02\x00\x00\x00\x00\x81"
    # Message ID Being Responded To, length 2      | value 5
    b"\x00\x00\x20\x01\x02\x00\x00\x00\x05\x00"
    # Command Data Set Type, length 2 | value 0x0001
    b"\x00\x00\x00\x08\x02\x00\x00\x00\x01\x00"
    # Status          | length 2      | value 0x0000
    b"\x00\x00\x00\x09\x02\x00\x00\x00\x00\x00"
    # Affected SOP Instance UID, length 12, value 1.2.4.5.7.8
    b"\x00\x00\x00\x10\x0c\x00\x00\x00\x31\x2e\x32\x2e\x34\x2e\x35\x2e\x37"
    b"\x2e\x38\x00"
    # Event Type ID   | length 2      | value 2
    b"\x00\x00\x02\x10\x02\x00\x00\x00\x02\x00"
)

n_er_rsp_ds = (
    # Message control header byte: dataset, last fragment
    b"\x02"
    # (0010, 0020) PatientName = "Tube HeNe"
    b"\x10\x00\x10\x00\x0a\x00\x00\x00\x54\x75\x62\x65\x20\x48\x65\x4e\x65"
    b"\x20"
    # (0010, 0010) PatientID = 'Test1101'
    b"\x10\x00\x20\x00\x08\x00\x00\x00\x54\x65\x73\x74\x31\x31\x30\x31"
)

n_get_rq_cmd = (
    # Message control header byte: command set, last fragment
    b"\x03"
    # Command Group Length, length 4, value 120
    b"\x00\x00\x00\x00\x04\x00\x00\x00\x78\x00\x00\x00"
    # Requested SOP Class UID, length 26, value 1.2.840.10008.5.1.4.1.1.2
    b"\x00\x00\x03\x00\x1a\x00\x00\x00\x31\x2e\x32\x2e\x38\x34\x30\x2e\x31"
    b"\x30\x30\x30\x38\x2e\x35\x2e\x31\x2e\x34\x2e\x31\x2e\x31\x2e\x32\x00"
    # Command Field   | length 2      | value 0x0110
    b"\x00\x00\x00\x01\x02\x00\x00\x00\x10\x01"
    # Message ID      | length 2      | value 7
    b"\x00\x00\x10\x01\x02\x00\x00\x00\x07\x00"
    # Command Data Set Type, length 2 | value 0x0101
    b"\x00\x00\x00\x08\x02\x00\x00\x00\x01\x01"
    # Requested SOP Instance UID, length 28, value 1.2.392.200036.9116.2.6.1.48
    b"\x00\x00\x01\x10\x1c\x00\x00\x00\x31\x2e\x32\x2e\x33\x39\x32\x2e\x32"
    b"\x30\x30\x30\x33\x36\x2e\x39\x31\x31\x36\x2e\x32\x2e\x36\x2e\x31\x2e"
    b"\x34\x38"
    # Attribute Identifier List, length 12, value 0x7fe0 0x0010 0x0000 0x0000 0xffff 0xffff
    b"\x00\x00\x05\x10\x0c\x00\x00\x00\xe0\x7f\x10\x00\x00\x00\x00\x00"
    b"\xff\xff\xff\xff"
)

n_get_rsp_cmd = (
    b"\x03"
    # Command Group Length, length 4, value 76
    b"\x00\x00\x00\x00\x04\x00\x00\x00\x4c\x00\x00\x00"
    # Affected SOP Class UID, length 8, value 1.2.4.10
    b"\x00\x00\x02\x00\x08\x00\x00\x00\x31\x2e\x32\x2e\x34\x2e\x31\x30"
    # Command Field   | length 2      | value 0x8110
    b"\x00\x00\x00\x01\x02\x00\x00\x00\x10\x81"
    # Message ID Being Responded To, length 2      | value 5
    b"\x00\x00\x20\x01\x02\x00\x00\x00\x05\x00"
    # Command Data Set Type, length 2 | value 0x0001
    b"\x00\x00\x00\x08\x02\x00\x00\x00\x01\x00"
    # Status          | length 2      | value 0x0000
    b"\x00\x00\x00\x09\x02\x00\x00\x00\x00\x00"
    # Affected SOP Instance UID, length 12, value 1.2.4.5.7.8
    b"\x00\x00\x00\x10\x0c\x00\x00\x00\x31\x2e\x32\x2e\x34\x2e\x35\x2e\x37"
    b"\x2e\x38\x00"
)

n_get_rsp_ds = (
    # Message control header byte: dataset, last fragment
    b"\x02"
    # (0010, 0020) PatientName = "Tube HeNe"
    b"\x10\x00\x10\x00\x0a\x00\x00\x00\x54\x75\x62\x65\x20\x48\x65\x4e\x65"
    b"\x20"
    # (0010, 0010) PatientID = 'Test1101'
    b"\x10\x00\x20\x00\x08\x00\x00\x00\x54\x65\x73\x74\x31\x31\x30\x31"
)

n_delete_rq_cmd = (
    # Message control header byte: command set, last fragment
    b"\x03"
    # Command Group Length, length 4, value 58
    b"\x00\x00\x00\x00\x04\x00\x00\x00\x3a\x00\x00\x00"
    # Requested SOP Class UID, length 6, value 1.2.3
    b"\x00\x00\x03\x00\x06\x00\x00\x00\x31\x2e\x32\x2e\x33\x00"
    # Command Field   | length 2      | value 0x0150
    b"\x00\x00\x00\x01\x02\x00\x00\x00\x50\x01"
    # Message ID      | length 2      | value 7
    b"\x00\x00\x10\x01\x02\x00\x00\x00\x07\x00"
    # Command Data Set Type, length 2 | value 0x0101
    b"\x00\x00\x00\x08\x02\x00\x00\x00\x01\x01"
    # Requested SOP Instance UID, length 6, value 1.2.30
    b"\x00\x00\x01\x10\x06\x00\x00\x00\x31\x2e\x32\x2e\x33\x30"
)

n_delete_rsp_cmd = (
    b"\x03"
    # Command Group Length, length 4, value 76
    b"\x00\x00\x00\x00\x04\x00\x00\x00\x4c\x00\x00\x00"
    # Affected SOP Class UID, length 8, value 1.2.4.10
    b"\x00\x00\x02\x00\x08\x00\x00\x00\x31\x2e\x32\x2e\x34\x2e\x31\x30"
    # Command Field   | length 2      | value 0x8150
    b"\x00\x00\x00\x01\x02\x00\x00\x00\x50\x81"
    # Message ID Being Responded To, length 2      | value 5
    b"\x00\x00\x20\x01\x02\x00\x00\x00\x05\x00"
    # Command Data Set Type, length 2 | value 0x0101
    b"\x00\x00\x00\x08\x02\x00\x00\x00\x01\x01"
    # Status          | length 2      | value 0xC201
    b"\x00\x00\x00\x09\x02\x00\x00\x00\x01\xC2"
    # Affected SOP Instance UID, length 12, value 1.2.4.5.7.8
    b"\x00\x00\x00\x10\x0c\x00\x00\x00\x31\x2e\x32\x2e\x34\x2e\x35\x2e\x37"
    b"\x2e\x38\x00"
)

n_set_rq_cmd = (
    b"\x03"
    # Command Group Length, length 4, value 120
    b"\x00\x00\x00\x00\x04\x00\x00\x00\x64\x00\x00\x00"
    # Requested SOP Class UID, length 26, value 1.2.840.10008.5.1.4.1.1.2
    b"\x00\x00\x03\x00\x1a\x00\x00\x00\x31\x2e\x32\x2e\x38\x34\x30\x2e\x31"
    b"\x30\x30\x30\x38\x2e\x35\x2e\x31\x2e\x34\x2e\x31\x2e\x31\x2e\x32\x00"
    # Command Field   | length 2      | value 0x0120
    b"\x00\x00\x00\x01\x02\x00\x00\x00\x20\x01"
    # Message ID      | length 2      | value 7
    b"\x00\x00\x10\x01\x02\x00\x00\x00\x07\x00"
    # Command Data Set Type, length 2 | value 0x0001
    b"\x00\x00\x00\x08\x02\x00\x00\x00\x01\x00"
    # Requested SOP Instance UID, length 28, value 1.2.392.200036.9116.2.6.1.48
    b"\x00\x00\x01\x10\x1c\x00\x00\x00\x31\x2e\x32\x2e\x33\x39\x32\x2e\x32"
    b"\x30\x30\x30\x33\x36\x2e\x39\x31\x31\x36\x2e\x32\x2e\x36\x2e\x31\x2e"
    b"\x34\x38"
)

n_set_rq_cmd_empty = (
    b"\x03"
    # Command Group Length, length 4, value 46
    b"\x00\x00\x00\x00\x04\x00\x00\x00\x2e\x00\x00\x00"
    # Requested SOP Class UID, length 0
    b"\x00\x00\x03\x00\x00\x00\x00\x00"
    # Command Field   | length 2      | value 0x0120
    b"\x00\x00\x00\x01\x02\x00\x00\x00\x20\x01"
    # Message ID      | length 2      | value 7
    b"\x00\x00\x10\x01\x02\x00\x00\x00\x07\x00"
    # Command Data Set Type, length 2 | value 0x0101
    b"\x00\x00\x00\x08\x02\x00\x00\x00\x01\x01"
    # Requested SOP Instance UID, length 0
    b"\x00\x00\x01\x10\x00\x00\x00\x00"
)

n_set_rq_ds = (
    # Message control header byte: dataset, last fragment
    b"\x02"
    # (0010, 0020) PatientName = "Tube HeNe"
    b"\x10\x00\x10\x00\x0a\x00\x00\x00\x54\x75\x62\x65\x20\x48\x65\x4e\x65"
    b"\x20"
    # (0010, 0010) PatientID = 'Test1101'
    b"\x10\x00\x20\x00\x08\x00\x00\x00\x54\x65\x73\x74\x31\x31\x30\x31"
)

n_set_rsp_cmd = (
    b"\x03"
    # Command Group Length, length 4, value 76
    b"\x00\x00\x00\x00\x04\x00\x00\x00\x4c\x00\x00\x00"
    # Affected SOP Class UID, length 8, value 1.2.4.10
    b"\x00\x00\x02\x00\x08\x00\x00\x00\x31\x2e\x32\x2e\x34\x2e\x31\x30"
    # Command Field   | length 2      | value 0x8120
    b"\x00\x00\x00\x01\x02\x00\x00\x00\x20\x81"
    # Message ID Being Responded To, length 2      | value 5
    b"\x00\x00\x20\x01\x02\x00\x00\x00\x05\x00"
    # Command Data Set Type, length 2 | value 0x0001
    b"\x00\x00\x00\x08\x02\x00\x00\x00\x01\x00"
    # Status          | length 2      | value 0x0000
    b"\x00\x00\x00\x09\x02\x00\x00\x00\x00\x00"
    # Affected SOP Instance UID, length 12, value 1.2.4.5.7.8
    b"\x00\x00\x00\x10\x0c\x00\x00\x00\x31\x2e\x32\x2e\x34\x2e\x35\x2e\x37"
    b"\x2e\x38\x00"
)

n_set_rsp_ds = (
    # Message control header byte: dataset, last fragment
    b"\x02"
    # (0010, 0020) PatientName = "Tube HeNe"
    b"\x10\x00\x10\x00\x0a\x00\x00\x00\x54\x75\x62\x65\x20\x48\x65\x4e\x65"
    b"\x20"
    # (0010, 0010) PatientID = 'Test1101'
    b"\x10\x00\x20\x00\x08\x00\x00\x00\x54\x65\x73\x74\x31\x31\x30\x31"
)

n_action_rq_cmd = (
    b"\x03"
    # Command Group Length, length 4, value 110
    b"\x00\x00\x00\x00\x04\x00\x00\x00\x6e\x00\x00\x00"
    # Requested SOP Class UID, length 26, value 1.2.840.10008.5.1.4.1.1.2
    b"\x00\x00\x03\x00\x1a\x00\x00\x00\x31\x2e\x32\x2e\x38\x34\x30\x2e\x31"
    b"\x30\x30\x30\x38\x2e\x35\x2e\x31\x2e\x34\x2e\x31\x2e\x31\x2e\x32\x00"
    # Command Field   | length 2      | value 0x0130
    b"\x00\x00\x00\x01\x02\x00\x00\x00\x30\x01"
    # Message ID      | length 2      | value 7
    b"\x00\x00\x10\x01\x02\x00\x00\x00\x07\x00"
    # Command Data Set Type, length 2 | value 0x0001
    b"\x00\x00\x00\x08\x02\x00\x00\x00\x01\x00"
    # Requested SOP Instance UID, length 28, value 1.2.392.200036.9116.2.6.1.48
    b"\x00\x00\x01\x10\x1c\x00\x00\x00\x31\x2e\x32\x2e\x33\x39\x32\x2e\x32"
    b"\x30\x30\x30\x33\x36\x2e\x39\x31\x31\x36\x2e\x32\x2e\x36\x2e\x31\x2e"
    b"\x34\x38"
    # Action Type ID  | length 2      | value 1
    b"\x00\x00\x08\x10\x02\x00\x00\x00\x01\x00"
)

n_action_rq_ds = (
    # Message control header byte: dataset, last fragment
    b"\x02"
    # (0010, 0020) PatientName = "Tube HeNe"
    b"\x10\x00\x10\x00\x0a\x00\x00\x00\x54\x75\x62\x65\x20\x48\x65\x4e\x65"
    b"\x20"
    # (0010, 0010) PatientID = 'Test1101'
    b"\x10\x00\x20\x00\x08\x00\x00\x00\x54\x65\x73\x74\x31\x31\x30\x31"
)

n_action_rsp_cmd = (
    b"\x03"
    # Command Group Length, length 4, value 86
    b"\x00\x00\x00\x00\x04\x00\x00\x00\x56\x00\x00\x00"
    # Affected SOP Class UID, length 8, value 1.2.4.10
    b"\x00\x00\x02\x00\x08\x00\x00\x00\x31\x2e\x32\x2e\x34\x2e\x31\x30"
    # Command Field   | length 2      | value 0x8130
    b"\x00\x00\x00\x01\x02\x00\x00\x00\x30\x81"
    # Message ID Being Responded To, length 2      | value 5
    b"\x00\x00\x20\x01\x02\x00\x00\x00\x05\x00"
    # Command Data Set Type, length 2 | value 0x0001
    b"\x00\x00\x00\x08\x02\x00\x00\x00\x01\x00"
    # Status          | length 2      | value 0x0000
    b"\x00\x00\x00\x09\x02\x00\x00\x00\x00\x00"
    # Affected SOP Instance UID, length 12, value 1.2.4.5.7.8
    b"\x00\x00\x00\x10\x0c\x00\x00\x00\x31\x2e\x32\x2e\x34\x2e\x35\x2e\x37"
    b"\x2e\x38\x00"
    # Action Type ID  | length 2      | value 1
    b"\x00\x00\x08\x10\x02\x00\x00\x00\x01\x00"
)

n_action_rsp_ds = (
    # Message control header byte: dataset, last fragment
    b"\x02"
    # (0010, 0020) PatientName = "Tube HeNe"
    b"\x10\x00\x10\x00\x0a\x00\x00\x00\x54\x75\x62\x65\x20\x48\x65\x4e\x65"
    b"\x20"
    # (0010, 0010) PatientID = 'Test1101'
    b"\x10\x00\x20\x00\x08\x00\x00\x00\x54\x65\x73\x74\x31\x31\x30\x31"
)

n_create_rq_cmd = (
    # Message control header byte: command set, last fragment
    b"\x03"
    # Command Group Length, length 4, value 100
    b"\x00\x00\x00\x00\x04\x00\x00\x00\x64\x00\x00\x00"
    # Affected SOP Class UID, length 26, value 1.2.840.10008.5.1.4.1.1.2
    b"\x00\x00\x02\x00\x1a\x00\x00\x00\x31\x2e\x32\x2e\x38\x34\x30\x2e\x31"
    b"\x30\x30\x30\x38\x2e\x35\x2e\x31\x2e\x34\x2e\x31\x2e\x31\x2e\x32\x00"
    # Command Field   | length 2      | value 0x0140
    b"\x00\x00\x00\x01\x02\x00\x00\x00\x40\x01"
    # Message ID      | length 2      | value 7
    b"\x00\x00\x10\x01\x02\x00\x00\x00\x07\x00"
    # Command Data Set Type, length 2 | value 0x0001
    b"\x00\x00\x00\x08\x02\x00\x00\x00\x01\x00"
    # Affected SOP Instance UID, length 28, value 1.2.392.200036.9116.2.6.1.48
    b"\x00\x00\x00\x10\x1c\x00\x00\x00\x31\x2e\x32\x2e\x33\x39\x32\x2e\x32"
    b"\x30\x30\x30\x33\x36\x2e\x39\x31\x31\x36\x2e\x32\x2e\x36\x2e\x31\x2e"
    b"\x34\x38"
)

n_create_rq_cmd_empty = (
    # Message control header byte: command set, last fragment
    b"\x03"
    # Command Group Length, length 4, value
    b"\x00\x00\x00\x00\x04\x00\x00\x00\x36\x00\x00\x00"
    # Affected SOP Class UID, length 8, value 1.2.3.4
    b"\x00\x00\x02\x00\x08\x00\x00\x00\x31\x2e\x32\x2e\x33\x2e\x34\x00"
    # Command Field   | length 2      | value 0x0140
    b"\x00\x00\x00\x01\x02\x00\x00\x00\x40\x01"
    # Message ID      | length 2      | value 7
    b"\x00\x00\x10\x01\x02\x00\x00\x00\x07\x00"
    # Command Data Set Type, length 2 | value 0x0101
    b"\x00\x00\x00\x08\x02\x00\x00\x00\x01\x01"
    # Affected SOP Instance UID, length 0
    b"\x00\x00\x00\x10\x00\x00\x00\x00"
)

n_create_rq_ds = (
    # Message control header byte: dataset, last fragment
    b"\x02"
    # (0010, 0020) PatientName = "Tube HeNe"
    b"\x10\x00\x10\x00\x0a\x00\x00\x00\x54\x75\x62\x65\x20\x48\x65\x4e\x65"
    b"\x20"
    # (0010, 0010) PatientID = 'Test1101'
    b"\x10\x00\x20\x00\x08\x00\x00\x00\x54\x65\x73\x74\x31\x31\x30\x31"
)

n_create_rsp_cmd = (
    b"\x03"
    # Command Group Length, length 4, value 66
    b"\x00\x00\x00\x00\x04\x00\x00\x00\x4c\x00\x00\x00"
    # Affected SOP Class UID, length 8, value 1.2.4.10
    b"\x00\x00\x02\x00\x08\x00\x00\x00\x31\x2e\x32\x2e\x34\x2e\x31\x30"
    # Command Field   | length 2      | value 0x8140
    b"\x00\x00\x00\x01\x02\x00\x00\x00\x40\x81"
    # Message ID Being Responded To, length 2      | value 5
    b"\x00\x00\x20\x01\x02\x00\x00\x00\x05\x00"
    # Command Data Set Type, length 2 | value 0x0001
    b"\x00\x00\x00\x08\x02\x00\x00\x00\x01\x00"
    # Status          | length 2      | value 0x0000
    b"\x00\x00\x00\x09\x02\x00\x00\x00\x00\x00"
    # Affected SOP Instance UID, length 12, value 1.2.4.5.7.8
    b"\x00\x00\x00\x10\x0c\x00\x00\x00\x31\x2e\x32\x2e\x34\x2e\x35\x2e\x37"
    b"\x2e\x38\x00"
)

n_create_rsp_ds = (
    # Message control header byte: dataset, last fragment
    b"\x02"
    # (0010, 0020) PatientName = "Tube HeNe"
    b"\x10\x00\x10\x00\x0a\x00\x00\x00\x54\x75\x62\x65\x20\x48\x65\x4e\x65"
    b"\x20"
    # (0010, 0010) PatientID = 'Test1101'
    b"\x10\x00\x20\x00\x08\x00\x00\x00\x54\x65\x73\x74\x31\x31\x30\x31"
)
