#!/usr/bin/env python
#
# Copyright (C) 2011  Leo Singer
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
"""

Demo of pyNDS, showing online seismic channels from LLO.

"""
__author__       = "Leo Singer <leo.singer@ligo.org>"
__organization__ = ["LIGO", "California Institute of Technology"]
__copyright__    = "Copyright 2010, Leo Singer"



import nds
from pylab import *


# Connect to the NDS1 server at LIGO Livingston.
# Note that since no protocol is specified, it will first attempt NDS2, then
# fall back to NDS1.
daq = nds.daq('llocds.ligo-la.caltech.edu', 31200)


# Recieve list of 'online' channels
channels = daq.recv_channel_list(nds.channel_type.online)


# Get the seismic channels at EX
desired_channels = ('L1:PEM-EY_SEISX_OUT_DQ', 'L1:PEM-EY_SEISY_OUT_DQ', 'L1:PEM-EY_SEISZ_OUT_DQ')
for c in channels:
	if c.name in desired_channels:
		daq.request_channel(c)


# Create a new figure
fig = figure()
fig.show()


# Iterate over blocks of data as they come in
for data in daq.request_data():

    # Get timestamp (tuple of GPS seconds and nanoseconds)
    timestamp = daq.timestamp[0] + daq.timestamp[1]*0.000000001

    # Clear axes
    cla()
    for i in range(3):
        # Compute time scale
        t = arange(len(data[i])) * 1000.0 / daq.requested_channels[i].rate
        # Plot
        plot(t, data[i], label=str(daq.requested_channels[i]))

    ylim((-20, 20))
    xlabel('milliseconds relative to GPS time %.1f' % timestamp)
    legend()
    draw()
