#!/usr/bin/env python
#
# Copyright (C) 2011  Leo Singer
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
"""

Demo of pyNDS, showing archived seismic channels from LHO

"""
__author__       = "Leo Singer <leo.singer@ligo.org>"
__organization__ = ["LIGO", "California Institute of Technology"]
__copyright__    = "Copyright 2010, Leo Singer"



import nds
from pylab import *


# Connect to the NDS2 server at the LIGO-Caltech computing cluster.
daq = nds.daq('ldas-pcdev1.ligo.caltech.edu', 31200)


# Recieve list of 'raw' channels
channels = daq.recv_channel_list(nds.channel_type.raw)


# Get the seismic channels at EX
desired_channels = ('H0:PEM-EY_SEISX', 'H0:PEM-EY_SEISY', 'H0:PEM-EY_SEISZ')
for c in channels:
	if c.name in desired_channels:
		daq.request_channel(c)


# Create new figure
fig = figure()
fig.show()


# Iterate over blocks of data as they come in
start = 953618739
for data in daq.request_data(start, start + 3600, 60):

    # Get timestamp (tuple of GPS seconds and nanoseconds)
    timestamp = daq.timestamp[0] + daq.timestamp[1]*0.000000001

    cla()
    for i in range(3):
        # Compute time scale
        t = arange(len(data[i])) / daq.requested_channels[i].rate
        # Plot
        plot(t, data[i], label=str(daq.requested_channels[i]))

    xlabel('seconds relative to GPS time %.1f' % timestamp)
    ylim((-6000, 6000))
    legend()
    draw()
