# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['pylint_venv']
setup_kwargs = {
    'name': 'pylint-venv',
    'version': '2.3.0',
    'description': 'pylint-venv provides a Pylint init-hook to use the same Pylint installation with different virtual environments.',
    'long_description': 'pylint-venv\n===========\n\nPylint_ does not respect the currently activated virtualenv_ if it is not\ninstalled in every virtual environment individually.  This module provides\na Pylint init-hook to use the same Pylint installation with different virtual\nenvironments.\n\nInstallation\n------------\n\n.. code:: bash\n\n    pip install pylint-venv\n\nAdd the following to your ``~/.pylintrc``:\n\n.. code:: ini\n\n    init-hook=\n        try: import pylint_venv\n        except ImportError: pass\n        else: pylint_venv.inithook()\n\nThe hook will then be used automatically if\n\n- a virtualenv without pylint is active,\n\n- or a Conda environment without pylint is active,\n\n- or no environment is active but your CWD contains virtualenv directory.\n\nAnything listed in the ``PYLINT_VENV_PATH`` environment variable is considered\na virtualenv directory. The default, if the variable is unset, is `.venv`. Use\na colon (`:`) as path separator. Example for checking directories ``.venv`` and\n``.virtualenv``:\n\n.. code:: console\n\n    PYLINT_VENV_PATH=.venv:.virtualenv\n\nYou can also call the hook via a command line argument:\n\n.. code:: console\n\n    $ pylint --init-hook="import pylint_venv; pylint_venv.inithook()"\n\nThis way you can also explicitly set an environment to be used:\n\n.. code:: console\n\n    $ pylint --init-hook="import pylint_venv; pylint_venv.inithook(\'$(pwd)/env\')"\n\nIf ``pylint`` itself is installed in a virtualenv, then you can ignore it by passing\n``force_venv_activation=True`` to force the activation of a different virtualenv:\n\n.. code:: console\n\n    $ pylint --init-hook="import pylint_venv; pylint_venv.inithook(force_venv_activation=True)"\n\n\nThis will try to automatically detect virtualenv and activate it.\n\n\nTroubleshooting\n---------------\n\nGeneral\n^^^^^^^\n\npylint_venv fails to import\n"""""""""""""""""""""""""""\n\nMost likely pylint-venv is not installed in the same virtual environment as\npylint. Either make sure to ensure pylint-venv into the same virtual environment\nas pylint, or add the appropriate path in the init hook:\n\n.. code:: python\n\n    import sys\n    sys.path.append("/path/to/installation/folder/of/pylint_venv")\n\n\npylint_venv breaks parsing with tools\n"""""""""""""""""""""""""""""""""""""\n\nWhen tools call pylint with :code:`-f json`, an extra line may break the parser, as the \noutput is no longer valid json. To avoid printing "using venv ...", pass :code:`quiet=True`\nto :code:`inithook`\n\n.. code:: console\n\n   $ pylint -f json --init-hook="import pylint_venv; pylint_venv.inithook(quiet=True)"\n\n\nVirtual environment does not get used (installed modules are reported as \'unable to import\')\n""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""\n\nMost likely the virtual environment does not get activated because pylint itself\nruns in a virtual environment. You can force the activation of the virtual\nenvironment with the :code:`force_venv_activation=True` flag to the\n:code:`pylint_venv.inithook` function.\n\n\nHomebrew\n^^^^^^^^\n\nHomebrew installs pylint into a separate virtual environment, thus you will\nneed to set the `force_venv_activation=True` flag. This also means, that\npylint_venv will be in a different search path and you must add the proper\npath to `sys.path`. You can use the following configuration adjusted to your\nPython version:\n\n.. code:: ini\n\n    init-hook=\n        import sys\n        sys.path.append("/usr/local/lib/python3.8/site-packages")\n        try: import pylint_venv\n        except ImportError: pass\n        else: pylint_venv.inithook(force_venv_activation=True)\n\n\n.. _Pylint: http://www.pylint.org/\n.. _virtualenv: https://virtualenv.pypa.io/en/latest/\n',
    'author': 'Jan Gosmann',
    'author_email': 'jan@hyper-world.de',
    'maintainer': 'Jan Gosmann',
    'maintainer_email': 'jan@hyper-world.de',
    'url': 'https://github.com/jgosmann/pylint-venv/',
    'py_modules': modules,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
