"""DICOM data dictionary auto-generated by generate_dicom_dict.py"""
from __future__ import absolute_import

# Each dict entry is Tag : (VR, VM, Name, Retired, Keyword)
DicomDictionary = {
    0x00000000: ('UL', '1', "Command Group Length", '', 'CommandGroupLength'),  # noqa
    0x00000001: ('UL', '1', "Command Length to End", 'Retired', 'CommandLengthToEnd'),  # noqa
    0x00000002: ('UI', '1', "Affected SOP Class UID", '', 'AffectedSOPClassUID'),  # noqa
    0x00000003: ('UI', '1', "Requested SOP Class UID", '', 'RequestedSOPClassUID'),  # noqa
    0x00000010: ('SH', '1', "Command Recognition Code", 'Retired', 'CommandRecognitionCode'),  # noqa
    0x00000100: ('US', '1', "Command Field", '', 'CommandField'),  # noqa
    0x00000110: ('US', '1', "Message ID", '', 'MessageID'),  # noqa
    0x00000120: ('US', '1', "Message ID Being Responded To", '', 'MessageIDBeingRespondedTo'),  # noqa
    0x00000200: ('AE', '1', "Initiator", 'Retired', 'Initiator'),  # noqa
    0x00000300: ('AE', '1', "Receiver", 'Retired', 'Receiver'),  # noqa
    0x00000400: ('AE', '1', "Find Location", 'Retired', 'FindLocation'),  # noqa
    0x00000600: ('AE', '1', "Move Destination", '', 'MoveDestination'),  # noqa
    0x00000700: ('US', '1', "Priority", '', 'Priority'),  # noqa
    0x00000800: ('US', '1', "Command Data Set Type", '', 'CommandDataSetType'),  # noqa
    0x00000850: ('US', '1', "Number of Matches", 'Retired', 'NumberOfMatches'),  # noqa
    0x00000860: ('US', '1', "Response Sequence Number", 'Retired', 'ResponseSequenceNumber'),  # noqa
    0x00000900: ('US', '1', "Status", '', 'Status'),  # noqa
    0x00000901: ('AT', '1-n', "Offending Element", '', 'OffendingElement'),  # noqa
    0x00000902: ('LO', '1', "Error Comment", '', 'ErrorComment'),  # noqa
    0x00000903: ('US', '1', "Error ID", '', 'ErrorID'),  # noqa
    0x00001000: ('UI', '1', "Affected SOP Instance UID", '', 'AffectedSOPInstanceUID'),  # noqa
    0x00001001: ('UI', '1', "Requested SOP Instance UID", '', 'RequestedSOPInstanceUID'),  # noqa
    0x00001002: ('US', '1', "Event Type ID", '', 'EventTypeID'),  # noqa
    0x00001005: ('AT', '1-n', "Attribute Identifier List", '', 'AttributeIdentifierList'),  # noqa
    0x00001008: ('US', '1', "Action Type ID", '', 'ActionTypeID'),  # noqa
    0x00001020: ('US', '1', "Number of Remaining Sub-operations", '', 'NumberOfRemainingSuboperations'),  # noqa
    0x00001021: ('US', '1', "Number of Completed Sub-operations", '', 'NumberOfCompletedSuboperations'),  # noqa
    0x00001022: ('US', '1', "Number of Failed Sub-operations", '', 'NumberOfFailedSuboperations'),  # noqa
    0x00001023: ('US', '1', "Number of Warning Sub-operations", '', 'NumberOfWarningSuboperations'),  # noqa
    0x00001030: ('AE', '1', "Move Originator Application Entity Title", '', 'MoveOriginatorApplicationEntityTitle'),  # noqa
    0x00001031: ('US', '1', "Move Originator Message ID", '', 'MoveOriginatorMessageID'),  # noqa
    0x00004000: ('LT', '1', "Dialog Receiver", 'Retired', 'DialogReceiver'),  # noqa
    0x00004010: ('LT', '1', "Terminal Type", 'Retired', 'TerminalType'),  # noqa
    0x00005010: ('SH', '1', "Message Set ID", 'Retired', 'MessageSetID'),  # noqa
    0x00005020: ('SH', '1', "End Message ID", 'Retired', 'EndMessageID'),  # noqa
    0x00005110: ('LT', '1', "Display Format", 'Retired', 'DisplayFormat'),  # noqa
    0x00005120: ('LT', '1', "Page Position ID", 'Retired', 'PagePositionID'),  # noqa
    0x00005130: ('CS', '1', "Text Format ID", 'Retired', 'TextFormatID'),  # noqa
    0x00005140: ('CS', '1', "Normal/Reverse", 'Retired', 'NormalReverse'),  # noqa
    0x00005150: ('CS', '1', "Add Gray Scale", 'Retired', 'AddGrayScale'),  # noqa
    0x00005160: ('CS', '1', "Borders", 'Retired', 'Borders'),  # noqa
    0x00005170: ('IS', '1', "Copies", 'Retired', 'Copies'),  # noqa
    0x00005180: ('CS', '1', "Command Magnification Type", 'Retired', 'CommandMagnificationType'),  # noqa
    0x00005190: ('CS', '1', "Erase", 'Retired', 'Erase'),  # noqa
    0x000051A0: ('CS', '1', "Print", 'Retired', 'Print'),  # noqa
    0x000051B0: ('US', '1-n', "Overlays", 'Retired', 'Overlays'),  # noqa
    0x00020000: ('UL', '1', "File Meta Information Group Length", '', 'FileMetaInformationGroupLength'),  # noqa
    0x00020001: ('OB', '1', "File Meta Information Version", '', 'FileMetaInformationVersion'),  # noqa
    0x00020002: ('UI', '1', "Media Storage SOP Class UID", '', 'MediaStorageSOPClassUID'),  # noqa
    0x00020003: ('UI', '1', "Media Storage SOP Instance UID", '', 'MediaStorageSOPInstanceUID'),  # noqa
    0x00020010: ('UI', '1', "Transfer Syntax UID", '', 'TransferSyntaxUID'),  # noqa
    0x00020012: ('UI', '1', "Implementation Class UID", '', 'ImplementationClassUID'),  # noqa
    0x00020013: ('SH', '1', "Implementation Version Name", '', 'ImplementationVersionName'),  # noqa
    0x00020016: ('AE', '1', "Source Application Entity Title", '', 'SourceApplicationEntityTitle'),  # noqa
    0x00020017: ('AE', '1', "Sending Application Entity Title", '', 'SendingApplicationEntityTitle'),  # noqa
    0x00020018: ('AE', '1', "Receiving Application Entity Title", '', 'ReceivingApplicationEntityTitle'),  # noqa
    0x00020100: ('UI', '1', "Private Information Creator UID", '', 'PrivateInformationCreatorUID'),  # noqa
    0x00020102: ('OB', '1', "Private Information", '', 'PrivateInformation'),  # noqa
    0x00041130: ('CS', '1', "File-set ID", '', 'FileSetID'),  # noqa
    0x00041141: ('CS', '1-8', "File-set Descriptor File ID", '', 'FileSetDescriptorFileID'),  # noqa
    0x00041142: ('CS', '1', "Specific Character Set of File-set Descriptor File", '', 'SpecificCharacterSetOfFileSetDescriptorFile'),  # noqa
    0x00041200: ('UL', '1', "Offset of the First Directory Record of the Root Directory Entity", '', 'OffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity'),  # noqa
    0x00041202: ('UL', '1', "Offset of the Last Directory Record of the Root Directory Entity", '', 'OffsetOfTheLastDirectoryRecordOfTheRootDirectoryEntity'),  # noqa
    0x00041212: ('US', '1', "File-set Consistency Flag", '', 'FileSetConsistencyFlag'),  # noqa
    0x00041220: ('SQ', '1', "Directory Record Sequence", '', 'DirectoryRecordSequence'),  # noqa
    0x00041400: ('UL', '1', "Offset of the Next Directory Record", '', 'OffsetOfTheNextDirectoryRecord'),  # noqa
    0x00041410: ('US', '1', "Record In-use Flag", '', 'RecordInUseFlag'),  # noqa
    0x00041420: ('UL', '1', "Offset of Referenced Lower-Level Directory Entity", '', 'OffsetOfReferencedLowerLevelDirectoryEntity'),  # noqa
    0x00041430: ('CS', '1', "Directory Record Type", '', 'DirectoryRecordType'),  # noqa
    0x00041432: ('UI', '1', "Private Record UID", '', 'PrivateRecordUID'),  # noqa
    0x00041500: ('CS', '1-8', "Referenced File ID", '', 'ReferencedFileID'),  # noqa
    0x00041504: ('UL', '1', "MRDR Directory Record Offset", 'Retired', 'MRDRDirectoryRecordOffset'),  # noqa
    0x00041510: ('UI', '1', "Referenced SOP Class UID in File", '', 'ReferencedSOPClassUIDInFile'),  # noqa
    0x00041511: ('UI', '1', "Referenced SOP Instance UID in File", '', 'ReferencedSOPInstanceUIDInFile'),  # noqa
    0x00041512: ('UI', '1', "Referenced Transfer Syntax UID in File", '', 'ReferencedTransferSyntaxUIDInFile'),  # noqa
    0x0004151A: ('UI', '1-n', "Referenced Related General SOP Class UID in File", '', 'ReferencedRelatedGeneralSOPClassUIDInFile'),  # noqa
    0x00041600: ('UL', '1', "Number of References", 'Retired', 'NumberOfReferences'),  # noqa
    0x00080001: ('UL', '1', "Length to End", 'Retired', 'LengthToEnd'),  # noqa
    0x00080005: ('CS', '1-n', "Specific Character Set", '', 'SpecificCharacterSet'),  # noqa
    0x00080006: ('SQ', '1', "Language Code Sequence", '', 'LanguageCodeSequence'),  # noqa
    0x00080008: ('CS', '2-n', "Image Type", '', 'ImageType'),  # noqa
    0x00080010: ('SH', '1', "Recognition Code", 'Retired', 'RecognitionCode'),  # noqa
    0x00080012: ('DA', '1', "Instance Creation Date", '', 'InstanceCreationDate'),  # noqa
    0x00080013: ('TM', '1', "Instance Creation Time", '', 'InstanceCreationTime'),  # noqa
    0x00080014: ('UI', '1', "Instance Creator UID", '', 'InstanceCreatorUID'),  # noqa
    0x00080015: ('DT', '1', "Instance Coercion DateTime", '', 'InstanceCoercionDateTime'),  # noqa
    0x00080016: ('UI', '1', "SOP Class UID", '', 'SOPClassUID'),  # noqa
    0x00080018: ('UI', '1', "SOP Instance UID", '', 'SOPInstanceUID'),  # noqa
    0x0008001A: ('UI', '1-n', "Related General SOP Class UID", '', 'RelatedGeneralSOPClassUID'),  # noqa
    0x0008001B: ('UI', '1', "Original Specialized SOP Class UID", '', 'OriginalSpecializedSOPClassUID'),  # noqa
    0x00080020: ('DA', '1', "Study Date", '', 'StudyDate'),  # noqa
    0x00080021: ('DA', '1', "Series Date", '', 'SeriesDate'),  # noqa
    0x00080022: ('DA', '1', "Acquisition Date", '', 'AcquisitionDate'),  # noqa
    0x00080023: ('DA', '1', "Content Date", '', 'ContentDate'),  # noqa
    0x00080024: ('DA', '1', "Overlay Date", 'Retired', 'OverlayDate'),  # noqa
    0x00080025: ('DA', '1', "Curve Date", 'Retired', 'CurveDate'),  # noqa
    0x0008002A: ('DT', '1', "Acquisition DateTime", '', 'AcquisitionDateTime'),  # noqa
    0x00080030: ('TM', '1', "Study Time", '', 'StudyTime'),  # noqa
    0x00080031: ('TM', '1', "Series Time", '', 'SeriesTime'),  # noqa
    0x00080032: ('TM', '1', "Acquisition Time", '', 'AcquisitionTime'),  # noqa
    0x00080033: ('TM', '1', "Content Time", '', 'ContentTime'),  # noqa
    0x00080034: ('TM', '1', "Overlay Time", 'Retired', 'OverlayTime'),  # noqa
    0x00080035: ('TM', '1', "Curve Time", 'Retired', 'CurveTime'),  # noqa
    0x00080040: ('US', '1', "Data Set Type", 'Retired', 'DataSetType'),  # noqa
    0x00080041: ('LO', '1', "Data Set Subtype", 'Retired', 'DataSetSubtype'),  # noqa
    0x00080042: ('CS', '1', "Nuclear Medicine Series Type", 'Retired', 'NuclearMedicineSeriesType'),  # noqa
    0x00080050: ('SH', '1', "Accession Number", '', 'AccessionNumber'),  # noqa
    0x00080051: ('SQ', '1', "Issuer of Accession Number Sequence", '', 'IssuerOfAccessionNumberSequence'),  # noqa
    0x00080052: ('CS', '1', "Query/Retrieve Level", '', 'QueryRetrieveLevel'),  # noqa
    0x00080053: ('CS', '1', "Query/Retrieve View", '', 'QueryRetrieveView'),  # noqa
    0x00080054: ('AE', '1-n', "Retrieve AE Title", '', 'RetrieveAETitle'),  # noqa
    0x00080055: ('AE', '1', "Station  AE Title", '', 'StationAETitle'),  # noqa
    0x00080056: ('CS', '1', "Instance Availability", '', 'InstanceAvailability'),  # noqa
    0x00080058: ('UI', '1-n', "Failed SOP Instance UID List", '', 'FailedSOPInstanceUIDList'),  # noqa
    0x00080060: ('CS', '1', "Modality", '', 'Modality'),  # noqa
    0x00080061: ('CS', '1-n', "Modalities in Study", '', 'ModalitiesInStudy'),  # noqa
    0x00080062: ('UI', '1-n', "SOP Classes in Study", '', 'SOPClassesInStudy'),  # noqa
    0x00080063: ('SQ', '1', "Anatomic Regions in Study Code Sequence", '', 'AnatomicRegionsInStudyCodeSequence'),  # noqa
    0x00080064: ('CS', '1', "Conversion Type", '', 'ConversionType'),  # noqa
    0x00080068: ('CS', '1', "Presentation Intent Type", '', 'PresentationIntentType'),  # noqa
    0x00080070: ('LO', '1', "Manufacturer", '', 'Manufacturer'),  # noqa
    0x00080080: ('LO', '1', "Institution Name", '', 'InstitutionName'),  # noqa
    0x00080081: ('ST', '1', "Institution Address", '', 'InstitutionAddress'),  # noqa
    0x00080082: ('SQ', '1', "Institution Code Sequence", '', 'InstitutionCodeSequence'),  # noqa
    0x00080090: ('PN', '1', "Referring Physician's Name", '', 'ReferringPhysicianName'),  # noqa
    0x00080092: ('ST', '1', "Referring Physician's Address", '', 'ReferringPhysicianAddress'),  # noqa
    0x00080094: ('SH', '1-n', "Referring Physician's Telephone Numbers", '', 'ReferringPhysicianTelephoneNumbers'),  # noqa
    0x00080096: ('SQ', '1', "Referring Physician Identification Sequence", '', 'ReferringPhysicianIdentificationSequence'),  # noqa
    0x0008009C: ('PN', '1-n', "Consulting Physician's Name", '', 'ConsultingPhysicianName'),  # noqa
    0x0008009D: ('SQ', '1', "Consulting Physician Identification Sequence", '', 'ConsultingPhysicianIdentificationSequence'),  # noqa
    0x00080100: ('SH', '1', "Code Value", '', 'CodeValue'),  # noqa
    0x00080101: ('LO', '1', "Extended Code Value", '', 'ExtendedCodeValue'),  # noqa
    0x00080102: ('SH', '1', "Coding Scheme Designator", '', 'CodingSchemeDesignator'),  # noqa
    0x00080103: ('SH', '1', "Coding Scheme Version", '', 'CodingSchemeVersion'),  # noqa
    0x00080104: ('LO', '1', "Code Meaning", '', 'CodeMeaning'),  # noqa
    0x00080105: ('CS', '1', "Mapping Resource", '', 'MappingResource'),  # noqa
    0x00080106: ('DT', '1', "Context Group Version", '', 'ContextGroupVersion'),  # noqa
    0x00080107: ('DT', '1', "Context Group Local Version", '', 'ContextGroupLocalVersion'),  # noqa
    0x00080108: ('LT', '1', "Extended Code Meaning", '', 'ExtendedCodeMeaning'),  # noqa
    0x00080109: ('SQ', '1', "Coding Scheme Resources Sequence", '', 'CodingSchemeResourcesSequence'),  # noqa
    0x0008010A: ('CS', '1', "Coding Scheme URL Type", '', 'CodingSchemeURLType'),  # noqa
    0x0008010B: ('CS', '1', "Context Group Extension Flag", '', 'ContextGroupExtensionFlag'),  # noqa
    0x0008010C: ('UI', '1', "Coding Scheme UID", '', 'CodingSchemeUID'),  # noqa
    0x0008010D: ('UI', '1', "Context Group Extension Creator UID", '', 'ContextGroupExtensionCreatorUID'),  # noqa
    0x0008010E: ('UR', '1', "Coding Scheme URL", '', 'CodingSchemeURL'),  # noqa
    0x0008010F: ('CS', '1', "Context Identifier", '', 'ContextIdentifier'),  # noqa
    0x00080110: ('SQ', '1', "Coding Scheme Identification Sequence", '', 'CodingSchemeIdentificationSequence'),  # noqa
    0x00080112: ('LO', '1', "Coding Scheme Registry", '', 'CodingSchemeRegistry'),  # noqa
    0x00080114: ('ST', '1', "Coding Scheme External ID", '', 'CodingSchemeExternalID'),  # noqa
    0x00080115: ('ST', '1', "Coding Scheme Name", '', 'CodingSchemeName'),  # noqa
    0x00080116: ('ST', '1', "Coding Scheme Responsible Organization", '', 'CodingSchemeResponsibleOrganization'),  # noqa
    0x00080117: ('UI', '1', "Context UID", '', 'ContextUID'),  # noqa
    0x00080118: ('UI', '1', "Mapping Resource UID", '', 'MappingResourceUID'),  # noqa
    0x00080119: ('UC', '1', "Long Code Value", '', 'LongCodeValue'),  # noqa
    0x00080120: ('UR', '1', "URN Code Value", '', 'URNCodeValue'),  # noqa
    0x00080121: ('SQ', '1', "Equivalent Code Sequence", '', 'EquivalentCodeSequence'),  # noqa
    0x00080122: ('LO', '1', "Mapping Resource Name", '', 'MappingResourceName'),  # noqa
    0x00080123: ('SQ', '1', "Context Group Identification Sequence", '', 'ContextGroupIdentificationSequence'),  # noqa
    0x00080124: ('SQ', '1', "Mapping Resource Identification Sequence", '', 'MappingResourceIdentificationSequence'),  # noqa
    0x00080201: ('SH', '1', "Timezone Offset From UTC", '', 'TimezoneOffsetFromUTC'),  # noqa
    0x00080220: ('SQ', '1', "Responsible Group Code Sequence", '', 'ResponsibleGroupCodeSequence'),  # noqa
    0x00080221: ('CS', '1', "Equipment Modality", '', 'EquipmentModality'),  # noqa
    0x00080222: ('LO', '1', "Manufacturer's Related Model Group", '', 'ManufacturerRelatedModelGroup'),  # noqa
    0x00080300: ('SQ', '1', "Private Data Element Characteristics Sequence", '', 'PrivateDataElementCharacteristicsSequence'),  # noqa
    0x00080301: ('US', '1', "Private Group Reference", '', 'PrivateGroupReference'),  # noqa
    0x00080302: ('LO', '1', "Private Creator Reference", '', 'PrivateCreatorReference'),  # noqa
    0x00080303: ('CS', '1', "Block Identifying Information Status", '', 'BlockIdentifyingInformationStatus'),  # noqa
    0x00080304: ('US', '1-n', "Nonidentifying Private Elements", '', 'NonidentifyingPrivateElements'),  # noqa
    0x00080305: ('SQ', '1', "Deidentification Action Sequence", '', 'DeidentificationActionSequence'),  # noqa
    0x00080306: ('US', '1-n', "Identifying Private Elements", '', 'IdentifyingPrivateElements'),  # noqa
    0x00080307: ('CS', '1', "Deidentification Action", '', 'DeidentificationAction'),  # noqa
    0x00080308: ('US', '1', "Private Data Element", '', 'PrivateDataElement'),  # noqa
    0x00080309: ('UL', '1-3', "Private Data Element Value Multiplicity", '', 'PrivateDataElementValueMultiplicity'),  # noqa
    0x0008030A: ('CS', '1', "Private Data Element Value Representation", '', 'PrivateDataElementValueRepresentation'),  # noqa
    0x0008030B: ('UL', '1-2', "Private Data Element Number of Items", '', 'PrivateDataElementNumberOfItems'),  # noqa
    0x0008030C: ('UC', '1', "Private Data Element Name", '', 'PrivateDataElementName'),  # noqa
    0x0008030D: ('UC', '1', "Private Data Element Keyword", '', 'PrivateDataElementKeyword'),  # noqa
    0x0008030E: ('UT', '1', "Private Data Element Description", '', 'PrivateDataElementDescription'),  # noqa
    0x0008030F: ('UT', '1', "Private Data Element Encoding", '', 'PrivateDataElementEncoding'),  # noqa
    0x00080310: ('SQ', '1', "Private Data Element Definition Sequence", '', 'PrivateDataElementDefinitionSequence'),  # noqa
    0x00081000: ('AE', '1', "Network ID", 'Retired', 'NetworkID'),  # noqa
    0x00081010: ('SH', '1', "Station Name", '', 'StationName'),  # noqa
    0x00081030: ('LO', '1', "Study Description", '', 'StudyDescription'),  # noqa
    0x00081032: ('SQ', '1', "Procedure Code Sequence", '', 'ProcedureCodeSequence'),  # noqa
    0x0008103E: ('LO', '1', "Series Description", '', 'SeriesDescription'),  # noqa
    0x0008103F: ('SQ', '1', "Series Description Code Sequence", '', 'SeriesDescriptionCodeSequence'),  # noqa
    0x00081040: ('LO', '1', "Institutional Department Name", '', 'InstitutionalDepartmentName'),  # noqa
    0x00081048: ('PN', '1-n', "Physician(s) of Record", '', 'PhysiciansOfRecord'),  # noqa
    0x00081049: ('SQ', '1', "Physician(s) of Record Identification Sequence", '', 'PhysiciansOfRecordIdentificationSequence'),  # noqa
    0x00081050: ('PN', '1-n', "Performing Physician's Name", '', 'PerformingPhysicianName'),  # noqa
    0x00081052: ('SQ', '1', "Performing Physician Identification Sequence", '', 'PerformingPhysicianIdentificationSequence'),  # noqa
    0x00081060: ('PN', '1-n', "Name of Physician(s) Reading Study", '', 'NameOfPhysiciansReadingStudy'),  # noqa
    0x00081062: ('SQ', '1', "Physician(s) Reading Study Identification Sequence", '', 'PhysiciansReadingStudyIdentificationSequence'),  # noqa
    0x00081070: ('PN', '1-n', "Operators' Name", '', 'OperatorsName'),  # noqa
    0x00081072: ('SQ', '1', "Operator Identification Sequence", '', 'OperatorIdentificationSequence'),  # noqa
    0x00081080: ('LO', '1-n', "Admitting Diagnoses Description", '', 'AdmittingDiagnosesDescription'),  # noqa
    0x00081084: ('SQ', '1', "Admitting Diagnoses Code Sequence", '', 'AdmittingDiagnosesCodeSequence'),  # noqa
    0x00081090: ('LO', '1', "Manufacturer's Model Name", '', 'ManufacturerModelName'),  # noqa
    0x00081100: ('SQ', '1', "Referenced Results Sequence", 'Retired', 'ReferencedResultsSequence'),  # noqa
    0x00081110: ('SQ', '1', "Referenced Study Sequence", '', 'ReferencedStudySequence'),  # noqa
    0x00081111: ('SQ', '1', "Referenced Performed Procedure Step Sequence", '', 'ReferencedPerformedProcedureStepSequence'),  # noqa
    0x00081115: ('SQ', '1', "Referenced Series Sequence", '', 'ReferencedSeriesSequence'),  # noqa
    0x00081120: ('SQ', '1', "Referenced Patient Sequence", '', 'ReferencedPatientSequence'),  # noqa
    0x00081125: ('SQ', '1', "Referenced Visit Sequence", '', 'ReferencedVisitSequence'),  # noqa
    0x00081130: ('SQ', '1', "Referenced Overlay Sequence", 'Retired', 'ReferencedOverlaySequence'),  # noqa
    0x00081134: ('SQ', '1', "Referenced Stereometric Instance Sequence", '', 'ReferencedStereometricInstanceSequence'),  # noqa
    0x0008113A: ('SQ', '1', "Referenced Waveform Sequence", '', 'ReferencedWaveformSequence'),  # noqa
    0x00081140: ('SQ', '1', "Referenced Image Sequence", '', 'ReferencedImageSequence'),  # noqa
    0x00081145: ('SQ', '1', "Referenced Curve Sequence", 'Retired', 'ReferencedCurveSequence'),  # noqa
    0x0008114A: ('SQ', '1', "Referenced Instance Sequence", '', 'ReferencedInstanceSequence'),  # noqa
    0x0008114B: ('SQ', '1', "Referenced Real World Value Mapping Instance Sequence", '', 'ReferencedRealWorldValueMappingInstanceSequence'),  # noqa
    0x00081150: ('UI', '1', "Referenced SOP Class UID", '', 'ReferencedSOPClassUID'),  # noqa
    0x00081155: ('UI', '1', "Referenced SOP Instance UID", '', 'ReferencedSOPInstanceUID'),  # noqa
    0x0008115A: ('UI', '1-n', "SOP Classes Supported", '', 'SOPClassesSupported'),  # noqa
    0x00081160: ('IS', '1-n', "Referenced Frame Number", '', 'ReferencedFrameNumber'),  # noqa
    0x00081161: ('UL', '1-n', "Simple Frame List", '', 'SimpleFrameList'),  # noqa
    0x00081162: ('UL', '3-3n', "Calculated Frame List", '', 'CalculatedFrameList'),  # noqa
    0x00081163: ('FD', '2', "Time Range", '', 'TimeRange'),  # noqa
    0x00081164: ('SQ', '1', "Frame Extraction Sequence", '', 'FrameExtractionSequence'),  # noqa
    0x00081167: ('UI', '1', "Multi-frame Source SOP Instance UID", '', 'MultiFrameSourceSOPInstanceUID'),  # noqa
    0x00081190: ('UR', '1', "Retrieve URL", '', 'RetrieveURL'),  # noqa
    0x00081195: ('UI', '1', "Transaction UID", '', 'TransactionUID'),  # noqa
    0x00081196: ('US', '1', "Warning Reason", '', 'WarningReason'),  # noqa
    0x00081197: ('US', '1', "Failure Reason", '', 'FailureReason'),  # noqa
    0x00081198: ('SQ', '1', "Failed SOP Sequence", '', 'FailedSOPSequence'),  # noqa
    0x00081199: ('SQ', '1', "Referenced SOP Sequence", '', 'ReferencedSOPSequence'),  # noqa
    0x0008119A: ('SQ', '1', "Other Failures Sequence", '', 'OtherFailuresSequence'),  # noqa
    0x00081200: ('SQ', '1', "Studies Containing Other Referenced Instances Sequence", '', 'StudiesContainingOtherReferencedInstancesSequence'),  # noqa
    0x00081250: ('SQ', '1', "Related Series Sequence", '', 'RelatedSeriesSequence'),  # noqa
    0x00082110: ('CS', '1', "Lossy Image Compression (Retired)", 'Retired', 'LossyImageCompressionRetired'),  # noqa
    0x00082111: ('ST', '1', "Derivation Description", '', 'DerivationDescription'),  # noqa
    0x00082112: ('SQ', '1', "Source Image Sequence", '', 'SourceImageSequence'),  # noqa
    0x00082120: ('SH', '1', "Stage Name", '', 'StageName'),  # noqa
    0x00082122: ('IS', '1', "Stage Number", '', 'StageNumber'),  # noqa
    0x00082124: ('IS', '1', "Number of Stages", '', 'NumberOfStages'),  # noqa
    0x00082127: ('SH', '1', "View Name", '', 'ViewName'),  # noqa
    0x00082128: ('IS', '1', "View Number", '', 'ViewNumber'),  # noqa
    0x00082129: ('IS', '1', "Number of Event Timers", '', 'NumberOfEventTimers'),  # noqa
    0x0008212A: ('IS', '1', "Number of Views in Stage", '', 'NumberOfViewsInStage'),  # noqa
    0x00082130: ('DS', '1-n', "Event Elapsed Time(s)", '', 'EventElapsedTimes'),  # noqa
    0x00082132: ('LO', '1-n', "Event Timer Name(s)", '', 'EventTimerNames'),  # noqa
    0x00082133: ('SQ', '1', "Event Timer Sequence", '', 'EventTimerSequence'),  # noqa
    0x00082134: ('FD', '1', "Event Time Offset", '', 'EventTimeOffset'),  # noqa
    0x00082135: ('SQ', '1', "Event Code Sequence", '', 'EventCodeSequence'),  # noqa
    0x00082142: ('IS', '1', "Start Trim", '', 'StartTrim'),  # noqa
    0x00082143: ('IS', '1', "Stop Trim", '', 'StopTrim'),  # noqa
    0x00082144: ('IS', '1', "Recommended Display Frame Rate", '', 'RecommendedDisplayFrameRate'),  # noqa
    0x00082200: ('CS', '1', "Transducer Position", 'Retired', 'TransducerPosition'),  # noqa
    0x00082204: ('CS', '1', "Transducer Orientation", 'Retired', 'TransducerOrientation'),  # noqa
    0x00082208: ('CS', '1', "Anatomic Structure", 'Retired', 'AnatomicStructure'),  # noqa
    0x00082218: ('SQ', '1', "Anatomic Region Sequence", '', 'AnatomicRegionSequence'),  # noqa
    0x00082220: ('SQ', '1', "Anatomic Region Modifier Sequence", '', 'AnatomicRegionModifierSequence'),  # noqa
    0x00082228: ('SQ', '1', "Primary Anatomic Structure Sequence", '', 'PrimaryAnatomicStructureSequence'),  # noqa
    0x00082229: ('SQ', '1', "Anatomic Structure, Space or Region Sequence", 'Retired', 'AnatomicStructureSpaceOrRegionSequence'),  # noqa
    0x00082230: ('SQ', '1', "Primary Anatomic Structure Modifier Sequence", '', 'PrimaryAnatomicStructureModifierSequence'),  # noqa
    0x00082240: ('SQ', '1', "Transducer Position Sequence", 'Retired', 'TransducerPositionSequence'),  # noqa
    0x00082242: ('SQ', '1', "Transducer Position Modifier Sequence", 'Retired', 'TransducerPositionModifierSequence'),  # noqa
    0x00082244: ('SQ', '1', "Transducer Orientation Sequence", 'Retired', 'TransducerOrientationSequence'),  # noqa
    0x00082246: ('SQ', '1', "Transducer Orientation Modifier Sequence", 'Retired', 'TransducerOrientationModifierSequence'),  # noqa
    0x00082251: ('SQ', '1', "Anatomic Structure Space Or Region Code Sequence (Trial)", 'Retired', 'AnatomicStructureSpaceOrRegionCodeSequenceTrial'),  # noqa
    0x00082253: ('SQ', '1', "Anatomic Portal Of Entrance Code Sequence (Trial)", 'Retired', 'AnatomicPortalOfEntranceCodeSequenceTrial'),  # noqa
    0x00082255: ('SQ', '1', "Anatomic Approach Direction Code Sequence (Trial)", 'Retired', 'AnatomicApproachDirectionCodeSequenceTrial'),  # noqa
    0x00082256: ('ST', '1', "Anatomic Perspective Description (Trial)", 'Retired', 'AnatomicPerspectiveDescriptionTrial'),  # noqa
    0x00082257: ('SQ', '1', "Anatomic Perspective Code Sequence (Trial)", 'Retired', 'AnatomicPerspectiveCodeSequenceTrial'),  # noqa
    0x00082258: ('ST', '1', "Anatomic Location Of Examining Instrument Description (Trial)", 'Retired', 'AnatomicLocationOfExaminingInstrumentDescriptionTrial'),  # noqa
    0x00082259: ('SQ', '1', "Anatomic Location Of Examining Instrument Code Sequence (Trial)", 'Retired', 'AnatomicLocationOfExaminingInstrumentCodeSequenceTrial'),  # noqa
    0x0008225A: ('SQ', '1', "Anatomic Structure Space Or Region Modifier Code Sequence (Trial)", 'Retired', 'AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial'),  # noqa
    0x0008225C: ('SQ', '1', "On Axis Background Anatomic Structure Code Sequence (Trial)", 'Retired', 'OnAxisBackgroundAnatomicStructureCodeSequenceTrial'),  # noqa
    0x00083001: ('SQ', '1', "Alternate Representation Sequence", '', 'AlternateRepresentationSequence'),  # noqa
    0x00083010: ('UI', '1-n', "Irradiation Event UID", '', 'IrradiationEventUID'),  # noqa
    0x00083011: ('SQ', '1', "Source Irradiation Event Sequence", '', 'SourceIrradiationEventSequence'),  # noqa
    0x00083012: ('UI', '1', "Radiopharmaceutical Administration Event UID", '', 'RadiopharmaceuticalAdministrationEventUID'),  # noqa
    0x00084000: ('LT', '1', "Identifying Comments", 'Retired', 'IdentifyingComments'),  # noqa
    0x00089007: ('CS', '4', "Frame Type", '', 'FrameType'),  # noqa
    0x00089092: ('SQ', '1', "Referenced Image Evidence Sequence", '', 'ReferencedImageEvidenceSequence'),  # noqa
    0x00089121: ('SQ', '1', "Referenced Raw Data Sequence", '', 'ReferencedRawDataSequence'),  # noqa
    0x00089123: ('UI', '1', "Creator-Version UID", '', 'CreatorVersionUID'),  # noqa
    0x00089124: ('SQ', '1', "Derivation Image Sequence", '', 'DerivationImageSequence'),  # noqa
    0x00089154: ('SQ', '1', "Source Image Evidence Sequence", '', 'SourceImageEvidenceSequence'),  # noqa
    0x00089205: ('CS', '1', "Pixel Presentation", '', 'PixelPresentation'),  # noqa
    0x00089206: ('CS', '1', "Volumetric Properties", '', 'VolumetricProperties'),  # noqa
    0x00089207: ('CS', '1', "Volume Based Calculation Technique", '', 'VolumeBasedCalculationTechnique'),  # noqa
    0x00089208: ('CS', '1', "Complex Image Component", '', 'ComplexImageComponent'),  # noqa
    0x00089209: ('CS', '1', "Acquisition Contrast", '', 'AcquisitionContrast'),  # noqa
    0x00089215: ('SQ', '1', "Derivation Code Sequence", '', 'DerivationCodeSequence'),  # noqa
    0x00089237: ('SQ', '1', "Referenced Presentation State Sequence", '', 'ReferencedPresentationStateSequence'),  # noqa
    0x00089410: ('SQ', '1', "Referenced Other Plane Sequence", '', 'ReferencedOtherPlaneSequence'),  # noqa
    0x00089458: ('SQ', '1', "Frame Display Sequence", '', 'FrameDisplaySequence'),  # noqa
    0x00089459: ('FL', '1', "Recommended Display Frame Rate in Float", '', 'RecommendedDisplayFrameRateInFloat'),  # noqa
    0x00089460: ('CS', '1', "Skip Frame Range Flag", '', 'SkipFrameRangeFlag'),  # noqa
    0x00100010: ('PN', '1', "Patient's Name", '', 'PatientName'),  # noqa
    0x00100020: ('LO', '1', "Patient ID", '', 'PatientID'),  # noqa
    0x00100021: ('LO', '1', "Issuer of Patient ID", '', 'IssuerOfPatientID'),  # noqa
    0x00100022: ('CS', '1', "Type of Patient ID", '', 'TypeOfPatientID'),  # noqa
    0x00100024: ('SQ', '1', "Issuer of Patient ID Qualifiers Sequence", '', 'IssuerOfPatientIDQualifiersSequence'),  # noqa
    0x00100026: ('SQ', '1', "Source Patient Group Identification Sequence", '', 'SourcePatientGroupIdentificationSequence'),  # noqa
    0x00100027: ('SQ', '1', "Group of Patients Identification Sequence", '', 'GroupOfPatientsIdentificationSequence'),  # noqa
    0x00100028: ('US', '3', "Subject Relative Position in Image", '', 'SubjectRelativePositionInImage'),  # noqa
    0x00100030: ('DA', '1', "Patient's Birth Date", '', 'PatientBirthDate'),  # noqa
    0x00100032: ('TM', '1', "Patient's Birth Time", '', 'PatientBirthTime'),  # noqa
    0x00100033: ('LO', '1', "Patient's Birth Date in Alternative Calendar", '', 'PatientBirthDateInAlternativeCalendar'),  # noqa
    0x00100034: ('LO', '1', "Patient's Death Date in Alternative Calendar", '', 'PatientDeathDateInAlternativeCalendar'),  # noqa
    0x00100035: ('CS', '1', "Patient's Alternative Calendar", '', 'PatientAlternativeCalendar'),  # noqa
    0x00100040: ('CS', '1', "Patient's Sex", '', 'PatientSex'),  # noqa
    0x00100050: ('SQ', '1', "Patient's Insurance Plan Code Sequence", '', 'PatientInsurancePlanCodeSequence'),  # noqa
    0x00100101: ('SQ', '1', "Patient's Primary Language Code Sequence", '', 'PatientPrimaryLanguageCodeSequence'),  # noqa
    0x00100102: ('SQ', '1', "Patient's Primary Language Modifier Code Sequence", '', 'PatientPrimaryLanguageModifierCodeSequence'),  # noqa
    0x00100200: ('CS', '1', "Quality Control Subject", '', 'QualityControlSubject'),  # noqa
    0x00100201: ('SQ', '1', "Quality Control Subject Type Code Sequence", '', 'QualityControlSubjectTypeCodeSequence'),  # noqa
    0x00100212: ('UC', '1', "Strain Description", '', 'StrainDescription'),  # noqa
    0x00100213: ('LO', '1', "Strain Nomenclature", '', 'StrainNomenclature'),  # noqa
    0x00100214: ('LO', '1', "Strain Stock Number", '', 'StrainStockNumber'),  # noqa
    0x00100215: ('SQ', '1', "Strain Source Registry Code Sequence", '', 'StrainSourceRegistryCodeSequence'),  # noqa
    0x00100216: ('SQ', '1', "Strain Stock Sequence", '', 'StrainStockSequence'),  # noqa
    0x00100217: ('LO', '1', "Strain Source", '', 'StrainSource'),  # noqa
    0x00100218: ('UT', '1', "Strain Additional Information", '', 'StrainAdditionalInformation'),  # noqa
    0x00100219: ('SQ', '1', "Strain Code Sequence", '', 'StrainCodeSequence'),  # noqa
    0x00100221: ('SQ', '1', "Genetic Modifications Sequence", '', 'GeneticModificationsSequence'),  # noqa
    0x00100222: ('UC', '1', "Genetic Modifications Description", '', 'GeneticModificationsDescription'),  # noqa
    0x00100223: ('LO', '1', "Genetic Modifications Nomenclature", '', 'GeneticModificationsNomenclature'),  # noqa
    0x00100229: ('SQ', '1', "Genetic Modifications Code Sequence", '', 'GeneticModificationsCodeSequence'),  # noqa
    0x00101000: ('LO', '1-n', "Other Patient IDs", 'Retired', 'OtherPatientIDs'),  # noqa
    0x00101001: ('PN', '1-n', "Other Patient Names", '', 'OtherPatientNames'),  # noqa
    0x00101002: ('SQ', '1', "Other Patient IDs Sequence", '', 'OtherPatientIDsSequence'),  # noqa
    0x00101005: ('PN', '1', "Patient's Birth Name", '', 'PatientBirthName'),  # noqa
    0x00101010: ('AS', '1', "Patient's Age", '', 'PatientAge'),  # noqa
    0x00101020: ('DS', '1', "Patient's Size", '', 'PatientSize'),  # noqa
    0x00101021: ('SQ', '1', "Patient's Size Code Sequence", '', 'PatientSizeCodeSequence'),  # noqa
    0x00101022: ('DS', '1', "Patient's Body Mass Index", '', 'PatientBodyMassIndex'),  # noqa
    0x00101023: ('DS', '1', "Measured AP Dimension", '', 'MeasuredAPDimension'),  # noqa
    0x00101024: ('DS', '1', "Measured Lateral Dimension", '', 'MeasuredLateralDimension'),  # noqa
    0x00101030: ('DS', '1', "Patient's Weight", '', 'PatientWeight'),  # noqa
    0x00101040: ('LO', '1', "Patient's Address", '', 'PatientAddress'),  # noqa
    0x00101050: ('LO', '1-n', "Insurance Plan Identification", 'Retired', 'InsurancePlanIdentification'),  # noqa
    0x00101060: ('PN', '1', "Patient's Mother's Birth Name", '', 'PatientMotherBirthName'),  # noqa
    0x00101080: ('LO', '1', "Military Rank", '', 'MilitaryRank'),  # noqa
    0x00101081: ('LO', '1', "Branch of Service", '', 'BranchOfService'),  # noqa
    0x00101090: ('LO', '1', "Medical Record Locator", 'Retired', 'MedicalRecordLocator'),  # noqa
    0x00101100: ('SQ', '1', "Referenced Patient Photo Sequence", '', 'ReferencedPatientPhotoSequence'),  # noqa
    0x00102000: ('LO', '1-n', "Medical Alerts", '', 'MedicalAlerts'),  # noqa
    0x00102110: ('LO', '1-n', "Allergies", '', 'Allergies'),  # noqa
    0x00102150: ('LO', '1', "Country of Residence", '', 'CountryOfResidence'),  # noqa
    0x00102152: ('LO', '1', "Region of Residence", '', 'RegionOfResidence'),  # noqa
    0x00102154: ('SH', '1-n', "Patient's Telephone Numbers", '', 'PatientTelephoneNumbers'),  # noqa
    0x00102155: ('LT', '1', "Patient's Telecom Information", '', 'PatientTelecomInformation'),  # noqa
    0x00102160: ('SH', '1', "Ethnic Group", '', 'EthnicGroup'),  # noqa
    0x00102180: ('SH', '1', "Occupation", '', 'Occupation'),  # noqa
    0x001021A0: ('CS', '1', "Smoking Status", '', 'SmokingStatus'),  # noqa
    0x001021B0: ('LT', '1', "Additional Patient History", '', 'AdditionalPatientHistory'),  # noqa
    0x001021C0: ('US', '1', "Pregnancy Status", '', 'PregnancyStatus'),  # noqa
    0x001021D0: ('DA', '1', "Last Menstrual Date", '', 'LastMenstrualDate'),  # noqa
    0x001021F0: ('LO', '1', "Patient's Religious Preference", '', 'PatientReligiousPreference'),  # noqa
    0x00102201: ('LO', '1', "Patient Species Description", '', 'PatientSpeciesDescription'),  # noqa
    0x00102202: ('SQ', '1', "Patient Species Code Sequence", '', 'PatientSpeciesCodeSequence'),  # noqa
    0x00102203: ('CS', '1', "Patient's Sex Neutered", '', 'PatientSexNeutered'),  # noqa
    0x00102210: ('CS', '1', "Anatomical Orientation Type", '', 'AnatomicalOrientationType'),  # noqa
    0x00102292: ('LO', '1', "Patient Breed Description", '', 'PatientBreedDescription'),  # noqa
    0x00102293: ('SQ', '1', "Patient Breed Code Sequence", '', 'PatientBreedCodeSequence'),  # noqa
    0x00102294: ('SQ', '1', "Breed Registration Sequence", '', 'BreedRegistrationSequence'),  # noqa
    0x00102295: ('LO', '1', "Breed Registration Number", '', 'BreedRegistrationNumber'),  # noqa
    0x00102296: ('SQ', '1', "Breed Registry Code Sequence", '', 'BreedRegistryCodeSequence'),  # noqa
    0x00102297: ('PN', '1', "Responsible Person", '', 'ResponsiblePerson'),  # noqa
    0x00102298: ('CS', '1', "Responsible Person Role", '', 'ResponsiblePersonRole'),  # noqa
    0x00102299: ('LO', '1', "Responsible Organization", '', 'ResponsibleOrganization'),  # noqa
    0x00104000: ('LT', '1', "Patient Comments", '', 'PatientComments'),  # noqa
    0x00109431: ('FL', '1', "Examined Body Thickness", '', 'ExaminedBodyThickness'),  # noqa
    0x00120010: ('LO', '1', "Clinical Trial Sponsor Name", '', 'ClinicalTrialSponsorName'),  # noqa
    0x00120020: ('LO', '1', "Clinical Trial Protocol ID", '', 'ClinicalTrialProtocolID'),  # noqa
    0x00120021: ('LO', '1', "Clinical Trial Protocol Name", '', 'ClinicalTrialProtocolName'),  # noqa
    0x00120030: ('LO', '1', "Clinical Trial Site ID", '', 'ClinicalTrialSiteID'),  # noqa
    0x00120031: ('LO', '1', "Clinical Trial Site Name", '', 'ClinicalTrialSiteName'),  # noqa
    0x00120040: ('LO', '1', "Clinical Trial Subject ID", '', 'ClinicalTrialSubjectID'),  # noqa
    0x00120042: ('LO', '1', "Clinical Trial Subject Reading ID", '', 'ClinicalTrialSubjectReadingID'),  # noqa
    0x00120050: ('LO', '1', "Clinical Trial Time Point ID", '', 'ClinicalTrialTimePointID'),  # noqa
    0x00120051: ('ST', '1', "Clinical Trial Time Point Description", '', 'ClinicalTrialTimePointDescription'),  # noqa
    0x00120052: ('FD', '1', "Longitudinal Temporal Offset from Event", '', 'LongitudinalTemporalOffsetFromEvent'),  # noqa
    0x00120053: ('CS', '1', "Longitudinal Temporal Event Type", '', 'LongitudinalTemporalEventType'),  # noqa
    0x00120060: ('LO', '1', "Clinical Trial Coordinating Center Name", '', 'ClinicalTrialCoordinatingCenterName'),  # noqa
    0x00120062: ('CS', '1', "Patient Identity Removed", '', 'PatientIdentityRemoved'),  # noqa
    0x00120063: ('LO', '1-n', "De-identification Method", '', 'DeidentificationMethod'),  # noqa
    0x00120064: ('SQ', '1', "De-identification Method Code Sequence", '', 'DeidentificationMethodCodeSequence'),  # noqa
    0x00120071: ('LO', '1', "Clinical Trial Series ID", '', 'ClinicalTrialSeriesID'),  # noqa
    0x00120072: ('LO', '1', "Clinical Trial Series Description", '', 'ClinicalTrialSeriesDescription'),  # noqa
    0x00120081: ('LO', '1', "Clinical Trial Protocol Ethics Committee Name", '', 'ClinicalTrialProtocolEthicsCommitteeName'),  # noqa
    0x00120082: ('LO', '1', "Clinical Trial Protocol Ethics Committee Approval Number", '', 'ClinicalTrialProtocolEthicsCommitteeApprovalNumber'),  # noqa
    0x00120083: ('SQ', '1', "Consent for Clinical Trial Use Sequence", '', 'ConsentForClinicalTrialUseSequence'),  # noqa
    0x00120084: ('CS', '1', "Distribution Type", '', 'DistributionType'),  # noqa
    0x00120085: ('CS', '1', "Consent for Distribution Flag", '', 'ConsentForDistributionFlag'),  # noqa
    0x00120086: ('DA', '1', "Ethics Committee Approval Effectiveness Start Date", '', 'EthicsCommitteeApprovalEffectivenessStartDate'),  # noqa
    0x00120087: ('DA', '1', "Ethics Committee Approval Effectiveness End Date", '', 'EthicsCommitteeApprovalEffectivenessEndDate'),  # noqa
    0x00140023: ('ST', '1', "CAD File Format", 'Retired', 'CADFileFormat'),  # noqa
    0x00140024: ('ST', '1', "Component Reference System", 'Retired', 'ComponentReferenceSystem'),  # noqa
    0x00140025: ('ST', '1', "Component Manufacturing Procedure", '', 'ComponentManufacturingProcedure'),  # noqa
    0x00140028: ('ST', '1', "Component Manufacturer", '', 'ComponentManufacturer'),  # noqa
    0x00140030: ('DS', '1-n', "Material Thickness", '', 'MaterialThickness'),  # noqa
    0x00140032: ('DS', '1-n', "Material Pipe Diameter", '', 'MaterialPipeDiameter'),  # noqa
    0x00140034: ('DS', '1-n', "Material Isolation Diameter", '', 'MaterialIsolationDiameter'),  # noqa
    0x00140042: ('ST', '1', "Material Grade", '', 'MaterialGrade'),  # noqa
    0x00140044: ('ST', '1', "Material Properties Description", '', 'MaterialPropertiesDescription'),  # noqa
    0x00140045: ('ST', '1', "Material Properties File Format (Retired)", 'Retired', 'MaterialPropertiesFileFormatRetired'),  # noqa
    0x00140046: ('LT', '1', "Material Notes", '', 'MaterialNotes'),  # noqa
    0x00140050: ('CS', '1', "Component Shape", '', 'ComponentShape'),  # noqa
    0x00140052: ('CS', '1', "Curvature Type", '', 'CurvatureType'),  # noqa
    0x00140054: ('DS', '1', "Outer Diameter", '', 'OuterDiameter'),  # noqa
    0x00140056: ('DS', '1', "Inner Diameter", '', 'InnerDiameter'),  # noqa
    0x00140100: ('LO', '1-n', "Component Welder IDs", '', 'ComponentWelderIDs'),  # noqa
    0x00140101: ('CS', '1', "Secondary Approval Status", '', 'SecondaryApprovalStatus'),  # noqa
    0x00140102: ('DA', '1', "Secondary Review Date", '', 'SecondaryReviewDate'),  # noqa
    0x00140103: ('TM', '1', "Secondary Review Time", '', 'SecondaryReviewTime'),  # noqa
    0x00140104: ('PN', '1', "Secondary Reviewer Name", '', 'SecondaryReviewerName'),  # noqa
    0x00140105: ('ST', '1', "Repair ID", '', 'RepairID'),  # noqa
    0x00140106: ('SQ', '1', "Multiple Component Approval Sequence", '', 'MultipleComponentApprovalSequence'),  # noqa
    0x00140107: ('CS', '1-n', "Other Approval Status", '', 'OtherApprovalStatus'),  # noqa
    0x00140108: ('CS', '1-n', "Other Secondary Approval Status", '', 'OtherSecondaryApprovalStatus'),  # noqa
    0x00141010: ('ST', '1', "Actual Environmental Conditions", '', 'ActualEnvironmentalConditions'),  # noqa
    0x00141020: ('DA', '1', "Expiry Date", '', 'ExpiryDate'),  # noqa
    0x00141040: ('ST', '1', "Environmental Conditions", '', 'EnvironmentalConditions'),  # noqa
    0x00142002: ('SQ', '1', "Evaluator Sequence", '', 'EvaluatorSequence'),  # noqa
    0x00142004: ('IS', '1', "Evaluator Number", '', 'EvaluatorNumber'),  # noqa
    0x00142006: ('PN', '1', "Evaluator Name", '', 'EvaluatorName'),  # noqa
    0x00142008: ('IS', '1', "Evaluation Attempt", '', 'EvaluationAttempt'),  # noqa
    0x00142012: ('SQ', '1', "Indication Sequence", '', 'IndicationSequence'),  # noqa
    0x00142014: ('IS', '1', "Indication Number", '', 'IndicationNumber'),  # noqa
    0x00142016: ('SH', '1', "Indication Label", '', 'IndicationLabel'),  # noqa
    0x00142018: ('ST', '1', "Indication Description", '', 'IndicationDescription'),  # noqa
    0x0014201A: ('CS', '1-n', "Indication Type", '', 'IndicationType'),  # noqa
    0x0014201C: ('CS', '1', "Indication Disposition", '', 'IndicationDisposition'),  # noqa
    0x0014201E: ('SQ', '1', "Indication ROI Sequence", '', 'IndicationROISequence'),  # noqa
    0x00142030: ('SQ', '1', "Indication Physical Property Sequence", '', 'IndicationPhysicalPropertySequence'),  # noqa
    0x00142032: ('SH', '1', "Property Label", '', 'PropertyLabel'),  # noqa
    0x00142202: ('IS', '1', "Coordinate System Number of Axes", '', 'CoordinateSystemNumberOfAxes'),  # noqa
    0x00142204: ('SQ', '1', "Coordinate System Axes Sequence", '', 'CoordinateSystemAxesSequence'),  # noqa
    0x00142206: ('ST', '1', "Coordinate System Axis Description", '', 'CoordinateSystemAxisDescription'),  # noqa
    0x00142208: ('CS', '1', "Coordinate System Data Set Mapping", '', 'CoordinateSystemDataSetMapping'),  # noqa
    0x0014220A: ('IS', '1', "Coordinate System Axis Number", '', 'CoordinateSystemAxisNumber'),  # noqa
    0x0014220C: ('CS', '1', "Coordinate System Axis Type", '', 'CoordinateSystemAxisType'),  # noqa
    0x0014220E: ('CS', '1', "Coordinate System Axis Units", '', 'CoordinateSystemAxisUnits'),  # noqa
    0x00142210: ('OB', '1', "Coordinate System Axis Values", '', 'CoordinateSystemAxisValues'),  # noqa
    0x00142220: ('SQ', '1', "Coordinate System Transform Sequence", '', 'CoordinateSystemTransformSequence'),  # noqa
    0x00142222: ('ST', '1', "Transform Description", '', 'TransformDescription'),  # noqa
    0x00142224: ('IS', '1', "Transform Number of Axes", '', 'TransformNumberOfAxes'),  # noqa
    0x00142226: ('IS', '1-n', "Transform Order of Axes", '', 'TransformOrderOfAxes'),  # noqa
    0x00142228: ('CS', '1', "Transformed Axis Units", '', 'TransformedAxisUnits'),  # noqa
    0x0014222A: ('DS', '1-n', "Coordinate System Transform Rotation and Scale Matrix", '', 'CoordinateSystemTransformRotationAndScaleMatrix'),  # noqa
    0x0014222C: ('DS', '1-n', "Coordinate System Transform Translation Matrix", '', 'CoordinateSystemTransformTranslationMatrix'),  # noqa
    0x00143011: ('DS', '1', "Internal Detector Frame Time", '', 'InternalDetectorFrameTime'),  # noqa
    0x00143012: ('DS', '1', "Number of Frames Integrated", '', 'NumberOfFramesIntegrated'),  # noqa
    0x00143020: ('SQ', '1', "Detector Temperature Sequence", '', 'DetectorTemperatureSequence'),  # noqa
    0x00143022: ('ST', '1', "Sensor Name", '', 'SensorName'),  # noqa
    0x00143024: ('DS', '1', "Horizontal Offset of Sensor", '', 'HorizontalOffsetOfSensor'),  # noqa
    0x00143026: ('DS', '1', "Vertical Offset of Sensor", '', 'VerticalOffsetOfSensor'),  # noqa
    0x00143028: ('DS', '1', "Sensor Temperature", '', 'SensorTemperature'),  # noqa
    0x00143040: ('SQ', '1', "Dark Current Sequence", '', 'DarkCurrentSequence'),  # noqa
    0x00143050: ('OB or OW', '1', "Dark Current Counts", '', 'DarkCurrentCounts'),  # noqa
    0x00143060: ('SQ', '1', "Gain Correction Reference Sequence", '', 'GainCorrectionReferenceSequence'),  # noqa
    0x00143070: ('OB or OW', '1', "Air Counts", '', 'AirCounts'),  # noqa
    0x00143071: ('DS', '1', "KV Used in Gain Calibration", '', 'KVUsedInGainCalibration'),  # noqa
    0x00143072: ('DS', '1', "MA Used in Gain Calibration", '', 'MAUsedInGainCalibration'),  # noqa
    0x00143073: ('DS', '1', "Number of Frames Used for Integration", '', 'NumberOfFramesUsedForIntegration'),  # noqa
    0x00143074: ('LO', '1', "Filter Material Used in Gain Calibration", '', 'FilterMaterialUsedInGainCalibration'),  # noqa
    0x00143075: ('DS', '1', "Filter Thickness Used in Gain Calibration", '', 'FilterThicknessUsedInGainCalibration'),  # noqa
    0x00143076: ('DA', '1', "Date of Gain Calibration", '', 'DateOfGainCalibration'),  # noqa
    0x00143077: ('TM', '1', "Time of Gain Calibration", '', 'TimeOfGainCalibration'),  # noqa
    0x00143080: ('OB', '1', "Bad Pixel Image", '', 'BadPixelImage'),  # noqa
    0x00143099: ('LT', '1', "Calibration Notes", '', 'CalibrationNotes'),  # noqa
    0x00144002: ('SQ', '1', "Pulser Equipment Sequence", '', 'PulserEquipmentSequence'),  # noqa
    0x00144004: ('CS', '1', "Pulser Type", '', 'PulserType'),  # noqa
    0x00144006: ('LT', '1', "Pulser Notes", '', 'PulserNotes'),  # noqa
    0x00144008: ('SQ', '1', "Receiver Equipment Sequence", '', 'ReceiverEquipmentSequence'),  # noqa
    0x0014400A: ('CS', '1', "Amplifier Type", '', 'AmplifierType'),  # noqa
    0x0014400C: ('LT', '1', "Receiver Notes", '', 'ReceiverNotes'),  # noqa
    0x0014400E: ('SQ', '1', "Pre-Amplifier Equipment Sequence", '', 'PreAmplifierEquipmentSequence'),  # noqa
    0x0014400F: ('LT', '1', "Pre-Amplifier Notes", '', 'PreAmplifierNotes'),  # noqa
    0x00144010: ('SQ', '1', "Transmit Transducer Sequence", '', 'TransmitTransducerSequence'),  # noqa
    0x00144011: ('SQ', '1', "Receive Transducer Sequence", '', 'ReceiveTransducerSequence'),  # noqa
    0x00144012: ('US', '1', "Number of Elements", '', 'NumberOfElements'),  # noqa
    0x00144013: ('CS', '1', "Element Shape", '', 'ElementShape'),  # noqa
    0x00144014: ('DS', '1', "Element Dimension A", '', 'ElementDimensionA'),  # noqa
    0x00144015: ('DS', '1', "Element Dimension B", '', 'ElementDimensionB'),  # noqa
    0x00144016: ('DS', '1', "Element Pitch A", '', 'ElementPitchA'),  # noqa
    0x00144017: ('DS', '1', "Measured Beam Dimension A", '', 'MeasuredBeamDimensionA'),  # noqa
    0x00144018: ('DS', '1', "Measured Beam Dimension B", '', 'MeasuredBeamDimensionB'),  # noqa
    0x00144019: ('DS', '1', "Location of Measured Beam Diameter", '', 'LocationOfMeasuredBeamDiameter'),  # noqa
    0x0014401A: ('DS', '1', "Nominal Frequency", '', 'NominalFrequency'),  # noqa
    0x0014401B: ('DS', '1', "Measured Center Frequency", '', 'MeasuredCenterFrequency'),  # noqa
    0x0014401C: ('DS', '1', "Measured Bandwidth", '', 'MeasuredBandwidth'),  # noqa
    0x0014401D: ('DS', '1', "Element Pitch B", '', 'ElementPitchB'),  # noqa
    0x00144020: ('SQ', '1', "Pulser Settings Sequence", '', 'PulserSettingsSequence'),  # noqa
    0x00144022: ('DS', '1', "Pulse Width", '', 'PulseWidth'),  # noqa
    0x00144024: ('DS', '1', "Excitation Frequency", '', 'ExcitationFrequency'),  # noqa
    0x00144026: ('CS', '1', "Modulation Type", '', 'ModulationType'),  # noqa
    0x00144028: ('DS', '1', "Damping", '', 'Damping'),  # noqa
    0x00144030: ('SQ', '1', "Receiver Settings Sequence", '', 'ReceiverSettingsSequence'),  # noqa
    0x00144031: ('DS', '1', "Acquired Soundpath Length", '', 'AcquiredSoundpathLength'),  # noqa
    0x00144032: ('CS', '1', "Acquisition Compression Type", '', 'AcquisitionCompressionType'),  # noqa
    0x00144033: ('IS', '1', "Acquisition Sample Size", '', 'AcquisitionSampleSize'),  # noqa
    0x00144034: ('DS', '1', "Rectifier Smoothing", '', 'RectifierSmoothing'),  # noqa
    0x00144035: ('SQ', '1', "DAC Sequence", '', 'DACSequence'),  # noqa
    0x00144036: ('CS', '1', "DAC Type", '', 'DACType'),  # noqa
    0x00144038: ('DS', '1-n', "DAC Gain Points", '', 'DACGainPoints'),  # noqa
    0x0014403A: ('DS', '1-n', "DAC Time Points", '', 'DACTimePoints'),  # noqa
    0x0014403C: ('DS', '1-n', "DAC Amplitude", '', 'DACAmplitude'),  # noqa
    0x00144040: ('SQ', '1', "Pre-Amplifier Settings Sequence", '', 'PreAmplifierSettingsSequence'),  # noqa
    0x00144050: ('SQ', '1', "Transmit Transducer Settings Sequence", '', 'TransmitTransducerSettingsSequence'),  # noqa
    0x00144051: ('SQ', '1', "Receive Transducer Settings Sequence", '', 'ReceiveTransducerSettingsSequence'),  # noqa
    0x00144052: ('DS', '1', "Incident Angle", '', 'IncidentAngle'),  # noqa
    0x00144054: ('ST', '1', "Coupling Technique", '', 'CouplingTechnique'),  # noqa
    0x00144056: ('ST', '1', "Coupling Medium", '', 'CouplingMedium'),  # noqa
    0x00144057: ('DS', '1', "Coupling Velocity", '', 'CouplingVelocity'),  # noqa
    0x00144058: ('DS', '1', "Probe Center Location X", '', 'ProbeCenterLocationX'),  # noqa
    0x00144059: ('DS', '1', "Probe Center Location Z", '', 'ProbeCenterLocationZ'),  # noqa
    0x0014405A: ('DS', '1', "Sound Path Length", '', 'SoundPathLength'),  # noqa
    0x0014405C: ('ST', '1', "Delay Law Identifier", '', 'DelayLawIdentifier'),  # noqa
    0x00144060: ('SQ', '1', "Gate Settings Sequence", '', 'GateSettingsSequence'),  # noqa
    0x00144062: ('DS', '1', "Gate Threshold", '', 'GateThreshold'),  # noqa
    0x00144064: ('DS', '1', "Velocity of Sound", '', 'VelocityOfSound'),  # noqa
    0x00144070: ('SQ', '1', "Calibration Settings Sequence", '', 'CalibrationSettingsSequence'),  # noqa
    0x00144072: ('ST', '1', "Calibration Procedure", '', 'CalibrationProcedure'),  # noqa
    0x00144074: ('SH', '1', "Procedure Version", '', 'ProcedureVersion'),  # noqa
    0x00144076: ('DA', '1', "Procedure Creation Date", '', 'ProcedureCreationDate'),  # noqa
    0x00144078: ('DA', '1', "Procedure Expiration Date", '', 'ProcedureExpirationDate'),  # noqa
    0x0014407A: ('DA', '1', "Procedure Last Modified Date", '', 'ProcedureLastModifiedDate'),  # noqa
    0x0014407C: ('TM', '1-n', "Calibration Time", '', 'CalibrationTime'),  # noqa
    0x0014407E: ('DA', '1-n', "Calibration Date", '', 'CalibrationDate'),  # noqa
    0x00144080: ('SQ', '1', "Probe Drive Equipment Sequence", '', 'ProbeDriveEquipmentSequence'),  # noqa
    0x00144081: ('CS', '1', "Drive Type", '', 'DriveType'),  # noqa
    0x00144082: ('LT', '1', "Probe Drive Notes", '', 'ProbeDriveNotes'),  # noqa
    0x00144083: ('SQ', '1', "Drive Probe Sequence", '', 'DriveProbeSequence'),  # noqa
    0x00144084: ('DS', '1', "Probe Inductance", '', 'ProbeInductance'),  # noqa
    0x00144085: ('DS', '1', "Probe Resistance", '', 'ProbeResistance'),  # noqa
    0x00144086: ('SQ', '1', "Receive Probe Sequence", '', 'ReceiveProbeSequence'),  # noqa
    0x00144087: ('SQ', '1', "Probe Drive Settings Sequence", '', 'ProbeDriveSettingsSequence'),  # noqa
    0x00144088: ('DS', '1', "Bridge Resistors", '', 'BridgeResistors'),  # noqa
    0x00144089: ('DS', '1', "Probe Orientation Angle", '', 'ProbeOrientationAngle'),  # noqa
    0x0014408B: ('DS', '1', "User Selected Gain Y", '', 'UserSelectedGainY'),  # noqa
    0x0014408C: ('DS', '1', "User Selected Phase", '', 'UserSelectedPhase'),  # noqa
    0x0014408D: ('DS', '1', "User Selected Offset X", '', 'UserSelectedOffsetX'),  # noqa
    0x0014408E: ('DS', '1', "User Selected Offset Y", '', 'UserSelectedOffsetY'),  # noqa
    0x00144091: ('SQ', '1', "Channel Settings Sequence", '', 'ChannelSettingsSequence'),  # noqa
    0x00144092: ('DS', '1', "Channel Threshold", '', 'ChannelThreshold'),  # noqa
    0x0014409A: ('SQ', '1', "Scanner Settings Sequence", '', 'ScannerSettingsSequence'),  # noqa
    0x0014409B: ('ST', '1', "Scan Procedure", '', 'ScanProcedure'),  # noqa
    0x0014409C: ('DS', '1', "Translation Rate X", '', 'TranslationRateX'),  # noqa
    0x0014409D: ('DS', '1', "Translation Rate Y", '', 'TranslationRateY'),  # noqa
    0x0014409F: ('DS', '1', "Channel Overlap", '', 'ChannelOverlap'),  # noqa
    0x001440A0: ('LO', '1', "Image Quality Indicator Type", '', 'ImageQualityIndicatorType'),  # noqa
    0x001440A1: ('LO', '1', "Image Quality Indicator Material", '', 'ImageQualityIndicatorMaterial'),  # noqa
    0x001440A2: ('LO', '1', "Image Quality Indicator Size", '', 'ImageQualityIndicatorSize'),  # noqa
    0x00145002: ('IS', '1', "LINAC Energy", '', 'LINACEnergy'),  # noqa
    0x00145004: ('IS', '1', "LINAC Output", '', 'LINACOutput'),  # noqa
    0x00145100: ('US', '1', "Active Aperture", '', 'ActiveAperture'),  # noqa
    0x00145101: ('DS', '1', "Total Aperture", '', 'TotalAperture'),  # noqa
    0x00145102: ('DS', '1', "Aperture Elevation", '', 'ApertureElevation'),  # noqa
    0x00145103: ('DS', '1', "Main Lobe Angle", '', 'MainLobeAngle'),  # noqa
    0x00145104: ('DS', '1', "Main Roof Angle", '', 'MainRoofAngle'),  # noqa
    0x00145105: ('CS', '1', "Connector Type", '', 'ConnectorType'),  # noqa
    0x00145106: ('SH', '1', "Wedge Model Number", '', 'WedgeModelNumber'),  # noqa
    0x00145107: ('DS', '1', "Wedge Angle Float", '', 'WedgeAngleFloat'),  # noqa
    0x00145108: ('DS', '1', "Wedge Roof Angle", '', 'WedgeRoofAngle'),  # noqa
    0x00145109: ('CS', '1', "Wedge Element 1 Position", '', 'WedgeElement1Position'),  # noqa
    0x0014510A: ('DS', '1', "Wedge Material Velocity", '', 'WedgeMaterialVelocity'),  # noqa
    0x0014510B: ('SH', '1', "Wedge Material", '', 'WedgeMaterial'),  # noqa
    0x0014510C: ('DS', '1', "Wedge Offset Z", '', 'WedgeOffsetZ'),  # noqa
    0x0014510D: ('DS', '1', "Wedge Origin Offset X", '', 'WedgeOriginOffsetX'),  # noqa
    0x0014510E: ('DS', '1', "Wedge Time Delay", '', 'WedgeTimeDelay'),  # noqa
    0x0014510F: ('SH', '1', "Wedge Name", '', 'WedgeName'),  # noqa
    0x00145110: ('SH', '1', "Wedge Manufacturer Name", '', 'WedgeManufacturerName'),  # noqa
    0x00145111: ('LO', '1', "Wedge Description", '', 'WedgeDescription'),  # noqa
    0x00145112: ('DS', '1', "Nominal Beam Angle", '', 'NominalBeamAngle'),  # noqa
    0x00145113: ('DS', '1', "Wedge Offset X", '', 'WedgeOffsetX'),  # noqa
    0x00145114: ('DS', '1', "Wedge Offset Y", '', 'WedgeOffsetY'),  # noqa
    0x00145115: ('DS', '1', "Wedge Total Length", '', 'WedgeTotalLength'),  # noqa
    0x00145116: ('DS', '1', "Wedge In Contact Length", '', 'WedgeInContactLength'),  # noqa
    0x00145117: ('DS', '1', "Wedge Front Gap", '', 'WedgeFrontGap'),  # noqa
    0x00145118: ('DS', '1', "Wedge Total Height", '', 'WedgeTotalHeight'),  # noqa
    0x00145119: ('DS', '1', "Wedge Front Height", '', 'WedgeFrontHeight'),  # noqa
    0x0014511A: ('DS', '1', "Wedge Rear Height", '', 'WedgeRearHeight'),  # noqa
    0x0014511B: ('DS', '1', "Wedge Total Width", '', 'WedgeTotalWidth'),  # noqa
    0x0014511C: ('DS', '1', "Wedge In Contact Width", '', 'WedgeInContactWidth'),  # noqa
    0x0014511D: ('DS', '1', "Wedge Chamfer Height", '', 'WedgeChamferHeight'),  # noqa
    0x0014511E: ('CS', '1', "Wedge Curve", '', 'WedgeCurve'),  # noqa
    0x0014511F: ('DS', '1', "Radius Along the Wedge", '', 'RadiusAlongWedge'),  # noqa
    0x00180010: ('LO', '1', "Contrast/Bolus Agent", '', 'ContrastBolusAgent'),  # noqa
    0x00180012: ('SQ', '1', "Contrast/Bolus Agent Sequence", '', 'ContrastBolusAgentSequence'),  # noqa
    0x00180013: ('FL', '1', "Contrast/Bolus T1 Relaxivity", '', 'ContrastBolusT1Relaxivity'),  # noqa
    0x00180014: ('SQ', '1', "Contrast/Bolus Administration Route Sequence", '', 'ContrastBolusAdministrationRouteSequence'),  # noqa
    0x00180015: ('CS', '1', "Body Part Examined", '', 'BodyPartExamined'),  # noqa
    0x00180020: ('CS', '1-n', "Scanning Sequence", '', 'ScanningSequence'),  # noqa
    0x00180021: ('CS', '1-n', "Sequence Variant", '', 'SequenceVariant'),  # noqa
    0x00180022: ('CS', '1-n', "Scan Options", '', 'ScanOptions'),  # noqa
    0x00180023: ('CS', '1', "MR Acquisition Type", '', 'MRAcquisitionType'),  # noqa
    0x00180024: ('SH', '1', "Sequence Name", '', 'SequenceName'),  # noqa
    0x00180025: ('CS', '1', "Angio Flag", '', 'AngioFlag'),  # noqa
    0x00180026: ('SQ', '1', "Intervention Drug Information Sequence", '', 'InterventionDrugInformationSequence'),  # noqa
    0x00180027: ('TM', '1', "Intervention Drug Stop Time", '', 'InterventionDrugStopTime'),  # noqa
    0x00180028: ('DS', '1', "Intervention Drug Dose", '', 'InterventionDrugDose'),  # noqa
    0x00180029: ('SQ', '1', "Intervention Drug Code Sequence", '', 'InterventionDrugCodeSequence'),  # noqa
    0x0018002A: ('SQ', '1', "Additional Drug Sequence", '', 'AdditionalDrugSequence'),  # noqa
    0x00180030: ('LO', '1-n', "Radionuclide", 'Retired', 'Radionuclide'),  # noqa
    0x00180031: ('LO', '1', "Radiopharmaceutical", '', 'Radiopharmaceutical'),  # noqa
    0x00180032: ('DS', '1', "Energy Window Centerline", 'Retired', 'EnergyWindowCenterline'),  # noqa
    0x00180033: ('DS', '1-n', "Energy Window Total Width", 'Retired', 'EnergyWindowTotalWidth'),  # noqa
    0x00180034: ('LO', '1', "Intervention Drug Name", '', 'InterventionDrugName'),  # noqa
    0x00180035: ('TM', '1', "Intervention Drug Start Time", '', 'InterventionDrugStartTime'),  # noqa
    0x00180036: ('SQ', '1', "Intervention Sequence", '', 'InterventionSequence'),  # noqa
    0x00180037: ('CS', '1', "Therapy Type", 'Retired', 'TherapyType'),  # noqa
    0x00180038: ('CS', '1', "Intervention Status", '', 'InterventionStatus'),  # noqa
    0x00180039: ('CS', '1', "Therapy Description", 'Retired', 'TherapyDescription'),  # noqa
    0x0018003A: ('ST', '1', "Intervention Description", '', 'InterventionDescription'),  # noqa
    0x00180040: ('IS', '1', "Cine Rate", '', 'CineRate'),  # noqa
    0x00180042: ('CS', '1', "Initial Cine Run State", '', 'InitialCineRunState'),  # noqa
    0x00180050: ('DS', '1', "Slice Thickness", '', 'SliceThickness'),  # noqa
    0x00180060: ('DS', '1', "KVP", '', 'KVP'),  # noqa
    0x00180061: ('DS', '1', "", 'Retired', ''),  # noqa
    0x00180070: ('IS', '1', "Counts Accumulated", '', 'CountsAccumulated'),  # noqa
    0x00180071: ('CS', '1', "Acquisition Termination Condition", '', 'AcquisitionTerminationCondition'),  # noqa
    0x00180072: ('DS', '1', "Effective Duration", '', 'EffectiveDuration'),  # noqa
    0x00180073: ('CS', '1', "Acquisition Start Condition", '', 'AcquisitionStartCondition'),  # noqa
    0x00180074: ('IS', '1', "Acquisition Start Condition Data", '', 'AcquisitionStartConditionData'),  # noqa
    0x00180075: ('IS', '1', "Acquisition Termination Condition Data", '', 'AcquisitionTerminationConditionData'),  # noqa
    0x00180080: ('DS', '1', "Repetition Time", '', 'RepetitionTime'),  # noqa
    0x00180081: ('DS', '1', "Echo Time", '', 'EchoTime'),  # noqa
    0x00180082: ('DS', '1', "Inversion Time", '', 'InversionTime'),  # noqa
    0x00180083: ('DS', '1', "Number of Averages", '', 'NumberOfAverages'),  # noqa
    0x00180084: ('DS', '1', "Imaging Frequency", '', 'ImagingFrequency'),  # noqa
    0x00180085: ('SH', '1', "Imaged Nucleus", '', 'ImagedNucleus'),  # noqa
    0x00180086: ('IS', '1-n', "Echo Number(s)", '', 'EchoNumbers'),  # noqa
    0x00180087: ('DS', '1', "Magnetic Field Strength", '', 'MagneticFieldStrength'),  # noqa
    0x00180088: ('DS', '1', "Spacing Between Slices", '', 'SpacingBetweenSlices'),  # noqa
    0x00180089: ('IS', '1', "Number of Phase Encoding Steps", '', 'NumberOfPhaseEncodingSteps'),  # noqa
    0x00180090: ('DS', '1', "Data Collection Diameter", '', 'DataCollectionDiameter'),  # noqa
    0x00180091: ('IS', '1', "Echo Train Length", '', 'EchoTrainLength'),  # noqa
    0x00180093: ('DS', '1', "Percent Sampling", '', 'PercentSampling'),  # noqa
    0x00180094: ('DS', '1', "Percent Phase Field of View", '', 'PercentPhaseFieldOfView'),  # noqa
    0x00180095: ('DS', '1', "Pixel Bandwidth", '', 'PixelBandwidth'),  # noqa
    0x00181000: ('LO', '1', "Device Serial Number", '', 'DeviceSerialNumber'),  # noqa
    0x00181002: ('UI', '1', "Device UID", '', 'DeviceUID'),  # noqa
    0x00181003: ('LO', '1', "Device ID", '', 'DeviceID'),  # noqa
    0x00181004: ('LO', '1', "Plate ID", '', 'PlateID'),  # noqa
    0x00181005: ('LO', '1', "Generator ID", '', 'GeneratorID'),  # noqa
    0x00181006: ('LO', '1', "Grid ID", '', 'GridID'),  # noqa
    0x00181007: ('LO', '1', "Cassette ID", '', 'CassetteID'),  # noqa
    0x00181008: ('LO', '1', "Gantry ID", '', 'GantryID'),  # noqa
    0x00181009: ('UT', '1', "Unique Device Identifier", '', 'UniqueDeviceIdentifier'),  # noqa
    0x0018100A: ('SQ', '1', "UDI Sequence", '', 'UDISequence'),  # noqa
    0x00181010: ('LO', '1', "Secondary Capture Device ID", '', 'SecondaryCaptureDeviceID'),  # noqa
    0x00181011: ('LO', '1', "Hardcopy Creation Device ID", 'Retired', 'HardcopyCreationDeviceID'),  # noqa
    0x00181012: ('DA', '1', "Date of Secondary Capture", '', 'DateOfSecondaryCapture'),  # noqa
    0x00181014: ('TM', '1', "Time of Secondary Capture", '', 'TimeOfSecondaryCapture'),  # noqa
    0x00181016: ('LO', '1', "Secondary Capture Device Manufacturer", '', 'SecondaryCaptureDeviceManufacturer'),  # noqa
    0x00181017: ('LO', '1', "Hardcopy Device Manufacturer", 'Retired', 'HardcopyDeviceManufacturer'),  # noqa
    0x00181018: ('LO', '1', "Secondary Capture Device Manufacturer's Model Name", '', 'SecondaryCaptureDeviceManufacturerModelName'),  # noqa
    0x00181019: ('LO', '1-n', "Secondary Capture Device Software Versions", '', 'SecondaryCaptureDeviceSoftwareVersions'),  # noqa
    0x0018101A: ('LO', '1-n', "Hardcopy Device Software Version", 'Retired', 'HardcopyDeviceSoftwareVersion'),  # noqa
    0x0018101B: ('LO', '1', "Hardcopy Device Manufacturer's Model Name", 'Retired', 'HardcopyDeviceManufacturerModelName'),  # noqa
    0x00181020: ('LO', '1-n', "Software Version(s)", '', 'SoftwareVersions'),  # noqa
    0x00181022: ('SH', '1', "Video Image Format Acquired", '', 'VideoImageFormatAcquired'),  # noqa
    0x00181023: ('LO', '1', "Digital Image Format Acquired", '', 'DigitalImageFormatAcquired'),  # noqa
    0x00181030: ('LO', '1', "Protocol Name", '', 'ProtocolName'),  # noqa
    0x00181040: ('LO', '1', "Contrast/Bolus Route", '', 'ContrastBolusRoute'),  # noqa
    0x00181041: ('DS', '1', "Contrast/Bolus Volume", '', 'ContrastBolusVolume'),  # noqa
    0x00181042: ('TM', '1', "Contrast/Bolus Start Time", '', 'ContrastBolusStartTime'),  # noqa
    0x00181043: ('TM', '1', "Contrast/Bolus Stop Time", '', 'ContrastBolusStopTime'),  # noqa
    0x00181044: ('DS', '1', "Contrast/Bolus Total Dose", '', 'ContrastBolusTotalDose'),  # noqa
    0x00181045: ('IS', '1', "Syringe Counts", '', 'SyringeCounts'),  # noqa
    0x00181046: ('DS', '1-n', "Contrast Flow Rate", '', 'ContrastFlowRate'),  # noqa
    0x00181047: ('DS', '1-n', "Contrast Flow Duration", '', 'ContrastFlowDuration'),  # noqa
    0x00181048: ('CS', '1', "Contrast/Bolus Ingredient", '', 'ContrastBolusIngredient'),  # noqa
    0x00181049: ('DS', '1', "Contrast/Bolus Ingredient Concentration", '', 'ContrastBolusIngredientConcentration'),  # noqa
    0x00181050: ('DS', '1', "Spatial Resolution", '', 'SpatialResolution'),  # noqa
    0x00181060: ('DS', '1', "Trigger Time", '', 'TriggerTime'),  # noqa
    0x00181061: ('LO', '1', "Trigger Source or Type", '', 'TriggerSourceOrType'),  # noqa
    0x00181062: ('IS', '1', "Nominal Interval", '', 'NominalInterval'),  # noqa
    0x00181063: ('DS', '1', "Frame Time", '', 'FrameTime'),  # noqa
    0x00181064: ('LO', '1', "Cardiac Framing Type", '', 'CardiacFramingType'),  # noqa
    0x00181065: ('DS', '1-n', "Frame Time Vector", '', 'FrameTimeVector'),  # noqa
    0x00181066: ('DS', '1', "Frame Delay", '', 'FrameDelay'),  # noqa
    0x00181067: ('DS', '1', "Image Trigger Delay", '', 'ImageTriggerDelay'),  # noqa
    0x00181068: ('DS', '1', "Multiplex Group Time Offset", '', 'MultiplexGroupTimeOffset'),  # noqa
    0x00181069: ('DS', '1', "Trigger Time Offset", '', 'TriggerTimeOffset'),  # noqa
    0x0018106A: ('CS', '1', "Synchronization Trigger", '', 'SynchronizationTrigger'),  # noqa
    0x0018106C: ('US', '2', "Synchronization Channel", '', 'SynchronizationChannel'),  # noqa
    0x0018106E: ('UL', '1', "Trigger Sample Position", '', 'TriggerSamplePosition'),  # noqa
    0x00181070: ('LO', '1', "Radiopharmaceutical Route", '', 'RadiopharmaceuticalRoute'),  # noqa
    0x00181071: ('DS', '1', "Radiopharmaceutical Volume", '', 'RadiopharmaceuticalVolume'),  # noqa
    0x00181072: ('TM', '1', "Radiopharmaceutical Start Time", '', 'RadiopharmaceuticalStartTime'),  # noqa
    0x00181073: ('TM', '1', "Radiopharmaceutical Stop Time", '', 'RadiopharmaceuticalStopTime'),  # noqa
    0x00181074: ('DS', '1', "Radionuclide Total Dose", '', 'RadionuclideTotalDose'),  # noqa
    0x00181075: ('DS', '1', "Radionuclide Half Life", '', 'RadionuclideHalfLife'),  # noqa
    0x00181076: ('DS', '1', "Radionuclide Positron Fraction", '', 'RadionuclidePositronFraction'),  # noqa
    0x00181077: ('DS', '1', "Radiopharmaceutical Specific Activity", '', 'RadiopharmaceuticalSpecificActivity'),  # noqa
    0x00181078: ('DT', '1', "Radiopharmaceutical Start DateTime", '', 'RadiopharmaceuticalStartDateTime'),  # noqa
    0x00181079: ('DT', '1', "Radiopharmaceutical Stop DateTime", '', 'RadiopharmaceuticalStopDateTime'),  # noqa
    0x00181080: ('CS', '1', "Beat Rejection Flag", '', 'BeatRejectionFlag'),  # noqa
    0x00181081: ('IS', '1', "Low R-R Value", '', 'LowRRValue'),  # noqa
    0x00181082: ('IS', '1', "High R-R Value", '', 'HighRRValue'),  # noqa
    0x00181083: ('IS', '1', "Intervals Acquired", '', 'IntervalsAcquired'),  # noqa
    0x00181084: ('IS', '1', "Intervals Rejected", '', 'IntervalsRejected'),  # noqa
    0x00181085: ('LO', '1', "PVC Rejection", '', 'PVCRejection'),  # noqa
    0x00181086: ('IS', '1', "Skip Beats", '', 'SkipBeats'),  # noqa
    0x00181088: ('IS', '1', "Heart Rate", '', 'HeartRate'),  # noqa
    0x00181090: ('IS', '1', "Cardiac Number of Images", '', 'CardiacNumberOfImages'),  # noqa
    0x00181094: ('IS', '1', "Trigger Window", '', 'TriggerWindow'),  # noqa
    0x00181100: ('DS', '1', "Reconstruction Diameter", '', 'ReconstructionDiameter'),  # noqa
    0x00181110: ('DS', '1', "Distance Source to Detector", '', 'DistanceSourceToDetector'),  # noqa
    0x00181111: ('DS', '1', "Distance Source to Patient", '', 'DistanceSourceToPatient'),  # noqa
    0x00181114: ('DS', '1', "Estimated Radiographic Magnification Factor", '', 'EstimatedRadiographicMagnificationFactor'),  # noqa
    0x00181120: ('DS', '1', "Gantry/Detector Tilt", '', 'GantryDetectorTilt'),  # noqa
    0x00181121: ('DS', '1', "Gantry/Detector Slew", '', 'GantryDetectorSlew'),  # noqa
    0x00181130: ('DS', '1', "Table Height", '', 'TableHeight'),  # noqa
    0x00181131: ('DS', '1', "Table Traverse", '', 'TableTraverse'),  # noqa
    0x00181134: ('CS', '1', "Table Motion", '', 'TableMotion'),  # noqa
    0x00181135: ('DS', '1-n', "Table Vertical Increment", '', 'TableVerticalIncrement'),  # noqa
    0x00181136: ('DS', '1-n', "Table Lateral Increment", '', 'TableLateralIncrement'),  # noqa
    0x00181137: ('DS', '1-n', "Table Longitudinal Increment", '', 'TableLongitudinalIncrement'),  # noqa
    0x00181138: ('DS', '1', "Table Angle", '', 'TableAngle'),  # noqa
    0x0018113A: ('CS', '1', "Table Type", '', 'TableType'),  # noqa
    0x00181140: ('CS', '1', "Rotation Direction", '', 'RotationDirection'),  # noqa
    0x00181141: ('DS', '1', "Angular Position", 'Retired', 'AngularPosition'),  # noqa
    0x00181142: ('DS', '1-n', "Radial Position", '', 'RadialPosition'),  # noqa
    0x00181143: ('DS', '1', "Scan Arc", '', 'ScanArc'),  # noqa
    0x00181144: ('DS', '1', "Angular Step", '', 'AngularStep'),  # noqa
    0x00181145: ('DS', '1', "Center of Rotation Offset", '', 'CenterOfRotationOffset'),  # noqa
    0x00181146: ('DS', '1-n', "Rotation Offset", 'Retired', 'RotationOffset'),  # noqa
    0x00181147: ('CS', '1', "Field of View Shape", '', 'FieldOfViewShape'),  # noqa
    0x00181149: ('IS', '1-2', "Field of View Dimension(s)", '', 'FieldOfViewDimensions'),  # noqa
    0x00181150: ('IS', '1', "Exposure Time", '', 'ExposureTime'),  # noqa
    0x00181151: ('IS', '1', "X-Ray Tube Current", '', 'XRayTubeCurrent'),  # noqa
    0x00181152: ('IS', '1', "Exposure", '', 'Exposure'),  # noqa
    0x00181153: ('IS', '1', "Exposure in uAs", '', 'ExposureInuAs'),  # noqa
    0x00181154: ('DS', '1', "Average Pulse Width", '', 'AveragePulseWidth'),  # noqa
    0x00181155: ('CS', '1', "Radiation Setting", '', 'RadiationSetting'),  # noqa
    0x00181156: ('CS', '1', "Rectification Type", '', 'RectificationType'),  # noqa
    0x0018115A: ('CS', '1', "Radiation Mode", '', 'RadiationMode'),  # noqa
    0x0018115E: ('DS', '1', "Image and Fluoroscopy Area Dose Product", '', 'ImageAndFluoroscopyAreaDoseProduct'),  # noqa
    0x00181160: ('SH', '1', "Filter Type", '', 'FilterType'),  # noqa
    0x00181161: ('LO', '1-n', "Type of Filters", '', 'TypeOfFilters'),  # noqa
    0x00181162: ('DS', '1', "Intensifier Size", '', 'IntensifierSize'),  # noqa
    0x00181164: ('DS', '2', "Imager Pixel Spacing", '', 'ImagerPixelSpacing'),  # noqa
    0x00181166: ('CS', '1-n', "Grid", '', 'Grid'),  # noqa
    0x00181170: ('IS', '1', "Generator Power", '', 'GeneratorPower'),  # noqa
    0x00181180: ('SH', '1', "Collimator/grid Name", '', 'CollimatorGridName'),  # noqa
    0x00181181: ('CS', '1', "Collimator Type", '', 'CollimatorType'),  # noqa
    0x00181182: ('IS', '1-2', "Focal Distance", '', 'FocalDistance'),  # noqa
    0x00181183: ('DS', '1-2', "X Focus Center", '', 'XFocusCenter'),  # noqa
    0x00181184: ('DS', '1-2', "Y Focus Center", '', 'YFocusCenter'),  # noqa
    0x00181190: ('DS', '1-n', "Focal Spot(s)", '', 'FocalSpots'),  # noqa
    0x00181191: ('CS', '1', "Anode Target Material", '', 'AnodeTargetMaterial'),  # noqa
    0x001811A0: ('DS', '1', "Body Part Thickness", '', 'BodyPartThickness'),  # noqa
    0x001811A2: ('DS', '1', "Compression Force", '', 'CompressionForce'),  # noqa
    0x001811A3: ('DS', '1', "Compression Pressure", '', 'CompressionPressure'),  # noqa
    0x001811A4: ('LO', '1', "Paddle Description", '', 'PaddleDescription'),  # noqa
    0x001811A5: ('DS', '1', "Compression Contact Area", '', 'CompressionContactArea'),  # noqa
    0x00181200: ('DA', '1-n', "Date of Last Calibration", '', 'DateOfLastCalibration'),  # noqa
    0x00181201: ('TM', '1-n', "Time of Last Calibration", '', 'TimeOfLastCalibration'),  # noqa
    0x00181202: ('DT', '1', "DateTime of Last Calibration", '', 'DateTimeOfLastCalibration'),  # noqa
    0x00181210: ('SH', '1-n', "Convolution Kernel", '', 'ConvolutionKernel'),  # noqa
    0x00181240: ('IS', '1-n', "Upper/Lower Pixel Values", 'Retired', 'UpperLowerPixelValues'),  # noqa
    0x00181242: ('IS', '1', "Actual Frame Duration", '', 'ActualFrameDuration'),  # noqa
    0x00181243: ('IS', '1', "Count Rate", '', 'CountRate'),  # noqa
    0x00181244: ('US', '1', "Preferred Playback Sequencing", '', 'PreferredPlaybackSequencing'),  # noqa
    0x00181250: ('SH', '1', "Receive Coil Name", '', 'ReceiveCoilName'),  # noqa
    0x00181251: ('SH', '1', "Transmit Coil Name", '', 'TransmitCoilName'),  # noqa
    0x00181260: ('SH', '1', "Plate Type", '', 'PlateType'),  # noqa
    0x00181261: ('LO', '1', "Phosphor Type", '', 'PhosphorType'),  # noqa
    0x00181271: ('FD', '1', "Water Equivalent Diameter", '', 'WaterEquivalentDiameter'),  # noqa
    0x00181272: ('SQ', '1', "Water Equivalent Diameter Calculation Method Code Sequence", '', 'WaterEquivalentDiameterCalculationMethodCodeSequence'),  # noqa
    0x00181300: ('DS', '1', "Scan Velocity", '', 'ScanVelocity'),  # noqa
    0x00181301: ('CS', '1-n', "Whole Body Technique", '', 'WholeBodyTechnique'),  # noqa
    0x00181302: ('IS', '1', "Scan Length", '', 'ScanLength'),  # noqa
    0x00181310: ('US', '4', "Acquisition Matrix", '', 'AcquisitionMatrix'),  # noqa
    0x00181312: ('CS', '1', "In-plane Phase Encoding Direction", '', 'InPlanePhaseEncodingDirection'),  # noqa
    0x00181314: ('DS', '1', "Flip Angle", '', 'FlipAngle'),  # noqa
    0x00181315: ('CS', '1', "Variable Flip Angle Flag", '', 'VariableFlipAngleFlag'),  # noqa
    0x00181316: ('DS', '1', "SAR", '', 'SAR'),  # noqa
    0x00181318: ('DS', '1', "dB/dt", '', 'dBdt'),  # noqa
    0x00181320: ('FL', '1', "B1rms", '', 'B1rms'),  # noqa
    0x00181400: ('LO', '1', "Acquisition Device Processing Description", '', 'AcquisitionDeviceProcessingDescription'),  # noqa
    0x00181401: ('LO', '1', "Acquisition Device Processing Code", '', 'AcquisitionDeviceProcessingCode'),  # noqa
    0x00181402: ('CS', '1', "Cassette Orientation", '', 'CassetteOrientation'),  # noqa
    0x00181403: ('CS', '1', "Cassette Size", '', 'CassetteSize'),  # noqa
    0x00181404: ('US', '1', "Exposures on Plate", '', 'ExposuresOnPlate'),  # noqa
    0x00181405: ('IS', '1', "Relative X-Ray Exposure", '', 'RelativeXRayExposure'),  # noqa
    0x00181411: ('DS', '1', "Exposure Index", '', 'ExposureIndex'),  # noqa
    0x00181412: ('DS', '1', "Target Exposure Index", '', 'TargetExposureIndex'),  # noqa
    0x00181413: ('DS', '1', "Deviation Index", '', 'DeviationIndex'),  # noqa
    0x00181450: ('DS', '1', "Column Angulation", '', 'ColumnAngulation'),  # noqa
    0x00181460: ('DS', '1', "Tomo Layer Height", '', 'TomoLayerHeight'),  # noqa
    0x00181470: ('DS', '1', "Tomo Angle", '', 'TomoAngle'),  # noqa
    0x00181480: ('DS', '1', "Tomo Time", '', 'TomoTime'),  # noqa
    0x00181490: ('CS', '1', "Tomo Type", '', 'TomoType'),  # noqa
    0x00181491: ('CS', '1', "Tomo Class", '', 'TomoClass'),  # noqa
    0x00181495: ('IS', '1', "Number of Tomosynthesis Source Images", '', 'NumberOfTomosynthesisSourceImages'),  # noqa
    0x00181500: ('CS', '1', "Positioner Motion", '', 'PositionerMotion'),  # noqa
    0x00181508: ('CS', '1', "Positioner Type", '', 'PositionerType'),  # noqa
    0x00181510: ('DS', '1', "Positioner Primary Angle", '', 'PositionerPrimaryAngle'),  # noqa
    0x00181511: ('DS', '1', "Positioner Secondary Angle", '', 'PositionerSecondaryAngle'),  # noqa
    0x00181520: ('DS', '1-n', "Positioner Primary Angle Increment", '', 'PositionerPrimaryAngleIncrement'),  # noqa
    0x00181521: ('DS', '1-n', "Positioner Secondary Angle Increment", '', 'PositionerSecondaryAngleIncrement'),  # noqa
    0x00181530: ('DS', '1', "Detector Primary Angle", '', 'DetectorPrimaryAngle'),  # noqa
    0x00181531: ('DS', '1', "Detector Secondary Angle", '', 'DetectorSecondaryAngle'),  # noqa
    0x00181600: ('CS', '1-3', "Shutter Shape", '', 'ShutterShape'),  # noqa
    0x00181602: ('IS', '1', "Shutter Left Vertical Edge", '', 'ShutterLeftVerticalEdge'),  # noqa
    0x00181604: ('IS', '1', "Shutter Right Vertical Edge", '', 'ShutterRightVerticalEdge'),  # noqa
    0x00181606: ('IS', '1', "Shutter Upper Horizontal Edge", '', 'ShutterUpperHorizontalEdge'),  # noqa
    0x00181608: ('IS', '1', "Shutter Lower Horizontal Edge", '', 'ShutterLowerHorizontalEdge'),  # noqa
    0x00181610: ('IS', '2', "Center of Circular Shutter", '', 'CenterOfCircularShutter'),  # noqa
    0x00181612: ('IS', '1', "Radius of Circular Shutter", '', 'RadiusOfCircularShutter'),  # noqa
    0x00181620: ('IS', '2-2n', "Vertices of the Polygonal Shutter", '', 'VerticesOfThePolygonalShutter'),  # noqa
    0x00181622: ('US', '1', "Shutter Presentation Value", '', 'ShutterPresentationValue'),  # noqa
    0x00181623: ('US', '1', "Shutter Overlay Group", '', 'ShutterOverlayGroup'),  # noqa
    0x00181624: ('US', '3', "Shutter Presentation Color CIELab Value", '', 'ShutterPresentationColorCIELabValue'),  # noqa
    0x00181700: ('CS', '1-3', "Collimator Shape", '', 'CollimatorShape'),  # noqa
    0x00181702: ('IS', '1', "Collimator Left Vertical Edge", '', 'CollimatorLeftVerticalEdge'),  # noqa
    0x00181704: ('IS', '1', "Collimator Right Vertical Edge", '', 'CollimatorRightVerticalEdge'),  # noqa
    0x00181706: ('IS', '1', "Collimator Upper Horizontal Edge", '', 'CollimatorUpperHorizontalEdge'),  # noqa
    0x00181708: ('IS', '1', "Collimator Lower Horizontal Edge", '', 'CollimatorLowerHorizontalEdge'),  # noqa
    0x00181710: ('IS', '2', "Center of Circular Collimator", '', 'CenterOfCircularCollimator'),  # noqa
    0x00181712: ('IS', '1', "Radius of Circular Collimator", '', 'RadiusOfCircularCollimator'),  # noqa
    0x00181720: ('IS', '2-2n', "Vertices of the Polygonal Collimator", '', 'VerticesOfThePolygonalCollimator'),  # noqa
    0x00181800: ('CS', '1', "Acquisition Time Synchronized", '', 'AcquisitionTimeSynchronized'),  # noqa
    0x00181801: ('SH', '1', "Time Source", '', 'TimeSource'),  # noqa
    0x00181802: ('CS', '1', "Time Distribution Protocol", '', 'TimeDistributionProtocol'),  # noqa
    0x00181803: ('LO', '1', "NTP Source Address", '', 'NTPSourceAddress'),  # noqa
    0x00182001: ('IS', '1-n', "Page Number Vector", '', 'PageNumberVector'),  # noqa
    0x00182002: ('SH', '1-n', "Frame Label Vector", '', 'FrameLabelVector'),  # noqa
    0x00182003: ('DS', '1-n', "Frame Primary Angle Vector", '', 'FramePrimaryAngleVector'),  # noqa
    0x00182004: ('DS', '1-n', "Frame Secondary Angle Vector", '', 'FrameSecondaryAngleVector'),  # noqa
    0x00182005: ('DS', '1-n', "Slice Location Vector", '', 'SliceLocationVector'),  # noqa
    0x00182006: ('SH', '1-n', "Display Window Label Vector", '', 'DisplayWindowLabelVector'),  # noqa
    0x00182010: ('DS', '2', "Nominal Scanned Pixel Spacing", '', 'NominalScannedPixelSpacing'),  # noqa
    0x00182020: ('CS', '1', "Digitizing Device Transport Direction", '', 'DigitizingDeviceTransportDirection'),  # noqa
    0x00182030: ('DS', '1', "Rotation of Scanned Film", '', 'RotationOfScannedFilm'),  # noqa
    0x00182041: ('SQ', '1', "Biopsy Target Sequence", '', 'BiopsyTargetSequence'),  # noqa
    0x00182042: ('UI', '1', "Target UID", '', 'TargetUID'),  # noqa
    0x00182043: ('FL', '2', "Localizing Cursor Position", '', 'LocalizingCursorPosition'),  # noqa
    0x00182044: ('FL', '3', "Calculated Target Position", '', 'CalculatedTargetPosition'),  # noqa
    0x00182045: ('SH', '1', "Target Label", '', 'TargetLabel'),  # noqa
    0x00182046: ('FL', '1', "Displayed Z Value", '', 'DisplayedZValue'),  # noqa
    0x00183100: ('CS', '1', "IVUS Acquisition", '', 'IVUSAcquisition'),  # noqa
    0x00183101: ('DS', '1', "IVUS Pullback Rate", '', 'IVUSPullbackRate'),  # noqa
    0x00183102: ('DS', '1', "IVUS Gated Rate", '', 'IVUSGatedRate'),  # noqa
    0x00183103: ('IS', '1', "IVUS Pullback Start Frame Number", '', 'IVUSPullbackStartFrameNumber'),  # noqa
    0x00183104: ('IS', '1', "IVUS Pullback Stop Frame Number", '', 'IVUSPullbackStopFrameNumber'),  # noqa
    0x00183105: ('IS', '1-n', "Lesion Number", '', 'LesionNumber'),  # noqa
    0x00184000: ('LT', '1', "Acquisition Comments", 'Retired', 'AcquisitionComments'),  # noqa
    0x00185000: ('SH', '1-n', "Output Power", '', 'OutputPower'),  # noqa
    0x00185010: ('LO', '1-n', "Transducer Data", '', 'TransducerData'),  # noqa
    0x00185012: ('DS', '1', "Focus Depth", '', 'FocusDepth'),  # noqa
    0x00185020: ('LO', '1', "Processing Function", '', 'ProcessingFunction'),  # noqa
    0x00185021: ('LO', '1', "Postprocessing Function", 'Retired', 'PostprocessingFunction'),  # noqa
    0x00185022: ('DS', '1', "Mechanical Index", '', 'MechanicalIndex'),  # noqa
    0x00185024: ('DS', '1', "Bone Thermal Index", '', 'BoneThermalIndex'),  # noqa
    0x00185026: ('DS', '1', "Cranial Thermal Index", '', 'CranialThermalIndex'),  # noqa
    0x00185027: ('DS', '1', "Soft Tissue Thermal Index", '', 'SoftTissueThermalIndex'),  # noqa
    0x00185028: ('DS', '1', "Soft Tissue-focus Thermal Index", '', 'SoftTissueFocusThermalIndex'),  # noqa
    0x00185029: ('DS', '1', "Soft Tissue-surface Thermal Index", '', 'SoftTissueSurfaceThermalIndex'),  # noqa
    0x00185030: ('DS', '1', "Dynamic Range", 'Retired', 'DynamicRange'),  # noqa
    0x00185040: ('DS', '1', "Total Gain", 'Retired', 'TotalGain'),  # noqa
    0x00185050: ('IS', '1', "Depth of Scan Field", '', 'DepthOfScanField'),  # noqa
    0x00185100: ('CS', '1', "Patient Position", '', 'PatientPosition'),  # noqa
    0x00185101: ('CS', '1', "View Position", '', 'ViewPosition'),  # noqa
    0x00185104: ('SQ', '1', "Projection Eponymous Name Code Sequence", '', 'ProjectionEponymousNameCodeSequence'),  # noqa
    0x00185210: ('DS', '6', "Image Transformation Matrix", 'Retired', 'ImageTransformationMatrix'),  # noqa
    0x00185212: ('DS', '3', "Image Translation Vector", 'Retired', 'ImageTranslationVector'),  # noqa
    0x00186000: ('DS', '1', "Sensitivity", '', 'Sensitivity'),  # noqa
    0x00186011: ('SQ', '1', "Sequence of Ultrasound Regions", '', 'SequenceOfUltrasoundRegions'),  # noqa
    0x00186012: ('US', '1', "Region Spatial Format", '', 'RegionSpatialFormat'),  # noqa
    0x00186014: ('US', '1', "Region Data Type", '', 'RegionDataType'),  # noqa
    0x00186016: ('UL', '1', "Region Flags", '', 'RegionFlags'),  # noqa
    0x00186018: ('UL', '1', "Region Location Min X0", '', 'RegionLocationMinX0'),  # noqa
    0x0018601A: ('UL', '1', "Region Location Min Y0", '', 'RegionLocationMinY0'),  # noqa
    0x0018601C: ('UL', '1', "Region Location Max X1", '', 'RegionLocationMaxX1'),  # noqa
    0x0018601E: ('UL', '1', "Region Location Max Y1", '', 'RegionLocationMaxY1'),  # noqa
    0x00186020: ('SL', '1', "Reference Pixel X0", '', 'ReferencePixelX0'),  # noqa
    0x00186022: ('SL', '1', "Reference Pixel Y0", '', 'ReferencePixelY0'),  # noqa
    0x00186024: ('US', '1', "Physical Units X Direction", '', 'PhysicalUnitsXDirection'),  # noqa
    0x00186026: ('US', '1', "Physical Units Y Direction", '', 'PhysicalUnitsYDirection'),  # noqa
    0x00186028: ('FD', '1', "Reference Pixel Physical Value X", '', 'ReferencePixelPhysicalValueX'),  # noqa
    0x0018602A: ('FD', '1', "Reference Pixel Physical Value Y", '', 'ReferencePixelPhysicalValueY'),  # noqa
    0x0018602C: ('FD', '1', "Physical Delta X", '', 'PhysicalDeltaX'),  # noqa
    0x0018602E: ('FD', '1', "Physical Delta Y", '', 'PhysicalDeltaY'),  # noqa
    0x00186030: ('UL', '1', "Transducer Frequency", '', 'TransducerFrequency'),  # noqa
    0x00186031: ('CS', '1', "Transducer Type", '', 'TransducerType'),  # noqa
    0x00186032: ('UL', '1', "Pulse Repetition Frequency", '', 'PulseRepetitionFrequency'),  # noqa
    0x00186034: ('FD', '1', "Doppler Correction Angle", '', 'DopplerCorrectionAngle'),  # noqa
    0x00186036: ('FD', '1', "Steering Angle", '', 'SteeringAngle'),  # noqa
    0x00186038: ('UL', '1', "Doppler Sample Volume X Position (Retired)", 'Retired', 'DopplerSampleVolumeXPositionRetired'),  # noqa
    0x00186039: ('SL', '1', "Doppler Sample Volume X Position", '', 'DopplerSampleVolumeXPosition'),  # noqa
    0x0018603A: ('UL', '1', "Doppler Sample Volume Y Position (Retired)", 'Retired', 'DopplerSampleVolumeYPositionRetired'),  # noqa
    0x0018603B: ('SL', '1', "Doppler Sample Volume Y Position", '', 'DopplerSampleVolumeYPosition'),  # noqa
    0x0018603C: ('UL', '1', "TM-Line Position X0 (Retired)", 'Retired', 'TMLinePositionX0Retired'),  # noqa
    0x0018603D: ('SL', '1', "TM-Line Position X0", '', 'TMLinePositionX0'),  # noqa
    0x0018603E: ('UL', '1', "TM-Line Position Y0 (Retired)", 'Retired', 'TMLinePositionY0Retired'),  # noqa
    0x0018603F: ('SL', '1', "TM-Line Position Y0", '', 'TMLinePositionY0'),  # noqa
    0x00186040: ('UL', '1', "TM-Line Position X1 (Retired)", 'Retired', 'TMLinePositionX1Retired'),  # noqa
    0x00186041: ('SL', '1', "TM-Line Position X1", '', 'TMLinePositionX1'),  # noqa
    0x00186042: ('UL', '1', "TM-Line Position Y1 (Retired)", 'Retired', 'TMLinePositionY1Retired'),  # noqa
    0x00186043: ('SL', '1', "TM-Line Position Y1", '', 'TMLinePositionY1'),  # noqa
    0x00186044: ('US', '1', "Pixel Component Organization", '', 'PixelComponentOrganization'),  # noqa
    0x00186046: ('UL', '1', "Pixel Component Mask", '', 'PixelComponentMask'),  # noqa
    0x00186048: ('UL', '1', "Pixel Component Range Start", '', 'PixelComponentRangeStart'),  # noqa
    0x0018604A: ('UL', '1', "Pixel Component Range Stop", '', 'PixelComponentRangeStop'),  # noqa
    0x0018604C: ('US', '1', "Pixel Component Physical Units", '', 'PixelComponentPhysicalUnits'),  # noqa
    0x0018604E: ('US', '1', "Pixel Component Data Type", '', 'PixelComponentDataType'),  # noqa
    0x00186050: ('UL', '1', "Number of Table Break Points", '', 'NumberOfTableBreakPoints'),  # noqa
    0x00186052: ('UL', '1-n', "Table of X Break Points", '', 'TableOfXBreakPoints'),  # noqa
    0x00186054: ('FD', '1-n', "Table of Y Break Points", '', 'TableOfYBreakPoints'),  # noqa
    0x00186056: ('UL', '1', "Number of Table Entries", '', 'NumberOfTableEntries'),  # noqa
    0x00186058: ('UL', '1-n', "Table of Pixel Values", '', 'TableOfPixelValues'),  # noqa
    0x0018605A: ('FL', '1-n', "Table of Parameter Values", '', 'TableOfParameterValues'),  # noqa
    0x00186060: ('FL', '1-n', "R Wave Time Vector", '', 'RWaveTimeVector'),  # noqa
    0x00187000: ('CS', '1', "Detector Conditions Nominal Flag", '', 'DetectorConditionsNominalFlag'),  # noqa
    0x00187001: ('DS', '1', "Detector Temperature", '', 'DetectorTemperature'),  # noqa
    0x00187004: ('CS', '1', "Detector Type", '', 'DetectorType'),  # noqa
    0x00187005: ('CS', '1', "Detector Configuration", '', 'DetectorConfiguration'),  # noqa
    0x00187006: ('LT', '1', "Detector Description", '', 'DetectorDescription'),  # noqa
    0x00187008: ('LT', '1', "Detector Mode", '', 'DetectorMode'),  # noqa
    0x0018700A: ('SH', '1', "Detector ID", '', 'DetectorID'),  # noqa
    0x0018700C: ('DA', '1', "Date of Last Detector Calibration", '', 'DateOfLastDetectorCalibration'),  # noqa
    0x0018700E: ('TM', '1', "Time of Last Detector Calibration", '', 'TimeOfLastDetectorCalibration'),  # noqa
    0x00187010: ('IS', '1', "Exposures on Detector Since Last Calibration", '', 'ExposuresOnDetectorSinceLastCalibration'),  # noqa
    0x00187011: ('IS', '1', "Exposures on Detector Since Manufactured", '', 'ExposuresOnDetectorSinceManufactured'),  # noqa
    0x00187012: ('DS', '1', "Detector Time Since Last Exposure", '', 'DetectorTimeSinceLastExposure'),  # noqa
    0x00187014: ('DS', '1', "Detector Active Time", '', 'DetectorActiveTime'),  # noqa
    0x00187016: ('DS', '1', "Detector Activation Offset From Exposure", '', 'DetectorActivationOffsetFromExposure'),  # noqa
    0x0018701A: ('DS', '2', "Detector Binning", '', 'DetectorBinning'),  # noqa
    0x00187020: ('DS', '2', "Detector Element Physical Size", '', 'DetectorElementPhysicalSize'),  # noqa
    0x00187022: ('DS', '2', "Detector Element Spacing", '', 'DetectorElementSpacing'),  # noqa
    0x00187024: ('CS', '1', "Detector Active Shape", '', 'DetectorActiveShape'),  # noqa
    0x00187026: ('DS', '1-2', "Detector Active Dimension(s)", '', 'DetectorActiveDimensions'),  # noqa
    0x00187028: ('DS', '2', "Detector Active Origin", '', 'DetectorActiveOrigin'),  # noqa
    0x0018702A: ('LO', '1', "Detector Manufacturer Name", '', 'DetectorManufacturerName'),  # noqa
    0x0018702B: ('LO', '1', "Detector Manufacturer's Model Name", '', 'DetectorManufacturerModelName'),  # noqa
    0x00187030: ('DS', '2', "Field of View Origin", '', 'FieldOfViewOrigin'),  # noqa
    0x00187032: ('DS', '1', "Field of View Rotation", '', 'FieldOfViewRotation'),  # noqa
    0x00187034: ('CS', '1', "Field of View Horizontal Flip", '', 'FieldOfViewHorizontalFlip'),  # noqa
    0x00187036: ('FL', '2', "Pixel Data Area Origin Relative To FOV", '', 'PixelDataAreaOriginRelativeToFOV'),  # noqa
    0x00187038: ('FL', '1', "Pixel Data Area Rotation Angle Relative To FOV", '', 'PixelDataAreaRotationAngleRelativeToFOV'),  # noqa
    0x00187040: ('LT', '1', "Grid Absorbing Material", '', 'GridAbsorbingMaterial'),  # noqa
    0x00187041: ('LT', '1', "Grid Spacing Material", '', 'GridSpacingMaterial'),  # noqa
    0x00187042: ('DS', '1', "Grid Thickness", '', 'GridThickness'),  # noqa
    0x00187044: ('DS', '1', "Grid Pitch", '', 'GridPitch'),  # noqa
    0x00187046: ('IS', '2', "Grid Aspect Ratio", '', 'GridAspectRatio'),  # noqa
    0x00187048: ('DS', '1', "Grid Period", '', 'GridPeriod'),  # noqa
    0x0018704C: ('DS', '1', "Grid Focal Distance", '', 'GridFocalDistance'),  # noqa
    0x00187050: ('CS', '1-n', "Filter Material", '', 'FilterMaterial'),  # noqa
    0x00187052: ('DS', '1-n', "Filter Thickness Minimum", '', 'FilterThicknessMinimum'),  # noqa
    0x00187054: ('DS', '1-n', "Filter Thickness Maximum", '', 'FilterThicknessMaximum'),  # noqa
    0x00187056: ('FL', '1-n', "Filter Beam Path Length Minimum", '', 'FilterBeamPathLengthMinimum'),  # noqa
    0x00187058: ('FL', '1-n', "Filter Beam Path Length Maximum", '', 'FilterBeamPathLengthMaximum'),  # noqa
    0x00187060: ('CS', '1', "Exposure Control Mode", '', 'ExposureControlMode'),  # noqa
    0x00187062: ('LT', '1', "Exposure Control Mode Description", '', 'ExposureControlModeDescription'),  # noqa
    0x00187064: ('CS', '1', "Exposure Status", '', 'ExposureStatus'),  # noqa
    0x00187065: ('DS', '1', "Phototimer Setting", '', 'PhototimerSetting'),  # noqa
    0x00188150: ('DS', '1', "Exposure Time in uS", '', 'ExposureTimeInuS'),  # noqa
    0x00188151: ('DS', '1', "X-Ray Tube Current in uA", '', 'XRayTubeCurrentInuA'),  # noqa
    0x00189004: ('CS', '1', "Content Qualification", '', 'ContentQualification'),  # noqa
    0x00189005: ('SH', '1', "Pulse Sequence Name", '', 'PulseSequenceName'),  # noqa
    0x00189006: ('SQ', '1', "MR Imaging Modifier Sequence", '', 'MRImagingModifierSequence'),  # noqa
    0x00189008: ('CS', '1', "Echo Pulse Sequence", '', 'EchoPulseSequence'),  # noqa
    0x00189009: ('CS', '1', "Inversion Recovery", '', 'InversionRecovery'),  # noqa
    0x00189010: ('CS', '1', "Flow Compensation", '', 'FlowCompensation'),  # noqa
    0x00189011: ('CS', '1', "Multiple Spin Echo", '', 'MultipleSpinEcho'),  # noqa
    0x00189012: ('CS', '1', "Multi-planar Excitation", '', 'MultiPlanarExcitation'),  # noqa
    0x00189014: ('CS', '1', "Phase Contrast", '', 'PhaseContrast'),  # noqa
    0x00189015: ('CS', '1', "Time of Flight Contrast", '', 'TimeOfFlightContrast'),  # noqa
    0x00189016: ('CS', '1', "Spoiling", '', 'Spoiling'),  # noqa
    0x00189017: ('CS', '1', "Steady State Pulse Sequence", '', 'SteadyStatePulseSequence'),  # noqa
    0x00189018: ('CS', '1', "Echo Planar Pulse Sequence", '', 'EchoPlanarPulseSequence'),  # noqa
    0x00189019: ('FD', '1', "Tag Angle First Axis", '', 'TagAngleFirstAxis'),  # noqa
    0x00189020: ('CS', '1', "Magnetization Transfer", '', 'MagnetizationTransfer'),  # noqa
    0x00189021: ('CS', '1', "T2 Preparation", '', 'T2Preparation'),  # noqa
    0x00189022: ('CS', '1', "Blood Signal Nulling", '', 'BloodSignalNulling'),  # noqa
    0x00189024: ('CS', '1', "Saturation Recovery", '', 'SaturationRecovery'),  # noqa
    0x00189025: ('CS', '1', "Spectrally Selected Suppression", '', 'SpectrallySelectedSuppression'),  # noqa
    0x00189026: ('CS', '1', "Spectrally Selected Excitation", '', 'SpectrallySelectedExcitation'),  # noqa
    0x00189027: ('CS', '1', "Spatial Pre-saturation", '', 'SpatialPresaturation'),  # noqa
    0x00189028: ('CS', '1', "Tagging", '', 'Tagging'),  # noqa
    0x00189029: ('CS', '1', "Oversampling Phase", '', 'OversamplingPhase'),  # noqa
    0x00189030: ('FD', '1', "Tag Spacing First Dimension", '', 'TagSpacingFirstDimension'),  # noqa
    0x00189032: ('CS', '1', "Geometry of k-Space Traversal", '', 'GeometryOfKSpaceTraversal'),  # noqa
    0x00189033: ('CS', '1', "Segmented k-Space Traversal", '', 'SegmentedKSpaceTraversal'),  # noqa
    0x00189034: ('CS', '1', "Rectilinear Phase Encode Reordering", '', 'RectilinearPhaseEncodeReordering'),  # noqa
    0x00189035: ('FD', '1', "Tag Thickness", '', 'TagThickness'),  # noqa
    0x00189036: ('CS', '1', "Partial Fourier Direction", '', 'PartialFourierDirection'),  # noqa
    0x00189037: ('CS', '1', "Cardiac Synchronization Technique", '', 'CardiacSynchronizationTechnique'),  # noqa
    0x00189041: ('LO', '1', "Receive Coil Manufacturer Name", '', 'ReceiveCoilManufacturerName'),  # noqa
    0x00189042: ('SQ', '1', "MR Receive Coil Sequence", '', 'MRReceiveCoilSequence'),  # noqa
    0x00189043: ('CS', '1', "Receive Coil Type", '', 'ReceiveCoilType'),  # noqa
    0x00189044: ('CS', '1', "Quadrature Receive Coil", '', 'QuadratureReceiveCoil'),  # noqa
    0x00189045: ('SQ', '1', "Multi-Coil Definition Sequence", '', 'MultiCoilDefinitionSequence'),  # noqa
    0x00189046: ('LO', '1', "Multi-Coil Configuration", '', 'MultiCoilConfiguration'),  # noqa
    0x00189047: ('SH', '1', "Multi-Coil Element Name", '', 'MultiCoilElementName'),  # noqa
    0x00189048: ('CS', '1', "Multi-Coil Element Used", '', 'MultiCoilElementUsed'),  # noqa
    0x00189049: ('SQ', '1', "MR Transmit Coil Sequence", '', 'MRTransmitCoilSequence'),  # noqa
    0x00189050: ('LO', '1', "Transmit Coil Manufacturer Name", '', 'TransmitCoilManufacturerName'),  # noqa
    0x00189051: ('CS', '1', "Transmit Coil Type", '', 'TransmitCoilType'),  # noqa
    0x00189052: ('FD', '1-2', "Spectral Width", '', 'SpectralWidth'),  # noqa
    0x00189053: ('FD', '1-2', "Chemical Shift Reference", '', 'ChemicalShiftReference'),  # noqa
    0x00189054: ('CS', '1', "Volume Localization Technique", '', 'VolumeLocalizationTechnique'),  # noqa
    0x00189058: ('US', '1', "MR Acquisition Frequency Encoding Steps", '', 'MRAcquisitionFrequencyEncodingSteps'),  # noqa
    0x00189059: ('CS', '1', "De-coupling", '', 'Decoupling'),  # noqa
    0x00189060: ('CS', '1-2', "De-coupled Nucleus", '', 'DecoupledNucleus'),  # noqa
    0x00189061: ('FD', '1-2', "De-coupling Frequency", '', 'DecouplingFrequency'),  # noqa
    0x00189062: ('CS', '1', "De-coupling Method", '', 'DecouplingMethod'),  # noqa
    0x00189063: ('FD', '1-2', "De-coupling Chemical Shift Reference", '', 'DecouplingChemicalShiftReference'),  # noqa
    0x00189064: ('CS', '1', "k-space Filtering", '', 'KSpaceFiltering'),  # noqa
    0x00189065: ('CS', '1-2', "Time Domain Filtering", '', 'TimeDomainFiltering'),  # noqa
    0x00189066: ('US', '1-2', "Number of Zero Fills", '', 'NumberOfZeroFills'),  # noqa
    0x00189067: ('CS', '1', "Baseline Correction", '', 'BaselineCorrection'),  # noqa
    0x00189069: ('FD', '1', "Parallel Reduction Factor In-plane", '', 'ParallelReductionFactorInPlane'),  # noqa
    0x00189070: ('FD', '1', "Cardiac R-R Interval Specified", '', 'CardiacRRIntervalSpecified'),  # noqa
    0x00189073: ('FD', '1', "Acquisition Duration", '', 'AcquisitionDuration'),  # noqa
    0x00189074: ('DT', '1', "Frame Acquisition DateTime", '', 'FrameAcquisitionDateTime'),  # noqa
    0x00189075: ('CS', '1', "Diffusion Directionality", '', 'DiffusionDirectionality'),  # noqa
    0x00189076: ('SQ', '1', "Diffusion Gradient Direction Sequence", '', 'DiffusionGradientDirectionSequence'),  # noqa
    0x00189077: ('CS', '1', "Parallel Acquisition", '', 'ParallelAcquisition'),  # noqa
    0x00189078: ('CS', '1', "Parallel Acquisition Technique", '', 'ParallelAcquisitionTechnique'),  # noqa
    0x00189079: ('FD', '1-n', "Inversion Times", '', 'InversionTimes'),  # noqa
    0x00189080: ('ST', '1', "Metabolite Map Description", '', 'MetaboliteMapDescription'),  # noqa
    0x00189081: ('CS', '1', "Partial Fourier", '', 'PartialFourier'),  # noqa
    0x00189082: ('FD', '1', "Effective Echo Time", '', 'EffectiveEchoTime'),  # noqa
    0x00189083: ('SQ', '1', "Metabolite Map Code Sequence", '', 'MetaboliteMapCodeSequence'),  # noqa
    0x00189084: ('SQ', '1', "Chemical Shift Sequence", '', 'ChemicalShiftSequence'),  # noqa
    0x00189085: ('CS', '1', "Cardiac Signal Source", '', 'CardiacSignalSource'),  # noqa
    0x00189087: ('FD', '1', "Diffusion b-value", '', 'DiffusionBValue'),  # noqa
    0x00189089: ('FD', '3', "Diffusion Gradient Orientation", '', 'DiffusionGradientOrientation'),  # noqa
    0x00189090: ('FD', '3', "Velocity Encoding Direction", '', 'VelocityEncodingDirection'),  # noqa
    0x00189091: ('FD', '1', "Velocity Encoding Minimum Value", '', 'VelocityEncodingMinimumValue'),  # noqa
    0x00189092: ('SQ', '1', "Velocity Encoding Acquisition Sequence", '', 'VelocityEncodingAcquisitionSequence'),  # noqa
    0x00189093: ('US', '1', "Number of k-Space Trajectories", '', 'NumberOfKSpaceTrajectories'),  # noqa
    0x00189094: ('CS', '1', "Coverage of k-Space", '', 'CoverageOfKSpace'),  # noqa
    0x00189095: ('UL', '1', "Spectroscopy Acquisition Phase Rows", '', 'SpectroscopyAcquisitionPhaseRows'),  # noqa
    0x00189096: ('FD', '1', "Parallel Reduction Factor In-plane (Retired)", 'Retired', 'ParallelReductionFactorInPlaneRetired'),  # noqa
    0x00189098: ('FD', '1-2', "Transmitter Frequency", '', 'TransmitterFrequency'),  # noqa
    0x00189100: ('CS', '1-2', "Resonant Nucleus", '', 'ResonantNucleus'),  # noqa
    0x00189101: ('CS', '1', "Frequency Correction", '', 'FrequencyCorrection'),  # noqa
    0x00189103: ('SQ', '1', "MR Spectroscopy FOV/Geometry Sequence", '', 'MRSpectroscopyFOVGeometrySequence'),  # noqa
    0x00189104: ('FD', '1', "Slab Thickness", '', 'SlabThickness'),  # noqa
    0x00189105: ('FD', '3', "Slab Orientation", '', 'SlabOrientation'),  # noqa
    0x00189106: ('FD', '3', "Mid Slab Position", '', 'MidSlabPosition'),  # noqa
    0x00189107: ('SQ', '1', "MR Spatial Saturation Sequence", '', 'MRSpatialSaturationSequence'),  # noqa
    0x00189112: ('SQ', '1', "MR Timing and Related Parameters Sequence", '', 'MRTimingAndRelatedParametersSequence'),  # noqa
    0x00189114: ('SQ', '1', "MR Echo Sequence", '', 'MREchoSequence'),  # noqa
    0x00189115: ('SQ', '1', "MR Modifier Sequence", '', 'MRModifierSequence'),  # noqa
    0x00189117: ('SQ', '1', "MR Diffusion Sequence", '', 'MRDiffusionSequence'),  # noqa
    0x00189118: ('SQ', '1', "Cardiac Synchronization Sequence", '', 'CardiacSynchronizationSequence'),  # noqa
    0x00189119: ('SQ', '1', "MR Averages Sequence", '', 'MRAveragesSequence'),  # noqa
    0x00189125: ('SQ', '1', "MR FOV/Geometry Sequence", '', 'MRFOVGeometrySequence'),  # noqa
    0x00189126: ('SQ', '1', "Volume Localization Sequence", '', 'VolumeLocalizationSequence'),  # noqa
    0x00189127: ('UL', '1', "Spectroscopy Acquisition Data Columns", '', 'SpectroscopyAcquisitionDataColumns'),  # noqa
    0x00189147: ('CS', '1', "Diffusion Anisotropy Type", '', 'DiffusionAnisotropyType'),  # noqa
    0x00189151: ('DT', '1', "Frame Reference DateTime", '', 'FrameReferenceDateTime'),  # noqa
    0x00189152: ('SQ', '1', "MR Metabolite Map Sequence", '', 'MRMetaboliteMapSequence'),  # noqa
    0x00189155: ('FD', '1', "Parallel Reduction Factor out-of-plane", '', 'ParallelReductionFactorOutOfPlane'),  # noqa
    0x00189159: ('UL', '1', "Spectroscopy Acquisition Out-of-plane Phase Steps", '', 'SpectroscopyAcquisitionOutOfPlanePhaseSteps'),  # noqa
    0x00189166: ('CS', '1', "Bulk Motion Status", 'Retired', 'BulkMotionStatus'),  # noqa
    0x00189168: ('FD', '1', "Parallel Reduction Factor Second In-plane", '', 'ParallelReductionFactorSecondInPlane'),  # noqa
    0x00189169: ('CS', '1', "Cardiac Beat Rejection Technique", '', 'CardiacBeatRejectionTechnique'),  # noqa
    0x00189170: ('CS', '1', "Respiratory Motion Compensation Technique", '', 'RespiratoryMotionCompensationTechnique'),  # noqa
    0x00189171: ('CS', '1', "Respiratory Signal Source", '', 'RespiratorySignalSource'),  # noqa
    0x00189172: ('CS', '1', "Bulk Motion Compensation Technique", '', 'BulkMotionCompensationTechnique'),  # noqa
    0x00189173: ('CS', '1', "Bulk Motion Signal Source", '', 'BulkMotionSignalSource'),  # noqa
    0x00189174: ('CS', '1', "Applicable Safety Standard Agency", '', 'ApplicableSafetyStandardAgency'),  # noqa
    0x00189175: ('LO', '1', "Applicable Safety Standard Description", '', 'ApplicableSafetyStandardDescription'),  # noqa
    0x00189176: ('SQ', '1', "Operating Mode Sequence", '', 'OperatingModeSequence'),  # noqa
    0x00189177: ('CS', '1', "Operating Mode Type", '', 'OperatingModeType'),  # noqa
    0x00189178: ('CS', '1', "Operating Mode", '', 'OperatingMode'),  # noqa
    0x00189179: ('CS', '1', "Specific Absorption Rate Definition", '', 'SpecificAbsorptionRateDefinition'),  # noqa
    0x00189180: ('CS', '1', "Gradient Output Type", '', 'GradientOutputType'),  # noqa
    0x00189181: ('FD', '1', "Specific Absorption Rate Value", '', 'SpecificAbsorptionRateValue'),  # noqa
    0x00189182: ('FD', '1', "Gradient Output", '', 'GradientOutput'),  # noqa
    0x00189183: ('CS', '1', "Flow Compensation Direction", '', 'FlowCompensationDirection'),  # noqa
    0x00189184: ('FD', '1', "Tagging Delay", '', 'TaggingDelay'),  # noqa
    0x00189185: ('ST', '1', "Respiratory Motion Compensation Technique Description", '', 'RespiratoryMotionCompensationTechniqueDescription'),  # noqa
    0x00189186: ('SH', '1', "Respiratory Signal Source ID", '', 'RespiratorySignalSourceID'),  # noqa
    0x00189195: ('FD', '1', "Chemical Shift Minimum Integration Limit in Hz", 'Retired', 'ChemicalShiftMinimumIntegrationLimitInHz'),  # noqa
    0x00189196: ('FD', '1', "Chemical Shift Maximum Integration Limit in Hz", 'Retired', 'ChemicalShiftMaximumIntegrationLimitInHz'),  # noqa
    0x00189197: ('SQ', '1', "MR Velocity Encoding Sequence", '', 'MRVelocityEncodingSequence'),  # noqa
    0x00189198: ('CS', '1', "First Order Phase Correction", '', 'FirstOrderPhaseCorrection'),  # noqa
    0x00189199: ('CS', '1', "Water Referenced Phase Correction", '', 'WaterReferencedPhaseCorrection'),  # noqa
    0x00189200: ('CS', '1', "MR Spectroscopy Acquisition Type", '', 'MRSpectroscopyAcquisitionType'),  # noqa
    0x00189214: ('CS', '1', "Respiratory Cycle Position", '', 'RespiratoryCyclePosition'),  # noqa
    0x00189217: ('FD', '1', "Velocity Encoding Maximum Value", '', 'VelocityEncodingMaximumValue'),  # noqa
    0x00189218: ('FD', '1', "Tag Spacing Second Dimension", '', 'TagSpacingSecondDimension'),  # noqa
    0x00189219: ('SS', '1', "Tag Angle Second Axis", '', 'TagAngleSecondAxis'),  # noqa
    0x00189220: ('FD', '1', "Frame Acquisition Duration", '', 'FrameAcquisitionDuration'),  # noqa
    0x00189226: ('SQ', '1', "MR Image Frame Type Sequence", '', 'MRImageFrameTypeSequence'),  # noqa
    0x00189227: ('SQ', '1', "MR Spectroscopy Frame Type Sequence", '', 'MRSpectroscopyFrameTypeSequence'),  # noqa
    0x00189231: ('US', '1', "MR Acquisition Phase Encoding Steps in-plane", '', 'MRAcquisitionPhaseEncodingStepsInPlane'),  # noqa
    0x00189232: ('US', '1', "MR Acquisition Phase Encoding Steps out-of-plane", '', 'MRAcquisitionPhaseEncodingStepsOutOfPlane'),  # noqa
    0x00189234: ('UL', '1', "Spectroscopy Acquisition Phase Columns", '', 'SpectroscopyAcquisitionPhaseColumns'),  # noqa
    0x00189236: ('CS', '1', "Cardiac Cycle Position", '', 'CardiacCyclePosition'),  # noqa
    0x00189239: ('SQ', '1', "Specific Absorption Rate Sequence", '', 'SpecificAbsorptionRateSequence'),  # noqa
    0x00189240: ('US', '1', "RF Echo Train Length", '', 'RFEchoTrainLength'),  # noqa
    0x00189241: ('US', '1', "Gradient Echo Train Length", '', 'GradientEchoTrainLength'),  # noqa
    0x00189250: ('CS', '1', "Arterial Spin Labeling Contrast", '', 'ArterialSpinLabelingContrast'),  # noqa
    0x00189251: ('SQ', '1', "MR Arterial Spin Labeling Sequence", '', 'MRArterialSpinLabelingSequence'),  # noqa
    0x00189252: ('LO', '1', "ASL Technique Description", '', 'ASLTechniqueDescription'),  # noqa
    0x00189253: ('US', '1', "ASL Slab Number", '', 'ASLSlabNumber'),  # noqa
    0x00189254: ('FD', '1', "ASL Slab Thickness", '', 'ASLSlabThickness'),  # noqa
    0x00189255: ('FD', '3', "ASL Slab Orientation", '', 'ASLSlabOrientation'),  # noqa
    0x00189256: ('FD', '3', "ASL Mid Slab Position", '', 'ASLMidSlabPosition'),  # noqa
    0x00189257: ('CS', '1', "ASL Context", '', 'ASLContext'),  # noqa
    0x00189258: ('UL', '1', "ASL Pulse Train Duration", '', 'ASLPulseTrainDuration'),  # noqa
    0x00189259: ('CS', '1', "ASL Crusher Flag", '', 'ASLCrusherFlag'),  # noqa
    0x0018925A: ('FD', '1', "ASL Crusher Flow Limit", '', 'ASLCrusherFlowLimit'),  # noqa
    0x0018925B: ('LO', '1', "ASL Crusher Description", '', 'ASLCrusherDescription'),  # noqa
    0x0018925C: ('CS', '1', "ASL Bolus Cut-off Flag", '', 'ASLBolusCutoffFlag'),  # noqa
    0x0018925D: ('SQ', '1', "ASL Bolus Cut-off Timing Sequence", '', 'ASLBolusCutoffTimingSequence'),  # noqa
    0x0018925E: ('LO', '1', "ASL Bolus Cut-off Technique", '', 'ASLBolusCutoffTechnique'),  # noqa
    0x0018925F: ('UL', '1', "ASL Bolus Cut-off Delay Time", '', 'ASLBolusCutoffDelayTime'),  # noqa
    0x00189260: ('SQ', '1', "ASL Slab Sequence", '', 'ASLSlabSequence'),  # noqa
    0x00189295: ('FD', '1', "Chemical Shift Minimum Integration Limit in ppm", '', 'ChemicalShiftMinimumIntegrationLimitInppm'),  # noqa
    0x00189296: ('FD', '1', "Chemical Shift Maximum Integration Limit in ppm", '', 'ChemicalShiftMaximumIntegrationLimitInppm'),  # noqa
    0x00189297: ('CS', '1', "Water Reference Acquisition", '', 'WaterReferenceAcquisition'),  # noqa
    0x00189298: ('IS', '1', "Echo Peak Position", '', 'EchoPeakPosition'),  # noqa
    0x00189301: ('SQ', '1', "CT Acquisition Type Sequence", '', 'CTAcquisitionTypeSequence'),  # noqa
    0x00189302: ('CS', '1', "Acquisition Type", '', 'AcquisitionType'),  # noqa
    0x00189303: ('FD', '1', "Tube Angle", '', 'TubeAngle'),  # noqa
    0x00189304: ('SQ', '1', "CT Acquisition Details Sequence", '', 'CTAcquisitionDetailsSequence'),  # noqa
    0x00189305: ('FD', '1', "Revolution Time", '', 'RevolutionTime'),  # noqa
    0x00189306: ('FD', '1', "Single Collimation Width", '', 'SingleCollimationWidth'),  # noqa
    0x00189307: ('FD', '1', "Total Collimation Width", '', 'TotalCollimationWidth'),  # noqa
    0x00189308: ('SQ', '1', "CT Table Dynamics Sequence", '', 'CTTableDynamicsSequence'),  # noqa
    0x00189309: ('FD', '1', "Table Speed", '', 'TableSpeed'),  # noqa
    0x00189310: ('FD', '1', "Table Feed per Rotation", '', 'TableFeedPerRotation'),  # noqa
    0x00189311: ('FD', '1', "Spiral Pitch Factor", '', 'SpiralPitchFactor'),  # noqa
    0x00189312: ('SQ', '1', "CT Geometry Sequence", '', 'CTGeometrySequence'),  # noqa
    0x00189313: ('FD', '3', "Data Collection Center (Patient)", '', 'DataCollectionCenterPatient'),  # noqa
    0x00189314: ('SQ', '1', "CT Reconstruction Sequence", '', 'CTReconstructionSequence'),  # noqa
    0x00189315: ('CS', '1', "Reconstruction Algorithm", '', 'ReconstructionAlgorithm'),  # noqa
    0x00189316: ('CS', '1', "Convolution Kernel Group", '', 'ConvolutionKernelGroup'),  # noqa
    0x00189317: ('FD', '2', "Reconstruction Field of View", '', 'ReconstructionFieldOfView'),  # noqa
    0x00189318: ('FD', '3', "Reconstruction Target Center (Patient)", '', 'ReconstructionTargetCenterPatient'),  # noqa
    0x00189319: ('FD', '1', "Reconstruction Angle", '', 'ReconstructionAngle'),  # noqa
    0x00189320: ('SH', '1', "Image Filter", '', 'ImageFilter'),  # noqa
    0x00189321: ('SQ', '1', "CT Exposure Sequence", '', 'CTExposureSequence'),  # noqa
    0x00189322: ('FD', '2', "Reconstruction Pixel Spacing", '', 'ReconstructionPixelSpacing'),  # noqa
    0x00189323: ('CS', '1-n', "Exposure Modulation Type", '', 'ExposureModulationType'),  # noqa
    0x00189324: ('FD', '1', "Estimated Dose Saving", '', 'EstimatedDoseSaving'),  # noqa
    0x00189325: ('SQ', '1', "CT X-Ray Details Sequence", '', 'CTXRayDetailsSequence'),  # noqa
    0x00189326: ('SQ', '1', "CT Position Sequence", '', 'CTPositionSequence'),  # noqa
    0x00189327: ('FD', '1', "Table Position", '', 'TablePosition'),  # noqa
    0x00189328: ('FD', '1', "Exposure Time in ms", '', 'ExposureTimeInms'),  # noqa
    0x00189329: ('SQ', '1', "CT Image Frame Type Sequence", '', 'CTImageFrameTypeSequence'),  # noqa
    0x00189330: ('FD', '1', "X-Ray Tube Current in mA", '', 'XRayTubeCurrentInmA'),  # noqa
    0x00189332: ('FD', '1', "Exposure in mAs", '', 'ExposureInmAs'),  # noqa
    0x00189333: ('CS', '1', "Constant Volume Flag", '', 'ConstantVolumeFlag'),  # noqa
    0x00189334: ('CS', '1', "Fluoroscopy Flag", '', 'FluoroscopyFlag'),  # noqa
    0x00189335: ('FD', '1', "Distance Source to Data Collection Center", '', 'DistanceSourceToDataCollectionCenter'),  # noqa
    0x00189337: ('US', '1', "Contrast/Bolus Agent Number", '', 'ContrastBolusAgentNumber'),  # noqa
    0x00189338: ('SQ', '1', "Contrast/Bolus Ingredient Code Sequence", '', 'ContrastBolusIngredientCodeSequence'),  # noqa
    0x00189340: ('SQ', '1', "Contrast Administration Profile Sequence", '', 'ContrastAdministrationProfileSequence'),  # noqa
    0x00189341: ('SQ', '1', "Contrast/Bolus Usage Sequence", '', 'ContrastBolusUsageSequence'),  # noqa
    0x00189342: ('CS', '1', "Contrast/Bolus Agent Administered", '', 'ContrastBolusAgentAdministered'),  # noqa
    0x00189343: ('CS', '1', "Contrast/Bolus Agent Detected", '', 'ContrastBolusAgentDetected'),  # noqa
    0x00189344: ('CS', '1', "Contrast/Bolus Agent Phase", '', 'ContrastBolusAgentPhase'),  # noqa
    0x00189345: ('FD', '1', "CTDIvol", '', 'CTDIvol'),  # noqa
    0x00189346: ('SQ', '1', "CTDI Phantom Type Code Sequence", '', 'CTDIPhantomTypeCodeSequence'),  # noqa
    0x00189351: ('FL', '1', "Calcium Scoring Mass Factor Patient", '', 'CalciumScoringMassFactorPatient'),  # noqa
    0x00189352: ('FL', '3', "Calcium Scoring Mass Factor Device", '', 'CalciumScoringMassFactorDevice'),  # noqa
    0x00189353: ('FL', '1', "Energy Weighting Factor", '', 'EnergyWeightingFactor'),  # noqa
    0x00189360: ('SQ', '1', "CT Additional X-Ray Source Sequence", '', 'CTAdditionalXRaySourceSequence'),  # noqa
    0x00189401: ('SQ', '1', "Projection Pixel Calibration Sequence", '', 'ProjectionPixelCalibrationSequence'),  # noqa
    0x00189402: ('FL', '1', "Distance Source to Isocenter", '', 'DistanceSourceToIsocenter'),  # noqa
    0x00189403: ('FL', '1', "Distance Object to Table Top", '', 'DistanceObjectToTableTop'),  # noqa
    0x00189404: ('FL', '2', "Object Pixel Spacing in Center of Beam", '', 'ObjectPixelSpacingInCenterOfBeam'),  # noqa
    0x00189405: ('SQ', '1', "Positioner Position Sequence", '', 'PositionerPositionSequence'),  # noqa
    0x00189406: ('SQ', '1', "Table Position Sequence", '', 'TablePositionSequence'),  # noqa
    0x00189407: ('SQ', '1', "Collimator Shape Sequence", '', 'CollimatorShapeSequence'),  # noqa
    0x00189410: ('CS', '1', "Planes in Acquisition", '', 'PlanesInAcquisition'),  # noqa
    0x00189412: ('SQ', '1', "XA/XRF Frame Characteristics Sequence", '', 'XAXRFFrameCharacteristicsSequence'),  # noqa
    0x00189417: ('SQ', '1', "Frame Acquisition Sequence", '', 'FrameAcquisitionSequence'),  # noqa
    0x00189420: ('CS', '1', "X-Ray Receptor Type", '', 'XRayReceptorType'),  # noqa
    0x00189423: ('LO', '1', "Acquisition Protocol Name", '', 'AcquisitionProtocolName'),  # noqa
    0x00189424: ('LT', '1', "Acquisition Protocol Description", '', 'AcquisitionProtocolDescription'),  # noqa
    0x00189425: ('CS', '1', "Contrast/Bolus Ingredient Opaque", '', 'ContrastBolusIngredientOpaque'),  # noqa
    0x00189426: ('FL', '1', "Distance Receptor Plane to Detector Housing", '', 'DistanceReceptorPlaneToDetectorHousing'),  # noqa
    0x00189427: ('CS', '1', "Intensifier Active Shape", '', 'IntensifierActiveShape'),  # noqa
    0x00189428: ('FL', '1-2', "Intensifier Active Dimension(s)", '', 'IntensifierActiveDimensions'),  # noqa
    0x00189429: ('FL', '2', "Physical Detector Size", '', 'PhysicalDetectorSize'),  # noqa
    0x00189430: ('FL', '2', "Position of Isocenter Projection", '', 'PositionOfIsocenterProjection'),  # noqa
    0x00189432: ('SQ', '1', "Field of View Sequence", '', 'FieldOfViewSequence'),  # noqa
    0x00189433: ('LO', '1', "Field of View Description", '', 'FieldOfViewDescription'),  # noqa
    0x00189434: ('SQ', '1', "Exposure Control Sensing Regions Sequence", '', 'ExposureControlSensingRegionsSequence'),  # noqa
    0x00189435: ('CS', '1', "Exposure Control Sensing Region Shape", '', 'ExposureControlSensingRegionShape'),  # noqa
    0x00189436: ('SS', '1', "Exposure Control Sensing Region Left Vertical Edge", '', 'ExposureControlSensingRegionLeftVerticalEdge'),  # noqa
    0x00189437: ('SS', '1', "Exposure Control Sensing Region Right Vertical Edge", '', 'ExposureControlSensingRegionRightVerticalEdge'),  # noqa
    0x00189438: ('SS', '1', "Exposure Control Sensing Region Upper Horizontal Edge", '', 'ExposureControlSensingRegionUpperHorizontalEdge'),  # noqa
    0x00189439: ('SS', '1', "Exposure Control Sensing Region Lower Horizontal Edge", '', 'ExposureControlSensingRegionLowerHorizontalEdge'),  # noqa
    0x00189440: ('SS', '2', "Center of Circular Exposure Control Sensing Region", '', 'CenterOfCircularExposureControlSensingRegion'),  # noqa
    0x00189441: ('US', '1', "Radius of Circular Exposure Control Sensing Region", '', 'RadiusOfCircularExposureControlSensingRegion'),  # noqa
    0x00189442: ('SS', '2-n', "Vertices of the Polygonal Exposure Control Sensing Region", '', 'VerticesOfThePolygonalExposureControlSensingRegion'),  # noqa
    0x00189445: ('OB', '1', "Retired-blank", 'Retired', ''),  # noqa
    0x00189447: ('FL', '1', "Column Angulation (Patient)", '', 'ColumnAngulationPatient'),  # noqa
    0x00189449: ('FL', '1', "Beam Angle", '', 'BeamAngle'),  # noqa
    0x00189451: ('SQ', '1', "Frame Detector Parameters Sequence", '', 'FrameDetectorParametersSequence'),  # noqa
    0x00189452: ('FL', '1', "Calculated Anatomy Thickness", '', 'CalculatedAnatomyThickness'),  # noqa
    0x00189455: ('SQ', '1', "Calibration Sequence", '', 'CalibrationSequence'),  # noqa
    0x00189456: ('SQ', '1', "Object Thickness Sequence", '', 'ObjectThicknessSequence'),  # noqa
    0x00189457: ('CS', '1', "Plane Identification", '', 'PlaneIdentification'),  # noqa
    0x00189461: ('FL', '1-2', "Field of View Dimension(s) in Float", '', 'FieldOfViewDimensionsInFloat'),  # noqa
    0x00189462: ('SQ', '1', "Isocenter Reference System Sequence", '', 'IsocenterReferenceSystemSequence'),  # noqa
    0x00189463: ('FL', '1', "Positioner Isocenter Primary Angle", '', 'PositionerIsocenterPrimaryAngle'),  # noqa
    0x00189464: ('FL', '1', "Positioner Isocenter Secondary Angle", '', 'PositionerIsocenterSecondaryAngle'),  # noqa
    0x00189465: ('FL', '1', "Positioner Isocenter Detector Rotation Angle", '', 'PositionerIsocenterDetectorRotationAngle'),  # noqa
    0x00189466: ('FL', '1', "Table X Position to Isocenter", '', 'TableXPositionToIsocenter'),  # noqa
    0x00189467: ('FL', '1', "Table Y Position to Isocenter", '', 'TableYPositionToIsocenter'),  # noqa
    0x00189468: ('FL', '1', "Table Z Position to Isocenter", '', 'TableZPositionToIsocenter'),  # noqa
    0x00189469: ('FL', '1', "Table Horizontal Rotation Angle", '', 'TableHorizontalRotationAngle'),  # noqa
    0x00189470: ('FL', '1', "Table Head Tilt Angle", '', 'TableHeadTiltAngle'),  # noqa
    0x00189471: ('FL', '1', "Table Cradle Tilt Angle", '', 'TableCradleTiltAngle'),  # noqa
    0x00189472: ('SQ', '1', "Frame Display Shutter Sequence", '', 'FrameDisplayShutterSequence'),  # noqa
    0x00189473: ('FL', '1', "Acquired Image Area Dose Product", '', 'AcquiredImageAreaDoseProduct'),  # noqa
    0x00189474: ('CS', '1', "C-arm Positioner Tabletop Relationship", '', 'CArmPositionerTabletopRelationship'),  # noqa
    0x00189476: ('SQ', '1', "X-Ray Geometry Sequence", '', 'XRayGeometrySequence'),  # noqa
    0x00189477: ('SQ', '1', "Irradiation Event Identification Sequence", '', 'IrradiationEventIdentificationSequence'),  # noqa
    0x00189504: ('SQ', '1', "X-Ray 3D Frame Type Sequence", '', 'XRay3DFrameTypeSequence'),  # noqa
    0x00189506: ('SQ', '1', "Contributing Sources Sequence", '', 'ContributingSourcesSequence'),  # noqa
    0x00189507: ('SQ', '1', "X-Ray 3D Acquisition Sequence", '', 'XRay3DAcquisitionSequence'),  # noqa
    0x00189508: ('FL', '1', "Primary Positioner Scan Arc", '', 'PrimaryPositionerScanArc'),  # noqa
    0x00189509: ('FL', '1', "Secondary Positioner Scan Arc", '', 'SecondaryPositionerScanArc'),  # noqa
    0x00189510: ('FL', '1', "Primary Positioner Scan Start Angle", '', 'PrimaryPositionerScanStartAngle'),  # noqa
    0x00189511: ('FL', '1', "Secondary Positioner Scan Start Angle", '', 'SecondaryPositionerScanStartAngle'),  # noqa
    0x00189514: ('FL', '1', "Primary Positioner Increment", '', 'PrimaryPositionerIncrement'),  # noqa
    0x00189515: ('FL', '1', "Secondary Positioner Increment", '', 'SecondaryPositionerIncrement'),  # noqa
    0x00189516: ('DT', '1', "Start Acquisition DateTime", '', 'StartAcquisitionDateTime'),  # noqa
    0x00189517: ('DT', '1', "End Acquisition DateTime", '', 'EndAcquisitionDateTime'),  # noqa
    0x00189518: ('SS', '1', "Primary Positioner Increment Sign", '', 'PrimaryPositionerIncrementSign'),  # noqa
    0x00189519: ('SS', '1', "Secondary Positioner Increment Sign", '', 'SecondaryPositionerIncrementSign'),  # noqa
    0x00189524: ('LO', '1', "Application Name", '', 'ApplicationName'),  # noqa
    0x00189525: ('LO', '1', "Application Version", '', 'ApplicationVersion'),  # noqa
    0x00189526: ('LO', '1', "Application Manufacturer", '', 'ApplicationManufacturer'),  # noqa
    0x00189527: ('CS', '1', "Algorithm Type", '', 'AlgorithmType'),  # noqa
    0x00189528: ('LO', '1', "Algorithm Description", '', 'AlgorithmDescription'),  # noqa
    0x00189530: ('SQ', '1', "X-Ray 3D Reconstruction Sequence", '', 'XRay3DReconstructionSequence'),  # noqa
    0x00189531: ('LO', '1', "Reconstruction Description", '', 'ReconstructionDescription'),  # noqa
    0x00189538: ('SQ', '1', "Per Projection Acquisition Sequence", '', 'PerProjectionAcquisitionSequence'),  # noqa
    0x00189541: ('SQ', '1', "Detector Position Sequence", '', 'DetectorPositionSequence'),  # noqa
    0x00189542: ('SQ', '1', "X-Ray Acquisition Dose Sequence", '', 'XRayAcquisitionDoseSequence'),  # noqa
    0x00189543: ('FD', '1', "X-Ray Source Isocenter Primary Angle", '', 'XRaySourceIsocenterPrimaryAngle'),  # noqa
    0x00189544: ('FD', '1', "X-Ray Source Isocenter Secondary Angle", '', 'XRaySourceIsocenterSecondaryAngle'),  # noqa
    0x00189545: ('FD', '1', "Breast Support Isocenter Primary Angle", '', 'BreastSupportIsocenterPrimaryAngle'),  # noqa
    0x00189546: ('FD', '1', "Breast Support Isocenter Secondary Angle", '', 'BreastSupportIsocenterSecondaryAngle'),  # noqa
    0x00189547: ('FD', '1', "Breast Support X Position to Isocenter", '', 'BreastSupportXPositionToIsocenter'),  # noqa
    0x00189548: ('FD', '1', "Breast Support Y Position to Isocenter", '', 'BreastSupportYPositionToIsocenter'),  # noqa
    0x00189549: ('FD', '1', "Breast Support Z Position to Isocenter", '', 'BreastSupportZPositionToIsocenter'),  # noqa
    0x00189550: ('FD', '1', "Detector Isocenter Primary Angle", '', 'DetectorIsocenterPrimaryAngle'),  # noqa
    0x00189551: ('FD', '1', "Detector Isocenter Secondary Angle", '', 'DetectorIsocenterSecondaryAngle'),  # noqa
    0x00189552: ('FD', '1', "Detector X Position to Isocenter", '', 'DetectorXPositionToIsocenter'),  # noqa
    0x00189553: ('FD', '1', "Detector Y Position to Isocenter", '', 'DetectorYPositionToIsocenter'),  # noqa
    0x00189554: ('FD', '1', "Detector Z Position to Isocenter", '', 'DetectorZPositionToIsocenter'),  # noqa
    0x00189555: ('SQ', '1', "X-Ray Grid Sequence", '', 'XRayGridSequence'),  # noqa
    0x00189556: ('SQ', '1', "X-Ray Filter Sequence", '', 'XRayFilterSequence'),  # noqa
    0x00189557: ('FD', '3', "Detector Active Area TLHC Position", '', 'DetectorActiveAreaTLHCPosition'),  # noqa
    0x00189558: ('FD', '6', "Detector Active Area Orientation", '', 'DetectorActiveAreaOrientation'),  # noqa
    0x00189559: ('CS', '1', "Positioner Primary Angle Direction", '', 'PositionerPrimaryAngleDirection'),  # noqa
    0x00189601: ('SQ', '1', "Diffusion b-matrix Sequence", '', 'DiffusionBMatrixSequence'),  # noqa
    0x00189602: ('FD', '1', "Diffusion b-value XX", '', 'DiffusionBValueXX'),  # noqa
    0x00189603: ('FD', '1', "Diffusion b-value XY", '', 'DiffusionBValueXY'),  # noqa
    0x00189604: ('FD', '1', "Diffusion b-value XZ", '', 'DiffusionBValueXZ'),  # noqa
    0x00189605: ('FD', '1', "Diffusion b-value YY", '', 'DiffusionBValueYY'),  # noqa
    0x00189606: ('FD', '1', "Diffusion b-value YZ", '', 'DiffusionBValueYZ'),  # noqa
    0x00189607: ('FD', '1', "Diffusion b-value ZZ", '', 'DiffusionBValueZZ'),  # noqa
    0x00189621: ('SQ', '1', "Functional MR Sequence", '', 'FunctionalMRSequence'),  # noqa
    0x00189622: ('CS', '1', "Functional Settling Phase Frames Present", '', 'FunctionalSettlingPhaseFramesPresent'),  # noqa
    0x00189623: ('DT', '1', "Functional Sync Pulse", '', 'FunctionalSyncPulse'),  # noqa
    0x00189624: ('CS', '1', "Settling Phase Frame", '', 'SettlingPhaseFrame'),  # noqa
    0x00189701: ('DT', '1', "Decay Correction DateTime", '', 'DecayCorrectionDateTime'),  # noqa
    0x00189715: ('FD', '1', "Start Density Threshold", '', 'StartDensityThreshold'),  # noqa
    0x00189716: ('FD', '1', "Start Relative Density Difference Threshold", '', 'StartRelativeDensityDifferenceThreshold'),  # noqa
    0x00189717: ('FD', '1', "Start Cardiac Trigger Count Threshold", '', 'StartCardiacTriggerCountThreshold'),  # noqa
    0x00189718: ('FD', '1', "Start Respiratory Trigger Count Threshold", '', 'StartRespiratoryTriggerCountThreshold'),  # noqa
    0x00189719: ('FD', '1', "Termination Counts Threshold", '', 'TerminationCountsThreshold'),  # noqa
    0x00189720: ('FD', '1', "Termination Density Threshold", '', 'TerminationDensityThreshold'),  # noqa
    0x00189721: ('FD', '1', "Termination Relative Density Threshold", '', 'TerminationRelativeDensityThreshold'),  # noqa
    0x00189722: ('FD', '1', "Termination Time Threshold", '', 'TerminationTimeThreshold'),  # noqa
    0x00189723: ('FD', '1', "Termination Cardiac Trigger Count Threshold", '', 'TerminationCardiacTriggerCountThreshold'),  # noqa
    0x00189724: ('FD', '1', "Termination Respiratory Trigger Count Threshold", '', 'TerminationRespiratoryTriggerCountThreshold'),  # noqa
    0x00189725: ('CS', '1', "Detector Geometry", '', 'DetectorGeometry'),  # noqa
    0x00189726: ('FD', '1', "Transverse Detector Separation", '', 'TransverseDetectorSeparation'),  # noqa
    0x00189727: ('FD', '1', "Axial Detector Dimension", '', 'AxialDetectorDimension'),  # noqa
    0x00189729: ('US', '1', "Radiopharmaceutical Agent Number", '', 'RadiopharmaceuticalAgentNumber'),  # noqa
    0x00189732: ('SQ', '1', "PET Frame Acquisition Sequence", '', 'PETFrameAcquisitionSequence'),  # noqa
    0x00189733: ('SQ', '1', "PET Detector Motion Details Sequence", '', 'PETDetectorMotionDetailsSequence'),  # noqa
    0x00189734: ('SQ', '1', "PET Table Dynamics Sequence", '', 'PETTableDynamicsSequence'),  # noqa
    0x00189735: ('SQ', '1', "PET Position Sequence", '', 'PETPositionSequence'),  # noqa
    0x00189736: ('SQ', '1', "PET Frame Correction Factors Sequence", '', 'PETFrameCorrectionFactorsSequence'),  # noqa
    0x00189737: ('SQ', '1', "Radiopharmaceutical Usage Sequence", '', 'RadiopharmaceuticalUsageSequence'),  # noqa
    0x00189738: ('CS', '1', "Attenuation Correction Source", '', 'AttenuationCorrectionSource'),  # noqa
    0x00189739: ('US', '1', "Number of Iterations", '', 'NumberOfIterations'),  # noqa
    0x00189740: ('US', '1', "Number of Subsets", '', 'NumberOfSubsets'),  # noqa
    0x00189749: ('SQ', '1', "PET Reconstruction Sequence", '', 'PETReconstructionSequence'),  # noqa
    0x00189751: ('SQ', '1', "PET Frame Type Sequence", '', 'PETFrameTypeSequence'),  # noqa
    0x00189755: ('CS', '1', "Time of Flight Information Used", '', 'TimeOfFlightInformationUsed'),  # noqa
    0x00189756: ('CS', '1', "Reconstruction Type", '', 'ReconstructionType'),  # noqa
    0x00189758: ('CS', '1', "Decay Corrected", '', 'DecayCorrected'),  # noqa
    0x00189759: ('CS', '1', "Attenuation Corrected", '', 'AttenuationCorrected'),  # noqa
    0x00189760: ('CS', '1', "Scatter Corrected", '', 'ScatterCorrected'),  # noqa
    0x00189761: ('CS', '1', "Dead Time Corrected", '', 'DeadTimeCorrected'),  # noqa
    0x00189762: ('CS', '1', "Gantry Motion Corrected", '', 'GantryMotionCorrected'),  # noqa
    0x00189763: ('CS', '1', "Patient Motion Corrected", '', 'PatientMotionCorrected'),  # noqa
    0x00189764: ('CS', '1', "Count Loss Normalization Corrected", '', 'CountLossNormalizationCorrected'),  # noqa
    0x00189765: ('CS', '1', "Randoms Corrected", '', 'RandomsCorrected'),  # noqa
    0x00189766: ('CS', '1', "Non-uniform Radial Sampling Corrected", '', 'NonUniformRadialSamplingCorrected'),  # noqa
    0x00189767: ('CS', '1', "Sensitivity Calibrated", '', 'SensitivityCalibrated'),  # noqa
    0x00189768: ('CS', '1', "Detector Normalization Correction", '', 'DetectorNormalizationCorrection'),  # noqa
    0x00189769: ('CS', '1', "Iterative Reconstruction Method", '', 'IterativeReconstructionMethod'),  # noqa
    0x00189770: ('CS', '1', "Attenuation Correction Temporal Relationship", '', 'AttenuationCorrectionTemporalRelationship'),  # noqa
    0x00189771: ('SQ', '1', "Patient Physiological State Sequence", '', 'PatientPhysiologicalStateSequence'),  # noqa
    0x00189772: ('SQ', '1', "Patient Physiological State Code Sequence", '', 'PatientPhysiologicalStateCodeSequence'),  # noqa
    0x00189801: ('FD', '1-n', "Depth(s) of Focus", '', 'DepthsOfFocus'),  # noqa
    0x00189803: ('SQ', '1', "Excluded Intervals Sequence", '', 'ExcludedIntervalsSequence'),  # noqa
    0x00189804: ('DT', '1', "Exclusion Start DateTime", '', 'ExclusionStartDateTime'),  # noqa
    0x00189805: ('FD', '1', "Exclusion Duration", '', 'ExclusionDuration'),  # noqa
    0x00189806: ('SQ', '1', "US Image Description Sequence", '', 'USImageDescriptionSequence'),  # noqa
    0x00189807: ('SQ', '1', "Image Data Type Sequence", '', 'ImageDataTypeSequence'),  # noqa
    0x00189808: ('CS', '1', "Data Type", '', 'DataType'),  # noqa
    0x00189809: ('SQ', '1', "Transducer Scan Pattern Code Sequence", '', 'TransducerScanPatternCodeSequence'),  # noqa
    0x0018980B: ('CS', '1', "Aliased Data Type", '', 'AliasedDataType'),  # noqa
    0x0018980C: ('CS', '1', "Position Measuring Device Used", '', 'PositionMeasuringDeviceUsed'),  # noqa
    0x0018980D: ('SQ', '1', "Transducer Geometry Code Sequence", '', 'TransducerGeometryCodeSequence'),  # noqa
    0x0018980E: ('SQ', '1', "Transducer Beam Steering Code Sequence", '', 'TransducerBeamSteeringCodeSequence'),  # noqa
    0x0018980F: ('SQ', '1', "Transducer Application Code Sequence", '', 'TransducerApplicationCodeSequence'),  # noqa
    0x00189810: ('US or SS', '1', "Zero Velocity Pixel Value", '', 'ZeroVelocityPixelValue'),  # noqa
    0x00189900: ('LO', '1', "Reference Location Label", '', 'ReferenceLocationLabel'),  # noqa
    0x00189901: ('UT', '1', "Reference Location Description", '', 'ReferenceLocationDescription'),  # noqa
    0x00189902: ('SQ', '1', "Reference Basis Code Sequence", '', 'ReferenceBasisCodeSequence'),  # noqa
    0x00189903: ('SQ', '1', "Reference Geometry Code Sequence", '', 'ReferenceGeometryCodeSequence'),  # noqa
    0x00189904: ('DS', '1', "Offset Distance", '', 'OffsetDistance'),  # noqa
    0x00189905: ('CS', '1', "Offset Direction", '', 'OffsetDirection'),  # noqa
    0x00189906: ('SQ', '1', "Potential Scheduled Protocol Code Sequence", '', 'PotentialScheduledProtocolCodeSequence'),  # noqa
    0x00189907: ('SQ', '1', "Potential Requested Procedure Code Sequence", '', 'PotentialRequestedProcedureCodeSequence'),  # noqa
    0x00189908: ('UC', '1-n', "Potential Reasons for Procedure", '', 'PotentialReasonsForProcedure'),  # noqa
    0x00189909: ('SQ', '1', "Potential Reasons for Procedure Code Sequence", '', 'PotentialReasonsForProcedureCodeSequence'),  # noqa
    0x0018990A: ('UC', '1-n', "Potential Diagnostic Tasks", '', 'PotentialDiagnosticTasks'),  # noqa
    0x0018990B: ('SQ', '1', "Contraindications Code Sequence", '', 'ContraindicationsCodeSequence'),  # noqa
    0x0018990C: ('SQ', '1', "Referenced Defined Protocol Sequence", '', 'ReferencedDefinedProtocolSequence'),  # noqa
    0x0018990D: ('SQ', '1', "Referenced Performed Protocol Sequence", '', 'ReferencedPerformedProtocolSequence'),  # noqa
    0x0018990E: ('SQ', '1', "Predecessor Protocol Sequence", '', 'PredecessorProtocolSequence'),  # noqa
    0x0018990F: ('UT', '1', "Protocol Planning Information", '', 'ProtocolPlanningInformation'),  # noqa
    0x00189910: ('UT', '1', "Protocol Design Rationale", '', 'ProtocolDesignRationale'),  # noqa
    0x00189911: ('SQ', '1', "Patient Specification Sequence", '', 'PatientSpecificationSequence'),  # noqa
    0x00189912: ('SQ', '1', "Model Specification Sequence", '', 'ModelSpecificationSequence'),  # noqa
    0x00189913: ('SQ', '1', "Parameters Specification Sequence", '', 'ParametersSpecificationSequence'),  # noqa
    0x00189914: ('SQ', '1', "Instruction Sequence", '', 'InstructionSequence'),  # noqa
    0x00189915: ('US', '1', "Instruction Index", '', 'InstructionIndex'),  # noqa
    0x00189916: ('LO', '1', "Instruction Text", '', 'InstructionText'),  # noqa
    0x00189917: ('UT', '1', "Instruction Description", '', 'InstructionDescription'),  # noqa
    0x00189918: ('CS', '1', "Instruction Performed Flag", '', 'InstructionPerformedFlag'),  # noqa
    0x00189919: ('DT', '1', "Instruction Performed DateTime", '', 'InstructionPerformedDateTime'),  # noqa
    0x0018991A: ('UT', '1', "Instruction Performance Comment", '', 'InstructionPerformanceComment'),  # noqa
    0x0018991B: ('SQ', '1', "Patient Positioning Instruction Sequence", '', 'PatientPositioningInstructionSequence'),  # noqa
    0x0018991C: ('SQ', '1', "Positioning Method Code Sequence", '', 'PositioningMethodCodeSequence'),  # noqa
    0x0018991D: ('SQ', '1', "Positioning Landmark Sequence", '', 'PositioningLandmarkSequence'),  # noqa
    0x0018991E: ('UI', '1', "Target Frame of Reference UID", '', 'TargetFrameOfReferenceUID'),  # noqa
    0x0018991F: ('SQ', '1', "Acquisition Protocol Element Specification Sequence", '', 'AcquisitionProtocolElementSpecificationSequence'),  # noqa
    0x00189920: ('SQ', '1', "Acquisition Protocol Element Sequence", '', 'AcquisitionProtocolElementSequence'),  # noqa
    0x00189921: ('US', '1', "Protocol Element Number", '', 'ProtocolElementNumber'),  # noqa
    0x00189922: ('LO', '1', "Protocol Element Name", '', 'ProtocolElementName'),  # noqa
    0x00189923: ('UT', '1', "Protocol Element Characteristics Summary", '', 'ProtocolElementCharacteristicsSummary'),  # noqa
    0x00189924: ('UT', '1', "Protocol Element Purpose", '', 'ProtocolElementPurpose'),  # noqa
    0x00189930: ('CS', '1', "Acquisition Motion", '', 'AcquisitionMotion'),  # noqa
    0x00189931: ('SQ', '1', "Acquisition Start Location Sequence", '', 'AcquisitionStartLocationSequence'),  # noqa
    0x00189932: ('SQ', '1', "Acquisition End Location Sequence", '', 'AcquisitionEndLocationSequence'),  # noqa
    0x00189933: ('SQ', '1', "Reconstruction Protocol Element Specification Sequence", '', 'ReconstructionProtocolElementSpecificationSequence'),  # noqa
    0x00189934: ('SQ', '1', "Reconstruction Protocol Element Sequence", '', 'ReconstructionProtocolElementSequence'),  # noqa
    0x00189935: ('SQ', '1', "Storage Protocol Element Specification Sequence", '', 'StorageProtocolElementSpecificationSequence'),  # noqa
    0x00189936: ('SQ', '1', "Storage Protocol Element Sequence", '', 'StorageProtocolElementSequence'),  # noqa
    0x00189937: ('LO', '1', "Requested Series Description", '', 'RequestedSeriesDescription'),  # noqa
    0x00189938: ('US', '1-n', "Source Acquisition Protocol Element Number", '', 'SourceAcquisitionProtocolElementNumber'),  # noqa
    0x00189939: ('US', '1-n', "Source Acquisition Beam Number", '', 'SourceAcquisitionBeamNumber'),  # noqa
    0x0018993A: ('US', '1-n', "Source Reconstruction Protocol Element Number", '', 'SourceReconstructionProtocolElementNumber'),  # noqa
    0x0018993B: ('SQ', '1', "Reconstruction Start Location Sequence", '', 'ReconstructionStartLocationSequence'),  # noqa
    0x0018993C: ('SQ', '1', "Reconstruction End Location Sequence", '', 'ReconstructionEndLocationSequence'),  # noqa
    0x0018993D: ('SQ', '1', "Reconstruction Algorithm Sequence", '', 'ReconstructionAlgorithmSequence'),  # noqa
    0x0018993E: ('SQ', '1', "Reconstruction Target Center Location Sequence", '', 'ReconstructionTargetCenterLocationSequence'),  # noqa
    0x00189941: ('UT', '1', "Image Filter Description", '', 'ImageFilterDescription'),  # noqa
    0x00189942: ('FD', '1', "CTDIvol Notification Trigger", '', 'CTDIvolNotificationTrigger'),  # noqa
    0x00189943: ('FD', '1', "DLP Notification Trigger", '', 'DLPNotificationTrigger'),  # noqa
    0x00189944: ('CS', '1', "Auto KVP Selection Type", '', 'AutoKVPSelectionType'),  # noqa
    0x00189945: ('FD', '1', "Auto KVP Upper Bound", '', 'AutoKVPUpperBound'),  # noqa
    0x00189946: ('FD', '1', "Auto KVP Lower Bound", '', 'AutoKVPLowerBound'),  # noqa
    0x00189947: ('CS', '1', "Protocol Defined Patient Position", '', 'ProtocolDefinedPatientPosition'),  # noqa
    0x0018A001: ('SQ', '1', "Contributing Equipment Sequence", '', 'ContributingEquipmentSequence'),  # noqa
    0x0018A002: ('DT', '1', "Contribution DateTime", '', 'ContributionDateTime'),  # noqa
    0x0018A003: ('ST', '1', "Contribution Description", '', 'ContributionDescription'),  # noqa
    0x0020000D: ('UI', '1', "Study Instance UID", '', 'StudyInstanceUID'),  # noqa
    0x0020000E: ('UI', '1', "Series Instance UID", '', 'SeriesInstanceUID'),  # noqa
    0x00200010: ('SH', '1', "Study ID", '', 'StudyID'),  # noqa
    0x00200011: ('IS', '1', "Series Number", '', 'SeriesNumber'),  # noqa
    0x00200012: ('IS', '1', "Acquisition Number", '', 'AcquisitionNumber'),  # noqa
    0x00200013: ('IS', '1', "Instance Number", '', 'InstanceNumber'),  # noqa
    0x00200014: ('IS', '1', "Isotope Number", 'Retired', 'IsotopeNumber'),  # noqa
    0x00200015: ('IS', '1', "Phase Number", 'Retired', 'PhaseNumber'),  # noqa
    0x00200016: ('IS', '1', "Interval Number", 'Retired', 'IntervalNumber'),  # noqa
    0x00200017: ('IS', '1', "Time Slot Number", 'Retired', 'TimeSlotNumber'),  # noqa
    0x00200018: ('IS', '1', "Angle Number", 'Retired', 'AngleNumber'),  # noqa
    0x00200019: ('IS', '1', "Item Number", '', 'ItemNumber'),  # noqa
    0x00200020: ('CS', '2', "Patient Orientation", '', 'PatientOrientation'),  # noqa
    0x00200022: ('IS', '1', "Overlay Number", 'Retired', 'OverlayNumber'),  # noqa
    0x00200024: ('IS', '1', "Curve Number", 'Retired', 'CurveNumber'),  # noqa
    0x00200026: ('IS', '1', "LUT Number", 'Retired', 'LUTNumber'),  # noqa
    0x00200030: ('DS', '3', "Image Position", 'Retired', 'ImagePosition'),  # noqa
    0x00200032: ('DS', '3', "Image Position (Patient)", '', 'ImagePositionPatient'),  # noqa
    0x00200035: ('DS', '6', "Image Orientation", 'Retired', 'ImageOrientation'),  # noqa
    0x00200037: ('DS', '6', "Image Orientation (Patient)", '', 'ImageOrientationPatient'),  # noqa
    0x00200050: ('DS', '1', "Location", 'Retired', 'Location'),  # noqa
    0x00200052: ('UI', '1', "Frame of Reference UID", '', 'FrameOfReferenceUID'),  # noqa
    0x00200060: ('CS', '1', "Laterality", '', 'Laterality'),  # noqa
    0x00200062: ('CS', '1', "Image Laterality", '', 'ImageLaterality'),  # noqa
    0x00200070: ('LO', '1', "Image Geometry Type", 'Retired', 'ImageGeometryType'),  # noqa
    0x00200080: ('CS', '1-n', "Masking Image", 'Retired', 'MaskingImage'),  # noqa
    0x002000AA: ('IS', '1', "Report Number", 'Retired', 'ReportNumber'),  # noqa
    0x00200100: ('IS', '1', "Temporal Position Identifier", '', 'TemporalPositionIdentifier'),  # noqa
    0x00200105: ('IS', '1', "Number of Temporal Positions", '', 'NumberOfTemporalPositions'),  # noqa
    0x00200110: ('DS', '1', "Temporal Resolution", '', 'TemporalResolution'),  # noqa
    0x00200200: ('UI', '1', "Synchronization Frame of Reference UID", '', 'SynchronizationFrameOfReferenceUID'),  # noqa
    0x00200242: ('UI', '1', "SOP Instance UID of Concatenation Source", '', 'SOPInstanceUIDOfConcatenationSource'),  # noqa
    0x00201000: ('IS', '1', "Series in Study", 'Retired', 'SeriesInStudy'),  # noqa
    0x00201001: ('IS', '1', "Acquisitions in Series", 'Retired', 'AcquisitionsInSeries'),  # noqa
    0x00201002: ('IS', '1', "Images in Acquisition", '', 'ImagesInAcquisition'),  # noqa
    0x00201003: ('IS', '1', "Images in Series", 'Retired', 'ImagesInSeries'),  # noqa
    0x00201004: ('IS', '1', "Acquisitions in Study", 'Retired', 'AcquisitionsInStudy'),  # noqa
    0x00201005: ('IS', '1', "Images in Study", 'Retired', 'ImagesInStudy'),  # noqa
    0x00201020: ('LO', '1-n', "Reference", 'Retired', 'Reference'),  # noqa
    0x0020103F: ('LO', '1', "Target Position Reference Indicator", '', 'TargetPositionReferenceIndicator'),  # noqa
    0x00201040: ('LO', '1', "Position Reference Indicator", '', 'PositionReferenceIndicator'),  # noqa
    0x00201041: ('DS', '1', "Slice Location", '', 'SliceLocation'),  # noqa
    0x00201070: ('IS', '1-n', "Other Study Numbers", 'Retired', 'OtherStudyNumbers'),  # noqa
    0x00201200: ('IS', '1', "Number of Patient Related Studies", '', 'NumberOfPatientRelatedStudies'),  # noqa
    0x00201202: ('IS', '1', "Number of Patient Related Series", '', 'NumberOfPatientRelatedSeries'),  # noqa
    0x00201204: ('IS', '1', "Number of Patient Related Instances", '', 'NumberOfPatientRelatedInstances'),  # noqa
    0x00201206: ('IS', '1', "Number of Study Related Series", '', 'NumberOfStudyRelatedSeries'),  # noqa
    0x00201208: ('IS', '1', "Number of Study Related Instances", '', 'NumberOfStudyRelatedInstances'),  # noqa
    0x00201209: ('IS', '1', "Number of Series Related Instances", '', 'NumberOfSeriesRelatedInstances'),  # noqa
    0x00203401: ('CS', '1', "Modifying Device ID", 'Retired', 'ModifyingDeviceID'),  # noqa
    0x00203402: ('CS', '1', "Modified Image ID", 'Retired', 'ModifiedImageID'),  # noqa
    0x00203403: ('DA', '1', "Modified Image Date", 'Retired', 'ModifiedImageDate'),  # noqa
    0x00203404: ('LO', '1', "Modifying Device Manufacturer", 'Retired', 'ModifyingDeviceManufacturer'),  # noqa
    0x00203405: ('TM', '1', "Modified Image Time", 'Retired', 'ModifiedImageTime'),  # noqa
    0x00203406: ('LO', '1', "Modified Image Description", 'Retired', 'ModifiedImageDescription'),  # noqa
    0x00204000: ('LT', '1', "Image Comments", '', 'ImageComments'),  # noqa
    0x00205000: ('AT', '1-n', "Original Image Identification", 'Retired', 'OriginalImageIdentification'),  # noqa
    0x00205002: ('LO', '1-n', "Original Image Identification Nomenclature", 'Retired', 'OriginalImageIdentificationNomenclature'),  # noqa
    0x00209056: ('SH', '1', "Stack ID", '', 'StackID'),  # noqa
    0x00209057: ('UL', '1', "In-Stack Position Number", '', 'InStackPositionNumber'),  # noqa
    0x00209071: ('SQ', '1', "Frame Anatomy Sequence", '', 'FrameAnatomySequence'),  # noqa
    0x00209072: ('CS', '1', "Frame Laterality", '', 'FrameLaterality'),  # noqa
    0x00209111: ('SQ', '1', "Frame Content Sequence", '', 'FrameContentSequence'),  # noqa
    0x00209113: ('SQ', '1', "Plane Position Sequence", '', 'PlanePositionSequence'),  # noqa
    0x00209116: ('SQ', '1', "Plane Orientation Sequence", '', 'PlaneOrientationSequence'),  # noqa
    0x00209128: ('UL', '1', "Temporal Position Index", '', 'TemporalPositionIndex'),  # noqa
    0x00209153: ('FD', '1', "Nominal Cardiac Trigger Delay Time", '', 'NominalCardiacTriggerDelayTime'),  # noqa
    0x00209154: ('FL', '1', "Nominal Cardiac Trigger Time Prior To R-Peak", '', 'NominalCardiacTriggerTimePriorToRPeak'),  # noqa
    0x00209155: ('FL', '1', "Actual Cardiac Trigger Time Prior To R-Peak", '', 'ActualCardiacTriggerTimePriorToRPeak'),  # noqa
    0x00209156: ('US', '1', "Frame Acquisition Number", '', 'FrameAcquisitionNumber'),  # noqa
    0x00209157: ('UL', '1-n', "Dimension Index Values", '', 'DimensionIndexValues'),  # noqa
    0x00209158: ('LT', '1', "Frame Comments", '', 'FrameComments'),  # noqa
    0x00209161: ('UI', '1', "Concatenation UID", '', 'ConcatenationUID'),  # noqa
    0x00209162: ('US', '1', "In-concatenation Number", '', 'InConcatenationNumber'),  # noqa
    0x00209163: ('US', '1', "In-concatenation Total Number", '', 'InConcatenationTotalNumber'),  # noqa
    0x00209164: ('UI', '1', "Dimension Organization UID", '', 'DimensionOrganizationUID'),  # noqa
    0x00209165: ('AT', '1', "Dimension Index Pointer", '', 'DimensionIndexPointer'),  # noqa
    0x00209167: ('AT', '1', "Functional Group Pointer", '', 'FunctionalGroupPointer'),  # noqa
    0x00209170: ('SQ', '1', "Unassigned Shared Converted Attributes Sequence", '', 'UnassignedSharedConvertedAttributesSequence'),  # noqa
    0x00209171: ('SQ', '1', "Unassigned Per-Frame Converted Attributes Sequence", '', 'UnassignedPerFrameConvertedAttributesSequence'),  # noqa
    0x00209172: ('SQ', '1', "Conversion Source Attributes Sequence", '', 'ConversionSourceAttributesSequence'),  # noqa
    0x00209213: ('LO', '1', "Dimension Index Private Creator", '', 'DimensionIndexPrivateCreator'),  # noqa
    0x00209221: ('SQ', '1', "Dimension Organization Sequence", '', 'DimensionOrganizationSequence'),  # noqa
    0x00209222: ('SQ', '1', "Dimension Index Sequence", '', 'DimensionIndexSequence'),  # noqa
    0x00209228: ('UL', '1', "Concatenation Frame Offset Number", '', 'ConcatenationFrameOffsetNumber'),  # noqa
    0x00209238: ('LO', '1', "Functional Group Private Creator", '', 'FunctionalGroupPrivateCreator'),  # noqa
    0x00209241: ('FL', '1', "Nominal Percentage of Cardiac Phase", '', 'NominalPercentageOfCardiacPhase'),  # noqa
    0x00209245: ('FL', '1', "Nominal Percentage of Respiratory Phase", '', 'NominalPercentageOfRespiratoryPhase'),  # noqa
    0x00209246: ('FL', '1', "Starting Respiratory Amplitude", '', 'StartingRespiratoryAmplitude'),  # noqa
    0x00209247: ('CS', '1', "Starting Respiratory Phase", '', 'StartingRespiratoryPhase'),  # noqa
    0x00209248: ('FL', '1', "Ending Respiratory Amplitude", '', 'EndingRespiratoryAmplitude'),  # noqa
    0x00209249: ('CS', '1', "Ending Respiratory Phase", '', 'EndingRespiratoryPhase'),  # noqa
    0x00209250: ('CS', '1', "Respiratory Trigger Type", '', 'RespiratoryTriggerType'),  # noqa
    0x00209251: ('FD', '1', "R-R Interval Time Nominal", '', 'RRIntervalTimeNominal'),  # noqa
    0x00209252: ('FD', '1', "Actual Cardiac Trigger Delay Time", '', 'ActualCardiacTriggerDelayTime'),  # noqa
    0x00209253: ('SQ', '1', "Respiratory Synchronization Sequence", '', 'RespiratorySynchronizationSequence'),  # noqa
    0x00209254: ('FD', '1', "Respiratory Interval Time", '', 'RespiratoryIntervalTime'),  # noqa
    0x00209255: ('FD', '1', "Nominal Respiratory Trigger Delay Time", '', 'NominalRespiratoryTriggerDelayTime'),  # noqa
    0x00209256: ('FD', '1', "Respiratory Trigger Delay Threshold", '', 'RespiratoryTriggerDelayThreshold'),  # noqa
    0x00209257: ('FD', '1', "Actual Respiratory Trigger Delay Time", '', 'ActualRespiratoryTriggerDelayTime'),  # noqa
    0x00209301: ('FD', '3', "Image Position (Volume)", '', 'ImagePositionVolume'),  # noqa
    0x00209302: ('FD', '6', "Image Orientation (Volume)", '', 'ImageOrientationVolume'),  # noqa
    0x00209307: ('CS', '1', "Ultrasound Acquisition Geometry", '', 'UltrasoundAcquisitionGeometry'),  # noqa
    0x00209308: ('FD', '3', "Apex Position", '', 'ApexPosition'),  # noqa
    0x00209309: ('FD', '16', "Volume to Transducer Mapping Matrix", '', 'VolumeToTransducerMappingMatrix'),  # noqa
    0x0020930A: ('FD', '16', "Volume to Table Mapping Matrix", '', 'VolumeToTableMappingMatrix'),  # noqa
    0x0020930B: ('CS', '1', "Volume to Transducer Relationship", '', 'VolumeToTransducerRelationship'),  # noqa
    0x0020930C: ('CS', '1', "Patient Frame of Reference Source", '', 'PatientFrameOfReferenceSource'),  # noqa
    0x0020930D: ('FD', '1', "Temporal Position Time Offset", '', 'TemporalPositionTimeOffset'),  # noqa
    0x0020930E: ('SQ', '1', "Plane Position (Volume) Sequence", '', 'PlanePositionVolumeSequence'),  # noqa
    0x0020930F: ('SQ', '1', "Plane Orientation (Volume) Sequence", '', 'PlaneOrientationVolumeSequence'),  # noqa
    0x00209310: ('SQ', '1', "Temporal Position Sequence", '', 'TemporalPositionSequence'),  # noqa
    0x00209311: ('CS', '1', "Dimension Organization Type", '', 'DimensionOrganizationType'),  # noqa
    0x00209312: ('UI', '1', "Volume Frame of Reference UID", '', 'VolumeFrameOfReferenceUID'),  # noqa
    0x00209313: ('UI', '1', "Table Frame of Reference UID", '', 'TableFrameOfReferenceUID'),  # noqa
    0x00209421: ('LO', '1', "Dimension Description Label", '', 'DimensionDescriptionLabel'),  # noqa
    0x00209450: ('SQ', '1', "Patient Orientation in Frame Sequence", '', 'PatientOrientationInFrameSequence'),  # noqa
    0x00209453: ('LO', '1', "Frame Label", '', 'FrameLabel'),  # noqa
    0x00209518: ('US', '1-n', "Acquisition Index", '', 'AcquisitionIndex'),  # noqa
    0x00209529: ('SQ', '1', "Contributing SOP Instances Reference Sequence", '', 'ContributingSOPInstancesReferenceSequence'),  # noqa
    0x00209536: ('US', '1', "Reconstruction Index", '', 'ReconstructionIndex'),  # noqa
    0x00220001: ('US', '1', "Light Path Filter Pass-Through Wavelength", '', 'LightPathFilterPassThroughWavelength'),  # noqa
    0x00220002: ('US', '2', "Light Path Filter Pass Band", '', 'LightPathFilterPassBand'),  # noqa
    0x00220003: ('US', '1', "Image Path Filter Pass-Through Wavelength", '', 'ImagePathFilterPassThroughWavelength'),  # noqa
    0x00220004: ('US', '2', "Image Path Filter Pass Band", '', 'ImagePathFilterPassBand'),  # noqa
    0x00220005: ('CS', '1', "Patient Eye Movement Commanded", '', 'PatientEyeMovementCommanded'),  # noqa
    0x00220006: ('SQ', '1', "Patient Eye Movement Command Code Sequence", '', 'PatientEyeMovementCommandCodeSequence'),  # noqa
    0x00220007: ('FL', '1', "Spherical Lens Power", '', 'SphericalLensPower'),  # noqa
    0x00220008: ('FL', '1', "Cylinder Lens Power", '', 'CylinderLensPower'),  # noqa
    0x00220009: ('FL', '1', "Cylinder Axis", '', 'CylinderAxis'),  # noqa
    0x0022000A: ('FL', '1', "Emmetropic Magnification", '', 'EmmetropicMagnification'),  # noqa
    0x0022000B: ('FL', '1', "Intra Ocular Pressure", '', 'IntraOcularPressure'),  # noqa
    0x0022000C: ('FL', '1', "Horizontal Field of View", '', 'HorizontalFieldOfView'),  # noqa
    0x0022000D: ('CS', '1', "Pupil Dilated", '', 'PupilDilated'),  # noqa
    0x0022000E: ('FL', '1', "Degree of Dilation", '', 'DegreeOfDilation'),  # noqa
    0x00220010: ('FL', '1', "Stereo Baseline Angle", '', 'StereoBaselineAngle'),  # noqa
    0x00220011: ('FL', '1', "Stereo Baseline Displacement", '', 'StereoBaselineDisplacement'),  # noqa
    0x00220012: ('FL', '1', "Stereo Horizontal Pixel Offset", '', 'StereoHorizontalPixelOffset'),  # noqa
    0x00220013: ('FL', '1', "Stereo Vertical Pixel Offset", '', 'StereoVerticalPixelOffset'),  # noqa
    0x00220014: ('FL', '1', "Stereo Rotation", '', 'StereoRotation'),  # noqa
    0x00220015: ('SQ', '1', "Acquisition Device Type Code Sequence", '', 'AcquisitionDeviceTypeCodeSequence'),  # noqa
    0x00220016: ('SQ', '1', "Illumination Type Code Sequence", '', 'IlluminationTypeCodeSequence'),  # noqa
    0x00220017: ('SQ', '1', "Light Path Filter Type Stack Code Sequence", '', 'LightPathFilterTypeStackCodeSequence'),  # noqa
    0x00220018: ('SQ', '1', "Image Path Filter Type Stack Code Sequence", '', 'ImagePathFilterTypeStackCodeSequence'),  # noqa
    0x00220019: ('SQ', '1', "Lenses Code Sequence", '', 'LensesCodeSequence'),  # noqa
    0x0022001A: ('SQ', '1', "Channel Description Code Sequence", '', 'ChannelDescriptionCodeSequence'),  # noqa
    0x0022001B: ('SQ', '1', "Refractive State Sequence", '', 'RefractiveStateSequence'),  # noqa
    0x0022001C: ('SQ', '1', "Mydriatic Agent Code Sequence", '', 'MydriaticAgentCodeSequence'),  # noqa
    0x0022001D: ('SQ', '1', "Relative Image Position Code Sequence", '', 'RelativeImagePositionCodeSequence'),  # noqa
    0x0022001E: ('FL', '1', "Camera Angle of View", '', 'CameraAngleOfView'),  # noqa
    0x00220020: ('SQ', '1', "Stereo Pairs Sequence", '', 'StereoPairsSequence'),  # noqa
    0x00220021: ('SQ', '1', "Left Image Sequence", '', 'LeftImageSequence'),  # noqa
    0x00220022: ('SQ', '1', "Right Image Sequence", '', 'RightImageSequence'),  # noqa
    0x00220028: ('CS', '1', "Stereo Pairs Present", '', 'StereoPairsPresent'),  # noqa
    0x00220030: ('FL', '1', "Axial Length of the Eye", '', 'AxialLengthOfTheEye'),  # noqa
    0x00220031: ('SQ', '1', "Ophthalmic Frame Location Sequence", '', 'OphthalmicFrameLocationSequence'),  # noqa
    0x00220032: ('FL', '2-2n', "Reference Coordinates", '', 'ReferenceCoordinates'),  # noqa
    0x00220035: ('FL', '1', "Depth Spatial Resolution", '', 'DepthSpatialResolution'),  # noqa
    0x00220036: ('FL', '1', "Maximum Depth Distortion", '', 'MaximumDepthDistortion'),  # noqa
    0x00220037: ('FL', '1', "Along-scan Spatial Resolution", '', 'AlongScanSpatialResolution'),  # noqa
    0x00220038: ('FL', '1', "Maximum Along-scan Distortion", '', 'MaximumAlongScanDistortion'),  # noqa
    0x00220039: ('CS', '1', "Ophthalmic Image Orientation", '', 'OphthalmicImageOrientation'),  # noqa
    0x00220041: ('FL', '1', "Depth of Transverse Image", '', 'DepthOfTransverseImage'),  # noqa
    0x00220042: ('SQ', '1', "Mydriatic Agent Concentration Units Sequence", '', 'MydriaticAgentConcentrationUnitsSequence'),  # noqa
    0x00220048: ('FL', '1', "Across-scan Spatial Resolution", '', 'AcrossScanSpatialResolution'),  # noqa
    0x00220049: ('FL', '1', "Maximum Across-scan Distortion", '', 'MaximumAcrossScanDistortion'),  # noqa
    0x0022004E: ('DS', '1', "Mydriatic Agent Concentration", '', 'MydriaticAgentConcentration'),  # noqa
    0x00220055: ('FL', '1', "Illumination Wave Length", '', 'IlluminationWaveLength'),  # noqa
    0x00220056: ('FL', '1', "Illumination Power", '', 'IlluminationPower'),  # noqa
    0x00220057: ('FL', '1', "Illumination Bandwidth", '', 'IlluminationBandwidth'),  # noqa
    0x00220058: ('SQ', '1', "Mydriatic Agent Sequence", '', 'MydriaticAgentSequence'),  # noqa
    0x00221007: ('SQ', '1', "Ophthalmic Axial Measurements Right Eye Sequence", '', 'OphthalmicAxialMeasurementsRightEyeSequence'),  # noqa
    0x00221008: ('SQ', '1', "Ophthalmic Axial Measurements Left Eye Sequence", '', 'OphthalmicAxialMeasurementsLeftEyeSequence'),  # noqa
    0x00221009: ('CS', '1', "Ophthalmic Axial Measurements Device Type", '', 'OphthalmicAxialMeasurementsDeviceType'),  # noqa
    0x00221010: ('CS', '1', "Ophthalmic Axial Length Measurements Type", '', 'OphthalmicAxialLengthMeasurementsType'),  # noqa
    0x00221012: ('SQ', '1', "Ophthalmic Axial Length Sequence", '', 'OphthalmicAxialLengthSequence'),  # noqa
    0x00221019: ('FL', '1', "Ophthalmic Axial Length", '', 'OphthalmicAxialLength'),  # noqa
    0x00221024: ('SQ', '1', "Lens Status Code Sequence", '', 'LensStatusCodeSequence'),  # noqa
    0x00221025: ('SQ', '1', "Vitreous Status Code Sequence", '', 'VitreousStatusCodeSequence'),  # noqa
    0x00221028: ('SQ', '1', "IOL Formula Code Sequence", '', 'IOLFormulaCodeSequence'),  # noqa
    0x00221029: ('LO', '1', "IOL Formula Detail", '', 'IOLFormulaDetail'),  # noqa
    0x00221033: ('FL', '1', "Keratometer Index", '', 'KeratometerIndex'),  # noqa
    0x00221035: ('SQ', '1', "Source of Ophthalmic Axial Length Code Sequence", '', 'SourceOfOphthalmicAxialLengthCodeSequence'),  # noqa
    0x00221037: ('FL', '1', "Target Refraction", '', 'TargetRefraction'),  # noqa
    0x00221039: ('CS', '1', "Refractive Procedure Occurred", '', 'RefractiveProcedureOccurred'),  # noqa
    0x00221040: ('SQ', '1', "Refractive Surgery Type Code Sequence", '', 'RefractiveSurgeryTypeCodeSequence'),  # noqa
    0x00221044: ('SQ', '1', "Ophthalmic Ultrasound Method Code Sequence", '', 'OphthalmicUltrasoundMethodCodeSequence'),  # noqa
    0x00221050: ('SQ', '1', "Ophthalmic Axial Length Measurements Sequence", '', 'OphthalmicAxialLengthMeasurementsSequence'),  # noqa
    0x00221053: ('FL', '1', "IOL Power", '', 'IOLPower'),  # noqa
    0x00221054: ('FL', '1', "Predicted Refractive Error", '', 'PredictedRefractiveError'),  # noqa
    0x00221059: ('FL', '1', "Ophthalmic Axial Length Velocity", '', 'OphthalmicAxialLengthVelocity'),  # noqa
    0x00221065: ('LO', '1', "Lens Status Description", '', 'LensStatusDescription'),  # noqa
    0x00221066: ('LO', '1', "Vitreous Status Description", '', 'VitreousStatusDescription'),  # noqa
    0x00221090: ('SQ', '1', "IOL Power Sequence", '', 'IOLPowerSequence'),  # noqa
    0x00221092: ('SQ', '1', "Lens Constant Sequence", '', 'LensConstantSequence'),  # noqa
    0x00221093: ('LO', '1', "IOL Manufacturer", '', 'IOLManufacturer'),  # noqa
    0x00221094: ('LO', '1', "Lens Constant Description", 'Retired', 'LensConstantDescription'),  # noqa
    0x00221095: ('LO', '1', "Implant Name", '', 'ImplantName'),  # noqa
    0x00221096: ('SQ', '1', "Keratometry Measurement Type Code Sequence", '', 'KeratometryMeasurementTypeCodeSequence'),  # noqa
    0x00221097: ('LO', '1', "Implant Part Number", '', 'ImplantPartNumber'),  # noqa
    0x00221100: ('SQ', '1', "Referenced Ophthalmic Axial Measurements Sequence", '', 'ReferencedOphthalmicAxialMeasurementsSequence'),  # noqa
    0x00221101: ('SQ', '1', "Ophthalmic Axial Length Measurements Segment Name Code Sequence", '', 'OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence'),  # noqa
    0x00221103: ('SQ', '1', "Refractive Error Before Refractive Surgery Code Sequence", '', 'RefractiveErrorBeforeRefractiveSurgeryCodeSequence'),  # noqa
    0x00221121: ('FL', '1', "IOL Power For Exact Emmetropia", '', 'IOLPowerForExactEmmetropia'),  # noqa
    0x00221122: ('FL', '1', "IOL Power For Exact Target Refraction", '', 'IOLPowerForExactTargetRefraction'),  # noqa
    0x00221125: ('SQ', '1', "Anterior Chamber Depth Definition Code Sequence", '', 'AnteriorChamberDepthDefinitionCodeSequence'),  # noqa
    0x00221127: ('SQ', '1', "Lens Thickness Sequence", '', 'LensThicknessSequence'),  # noqa
    0x00221128: ('SQ', '1', "Anterior Chamber Depth Sequence", '', 'AnteriorChamberDepthSequence'),  # noqa
    0x00221130: ('FL', '1', "Lens Thickness", '', 'LensThickness'),  # noqa
    0x00221131: ('FL', '1', "Anterior Chamber Depth", '', 'AnteriorChamberDepth'),  # noqa
    0x00221132: ('SQ', '1', "Source of Lens Thickness Data Code Sequence", '', 'SourceOfLensThicknessDataCodeSequence'),  # noqa
    0x00221133: ('SQ', '1', "Source of Anterior Chamber Depth Data Code Sequence", '', 'SourceOfAnteriorChamberDepthDataCodeSequence'),  # noqa
    0x00221134: ('SQ', '1', "Source of Refractive Measurements Sequence", '', 'SourceOfRefractiveMeasurementsSequence'),  # noqa
    0x00221135: ('SQ', '1', "Source of Refractive Measurements Code Sequence", '', 'SourceOfRefractiveMeasurementsCodeSequence'),  # noqa
    0x00221140: ('CS', '1', "Ophthalmic Axial Length Measurement Modified", '', 'OphthalmicAxialLengthMeasurementModified'),  # noqa
    0x00221150: ('SQ', '1', "Ophthalmic Axial Length Data Source Code Sequence", '', 'OphthalmicAxialLengthDataSourceCodeSequence'),  # noqa
    0x00221153: ('SQ', '1', "Ophthalmic Axial Length Acquisition Method Code Sequence", 'Retired', 'OphthalmicAxialLengthAcquisitionMethodCodeSequence'),  # noqa
    0x00221155: ('FL', '1', "Signal to Noise Ratio", '', 'SignalToNoiseRatio'),  # noqa
    0x00221159: ('LO', '1', "Ophthalmic Axial Length Data Source Description", '', 'OphthalmicAxialLengthDataSourceDescription'),  # noqa
    0x00221210: ('SQ', '1', "Ophthalmic Axial Length Measurements Total Length Sequence", '', 'OphthalmicAxialLengthMeasurementsTotalLengthSequence'),  # noqa
    0x00221211: ('SQ', '1', "Ophthalmic Axial Length Measurements Segmental Length Sequence", '', 'OphthalmicAxialLengthMeasurementsSegmentalLengthSequence'),  # noqa
    0x00221212: ('SQ', '1', "Ophthalmic Axial Length Measurements Length Summation Sequence", '', 'OphthalmicAxialLengthMeasurementsLengthSummationSequence'),  # noqa
    0x00221220: ('SQ', '1', "Ultrasound Ophthalmic Axial Length Measurements Sequence", '', 'UltrasoundOphthalmicAxialLengthMeasurementsSequence'),  # noqa
    0x00221225: ('SQ', '1', "Optical Ophthalmic Axial Length Measurements Sequence", '', 'OpticalOphthalmicAxialLengthMeasurementsSequence'),  # noqa
    0x00221230: ('SQ', '1', "Ultrasound Selected Ophthalmic Axial Length Sequence", '', 'UltrasoundSelectedOphthalmicAxialLengthSequence'),  # noqa
    0x00221250: ('SQ', '1', "Ophthalmic Axial Length Selection Method Code Sequence", '', 'OphthalmicAxialLengthSelectionMethodCodeSequence'),  # noqa
    0x00221255: ('SQ', '1', "Optical Selected Ophthalmic Axial Length Sequence", '', 'OpticalSelectedOphthalmicAxialLengthSequence'),  # noqa
    0x00221257: ('SQ', '1', "Selected Segmental Ophthalmic Axial Length Sequence", '', 'SelectedSegmentalOphthalmicAxialLengthSequence'),  # noqa
    0x00221260: ('SQ', '1', "Selected Total Ophthalmic Axial Length Sequence", '', 'SelectedTotalOphthalmicAxialLengthSequence'),  # noqa
    0x00221262: ('SQ', '1', "Ophthalmic Axial Length Quality Metric Sequence", '', 'OphthalmicAxialLengthQualityMetricSequence'),  # noqa
    0x00221265: ('SQ', '1', "Ophthalmic Axial Length Quality Metric Type Code Sequence", 'Retired', 'OphthalmicAxialLengthQualityMetricTypeCodeSequence'),  # noqa
    0x00221273: ('LO', '1', "Ophthalmic Axial Length Quality Metric Type Description", 'Retired', 'OphthalmicAxialLengthQualityMetricTypeDescription'),  # noqa
    0x00221300: ('SQ', '1', "Intraocular Lens Calculations Right Eye Sequence", '', 'IntraocularLensCalculationsRightEyeSequence'),  # noqa
    0x00221310: ('SQ', '1', "Intraocular Lens Calculations Left Eye Sequence", '', 'IntraocularLensCalculationsLeftEyeSequence'),  # noqa
    0x00221330: ('SQ', '1', "Referenced Ophthalmic Axial Length Measurement QC Image Sequence", '', 'ReferencedOphthalmicAxialLengthMeasurementQCImageSequence'),  # noqa
    0x00221415: ('CS', '1', "Ophthalmic Mapping Device Type", '', 'OphthalmicMappingDeviceType'),  # noqa
    0x00221420: ('SQ', '1', "Acquisition Method Code Sequence", '', 'AcquisitionMethodCodeSequence'),  # noqa
    0x00221423: ('SQ', '1', "Acquisition Method Algorithm Sequence", '', 'AcquisitionMethodAlgorithmSequence'),  # noqa
    0x00221436: ('SQ', '1', "Ophthalmic Thickness Map Type Code Sequence", '', 'OphthalmicThicknessMapTypeCodeSequence'),  # noqa
    0x00221443: ('SQ', '1', "Ophthalmic Thickness Mapping Normals Sequence", '', 'OphthalmicThicknessMappingNormalsSequence'),  # noqa
    0x00221445: ('SQ', '1', "Retinal Thickness Definition Code Sequence", '', 'RetinalThicknessDefinitionCodeSequence'),  # noqa
    0x00221450: ('SQ', '1', "Pixel Value Mapping to Coded Concept Sequence", '', 'PixelValueMappingToCodedConceptSequence'),  # noqa
    0x00221452: ('US or SS', '1', "Mapped Pixel Value", '', 'MappedPixelValue'),  # noqa
    0x00221454: ('LO', '1', "Pixel Value Mapping Explanation", '', 'PixelValueMappingExplanation'),  # noqa
    0x00221458: ('SQ', '1', "Ophthalmic Thickness Map Quality Threshold Sequence", '', 'OphthalmicThicknessMapQualityThresholdSequence'),  # noqa
    0x00221460: ('FL', '1', "Ophthalmic Thickness Map Threshold Quality Rating", '', 'OphthalmicThicknessMapThresholdQualityRating'),  # noqa
    0x00221463: ('FL', '2', "Anatomic Structure Reference Point", '', 'AnatomicStructureReferencePoint'),  # noqa
    0x00221465: ('SQ', '1', "Registration to Localizer Sequence", '', 'RegistrationToLocalizerSequence'),  # noqa
    0x00221466: ('CS', '1', "Registered Localizer Units", '', 'RegisteredLocalizerUnits'),  # noqa
    0x00221467: ('FL', '2', "Registered Localizer Top Left Hand Corner", '', 'RegisteredLocalizerTopLeftHandCorner'),  # noqa
    0x00221468: ('FL', '2', "Registered Localizer Bottom Right Hand Corner", '', 'RegisteredLocalizerBottomRightHandCorner'),  # noqa
    0x00221470: ('SQ', '1', "Ophthalmic Thickness Map Quality Rating Sequence", '', 'OphthalmicThicknessMapQualityRatingSequence'),  # noqa
    0x00221472: ('SQ', '1', "Relevant OPT Attributes Sequence", '', 'RelevantOPTAttributesSequence'),  # noqa
    0x00221512: ('SQ', '1', "Transformation Method Code Sequence", '', 'TransformationMethodCodeSequence'),  # noqa
    0x00221513: ('SQ', '1', "Transformation Algorithm Sequence", '', 'TransformationAlgorithmSequence'),  # noqa
    0x00221515: ('CS', '1', "Ophthalmic Axial Length Method", '', 'OphthalmicAxialLengthMethod'),  # noqa
    0x00221517: ('FL', '1', "Ophthalmic FOV", '', 'OphthalmicFOV'),  # noqa
    0x00221518: ('SQ', '1', "Two Dimensional to Three Dimensional Map Sequence", '', 'TwoDimensionalToThreeDimensionalMapSequence'),  # noqa
    0x00221525: ('SQ', '1', "Wide Field Ophthalmic Photography Quality Rating Sequence", '', 'WideFieldOphthalmicPhotographyQualityRatingSequence'),  # noqa
    0x00221526: ('SQ', '1', "Wide Field Ophthalmic Photography Quality Threshold Sequence", '', 'WideFieldOphthalmicPhotographyQualityThresholdSequence'),  # noqa
    0x00221527: ('FL', '1', "Wide Field Ophthalmic Photography Threshold Quality Rating", '', 'WideFieldOphthalmicPhotographyThresholdQualityRating'),  # noqa
    0x00221528: ('FL', '1', "X Coordinates Center Pixel View Angle", '', 'XCoordinatesCenterPixelViewAngle'),  # noqa
    0x00221529: ('FL', '1', "Y Coordinates Center Pixel View Angle", '', 'YCoordinatesCenterPixelViewAngle'),  # noqa
    0x00221530: ('UL', '1', "Number of Map Points", '', 'NumberOfMapPoints'),  # noqa
    0x00221531: ('OF', '1', "Two Dimensional to Three Dimensional Map Data", '', 'TwoDimensionalToThreeDimensionalMapData'),  # noqa
    0x00221612: ('SQ', '1', "Derivation Algorithm Sequence", '', 'DerivationAlgorithmSequence'),  # noqa
    0x00221615: ('SQ', '1', "Ophthalmic Image Type Code Sequence", '', 'OphthalmicImageTypeCodeSequence'),  # noqa
    0x00221616: ('LO', '1', "Ophthalmic Image Type Description", '', 'OphthalmicImageTypeDescription'),  # noqa
    0x00221618: ('SQ', '1', "Scan Pattern Type Code Sequence", '', 'ScanPatternTypeCodeSequence'),  # noqa
    0x00221620: ('SQ', '1', "Referenced Surface Mesh Identification Sequence", '', 'ReferencedSurfaceMeshIdentificationSequence'),  # noqa
    0x00221622: ('CS', '1', "Ophthalmic Volumetric Properties Flag", '', 'OphthalmicVolumetricPropertiesFlag'),  # noqa
    0x00221624: ('FL', '1', "Ophthalmic Anatomic Reference Point X-Coordinate", '', 'OphthalmicAnatomicReferencePointXCoordinate'),  # noqa
    0x00221626: ('FL', '1', "Ophthalmic Anatomic Reference Point Y-Coordinate", '', 'OphthalmicAnatomicReferencePointYCoordinate'),  # noqa
    0x00221628: ('SQ', '1', "Ophthalmic En Face Image Quality Rating Sequence", '', 'OphthalmicEnFaceImageQualityRatingSequence'),  # noqa
    0x00221630: ('DS', '1', "Quality Threshold", '', 'QualityThreshold'),  # noqa
    0x00221640: ('SQ', '1', "OCT B-scan Analysis Acquisition Parameters Sequence", '', 'OCTBscanAnalysisAcquisitionParametersSequence'),  # noqa
    0x00221642: ('UL', '1', "Number of B-scans Per Frame", '', 'NumberofBscansPerFrame'),  # noqa
    0x00221643: ('FL', '1', "B-scan Slab Thickness", '', 'BscanSlabThickness'),  # noqa
    0x00221644: ('FL', '1', "Distance Between B-scan Slabs", '', 'DistanceBetweenBscanSlabs'),  # noqa
    0x00221645: ('FL', '1', "B-scan Cycle Time", '', 'BscanCycleTime'),  # noqa
    0x00221646: ('FL', '1-n', "B-scan Cycle Time Vector", '', 'BscanCycleTimeVector'),  # noqa
    0x00221649: ('FL', '1', "A-scan Rate", '', 'AscanRate'),  # noqa
    0x00221650: ('FL', '1', "B-scan Rate", '', 'BscanRate'),  # noqa
    0x00221658: ('UL', '1', "Surface Mesh Z-Pixel Offset", '', 'SurfaceMeshZPixelOffset'),  # noqa
    0x00240010: ('FL', '1', "Visual Field Horizontal Extent", '', 'VisualFieldHorizontalExtent'),  # noqa
    0x00240011: ('FL', '1', "Visual Field Vertical Extent", '', 'VisualFieldVerticalExtent'),  # noqa
    0x00240012: ('CS', '1', "Visual Field Shape", '', 'VisualFieldShape'),  # noqa
    0x00240016: ('SQ', '1', "Screening Test Mode Code Sequence", '', 'ScreeningTestModeCodeSequence'),  # noqa
    0x00240018: ('FL', '1', "Maximum Stimulus Luminance", '', 'MaximumStimulusLuminance'),  # noqa
    0x00240020: ('FL', '1', "Background Luminance", '', 'BackgroundLuminance'),  # noqa
    0x00240021: ('SQ', '1', "Stimulus Color Code Sequence", '', 'StimulusColorCodeSequence'),  # noqa
    0x00240024: ('SQ', '1', "Background Illumination Color Code Sequence", '', 'BackgroundIlluminationColorCodeSequence'),  # noqa
    0x00240025: ('FL', '1', "Stimulus Area", '', 'StimulusArea'),  # noqa
    0x00240028: ('FL', '1', "Stimulus Presentation Time", '', 'StimulusPresentationTime'),  # noqa
    0x00240032: ('SQ', '1', "Fixation Sequence", '', 'FixationSequence'),  # noqa
    0x00240033: ('SQ', '1', "Fixation Monitoring Code Sequence", '', 'FixationMonitoringCodeSequence'),  # noqa
    0x00240034: ('SQ', '1', "Visual Field Catch Trial Sequence", '', 'VisualFieldCatchTrialSequence'),  # noqa
    0x00240035: ('US', '1', "Fixation Checked Quantity", '', 'FixationCheckedQuantity'),  # noqa
    0x00240036: ('US', '1', "Patient Not Properly Fixated Quantity", '', 'PatientNotProperlyFixatedQuantity'),  # noqa
    0x00240037: ('CS', '1', "Presented Visual Stimuli Data Flag", '', 'PresentedVisualStimuliDataFlag'),  # noqa
    0x00240038: ('US', '1', "Number of Visual Stimuli", '', 'NumberOfVisualStimuli'),  # noqa
    0x00240039: ('CS', '1', "Excessive Fixation Losses Data Flag", '', 'ExcessiveFixationLossesDataFlag'),  # noqa
    0x00240040: ('CS', '1', "Excessive Fixation Losses", '', 'ExcessiveFixationLosses'),  # noqa
    0x00240042: ('US', '1', "Stimuli Retesting Quantity", '', 'StimuliRetestingQuantity'),  # noqa
    0x00240044: ('LT', '1', "Comments on Patient's Performance of Visual Field", '', 'CommentsOnPatientPerformanceOfVisualField'),  # noqa
    0x00240045: ('CS', '1', "False Negatives Estimate Flag", '', 'FalseNegativesEstimateFlag'),  # noqa
    0x00240046: ('FL', '1', "False Negatives Estimate", '', 'FalseNegativesEstimate'),  # noqa
    0x00240048: ('US', '1', "Negative Catch Trials Quantity", '', 'NegativeCatchTrialsQuantity'),  # noqa
    0x00240050: ('US', '1', "False Negatives Quantity", '', 'FalseNegativesQuantity'),  # noqa
    0x00240051: ('CS', '1', "Excessive False Negatives Data Flag", '', 'ExcessiveFalseNegativesDataFlag'),  # noqa
    0x00240052: ('CS', '1', "Excessive False Negatives", '', 'ExcessiveFalseNegatives'),  # noqa
    0x00240053: ('CS', '1', "False Positives Estimate Flag", '', 'FalsePositivesEstimateFlag'),  # noqa
    0x00240054: ('FL', '1', "False Positives Estimate", '', 'FalsePositivesEstimate'),  # noqa
    0x00240055: ('CS', '1', "Catch Trials Data Flag", '', 'CatchTrialsDataFlag'),  # noqa
    0x00240056: ('US', '1', "Positive Catch Trials Quantity", '', 'PositiveCatchTrialsQuantity'),  # noqa
    0x00240057: ('CS', '1', "Test Point Normals Data Flag", '', 'TestPointNormalsDataFlag'),  # noqa
    0x00240058: ('SQ', '1', "Test Point Normals Sequence", '', 'TestPointNormalsSequence'),  # noqa
    0x00240059: ('CS', '1', "Global Deviation Probability Normals Flag", '', 'GlobalDeviationProbabilityNormalsFlag'),  # noqa
    0x00240060: ('US', '1', "False Positives Quantity", '', 'FalsePositivesQuantity'),  # noqa
    0x00240061: ('CS', '1', "Excessive False Positives Data Flag", '', 'ExcessiveFalsePositivesDataFlag'),  # noqa
    0x00240062: ('CS', '1', "Excessive False Positives", '', 'ExcessiveFalsePositives'),  # noqa
    0x00240063: ('CS', '1', "Visual Field Test Normals Flag", '', 'VisualFieldTestNormalsFlag'),  # noqa
    0x00240064: ('SQ', '1', "Results Normals Sequence", '', 'ResultsNormalsSequence'),  # noqa
    0x00240065: ('SQ', '1', "Age Corrected Sensitivity Deviation Algorithm Sequence", '', 'AgeCorrectedSensitivityDeviationAlgorithmSequence'),  # noqa
    0x00240066: ('FL', '1', "Global Deviation From Normal", '', 'GlobalDeviationFromNormal'),  # noqa
    0x00240067: ('SQ', '1', "Generalized Defect Sensitivity Deviation Algorithm Sequence", '', 'GeneralizedDefectSensitivityDeviationAlgorithmSequence'),  # noqa
    0x00240068: ('FL', '1', "Localized Deviation From Normal", '', 'LocalizedDeviationFromNormal'),  # noqa
    0x00240069: ('LO', '1', "Patient Reliability Indicator", '', 'PatientReliabilityIndicator'),  # noqa
    0x00240070: ('FL', '1', "Visual Field Mean Sensitivity", '', 'VisualFieldMeanSensitivity'),  # noqa
    0x00240071: ('FL', '1', "Global Deviation Probability", '', 'GlobalDeviationProbability'),  # noqa
    0x00240072: ('CS', '1', "Local Deviation Probability Normals Flag", '', 'LocalDeviationProbabilityNormalsFlag'),  # noqa
    0x00240073: ('FL', '1', "Localized Deviation Probability", '', 'LocalizedDeviationProbability'),  # noqa
    0x00240074: ('CS', '1', "Short Term Fluctuation Calculated", '', 'ShortTermFluctuationCalculated'),  # noqa
    0x00240075: ('FL', '1', "Short Term Fluctuation", '', 'ShortTermFluctuation'),  # noqa
    0x00240076: ('CS', '1', "Short Term Fluctuation Probability Calculated", '', 'ShortTermFluctuationProbabilityCalculated'),  # noqa
    0x00240077: ('FL', '1', "Short Term Fluctuation Probability", '', 'ShortTermFluctuationProbability'),  # noqa
    0x00240078: ('CS', '1', "Corrected Localized Deviation From Normal Calculated", '', 'CorrectedLocalizedDeviationFromNormalCalculated'),  # noqa
    0x00240079: ('FL', '1', "Corrected Localized Deviation From Normal", '', 'CorrectedLocalizedDeviationFromNormal'),  # noqa
    0x00240080: ('CS', '1', "Corrected Localized Deviation From Normal Probability Calculated", '', 'CorrectedLocalizedDeviationFromNormalProbabilityCalculated'),  # noqa
    0x00240081: ('FL', '1', "Corrected Localized Deviation From Normal Probability", '', 'CorrectedLocalizedDeviationFromNormalProbability'),  # noqa
    0x00240083: ('SQ', '1', "Global Deviation Probability Sequence", '', 'GlobalDeviationProbabilitySequence'),  # noqa
    0x00240085: ('SQ', '1', "Localized Deviation Probability Sequence", '', 'LocalizedDeviationProbabilitySequence'),  # noqa
    0x00240086: ('CS', '1', "Foveal Sensitivity Measured", '', 'FovealSensitivityMeasured'),  # noqa
    0x00240087: ('FL', '1', "Foveal Sensitivity", '', 'FovealSensitivity'),  # noqa
    0x00240088: ('FL', '1', "Visual Field Test Duration", '', 'VisualFieldTestDuration'),  # noqa
    0x00240089: ('SQ', '1', "Visual Field Test Point Sequence", '', 'VisualFieldTestPointSequence'),  # noqa
    0x00240090: ('FL', '1', "Visual Field Test Point X-Coordinate", '', 'VisualFieldTestPointXCoordinate'),  # noqa
    0x00240091: ('FL', '1', "Visual Field Test Point Y-Coordinate", '', 'VisualFieldTestPointYCoordinate'),  # noqa
    0x00240092: ('FL', '1', "Age Corrected Sensitivity Deviation Value", '', 'AgeCorrectedSensitivityDeviationValue'),  # noqa
    0x00240093: ('CS', '1', "Stimulus Results", '', 'StimulusResults'),  # noqa
    0x00240094: ('FL', '1', "Sensitivity Value", '', 'SensitivityValue'),  # noqa
    0x00240095: ('CS', '1', "Retest Stimulus Seen", '', 'RetestStimulusSeen'),  # noqa
    0x00240096: ('FL', '1', "Retest Sensitivity Value", '', 'RetestSensitivityValue'),  # noqa
    0x00240097: ('SQ', '1', "Visual Field Test Point Normals Sequence", '', 'VisualFieldTestPointNormalsSequence'),  # noqa
    0x00240098: ('FL', '1', "Quantified Defect", '', 'QuantifiedDefect'),  # noqa
    0x00240100: ('FL', '1', "Age Corrected Sensitivity Deviation Probability Value", '', 'AgeCorrectedSensitivityDeviationProbabilityValue'),  # noqa
    0x00240102: ('CS', '1', "Generalized Defect Corrected Sensitivity Deviation Flag", '', 'GeneralizedDefectCorrectedSensitivityDeviationFlag'),  # noqa
    0x00240103: ('FL', '1', "Generalized Defect Corrected Sensitivity Deviation Value", '', 'GeneralizedDefectCorrectedSensitivityDeviationValue'),  # noqa
    0x00240104: ('FL', '1', "Generalized Defect Corrected Sensitivity Deviation Probability Value", '', 'GeneralizedDefectCorrectedSensitivityDeviationProbabilityValue'),  # noqa
    0x00240105: ('FL', '1', "Minimum Sensitivity Value", '', 'MinimumSensitivityValue'),  # noqa
    0x00240106: ('CS', '1', "Blind Spot Localized", '', 'BlindSpotLocalized'),  # noqa
    0x00240107: ('FL', '1', "Blind Spot X-Coordinate", '', 'BlindSpotXCoordinate'),  # noqa
    0x00240108: ('FL', '1', "Blind Spot Y-Coordinate", '', 'BlindSpotYCoordinate'),  # noqa
    0x00240110: ('SQ', '1', "Visual Acuity Measurement Sequence", '', 'VisualAcuityMeasurementSequence'),  # noqa
    0x00240112: ('SQ', '1', "Refractive Parameters Used on Patient Sequence", '', 'RefractiveParametersUsedOnPatientSequence'),  # noqa
    0x00240113: ('CS', '1', "Measurement Laterality", '', 'MeasurementLaterality'),  # noqa
    0x00240114: ('SQ', '1', "Ophthalmic Patient Clinical Information Left Eye Sequence", '', 'OphthalmicPatientClinicalInformationLeftEyeSequence'),  # noqa
    0x00240115: ('SQ', '1', "Ophthalmic Patient Clinical Information Right Eye Sequence", '', 'OphthalmicPatientClinicalInformationRightEyeSequence'),  # noqa
    0x00240117: ('CS', '1', "Foveal Point Normative Data Flag", '', 'FovealPointNormativeDataFlag'),  # noqa
    0x00240118: ('FL', '1', "Foveal Point Probability Value", '', 'FovealPointProbabilityValue'),  # noqa
    0x00240120: ('CS', '1', "Screening Baseline Measured", '', 'ScreeningBaselineMeasured'),  # noqa
    0x00240122: ('SQ', '1', "Screening Baseline Measured Sequence", '', 'ScreeningBaselineMeasuredSequence'),  # noqa
    0x00240124: ('CS', '1', "Screening Baseline Type", '', 'ScreeningBaselineType'),  # noqa
    0x00240126: ('FL', '1', "Screening Baseline Value", '', 'ScreeningBaselineValue'),  # noqa
    0x00240202: ('LO', '1', "Algorithm Source", '', 'AlgorithmSource'),  # noqa
    0x00240306: ('LO', '1', "Data Set Name", '', 'DataSetName'),  # noqa
    0x00240307: ('LO', '1', "Data Set Version", '', 'DataSetVersion'),  # noqa
    0x00240308: ('LO', '1', "Data Set Source", '', 'DataSetSource'),  # noqa
    0x00240309: ('LO', '1', "Data Set Description", '', 'DataSetDescription'),  # noqa
    0x00240317: ('SQ', '1', "Visual Field Test Reliability Global Index Sequence", '', 'VisualFieldTestReliabilityGlobalIndexSequence'),  # noqa
    0x00240320: ('SQ', '1', "Visual Field Global Results Index Sequence", '', 'VisualFieldGlobalResultsIndexSequence'),  # noqa
    0x00240325: ('SQ', '1', "Data Observation Sequence", '', 'DataObservationSequence'),  # noqa
    0x00240338: ('CS', '1', "Index Normals Flag", '', 'IndexNormalsFlag'),  # noqa
    0x00240341: ('FL', '1', "Index Probability", '', 'IndexProbability'),  # noqa
    0x00240344: ('SQ', '1', "Index Probability Sequence", '', 'IndexProbabilitySequence'),  # noqa
    0x00280002: ('US', '1', "Samples per Pixel", '', 'SamplesPerPixel'),  # noqa
    0x00280003: ('US', '1', "Samples per Pixel Used", '', 'SamplesPerPixelUsed'),  # noqa
    0x00280004: ('CS', '1', "Photometric Interpretation", '', 'PhotometricInterpretation'),  # noqa
    0x00280005: ('US', '1', "Image Dimensions", 'Retired', 'ImageDimensions'),  # noqa
    0x00280006: ('US', '1', "Planar Configuration", '', 'PlanarConfiguration'),  # noqa
    0x00280008: ('IS', '1', "Number of Frames", '', 'NumberOfFrames'),  # noqa
    0x00280009: ('AT', '1-n', "Frame Increment Pointer", '', 'FrameIncrementPointer'),  # noqa
    0x0028000A: ('AT', '1-n', "Frame Dimension Pointer", '', 'FrameDimensionPointer'),  # noqa
    0x00280010: ('US', '1', "Rows", '', 'Rows'),  # noqa
    0x00280011: ('US', '1', "Columns", '', 'Columns'),  # noqa
    0x00280012: ('US', '1', "Planes", 'Retired', 'Planes'),  # noqa
    0x00280014: ('US', '1', "Ultrasound Color Data Present", '', 'UltrasoundColorDataPresent'),  # noqa
    0x00280020: ('OB', '1', "Retired-blank", 'Retired', ''),  # noqa
    0x00280030: ('DS', '2', "Pixel Spacing", '', 'PixelSpacing'),  # noqa
    0x00280031: ('DS', '2', "Zoom Factor", '', 'ZoomFactor'),  # noqa
    0x00280032: ('DS', '2', "Zoom Center", '', 'ZoomCenter'),  # noqa
    0x00280034: ('IS', '2', "Pixel Aspect Ratio", '', 'PixelAspectRatio'),  # noqa
    0x00280040: ('CS', '1', "Image Format", 'Retired', 'ImageFormat'),  # noqa
    0x00280050: ('LO', '1-n', "Manipulated Image", 'Retired', 'ManipulatedImage'),  # noqa
    0x00280051: ('CS', '1-n', "Corrected Image", '', 'CorrectedImage'),  # noqa
    0x0028005F: ('LO', '1', "Compression Recognition Code", 'Retired', 'CompressionRecognitionCode'),  # noqa
    0x00280060: ('CS', '1', "Compression Code", 'Retired', 'CompressionCode'),  # noqa
    0x00280061: ('SH', '1', "Compression Originator", 'Retired', 'CompressionOriginator'),  # noqa
    0x00280062: ('LO', '1', "Compression Label", 'Retired', 'CompressionLabel'),  # noqa
    0x00280063: ('SH', '1', "Compression Description", 'Retired', 'CompressionDescription'),  # noqa
    0x00280065: ('CS', '1-n', "Compression Sequence", 'Retired', 'CompressionSequence'),  # noqa
    0x00280066: ('AT', '1-n', "Compression Step Pointers", 'Retired', 'CompressionStepPointers'),  # noqa
    0x00280068: ('US', '1', "Repeat Interval", 'Retired', 'RepeatInterval'),  # noqa
    0x00280069: ('US', '1', "Bits Grouped", 'Retired', 'BitsGrouped'),  # noqa
    0x00280070: ('US', '1-n', "Perimeter Table", 'Retired', 'PerimeterTable'),  # noqa
    0x00280071: ('US or SS', '1', "Perimeter Value", 'Retired', 'PerimeterValue'),  # noqa
    0x00280080: ('US', '1', "Predictor Rows", 'Retired', 'PredictorRows'),  # noqa
    0x00280081: ('US', '1', "Predictor Columns", 'Retired', 'PredictorColumns'),  # noqa
    0x00280082: ('US', '1-n', "Predictor Constants", 'Retired', 'PredictorConstants'),  # noqa
    0x00280090: ('CS', '1', "Blocked Pixels", 'Retired', 'BlockedPixels'),  # noqa
    0x00280091: ('US', '1', "Block Rows", 'Retired', 'BlockRows'),  # noqa
    0x00280092: ('US', '1', "Block Columns", 'Retired', 'BlockColumns'),  # noqa
    0x00280093: ('US', '1', "Row Overlap", 'Retired', 'RowOverlap'),  # noqa
    0x00280094: ('US', '1', "Column Overlap", 'Retired', 'ColumnOverlap'),  # noqa
    0x00280100: ('US', '1', "Bits Allocated", '', 'BitsAllocated'),  # noqa
    0x00280101: ('US', '1', "Bits Stored", '', 'BitsStored'),  # noqa
    0x00280102: ('US', '1', "High Bit", '', 'HighBit'),  # noqa
    0x00280103: ('US', '1', "Pixel Representation", '', 'PixelRepresentation'),  # noqa
    0x00280104: ('US or SS', '1', "Smallest Valid Pixel Value", 'Retired', 'SmallestValidPixelValue'),  # noqa
    0x00280105: ('US or SS', '1', "Largest Valid Pixel Value", 'Retired', 'LargestValidPixelValue'),  # noqa
    0x00280106: ('US or SS', '1', "Smallest Image Pixel Value", '', 'SmallestImagePixelValue'),  # noqa
    0x00280107: ('US or SS', '1', "Largest Image Pixel Value", '', 'LargestImagePixelValue'),  # noqa
    0x00280108: ('US or SS', '1', "Smallest Pixel Value in Series", '', 'SmallestPixelValueInSeries'),  # noqa
    0x00280109: ('US or SS', '1', "Largest Pixel Value in Series", '', 'LargestPixelValueInSeries'),  # noqa
    0x00280110: ('US or SS', '1', "Smallest Image Pixel Value in Plane", 'Retired', 'SmallestImagePixelValueInPlane'),  # noqa
    0x00280111: ('US or SS', '1', "Largest Image Pixel Value in Plane", 'Retired', 'LargestImagePixelValueInPlane'),  # noqa
    0x00280120: ('US or SS', '1', "Pixel Padding Value", '', 'PixelPaddingValue'),  # noqa
    0x00280121: ('US or SS', '1', "Pixel Padding Range Limit", '', 'PixelPaddingRangeLimit'),  # noqa
    0x00280122: ('FL', '1', "Float Pixel Padding Value", '', 'FloatPixelPaddingValue'),  # noqa
    0x00280123: ('FD', '1', "Double Float Pixel Padding Value", '', 'DoubleFloatPixelPaddingValue'),  # noqa
    0x00280124: ('FL', '1', "Float Pixel Padding Range Limit", '', 'FloatPixelPaddingRangeLimit'),  # noqa
    0x00280125: ('FD', '1', "Double Float Pixel Padding Range Limit", '', 'DoubleFloatPixelPaddingRangeLimit'),  # noqa
    0x00280200: ('US', '1', "Image Location", 'Retired', 'ImageLocation'),  # noqa
    0x00280300: ('CS', '1', "Quality Control Image", '', 'QualityControlImage'),  # noqa
    0x00280301: ('CS', '1', "Burned In Annotation", '', 'BurnedInAnnotation'),  # noqa
    0x00280302: ('CS', '1', "Recognizable Visual Features", '', 'RecognizableVisualFeatures'),  # noqa
    0x00280303: ('CS', '1', "Longitudinal Temporal Information Modified", '', 'LongitudinalTemporalInformationModified'),  # noqa
    0x00280304: ('UI', '1', "Referenced Color Palette Instance UID", '', 'ReferencedColorPaletteInstanceUID'),  # noqa
    0x00280400: ('LO', '1', "Transform Label", 'Retired', 'TransformLabel'),  # noqa
    0x00280401: ('LO', '1', "Transform Version Number", 'Retired', 'TransformVersionNumber'),  # noqa
    0x00280402: ('US', '1', "Number of Transform Steps", 'Retired', 'NumberOfTransformSteps'),  # noqa
    0x00280403: ('LO', '1-n', "Sequence of Compressed Data", 'Retired', 'SequenceOfCompressedData'),  # noqa
    0x00280404: ('AT', '1-n', "Details of Coefficients", 'Retired', 'DetailsOfCoefficients'),  # noqa
    0x00280700: ('LO', '1', "DCT Label", 'Retired', 'DCTLabel'),  # noqa
    0x00280701: ('CS', '1-n', "Data Block Description", 'Retired', 'DataBlockDescription'),  # noqa
    0x00280702: ('AT', '1-n', "Data Block", 'Retired', 'DataBlock'),  # noqa
    0x00280710: ('US', '1', "Normalization Factor Format", 'Retired', 'NormalizationFactorFormat'),  # noqa
    0x00280720: ('US', '1', "Zonal Map Number Format", 'Retired', 'ZonalMapNumberFormat'),  # noqa
    0x00280721: ('AT', '1-n', "Zonal Map Location", 'Retired', 'ZonalMapLocation'),  # noqa
    0x00280722: ('US', '1', "Zonal Map Format", 'Retired', 'ZonalMapFormat'),  # noqa
    0x00280730: ('US', '1', "Adaptive Map Format", 'Retired', 'AdaptiveMapFormat'),  # noqa
    0x00280740: ('US', '1', "Code Number Format", 'Retired', 'CodeNumberFormat'),  # noqa
    0x00280A02: ('CS', '1', "Pixel Spacing Calibration Type", '', 'PixelSpacingCalibrationType'),  # noqa
    0x00280A04: ('LO', '1', "Pixel Spacing Calibration Description", '', 'PixelSpacingCalibrationDescription'),  # noqa
    0x00281040: ('CS', '1', "Pixel Intensity Relationship", '', 'PixelIntensityRelationship'),  # noqa
    0x00281041: ('SS', '1', "Pixel Intensity Relationship Sign", '', 'PixelIntensityRelationshipSign'),  # noqa
    0x00281050: ('DS', '1-n', "Window Center", '', 'WindowCenter'),  # noqa
    0x00281051: ('DS', '1-n', "Window Width", '', 'WindowWidth'),  # noqa
    0x00281052: ('DS', '1', "Rescale Intercept", '', 'RescaleIntercept'),  # noqa
    0x00281053: ('DS', '1', "Rescale Slope", '', 'RescaleSlope'),  # noqa
    0x00281054: ('LO', '1', "Rescale Type", '', 'RescaleType'),  # noqa
    0x00281055: ('LO', '1-n', "Window Center & Width Explanation", '', 'WindowCenterWidthExplanation'),  # noqa
    0x00281056: ('CS', '1', "VOI LUT Function", '', 'VOILUTFunction'),  # noqa
    0x00281080: ('CS', '1', "Gray Scale", 'Retired', 'GrayScale'),  # noqa
    0x00281090: ('CS', '1', "Recommended Viewing Mode", '', 'RecommendedViewingMode'),  # noqa
    0x00281100: ('US or SS', '3', "Gray Lookup Table Descriptor", 'Retired', 'GrayLookupTableDescriptor'),  # noqa
    0x00281101: ('US or SS', '3', "Red Palette Color Lookup Table Descriptor", '', 'RedPaletteColorLookupTableDescriptor'),  # noqa
    0x00281102: ('US or SS', '3', "Green Palette Color Lookup Table Descriptor", '', 'GreenPaletteColorLookupTableDescriptor'),  # noqa
    0x00281103: ('US or SS', '3', "Blue Palette Color Lookup Table Descriptor", '', 'BluePaletteColorLookupTableDescriptor'),  # noqa
    0x00281104: ('US', '3', "Alpha Palette Color Lookup Table Descriptor", '', 'AlphaPaletteColorLookupTableDescriptor'),  # noqa
    0x00281111: ('US or SS', '4', "Large Red Palette Color Lookup Table Descriptor", 'Retired', 'LargeRedPaletteColorLookupTableDescriptor'),  # noqa
    0x00281112: ('US or SS', '4', "Large Green Palette Color Lookup Table Descriptor", 'Retired', 'LargeGreenPaletteColorLookupTableDescriptor'),  # noqa
    0x00281113: ('US or SS', '4', "Large Blue Palette Color Lookup Table Descriptor", 'Retired', 'LargeBluePaletteColorLookupTableDescriptor'),  # noqa
    0x00281199: ('UI', '1', "Palette Color Lookup Table UID", '', 'PaletteColorLookupTableUID'),  # noqa
    0x00281200: ('US or SS or OW', '1-n', "Gray Lookup Table Data", 'Retired', 'GrayLookupTableData'),  # noqa
    0x00281201: ('OW', '1', "Red Palette Color Lookup Table Data", '', 'RedPaletteColorLookupTableData'),  # noqa
    0x00281202: ('OW', '1', "Green Palette Color Lookup Table Data", '', 'GreenPaletteColorLookupTableData'),  # noqa
    0x00281203: ('OW', '1', "Blue Palette Color Lookup Table Data", '', 'BluePaletteColorLookupTableData'),  # noqa
    0x00281204: ('OW', '1', "Alpha Palette Color Lookup Table Data", '', 'AlphaPaletteColorLookupTableData'),  # noqa
    0x00281211: ('OW', '1', "Large Red Palette Color Lookup Table Data", 'Retired', 'LargeRedPaletteColorLookupTableData'),  # noqa
    0x00281212: ('OW', '1', "Large Green Palette Color Lookup Table Data", 'Retired', 'LargeGreenPaletteColorLookupTableData'),  # noqa
    0x00281213: ('OW', '1', "Large Blue Palette Color Lookup Table Data", 'Retired', 'LargeBluePaletteColorLookupTableData'),  # noqa
    0x00281214: ('UI', '1', "Large Palette Color Lookup Table UID", 'Retired', 'LargePaletteColorLookupTableUID'),  # noqa
    0x00281221: ('OW', '1', "Segmented Red Palette Color Lookup Table Data", '', 'SegmentedRedPaletteColorLookupTableData'),  # noqa
    0x00281222: ('OW', '1', "Segmented Green Palette Color Lookup Table Data", '', 'SegmentedGreenPaletteColorLookupTableData'),  # noqa
    0x00281223: ('OW', '1', "Segmented Blue Palette Color Lookup Table Data", '', 'SegmentedBluePaletteColorLookupTableData'),  # noqa
    0x00281224: ('OW', '1', "Segmented Alpha Palette Color Lookup Table Data", '', 'SegmentedAlphaPaletteColorLookupTableData'),  # noqa
    0x00281230: ('SQ', '1', "Stored Value Color Range Sequence", '', 'StoredValueColorRangeSequence'),  # noqa
    0x00281231: ('FD', '1', "Minimum Stored Value Mapped", '', 'MinimumStoredValueMapped'),  # noqa
    0x00281232: ('FD', '1', "Maximum Stored Value Mapped", '', 'MaximumStoredValueMapped'),  # noqa
    0x00281300: ('CS', '1', "Breast Implant Present", '', 'BreastImplantPresent'),  # noqa
    0x00281350: ('CS', '1', "Partial View", '', 'PartialView'),  # noqa
    0x00281351: ('ST', '1', "Partial View Description", '', 'PartialViewDescription'),  # noqa
    0x00281352: ('SQ', '1', "Partial View Code Sequence", '', 'PartialViewCodeSequence'),  # noqa
    0x0028135A: ('CS', '1', "Spatial Locations Preserved", '', 'SpatialLocationsPreserved'),  # noqa
    0x00281401: ('SQ', '1', "Data Frame Assignment Sequence", '', 'DataFrameAssignmentSequence'),  # noqa
    0x00281402: ('CS', '1', "Data Path Assignment", '', 'DataPathAssignment'),  # noqa
    0x00281403: ('US', '1', "Bits Mapped to Color Lookup Table", '', 'BitsMappedToColorLookupTable'),  # noqa
    0x00281404: ('SQ', '1', "Blending LUT 1 Sequence", '', 'BlendingLUT1Sequence'),  # noqa
    0x00281405: ('CS', '1', "Blending LUT 1 Transfer Function", '', 'BlendingLUT1TransferFunction'),  # noqa
    0x00281406: ('FD', '1', "Blending Weight Constant", '', 'BlendingWeightConstant'),  # noqa
    0x00281407: ('US', '3', "Blending Lookup Table Descriptor", '', 'BlendingLookupTableDescriptor'),  # noqa
    0x00281408: ('OW', '1', "Blending Lookup Table Data", '', 'BlendingLookupTableData'),  # noqa
    0x0028140B: ('SQ', '1', "Enhanced Palette Color Lookup Table Sequence", '', 'EnhancedPaletteColorLookupTableSequence'),  # noqa
    0x0028140C: ('SQ', '1', "Blending LUT 2 Sequence", '', 'BlendingLUT2Sequence'),  # noqa
    0x0028140D: ('CS', '1', "Blending LUT 2 Transfer Function", '', 'BlendingLUT2TransferFunction'),  # noqa
    0x0028140E: ('CS', '1', "Data Path ID", '', 'DataPathID'),  # noqa
    0x0028140F: ('CS', '1', "RGB LUT Transfer Function", '', 'RGBLUTTransferFunction'),  # noqa
    0x00281410: ('CS', '1', "Alpha LUT Transfer Function", '', 'AlphaLUTTransferFunction'),  # noqa
    0x00282000: ('OB', '1', "ICC Profile", '', 'ICCProfile'),  # noqa
    0x00282002: ('CS', '1', "Color Space", '', 'ColorSpace'),  # noqa
    0x00282110: ('CS', '1', "Lossy Image Compression", '', 'LossyImageCompression'),  # noqa
    0x00282112: ('DS', '1-n', "Lossy Image Compression Ratio", '', 'LossyImageCompressionRatio'),  # noqa
    0x00282114: ('CS', '1-n', "Lossy Image Compression Method", '', 'LossyImageCompressionMethod'),  # noqa
    0x00283000: ('SQ', '1', "Modality LUT Sequence", '', 'ModalityLUTSequence'),  # noqa
    0x00283002: ('US or SS', '3', "LUT Descriptor", '', 'LUTDescriptor'),  # noqa
    0x00283003: ('LO', '1', "LUT Explanation", '', 'LUTExplanation'),  # noqa
    0x00283004: ('LO', '1', "Modality LUT Type", '', 'ModalityLUTType'),  # noqa
    0x00283006: ('US or OW', '1-n', "LUT Data", '', 'LUTData'),  # noqa
    0x00283010: ('SQ', '1', "VOI LUT Sequence", '', 'VOILUTSequence'),  # noqa
    0x00283110: ('SQ', '1', "Softcopy VOI LUT Sequence", '', 'SoftcopyVOILUTSequence'),  # noqa
    0x00284000: ('LT', '1', "Image Presentation Comments", 'Retired', 'ImagePresentationComments'),  # noqa
    0x00285000: ('SQ', '1', "Bi-Plane Acquisition Sequence", 'Retired', 'BiPlaneAcquisitionSequence'),  # noqa
    0x00286010: ('US', '1', "Representative Frame Number", '', 'RepresentativeFrameNumber'),  # noqa
    0x00286020: ('US', '1-n', "Frame Numbers of Interest (FOI)", '', 'FrameNumbersOfInterest'),  # noqa
    0x00286022: ('LO', '1-n', "Frame of Interest Description", '', 'FrameOfInterestDescription'),  # noqa
    0x00286023: ('CS', '1-n', "Frame of Interest Type", '', 'FrameOfInterestType'),  # noqa
    0x00286030: ('US', '1-n', "Mask Pointer(s)", 'Retired', 'MaskPointers'),  # noqa
    0x00286040: ('US', '1-n', "R Wave Pointer", '', 'RWavePointer'),  # noqa
    0x00286100: ('SQ', '1', "Mask Subtraction Sequence", '', 'MaskSubtractionSequence'),  # noqa
    0x00286101: ('CS', '1', "Mask Operation", '', 'MaskOperation'),  # noqa
    0x00286102: ('US', '2-2n', "Applicable Frame Range", '', 'ApplicableFrameRange'),  # noqa
    0x00286110: ('US', '1-n', "Mask Frame Numbers", '', 'MaskFrameNumbers'),  # noqa
    0x00286112: ('US', '1', "Contrast Frame Averaging", '', 'ContrastFrameAveraging'),  # noqa
    0x00286114: ('FL', '2', "Mask Sub-pixel Shift", '', 'MaskSubPixelShift'),  # noqa
    0x00286120: ('SS', '1', "TID Offset", '', 'TIDOffset'),  # noqa
    0x00286190: ('ST', '1', "Mask Operation Explanation", '', 'MaskOperationExplanation'),  # noqa
    0x00287000: ('SQ', '1', "Equipment Administrator Sequence", '', 'EquipmentAdministratorSequence'),  # noqa
    0x00287001: ('US', '1', "Number of Display Subsystems", '', 'NumberOfDisplaySubsystems'),  # noqa
    0x00287002: ('US', '1', "Current Configuration ID", '', 'CurrentConfigurationID'),  # noqa
    0x00287003: ('US', '1', "Display Subsystem ID", '', 'DisplaySubsystemID'),  # noqa
    0x00287004: ('SH', '1', "Display Subsystem Name", '', 'DisplaySubsystemName'),  # noqa
    0x00287005: ('LO', '1', "Display Subsystem Description", '', 'DisplaySubsystemDescription'),  # noqa
    0x00287006: ('CS', '1', "System Status", '', 'SystemStatus'),  # noqa
    0x00287007: ('LO', '1', "System Status Comment", '', 'SystemStatusComment'),  # noqa
    0x00287008: ('SQ', '1', "Target Luminance Characteristics Sequence", '', 'TargetLuminanceCharacteristicsSequence'),  # noqa
    0x00287009: ('US', '1', "Luminance Characteristics ID", '', 'LuminanceCharacteristicsID'),  # noqa
    0x0028700A: ('SQ', '1', "Display Subsystem Configuration Sequence", '', 'DisplaySubsystemConfigurationSequence'),  # noqa
    0x0028700B: ('US', '1', "Configuration ID", '', 'ConfigurationID'),  # noqa
    0x0028700C: ('SH', '1', "Configuration Name", '', 'ConfigurationName'),  # noqa
    0x0028700D: ('LO', '1', "Configuration Description", '', 'ConfigurationDescription'),  # noqa
    0x0028700E: ('US', '1', "Referenced Target Luminance Characteristics ID", '', 'ReferencedTargetLuminanceCharacteristicsID'),  # noqa
    0x0028700F: ('SQ', '1', "QA Results Sequence", '', 'QAResultsSequence'),  # noqa
    0x00287010: ('SQ', '1', "Display Subsystem QA Results Sequence", '', 'DisplaySubsystemQAResultsSequence'),  # noqa
    0x00287011: ('SQ', '1', "Configuration QA Results Sequence", '', 'ConfigurationQAResultsSequence'),  # noqa
    0x00287012: ('SQ', '1', "Measurement Equipment Sequence", '', 'MeasurementEquipmentSequence'),  # noqa
    0x00287013: ('CS', '1-n', "Measurement Functions", '', 'MeasurementFunctions'),  # noqa
    0x00287014: ('CS', '1', "Measurement Equipment Type", '', 'MeasurementEquipmentType'),  # noqa
    0x00287015: ('SQ', '1', "Visual Evaluation Result Sequence", '', 'VisualEvaluationResultSequence'),  # noqa
    0x00287016: ('SQ', '1', "Display Calibration Result Sequence", '', 'DisplayCalibrationResultSequence'),  # noqa
    0x00287017: ('US', '1', "DDL Value", '', 'DDLValue'),  # noqa
    0x00287018: ('FL', '2', "CIExy White Point", '', 'CIExyWhitePoint'),  # noqa
    0x00287019: ('CS', '1', "Display Function Type", '', 'DisplayFunctionType'),  # noqa
    0x0028701A: ('FL', '1', "Gamma Value", '', 'GammaValue'),  # noqa
    0x0028701B: ('US', '1', "Number of Luminance Points", '', 'NumberOfLuminancePoints'),  # noqa
    0x0028701C: ('SQ', '1', "Luminance Response Sequence", '', 'LuminanceResponseSequence'),  # noqa
    0x0028701D: ('FL', '1', "Target Minimum Luminance", '', 'TargetMinimumLuminance'),  # noqa
    0x0028701E: ('FL', '1', "Target Maximum Luminance", '', 'TargetMaximumLuminance'),  # noqa
    0x0028701F: ('FL', '1', "Luminance Value", '', 'LuminanceValue'),  # noqa
    0x00287020: ('LO', '1', "Luminance Response Description", '', 'LuminanceResponseDescription'),  # noqa
    0x00287021: ('CS', '1', "White Point Flag", '', 'WhitePointFlag'),  # noqa
    0x00287022: ('SQ', '1', "Display Device Type Code Sequence", '', 'DisplayDeviceTypeCodeSequence'),  # noqa
    0x00287023: ('SQ', '1', "Display Subsystem Sequence", '', 'DisplaySubsystemSequence'),  # noqa
    0x00287024: ('SQ', '1', "Luminance Result Sequence", '', 'LuminanceResultSequence'),  # noqa
    0x00287025: ('CS', '1', "Ambient Light Value Source", '', 'AmbientLightValueSource'),  # noqa
    0x00287026: ('CS', '1-n', "Measured Characteristics", '', 'MeasuredCharacteristics'),  # noqa
    0x00287027: ('SQ', '1', "Luminance Uniformity Result Sequence", '', 'LuminanceUniformityResultSequence'),  # noqa
    0x00287028: ('SQ', '1', "Visual Evaluation Test Sequence", '', 'VisualEvaluationTestSequence'),  # noqa
    0x00287029: ('CS', '1', "Test Result", '', 'TestResult'),  # noqa
    0x0028702A: ('LO', '1', "Test Result Comment", '', 'TestResultComment'),  # noqa
    0x0028702B: ('CS', '1', "Test Image Validation", '', 'TestImageValidation'),  # noqa
    0x0028702C: ('SQ', '1', "Test Pattern Code Sequence", '', 'TestPatternCodeSequence'),  # noqa
    0x0028702D: ('SQ', '1', "Measurement Pattern Code Sequence", '', 'MeasurementPatternCodeSequence'),  # noqa
    0x0028702E: ('SQ', '1', "Visual Evaluation Method Code Sequence", '', 'VisualEvaluationMethodCodeSequence'),  # noqa
    0x00287FE0: ('UR', '1', "Pixel Data Provider URL", '', 'PixelDataProviderURL'),  # noqa
    0x00289001: ('UL', '1', "Data Point Rows", '', 'DataPointRows'),  # noqa
    0x00289002: ('UL', '1', "Data Point Columns", '', 'DataPointColumns'),  # noqa
    0x00289003: ('CS', '1', "Signal Domain Columns", '', 'SignalDomainColumns'),  # noqa
    0x00289099: ('US', '1', "Largest Monochrome Pixel Value", 'Retired', 'LargestMonochromePixelValue'),  # noqa
    0x00289108: ('CS', '1', "Data Representation", '', 'DataRepresentation'),  # noqa
    0x00289110: ('SQ', '1', "Pixel Measures Sequence", '', 'PixelMeasuresSequence'),  # noqa
    0x00289132: ('SQ', '1', "Frame VOI LUT Sequence", '', 'FrameVOILUTSequence'),  # noqa
    0x00289145: ('SQ', '1', "Pixel Value Transformation Sequence", '', 'PixelValueTransformationSequence'),  # noqa
    0x00289235: ('CS', '1', "Signal Domain Rows", '', 'SignalDomainRows'),  # noqa
    0x00289411: ('FL', '1', "Display Filter Percentage", '', 'DisplayFilterPercentage'),  # noqa
    0x00289415: ('SQ', '1', "Frame Pixel Shift Sequence", '', 'FramePixelShiftSequence'),  # noqa
    0x00289416: ('US', '1', "Subtraction Item ID", '', 'SubtractionItemID'),  # noqa
    0x00289422: ('SQ', '1', "Pixel Intensity Relationship LUT Sequence", '', 'PixelIntensityRelationshipLUTSequence'),  # noqa
    0x00289443: ('SQ', '1', "Frame Pixel Data Properties Sequence", '', 'FramePixelDataPropertiesSequence'),  # noqa
    0x00289444: ('CS', '1', "Geometrical Properties", '', 'GeometricalProperties'),  # noqa
    0x00289445: ('FL', '1', "Geometric Maximum Distortion", '', 'GeometricMaximumDistortion'),  # noqa
    0x00289446: ('CS', '1-n', "Image Processing Applied", '', 'ImageProcessingApplied'),  # noqa
    0x00289454: ('CS', '1', "Mask Selection Mode", '', 'MaskSelectionMode'),  # noqa
    0x00289474: ('CS', '1', "LUT Function", '', 'LUTFunction'),  # noqa
    0x00289478: ('FL', '1', "Mask Visibility Percentage", '', 'MaskVisibilityPercentage'),  # noqa
    0x00289501: ('SQ', '1', "Pixel Shift Sequence", '', 'PixelShiftSequence'),  # noqa
    0x00289502: ('SQ', '1', "Region Pixel Shift Sequence", '', 'RegionPixelShiftSequence'),  # noqa
    0x00289503: ('SS', '2-2n', "Vertices of the Region", '', 'VerticesOfTheRegion'),  # noqa
    0x00289505: ('SQ', '1', "Multi-frame Presentation Sequence", '', 'MultiFramePresentationSequence'),  # noqa
    0x00289506: ('US', '2-2n', "Pixel Shift Frame Range", '', 'PixelShiftFrameRange'),  # noqa
    0x00289507: ('US', '2-2n', "LUT Frame Range", '', 'LUTFrameRange'),  # noqa
    0x00289520: ('DS', '16', "Image to Equipment Mapping Matrix", '', 'ImageToEquipmentMappingMatrix'),  # noqa
    0x00289537: ('CS', '1', "Equipment Coordinate System Identification", '', 'EquipmentCoordinateSystemIdentification'),  # noqa
    0x0032000A: ('CS', '1', "Study Status ID", 'Retired', 'StudyStatusID'),  # noqa
    0x0032000C: ('CS', '1', "Study Priority ID", 'Retired', 'StudyPriorityID'),  # noqa
    0x00320012: ('LO', '1', "Study ID Issuer", 'Retired', 'StudyIDIssuer'),  # noqa
    0x00320032: ('DA', '1', "Study Verified Date", 'Retired', 'StudyVerifiedDate'),  # noqa
    0x00320033: ('TM', '1', "Study Verified Time", 'Retired', 'StudyVerifiedTime'),  # noqa
    0x00320034: ('DA', '1', "Study Read Date", 'Retired', 'StudyReadDate'),  # noqa
    0x00320035: ('TM', '1', "Study Read Time", 'Retired', 'StudyReadTime'),  # noqa
    0x00321000: ('DA', '1', "Scheduled Study Start Date", 'Retired', 'ScheduledStudyStartDate'),  # noqa
    0x00321001: ('TM', '1', "Scheduled Study Start Time", 'Retired', 'ScheduledStudyStartTime'),  # noqa
    0x00321010: ('DA', '1', "Scheduled Study Stop Date", 'Retired', 'ScheduledStudyStopDate'),  # noqa
    0x00321011: ('TM', '1', "Scheduled Study Stop Time", 'Retired', 'ScheduledStudyStopTime'),  # noqa
    0x00321020: ('LO', '1', "Scheduled Study Location", 'Retired', 'ScheduledStudyLocation'),  # noqa
    0x00321021: ('AE', '1-n', "Scheduled Study Location AE Title", 'Retired', 'ScheduledStudyLocationAETitle'),  # noqa
    0x00321030: ('LO', '1', "Reason for Study", 'Retired', 'ReasonForStudy'),  # noqa
    0x00321031: ('SQ', '1', "Requesting Physician Identification Sequence", '', 'RequestingPhysicianIdentificationSequence'),  # noqa
    0x00321032: ('PN', '1', "Requesting Physician", '', 'RequestingPhysician'),  # noqa
    0x00321033: ('LO', '1', "Requesting Service", '', 'RequestingService'),  # noqa
    0x00321034: ('SQ', '1', "Requesting Service Code Sequence", '', 'RequestingServiceCodeSequence'),  # noqa
    0x00321040: ('DA', '1', "Study Arrival Date", 'Retired', 'StudyArrivalDate'),  # noqa
    0x00321041: ('TM', '1', "Study Arrival Time", 'Retired', 'StudyArrivalTime'),  # noqa
    0x00321050: ('DA', '1', "Study Completion Date", 'Retired', 'StudyCompletionDate'),  # noqa
    0x00321051: ('TM', '1', "Study Completion Time", 'Retired', 'StudyCompletionTime'),  # noqa
    0x00321055: ('CS', '1', "Study Component Status ID", 'Retired', 'StudyComponentStatusID'),  # noqa
    0x00321060: ('LO', '1', "Requested Procedure Description", '', 'RequestedProcedureDescription'),  # noqa
    0x00321064: ('SQ', '1', "Requested Procedure Code Sequence", '', 'RequestedProcedureCodeSequence'),  # noqa
    0x00321070: ('LO', '1', "Requested Contrast Agent", '', 'RequestedContrastAgent'),  # noqa
    0x00324000: ('LT', '1', "Study Comments", 'Retired', 'StudyComments'),  # noqa
    0x00380004: ('SQ', '1', "Referenced Patient Alias Sequence", '', 'ReferencedPatientAliasSequence'),  # noqa
    0x00380008: ('CS', '1', "Visit Status ID", '', 'VisitStatusID'),  # noqa
    0x00380010: ('LO', '1', "Admission ID", '', 'AdmissionID'),  # noqa
    0x00380011: ('LO', '1', "Issuer of Admission ID", 'Retired', 'IssuerOfAdmissionID'),  # noqa
    0x00380014: ('SQ', '1', "Issuer of Admission ID Sequence", '', 'IssuerOfAdmissionIDSequence'),  # noqa
    0x00380016: ('LO', '1', "Route of Admissions", '', 'RouteOfAdmissions'),  # noqa
    0x0038001A: ('DA', '1', "Scheduled Admission Date", 'Retired', 'ScheduledAdmissionDate'),  # noqa
    0x0038001B: ('TM', '1', "Scheduled Admission Time", 'Retired', 'ScheduledAdmissionTime'),  # noqa
    0x0038001C: ('DA', '1', "Scheduled Discharge Date", 'Retired', 'ScheduledDischargeDate'),  # noqa
    0x0038001D: ('TM', '1', "Scheduled Discharge Time", 'Retired', 'ScheduledDischargeTime'),  # noqa
    0x0038001E: ('LO', '1', "Scheduled Patient Institution Residence", 'Retired', 'ScheduledPatientInstitutionResidence'),  # noqa
    0x00380020: ('DA', '1', "Admitting Date", '', 'AdmittingDate'),  # noqa
    0x00380021: ('TM', '1', "Admitting Time", '', 'AdmittingTime'),  # noqa
    0x00380030: ('DA', '1', "Discharge Date", 'Retired', 'DischargeDate'),  # noqa
    0x00380032: ('TM', '1', "Discharge Time", 'Retired', 'DischargeTime'),  # noqa
    0x00380040: ('LO', '1', "Discharge Diagnosis Description", 'Retired', 'DischargeDiagnosisDescription'),  # noqa
    0x00380044: ('SQ', '1', "Discharge Diagnosis Code Sequence", 'Retired', 'DischargeDiagnosisCodeSequence'),  # noqa
    0x00380050: ('LO', '1', "Special Needs", '', 'SpecialNeeds'),  # noqa
    0x00380060: ('LO', '1', "Service Episode ID", '', 'ServiceEpisodeID'),  # noqa
    0x00380061: ('LO', '1', "Issuer of Service Episode ID", 'Retired', 'IssuerOfServiceEpisodeID'),  # noqa
    0x00380062: ('LO', '1', "Service Episode Description", '', 'ServiceEpisodeDescription'),  # noqa
    0x00380064: ('SQ', '1', "Issuer of Service Episode ID Sequence", '', 'IssuerOfServiceEpisodeIDSequence'),  # noqa
    0x00380100: ('SQ', '1', "Pertinent Documents Sequence", '', 'PertinentDocumentsSequence'),  # noqa
    0x00380101: ('SQ', '1', "Pertinent Resources Sequence", '', 'PertinentResourcesSequence'),  # noqa
    0x00380102: ('LO', '1', "Resource Description", '', 'ResourceDescription'),  # noqa
    0x00380300: ('LO', '1', "Current Patient Location", '', 'CurrentPatientLocation'),  # noqa
    0x00380400: ('LO', '1', "Patient's Institution Residence", '', 'PatientInstitutionResidence'),  # noqa
    0x00380500: ('LO', '1', "Patient State", '', 'PatientState'),  # noqa
    0x00380502: ('SQ', '1', "Patient Clinical Trial Participation Sequence", '', 'PatientClinicalTrialParticipationSequence'),  # noqa
    0x00384000: ('LT', '1', "Visit Comments", '', 'VisitComments'),  # noqa
    0x003A0004: ('CS', '1', "Waveform Originality", '', 'WaveformOriginality'),  # noqa
    0x003A0005: ('US', '1', "Number of Waveform Channels", '', 'NumberOfWaveformChannels'),  # noqa
    0x003A0010: ('UL', '1', "Number of Waveform Samples", '', 'NumberOfWaveformSamples'),  # noqa
    0x003A001A: ('DS', '1', "Sampling Frequency", '', 'SamplingFrequency'),  # noqa
    0x003A0020: ('SH', '1', "Multiplex Group Label", '', 'MultiplexGroupLabel'),  # noqa
    0x003A0200: ('SQ', '1', "Channel Definition Sequence", '', 'ChannelDefinitionSequence'),  # noqa
    0x003A0202: ('IS', '1', "Waveform Channel Number", '', 'WaveformChannelNumber'),  # noqa
    0x003A0203: ('SH', '1', "Channel Label", '', 'ChannelLabel'),  # noqa
    0x003A0205: ('CS', '1-n', "Channel Status", '', 'ChannelStatus'),  # noqa
    0x003A0208: ('SQ', '1', "Channel Source Sequence", '', 'ChannelSourceSequence'),  # noqa
    0x003A0209: ('SQ', '1', "Channel Source Modifiers Sequence", '', 'ChannelSourceModifiersSequence'),  # noqa
    0x003A020A: ('SQ', '1', "Source Waveform Sequence", '', 'SourceWaveformSequence'),  # noqa
    0x003A020C: ('LO', '1', "Channel Derivation Description", '', 'ChannelDerivationDescription'),  # noqa
    0x003A0210: ('DS', '1', "Channel Sensitivity", '', 'ChannelSensitivity'),  # noqa
    0x003A0211: ('SQ', '1', "Channel Sensitivity Units Sequence", '', 'ChannelSensitivityUnitsSequence'),  # noqa
    0x003A0212: ('DS', '1', "Channel Sensitivity Correction Factor", '', 'ChannelSensitivityCorrectionFactor'),  # noqa
    0x003A0213: ('DS', '1', "Channel Baseline", '', 'ChannelBaseline'),  # noqa
    0x003A0214: ('DS', '1', "Channel Time Skew", '', 'ChannelTimeSkew'),  # noqa
    0x003A0215: ('DS', '1', "Channel Sample Skew", '', 'ChannelSampleSkew'),  # noqa
    0x003A0218: ('DS', '1', "Channel Offset", '', 'ChannelOffset'),  # noqa
    0x003A021A: ('US', '1', "Waveform Bits Stored", '', 'WaveformBitsStored'),  # noqa
    0x003A0220: ('DS', '1', "Filter Low Frequency", '', 'FilterLowFrequency'),  # noqa
    0x003A0221: ('DS', '1', "Filter High Frequency", '', 'FilterHighFrequency'),  # noqa
    0x003A0222: ('DS', '1', "Notch Filter Frequency", '', 'NotchFilterFrequency'),  # noqa
    0x003A0223: ('DS', '1', "Notch Filter Bandwidth", '', 'NotchFilterBandwidth'),  # noqa
    0x003A0230: ('FL', '1', "Waveform Data Display Scale", '', 'WaveformDataDisplayScale'),  # noqa
    0x003A0231: ('US', '3', "Waveform Display Background CIELab Value", '', 'WaveformDisplayBackgroundCIELabValue'),  # noqa
    0x003A0240: ('SQ', '1', "Waveform Presentation Group Sequence", '', 'WaveformPresentationGroupSequence'),  # noqa
    0x003A0241: ('US', '1', "Presentation Group Number", '', 'PresentationGroupNumber'),  # noqa
    0x003A0242: ('SQ', '1', "Channel Display Sequence", '', 'ChannelDisplaySequence'),  # noqa
    0x003A0244: ('US', '3', "Channel Recommended Display CIELab Value", '', 'ChannelRecommendedDisplayCIELabValue'),  # noqa
    0x003A0245: ('FL', '1', "Channel Position", '', 'ChannelPosition'),  # noqa
    0x003A0246: ('CS', '1', "Display Shading Flag", '', 'DisplayShadingFlag'),  # noqa
    0x003A0247: ('FL', '1', "Fractional Channel Display Scale", '', 'FractionalChannelDisplayScale'),  # noqa
    0x003A0248: ('FL', '1', "Absolute Channel Display Scale", '', 'AbsoluteChannelDisplayScale'),  # noqa
    0x003A0300: ('SQ', '1', "Multiplexed Audio Channels Description Code Sequence", '', 'MultiplexedAudioChannelsDescriptionCodeSequence'),  # noqa
    0x003A0301: ('IS', '1', "Channel Identification Code", '', 'ChannelIdentificationCode'),  # noqa
    0x003A0302: ('CS', '1', "Channel Mode", '', 'ChannelMode'),  # noqa
    0x00400001: ('AE', '1-n', "Scheduled Station AE Title", '', 'ScheduledStationAETitle'),  # noqa
    0x00400002: ('DA', '1', "Scheduled Procedure Step Start Date", '', 'ScheduledProcedureStepStartDate'),  # noqa
    0x00400003: ('TM', '1', "Scheduled Procedure Step Start Time", '', 'ScheduledProcedureStepStartTime'),  # noqa
    0x00400004: ('DA', '1', "Scheduled Procedure Step End Date", '', 'ScheduledProcedureStepEndDate'),  # noqa
    0x00400005: ('TM', '1', "Scheduled Procedure Step End Time", '', 'ScheduledProcedureStepEndTime'),  # noqa
    0x00400006: ('PN', '1', "Scheduled Performing Physician's Name", '', 'ScheduledPerformingPhysicianName'),  # noqa
    0x00400007: ('LO', '1', "Scheduled Procedure Step Description", '', 'ScheduledProcedureStepDescription'),  # noqa
    0x00400008: ('SQ', '1', "Scheduled Protocol Code Sequence", '', 'ScheduledProtocolCodeSequence'),  # noqa
    0x00400009: ('SH', '1', "Scheduled Procedure Step ID", '', 'ScheduledProcedureStepID'),  # noqa
    0x0040000A: ('SQ', '1', "Stage Code Sequence", '', 'StageCodeSequence'),  # noqa
    0x0040000B: ('SQ', '1', "Scheduled Performing Physician Identification Sequence", '', 'ScheduledPerformingPhysicianIdentificationSequence'),  # noqa
    0x00400010: ('SH', '1-n', "Scheduled Station Name", '', 'ScheduledStationName'),  # noqa
    0x00400011: ('SH', '1', "Scheduled Procedure Step Location", '', 'ScheduledProcedureStepLocation'),  # noqa
    0x00400012: ('LO', '1', "Pre-Medication", '', 'PreMedication'),  # noqa
    0x00400020: ('CS', '1', "Scheduled Procedure Step Status", '', 'ScheduledProcedureStepStatus'),  # noqa
    0x00400026: ('SQ', '1', "Order Placer Identifier Sequence", '', 'OrderPlacerIdentifierSequence'),  # noqa
    0x00400027: ('SQ', '1', "Order Filler Identifier Sequence", '', 'OrderFillerIdentifierSequence'),  # noqa
    0x00400031: ('UT', '1', "Local Namespace Entity ID", '', 'LocalNamespaceEntityID'),  # noqa
    0x00400032: ('UT', '1', "Universal Entity ID", '', 'UniversalEntityID'),  # noqa
    0x00400033: ('CS', '1', "Universal Entity ID Type", '', 'UniversalEntityIDType'),  # noqa
    0x00400035: ('CS', '1', "Identifier Type Code", '', 'IdentifierTypeCode'),  # noqa
    0x00400036: ('SQ', '1', "Assigning Facility Sequence", '', 'AssigningFacilitySequence'),  # noqa
    0x00400039: ('SQ', '1', "Assigning Jurisdiction Code Sequence", '', 'AssigningJurisdictionCodeSequence'),  # noqa
    0x0040003A: ('SQ', '1', "Assigning Agency or Department Code Sequence", '', 'AssigningAgencyOrDepartmentCodeSequence'),  # noqa
    0x00400100: ('SQ', '1', "Scheduled Procedure Step Sequence", '', 'ScheduledProcedureStepSequence'),  # noqa
    0x00400220: ('SQ', '1', "Referenced Non-Image Composite SOP Instance Sequence", '', 'ReferencedNonImageCompositeSOPInstanceSequence'),  # noqa
    0x00400241: ('AE', '1', "Performed Station AE Title", '', 'PerformedStationAETitle'),  # noqa
    0x00400242: ('SH', '1', "Performed Station Name", '', 'PerformedStationName'),  # noqa
    0x00400243: ('SH', '1', "Performed Location", '', 'PerformedLocation'),  # noqa
    0x00400244: ('DA', '1', "Performed Procedure Step Start Date", '', 'PerformedProcedureStepStartDate'),  # noqa
    0x00400245: ('TM', '1', "Performed Procedure Step Start Time", '', 'PerformedProcedureStepStartTime'),  # noqa
    0x00400250: ('DA', '1', "Performed Procedure Step End Date", '', 'PerformedProcedureStepEndDate'),  # noqa
    0x00400251: ('TM', '1', "Performed Procedure Step End Time", '', 'PerformedProcedureStepEndTime'),  # noqa
    0x00400252: ('CS', '1', "Performed Procedure Step Status", '', 'PerformedProcedureStepStatus'),  # noqa
    0x00400253: ('SH', '1', "Performed Procedure Step ID", '', 'PerformedProcedureStepID'),  # noqa
    0x00400254: ('LO', '1', "Performed Procedure Step Description", '', 'PerformedProcedureStepDescription'),  # noqa
    0x00400255: ('LO', '1', "Performed Procedure Type Description", '', 'PerformedProcedureTypeDescription'),  # noqa
    0x00400260: ('SQ', '1', "Performed Protocol Code Sequence", '', 'PerformedProtocolCodeSequence'),  # noqa
    0x00400261: ('CS', '1', "Performed Protocol Type", '', 'PerformedProtocolType'),  # noqa
    0x00400270: ('SQ', '1', "Scheduled Step Attributes Sequence", '', 'ScheduledStepAttributesSequence'),  # noqa
    0x00400275: ('SQ', '1', "Request Attributes Sequence", '', 'RequestAttributesSequence'),  # noqa
    0x00400280: ('ST', '1', "Comments on the Performed Procedure Step", '', 'CommentsOnThePerformedProcedureStep'),  # noqa
    0x00400281: ('SQ', '1', "Performed Procedure Step Discontinuation Reason Code Sequence", '', 'PerformedProcedureStepDiscontinuationReasonCodeSequence'),  # noqa
    0x00400293: ('SQ', '1', "Quantity Sequence", '', 'QuantitySequence'),  # noqa
    0x00400294: ('DS', '1', "Quantity", '', 'Quantity'),  # noqa
    0x00400295: ('SQ', '1', "Measuring Units Sequence", '', 'MeasuringUnitsSequence'),  # noqa
    0x00400296: ('SQ', '1', "Billing Item Sequence", '', 'BillingItemSequence'),  # noqa
    0x00400300: ('US', '1', "Total Time of Fluoroscopy", 'Retired', 'TotalTimeOfFluoroscopy'),  # noqa
    0x00400301: ('US', '1', "Total Number of Exposures", 'Retired', 'TotalNumberOfExposures'),  # noqa
    0x00400302: ('US', '1', "Entrance Dose", '', 'EntranceDose'),  # noqa
    0x00400303: ('US', '1-2', "Exposed Area", '', 'ExposedArea'),  # noqa
    0x00400306: ('DS', '1', "Distance Source to Entrance", '', 'DistanceSourceToEntrance'),  # noqa
    0x00400307: ('DS', '1', "Distance Source to Support", 'Retired', 'DistanceSourceToSupport'),  # noqa
    0x0040030E: ('SQ', '1', "Exposure Dose Sequence", 'Retired', 'ExposureDoseSequence'),  # noqa
    0x00400310: ('ST', '1', "Comments on Radiation Dose", '', 'CommentsOnRadiationDose'),  # noqa
    0x00400312: ('DS', '1', "X-Ray Output", '', 'XRayOutput'),  # noqa
    0x00400314: ('DS', '1', "Half Value Layer", '', 'HalfValueLayer'),  # noqa
    0x00400316: ('DS', '1', "Organ Dose", '', 'OrganDose'),  # noqa
    0x00400318: ('CS', '1', "Organ Exposed", '', 'OrganExposed'),  # noqa
    0x00400320: ('SQ', '1', "Billing Procedure Step Sequence", '', 'BillingProcedureStepSequence'),  # noqa
    0x00400321: ('SQ', '1', "Film Consumption Sequence", '', 'FilmConsumptionSequence'),  # noqa
    0x00400324: ('SQ', '1', "Billing Supplies and Devices Sequence", '', 'BillingSuppliesAndDevicesSequence'),  # noqa
    0x00400330: ('SQ', '1', "Referenced Procedure Step Sequence", 'Retired', 'ReferencedProcedureStepSequence'),  # noqa
    0x00400340: ('SQ', '1', "Performed Series Sequence", '', 'PerformedSeriesSequence'),  # noqa
    0x00400400: ('LT', '1', "Comments on the Scheduled Procedure Step", '', 'CommentsOnTheScheduledProcedureStep'),  # noqa
    0x00400440: ('SQ', '1', "Protocol Context Sequence", '', 'ProtocolContextSequence'),  # noqa
    0x00400441: ('SQ', '1', "Content Item Modifier Sequence", '', 'ContentItemModifierSequence'),  # noqa
    0x00400500: ('SQ', '1', "Scheduled Specimen Sequence", '', 'ScheduledSpecimenSequence'),  # noqa
    0x0040050A: ('LO', '1', "Specimen Accession Number", 'Retired', 'SpecimenAccessionNumber'),  # noqa
    0x00400512: ('LO', '1', "Container Identifier", '', 'ContainerIdentifier'),  # noqa
    0x00400513: ('SQ', '1', "Issuer of the Container Identifier Sequence", '', 'IssuerOfTheContainerIdentifierSequence'),  # noqa
    0x00400515: ('SQ', '1', "Alternate Container Identifier Sequence", '', 'AlternateContainerIdentifierSequence'),  # noqa
    0x00400518: ('SQ', '1', "Container Type Code Sequence", '', 'ContainerTypeCodeSequence'),  # noqa
    0x0040051A: ('LO', '1', "Container Description", '', 'ContainerDescription'),  # noqa
    0x00400520: ('SQ', '1', "Container Component Sequence", '', 'ContainerComponentSequence'),  # noqa
    0x00400550: ('SQ', '1', "Specimen Sequence", 'Retired', 'SpecimenSequence'),  # noqa
    0x00400551: ('LO', '1', "Specimen Identifier", '', 'SpecimenIdentifier'),  # noqa
    0x00400552: ('SQ', '1', "Specimen Description Sequence (Trial)", 'Retired', 'SpecimenDescriptionSequenceTrial'),  # noqa
    0x00400553: ('ST', '1', "Specimen Description (Trial)", 'Retired', 'SpecimenDescriptionTrial'),  # noqa
    0x00400554: ('UI', '1', "Specimen UID", '', 'SpecimenUID'),  # noqa
    0x00400555: ('SQ', '1', "Acquisition Context Sequence", '', 'AcquisitionContextSequence'),  # noqa
    0x00400556: ('ST', '1', "Acquisition Context Description", '', 'AcquisitionContextDescription'),  # noqa
    0x00400560: ('SQ', '1', "Specimen Description Sequence", '', 'SpecimenDescriptionSequence'),  # noqa
    0x00400562: ('SQ', '1', "Issuer of the Specimen Identifier Sequence", '', 'IssuerOfTheSpecimenIdentifierSequence'),  # noqa
    0x0040059A: ('SQ', '1', "Specimen Type Code Sequence", '', 'SpecimenTypeCodeSequence'),  # noqa
    0x00400600: ('LO', '1', "Specimen Short Description", '', 'SpecimenShortDescription'),  # noqa
    0x00400602: ('UT', '1', "Specimen Detailed Description", '', 'SpecimenDetailedDescription'),  # noqa
    0x00400610: ('SQ', '1', "Specimen Preparation Sequence", '', 'SpecimenPreparationSequence'),  # noqa
    0x00400612: ('SQ', '1', "Specimen Preparation Step Content Item Sequence", '', 'SpecimenPreparationStepContentItemSequence'),  # noqa
    0x00400620: ('SQ', '1', "Specimen Localization Content Item Sequence", '', 'SpecimenLocalizationContentItemSequence'),  # noqa
    0x004006FA: ('LO', '1', "Slide Identifier", 'Retired', 'SlideIdentifier'),  # noqa
    0x0040071A: ('SQ', '1', "Image Center Point Coordinates Sequence", '', 'ImageCenterPointCoordinatesSequence'),  # noqa
    0x0040072A: ('DS', '1', "X Offset in Slide Coordinate System", '', 'XOffsetInSlideCoordinateSystem'),  # noqa
    0x0040073A: ('DS', '1', "Y Offset in Slide Coordinate System", '', 'YOffsetInSlideCoordinateSystem'),  # noqa
    0x0040074A: ('DS', '1', "Z Offset in Slide Coordinate System", '', 'ZOffsetInSlideCoordinateSystem'),  # noqa
    0x004008D8: ('SQ', '1', "Pixel Spacing Sequence", 'Retired', 'PixelSpacingSequence'),  # noqa
    0x004008DA: ('SQ', '1', "Coordinate System Axis Code Sequence", 'Retired', 'CoordinateSystemAxisCodeSequence'),  # noqa
    0x004008EA: ('SQ', '1', "Measurement Units Code Sequence", '', 'MeasurementUnitsCodeSequence'),  # noqa
    0x004009F8: ('SQ', '1', "Vital Stain Code Sequence (Trial)", 'Retired', 'VitalStainCodeSequenceTrial'),  # noqa
    0x00401001: ('SH', '1', "Requested Procedure ID", '', 'RequestedProcedureID'),  # noqa
    0x00401002: ('LO', '1', "Reason for the Requested Procedure", '', 'ReasonForTheRequestedProcedure'),  # noqa
    0x00401003: ('SH', '1', "Requested Procedure Priority", '', 'RequestedProcedurePriority'),  # noqa
    0x00401004: ('LO', '1', "Patient Transport Arrangements", '', 'PatientTransportArrangements'),  # noqa
    0x00401005: ('LO', '1', "Requested Procedure Location", '', 'RequestedProcedureLocation'),  # noqa
    0x00401006: ('SH', '1', "Placer Order Number / Procedure", 'Retired', 'PlacerOrderNumberProcedure'),  # noqa
    0x00401007: ('SH', '1', "Filler Order Number / Procedure", 'Retired', 'FillerOrderNumberProcedure'),  # noqa
    0x00401008: ('LO', '1', "Confidentiality Code", '', 'ConfidentialityCode'),  # noqa
    0x00401009: ('SH', '1', "Reporting Priority", '', 'ReportingPriority'),  # noqa
    0x0040100A: ('SQ', '1', "Reason for Requested Procedure Code Sequence", '', 'ReasonForRequestedProcedureCodeSequence'),  # noqa
    0x00401010: ('PN', '1-n', "Names of Intended Recipients of Results", '', 'NamesOfIntendedRecipientsOfResults'),  # noqa
    0x00401011: ('SQ', '1', "Intended Recipients of Results Identification Sequence", '', 'IntendedRecipientsOfResultsIdentificationSequence'),  # noqa
    0x00401012: ('SQ', '1', "Reason For Performed Procedure Code Sequence", '', 'ReasonForPerformedProcedureCodeSequence'),  # noqa
    0x00401060: ('LO', '1', "Requested Procedure Description (Trial)", 'Retired', 'RequestedProcedureDescriptionTrial'),  # noqa
    0x00401101: ('SQ', '1', "Person Identification Code Sequence", '', 'PersonIdentificationCodeSequence'),  # noqa
    0x00401102: ('ST', '1', "Person's Address", '', 'PersonAddress'),  # noqa
    0x00401103: ('LO', '1-n', "Person's Telephone Numbers", '', 'PersonTelephoneNumbers'),  # noqa
    0x00401104: ('LT', '1', "Person's Telecom Information", '', 'PersonTelecomInformation'),  # noqa
    0x00401400: ('LT', '1', "Requested Procedure Comments", '', 'RequestedProcedureComments'),  # noqa
    0x00402001: ('LO', '1', "Reason for the Imaging Service Request", 'Retired', 'ReasonForTheImagingServiceRequest'),  # noqa
    0x00402004: ('DA', '1', "Issue Date of Imaging Service Request", '', 'IssueDateOfImagingServiceRequest'),  # noqa
    0x00402005: ('TM', '1', "Issue Time of Imaging Service Request", '', 'IssueTimeOfImagingServiceRequest'),  # noqa
    0x00402006: ('SH', '1', "Placer Order Number / Imaging Service Request (Retired)", 'Retired', 'PlacerOrderNumberImagingServiceRequestRetired'),  # noqa
    0x00402007: ('SH', '1', "Filler Order Number / Imaging Service Request (Retired)", 'Retired', 'FillerOrderNumberImagingServiceRequestRetired'),  # noqa
    0x00402008: ('PN', '1', "Order Entered By", '', 'OrderEnteredBy'),  # noqa
    0x00402009: ('SH', '1', "Order Enterer's Location", '', 'OrderEntererLocation'),  # noqa
    0x00402010: ('SH', '1', "Order Callback Phone Number", '', 'OrderCallbackPhoneNumber'),  # noqa
    0x00402011: ('LT', '1', "Order Callback Telecom Information", '', 'OrderCallbackTelecomInformation'),  # noqa
    0x00402016: ('LO', '1', "Placer Order Number / Imaging Service Request", '', 'PlacerOrderNumberImagingServiceRequest'),  # noqa
    0x00402017: ('LO', '1', "Filler Order Number / Imaging Service Request", '', 'FillerOrderNumberImagingServiceRequest'),  # noqa
    0x00402400: ('LT', '1', "Imaging Service Request Comments", '', 'ImagingServiceRequestComments'),  # noqa
    0x00403001: ('LO', '1', "Confidentiality Constraint on Patient Data Description", '', 'ConfidentialityConstraintOnPatientDataDescription'),  # noqa
    0x00404001: ('CS', '1', "General Purpose Scheduled Procedure Step Status", 'Retired', 'GeneralPurposeScheduledProcedureStepStatus'),  # noqa
    0x00404002: ('CS', '1', "General Purpose Performed Procedure Step Status", 'Retired', 'GeneralPurposePerformedProcedureStepStatus'),  # noqa
    0x00404003: ('CS', '1', "General Purpose Scheduled Procedure Step Priority", 'Retired', 'GeneralPurposeScheduledProcedureStepPriority'),  # noqa
    0x00404004: ('SQ', '1', "Scheduled Processing Applications Code Sequence", 'Retired', 'ScheduledProcessingApplicationsCodeSequence'),  # noqa
    0x00404005: ('DT', '1', "Scheduled Procedure Step Start DateTime", '', 'ScheduledProcedureStepStartDateTime'),  # noqa
    0x00404006: ('CS', '1', "Multiple Copies Flag", 'Retired', 'MultipleCopiesFlag'),  # noqa
    0x00404007: ('SQ', '1', "Performed Processing Applications Code Sequence", '', 'PerformedProcessingApplicationsCodeSequence'),  # noqa
    0x00404009: ('SQ', '1', "Human Performer Code Sequence", '', 'HumanPerformerCodeSequence'),  # noqa
    0x00404010: ('DT', '1', "Scheduled Procedure Step Modification DateTime", '', 'ScheduledProcedureStepModificationDateTime'),  # noqa
    0x00404011: ('DT', '1', "Expected Completion DateTime", '', 'ExpectedCompletionDateTime'),  # noqa
    0x00404015: ('SQ', '1', "Resulting General Purpose Performed Procedure Steps Sequence", 'Retired', 'ResultingGeneralPurposePerformedProcedureStepsSequence'),  # noqa
    0x00404016: ('SQ', '1', "Referenced General Purpose Scheduled Procedure Step Sequence", 'Retired', 'ReferencedGeneralPurposeScheduledProcedureStepSequence'),  # noqa
    0x00404018: ('SQ', '1', "Scheduled Workitem Code Sequence", '', 'ScheduledWorkitemCodeSequence'),  # noqa
    0x00404019: ('SQ', '1', "Performed Workitem Code Sequence", '', 'PerformedWorkitemCodeSequence'),  # noqa
    0x00404020: ('CS', '1', "Input Availability Flag", 'Retired', 'InputAvailabilityFlag'),  # noqa
    0x00404021: ('SQ', '1', "Input Information Sequence", '', 'InputInformationSequence'),  # noqa
    0x00404022: ('SQ', '1', "Relevant Information Sequence", 'Retired', 'RelevantInformationSequence'),  # noqa
    0x00404023: ('UI', '1', "Referenced General Purpose Scheduled Procedure Step Transaction UID", 'Retired', 'ReferencedGeneralPurposeScheduledProcedureStepTransactionUID'),  # noqa
    0x00404025: ('SQ', '1', "Scheduled Station Name Code Sequence", '', 'ScheduledStationNameCodeSequence'),  # noqa
    0x00404026: ('SQ', '1', "Scheduled Station Class Code Sequence", '', 'ScheduledStationClassCodeSequence'),  # noqa
    0x00404027: ('SQ', '1', "Scheduled Station Geographic Location Code Sequence", '', 'ScheduledStationGeographicLocationCodeSequence'),  # noqa
    0x00404028: ('SQ', '1', "Performed Station Name Code Sequence", '', 'PerformedStationNameCodeSequence'),  # noqa
    0x00404029: ('SQ', '1', "Performed Station Class Code Sequence", '', 'PerformedStationClassCodeSequence'),  # noqa
    0x00404030: ('SQ', '1', "Performed Station Geographic Location Code Sequence", '', 'PerformedStationGeographicLocationCodeSequence'),  # noqa
    0x00404031: ('SQ', '1', "Requested Subsequent Workitem Code Sequence", 'Retired', 'RequestedSubsequentWorkitemCodeSequence'),  # noqa
    0x00404032: ('SQ', '1', "Non-DICOM Output Code Sequence", 'Retired', 'NonDICOMOutputCodeSequence'),  # noqa
    0x00404033: ('SQ', '1', "Output Information Sequence", '', 'OutputInformationSequence'),  # noqa
    0x00404034: ('SQ', '1', "Scheduled Human Performers Sequence", '', 'ScheduledHumanPerformersSequence'),  # noqa
    0x00404035: ('SQ', '1', "Actual Human Performers Sequence", '', 'ActualHumanPerformersSequence'),  # noqa
    0x00404036: ('LO', '1', "Human Performer's Organization", '', 'HumanPerformerOrganization'),  # noqa
    0x00404037: ('PN', '1', "Human Performer's Name", '', 'HumanPerformerName'),  # noqa
    0x00404040: ('CS', '1', "Raw Data Handling", '', 'RawDataHandling'),  # noqa
    0x00404041: ('CS', '1', "Input Readiness State", '', 'InputReadinessState'),  # noqa
    0x00404050: ('DT', '1', "Performed Procedure Step Start DateTime", '', 'PerformedProcedureStepStartDateTime'),  # noqa
    0x00404051: ('DT', '1', "Performed Procedure Step End DateTime", '', 'PerformedProcedureStepEndDateTime'),  # noqa
    0x00404052: ('DT', '1', "Procedure Step Cancellation DateTime", '', 'ProcedureStepCancellationDateTime'),  # noqa
    0x00404070: ('SQ', '1', "Output Destination Sequence", '', 'OutputDestinationSequence'),  # noqa
    0x00404071: ('SQ', '1', "DICOM Storage Sequence", '', 'DICOMStorageSequence'),  # noqa
    0x00404072: ('SQ', '1', "STOW-RS Storage Sequence", '', 'STOWRSStorageSequence'),  # noqa
    0x00404073: ('UR', '1', "Storage URL", '', 'StorageURL'),  # noqa
    0x00404074: ('SQ', '1', "XDS Storage Sequence", '', 'XDSStorageSequence'),  # noqa
    0x00408302: ('DS', '1', "Entrance Dose in mGy", '', 'EntranceDoseInmGy'),  # noqa
    0x00408303: ('CS', '1', "Entrance Dose Derivation", '', 'EntranceDoseDerivation'),  # noqa
    0x00409092: ('SQ', '1', "Parametric Map Frame Type Sequence", '', 'ParametricMapFrameTypeSequence'),  # noqa
    0x00409094: ('SQ', '1', "Referenced Image Real World Value Mapping Sequence", '', 'ReferencedImageRealWorldValueMappingSequence'),  # noqa
    0x00409096: ('SQ', '1', "Real World Value Mapping Sequence", '', 'RealWorldValueMappingSequence'),  # noqa
    0x00409098: ('SQ', '1', "Pixel Value Mapping Code Sequence", '', 'PixelValueMappingCodeSequence'),  # noqa
    0x00409210: ('SH', '1', "LUT Label", '', 'LUTLabel'),  # noqa
    0x00409211: ('US or SS', '1', "Real World Value Last Value Mapped", '', 'RealWorldValueLastValueMapped'),  # noqa
    0x00409212: ('FD', '1-n', "Real World Value LUT Data", '', 'RealWorldValueLUTData'),  # noqa
    0x00409213: ('FD', '1', "Double Float Real World Value Last Value Mapped", '', 'DoubleFloatRealWorldValueLastValueMapped'),  # noqa
    0x00409214: ('FD', '1', "Double Float Real World Value First Value Mapped", '', 'DoubleFloatRealWorldValueFirstValueMapped'),  # noqa
    0x00409216: ('US or SS', '1', "Real World Value First Value Mapped", '', 'RealWorldValueFirstValueMapped'),  # noqa
    0x00409220: ('SQ', '1', "Quantity Definition Sequence", '', 'QuantityDefinitionSequence'),  # noqa
    0x00409224: ('FD', '1', "Real World Value Intercept", '', 'RealWorldValueIntercept'),  # noqa
    0x00409225: ('FD', '1', "Real World Value Slope", '', 'RealWorldValueSlope'),  # noqa
    0x0040A007: ('CS', '1', "Findings Flag (Trial)", 'Retired', 'FindingsFlagTrial'),  # noqa
    0x0040A010: ('CS', '1', "Relationship Type", '', 'RelationshipType'),  # noqa
    0x0040A020: ('SQ', '1', "Findings Sequence (Trial)", 'Retired', 'FindingsSequenceTrial'),  # noqa
    0x0040A021: ('UI', '1', "Findings Group UID (Trial)", 'Retired', 'FindingsGroupUIDTrial'),  # noqa
    0x0040A022: ('UI', '1', "Referenced Findings Group UID (Trial)", 'Retired', 'ReferencedFindingsGroupUIDTrial'),  # noqa
    0x0040A023: ('DA', '1', "Findings Group Recording Date (Trial)", 'Retired', 'FindingsGroupRecordingDateTrial'),  # noqa
    0x0040A024: ('TM', '1', "Findings Group Recording Time (Trial)", 'Retired', 'FindingsGroupRecordingTimeTrial'),  # noqa
    0x0040A026: ('SQ', '1', "Findings Source Category Code Sequence (Trial)", 'Retired', 'FindingsSourceCategoryCodeSequenceTrial'),  # noqa
    0x0040A027: ('LO', '1', "Verifying Organization", '', 'VerifyingOrganization'),  # noqa
    0x0040A028: ('SQ', '1', "Documenting Organization Identifier Code Sequence (Trial)", 'Retired', 'DocumentingOrganizationIdentifierCodeSequenceTrial'),  # noqa
    0x0040A030: ('DT', '1', "Verification DateTime", '', 'VerificationDateTime'),  # noqa
    0x0040A032: ('DT', '1', "Observation DateTime", '', 'ObservationDateTime'),  # noqa
    0x0040A040: ('CS', '1', "Value Type", '', 'ValueType'),  # noqa
    0x0040A043: ('SQ', '1', "Concept Name Code Sequence", '', 'ConceptNameCodeSequence'),  # noqa
    0x0040A047: ('LO', '1', "Measurement Precision Description (Trial)", 'Retired', 'MeasurementPrecisionDescriptionTrial'),  # noqa
    0x0040A050: ('CS', '1', "Continuity Of Content", '', 'ContinuityOfContent'),  # noqa
    0x0040A057: ('CS', '1-n', "Urgency or Priority Alerts (Trial)", 'Retired', 'UrgencyOrPriorityAlertsTrial'),  # noqa
    0x0040A060: ('LO', '1', "Sequencing Indicator (Trial)", 'Retired', 'SequencingIndicatorTrial'),  # noqa
    0x0040A066: ('SQ', '1', "Document Identifier Code Sequence (Trial)", 'Retired', 'DocumentIdentifierCodeSequenceTrial'),  # noqa
    0x0040A067: ('PN', '1', "Document Author (Trial)", 'Retired', 'DocumentAuthorTrial'),  # noqa
    0x0040A068: ('SQ', '1', "Document Author Identifier Code Sequence (Trial)", 'Retired', 'DocumentAuthorIdentifierCodeSequenceTrial'),  # noqa
    0x0040A070: ('SQ', '1', "Identifier Code Sequence (Trial)", 'Retired', 'IdentifierCodeSequenceTrial'),  # noqa
    0x0040A073: ('SQ', '1', "Verifying Observer Sequence", '', 'VerifyingObserverSequence'),  # noqa
    0x0040A074: ('OB', '1', "Object Binary Identifier (Trial)", 'Retired', 'ObjectBinaryIdentifierTrial'),  # noqa
    0x0040A075: ('PN', '1', "Verifying Observer Name", '', 'VerifyingObserverName'),  # noqa
    0x0040A076: ('SQ', '1', "Documenting Observer Identifier Code Sequence (Trial)", 'Retired', 'DocumentingObserverIdentifierCodeSequenceTrial'),  # noqa
    0x0040A078: ('SQ', '1', "Author Observer Sequence", '', 'AuthorObserverSequence'),  # noqa
    0x0040A07A: ('SQ', '1', "Participant Sequence", '', 'ParticipantSequence'),  # noqa
    0x0040A07C: ('SQ', '1', "Custodial Organization Sequence", '', 'CustodialOrganizationSequence'),  # noqa
    0x0040A080: ('CS', '1', "Participation Type", '', 'ParticipationType'),  # noqa
    0x0040A082: ('DT', '1', "Participation DateTime", '', 'ParticipationDateTime'),  # noqa
    0x0040A084: ('CS', '1', "Observer Type", '', 'ObserverType'),  # noqa
    0x0040A085: ('SQ', '1', "Procedure Identifier Code Sequence (Trial)", 'Retired', 'ProcedureIdentifierCodeSequenceTrial'),  # noqa
    0x0040A088: ('SQ', '1', "Verifying Observer Identification Code Sequence", '', 'VerifyingObserverIdentificationCodeSequence'),  # noqa
    0x0040A089: ('OB', '1', "Object Directory Binary Identifier (Trial)", 'Retired', 'ObjectDirectoryBinaryIdentifierTrial'),  # noqa
    0x0040A090: ('SQ', '1', "Equivalent CDA Document Sequence", 'Retired', 'EquivalentCDADocumentSequence'),  # noqa
    0x0040A0B0: ('US', '2-2n', "Referenced Waveform Channels", '', 'ReferencedWaveformChannels'),  # noqa
    0x0040A110: ('DA', '1', "Date of Document or Verbal Transaction (Trial)", 'Retired', 'DateOfDocumentOrVerbalTransactionTrial'),  # noqa
    0x0040A112: ('TM', '1', "Time of Document Creation or Verbal Transaction (Trial)", 'Retired', 'TimeOfDocumentCreationOrVerbalTransactionTrial'),  # noqa
    0x0040A120: ('DT', '1', "DateTime", '', 'DateTime'),  # noqa
    0x0040A121: ('DA', '1', "Date", '', 'Date'),  # noqa
    0x0040A122: ('TM', '1', "Time", '', 'Time'),  # noqa
    0x0040A123: ('PN', '1', "Person Name", '', 'PersonName'),  # noqa
    0x0040A124: ('UI', '1', "UID", '', 'UID'),  # noqa
    0x0040A125: ('CS', '2', "Report Status ID (Trial)", 'Retired', 'ReportStatusIDTrial'),  # noqa
    0x0040A130: ('CS', '1', "Temporal Range Type", '', 'TemporalRangeType'),  # noqa
    0x0040A132: ('UL', '1-n', "Referenced Sample Positions", '', 'ReferencedSamplePositions'),  # noqa
    0x0040A136: ('US', '1-n', "Referenced Frame Numbers", '', 'ReferencedFrameNumbers'),  # noqa
    0x0040A138: ('DS', '1-n', "Referenced Time Offsets", '', 'ReferencedTimeOffsets'),  # noqa
    0x0040A13A: ('DT', '1-n', "Referenced DateTime", '', 'ReferencedDateTime'),  # noqa
    0x0040A160: ('UT', '1', "Text Value", '', 'TextValue'),  # noqa
    0x0040A161: ('FD', '1-n', "Floating Point Value", '', 'FloatingPointValue'),  # noqa
    0x0040A162: ('SL', '1-n', "Rational Numerator Value", '', 'RationalNumeratorValue'),  # noqa
    0x0040A163: ('UL', '1-n', "Rational Denominator Value", '', 'RationalDenominatorValue'),  # noqa
    0x0040A167: ('SQ', '1', "Observation Category Code Sequence (Trial)", 'Retired', 'ObservationCategoryCodeSequenceTrial'),  # noqa
    0x0040A168: ('SQ', '1', "Concept Code Sequence", '', 'ConceptCodeSequence'),  # noqa
    0x0040A16A: ('ST', '1', "Bibliographic Citation (Trial)", 'Retired', 'BibliographicCitationTrial'),  # noqa
    0x0040A170: ('SQ', '1', "Purpose of Reference Code Sequence", '', 'PurposeOfReferenceCodeSequence'),  # noqa
    0x0040A171: ('UI', '1', "Observation UID", '', 'ObservationUID'),  # noqa
    0x0040A172: ('UI', '1', "Referenced Observation UID (Trial)", 'Retired', 'ReferencedObservationUIDTrial'),  # noqa
    0x0040A173: ('CS', '1', "Referenced Observation Class (Trial)", 'Retired', 'ReferencedObservationClassTrial'),  # noqa
    0x0040A174: ('CS', '1', "Referenced Object Observation Class (Trial)", 'Retired', 'ReferencedObjectObservationClassTrial'),  # noqa
    0x0040A180: ('US', '1', "Annotation Group Number", '', 'AnnotationGroupNumber'),  # noqa
    0x0040A192: ('DA', '1', "Observation Date (Trial)", 'Retired', 'ObservationDateTrial'),  # noqa
    0x0040A193: ('TM', '1', "Observation Time (Trial)", 'Retired', 'ObservationTimeTrial'),  # noqa
    0x0040A194: ('CS', '1', "Measurement Automation (Trial)", 'Retired', 'MeasurementAutomationTrial'),  # noqa
    0x0040A195: ('SQ', '1', "Modifier Code Sequence", '', 'ModifierCodeSequence'),  # noqa
    0x0040A224: ('ST', '1', "Identification Description (Trial)", 'Retired', 'IdentificationDescriptionTrial'),  # noqa
    0x0040A290: ('CS', '1', "Coordinates Set Geometric Type (Trial)", 'Retired', 'CoordinatesSetGeometricTypeTrial'),  # noqa
    0x0040A296: ('SQ', '1', "Algorithm Code Sequence (Trial)", 'Retired', 'AlgorithmCodeSequenceTrial'),  # noqa
    0x0040A297: ('ST', '1', "Algorithm Description (Trial)", 'Retired', 'AlgorithmDescriptionTrial'),  # noqa
    0x0040A29A: ('SL', '2-2n', "Pixel Coordinates Set (Trial)", 'Retired', 'PixelCoordinatesSetTrial'),  # noqa
    0x0040A300: ('SQ', '1', "Measured Value Sequence", '', 'MeasuredValueSequence'),  # noqa
    0x0040A301: ('SQ', '1', "Numeric Value Qualifier Code Sequence", '', 'NumericValueQualifierCodeSequence'),  # noqa
    0x0040A307: ('PN', '1', "Current Observer (Trial)", 'Retired', 'CurrentObserverTrial'),  # noqa
    0x0040A30A: ('DS', '1-n', "Numeric Value", '', 'NumericValue'),  # noqa
    0x0040A313: ('SQ', '1', "Referenced Accession Sequence (Trial)", 'Retired', 'ReferencedAccessionSequenceTrial'),  # noqa
    0x0040A33A: ('ST', '1', "Report Status Comment (Trial)", 'Retired', 'ReportStatusCommentTrial'),  # noqa
    0x0040A340: ('SQ', '1', "Procedure Context Sequence (Trial)", 'Retired', 'ProcedureContextSequenceTrial'),  # noqa
    0x0040A352: ('PN', '1', "Verbal Source (Trial)", 'Retired', 'VerbalSourceTrial'),  # noqa
    0x0040A353: ('ST', '1', "Address (Trial)", 'Retired', 'AddressTrial'),  # noqa
    0x0040A354: ('LO', '1', "Telephone Number (Trial)", 'Retired', 'TelephoneNumberTrial'),  # noqa
    0x0040A358: ('SQ', '1', "Verbal Source Identifier Code Sequence (Trial)", 'Retired', 'VerbalSourceIdentifierCodeSequenceTrial'),  # noqa
    0x0040A360: ('SQ', '1', "Predecessor Documents Sequence", '', 'PredecessorDocumentsSequence'),  # noqa
    0x0040A370: ('SQ', '1', "Referenced Request Sequence", '', 'ReferencedRequestSequence'),  # noqa
    0x0040A372: ('SQ', '1', "Performed Procedure Code Sequence", '', 'PerformedProcedureCodeSequence'),  # noqa
    0x0040A375: ('SQ', '1', "Current Requested Procedure Evidence Sequence", '', 'CurrentRequestedProcedureEvidenceSequence'),  # noqa
    0x0040A380: ('SQ', '1', "Report Detail Sequence (Trial)", 'Retired', 'ReportDetailSequenceTrial'),  # noqa
    0x0040A385: ('SQ', '1', "Pertinent Other Evidence Sequence", '', 'PertinentOtherEvidenceSequence'),  # noqa
    0x0040A390: ('SQ', '1', "HL7 Structured Document Reference Sequence", '', 'HL7StructuredDocumentReferenceSequence'),  # noqa
    0x0040A402: ('UI', '1', "Observation Subject UID (Trial)", 'Retired', 'ObservationSubjectUIDTrial'),  # noqa
    0x0040A403: ('CS', '1', "Observation Subject Class (Trial)", 'Retired', 'ObservationSubjectClassTrial'),  # noqa
    0x0040A404: ('SQ', '1', "Observation Subject Type Code Sequence (Trial)", 'Retired', 'ObservationSubjectTypeCodeSequenceTrial'),  # noqa
    0x0040A491: ('CS', '1', "Completion Flag", '', 'CompletionFlag'),  # noqa
    0x0040A492: ('LO', '1', "Completion Flag Description", '', 'CompletionFlagDescription'),  # noqa
    0x0040A493: ('CS', '1', "Verification Flag", '', 'VerificationFlag'),  # noqa
    0x0040A494: ('CS', '1', "Archive Requested", '', 'ArchiveRequested'),  # noqa
    0x0040A496: ('CS', '1', "Preliminary Flag", '', 'PreliminaryFlag'),  # noqa
    0x0040A504: ('SQ', '1', "Content Template Sequence", '', 'ContentTemplateSequence'),  # noqa
    0x0040A525: ('SQ', '1', "Identical Documents Sequence", '', 'IdenticalDocumentsSequence'),  # noqa
    0x0040A600: ('CS', '1', "Observation Subject Context Flag (Trial)", 'Retired', 'ObservationSubjectContextFlagTrial'),  # noqa
    0x0040A601: ('CS', '1', "Observer Context Flag (Trial)", 'Retired', 'ObserverContextFlagTrial'),  # noqa
    0x0040A603: ('CS', '1', "Procedure Context Flag (Trial)", 'Retired', 'ProcedureContextFlagTrial'),  # noqa
    0x0040A730: ('SQ', '1', "Content Sequence", '', 'ContentSequence'),  # noqa
    0x0040A731: ('SQ', '1', "Relationship Sequence (Trial)", 'Retired', 'RelationshipSequenceTrial'),  # noqa
    0x0040A732: ('SQ', '1', "Relationship Type Code Sequence (Trial)", 'Retired', 'RelationshipTypeCodeSequenceTrial'),  # noqa
    0x0040A744: ('SQ', '1', "Language Code Sequence (Trial)", 'Retired', 'LanguageCodeSequenceTrial'),  # noqa
    0x0040A992: ('ST', '1', "Uniform Resource Locator (Trial)", 'Retired', 'UniformResourceLocatorTrial'),  # noqa
    0x0040B020: ('SQ', '1', "Waveform Annotation Sequence", '', 'WaveformAnnotationSequence'),  # noqa
    0x0040DB00: ('CS', '1', "Template Identifier", '', 'TemplateIdentifier'),  # noqa
    0x0040DB06: ('DT', '1', "Template Version", 'Retired', 'TemplateVersion'),  # noqa
    0x0040DB07: ('DT', '1', "Template Local Version", 'Retired', 'TemplateLocalVersion'),  # noqa
    0x0040DB0B: ('CS', '1', "Template Extension Flag", 'Retired', 'TemplateExtensionFlag'),  # noqa
    0x0040DB0C: ('UI', '1', "Template Extension Organization UID", 'Retired', 'TemplateExtensionOrganizationUID'),  # noqa
    0x0040DB0D: ('UI', '1', "Template Extension Creator UID", 'Retired', 'TemplateExtensionCreatorUID'),  # noqa
    0x0040DB73: ('UL', '1-n', "Referenced Content Item Identifier", '', 'ReferencedContentItemIdentifier'),  # noqa
    0x0040E001: ('ST', '1', "HL7 Instance Identifier", '', 'HL7InstanceIdentifier'),  # noqa
    0x0040E004: ('DT', '1', "HL7 Document Effective Time", '', 'HL7DocumentEffectiveTime'),  # noqa
    0x0040E006: ('SQ', '1', "HL7 Document Type Code Sequence", '', 'HL7DocumentTypeCodeSequence'),  # noqa
    0x0040E008: ('SQ', '1', "Document Class Code Sequence", '', 'DocumentClassCodeSequence'),  # noqa
    0x0040E010: ('UR', '1', "Retrieve URI", '', 'RetrieveURI'),  # noqa
    0x0040E011: ('UI', '1', "Retrieve Location UID", '', 'RetrieveLocationUID'),  # noqa
    0x0040E020: ('CS', '1', "Type of Instances", '', 'TypeOfInstances'),  # noqa
    0x0040E021: ('SQ', '1', "DICOM Retrieval Sequence", '', 'DICOMRetrievalSequence'),  # noqa
    0x0040E022: ('SQ', '1', "DICOM Media Retrieval Sequence", '', 'DICOMMediaRetrievalSequence'),  # noqa
    0x0040E023: ('SQ', '1', "WADO Retrieval Sequence", '', 'WADORetrievalSequence'),  # noqa
    0x0040E024: ('SQ', '1', "XDS Retrieval Sequence", '', 'XDSRetrievalSequence'),  # noqa
    0x0040E025: ('SQ', '1', "WADO-RS Retrieval Sequence", '', 'WADORSRetrievalSequence'),  # noqa
    0x0040E030: ('UI', '1', "Repository Unique ID", '', 'RepositoryUniqueID'),  # noqa
    0x0040E031: ('UI', '1', "Home Community ID", '', 'HomeCommunityID'),  # noqa
    0x00420010: ('ST', '1', "Document Title", '', 'DocumentTitle'),  # noqa
    0x00420011: ('OB', '1', "Encapsulated Document", '', 'EncapsulatedDocument'),  # noqa
    0x00420012: ('LO', '1', "MIME Type of Encapsulated Document", '', 'MIMETypeOfEncapsulatedDocument'),  # noqa
    0x00420013: ('SQ', '1', "Source Instance Sequence", '', 'SourceInstanceSequence'),  # noqa
    0x00420014: ('LO', '1-n', "List of MIME Types", '', 'ListOfMIMETypes'),  # noqa
    0x00440001: ('ST', '1', "Product Package Identifier", '', 'ProductPackageIdentifier'),  # noqa
    0x00440002: ('CS', '1', "Substance Administration Approval", '', 'SubstanceAdministrationApproval'),  # noqa
    0x00440003: ('LT', '1', "Approval Status Further Description", '', 'ApprovalStatusFurtherDescription'),  # noqa
    0x00440004: ('DT', '1', "Approval Status DateTime", '', 'ApprovalStatusDateTime'),  # noqa
    0x00440007: ('SQ', '1', "Product Type Code Sequence", '', 'ProductTypeCodeSequence'),  # noqa
    0x00440008: ('LO', '1-n', "Product Name", '', 'ProductName'),  # noqa
    0x00440009: ('LT', '1', "Product Description", '', 'ProductDescription'),  # noqa
    0x0044000A: ('LO', '1', "Product Lot Identifier", '', 'ProductLotIdentifier'),  # noqa
    0x0044000B: ('DT', '1', "Product Expiration DateTime", '', 'ProductExpirationDateTime'),  # noqa
    0x00440010: ('DT', '1', "Substance Administration DateTime", '', 'SubstanceAdministrationDateTime'),  # noqa
    0x00440011: ('LO', '1', "Substance Administration Notes", '', 'SubstanceAdministrationNotes'),  # noqa
    0x00440012: ('LO', '1', "Substance Administration Device ID", '', 'SubstanceAdministrationDeviceID'),  # noqa
    0x00440013: ('SQ', '1', "Product Parameter Sequence", '', 'ProductParameterSequence'),  # noqa
    0x00440019: ('SQ', '1', "Substance Administration Parameter Sequence", '', 'SubstanceAdministrationParameterSequence'),  # noqa
    0x00440100: ('SQ', '1', "Approval Sequence", '', 'ApprovalSequence'),  # noqa
    0x00440101: ('SQ', '1', "Assertion Code Sequence", '', 'AssertionCodeSequence'),  # noqa
    0x00440102: ('UI', '1', "Assertion UID", '', 'AssertionUID'),  # noqa
    0x00440103: ('SQ', '1', "Asserter Identification Sequence", '', 'AsserterIdentificationSequence'),  # noqa
    0x00440104: ('DT', '1', "Assertion DateTime", '', 'AssertionDateTime'),  # noqa
    0x00440105: ('DT', '1', "Assertion Expiration DateTime", '', 'AssertionExpirationDateTime'),  # noqa
    0x00440106: ('UT', '1', "Assertion Comments", '', 'AssertionComments'),  # noqa
    0x00440107: ('SQ', '1', "Related Assertion Sequence", '', 'RelatedAssertionSequence'),  # noqa
    0x00440108: ('UI', '1', "Referenced Assertion UID", '', 'ReferencedAssertionUID'),  # noqa
    0x00440109: ('SQ', '1', "Approval Subject Sequence", '', 'ApprovalSubjectSequence'),  # noqa
    0x0044010A: ('SQ', '1', "Organizational Role Code Sequence", '', 'OrganizationalRoleCodeSequence'),  # noqa
    0x00460012: ('LO', '1', "Lens Description", '', 'LensDescription'),  # noqa
    0x00460014: ('SQ', '1', "Right Lens Sequence", '', 'RightLensSequence'),  # noqa
    0x00460015: ('SQ', '1', "Left Lens Sequence", '', 'LeftLensSequence'),  # noqa
    0x00460016: ('SQ', '1', "Unspecified Laterality Lens Sequence", '', 'UnspecifiedLateralityLensSequence'),  # noqa
    0x00460018: ('SQ', '1', "Cylinder Sequence", '', 'CylinderSequence'),  # noqa
    0x00460028: ('SQ', '1', "Prism Sequence", '', 'PrismSequence'),  # noqa
    0x00460030: ('FD', '1', "Horizontal Prism Power", '', 'HorizontalPrismPower'),  # noqa
    0x00460032: ('CS', '1', "Horizontal Prism Base", '', 'HorizontalPrismBase'),  # noqa
    0x00460034: ('FD', '1', "Vertical Prism Power", '', 'VerticalPrismPower'),  # noqa
    0x00460036: ('CS', '1', "Vertical Prism Base", '', 'VerticalPrismBase'),  # noqa
    0x00460038: ('CS', '1', "Lens Segment Type", '', 'LensSegmentType'),  # noqa
    0x00460040: ('FD', '1', "Optical Transmittance", '', 'OpticalTransmittance'),  # noqa
    0x00460042: ('FD', '1', "Channel Width", '', 'ChannelWidth'),  # noqa
    0x00460044: ('FD', '1', "Pupil Size", '', 'PupilSize'),  # noqa
    0x00460046: ('FD', '1', "Corneal Size", '', 'CornealSize'),  # noqa
    0x00460050: ('SQ', '1', "Autorefraction Right Eye Sequence", '', 'AutorefractionRightEyeSequence'),  # noqa
    0x00460052: ('SQ', '1', "Autorefraction Left Eye Sequence", '', 'AutorefractionLeftEyeSequence'),  # noqa
    0x00460060: ('FD', '1', "Distance Pupillary Distance", '', 'DistancePupillaryDistance'),  # noqa
    0x00460062: ('FD', '1', "Near Pupillary Distance", '', 'NearPupillaryDistance'),  # noqa
    0x00460063: ('FD', '1', "Intermediate Pupillary Distance", '', 'IntermediatePupillaryDistance'),  # noqa
    0x00460064: ('FD', '1', "Other Pupillary Distance", '', 'OtherPupillaryDistance'),  # noqa
    0x00460070: ('SQ', '1', "Keratometry Right Eye Sequence", '', 'KeratometryRightEyeSequence'),  # noqa
    0x00460071: ('SQ', '1', "Keratometry Left Eye Sequence", '', 'KeratometryLeftEyeSequence'),  # noqa
    0x00460074: ('SQ', '1', "Steep Keratometric Axis Sequence", '', 'SteepKeratometricAxisSequence'),  # noqa
    0x00460075: ('FD', '1', "Radius of Curvature", '', 'RadiusOfCurvature'),  # noqa
    0x00460076: ('FD', '1', "Keratometric Power", '', 'KeratometricPower'),  # noqa
    0x00460077: ('FD', '1', "Keratometric Axis", '', 'KeratometricAxis'),  # noqa
    0x00460080: ('SQ', '1', "Flat Keratometric Axis Sequence", '', 'FlatKeratometricAxisSequence'),  # noqa
    0x00460092: ('CS', '1', "Background Color", '', 'BackgroundColor'),  # noqa
    0x00460094: ('CS', '1', "Optotype", '', 'Optotype'),  # noqa
    0x00460095: ('CS', '1', "Optotype Presentation", '', 'OptotypePresentation'),  # noqa
    0x00460097: ('SQ', '1', "Subjective Refraction Right Eye Sequence", '', 'SubjectiveRefractionRightEyeSequence'),  # noqa
    0x00460098: ('SQ', '1', "Subjective Refraction Left Eye Sequence", '', 'SubjectiveRefractionLeftEyeSequence'),  # noqa
    0x00460100: ('SQ', '1', "Add Near Sequence", '', 'AddNearSequence'),  # noqa
    0x00460101: ('SQ', '1', "Add Intermediate Sequence", '', 'AddIntermediateSequence'),  # noqa
    0x00460102: ('SQ', '1', "Add Other Sequence", '', 'AddOtherSequence'),  # noqa
    0x00460104: ('FD', '1', "Add Power", '', 'AddPower'),  # noqa
    0x00460106: ('FD', '1', "Viewing Distance", '', 'ViewingDistance'),  # noqa
    0x00460121: ('SQ', '1', "Visual Acuity Type Code Sequence", '', 'VisualAcuityTypeCodeSequence'),  # noqa
    0x00460122: ('SQ', '1', "Visual Acuity Right Eye Sequence", '', 'VisualAcuityRightEyeSequence'),  # noqa
    0x00460123: ('SQ', '1', "Visual Acuity Left Eye Sequence", '', 'VisualAcuityLeftEyeSequence'),  # noqa
    0x00460124: ('SQ', '1', "Visual Acuity Both Eyes Open Sequence", '', 'VisualAcuityBothEyesOpenSequence'),  # noqa
    0x00460125: ('CS', '1', "Viewing Distance Type", '', 'ViewingDistanceType'),  # noqa
    0x00460135: ('SS', '2', "Visual Acuity Modifiers", '', 'VisualAcuityModifiers'),  # noqa
    0x00460137: ('FD', '1', "Decimal Visual Acuity", '', 'DecimalVisualAcuity'),  # noqa
    0x00460139: ('LO', '1', "Optotype Detailed Definition", '', 'OptotypeDetailedDefinition'),  # noqa
    0x00460145: ('SQ', '1', "Referenced Refractive Measurements Sequence", '', 'ReferencedRefractiveMeasurementsSequence'),  # noqa
    0x00460146: ('FD', '1', "Sphere Power", '', 'SpherePower'),  # noqa
    0x00460147: ('FD', '1', "Cylinder Power", '', 'CylinderPower'),  # noqa
    0x00460201: ('CS', '1', "Corneal Topography Surface", '', 'CornealTopographySurface'),  # noqa
    0x00460202: ('FL', '2', "Corneal Vertex Location", '', 'CornealVertexLocation'),  # noqa
    0x00460203: ('FL', '1', "Pupil Centroid X-Coordinate", '', 'PupilCentroidXCoordinate'),  # noqa
    0x00460204: ('FL', '1', "Pupil Centroid Y-Coordinate", '', 'PupilCentroidYCoordinate'),  # noqa
    0x00460205: ('FL', '1', "Equivalent Pupil Radius", '', 'EquivalentPupilRadius'),  # noqa
    0x00460207: ('SQ', '1', "Corneal Topography Map Type Code Sequence", '', 'CornealTopographyMapTypeCodeSequence'),  # noqa
    0x00460208: ('IS', '2-2n', "Vertices of the Outline of Pupil", '', 'VerticesOfTheOutlineOfPupil'),  # noqa
    0x00460210: ('SQ', '1', "Corneal Topography Mapping Normals Sequence", '', 'CornealTopographyMappingNormalsSequence'),  # noqa
    0x00460211: ('SQ', '1', "Maximum Corneal Curvature Sequence", '', 'MaximumCornealCurvatureSequence'),  # noqa
    0x00460212: ('FL', '1', "Maximum Corneal Curvature", '', 'MaximumCornealCurvature'),  # noqa
    0x00460213: ('FL', '2', "Maximum Corneal Curvature Location", '', 'MaximumCornealCurvatureLocation'),  # noqa
    0x00460215: ('SQ', '1', "Minimum Keratometric Sequence", '', 'MinimumKeratometricSequence'),  # noqa
    0x00460218: ('SQ', '1', "Simulated Keratometric Cylinder Sequence", '', 'SimulatedKeratometricCylinderSequence'),  # noqa
    0x00460220: ('FL', '1', "Average Corneal Power", '', 'AverageCornealPower'),  # noqa
    0x00460224: ('FL', '1', "Corneal I-S Value", '', 'CornealISValue'),  # noqa
    0x00460227: ('FL', '1', "Analyzed Area", '', 'AnalyzedArea'),  # noqa
    0x00460230: ('FL', '1', "Surface Regularity Index", '', 'SurfaceRegularityIndex'),  # noqa
    0x00460232: ('FL', '1', "Surface Asymmetry Index", '', 'SurfaceAsymmetryIndex'),  # noqa
    0x00460234: ('FL', '1', "Corneal Eccentricity Index", '', 'CornealEccentricityIndex'),  # noqa
    0x00460236: ('FL', '1', "Keratoconus Prediction Index", '', 'KeratoconusPredictionIndex'),  # noqa
    0x00460238: ('FL', '1', "Decimal Potential Visual Acuity", '', 'DecimalPotentialVisualAcuity'),  # noqa
    0x00460242: ('CS', '1', "Corneal Topography Map Quality Evaluation", '', 'CornealTopographyMapQualityEvaluation'),  # noqa
    0x00460244: ('SQ', '1', "Source Image Corneal Processed Data Sequence", '', 'SourceImageCornealProcessedDataSequence'),  # noqa
    0x00460247: ('FL', '3', "Corneal Point Location", '', 'CornealPointLocation'),  # noqa
    0x00460248: ('CS', '1', "Corneal Point Estimated", '', 'CornealPointEstimated'),  # noqa
    0x00460249: ('FL', '1', "Axial Power", '', 'AxialPower'),  # noqa
    0x00460250: ('FL', '1', "Tangential Power", '', 'TangentialPower'),  # noqa
    0x00460251: ('FL', '1', "Refractive Power", '', 'RefractivePower'),  # noqa
    0x00460252: ('FL', '1', "Relative Elevation", '', 'RelativeElevation'),  # noqa
    0x00460253: ('FL', '1', "Corneal Wavefront", '', 'CornealWavefront'),  # noqa
    0x00480001: ('FL', '1', "Imaged Volume Width", '', 'ImagedVolumeWidth'),  # noqa
    0x00480002: ('FL', '1', "Imaged Volume Height", '', 'ImagedVolumeHeight'),  # noqa
    0x00480003: ('FL', '1', "Imaged Volume Depth", '', 'ImagedVolumeDepth'),  # noqa
    0x00480006: ('UL', '1', "Total Pixel Matrix Columns", '', 'TotalPixelMatrixColumns'),  # noqa
    0x00480007: ('UL', '1', "Total Pixel Matrix Rows", '', 'TotalPixelMatrixRows'),  # noqa
    0x00480008: ('SQ', '1', "Total Pixel Matrix Origin Sequence", '', 'TotalPixelMatrixOriginSequence'),  # noqa
    0x00480010: ('CS', '1', "Specimen Label in Image", '', 'SpecimenLabelInImage'),  # noqa
    0x00480011: ('CS', '1', "Focus Method", '', 'FocusMethod'),  # noqa
    0x00480012: ('CS', '1', "Extended Depth of Field", '', 'ExtendedDepthOfField'),  # noqa
    0x00480013: ('US', '1', "Number of Focal Planes", '', 'NumberOfFocalPlanes'),  # noqa
    0x00480014: ('FL', '1', "Distance Between Focal Planes", '', 'DistanceBetweenFocalPlanes'),  # noqa
    0x00480015: ('US', '3', "Recommended Absent Pixel CIELab Value", '', 'RecommendedAbsentPixelCIELabValue'),  # noqa
    0x00480100: ('SQ', '1', "Illuminator Type Code Sequence", '', 'IlluminatorTypeCodeSequence'),  # noqa
    0x00480102: ('DS', '6', "Image Orientation (Slide)", '', 'ImageOrientationSlide'),  # noqa
    0x00480105: ('SQ', '1', "Optical Path Sequence", '', 'OpticalPathSequence'),  # noqa
    0x00480106: ('SH', '1', "Optical Path Identifier", '', 'OpticalPathIdentifier'),  # noqa
    0x00480107: ('ST', '1', "Optical Path Description", '', 'OpticalPathDescription'),  # noqa
    0x00480108: ('SQ', '1', "Illumination Color Code Sequence", '', 'IlluminationColorCodeSequence'),  # noqa
    0x00480110: ('SQ', '1', "Specimen Reference Sequence", '', 'SpecimenReferenceSequence'),  # noqa
    0x00480111: ('DS', '1', "Condenser Lens Power", '', 'CondenserLensPower'),  # noqa
    0x00480112: ('DS', '1', "Objective Lens Power", '', 'ObjectiveLensPower'),  # noqa
    0x00480113: ('DS', '1', "Objective Lens Numerical Aperture", '', 'ObjectiveLensNumericalAperture'),  # noqa
    0x00480120: ('SQ', '1', "Palette Color Lookup Table Sequence", '', 'PaletteColorLookupTableSequence'),  # noqa
    0x00480200: ('SQ', '1', "Referenced Image Navigation Sequence", '', 'ReferencedImageNavigationSequence'),  # noqa
    0x00480201: ('US', '2', "Top Left Hand Corner of Localizer Area", '', 'TopLeftHandCornerOfLocalizerArea'),  # noqa
    0x00480202: ('US', '2', "Bottom Right Hand Corner of Localizer Area", '', 'BottomRightHandCornerOfLocalizerArea'),  # noqa
    0x00480207: ('SQ', '1', "Optical Path Identification Sequence", '', 'OpticalPathIdentificationSequence'),  # noqa
    0x0048021A: ('SQ', '1', "Plane Position (Slide) Sequence", '', 'PlanePositionSlideSequence'),  # noqa
    0x0048021E: ('SL', '1', "Column Position In Total Image Pixel Matrix", '', 'ColumnPositionInTotalImagePixelMatrix'),  # noqa
    0x0048021F: ('SL', '1', "Row Position In Total Image Pixel Matrix", '', 'RowPositionInTotalImagePixelMatrix'),  # noqa
    0x00480301: ('CS', '1', "Pixel Origin Interpretation", '', 'PixelOriginInterpretation'),  # noqa
    0x00500004: ('CS', '1', "Calibration Image", '', 'CalibrationImage'),  # noqa
    0x00500010: ('SQ', '1', "Device Sequence", '', 'DeviceSequence'),  # noqa
    0x00500012: ('SQ', '1', "Container Component Type Code Sequence", '', 'ContainerComponentTypeCodeSequence'),  # noqa
    0x00500013: ('FD', '1', "Container Component Thickness", '', 'ContainerComponentThickness'),  # noqa
    0x00500014: ('DS', '1', "Device Length", '', 'DeviceLength'),  # noqa
    0x00500015: ('FD', '1', "Container Component Width", '', 'ContainerComponentWidth'),  # noqa
    0x00500016: ('DS', '1', "Device Diameter", '', 'DeviceDiameter'),  # noqa
    0x00500017: ('CS', '1', "Device Diameter Units", '', 'DeviceDiameterUnits'),  # noqa
    0x00500018: ('DS', '1', "Device Volume", '', 'DeviceVolume'),  # noqa
    0x00500019: ('DS', '1', "Inter-Marker Distance", '', 'InterMarkerDistance'),  # noqa
    0x0050001A: ('CS', '1', "Container Component Material", '', 'ContainerComponentMaterial'),  # noqa
    0x0050001B: ('LO', '1', "Container Component ID", '', 'ContainerComponentID'),  # noqa
    0x0050001C: ('FD', '1', "Container Component Length", '', 'ContainerComponentLength'),  # noqa
    0x0050001D: ('FD', '1', "Container Component Diameter", '', 'ContainerComponentDiameter'),  # noqa
    0x0050001E: ('LO', '1', "Container Component Description", '', 'ContainerComponentDescription'),  # noqa
    0x00500020: ('LO', '1', "Device Description", '', 'DeviceDescription'),  # noqa
    0x00520001: ('FL', '1', "Contrast/Bolus Ingredient Percent by Volume", '', 'ContrastBolusIngredientPercentByVolume'),  # noqa
    0x00520002: ('FD', '1', "OCT Focal Distance", '', 'OCTFocalDistance'),  # noqa
    0x00520003: ('FD', '1', "Beam Spot Size", '', 'BeamSpotSize'),  # noqa
    0x00520004: ('FD', '1', "Effective Refractive Index", '', 'EffectiveRefractiveIndex'),  # noqa
    0x00520006: ('CS', '1', "OCT Acquisition Domain", '', 'OCTAcquisitionDomain'),  # noqa
    0x00520007: ('FD', '1', "OCT Optical Center Wavelength", '', 'OCTOpticalCenterWavelength'),  # noqa
    0x00520008: ('FD', '1', "Axial Resolution", '', 'AxialResolution'),  # noqa
    0x00520009: ('FD', '1', "Ranging Depth", '', 'RangingDepth'),  # noqa
    0x00520011: ('FD', '1', "A-line Rate", '', 'ALineRate'),  # noqa
    0x00520012: ('US', '1', "A-lines Per Frame", '', 'ALinesPerFrame'),  # noqa
    0x00520013: ('FD', '1', "Catheter Rotational Rate", '', 'CatheterRotationalRate'),  # noqa
    0x00520014: ('FD', '1', "A-line Pixel Spacing", '', 'ALinePixelSpacing'),  # noqa
    0x00520016: ('SQ', '1', "Mode of Percutaneous Access Sequence", '', 'ModeOfPercutaneousAccessSequence'),  # noqa
    0x00520025: ('SQ', '1', "Intravascular OCT Frame Type Sequence", '', 'IntravascularOCTFrameTypeSequence'),  # noqa
    0x00520026: ('CS', '1', "OCT Z Offset Applied", '', 'OCTZOffsetApplied'),  # noqa
    0x00520027: ('SQ', '1', "Intravascular Frame Content Sequence", '', 'IntravascularFrameContentSequence'),  # noqa
    0x00520028: ('FD', '1', "Intravascular Longitudinal Distance", '', 'IntravascularLongitudinalDistance'),  # noqa
    0x00520029: ('SQ', '1', "Intravascular OCT Frame Content Sequence", '', 'IntravascularOCTFrameContentSequence'),  # noqa
    0x00520030: ('SS', '1', "OCT Z Offset Correction", '', 'OCTZOffsetCorrection'),  # noqa
    0x00520031: ('CS', '1', "Catheter Direction of Rotation", '', 'CatheterDirectionOfRotation'),  # noqa
    0x00520033: ('FD', '1', "Seam Line Location", '', 'SeamLineLocation'),  # noqa
    0x00520034: ('FD', '1', "First A-line Location", '', 'FirstALineLocation'),  # noqa
    0x00520036: ('US', '1', "Seam Line Index", '', 'SeamLineIndex'),  # noqa
    0x00520038: ('US', '1', "Number of Padded A-lines", '', 'NumberOfPaddedALines'),  # noqa
    0x00520039: ('CS', '1', "Interpolation Type", '', 'InterpolationType'),  # noqa
    0x0052003A: ('CS', '1', "Refractive Index Applied", '', 'RefractiveIndexApplied'),  # noqa
    0x00540010: ('US', '1-n', "Energy Window Vector", '', 'EnergyWindowVector'),  # noqa
    0x00540011: ('US', '1', "Number of Energy Windows", '', 'NumberOfEnergyWindows'),  # noqa
    0x00540012: ('SQ', '1', "Energy Window Information Sequence", '', 'EnergyWindowInformationSequence'),  # noqa
    0x00540013: ('SQ', '1', "Energy Window Range Sequence", '', 'EnergyWindowRangeSequence'),  # noqa
    0x00540014: ('DS', '1', "Energy Window Lower Limit", '', 'EnergyWindowLowerLimit'),  # noqa
    0x00540015: ('DS', '1', "Energy Window Upper Limit", '', 'EnergyWindowUpperLimit'),  # noqa
    0x00540016: ('SQ', '1', "Radiopharmaceutical Information Sequence", '', 'RadiopharmaceuticalInformationSequence'),  # noqa
    0x00540017: ('IS', '1', "Residual Syringe Counts", '', 'ResidualSyringeCounts'),  # noqa
    0x00540018: ('SH', '1', "Energy Window Name", '', 'EnergyWindowName'),  # noqa
    0x00540020: ('US', '1-n', "Detector Vector", '', 'DetectorVector'),  # noqa
    0x00540021: ('US', '1', "Number of Detectors", '', 'NumberOfDetectors'),  # noqa
    0x00540022: ('SQ', '1', "Detector Information Sequence", '', 'DetectorInformationSequence'),  # noqa
    0x00540030: ('US', '1-n', "Phase Vector", '', 'PhaseVector'),  # noqa
    0x00540031: ('US', '1', "Number of Phases", '', 'NumberOfPhases'),  # noqa
    0x00540032: ('SQ', '1', "Phase Information Sequence", '', 'PhaseInformationSequence'),  # noqa
    0x00540033: ('US', '1', "Number of Frames in Phase", '', 'NumberOfFramesInPhase'),  # noqa
    0x00540036: ('IS', '1', "Phase Delay", '', 'PhaseDelay'),  # noqa
    0x00540038: ('IS', '1', "Pause Between Frames", '', 'PauseBetweenFrames'),  # noqa
    0x00540039: ('CS', '1', "Phase Description", '', 'PhaseDescription'),  # noqa
    0x00540050: ('US', '1-n', "Rotation Vector", '', 'RotationVector'),  # noqa
    0x00540051: ('US', '1', "Number of Rotations", '', 'NumberOfRotations'),  # noqa
    0x00540052: ('SQ', '1', "Rotation Information Sequence", '', 'RotationInformationSequence'),  # noqa
    0x00540053: ('US', '1', "Number of Frames in Rotation", '', 'NumberOfFramesInRotation'),  # noqa
    0x00540060: ('US', '1-n', "R-R Interval Vector", '', 'RRIntervalVector'),  # noqa
    0x00540061: ('US', '1', "Number of R-R Intervals", '', 'NumberOfRRIntervals'),  # noqa
    0x00540062: ('SQ', '1', "Gated Information Sequence", '', 'GatedInformationSequence'),  # noqa
    0x00540063: ('SQ', '1', "Data Information Sequence", '', 'DataInformationSequence'),  # noqa
    0x00540070: ('US', '1-n', "Time Slot Vector", '', 'TimeSlotVector'),  # noqa
    0x00540071: ('US', '1', "Number of Time Slots", '', 'NumberOfTimeSlots'),  # noqa
    0x00540072: ('SQ', '1', "Time Slot Information Sequence", '', 'TimeSlotInformationSequence'),  # noqa
    0x00540073: ('DS', '1', "Time Slot Time", '', 'TimeSlotTime'),  # noqa
    0x00540080: ('US', '1-n', "Slice Vector", '', 'SliceVector'),  # noqa
    0x00540081: ('US', '1', "Number of Slices", '', 'NumberOfSlices'),  # noqa
    0x00540090: ('US', '1-n', "Angular View Vector", '', 'AngularViewVector'),  # noqa
    0x00540100: ('US', '1-n', "Time Slice Vector", '', 'TimeSliceVector'),  # noqa
    0x00540101: ('US', '1', "Number of Time Slices", '', 'NumberOfTimeSlices'),  # noqa
    0x00540200: ('DS', '1', "Start Angle", '', 'StartAngle'),  # noqa
    0x00540202: ('CS', '1', "Type of Detector Motion", '', 'TypeOfDetectorMotion'),  # noqa
    0x00540210: ('IS', '1-n', "Trigger Vector", '', 'TriggerVector'),  # noqa
    0x00540211: ('US', '1', "Number of Triggers in Phase", '', 'NumberOfTriggersInPhase'),  # noqa
    0x00540220: ('SQ', '1', "View Code Sequence", '', 'ViewCodeSequence'),  # noqa
    0x00540222: ('SQ', '1', "View Modifier Code Sequence", '', 'ViewModifierCodeSequence'),  # noqa
    0x00540300: ('SQ', '1', "Radionuclide Code Sequence", '', 'RadionuclideCodeSequence'),  # noqa
    0x00540302: ('SQ', '1', "Administration Route Code Sequence", '', 'AdministrationRouteCodeSequence'),  # noqa
    0x00540304: ('SQ', '1', "Radiopharmaceutical Code Sequence", '', 'RadiopharmaceuticalCodeSequence'),  # noqa
    0x00540306: ('SQ', '1', "Calibration Data Sequence", '', 'CalibrationDataSequence'),  # noqa
    0x00540308: ('US', '1', "Energy Window Number", '', 'EnergyWindowNumber'),  # noqa
    0x00540400: ('SH', '1', "Image ID", '', 'ImageID'),  # noqa
    0x00540410: ('SQ', '1', "Patient Orientation Code Sequence", '', 'PatientOrientationCodeSequence'),  # noqa
    0x00540412: ('SQ', '1', "Patient Orientation Modifier Code Sequence", '', 'PatientOrientationModifierCodeSequence'),  # noqa
    0x00540414: ('SQ', '1', "Patient Gantry Relationship Code Sequence", '', 'PatientGantryRelationshipCodeSequence'),  # noqa
    0x00540500: ('CS', '1', "Slice Progression Direction", '', 'SliceProgressionDirection'),  # noqa
    0x00540501: ('CS', '1', "Scan Progression Direction", '', 'ScanProgressionDirection'),  # noqa
    0x00541000: ('CS', '2', "Series Type", '', 'SeriesType'),  # noqa
    0x00541001: ('CS', '1', "Units", '', 'Units'),  # noqa
    0x00541002: ('CS', '1', "Counts Source", '', 'CountsSource'),  # noqa
    0x00541004: ('CS', '1', "Reprojection Method", '', 'ReprojectionMethod'),  # noqa
    0x00541006: ('CS', '1', "SUV Type", '', 'SUVType'),  # noqa
    0x00541100: ('CS', '1', "Randoms Correction Method", '', 'RandomsCorrectionMethod'),  # noqa
    0x00541101: ('LO', '1', "Attenuation Correction Method", '', 'AttenuationCorrectionMethod'),  # noqa
    0x00541102: ('CS', '1', "Decay Correction", '', 'DecayCorrection'),  # noqa
    0x00541103: ('LO', '1', "Reconstruction Method", '', 'ReconstructionMethod'),  # noqa
    0x00541104: ('LO', '1', "Detector Lines of Response Used", '', 'DetectorLinesOfResponseUsed'),  # noqa
    0x00541105: ('LO', '1', "Scatter Correction Method", '', 'ScatterCorrectionMethod'),  # noqa
    0x00541200: ('DS', '1', "Axial Acceptance", '', 'AxialAcceptance'),  # noqa
    0x00541201: ('IS', '2', "Axial Mash", '', 'AxialMash'),  # noqa
    0x00541202: ('IS', '1', "Transverse Mash", '', 'TransverseMash'),  # noqa
    0x00541203: ('DS', '2', "Detector Element Size", '', 'DetectorElementSize'),  # noqa
    0x00541210: ('DS', '1', "Coincidence Window Width", '', 'CoincidenceWindowWidth'),  # noqa
    0x00541220: ('CS', '1-n', "Secondary Counts Type", '', 'SecondaryCountsType'),  # noqa
    0x00541300: ('DS', '1', "Frame Reference Time", '', 'FrameReferenceTime'),  # noqa
    0x00541310: ('IS', '1', "Primary (Prompts) Counts Accumulated", '', 'PrimaryPromptsCountsAccumulated'),  # noqa
    0x00541311: ('IS', '1-n', "Secondary Counts Accumulated", '', 'SecondaryCountsAccumulated'),  # noqa
    0x00541320: ('DS', '1', "Slice Sensitivity Factor", '', 'SliceSensitivityFactor'),  # noqa
    0x00541321: ('DS', '1', "Decay Factor", '', 'DecayFactor'),  # noqa
    0x00541322: ('DS', '1', "Dose Calibration Factor", '', 'DoseCalibrationFactor'),  # noqa
    0x00541323: ('DS', '1', "Scatter Fraction Factor", '', 'ScatterFractionFactor'),  # noqa
    0x00541324: ('DS', '1', "Dead Time Factor", '', 'DeadTimeFactor'),  # noqa
    0x00541330: ('US', '1', "Image Index", '', 'ImageIndex'),  # noqa
    0x00541400: ('CS', '1-n', "Counts Included", 'Retired', 'CountsIncluded'),  # noqa
    0x00541401: ('CS', '1', "Dead Time Correction Flag", 'Retired', 'DeadTimeCorrectionFlag'),  # noqa
    0x00603000: ('SQ', '1', "Histogram Sequence", '', 'HistogramSequence'),  # noqa
    0x00603002: ('US', '1', "Histogram Number of Bins", '', 'HistogramNumberOfBins'),  # noqa
    0x00603004: ('US or SS', '1', "Histogram First Bin Value", '', 'HistogramFirstBinValue'),  # noqa
    0x00603006: ('US or SS', '1', "Histogram Last Bin Value", '', 'HistogramLastBinValue'),  # noqa
    0x00603008: ('US', '1', "Histogram Bin Width", '', 'HistogramBinWidth'),  # noqa
    0x00603010: ('LO', '1', "Histogram Explanation", '', 'HistogramExplanation'),  # noqa
    0x00603020: ('UL', '1-n', "Histogram Data", '', 'HistogramData'),  # noqa
    0x00620001: ('CS', '1', "Segmentation Type", '', 'SegmentationType'),  # noqa
    0x00620002: ('SQ', '1', "Segment Sequence", '', 'SegmentSequence'),  # noqa
    0x00620003: ('SQ', '1', "Segmented Property Category Code Sequence", '', 'SegmentedPropertyCategoryCodeSequence'),  # noqa
    0x00620004: ('US', '1', "Segment Number", '', 'SegmentNumber'),  # noqa
    0x00620005: ('LO', '1', "Segment Label", '', 'SegmentLabel'),  # noqa
    0x00620006: ('ST', '1', "Segment Description", '', 'SegmentDescription'),  # noqa
    0x00620007: ('SQ', '1', "Segmentation Algorithm Identification Sequence", '', 'SegmentationAlgorithmIdentificationSequence'),  # noqa
    0x00620008: ('CS', '1', "Segment Algorithm Type", '', 'SegmentAlgorithmType'),  # noqa
    0x00620009: ('LO', '1', "Segment Algorithm Name", '', 'SegmentAlgorithmName'),  # noqa
    0x0062000A: ('SQ', '1', "Segment Identification Sequence", '', 'SegmentIdentificationSequence'),  # noqa
    0x0062000B: ('US', '1-n', "Referenced Segment Number", '', 'ReferencedSegmentNumber'),  # noqa
    0x0062000C: ('US', '1', "Recommended Display Grayscale Value", '', 'RecommendedDisplayGrayscaleValue'),  # noqa
    0x0062000D: ('US', '3', "Recommended Display CIELab Value", '', 'RecommendedDisplayCIELabValue'),  # noqa
    0x0062000E: ('US', '1', "Maximum Fractional Value", '', 'MaximumFractionalValue'),  # noqa
    0x0062000F: ('SQ', '1', "Segmented Property Type Code Sequence", '', 'SegmentedPropertyTypeCodeSequence'),  # noqa
    0x00620010: ('CS', '1', "Segmentation Fractional Type", '', 'SegmentationFractionalType'),  # noqa
    0x00620011: ('SQ', '1', "Segmented Property Type Modifier Code Sequence", '', 'SegmentedPropertyTypeModifierCodeSequence'),  # noqa
    0x00620012: ('SQ', '1', "Used Segments Sequence", '', 'UsedSegmentsSequence'),  # noqa
    0x00620020: ('UT', '1', "Tracking ID", '', 'TrackingID'),  # noqa
    0x00620021: ('UI', '1', "Tracking UID", '', 'TrackingUID'),  # noqa
    0x00640002: ('SQ', '1', "Deformable Registration Sequence", '', 'DeformableRegistrationSequence'),  # noqa
    0x00640003: ('UI', '1', "Source Frame of Reference UID", '', 'SourceFrameOfReferenceUID'),  # noqa
    0x00640005: ('SQ', '1', "Deformable Registration Grid Sequence", '', 'DeformableRegistrationGridSequence'),  # noqa
    0x00640007: ('UL', '3', "Grid Dimensions", '', 'GridDimensions'),  # noqa
    0x00640008: ('FD', '3', "Grid Resolution", '', 'GridResolution'),  # noqa
    0x00640009: ('OF', '1', "Vector Grid Data", '', 'VectorGridData'),  # noqa
    0x0064000F: ('SQ', '1', "Pre Deformation Matrix Registration Sequence", '', 'PreDeformationMatrixRegistrationSequence'),  # noqa
    0x00640010: ('SQ', '1', "Post Deformation Matrix Registration Sequence", '', 'PostDeformationMatrixRegistrationSequence'),  # noqa
    0x00660001: ('UL', '1', "Number of Surfaces", '', 'NumberOfSurfaces'),  # noqa
    0x00660002: ('SQ', '1', "Surface Sequence", '', 'SurfaceSequence'),  # noqa
    0x00660003: ('UL', '1', "Surface Number", '', 'SurfaceNumber'),  # noqa
    0x00660004: ('LT', '1', "Surface Comments", '', 'SurfaceComments'),  # noqa
    0x00660009: ('CS', '1', "Surface Processing", '', 'SurfaceProcessing'),  # noqa
    0x0066000A: ('FL', '1', "Surface Processing Ratio", '', 'SurfaceProcessingRatio'),  # noqa
    0x0066000B: ('LO', '1', "Surface Processing Description", '', 'SurfaceProcessingDescription'),  # noqa
    0x0066000C: ('FL', '1', "Recommended Presentation Opacity", '', 'RecommendedPresentationOpacity'),  # noqa
    0x0066000D: ('CS', '1', "Recommended Presentation Type", '', 'RecommendedPresentationType'),  # noqa
    0x0066000E: ('CS', '1', "Finite Volume", '', 'FiniteVolume'),  # noqa
    0x00660010: ('CS', '1', "Manifold", '', 'Manifold'),  # noqa
    0x00660011: ('SQ', '1', "Surface Points Sequence", '', 'SurfacePointsSequence'),  # noqa
    0x00660012: ('SQ', '1', "Surface Points Normals Sequence", '', 'SurfacePointsNormalsSequence'),  # noqa
    0x00660013: ('SQ', '1', "Surface Mesh Primitives Sequence", '', 'SurfaceMeshPrimitivesSequence'),  # noqa
    0x00660015: ('UL', '1', "Number of Surface Points", '', 'NumberOfSurfacePoints'),  # noqa
    0x00660016: ('OF', '1', "Point Coordinates Data", '', 'PointCoordinatesData'),  # noqa
    0x00660017: ('FL', '3', "Point Position Accuracy", '', 'PointPositionAccuracy'),  # noqa
    0x00660018: ('FL', '1', "Mean Point Distance", '', 'MeanPointDistance'),  # noqa
    0x00660019: ('FL', '1', "Maximum Point Distance", '', 'MaximumPointDistance'),  # noqa
    0x0066001A: ('FL', '6', "Points Bounding Box Coordinates", '', 'PointsBoundingBoxCoordinates'),  # noqa
    0x0066001B: ('FL', '3', "Axis of Rotation", '', 'AxisOfRotation'),  # noqa
    0x0066001C: ('FL', '3', "Center of Rotation", '', 'CenterOfRotation'),  # noqa
    0x0066001E: ('UL', '1', "Number of Vectors", '', 'NumberOfVectors'),  # noqa
    0x0066001F: ('US', '1', "Vector Dimensionality", '', 'VectorDimensionality'),  # noqa
    0x00660020: ('FL', '1-n', "Vector Accuracy", '', 'VectorAccuracy'),  # noqa
    0x00660021: ('OF', '1', "Vector Coordinate Data", '', 'VectorCoordinateData'),  # noqa
    0x00660023: ('OW', '1', "Triangle Point Index List", 'Retired', 'TrianglePointIndexList'),  # noqa
    0x00660024: ('OW', '1', "Edge Point Index List", 'Retired', 'EdgePointIndexList'),  # noqa
    0x00660025: ('OW', '1', "Vertex Point Index List", 'Retired', 'VertexPointIndexList'),  # noqa
    0x00660026: ('SQ', '1', "Triangle Strip Sequence", '', 'TriangleStripSequence'),  # noqa
    0x00660027: ('SQ', '1', "Triangle Fan Sequence", '', 'TriangleFanSequence'),  # noqa
    0x00660028: ('SQ', '1', "Line Sequence", '', 'LineSequence'),  # noqa
    0x00660029: ('OW', '1', "Primitive Point Index List", 'Retired', 'PrimitivePointIndexList'),  # noqa
    0x0066002A: ('UL', '1', "Surface Count", '', 'SurfaceCount'),  # noqa
    0x0066002B: ('SQ', '1', "Referenced Surface Sequence", '', 'ReferencedSurfaceSequence'),  # noqa
    0x0066002C: ('UL', '1', "Referenced Surface Number", '', 'ReferencedSurfaceNumber'),  # noqa
    0x0066002D: ('SQ', '1', "Segment Surface Generation Algorithm Identification Sequence", '', 'SegmentSurfaceGenerationAlgorithmIdentificationSequence'),  # noqa
    0x0066002E: ('SQ', '1', "Segment Surface Source Instance Sequence", '', 'SegmentSurfaceSourceInstanceSequence'),  # noqa
    0x0066002F: ('SQ', '1', "Algorithm Family Code Sequence", '', 'AlgorithmFamilyCodeSequence'),  # noqa
    0x00660030: ('SQ', '1', "Algorithm Name Code Sequence", '', 'AlgorithmNameCodeSequence'),  # noqa
    0x00660031: ('LO', '1', "Algorithm Version", '', 'AlgorithmVersion'),  # noqa
    0x00660032: ('LT', '1', "Algorithm Parameters", '', 'AlgorithmParameters'),  # noqa
    0x00660034: ('SQ', '1', "Facet Sequence", '', 'FacetSequence'),  # noqa
    0x00660035: ('SQ', '1', "Surface Processing Algorithm Identification Sequence", '', 'SurfaceProcessingAlgorithmIdentificationSequence'),  # noqa
    0x00660036: ('LO', '1', "Algorithm Name", '', 'AlgorithmName'),  # noqa
    0x00660037: ('FL', '1', "Recommended Point Radius", '', 'RecommendedPointRadius'),  # noqa
    0x00660038: ('FL', '1', "Recommended Line Thickness", '', 'RecommendedLineThickness'),  # noqa
    0x00660040: ('OL', '1', "Long Primitive Point Index List", '', 'LongPrimitivePointIndexList'),  # noqa
    0x00660041: ('OL', '1', "Long Triangle Point Index List", '', 'LongTrianglePointIndexList'),  # noqa
    0x00660042: ('OL', '1', "Long Edge Point Index List", '', 'LongEdgePointIndexList'),  # noqa
    0x00660043: ('OL', '1', "Long Vertex Point Index List", '', 'LongVertexPointIndexList'),  # noqa
    0x00660101: ('SQ', '1', "Track Set Sequence", '', 'TrackSetSequence'),  # noqa
    0x00660102: ('SQ', '1', "Track Sequence", '', 'TrackSequence'),  # noqa
    0x00660103: ('OW', '1', "Recommended Display CIELab Value List", '', 'RecommendedDisplayCIELabValueList'),  # noqa
    0x00660104: ('SQ', '1', "Tracking Algorithm Identification Sequence", '', 'TrackingAlgorithmIdentificationSequence'),  # noqa
    0x00660105: ('UL', '1', "Track Set Number", '', 'TrackSetNumber'),  # noqa
    0x00660106: ('LO', '1', "Track Set Label", '', 'TrackSetLabel'),  # noqa
    0x00660107: ('UT', '1', "Track Set Description", '', 'TrackSetDescription'),  # noqa
    0x00660108: ('SQ', '1', "Track Set Anatomical Type Code Sequence", '', 'TrackSetAnatomicalTypeCodeSequence'),  # noqa
    0x00660121: ('SQ', '1', "Measurements Sequence", '', 'MeasurementsSequence'),  # noqa
    0x00660124: ('SQ', '1', "Track Set Statistics Sequence", '', 'TrackSetStatisticsSequence'),  # noqa
    0x00660125: ('OF', '1', "Floating Point Values", '', 'FloatingPointValues'),  # noqa
    0x00660129: ('OL', '1', "Track Point Index List", '', 'TrackPointIndexList'),  # noqa
    0x00660130: ('SQ', '1', "Track Statistics Sequence", '', 'TrackStatisticsSequence'),  # noqa
    0x00660132: ('SQ', '1', "Measurement Values Sequence", '', 'MeasurementValuesSequence'),  # noqa
    0x00660133: ('SQ', '1', "Diffusion Acquisition Code Sequence", '', 'DiffusionAcquisitionCodeSequence'),  # noqa
    0x00660134: ('SQ', '1', "Diffusion Model Code Sequence", '', 'DiffusionModelCodeSequence'),  # noqa
    0x00686210: ('LO', '1', "Implant Size", '', 'ImplantSize'),  # noqa
    0x00686221: ('LO', '1', "Implant Template Version", '', 'ImplantTemplateVersion'),  # noqa
    0x00686222: ('SQ', '1', "Replaced Implant Template Sequence", '', 'ReplacedImplantTemplateSequence'),  # noqa
    0x00686223: ('CS', '1', "Implant Type", '', 'ImplantType'),  # noqa
    0x00686224: ('SQ', '1', "Derivation Implant Template Sequence", '', 'DerivationImplantTemplateSequence'),  # noqa
    0x00686225: ('SQ', '1', "Original Implant Template Sequence", '', 'OriginalImplantTemplateSequence'),  # noqa
    0x00686226: ('DT', '1', "Effective DateTime", '', 'EffectiveDateTime'),  # noqa
    0x00686230: ('SQ', '1', "Implant Target Anatomy Sequence", '', 'ImplantTargetAnatomySequence'),  # noqa
    0x00686260: ('SQ', '1', "Information From Manufacturer Sequence", '', 'InformationFromManufacturerSequence'),  # noqa
    0x00686265: ('SQ', '1', "Notification From Manufacturer Sequence", '', 'NotificationFromManufacturerSequence'),  # noqa
    0x00686270: ('DT', '1', "Information Issue DateTime", '', 'InformationIssueDateTime'),  # noqa
    0x00686280: ('ST', '1', "Information Summary", '', 'InformationSummary'),  # noqa
    0x006862A0: ('SQ', '1', "Implant Regulatory Disapproval Code Sequence", '', 'ImplantRegulatoryDisapprovalCodeSequence'),  # noqa
    0x006862A5: ('FD', '1', "Overall Template Spatial Tolerance", '', 'OverallTemplateSpatialTolerance'),  # noqa
    0x006862C0: ('SQ', '1', "HPGL Document Sequence", '', 'HPGLDocumentSequence'),  # noqa
    0x006862D0: ('US', '1', "HPGL Document ID", '', 'HPGLDocumentID'),  # noqa
    0x006862D5: ('LO', '1', "HPGL Document Label", '', 'HPGLDocumentLabel'),  # noqa
    0x006862E0: ('SQ', '1', "View Orientation Code Sequence", '', 'ViewOrientationCodeSequence'),  # noqa
    0x006862F0: ('SQ', '1', "View Orientation Modifier Code Sequence", '', 'ViewOrientationModifierCodeSequence'),  # noqa
    0x006862F2: ('FD', '1', "HPGL Document Scaling", '', 'HPGLDocumentScaling'),  # noqa
    0x00686300: ('OB', '1', "HPGL Document", '', 'HPGLDocument'),  # noqa
    0x00686310: ('US', '1', "HPGL Contour Pen Number", '', 'HPGLContourPenNumber'),  # noqa
    0x00686320: ('SQ', '1', "HPGL Pen Sequence", '', 'HPGLPenSequence'),  # noqa
    0x00686330: ('US', '1', "HPGL Pen Number", '', 'HPGLPenNumber'),  # noqa
    0x00686340: ('LO', '1', "HPGL Pen Label", '', 'HPGLPenLabel'),  # noqa
    0x00686345: ('ST', '1', "HPGL Pen Description", '', 'HPGLPenDescription'),  # noqa
    0x00686346: ('FD', '2', "Recommended Rotation Point", '', 'RecommendedRotationPoint'),  # noqa
    0x00686347: ('FD', '4', "Bounding Rectangle", '', 'BoundingRectangle'),  # noqa
    0x00686350: ('US', '1-n', "Implant Template 3D Model Surface Number", '', 'ImplantTemplate3DModelSurfaceNumber'),  # noqa
    0x00686360: ('SQ', '1', "Surface Model Description Sequence", '', 'SurfaceModelDescriptionSequence'),  # noqa
    0x00686380: ('LO', '1', "Surface Model Label", '', 'SurfaceModelLabel'),  # noqa
    0x00686390: ('FD', '1', "Surface Model Scaling Factor", '', 'SurfaceModelScalingFactor'),  # noqa
    0x006863A0: ('SQ', '1', "Materials Code Sequence", '', 'MaterialsCodeSequence'),  # noqa
    0x006863A4: ('SQ', '1', "Coating Materials Code Sequence", '', 'CoatingMaterialsCodeSequence'),  # noqa
    0x006863A8: ('SQ', '1', "Implant Type Code Sequence", '', 'ImplantTypeCodeSequence'),  # noqa
    0x006863AC: ('SQ', '1', "Fixation Method Code Sequence", '', 'FixationMethodCodeSequence'),  # noqa
    0x006863B0: ('SQ', '1', "Mating Feature Sets Sequence", '', 'MatingFeatureSetsSequence'),  # noqa
    0x006863C0: ('US', '1', "Mating Feature Set ID", '', 'MatingFeatureSetID'),  # noqa
    0x006863D0: ('LO', '1', "Mating Feature Set Label", '', 'MatingFeatureSetLabel'),  # noqa
    0x006863E0: ('SQ', '1', "Mating Feature Sequence", '', 'MatingFeatureSequence'),  # noqa
    0x006863F0: ('US', '1', "Mating Feature ID", '', 'MatingFeatureID'),  # noqa
    0x00686400: ('SQ', '1', "Mating Feature Degree of Freedom Sequence", '', 'MatingFeatureDegreeOfFreedomSequence'),  # noqa
    0x00686410: ('US', '1', "Degree of Freedom ID", '', 'DegreeOfFreedomID'),  # noqa
    0x00686420: ('CS', '1', "Degree of Freedom Type", '', 'DegreeOfFreedomType'),  # noqa
    0x00686430: ('SQ', '1', "2D Mating Feature Coordinates Sequence", '', 'TwoDMatingFeatureCoordinatesSequence'),  # noqa
    0x00686440: ('US', '1', "Referenced HPGL Document ID", '', 'ReferencedHPGLDocumentID'),  # noqa
    0x00686450: ('FD', '2', "2D Mating Point", '', 'TwoDMatingPoint'),  # noqa
    0x00686460: ('FD', '4', "2D Mating Axes", '', 'TwoDMatingAxes'),  # noqa
    0x00686470: ('SQ', '1', "2D Degree of Freedom Sequence", '', 'TwoDDegreeOfFreedomSequence'),  # noqa
    0x00686490: ('FD', '3', "3D Degree of Freedom Axis", '', 'ThreeDDegreeOfFreedomAxis'),  # noqa
    0x006864A0: ('FD', '2', "Range of Freedom", '', 'RangeOfFreedom'),  # noqa
    0x006864C0: ('FD', '3', "3D Mating Point", '', 'ThreeDMatingPoint'),  # noqa
    0x006864D0: ('FD', '9', "3D Mating Axes", '', 'ThreeDMatingAxes'),  # noqa
    0x006864F0: ('FD', '3', "2D Degree of Freedom Axis", '', 'TwoDDegreeOfFreedomAxis'),  # noqa
    0x00686500: ('SQ', '1', "Planning Landmark Point Sequence", '', 'PlanningLandmarkPointSequence'),  # noqa
    0x00686510: ('SQ', '1', "Planning Landmark Line Sequence", '', 'PlanningLandmarkLineSequence'),  # noqa
    0x00686520: ('SQ', '1', "Planning Landmark Plane Sequence", '', 'PlanningLandmarkPlaneSequence'),  # noqa
    0x00686530: ('US', '1', "Planning Landmark ID", '', 'PlanningLandmarkID'),  # noqa
    0x00686540: ('LO', '1', "Planning Landmark Description", '', 'PlanningLandmarkDescription'),  # noqa
    0x00686545: ('SQ', '1', "Planning Landmark Identification Code Sequence", '', 'PlanningLandmarkIdentificationCodeSequence'),  # noqa
    0x00686550: ('SQ', '1', "2D Point Coordinates Sequence", '', 'TwoDPointCoordinatesSequence'),  # noqa
    0x00686560: ('FD', '2', "2D Point Coordinates", '', 'TwoDPointCoordinates'),  # noqa
    0x00686590: ('FD', '3', "3D Point Coordinates", '', 'ThreeDPointCoordinates'),  # noqa
    0x006865A0: ('SQ', '1', "2D Line Coordinates Sequence", '', 'TwoDLineCoordinatesSequence'),  # noqa
    0x006865B0: ('FD', '4', "2D Line Coordinates", '', 'TwoDLineCoordinates'),  # noqa
    0x006865D0: ('FD', '6', "3D Line Coordinates", '', 'ThreeDLineCoordinates'),  # noqa
    0x006865E0: ('SQ', '1', "2D Plane Coordinates Sequence", '', 'TwoDPlaneCoordinatesSequence'),  # noqa
    0x006865F0: ('FD', '4', "2D Plane Intersection", '', 'TwoDPlaneIntersection'),  # noqa
    0x00686610: ('FD', '3', "3D Plane Origin", '', 'ThreeDPlaneOrigin'),  # noqa
    0x00686620: ('FD', '3', "3D Plane Normal", '', 'ThreeDPlaneNormal'),  # noqa
    0x00700001: ('SQ', '1', "Graphic Annotation Sequence", '', 'GraphicAnnotationSequence'),  # noqa
    0x00700002: ('CS', '1', "Graphic Layer", '', 'GraphicLayer'),  # noqa
    0x00700003: ('CS', '1', "Bounding Box Annotation Units", '', 'BoundingBoxAnnotationUnits'),  # noqa
    0x00700004: ('CS', '1', "Anchor Point Annotation Units", '', 'AnchorPointAnnotationUnits'),  # noqa
    0x00700005: ('CS', '1', "Graphic Annotation Units", '', 'GraphicAnnotationUnits'),  # noqa
    0x00700006: ('ST', '1', "Unformatted Text Value", '', 'UnformattedTextValue'),  # noqa
    0x00700008: ('SQ', '1', "Text Object Sequence", '', 'TextObjectSequence'),  # noqa
    0x00700009: ('SQ', '1', "Graphic Object Sequence", '', 'GraphicObjectSequence'),  # noqa
    0x00700010: ('FL', '2', "Bounding Box Top Left Hand Corner", '', 'BoundingBoxTopLeftHandCorner'),  # noqa
    0x00700011: ('FL', '2', "Bounding Box Bottom Right Hand Corner", '', 'BoundingBoxBottomRightHandCorner'),  # noqa
    0x00700012: ('CS', '1', "Bounding Box Text Horizontal Justification", '', 'BoundingBoxTextHorizontalJustification'),  # noqa
    0x00700014: ('FL', '2', "Anchor Point", '', 'AnchorPoint'),  # noqa
    0x00700015: ('CS', '1', "Anchor Point Visibility", '', 'AnchorPointVisibility'),  # noqa
    0x00700020: ('US', '1', "Graphic Dimensions", '', 'GraphicDimensions'),  # noqa
    0x00700021: ('US', '1', "Number of Graphic Points", '', 'NumberOfGraphicPoints'),  # noqa
    0x00700022: ('FL', '2-n', "Graphic Data", '', 'GraphicData'),  # noqa
    0x00700023: ('CS', '1', "Graphic Type", '', 'GraphicType'),  # noqa
    0x00700024: ('CS', '1', "Graphic Filled", '', 'GraphicFilled'),  # noqa
    0x00700040: ('IS', '1', "Image Rotation (Retired)", 'Retired', 'ImageRotationRetired'),  # noqa
    0x00700041: ('CS', '1', "Image Horizontal Flip", '', 'ImageHorizontalFlip'),  # noqa
    0x00700042: ('US', '1', "Image Rotation", '', 'ImageRotation'),  # noqa
    0x00700050: ('US', '2', "Displayed Area Top Left Hand Corner (Trial)", 'Retired', 'DisplayedAreaTopLeftHandCornerTrial'),  # noqa
    0x00700051: ('US', '2', "Displayed Area Bottom Right Hand Corner (Trial)", 'Retired', 'DisplayedAreaBottomRightHandCornerTrial'),  # noqa
    0x00700052: ('SL', '2', "Displayed Area Top Left Hand Corner", '', 'DisplayedAreaTopLeftHandCorner'),  # noqa
    0x00700053: ('SL', '2', "Displayed Area Bottom Right Hand Corner", '', 'DisplayedAreaBottomRightHandCorner'),  # noqa
    0x0070005A: ('SQ', '1', "Displayed Area Selection Sequence", '', 'DisplayedAreaSelectionSequence'),  # noqa
    0x00700060: ('SQ', '1', "Graphic Layer Sequence", '', 'GraphicLayerSequence'),  # noqa
    0x00700062: ('IS', '1', "Graphic Layer Order", '', 'GraphicLayerOrder'),  # noqa
    0x00700066: ('US', '1', "Graphic Layer Recommended Display Grayscale Value", '', 'GraphicLayerRecommendedDisplayGrayscaleValue'),  # noqa
    0x00700067: ('US', '3', "Graphic Layer Recommended Display RGB Value", 'Retired', 'GraphicLayerRecommendedDisplayRGBValue'),  # noqa
    0x00700068: ('LO', '1', "Graphic Layer Description", '', 'GraphicLayerDescription'),  # noqa
    0x00700080: ('CS', '1', "Content Label", '', 'ContentLabel'),  # noqa
    0x00700081: ('LO', '1', "Content Description", '', 'ContentDescription'),  # noqa
    0x00700082: ('DA', '1', "Presentation Creation Date", '', 'PresentationCreationDate'),  # noqa
    0x00700083: ('TM', '1', "Presentation Creation Time", '', 'PresentationCreationTime'),  # noqa
    0x00700084: ('PN', '1', "Content Creator's Name", '', 'ContentCreatorName'),  # noqa
    0x00700086: ('SQ', '1', "Content Creator's Identification Code Sequence", '', 'ContentCreatorIdentificationCodeSequence'),  # noqa
    0x00700087: ('SQ', '1', "Alternate Content Description Sequence", '', 'AlternateContentDescriptionSequence'),  # noqa
    0x00700100: ('CS', '1', "Presentation Size Mode", '', 'PresentationSizeMode'),  # noqa
    0x00700101: ('DS', '2', "Presentation Pixel Spacing", '', 'PresentationPixelSpacing'),  # noqa
    0x00700102: ('IS', '2', "Presentation Pixel Aspect Ratio", '', 'PresentationPixelAspectRatio'),  # noqa
    0x00700103: ('FL', '1', "Presentation Pixel Magnification Ratio", '', 'PresentationPixelMagnificationRatio'),  # noqa
    0x00700207: ('LO', '1', "Graphic Group Label", '', 'GraphicGroupLabel'),  # noqa
    0x00700208: ('ST', '1', "Graphic Group Description", '', 'GraphicGroupDescription'),  # noqa
    0x00700209: ('SQ', '1', "Compound Graphic Sequence", '', 'CompoundGraphicSequence'),  # noqa
    0x00700226: ('UL', '1', "Compound Graphic Instance ID", '', 'CompoundGraphicInstanceID'),  # noqa
    0x00700227: ('LO', '1', "Font Name", '', 'FontName'),  # noqa
    0x00700228: ('CS', '1', "Font Name Type", '', 'FontNameType'),  # noqa
    0x00700229: ('LO', '1', "CSS Font Name", '', 'CSSFontName'),  # noqa
    0x00700230: ('FD', '1', "Rotation Angle", '', 'RotationAngle'),  # noqa
    0x00700231: ('SQ', '1', "Text Style Sequence", '', 'TextStyleSequence'),  # noqa
    0x00700232: ('SQ', '1', "Line Style Sequence", '', 'LineStyleSequence'),  # noqa
    0x00700233: ('SQ', '1', "Fill Style Sequence", '', 'FillStyleSequence'),  # noqa
    0x00700234: ('SQ', '1', "Graphic Group Sequence", '', 'GraphicGroupSequence'),  # noqa
    0x00700241: ('US', '3', "Text Color CIELab Value", '', 'TextColorCIELabValue'),  # noqa
    0x00700242: ('CS', '1', "Horizontal Alignment", '', 'HorizontalAlignment'),  # noqa
    0x00700243: ('CS', '1', "Vertical Alignment", '', 'VerticalAlignment'),  # noqa
    0x00700244: ('CS', '1', "Shadow Style", '', 'ShadowStyle'),  # noqa
    0x00700245: ('FL', '1', "Shadow Offset X", '', 'ShadowOffsetX'),  # noqa
    0x00700246: ('FL', '1', "Shadow Offset Y", '', 'ShadowOffsetY'),  # noqa
    0x00700247: ('US', '3', "Shadow Color CIELab Value", '', 'ShadowColorCIELabValue'),  # noqa
    0x00700248: ('CS', '1', "Underlined", '', 'Underlined'),  # noqa
    0x00700249: ('CS', '1', "Bold", '', 'Bold'),  # noqa
    0x00700250: ('CS', '1', "Italic", '', 'Italic'),  # noqa
    0x00700251: ('US', '3', "Pattern On Color CIELab Value", '', 'PatternOnColorCIELabValue'),  # noqa
    0x00700252: ('US', '3', "Pattern Off Color CIELab Value", '', 'PatternOffColorCIELabValue'),  # noqa
    0x00700253: ('FL', '1', "Line Thickness", '', 'LineThickness'),  # noqa
    0x00700254: ('CS', '1', "Line Dashing Style", '', 'LineDashingStyle'),  # noqa
    0x00700255: ('UL', '1', "Line Pattern", '', 'LinePattern'),  # noqa
    0x00700256: ('OB', '1', "Fill Pattern", '', 'FillPattern'),  # noqa
    0x00700257: ('CS', '1', "Fill Mode", '', 'FillMode'),  # noqa
    0x00700258: ('FL', '1', "Shadow Opacity", '', 'ShadowOpacity'),  # noqa
    0x00700261: ('FL', '1', "Gap Length", '', 'GapLength'),  # noqa
    0x00700262: ('FL', '1', "Diameter of Visibility", '', 'DiameterOfVisibility'),  # noqa
    0x00700273: ('FL', '2', "Rotation Point", '', 'RotationPoint'),  # noqa
    0x00700274: ('CS', '1', "Tick Alignment", '', 'TickAlignment'),  # noqa
    0x00700278: ('CS', '1', "Show Tick Label", '', 'ShowTickLabel'),  # noqa
    0x00700279: ('CS', '1', "Tick Label Alignment", '', 'TickLabelAlignment'),  # noqa
    0x00700282: ('CS', '1', "Compound Graphic Units", '', 'CompoundGraphicUnits'),  # noqa
    0x00700284: ('FL', '1', "Pattern On Opacity", '', 'PatternOnOpacity'),  # noqa
    0x00700285: ('FL', '1', "Pattern Off Opacity", '', 'PatternOffOpacity'),  # noqa
    0x00700287: ('SQ', '1', "Major Ticks Sequence", '', 'MajorTicksSequence'),  # noqa
    0x00700288: ('FL', '1', "Tick Position", '', 'TickPosition'),  # noqa
    0x00700289: ('SH', '1', "Tick Label", '', 'TickLabel'),  # noqa
    0x00700294: ('CS', '1', "Compound Graphic Type", '', 'CompoundGraphicType'),  # noqa
    0x00700295: ('UL', '1', "Graphic Group ID", '', 'GraphicGroupID'),  # noqa
    0x00700306: ('CS', '1', "Shape Type", '', 'ShapeType'),  # noqa
    0x00700308: ('SQ', '1', "Registration Sequence", '', 'RegistrationSequence'),  # noqa
    0x00700309: ('SQ', '1', "Matrix Registration Sequence", '', 'MatrixRegistrationSequence'),  # noqa
    0x0070030A: ('SQ', '1', "Matrix Sequence", '', 'MatrixSequence'),  # noqa
    0x0070030B: ('FD', '16', "Frame of Reference to Displayed Coordinate System Transformation Matrix", '', 'FrameOfReferenceToDisplayedCoordinateSystemTransformationMatrix'),  # noqa
    0x0070030C: ('CS', '1', "Frame of Reference Transformation Matrix Type", '', 'FrameOfReferenceTransformationMatrixType'),  # noqa
    0x0070030D: ('SQ', '1', "Registration Type Code Sequence", '', 'RegistrationTypeCodeSequence'),  # noqa
    0x0070030F: ('ST', '1', "Fiducial Description", '', 'FiducialDescription'),  # noqa
    0x00700310: ('SH', '1', "Fiducial Identifier", '', 'FiducialIdentifier'),  # noqa
    0x00700311: ('SQ', '1', "Fiducial Identifier Code Sequence", '', 'FiducialIdentifierCodeSequence'),  # noqa
    0x00700312: ('FD', '1', "Contour Uncertainty Radius", '', 'ContourUncertaintyRadius'),  # noqa
    0x00700314: ('SQ', '1', "Used Fiducials Sequence", '', 'UsedFiducialsSequence'),  # noqa
    0x00700318: ('SQ', '1', "Graphic Coordinates Data Sequence", '', 'GraphicCoordinatesDataSequence'),  # noqa
    0x0070031A: ('UI', '1', "Fiducial UID", '', 'FiducialUID'),  # noqa
    0x0070031C: ('SQ', '1', "Fiducial Set Sequence", '', 'FiducialSetSequence'),  # noqa
    0x0070031E: ('SQ', '1', "Fiducial Sequence", '', 'FiducialSequence'),  # noqa
    0x0070031F: ('SQ', '1', "Fiducials Property Category Code Sequence", '', 'FiducialsPropertyCategoryCodeSequence'),  # noqa
    0x00700401: ('US', '3', "Graphic Layer Recommended Display CIELab Value", '', 'GraphicLayerRecommendedDisplayCIELabValue'),  # noqa
    0x00700402: ('SQ', '1', "Blending Sequence", '', 'BlendingSequence'),  # noqa
    0x00700403: ('FL', '1', "Relative Opacity", '', 'RelativeOpacity'),  # noqa
    0x00700404: ('SQ', '1', "Referenced Spatial Registration Sequence", '', 'ReferencedSpatialRegistrationSequence'),  # noqa
    0x00700405: ('CS', '1', "Blending Position", '', 'BlendingPosition'),  # noqa
    0x00701101: ('UI', '1', "Presentation Display Collection UID", '', 'PresentationDisplayCollectionUID'),  # noqa
    0x00701102: ('UI', '1', "Presentation Sequence Collection UID", '', 'PresentationSequenceCollectionUID'),  # noqa
    0x00701103: ('US', '1', "Presentation Sequence Position Index", '', 'PresentationSequencePositionIndex'),  # noqa
    0x00701104: ('SQ', '1', "Rendered Image Reference Sequence", '', 'RenderedImageReferenceSequence'),  # noqa
    0x00701201: ('SQ', '1', "Volumetric Presentation State Input Sequence", '', 'VolumetricPresentationStateInputSequence'),  # noqa
    0x00701202: ('CS', '1', "Presentation Input Type", '', 'PresentationInputType'),  # noqa
    0x00701203: ('US', '1', "Input Sequence Position Index", '', 'InputSequencePositionIndex'),  # noqa
    0x00701204: ('CS', '1', "Crop", '', 'Crop'),  # noqa
    0x00701205: ('US', '1-n', "Cropping Specification Index", '', 'CroppingSpecificationIndex'),  # noqa
    0x00701206: ('CS', '1', "Compositing Method", 'Retired', 'CompositingMethod'),  # noqa
    0x00701207: ('US', '1', "Volumetric Presentation Input Number", '', 'VolumetricPresentationInputNumber'),  # noqa
    0x00701208: ('CS', '1', "Image Volume Geometry", '', 'ImageVolumeGeometry'),  # noqa
    0x00701209: ('UI', '1', "Volumetric Presentation Input Set UID", '', 'VolumetricPresentationInputSetUID'),  # noqa
    0x0070120A: ('SQ', '1', "Volumetric Presentation Input Set Sequence", '', 'VolumetricPresentationInputSetSequence'),  # noqa
    0x0070120B: ('CS', '1', "Global Crop", '', 'GlobalCrop'),  # noqa
    0x0070120C: ('US', '1-n', "Global Cropping Specification Index", '', 'GlobalCroppingSpecificationIndex'),  # noqa
    0x0070120D: ('CS', '1', "Rendering Method", '', 'RenderingMethod'),  # noqa
    0x00701301: ('SQ', '1', "Volume Cropping Sequence", '', 'VolumeCroppingSequence'),  # noqa
    0x00701302: ('CS', '1', "Volume Cropping Method", '', 'VolumeCroppingMethod'),  # noqa
    0x00701303: ('FD', '6', "Bounding Box Crop", '', 'BoundingBoxCrop'),  # noqa
    0x00701304: ('SQ', '1', "Oblique Cropping Plane Sequence", '', 'ObliqueCroppingPlaneSequence'),  # noqa
    0x00701305: ('FD', '4', "Plane", '', 'Plane'),  # noqa
    0x00701306: ('FD', '3', "Plane Normal", '', 'PlaneNormal'),  # noqa
    0x00701309: ('US', '1', "Cropping Specification Number", '', 'CroppingSpecificationNumber'),  # noqa
    0x00701501: ('CS', '1', "Multi-Planar Reconstruction Style", '', 'MultiPlanarReconstructionStyle'),  # noqa
    0x00701502: ('CS', '1', "MPR Thickness Type", '', 'MPRThicknessType'),  # noqa
    0x00701503: ('FD', '1', "MPR Slab Thickness", '', 'MPRSlabThickness'),  # noqa
    0x00701505: ('FD', '3', "MPR Top Left Hand Corner", '', 'MPRTopLeftHandCorner'),  # noqa
    0x00701507: ('FD', '3', "MPR View Width Direction", '', 'MPRViewWidthDirection'),  # noqa
    0x00701508: ('FD', '1', "MPR View Width", '', 'MPRViewWidth'),  # noqa
    0x0070150C: ('UL', '1', "Number of Volumetric Curve Points", '', 'NumberOfVolumetricCurvePoints'),  # noqa
    0x0070150D: ('OD', '1', "Volumetric Curve Points", '', 'VolumetricCurvePoints'),  # noqa
    0x00701511: ('FD', '3', "MPR View Height Direction", '', 'MPRViewHeightDirection'),  # noqa
    0x00701512: ('FD', '1', "MPR View Height", '', 'MPRViewHeight'),  # noqa
    0x00701602: ('CS', '1', "Render Projection", '', 'RenderProjection'),  # noqa
    0x00701603: ('FD', '3', "Viewpoint Position", '', 'ViewpointPosition'),  # noqa
    0x00701604: ('FD', '3', "Viewpoint LookAt Point", '', 'ViewpointLookAtPoint'),  # noqa
    0x00701605: ('FD', '3', "Viewpoint Up Direction", '', 'ViewpointUpDirection'),  # noqa
    0x00701606: ('FD', '6', "Render Field of View", '', 'RenderFieldOfView'),  # noqa
    0x00701607: ('FD', '1', "Sampling Step Size", '', 'SamplingStepSize'),  # noqa
    0x00701701: ('CS', '1', "Shading Style", '', 'ShadingStyle'),  # noqa
    0x00701702: ('FD', '1', "Ambient Reflection Intensity", '', 'AmbientReflectionIntensity'),  # noqa
    0x00701703: ('FD', '3', "Light Direction", '', 'LightDirection'),  # noqa
    0x00701704: ('FD', '1', "Diffuse Reflection Intensity", '', 'DiffuseReflectionIntensity'),  # noqa
    0x00701705: ('FD', '1', "Specular Reflection Intensity", '', 'SpecularReflectionIntensity'),  # noqa
    0x00701706: ('FD', '1', "Shininess", '', 'Shininess'),  # noqa
    0x00701801: ('SQ', '1', "Presentation State Classification Component Sequence", '', 'PresentationStateClassificationComponentSequence'),  # noqa
    0x00701802: ('CS', '1', "Component Type", '', 'ComponentType'),  # noqa
    0x00701803: ('SQ', '1', "Component Input Sequence", '', 'ComponentInputSequence'),  # noqa
    0x00701804: ('US', '1', "Volumetric Presentation Input Index", '', 'VolumetricPresentationInputIndex'),  # noqa
    0x00701805: ('SQ', '1', "Presentation State Compositor Component Sequence", '', 'PresentationStateCompositorComponentSequence'),  # noqa
    0x00701806: ('SQ', '1', "Weighting Transfer Function Sequence", '', 'WeightingTransferFunctionSequence'),  # noqa
    0x00701807: ('US', '3', "Weighting Lookup Table Descriptor", '', 'WeightingLookupTableDescriptor'),  # noqa
    0x00701808: ('OB', '1', "Weighting Lookup Table Data", '', 'WeightingLookupTableData'),  # noqa
    0x00701901: ('SQ', '1', "Volumetric Annotation Sequence", '', 'VolumetricAnnotationSequence'),  # noqa
    0x00701903: ('SQ', '1', "Referenced Structured Context Sequence", '', 'ReferencedStructuredContextSequence'),  # noqa
    0x00701904: ('UI', '1', "Referenced Content Item", '', 'ReferencedContentItem'),  # noqa
    0x00701905: ('SQ', '1', "Volumetric Presentation Input Annotation Sequence", '', 'VolumetricPresentationInputAnnotationSequence'),  # noqa
    0x00701907: ('CS', '1', "Annotation Clipping", '', 'AnnotationClipping'),  # noqa
    0x00701A01: ('CS', '1', "Presentation Animation Style", '', 'PresentationAnimationStyle'),  # noqa
    0x00701A03: ('FD', '1', "Recommended Animation Rate", '', 'RecommendedAnimationRate'),  # noqa
    0x00701A04: ('SQ', '1', "Animation Curve Sequence", '', 'AnimationCurveSequence'),  # noqa
    0x00701A05: ('FD', '1', "Animation Step Size", '', 'AnimationStepSize'),  # noqa
    0x00701A06: ('FD', '1', "Swivel Range", '', 'SwivelRange'),  # noqa
    0x00701A07: ('OD', '1', "Volumetric Curve Up Directions", '', 'VolumetricCurveUpDirections'),  # noqa
    0x00701A08: ('SQ', '1', "Volume Stream Sequence", '', 'VolumeStreamSequence'),  # noqa
    0x00701A09: ('LO', '1', "RGBA Transfer Function Description", '', 'RGBATransferFunctionDescription'),  # noqa
    0x00701B01: ('SQ', '1', "Advanced Blending Sequence", '', 'AdvancedBlendingSequence'),  # noqa
    0x00701B02: ('US', '1', "Blending Input Number", '', 'BlendingInputNumber'),  # noqa
    0x00701B03: ('SQ', '1', "Blending Display Input Sequence", '', 'BlendingDisplayInputSequence'),  # noqa
    0x00701B04: ('SQ', '1', "Blending Display Sequence", '', 'BlendingDisplaySequence'),  # noqa
    0x00701B06: ('CS', '1', "Blending Mode", '', 'BlendingMode'),  # noqa
    0x00701B07: ('CS', '1', "Time Series Blending", '', 'TimeSeriesBlending'),  # noqa
    0x00701B08: ('CS', '1', "Geometry for Display", '', 'GeometryForDisplay'),  # noqa
    0x00701B11: ('SQ', '1', "Threshold Sequence", '', 'ThresholdSequence'),  # noqa
    0x00701B12: ('SQ', '1', "Threshold Value Sequence", '', 'ThresholdValueSequence'),  # noqa
    0x00701B13: ('CS', '1', "Threshold Type", '', 'ThresholdType'),  # noqa
    0x00701B14: ('FD', '1', "Threshold Value", '', 'ThresholdValue'),  # noqa
    0x00720002: ('SH', '1', "Hanging Protocol Name", '', 'HangingProtocolName'),  # noqa
    0x00720004: ('LO', '1', "Hanging Protocol Description", '', 'HangingProtocolDescription'),  # noqa
    0x00720006: ('CS', '1', "Hanging Protocol Level", '', 'HangingProtocolLevel'),  # noqa
    0x00720008: ('LO', '1', "Hanging Protocol Creator", '', 'HangingProtocolCreator'),  # noqa
    0x0072000A: ('DT', '1', "Hanging Protocol Creation DateTime", '', 'HangingProtocolCreationDateTime'),  # noqa
    0x0072000C: ('SQ', '1', "Hanging Protocol Definition Sequence", '', 'HangingProtocolDefinitionSequence'),  # noqa
    0x0072000E: ('SQ', '1', "Hanging Protocol User Identification Code Sequence", '', 'HangingProtocolUserIdentificationCodeSequence'),  # noqa
    0x00720010: ('LO', '1', "Hanging Protocol User Group Name", '', 'HangingProtocolUserGroupName'),  # noqa
    0x00720012: ('SQ', '1', "Source Hanging Protocol Sequence", '', 'SourceHangingProtocolSequence'),  # noqa
    0x00720014: ('US', '1', "Number of Priors Referenced", '', 'NumberOfPriorsReferenced'),  # noqa
    0x00720020: ('SQ', '1', "Image Sets Sequence", '', 'ImageSetsSequence'),  # noqa
    0x00720022: ('SQ', '1', "Image Set Selector Sequence", '', 'ImageSetSelectorSequence'),  # noqa
    0x00720024: ('CS', '1', "Image Set Selector Usage Flag", '', 'ImageSetSelectorUsageFlag'),  # noqa
    0x00720026: ('AT', '1', "Selector Attribute", '', 'SelectorAttribute'),  # noqa
    0x00720028: ('US', '1', "Selector Value Number", '', 'SelectorValueNumber'),  # noqa
    0x00720030: ('SQ', '1', "Time Based Image Sets Sequence", '', 'TimeBasedImageSetsSequence'),  # noqa
    0x00720032: ('US', '1', "Image Set Number", '', 'ImageSetNumber'),  # noqa
    0x00720034: ('CS', '1', "Image Set Selector Category", '', 'ImageSetSelectorCategory'),  # noqa
    0x00720038: ('US', '2', "Relative Time", '', 'RelativeTime'),  # noqa
    0x0072003A: ('CS', '1', "Relative Time Units", '', 'RelativeTimeUnits'),  # noqa
    0x0072003C: ('SS', '2', "Abstract Prior Value", '', 'AbstractPriorValue'),  # noqa
    0x0072003E: ('SQ', '1', "Abstract Prior Code Sequence", '', 'AbstractPriorCodeSequence'),  # noqa
    0x00720040: ('LO', '1', "Image Set Label", '', 'ImageSetLabel'),  # noqa
    0x00720050: ('CS', '1', "Selector Attribute VR", '', 'SelectorAttributeVR'),  # noqa
    0x00720052: ('AT', '1-n', "Selector Sequence Pointer", '', 'SelectorSequencePointer'),  # noqa
    0x00720054: ('LO', '1-n', "Selector Sequence Pointer Private Creator", '', 'SelectorSequencePointerPrivateCreator'),  # noqa
    0x00720056: ('LO', '1', "Selector Attribute Private Creator", '', 'SelectorAttributePrivateCreator'),  # noqa
    0x0072005E: ('AE', '1-n', "Selector AE Value", '', 'SelectorAEValue'),  # noqa
    0x0072005F: ('AS', '1-n', "Selector AS Value", '', 'SelectorASValue'),  # noqa
    0x00720060: ('AT', '1-n', "Selector AT Value", '', 'SelectorATValue'),  # noqa
    0x00720061: ('DA', '1-n', "Selector DA Value", '', 'SelectorDAValue'),  # noqa
    0x00720062: ('CS', '1-n', "Selector CS Value", '', 'SelectorCSValue'),  # noqa
    0x00720063: ('DT', '1-n', "Selector DT Value", '', 'SelectorDTValue'),  # noqa
    0x00720064: ('IS', '1-n', "Selector IS Value", '', 'SelectorISValue'),  # noqa
    0x00720065: ('OB', '1', "Selector OB Value", '', 'SelectorOBValue'),  # noqa
    0x00720066: ('LO', '1-n', "Selector LO Value", '', 'SelectorLOValue'),  # noqa
    0x00720067: ('OF', '1', "Selector OF Value", '', 'SelectorOFValue'),  # noqa
    0x00720068: ('LT', '1', "Selector LT Value", '', 'SelectorLTValue'),  # noqa
    0x00720069: ('OW', '1', "Selector OW Value", '', 'SelectorOWValue'),  # noqa
    0x0072006A: ('PN', '1-n', "Selector PN Value", '', 'SelectorPNValue'),  # noqa
    0x0072006B: ('TM', '1-n', "Selector TM Value", '', 'SelectorTMValue'),  # noqa
    0x0072006C: ('SH', '1-n', "Selector SH Value", '', 'SelectorSHValue'),  # noqa
    0x0072006D: ('UN', '1', "Selector UN Value", '', 'SelectorUNValue'),  # noqa
    0x0072006E: ('ST', '1', "Selector ST Value", '', 'SelectorSTValue'),  # noqa
    0x0072006F: ('UC', '1-n', "Selector UC Value", '', 'SelectorUCValue'),  # noqa
    0x00720070: ('UT', '1', "Selector UT Value", '', 'SelectorUTValue'),  # noqa
    0x00720071: ('UR', '1', "Selector UR Value", '', 'SelectorURValue'),  # noqa
    0x00720072: ('DS', '1-n', "Selector DS Value", '', 'SelectorDSValue'),  # noqa
    0x00720073: ('OD', '1', "Selector OD Value", '', 'SelectorODValue'),  # noqa
    0x00720074: ('FD', '1-n', "Selector FD Value", '', 'SelectorFDValue'),  # noqa
    0x00720075: ('OL', '1', "Selector OL Value", '', 'SelectorOLValue'),  # noqa
    0x00720076: ('FL', '1-n', "Selector FL Value", '', 'SelectorFLValue'),  # noqa
    0x00720078: ('UL', '1-n', "Selector UL Value", '', 'SelectorULValue'),  # noqa
    0x0072007A: ('US', '1-n', "Selector US Value", '', 'SelectorUSValue'),  # noqa
    0x0072007C: ('SL', '1-n', "Selector SL Value", '', 'SelectorSLValue'),  # noqa
    0x0072007E: ('SS', '1-n', "Selector SS Value", '', 'SelectorSSValue'),  # noqa
    0x0072007F: ('UI', '1-n', "Selector UI Value", '', 'SelectorUIValue'),  # noqa
    0x00720080: ('SQ', '1', "Selector Code Sequence Value", '', 'SelectorCodeSequenceValue'),  # noqa
    0x00720100: ('US', '1', "Number of Screens", '', 'NumberOfScreens'),  # noqa
    0x00720102: ('SQ', '1', "Nominal Screen Definition Sequence", '', 'NominalScreenDefinitionSequence'),  # noqa
    0x00720104: ('US', '1', "Number of Vertical Pixels", '', 'NumberOfVerticalPixels'),  # noqa
    0x00720106: ('US', '1', "Number of Horizontal Pixels", '', 'NumberOfHorizontalPixels'),  # noqa
    0x00720108: ('FD', '4', "Display Environment Spatial Position", '', 'DisplayEnvironmentSpatialPosition'),  # noqa
    0x0072010A: ('US', '1', "Screen Minimum Grayscale Bit Depth", '', 'ScreenMinimumGrayscaleBitDepth'),  # noqa
    0x0072010C: ('US', '1', "Screen Minimum Color Bit Depth", '', 'ScreenMinimumColorBitDepth'),  # noqa
    0x0072010E: ('US', '1', "Application Maximum Repaint Time", '', 'ApplicationMaximumRepaintTime'),  # noqa
    0x00720200: ('SQ', '1', "Display Sets Sequence", '', 'DisplaySetsSequence'),  # noqa
    0x00720202: ('US', '1', "Display Set Number", '', 'DisplaySetNumber'),  # noqa
    0x00720203: ('LO', '1', "Display Set Label", '', 'DisplaySetLabel'),  # noqa
    0x00720204: ('US', '1', "Display Set Presentation Group", '', 'DisplaySetPresentationGroup'),  # noqa
    0x00720206: ('LO', '1', "Display Set Presentation Group Description", '', 'DisplaySetPresentationGroupDescription'),  # noqa
    0x00720208: ('CS', '1', "Partial Data Display Handling", '', 'PartialDataDisplayHandling'),  # noqa
    0x00720210: ('SQ', '1', "Synchronized Scrolling Sequence", '', 'SynchronizedScrollingSequence'),  # noqa
    0x00720212: ('US', '2-n', "Display Set Scrolling Group", '', 'DisplaySetScrollingGroup'),  # noqa
    0x00720214: ('SQ', '1', "Navigation Indicator Sequence", '', 'NavigationIndicatorSequence'),  # noqa
    0x00720216: ('US', '1', "Navigation Display Set", '', 'NavigationDisplaySet'),  # noqa
    0x00720218: ('US', '1-n', "Reference Display Sets", '', 'ReferenceDisplaySets'),  # noqa
    0x00720300: ('SQ', '1', "Image Boxes Sequence", '', 'ImageBoxesSequence'),  # noqa
    0x00720302: ('US', '1', "Image Box Number", '', 'ImageBoxNumber'),  # noqa
    0x00720304: ('CS', '1', "Image Box Layout Type", '', 'ImageBoxLayoutType'),  # noqa
    0x00720306: ('US', '1', "Image Box Tile Horizontal Dimension", '', 'ImageBoxTileHorizontalDimension'),  # noqa
    0x00720308: ('US', '1', "Image Box Tile Vertical Dimension", '', 'ImageBoxTileVerticalDimension'),  # noqa
    0x00720310: ('CS', '1', "Image Box Scroll Direction", '', 'ImageBoxScrollDirection'),  # noqa
    0x00720312: ('CS', '1', "Image Box Small Scroll Type", '', 'ImageBoxSmallScrollType'),  # noqa
    0x00720314: ('US', '1', "Image Box Small Scroll Amount", '', 'ImageBoxSmallScrollAmount'),  # noqa
    0x00720316: ('CS', '1', "Image Box Large Scroll Type", '', 'ImageBoxLargeScrollType'),  # noqa
    0x00720318: ('US', '1', "Image Box Large Scroll Amount", '', 'ImageBoxLargeScrollAmount'),  # noqa
    0x00720320: ('US', '1', "Image Box Overlap Priority", '', 'ImageBoxOverlapPriority'),  # noqa
    0x00720330: ('FD', '1', "Cine Relative to Real-Time", '', 'CineRelativeToRealTime'),  # noqa
    0x00720400: ('SQ', '1', "Filter Operations Sequence", '', 'FilterOperationsSequence'),  # noqa
    0x00720402: ('CS', '1', "Filter-by Category", '', 'FilterByCategory'),  # noqa
    0x00720404: ('CS', '1', "Filter-by Attribute Presence", '', 'FilterByAttributePresence'),  # noqa
    0x00720406: ('CS', '1', "Filter-by Operator", '', 'FilterByOperator'),  # noqa
    0x00720420: ('US', '3', "Structured Display Background CIELab Value", '', 'StructuredDisplayBackgroundCIELabValue'),  # noqa
    0x00720421: ('US', '3', "Empty Image Box CIELab Value", '', 'EmptyImageBoxCIELabValue'),  # noqa
    0x00720422: ('SQ', '1', "Structured Display Image Box Sequence", '', 'StructuredDisplayImageBoxSequence'),  # noqa
    0x00720424: ('SQ', '1', "Structured Display Text Box Sequence", '', 'StructuredDisplayTextBoxSequence'),  # noqa
    0x00720427: ('SQ', '1', "Referenced First Frame Sequence", '', 'ReferencedFirstFrameSequence'),  # noqa
    0x00720430: ('SQ', '1', "Image Box Synchronization Sequence", '', 'ImageBoxSynchronizationSequence'),  # noqa
    0x00720432: ('US', '2-n', "Synchronized Image Box List", '', 'SynchronizedImageBoxList'),  # noqa
    0x00720434: ('CS', '1', "Type of Synchronization", '', 'TypeOfSynchronization'),  # noqa
    0x00720500: ('CS', '1', "Blending Operation Type", '', 'BlendingOperationType'),  # noqa
    0x00720510: ('CS', '1', "Reformatting Operation Type", '', 'ReformattingOperationType'),  # noqa
    0x00720512: ('FD', '1', "Reformatting Thickness", '', 'ReformattingThickness'),  # noqa
    0x00720514: ('FD', '1', "Reformatting Interval", '', 'ReformattingInterval'),  # noqa
    0x00720516: ('CS', '1', "Reformatting Operation Initial View Direction", '', 'ReformattingOperationInitialViewDirection'),  # noqa
    0x00720520: ('CS', '1-n', "3D Rendering Type", '', 'ThreeDRenderingType'),  # noqa
    0x00720600: ('SQ', '1', "Sorting Operations Sequence", '', 'SortingOperationsSequence'),  # noqa
    0x00720602: ('CS', '1', "Sort-by Category", '', 'SortByCategory'),  # noqa
    0x00720604: ('CS', '1', "Sorting Direction", '', 'SortingDirection'),  # noqa
    0x00720700: ('CS', '2', "Display Set Patient Orientation", '', 'DisplaySetPatientOrientation'),  # noqa
    0x00720702: ('CS', '1', "VOI Type", '', 'VOIType'),  # noqa
    0x00720704: ('CS', '1', "Pseudo-Color Type", '', 'PseudoColorType'),  # noqa
    0x00720705: ('SQ', '1', "Pseudo-Color Palette Instance Reference Sequence", '', 'PseudoColorPaletteInstanceReferenceSequence'),  # noqa
    0x00720706: ('CS', '1', "Show Grayscale Inverted", '', 'ShowGrayscaleInverted'),  # noqa
    0x00720710: ('CS', '1', "Show Image True Size Flag", '', 'ShowImageTrueSizeFlag'),  # noqa
    0x00720712: ('CS', '1', "Show Graphic Annotation Flag", '', 'ShowGraphicAnnotationFlag'),  # noqa
    0x00720714: ('CS', '1', "Show Patient Demographics Flag", '', 'ShowPatientDemographicsFlag'),  # noqa
    0x00720716: ('CS', '1', "Show Acquisition Techniques Flag", '', 'ShowAcquisitionTechniquesFlag'),  # noqa
    0x00720717: ('CS', '1', "Display Set Horizontal Justification", '', 'DisplaySetHorizontalJustification'),  # noqa
    0x00720718: ('CS', '1', "Display Set Vertical Justification", '', 'DisplaySetVerticalJustification'),  # noqa
    0x00740120: ('FD', '1', "Continuation Start Meterset", '', 'ContinuationStartMeterset'),  # noqa
    0x00740121: ('FD', '1', "Continuation End Meterset", '', 'ContinuationEndMeterset'),  # noqa
    0x00741000: ('CS', '1', "Procedure Step State", '', 'ProcedureStepState'),  # noqa
    0x00741002: ('SQ', '1', "Procedure Step Progress Information Sequence", '', 'ProcedureStepProgressInformationSequence'),  # noqa
    0x00741004: ('DS', '1', "Procedure Step Progress", '', 'ProcedureStepProgress'),  # noqa
    0x00741006: ('ST', '1', "Procedure Step Progress Description", '', 'ProcedureStepProgressDescription'),  # noqa
    0x00741007: ('SQ', '1', "Procedure Step Progress Parameters Sequence", '', 'ProcedureStepProgressParametersSequence'),  # noqa
    0x00741008: ('SQ', '1', "Procedure Step Communications URI Sequence", '', 'ProcedureStepCommunicationsURISequence'),  # noqa
    0x0074100A: ('UR', '1', "Contact URI", '', 'ContactURI'),  # noqa
    0x0074100C: ('LO', '1', "Contact Display Name", '', 'ContactDisplayName'),  # noqa
    0x0074100E: ('SQ', '1', "Procedure Step Discontinuation Reason Code Sequence", '', 'ProcedureStepDiscontinuationReasonCodeSequence'),  # noqa
    0x00741020: ('SQ', '1', "Beam Task Sequence", '', 'BeamTaskSequence'),  # noqa
    0x00741022: ('CS', '1', "Beam Task Type", '', 'BeamTaskType'),  # noqa
    0x00741024: ('IS', '1', "Beam Order Index (Trial)", 'Retired', 'BeamOrderIndexTrial'),  # noqa
    0x00741025: ('CS', '1', "Autosequence Flag", '', 'AutosequenceFlag'),  # noqa
    0x00741026: ('FD', '1', "Table Top Vertical Adjusted Position", '', 'TableTopVerticalAdjustedPosition'),  # noqa
    0x00741027: ('FD', '1', "Table Top Longitudinal Adjusted Position", '', 'TableTopLongitudinalAdjustedPosition'),  # noqa
    0x00741028: ('FD', '1', "Table Top Lateral Adjusted Position", '', 'TableTopLateralAdjustedPosition'),  # noqa
    0x0074102A: ('FD', '1', "Patient Support Adjusted Angle", '', 'PatientSupportAdjustedAngle'),  # noqa
    0x0074102B: ('FD', '1', "Table Top Eccentric Adjusted Angle", '', 'TableTopEccentricAdjustedAngle'),  # noqa
    0x0074102C: ('FD', '1', "Table Top Pitch Adjusted Angle", '', 'TableTopPitchAdjustedAngle'),  # noqa
    0x0074102D: ('FD', '1', "Table Top Roll Adjusted Angle", '', 'TableTopRollAdjustedAngle'),  # noqa
    0x00741030: ('SQ', '1', "Delivery Verification Image Sequence", '', 'DeliveryVerificationImageSequence'),  # noqa
    0x00741032: ('CS', '1', "Verification Image Timing", '', 'VerificationImageTiming'),  # noqa
    0x00741034: ('CS', '1', "Double Exposure Flag", '', 'DoubleExposureFlag'),  # noqa
    0x00741036: ('CS', '1', "Double Exposure Ordering", '', 'DoubleExposureOrdering'),  # noqa
    0x00741038: ('DS', '1', "Double Exposure Meterset (Trial)", 'Retired', 'DoubleExposureMetersetTrial'),  # noqa
    0x0074103A: ('DS', '4', "Double Exposure Field Delta (Trial)", 'Retired', 'DoubleExposureFieldDeltaTrial'),  # noqa
    0x00741040: ('SQ', '1', "Related Reference RT Image Sequence", '', 'RelatedReferenceRTImageSequence'),  # noqa
    0x00741042: ('SQ', '1', "General Machine Verification Sequence", '', 'GeneralMachineVerificationSequence'),  # noqa
    0x00741044: ('SQ', '1', "Conventional Machine Verification Sequence", '', 'ConventionalMachineVerificationSequence'),  # noqa
    0x00741046: ('SQ', '1', "Ion Machine Verification Sequence", '', 'IonMachineVerificationSequence'),  # noqa
    0x00741048: ('SQ', '1', "Failed Attributes Sequence", '', 'FailedAttributesSequence'),  # noqa
    0x0074104A: ('SQ', '1', "Overridden Attributes Sequence", '', 'OverriddenAttributesSequence'),  # noqa
    0x0074104C: ('SQ', '1', "Conventional Control Point Verification Sequence", '', 'ConventionalControlPointVerificationSequence'),  # noqa
    0x0074104E: ('SQ', '1', "Ion Control Point Verification Sequence", '', 'IonControlPointVerificationSequence'),  # noqa
    0x00741050: ('SQ', '1', "Attribute Occurrence Sequence", '', 'AttributeOccurrenceSequence'),  # noqa
    0x00741052: ('AT', '1', "Attribute Occurrence Pointer", '', 'AttributeOccurrencePointer'),  # noqa
    0x00741054: ('UL', '1', "Attribute Item Selector", '', 'AttributeItemSelector'),  # noqa
    0x00741056: ('LO', '1', "Attribute Occurrence Private Creator", '', 'AttributeOccurrencePrivateCreator'),  # noqa
    0x00741057: ('IS', '1-n', "Selector Sequence Pointer Items", '', 'SelectorSequencePointerItems'),  # noqa
    0x00741200: ('CS', '1', "Scheduled Procedure Step Priority", '', 'ScheduledProcedureStepPriority'),  # noqa
    0x00741202: ('LO', '1', "Worklist Label", '', 'WorklistLabel'),  # noqa
    0x00741204: ('LO', '1', "Procedure Step Label", '', 'ProcedureStepLabel'),  # noqa
    0x00741210: ('SQ', '1', "Scheduled Processing Parameters Sequence", '', 'ScheduledProcessingParametersSequence'),  # noqa
    0x00741212: ('SQ', '1', "Performed Processing Parameters Sequence", '', 'PerformedProcessingParametersSequence'),  # noqa
    0x00741216: ('SQ', '1', "Unified Procedure Step Performed Procedure Sequence", '', 'UnifiedProcedureStepPerformedProcedureSequence'),  # noqa
    0x00741220: ('SQ', '1', "Related Procedure Step Sequence", 'Retired', 'RelatedProcedureStepSequence'),  # noqa
    0x00741222: ('LO', '1', "Procedure Step Relationship Type", 'Retired', 'ProcedureStepRelationshipType'),  # noqa
    0x00741224: ('SQ', '1', "Replaced Procedure Step Sequence", '', 'ReplacedProcedureStepSequence'),  # noqa
    0x00741230: ('LO', '1', "Deletion Lock", '', 'DeletionLock'),  # noqa
    0x00741234: ('AE', '1', "Receiving AE", '', 'ReceivingAE'),  # noqa
    0x00741236: ('AE', '1', "Requesting AE", '', 'RequestingAE'),  # noqa
    0x00741238: ('LT', '1', "Reason for Cancellation", '', 'ReasonForCancellation'),  # noqa
    0x00741242: ('CS', '1', "SCP Status", '', 'SCPStatus'),  # noqa
    0x00741244: ('CS', '1', "Subscription List Status", '', 'SubscriptionListStatus'),  # noqa
    0x00741246: ('CS', '1', "Unified Procedure Step List Status", '', 'UnifiedProcedureStepListStatus'),  # noqa
    0x00741324: ('UL', '1', "Beam Order Index", '', 'BeamOrderIndex'),  # noqa
    0x00741338: ('FD', '1', "Double Exposure Meterset", '', 'DoubleExposureMeterset'),  # noqa
    0x0074133A: ('FD', '4', "Double Exposure Field Delta", '', 'DoubleExposureFieldDelta'),  # noqa
    0x00741401: ('SQ', '1', "Brachy Task Sequence", '', 'BrachyTaskSequence'),  # noqa
    0x00741402: ('DS', '1', "Continuation Start Total Reference Air Kerma", '', 'ContinuationStartTotalReferenceAirKerma'),  # noqa
    0x00741403: ('DS', '1', "Continuation End Total Reference Air Kerma", '', 'ContinuationEndTotalReferenceAirKerma'),  # noqa
    0x00741404: ('IS', '1', "Continuation Pulse Number", '', 'ContinuationPulseNumber'),  # noqa
    0x00741405: ('SQ', '1', "Channel Delivery Order Sequence", '', 'ChannelDeliveryOrderSequence'),  # noqa
    0x00741406: ('IS', '1', "Referenced Channel Number", '', 'ReferencedChannelNumber'),  # noqa
    0x00741407: ('DS', '1', "Start Cumulative Time Weight", '', 'StartCumulativeTimeWeight'),  # noqa
    0x00741408: ('DS', '1', "End Cumulative Time Weight", '', 'EndCumulativeTimeWeight'),  # noqa
    0x00741409: ('SQ', '1', "Omitted Channel Sequence", '', 'OmittedChannelSequence'),  # noqa
    0x0074140A: ('CS', '1', "Reason for Channel Omission", '', 'ReasonForChannelOmission'),  # noqa
    0x0074140B: ('LO', '1', "Reason for Channel Omission Description", '', 'ReasonForChannelOmissionDescription'),  # noqa
    0x0074140C: ('IS', '1', "Channel Delivery Order Index", '', 'ChannelDeliveryOrderIndex'),  # noqa
    0x0074140D: ('SQ', '1', "Channel Delivery Continuation Sequence", '', 'ChannelDeliveryContinuationSequence'),  # noqa
    0x0074140E: ('SQ', '1', "Omitted Application Setup Sequence", '', 'OmittedApplicationSetupSequence'),  # noqa
    0x00760001: ('LO', '1', "Implant Assembly Template Name", '', 'ImplantAssemblyTemplateName'),  # noqa
    0x00760003: ('LO', '1', "Implant Assembly Template Issuer", '', 'ImplantAssemblyTemplateIssuer'),  # noqa
    0x00760006: ('LO', '1', "Implant Assembly Template Version", '', 'ImplantAssemblyTemplateVersion'),  # noqa
    0x00760008: ('SQ', '1', "Replaced Implant Assembly Template Sequence", '', 'ReplacedImplantAssemblyTemplateSequence'),  # noqa
    0x0076000A: ('CS', '1', "Implant Assembly Template Type", '', 'ImplantAssemblyTemplateType'),  # noqa
    0x0076000C: ('SQ', '1', "Original Implant Assembly Template Sequence", '', 'OriginalImplantAssemblyTemplateSequence'),  # noqa
    0x0076000E: ('SQ', '1', "Derivation Implant Assembly Template Sequence", '', 'DerivationImplantAssemblyTemplateSequence'),  # noqa
    0x00760010: ('SQ', '1', "Implant Assembly Template Target Anatomy Sequence", '', 'ImplantAssemblyTemplateTargetAnatomySequence'),  # noqa
    0x00760020: ('SQ', '1', "Procedure Type Code Sequence", '', 'ProcedureTypeCodeSequence'),  # noqa
    0x00760030: ('LO', '1', "Surgical Technique", '', 'SurgicalTechnique'),  # noqa
    0x00760032: ('SQ', '1', "Component Types Sequence", '', 'ComponentTypesSequence'),  # noqa
    0x00760034: ('SQ', '1', "Component Type Code Sequence", '', 'ComponentTypeCodeSequence'),  # noqa
    0x00760036: ('CS', '1', "Exclusive Component Type", '', 'ExclusiveComponentType'),  # noqa
    0x00760038: ('CS', '1', "Mandatory Component Type", '', 'MandatoryComponentType'),  # noqa
    0x00760040: ('SQ', '1', "Component Sequence", '', 'ComponentSequence'),  # noqa
    0x00760055: ('US', '1', "Component ID", '', 'ComponentID'),  # noqa
    0x00760060: ('SQ', '1', "Component Assembly Sequence", '', 'ComponentAssemblySequence'),  # noqa
    0x00760070: ('US', '1', "Component 1 Referenced ID", '', 'Component1ReferencedID'),  # noqa
    0x00760080: ('US', '1', "Component 1 Referenced Mating Feature Set ID", '', 'Component1ReferencedMatingFeatureSetID'),  # noqa
    0x00760090: ('US', '1', "Component 1 Referenced Mating Feature ID", '', 'Component1ReferencedMatingFeatureID'),  # noqa
    0x007600A0: ('US', '1', "Component 2 Referenced ID", '', 'Component2ReferencedID'),  # noqa
    0x007600B0: ('US', '1', "Component 2 Referenced Mating Feature Set ID", '', 'Component2ReferencedMatingFeatureSetID'),  # noqa
    0x007600C0: ('US', '1', "Component 2 Referenced Mating Feature ID", '', 'Component2ReferencedMatingFeatureID'),  # noqa
    0x00780001: ('LO', '1', "Implant Template Group Name", '', 'ImplantTemplateGroupName'),  # noqa
    0x00780010: ('ST', '1', "Implant Template Group Description", '', 'ImplantTemplateGroupDescription'),  # noqa
    0x00780020: ('LO', '1', "Implant Template Group Issuer", '', 'ImplantTemplateGroupIssuer'),  # noqa
    0x00780024: ('LO', '1', "Implant Template Group Version", '', 'ImplantTemplateGroupVersion'),  # noqa
    0x00780026: ('SQ', '1', "Replaced Implant Template Group Sequence", '', 'ReplacedImplantTemplateGroupSequence'),  # noqa
    0x00780028: ('SQ', '1', "Implant Template Group Target Anatomy Sequence", '', 'ImplantTemplateGroupTargetAnatomySequence'),  # noqa
    0x0078002A: ('SQ', '1', "Implant Template Group Members Sequence", '', 'ImplantTemplateGroupMembersSequence'),  # noqa
    0x0078002E: ('US', '1', "Implant Template Group Member ID", '', 'ImplantTemplateGroupMemberID'),  # noqa
    0x00780050: ('FD', '3', "3D Implant Template Group Member Matching Point", '', 'ThreeDImplantTemplateGroupMemberMatchingPoint'),  # noqa
    0x00780060: ('FD', '9', "3D Implant Template Group Member Matching Axes", '', 'ThreeDImplantTemplateGroupMemberMatchingAxes'),  # noqa
    0x00780070: ('SQ', '1', "Implant Template Group Member Matching 2D Coordinates Sequence", '', 'ImplantTemplateGroupMemberMatching2DCoordinatesSequence'),  # noqa
    0x00780090: ('FD', '2', "2D Implant Template Group Member Matching Point", '', 'TwoDImplantTemplateGroupMemberMatchingPoint'),  # noqa
    0x007800A0: ('FD', '4', "2D Implant Template Group Member Matching Axes", '', 'TwoDImplantTemplateGroupMemberMatchingAxes'),  # noqa
    0x007800B0: ('SQ', '1', "Implant Template Group Variation Dimension Sequence", '', 'ImplantTemplateGroupVariationDimensionSequence'),  # noqa
    0x007800B2: ('LO', '1', "Implant Template Group Variation Dimension Name", '', 'ImplantTemplateGroupVariationDimensionName'),  # noqa
    0x007800B4: ('SQ', '1', "Implant Template Group Variation Dimension Rank Sequence", '', 'ImplantTemplateGroupVariationDimensionRankSequence'),  # noqa
    0x007800B6: ('US', '1', "Referenced Implant Template Group Member ID", '', 'ReferencedImplantTemplateGroupMemberID'),  # noqa
    0x007800B8: ('US', '1', "Implant Template Group Variation Dimension Rank", '', 'ImplantTemplateGroupVariationDimensionRank'),  # noqa
    0x00800001: ('SQ', '1', "Surface Scan Acquisition Type Code Sequence", '', 'SurfaceScanAcquisitionTypeCodeSequence'),  # noqa
    0x00800002: ('SQ', '1', "Surface Scan Mode Code Sequence", '', 'SurfaceScanModeCodeSequence'),  # noqa
    0x00800003: ('SQ', '1', "Registration Method Code Sequence", '', 'RegistrationMethodCodeSequence'),  # noqa
    0x00800004: ('FD', '1', "Shot Duration Time", '', 'ShotDurationTime'),  # noqa
    0x00800005: ('FD', '1', "Shot Offset Time", '', 'ShotOffsetTime'),  # noqa
    0x00800006: ('US', '1-n', "Surface Point Presentation Value Data", '', 'SurfacePointPresentationValueData'),  # noqa
    0x00800007: ('US', '3-3n', "Surface Point Color CIELab Value Data", '', 'SurfacePointColorCIELabValueData'),  # noqa
    0x00800008: ('SQ', '1', "UV Mapping Sequence", '', 'UVMappingSequence'),  # noqa
    0x00800009: ('SH', '1', "Texture Label", '', 'TextureLabel'),  # noqa
    0x00800010: ('OF', '1-n', "U Value Data", '', 'UValueData'),  # noqa
    0x00800011: ('OF', '1-n', "V Value Data", '', 'VValueData'),  # noqa
    0x00800012: ('SQ', '1', "Referenced Texture Sequence", '', 'ReferencedTextureSequence'),  # noqa
    0x00800013: ('SQ', '1', "Referenced Surface Data Sequence", '', 'ReferencedSurfaceDataSequence'),  # noqa
    0x00820001: ('CS', '1', "Assessment Summary", '', 'AssessmentSummary'),  # noqa
    0x00820003: ('UT', '1', "Assessment Summary Description", '', 'AssessmentSummaryDescription'),  # noqa
    0x00820004: ('SQ', '1', "Assessed SOP Instance Sequence", '', 'AssessedSOPInstanceSequence'),  # noqa
    0x00820005: ('SQ', '1', "Referenced Comparison SOP Instance Sequence", '', 'ReferencedComparisonSOPInstanceSequence'),  # noqa
    0x00820006: ('UL', '1', "Number of Assessment Observations", '', 'NumberOfAssessmentObservations'),  # noqa
    0x00820007: ('SQ', '1', "Assessment Observations Sequence", '', 'AssessmentObservationsSequence'),  # noqa
    0x00820008: ('CS', '1', "Observation Significance", '', 'ObservationSignificance'),  # noqa
    0x0082000A: ('UT', '1', "Observation Description", '', 'ObservationDescription'),  # noqa
    0x0082000C: ('SQ', '1', "Structured Constraint Observation Sequence", '', 'StructuredConstraintObservationSequence'),  # noqa
    0x00820010: ('SQ', '1', "Assessed Attribute Value Sequence", '', 'AssessedAttributeValueSequence'),  # noqa
    0x00820016: ('LO', '1', "Assessment Set ID", '', 'AssessmentSetID'),  # noqa
    0x00820017: ('SQ', '1', "Assessment Requester Sequence", '', 'AssessmentRequesterSequence'),  # noqa
    0x00820018: ('LO', '1', "Selector Attribute Name", '', 'SelectorAttributeName'),  # noqa
    0x00820019: ('LO', '1', "Selector Attribute Keyword", '', 'SelectorAttributeKeyword'),  # noqa
    0x00820021: ('SQ', '1', "Assessment Type Code Sequence", '', 'AssessmentTypeCodeSequence'),  # noqa
    0x00820022: ('SQ', '1', "Observation Basis Code Sequence", '', 'ObservationBasisCodeSequence'),  # noqa
    0x00820023: ('LO', '1', "Assessment Label", '', 'AssessmentLabel'),  # noqa
    0x00820032: ('CS', '1', "Constraint Type", '', 'ConstraintType'),  # noqa
    0x00820033: ('UT', '1', "Specification Selection Guidance", '', 'SpecificationSelectionGuidance'),  # noqa
    0x00820034: ('SQ', '1', "Constraint Value Sequence", '', 'ConstraintValueSequence'),  # noqa
    0x00820035: ('SQ', '1', "Recommended Default Value Sequence", '', 'RecommendedDefaultValueSequence'),  # noqa
    0x00820036: ('CS', '1', "Constraint Violation Significance", '', 'ConstraintViolationSignificance'),  # noqa
    0x00820037: ('UT', '1', "Constraint Violation Condition", '', 'ConstraintViolationCondition'),  # noqa
    0x00820038: ('CS', '1', "Modifiable Constraint Flag", '', 'ModifiableConstraintFlag'),  # noqa
    0x00880130: ('SH', '1', "Storage Media File-set ID", '', 'StorageMediaFileSetID'),  # noqa
    0x00880140: ('UI', '1', "Storage Media File-set UID", '', 'StorageMediaFileSetUID'),  # noqa
    0x00880200: ('SQ', '1', "Icon Image Sequence", '', 'IconImageSequence'),  # noqa
    0x00880904: ('LO', '1', "Topic Title", 'Retired', 'TopicTitle'),  # noqa
    0x00880906: ('ST', '1', "Topic Subject", 'Retired', 'TopicSubject'),  # noqa
    0x00880910: ('LO', '1', "Topic Author", 'Retired', 'TopicAuthor'),  # noqa
    0x00880912: ('LO', '1-32', "Topic Keywords", 'Retired', 'TopicKeywords'),  # noqa
    0x01000410: ('CS', '1', "SOP Instance Status", '', 'SOPInstanceStatus'),  # noqa
    0x01000420: ('DT', '1', "SOP Authorization DateTime", '', 'SOPAuthorizationDateTime'),  # noqa
    0x01000424: ('LT', '1', "SOP Authorization Comment", '', 'SOPAuthorizationComment'),  # noqa
    0x01000426: ('LO', '1', "Authorization Equipment Certification Number", '', 'AuthorizationEquipmentCertificationNumber'),  # noqa
    0x04000005: ('US', '1', "MAC ID Number", '', 'MACIDNumber'),  # noqa
    0x04000010: ('UI', '1', "MAC Calculation Transfer Syntax UID", '', 'MACCalculationTransferSyntaxUID'),  # noqa
    0x04000015: ('CS', '1', "MAC Algorithm", '', 'MACAlgorithm'),  # noqa
    0x04000020: ('AT', '1-n', "Data Elements Signed", '', 'DataElementsSigned'),  # noqa
    0x04000100: ('UI', '1', "Digital Signature UID", '', 'DigitalSignatureUID'),  # noqa
    0x04000105: ('DT', '1', "Digital Signature DateTime", '', 'DigitalSignatureDateTime'),  # noqa
    0x04000110: ('CS', '1', "Certificate Type", '', 'CertificateType'),  # noqa
    0x04000115: ('OB', '1', "Certificate of Signer", '', 'CertificateOfSigner'),  # noqa
    0x04000120: ('OB', '1', "Signature", '', 'Signature'),  # noqa
    0x04000305: ('CS', '1', "Certified Timestamp Type", '', 'CertifiedTimestampType'),  # noqa
    0x04000310: ('OB', '1', "Certified Timestamp", '', 'CertifiedTimestamp'),  # noqa
    0x04000315: ('FL', '1', "", 'Retired', ''),  # noqa
    0x04000401: ('SQ', '1', "Digital Signature Purpose Code Sequence", '', 'DigitalSignaturePurposeCodeSequence'),  # noqa
    0x04000402: ('SQ', '1', "Referenced Digital Signature Sequence", '', 'ReferencedDigitalSignatureSequence'),  # noqa
    0x04000403: ('SQ', '1', "Referenced SOP Instance MAC Sequence", '', 'ReferencedSOPInstanceMACSequence'),  # noqa
    0x04000404: ('OB', '1', "MAC", '', 'MAC'),  # noqa
    0x04000500: ('SQ', '1', "Encrypted Attributes Sequence", '', 'EncryptedAttributesSequence'),  # noqa
    0x04000510: ('UI', '1', "Encrypted Content Transfer Syntax UID", '', 'EncryptedContentTransferSyntaxUID'),  # noqa
    0x04000520: ('OB', '1', "Encrypted Content", '', 'EncryptedContent'),  # noqa
    0x04000550: ('SQ', '1', "Modified Attributes Sequence", '', 'ModifiedAttributesSequence'),  # noqa
    0x04000561: ('SQ', '1', "Original Attributes Sequence", '', 'OriginalAttributesSequence'),  # noqa
    0x04000562: ('DT', '1', "Attribute Modification DateTime", '', 'AttributeModificationDateTime'),  # noqa
    0x04000563: ('LO', '1', "Modifying System", '', 'ModifyingSystem'),  # noqa
    0x04000564: ('LO', '1', "Source of Previous Values", '', 'SourceOfPreviousValues'),  # noqa
    0x04000565: ('CS', '1', "Reason for the Attribute Modification", '', 'ReasonForTheAttributeModification'),  # noqa
    0x20000010: ('IS', '1', "Number of Copies", '', 'NumberOfCopies'),  # noqa
    0x2000001E: ('SQ', '1', "Printer Configuration Sequence", '', 'PrinterConfigurationSequence'),  # noqa
    0x20000020: ('CS', '1', "Print Priority", '', 'PrintPriority'),  # noqa
    0x20000030: ('CS', '1', "Medium Type", '', 'MediumType'),  # noqa
    0x20000040: ('CS', '1', "Film Destination", '', 'FilmDestination'),  # noqa
    0x20000050: ('LO', '1', "Film Session Label", '', 'FilmSessionLabel'),  # noqa
    0x20000060: ('IS', '1', "Memory Allocation", '', 'MemoryAllocation'),  # noqa
    0x20000061: ('IS', '1', "Maximum Memory Allocation", '', 'MaximumMemoryAllocation'),  # noqa
    0x20000062: ('CS', '1', "Color Image Printing Flag", 'Retired', 'ColorImagePrintingFlag'),  # noqa
    0x20000063: ('CS', '1', "Collation Flag", 'Retired', 'CollationFlag'),  # noqa
    0x20000065: ('CS', '1', "Annotation Flag", 'Retired', 'AnnotationFlag'),  # noqa
    0x20000067: ('CS', '1', "Image Overlay Flag", 'Retired', 'ImageOverlayFlag'),  # noqa
    0x20000069: ('CS', '1', "Presentation LUT Flag", 'Retired', 'PresentationLUTFlag'),  # noqa
    0x2000006A: ('CS', '1', "Image Box Presentation LUT Flag", 'Retired', 'ImageBoxPresentationLUTFlag'),  # noqa
    0x200000A0: ('US', '1', "Memory Bit Depth", '', 'MemoryBitDepth'),  # noqa
    0x200000A1: ('US', '1', "Printing Bit Depth", '', 'PrintingBitDepth'),  # noqa
    0x200000A2: ('SQ', '1', "Media Installed Sequence", '', 'MediaInstalledSequence'),  # noqa
    0x200000A4: ('SQ', '1', "Other Media Available Sequence", '', 'OtherMediaAvailableSequence'),  # noqa
    0x200000A8: ('SQ', '1', "Supported Image Display Formats Sequence", '', 'SupportedImageDisplayFormatsSequence'),  # noqa
    0x20000500: ('SQ', '1', "Referenced Film Box Sequence", '', 'ReferencedFilmBoxSequence'),  # noqa
    0x20000510: ('SQ', '1', "Referenced Stored Print Sequence", 'Retired', 'ReferencedStoredPrintSequence'),  # noqa
    0x20100010: ('ST', '1', "Image Display Format", '', 'ImageDisplayFormat'),  # noqa
    0x20100030: ('CS', '1', "Annotation Display Format ID", '', 'AnnotationDisplayFormatID'),  # noqa
    0x20100040: ('CS', '1', "Film Orientation", '', 'FilmOrientation'),  # noqa
    0x20100050: ('CS', '1', "Film Size ID", '', 'FilmSizeID'),  # noqa
    0x20100052: ('CS', '1', "Printer Resolution ID", '', 'PrinterResolutionID'),  # noqa
    0x20100054: ('CS', '1', "Default Printer Resolution ID", '', 'DefaultPrinterResolutionID'),  # noqa
    0x20100060: ('CS', '1', "Magnification Type", '', 'MagnificationType'),  # noqa
    0x20100080: ('CS', '1', "Smoothing Type", '', 'SmoothingType'),  # noqa
    0x201000A6: ('CS', '1', "Default Magnification Type", '', 'DefaultMagnificationType'),  # noqa
    0x201000A7: ('CS', '1-n', "Other Magnification Types Available", '', 'OtherMagnificationTypesAvailable'),  # noqa
    0x201000A8: ('CS', '1', "Default Smoothing Type", '', 'DefaultSmoothingType'),  # noqa
    0x201000A9: ('CS', '1-n', "Other Smoothing Types Available", '', 'OtherSmoothingTypesAvailable'),  # noqa
    0x20100100: ('CS', '1', "Border Density", '', 'BorderDensity'),  # noqa
    0x20100110: ('CS', '1', "Empty Image Density", '', 'EmptyImageDensity'),  # noqa
    0x20100120: ('US', '1', "Min Density", '', 'MinDensity'),  # noqa
    0x20100130: ('US', '1', "Max Density", '', 'MaxDensity'),  # noqa
    0x20100140: ('CS', '1', "Trim", '', 'Trim'),  # noqa
    0x20100150: ('ST', '1', "Configuration Information", '', 'ConfigurationInformation'),  # noqa
    0x20100152: ('LT', '1', "Configuration Information Description", '', 'ConfigurationInformationDescription'),  # noqa
    0x20100154: ('IS', '1', "Maximum Collated Films", '', 'MaximumCollatedFilms'),  # noqa
    0x2010015E: ('US', '1', "Illumination", '', 'Illumination'),  # noqa
    0x20100160: ('US', '1', "Reflected Ambient Light", '', 'ReflectedAmbientLight'),  # noqa
    0x20100376: ('DS', '2', "Printer Pixel Spacing", '', 'PrinterPixelSpacing'),  # noqa
    0x20100500: ('SQ', '1', "Referenced Film Session Sequence", '', 'ReferencedFilmSessionSequence'),  # noqa
    0x20100510: ('SQ', '1', "Referenced Image Box Sequence", '', 'ReferencedImageBoxSequence'),  # noqa
    0x20100520: ('SQ', '1', "Referenced Basic Annotation Box Sequence", '', 'ReferencedBasicAnnotationBoxSequence'),  # noqa
    0x20200010: ('US', '1', "Image Box Position", '', 'ImageBoxPosition'),  # noqa
    0x20200020: ('CS', '1', "Polarity", '', 'Polarity'),  # noqa
    0x20200030: ('DS', '1', "Requested Image Size", '', 'RequestedImageSize'),  # noqa
    0x20200040: ('CS', '1', "Requested Decimate/Crop Behavior", '', 'RequestedDecimateCropBehavior'),  # noqa
    0x20200050: ('CS', '1', "Requested Resolution ID", '', 'RequestedResolutionID'),  # noqa
    0x202000A0: ('CS', '1', "Requested Image Size Flag", '', 'RequestedImageSizeFlag'),  # noqa
    0x202000A2: ('CS', '1', "Decimate/Crop Result", '', 'DecimateCropResult'),  # noqa
    0x20200110: ('SQ', '1', "Basic Grayscale Image Sequence", '', 'BasicGrayscaleImageSequence'),  # noqa
    0x20200111: ('SQ', '1', "Basic Color Image Sequence", '', 'BasicColorImageSequence'),  # noqa
    0x20200130: ('SQ', '1', "Referenced Image Overlay Box Sequence", 'Retired', 'ReferencedImageOverlayBoxSequence'),  # noqa
    0x20200140: ('SQ', '1', "Referenced VOI LUT Box Sequence", 'Retired', 'ReferencedVOILUTBoxSequence'),  # noqa
    0x20300010: ('US', '1', "Annotation Position", '', 'AnnotationPosition'),  # noqa
    0x20300020: ('LO', '1', "Text String", '', 'TextString'),  # noqa
    0x20400010: ('SQ', '1', "Referenced Overlay Plane Sequence", 'Retired', 'ReferencedOverlayPlaneSequence'),  # noqa
    0x20400011: ('US', '1-99', "Referenced Overlay Plane Groups", 'Retired', 'ReferencedOverlayPlaneGroups'),  # noqa
    0x20400020: ('SQ', '1', "Overlay Pixel Data Sequence", 'Retired', 'OverlayPixelDataSequence'),  # noqa
    0x20400060: ('CS', '1', "Overlay Magnification Type", 'Retired', 'OverlayMagnificationType'),  # noqa
    0x20400070: ('CS', '1', "Overlay Smoothing Type", 'Retired', 'OverlaySmoothingType'),  # noqa
    0x20400072: ('CS', '1', "Overlay or Image Magnification", 'Retired', 'OverlayOrImageMagnification'),  # noqa
    0x20400074: ('US', '1', "Magnify to Number of Columns", 'Retired', 'MagnifyToNumberOfColumns'),  # noqa
    0x20400080: ('CS', '1', "Overlay Foreground Density", 'Retired', 'OverlayForegroundDensity'),  # noqa
    0x20400082: ('CS', '1', "Overlay Background Density", 'Retired', 'OverlayBackgroundDensity'),  # noqa
    0x20400090: ('CS', '1', "Overlay Mode", 'Retired', 'OverlayMode'),  # noqa
    0x20400100: ('CS', '1', "Threshold Density", 'Retired', 'ThresholdDensity'),  # noqa
    0x20400500: ('SQ', '1', "Referenced Image Box Sequence (Retired)", 'Retired', 'ReferencedImageBoxSequenceRetired'),  # noqa
    0x20500010: ('SQ', '1', "Presentation LUT Sequence", '', 'PresentationLUTSequence'),  # noqa
    0x20500020: ('CS', '1', "Presentation LUT Shape", '', 'PresentationLUTShape'),  # noqa
    0x20500500: ('SQ', '1', "Referenced Presentation LUT Sequence", '', 'ReferencedPresentationLUTSequence'),  # noqa
    0x21000010: ('SH', '1', "Print Job ID", 'Retired', 'PrintJobID'),  # noqa
    0x21000020: ('CS', '1', "Execution Status", '', 'ExecutionStatus'),  # noqa
    0x21000030: ('CS', '1', "Execution Status Info", '', 'ExecutionStatusInfo'),  # noqa
    0x21000040: ('DA', '1', "Creation Date", '', 'CreationDate'),  # noqa
    0x21000050: ('TM', '1', "Creation Time", '', 'CreationTime'),  # noqa
    0x21000070: ('AE', '1', "Originator", '', 'Originator'),  # noqa
    0x21000140: ('AE', '1', "Destination AE", '', 'DestinationAE'),  # noqa
    0x21000160: ('SH', '1', "Owner ID", '', 'OwnerID'),  # noqa
    0x21000170: ('IS', '1', "Number of Films", '', 'NumberOfFilms'),  # noqa
    0x21000500: ('SQ', '1', "Referenced Print Job Sequence (Pull Stored Print)", 'Retired', 'ReferencedPrintJobSequencePullStoredPrint'),  # noqa
    0x21100010: ('CS', '1', "Printer Status", '', 'PrinterStatus'),  # noqa
    0x21100020: ('CS', '1', "Printer Status Info", '', 'PrinterStatusInfo'),  # noqa
    0x21100030: ('LO', '1', "Printer Name", '', 'PrinterName'),  # noqa
    0x21100099: ('SH', '1', "Print Queue ID", 'Retired', 'PrintQueueID'),  # noqa
    0x21200010: ('CS', '1', "Queue Status", 'Retired', 'QueueStatus'),  # noqa
    0x21200050: ('SQ', '1', "Print Job Description Sequence", 'Retired', 'PrintJobDescriptionSequence'),  # noqa
    0x21200070: ('SQ', '1', "Referenced Print Job Sequence", 'Retired', 'ReferencedPrintJobSequence'),  # noqa
    0x21300010: ('SQ', '1', "Print Management Capabilities Sequence", 'Retired', 'PrintManagementCapabilitiesSequence'),  # noqa
    0x21300015: ('SQ', '1', "Printer Characteristics Sequence", 'Retired', 'PrinterCharacteristicsSequence'),  # noqa
    0x21300030: ('SQ', '1', "Film Box Content Sequence", 'Retired', 'FilmBoxContentSequence'),  # noqa
    0x21300040: ('SQ', '1', "Image Box Content Sequence", 'Retired', 'ImageBoxContentSequence'),  # noqa
    0x21300050: ('SQ', '1', "Annotation Content Sequence", 'Retired', 'AnnotationContentSequence'),  # noqa
    0x21300060: ('SQ', '1', "Image Overlay Box Content Sequence", 'Retired', 'ImageOverlayBoxContentSequence'),  # noqa
    0x21300080: ('SQ', '1', "Presentation LUT Content Sequence", 'Retired', 'PresentationLUTContentSequence'),  # noqa
    0x213000A0: ('SQ', '1', "Proposed Study Sequence", 'Retired', 'ProposedStudySequence'),  # noqa
    0x213000C0: ('SQ', '1', "Original Image Sequence", 'Retired', 'OriginalImageSequence'),  # noqa
    0x22000001: ('CS', '1', "Label Using Information Extracted From Instances", '', 'LabelUsingInformationExtractedFromInstances'),  # noqa
    0x22000002: ('UT', '1', "Label Text", '', 'LabelText'),  # noqa
    0x22000003: ('CS', '1', "Label Style Selection", '', 'LabelStyleSelection'),  # noqa
    0x22000004: ('LT', '1', "Media Disposition", '', 'MediaDisposition'),  # noqa
    0x22000005: ('LT', '1', "Barcode Value", '', 'BarcodeValue'),  # noqa
    0x22000006: ('CS', '1', "Barcode Symbology", '', 'BarcodeSymbology'),  # noqa
    0x22000007: ('CS', '1', "Allow Media Splitting", '', 'AllowMediaSplitting'),  # noqa
    0x22000008: ('CS', '1', "Include Non-DICOM Objects", '', 'IncludeNonDICOMObjects'),  # noqa
    0x22000009: ('CS', '1', "Include Display Application", '', 'IncludeDisplayApplication'),  # noqa
    0x2200000A: ('CS', '1', "Preserve Composite Instances After Media Creation", '', 'PreserveCompositeInstancesAfterMediaCreation'),  # noqa
    0x2200000B: ('US', '1', "Total Number of Pieces of Media Created", '', 'TotalNumberOfPiecesOfMediaCreated'),  # noqa
    0x2200000C: ('LO', '1', "Requested Media Application Profile", '', 'RequestedMediaApplicationProfile'),  # noqa
    0x2200000D: ('SQ', '1', "Referenced Storage Media Sequence", '', 'ReferencedStorageMediaSequence'),  # noqa
    0x2200000E: ('AT', '1-n', "Failure Attributes", '', 'FailureAttributes'),  # noqa
    0x2200000F: ('CS', '1', "Allow Lossy Compression", '', 'AllowLossyCompression'),  # noqa
    0x22000020: ('CS', '1', "Request Priority", '', 'RequestPriority'),  # noqa
    0x30020002: ('SH', '1', "RT Image Label", '', 'RTImageLabel'),  # noqa
    0x30020003: ('LO', '1', "RT Image Name", '', 'RTImageName'),  # noqa
    0x30020004: ('ST', '1', "RT Image Description", '', 'RTImageDescription'),  # noqa
    0x3002000A: ('CS', '1', "Reported Values Origin", '', 'ReportedValuesOrigin'),  # noqa
    0x3002000C: ('CS', '1', "RT Image Plane", '', 'RTImagePlane'),  # noqa
    0x3002000D: ('DS', '3', "X-Ray Image Receptor Translation", '', 'XRayImageReceptorTranslation'),  # noqa
    0x3002000E: ('DS', '1', "X-Ray Image Receptor Angle", '', 'XRayImageReceptorAngle'),  # noqa
    0x30020010: ('DS', '6', "RT Image Orientation", '', 'RTImageOrientation'),  # noqa
    0x30020011: ('DS', '2', "Image Plane Pixel Spacing", '', 'ImagePlanePixelSpacing'),  # noqa
    0x30020012: ('DS', '2', "RT Image Position", '', 'RTImagePosition'),  # noqa
    0x30020020: ('SH', '1', "Radiation Machine Name", '', 'RadiationMachineName'),  # noqa
    0x30020022: ('DS', '1', "Radiation Machine SAD", '', 'RadiationMachineSAD'),  # noqa
    0x30020024: ('DS', '1', "Radiation Machine SSD", '', 'RadiationMachineSSD'),  # noqa
    0x30020026: ('DS', '1', "RT Image SID", '', 'RTImageSID'),  # noqa
    0x30020028: ('DS', '1', "Source to Reference Object Distance", '', 'SourceToReferenceObjectDistance'),  # noqa
    0x30020029: ('IS', '1', "Fraction Number", '', 'FractionNumber'),  # noqa
    0x30020030: ('SQ', '1', "Exposure Sequence", '', 'ExposureSequence'),  # noqa
    0x30020032: ('DS', '1', "Meterset Exposure", '', 'MetersetExposure'),  # noqa
    0x30020034: ('DS', '4', "Diaphragm Position", '', 'DiaphragmPosition'),  # noqa
    0x30020040: ('SQ', '1', "Fluence Map Sequence", '', 'FluenceMapSequence'),  # noqa
    0x30020041: ('CS', '1', "Fluence Data Source", '', 'FluenceDataSource'),  # noqa
    0x30020042: ('DS', '1', "Fluence Data Scale", '', 'FluenceDataScale'),  # noqa
    0x30020050: ('SQ', '1', "Primary Fluence Mode Sequence", '', 'PrimaryFluenceModeSequence'),  # noqa
    0x30020051: ('CS', '1', "Fluence Mode", '', 'FluenceMode'),  # noqa
    0x30020052: ('SH', '1', "Fluence Mode ID", '', 'FluenceModeID'),  # noqa
    0x30040001: ('CS', '1', "DVH Type", '', 'DVHType'),  # noqa
    0x30040002: ('CS', '1', "Dose Units", '', 'DoseUnits'),  # noqa
    0x30040004: ('CS', '1', "Dose Type", '', 'DoseType'),  # noqa
    0x30040005: ('CS', '1', "Spatial Transform of Dose", '', 'SpatialTransformOfDose'),  # noqa
    0x30040006: ('LO', '1', "Dose Comment", '', 'DoseComment'),  # noqa
    0x30040008: ('DS', '3', "Normalization Point", '', 'NormalizationPoint'),  # noqa
    0x3004000A: ('CS', '1', "Dose Summation Type", '', 'DoseSummationType'),  # noqa
    0x3004000C: ('DS', '2-n', "Grid Frame Offset Vector", '', 'GridFrameOffsetVector'),  # noqa
    0x3004000E: ('DS', '1', "Dose Grid Scaling", '', 'DoseGridScaling'),  # noqa
    0x30040010: ('SQ', '1', "RT Dose ROI Sequence", '', 'RTDoseROISequence'),  # noqa
    0x30040012: ('DS', '1', "Dose Value", '', 'DoseValue'),  # noqa
    0x30040014: ('CS', '1-3', "Tissue Heterogeneity Correction", '', 'TissueHeterogeneityCorrection'),  # noqa
    0x30040040: ('DS', '3', "DVH Normalization Point", '', 'DVHNormalizationPoint'),  # noqa
    0x30040042: ('DS', '1', "DVH Normalization Dose Value", '', 'DVHNormalizationDoseValue'),  # noqa
    0x30040050: ('SQ', '1', "DVH Sequence", '', 'DVHSequence'),  # noqa
    0x30040052: ('DS', '1', "DVH Dose Scaling", '', 'DVHDoseScaling'),  # noqa
    0x30040054: ('CS', '1', "DVH Volume Units", '', 'DVHVolumeUnits'),  # noqa
    0x30040056: ('IS', '1', "DVH Number of Bins", '', 'DVHNumberOfBins'),  # noqa
    0x30040058: ('DS', '2-2n', "DVH Data", '', 'DVHData'),  # noqa
    0x30040060: ('SQ', '1', "DVH Referenced ROI Sequence", '', 'DVHReferencedROISequence'),  # noqa
    0x30040062: ('CS', '1', "DVH ROI Contribution Type", '', 'DVHROIContributionType'),  # noqa
    0x30040070: ('DS', '1', "DVH Minimum Dose", '', 'DVHMinimumDose'),  # noqa
    0x30040072: ('DS', '1', "DVH Maximum Dose", '', 'DVHMaximumDose'),  # noqa
    0x30040074: ('DS', '1', "DVH Mean Dose", '', 'DVHMeanDose'),  # noqa
    0x30060002: ('SH', '1', "Structure Set Label", '', 'StructureSetLabel'),  # noqa
    0x30060004: ('LO', '1', "Structure Set Name", '', 'StructureSetName'),  # noqa
    0x30060006: ('ST', '1', "Structure Set Description", '', 'StructureSetDescription'),  # noqa
    0x30060008: ('DA', '1', "Structure Set Date", '', 'StructureSetDate'),  # noqa
    0x30060009: ('TM', '1', "Structure Set Time", '', 'StructureSetTime'),  # noqa
    0x30060010: ('SQ', '1', "Referenced Frame of Reference Sequence", '', 'ReferencedFrameOfReferenceSequence'),  # noqa
    0x30060012: ('SQ', '1', "RT Referenced Study Sequence", '', 'RTReferencedStudySequence'),  # noqa
    0x30060014: ('SQ', '1', "RT Referenced Series Sequence", '', 'RTReferencedSeriesSequence'),  # noqa
    0x30060016: ('SQ', '1', "Contour Image Sequence", '', 'ContourImageSequence'),  # noqa
    0x30060018: ('SQ', '1', "Predecessor Structure Set Sequence", '', 'PredecessorStructureSetSequence'),  # noqa
    0x30060020: ('SQ', '1', "Structure Set ROI Sequence", '', 'StructureSetROISequence'),  # noqa
    0x30060022: ('IS', '1', "ROI Number", '', 'ROINumber'),  # noqa
    0x30060024: ('UI', '1', "Referenced Frame of Reference UID", '', 'ReferencedFrameOfReferenceUID'),  # noqa
    0x30060026: ('LO', '1', "ROI Name", '', 'ROIName'),  # noqa
    0x30060028: ('ST', '1', "ROI Description", '', 'ROIDescription'),  # noqa
    0x3006002A: ('IS', '3', "ROI Display Color", '', 'ROIDisplayColor'),  # noqa
    0x3006002C: ('DS', '1', "ROI Volume", '', 'ROIVolume'),  # noqa
    0x30060030: ('SQ', '1', "RT Related ROI Sequence", '', 'RTRelatedROISequence'),  # noqa
    0x30060033: ('CS', '1', "RT ROI Relationship", '', 'RTROIRelationship'),  # noqa
    0x30060036: ('CS', '1', "ROI Generation Algorithm", '', 'ROIGenerationAlgorithm'),  # noqa
    0x30060038: ('LO', '1', "ROI Generation Description", '', 'ROIGenerationDescription'),  # noqa
    0x30060039: ('SQ', '1', "ROI Contour Sequence", '', 'ROIContourSequence'),  # noqa
    0x30060040: ('SQ', '1', "Contour Sequence", '', 'ContourSequence'),  # noqa
    0x30060042: ('CS', '1', "Contour Geometric Type", '', 'ContourGeometricType'),  # noqa
    0x30060044: ('DS', '1', "Contour Slab Thickness", '', 'ContourSlabThickness'),  # noqa
    0x30060045: ('DS', '3', "Contour Offset Vector", '', 'ContourOffsetVector'),  # noqa
    0x30060046: ('IS', '1', "Number of Contour Points", '', 'NumberOfContourPoints'),  # noqa
    0x30060048: ('IS', '1', "Contour Number", '', 'ContourNumber'),  # noqa
    0x30060049: ('IS', '1-n', "Attached Contours", '', 'AttachedContours'),  # noqa
    0x30060050: ('DS', '3-3n', "Contour Data", '', 'ContourData'),  # noqa
    0x30060080: ('SQ', '1', "RT ROI Observations Sequence", '', 'RTROIObservationsSequence'),  # noqa
    0x30060082: ('IS', '1', "Observation Number", '', 'ObservationNumber'),  # noqa
    0x30060084: ('IS', '1', "Referenced ROI Number", '', 'ReferencedROINumber'),  # noqa
    0x30060085: ('SH', '1', "ROI Observation Label", '', 'ROIObservationLabel'),  # noqa
    0x30060086: ('SQ', '1', "RT ROI Identification Code Sequence", '', 'RTROIIdentificationCodeSequence'),  # noqa
    0x30060088: ('ST', '1', "ROI Observation Description", '', 'ROIObservationDescription'),  # noqa
    0x300600A0: ('SQ', '1', "Related RT ROI Observations Sequence", '', 'RelatedRTROIObservationsSequence'),  # noqa
    0x300600A4: ('CS', '1', "RT ROI Interpreted Type", '', 'RTROIInterpretedType'),  # noqa
    0x300600A6: ('PN', '1', "ROI Interpreter", '', 'ROIInterpreter'),  # noqa
    0x300600B0: ('SQ', '1', "ROI Physical Properties Sequence", '', 'ROIPhysicalPropertiesSequence'),  # noqa
    0x300600B2: ('CS', '1', "ROI Physical Property", '', 'ROIPhysicalProperty'),  # noqa
    0x300600B4: ('DS', '1', "ROI Physical Property Value", '', 'ROIPhysicalPropertyValue'),  # noqa
    0x300600B6: ('SQ', '1', "ROI Elemental Composition Sequence", '', 'ROIElementalCompositionSequence'),  # noqa
    0x300600B7: ('US', '1', "ROI Elemental Composition Atomic Number", '', 'ROIElementalCompositionAtomicNumber'),  # noqa
    0x300600B8: ('FL', '1', "ROI Elemental Composition Atomic Mass Fraction", '', 'ROIElementalCompositionAtomicMassFraction'),  # noqa
    0x300600B9: ('SQ', '1', "Additional RT ROI Identification Code Sequence", 'Retired', 'AdditionalRTROIIdentificationCodeSequence'),  # noqa
    0x300600C0: ('SQ', '1', "Frame of Reference Relationship Sequence", 'Retired', 'FrameOfReferenceRelationshipSequence'),  # noqa
    0x300600C2: ('UI', '1', "Related Frame of Reference UID", 'Retired', 'RelatedFrameOfReferenceUID'),  # noqa
    0x300600C4: ('CS', '1', "Frame of Reference Transformation Type", 'Retired', 'FrameOfReferenceTransformationType'),  # noqa
    0x300600C6: ('DS', '16', "Frame of Reference Transformation Matrix", '', 'FrameOfReferenceTransformationMatrix'),  # noqa
    0x300600C8: ('LO', '1', "Frame of Reference Transformation Comment", '', 'FrameOfReferenceTransformationComment'),  # noqa
    0x30080010: ('SQ', '1', "Measured Dose Reference Sequence", '', 'MeasuredDoseReferenceSequence'),  # noqa
    0x30080012: ('ST', '1', "Measured Dose Description", '', 'MeasuredDoseDescription'),  # noqa
    0x30080014: ('CS', '1', "Measured Dose Type", '', 'MeasuredDoseType'),  # noqa
    0x30080016: ('DS', '1', "Measured Dose Value", '', 'MeasuredDoseValue'),  # noqa
    0x30080020: ('SQ', '1', "Treatment Session Beam Sequence", '', 'TreatmentSessionBeamSequence'),  # noqa
    0x30080021: ('SQ', '1', "Treatment Session Ion Beam Sequence", '', 'TreatmentSessionIonBeamSequence'),  # noqa
    0x30080022: ('IS', '1', "Current Fraction Number", '', 'CurrentFractionNumber'),  # noqa
    0x30080024: ('DA', '1', "Treatment Control Point Date", '', 'TreatmentControlPointDate'),  # noqa
    0x30080025: ('TM', '1', "Treatment Control Point Time", '', 'TreatmentControlPointTime'),  # noqa
    0x3008002A: ('CS', '1', "Treatment Termination Status", '', 'TreatmentTerminationStatus'),  # noqa
    0x3008002B: ('SH', '1', "Treatment Termination Code", '', 'TreatmentTerminationCode'),  # noqa
    0x3008002C: ('CS', '1', "Treatment Verification Status", '', 'TreatmentVerificationStatus'),  # noqa
    0x30080030: ('SQ', '1', "Referenced Treatment Record Sequence", '', 'ReferencedTreatmentRecordSequence'),  # noqa
    0x30080032: ('DS', '1', "Specified Primary Meterset", '', 'SpecifiedPrimaryMeterset'),  # noqa
    0x30080033: ('DS', '1', "Specified Secondary Meterset", '', 'SpecifiedSecondaryMeterset'),  # noqa
    0x30080036: ('DS', '1', "Delivered Primary Meterset", '', 'DeliveredPrimaryMeterset'),  # noqa
    0x30080037: ('DS', '1', "Delivered Secondary Meterset", '', 'DeliveredSecondaryMeterset'),  # noqa
    0x3008003A: ('DS', '1', "Specified Treatment Time", '', 'SpecifiedTreatmentTime'),  # noqa
    0x3008003B: ('DS', '1', "Delivered Treatment Time", '', 'DeliveredTreatmentTime'),  # noqa
    0x30080040: ('SQ', '1', "Control Point Delivery Sequence", '', 'ControlPointDeliverySequence'),  # noqa
    0x30080041: ('SQ', '1', "Ion Control Point Delivery Sequence", '', 'IonControlPointDeliverySequence'),  # noqa
    0x30080042: ('DS', '1', "Specified Meterset", '', 'SpecifiedMeterset'),  # noqa
    0x30080044: ('DS', '1', "Delivered Meterset", '', 'DeliveredMeterset'),  # noqa
    0x30080045: ('FL', '1', "Meterset Rate Set", '', 'MetersetRateSet'),  # noqa
    0x30080046: ('FL', '1', "Meterset Rate Delivered", '', 'MetersetRateDelivered'),  # noqa
    0x30080047: ('FL', '1-n', "Scan Spot Metersets Delivered", '', 'ScanSpotMetersetsDelivered'),  # noqa
    0x30080048: ('DS', '1', "Dose Rate Delivered", '', 'DoseRateDelivered'),  # noqa
    0x30080050: ('SQ', '1', "Treatment Summary Calculated Dose Reference Sequence", '', 'TreatmentSummaryCalculatedDoseReferenceSequence'),  # noqa
    0x30080052: ('DS', '1', "Cumulative Dose to Dose Reference", '', 'CumulativeDoseToDoseReference'),  # noqa
    0x30080054: ('DA', '1', "First Treatment Date", '', 'FirstTreatmentDate'),  # noqa
    0x30080056: ('DA', '1', "Most Recent Treatment Date", '', 'MostRecentTreatmentDate'),  # noqa
    0x3008005A: ('IS', '1', "Number of Fractions Delivered", '', 'NumberOfFractionsDelivered'),  # noqa
    0x30080060: ('SQ', '1', "Override Sequence", '', 'OverrideSequence'),  # noqa
    0x30080061: ('AT', '1', "Parameter Sequence Pointer", '', 'ParameterSequencePointer'),  # noqa
    0x30080062: ('AT', '1', "Override Parameter Pointer", '', 'OverrideParameterPointer'),  # noqa
    0x30080063: ('IS', '1', "Parameter Item Index", '', 'ParameterItemIndex'),  # noqa
    0x30080064: ('IS', '1', "Measured Dose Reference Number", '', 'MeasuredDoseReferenceNumber'),  # noqa
    0x30080065: ('AT', '1', "Parameter Pointer", '', 'ParameterPointer'),  # noqa
    0x30080066: ('ST', '1', "Override Reason", '', 'OverrideReason'),  # noqa
    0x30080067: ('US', '1', "Parameter Value Number", '', 'ParameterValueNumber'),  # noqa
    0x30080068: ('SQ', '1', "Corrected Parameter Sequence", '', 'CorrectedParameterSequence'),  # noqa
    0x3008006A: ('FL', '1', "Correction Value", '', 'CorrectionValue'),  # noqa
    0x30080070: ('SQ', '1', "Calculated Dose Reference Sequence", '', 'CalculatedDoseReferenceSequence'),  # noqa
    0x30080072: ('IS', '1', "Calculated Dose Reference Number", '', 'CalculatedDoseReferenceNumber'),  # noqa
    0x30080074: ('ST', '1', "Calculated Dose Reference Description", '', 'CalculatedDoseReferenceDescription'),  # noqa
    0x30080076: ('DS', '1', "Calculated Dose Reference Dose Value", '', 'CalculatedDoseReferenceDoseValue'),  # noqa
    0x30080078: ('DS', '1', "Start Meterset", '', 'StartMeterset'),  # noqa
    0x3008007A: ('DS', '1', "End Meterset", '', 'EndMeterset'),  # noqa
    0x30080080: ('SQ', '1', "Referenced Measured Dose Reference Sequence", '', 'ReferencedMeasuredDoseReferenceSequence'),  # noqa
    0x30080082: ('IS', '1', "Referenced Measured Dose Reference Number", '', 'ReferencedMeasuredDoseReferenceNumber'),  # noqa
    0x30080090: ('SQ', '1', "Referenced Calculated Dose Reference Sequence", '', 'ReferencedCalculatedDoseReferenceSequence'),  # noqa
    0x30080092: ('IS', '1', "Referenced Calculated Dose Reference Number", '', 'ReferencedCalculatedDoseReferenceNumber'),  # noqa
    0x300800A0: ('SQ', '1', "Beam Limiting Device Leaf Pairs Sequence", '', 'BeamLimitingDeviceLeafPairsSequence'),  # noqa
    0x300800B0: ('SQ', '1', "Recorded Wedge Sequence", '', 'RecordedWedgeSequence'),  # noqa
    0x300800C0: ('SQ', '1', "Recorded Compensator Sequence", '', 'RecordedCompensatorSequence'),  # noqa
    0x300800D0: ('SQ', '1', "Recorded Block Sequence", '', 'RecordedBlockSequence'),  # noqa
    0x300800E0: ('SQ', '1', "Treatment Summary Measured Dose Reference Sequence", '', 'TreatmentSummaryMeasuredDoseReferenceSequence'),  # noqa
    0x300800F0: ('SQ', '1', "Recorded Snout Sequence", '', 'RecordedSnoutSequence'),  # noqa
    0x300800F2: ('SQ', '1', "Recorded Range Shifter Sequence", '', 'RecordedRangeShifterSequence'),  # noqa
    0x300800F4: ('SQ', '1', "Recorded Lateral Spreading Device Sequence", '', 'RecordedLateralSpreadingDeviceSequence'),  # noqa
    0x300800F6: ('SQ', '1', "Recorded Range Modulator Sequence", '', 'RecordedRangeModulatorSequence'),  # noqa
    0x30080100: ('SQ', '1', "Recorded Source Sequence", '', 'RecordedSourceSequence'),  # noqa
    0x30080105: ('LO', '1', "Source Serial Number", '', 'SourceSerialNumber'),  # noqa
    0x30080110: ('SQ', '1', "Treatment Session Application Setup Sequence", '', 'TreatmentSessionApplicationSetupSequence'),  # noqa
    0x30080116: ('CS', '1', "Application Setup Check", '', 'ApplicationSetupCheck'),  # noqa
    0x30080120: ('SQ', '1', "Recorded Brachy Accessory Device Sequence", '', 'RecordedBrachyAccessoryDeviceSequence'),  # noqa
    0x30080122: ('IS', '1', "Referenced Brachy Accessory Device Number", '', 'ReferencedBrachyAccessoryDeviceNumber'),  # noqa
    0x30080130: ('SQ', '1', "Recorded Channel Sequence", '', 'RecordedChannelSequence'),  # noqa
    0x30080132: ('DS', '1', "Specified Channel Total Time", '', 'SpecifiedChannelTotalTime'),  # noqa
    0x30080134: ('DS', '1', "Delivered Channel Total Time", '', 'DeliveredChannelTotalTime'),  # noqa
    0x30080136: ('IS', '1', "Specified Number of Pulses", '', 'SpecifiedNumberOfPulses'),  # noqa
    0x30080138: ('IS', '1', "Delivered Number of Pulses", '', 'DeliveredNumberOfPulses'),  # noqa
    0x3008013A: ('DS', '1', "Specified Pulse Repetition Interval", '', 'SpecifiedPulseRepetitionInterval'),  # noqa
    0x3008013C: ('DS', '1', "Delivered Pulse Repetition Interval", '', 'DeliveredPulseRepetitionInterval'),  # noqa
    0x30080140: ('SQ', '1', "Recorded Source Applicator Sequence", '', 'RecordedSourceApplicatorSequence'),  # noqa
    0x30080142: ('IS', '1', "Referenced Source Applicator Number", '', 'ReferencedSourceApplicatorNumber'),  # noqa
    0x30080150: ('SQ', '1', "Recorded Channel Shield Sequence", '', 'RecordedChannelShieldSequence'),  # noqa
    0x30080152: ('IS', '1', "Referenced Channel Shield Number", '', 'ReferencedChannelShieldNumber'),  # noqa
    0x30080160: ('SQ', '1', "Brachy Control Point Delivered Sequence", '', 'BrachyControlPointDeliveredSequence'),  # noqa
    0x30080162: ('DA', '1', "Safe Position Exit Date", '', 'SafePositionExitDate'),  # noqa
    0x30080164: ('TM', '1', "Safe Position Exit Time", '', 'SafePositionExitTime'),  # noqa
    0x30080166: ('DA', '1', "Safe Position Return Date", '', 'SafePositionReturnDate'),  # noqa
    0x30080168: ('TM', '1', "Safe Position Return Time", '', 'SafePositionReturnTime'),  # noqa
    0x30080171: ('SQ', '1', "Pulse Specific Brachy Control Point Delivered Sequence", '', 'PulseSpecificBrachyControlPointDeliveredSequence'),  # noqa
    0x30080172: ('US', '1', "Pulse Number", '', 'PulseNumber'),  # noqa
    0x30080173: ('SQ', '1', "Brachy Pulse Control Point Delivered Sequence", '', 'BrachyPulseControlPointDeliveredSequence'),  # noqa
    0x30080200: ('CS', '1', "Current Treatment Status", '', 'CurrentTreatmentStatus'),  # noqa
    0x30080202: ('ST', '1', "Treatment Status Comment", '', 'TreatmentStatusComment'),  # noqa
    0x30080220: ('SQ', '1', "Fraction Group Summary Sequence", '', 'FractionGroupSummarySequence'),  # noqa
    0x30080223: ('IS', '1', "Referenced Fraction Number", '', 'ReferencedFractionNumber'),  # noqa
    0x30080224: ('CS', '1', "Fraction Group Type", '', 'FractionGroupType'),  # noqa
    0x30080230: ('CS', '1', "Beam Stopper Position", '', 'BeamStopperPosition'),  # noqa
    0x30080240: ('SQ', '1', "Fraction Status Summary Sequence", '', 'FractionStatusSummarySequence'),  # noqa
    0x30080250: ('DA', '1', "Treatment Date", '', 'TreatmentDate'),  # noqa
    0x30080251: ('TM', '1', "Treatment Time", '', 'TreatmentTime'),  # noqa
    0x300A0002: ('SH', '1', "RT Plan Label", '', 'RTPlanLabel'),  # noqa
    0x300A0003: ('LO', '1', "RT Plan Name", '', 'RTPlanName'),  # noqa
    0x300A0004: ('ST', '1', "RT Plan Description", '', 'RTPlanDescription'),  # noqa
    0x300A0006: ('DA', '1', "RT Plan Date", '', 'RTPlanDate'),  # noqa
    0x300A0007: ('TM', '1', "RT Plan Time", '', 'RTPlanTime'),  # noqa
    0x300A0009: ('LO', '1-n', "Treatment Protocols", '', 'TreatmentProtocols'),  # noqa
    0x300A000A: ('CS', '1', "Plan Intent", '', 'PlanIntent'),  # noqa
    0x300A000B: ('LO', '1-n', "Treatment Sites", '', 'TreatmentSites'),  # noqa
    0x300A000C: ('CS', '1', "RT Plan Geometry", '', 'RTPlanGeometry'),  # noqa
    0x300A000E: ('ST', '1', "Prescription Description", '', 'PrescriptionDescription'),  # noqa
    0x300A0010: ('SQ', '1', "Dose Reference Sequence", '', 'DoseReferenceSequence'),  # noqa
    0x300A0012: ('IS', '1', "Dose Reference Number", '', 'DoseReferenceNumber'),  # noqa
    0x300A0013: ('UI', '1', "Dose Reference UID", '', 'DoseReferenceUID'),  # noqa
    0x300A0014: ('CS', '1', "Dose Reference Structure Type", '', 'DoseReferenceStructureType'),  # noqa
    0x300A0015: ('CS', '1', "Nominal Beam Energy Unit", '', 'NominalBeamEnergyUnit'),  # noqa
    0x300A0016: ('LO', '1', "Dose Reference Description", '', 'DoseReferenceDescription'),  # noqa
    0x300A0018: ('DS', '3', "Dose Reference Point Coordinates", '', 'DoseReferencePointCoordinates'),  # noqa
    0x300A001A: ('DS', '1', "Nominal Prior Dose", '', 'NominalPriorDose'),  # noqa
    0x300A0020: ('CS', '1', "Dose Reference Type", '', 'DoseReferenceType'),  # noqa
    0x300A0021: ('DS', '1', "Constraint Weight", '', 'ConstraintWeight'),  # noqa
    0x300A0022: ('DS', '1', "Delivery Warning Dose", '', 'DeliveryWarningDose'),  # noqa
    0x300A0023: ('DS', '1', "Delivery Maximum Dose", '', 'DeliveryMaximumDose'),  # noqa
    0x300A0025: ('DS', '1', "Target Minimum Dose", '', 'TargetMinimumDose'),  # noqa
    0x300A0026: ('DS', '1', "Target Prescription Dose", '', 'TargetPrescriptionDose'),  # noqa
    0x300A0027: ('DS', '1', "Target Maximum Dose", '', 'TargetMaximumDose'),  # noqa
    0x300A0028: ('DS', '1', "Target Underdose Volume Fraction", '', 'TargetUnderdoseVolumeFraction'),  # noqa
    0x300A002A: ('DS', '1', "Organ at Risk Full-volume Dose", '', 'OrganAtRiskFullVolumeDose'),  # noqa
    0x300A002B: ('DS', '1', "Organ at Risk Limit Dose", '', 'OrganAtRiskLimitDose'),  # noqa
    0x300A002C: ('DS', '1', "Organ at Risk Maximum Dose", '', 'OrganAtRiskMaximumDose'),  # noqa
    0x300A002D: ('DS', '1', "Organ at Risk Overdose Volume Fraction", '', 'OrganAtRiskOverdoseVolumeFraction'),  # noqa
    0x300A0040: ('SQ', '1', "Tolerance Table Sequence", '', 'ToleranceTableSequence'),  # noqa
    0x300A0042: ('IS', '1', "Tolerance Table Number", '', 'ToleranceTableNumber'),  # noqa
    0x300A0043: ('SH', '1', "Tolerance Table Label", '', 'ToleranceTableLabel'),  # noqa
    0x300A0044: ('DS', '1', "Gantry Angle Tolerance", '', 'GantryAngleTolerance'),  # noqa
    0x300A0046: ('DS', '1', "Beam Limiting Device Angle Tolerance", '', 'BeamLimitingDeviceAngleTolerance'),  # noqa
    0x300A0048: ('SQ', '1', "Beam Limiting Device Tolerance Sequence", '', 'BeamLimitingDeviceToleranceSequence'),  # noqa
    0x300A004A: ('DS', '1', "Beam Limiting Device Position Tolerance", '', 'BeamLimitingDevicePositionTolerance'),  # noqa
    0x300A004B: ('FL', '1', "Snout Position Tolerance", '', 'SnoutPositionTolerance'),  # noqa
    0x300A004C: ('DS', '1', "Patient Support Angle Tolerance", '', 'PatientSupportAngleTolerance'),  # noqa
    0x300A004E: ('DS', '1', "Table Top Eccentric Angle Tolerance", '', 'TableTopEccentricAngleTolerance'),  # noqa
    0x300A004F: ('FL', '1', "Table Top Pitch Angle Tolerance", '', 'TableTopPitchAngleTolerance'),  # noqa
    0x300A0050: ('FL', '1', "Table Top Roll Angle Tolerance", '', 'TableTopRollAngleTolerance'),  # noqa
    0x300A0051: ('DS', '1', "Table Top Vertical Position Tolerance", '', 'TableTopVerticalPositionTolerance'),  # noqa
    0x300A0052: ('DS', '1', "Table Top Longitudinal Position Tolerance", '', 'TableTopLongitudinalPositionTolerance'),  # noqa
    0x300A0053: ('DS', '1', "Table Top Lateral Position Tolerance", '', 'TableTopLateralPositionTolerance'),  # noqa
    0x300A0055: ('CS', '1', "RT Plan Relationship", '', 'RTPlanRelationship'),  # noqa
    0x300A0070: ('SQ', '1', "Fraction Group Sequence", '', 'FractionGroupSequence'),  # noqa
    0x300A0071: ('IS', '1', "Fraction Group Number", '', 'FractionGroupNumber'),  # noqa
    0x300A0072: ('LO', '1', "Fraction Group Description", '', 'FractionGroupDescription'),  # noqa
    0x300A0078: ('IS', '1', "Number of Fractions Planned", '', 'NumberOfFractionsPlanned'),  # noqa
    0x300A0079: ('IS', '1', "Number of Fraction Pattern Digits Per Day", '', 'NumberOfFractionPatternDigitsPerDay'),  # noqa
    0x300A007A: ('IS', '1', "Repeat Fraction Cycle Length", '', 'RepeatFractionCycleLength'),  # noqa
    0x300A007B: ('LT', '1', "Fraction Pattern", '', 'FractionPattern'),  # noqa
    0x300A0080: ('IS', '1', "Number of Beams", '', 'NumberOfBeams'),  # noqa
    0x300A0082: ('DS', '3', "Beam Dose Specification Point", '', 'BeamDoseSpecificationPoint'),  # noqa
    0x300A0083: ('UI', '1', "Referenced Dose Reference UID", '', 'ReferencedDoseReferenceUID'),  # noqa
    0x300A0084: ('DS', '1', "Beam Dose", '', 'BeamDose'),  # noqa
    0x300A0086: ('DS', '1', "Beam Meterset", '', 'BeamMeterset'),  # noqa
    0x300A0088: ('FL', '1', "Beam Dose Point Depth", '', 'BeamDosePointDepth'),  # noqa
    0x300A0089: ('FL', '1', "Beam Dose Point Equivalent Depth", '', 'BeamDosePointEquivalentDepth'),  # noqa
    0x300A008A: ('FL', '1', "Beam Dose Point SSD", '', 'BeamDosePointSSD'),  # noqa
    0x300A008B: ('CS', '1', "Beam Dose Meaning", '', 'BeamDoseMeaning'),  # noqa
    0x300A008C: ('SQ', '1', "Beam Dose Verification Control Point Sequence", '', 'BeamDoseVerificationControlPointSequence'),  # noqa
    0x300A008D: ('FL', '1', "Average Beam Dose Point Depth", 'Retired', 'AverageBeamDosePointDepth'),  # noqa
    0x300A008E: ('FL', '1', "Average Beam Dose Point Equivalent Depth", 'Retired', 'AverageBeamDosePointEquivalentDepth'),  # noqa
    0x300A008F: ('FL', '1', "Average Beam Dose Point SSD", 'Retired', 'AverageBeamDosePointSSD'),  # noqa
    0x300A0090: ('CS', '1', "Beam Dose Type", '', 'BeamDoseType'),  # noqa
    0x300A0091: ('DS', '1', "Alternate Beam Dose", '', 'AlternateBeamDose'),  # noqa
    0x300A0092: ('CS', '1', "Alternate Beam Dose Type", '', 'AlternateBeamDoseType'),  # noqa
    0x300A0093: ('CS', '1', "Depth Value Averaging Flag", '', 'DepthValueAveragingFlag'),  # noqa
    0x300A00A0: ('IS', '1', "Number of Brachy Application Setups", '', 'NumberOfBrachyApplicationSetups'),  # noqa
    0x300A00A2: ('DS', '3', "Brachy Application Setup Dose Specification Point", '', 'BrachyApplicationSetupDoseSpecificationPoint'),  # noqa
    0x300A00A4: ('DS', '1', "Brachy Application Setup Dose", '', 'BrachyApplicationSetupDose'),  # noqa
    0x300A00B0: ('SQ', '1', "Beam Sequence", '', 'BeamSequence'),  # noqa
    0x300A00B2: ('SH', '1', "Treatment Machine Name", '', 'TreatmentMachineName'),  # noqa
    0x300A00B3: ('CS', '1', "Primary Dosimeter Unit", '', 'PrimaryDosimeterUnit'),  # noqa
    0x300A00B4: ('DS', '1', "Source-Axis Distance", '', 'SourceAxisDistance'),  # noqa
    0x300A00B6: ('SQ', '1', "Beam Limiting Device Sequence", '', 'BeamLimitingDeviceSequence'),  # noqa
    0x300A00B8: ('CS', '1', "RT Beam Limiting Device Type", '', 'RTBeamLimitingDeviceType'),  # noqa
    0x300A00BA: ('DS', '1', "Source to Beam Limiting Device Distance", '', 'SourceToBeamLimitingDeviceDistance'),  # noqa
    0x300A00BB: ('FL', '1', "Isocenter to Beam Limiting Device Distance", '', 'IsocenterToBeamLimitingDeviceDistance'),  # noqa
    0x300A00BC: ('IS', '1', "Number of Leaf/Jaw Pairs", '', 'NumberOfLeafJawPairs'),  # noqa
    0x300A00BE: ('DS', '3-n', "Leaf Position Boundaries", '', 'LeafPositionBoundaries'),  # noqa
    0x300A00C0: ('IS', '1', "Beam Number", '', 'BeamNumber'),  # noqa
    0x300A00C2: ('LO', '1', "Beam Name", '', 'BeamName'),  # noqa
    0x300A00C3: ('ST', '1', "Beam Description", '', 'BeamDescription'),  # noqa
    0x300A00C4: ('CS', '1', "Beam Type", '', 'BeamType'),  # noqa
    0x300A00C5: ('FD', '1', "Beam Delivery Duration Limit", '', 'BeamDeliveryDurationLimit'),  # noqa
    0x300A00C6: ('CS', '1', "Radiation Type", '', 'RadiationType'),  # noqa
    0x300A00C7: ('CS', '1', "High-Dose Technique Type", '', 'HighDoseTechniqueType'),  # noqa
    0x300A00C8: ('IS', '1', "Reference Image Number", '', 'ReferenceImageNumber'),  # noqa
    0x300A00CA: ('SQ', '1', "Planned Verification Image Sequence", '', 'PlannedVerificationImageSequence'),  # noqa
    0x300A00CC: ('LO', '1-n', "Imaging Device-Specific Acquisition Parameters", '', 'ImagingDeviceSpecificAcquisitionParameters'),  # noqa
    0x300A00CE: ('CS', '1', "Treatment Delivery Type", '', 'TreatmentDeliveryType'),  # noqa
    0x300A00D0: ('IS', '1', "Number of Wedges", '', 'NumberOfWedges'),  # noqa
    0x300A00D1: ('SQ', '1', "Wedge Sequence", '', 'WedgeSequence'),  # noqa
    0x300A00D2: ('IS', '1', "Wedge Number", '', 'WedgeNumber'),  # noqa
    0x300A00D3: ('CS', '1', "Wedge Type", '', 'WedgeType'),  # noqa
    0x300A00D4: ('SH', '1', "Wedge ID", '', 'WedgeID'),  # noqa
    0x300A00D5: ('IS', '1', "Wedge Angle", '', 'WedgeAngle'),  # noqa
    0x300A00D6: ('DS', '1', "Wedge Factor", '', 'WedgeFactor'),  # noqa
    0x300A00D7: ('FL', '1', "Total Wedge Tray Water-Equivalent Thickness", '', 'TotalWedgeTrayWaterEquivalentThickness'),  # noqa
    0x300A00D8: ('DS', '1', "Wedge Orientation", '', 'WedgeOrientation'),  # noqa
    0x300A00D9: ('FL', '1', "Isocenter to Wedge Tray Distance", '', 'IsocenterToWedgeTrayDistance'),  # noqa
    0x300A00DA: ('DS', '1', "Source to Wedge Tray Distance", '', 'SourceToWedgeTrayDistance'),  # noqa
    0x300A00DB: ('FL', '1', "Wedge Thin Edge Position", '', 'WedgeThinEdgePosition'),  # noqa
    0x300A00DC: ('SH', '1', "Bolus ID", '', 'BolusID'),  # noqa
    0x300A00DD: ('ST', '1', "Bolus Description", '', 'BolusDescription'),  # noqa
    0x300A00DE: ('DS', '1', "Effective Wedge Angle", '', 'EffectiveWedgeAngle'),  # noqa
    0x300A00E0: ('IS', '1', "Number of Compensators", '', 'NumberOfCompensators'),  # noqa
    0x300A00E1: ('SH', '1', "Material ID", '', 'MaterialID'),  # noqa
    0x300A00E2: ('DS', '1', "Total Compensator Tray Factor", '', 'TotalCompensatorTrayFactor'),  # noqa
    0x300A00E3: ('SQ', '1', "Compensator Sequence", '', 'CompensatorSequence'),  # noqa
    0x300A00E4: ('IS', '1', "Compensator Number", '', 'CompensatorNumber'),  # noqa
    0x300A00E5: ('SH', '1', "Compensator ID", '', 'CompensatorID'),  # noqa
    0x300A00E6: ('DS', '1', "Source to Compensator Tray Distance", '', 'SourceToCompensatorTrayDistance'),  # noqa
    0x300A00E7: ('IS', '1', "Compensator Rows", '', 'CompensatorRows'),  # noqa
    0x300A00E8: ('IS', '1', "Compensator Columns", '', 'CompensatorColumns'),  # noqa
    0x300A00E9: ('DS', '2', "Compensator Pixel Spacing", '', 'CompensatorPixelSpacing'),  # noqa
    0x300A00EA: ('DS', '2', "Compensator Position", '', 'CompensatorPosition'),  # noqa
    0x300A00EB: ('DS', '1-n', "Compensator Transmission Data", '', 'CompensatorTransmissionData'),  # noqa
    0x300A00EC: ('DS', '1-n', "Compensator Thickness Data", '', 'CompensatorThicknessData'),  # noqa
    0x300A00ED: ('IS', '1', "Number of Boli", '', 'NumberOfBoli'),  # noqa
    0x300A00EE: ('CS', '1', "Compensator Type", '', 'CompensatorType'),  # noqa
    0x300A00EF: ('SH', '1', "Compensator Tray ID", '', 'CompensatorTrayID'),  # noqa
    0x300A00F0: ('IS', '1', "Number of Blocks", '', 'NumberOfBlocks'),  # noqa
    0x300A00F2: ('DS', '1', "Total Block Tray Factor", '', 'TotalBlockTrayFactor'),  # noqa
    0x300A00F3: ('FL', '1', "Total Block Tray Water-Equivalent Thickness", '', 'TotalBlockTrayWaterEquivalentThickness'),  # noqa
    0x300A00F4: ('SQ', '1', "Block Sequence", '', 'BlockSequence'),  # noqa
    0x300A00F5: ('SH', '1', "Block Tray ID", '', 'BlockTrayID'),  # noqa
    0x300A00F6: ('DS', '1', "Source to Block Tray Distance", '', 'SourceToBlockTrayDistance'),  # noqa
    0x300A00F7: ('FL', '1', "Isocenter to Block Tray Distance", '', 'IsocenterToBlockTrayDistance'),  # noqa
    0x300A00F8: ('CS', '1', "Block Type", '', 'BlockType'),  # noqa
    0x300A00F9: ('LO', '1', "Accessory Code", '', 'AccessoryCode'),  # noqa
    0x300A00FA: ('CS', '1', "Block Divergence", '', 'BlockDivergence'),  # noqa
    0x300A00FB: ('CS', '1', "Block Mounting Position", '', 'BlockMountingPosition'),  # noqa
    0x300A00FC: ('IS', '1', "Block Number", '', 'BlockNumber'),  # noqa
    0x300A00FE: ('LO', '1', "Block Name", '', 'BlockName'),  # noqa
    0x300A0100: ('DS', '1', "Block Thickness", '', 'BlockThickness'),  # noqa
    0x300A0102: ('DS', '1', "Block Transmission", '', 'BlockTransmission'),  # noqa
    0x300A0104: ('IS', '1', "Block Number of Points", '', 'BlockNumberOfPoints'),  # noqa
    0x300A0106: ('DS', '2-2n', "Block Data", '', 'BlockData'),  # noqa
    0x300A0107: ('SQ', '1', "Applicator Sequence", '', 'ApplicatorSequence'),  # noqa
    0x300A0108: ('SH', '1', "Applicator ID", '', 'ApplicatorID'),  # noqa
    0x300A0109: ('CS', '1', "Applicator Type", '', 'ApplicatorType'),  # noqa
    0x300A010A: ('LO', '1', "Applicator Description", '', 'ApplicatorDescription'),  # noqa
    0x300A010C: ('DS', '1', "Cumulative Dose Reference Coefficient", '', 'CumulativeDoseReferenceCoefficient'),  # noqa
    0x300A010E: ('DS', '1', "Final Cumulative Meterset Weight", '', 'FinalCumulativeMetersetWeight'),  # noqa
    0x300A0110: ('IS', '1', "Number of Control Points", '', 'NumberOfControlPoints'),  # noqa
    0x300A0111: ('SQ', '1', "Control Point Sequence", '', 'ControlPointSequence'),  # noqa
    0x300A0112: ('IS', '1', "Control Point Index", '', 'ControlPointIndex'),  # noqa
    0x300A0114: ('DS', '1', "Nominal Beam Energy", '', 'NominalBeamEnergy'),  # noqa
    0x300A0115: ('DS', '1', "Dose Rate Set", '', 'DoseRateSet'),  # noqa
    0x300A0116: ('SQ', '1', "Wedge Position Sequence", '', 'WedgePositionSequence'),  # noqa
    0x300A0118: ('CS', '1', "Wedge Position", '', 'WedgePosition'),  # noqa
    0x300A011A: ('SQ', '1', "Beam Limiting Device Position Sequence", '', 'BeamLimitingDevicePositionSequence'),  # noqa
    0x300A011C: ('DS', '2-2n', "Leaf/Jaw Positions", '', 'LeafJawPositions'),  # noqa
    0x300A011E: ('DS', '1', "Gantry Angle", '', 'GantryAngle'),  # noqa
    0x300A011F: ('CS', '1', "Gantry Rotation Direction", '', 'GantryRotationDirection'),  # noqa
    0x300A0120: ('DS', '1', "Beam Limiting Device Angle", '', 'BeamLimitingDeviceAngle'),  # noqa
    0x300A0121: ('CS', '1', "Beam Limiting Device Rotation Direction", '', 'BeamLimitingDeviceRotationDirection'),  # noqa
    0x300A0122: ('DS', '1', "Patient Support Angle", '', 'PatientSupportAngle'),  # noqa
    0x300A0123: ('CS', '1', "Patient Support Rotation Direction", '', 'PatientSupportRotationDirection'),  # noqa
    0x300A0124: ('DS', '1', "Table Top Eccentric Axis Distance", '', 'TableTopEccentricAxisDistance'),  # noqa
    0x300A0125: ('DS', '1', "Table Top Eccentric Angle", '', 'TableTopEccentricAngle'),  # noqa
    0x300A0126: ('CS', '1', "Table Top Eccentric Rotation Direction", '', 'TableTopEccentricRotationDirection'),  # noqa
    0x300A0128: ('DS', '1', "Table Top Vertical Position", '', 'TableTopVerticalPosition'),  # noqa
    0x300A0129: ('DS', '1', "Table Top Longitudinal Position", '', 'TableTopLongitudinalPosition'),  # noqa
    0x300A012A: ('DS', '1', "Table Top Lateral Position", '', 'TableTopLateralPosition'),  # noqa
    0x300A012C: ('DS', '3', "Isocenter Position", '', 'IsocenterPosition'),  # noqa
    0x300A012E: ('DS', '3', "Surface Entry Point", '', 'SurfaceEntryPoint'),  # noqa
    0x300A0130: ('DS', '1', "Source to Surface Distance", '', 'SourceToSurfaceDistance'),  # noqa
    0x300A0131: ('FL', '1', "Average Beam Dose Point Source to External Contour Distance", '', 'AverageBeamDosePointSourceToExternalContourDistance'),  # noqa
    0x300A0132: ('FL', '1', "Source to External Contour Distance", '', 'SourceToExternalContourDistance'),  # noqa
    0x300A0133: ('FL', '3', "External Contour Entry Point", '', 'ExternalContourEntryPoint'),  # noqa
    0x300A0134: ('DS', '1', "Cumulative Meterset Weight", '', 'CumulativeMetersetWeight'),  # noqa
    0x300A0140: ('FL', '1', "Table Top Pitch Angle", '', 'TableTopPitchAngle'),  # noqa
    0x300A0142: ('CS', '1', "Table Top Pitch Rotation Direction", '', 'TableTopPitchRotationDirection'),  # noqa
    0x300A0144: ('FL', '1', "Table Top Roll Angle", '', 'TableTopRollAngle'),  # noqa
    0x300A0146: ('CS', '1', "Table Top Roll Rotation Direction", '', 'TableTopRollRotationDirection'),  # noqa
    0x300A0148: ('FL', '1', "Head Fixation Angle", '', 'HeadFixationAngle'),  # noqa
    0x300A014A: ('FL', '1', "Gantry Pitch Angle", '', 'GantryPitchAngle'),  # noqa
    0x300A014C: ('CS', '1', "Gantry Pitch Rotation Direction", '', 'GantryPitchRotationDirection'),  # noqa
    0x300A014E: ('FL', '1', "Gantry Pitch Angle Tolerance", '', 'GantryPitchAngleTolerance'),  # noqa
    0x300A0150: ('CS', '1', "Fixation Eye", '', 'FixationEye'),  # noqa
    0x300A0151: ('DS', '1', "Chair Head Frame Position", '', 'ChairHeadFramePosition'),  # noqa
    0x300A0152: ('DS', '1', "Head Fixation Angle Tolerance", '', 'HeadFixationAngleTolerance'),  # noqa
    0x300A0153: ('DS', '1', "Chair Head Frame Position Tolerance", '', 'ChairHeadFramePositionTolerance'),  # noqa
    0x300A0154: ('DS', '1', "Fixation Light Azimuthal Angle Tolerance", '', 'FixationLightAzimuthalAngleTolerance'),  # noqa
    0x300A0155: ('DS', '1', "Fixation Light Polar Angle Tolerance", '', 'FixationLightPolarAngleTolerance'),  # noqa
    0x300A0180: ('SQ', '1', "Patient Setup Sequence", '', 'PatientSetupSequence'),  # noqa
    0x300A0182: ('IS', '1', "Patient Setup Number", '', 'PatientSetupNumber'),  # noqa
    0x300A0183: ('LO', '1', "Patient Setup Label", '', 'PatientSetupLabel'),  # noqa
    0x300A0184: ('LO', '1', "Patient Additional Position", '', 'PatientAdditionalPosition'),  # noqa
    0x300A0190: ('SQ', '1', "Fixation Device Sequence", '', 'FixationDeviceSequence'),  # noqa
    0x300A0192: ('CS', '1', "Fixation Device Type", '', 'FixationDeviceType'),  # noqa
    0x300A0194: ('SH', '1', "Fixation Device Label", '', 'FixationDeviceLabel'),  # noqa
    0x300A0196: ('ST', '1', "Fixation Device Description", '', 'FixationDeviceDescription'),  # noqa
    0x300A0198: ('SH', '1', "Fixation Device Position", '', 'FixationDevicePosition'),  # noqa
    0x300A0199: ('FL', '1', "Fixation Device Pitch Angle", '', 'FixationDevicePitchAngle'),  # noqa
    0x300A019A: ('FL', '1', "Fixation Device Roll Angle", '', 'FixationDeviceRollAngle'),  # noqa
    0x300A01A0: ('SQ', '1', "Shielding Device Sequence", '', 'ShieldingDeviceSequence'),  # noqa
    0x300A01A2: ('CS', '1', "Shielding Device Type", '', 'ShieldingDeviceType'),  # noqa
    0x300A01A4: ('SH', '1', "Shielding Device Label", '', 'ShieldingDeviceLabel'),  # noqa
    0x300A01A6: ('ST', '1', "Shielding Device Description", '', 'ShieldingDeviceDescription'),  # noqa
    0x300A01A8: ('SH', '1', "Shielding Device Position", '', 'ShieldingDevicePosition'),  # noqa
    0x300A01B0: ('CS', '1', "Setup Technique", '', 'SetupTechnique'),  # noqa
    0x300A01B2: ('ST', '1', "Setup Technique Description", '', 'SetupTechniqueDescription'),  # noqa
    0x300A01B4: ('SQ', '1', "Setup Device Sequence", '', 'SetupDeviceSequence'),  # noqa
    0x300A01B6: ('CS', '1', "Setup Device Type", '', 'SetupDeviceType'),  # noqa
    0x300A01B8: ('SH', '1', "Setup Device Label", '', 'SetupDeviceLabel'),  # noqa
    0x300A01BA: ('ST', '1', "Setup Device Description", '', 'SetupDeviceDescription'),  # noqa
    0x300A01BC: ('DS', '1', "Setup Device Parameter", '', 'SetupDeviceParameter'),  # noqa
    0x300A01D0: ('ST', '1', "Setup Reference Description", '', 'SetupReferenceDescription'),  # noqa
    0x300A01D2: ('DS', '1', "Table Top Vertical Setup Displacement", '', 'TableTopVerticalSetupDisplacement'),  # noqa
    0x300A01D4: ('DS', '1', "Table Top Longitudinal Setup Displacement", '', 'TableTopLongitudinalSetupDisplacement'),  # noqa
    0x300A01D6: ('DS', '1', "Table Top Lateral Setup Displacement", '', 'TableTopLateralSetupDisplacement'),  # noqa
    0x300A0200: ('CS', '1', "Brachy Treatment Technique", '', 'BrachyTreatmentTechnique'),  # noqa
    0x300A0202: ('CS', '1', "Brachy Treatment Type", '', 'BrachyTreatmentType'),  # noqa
    0x300A0206: ('SQ', '1', "Treatment Machine Sequence", '', 'TreatmentMachineSequence'),  # noqa
    0x300A0210: ('SQ', '1', "Source Sequence", '', 'SourceSequence'),  # noqa
    0x300A0212: ('IS', '1', "Source Number", '', 'SourceNumber'),  # noqa
    0x300A0214: ('CS', '1', "Source Type", '', 'SourceType'),  # noqa
    0x300A0216: ('LO', '1', "Source Manufacturer", '', 'SourceManufacturer'),  # noqa
    0x300A0218: ('DS', '1', "Active Source Diameter", '', 'ActiveSourceDiameter'),  # noqa
    0x300A021A: ('DS', '1', "Active Source Length", '', 'ActiveSourceLength'),  # noqa
    0x300A021B: ('SH', '1', "Source Model ID", '', 'SourceModelID'),  # noqa
    0x300A021C: ('LO', '1', "Source Description", '', 'SourceDescription'),  # noqa
    0x300A0222: ('DS', '1', "Source Encapsulation Nominal Thickness", '', 'SourceEncapsulationNominalThickness'),  # noqa
    0x300A0224: ('DS', '1', "Source Encapsulation Nominal Transmission", '', 'SourceEncapsulationNominalTransmission'),  # noqa
    0x300A0226: ('LO', '1', "Source Isotope Name", '', 'SourceIsotopeName'),  # noqa
    0x300A0228: ('DS', '1', "Source Isotope Half Life", '', 'SourceIsotopeHalfLife'),  # noqa
    0x300A0229: ('CS', '1', "Source Strength Units", '', 'SourceStrengthUnits'),  # noqa
    0x300A022A: ('DS', '1', "Reference Air Kerma Rate", '', 'ReferenceAirKermaRate'),  # noqa
    0x300A022B: ('DS', '1', "Source Strength", '', 'SourceStrength'),  # noqa
    0x300A022C: ('DA', '1', "Source Strength Reference Date", '', 'SourceStrengthReferenceDate'),  # noqa
    0x300A022E: ('TM', '1', "Source Strength Reference Time", '', 'SourceStrengthReferenceTime'),  # noqa
    0x300A0230: ('SQ', '1', "Application Setup Sequence", '', 'ApplicationSetupSequence'),  # noqa
    0x300A0232: ('CS', '1', "Application Setup Type", '', 'ApplicationSetupType'),  # noqa
    0x300A0234: ('IS', '1', "Application Setup Number", '', 'ApplicationSetupNumber'),  # noqa
    0x300A0236: ('LO', '1', "Application Setup Name", '', 'ApplicationSetupName'),  # noqa
    0x300A0238: ('LO', '1', "Application Setup Manufacturer", '', 'ApplicationSetupManufacturer'),  # noqa
    0x300A0240: ('IS', '1', "Template Number", '', 'TemplateNumber'),  # noqa
    0x300A0242: ('SH', '1', "Template Type", '', 'TemplateType'),  # noqa
    0x300A0244: ('LO', '1', "Template Name", '', 'TemplateName'),  # noqa
    0x300A0250: ('DS', '1', "Total Reference Air Kerma", '', 'TotalReferenceAirKerma'),  # noqa
    0x300A0260: ('SQ', '1', "Brachy Accessory Device Sequence", '', 'BrachyAccessoryDeviceSequence'),  # noqa
    0x300A0262: ('IS', '1', "Brachy Accessory Device Number", '', 'BrachyAccessoryDeviceNumber'),  # noqa
    0x300A0263: ('SH', '1', "Brachy Accessory Device ID", '', 'BrachyAccessoryDeviceID'),  # noqa
    0x300A0264: ('CS', '1', "Brachy Accessory Device Type", '', 'BrachyAccessoryDeviceType'),  # noqa
    0x300A0266: ('LO', '1', "Brachy Accessory Device Name", '', 'BrachyAccessoryDeviceName'),  # noqa
    0x300A026A: ('DS', '1', "Brachy Accessory Device Nominal Thickness", '', 'BrachyAccessoryDeviceNominalThickness'),  # noqa
    0x300A026C: ('DS', '1', "Brachy Accessory Device Nominal Transmission", '', 'BrachyAccessoryDeviceNominalTransmission'),  # noqa
    0x300A0271: ('DS', '1', "Channel Effective Length", '', 'ChannelEffectiveLength'),  # noqa
    0x300A0272: ('DS', '1', "Channel Inner Length", '', 'ChannelInnerLength'),  # noqa
    0x300A0273: ('SH', '1', "Afterloader Channel ID", '', 'AfterloaderChannelID'),  # noqa
    0x300A0274: ('DS', '1', "Source Applicator Tip Length", '', 'SourceApplicatorTipLength'),  # noqa
    0x300A0280: ('SQ', '1', "Channel Sequence", '', 'ChannelSequence'),  # noqa
    0x300A0282: ('IS', '1', "Channel Number", '', 'ChannelNumber'),  # noqa
    0x300A0284: ('DS', '1', "Channel Length", '', 'ChannelLength'),  # noqa
    0x300A0286: ('DS', '1', "Channel Total Time", '', 'ChannelTotalTime'),  # noqa
    0x300A0288: ('CS', '1', "Source Movement Type", '', 'SourceMovementType'),  # noqa
    0x300A028A: ('IS', '1', "Number of Pulses", '', 'NumberOfPulses'),  # noqa
    0x300A028C: ('DS', '1', "Pulse Repetition Interval", '', 'PulseRepetitionInterval'),  # noqa
    0x300A0290: ('IS', '1', "Source Applicator Number", '', 'SourceApplicatorNumber'),  # noqa
    0x300A0291: ('SH', '1', "Source Applicator ID", '', 'SourceApplicatorID'),  # noqa
    0x300A0292: ('CS', '1', "Source Applicator Type", '', 'SourceApplicatorType'),  # noqa
    0x300A0294: ('LO', '1', "Source Applicator Name", '', 'SourceApplicatorName'),  # noqa
    0x300A0296: ('DS', '1', "Source Applicator Length", '', 'SourceApplicatorLength'),  # noqa
    0x300A0298: ('LO', '1', "Source Applicator Manufacturer", '', 'SourceApplicatorManufacturer'),  # noqa
    0x300A029C: ('DS', '1', "Source Applicator Wall Nominal Thickness", '', 'SourceApplicatorWallNominalThickness'),  # noqa
    0x300A029E: ('DS', '1', "Source Applicator Wall Nominal Transmission", '', 'SourceApplicatorWallNominalTransmission'),  # noqa
    0x300A02A0: ('DS', '1', "Source Applicator Step Size", '', 'SourceApplicatorStepSize'),  # noqa
    0x300A02A2: ('IS', '1', "Transfer Tube Number", '', 'TransferTubeNumber'),  # noqa
    0x300A02A4: ('DS', '1', "Transfer Tube Length", '', 'TransferTubeLength'),  # noqa
    0x300A02B0: ('SQ', '1', "Channel Shield Sequence", '', 'ChannelShieldSequence'),  # noqa
    0x300A02B2: ('IS', '1', "Channel Shield Number", '', 'ChannelShieldNumber'),  # noqa
    0x300A02B3: ('SH', '1', "Channel Shield ID", '', 'ChannelShieldID'),  # noqa
    0x300A02B4: ('LO', '1', "Channel Shield Name", '', 'ChannelShieldName'),  # noqa
    0x300A02B8: ('DS', '1', "Channel Shield Nominal Thickness", '', 'ChannelShieldNominalThickness'),  # noqa
    0x300A02BA: ('DS', '1', "Channel Shield Nominal Transmission", '', 'ChannelShieldNominalTransmission'),  # noqa
    0x300A02C8: ('DS', '1', "Final Cumulative Time Weight", '', 'FinalCumulativeTimeWeight'),  # noqa
    0x300A02D0: ('SQ', '1', "Brachy Control Point Sequence", '', 'BrachyControlPointSequence'),  # noqa
    0x300A02D2: ('DS', '1', "Control Point Relative Position", '', 'ControlPointRelativePosition'),  # noqa
    0x300A02D4: ('DS', '3', "Control Point 3D Position", '', 'ControlPoint3DPosition'),  # noqa
    0x300A02D6: ('DS', '1', "Cumulative Time Weight", '', 'CumulativeTimeWeight'),  # noqa
    0x300A02E0: ('CS', '1', "Compensator Divergence", '', 'CompensatorDivergence'),  # noqa
    0x300A02E1: ('CS', '1', "Compensator Mounting Position", '', 'CompensatorMountingPosition'),  # noqa
    0x300A02E2: ('DS', '1-n', "Source to Compensator Distance", '', 'SourceToCompensatorDistance'),  # noqa
    0x300A02E3: ('FL', '1', "Total Compensator Tray Water-Equivalent Thickness", '', 'TotalCompensatorTrayWaterEquivalentThickness'),  # noqa
    0x300A02E4: ('FL', '1', "Isocenter to Compensator Tray Distance", '', 'IsocenterToCompensatorTrayDistance'),  # noqa
    0x300A02E5: ('FL', '1', "Compensator Column Offset", '', 'CompensatorColumnOffset'),  # noqa
    0x300A02E6: ('FL', '1-n', "Isocenter to Compensator Distances", '', 'IsocenterToCompensatorDistances'),  # noqa
    0x300A02E7: ('FL', '1', "Compensator Relative Stopping Power Ratio", '', 'CompensatorRelativeStoppingPowerRatio'),  # noqa
    0x300A02E8: ('FL', '1', "Compensator Milling Tool Diameter", '', 'CompensatorMillingToolDiameter'),  # noqa
    0x300A02EA: ('SQ', '1', "Ion Range Compensator Sequence", '', 'IonRangeCompensatorSequence'),  # noqa
    0x300A02EB: ('LT', '1', "Compensator Description", '', 'CompensatorDescription'),  # noqa
    0x300A0302: ('IS', '1', "Radiation Mass Number", '', 'RadiationMassNumber'),  # noqa
    0x300A0304: ('IS', '1', "Radiation Atomic Number", '', 'RadiationAtomicNumber'),  # noqa
    0x300A0306: ('SS', '1', "Radiation Charge State", '', 'RadiationChargeState'),  # noqa
    0x300A0308: ('CS', '1', "Scan Mode", '', 'ScanMode'),  # noqa
    0x300A0309: ('CS', '1', "Modulated Scan Mode Type", '', 'ModulatedScanModeType'),  # noqa
    0x300A030A: ('FL', '2', "Virtual Source-Axis Distances", '', 'VirtualSourceAxisDistances'),  # noqa
    0x300A030C: ('SQ', '1', "Snout Sequence", '', 'SnoutSequence'),  # noqa
    0x300A030D: ('FL', '1', "Snout Position", '', 'SnoutPosition'),  # noqa
    0x300A030F: ('SH', '1', "Snout ID", '', 'SnoutID'),  # noqa
    0x300A0312: ('IS', '1', "Number of Range Shifters", '', 'NumberOfRangeShifters'),  # noqa
    0x300A0314: ('SQ', '1', "Range Shifter Sequence", '', 'RangeShifterSequence'),  # noqa
    0x300A0316: ('IS', '1', "Range Shifter Number", '', 'RangeShifterNumber'),  # noqa
    0x300A0318: ('SH', '1', "Range Shifter ID", '', 'RangeShifterID'),  # noqa
    0x300A0320: ('CS', '1', "Range Shifter Type", '', 'RangeShifterType'),  # noqa
    0x300A0322: ('LO', '1', "Range Shifter Description", '', 'RangeShifterDescription'),  # noqa
    0x300A0330: ('IS', '1', "Number of Lateral Spreading Devices", '', 'NumberOfLateralSpreadingDevices'),  # noqa
    0x300A0332: ('SQ', '1', "Lateral Spreading Device Sequence", '', 'LateralSpreadingDeviceSequence'),  # noqa
    0x300A0334: ('IS', '1', "Lateral Spreading Device Number", '', 'LateralSpreadingDeviceNumber'),  # noqa
    0x300A0336: ('SH', '1', "Lateral Spreading Device ID", '', 'LateralSpreadingDeviceID'),  # noqa
    0x300A0338: ('CS', '1', "Lateral Spreading Device Type", '', 'LateralSpreadingDeviceType'),  # noqa
    0x300A033A: ('LO', '1', "Lateral Spreading Device Description", '', 'LateralSpreadingDeviceDescription'),  # noqa
    0x300A033C: ('FL', '1', "Lateral Spreading Device Water Equivalent Thickness", '', 'LateralSpreadingDeviceWaterEquivalentThickness'),  # noqa
    0x300A0340: ('IS', '1', "Number of Range Modulators", '', 'NumberOfRangeModulators'),  # noqa
    0x300A0342: ('SQ', '1', "Range Modulator Sequence", '', 'RangeModulatorSequence'),  # noqa
    0x300A0344: ('IS', '1', "Range Modulator Number", '', 'RangeModulatorNumber'),  # noqa
    0x300A0346: ('SH', '1', "Range Modulator ID", '', 'RangeModulatorID'),  # noqa
    0x300A0348: ('CS', '1', "Range Modulator Type", '', 'RangeModulatorType'),  # noqa
    0x300A034A: ('LO', '1', "Range Modulator Description", '', 'RangeModulatorDescription'),  # noqa
    0x300A034C: ('SH', '1', "Beam Current Modulation ID", '', 'BeamCurrentModulationID'),  # noqa
    0x300A0350: ('CS', '1', "Patient Support Type", '', 'PatientSupportType'),  # noqa
    0x300A0352: ('SH', '1', "Patient Support ID", '', 'PatientSupportID'),  # noqa
    0x300A0354: ('LO', '1', "Patient Support Accessory Code", '', 'PatientSupportAccessoryCode'),  # noqa
    0x300A0355: ('LO', '1', "Tray Accessory Code", '', 'TrayAccessoryCode'),  # noqa
    0x300A0356: ('FL', '1', "Fixation Light Azimuthal Angle", '', 'FixationLightAzimuthalAngle'),  # noqa
    0x300A0358: ('FL', '1', "Fixation Light Polar Angle", '', 'FixationLightPolarAngle'),  # noqa
    0x300A035A: ('FL', '1', "Meterset Rate", '', 'MetersetRate'),  # noqa
    0x300A0360: ('SQ', '1', "Range Shifter Settings Sequence", '', 'RangeShifterSettingsSequence'),  # noqa
    0x300A0362: ('LO', '1', "Range Shifter Setting", '', 'RangeShifterSetting'),  # noqa
    0x300A0364: ('FL', '1', "Isocenter to Range Shifter Distance", '', 'IsocenterToRangeShifterDistance'),  # noqa
    0x300A0366: ('FL', '1', "Range Shifter Water Equivalent Thickness", '', 'RangeShifterWaterEquivalentThickness'),  # noqa
    0x300A0370: ('SQ', '1', "Lateral Spreading Device Settings Sequence", '', 'LateralSpreadingDeviceSettingsSequence'),  # noqa
    0x300A0372: ('LO', '1', "Lateral Spreading Device Setting", '', 'LateralSpreadingDeviceSetting'),  # noqa
    0x300A0374: ('FL', '1', "Isocenter to Lateral Spreading Device Distance", '', 'IsocenterToLateralSpreadingDeviceDistance'),  # noqa
    0x300A0380: ('SQ', '1', "Range Modulator Settings Sequence", '', 'RangeModulatorSettingsSequence'),  # noqa
    0x300A0382: ('FL', '1', "Range Modulator Gating Start Value", '', 'RangeModulatorGatingStartValue'),  # noqa
    0x300A0384: ('FL', '1', "Range Modulator Gating Stop Value", '', 'RangeModulatorGatingStopValue'),  # noqa
    0x300A0386: ('FL', '1', "Range Modulator Gating Start Water Equivalent Thickness", '', 'RangeModulatorGatingStartWaterEquivalentThickness'),  # noqa
    0x300A0388: ('FL', '1', "Range Modulator Gating Stop Water Equivalent Thickness", '', 'RangeModulatorGatingStopWaterEquivalentThickness'),  # noqa
    0x300A038A: ('FL', '1', "Isocenter to Range Modulator Distance", '', 'IsocenterToRangeModulatorDistance'),  # noqa
    0x300A038F: ('FL', '1-n', "Scan Spot Time Offset", '', 'ScanSpotTimeOffset'),  # noqa
    0x300A0390: ('SH', '1', "Scan Spot Tune ID", '', 'ScanSpotTuneID'),  # noqa
    0x300A0391: ('IS', '1-n', "Scan Spot Prescribed Indices", '', 'ScanSpotPrescribedIndices'),  # noqa
    0x300A0392: ('IS', '1', "Number of Scan Spot Positions", '', 'NumberOfScanSpotPositions'),  # noqa
    0x300A0393: ('CS', '1', "Scan Spot Reordered", '', 'ScanSpotReordered'),  # noqa
    0x300A0394: ('FL', '1-n', "Scan Spot Position Map", '', 'ScanSpotPositionMap'),  # noqa
    0x300A0395: ('CS', '1', "Scan Spot Reordering Allowed", '', 'ScanSpotReorderingAllowed'),  # noqa
    0x300A0396: ('FL', '1-n', "Scan Spot Meterset Weights", '', 'ScanSpotMetersetWeights'),  # noqa
    0x300A0398: ('FL', '2', "Scanning Spot Size", '', 'ScanningSpotSize'),  # noqa
    0x300A039A: ('IS', '1', "Number of Paintings", '', 'NumberOfPaintings'),  # noqa
    0x300A03A0: ('SQ', '1', "Ion Tolerance Table Sequence", '', 'IonToleranceTableSequence'),  # noqa
    0x300A03A2: ('SQ', '1', "Ion Beam Sequence", '', 'IonBeamSequence'),  # noqa
    0x300A03A4: ('SQ', '1', "Ion Beam Limiting Device Sequence", '', 'IonBeamLimitingDeviceSequence'),  # noqa
    0x300A03A6: ('SQ', '1', "Ion Block Sequence", '', 'IonBlockSequence'),  # noqa
    0x300A03A8: ('SQ', '1', "Ion Control Point Sequence", '', 'IonControlPointSequence'),  # noqa
    0x300A03AA: ('SQ', '1', "Ion Wedge Sequence", '', 'IonWedgeSequence'),  # noqa
    0x300A03AC: ('SQ', '1', "Ion Wedge Position Sequence", '', 'IonWedgePositionSequence'),  # noqa
    0x300A0401: ('SQ', '1', "Referenced Setup Image Sequence", '', 'ReferencedSetupImageSequence'),  # noqa
    0x300A0402: ('ST', '1', "Setup Image Comment", '', 'SetupImageComment'),  # noqa
    0x300A0410: ('SQ', '1', "Motion Synchronization Sequence", '', 'MotionSynchronizationSequence'),  # noqa
    0x300A0412: ('FL', '3', "Control Point Orientation", '', 'ControlPointOrientation'),  # noqa
    0x300A0420: ('SQ', '1', "General Accessory Sequence", '', 'GeneralAccessorySequence'),  # noqa
    0x300A0421: ('SH', '1', "General Accessory ID", '', 'GeneralAccessoryID'),  # noqa
    0x300A0422: ('ST', '1', "General Accessory Description", '', 'GeneralAccessoryDescription'),  # noqa
    0x300A0423: ('CS', '1', "General Accessory Type", '', 'GeneralAccessoryType'),  # noqa
    0x300A0424: ('IS', '1', "General Accessory Number", '', 'GeneralAccessoryNumber'),  # noqa
    0x300A0425: ('FL', '1', "Source to General Accessory Distance", '', 'SourceToGeneralAccessoryDistance'),  # noqa
    0x300A0431: ('SQ', '1', "Applicator Geometry Sequence", '', 'ApplicatorGeometrySequence'),  # noqa
    0x300A0432: ('CS', '1', "Applicator Aperture Shape", '', 'ApplicatorApertureShape'),  # noqa
    0x300A0433: ('FL', '1', "Applicator Opening", '', 'ApplicatorOpening'),  # noqa
    0x300A0434: ('FL', '1', "Applicator Opening X", '', 'ApplicatorOpeningX'),  # noqa
    0x300A0435: ('FL', '1', "Applicator Opening Y", '', 'ApplicatorOpeningY'),  # noqa
    0x300A0436: ('FL', '1', "Source to Applicator Mounting Position Distance", '', 'SourceToApplicatorMountingPositionDistance'),  # noqa
    0x300A0440: ('IS', '1', "Number of Block Slab Items", '', 'NumberOfBlockSlabItems'),  # noqa
    0x300A0441: ('SQ', '1', "Block Slab Sequence", '', 'BlockSlabSequence'),  # noqa
    0x300A0442: ('DS', '1', "Block Slab Thickness", '', 'BlockSlabThickness'),  # noqa
    0x300A0443: ('US', '1', "Block Slab Number", '', 'BlockSlabNumber'),  # noqa
    0x300A0450: ('SQ', '1', "Device Motion Control Sequence", '', 'DeviceMotionControlSequence'),  # noqa
    0x300A0451: ('CS', '1', "Device Motion Execution Mode", '', 'DeviceMotionExecutionMode'),  # noqa
    0x300A0452: ('CS', '1', "Device Motion Observation Mode", '', 'DeviceMotionObservationMode'),  # noqa
    0x300A0453: ('SQ', '1', "Device Motion Parameter Code Sequence", '', 'DeviceMotionParameterCodeSequence'),  # noqa
    0x300A0501: ('FL', '1', "Distal Depth Fraction", '', 'DistalDepthFraction'),  # noqa
    0x300A0502: ('FL', '1', "Distal Depth", '', 'DistalDepth'),  # noqa
    0x300A0503: ('FL', '2', "Nominal Range Modulation Fractions", '', 'NominalRangeModulationFractions'),  # noqa
    0x300A0504: ('FL', '2', "Nominal Range Modulated Region Depths", '', 'NominalRangeModulatedRegionDepths'),  # noqa
    0x300A0505: ('SQ', '1', "Depth Dose Parameters Sequence", '', 'DepthDoseParametersSequence'),  # noqa
    0x300A0506: ('SQ', '1', "Delivered Depth Dose Parameters Sequence", '', 'DeliveredDepthDoseParametersSequence'),  # noqa
    0x300A0507: ('FL', '1', "Delivered Distal Depth Fraction", '', 'DeliveredDistalDepthFraction'),  # noqa
    0x300A0508: ('FL', '1', "Delivered Distal Depth", '', 'DeliveredDistalDepth'),  # noqa
    0x300A0509: ('FL', '2', "Delivered Nominal Range Modulation Fractions", '', 'DeliveredNominalRangeModulationFractions'),  # noqa
    0x300A0510: ('FL', '2', "Delivered Nominal Range Modulated Region Depths", '', 'DeliveredNominalRangeModulatedRegionDepths'),  # noqa
    0x300A0511: ('CS', '1', "Delivered Reference Dose Definition", '', 'DeliveredReferenceDoseDefinition'),  # noqa
    0x300A0512: ('CS', '1', "Reference Dose Definition", '', 'ReferenceDoseDefinition'),  # noqa
    0x300C0002: ('SQ', '1', "Referenced RT Plan Sequence", '', 'ReferencedRTPlanSequence'),  # noqa
    0x300C0004: ('SQ', '1', "Referenced Beam Sequence", '', 'ReferencedBeamSequence'),  # noqa
    0x300C0006: ('IS', '1', "Referenced Beam Number", '', 'ReferencedBeamNumber'),  # noqa
    0x300C0007: ('IS', '1', "Referenced Reference Image Number", '', 'ReferencedReferenceImageNumber'),  # noqa
    0x300C0008: ('DS', '1', "Start Cumulative Meterset Weight", '', 'StartCumulativeMetersetWeight'),  # noqa
    0x300C0009: ('DS', '1', "End Cumulative Meterset Weight", '', 'EndCumulativeMetersetWeight'),  # noqa
    0x300C000A: ('SQ', '1', "Referenced Brachy Application Setup Sequence", '', 'ReferencedBrachyApplicationSetupSequence'),  # noqa
    0x300C000C: ('IS', '1', "Referenced Brachy Application Setup Number", '', 'ReferencedBrachyApplicationSetupNumber'),  # noqa
    0x300C000E: ('IS', '1', "Referenced Source Number", '', 'ReferencedSourceNumber'),  # noqa
    0x300C0020: ('SQ', '1', "Referenced Fraction Group Sequence", '', 'ReferencedFractionGroupSequence'),  # noqa
    0x300C0022: ('IS', '1', "Referenced Fraction Group Number", '', 'ReferencedFractionGroupNumber'),  # noqa
    0x300C0040: ('SQ', '1', "Referenced Verification Image Sequence", '', 'ReferencedVerificationImageSequence'),  # noqa
    0x300C0042: ('SQ', '1', "Referenced Reference Image Sequence", '', 'ReferencedReferenceImageSequence'),  # noqa
    0x300C0050: ('SQ', '1', "Referenced Dose Reference Sequence", '', 'ReferencedDoseReferenceSequence'),  # noqa
    0x300C0051: ('IS', '1', "Referenced Dose Reference Number", '', 'ReferencedDoseReferenceNumber'),  # noqa
    0x300C0055: ('SQ', '1', "Brachy Referenced Dose Reference Sequence", '', 'BrachyReferencedDoseReferenceSequence'),  # noqa
    0x300C0060: ('SQ', '1', "Referenced Structure Set Sequence", '', 'ReferencedStructureSetSequence'),  # noqa
    0x300C006A: ('IS', '1', "Referenced Patient Setup Number", '', 'ReferencedPatientSetupNumber'),  # noqa
    0x300C0080: ('SQ', '1', "Referenced Dose Sequence", '', 'ReferencedDoseSequence'),  # noqa
    0x300C00A0: ('IS', '1', "Referenced Tolerance Table Number", '', 'ReferencedToleranceTableNumber'),  # noqa
    0x300C00B0: ('SQ', '1', "Referenced Bolus Sequence", '', 'ReferencedBolusSequence'),  # noqa
    0x300C00C0: ('IS', '1', "Referenced Wedge Number", '', 'ReferencedWedgeNumber'),  # noqa
    0x300C00D0: ('IS', '1', "Referenced Compensator Number", '', 'ReferencedCompensatorNumber'),  # noqa
    0x300C00E0: ('IS', '1', "Referenced Block Number", '', 'ReferencedBlockNumber'),  # noqa
    0x300C00F0: ('IS', '1', "Referenced Control Point Index", '', 'ReferencedControlPointIndex'),  # noqa
    0x300C00F2: ('SQ', '1', "Referenced Control Point Sequence", '', 'ReferencedControlPointSequence'),  # noqa
    0x300C00F4: ('IS', '1', "Referenced Start Control Point Index", '', 'ReferencedStartControlPointIndex'),  # noqa
    0x300C00F6: ('IS', '1', "Referenced Stop Control Point Index", '', 'ReferencedStopControlPointIndex'),  # noqa
    0x300C0100: ('IS', '1', "Referenced Range Shifter Number", '', 'ReferencedRangeShifterNumber'),  # noqa
    0x300C0102: ('IS', '1', "Referenced Lateral Spreading Device Number", '', 'ReferencedLateralSpreadingDeviceNumber'),  # noqa
    0x300C0104: ('IS', '1', "Referenced Range Modulator Number", '', 'ReferencedRangeModulatorNumber'),  # noqa
    0x300C0111: ('SQ', '1', "Omitted Beam Task Sequence", '', 'OmittedBeamTaskSequence'),  # noqa
    0x300C0112: ('CS', '1', "Reason for Omission", '', 'ReasonForOmission'),  # noqa
    0x300C0113: ('LO', '1', "Reason for Omission Description", '', 'ReasonForOmissionDescription'),  # noqa
    0x300E0002: ('CS', '1', "Approval Status", '', 'ApprovalStatus'),  # noqa
    0x300E0004: ('DA', '1', "Review Date", '', 'ReviewDate'),  # noqa
    0x300E0005: ('TM', '1', "Review Time", '', 'ReviewTime'),  # noqa
    0x300E0008: ('PN', '1', "Reviewer Name", '', 'ReviewerName'),  # noqa
    0x40000010: ('LT', '1', "Arbitrary", 'Retired', 'Arbitrary'),  # noqa
    0x40004000: ('LT', '1', "Text Comments", 'Retired', 'TextComments'),  # noqa
    0x40080040: ('SH', '1', "Results ID", 'Retired', 'ResultsID'),  # noqa
    0x40080042: ('LO', '1', "Results ID Issuer", 'Retired', 'ResultsIDIssuer'),  # noqa
    0x40080050: ('SQ', '1', "Referenced Interpretation Sequence", 'Retired', 'ReferencedInterpretationSequence'),  # noqa
    0x400800FF: ('CS', '1', "Report Production Status (Trial)", 'Retired', 'ReportProductionStatusTrial'),  # noqa
    0x40080100: ('DA', '1', "Interpretation Recorded Date", 'Retired', 'InterpretationRecordedDate'),  # noqa
    0x40080101: ('TM', '1', "Interpretation Recorded Time", 'Retired', 'InterpretationRecordedTime'),  # noqa
    0x40080102: ('PN', '1', "Interpretation Recorder", 'Retired', 'InterpretationRecorder'),  # noqa
    0x40080103: ('LO', '1', "Reference to Recorded Sound", 'Retired', 'ReferenceToRecordedSound'),  # noqa
    0x40080108: ('DA', '1', "Interpretation Transcription Date", 'Retired', 'InterpretationTranscriptionDate'),  # noqa
    0x40080109: ('TM', '1', "Interpretation Transcription Time", 'Retired', 'InterpretationTranscriptionTime'),  # noqa
    0x4008010A: ('PN', '1', "Interpretation Transcriber", 'Retired', 'InterpretationTranscriber'),  # noqa
    0x4008010B: ('ST', '1', "Interpretation Text", 'Retired', 'InterpretationText'),  # noqa
    0x4008010C: ('PN', '1', "Interpretation Author", 'Retired', 'InterpretationAuthor'),  # noqa
    0x40080111: ('SQ', '1', "Interpretation Approver Sequence", 'Retired', 'InterpretationApproverSequence'),  # noqa
    0x40080112: ('DA', '1', "Interpretation Approval Date", 'Retired', 'InterpretationApprovalDate'),  # noqa
    0x40080113: ('TM', '1', "Interpretation Approval Time", 'Retired', 'InterpretationApprovalTime'),  # noqa
    0x40080114: ('PN', '1', "Physician Approving Interpretation", 'Retired', 'PhysicianApprovingInterpretation'),  # noqa
    0x40080115: ('LT', '1', "Interpretation Diagnosis Description", 'Retired', 'InterpretationDiagnosisDescription'),  # noqa
    0x40080117: ('SQ', '1', "Interpretation Diagnosis Code Sequence", 'Retired', 'InterpretationDiagnosisCodeSequence'),  # noqa
    0x40080118: ('SQ', '1', "Results Distribution List Sequence", 'Retired', 'ResultsDistributionListSequence'),  # noqa
    0x40080119: ('PN', '1', "Distribution Name", 'Retired', 'DistributionName'),  # noqa
    0x4008011A: ('LO', '1', "Distribution Address", 'Retired', 'DistributionAddress'),  # noqa
    0x40080200: ('SH', '1', "Interpretation ID", 'Retired', 'InterpretationID'),  # noqa
    0x40080202: ('LO', '1', "Interpretation ID Issuer", 'Retired', 'InterpretationIDIssuer'),  # noqa
    0x40080210: ('CS', '1', "Interpretation Type ID", 'Retired', 'InterpretationTypeID'),  # noqa
    0x40080212: ('CS', '1', "Interpretation Status ID", 'Retired', 'InterpretationStatusID'),  # noqa
    0x40080300: ('ST', '1', "Impressions", 'Retired', 'Impressions'),  # noqa
    0x40084000: ('ST', '1', "Results Comments", 'Retired', 'ResultsComments'),  # noqa
    0x40100001: ('CS', '1', "Low Energy Detectors", '', 'LowEnergyDetectors'),  # noqa
    0x40100002: ('CS', '1', "High Energy Detectors", '', 'HighEnergyDetectors'),  # noqa
    0x40100004: ('SQ', '1', "Detector Geometry Sequence", '', 'DetectorGeometrySequence'),  # noqa
    0x40101001: ('SQ', '1', "Threat ROI Voxel Sequence", '', 'ThreatROIVoxelSequence'),  # noqa
    0x40101004: ('FL', '3', "Threat ROI Base", '', 'ThreatROIBase'),  # noqa
    0x40101005: ('FL', '3', "Threat ROI Extents", '', 'ThreatROIExtents'),  # noqa
    0x40101006: ('OB', '1', "Threat ROI Bitmap", '', 'ThreatROIBitmap'),  # noqa
    0x40101007: ('SH', '1', "Route Segment ID", '', 'RouteSegmentID'),  # noqa
    0x40101008: ('CS', '1', "Gantry Type", '', 'GantryType'),  # noqa
    0x40101009: ('CS', '1', "OOI Owner Type", '', 'OOIOwnerType'),  # noqa
    0x4010100A: ('SQ', '1', "Route Segment Sequence", '', 'RouteSegmentSequence'),  # noqa
    0x40101010: ('US', '1', "Potential Threat Object ID", '', 'PotentialThreatObjectID'),  # noqa
    0x40101011: ('SQ', '1', "Threat Sequence", '', 'ThreatSequence'),  # noqa
    0x40101012: ('CS', '1', "Threat Category", '', 'ThreatCategory'),  # noqa
    0x40101013: ('LT', '1', "Threat Category Description", '', 'ThreatCategoryDescription'),  # noqa
    0x40101014: ('CS', '1', "ATD Ability Assessment", '', 'ATDAbilityAssessment'),  # noqa
    0x40101015: ('CS', '1', "ATD Assessment Flag", '', 'ATDAssessmentFlag'),  # noqa
    0x40101016: ('FL', '1', "ATD Assessment Probability", '', 'ATDAssessmentProbability'),  # noqa
    0x40101017: ('FL', '1', "Mass", '', 'Mass'),  # noqa
    0x40101018: ('FL', '1', "Density", '', 'Density'),  # noqa
    0x40101019: ('FL', '1', "Z Effective", '', 'ZEffective'),  # noqa
    0x4010101A: ('SH', '1', "Boarding Pass ID", '', 'BoardingPassID'),  # noqa
    0x4010101B: ('FL', '3', "Center of Mass", '', 'CenterOfMass'),  # noqa
    0x4010101C: ('FL', '3', "Center of PTO", '', 'CenterOfPTO'),  # noqa
    0x4010101D: ('FL', '6-n', "Bounding Polygon", '', 'BoundingPolygon'),  # noqa
    0x4010101E: ('SH', '1', "Route Segment Start Location ID", '', 'RouteSegmentStartLocationID'),  # noqa
    0x4010101F: ('SH', '1', "Route Segment End Location ID", '', 'RouteSegmentEndLocationID'),  # noqa
    0x40101020: ('CS', '1', "Route Segment Location ID Type", '', 'RouteSegmentLocationIDType'),  # noqa
    0x40101021: ('CS', '1-n', "Abort Reason", '', 'AbortReason'),  # noqa
    0x40101023: ('FL', '1', "Volume of PTO", '', 'VolumeOfPTO'),  # noqa
    0x40101024: ('CS', '1', "Abort Flag", '', 'AbortFlag'),  # noqa
    0x40101025: ('DT', '1', "Route Segment Start Time", '', 'RouteSegmentStartTime'),  # noqa
    0x40101026: ('DT', '1', "Route Segment End Time", '', 'RouteSegmentEndTime'),  # noqa
    0x40101027: ('CS', '1', "TDR Type", '', 'TDRType'),  # noqa
    0x40101028: ('CS', '1', "International Route Segment", '', 'InternationalRouteSegment'),  # noqa
    0x40101029: ('LO', '1-n', "Threat Detection Algorithm and Version", '', 'ThreatDetectionAlgorithmandVersion'),  # noqa
    0x4010102A: ('SH', '1', "Assigned Location", '', 'AssignedLocation'),  # noqa
    0x4010102B: ('DT', '1', "Alarm Decision Time", '', 'AlarmDecisionTime'),  # noqa
    0x40101031: ('CS', '1', "Alarm Decision", '', 'AlarmDecision'),  # noqa
    0x40101033: ('US', '1', "Number of Total Objects", '', 'NumberOfTotalObjects'),  # noqa
    0x40101034: ('US', '1', "Number of Alarm Objects", '', 'NumberOfAlarmObjects'),  # noqa
    0x40101037: ('SQ', '1', "PTO Representation Sequence", '', 'PTORepresentationSequence'),  # noqa
    0x40101038: ('SQ', '1', "ATD Assessment Sequence", '', 'ATDAssessmentSequence'),  # noqa
    0x40101039: ('CS', '1', "TIP Type", '', 'TIPType'),  # noqa
    0x4010103A: ('CS', '1', "DICOS Version", '', 'DICOSVersion'),  # noqa
    0x40101041: ('DT', '1', "OOI Owner Creation Time", '', 'OOIOwnerCreationTime'),  # noqa
    0x40101042: ('CS', '1', "OOI Type", '', 'OOIType'),  # noqa
    0x40101043: ('FL', '3', "OOI Size", '', 'OOISize'),  # noqa
    0x40101044: ('CS', '1', "Acquisition Status", '', 'AcquisitionStatus'),  # noqa
    0x40101045: ('SQ', '1', "Basis Materials Code Sequence", '', 'BasisMaterialsCodeSequence'),  # noqa
    0x40101046: ('CS', '1', "Phantom Type", '', 'PhantomType'),  # noqa
    0x40101047: ('SQ', '1', "OOI Owner Sequence", '', 'OOIOwnerSequence'),  # noqa
    0x40101048: ('CS', '1', "Scan Type", '', 'ScanType'),  # noqa
    0x40101051: ('LO', '1', "Itinerary ID", '', 'ItineraryID'),  # noqa
    0x40101052: ('SH', '1', "Itinerary ID Type", '', 'ItineraryIDType'),  # noqa
    0x40101053: ('LO', '1', "Itinerary ID Assigning Authority", '', 'ItineraryIDAssigningAuthority'),  # noqa
    0x40101054: ('SH', '1', "Route ID", '', 'RouteID'),  # noqa
    0x40101055: ('SH', '1', "Route ID Assigning Authority", '', 'RouteIDAssigningAuthority'),  # noqa
    0x40101056: ('CS', '1', "Inbound Arrival Type", '', 'InboundArrivalType'),  # noqa
    0x40101058: ('SH', '1', "Carrier ID", '', 'CarrierID'),  # noqa
    0x40101059: ('CS', '1', "Carrier ID Assigning Authority", '', 'CarrierIDAssigningAuthority'),  # noqa
    0x40101060: ('FL', '3', "Source Orientation", '', 'SourceOrientation'),  # noqa
    0x40101061: ('FL', '3', "Source Position", '', 'SourcePosition'),  # noqa
    0x40101062: ('FL', '1', "Belt Height", '', 'BeltHeight'),  # noqa
    0x40101064: ('SQ', '1', "Algorithm Routing Code Sequence", '', 'AlgorithmRoutingCodeSequence'),  # noqa
    0x40101067: ('CS', '1', "Transport Classification", '', 'TransportClassification'),  # noqa
    0x40101068: ('LT', '1', "OOI Type Descriptor", '', 'OOITypeDescriptor'),  # noqa
    0x40101069: ('FL', '1', "Total Processing Time", '', 'TotalProcessingTime'),  # noqa
    0x4010106C: ('OB', '1', "Detector Calibration Data", '', 'DetectorCalibrationData'),  # noqa
    0x4010106D: ('CS', '1', "Additional Screening Performed", '', 'AdditionalScreeningPerformed'),  # noqa
    0x4010106E: ('CS', '1', "Additional Inspection Selection Criteria", '', 'AdditionalInspectionSelectionCriteria'),  # noqa
    0x4010106F: ('SQ', '1', "Additional Inspection Method Sequence", '', 'AdditionalInspectionMethodSequence'),  # noqa
    0x40101070: ('CS', '1', "AIT Device Type", '', 'AITDeviceType'),  # noqa
    0x40101071: ('SQ', '1', "QR Measurements Sequence", '', 'QRMeasurementsSequence'),  # noqa
    0x40101072: ('SQ', '1', "Target Material Sequence", '', 'TargetMaterialSequence'),  # noqa
    0x40101073: ('FD', '1', "SNR Threshold", '', 'SNRThreshold'),  # noqa
    0x40101075: ('DS', '1', "Image Scale Representation", '', 'ImageScaleRepresentation'),  # noqa
    0x40101076: ('SQ', '1', "Referenced PTO Sequence", '', 'ReferencedPTOSequence'),  # noqa
    0x40101077: ('SQ', '1', "Referenced TDR Instance Sequence", '', 'ReferencedTDRInstanceSequence'),  # noqa
    0x40101078: ('ST', '1', "PTO Location Description", '', 'PTOLocationDescription'),  # noqa
    0x40101079: ('SQ', '1', "Anomaly Locator Indicator Sequence", '', 'AnomalyLocatorIndicatorSequence'),  # noqa
    0x4010107A: ('FL', '3', "Anomaly Locator Indicator", '', 'AnomalyLocatorIndicator'),  # noqa
    0x4010107B: ('SQ', '1', "PTO Region Sequence", '', 'PTORegionSequence'),  # noqa
    0x4010107C: ('CS', '1', "Inspection Selection Criteria", '', 'InspectionSelectionCriteria'),  # noqa
    0x4010107D: ('SQ', '1', "Secondary Inspection Method Sequence", '', 'SecondaryInspectionMethodSequence'),  # noqa
    0x4010107E: ('DS', '6', "PRCS to RCS Orientation", '', 'PRCSToRCSOrientation'),  # noqa
    0x4FFE0001: ('SQ', '1', "MAC Parameters Sequence", '', 'MACParametersSequence'),  # noqa
    0x52009229: ('SQ', '1', "Shared Functional Groups Sequence", '', 'SharedFunctionalGroupsSequence'),  # noqa
    0x52009230: ('SQ', '1', "Per-frame Functional Groups Sequence", '', 'PerFrameFunctionalGroupsSequence'),  # noqa
    0x54000100: ('SQ', '1', "Waveform Sequence", '', 'WaveformSequence'),  # noqa
    0x54000110: ('OB or OW', '1', "Channel Minimum Value", '', 'ChannelMinimumValue'),  # noqa
    0x54000112: ('OB or OW', '1', "Channel Maximum Value", '', 'ChannelMaximumValue'),  # noqa
    0x54001004: ('US', '1', "Waveform Bits Allocated", '', 'WaveformBitsAllocated'),  # noqa
    0x54001006: ('CS', '1', "Waveform Sample Interpretation", '', 'WaveformSampleInterpretation'),  # noqa
    0x5400100A: ('OB or OW', '1', "Waveform Padding Value", '', 'WaveformPaddingValue'),  # noqa
    0x54001010: ('OB or OW', '1', "Waveform Data", '', 'WaveformData'),  # noqa
    0x56000010: ('OF', '1', "First Order Phase Correction Angle", '', 'FirstOrderPhaseCorrectionAngle'),  # noqa
    0x56000020: ('OF', '1', "Spectroscopy Data", '', 'SpectroscopyData'),  # noqa
    0x7FE00008: ('OF', '1', "Float Pixel Data", '', 'FloatPixelData'),  # noqa
    0x7FE00009: ('OD', '1', "Double Float Pixel Data", '', 'DoubleFloatPixelData'),  # noqa
    0x7FE00010: ('OB or OW', '1', "Pixel Data", '', 'PixelData'),  # noqa
    0x7FE00020: ('OW', '1', "Coefficients SDVN", 'Retired', 'CoefficientsSDVN'),  # noqa
    0x7FE00030: ('OW', '1', "Coefficients SDHN", 'Retired', 'CoefficientsSDHN'),  # noqa
    0x7FE00040: ('OW', '1', "Coefficients SDDN", 'Retired', 'CoefficientsSDDN'),  # noqa
    0xFFFAFFFA: ('SQ', '1', "Digital Signatures Sequence", '', 'DigitalSignaturesSequence'),  # noqa
    0xFFFCFFFC: ('OB', '1', "Data Set Trailing Padding", '', 'DataSetTrailingPadding'),  # noqa
    0xFFFEE000: ('NONE', '1', "Item", '', 'Item'),  # noqa
    0xFFFEE00D: ('NONE', '1', "Item Delimitation Item", '', 'ItemDelimitationItem'),  # noqa
    0xFFFEE0DD: ('NONE', '1', "Sequence Delimitation Item", '', 'SequenceDelimitationItem')  # noqa
}

RepeatersDictionary = {
    '002031xx': ('CS', '1-n', "Source Image IDs", 'Retired', 'SourceImageIDs'),  # noqa
    '002804x0': ('US', '1', "Rows For Nth Order Coefficients", 'Retired', 'RowsForNthOrderCoefficients'),  # noqa
    '002804x1': ('US', '1', "Columns For Nth Order Coefficients", 'Retired', 'ColumnsForNthOrderCoefficients'),  # noqa
    '002804x2': ('LO', '1-n', "Coefficient Coding", 'Retired', 'CoefficientCoding'),  # noqa
    '002804x3': ('AT', '1-n', "Coefficient Coding Pointers", 'Retired', 'CoefficientCodingPointers'),  # noqa
    '002808x0': ('CS', '1-n', "Code Label", 'Retired', 'CodeLabel'),  # noqa
    '002808x2': ('US', '1', "Number of Tables", 'Retired', 'NumberOfTables'),  # noqa
    '002808x3': ('AT', '1-n', "Code Table Location", 'Retired', 'CodeTableLocation'),  # noqa
    '002808x4': ('US', '1', "Bits For Code Word", 'Retired', 'BitsForCodeWord'),  # noqa
    '002808x8': ('AT', '1-n', "Image Data Location", 'Retired', 'ImageDataLocation'),  # noqa
    '1000xxx0': ('US', '3', "Escape Triplet", 'Retired', 'EscapeTriplet'),  # noqa
    '1000xxx1': ('US', '3', "Run Length Triplet", 'Retired', 'RunLengthTriplet'),  # noqa
    '1000xxx2': ('US', '1', "Huffman Table Size", 'Retired', 'HuffmanTableSize'),  # noqa
    '1000xxx3': ('US', '3', "Huffman Table Triplet", 'Retired', 'HuffmanTableTriplet'),  # noqa
    '1000xxx4': ('US', '1', "Shift Table Size", 'Retired', 'ShiftTableSize'),  # noqa
    '1000xxx5': ('US', '3', "Shift Table Triplet", 'Retired', 'ShiftTableTriplet'),  # noqa
    '1010xxxx': ('US', '1-n', "Zonal Map", 'Retired', 'ZonalMap'),  # noqa
    '50xx0005': ('US', '1', "Curve Dimensions", 'Retired', 'CurveDimensions'),  # noqa
    '50xx0010': ('US', '1', "Number of Points", 'Retired', 'NumberOfPoints'),  # noqa
    '50xx0020': ('CS', '1', "Type of Data", 'Retired', 'TypeOfData'),  # noqa
    '50xx0022': ('LO', '1', "Curve Description", 'Retired', 'CurveDescription'),  # noqa
    '50xx0030': ('SH', '1-n', "Axis Units", 'Retired', 'AxisUnits'),  # noqa
    '50xx0040': ('SH', '1-n', "Axis Labels", 'Retired', 'AxisLabels'),  # noqa
    '50xx0103': ('US', '1', "Data Value Representation", 'Retired', 'DataValueRepresentation'),  # noqa
    '50xx0104': ('US', '1-n', "Minimum Coordinate Value", 'Retired', 'MinimumCoordinateValue'),  # noqa
    '50xx0105': ('US', '1-n', "Maximum Coordinate Value", 'Retired', 'MaximumCoordinateValue'),  # noqa
    '50xx0106': ('SH', '1-n', "Curve Range", 'Retired', 'CurveRange'),  # noqa
    '50xx0110': ('US', '1-n', "Curve Data Descriptor", 'Retired', 'CurveDataDescriptor'),  # noqa
    '50xx0112': ('US', '1-n', "Coordinate Start Value", 'Retired', 'CoordinateStartValue'),  # noqa
    '50xx0114': ('US', '1-n', "Coordinate Step Value", 'Retired', 'CoordinateStepValue'),  # noqa
    '50xx1001': ('CS', '1', "Curve Activation Layer", 'Retired', 'CurveActivationLayer'),  # noqa
    '50xx2000': ('US', '1', "Audio Type", 'Retired', 'AudioType'),  # noqa
    '50xx2002': ('US', '1', "Audio Sample Format", 'Retired', 'AudioSampleFormat'),  # noqa
    '50xx2004': ('US', '1', "Number of Channels", 'Retired', 'NumberOfChannels'),  # noqa
    '50xx2006': ('UL', '1', "Number of Samples", 'Retired', 'NumberOfSamples'),  # noqa
    '50xx2008': ('UL', '1', "Sample Rate", 'Retired', 'SampleRate'),  # noqa
    '50xx200A': ('UL', '1', "Total Time", 'Retired', 'TotalTime'),  # noqa
    '50xx200C': ('OB or OW', '1', "Audio Sample Data", 'Retired', 'AudioSampleData'),  # noqa
    '50xx200E': ('LT', '1', "Audio Comments", 'Retired', 'AudioComments'),  # noqa
    '50xx2500': ('LO', '1', "Curve Label", 'Retired', 'CurveLabel'),  # noqa
    '50xx2600': ('SQ', '1', "Curve Referenced Overlay Sequence", 'Retired', 'CurveReferencedOverlaySequence'),  # noqa
    '50xx2610': ('US', '1', "Curve Referenced Overlay Group", 'Retired', 'CurveReferencedOverlayGroup'),  # noqa
    '50xx3000': ('OB or OW', '1', "Curve Data", 'Retired', 'CurveData'),  # noqa
    '60xx0010': ('US', '1', "Overlay Rows", '', 'OverlayRows'),  # noqa
    '60xx0011': ('US', '1', "Overlay Columns", '', 'OverlayColumns'),  # noqa
    '60xx0012': ('US', '1', "Overlay Planes", 'Retired', 'OverlayPlanes'),  # noqa
    '60xx0015': ('IS', '1', "Number of Frames in Overlay", '', 'NumberOfFramesInOverlay'),  # noqa
    '60xx0022': ('LO', '1', "Overlay Description", '', 'OverlayDescription'),  # noqa
    '60xx0040': ('CS', '1', "Overlay Type", '', 'OverlayType'),  # noqa
    '60xx0045': ('LO', '1', "Overlay Subtype", '', 'OverlaySubtype'),  # noqa
    '60xx0050': ('SS', '2', "Overlay Origin", '', 'OverlayOrigin'),  # noqa
    '60xx0051': ('US', '1', "Image Frame Origin", '', 'ImageFrameOrigin'),  # noqa
    '60xx0052': ('US', '1', "Overlay Plane Origin", 'Retired', 'OverlayPlaneOrigin'),  # noqa
    '60xx0060': ('CS', '1', "Overlay Compression Code", 'Retired', 'OverlayCompressionCode'),  # noqa
    '60xx0061': ('SH', '1', "Overlay Compression Originator", 'Retired', 'OverlayCompressionOriginator'),  # noqa
    '60xx0062': ('SH', '1', "Overlay Compression Label", 'Retired', 'OverlayCompressionLabel'),  # noqa
    '60xx0063': ('CS', '1', "Overlay Compression Description", 'Retired', 'OverlayCompressionDescription'),  # noqa
    '60xx0066': ('AT', '1-n', "Overlay Compression Step Pointers", 'Retired', 'OverlayCompressionStepPointers'),  # noqa
    '60xx0068': ('US', '1', "Overlay Repeat Interval", 'Retired', 'OverlayRepeatInterval'),  # noqa
    '60xx0069': ('US', '1', "Overlay Bits Grouped", 'Retired', 'OverlayBitsGrouped'),  # noqa
    '60xx0100': ('US', '1', "Overlay Bits Allocated", '', 'OverlayBitsAllocated'),  # noqa
    '60xx0102': ('US', '1', "Overlay Bit Position", '', 'OverlayBitPosition'),  # noqa
    '60xx0110': ('CS', '1', "Overlay Format", 'Retired', 'OverlayFormat'),  # noqa
    '60xx0200': ('US', '1', "Overlay Location", 'Retired', 'OverlayLocation'),  # noqa
    '60xx0800': ('CS', '1-n', "Overlay Code Label", 'Retired', 'OverlayCodeLabel'),  # noqa
    '60xx0802': ('US', '1', "Overlay Number of Tables", 'Retired', 'OverlayNumberOfTables'),  # noqa
    '60xx0803': ('AT', '1-n', "Overlay Code Table Location", 'Retired', 'OverlayCodeTableLocation'),  # noqa
    '60xx0804': ('US', '1', "Overlay Bits For Code Word", 'Retired', 'OverlayBitsForCodeWord'),  # noqa
    '60xx1001': ('CS', '1', "Overlay Activation Layer", '', 'OverlayActivationLayer'),  # noqa
    '60xx1100': ('US', '1', "Overlay Descriptor - Gray", 'Retired', 'OverlayDescriptorGray'),  # noqa
    '60xx1101': ('US', '1', "Overlay Descriptor - Red", 'Retired', 'OverlayDescriptorRed'),  # noqa
    '60xx1102': ('US', '1', "Overlay Descriptor - Green", 'Retired', 'OverlayDescriptorGreen'),  # noqa
    '60xx1103': ('US', '1', "Overlay Descriptor - Blue", 'Retired', 'OverlayDescriptorBlue'),  # noqa
    '60xx1200': ('US', '1-n', "Overlays - Gray", 'Retired', 'OverlaysGray'),  # noqa
    '60xx1201': ('US', '1-n', "Overlays - Red", 'Retired', 'OverlaysRed'),  # noqa
    '60xx1202': ('US', '1-n', "Overlays - Green", 'Retired', 'OverlaysGreen'),  # noqa
    '60xx1203': ('US', '1-n', "Overlays - Blue", 'Retired', 'OverlaysBlue'),  # noqa
    '60xx1301': ('IS', '1', "ROI Area", '', 'ROIArea'),  # noqa
    '60xx1302': ('DS', '1', "ROI Mean", '', 'ROIMean'),  # noqa
    '60xx1303': ('DS', '1', "ROI Standard Deviation", '', 'ROIStandardDeviation'),  # noqa
    '60xx1500': ('LO', '1', "Overlay Label", '', 'OverlayLabel'),  # noqa
    '60xx3000': ('OB or OW', '1', "Overlay Data", '', 'OverlayData'),  # noqa
    '60xx4000': ('LT', '1', "Overlay Comments", 'Retired', 'OverlayComments'),  # noqa
    '7Fxx0010': ('OB or OW', '1', "Variable Pixel Data", 'Retired', 'VariablePixelData'),  # noqa
    '7Fxx0011': ('US', '1', "Variable Next Data Group", 'Retired', 'VariableNextDataGroup'),  # noqa
    '7Fxx0020': ('OW', '1', "Variable Coefficients SDVN", 'Retired', 'VariableCoefficientsSDVN'),  # noqa
    '7Fxx0030': ('OW', '1', "Variable Coefficients SDHN", 'Retired', 'VariableCoefficientsSDHN'),  # noqa
    '7Fxx0040': ('OW', '1', "Variable Coefficients SDDN", 'Retired', 'VariableCoefficientsSDDN')  # noqa
}
