import pathlib
from datetime import tzinfo
from typing import Any, BinaryIO, Optional, Union

def calculate_crc32(data: bytes, value: int=..., blocksize: int=...) -> int: ...

calculate_key: Any

def filetime_to_dt(ft: Any): ...

ZERO: Any
HOUR: Any
SECOND: Any
STDOFFSET: Any
DSTOFFSET: Any
DSTOFFSET = STDOFFSET
DSTDIFF: Any

class LocalTimezone(tzinfo):
    def fromutc(self, dt: Any): ...
    def utcoffset(self, dt: Any): ...
    def dst(self, dt: Any): ...
    def tzname(self, dt: Any): ...

Local: Any
TIMESTAMP_ADJUST: int

class UTC(tzinfo):
    def utcoffset(self, dt: Any): ...
    def tzname(self, dt: Any): ...
    def dst(self, dt: Any): ...
    def _call__(self): ...

class ArchiveTimestamp(int):
    def __index__(self): ...
    def totimestamp(self) -> float: ...
    def as_datetime(self): ...
    @staticmethod
    def from_datetime(val: Any): ...
    @staticmethod
    def from_now(): ...

def islink(path: Any): ...
def readlink(path: Union[str, pathlib.Path], *, dir_fd: Any=...) -> Union[str, pathlib.Path]: ...

class MemIO:
    def __init__(self, buf: BinaryIO) -> None: ...
    def write(self, data: bytes) -> int: ...
    def read(self, length: Optional[int]=...) -> bytes: ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    def seek(self, position: int) -> None: ...
    def open(self, mode: Optional[Any] = ...): ...
    @property
    def parent(self): ...
    def mkdir(self, parents: Optional[Any] = ..., exist_ok: bool = ...) -> None: ...
    def __enter__(self): ...
    def __exit__(self, exc_type: Any, exc_val: Any, exc_tb: Any) -> None: ...

class NullIO:
    def __init__(self) -> None: ...
    def write(self, data: Any): ...
    def read(self, length: Optional[Any] = ...): ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    def open(self, mode: Optional[Any] = ...): ...
    @property
    def parent(self): ...
    def mkdir(self) -> None: ...
    def __enter__(self): ...
    def __exit__(self, exc_type: Any, exc_val: Any, exc_tb: Any) -> None: ...

class BufferOverflow(Exception): ...

class Buffer:
    view: Any = ...
    def __init__(self, size: int=...) -> None: ...
    def add(self, data: Union[bytes, bytearray, memoryview]) -> Any: ...
    def reset(self) -> None: ...
    def set(self, data: Union[bytes, bytearray, memoryview]) -> None: ...
    def get(self) -> bytearray: ...
    def __len__(self) -> int: ...
    def __bytes__(self): ...
