import abc
from abc import ABC, abstractmethod
from enum import Enum
from py7zr.exceptions import PasswordRequired as PasswordRequired, UnsupportedCompressionMethodError as UnsupportedCompressionMethodError
from py7zr.helpers import Buffer as Buffer, calculate_crc32 as calculate_crc32, calculate_key as calculate_key
from py7zr.properties import COMPRESSION_METHOD as COMPRESSION_METHOD, CompressionMethod as CompressionMethod, FILTER_ARM as FILTER_ARM, FILTER_ARMTHUMB as FILTER_ARMTHUMB, FILTER_BROTLI as FILTER_BROTLI, FILTER_BZIP2 as FILTER_BZIP2, FILTER_COPY as FILTER_COPY, FILTER_CRYPTO_AES256_SHA256 as FILTER_CRYPTO_AES256_SHA256, FILTER_DEFLATE as FILTER_DEFLATE, FILTER_DELTA as FILTER_DELTA, FILTER_IA64 as FILTER_IA64, FILTER_LZMA as FILTER_LZMA, FILTER_LZMA2 as FILTER_LZMA2, FILTER_POWERPC as FILTER_POWERPC, FILTER_PPMD as FILTER_PPMD, FILTER_SPARC as FILTER_SPARC, FILTER_X86 as FILTER_X86, FILTER_ZSTD as FILTER_ZSTD, MAGIC_7Z as MAGIC_7Z, get_default_blocksize as get_default_blocksize
from typing import Any, Dict, List, Optional, Tuple, Union

brotli_major: int
brotli_minor: int

class ISevenZipCompressor(ABC, metaclass=abc.ABCMeta):
    @abstractmethod
    def compress(self, data: Union[bytes, bytearray, memoryview]) -> bytes: ...
    @abstractmethod
    def flush(self) -> bytes: ...

class ISevenZipDecompressor(ABC, metaclass=abc.ABCMeta):
    @abstractmethod
    def decompress(self, data: Union[bytes, bytearray, memoryview], max_length: int=...) -> bytes: ...

class AESCompressor(ISevenZipCompressor):
    AES_CBC_BLOCKSIZE: int = ...
    cycles: int = ...
    iv: Any = ...
    salt: bytes = ...
    method: Any = ...
    cipher: Any = ...
    flushed: bool = ...
    buf: Any = ...
    def __init__(self, password: str, blocksize: Optional[int]=...) -> None: ...
    def encode_filter_properties(self): ...
    def compress(self, data: Any): ...
    def flush(self): ...

class AESDecompressor(ISevenZipDecompressor):
    cipher: Any = ...
    buf: Any = ...
    def __init__(self, aes_properties: bytes, password: str, blocksize: Optional[int]=...) -> None: ...
    def decompress(self, data: Union[bytes, bytearray, memoryview], max_length: int=...) -> bytes: ...

class DeflateCompressor(ISevenZipCompressor):
    def __init__(self) -> None: ...
    def compress(self, data: Any): ...
    def flush(self): ...

class DeflateDecompressor(ISevenZipDecompressor):
    flushed: bool = ...
    def __init__(self) -> None: ...
    def decompress(self, data: Union[bytes, bytearray, memoryview], max_length: int=...) -> bytes: ...

class CopyCompressor(ISevenZipCompressor):
    def compress(self, data: Union[bytes, bytearray, memoryview]) -> bytes: ...
    def flush(self): ...

class CopyDecompressor(ISevenZipDecompressor):
    def decompress(self, data: Union[bytes, bytearray, memoryview], max_length: int=...) -> bytes: ...

class PpmdDecompressor(ISevenZipDecompressor):
    decoder: Any = ...
    def __init__(self, properties: bytes, blocksize: Optional[int]=...) -> None: ...
    def decompress(self, data: Union[bytes, bytearray, memoryview], max_length: Any=...) -> bytes: ...

class PpmdCompressor(ISevenZipCompressor):
    encoder: Any = ...
    def __init__(self, properties: bytes) -> None: ...
    def compress(self, data: Union[bytes, bytearray, memoryview]) -> bytes: ...
    def flush(self): ...
    @classmethod
    def encode_filter_properties(cls, filter: Dict[str, Union[str, int]]) -> Any: ...

class BcjSparcDecoder(ISevenZipDecompressor):
    decoder: Any = ...
    def __init__(self, size: int) -> None: ...
    def decompress(self, data: Union[bytes, bytearray, memoryview], max_length: int=...) -> bytes: ...

class BcjSparcEncoder(ISevenZipCompressor):
    encoder: Any = ...
    def __init__(self) -> None: ...
    def compress(self, data: Union[bytes, bytearray, memoryview]) -> bytes: ...
    def flush(self): ...

class BcjPpcDecoder(ISevenZipDecompressor):
    decoder: Any = ...
    def __init__(self, size: int) -> None: ...
    def decompress(self, data: Union[bytes, bytearray, memoryview], max_length: int=...) -> bytes: ...

class BcjPpcEncoder(ISevenZipCompressor):
    encoder: Any = ...
    def __init__(self) -> None: ...
    def compress(self, data: Union[bytes, bytearray, memoryview]) -> bytes: ...
    def flush(self): ...

class BcjArmtDecoder(ISevenZipDecompressor):
    decoder: Any = ...
    def __init__(self, size: int) -> None: ...
    def decompress(self, data: Union[bytes, bytearray, memoryview], max_length: int=...) -> bytes: ...

class BcjArmtEncoder(ISevenZipCompressor):
    encoder: Any = ...
    def __init__(self) -> None: ...
    def compress(self, data: Union[bytes, bytearray, memoryview]) -> bytes: ...
    def flush(self): ...

class BcjArmDecoder(ISevenZipDecompressor):
    decoder: Any = ...
    def __init__(self, size: int) -> None: ...
    def decompress(self, data: Union[bytes, bytearray, memoryview], max_length: int=...) -> bytes: ...

class BcjArmEncoder(ISevenZipCompressor):
    encoder: Any = ...
    def __init__(self) -> None: ...
    def compress(self, data: Union[bytes, bytearray, memoryview]) -> bytes: ...
    def flush(self): ...

class BCJDecoder(ISevenZipDecompressor):
    decoder: Any = ...
    def __init__(self, size: int) -> None: ...
    def decompress(self, data: Union[bytes, bytearray, memoryview], max_length: int=...) -> bytes: ...

class BCJEncoder(ISevenZipCompressor):
    encoder: Any = ...
    def __init__(self) -> None: ...
    def compress(self, data: Union[bytes, bytearray, memoryview]) -> bytes: ...
    def flush(self): ...

class BrotliCompressor:
    def __init__(self, level: Any) -> None: ...
    def compress(self, data: Union[bytes, bytearray, memoryview]) -> bytes: ...
    def flush(self) -> bytes: ...

class BrotliDecompressor:
    decompress: Any = ...
    def __init__(self, properties: bytes, block_size: int) -> None: ...

class ZstdCompressor:
    compressor: Any = ...
    def __init__(self, level: int) -> None: ...
    def compress(self, data: Union[bytes, bytearray, memoryview]) -> bytes: ...
    def flush(self) -> bytes: ...

class ZstdDecompressor:
    decompressor: Any = ...
    def __init__(self, properties: bytes, blocksize: int) -> None: ...
    def decompress(self, data: Union[bytes, bytearray, memoryview]) -> bytes: ...

algorithm_class_map: Dict[int, Tuple[Any, Any]]

class LZMA1Decompressor(ISevenZipDecompressor):
    unpacksize: Any = ...
    def __init__(self, filters: Any, unpacksize: Any) -> None: ...
    def decompress(self, data: Union[bytes, bytearray, memoryview], max_length: int = ...) -> bytes: ...

class SevenZipDecompressor:
    input_size: Any = ...
    unpacksizes: Any = ...
    consumed: int = ...
    crc: Any = ...
    digest: int = ...
    block_size: Any = ...
    methods_map: Any = ...
    chain: Any = ...
    def __init__(self, coders: List[Dict[str, Any]], packsize: int, unpacksizes: List[int], crc: Optional[int], password: Optional[str]=..., blocksize: Optional[int]=...) -> None: ...
    def decompress(self, fp: Any, max_length: int=...) -> bytes: ...
    def check_crc(self): ...
    @property
    def unused_size(self): ...

class SevenZipCompressor:
    filters: Any = ...
    chain: Any = ...
    digest: int = ...
    packsize: int = ...
    methods_map: Any = ...
    coders: Any = ...
    def __init__(self, filters: Any=..., password: Any=..., blocksize: Optional[int]=...) -> None: ...
    def compress(self, fd: Any, fp: Any, crc: int = ...): ...
    def flush(self, fp: Any): ...
    @property
    def unpacksizes(self): ...

class MethodsType(Enum):
    compressor: int = ...
    filter: int = ...
    crypto: int = ...

class SupportedMethods:
    formats: Any = ...
    methods: Any = ...
    @classmethod
    def get_method_name_id(cls, filter_id: Any): ...
    @classmethod
    def get_filter_id(cls, coder: Any): ...
    @classmethod
    def is_native_filter(cls, filter: Any) -> bool: ...
    @classmethod
    def is_compressor(cls, filter: Any): ...
    @classmethod
    def is_compressor_id(cls, filter_id: Any): ...
    @classmethod
    def is_native_coder(cls, coder: Any) -> bool: ...
    @classmethod
    def need_property(cls, filter_id: Any): ...
    @classmethod
    def is_crypto_id(cls, filter_id: Any) -> bool: ...
    @classmethod
    def get_method_id(cls, filter_id: Any) -> bytes: ...
    @classmethod
    def get_coder(cls, filter: Any) -> Dict[str, Any]: ...
    @classmethod
    def needs_password(cls, coders: Any) -> bool: ...

def get_methods_names_string(coders_lists: List[List[dict]]) -> str: ...
