from io import BytesIO
from py7zr.compressor import SevenZipCompressor as SevenZipCompressor, SevenZipDecompressor as SevenZipDecompressor
from py7zr.exceptions import Bad7zFile as Bad7zFile
from py7zr.helpers import ArchiveTimestamp as ArchiveTimestamp, calculate_crc32 as calculate_crc32
from py7zr.properties import DEFAULT_FILTERS as DEFAULT_FILTERS, MAGIC_7Z as MAGIC_7Z, PROPERTY as PROPERTY
from typing import Any, BinaryIO, List, Tuple

MAX_LENGTH: int
P7ZIP_MAJOR_VERSION: bytes
P7ZIP_MINOR_VERSION: bytes

def read_crcs(file: BinaryIO, count: int) -> List[int]: ...
def write_crcs(file: BinaryIO, crcs: Any) -> Any: ...
def read_byte(file: BinaryIO) -> int: ...
def write_bytes(file: BinaryIO, data: bytes) -> Any: ...
def write_byte(file: BinaryIO, data: Any) -> Any: ...
def read_real_uint64(file: BinaryIO) -> Tuple[int, bytes]: ...
def read_uint32(file: BinaryIO) -> Tuple[int, bytes]: ...
def write_uint32(file: BinaryIO, value: Any) -> Any: ...
def read_uint64(file: BinaryIO) -> int: ...
def write_real_uint64(file: BinaryIO, value: int) -> Any: ...
def write_uint64(file: BinaryIO, value: int) -> Any: ...
def read_boolean(file: BinaryIO, count: int, checkall: bool=...) -> List[bool]: ...
def write_boolean(file: BinaryIO, booleans: List[bool], all_defined: bool=...) -> Any: ...
def read_utf16(file: BinaryIO) -> str: ...
def write_utf16(file: BinaryIO, val: str) -> Any: ...
def bits_to_bytes(bit_length: int) -> int: ...

class PackInfo:
    packpos: int = ...
    numstreams: int = ...
    packsizes: Any = ...
    digestdefined: Any = ...
    crcs: Any = ...
    enable_digests: bool = ...
    def __init__(self) -> None: ...
    @classmethod
    def retrieve(cls, file: BinaryIO) -> Any: ...
    def write(self, file: BinaryIO) -> Any: ...

class Bond:
    incoder: Any = ...
    outcoder: Any = ...
    def __init__(self, incoder: Any, outcoder: Any) -> None: ...

class Folder:
    unpacksizes: Any = ...
    coders: Any = ...
    bindpairs: Any = ...
    packed_indices: Any = ...
    solid: bool = ...
    digestdefined: bool = ...
    crc: Any = ...
    decompressor: Any = ...
    compressor: Any = ...
    files: Any = ...
    password: Any = ...
    def __init__(self) -> None: ...
    @classmethod
    def retrieve(cls, file: BinaryIO) -> Any: ...
    def prepare_coderinfo(self, filters: Any) -> None: ...
    def write(self, file: BinaryIO) -> Any: ...
    def is_simple(self, coder: Any): ...
    def get_decompressor(self, packsize: int, reset: bool=...) -> SevenZipDecompressor: ...
    def get_compressor(self) -> SevenZipCompressor: ...
    def get_unpack_size(self) -> int: ...

class UnpackInfo:
    @classmethod
    def retrieve(cls, file: BinaryIO) -> Any: ...
    numfolders: Any = ...
    folders: Any = ...
    datastreamidx: Any = ...
    def __init__(self) -> None: ...
    def write(self, file: BinaryIO) -> Any: ...

class SubstreamsInfo:
    digests: Any = ...
    digestsdefined: Any = ...
    unpacksizes: Any = ...
    num_unpackstreams_folders: Any = ...
    def __init__(self) -> None: ...
    @classmethod
    def retrieve(cls, file: BinaryIO, numfolders: int, folders: List[Folder]) -> Any: ...
    def write(self, file: BinaryIO) -> Any: ...

class StreamsInfo:
    packinfo: Any = ...
    unpackinfo: Any = ...
    substreamsinfo: Any = ...
    def __init__(self) -> None: ...
    @classmethod
    def retrieve(cls, file: BinaryIO) -> Any: ...
    def read(self, file: BinaryIO) -> None: ...
    def write(self, file: BinaryIO) -> Any: ...

class HeaderStreamsInfo(StreamsInfo):
    packinfo: Any = ...
    unpackinfo: Any = ...
    def __init__(self) -> None: ...
    def write(self, file: BinaryIO) -> Any: ...

class FilesInfo:
    files: Any = ...
    emptyfiles: Any = ...
    antifiles: Any = ...
    def __init__(self) -> None: ...
    @classmethod
    def retrieve(cls, file: BinaryIO) -> Any: ...
    def write(self, file: BinaryIO) -> Any: ...

class WriteWithCrc:
    digest: int = ...
    def __init__(self, fp: BinaryIO) -> None: ...
    def write(self, data: Any): ...
    def tell(self): ...

class Header:
    __slot__: Any = ...
    solid: bool = ...
    main_streams: Any = ...
    files_info: Any = ...
    size: int = ...
    password: Any = ...
    def __init__(self) -> None: ...
    @classmethod
    def retrieve(cls, fp: BinaryIO, buffer: BytesIO, start_pos: int, password: Any=...) -> Any: ...
    def write(self, file: BinaryIO, afterheader: int, encoded: Any=..., encrypted: Any=...) -> Any: ...
    @staticmethod
    def build_header(folders: Any): ...

class SignatureHeader:
    version: Any = ...
    startheadercrc: int = ...
    nextheaderofs: int = ...
    nextheadersize: int = ...
    nextheadercrc: int = ...
    def __init__(self) -> None: ...
    @classmethod
    def retrieve(cls, file: BinaryIO) -> Any: ...
    def calccrc(self, length: int, header_crc: int) -> Any: ...
    def write(self, file: BinaryIO) -> Any: ...
