# -----------------------------------------------------------------------------
# yacc_simple.py
#
# Test to see if raising SyntaxError inside a production actually works
# -----------------------------------------------------------------------------
import sys

if ".." not in sys.path: sys.path.insert(0,"..")
import ply.yacc as yacc

from calclex import tokens

def p_statements(p):
    '''
    statements : statements statement
               | statement
    '''
    pass
    
def p_statement_good(t):
    'statement : NAME PLUS NUMBER'
    print('%s = %s' % (t[1], t[3]))

def p_statement_bad(t):
    'statement : NAME TIMES NUMBER'
    print('Bad expression')
    raise SyntaxError()

def p_error(t):
    print("Syntax error at '%s'" % t.value)

in_text = '''a + 40
             a * 30
             a + 60
             a + 70'''
    
yacc.yacc()
yacc.parse(in_text)




