#!/usr/bin/python

###############################################################################
# NAME: pypedal.py
# VERSION: 2.01 (28JAN2004)
# AUTHOR: John B. Cole, PhD (jcole@funjackals.com)
# LICENSE: LGPL
###############################################################################

from pyp_classes import *
from pyp_io import *
from pyp_metrics import *
from pyp_nrm import *
from pyp_utils import *

if __name__=='__main__':

	print 'Starting pypedal.py at %s' % asctime(localtime(time()))
	print '\tPreprocessing pedigree at %s' % asctime(localtime(time()))
	example = preprocess('example.ped')
	print '\tCalling fast_a_matrix() at %s' % asctime(localtime(time()))
	ex_a = fast_a_matrix(example,'example')
	#print '\tCalling a_decompose() at %s' % asctime(localtime(time()))
	#de_a_t,de_a_d = a_decompose(example,'example',ex_a)
	#print '\tCalling a_inverse_dnf() at %s' % asctime(localtime(time()))
	#my_ainv_dnf = a_inverse_dnf(example,'example')
	#print '\tCalling a_inverse_df() at %s' % asctime(localtime(time()))
	#my_ainv_df = a_inverse_df(example,'example')
	print '\tCalling a_coefficients() at %s' % asctime(localtime(time()))
	a_coefficients(example,'example',ex_a)
	#print '\tCalling a_effective_founders_lacy() at %s' % asctime(localtime(time()))
	#a_effective_founders_lacy(example,'example')
	#print '\tCalling a_effective_founders_boichard() at %s' % asctime(localtime(time()))
	#a_effective_founders_boichard(example,'example')
	#print '\tCalling a_effective_ancestors_boichard() at %s' % asctime(localtime(time()))
	#a_effective_ancestors_definite(example,'example')
	# Instantiate a pedigree metadata object
	example_meta = Pedigree(example,'example.ped','example_meta')
	print '\tCalling theoretical_ne_from_metadata() at %s' % asctime(localtime(time()))
	theoretical_ne_from_metadata(example_meta,filetag='example')
	print '\tCalling pedigree_completeness() at %s' % asctime(localtime(time()))
	pedigree_completeness(example,filetag='example')

	print 'Stopping pypedal.py at %s' % asctime(localtime(time()))
