#!/usr/bin/python

###############################################################################
# NAME: boichard.py
# VERSION: 2.0.0a3 (15APR2004)
# AUTHOR: John B. Cole, PhD (jcole@aipl.arsusda.gov)
# LICENSE: LGPL
###############################################################################

from pyp_classes import *
from pyp_io import *
from pyp_metrics import *
from pyp_nrm import *
from pyp_utils import *

if __name__=='__main__':

	print 'Starting pypedal.py at %s' % asctime(localtime(time()))
	print '\tPreprocessing pedigree at %s' % asctime(localtime(time()))
	example = preprocess('lacy.ped',sepchar=' ')
	print '\tCollecting pedigree metadata at %s' % asctime(localtime(time()))
	example_meta = Pedigree(example,'example.ped','example_meta')
	print '\tCalling a_effective_founders_lacy() at %s' % asctime(localtime(time()))
	a_effective_founders_lacy(example,filetag='example')
	print '\tCalling a_effective_founders_boichard() at %s' % asctime(localtime(time()))
	a_effective_founders_boichard(example,filetag='example')
	print 'Stopping pypedal.py at %s' % asctime(localtime(time()))