# Build a `Pipeline`

A Panel Pipeline allows you to connect multiple panels into a sequential user interface where the output of one stage feeds into the next. These How-to pages provide solutions for common tasks related to creating and customizing pipelines.

::::{grid} 1 2 2 3
:gutter: 1 1 1 2

:::{grid-item-card} {octicon}`git-commit;2.5em;sd-mr-1 sd-animate-grow50` Create a `Pipeline`
:link: simple_pipeline
:link-type: doc

How to create a simple linear Panel Pipeline.
:::

:::{grid-item-card} {octicon}`git-branch;2.5em;sd-mr-1 sd-animate-grow50` Create a Non-Linear `Pipeline`
:link: complex_pipeline
:link-type: doc

This guide addresses how to build a non-linear Panel Pipeline with branching and converging steps.
:::

:::{grid-item-card} {octicon}`tab;2.5em;sd-mr-1 sd-animate-grow50` Customize `Pipeline` Layout
:link: pipeline_layout
:link-type: doc

How to customize the visual layout of the Panel Pipeline UI.
:::

:::{grid-item-card} {octicon}`milestone;2.5em;sd-mr-1 sd-animate-grow50` Control `Pipeline` Flow
:link: control_flow
:link-type: doc

How to programmatically control the Pipeline UI flow.
:::

::::

```{toctree}
:titlesonly:
:hidden:
:maxdepth: 2

simple_pipeline
complex_pipeline
pipeline_layout
control_flow
```
