# App Gallery

These Panel applications demonstrate what you can build with Panel and how to do it. Click on each thumbnail to see the app running live, and click on "See source" to look at how each of the components are configured and put together. The source is fully runnable in your browser thanks to [WASM & Pyodide](../how_to/wasm/index.md); just press the <span style="color:green">▶</span> button on the first code cell to run all the cells.

::::{grid} 1 2 2 3
:gutter: 1 1 1 2

:::{grid-item-card} Portfolio Optimizer

```{image} https://assets.holoviz.org/panel/gallery/portfolio_optimizer.png
:target: https://|gallery-endpoint|.pyviz.demo.anaconda.com/portfolio_optimizer
:width: 100%
```

Stock portfolio optimization by exploring the efficient frontier and optimizing the Sharpe ratio.
+++
[See source](portfolio_optimizer)
:::

:::{grid-item-card} Streaming Videostream

```{image} https://assets.holoviz.org/panel/gallery/streaming_videostream.png
:target: https://|gallery-endpoint|.pyviz.demo.anaconda.com/streaming_videostream
:width: 100%
```

Applying face detection and other image transforms on your webcam input using scikit-image.
+++
[See source](streaming_videostream)
:::

:::{grid-item-card} Windturbines Explorer

```{image} https://assets.holoviz.org/panel/gallery/windturbines.png
:target: https://|gallery-endpoint|.pyviz.demo.anaconda.com/windturbines
:width: 100%
```

Visually explore a dataset of US Windturbines.
+++
[See source](windturbines)
:::

:::{grid-item-card} Portfolio Analyzer

```{image} https://assets.holoviz.org/panel/gallery/portfolio_analyzer.png
:target: https://|gallery-endpoint|.pyviz.demo.anaconda.com/portfolio_analyzer
:width: 100%
```

Analyze a stock portfolio using Plotly and Tabulator components.
+++
[See source](portfolio_analyzer)
:::

:::{grid-item-card} OGGM Glaciers

```{image} https://assets.holoviz.org/panel/gallery/glaciers.png
:target: https://|gallery-endpoint|.pyviz.demo.anaconda.com/glaciers
:width: 100%
```

Visually explore the worlds glaciers in this application built in collaboration with OGGM.
+++
[See source](glaciers)
:::

:::{grid-item-card} VTK Slicer

```{image} https://assets.holoviz.org/panel/gallery/vtk_slicer.png
:target: https://|gallery-endpoint|.pyviz.demo.anaconda.com/vtk_slicer
:width: 100%
```

Visualizing MRI brain scans and their cross-sections using a VTK volume and linked 2D slices.
+++
[See source](vtk_slicer)
:::

:::{grid-item-card} Deck.GL: NYC Taxi

```{image} https://assets.holoviz.org/panel/gallery/nyc_deckgl.png
:target: https://|gallery-endpoint|.pyviz.demo.anaconda.com/nyc_deckgl
:width: 100%
```

NYC Taxi trips visualized and animated using Deck.GL.
+++
[See source](nyc_deckgl)
:::

:::{grid-item-card} Gapminders

```{image} https://assets.holoviz.org/panel/gallery/gapminders.png
:target: https://|gallery-endpoint|.pyviz.demo.anaconda.com/gapminders
:width: 100%
```

Visualizing the Gapminders data using the most common Python plotting libraries.
+++
[See source](gapminders)
:::

:::{grid-item-card} VTK: St. Helens

```{image} https://assets.holoviz.org/panel/gallery/vtk_interactive.png
:target: https://|gallery-endpoint|.pyviz.demo.anaconda.com/vtk_interactive
:width: 100%
```

Visualizing the surface of Mount St. Helens using VTK and linked widgets to control the rendering.
+++
[See source](vtk_interactive)
:::

:::{grid-item-card} Penguin Crossfiltering

```{image} https://assets.holoviz.org/panel/gallery/penguin_crossfilter.png
:target: https://|gallery-endpoint|.pyviz.demo.anaconda.com/penguin_crossfilter
:width: 100%
```

Palmer Penguins data visualized using a set of linked cross-filtering plots.
+++
[See source](penguin_crossfilter)
:::

:::{grid-item-card} Deck.GL: Game of Life

```{image} https://assets.holoviz.org/panel/gallery/deckgl_game_of_life.png
:target: https://|gallery-endpoint|.pyviz.demo.anaconda.com/deckgl_game_of_life
:width: 100%
```

Game of Life simulation rendered on a 3D plane using Deck.gl.
+++
[See source](deckgl_game_of_life)
:::

:::{grid-item-card} hvPlot Explorer

```{image} https://assets.holoviz.org/panel/gallery/hvplot_explorer.png
:target: https://|gallery-endpoint|.pyviz.demo.anaconda.com/hvplot_explorer
:width: 100%
```

Use the hvPlot explorer to interactive visualize your dataset.
+++
[See source](penguin_crossfilter)
:::

:::{grid-item-card} Iris KMeans Clustering

```{image} https://assets.holoviz.org/panel/gallery/iris_kmeans.png
:target: https://|gallery-endpoint|.pyviz.demo.anaconda.com/iris_kmeans
:width: 100%
```

Interactively apply KMeans clustering on the Iris dataset.
+++
[See source](iris_kmeans)
:::

:::{grid-item-card} XGBoost Classifier

```{image} https://assets.holoviz.org/panel/gallery/xgboost_classifier.png
:target: https://|gallery-endpoint|.pyviz.demo.anaconda.com/xgboost_classifier
:width: 100%
```

Interactively apply a XGBoost classifier on the Iris dataset.
+++
[See source](xgboost_classifier)
:::

:::{grid-item-card} Altair Brushing

```{image} https://assets.holoviz.org/panel/gallery/altair_brushing.png
:target: https://|gallery-endpoint|.pyviz.demo.anaconda.com/altair_brushing
:width: 100%
```

Try interactive brushing on an Altair plot linked with a table.
+++
[See source](altair_brushing)
:::

::::

## HoloViz Topics

Examples of Panel applications maintained by the [HoloViz](https://holoviz.org/) project.

::::{grid} 1 2 2 3
:gutter: 1 1 1 2

:::{grid-item-card} Panel Chat Examples
:img-top: https://assets.holoviz.org/panel/gallery/panel_chat_examples.png
:link: https://holoviz-topics.github.io/panel-chat-examples/
:link-type: url

A large selection of chat applications showcasing Panels chat components.
:::

::::

## Community Gallery

::::{grid} 1 2 2 3
:gutter: 1 1 1 2

:::{grid-item-card} awesome-panel.org
:img-top: https://assets.holoviz.org/panel/gallery/community/awesome-panel.png
:link: https://awesome-panel.org
:link-type: url

A great selection of applications and other resources showcasing various features of Panel.
:::

:::{grid-item-card} cuxfilter
:img-top: https://assets.holoviz.org/panel/gallery/community/cuxfilter.png
:link: https://github.com/rapidsai/cuxfilter
:link-type: url

cuxfilter ( ku-cross-filter ) is a RAPIDS framework to connect web visualizations to GPU accelerated crossfiltering which is built on top of Panel.
:::

:::{grid-item-card} AstronomicalAL
:img-top: https://assets.holoviz.org/panel/gallery/community/AstronomicAL.png
:link: https://github.com/grant-m-s/AstronomicAL
:link-type: url

An interactive dashboard for visualisation, integration and classification of data using Active Learning.
:::

:::{grid-item-card} PyHDX
:img-top: https://assets.holoviz.org/panel/gallery/community/pyhdx.png
:link: https://github.com/Jhsmit/PyHDX
:link-type: url

PyHDX is software to extract H/D exchange kinetics from HDX-MS data sets in terms of Gibbs free energy of exchange (ΔG) at the residue level.
:::

:::{grid-item-card} gluoNNet Aviation Tracking
:img-top: https://assets.holoviz.org/panel/gallery/community/gluoNNet.png
:link: http://gluonnet.com/portfolio/aviation-graphs/
:link-type: url

The gluoNNet aviation tracking application visualizes airplane positioning (ADS-B) data to track, analyse, and manage flight tracks, aircraft behaviour, and flight efficiency.
:::

::::

```{toctree}
:titlesonly:
:hidden:
:maxdepth: 1

altair_brushing
deckgl_game_of_life
gapminders
glaciers
hvplot_explorer
iris_kmeans
nyc_deckgl
penguin_crossfilter
penguin_kmeans
portfolio_analyzer
portfolio_optimizer
streaming_videostream
vtk_interactive
vtk_slicer
vtk_warp
windturbines
xgboost_classifier
```
