/*!
 * Copyright (c) 2012 - 2023, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  factory(root["Bokeh"], undefined);
})(this, function(Bokeh, version) {
  let define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" && (version != null ? Bokeh[version] : Bokeh);
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh " + version + ". You have to load it prior to loading plugins.");
    }
  })
({
"4e90918c0a": function _(e,s,t,o,a){o();const b=e("tslib").__importStar(e("25913cabc4"));t.Panel=b;(0,e("@bokehjs/base").register_models)(b)},
"25913cabc4": function _(e,a,t,o,c){o();const d=e("tslib");c("AcePlot",e("464e3dc85c").AcePlot),c("Audio",e("d8d3afec63").Audio),c("BrowserInfo",e("af84f1061d").BrowserInfo),c("Button",e("0e384ee9c4").Button),c("Card",e("eec4af24bc").Card),c("CheckboxButtonGroup",e("820473477c").CheckboxButtonGroup),c("Column",e("991bd33955").Column),c("CommManager",e("eca6f2cacb").CommManager),c("CustomSelect",e("e258e515be").CustomSelect),c("DataTabulator",e("1629ba0343").DataTabulator),c("DatetimePicker",e("5fd6501095").DatetimePicker),c("DeckGLPlot",e("19b5a68a40").DeckGLPlot),c("ECharts",e("44fa3f3649").ECharts),c("FileDownload",e("e6943b23b3").FileDownload),c("HTML",e("3db2e41978").HTML),c("IPyWidget",e("4dfd782539").IPyWidget),c("JSON",e("e954d48822").JSON),c("JSONEditor",e("3c56a75fcf").JSONEditor),c("KaTeX",e("001dfd2dde").KaTeX),c("Location",e("a85ed38ee9").Location),c("MathJax",e("ca760ebc92").MathJax),c("PDF",e("46cccf2270").PDF),c("Perspective",e("5f38562b04").Perspective),c("Player",e("bd5015f776").Player),c("PlotlyPlot",e("b6febc7d6f").PlotlyPlot),c("Progress",e("e6caa5bc95").Progress),c("QuillInput",e("283ee868b0").QuillInput),c("RadioButtonGroup",e("81e6ca704a").RadioButtonGroup),c("ReactiveHTML",e("0590cf2a27").ReactiveHTML),c("SingleSelect",e("665213fba5").SingleSelect),c("SpeechToText",e("7651136c44").SpeechToText),c("State",e("1bb5a1aca6").State),c("Tabs",e("8013e805da").Tabs),c("Terminal",e("4a0674b147").Terminal),c("TextAreaInput",e("59f46adc8c").TextAreaInput),c("TextToSpeech",e("a44f0bd49f").TextToSpeech),c("TooltipIcon",e("4c6dd3d1dc").TooltipIcon),c("TrendIndicator",e("c2c4524e04").TrendIndicator),c("VegaPlot",e("b396729d22").VegaPlot),c("Video",e("e6e8c94f32").Video),c("VideoStream",e("2dfabe6882").VideoStream),c("VizzuChart",e("dfe3c4a2a9").VizzuChart),d.__exportStar(e("c51f25e2a7"),t)},
"464e3dc85c": function _(e,t,i,o,n){var s;o();const a=e("@bokehjs/core/dom"),d=e("c64c1219c8");class h extends d.HTMLBoxView{initialize(){super.initialize(),this._container=(0,a.div)({id:"_"+Math.random().toString(36).substr(2,9),style:{width:"100%",height:"100%",zIndex:0}})}connect_signals(){super.connect_signals(),this.connect(this.model.properties.code.change,(()=>this._update_code_from_model())),this.connect(this.model.properties.theme.change,(()=>this._update_theme())),this.connect(this.model.properties.language.change,(()=>this._update_language())),this.connect(this.model.properties.filename.change,(()=>this._update_filename())),this.connect(this.model.properties.print_margin.change,(()=>this._update_print_margin())),this.connect(this.model.properties.annotations.change,(()=>this._add_annotations())),this.connect(this.model.properties.readonly.change,(()=>{this._editor.setReadOnly(this.model.readonly)}))}render(){super.render(),this._container!==this.shadow_el.childNodes[0]&&this.shadow_el.append(this._container),this._container.textContent=this.model.code,this._editor=ace.edit(this._container),this._editor.renderer.attachToShadowRoot(),this._langTools=ace.require("ace/ext/language_tools"),this._modelist=ace.require("ace/ext/modelist"),this._editor.setOptions({enableBasicAutocompletion:!0,enableSnippets:!0,fontFamily:"monospace"}),this._update_theme(),this._update_filename(),this._update_language(),this._editor.setReadOnly(this.model.readonly),this._editor.setShowPrintMargin(this.model.print_margin),this._editor.on("change",(()=>this._update_code_from_editor()))}_update_code_from_model(){this._editor&&this._editor.getValue()!=this.model.code&&this._editor.setValue(this.model.code)}_update_print_margin(){this._editor.setShowPrintMargin(this.model.print_margin)}_update_code_from_editor(){this._editor.getValue()!=this.model.code&&(this.model.code=this._editor.getValue())}_update_theme(){this._editor.setTheme(`ace/theme/${this.model.theme}`)}_update_filename(){if(this.model.filename){const e=this._modelist.getModeForPath(this.model.filename).mode;this.model.language=e.slice(9)}}_update_language(){null!=this.model.language&&this._editor.session.setMode(`ace/mode/${this.model.language}`)}_add_annotations(){this._editor.session.setAnnotations(this.model.annotations)}after_layout(){super.after_layout(),this._editor.resize()}}i.AcePlotView=h,h.__name__="AcePlotView";class r extends d.HTMLBox{constructor(e){super(e)}}i.AcePlot=r,s=r,r.__name__="AcePlot",r.__module__="panel.models.ace",s.prototype.default_view=h,s.define((({Any:e,Array:t,Boolean:i,String:o,Nullable:n})=>({code:[o,""],filename:[n(o),null],language:[o,""],theme:[o,"chrome"],annotations:[t(e),[]],readonly:[i,!1],print_margin:[i,!1]}))),s.override({height:300,width:300})},
"c64c1219c8": function _(e,t,i,s,h){s();const l=e("@bokehjs/core/dom"),a=e("@bokehjs/core/util/types"),n=e("@bokehjs/models/widgets/widget"),d=e("@bokehjs/models/layouts/layout_dom");class r extends n.WidgetView{async lazy_initialize(){await super.lazy_initialize(),"not_started"!=this.provider.status&&"loading"!=this.provider.status||this.provider.ready.connect((()=>{this.contains_tex_string(this.model.text)&&this.render()}))}watch_stylesheets(){this._initialized_stylesheets={};for(const e of this._applied_stylesheets){const t=e.el;t instanceof HTMLLinkElement&&(this._initialized_stylesheets[t.href]=!1,t.addEventListener("load",(()=>{this._initialized_stylesheets[t.href]=!0,Object.values(this._initialized_stylesheets).every(Boolean)&&this.style_redraw()})))}}style_redraw(){}has_math_disabled(){return this.model.disable_math||!this.contains_tex_string(this.model.text)}render(){super.render(),_(this.el,this.model),this.container=(0,l.div)(),_(this.container,this.model,!1),this.shadow_el.appendChild(this.container),"failed"!=this.provider.status&&"loaded"!=this.provider.status||(this._has_finished=!0)}}function _(e,t,i=!0){let s=null!=t.width?"fixed":"fit",h=null!=t.height?"fixed":"fit";const{sizing_mode:l,margin:n}=t;if(null!=l)if("fixed"==l)s=h="fixed";else if("stretch_both"==l)s=h="max";else if("stretch_width"==l)s="max";else if("stretch_height"==l)h="max";else switch(l){case"scale_width":s="max",h="min";break;case"scale_height":s="min",h="max";break;case"scale_both":s="max",h="max";break;default:throw new Error("unreachable")}let d,r;i?(0,a.isArray)(n)?4===n.length?(r=n[0]+n[2],d=n[1]+n[3]):(r=2*n[0],d=2*n[1]):null==n?r=d=0:d=r=2*n:r=d=0,"fixed"==s&&t.width?e.style.width=t.width+"px":"max"==s&&(e.style.width=d?`calc(100% - ${d}px)`:"100%"),null!=t.min_width&&(e.style.minWidth=t.min_width+"px"),null!=t.max_width&&(e.style.maxWidth=t.max_width+"px"),"fixed"==h&&t.height?e.style.height=t.height+"px":"max"==h&&(e.style.height=r?`calc(100% - ${r}px)`:"100%"),null!=t.min_height&&(e.style.minHeight=t.min_height+"px"),null!=t.max_width&&(e.style.maxHeight=t.max_height+"px")}i.PanelMarkupView=r,r.__name__="PanelMarkupView",i.set_size=_;class o extends d.LayoutDOMView{render(){super.render(),_(this.el,this.model)}watch_stylesheets(){this._initialized_stylesheets={};for(const e of this._applied_stylesheets){const t=e.el;t instanceof HTMLLinkElement&&(this._initialized_stylesheets[t.href]=!1,t.addEventListener("load",(()=>{this._initialized_stylesheets[t.href]=!0,Object.values(this._initialized_stylesheets).every(Boolean)&&this.style_redraw()})))}}style_redraw(){}get child_models(){return[]}}i.HTMLBoxView=o,o.__name__="HTMLBoxView";class c extends d.LayoutDOM{constructor(e){super(e)}}i.HTMLBox=c,c.__name__="HTMLBox"},
"d8d3afec63": function _(e,t,i,o,s){var l;o();const d=e("c64c1219c8");class u extends d.HTMLBoxView{initialize(){super.initialize(),this._blocked=!1,this._setting=!1,this._time=Date.now()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.loop.change,(()=>this.set_loop())),this.connect(this.model.properties.paused.change,(()=>this.set_paused())),this.connect(this.model.properties.time.change,(()=>this.set_time())),this.connect(this.model.properties.value.change,(()=>this.set_value())),this.connect(this.model.properties.volume.change,(()=>this.set_volume())),this.connect(this.model.properties.muted.change,(()=>this.set_muted())),this.connect(this.model.properties.autoplay.change,(()=>this.set_autoplay()))}render(){super.render(),this.audioEl=document.createElement("audio"),this.audioEl.controls=!0,this.audioEl.src=this.model.value,this.audioEl.currentTime=this.model.time,this.audioEl.loop=this.model.loop,this.audioEl.muted=this.model.muted,this.audioEl.autoplay=this.model.autoplay,null!=this.model.volume?this.audioEl.volume=this.model.volume/100:this.model.volume=100*this.audioEl.volume,this.audioEl.onpause=()=>this.model.paused=!0,this.audioEl.onplay=()=>this.model.paused=!1,this.audioEl.ontimeupdate=()=>this.update_time(this),this.audioEl.onvolumechange=()=>this.update_volume(this),this.shadow_el.appendChild(this.audioEl),this.model.paused||this.audioEl.play()}update_time(e){e._setting?e._setting=!1:Date.now()-e._time<e.model.throttle||(e._blocked=!0,e.model.time=e.audioEl.currentTime,e._time=Date.now())}update_volume(e){e._setting?e._setting=!1:(e._blocked=!0,e.model.volume=100*e.audioEl.volume)}set_loop(){this.audioEl.loop=this.model.loop}set_muted(){this.audioEl.muted=this.model.muted}set_autoplay(){this.audioEl.autoplay=this.model.autoplay}set_paused(){!this.audioEl.paused&&this.model.paused&&this.audioEl.pause(),this.audioEl.paused&&!this.model.paused&&this.audioEl.play()}set_volume(){this._blocked?this._blocked=!1:(this._setting=!0,null!=this.model.volume&&(this.audioEl.volume=this.model.volume/100))}set_time(){this._blocked?this._blocked=!1:(this._setting=!0,this.audioEl.currentTime=this.model.time)}set_value(){this.audioEl.src=this.model.value}}i.AudioView=u,u.__name__="AudioView";class a extends d.HTMLBox{constructor(e){super(e)}}i.Audio=a,l=a,a.__name__="Audio",a.__module__="panel.models.widgets",l.prototype.default_view=u,l.define((({Any:e,Boolean:t,Number:i,Nullable:o})=>({loop:[t,!1],paused:[t,!0],muted:[t,!1],autoplay:[t,!1],time:[i,0],throttle:[i,250],value:[e,""],volume:[o(i),null]})))},
"af84f1061d": function _(e,i,o,n,l){var t;n();const s=e("@bokehjs/core/view"),a=e("@bokehjs/model");class r extends s.View{initialize(){super.initialize(),null!=window.matchMedia&&(this.model.dark_mode=window.matchMedia("(prefers-color-scheme: dark)").matches),this.model.device_pixel_ratio=window.devicePixelRatio,null!=navigator&&(this.model.language=navigator.language,this.model.webdriver=navigator.webdriver);const e=Intl.DateTimeFormat().resolvedOptions().timeZone;null!=e&&(this.model.timezone=e);const i=(new Date).getTimezoneOffset();null!=i&&(this.model.timezone_offset=i),this._has_finished=!0,this.notify_finished()}}o.BrowserInfoView=r,r.__name__="BrowserInfoView";class d extends a.Model{constructor(e){super(e)}}o.BrowserInfo=d,t=d,d.__name__="BrowserInfo",d.__module__="panel.models.browser",t.prototype.default_view=r,t.define((({Boolean:e,Nullable:i,Number:o,String:n})=>({dark_mode:[i(e),null],device_pixel_ratio:[i(o),null],language:[i(n),null],timezone:[i(n),null],timezone_offset:[i(o),null],webdriver:[i(e),null]})))},
"0e384ee9c4": function _(e,t,o,i,l){var s;i();const n=e("@bokehjs/models/ui/tooltip"),u=e("@bokehjs/core/build_views"),d=e("@bokehjs/models/widgets/button");class r extends d.ButtonView{*children(){yield*super.children(),null!=this.tooltip&&(yield this.tooltip)}async lazy_initialize(){await super.lazy_initialize();const{tooltip:e}=this.model;null!=e&&(this.tooltip=await(0,u.build_view)(e,{parent:this}))}remove(){var e;null===(e=this.tooltip)||void 0===e||e.remove(),super.remove()}render(){super.render();const e=e=>{var t;null===(t=this.tooltip)||void 0===t||t.model.setv({visible:e})};let t;this.el.addEventListener("mouseenter",(()=>{t=setTimeout((()=>e(!0)),this.model.tooltip_delay)})),this.el.addEventListener("mouseleave",(()=>{clearTimeout(t),e(!1)}))}}o.ButtonView=r,r.__name__="ButtonView";class a extends d.Button{constructor(e){super(e)}}o.Button=a,s=a,a.__name__="Button",a.__module__="panel.models.widgets",s.prototype.default_view=r,s.define((({Nullable:e,Ref:t,Number:o})=>({tooltip:[e(t(n.Tooltip)),null],tooltip_delay:[o,500]})))},
"eec4af24bc": function _(e,l,s,t,o){t();const a=e("tslib");var d;const i=e("991bd33955"),h=a.__importStar(e("@bokehjs/core/dom"));class n extends i.ColumnView{constructor(){super(...arguments),this.collapsed_style=new h.InlineStyleSheet}connect_signals(){super.connect_signals();const{active_header_background:e,children:l,collapsed:s,header_background:t,header_color:o,hide_header:a}=this.model.properties;this.on_change(l,(()=>this.render())),this.on_change(s,(()=>this._collapse())),this.on_change([o,a],(()=>this.render())),this.on_change([e,s,t],(()=>{const e=this.header_background;null!=e&&(this.child_views[0].el.style.backgroundColor=e,this.header_el.style.backgroundColor=e)}))}*_stylesheets(){yield*super._stylesheets(),yield this.collapsed_style}get header_background(){let e=this.model.header_background;return!this.model.collapsed&&this.model.active_header_background&&(e=this.model.active_header_background),e}render(){this.empty(),this.model.collapsed&&this.collapsed_style.replace(":host",{height:"fit-content",flex:"none"}),this._update_stylesheets(),this._update_css_classes(),this._apply_styles(),this._apply_visible(),this.class_list.add(...this.css_classes());const{button_css_classes:e,header_color:l,header_tag:s,header_css_classes:t}=this.model,o=this.header_background,a=this.child_views[0];let d;if(this.model.collapsible){this.button_el=h.createElement("button",{type:"button",class:t});const l=h.createElement("div",{class:e});l.innerHTML=this.model.collapsed?"\u25ba":"\u25bc",this.button_el.appendChild(l),this.button_el.style.backgroundColor=null!=o?o:"",a.el.style.backgroundColor=null!=o?o:"",this.button_el.appendChild(a.el),this.button_el.onclick=()=>this._toggle_button(),d=this.button_el}else d=h.createElement(s,{class:t}),d.style.backgroundColor=null!=o?o:"",d.appendChild(a.el);if(this.header_el=d,this.model.hide_header||(d.style.color=null!=l?l:"",this.shadow_el.appendChild(d),a.render(),a.after_render()),!this.model.collapsed)for(const e of this.child_views.slice(1))this.shadow_el.appendChild(e.el),e.render(),e.after_render()}async update_children(){await this.build_child_views(),this.render(),this.invalidate_layout()}_toggle_button(){this.model.collapsed=!this.model.collapsed}_collapse(){for(const e of this.child_views.slice(1))this.model.collapsed?(this.shadow_el.removeChild(e.el),e.model.visible=!1):(e.render(),e.after_render(),this.shadow_el.appendChild(e.el),e.model.visible=!0);this.model.collapsed?this.collapsed_style.replace(":host",{height:"fit-content",flex:"none"}):this.collapsed_style.clear(),this.button_el.children[0].innerHTML=this.model.collapsed?"\u25ba":"\u25bc",this.invalidate_layout()}_createElement(){return h.createElement(this.model.tag,{class:this.css_classes()})}}s.CardView=n,n.__name__="CardView";class r extends i.Column{constructor(e){super(e)}}s.Card=r,d=r,r.__name__="Card",r.__module__="panel.models.layout",d.prototype.default_view=n,d.define((({Array:e,Boolean:l,Nullable:s,String:t})=>({active_header_background:[s(t),null],button_css_classes:[e(t),[]],collapsed:[l,!0],collapsible:[l,!0],header_background:[s(t),null],header_color:[s(t),null],header_css_classes:[e(t),[]],header_tag:[t,"div"],hide_header:[l,!1],tag:[t,"div"]})))},
"991bd33955": function _(t,o,l,s,e){s();const i=t("tslib");var _;const r=t("@bokehjs/models/layouts/column"),n=i.__importStar(t("@bokehjs/core/dom"));class c extends r.ColumnView{connect_signals(){super.connect_signals();const{children:t,scroll_position:o,scroll_button_threshold:l}=this.model.properties;this.on_change(t,(()=>this.trigger_auto_scroll())),this.on_change(o,(()=>this.scroll_to_position())),this.on_change(l,(()=>this.toggle_scroll_button()))}get distance_from_latest(){return this.el.scrollHeight-this.el.scrollTop-this.el.clientHeight}scroll_to_position(){requestAnimationFrame((()=>{this.el.scrollTo({top:this.model.scroll_position})}))}scroll_to_latest(){requestAnimationFrame((()=>{this.el.scrollTo({top:this.el.scrollHeight})}))}trigger_auto_scroll(){const t=this.model.auto_scroll_limit,o=this.distance_from_latest<=t;0!=t&&o&&this.scroll_to_latest()}record_scroll_position(){this.model.scroll_position=Math.round(this.el.scrollTop)}toggle_scroll_button(){const t=this.model.scroll_button_threshold,o=this.distance_from_latest>=t;this.scroll_down_button_el&&this.scroll_down_button_el.classList.toggle("visible",0!==t&&o)}render(){super.render(),this.scroll_down_button_el=n.createElement("div",{class:"scroll-button"}),this.shadow_el.appendChild(this.scroll_down_button_el),this.el.addEventListener("scroll",(()=>{this.record_scroll_position(),this.toggle_scroll_button()})),this.scroll_down_button_el.addEventListener("click",(()=>{this.scroll_to_latest()}))}after_render(){super.after_render(),requestAnimationFrame((()=>{this.model.scroll_position&&this.scroll_to_position(),this.model.view_latest&&this.scroll_to_latest(),this.toggle_scroll_button()}))}}l.ColumnView=c,c.__name__="ColumnView";class h extends r.Column{constructor(t){super(t)}}l.Column=h,_=h,h.__name__="Column",h.__module__="panel.models.layout",_.prototype.default_view=c,_.define((({Int:t,Boolean:o})=>({scroll_position:[t,0],auto_scroll_limit:[t,0],scroll_button_threshold:[t,0],view_latest:[o,!1]})))},
"820473477c": function _(e,t,o,i,l){var s;i();const n=e("@bokehjs/models/ui/tooltip"),u=e("@bokehjs/core/build_views"),r=e("@bokehjs/models/widgets/checkbox_button_group");class d extends r.CheckboxButtonGroupView{*children(){yield*super.children(),null!=this.tooltip&&(yield this.tooltip)}async lazy_initialize(){await super.lazy_initialize();const{tooltip:e}=this.model;null!=e&&(this.tooltip=await(0,u.build_view)(e,{parent:this}))}remove(){var e;null===(e=this.tooltip)||void 0===e||e.remove(),super.remove()}render(){super.render();const e=e=>{var t;null===(t=this.tooltip)||void 0===t||t.model.setv({visible:e})};let t;this.el.addEventListener("mouseenter",(()=>{t=setTimeout((()=>e(!0)),this.model.tooltip_delay)})),this.el.addEventListener("mouseleave",(()=>{clearTimeout(t),e(!1)}))}}o.CheckboxButtonGroupView=d,d.__name__="CheckboxButtonGroupView";class p extends r.CheckboxButtonGroup{constructor(e){super(e)}}o.CheckboxButtonGroup=p,s=p,p.__name__="CheckboxButtonGroup",p.__module__="panel.models.widgets",s.prototype.default_view=d,s.define((({Nullable:e,Ref:t,Number:o})=>({tooltip:[e(t(n.Tooltip)),null],tooltip_delay:[o,500]})))},
"eca6f2cacb": function _(e,t,s,n,i){var o;n();const c=e("@bokehjs/document"),l=e("@bokehjs/core/view"),_=e("@bokehjs/model"),h=e("@bokehjs/protocol/message"),r=e("@bokehjs/protocol/receiver");s.comm_settings={debounce:!0};class a extends l.View{}s.CommManagerView=a,a.__name__="CommManagerView";class d extends _.Model{constructor(e){super(e),this._document_listener=e=>this._document_changed(e)}initialize(){super.initialize(),this._receiver=new r.Receiver,this._event_buffer=[],this._blocked=!1,this._timeout=Date.now(),null!=window.PyViz&&window.PyViz.comm_manager?(this.ns=window.PyViz,this.ns.comm_manager.register_target(this.plot_id,this.comm_id,(e=>{for(const t of this.ns.shared_views.get(this.plot_id))t!==this&&t.msg_handler(e);try{this.msg_handler(e)}catch(e){console.error(e)}})),this._client_comm=this.ns.comm_manager.get_client_comm(this.plot_id,this.client_comm_id,(e=>this.on_ack(e))),null==this.ns.shared_views&&(this.ns.shared_views=new Map),this.ns.shared_views.has(this.plot_id)?this.ns.shared_views.get(this.plot_id).push(this):this.ns.shared_views.set(this.plot_id,[this])):console.log("Could not find comm manager on window.PyViz, ensure the extension is loaded.")}_doc_attached(){super._doc_attached(),null!=this.document&&this.document.on_change(this._document_listener)}_document_changed(e){e instanceof c.ModelChangedEvent&&!e.model.properties[e.attr].syncable||(this._event_buffer.push(e),s.comm_settings.debounce?(!this._blocked||Date.now()>this._timeout)&&(setTimeout((()=>this.process_events()),this.debounce),this._blocked=!0,this._timeout=Date.now()+this.timeout):this.process_events())}_extract_buffers(e,t){let s;if(e instanceof Array){s=[];for(const n of e)s.push(this._extract_buffers(n,t))}else if(e instanceof Object){s={};for(const n in e){if("buffer"===n&&e[n]instanceof ArrayBuffer){s={id:Object.keys(t).length},t.push(e[n]);break}s[n]=this._extract_buffers(e[n],t)}}else s=e;return s}process_events(){if(null==this.document||null==this._client_comm)return;const e=this.document.create_json_patch(this._event_buffer);this._event_buffer=[];const t=Object.assign({},h.Message.create("PATCH-DOC",{},e)),s=[];t.content=this._extract_buffers(t.content,s),this._client_comm.send(t,{},s);for(const t of this.ns.shared_views.get(this.plot_id))t!==this&&null!=t.document&&t.document.apply_json_patch(e,[],this.id)}disconnect_signals(){super.disconnect_signals(),this.ns.shared_views.shared_views.delete(this.plot_id)}on_ack(e){const t=e.metadata;this._event_buffer.length?(this._blocked=!0,this._timeout=Date.now()+this.timeout,this.process_events()):this._blocked=!1,"Ready"==t.msg_type&&t.content?console.log("Python callback returned following output:",t.content):"Error"==t.msg_type&&console.log("Python failed with the following traceback:",t.traceback)}msg_handler(e){const t=e.metadata,s=e.buffers,n=e.content.data,i=this.plot_id;if("Ready"==t.msg_type)t.content?console.log("Python callback returned following output:",t.content):"Error"==t.msg_type&&console.log("Python failed with the following traceback:",t.traceback);else if(null!=i){let e=null;if(i in this.ns.plot_index&&null!=this.ns.plot_index[i]?e=this.ns.plot_index[i]:void 0!==window.Bokeh&&i in window.Bokeh.index&&(e=window.Bokeh.index[i]),null==e)return;if(n.length)this._receiver.consume(n);else{if(!(null!=s&&s.length>0))return;this._receiver.consume(s[0].buffer)}const t=this._receiver.message;if(null!=t&&Object.keys(t.content).length>0&&null!=this.document){const e=t.content;this.document.apply_json_patch(e,t.buffers)}}}}s.CommManager=d,o=d,d.__name__="CommManager",d.__module__="panel.models.comm_manager",o.prototype.default_view=a,o.define((({Int:e,String:t,Nullable:s})=>({plot_id:[s(t),null],comm_id:[s(t),null],client_comm_id:[s(t),null],timeout:[e,5e3],debounce:[e,50]})))},
"e258e515be": function _(e,t,s,o,i){var l;o();const d=e("@bokehjs/models/widgets/selectbox");class n extends d.SelectView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.disabled_options.change,(()=>this._update_disabled_options()))}options_el(){let e=super.options_el();return e.forEach((e=>{this.model.disabled_options.includes(e.value)&&e.setAttribute("disabled","true")})),e}_update_disabled_options(){for(const e of this.input_el.options)this.model.disabled_options.includes(e.value)?e.setAttribute("disabled","true"):e.removeAttribute("disabled")}}s.CustomSelectView=n,n.__name__="CustomSelectView";class _ extends d.Select{constructor(e){super(e)}}s.CustomSelect=_,l=_,_.__name__="CustomSelect",_.__module__="panel.models.widgets",l.prototype.default_view=n,l.define((({Array:e,String:t})=>({disabled_options:[e(t),[]]})))},
"1629ba0343": function _(t,e,i,s,o){var l,n,a,r;s();const d=t("@bokehjs/core/dom"),h=t("@bokehjs/core/util/types"),c=t("@bokehjs/core/bokeh_events"),u=t("@bokehjs/core/dom"),m=t("@bokehjs/core/kinds"),g=t("@bokehjs/models/sources/column_data_source"),_=t("@bokehjs/models/widgets/tables"),f=t("99a25e6992"),p=t("eca6f2cacb"),b=t("4e27eda472"),w=t("c64c1219c8");class y extends c.ModelEvent{constructor(t,e,i){super(),this.column=t,this.row=e,this.pre=i}get event_values(){return{model:this.origin,column:this.column,row:this.row,pre:this.pre}}}i.TableEditEvent=y,l=y,y.__name__="TableEditEvent",l.prototype.event_name="table-edit";class v extends c.ModelEvent{constructor(t,e){super(),this.column=t,this.row=e}get event_values(){return{model:this.origin,column:this.column,row:this.row}}}i.CellClickEvent=v,n=v,v.__name__="CellClickEvent",n.prototype.event_name="cell-click";class x extends c.ModelEvent{constructor(t,e){super(),this.indices=t,this.selected=e}get event_values(){return{model:this.origin,indices:this.indices,selected:this.selected}}}function S(t,e,i){for(const s of i)if(s[t]==e)return s;return null}function C(t,e,i,s=0){const o={};if(0==t.length)return o;const l=i[s];for(const n of t){const t=C(n._children,e,i,s+1);for(const e in t)(0,h.isArray)(t[e])?n[e]=t[e].reduce(((t,e)=>t+e),0)/t[e].length:n[e]=t[e];for(const t of e.slice(1)){const e=n[t.field];if(t.field in o){const i=o[t.field];"min"===l?o[t.field]=Math.min(e,i):"max"===l?o[t.field]=Math.max(e,i):"sum"===l?o[t.field]=e+i:"mean"===l&&((0,h.isArray)(o[t.field])?o[t.field].push(e):o[t.field]=[i,e])}else o[t.field]=e}}return o}function T(t,e,i,s){const o=[],l=e[0].field;for(const s of t){const t=s[i[0]];let n=S(l,t,o);null==n&&(n={_children:[]},n[l]=t,o.push(n));let a=n;const r={};for(const t of i.slice(1)){a=S(l,s[t],a._children),null==a&&(a={_children:[]},a[l]=s[t],n._children.push(a)),r[t]=n;for(const t of e.slice(1))a[t.field]=s[t];n=a}for(const t of e.slice(1))a[t.field]=s[t.field]}const n=[];for(const t of i)n.push(t in s?s[t]:"sum");return C(o,e,n),o}i.SelectionEvent=x,a=x,x.__name__="SelectionEvent",a.prototype.event_name="selection-change";const M=function(t,e,i,s,o,l,n){let a;a=0;const r={zone:new window.luxon.IANAZone("UTC")};if(t="-9223372036854776"==String(t)?window.luxon.DateTime.fromISO("invalid"):window.luxon.DateTime.fromMillis(t,r),e="-9223372036854776"==String(e)?window.luxon.DateTime.fromISO("invalid"):window.luxon.DateTime.fromMillis(e,r),t.isValid){if(e.isValid)return t-e;a=1}else a=e.isValid?-1:0;return a*=-1,a},E=function(t,e,i,s){const o=t.getValue(),l={zone:new window.luxon.IANAZone("UTC")};let n;n="NaN"===o||null===o?null:window.luxon.DateTime.fromMillis(o,l).toFormat("yyyy-MM-dd");const a=document.createElement("input");function r(){const t=window.luxon.DateTime.fromFormat(a.value,"yyyy-MM-dd",l).toMillis();t!=n?i(t):s()}return a.setAttribute("type","date"),a.style.padding="4px",a.style.width="100%",a.style.boxSizing="border-box",a.value=n,e((()=>{a.focus(),a.style.height="100%"})),a.addEventListener("blur",r),a.addEventListener("keydown",(t=>{"Enter"==t.key&&setTimeout(r,100),"Escape"==t.key&&setTimeout(s,100)})),a},z=function(t,e,i,s){const o=t.getValue(),l={zone:new window.luxon.IANAZone("UTC")};let n;n="NaN"===o||null===o?null:window.luxon.DateTime.fromMillis(o,l).toFormat("yyyy-MM-dd'T'T");const a=document.createElement("input");function r(){const t=window.luxon.DateTime.fromFormat(a.value,"yyyy-MM-dd'T'T",l).toMillis();t!=n?i(t):s()}return a.setAttribute("type","datetime-local"),a.style.padding="4px",a.style.width="100%",a.style.boxSizing="border-box",a.value=n,e((()=>{a.focus(),a.style.height="100%"})),a.addEventListener("blur",r),a.addEventListener("keydown",(t=>{"Enter"==t.key&&setTimeout(r,100),"Escape"==t.key&&setTimeout(s,100)})),a};class k extends w.HTMLBoxView{constructor(){super(...arguments),this.columns=new Map,this._tabulator_cell_updating=!1,this._updating_page=!1,this._updating_sort=!1,this._selection_updating=!1,this._lastVerticalScrollbarTopPosition=0,this._applied_styles=!1,this._building=!1}connect_signals(){super.connect_signals();const t=this.model.properties,{configuration:e,layout:i,columns:s,groupby:o}=t;this.on_change([e,i,o],(0,f.debounce)((()=>{this.invalidate_render()}),20,!1)),this.connect(this.model.properties.visible.change,(()=>{this.model.visible&&(this.tabulator.element.style.visibility="visible")})),this.on_change([s],(()=>{this.tabulator.setColumns(this.getColumns()),this.setHidden()})),this.connect(t.download.change,(()=>{const t=this.model.filename.endsWith(".json")?"json":"csv";this.tabulator.download(t,this.model.filename)})),this.connect(t.children.change,(()=>this.renderChildren())),this.connect(t.expanded.change,(()=>{for(const t of this.tabulator.rowManager.getRows())t.cells.length>0&&t.cells[0].layoutElement();for(const t of this.tabulator.rowManager.getRows())if(t.cells.length>0){const e=t.data._index,i=this.model.expanded.indexOf(e)<0?"\u25ba":"\u25bc";t.cells[1].element.innerText=i}})),this.connect(t.cell_styles.change,(()=>{this._applied_styles&&this.tabulator.redraw(!0),this.setStyles()})),this.connect(t.hidden_columns.change,(()=>{this.setHidden(),this.tabulator.redraw(!0)})),this.connect(t.page_size.change,(()=>this.setPageSize())),this.connect(t.page.change,(()=>{this._updating_page||this.setPage()})),this.connect(t.visible.change,(()=>this.setVisibility())),this.connect(t.max_page.change,(()=>this.setMaxPage())),this.connect(t.frozen_rows.change,(()=>this.setFrozen())),this.connect(t.sorters.change,(()=>this.setSorters())),this.connect(t.theme_classes.change,(()=>this.setCSSClasses(this.tabulator.element))),this.connect(this.model.source.properties.data.change,(()=>{this._selection_updating=!0,this.setData(),this._selection_updating=!1,this.postUpdate()})),this.connect(this.model.source.streaming,(()=>this.addData())),this.connect(this.model.source.patching,(()=>{const t=this.model.source.selected.indices;this.updateOrAddData(),this.tabulator.rowManager.element.scrollTop=this._lastVerticalScrollbarTopPosition,this.model.source.selected.indices=t})),this.connect(this.model.source.selected.change,(()=>this.setSelection())),this.connect(this.model.source.selected.properties.indices.change,(()=>this.setSelection()))}get groupBy(){return!!this.model.groupby.length&&(t=>{const e=[];for(const i of this.model.groupby){const s=i+": "+t[i];e.push(s)}return e.join(", ")})}get sorters(){const t=[];this.model.sorters.length&&t.push({column:"_index",dir:"asc"});for(const e of this.model.sorters.reverse())void 0===e.column&&(e.column=e.field),t.push(e);return t}invalidate_render(){this.tabulator.destroy(),this.tabulator=null,this.render()}redraw(){this._building||(null!=this.tabulator.columnManager.element&&this.tabulator.columnManager.redraw(!0),null!=this.tabulator.rowManager.renderer&&(this.tabulator.rowManager.redraw(!0),this.renderChildren(),this.setStyles()))}after_layout(){super.after_layout(),null!=this.tabulator&&this._initializing&&this.redraw(),this._initializing=!1}setCSSClasses(t){t.className="pnx-tabulator tabulator";for(const e of this.model.theme_classes)t.classList.add(e)}render(){null!=this.tabulator&&this.tabulator.destroy(),super.render(),this._initializing=!0;const t=(0,u.div)({style:"display: contents;"}),e=(0,u.div)({style:"width: 100%; height: 100%; visibility: hidden;"});this.setCSSClasses(e),t.appendChild(e),this.shadow_el.appendChild(t);let i=this.getConfiguration();this.tabulator=new Tabulator(e,i),this.watch_stylesheets(),this.init_callbacks()}style_redraw(){this.model.visible&&(this.tabulator.element.style.visibility="visible"),this._initializing||this._building||this.redraw()}tableInit(){this._building=!0;this.tabulator.modules.ajax.sendRequest=(t,e,i)=>this.requestPage(e.page,e.sort),this.tabulator.modules.page._parseRemoteData=()=>!1}init_callbacks(){this.tabulator.on("tableBuilding",(()=>this.tableInit())),this.tabulator.on("tableBuilt",(()=>this.tableBuilt())),this.tabulator.on("selectableCheck",(t=>{const e=this.model.selectable_rows;return null==e||e.includes(t._row.data._index)})),this.tabulator.on("tooltips",(t=>t.getColumn().getField()+": "+t.getValue())),this.tabulator.on("scrollVertical",(0,f.debounce)((()=>{this.setStyles()}),50,!1)),this.tabulator.on("rowSelectionChanged",((t,e,i,s)=>this.rowSelectionChanged(t,e,i,s))),this.tabulator.on("rowClick",((t,e)=>this.rowClicked(t,e))),this.tabulator.on("cellEdited",(t=>this.cellEdited(t))),this.tabulator.on("dataFiltering",(t=>{this.model.filters=t})),this.tabulator.on("dataFiltered",((t,e)=>{this._building||(0===e.length&&this.tabulator.rowManager.renderEmptyScroll(),this.updatePage(this.tabulator.getPage()))})),this.tabulator.on("pageLoaded",(t=>{this.updatePage(t)})),this.tabulator.on("renderComplete",(()=>{this._building||this.postUpdate()})),this.tabulator.on("dataSorting",(t=>{const e=[];for(const i of t)"_index"!==i.field&&e.push({field:i.field,dir:i.dir});"remote"!==this.model.pagination&&(this._updating_sort=!0,this.model.sorters=e,this._updating_sort=!1)}))}tableBuilt(){this._building=!1,this.setSelection(),this.renderChildren(),this.setStyles(),this.model.pagination&&(this.setMaxPage(),this.tabulator.setPage(this.model.page))}requestPage(t,e){return new Promise(((i,s)=>{try{if(null!=t&&null!=e){this._updating_sort=!0;const i=[];for(const t of e)"_index"!==t.field&&i.push({field:t.field,dir:t.dir});this.model.sorters=i,this._updating_sort=!1,this._updating_page=!0;try{this.model.page=t||1}finally{this._updating_page=!1}}i([])}catch(t){s(t)}}))}getLayout(){switch(this.model.layout){case"fit_data":return"fitData";case"fit_data_fill":return"fitDataFill";case"fit_data_stretch":return"fitDataStretch";case"fit_data_table":return"fitDataTable";case"fit_columns":return"fitColumns"}}getConfiguration(){let t="toggle"===this.model.select_mode||NaN,e=Object.assign(Object.assign({},this.model.configuration),{index:"_index",nestedFieldSeparator:!1,movableColumns:!1,selectable:t,columns:this.getColumns(),initialSort:this.sorters,layout:this.getLayout(),pagination:null!=this.model.pagination,paginationMode:this.model.pagination,paginationSize:this.model.page_size,paginationInitialPage:1,groupBy:this.groupBy,rowFormatter:t=>this._render_row(t),frozenRows:t=>!!this.model.frozen_rows.length&&this.model.frozen_rows.includes(t._row.data._index)});"remote"===this.model.pagination&&(e.ajaxURL="http://panel.pyviz.org",e.sortMode="remote");const i=this.model.source;let s;return s=null===i||0===i.columns().length?[]:(0,b.transform_cds_to_records)(i,!0),e.dataTree&&(s=T(s,this.model.columns,this.model.indexes,this.model.aggregators)),Object.assign(Object.assign({},e),{data:s})}get child_models(){var t,e;const i=[];for(const s of this.model.expanded){const o=null===(e=(t=this.model.children).get)||void 0===e?void 0:e.call(t,s);null!=o&&i.push(o)}return i}renderChildren(){new Promise((async t=>{await this.build_child_views(),t(null)})).then((()=>{for(const t of this.model.expanded){const e=this.tabulator.getRow(t);this._render_row(e,!1)}this._update_children(),null!=this.tabulator.rowManager.renderer&&this.tabulator.rowManager.adjustTableSize(),this.invalidate_layout()}))}_render_row(t,e=!0){var i;const s=null===(i=t._row)||void 0===i?void 0:i.data._index;if(!this.model.expanded.includes(s)||null==this.model.children.get(s))return;const o=this.model.children.get(s),l=null==o?null:this._child_views.get(o);if(null==l)return;const n=t.getElement(),a=getComputedStyle(this.tabulator.element.children[1].children[0]).backgroundColor,r=n.style.paddingLeft?"-"+n.style.paddingLeft:"0",d=(0,u.div)({style:"background-color: "+a+"; margin-left:"+r+"; max-width: 100%; overflow-x: hidden;"});d.appendChild(l.el),n.appendChild(d),l.has_finished()||(l.render(),l.after_render()),e&&(this._update_children(),this.tabulator.rowManager.adjustTableSize(),this.invalidate_layout())}_expand_render(t){const e=t._cell.row.data._index;return"<i>"+(this.model.expanded.indexOf(e)<0?"\u25ba":"\u25bc")+"</i>"}_update_expand(t){var e,i,s,o;const l=t._cell.row.data._index,n=[...this.model.expanded],a=n.indexOf(l);if(a<0)n.push(l);else{const t=n.splice(a,1)[0],s=null===(i=(e=this.model.children).get)||void 0===i?void 0:i.call(e,t);if(null!=s){const t=this._child_views.get(s);void 0!==t&&null!=t.el&&(0,d.undisplay)(t.el)}}if(this.model.expanded=n,n.indexOf(l)<0)return;let r=!0;for(const t of this.model.expanded)if(null==(null===(o=(s=this.model.children).get)||void 0===o?void 0:o.call(s,t))){r=!1;break}r&&this.renderChildren()}getData(){let t=(0,b.transform_cds_to_records)(this.model.source,!0);return this.model.configuration.dataTree&&(t=T(t,this.model.columns,this.model.indexes,this.model.aggregators)),t}getColumns(){var t;this.columns=new Map;const e=null===(t=this.model.configuration)||void 0===t?void 0:t.columns;let i=[];if(i.push({field:"_index",frozen:!0,visible:!1}),null!=e)for(const t of e)if(null!=t.columns){const e=[];for(const i of t.columns)e.push(Object.assign({},i));i.push(Object.assign(Object.assign({},t),{columns:e}))}else if("expand"===t.formatter){const t={hozAlign:"center",cellClick:(t,e)=>{this._update_expand(e)},formatter:t=>this._expand_render(t),width:40,frozen:!0};i.push(t)}else{const e=Object.assign({},t);"rowSelection"===e.formatter&&(e.cellClick=(t,e)=>{e.getRow().toggleSelect()}),i.push(e)}for(const t of this.model.columns){let s=null;if(null!=e)for(const e of i)if(null!=e.columns){for(const i of e.columns)if(t.field===i.field){s=i;break}if(null!=s)break}else if(t.field===e.field){s=e;break}if(null==s&&(s={field:t.field}),this.columns.set(t.field,s),null==s.title&&(s.title=t.title),null==s.width&&null!=t.width&&0!=t.width&&(s.width=t.width),null==s.formatter&&null!=t.formatter){const e=t.formatter.type;s.formatter="BooleanFormatter"===e?"tickCross":e=>{const i=t.formatter.doFormat(e.getRow(),e,e.getValue(),null,null);if("HTMLTemplateFormatter"===t.formatter.type)return i;const s=(0,u.div)();s.innerHTML=i;const o=s.children[0];return"function(){return c.convert(arguments)}"===o.innerHTML?"":o}}"timestamp"==s.sorter&&(s.sorter=M),void 0===s.sorter&&(s.sorter="string");const o=t.editor,l=o.type;null!=s.editor?"date"===s.editor?s.editor=E:"datetime"===s.editor&&(s.editor=z):"StringEditor"===l?o.completions.length>0?(s.editor="list",s.editorParams={values:o.completions,autocomplete:!0,listOnEmpty:!0}):s.editor="input":"TextEditor"===l?s.editor="textarea":"IntEditor"===l||"NumberEditor"===l?(s.editor="number",s.editorParams={step:o.step},s.validator="IntEditor"===l?"integer":"numeric"):"CheckboxEditor"===l?s.editor="tickCross":"DateEditor"===l?s.editor=E:"SelectEditor"===l?(s.editor="list",s.editorParams={values:o.options}):null!=o&&null!=o.default_view&&(s.editor=(e,i,s,o)=>{this.renderEditor(t,e,i,s,o)}),s.visible=0!=s.visible&&!this.model.hidden_columns.includes(t.field),s.editable=()=>this.model.editable&&null!=o.default_view,s.headerFilter&&"boolean"==typeof s.headerFilter&&"string"==typeof s.editor&&(s.headerFilter=s.editor,s.headerFilterParams=s.editorParams);for(const t of this.model.sorters)s.field===t.field&&(s.headerSortStartingDir=t.dir);s.cellClick=(e,i)=>{const s=i.getData()._index,o=new v(t.field,s);this.model.trigger_event(o)},null==e&&i.push(s)}for(const t in this.model.buttons){const e={formatter:()=>this.model.buttons[t],hozAlign:"center",cellClick:(e,i)=>{const s=i.getData()._index,o=new v(t,s);this.model.trigger_event(o)}};i.push(e)}return i}renderEditor(t,e,i,s,o){const l=t.editor,n=new l.default_view({column:t,model:l,parent:this,container:e._cell.element});return n.initialize(),n.connect_signals(),i((()=>{n.setValue(e.getValue())})),n.inputEl.addEventListener("input",(()=>{const t=n.serializeValue(),i=e.getValue(),l=n.validate();l.valid||o(l.msg),null!=i&&typeof t!=typeof i?o("Mismatching type"):s(n.serializeValue())})),n.inputEl}setData(){if(this._initializing||this._building||!this.tabulator.initialized)return;const t=this.getData();null!=this.model.pagination?this.tabulator.rowManager.setData(t,!0,!1):this.tabulator.setData(t)}addData(){const t=this.tabulator.rowManager.getRows(),e=t[t.length-1],i=(null==e?void 0:e.data._index)||0;this.setData(),this.model.follow&&e&&this.tabulator.scrollToRow(i,"top",!1)}postUpdate(){this.setSelection(),this.setStyles()}updateOrAddData(){if(this._tabulator_cell_updating)return;const t=this.tabulator.element.style.minHeight;this.tabulator.element.style.minHeight=this.tabulator.element.offsetHeight+"px";let e=(0,b.transform_cds_to_records)(this.model.source,!0);this.tabulator.setData(e).then((()=>{this.tabulator.element.style.minHeight=t}))}setFrozen(){for(const t of this.model.frozen_rows)this.tabulator.getRow(t).freeze()}setVisibility(){null!=this.tabulator&&(this.tabulator.element.style.visibility=this.model.visible?"visible":"hidden")}updatePage(t){"local"===this.model.pagination&&this.model.page!==t&&(this._updating_page=!0,this.model.page=t,this._updating_page=!1,this.setStyles())}setGroupBy(){this.tabulator.setGroupBy(this.groupBy)}setSorters(){this._updating_sort||this.tabulator.setSort(this.sorters)}setStyles(){const t=this.model.cell_styles.data;if(null!=this.tabulator&&0!=this.tabulator.getDataCount()&&null!=t&&t.size){this._applied_styles=!1;for(const e of t.keys()){const i=t.get(e),s=this.tabulator.getRow(e);if(!s)continue;const o=s._row.cells;for(const t of i.keys()){const e=i.get(t),s=o[t];if(null==s||!e.length)continue;const l=s.element;for(const t of e){let e,i;if((0,h.isArray)(t))[e,i]=t;else{if(!t.includes(":"))continue;[e,i]=t.split(":")}l.style.setProperty(e,i.trimLeft()),this._applied_styles=!0}}}}}setHidden(){for(const t of this.tabulator.getColumns()){const e=t._column;"_index"==e.field||this.model.hidden_columns.includes(e.field)?t.hide():t.show()}}setMaxPage(){this.tabulator.setMaxPage(this.model.max_page),this.tabulator.modules.page.pagesElement&&this.tabulator.modules.page._setPageButtons()}setPage(){this.tabulator.setPage(Math.min(this.model.max_page,this.model.page)),"local"===this.model.pagination&&(this.renderChildren(),this.setStyles())}setPageSize(){this.tabulator.setPageSize(this.model.page_size),"local"===this.model.pagination&&(this.renderChildren(),this.setStyles())}setSelection(){if(null==this.tabulator||this._initializing||this._selection_updating||!this.tabulator.initialized)return;const t=this.model.source.selected.indices,e=this.tabulator.getSelectedData().map((t=>t._index));if(JSON.stringify(t)!=JSON.stringify(e)){this._selection_updating=!0,this.tabulator.deselectRow(),this.tabulator.selectRow(t);for(const e of t){this.tabulator.rowManager.findRow(e)&&this.tabulator.scrollToRow(e,"center",!1).catch((()=>{}))}this._selection_updating=!1}}rowClicked(t,e){var i;if(this._selection_updating||this._initializing||"string"==typeof this.model.select_mode||!1===this.model.select_mode||this.model.configuration.dataTree||"\u25ba"===(null===(i=t.srcElement)||void 0===i?void 0:i.innerText))return;let s=[];const o=this.model.source.selected,l=e._row.data._index;if(t.ctrlKey||t.metaKey)s=[...this.model.source.selected.indices];else if(t.shiftKey&&o.indices.length){const t=o.indices[o.indices.length-1];if(l>t)for(let e=t;e<l;e++)s.push(e);else for(let e=t;e>l;e--)s.push(e)}if(s.indexOf(l)<0?s.push(l):s.splice(s.indexOf(l),1),"number"==typeof this.model.select_mode)for(;s.length>this.model.select_mode;)s.shift();const n=this._filter_selected(s);this.tabulator.deselectRow(),this.tabulator.selectRow(n),this._selection_updating=!0,o.indices=n,this._selection_updating=!1}_filter_selected(t){const e=[];for(const i of t)(null==this.model.selectable_rows||this.model.selectable_rows.indexOf(i)>=0)&&e.push(i);return e}rowSelectionChanged(t,e,i,s){if(!(this._selection_updating||this._initializing||"boolean"==typeof this.model.select_mode||"number"==typeof this.model.select_mode||this.model.configuration.dataTree)){if("remote"===this.model.pagination){let t=i.map((t=>t._row.data._index)),e=s.map((t=>t._row.data._index));t.length>0&&(this._selection_updating=!0,this.model.trigger_event(new x(t,i=!0))),e.length>0&&(this._selection_updating=!0,this.model.trigger_event(new x(e,i=!1)))}else{const e=t.map((t=>t._index)),i=this._filter_selected(e);this._selection_updating=e.length===i.length,this.model.source.selected.indices=i}this._selection_updating=!1}}cellEdited(t){const e=t._cell.column.field,i=this.columns.get(e),s=t.getData()._index,o=t._cell.value;if("numeric"!==i.validator||""!==o){this._tabulator_cell_updating=!0,p.comm_settings.debounce=!1,this.model.trigger_event(new y(e,s,!0));try{this.model.source.patch({[e]:[[s,o]]})}finally{p.comm_settings.debounce=!0,this._tabulator_cell_updating=!1}this.model.trigger_event(new y(e,s,!1)),this.tabulator.scrollToRow(s,"top",!1)}else t.setValue(NaN,!0)}}i.DataTabulatorView=k,k.__name__="DataTabulatorView",i.TableLayout=(0,m.Enum)("fit_data","fit_data_fill","fit_data_stretch","fit_data_table","fit_columns");class D extends w.HTMLBox{constructor(t){super(t)}}i.DataTabulator=D,r=D,D.__name__="DataTabulator",D.__module__="panel.models.tabulator",r.prototype.default_view=k,r.define((({Any:t,Array:e,Boolean:s,Nullable:o,Number:l,Ref:n,String:a})=>({aggregators:[t,{}],buttons:[t,{}],children:[t,new Map],configuration:[t,{}],columns:[e(n(_.TableColumn)),[]],download:[s,!1],editable:[s,!0],expanded:[e(l),[]],filename:[a,"table.csv"],filters:[e(t),[]],follow:[s,!0],frozen_rows:[e(l),[]],groupby:[e(a),[]],hidden_columns:[e(a),[]],indexes:[e(a),[]],layout:[i.TableLayout,"fit_data"],max_page:[l,0],pagination:[o(a),null],page:[l,0],page_size:[l,0],select_mode:[t,!0],selectable_rows:[o(e(l)),null],source:[n(g.ColumnDataSource)],sorters:[e(t),[]],cell_styles:[t,{}],theme_classes:[e(a),[]]})))},
"99a25e6992": function _(n,l,u,t,e){function o(n,l,u){var t,e,o,a,r;function i(){var c=Date.now()-a;c<l&&c>=0?t=setTimeout(i,l-c):(t=null,u||(r=n.apply(o,e),o=e=null))}null==l&&(l=100);var c=function(){o=this,e=arguments,a=Date.now();var c=u&&!t;return t||(t=setTimeout(i,l)),c&&(r=n.apply(o,e),o=e=null),r};return c.clear=function(){t&&(clearTimeout(t),t=null)},c.flush=function(){t&&(r=n.apply(o,e),o=e=null,clearTimeout(t),t=null)},c}o.debounce=o,l.exports=o},
"4e27eda472": function _(n,e,t,l,o){l(),t.transform_cds_to_records=function(n,e=!1,t=0){const l=[],o=n.columns(),r=n.get_length();if(0===o.length||null===r)return[];for(let s=t;s<r;s++){const t={};for(const e of o){let l=n.get_array(e);const o=null==l[0]||null==l[0].shape?null:l[0].shape;if(null!=o&&o.length>1&&"number"==typeof o[0])t[e]=l.slice(s*o[1],s*o[1]+o[1]);else if(l.length!=r&&l.length%r==0){const n=l.length/r;t[e]=l.slice(s*n,s*n+n)}else t[e]=l[s]}e&&(t._index=s),l.push(t)}return l},t.dict_to_records=function(n,e=!0){for(let t=0;t<n.index.length;t++){const l={};for(const o of n)(e||"index"!==o)&&(l[o]=n[o][t])}return[]}},
"5fd6501095": function _(e,t,i,n,s){n();const o=e("tslib");var l;const a=o.__importDefault(e("1156ddcec2")),r=e("@bokehjs/models/widgets/input_widget"),d=e("@bokehjs/core/dom"),c=e("@bokehjs/core/enums"),h=e("@bokehjs/core/util/types"),u=o.__importStar(e("@bokehjs/styles/widgets/inputs.css")),m=o.__importDefault(e("@bokehjs/styles/widgets/flatpickr.css"));function _(e){const t=[];for(const i of e)if((0,h.isString)(i))t.push(i);else{const[e,n]=i;t.push({from:e,to:n})}return t}class p extends r.InputWidgetView{connect_signals(){super.connect_signals();const{value:e,min_date:t,max_date:i,disabled_dates:n,enabled_dates:s,inline:o,enable_time:l,enable_seconds:a,military_time:r,date_format:d,mode:c}=this.model.properties;this.connect(e.change,(()=>{var e;return this.model.value?null===(e=this._picker)||void 0===e?void 0:e.setDate(this.model.value):this._clear()})),this.connect(t.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("minDate",this.model.min_date)})),this.connect(i.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("maxDate",this.model.max_date)})),this.connect(n.change,(()=>{var e;const{disabled_dates:t}=this.model;null===(e=this._picker)||void 0===e||e.set("disable",null!=t?_(t):[])})),this.connect(s.change,(()=>{var e;const{enabled_dates:t}=this.model;null!=t?null===(e=this._picker)||void 0===e||e.set("enable",_(t)):this._picker&&(this._picker.config._enable=void 0,this._picker.redraw(),this._picker.updateValue(!0))})),this.connect(o.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("inline",this.model.inline)})),this.connect(l.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("enableTime",this.model.enable_time)})),this.connect(a.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("enableSeconds",this.model.enable_seconds)})),this.connect(r.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("time_24hr",this.model.military_time)})),this.connect(c.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("mode",this.model.mode)})),this.connect(d.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("dateFormat",this.model.date_format)}))}remove(){var e;null===(e=this._picker)||void 0===e||e.destroy(),super.remove()}stylesheets(){return[...super.stylesheets(),m.default]}render(){if(null!=this._picker)return;super.render(),this.input_el=(0,d.input)({type:"text",class:u.input,disabled:this.model.disabled}),this.group_el.appendChild(this.input_el);const e={appendTo:this.group_el,positionElement:this.input_el,defaultDate:this.model.value,inline:this.model.inline,position:this._position.bind(this),enableTime:this.model.enable_time,enableSeconds:this.model.enable_seconds,time_24hr:this.model.military_time,dateFormat:this.model.date_format,mode:this.model.mode,onClose:(e,t,i)=>this._on_close(e,t,i)},{min_date:t,max_date:i,disabled_dates:n,enabled_dates:s}=this.model;null!=t&&(e.minDate=t),null!=i&&(e.maxDate=i),null!=n&&(e.disable=_(n)),null!=s&&(e.enable=_(s)),this._picker=(0,a.default)(this.input_el,e),this._picker.maxDateHasTime=!0,this._picker.minDateHasTime=!0}_clear(){var e;null===(e=this._picker)||void 0===e||e.clear(),this.model.value=null}_on_close(e,t,i){("range"!=this.model.mode||t.includes("to"))&&(this.model.value=t,this.change_input())}_position(e,t){const i=null!=t?t:e._positionElement,n=[...e.calendarContainer.children].reduce(((e,t)=>e+(0,d.bounding_box)(t).height),0),s=e.calendarContainer.offsetWidth,o=this.model.position.split(" "),l=o[0],a=o.length>1?o[1]:null,r=i.offsetTop,c=i.offsetTop+i.offsetHeight,h=i.offsetLeft,u=i.offsetLeft+i.offsetWidth,m=i.offsetWidth,_=window.innerHeight-c,p="above"===l||"below"!==l&&_<n&&r>n,f=e.config.appendTo?r+(p?-n-2:i.offsetHeight+2):window.scrollY+r+(p?-n-2:i.offsetHeight+2);if(e.calendarContainer.classList.toggle("arrowTop",!p),e.calendarContainer.classList.toggle("arrowBottom",p),e.config.inline)return;let g=window.scrollX+h,v=!1,b=!1;"center"===a?(g-=(s-m)/2,v=!0):"right"===a&&(g-=s-m,b=!0),e.calendarContainer.classList.toggle("arrowLeft",!v&&!b),e.calendarContainer.classList.toggle("arrowCenter",v),e.calendarContainer.classList.toggle("arrowRight",b);const k=window.document.body.offsetWidth-(window.scrollX+u),w=g+s>window.document.body.offsetWidth,y=k+s>window.document.body.offsetWidth;if(e.calendarContainer.classList.toggle("rightMost",w),!e.config.static)if(e.calendarContainer.style.top=`${f}px`,w)if(y){const t=this.shadow_el.styleSheets[0],i=window.document.body.offsetWidth,n=Math.max(0,i/2-s/2),o=".flatpickr-calendar.centerMost:before",l=".flatpickr-calendar.centerMost:after",a=t.cssRules.length,r=`{left:${h}px;right:auto;}`;e.calendarContainer.classList.toggle("rightMost",!1),e.calendarContainer.classList.toggle("centerMost",!0),t.insertRule(`${o},${l}${r}`,a),e.calendarContainer.style.left=`${n}px`,e.calendarContainer.style.right="auto"}else e.calendarContainer.style.left="auto",e.calendarContainer.style.right=`${k}px`;else e.calendarContainer.style.left=`${g}px`,e.calendarContainer.style.right="auto"}}i.DatetimePickerView=p,p.__name__="DatetimePickerView";class f extends r.InputWidget{constructor(e){super(e)}}i.DatetimePicker=f,l=f,f.__name__="DatetimePicker",f.__module__="panel.models.datetime_picker",l.prototype.default_view=p,l.define((({Boolean:e,String:t,Array:i,Tuple:n,Or:s,Nullable:o})=>{const l=i(s(t,n(t,t)));return{value:[o(t),null],min_date:[o(t),null],max_date:[o(t),null],disabled_dates:[o(l),null],enabled_dates:[o(l),null],position:[c.CalendarPosition,"auto"],inline:[e,!1],enable_time:[e,!0],enable_seconds:[e,!0],military_time:[e,!0],date_format:[t,"Y-m-d H:i:S"],mode:[t,"single"]}}))},
"1156ddcec2": function _(e,t,n,a,i){a();const o=e("tslib");var r=this&&this.__assign||function(){return r=Object.assign||function(e){for(var t,n=1,a=arguments.length;n<a;n++)for(var i in t=arguments[n])Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i]);return e},r.apply(this,arguments)},l=this&&this.__spreadArrays||function(){for(var e=0,t=0,n=arguments.length;t<n;t++)e+=arguments[t].length;var a=Array(e),i=0;for(t=0;t<n;t++)for(var o=arguments[t],r=0,l=o.length;r<l;r++,i++)a[i]=o[r];return a};const c=e("651d495396"),s=o.__importDefault(e("3bfa124fda")),d=e("15458073ce"),u=e("6b6749c6cf"),f=e("1bb8c967d1"),m=e("3d14787c35");e("6f45019dc1");var g=300;function p(e,t){var n={config:r(r({},c.defaults),v.defaultConfig),l10n:s.default};function a(){var e;return(null===(e=n.calendarContainer)||void 0===e?void 0:e.getRootNode()).activeElement||document.activeElement}function i(e){return e.bind(n)}function o(){var e=n.config;!1===e.weekNumbers&&1===e.showMonths||!0!==e.noCalendar&&window.requestAnimationFrame((function(){if(void 0!==n.calendarContainer&&(n.calendarContainer.style.visibility="hidden",n.calendarContainer.style.display="block"),void 0!==n.daysContainer){var t=(n.days.offsetWidth+1)*e.showMonths;n.daysContainer.style.width=t+"px",n.calendarContainer.style.width=t+(void 0!==n.weekWrapper?n.weekWrapper.offsetWidth:0)+"px",n.calendarContainer.style.removeProperty("visibility"),n.calendarContainer.style.removeProperty("display")}}))}function p(e){if(0===n.selectedDates.length){var t=void 0===n.config.minDate||(0,f.compareDates)(new Date,n.config.minDate)>=0?new Date:new Date(n.config.minDate.getTime()),a=(0,f.getDefaultHours)(n.config);t.setHours(a.hours,a.minutes,a.seconds,t.getMilliseconds()),n.selectedDates=[t],n.latestSelectedDateObj=t}void 0!==e&&"blur"!==e.type&&function(e){e.preventDefault();var t="keydown"===e.type,a=(0,u.getEventTarget)(e),i=a;void 0!==n.amPM&&a===n.amPM&&(n.amPM.textContent=n.l10n.amPM[(0,d.int)(n.amPM.textContent===n.l10n.amPM[0])]);var o=parseFloat(i.getAttribute("min")),r=parseFloat(i.getAttribute("max")),l=parseFloat(i.getAttribute("step")),c=parseInt(i.value,10),s=e.delta||(t?38===e.which?1:-1:0),f=c+l*s;if(void 0!==i.value&&2===i.value.length){var m=i===n.hourElement,g=i===n.minuteElement;f<o?(f=r+f+(0,d.int)(!m)+((0,d.int)(m)&&(0,d.int)(!n.amPM)),g&&x(void 0,-1,n.hourElement)):f>r&&(f=i===n.hourElement?f-r-(0,d.int)(!n.amPM):o,g&&x(void 0,1,n.hourElement)),n.amPM&&m&&(1===l?f+c===23:Math.abs(f-c)>l)&&(n.amPM.textContent=n.l10n.amPM[(0,d.int)(n.amPM.textContent===n.l10n.amPM[0])]),i.value=(0,d.pad)(f)}}(e);var i=n._input.value;h(),se(),n._input.value!==i&&n._debouncedChange()}function h(){if(void 0!==n.hourElement&&void 0!==n.minuteElement){var e,t,a=(parseInt(n.hourElement.value.slice(-2),10)||0)%24,i=(parseInt(n.minuteElement.value,10)||0)%60,o=void 0!==n.secondElement?(parseInt(n.secondElement.value,10)||0)%60:0;void 0!==n.amPM&&(e=a,t=n.amPM.textContent,a=e%12+12*(0,d.int)(t===n.l10n.amPM[1]));var r=void 0!==n.config.minTime||n.config.minDate&&n.minDateHasTime&&n.latestSelectedDateObj&&0===(0,f.compareDates)(n.latestSelectedDateObj,n.config.minDate,!0),l=void 0!==n.config.maxTime||n.config.maxDate&&n.maxDateHasTime&&n.latestSelectedDateObj&&0===(0,f.compareDates)(n.latestSelectedDateObj,n.config.maxDate,!0);if(void 0!==n.config.maxTime&&void 0!==n.config.minTime&&n.config.minTime>n.config.maxTime){var c=(0,f.calculateSecondsSinceMidnight)(n.config.minTime.getHours(),n.config.minTime.getMinutes(),n.config.minTime.getSeconds()),s=(0,f.calculateSecondsSinceMidnight)(n.config.maxTime.getHours(),n.config.maxTime.getMinutes(),n.config.maxTime.getSeconds()),u=(0,f.calculateSecondsSinceMidnight)(a,i,o);if(u>s&&u<c){var m=(0,f.parseSeconds)(c);a=m[0],i=m[1],o=m[2]}}else{if(l){var g=void 0!==n.config.maxTime?n.config.maxTime:n.config.maxDate;(a=Math.min(a,g.getHours()))===g.getHours()&&(i=Math.min(i,g.getMinutes())),i===g.getMinutes()&&(o=Math.min(o,g.getSeconds()))}if(r){var p=void 0!==n.config.minTime?n.config.minTime:n.config.minDate;(a=Math.max(a,p.getHours()))===p.getHours()&&i<p.getMinutes()&&(i=p.getMinutes()),i===p.getMinutes()&&(o=Math.max(o,p.getSeconds()))}}C(a,i,o)}}function D(e){var t=e||n.latestSelectedDateObj;t&&t instanceof Date&&C(t.getHours(),t.getMinutes(),t.getSeconds())}function C(e,t,a){void 0!==n.latestSelectedDateObj&&n.latestSelectedDateObj.setHours(e%24,t,a||0,0),n.hourElement&&n.minuteElement&&!n.isMobile&&(n.hourElement.value=(0,d.pad)(n.config.time_24hr?e:(12+e)%12+12*(0,d.int)(e%12==0)),n.minuteElement.value=(0,d.pad)(t),void 0!==n.amPM&&(n.amPM.textContent=n.l10n.amPM[(0,d.int)(e>=12)]),void 0!==n.secondElement&&(n.secondElement.value=(0,d.pad)(a)))}function b(e){var t=(0,u.getEventTarget)(e),n=parseInt(t.value)+(e.delta||0);(n/1e3>1||"Enter"===e.key&&!/[^\d]/.test(n.toString()))&&R(n)}function M(e,t,a,i){return t instanceof Array?t.forEach((function(t){return M(e,t,a,i)})):e instanceof Array?e.forEach((function(e){return M(e,t,a,i)})):(e.addEventListener(t,a,i),void n._handlers.push({remove:function(){return e.removeEventListener(t,a,i)}}))}function y(){ie("onChange")}function w(e,t){var a=void 0!==e?n.parseDate(e):n.latestSelectedDateObj||(n.config.minDate&&n.config.minDate>n.now?n.config.minDate:n.config.maxDate&&n.config.maxDate<n.now?n.config.maxDate:n.now),i=n.currentYear,o=n.currentMonth;try{void 0!==a&&(n.currentYear=a.getFullYear(),n.currentMonth=a.getMonth())}catch(e){e.message="Invalid date supplied: "+a,n.config.errorHandler(e)}t&&n.currentYear!==i&&(ie("onYearChange"),N()),!t||n.currentYear===i&&n.currentMonth===o||ie("onMonthChange"),n.redraw()}function E(e){var t=(0,u.getEventTarget)(e);~t.className.indexOf("arrow")&&x(e,t.classList.contains("arrowUp")?1:-1)}function x(e,t,n){var a=e&&(0,u.getEventTarget)(e),i=n||a&&a.parentNode&&a.parentNode.firstChild,o=oe("increment");o.delta=t,i&&i.dispatchEvent(o)}function k(e,t,a,i){var o=W(t,!0),r=(0,u.createElement)("span",e,t.getDate().toString());return r.dateObj=t,r.$i=i,r.setAttribute("aria-label",n.formatDate(t,n.config.ariaDateFormat)),-1===e.indexOf("hidden")&&0===(0,f.compareDates)(t,n.now)&&(n.todayDateElem=r,r.classList.add("today"),r.setAttribute("aria-current","date")),o?(r.tabIndex=-1,re(t)&&(r.classList.add("selected"),n.selectedDateElem=r,"range"===n.config.mode&&((0,u.toggleClass)(r,"startRange",n.selectedDates[0]&&0===(0,f.compareDates)(t,n.selectedDates[0],!0)),(0,u.toggleClass)(r,"endRange",n.selectedDates[1]&&0===(0,f.compareDates)(t,n.selectedDates[1],!0)),"nextMonthDay"===e&&r.classList.add("inRange")))):r.classList.add("flatpickr-disabled"),"range"===n.config.mode&&function(e){return!("range"!==n.config.mode||n.selectedDates.length<2)&&((0,f.compareDates)(e,n.selectedDates[0])>=0&&(0,f.compareDates)(e,n.selectedDates[1])<=0)}(t)&&!re(t)&&r.classList.add("inRange"),n.weekNumbers&&1===n.config.showMonths&&"prevMonthDay"!==e&&i%7==6&&n.weekNumbers.insertAdjacentHTML("beforeend","<span class='flatpickr-day'>"+n.config.getWeek(t)+"</span>"),ie("onDayCreate",r),r}function T(e){e.focus(),"range"===n.config.mode&&J(e)}function _(e){for(var t=e>0?0:n.config.showMonths-1,a=e>0?n.config.showMonths:-1,i=t;i!=a;i+=e)for(var o=n.daysContainer.children[i],r=e>0?0:o.children.length-1,l=e>0?o.children.length:-1,c=r;c!=l;c+=e){var s=o.children[c];if(-1===s.className.indexOf("hidden")&&W(s.dateObj))return s}}function I(e,t){var i=a(),o=B(i||document.body),r=void 0!==e?e:o?i:void 0!==n.selectedDateElem&&B(n.selectedDateElem)?n.selectedDateElem:void 0!==n.todayDateElem&&B(n.todayDateElem)?n.todayDateElem:_(t>0?1:-1);void 0===r?n._input.focus():o?function(e,t){for(var a=-1===e.className.indexOf("Month")?e.dateObj.getMonth():n.currentMonth,i=t>0?n.config.showMonths:-1,o=t>0?1:-1,r=a-n.currentMonth;r!=i;r+=o)for(var l=n.daysContainer.children[r],c=a-n.currentMonth===r?e.$i+t:t<0?l.children.length-1:0,s=l.children.length,d=c;d>=0&&d<s&&d!=(t>0?s:-1);d+=o){var u=l.children[d];if(-1===u.className.indexOf("hidden")&&W(u.dateObj)&&Math.abs(e.$i-d)>=Math.abs(t))return T(u)}n.changeMonth(o),I(_(o),0)}(r,t):T(r)}function S(e,t){for(var a=(new Date(e,t,1).getDay()-n.l10n.firstDayOfWeek+7)%7,i=n.utils.getDaysInMonth((t-1+12)%12,e),o=n.utils.getDaysInMonth(t,e),r=window.document.createDocumentFragment(),l=n.config.showMonths>1,c=l?"prevMonthDay hidden":"prevMonthDay",s=l?"nextMonthDay hidden":"nextMonthDay",d=i+1-a,f=0;d<=i;d++,f++)r.appendChild(k("flatpickr-day "+c,new Date(e,t-1,d),0,f));for(d=1;d<=o;d++,f++)r.appendChild(k("flatpickr-day",new Date(e,t,d),0,f));for(var m=o+1;m<=42-a&&(1===n.config.showMonths||f%7!=0);m++,f++)r.appendChild(k("flatpickr-day "+s,new Date(e,t+1,m%o),0,f));var g=(0,u.createElement)("div","dayContainer");return g.appendChild(r),g}function O(){if(void 0!==n.daysContainer){(0,u.clearNode)(n.daysContainer),n.weekNumbers&&(0,u.clearNode)(n.weekNumbers);for(var e=document.createDocumentFragment(),t=0;t<n.config.showMonths;t++){var a=new Date(n.currentYear,n.currentMonth,1);a.setMonth(n.currentMonth+t),e.appendChild(S(a.getFullYear(),a.getMonth()))}n.daysContainer.appendChild(e),n.days=n.daysContainer.firstChild,"range"===n.config.mode&&1===n.selectedDates.length&&J()}}function N(){if(!(n.config.showMonths>1||"dropdown"!==n.config.monthSelectorType)){var e=function(e){return!(void 0!==n.config.minDate&&n.currentYear===n.config.minDate.getFullYear()&&e<n.config.minDate.getMonth())&&!(void 0!==n.config.maxDate&&n.currentYear===n.config.maxDate.getFullYear()&&e>n.config.maxDate.getMonth())};n.monthsDropdownContainer.tabIndex=-1,n.monthsDropdownContainer.innerHTML="";for(var t=0;t<12;t++)if(e(t)){var a=(0,u.createElement)("option","flatpickr-monthDropdown-month");a.value=new Date(n.currentYear,t).getMonth().toString(),a.textContent=(0,m.monthToStr)(t,n.config.shorthandCurrentMonth,n.l10n),a.tabIndex=-1,n.currentMonth===t&&(a.selected=!0),n.monthsDropdownContainer.appendChild(a)}}}function A(){var e,t=(0,u.createElement)("div","flatpickr-month"),a=window.document.createDocumentFragment();n.config.showMonths>1||"static"===n.config.monthSelectorType?e=(0,u.createElement)("span","cur-month"):(n.monthsDropdownContainer=(0,u.createElement)("select","flatpickr-monthDropdown-months"),n.monthsDropdownContainer.setAttribute("aria-label",n.l10n.monthAriaLabel),M(n.monthsDropdownContainer,"change",(function(e){var t=(0,u.getEventTarget)(e),a=parseInt(t.value,10);n.changeMonth(a-n.currentMonth),ie("onMonthChange")})),N(),e=n.monthsDropdownContainer);var i=(0,u.createNumberInput)("cur-year",{tabindex:"-1"}),o=i.getElementsByTagName("input")[0];o.setAttribute("aria-label",n.l10n.yearAriaLabel),n.config.minDate&&o.setAttribute("min",n.config.minDate.getFullYear().toString()),n.config.maxDate&&(o.setAttribute("max",n.config.maxDate.getFullYear().toString()),o.disabled=!!n.config.minDate&&n.config.minDate.getFullYear()===n.config.maxDate.getFullYear());var r=(0,u.createElement)("div","flatpickr-current-month");return r.appendChild(e),r.appendChild(i),a.appendChild(r),t.appendChild(a),{container:t,yearElement:o,monthElement:e}}function P(){(0,u.clearNode)(n.monthNav),n.monthNav.appendChild(n.prevMonthNav),n.config.showMonths&&(n.yearElements=[],n.monthElements=[]);for(var e=n.config.showMonths;e--;){var t=A();n.yearElements.push(t.yearElement),n.monthElements.push(t.monthElement),n.monthNav.appendChild(t.container)}n.monthNav.appendChild(n.nextMonthNav)}function Y(){n.weekdayContainer?(0,u.clearNode)(n.weekdayContainer):n.weekdayContainer=(0,u.createElement)("div","flatpickr-weekdays");for(var e=n.config.showMonths;e--;){var t=(0,u.createElement)("div","flatpickr-weekdaycontainer");n.weekdayContainer.appendChild(t)}return F(),n.weekdayContainer}function F(){if(n.weekdayContainer){var e=n.l10n.firstDayOfWeek,t=l(n.l10n.weekdays.shorthand);e>0&&e<t.length&&(t=l(t.splice(e,t.length),t.splice(0,e)));for(var a=n.config.showMonths;a--;)n.weekdayContainer.children[a].innerHTML="\n      <span class='flatpickr-weekday'>\n        "+t.join("</span><span class='flatpickr-weekday'>")+"\n      </span>\n      "}}function j(e,t){void 0===t&&(t=!0);var a=t?e:e-n.currentMonth;a<0&&!0===n._hidePrevMonthArrow||a>0&&!0===n._hideNextMonthArrow||(n.currentMonth+=a,(n.currentMonth<0||n.currentMonth>11)&&(n.currentYear+=n.currentMonth>11?1:-1,n.currentMonth=(n.currentMonth+12)%12,ie("onYearChange"),N()),O(),ie("onMonthChange"),le())}function L(e){return n.calendarContainer.contains(e)}function H(e){if(n.isOpen&&!n.config.inline){var t=(0,u.getEventTarget)(e),a=L(t),i=!(t===n.input||t===n.altInput||n.element.contains(t)||e.path&&e.path.indexOf&&(~e.path.indexOf(n.input)||~e.path.indexOf(n.altInput)))&&!a&&!L(e.relatedTarget),o=!n.config.ignoredFocusElements.some((function(e){return e.contains(t)}));i&&o&&(n.config.allowInput&&n.setDate(n._input.value,!1,n.config.altInput?n.config.altFormat:n.config.dateFormat),void 0!==n.timeContainer&&void 0!==n.minuteElement&&void 0!==n.hourElement&&""!==n.input.value&&void 0!==n.input.value&&p(),n.close(),n.config&&"range"===n.config.mode&&1===n.selectedDates.length&&n.clear(!1))}}function R(e){if(!(!e||n.config.minDate&&e<n.config.minDate.getFullYear()||n.config.maxDate&&e>n.config.maxDate.getFullYear())){var t=e,a=n.currentYear!==t;n.currentYear=t||n.currentYear,n.config.maxDate&&n.currentYear===n.config.maxDate.getFullYear()?n.currentMonth=Math.min(n.config.maxDate.getMonth(),n.currentMonth):n.config.minDate&&n.currentYear===n.config.minDate.getFullYear()&&(n.currentMonth=Math.max(n.config.minDate.getMonth(),n.currentMonth)),a&&(n.redraw(),ie("onYearChange"),N())}}function W(e,t){var a;void 0===t&&(t=!0);var i=n.parseDate(e,void 0,t);if(n.config.minDate&&i&&(0,f.compareDates)(i,n.config.minDate,void 0!==t?t:!n.minDateHasTime)<0||n.config.maxDate&&i&&(0,f.compareDates)(i,n.config.maxDate,void 0!==t?t:!n.maxDateHasTime)>0)return!1;if(!n.config.enable&&0===n.config.disable.length)return!0;if(void 0===i)return!1;for(var o=!!n.config.enable,r=null!==(a=n.config.enable)&&void 0!==a?a:n.config.disable,l=0,c=void 0;l<r.length;l++){if("function"==typeof(c=r[l])&&c(i))return o;if(c instanceof Date&&void 0!==i&&c.getTime()===i.getTime())return o;if("string"==typeof c){var s=n.parseDate(c,void 0,!0);return s&&s.getTime()===i.getTime()?o:!o}if("object"==typeof c&&void 0!==i&&c.from&&c.to&&i.getTime()>=c.from.getTime()&&i.getTime()<=c.to.getTime())return o}return!o}function B(e){return void 0!==n.daysContainer&&(-1===e.className.indexOf("hidden")&&-1===e.className.indexOf("flatpickr-disabled")&&n.daysContainer.contains(e))}function K(e){var t=e.target===n._input,a=n._input.value.trimEnd()!==ce();!t||!a||e.relatedTarget&&L(e.relatedTarget)||n.setDate(n._input.value,!0,e.target===n.altInput?n.config.altFormat:n.config.dateFormat)}function q(t){var i=(0,u.getEventTarget)(t),o=n.config.wrap?e.contains(i):i===n._input,r=n.config.allowInput,l=n.isOpen&&(!r||!o),c=n.config.inline&&o&&!r;if(13===t.keyCode&&o){if(r)return n.setDate(n._input.value,!0,i===n.altInput?n.config.altFormat:n.config.dateFormat),n.close(),i.blur();n.open()}else if(L(i)||l||c){var s=!!n.timeContainer&&n.timeContainer.contains(i);switch(t.keyCode){case 13:s?(t.preventDefault(),p(),G()):Z(t);break;case 27:t.preventDefault(),G();break;case 8:case 46:o&&!n.config.allowInput&&(t.preventDefault(),n.clear());break;case 37:case 39:if(s||o)n.hourElement&&n.hourElement.focus();else{t.preventDefault();var d=a();if(void 0!==n.daysContainer&&(!1===r||d&&B(d))){var f=39===t.keyCode?1:-1;t.ctrlKey?(t.stopPropagation(),j(f),I(_(1),0)):I(void 0,f)}}break;case 38:case 40:t.preventDefault();var m=40===t.keyCode?1:-1;n.daysContainer&&void 0!==i.$i||i===n.input||i===n.altInput?t.ctrlKey?(t.stopPropagation(),R(n.currentYear-m),I(_(1),0)):s||I(void 0,7*m):i===n.currentYearElement?R(n.currentYear-m):n.config.enableTime&&(!s&&n.hourElement&&n.hourElement.focus(),p(t),n._debouncedChange());break;case 9:if(s){var g=[n.hourElement,n.minuteElement,n.secondElement,n.amPM].concat(n.pluginElements).filter((function(e){return e})),v=g.indexOf(i);if(-1!==v){var D=g[v+(t.shiftKey?-1:1)];t.preventDefault(),(D||n._input).focus()}}else!n.config.noCalendar&&n.daysContainer&&n.daysContainer.contains(i)&&t.shiftKey&&(t.preventDefault(),n._input.focus())}}if(void 0!==n.amPM&&i===n.amPM)switch(t.key){case n.l10n.amPM[0].charAt(0):case n.l10n.amPM[0].charAt(0).toLowerCase():n.amPM.textContent=n.l10n.amPM[0],h(),se();break;case n.l10n.amPM[1].charAt(0):case n.l10n.amPM[1].charAt(0).toLowerCase():n.amPM.textContent=n.l10n.amPM[1],h(),se()}(o||L(i))&&ie("onKeyDown",t)}function J(e,t){if(void 0===t&&(t="flatpickr-day"),1===n.selectedDates.length&&(!e||e.classList.contains(t)&&!e.classList.contains("flatpickr-disabled"))){for(var a=e?e.dateObj.getTime():n.days.firstElementChild.dateObj.getTime(),i=n.parseDate(n.selectedDates[0],void 0,!0).getTime(),o=Math.min(a,n.selectedDates[0].getTime()),r=Math.max(a,n.selectedDates[0].getTime()),l=!1,c=0,s=0,d=o;d<r;d+=f.duration.DAY)W(new Date(d),!0)||(l=l||d>o&&d<r,d<i&&(!c||d>c)?c=d:d>i&&(!s||d<s)&&(s=d));Array.from(n.rContainer.querySelectorAll("*:nth-child(-n+"+n.config.showMonths+") > ."+t)).forEach((function(t){var o=t.dateObj.getTime(),r=c>0&&o<c||s>0&&o>s;if(r)return t.classList.add("notAllowed"),void["inRange","startRange","endRange"].forEach((function(e){t.classList.remove(e)}));l&&!r||(["startRange","inRange","endRange","notAllowed"].forEach((function(e){t.classList.remove(e)})),void 0!==e&&(e.classList.add(a<=n.selectedDates[0].getTime()?"startRange":"endRange"),i<a&&o===i?t.classList.add("startRange"):i>a&&o===i&&t.classList.add("endRange"),o>=c&&(0===s||o<=s)&&(0,f.isBetween)(o,i,a)&&t.classList.add("inRange")))}))}}function U(){!n.isOpen||n.config.static||n.config.inline||X()}function $(e){return function(t){var a=n.config["_"+e+"Date"]=n.parseDate(t,n.config.dateFormat),i=n.config["_"+("min"===e?"max":"min")+"Date"];void 0!==a&&(n["min"===e?"minDateHasTime":"maxDateHasTime"]=a.getHours()>0||a.getMinutes()>0||a.getSeconds()>0),n.selectedDates&&(n.selectedDates=n.selectedDates.filter((function(e){return W(e)})),n.selectedDates.length||"min"!==e||D(a),se()),n.daysContainer&&(z(),void 0!==a?n.currentYearElement[e]=a.getFullYear().toString():n.currentYearElement.removeAttribute(e),n.currentYearElement.disabled=!!i&&void 0!==a&&i.getFullYear()===a.getFullYear())}}function Q(){return n.config.wrap?e.querySelector("[data-input]"):e}function V(){"object"!=typeof n.config.locale&&void 0===v.l10ns[n.config.locale]&&n.config.errorHandler(new Error("flatpickr: invalid locale "+n.config.locale)),n.l10n=r(r({},v.l10ns.default),"object"==typeof n.config.locale?n.config.locale:"default"!==n.config.locale?v.l10ns[n.config.locale]:void 0),m.tokenRegex.D="("+n.l10n.weekdays.shorthand.join("|")+")",m.tokenRegex.l="("+n.l10n.weekdays.longhand.join("|")+")",m.tokenRegex.M="("+n.l10n.months.shorthand.join("|")+")",m.tokenRegex.F="("+n.l10n.months.longhand.join("|")+")",m.tokenRegex.K="("+n.l10n.amPM[0]+"|"+n.l10n.amPM[1]+"|"+n.l10n.amPM[0].toLowerCase()+"|"+n.l10n.amPM[1].toLowerCase()+")",void 0===r(r({},t),JSON.parse(JSON.stringify(e.dataset||{}))).time_24hr&&void 0===v.defaultConfig.time_24hr&&(n.config.time_24hr=n.l10n.time_24hr),n.formatDate=(0,f.createDateFormatter)(n),n.parseDate=(0,f.createDateParser)({config:n.config,l10n:n.l10n})}function X(e){if("function"!=typeof n.config.position){if(void 0!==n.calendarContainer){ie("onPreCalendarPosition");var t=e||n._positionElement,a=Array.prototype.reduce.call(n.calendarContainer.children,(function(e,t){return e+t.offsetHeight}),0),i=n.calendarContainer.offsetWidth,o=n.config.position.split(" "),r=o[0],l=o.length>1?o[1]:null,c=t.getBoundingClientRect(),s=window.innerHeight-c.bottom,d="above"===r||"below"!==r&&s<a&&c.top>a,f=window.pageYOffset+c.top+(d?-a-2:t.offsetHeight+2);if((0,u.toggleClass)(n.calendarContainer,"arrowTop",!d),(0,u.toggleClass)(n.calendarContainer,"arrowBottom",d),!n.config.inline){var m=window.pageXOffset+c.left,g=!1,p=!1;"center"===l?(m-=(i-c.width)/2,g=!0):"right"===l&&(m-=i-c.width,p=!0),(0,u.toggleClass)(n.calendarContainer,"arrowLeft",!g&&!p),(0,u.toggleClass)(n.calendarContainer,"arrowCenter",g),(0,u.toggleClass)(n.calendarContainer,"arrowRight",p);var h=window.document.body.offsetWidth-(window.pageXOffset+c.right),v=m+i>window.document.body.offsetWidth,D=h+i>window.document.body.offsetWidth;if((0,u.toggleClass)(n.calendarContainer,"rightMost",v),!n.config.static)if(n.calendarContainer.style.top=f+"px",v)if(D){var C=function(){for(var e=null,t=0;t<document.styleSheets.length;t++){var n=document.styleSheets[t];if(n.cssRules){try{n.cssRules}catch(e){continue}e=n;break}}return null!=e?e:(a=document.createElement("style"),document.head.appendChild(a),a.sheet);var a}();if(void 0===C)return;var b=window.document.body.offsetWidth,M=Math.max(0,b/2-i/2),y=C.cssRules.length,w="{left:"+c.left+"px;right:auto;}";(0,u.toggleClass)(n.calendarContainer,"rightMost",!1),(0,u.toggleClass)(n.calendarContainer,"centerMost",!0),C.insertRule(".flatpickr-calendar.centerMost:before,.flatpickr-calendar.centerMost:after"+w,y),n.calendarContainer.style.left=M+"px",n.calendarContainer.style.right="auto"}else n.calendarContainer.style.left="auto",n.calendarContainer.style.right=h+"px";else n.calendarContainer.style.left=m+"px",n.calendarContainer.style.right="auto"}}}else n.config.position(n,e)}function z(){n.config.noCalendar||n.isMobile||(N(),le(),O())}function G(){n._input.focus(),-1!==window.navigator.userAgent.indexOf("MSIE")||void 0!==navigator.msMaxTouchPoints?setTimeout(n.close,0):n.close()}function Z(e){e.preventDefault(),e.stopPropagation();var t=(0,u.findParent)((0,u.getEventTarget)(e),(function(e){return e.classList&&e.classList.contains("flatpickr-day")&&!e.classList.contains("flatpickr-disabled")&&!e.classList.contains("notAllowed")}));if(void 0!==t){var a=t,i=n.latestSelectedDateObj=new Date(a.dateObj.getTime()),o=(i.getMonth()<n.currentMonth||i.getMonth()>n.currentMonth+n.config.showMonths-1)&&"range"!==n.config.mode;if(n.selectedDateElem=a,"single"===n.config.mode)n.selectedDates=[i];else if("multiple"===n.config.mode){var r=re(i);r?n.selectedDates.splice(parseInt(r),1):n.selectedDates.push(i)}else"range"===n.config.mode&&(2===n.selectedDates.length&&n.clear(!1,!1),n.latestSelectedDateObj=i,n.selectedDates.push(i),0!==(0,f.compareDates)(i,n.selectedDates[0],!0)&&n.selectedDates.sort((function(e,t){return e.getTime()-t.getTime()})));if(h(),o){var l=n.currentYear!==i.getFullYear();n.currentYear=i.getFullYear(),n.currentMonth=i.getMonth(),l&&(ie("onYearChange"),N()),ie("onMonthChange")}if(le(),O(),se(),o||"range"===n.config.mode||1!==n.config.showMonths?void 0!==n.selectedDateElem&&void 0===n.hourElement&&n.selectedDateElem&&n.selectedDateElem.focus():T(a),void 0!==n.hourElement&&void 0!==n.hourElement&&n.hourElement.focus(),n.config.closeOnSelect){var c="single"===n.config.mode&&!n.config.enableTime,s="range"===n.config.mode&&2===n.selectedDates.length&&!n.config.enableTime;(c||s)&&G()}y()}}n.parseDate=(0,f.createDateParser)({config:n.config,l10n:n.l10n}),n._handlers=[],n.pluginElements=[],n.loadedPlugins=[],n._bind=M,n._setHoursFromDate=D,n._positionCalendar=X,n.changeMonth=j,n.changeYear=R,n.clear=function(e,t){void 0===e&&(e=!0);void 0===t&&(t=!0);n.input.value="",void 0!==n.altInput&&(n.altInput.value="");void 0!==n.mobileInput&&(n.mobileInput.value="");n.selectedDates=[],n.latestSelectedDateObj=void 0,!0===t&&(n.currentYear=n._initialDate.getFullYear(),n.currentMonth=n._initialDate.getMonth());if(!0===n.config.enableTime){var a=(0,f.getDefaultHours)(n.config);C(a.hours,a.minutes,a.seconds)}n.redraw(),e&&ie("onChange")},n.close=function(){n.isOpen=!1,n.isMobile||(void 0!==n.calendarContainer&&n.calendarContainer.classList.remove("open"),void 0!==n._input&&n._input.classList.remove("active"));ie("onClose")},n.onMouseOver=J,n._createElement=u.createElement,n.createDay=k,n.destroy=function(){void 0!==n.config&&ie("onDestroy");for(var e=n._handlers.length;e--;)n._handlers[e].remove();if(n._handlers=[],n.mobileInput)n.mobileInput.parentNode&&n.mobileInput.parentNode.removeChild(n.mobileInput),n.mobileInput=void 0;else if(n.calendarContainer&&n.calendarContainer.parentNode)if(n.config.static&&n.calendarContainer.parentNode){var t=n.calendarContainer.parentNode;if(t.lastChild&&t.removeChild(t.lastChild),t.parentNode){for(;t.firstChild;)t.parentNode.insertBefore(t.firstChild,t);t.parentNode.removeChild(t)}}else n.calendarContainer.parentNode.removeChild(n.calendarContainer);n.altInput&&(n.input.type="text",n.altInput.parentNode&&n.altInput.parentNode.removeChild(n.altInput),delete n.altInput);n.input&&(n.input.type=n.input._type,n.input.classList.remove("flatpickr-input"),n.input.removeAttribute("readonly"));["_showTimeInput","latestSelectedDateObj","_hideNextMonthArrow","_hidePrevMonthArrow","__hideNextMonthArrow","__hidePrevMonthArrow","isMobile","isOpen","selectedDateElem","minDateHasTime","maxDateHasTime","days","daysContainer","_input","_positionElement","innerContainer","rContainer","monthNav","todayDateElem","calendarContainer","weekdayContainer","prevMonthNav","nextMonthNav","monthsDropdownContainer","currentMonthElement","currentYearElement","navigationCurrentMonth","selectedDateElem","config"].forEach((function(e){try{delete n[e]}catch(e){}}))},n.isEnabled=W,n.jumpToDate=w,n.updateValue=se,n.open=function(e,t){void 0===t&&(t=n._positionElement);if(!0===n.isMobile){if(e){e.preventDefault();var a=(0,u.getEventTarget)(e);a&&a.blur()}return void 0!==n.mobileInput&&(n.mobileInput.focus(),n.mobileInput.click()),void ie("onOpen")}if(n._input.disabled||n.config.inline)return;var i=n.isOpen;n.isOpen=!0,i||(n.calendarContainer.classList.add("open"),n._input.classList.add("active"),ie("onOpen"),X(t));!0===n.config.enableTime&&!0===n.config.noCalendar&&(!1!==n.config.allowInput||void 0!==e&&n.timeContainer.contains(e.relatedTarget)||setTimeout((function(){return n.hourElement.select()}),50))},n.redraw=z,n.set=function(e,t){if(null!==e&&"object"==typeof e)for(var a in Object.assign(n.config,e),e)void 0!==ee[a]&&ee[a].forEach((function(e){return e()}));else n.config[e]=t,void 0!==ee[e]?ee[e].forEach((function(e){return e()})):c.HOOKS.indexOf(e)>-1&&(n.config[e]=(0,d.arrayify)(t));n.redraw(),se(!0)},n.setDate=function(e,t,a){void 0===t&&(t=!1);void 0===a&&(a=n.config.dateFormat);if(0!==e&&!e||e instanceof Array&&0===e.length)return n.clear(t);te(e,a),n.latestSelectedDateObj=n.selectedDates[n.selectedDates.length-1],n.redraw(),w(void 0,t),D(),0===n.selectedDates.length&&n.clear(!1);se(t),t&&ie("onChange")},n.toggle=function(e){if(!0===n.isOpen)return n.close();n.open(e)};var ee={locale:[V,F],showMonths:[P,o,Y],minDate:[w],maxDate:[w],positionElement:[ae],clickOpens:[function(){!0===n.config.clickOpens?(M(n._input,"focus",n.open),M(n._input,"click",n.open)):(n._input.removeEventListener("focus",n.open),n._input.removeEventListener("click",n.open))}]};function te(e,t){var a=[];if(e instanceof Array)a=e.map((function(e){return n.parseDate(e,t)}));else if(e instanceof Date||"number"==typeof e)a=[n.parseDate(e,t)];else if("string"==typeof e)switch(n.config.mode){case"single":case"time":a=[n.parseDate(e,t)];break;case"multiple":a=e.split(n.config.conjunction).map((function(e){return n.parseDate(e,t)}));break;case"range":a=e.split(n.l10n.rangeSeparator).map((function(e){return n.parseDate(e,t)}))}else n.config.errorHandler(new Error("Invalid date supplied: "+JSON.stringify(e)));n.selectedDates=n.config.allowInvalidPreload?a:a.filter((function(e){return e instanceof Date&&W(e,!1)})),"range"===n.config.mode&&n.selectedDates.sort((function(e,t){return e.getTime()-t.getTime()}))}function ne(e){return e.slice().map((function(e){return"string"==typeof e||"number"==typeof e||e instanceof Date?n.parseDate(e,void 0,!0):e&&"object"==typeof e&&e.from&&e.to?{from:n.parseDate(e.from,void 0),to:n.parseDate(e.to,void 0)}:e})).filter((function(e){return e}))}function ae(){n._positionElement=n.config.positionElement||n._input}function ie(e,t){if(void 0!==n.config){var a=n.config[e];if(void 0!==a&&a.length>0)for(var i=0;a[i]&&i<a.length;i++)a[i](n.selectedDates,n.input.value,n,t);"onChange"===e&&(n.input.dispatchEvent(oe("change")),n.input.dispatchEvent(oe("input")))}}function oe(e){var t=document.createEvent("Event");return t.initEvent(e,!0,!0),t}function re(e){for(var t=0;t<n.selectedDates.length;t++){var a=n.selectedDates[t];if(a instanceof Date&&0===(0,f.compareDates)(a,e))return""+t}return!1}function le(){n.config.noCalendar||n.isMobile||!n.monthNav||(n.yearElements.forEach((function(e,t){var a=new Date(n.currentYear,n.currentMonth,1);a.setMonth(n.currentMonth+t),n.config.showMonths>1||"static"===n.config.monthSelectorType?n.monthElements[t].textContent=(0,m.monthToStr)(a.getMonth(),n.config.shorthandCurrentMonth,n.l10n)+" ":n.monthsDropdownContainer.value=a.getMonth().toString(),e.value=a.getFullYear().toString()})),n._hidePrevMonthArrow=void 0!==n.config.minDate&&(n.currentYear===n.config.minDate.getFullYear()?n.currentMonth<=n.config.minDate.getMonth():n.currentYear<n.config.minDate.getFullYear()),n._hideNextMonthArrow=void 0!==n.config.maxDate&&(n.currentYear===n.config.maxDate.getFullYear()?n.currentMonth+1>n.config.maxDate.getMonth():n.currentYear>n.config.maxDate.getFullYear()))}function ce(e){var t=e||(n.config.altInput?n.config.altFormat:n.config.dateFormat);return n.selectedDates.map((function(e){return n.formatDate(e,t)})).filter((function(e,t,a){return"range"!==n.config.mode||n.config.enableTime||a.indexOf(e)===t})).join("range"!==n.config.mode?n.config.conjunction:n.l10n.rangeSeparator)}function se(e){void 0===e&&(e=!0),void 0!==n.mobileInput&&n.mobileFormatStr&&(n.mobileInput.value=void 0!==n.latestSelectedDateObj?n.formatDate(n.latestSelectedDateObj,n.mobileFormatStr):""),n.input.value=ce(n.config.dateFormat),void 0!==n.altInput&&(n.altInput.value=ce(n.config.altFormat)),!1!==e&&ie("onValueUpdate")}function de(e){var t=(0,u.getEventTarget)(e),a=n.prevMonthNav.contains(t),i=n.nextMonthNav.contains(t);a||i?j(a?-1:1):n.yearElements.indexOf(t)>=0?t.select():t.classList.contains("arrowUp")?n.changeYear(n.currentYear+1):t.classList.contains("arrowDown")&&n.changeYear(n.currentYear-1)}return function(){n.element=n.input=e,n.isOpen=!1,function(){var a=["wrap","weekNumbers","allowInput","allowInvalidPreload","clickOpens","time_24hr","enableTime","noCalendar","altInput","shorthandCurrentMonth","inline","static","enableSeconds","disableMobile"],o=r(r({},JSON.parse(JSON.stringify(e.dataset||{}))),t),l={};n.config.parseDate=o.parseDate,n.config.formatDate=o.formatDate,Object.defineProperty(n.config,"enable",{get:function(){return n.config._enable},set:function(e){n.config._enable=ne(e)}}),Object.defineProperty(n.config,"disable",{get:function(){return n.config._disable},set:function(e){n.config._disable=ne(e)}});var s="time"===o.mode;if(!o.dateFormat&&(o.enableTime||s)){var u=v.defaultConfig.dateFormat||c.defaults.dateFormat;l.dateFormat=o.noCalendar||s?"H:i"+(o.enableSeconds?":S":""):u+" H:i"+(o.enableSeconds?":S":"")}if(o.altInput&&(o.enableTime||s)&&!o.altFormat){var f=v.defaultConfig.altFormat||c.defaults.altFormat;l.altFormat=o.noCalendar||s?"h:i"+(o.enableSeconds?":S K":" K"):f+" h:i"+(o.enableSeconds?":S":"")+" K"}Object.defineProperty(n.config,"minDate",{get:function(){return n.config._minDate},set:$("min")}),Object.defineProperty(n.config,"maxDate",{get:function(){return n.config._maxDate},set:$("max")});var m=function(e){return function(t){n.config["min"===e?"_minTime":"_maxTime"]=n.parseDate(t,"H:i:S")}};Object.defineProperty(n.config,"minTime",{get:function(){return n.config._minTime},set:m("min")}),Object.defineProperty(n.config,"maxTime",{get:function(){return n.config._maxTime},set:m("max")}),"time"===o.mode&&(n.config.noCalendar=!0,n.config.enableTime=!0);Object.assign(n.config,l,o);for(var g=0;g<a.length;g++)n.config[a[g]]=!0===n.config[a[g]]||"true"===n.config[a[g]];c.HOOKS.filter((function(e){return void 0!==n.config[e]})).forEach((function(e){n.config[e]=(0,d.arrayify)(n.config[e]||[]).map(i)})),n.isMobile=!n.config.disableMobile&&!n.config.inline&&"single"===n.config.mode&&!n.config.disable.length&&!n.config.enable&&!n.config.weekNumbers&&/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);for(g=0;g<n.config.plugins.length;g++){var p=n.config.plugins[g](n)||{};for(var h in p)c.HOOKS.indexOf(h)>-1?n.config[h]=(0,d.arrayify)(p[h]).map(i).concat(n.config[h]):void 0===o[h]&&(n.config[h]=p[h])}o.altInputClass||(n.config.altInputClass=Q().className+" "+n.config.altInputClass);ie("onParseConfig")}(),V(),function(){if(n.input=Q(),!n.input)return void n.config.errorHandler(new Error("Invalid input element specified"));n.input._type=n.input.type,n.input.type="text",n.input.classList.add("flatpickr-input"),n._input=n.input,n.config.altInput&&(n.altInput=(0,u.createElement)(n.input.nodeName,n.config.altInputClass),n._input=n.altInput,n.altInput.placeholder=n.input.placeholder,n.altInput.disabled=n.input.disabled,n.altInput.required=n.input.required,n.altInput.tabIndex=n.input.tabIndex,n.altInput.type="text",n.input.setAttribute("type","hidden"),!n.config.static&&n.input.parentNode&&n.input.parentNode.insertBefore(n.altInput,n.input.nextSibling));n.config.allowInput||n._input.setAttribute("readonly","readonly");ae()}(),function(){n.selectedDates=[],n.now=n.parseDate(n.config.now)||new Date;var e=n.config.defaultDate||("INPUT"!==n.input.nodeName&&"TEXTAREA"!==n.input.nodeName||!n.input.placeholder||n.input.value!==n.input.placeholder?n.input.value:null);e&&te(e,n.config.dateFormat);n._initialDate=n.selectedDates.length>0?n.selectedDates[0]:n.config.minDate&&n.config.minDate.getTime()>n.now.getTime()?n.config.minDate:n.config.maxDate&&n.config.maxDate.getTime()<n.now.getTime()?n.config.maxDate:n.now,n.currentYear=n._initialDate.getFullYear(),n.currentMonth=n._initialDate.getMonth(),n.selectedDates.length>0&&(n.latestSelectedDateObj=n.selectedDates[0]);void 0!==n.config.minTime&&(n.config.minTime=n.parseDate(n.config.minTime,"H:i"));void 0!==n.config.maxTime&&(n.config.maxTime=n.parseDate(n.config.maxTime,"H:i"));n.minDateHasTime=!!n.config.minDate&&(n.config.minDate.getHours()>0||n.config.minDate.getMinutes()>0||n.config.minDate.getSeconds()>0),n.maxDateHasTime=!!n.config.maxDate&&(n.config.maxDate.getHours()>0||n.config.maxDate.getMinutes()>0||n.config.maxDate.getSeconds()>0)}(),n.utils={getDaysInMonth:function(e,t){return void 0===e&&(e=n.currentMonth),void 0===t&&(t=n.currentYear),1===e&&(t%4==0&&t%100!=0||t%400==0)?29:n.l10n.daysInMonth[e]}},n.isMobile||function(){var e=window.document.createDocumentFragment();if(n.calendarContainer=(0,u.createElement)("div","flatpickr-calendar"),n.calendarContainer.tabIndex=-1,!n.config.noCalendar){if(e.appendChild((n.monthNav=(0,u.createElement)("div","flatpickr-months"),n.yearElements=[],n.monthElements=[],n.prevMonthNav=(0,u.createElement)("span","flatpickr-prev-month"),n.prevMonthNav.innerHTML=n.config.prevArrow,n.nextMonthNav=(0,u.createElement)("span","flatpickr-next-month"),n.nextMonthNav.innerHTML=n.config.nextArrow,P(),Object.defineProperty(n,"_hidePrevMonthArrow",{get:function(){return n.__hidePrevMonthArrow},set:function(e){n.__hidePrevMonthArrow!==e&&((0,u.toggleClass)(n.prevMonthNav,"flatpickr-disabled",e),n.__hidePrevMonthArrow=e)}}),Object.defineProperty(n,"_hideNextMonthArrow",{get:function(){return n.__hideNextMonthArrow},set:function(e){n.__hideNextMonthArrow!==e&&((0,u.toggleClass)(n.nextMonthNav,"flatpickr-disabled",e),n.__hideNextMonthArrow=e)}}),n.currentYearElement=n.yearElements[0],le(),n.monthNav)),n.innerContainer=(0,u.createElement)("div","flatpickr-innerContainer"),n.config.weekNumbers){var t=function(){n.calendarContainer.classList.add("hasWeeks");var e=(0,u.createElement)("div","flatpickr-weekwrapper");e.appendChild((0,u.createElement)("span","flatpickr-weekday",n.l10n.weekAbbreviation));var t=(0,u.createElement)("div","flatpickr-weeks");return e.appendChild(t),{weekWrapper:e,weekNumbers:t}}(),a=t.weekWrapper,i=t.weekNumbers;n.innerContainer.appendChild(a),n.weekNumbers=i,n.weekWrapper=a}n.rContainer=(0,u.createElement)("div","flatpickr-rContainer"),n.rContainer.appendChild(Y()),n.daysContainer||(n.daysContainer=(0,u.createElement)("div","flatpickr-days"),n.daysContainer.tabIndex=-1),O(),n.rContainer.appendChild(n.daysContainer),n.innerContainer.appendChild(n.rContainer),e.appendChild(n.innerContainer)}n.config.enableTime&&e.appendChild(function(){n.calendarContainer.classList.add("hasTime"),n.config.noCalendar&&n.calendarContainer.classList.add("noCalendar");var e=(0,f.getDefaultHours)(n.config);n.timeContainer=(0,u.createElement)("div","flatpickr-time"),n.timeContainer.tabIndex=-1;var t=(0,u.createElement)("span","flatpickr-time-separator",":"),a=(0,u.createNumberInput)("flatpickr-hour",{"aria-label":n.l10n.hourAriaLabel});n.hourElement=a.getElementsByTagName("input")[0];var i=(0,u.createNumberInput)("flatpickr-minute",{"aria-label":n.l10n.minuteAriaLabel});n.minuteElement=i.getElementsByTagName("input")[0],n.hourElement.tabIndex=n.minuteElement.tabIndex=-1,n.hourElement.value=(0,d.pad)(n.latestSelectedDateObj?n.latestSelectedDateObj.getHours():n.config.time_24hr?e.hours:function(e){switch(e%24){case 0:case 12:return 12;default:return e%12}}(e.hours)),n.minuteElement.value=(0,d.pad)(n.latestSelectedDateObj?n.latestSelectedDateObj.getMinutes():e.minutes),n.hourElement.setAttribute("step",n.config.hourIncrement.toString()),n.minuteElement.setAttribute("step",n.config.minuteIncrement.toString()),n.hourElement.setAttribute("min",n.config.time_24hr?"0":"1"),n.hourElement.setAttribute("max",n.config.time_24hr?"23":"12"),n.hourElement.setAttribute("maxlength","2"),n.minuteElement.setAttribute("min","0"),n.minuteElement.setAttribute("max","59"),n.minuteElement.setAttribute("maxlength","2"),n.timeContainer.appendChild(a),n.timeContainer.appendChild(t),n.timeContainer.appendChild(i),n.config.time_24hr&&n.timeContainer.classList.add("time24hr");if(n.config.enableSeconds){n.timeContainer.classList.add("hasSeconds");var o=(0,u.createNumberInput)("flatpickr-second");n.secondElement=o.getElementsByTagName("input")[0],n.secondElement.value=(0,d.pad)(n.latestSelectedDateObj?n.latestSelectedDateObj.getSeconds():e.seconds),n.secondElement.setAttribute("step",n.minuteElement.getAttribute("step")),n.secondElement.setAttribute("min","0"),n.secondElement.setAttribute("max","59"),n.secondElement.setAttribute("maxlength","2"),n.timeContainer.appendChild((0,u.createElement)("span","flatpickr-time-separator",":")),n.timeContainer.appendChild(o)}n.config.time_24hr||(n.amPM=(0,u.createElement)("span","flatpickr-am-pm",n.l10n.amPM[(0,d.int)((n.latestSelectedDateObj?n.hourElement.value:n.config.defaultHour)>11)]),n.amPM.title=n.l10n.toggleTitle,n.amPM.tabIndex=-1,n.timeContainer.appendChild(n.amPM));return n.timeContainer}());(0,u.toggleClass)(n.calendarContainer,"rangeMode","range"===n.config.mode),(0,u.toggleClass)(n.calendarContainer,"animate",!0===n.config.animate),(0,u.toggleClass)(n.calendarContainer,"multiMonth",n.config.showMonths>1),n.calendarContainer.appendChild(e);var o=void 0!==n.config.appendTo&&void 0!==n.config.appendTo.nodeType;if((n.config.inline||n.config.static)&&(n.calendarContainer.classList.add(n.config.inline?"inline":"static"),n.config.inline&&(!o&&n.element.parentNode?n.element.parentNode.insertBefore(n.calendarContainer,n._input.nextSibling):void 0!==n.config.appendTo&&n.config.appendTo.appendChild(n.calendarContainer)),n.config.static)){var r=(0,u.createElement)("div","flatpickr-wrapper");n.element.parentNode&&n.element.parentNode.insertBefore(r,n.element),r.appendChild(n.element),n.altInput&&r.appendChild(n.altInput),r.appendChild(n.calendarContainer)}n.config.static||n.config.inline||(void 0!==n.config.appendTo?n.config.appendTo:window.document.body).appendChild(n.calendarContainer)}(),function(){n.config.wrap&&["open","close","toggle","clear"].forEach((function(e){Array.prototype.forEach.call(n.element.querySelectorAll("[data-"+e+"]"),(function(t){return M(t,"click",n[e])}))}));if(n.isMobile)return void function(){var e=n.config.enableTime?n.config.noCalendar?"time":"datetime-local":"date";n.mobileInput=(0,u.createElement)("input",n.input.className+" flatpickr-mobile"),n.mobileInput.tabIndex=1,n.mobileInput.type=e,n.mobileInput.disabled=n.input.disabled,n.mobileInput.required=n.input.required,n.mobileInput.placeholder=n.input.placeholder,n.mobileFormatStr="datetime-local"===e?"Y-m-d\\TH:i:S":"date"===e?"Y-m-d":"H:i:S",n.selectedDates.length>0&&(n.mobileInput.defaultValue=n.mobileInput.value=n.formatDate(n.selectedDates[0],n.mobileFormatStr));n.config.minDate&&(n.mobileInput.min=n.formatDate(n.config.minDate,"Y-m-d"));n.config.maxDate&&(n.mobileInput.max=n.formatDate(n.config.maxDate,"Y-m-d"));n.input.getAttribute("step")&&(n.mobileInput.step=String(n.input.getAttribute("step")));n.input.type="hidden",void 0!==n.altInput&&(n.altInput.type="hidden");try{n.input.parentNode&&n.input.parentNode.insertBefore(n.mobileInput,n.input.nextSibling)}catch(e){}M(n.mobileInput,"change",(function(e){n.setDate((0,u.getEventTarget)(e).value,!1,n.mobileFormatStr),ie("onChange"),ie("onClose")}))}();var e=(0,d.debounce)(U,50);n._debouncedChange=(0,d.debounce)(y,g),n.daysContainer&&!/iPhone|iPad|iPod/i.test(navigator.userAgent)&&M(n.daysContainer,"mouseover",(function(e){"range"===n.config.mode&&J((0,u.getEventTarget)(e))}));M(n._input,"keydown",q),void 0!==n.calendarContainer&&M(n.calendarContainer,"keydown",q);n.config.inline||n.config.static||M(window,"resize",e);void 0!==window.ontouchstart?M(window.document,"touchstart",H):M(window.document,"mousedown",H);M(window.document,"focus",H,{capture:!0}),!0===n.config.clickOpens&&(M(n._input,"focus",n.open),M(n._input,"click",n.open));void 0!==n.daysContainer&&(M(n.monthNav,"click",de),M(n.monthNav,["keyup","increment"],b),M(n.daysContainer,"click",Z));if(void 0!==n.timeContainer&&void 0!==n.minuteElement&&void 0!==n.hourElement){var t=function(e){return(0,u.getEventTarget)(e).select()};M(n.timeContainer,["increment"],p),M(n.timeContainer,"blur",p,{capture:!0}),M(n.timeContainer,"click",E),M([n.hourElement,n.minuteElement],["focus","click"],t),void 0!==n.secondElement&&M(n.secondElement,"focus",(function(){return n.secondElement&&n.secondElement.select()})),void 0!==n.amPM&&M(n.amPM,"click",(function(e){p(e)}))}n.config.allowInput&&M(n._input,"blur",K)}(),(n.selectedDates.length||n.config.noCalendar)&&(n.config.enableTime&&D(n.config.noCalendar?n.latestSelectedDateObj:void 0),se(!1)),o();var a=/^((?!chrome|android).)*safari/i.test(navigator.userAgent);!n.isMobile&&a&&X(),ie("onReady")}(),n}function h(e,t){for(var n=Array.prototype.slice.call(e).filter((function(e){return e instanceof HTMLElement})),a=[],i=0;i<n.length;i++){var o=n[i];try{if(null!==o.getAttribute("data-fp-omit"))continue;void 0!==o._flatpickr&&(o._flatpickr.destroy(),o._flatpickr=void 0),o._flatpickr=p(o,t||{}),a.push(o._flatpickr)}catch(e){console.error(e)}}return 1===a.length?a[0]:a}"undefined"!=typeof HTMLElement&&"undefined"!=typeof HTMLCollection&&"undefined"!=typeof NodeList&&(HTMLCollection.prototype.flatpickr=NodeList.prototype.flatpickr=function(e){return h(this,e)},HTMLElement.prototype.flatpickr=function(e){return h([this],e)});var v=function(e,t){return"string"==typeof e?h(window.document.querySelectorAll(e),t):e instanceof Node?h([e],t):h(e,t)};v.defaultConfig={},v.l10ns={en:r({},s.default),default:r({},s.default)},v.localize=function(e){v.l10ns.default=r(r({},v.l10ns.default),e)},v.setDefaults=function(e){v.defaultConfig=r(r({},v.defaultConfig),e)},v.parseDate=(0,f.createDateParser)({}),v.formatDate=(0,f.createDateFormatter)({}),v.compareDates=f.compareDates,"undefined"!=typeof jQuery&&void 0!==jQuery.fn&&(jQuery.fn.flatpickr=function(e){return h(this,e)}),Date.prototype.fp_incr=function(e){return new Date(this.getFullYear(),this.getMonth(),this.getDate()+("string"==typeof e?parseInt(e,10):e))},"undefined"!=typeof window&&(window.flatpickr=v),n.default=v},
"651d495396": function _(e,n,o,t,a){t(),o.HOOKS=["onChange","onClose","onDayCreate","onDestroy","onKeyDown","onMonthChange","onOpen","onParseConfig","onReady","onValueUpdate","onYearChange","onPreCalendarPosition"],o.defaults={_disable:[],allowInput:!1,allowInvalidPreload:!1,altFormat:"F j, Y",altInput:!1,altInputClass:"form-control input",animate:"object"==typeof window&&-1===window.navigator.userAgent.indexOf("MSIE"),ariaDateFormat:"F j, Y",autoFillDefaultTime:!0,clickOpens:!0,closeOnSelect:!0,conjunction:", ",dateFormat:"Y-m-d",defaultHour:12,defaultMinute:0,defaultSeconds:0,disable:[],disableMobile:!1,enableSeconds:!1,enableTime:!1,errorHandler:function(e){return"undefined"!=typeof console&&console.warn(e)},getWeek:function(e){var n=new Date(e.getTime());n.setHours(0,0,0,0),n.setDate(n.getDate()+3-(n.getDay()+6)%7);var o=new Date(n.getFullYear(),0,4);return 1+Math.round(((n.getTime()-o.getTime())/864e5-3+(o.getDay()+6)%7)/7)},hourIncrement:1,ignoredFocusElements:[],inline:!1,locale:"default",minuteIncrement:5,mode:"single",monthSelectorType:"dropdown",nextArrow:"<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M13.207 8.472l-7.854 7.854-0.707-0.707 7.146-7.146-7.146-7.148 0.707-0.707 7.854 7.854z' /></svg>",noCalendar:!1,now:new Date,onChange:[],onClose:[],onDayCreate:[],onDestroy:[],onKeyDown:[],onMonthChange:[],onOpen:[],onParseConfig:[],onReady:[],onValueUpdate:[],onYearChange:[],onPreCalendarPosition:[],plugins:[],position:"auto",positionElement:void 0,prevArrow:"<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M5.207 8.471l7.146 7.147-0.707 0.707-7.853-7.854 7.854-7.853 0.707 0.707-7.147 7.146z' /></svg>",shorthandCurrentMonth:!1,showMonths:1,static:!1,time_24hr:!1,weekNumbers:!1,wrap:!1}},
"3bfa124fda": function _(e,r,a,n,t){n(),a.english={weekdays:{shorthand:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],longhand:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"]},months:{shorthand:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],longhand:["January","February","March","April","May","June","July","August","September","October","November","December"]},daysInMonth:[31,28,31,30,31,30,31,31,30,31,30,31],firstDayOfWeek:0,ordinal:function(e){var r=e%100;if(r>3&&r<21)return"th";switch(r%10){case 1:return"st";case 2:return"nd";case 3:return"rd";default:return"th"}},rangeSeparator:" to ",weekAbbreviation:"Wk",scrollTitle:"Scroll to increment",toggleTitle:"Click to toggle",amPM:["AM","PM"],yearAriaLabel:"Year",monthAriaLabel:"Month",hourAriaLabel:"Hour",minuteAriaLabel:"Minute",time_24hr:!1},a.default=a.english},
"15458073ce": function _(n,t,r,i,u){i();r.pad=function(n,t){return void 0===t&&(t=2),("000"+n).slice(-1*t)};r.int=function(n){return!0===n?1:0},r.debounce=function(n,t){var r;return function(){var i=this,u=arguments;clearTimeout(r),r=setTimeout((function(){return n.apply(i,u)}),t)}};r.arrayify=function(n){return n instanceof Array?n:[n]}},
"6b6749c6cf": function _(t,e,n,r,a){function i(t,e,n){var r=window.document.createElement(t);return e=e||"",n=n||"",r.className=e,void 0!==n&&(r.textContent=n),r}r(),n.toggleClass=function(t,e,n){if(!0===n)return t.classList.add(e);t.classList.remove(e)},n.createElement=i,n.clearNode=function(t){for(;t.firstChild;)t.removeChild(t.firstChild)},n.findParent=function t(e,n){return n(e)?e:e.parentNode?t(e.parentNode,n):void 0},n.createNumberInput=function(t,e){var n=i("div","numInputWrapper"),r=i("input","numInput "+t),a=i("span","arrowUp"),o=i("span","arrowDown");if(-1===navigator.userAgent.indexOf("MSIE 9.0")?r.type="number":(r.type="text",r.pattern="\\d*"),void 0!==e)for(var d in e)r.setAttribute(d,e[d]);return n.appendChild(r),n.appendChild(a),n.appendChild(o),n},n.getEventTarget=function(t){try{return"function"==typeof t.composedPath?t.composedPath()[0]:t.target}catch(e){return t.target}}},
"1bb8c967d1": function _(e,t,n,a,r){a();const i=e("3d14787c35"),o=e("651d495396"),s=e("3bfa124fda");n.createDateFormatter=function(e){var t=e.config,n=void 0===t?o.defaults:t,a=e.l10n,r=void 0===a?s.english:a,u=e.isMobile,f=void 0!==u&&u;return function(e,t,a){var o=a||r;return void 0===n.formatDate||f?t.split("").map((function(t,a,r){return i.formats[t]&&"\\"!==r[a-1]?i.formats[t](e,o,n):"\\"!==t?t:""})).join(""):n.formatDate(e,t,o)}};n.createDateParser=function(e){var t=e.config,n=void 0===t?o.defaults:t,a=e.l10n,r=void 0===a?s.english:a;return function(e,t,a,s){if(0===e||e){var u,f=s||r,d=e;if(e instanceof Date)u=new Date(e.getTime());else if("string"!=typeof e&&void 0!==e.toFixed)u=new Date(e);else if("string"==typeof e){var c=t||(n||o.defaults).dateFormat,g=String(e).trim();if("today"===g)u=new Date,a=!0;else if(n&&n.parseDate)u=n.parseDate(e,c);else if(/Z$/.test(g)||/GMT$/.test(g))u=new Date(e);else{for(var m=void 0,l=[],v=0,D=0,h="";v<c.length;v++){var w=c[v],M="\\"===w,p="\\"===c[v-1]||M;if(i.tokenRegex[w]&&!p){h+=i.tokenRegex[w];var H=new RegExp(h).exec(e);H&&(m=!0)&&l["Y"!==w?"push":"unshift"]({fn:i.revFormat[w],val:H[++D]})}else M||(h+=".")}u=n&&n.noCalendar?new Date((new Date).setHours(0,0,0,0)):new Date((new Date).getFullYear(),0,1,0,0,0,0),l.forEach((function(e){var t=e.fn,n=e.val;return u=t(u,n,f)||u})),u=m?u:void 0}}if(u instanceof Date&&!isNaN(u.getTime()))return!0===a&&u.setHours(0,0,0,0),u;n.errorHandler(new Error("Invalid date provided: "+d))}}},n.compareDates=function(e,t,n){return void 0===n&&(n=!0),!1!==n?new Date(e.getTime()).setHours(0,0,0,0)-new Date(t.getTime()).setHours(0,0,0,0):e.getTime()-t.getTime()},n.compareTimes=function(e,t){return 3600*(e.getHours()-t.getHours())+60*(e.getMinutes()-t.getMinutes())+e.getSeconds()-t.getSeconds()};n.isBetween=function(e,t,n){return e>Math.min(t,n)&&e<Math.max(t,n)};n.calculateSecondsSinceMidnight=function(e,t,n){return 3600*e+60*t+n};n.parseSeconds=function(e){var t=Math.floor(e/3600),n=(e-3600*t)/60;return[t,n,e-3600*t-60*n]},n.duration={DAY:864e5},n.getDefaultHours=function(e){var t=e.defaultHour,n=e.defaultMinute,a=e.defaultSeconds;if(void 0!==e.minDate){var r=e.minDate.getHours(),i=e.minDate.getMinutes(),o=e.minDate.getSeconds();t<r&&(t=r),t===r&&n<i&&(n=i),t===r&&n===i&&a<o&&(a=e.minDate.getSeconds())}if(void 0!==e.maxDate){var s=e.maxDate.getHours(),u=e.maxDate.getMinutes();(t=Math.min(t,s))===s&&(n=Math.min(u,n)),t===s&&n===u&&(a=e.maxDate.getSeconds())}return{hours:t,minutes:n,seconds:a}}},
"3d14787c35": function _(t,n,e,o,r){o();const u=t("15458073ce");var a=function(){};e.monthToStr=function(t,n,e){return e.months[n?"shorthand":"longhand"][t]},e.revFormat={D:a,F:function(t,n,e){t.setMonth(e.months.longhand.indexOf(n))},G:function(t,n){t.setHours((t.getHours()>=12?12:0)+parseFloat(n))},H:function(t,n){t.setHours(parseFloat(n))},J:function(t,n){t.setDate(parseFloat(n))},K:function(t,n,e){t.setHours(t.getHours()%12+12*(0,u.int)(new RegExp(e.amPM[1],"i").test(n)))},M:function(t,n,e){t.setMonth(e.months.shorthand.indexOf(n))},S:function(t,n){t.setSeconds(parseFloat(n))},U:function(t,n){return new Date(1e3*parseFloat(n))},W:function(t,n,e){var o=parseInt(n),r=new Date(t.getFullYear(),0,2+7*(o-1),0,0,0,0);return r.setDate(r.getDate()-r.getDay()+e.firstDayOfWeek),r},Y:function(t,n){t.setFullYear(parseFloat(n))},Z:function(t,n){return new Date(n)},d:function(t,n){t.setDate(parseFloat(n))},h:function(t,n){t.setHours((t.getHours()>=12?12:0)+parseFloat(n))},i:function(t,n){t.setMinutes(parseFloat(n))},j:function(t,n){t.setDate(parseFloat(n))},l:a,m:function(t,n){t.setMonth(parseFloat(n)-1)},n:function(t,n){t.setMonth(parseFloat(n)-1)},s:function(t,n){t.setSeconds(parseFloat(n))},u:function(t,n){return new Date(parseFloat(n))},w:a,y:function(t,n){t.setFullYear(2e3+parseFloat(n))}},e.tokenRegex={D:"",F:"",G:"(\\d\\d|\\d)",H:"(\\d\\d|\\d)",J:"(\\d\\d|\\d)\\w+",K:"",M:"",S:"(\\d\\d|\\d)",U:"(.+)",W:"(\\d\\d|\\d)",Y:"(\\d{4})",Z:"(.+)",d:"(\\d\\d|\\d)",h:"(\\d\\d|\\d)",i:"(\\d\\d|\\d)",j:"(\\d\\d|\\d)",l:"",m:"(\\d\\d|\\d)",n:"(\\d\\d|\\d)",s:"(\\d\\d|\\d)",u:"(.+)",w:"(\\d\\d|\\d)",y:"(\\d{2})"},e.formats={Z:function(t){return t.toISOString()},D:function(t,n,o){return n.weekdays.shorthand[e.formats.w(t,n,o)]},F:function(t,n,o){return(0,e.monthToStr)(e.formats.n(t,n,o)-1,!1,n)},G:function(t,n,o){return(0,u.pad)(e.formats.h(t,n,o))},H:function(t){return(0,u.pad)(t.getHours())},J:function(t,n){return void 0!==n.ordinal?t.getDate()+n.ordinal(t.getDate()):t.getDate()},K:function(t,n){return n.amPM[(0,u.int)(t.getHours()>11)]},M:function(t,n){return(0,e.monthToStr)(t.getMonth(),!0,n)},S:function(t){return(0,u.pad)(t.getSeconds())},U:function(t){return t.getTime()/1e3},W:function(t,n,e){return e.getWeek(t)},Y:function(t){return(0,u.pad)(t.getFullYear(),4)},d:function(t){return(0,u.pad)(t.getDate())},h:function(t){return t.getHours()%12?t.getHours()%12:12},i:function(t){return(0,u.pad)(t.getMinutes())},j:function(t){return t.getDate()},l:function(t,n){return n.weekdays.longhand[t.getDay()]},m:function(t){return(0,u.pad)(t.getMonth()+1)},n:function(t){return t.getMonth()+1},s:function(t){return t.getSeconds()},u:function(t){return t.getTime()},w:function(t){return t.getDay()},y:function(t){return String(t.getFullYear()).substring(2)}}},
"6f45019dc1": function _(n,t,o,r,e){"function"!=typeof Object.assign&&(Object.assign=function(n){for(var t=[],o=1;o<arguments.length;o++)t[o-1]=arguments[o];if(!n)throw TypeError("Cannot convert undefined or null to object");for(var r=function(t){t&&Object.keys(t).forEach((function(o){return n[o]=t[o]}))},e=0,c=t;e<c.length;e++){r(c[e])}return n})},
"19b5a68a40": function _(e,t,o,i,a){i();const n=e("tslib");var s;const r=e("@bokehjs/core/dom"),c=e("@bokehjs/models/sources/column_data_source"),d=e("99a25e6992"),l=e("4e27eda472"),_=e("@bokehjs/models/layouts/layout_dom"),h=e("9588ab7c9e"),p=n.__importDefault(e("093eb75864"));function u(){const e={},t=window.deck,o=Object.keys(t).filter((e=>e.charAt(0)===e.charAt(0).toUpperCase()));for(const i of o)e[i]=t[i];return e}class w extends _.LayoutDOMView{connect_signals(){super.connect_signals();const{data:e,mapbox_api_key:t,tooltip:o,layers:i,initialViewState:a,data_sources:n}=this.model.properties;this.on_change([t,o],(()=>this.render())),this.on_change([e,a],(()=>this.updateDeck())),this.on_change([i],(()=>this._update_layers())),this.on_change([n],(()=>this._connect_sources(!0))),this._layer_map={},this._connected=[],this._connect_sources()}remove(){this.deckGL.finalize(),super.remove()}_update_layers(){this._layer_map={},this._update_data(!0)}_connect_sources(e=!1){for(const e of this.model.data_sources)this._connected.indexOf(e)<0&&(this.connect(e.properties.data.change,(()=>this._update_data(!0))),this._connected.push(e));this._update_data(e)}initialize(){if(super.initialize(),window.deck.JSONConverter){const{CSVLoader:e,Tiles3DLoader:t}=window.loaders;window.loaders.registerLoaders([t,e]);const o={classes:u(),enumerations:{COORDINATE_SYSTEM:window.deck.COORDINATE_SYSTEM,GL:p.default},constants:{Tiles3DLoader:t}};this.jsonConverter=new window.deck.JSONConverter({configuration:o})}}_update_data(e=!0){let t=0;for(const e of this.model.layers){let o;if(t+=1,t-1 in this._layer_map)o=this.model.data_sources[this._layer_map[t-1]];else{if("number"!=typeof e.data)continue;this._layer_map[t-1]=e.data,o=this.model.data_sources[e.data]}e.data=(0,l.transform_cds_to_records)(o)}e&&this.updateDeck()}_on_click_event(e){const t={coordinate:e.coordinate,lngLat:e.coordinate,index:e.index};e.layer&&(t.layer=e.layer.id),this.model.clickState=t}_on_hover_event(e){if(null==e.coordinate)return;const t={coordinate:e.coordinate,lngLat:e.coordinate,index:e.index};e.layer&&(t.layer=e.layer.id),this.model.hoverState=t}_on_viewState_event(e){const t=Object.assign({},e.viewState);delete t.normalize;for(const e in t)e.startsWith("transition")&&delete t[e];const o=new window.deck.WebMercatorViewport(t);t.nw=o.unproject([0,0]),t.se=o.unproject([o.width,o.height]),this.model.viewState=t}get child_models(){return[]}getData(){const e=this.model.throttle.view||200,t=this.model.throttle.hover||100,o=(0,d.debounce)((e=>this._on_viewState_event(e)),e,!1),i=(0,d.debounce)((e=>this._on_hover_event(e)),t,!1);return Object.assign(Object.assign({},this.model.data),{layers:this.model.layers,initialViewState:this.model.initialViewState,onViewStateChange:o,onClick:e=>this._on_click_event(e),onHover:i})}updateDeck(){if(!this.deckGL)return void this.render();const e=this.getData();if(window.deck.updateDeck)window.deck.updateDeck(e,this.deckGL);else{const t=this.jsonConverter.convert(e);this.deckGL.setProps(t)}}createDeck({mapboxApiKey:e,container:t,jsonInput:o,tooltip:i}){let a;try{const n=this.jsonConverter.convert(o),s=(0,h.makeTooltip)(i,n.layers);a=new window.deck.DeckGL(Object.assign(Object.assign({},n),{map:window.mapboxgl,mapboxApiAccessToken:e,container:t,getTooltip:s,width:"100%",height:"100%"}))}catch(e){console.error(e)}return a}render(){super.render();const e=(0,r.div)({class:"deckgl"}),t=this.model.mapbox_api_key,o=this.model.tooltip,i=this.getData();window.deck.createDeck?this.deckGL=window.deck.createDeck({mapboxApiKey:t,container:e,jsonInput:i,tooltip:o}):this.deckGL=this.createDeck({mapboxApiKey:t,container:e,jsonInput:i,tooltip:o}),this.shadow_el.appendChild(e)}after_layout(){super.after_layout(),this.deckGL.redraw(!0)}}o.DeckGLPlotView=w,w.__name__="DeckGLPlotView";class m extends _.LayoutDOM{constructor(e){super(e)}}o.DeckGLPlot=m,s=m,m.__name__="DeckGLPlot",m.__module__="panel.models.deckgl",s.prototype.default_view=w,s.define((({Any:e,Array:t,String:o,Ref:i})=>({data:[e],data_sources:[t(i(c.ColumnDataSource)),[]],clickState:[e,{}],hoverState:[e,{}],initialViewState:[e,{}],layers:[t(e),[]],mapbox_api_key:[o,""],throttle:[e,{}],tooltip:[e,!0],viewState:[e,{}]}))),s.override({height:400,width:600})},
"9588ab7c9e": function _(t,e,n,i,l){
/*
    This file was adapted from https://github.com/uber/deck.gl/ the LICENSE
    below is preserved to comply with the original license.
    
    Copyright (c) 2015 - 2017 Uber Technologies, Inc.
    
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
    
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
    
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
    */
let o,r;i();const c={fontFamily:'"Helvetica Neue", Helvetica, Arial, sans-serif',display:"flex",flex:"wrap",maxWidth:"500px",flexDirection:"column",zIndex:2};function s(){return document.createElement("div")}function a(t){if(!t.picked)return null;if(t.object===o)return r;const e={html:u(t.object),style:c};return r=e,o=t.object,e}n.getTooltipDefault=a;const f=new Set(["position","index"]);function u(t){const e=s();for(const n in t){if(f.has(n))continue;const i=s();i.className="header",i.textContent=n;const l=s();l.className="value",l.textContent=h(t[n]);const o=s();p(o,i,l),o.appendChild(i),o.appendChild(l),e.appendChild(o)}return e.innerHTML}function p(t,e,n){Object.assign(e.style,{fontWeight:700,marginRight:"10px",flex:"1 1 0%"}),Object.assign(n.style,{flex:"none",maxWidth:"250px",overflow:"hidden",whiteSpace:"nowrap",textOverflow:"ellipsis"}),Object.assign(t.style,{display:"flex",flexDirection:"row",justifyContent:"space-between",alignItems:"stretch"})}function h(t){let e;if(Array.isArray(t)&&t.length>4)e=`Array<${t.length}>`;else if("string"==typeof t)e=t;else if("number"==typeof t)e=String(t);else try{e=JSON.stringify(t)}catch(t){e="<Non-Serializable Object>"}return e.length>50&&(e=e.slice(0,50)),e}function d(t,e){let n=t;for(const t in e){if("object"==typeof e[t])for(const i in e[t])n=n.replace(`{${t}.${i}}`,e[t][i]);n=n.replace(`{${t}}`,e[t])}return n}n.tabularize=u,n.toText=h,n.substituteIn=d,n.makeTooltip=function(t,e){if(!t)return null;let n=!1;const i={};for(let l=0;l<e.length;l++){const o=e[l].id;"boolean"!=typeof t&&(l.toString()in t||o in t)&&(i[o]=o in t?t[o]:t[l.toString()],n=!0)}return t.html||t.text||n?e=>{if(!e.picked)return null;const l=n?i[e.layer.id]:t;if(null==l)return;if("boolean"==typeof l)return l?a(e):null;const o={style:l.style||c};return l.html?o.html=d(l.html,e.object):o.text=d(l.text,e.object),o}:a}},
"093eb75864": function _(E,_,R,T,A){_.exports={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,FUNC_ADD:32774,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,BLEND_COLOR:32773,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,VENDOR:7936,RENDERER:7937,VERSION:7938,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,BROWSER_DEFAULT_WEBGL:37444,STATIC_DRAW:35044,STREAM_DRAW:35040,DYNAMIC_DRAW:35048,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,CULL_FACE:2884,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,BLEND:3042,DEPTH_TEST:2929,DITHER:3024,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,SCISSOR_TEST:3089,STENCIL_TEST:2960,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CONTEXT_LOST_WEBGL:37442,CW:2304,CCW:2305,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DOUBLE:5130,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,COMPILE_STATUS:35713,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_ATTRIBUTES:35721,ACTIVE_UNIFORMS:35718,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,ALWAYS:519,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,GEQUAL:518,NOTEQUAL:517,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,TEXTURE_WIDTH:4096,TEXTURE_HEIGHT:4097,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,MAX_3D_TEXTURE_SIZE:32883,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,MAX_TEXTURE_LOD_BIAS:34045,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,RASTERIZER_DISCARD:35977,VERTEX_ARRAY_BINDING:34229,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,MAX_ELEMENT_INDEX:36203,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,RGB9_E5:35901,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,RGB10_A2UI:36975,TEXTURE_IMMUTABLE_FORMAT:37167,TEXTURE_IMMUTABLE_LEVELS:33503,UNSIGNED_INT_2_10_10_10_REV:33640,UNSIGNED_INT_10F_11F_11F_REV:35899,UNSIGNED_INT_5_9_9_9_REV:35902,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,UNSIGNED_INT_24_8:34042,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,INT_2_10_10_10_REV:36255,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,MAX_SAMPLES:36183,SAMPLER_BINDING:35097,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,UNSIGNED_NORMALIZED:35863,SIGNED_NORMALIZED:36764,VERTEX_ATTRIB_ARRAY_INTEGER:35069,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,DEPTH24_STENCIL8:35056,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,COLOR:6144,DEPTH:6145,STENCIL:6146,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,INVALID_INDEX:4294967295,TIMEOUT_IGNORED:-1,MAX_CLIENT_WAIT_TIMEOUT_WEBGL:37447,VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE:35070,UNMASKED_VENDOR_WEBGL:37445,UNMASKED_RENDERER_WEBGL:37446,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047,TEXTURE_MAX_ANISOTROPY_EXT:34046,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_RGBA8_ETC2_EAC:37493,COMPRESSED_SRGB8_ETC2:37494,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37495,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37496,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37497,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,COMPRESSED_RGB_ATC_WEBGL:35986,COMPRESSED_RGBA_ATC_EXPLICIT_ALPHA_WEBGL:35986,COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL:34798,UNSIGNED_INT_24_8_WEBGL:34042,HALF_FLOAT_OES:36193,RGBA32F_EXT:34836,RGB32F_EXT:34837,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT:33297,UNSIGNED_NORMALIZED_EXT:35863,MIN_EXT:32775,MAX_EXT:32776,SRGB_EXT:35904,SRGB_ALPHA_EXT:35906,SRGB8_ALPHA8_EXT:35907,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT:33296,FRAGMENT_SHADER_DERIVATIVE_HINT_OES:35723,COLOR_ATTACHMENT0_WEBGL:36064,COLOR_ATTACHMENT1_WEBGL:36065,COLOR_ATTACHMENT2_WEBGL:36066,COLOR_ATTACHMENT3_WEBGL:36067,COLOR_ATTACHMENT4_WEBGL:36068,COLOR_ATTACHMENT5_WEBGL:36069,COLOR_ATTACHMENT6_WEBGL:36070,COLOR_ATTACHMENT7_WEBGL:36071,COLOR_ATTACHMENT8_WEBGL:36072,COLOR_ATTACHMENT9_WEBGL:36073,COLOR_ATTACHMENT10_WEBGL:36074,COLOR_ATTACHMENT11_WEBGL:36075,COLOR_ATTACHMENT12_WEBGL:36076,COLOR_ATTACHMENT13_WEBGL:36077,COLOR_ATTACHMENT14_WEBGL:36078,COLOR_ATTACHMENT15_WEBGL:36079,DRAW_BUFFER0_WEBGL:34853,DRAW_BUFFER1_WEBGL:34854,DRAW_BUFFER2_WEBGL:34855,DRAW_BUFFER3_WEBGL:34856,DRAW_BUFFER4_WEBGL:34857,DRAW_BUFFER5_WEBGL:34858,DRAW_BUFFER6_WEBGL:34859,DRAW_BUFFER7_WEBGL:34860,DRAW_BUFFER8_WEBGL:34861,DRAW_BUFFER9_WEBGL:34862,DRAW_BUFFER10_WEBGL:34863,DRAW_BUFFER11_WEBGL:34864,DRAW_BUFFER12_WEBGL:34865,DRAW_BUFFER13_WEBGL:34866,DRAW_BUFFER14_WEBGL:34867,DRAW_BUFFER15_WEBGL:34868,MAX_COLOR_ATTACHMENTS_WEBGL:36063,MAX_DRAW_BUFFERS_WEBGL:34852,VERTEX_ARRAY_BINDING_OES:34229,QUERY_COUNTER_BITS_EXT:34916,CURRENT_QUERY_EXT:34917,QUERY_RESULT_EXT:34918,QUERY_RESULT_AVAILABLE_EXT:34919,TIME_ELAPSED_EXT:35007,TIMESTAMP_EXT:36392,GPU_DISJOINT_EXT:36795}},
"44fa3f3649": function _(e,t,s,n,o){var i,h;n();const c=e("@bokehjs/core/bokeh_events"),r=e("@bokehjs/core/dom"),a=e("490942d778"),l=e("c64c1219c8"),d=["click","dblclick","mousedown","mousemove","mouseup","mouseover","mouseout","globalout","contextmenu"].concat(["highlight","downplay","selectchanged","legendselectchangedEvent","legendselected","legendunselected","legendselectall","legendinverseselect","legendscroll","datazoom","datarangeselected","timelineplaychanged","restore","dataviewchanged","magictypechanged","geoselectchanged","geoselected","geounselected","axisareaselected","brush","brushEnd","rushselected","globalcursortaken","rendered","finished"]);class _ extends c.ModelEvent{constructor(e,t,s){super(),this.type=e,this.data=t,this.query=s}get event_values(){return{model:this.origin,type:this.type,data:this.data,query:this.query}}}s.EChartsEvent=_,i=_,_.__name__="EChartsEvent",i.prototype.event_name="echarts_event";class u extends l.HTMLBoxView{constructor(){super(...arguments),this._callbacks=[]}connect_signals(){super.connect_signals(),this.connect(this.model.properties.data.change,(()=>this._plot()));const{width:e,height:t,renderer:s,theme:n,event_config:o,js_events:i}=this.model.properties;this.on_change([e,t],(()=>this._resize())),this.on_change([n,s],(()=>this.render())),this.on_change([o,i],(()=>this._subscribe()))}render(){null!=this._chart&&window.echarts.dispose(this._chart),super.render(),this.container=(0,r.div)({style:"height: 100%; width: 100%;"});const e={width:this.model.width,height:this.model.height,renderer:this.model.renderer};this._chart=window.echarts.init(this.container,this.model.theme,e),this._plot(),this._subscribe(),this.shadow_el.append(this.container)}remove(){super.remove(),null!=this._chart&&window.echarts.dispose(this._chart)}after_layout(){super.after_layout(),this._chart.resize()}_plot(){null!=window.echarts&&this._chart.setOption(this.model.data,this.model.options)}_resize(){this._chart.resize({width:this.model.width,height:this.model.height})}_subscribe(){if(null!=window.echarts){for(const[e,t]of this._callbacks)this._chart.off(e,t);this._callbacks=[];for(const e in this.model.event_config){if(!d.includes(e)){console.warn(`Could not subscribe to unknown Echarts event: ${e}.`);continue}const t=this.model.event_config[e];for(const s of t){const t=t=>{var n;const o=Object.assign({},t);o.event=(0,a.serializeEvent)(null===(n=t.event)||void 0===n?void 0:n.event);const i=JSON.parse(JSON.stringify(o));this.model.trigger_event(new _(e,i,s))};null==s?this._chart.on(e,s,t):this._chart.on(e,t),this._callbacks.push([e,t])}}for(const e in this.model.js_events){if(!d.includes(e)){console.warn(`Could not subscribe to unknown Echarts event: ${e}.`);continue}const t=this.model.js_events[e];for(const s of t){const t=e=>{s.callback.execute(this._chart,e)};"query"in s?this._chart.on(e,s.query,t):this._chart.on(e,t),this._callbacks.push([e,t])}}}}}s.EChartsView=u,u.__name__="EChartsView";class g extends l.HTMLBox{constructor(e){super(e)}}s.ECharts=g,h=g,g.__name__="ECharts",g.__module__="panel.models.echarts",h.prototype.default_view=u,h.define((({Any:e,String:t})=>({data:[e,{}],options:[e,{}],event_config:[e,{}],js_events:[e,{}],theme:[t,"default"],renderer:[t,"canvas"]})))},
"490942d778": function _(e,t,a,r,n){function i(e){let t=null;return e&&(t=function(e){try{return{boundingClientRect:Object.assign({},e.getBoundingClientRect())}}catch(e){return{}}}(e),e.tagName in l&&l[e.tagName].forEach((a=>Object.assign(t,a(e))))),t}r(),a.serializeEvent=
/*
    The MIT License (MIT)
    
    Copyright (c) 2019 Ryan S. Morshead
    
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
    
    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.
    
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
    SOFTWARE.
    */
function(e){const t={};return void 0!==e.detail&&Object.assign(t,{detail:JSON.parse(JSON.stringify(e.detail))}),e.type in d&&Object.assign(t,d[e.type](e)),t.target=i(e.target),t.currentTarget=e.target===e.currentTarget?t.target:i(e.currentTarget),t.relatedTarget=i(e.relatedTarget),t};const o={hasValue:e=>({value:e.value}),hasCurrentTime:e=>({currentTime:e.currentTime}),hasFiles:e=>"file"===(null==e?void 0:e.type)?{files:Array.from(e.files).map((e=>({lastModified:e.lastModified,name:e.name,size:e.size,type:e.type})))}:{}};const s={hasValue:["BUTTON","INPUT","OPTION","LI","METER","PROGRESS","PARAM","SELECT","TEXTAREA"],hasCurrentTime:["AUDIO","VIDEO"],hasFiles:["INPUT"]},l={};Object.keys(s).forEach((e=>{s[e].forEach((t=>{(l[t]||(l[t]=[])).push(o[e])}))}));class c{clipboard(e){return{clipboardData:e.clipboardData}}composition(e){return{data:e.data}}keyboard(e){return{altKey:e.altKey,charCode:e.charCode,ctrlKey:e.ctrlKey,key:e.key,keyCode:e.keyCode,locale:e.locale,location:e.location,metaKey:e.metaKey,repeat:e.repeat,shiftKey:e.shiftKey,which:e.which}}mouse(e){return{altKey:e.altKey,button:e.button,buttons:e.buttons,clientX:e.clientX,clientY:e.clientY,ctrlKey:e.ctrlKey,metaKey:e.metaKey,pageX:e.pageX,pageY:e.pageY,screenX:e.screenX,screenY:e.screenY,shiftKey:e.shiftKey}}pointer(e){return Object.assign(Object.assign({},this.mouse(e)),{pointerId:e.pointerId,width:e.width,height:e.height,pressure:e.pressure,tiltX:e.tiltX,tiltY:e.tiltY,pointerType:e.pointerType,isPrimary:e.isPrimary})}selection(){return{selectedText:window.getSelection().toString()}}touch(e){return{altKey:e.altKey,ctrlKey:e.ctrlKey,metaKey:e.metaKey,shiftKey:e.shiftKey}}ui(e){return{detail:e.detail}}wheel(e){return{deltaMode:e.deltaMode,deltaX:e.deltaX,deltaY:e.deltaY,deltaZ:e.deltaZ}}animation(e){return{animationName:e.animationName,pseudoElement:e.pseudoElement,elapsedTime:e.elapsedTime}}transition(e){return{propertyName:e.propertyName,pseudoElement:e.pseudoElement,elapsedTime:e.elapsedTime}}}c.__name__="EventTransformCategories";const u={clipboard:["copy","cut","paste"],composition:["compositionend","compositionstart","compositionupdate"],keyboard:["keydown","keypress","keyup"],mouse:["click","contextmenu","doubleclick","drag","dragend","dragenter","dragexit","dragleave","dragover","dragstart","drop","mousedown","mouseenter","mouseleave","mousemove","mouseout","mouseover","mouseup"],pointer:["pointerdown","pointermove","pointerup","pointercancel","gotpointercapture","lostpointercapture","pointerenter","pointerleave","pointerover","pointerout"],selection:["select"],touch:["touchcancel","touchend","touchmove","touchstart"],ui:["scroll"],wheel:["wheel"],animation:["animationstart","animationend","animationiteration"],transition:["transitionend"]},d={},p=new c;Object.keys(u).forEach((e=>{u[e].forEach((t=>{d[t]=p[e]}))}))},
"e6943b23b3": function _(e,t,i,l,s){l();const o=e("tslib");var n;const h=e("@bokehjs/core/build_views"),a=e("@bokehjs/core/enums"),_=e("@bokehjs/models/widgets/input_widget"),d=e("@bokehjs/models/ui/icons/icon"),r=o.__importStar(e("@bokehjs/styles/buttons.css")),c=r,u=e("@bokehjs/core/dom");class b extends _.InputWidgetView{constructor(){super(...arguments),this._downloadable=!1,this._prev_href="",this._prev_download=""}*children(){yield*super.children(),null!=this.icon_view&&(yield this.icon_view)}*controls(){yield this.anchor_el,yield this.button_el}connect_signals(){super.connect_signals(),this.connect(this.model.properties.button_type.change,(()=>this._update_button_style())),this.connect(this.model.properties.filename.change,(()=>this._update_download())),this.connect(this.model.properties._transfers.change,(()=>this._handle_click())),this.connect(this.model.properties.label.change,(()=>this._update_label()))}remove(){null!=this.icon_view&&this.icon_view.remove(),super.remove()}async lazy_initialize(){await super.lazy_initialize();const{icon:e}=this.model;null!=e&&(this.icon_view=await(0,h.build_view)(e,{parent:this}))}render(){if(super.render(),this.group_el.style.display="flex",this.group_el.style.alignItems="stretch",this.anchor_el=document.createElement("a"),this.button_el=(0,u.button)({disabled:this.model.disabled,type:"bk_btn, bk_btn_type"}),null!=this.icon_view){const e=""!=this.model.label?(0,u.nbsp)():(0,u.text)("");(0,u.prepend)(this.button_el,this.icon_view.el,e),this.icon_view.render()}this._update_button_style(),this._update_label(),this.model.disabled?(this.anchor_el.setAttribute("disabled",""),this._downloadable=!1):(this.anchor_el.removeAttribute("disabled"),this._prev_download&&(this.anchor_el.download=this._prev_download),this._prev_href&&(this.anchor_el.href=this._prev_href),this.anchor_el.download&&this.anchor_el.download&&(this._downloadable=!0)),this.model.embed?this._make_link_downloadable():(this._click_listener=this._increment_clicks.bind(this),this.anchor_el.addEventListener("click",this._click_listener)),this.button_el.appendChild(this.anchor_el),this.group_el.appendChild(this.button_el)}stylesheets(){return[...super.stylesheets(),r.default]}_increment_clicks(){this.model.clicks=this.model.clicks+1}_handle_click(){!this.model.auto&&this._downloadable||this.anchor_el.hasAttribute("disabled")||(this._make_link_downloadable(),!this.model.embed&&this.model.auto&&(this.anchor_el.removeEventListener("click",this._click_listener),this.anchor_el.click(),this.anchor_el.removeAttribute("href"),this.anchor_el.removeAttribute("download"),this.anchor_el.addEventListener("click",this._click_listener)),this._prev_href=this.anchor_el.getAttribute("href"),this._prev_download=this.anchor_el.getAttribute("download"))}_make_link_downloadable(){this._update_href(),this._update_download(),this.anchor_el.download&&this.anchor_el.href&&(this._downloadable=!0)}_update_href(){if(this.model.data){const e=function(e){const t=atob(e.split(",")[1]),i=e.split(",")[0].split(":")[1].split(";")[0],l=new ArrayBuffer(t.length),s=new Uint8Array(l);for(let e=0;e<t.length;e++)s[e]=t.charCodeAt(e);return new Blob([l],{type:i})}(this.model.data);this.anchor_el.href=URL.createObjectURL(e)}}_update_download(){this.model.filename&&(this.anchor_el.download=this.model.filename)}_update_label(){this.anchor_el.textContent=this.model.label}_update_button_style(){const e=c[`btn_${this.model.button_type}`];if(this.button_el.hasAttribute("class")){const t=this.anchor_el.classList.item(1);t&&this.button_el.classList.replace(t,e)}else this.button_el.classList.add(c.btn),this.button_el.classList.add(e)}}i.FileDownloadView=b,b.__name__="FileDownloadView";class p extends _.InputWidget{constructor(e){super(e)}}i.FileDownload=p,n=p,p.__name__="FileDownload",p.__module__="panel.models.widgets",n.prototype.default_view=b,n.define((({Boolean:e,Int:t,Nullable:i,Ref:l,String:s})=>({auto:[e,!1],clicks:[t,0],data:[i(s),null],embed:[e,!1],icon:[i(l(d.Icon)),null],label:[s,"Download"],filename:[i(s),null],button_type:[a.ButtonType,"default"],_transfers:[t,0]}))),n.override({title:""})},
"3db2e41978": function _(e,t,s,n,i){var r,o;n();const l=e("@bokehjs/core/bokeh_events"),h=e("@bokehjs/models/widgets/markup"),a=e("c64c1219c8"),c=e("490942d778");class d extends l.ModelEvent{constructor(e,t){super(),this.node=e,this.data=t}get event_values(){return{model:this.origin,node:this.node,data:this.data}}}function _(e){return(new DOMParser).parseFromString(e,"text/html").documentElement.textContent}function u(e){Array.from(e.querySelectorAll("script")).forEach((e=>{const t=document.createElement("script");Array.from(e.attributes).forEach((e=>t.setAttribute(e.name,e.value))),t.appendChild(document.createTextNode(e.innerHTML)),e.parentNode&&e.parentNode.replaceChild(t,e)}))}s.DOMEvent=d,r=d,d.__name__="DOMEvent",r.prototype.event_name="dom_event",s.htmlDecode=_,s.runScripts=u;class v extends a.PanelMarkupView{constructor(){super(...arguments),this._event_listeners={}}connect_signals(){super.connect_signals(),this.connect(this.model.properties.text.change,(()=>{const e=this.process_tex();this.set_html(e)})),this.connect(this.model.properties.visible.change,(()=>{this.model.visible&&(this.container.style.visibility="visible")})),this.connect(this.model.properties.events.change,(()=>{this._remove_event_listeners(),this._setup_event_listeners()}))}rerender(){this.render(),this.invalidate_layout()}set_html(e){e&&(this.container.innerHTML=e,this.model.run_scripts&&u(this.container),this._setup_event_listeners())}render(){super.render(),this.container.style.visibility="hidden",this.shadow_el.appendChild(this.container),"failed"!=this.provider.status&&"loaded"!=this.provider.status||(this._has_finished=!0);const e=this.process_tex();this.watch_stylesheets(),this.set_html(e)}style_redraw(){this.model.visible&&(this.container.style.visibility="visible")}process_tex(){const e=_(this.model.text)||this.model.text;if(this.model.disable_math||!this.contains_tex(e))return e;const t=this.provider.MathJax.find_tex(e),s=[];let n=0;for(const i of t)s.push(e.slice(n,i.start.n)),s.push(this.provider.MathJax.tex2svg(i.math,{display:i.display}).outerHTML),n=i.end.n;return n<e.length&&s.push(e.slice(n)),s.join("")}contains_tex(e){return!!this.provider.MathJax&&this.provider.MathJax.find_tex(e).length>0}_remove_event_listeners(){for(const e in this._event_listeners){const t=document.getElementById(e);if(null!=t)for(const s in this._event_listeners[e]){const n=this._event_listeners[e][s];t.removeEventListener(s,n)}else console.warn(`DOM node '${e}' could not be found. Cannot subscribe to DOM events.`)}this._event_listeners={}}_setup_event_listeners(){for(const e in this.model.events){const t=document.getElementById(e);if(null!=t)for(const s of this.model.events[e]){const n=t=>{this.model.trigger_event(new d(e,(0,c.serializeEvent)(t)))};t.addEventListener(s,n),e in this._event_listeners||(this._event_listeners[e]={}),this._event_listeners[e][s]=n}else console.warn(`DOM node '${e}' could not be found. Cannot subscribe to DOM events.`)}}}s.HTMLView=v,v.__name__="HTMLView";class p extends h.Markup{constructor(e){super(e)}}s.HTML=p,o=p,p.__name__="HTML",p.__module__="panel.models.markup",o.prototype.default_view=v,o.define((({Any:e,Boolean:t})=>({events:[e,{}],run_scripts:[t,!0]})))},
"4dfd782539": function _(e,i,t,n,s){var o;n();const l=e("@bokehjs/core/dom"),r=e("c64c1219c8"),d=window.Jupyter;class a extends r.HTMLBoxView{initialize(){let e;if(super.initialize(),null!=d&&null!=d.notebook)e=d.notebook.kernel.widget_manager;else{if(null==window.PyViz.widget_manager)return void console.warn("Panel IPyWidget model could not find a WidgetManager");e=window.PyViz.widget_manager}this.manager=e,this.ipychildren=[]}remove(){this.ipyview.remove(),super.remove()}_ipy_stylesheets(){const e=[];for(const i of document.head.children)if(i instanceof HTMLStyleElement){const t=i.textContent;if(null!=t){const i=t.replace(/:root/g,":host");e.push(new l.InlineStyleSheet(i))}}return e}stylesheets(){return[...super.stylesheets(),...this._ipy_stylesheets()]}render(){super.render();const{spec:e,state:i}=this.model.bundle;this.manager.set_state(i).then((async i=>{const t=i.find((i=>i.model_id==e.model_id));if(null==t)return;const n=await this.manager.create_view(t,{el:this.el});if(this.ipyview=n,this.ipychildren=[],n.children_views)for(const e of n.children_views.views)this.ipychildren.push(await e);this.shadow_el.appendChild(this.ipyview.el),this.ipyview.trigger("displayed",this.ipyview);for(const e of this.ipychildren)e.trigger("displayed",e);this.invalidate_layout()}))}}t.IPyWidgetView=a,a.__name__="IPyWidgetView";class h extends r.HTMLBox{constructor(e){super(e)}}t.IPyWidget=h,o=h,h.__name__="IPyWidget",h.__module__="panel.models.ipywidget",o.prototype.default_view=a,o.define((({Any:e})=>({bundle:[e,{}]})))},
"e954d48822": function _(e,t,r,n,s){n();const o=e("tslib");var i;const d=e("@bokehjs/core/kinds"),a=e("@bokehjs/models/widgets/markup"),l=o.__importDefault(e("18bba7b7e1")),h=e("c64c1219c8");class c extends h.PanelMarkupView{connect_signals(){super.connect_signals();const{depth:e,hover_preview:t,text:r,theme:n}=this.model.properties;this.on_change([e,t,r,n],(()=>this.render()))}render(){super.render();const e=this.model.text.replace(/(\r\n|\n|\r)/gm,"");let t;try{t=window.JSON.parse(e)}catch(e){return void(this.container.innerHTML="<b>Invalid JSON:</b> "+e.toString())}const r={hoverPreviewEnabled:this.model.hover_preview,theme:this.model.theme},n=null==this.model.depth?1/0:this.model.depth,s=new l.default(t,n,r).render();let o="border-radius: 5px; padding: 10px; width: 100%; height: 100%;";"dark"==this.model.theme?s.style.cssText="background-color: rgb(30, 30, 30);"+o:s.style.cssText=o,this.container.append(s)}}r.JSONView=c,c.__name__="JSONView",r.JSONTheme=(0,d.Enum)("dark","light");class p extends a.Markup{constructor(e){super(e)}}r.JSON=p,i=p,p.__name__="JSON",p.__module__="panel.models.markup",i.prototype.default_view=c,i.define((({Array:e,Boolean:t,Int:n,Nullable:s,String:o})=>({css:[e(o),[]],depth:[s(n),1],hover_preview:[t,!1],theme:[r.JSONTheme,"dark"]})))},
"18bba7b7e1": function _(t,e,r,n,o){function i(t){return null===t?"null":typeof t}function s(t){return!!t&&"object"==typeof t}function a(t){if(void 0===t)return"";if(null===t)return"Object";if("object"==typeof t&&!t.constructor)return"Object";var e=/function ([^(]*)/.exec(t.constructor.toString());return e&&e.length>1?e[1]:""}function f(t,e,r){return"null"===t||"undefined"===t?t:("string"!==t&&"stringifiable"!==t||(r='"'+r.replace(/"/g,'\\"')+'"'),"function"===t?e.toString().replace(/[\r\n]/g,"").replace(/\{.*\}/,"")+"{\u2026}":r)}function m(t){var e="";return s(t)?(e=a(t),Array.isArray(t)&&(e+="["+t.length+"]")):e=f(i(t),t,t),e}function l(t){return"json-formatter-"+t}function d(t,e,r){var n=document.createElement(t);return e&&n.classList.add(l(e)),void 0!==r&&(r instanceof Node?n.appendChild(r):n.appendChild(document.createTextNode(String(r)))),n}n(),function(t){if(t&&"undefined"!=typeof window){var e=document.createElement("style");e.setAttribute("media","screen"),e.innerHTML=t,document.head.appendChild(e)}}('.json-formatter-row {\n  font-family: monospace;\n}\n.json-formatter-row,\n.json-formatter-row a,\n.json-formatter-row a:hover {\n  color: black;\n  text-decoration: none;\n}\n.json-formatter-row .json-formatter-row {\n  margin-left: 1rem;\n}\n.json-formatter-row .json-formatter-children.json-formatter-empty {\n  opacity: 0.5;\n  margin-left: 1rem;\n}\n.json-formatter-row .json-formatter-children.json-formatter-empty:after {\n  display: none;\n}\n.json-formatter-row .json-formatter-children.json-formatter-empty.json-formatter-object:after {\n  content: "No properties";\n}\n.json-formatter-row .json-formatter-children.json-formatter-empty.json-formatter-array:after {\n  content: "[]";\n}\n.json-formatter-row .json-formatter-string,\n.json-formatter-row .json-formatter-stringifiable {\n  color: green;\n  white-space: pre;\n  word-wrap: break-word;\n}\n.json-formatter-row .json-formatter-number {\n  color: blue;\n}\n.json-formatter-row .json-formatter-boolean {\n  color: red;\n}\n.json-formatter-row .json-formatter-null {\n  color: #855A00;\n}\n.json-formatter-row .json-formatter-undefined {\n  color: #ca0b69;\n}\n.json-formatter-row .json-formatter-function {\n  color: #FF20ED;\n}\n.json-formatter-row .json-formatter-date {\n  background-color: rgba(0, 0, 0, 0.05);\n}\n.json-formatter-row .json-formatter-url {\n  text-decoration: underline;\n  color: blue;\n  cursor: pointer;\n}\n.json-formatter-row .json-formatter-bracket {\n  color: blue;\n}\n.json-formatter-row .json-formatter-key {\n  color: #00008B;\n  padding-right: 0.2rem;\n}\n.json-formatter-row .json-formatter-toggler-link {\n  cursor: pointer;\n}\n.json-formatter-row .json-formatter-toggler {\n  line-height: 1.2rem;\n  font-size: 0.7rem;\n  vertical-align: middle;\n  opacity: 0.6;\n  cursor: pointer;\n  padding-right: 0.2rem;\n}\n.json-formatter-row .json-formatter-toggler:after {\n  display: inline-block;\n  transition: transform 100ms ease-in;\n  content: "\u25ba";\n}\n.json-formatter-row > a > .json-formatter-preview-text {\n  opacity: 0;\n  transition: opacity 0.15s ease-in;\n  font-style: italic;\n}\n.json-formatter-row:hover > a > .json-formatter-preview-text {\n  opacity: 0.6;\n}\n.json-formatter-row.json-formatter-open > .json-formatter-toggler-link .json-formatter-toggler:after {\n  transform: rotate(90deg);\n}\n.json-formatter-row.json-formatter-open > .json-formatter-children:after {\n  display: inline-block;\n}\n.json-formatter-row.json-formatter-open > a > .json-formatter-preview-text {\n  display: none;\n}\n.json-formatter-row.json-formatter-open.json-formatter-empty:after {\n  display: block;\n}\n.json-formatter-dark.json-formatter-row {\n  font-family: monospace;\n}\n.json-formatter-dark.json-formatter-row,\n.json-formatter-dark.json-formatter-row a,\n.json-formatter-dark.json-formatter-row a:hover {\n  color: white;\n  text-decoration: none;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-row {\n  margin-left: 1rem;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-children.json-formatter-empty {\n  opacity: 0.5;\n  margin-left: 1rem;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-children.json-formatter-empty:after {\n  display: none;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-children.json-formatter-empty.json-formatter-object:after {\n  content: "No properties";\n}\n.json-formatter-dark.json-formatter-row .json-formatter-children.json-formatter-empty.json-formatter-array:after {\n  content: "[]";\n}\n.json-formatter-dark.json-formatter-row .json-formatter-string,\n.json-formatter-dark.json-formatter-row .json-formatter-stringifiable {\n  color: #31F031;\n  white-space: pre;\n  word-wrap: break-word;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-number {\n  color: #66C2FF;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-boolean {\n  color: #EC4242;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-null {\n  color: #EEC97D;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-undefined {\n  color: #ef8fbe;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-function {\n  color: #FD48CB;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-date {\n  background-color: rgba(255, 255, 255, 0.05);\n}\n.json-formatter-dark.json-formatter-row .json-formatter-url {\n  text-decoration: underline;\n  color: #027BFF;\n  cursor: pointer;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-bracket {\n  color: #9494FF;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-key {\n  color: #23A0DB;\n  padding-right: 0.2rem;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-toggler-link {\n  cursor: pointer;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-toggler {\n  line-height: 1.2rem;\n  font-size: 0.7rem;\n  vertical-align: middle;\n  opacity: 0.6;\n  cursor: pointer;\n  padding-right: 0.2rem;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-toggler:after {\n  display: inline-block;\n  transition: transform 100ms ease-in;\n  content: "\u25ba";\n}\n.json-formatter-dark.json-formatter-row > a > .json-formatter-preview-text {\n  opacity: 0;\n  transition: opacity 0.15s ease-in;\n  font-style: italic;\n}\n.json-formatter-dark.json-formatter-row:hover > a > .json-formatter-preview-text {\n  opacity: 0.6;\n}\n.json-formatter-dark.json-formatter-row.json-formatter-open > .json-formatter-toggler-link .json-formatter-toggler:after {\n  transform: rotate(90deg);\n}\n.json-formatter-dark.json-formatter-row.json-formatter-open > .json-formatter-children:after {\n  display: inline-block;\n}\n.json-formatter-dark.json-formatter-row.json-formatter-open > a > .json-formatter-preview-text {\n  display: none;\n}\n.json-formatter-dark.json-formatter-row.json-formatter-open.json-formatter-empty:after {\n  display: block;\n}\n');var c=/(^\d{1,4}[\.|\\/|-]\d{1,2}[\.|\\/|-]\d{1,4})(\s*(?:0?[1-9]:[0-5]|1(?=[012])\d:[0-5])\d\s*[ap]m)?$/,p=/\d{2}:\d{2}:\d{2} GMT-\d{4}/,j=/\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}.\d{3}Z/,h=window.requestAnimationFrame||function(t){return t(),0},u={hoverPreviewEnabled:!1,hoverPreviewArrayCount:100,hoverPreviewFieldCount:5,animateOpen:!0,animateClose:!0,theme:null,useToJSON:!0,sortPropertiesBy:null},g=function(){function t(t,e,r,n){void 0===e&&(e=1),void 0===r&&(r=u),this.json=t,this.open=e,this.config=r,this.key=n,this._isOpen=null,void 0===this.config.hoverPreviewEnabled&&(this.config.hoverPreviewEnabled=u.hoverPreviewEnabled),void 0===this.config.hoverPreviewArrayCount&&(this.config.hoverPreviewArrayCount=u.hoverPreviewArrayCount),void 0===this.config.hoverPreviewFieldCount&&(this.config.hoverPreviewFieldCount=u.hoverPreviewFieldCount),void 0===this.config.useToJSON&&(this.config.useToJSON=u.useToJSON),""===this.key&&(this.key='""')}return Object.defineProperty(t.prototype,"isOpen",{get:function(){return null!==this._isOpen?this._isOpen:this.open>0},set:function(t){this._isOpen=t},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isDate",{get:function(){return this.json instanceof Date||"string"===this.type&&(c.test(this.json)||j.test(this.json)||p.test(this.json))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isUrl",{get:function(){return"string"===this.type&&0===this.json.indexOf("http")},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isArray",{get:function(){return Array.isArray(this.json)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isObject",{get:function(){return s(this.json)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isEmptyObject",{get:function(){return!this.keys.length&&!this.isArray},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isEmpty",{get:function(){return this.isEmptyObject||this.keys&&!this.keys.length&&this.isArray},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"useToJSON",{get:function(){return this.config.useToJSON&&"stringifiable"===this.type},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"hasKey",{get:function(){return void 0!==this.key},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"constructorName",{get:function(){return a(this.json)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"type",{get:function(){return this.config.useToJSON&&this.json&&this.json.toJSON?"stringifiable":i(this.json)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"keys",{get:function(){if(this.isObject){var t=Object.keys(this.json);return!this.isArray&&this.config.sortPropertiesBy?t.sort(this.config.sortPropertiesBy):t}return[]},enumerable:!0,configurable:!0}),t.prototype.toggleOpen=function(){this.isOpen=!this.isOpen,this.element&&(this.isOpen?this.appendChildren(this.config.animateOpen):this.removeChildren(this.config.animateClose),this.element.classList.toggle(l("open")))},t.prototype.openAtDepth=function(t){void 0===t&&(t=1),t<0||(this.open=t,this.isOpen=0!==t,this.element&&(this.removeChildren(!1),0===t?this.element.classList.remove(l("open")):(this.appendChildren(this.config.animateOpen),this.element.classList.add(l("open")))))},t.prototype.getInlinepreview=function(){var t=this;if(this.isArray)return this.json.length>this.config.hoverPreviewArrayCount?"Array["+this.json.length+"]":"["+this.json.map(m).join(", ")+"]";var e=this.keys,r=e.slice(0,this.config.hoverPreviewFieldCount).map((function(e){return e+":"+m(t.json[e])})),n=e.length>=this.config.hoverPreviewFieldCount?"\u2026":"";return"{"+r.join(", ")+n+"}"},t.prototype.render=function(){this.element=d("div","row");var t=this.isObject?d("a","toggler-link"):d("span");if(this.isObject&&!this.useToJSON&&t.appendChild(d("span","toggler")),this.hasKey&&t.appendChild(d("span","key",this.key+":")),this.isObject&&!this.useToJSON){var e=d("span","value"),r=d("span"),n=d("span","constructor-name",this.constructorName);if(r.appendChild(n),this.isArray){var o=d("span");o.appendChild(d("span","bracket","[")),o.appendChild(d("span","number",this.json.length)),o.appendChild(d("span","bracket","]")),r.appendChild(o)}e.appendChild(r),t.appendChild(e)}else{(e=this.isUrl?d("a"):d("span")).classList.add(l(this.type)),this.isDate&&e.classList.add(l("date")),this.isUrl&&(e.classList.add(l("url")),e.setAttribute("href",this.json));var i=f(this.type,this.json,this.useToJSON?this.json.toJSON():this.json);e.appendChild(document.createTextNode(i)),t.appendChild(e)}if(this.isObject&&this.config.hoverPreviewEnabled){var s=d("span","preview-text");s.appendChild(document.createTextNode(this.getInlinepreview())),t.appendChild(s)}var a=d("div","children");return this.isObject&&a.classList.add(l("object")),this.isArray&&a.classList.add(l("array")),this.isEmpty&&a.classList.add(l("empty")),this.config&&this.config.theme&&this.element.classList.add(l(this.config.theme)),this.isOpen&&this.element.classList.add(l("open")),this.element.appendChild(t),this.element.appendChild(a),this.isObject&&this.isOpen&&this.appendChildren(),this.isObject&&!this.useToJSON&&t.addEventListener("click",this.toggleOpen.bind(this)),this.element},t.prototype.appendChildren=function(e){var r=this;void 0===e&&(e=!1);var n=this.element.querySelector("div."+l("children"));if(n&&!this.isEmpty)if(e){var o=0,i=function(){var e=r.keys[o],s=new t(r.json[e],r.open-1,r.config,e);n.appendChild(s.render()),(o+=1)<r.keys.length&&(o>10?i():h(i))};h(i)}else this.keys.forEach((function(e){var o=new t(r.json[e],r.open-1,r.config,e);n.appendChild(o.render())}))},t.prototype.removeChildren=function(t){void 0===t&&(t=!1);var e=this.element.querySelector("div."+l("children"));if(t){var r=0,n=function(){e&&e.children.length&&(e.removeChild(e.children[0]),(r+=1)>10?n():h(n))};h(n)}else e&&(e.innerHTML="")},t}();r.default=g},
"3c56a75fcf": function _(e,t,s,o,i){var n,d;o();const h=e("@bokehjs/core/dom"),a=e("@bokehjs/core/bokeh_events"),r=e("c64c1219c8");class m extends a.ModelEvent{constructor(e){super(),this.data=e}get event_values(){return{model:this.origin,data:this.data}}}s.JSONEditEvent=m,n=m,m.__name__="JSONEditEvent",n.prototype.event_name="json_edit";class l extends r.HTMLBoxView{connect_signals(){super.connect_signals();const{data:e,disabled:t,templates:s,menu:o,mode:i,search:n,schema:d}=this.model.properties;this.on_change([e],(()=>this.editor.update(this.model.data))),this.on_change([s],(()=>{this.editor.options.templates=this.model.templates})),this.on_change([o],(()=>{this.editor.options.menu=this.model.menu})),this.on_change([n],(()=>{this.editor.options.search=this.model.search})),this.on_change([d],(()=>{this.editor.options.schema=this.model.schema})),this.on_change([t,i],(()=>{const e=this.model.disabled?"view":this.model.mode;this.editor.setMode(e)}))}stylesheets(){const e=super.stylesheets();for(const t of this.model.css)e.push(new h.ImportedStyleSheet(t));return e}remove(){super.remove(),this.editor.destroy()}render(){super.render();const e=this.model.disabled?"view":this.model.mode;this.editor=new window.JSONEditor(this.shadow_el,{menu:this.model.menu,mode:e,onChangeJSON:e=>{this.model.data=e},onSelectionChange:(e,t)=>{this.model.selection=[e,t]},search:this.model.search,schema:this.model.schema,templates:this.model.templates}),this.editor.set(this.model.data)}}s.JSONEditorView=l,l.__name__="JSONEditorView";class c extends r.HTMLBox{constructor(e){super(e)}}s.JSONEditor=c,d=c,c.__name__="JSONEditor",c.__module__="panel.models.jsoneditor",d.prototype.default_view=l,d.define((({Any:e,Array:t,Boolean:s,String:o})=>({css:[t(o),[]],data:[e,{}],mode:[o,"tree"],menu:[s,!0],search:[s,!0],selection:[t(e),[]],schema:[e,null],templates:[t(e),[]]})))},
"001dfd2dde": function _(e,t,n,s,i){var r;s();const a=e("@bokehjs/models/widgets/markup"),l=e("c64c1219c8");class d extends l.PanelMarkupView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.text.change,(()=>this.render()))}render(){super.render(),this.container.innerHTML=this.model.text,window.renderMathInElement&&window.renderMathInElement(this.shadow_el,{delimiters:[{left:"$$",right:"$$",display:!0},{left:"\\[",right:"\\]",display:!0},{left:"$",right:"$",display:!1},{left:"\\(",right:"\\)",display:!1}]})}}n.KaTeXView=d,d.__name__="KaTeXView";class o extends a.Markup{constructor(e){super(e)}}n.KaTeX=o,r=o,o.__name__="KaTeX",o.__module__="panel.models.katex",r.prototype.default_view=d},
"a85ed38ee9": function _(e,o,t,h,i){var a;h();const s=e("@bokehjs/core/view"),n=e("@bokehjs/model");class d extends s.View{initialize(){super.initialize(),this.model.pathname=window.location.pathname,this.model.search=window.location.search,this.model.hash=window.location.hash,this.model.href=window.location.href,this.model.hostname=window.location.hostname,this.model.protocol=window.location.protocol,this.model.port=window.location.port,this._hash_listener=()=>{this.model.hash=window.location.hash},window.addEventListener("hashchange",this._hash_listener),this._has_finished=!0,this.notify_finished()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.pathname.change,(()=>this.update("pathname"))),this.connect(this.model.properties.search.change,(()=>this.update("search"))),this.connect(this.model.properties.hash.change,(()=>this.update("hash"))),this.connect(this.model.properties.reload.change,(()=>this.update("reload")))}remove(){super.remove(),window.removeEventListener("hashchange",this._hash_listener)}update(e){this.model.reload&&"reload"!==e?("pathname"==e&&(window.location.pathname=this.model.pathname),"search"==e&&(window.location.search=this.model.search),"hash"==e&&(window.location.hash=this.model.hash)):(window.history.pushState({},"",`${this.model.pathname}${this.model.search}${this.model.hash}`),this.model.href=window.location.href,"reload"===e&&window.location.reload())}}t.LocationView=d,d.__name__="LocationView";class l extends n.Model{constructor(e){super(e)}}t.Location=l,a=l,l.__name__="Location",l.__module__="panel.models.location",a.prototype.default_view=d,a.define((({Boolean:e,String:o})=>({href:[o,""],hostname:[o,""],pathname:[o,""],protocol:[o,""],port:[o,""],search:[o,""],hash:[o,""],reload:[e,!1]})))},
"ca760ebc92": function _(e,t,s,a,n){var r;a();const i=e("@bokehjs/models/widgets/markup"),o=e("c64c1219c8");class _ extends o.PanelMarkupView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.text.change,(()=>this.render()))}render(){super.render(),this.container.innerHTML=this.has_math_disabled()?this.model.text:this.process_tex(this.model.text)}}s.MathJaxView=_,_.__name__="MathJaxView";class c extends i.Markup{constructor(e){super(e)}}s.MathJax=c,r=c,c.__name__="MathJax",c.__module__="panel.models.mathjax",r.prototype.default_view=_},
"46cccf2270": function _(e,t,s,n,o){var i;n();const a=e("@bokehjs/models/widgets/markup"),r=e("c64c1219c8"),d=e("3db2e41978");class c extends r.PanelMarkupView{connect_signals(){super.connect_signals();const e=this.model.properties,{text:t,width:s,height:n,embed:o,start_page:i}=e;this.on_change([t,s,n,o,i],(()=>{this.update()}))}render(){super.render(),this.update()}update(){if(this.model.embed){const e=this.convert_base64_to_blob(),t=URL.createObjectURL(e),s=this.model.width||"100%",n=this.model.height||"100%";this.container.innerHTML=`<embed src="${t}#page=${this.model.start_page}" type="application/pdf" width="${s}" height="${n}"></embed>`}else{const e=(0,d.htmlDecode)(this.model.text);this.container.innerHTML=e||""}}convert_base64_to_blob(){const e=atob(this.model.text);var t=[];for(let s=0;s<e.length;s+=512){const n=e.slice(s,s+512),o=new Uint8Array(n.length);for(let e=0;e<n.length;e++)o[e]=n.charCodeAt(e);t.push(o)}return new Blob(t,{type:"application/pdf"})}}s.PDFView=c,c.__name__="PDFView";class l extends a.Markup{constructor(e){super(e)}}s.PDF=l,i=l,l.__name__="PDF",l.__module__="panel.models.markup",i.prototype.default_view=c,i.define((({Number:e,Boolean:t})=>({embed:[t,!0],start_page:[e,1]})))},
"5f38562b04": function _(e,t,s,i,n){var r,o;i();const l=e("@bokehjs/core/bokeh_events"),c=e("@bokehjs/core/dom"),a=e("@bokehjs/models/sources/column_data_source"),h=e("c64c1219c8"),p={"material-dark":"Material Dark",material:"Material Light",vaporwave:"Vaporwave",solarized:"Solarized","solarized-dark":"Solarized Dark",monokai:"Monokai"},d={datagrid:"Datagrid",d3_x_bar:"X Bar",d3_y_bar:"Y Bar",d3_xy_line:"X/Y Line",d3_y_line:"Y Line",d3_y_area:"Y Area",d3_y_scatter:"Y Scatter",d3_xy_scatter:"X/Y Scatter",d3_treemap:"Treemap",d3_candlestick:"Candlestick",d3_sunburst:"Sunburst",d3_heatmap:"Heatmap",d3_ohlc:"OHLC"};function _(e){const t={};return Object.keys(e).forEach((s=>{t[e[s]]=s})),t}const g=_(d),m=_(p);class u extends l.ModelEvent{constructor(e,t,s){super(),this.config=e,this.column_names=t,this.row=s}get event_values(){return{model:this.origin,config:this.config,column_names:this.column_names,row:this.row}}}s.PerspectiveClickEvent=u,r=u,u.__name__="PerspectiveClickEvent",r.prototype.event_name="perspective-click";class v extends h.HTMLBoxView{constructor(){super(...arguments),this._updating=!1,this._config_listener=null,this._current_config=null,this._loaded=!1}connect_signals(){super.connect_signals(),this.connect(this.model.source.properties.data.change,(()=>this.setData())),this.connect(this.model.source.streaming,(()=>this.stream())),this.connect(this.model.source.patching,(()=>this.patch())),this.connect(this.model.properties.schema.change,(()=>{this.worker.table(this.model.schema).then((e=>{this.table=e,this.table.update(this.data),this.perspective_element.load(this.table)}))})),this.connect(this.model.properties.toggle_config.change,(()=>{this.perspective_element.toggleConfig()})),this.connect(this.model.properties.columns.change,(()=>{this._updating||this.perspective_element.restore({columns:this.model.columns})})),this.connect(this.model.properties.expressions.change,(()=>{this._updating||this.perspective_element.restore({expressions:this.model.expressions})})),this.connect(this.model.properties.split_by.change,(()=>{this._updating||this.perspective_element.restore({split_by:this.model.split_by})})),this.connect(this.model.properties.group_by.change,(()=>{this._updating||this.perspective_element.restore({group_by:this.model.group_by})})),this.connect(this.model.properties.aggregates.change,(()=>{this._updating||this.perspective_element.restore({aggregates:this.model.aggregates})})),this.connect(this.model.properties.filters.change,(()=>{this._updating||this.perspective_element.restore({filter:this.model.filters})})),this.connect(this.model.properties.sort.change,(()=>{this._updating||this.perspective_element.restore({sort:this.model.sort})})),this.connect(this.model.properties.plugin.change,(()=>{this._updating||this.perspective_element.restore({plugin:d[this.model.plugin]})})),this.connect(this.model.properties.selectable.change,(()=>{this._updating||this.perspective_element.restore({plugin_config:Object.assign(Object.assign({},this._current_config),{selectable:this.model.selectable})})})),this.connect(this.model.properties.editable.change,(()=>{this._updating||this.perspective_element.restore({plugin_config:Object.assign(Object.assign({},this._current_config),{editable:this.model.editable})})})),this.connect(this.model.properties.theme.change,(()=>{this._updating||this.perspective_element.restore({theme:p[this.model.theme]}).catch((()=>{}))}))}disconnect_signals(){null!=this._config_listener&&this.perspective_element.removeEventListener("perspective-config-update",this._config_listener),this._config_listener=null,super.disconnect_signals()}remove(){this.perspective_element.delete((()=>this.worker.terminate())),super.remove()}render(){super.render(),this.worker=window.perspective.worker();const e=(0,c.div)({class:"pnx-perspective-viewer",style:{zIndex:0}});e.innerHTML="<perspective-viewer style='height:100%; width:100%;'></perspective-viewer>",this.perspective_element=e.children[0],this.perspective_element.resetThemes([...Object.values(p)]).catch((()=>{})),this.model.toggle_config&&this.perspective_element.toggleConfig(),(0,h.set_size)(e,this.model),this.shadow_el.appendChild(e),this.worker.table(this.model.schema).then((e=>{this.table=e,this.table.update(this.data),this.perspective_element.load(this.table);const t=Object.assign(Object.assign({},this.model.plugin_config),{editable:this.model.editable,selectable:this.model.selectable});this.perspective_element.restore({aggregates:this.model.aggregates,columns:this.model.columns,expressions:this.model.expressions,filter:this.model.filters,split_by:this.model.split_by,group_by:this.model.group_by,plugin:d[this.model.plugin],plugin_config:t,sort:this.model.sort,theme:p[this.model.theme]}).catch((()=>{})),this.perspective_element.save().then((e=>{this._current_config=e})),this._config_listener=()=>this.sync_config(),this.perspective_element.addEventListener("perspective-config-update",this._config_listener),this.perspective_element.addEventListener("perspective-click",(e=>{this.model.trigger_event(new u(e.detail.config,e.detail.column_names,e.detail.row))})),this._loaded=!0}))}sync_config(){return this._updating||this.perspective_element.save().then((e=>{this._current_config=e;const t={};for(let s in e){let i=e[s];void 0===i||"plugin"==s&&"debug"===i||"settings"===s||("filter"===s?s="filters":"plugin"===s?i=g[i]:"theme"===s&&(i=m[i]),t[s]=i)}this._updating=!0,this.model.setv(t),this._updating=!1})),!0}get data(){const e={};for(const t of this.model.source.columns())e[t]=this.model.source.get_array(t);return e}setData(){if(this._loaded){for(const e of this.model.source.columns())if(!(e in this.model.schema))return;this.table.replace(this.data)}}stream(){this._loaded&&this.table.replace(this.data)}patch(){this._loaded&&this.table.replace(this.data)}}s.PerspectiveView=v,v.__name__="PerspectiveView";class b extends h.HTMLBox{constructor(e){super(e)}}s.Perspective=b,o=b,b.__name__="Perspective",b.__module__="panel.models.perspective",o.prototype.default_view=v,o.define((({Any:e,Array:t,Boolean:s,Ref:i,Nullable:n,String:r})=>({aggregates:[e,{}],columns:[t(n(r)),[]],expressions:[n(t(r)),null],split_by:[n(t(r)),null],editable:[s,!0],filters:[n(t(e)),null],group_by:[n(t(r)),null],plugin:[r],plugin_config:[e,{}],selectable:[s,!0],schema:[e,{}],toggle_config:[s,!0],sort:[n(t(t(r))),null],source:[i(a.ColumnDataSource)],theme:[r,"material"]})))},
"bd5015f776": function _(e,t,i,s,o){var l;s();const n=e("@bokehjs/core/kinds"),a=e("@bokehjs/core/dom"),r=e("@bokehjs/models/widgets/widget");function d(e){e.forEach((e=>e.style.borderStyle="inset"))}function h(e){e.forEach((e=>e.style.borderStyle="outset"))}class c extends r.WidgetView{constructor(){super(...arguments),this._changing=!1}connect_signals(){super.connect_signals(),this.connect(this.model.properties.direction.change,(()=>this.set_direction())),this.connect(this.model.properties.value.change,(()=>this.render())),this.connect(this.model.properties.loop_policy.change,(()=>this.set_loop_state(this.model.loop_policy))),this.connect(this.model.properties.disabled.change,(()=>this.toggle_disable())),this.connect(this.model.properties.show_loop_controls.change,(()=>{this.model.show_loop_controls&&this.loop_state.parentNode!=this.groupEl?this.groupEl.appendChild(this.loop_state):this.model.show_loop_controls||this.loop_state.parentNode!=this.groupEl||this.groupEl.removeChild(this.loop_state)}))}toggle_disable(){this.sliderEl.disabled=this.model.disabled;for(const e of this.buttonEl.children){e.disabled=this.model.disabled}for(const e of this.loop_state.children)if("input"==e.tagName){e.disabled=this.model.disabled}}get_height(){return 250}render(){if(null!=this.sliderEl)return this.sliderEl.min=String(this.model.start),this.sliderEl.max=String(this.model.end),void(this.sliderEl.value=String(this.model.value));super.render(),this.groupEl=(0,a.div)(),this.groupEl.style.display="flex",this.groupEl.style.flexDirection="column",this.groupEl.style.alignItems="center",this.sliderEl=document.createElement("input"),this.sliderEl.style.width="100%",this.sliderEl.setAttribute("type","range"),this.sliderEl.value=String(this.model.value),this.sliderEl.min=String(this.model.start),this.sliderEl.max=String(this.model.end),this.sliderEl.addEventListener("input",(e=>{this.set_frame(parseInt(e.target.value),!1)})),this.sliderEl.addEventListener("change",(e=>{this.set_frame(parseInt(e.target.value))}));const e=(0,a.div)();this.buttonEl=e,e.style.cssText="margin: 0 auto; display: flex; padding: 5px; align-items: stretch; width: 100%;";const t="text-align: center; min-width: 20px; flex-grow: 1; margin: 2px",i="text-align: center; min-width: 40px; flex-grow: 2; margin: 2px",s=document.createElement("button");s.style.cssText=t,s.appendChild(document.createTextNode("\u2013")),s.onclick=()=>this.slower(),e.appendChild(s);const o=document.createElement("button");o.style.cssText=i,o.appendChild(document.createTextNode("\u275a\u25c0\u25c0")),o.onclick=()=>this.first_frame(),e.appendChild(o);const l=document.createElement("button");l.style.cssText=i,l.appendChild(document.createTextNode("\u275a\u25c0")),l.onclick=()=>this.previous_frame(),e.appendChild(l);const n=document.createElement("button");n.style.cssText=i,n.appendChild(document.createTextNode("\u25c0")),n.onclick=()=>this.reverse_animation(),e.appendChild(n);const r=document.createElement("button");r.style.cssText=i,r.appendChild(document.createTextNode("\u275a\u275a")),r.onclick=()=>this.pause_animation(),e.appendChild(r);const c=document.createElement("button");c.style.cssText=i,c.appendChild(document.createTextNode("\u25b6")),c.onclick=()=>this.play_animation(),e.appendChild(c);const p=document.createElement("button");p.style.cssText=i,p.appendChild(document.createTextNode("\u25b6\u275a")),p.onclick=()=>this.next_frame(),e.appendChild(p);const m=document.createElement("button");m.style.cssText=i,m.appendChild(document.createTextNode("\u25b6\u25b6\u275a")),m.onclick=()=>this.last_frame(),e.appendChild(m);const _=document.createElement("button");_.style.cssText=t,_.appendChild(document.createTextNode("+")),_.onclick=()=>this.faster(),e.appendChild(_),this._toggle_reverse=()=>{h([r,c]),d([n])},this._toogle_pause=()=>{h([n,c]),d([r])},this._toggle_play=()=>{h([n,r]),d([c])},this.loop_state=document.createElement("form"),this.loop_state.style.cssText="margin: 0 auto; display: table";const u=document.createElement("input");u.type="radio",u.value="once",u.name="state";const g=document.createElement("label");g.innerHTML="Once",g.style.cssText="padding: 0 10px 0 5px; user-select:none;";const f=document.createElement("input");f.setAttribute("type","radio"),f.setAttribute("value","loop"),f.setAttribute("name","state");const v=document.createElement("label");v.innerHTML="Loop",v.style.cssText="padding: 0 10px 0 5px; user-select:none;";const E=document.createElement("input");E.setAttribute("type","radio"),E.setAttribute("value","reflect"),E.setAttribute("name","state");const x=document.createElement("label");x.innerHTML="Reflect",x.style.cssText="padding: 0 10px 0 5px; user-select:none;","once"==this.model.loop_policy?u.checked=!0:"loop"==this.model.loop_policy?f.checked=!0:E.checked=!0,this.loop_state.appendChild(u),this.loop_state.appendChild(g),this.loop_state.appendChild(f),this.loop_state.appendChild(v),this.loop_state.appendChild(E),this.loop_state.appendChild(x),this.groupEl.appendChild(this.sliderEl),this.groupEl.appendChild(e),this.model.show_loop_controls&&this.groupEl.appendChild(this.loop_state),this.toggle_disable(),this.shadow_el.appendChild(this.groupEl)}set_frame(e,t=!0){this.model.value=e,t&&(this.model.value_throttled=e),this.sliderEl.value!=String(e)&&(this.sliderEl.value=String(e))}get_loop_state(){for(var e=this.loop_state.state,t=0;t<e.length;t++){var i=e[t];if(i.checked)return i.value}return"once"}set_loop_state(e){for(var t=this.loop_state.state,i=0;i<t.length;i++){var s=t[i];s.value==e&&(s.checked=!0)}}next_frame(){this.set_frame(Math.min(this.model.end,this.model.value+this.model.step))}previous_frame(){this.set_frame(Math.max(this.model.start,this.model.value-this.model.step))}first_frame(){this.set_frame(this.model.start)}last_frame(){this.set_frame(this.model.end)}slower(){this.model.interval=Math.round(this.model.interval/.7),this.model.direction>0?this.play_animation():this.model.direction<0&&this.reverse_animation()}faster(){this.model.interval=Math.round(.7*this.model.interval),this.model.direction>0?this.play_animation():this.model.direction<0&&this.reverse_animation()}anim_step_forward(){if(this.model.value<this.model.end)this.next_frame();else{var e=this.get_loop_state();"loop"==e?this.first_frame():"reflect"==e?(this.last_frame(),this.reverse_animation()):(this.pause_animation(),this.last_frame())}}anim_step_reverse(){if(this.model.value>this.model.start)this.previous_frame();else{var e=this.get_loop_state();"loop"==e?this.last_frame():"reflect"==e?(this.first_frame(),this.play_animation()):(this.pause_animation(),this.first_frame())}}set_direction(){this._changing||(0===this.model.direction?this.pause_animation():1===this.model.direction?this.play_animation():-1===this.model.direction&&this.reverse_animation())}pause_animation(){this._toogle_pause(),this._changing=!0,this.model.direction=0,this._changing=!1,this.timer&&(clearInterval(this.timer),this.timer=null)}play_animation(){this.pause_animation(),this._toggle_play(),this._changing=!0,this.model.direction=1,this._changing=!1,this.timer||(this.timer=setInterval((()=>this.anim_step_forward()),this.model.interval))}reverse_animation(){this.pause_animation(),this._toggle_reverse(),this._changing=!0,this.model.direction=-1,this._changing=!1,this.timer||(this.timer=setInterval((()=>this.anim_step_reverse()),this.model.interval))}}i.PlayerView=c,c.__name__="PlayerView",i.LoopPolicy=(0,n.Enum)("once","loop","reflect");class p extends r.Widget{constructor(e){super(e)}}i.Player=p,l=p,p.__name__="Player",p.__module__="panel.models.widgets",l.prototype.default_view=c,l.define((({Boolean:e,Int:t})=>({direction:[t,0],interval:[t,500],start:[t,0],end:[t,10],step:[t,1],loop_policy:[i.LoopPolicy,"once"],value:[t,0],value_throttled:[t,0],show_loop_controls:[e,!0]}))),l.override({width:400})},
"b6febc7d6f": function _(t,e,o,i,s){var r;i();const n=t("@bokehjs/core/dom"),l=t("@bokehjs/core/util/object"),a=t("@bokehjs/core/util/eq"),h=t("@bokehjs/models/sources/column_data_source"),c=t("99a25e6992"),d=t("990b5dd5c7"),p=t("c64c1219c8");function _(t){return Object.entries(t).forEach((([e,o])=>{o&&"object"==typeof o?_(o):void 0===o&&(t[e]=null)})),t}const u=(t,e,o)=>{let i=Array.isArray(e)?[]:{};if("click"===o||"hover"===o||"selected"===o){const o=[];if(null==e)return null;const s=t.data;for(let t=0;t<e.points.length;t++){const i=e.points[t];let r={};for(let t in i){const e=i[t];!i.hasOwnProperty(t)||Array.isArray(e)||(0,d.isPlainObject)(e)||void 0===e||(r[t]=e)}null!=i&&(i.hasOwnProperty("curveNumber")&&i.hasOwnProperty("pointNumber")&&s[i.curveNumber].hasOwnProperty("customdata")&&(r.customdata=s[i.curveNumber].customdata[i.pointNumber]),i.hasOwnProperty("pointNumbers")&&(r.pointNumbers=i.pointNumbers)),o[t]=r}i.points=o}else if("relayout"===o||"restyle"===o)for(let t in e)e.hasOwnProperty(t)&&(i[t]=e[t]);return e.hasOwnProperty("range")&&(i.range=e.range),e.hasOwnProperty("lassoPoints")&&(i.lassoPoints=e.lassoPoints),_(i)};class y extends p.HTMLBoxView{constructor(){super(...arguments),this._settingViewport=!1,this._plotInitialized=!1,this._rendered=!1,this._reacting=!1,this._relayouting=!1,this._end_relayouting=(0,c.debounce)((()=>{this._relayouting=!1}),2e3,!1)}connect_signals(){super.connect_signals();const{data:t,data_sources:e,layout:o,relayout:i,restyle:s}=this.model.properties;this.on_change([t,e,o],(()=>{const t=this.model._render_count;setTimeout((()=>{this.model._render_count===t&&(this.model._render_count+=1)}),250)})),this.on_change([i],(()=>{null!=this.model.relayout&&(window.Plotly.relayout(this.container,this.model.relayout),this.model.relayout=null)})),this.on_change([s],(()=>{null!=this.model.restyle&&(window.Plotly.restyle(this.container,this.model.restyle.data,this.model.restyle.traces),this.model.restyle=null)})),this.connect(this.model.properties.viewport_update_policy.change,(()=>{this._updateSetViewportFunction()})),this.connect(this.model.properties.viewport_update_throttle.change,(()=>{this._updateSetViewportFunction()})),this.connect(this.model.properties._render_count.change,(()=>{this.plot()})),this.connect(this.model.properties.frames.change,(()=>{this.plot(!0)})),this.connect(this.model.properties.viewport.change,(()=>this._updateViewportFromProperty()))}remove(){window.Plotly.purge(this.container),super.remove()}render(){super.render(),this.container=(0,n.div)(),(0,p.set_size)(this.container,this.model),this._rendered=!1,this.shadow_el.appendChild(this.container),this.watch_stylesheets(),this.plot().then((()=>{this._rendered=!0,null!=this.model.relayout&&window.Plotly.relayout(this.container,this.model.relayout),window.Plotly.Plots.resize(this.container)}))}style_redraw(){this._rendered&&window.Plotly.Plots.resize(this.container)}after_layout(){super.after_layout(),this._rendered&&window.Plotly.Plots.resize(this.container)}_trace_data(){const t=[];for(let e=0;e<this.model.data.length;e++)t.push(this._get_trace(e,!1));return t}_layout_data(){const t=(0,d.deepCopy)(this.model.layout);if(this._relayouting){const{layout:e}=this.container;Object.keys(e).reduce(((e,o)=>{"axis"===o.slice(1,5)&&"range"in e&&(t[o].range=e.range)}),{})}return t}_install_callbacks(){this.container.on("plotly_relayout",(t=>{!0!==t._update_from_property&&(this.model.relayout_data=u(this.container,t,"relayout"),this._updateViewportProperty(),this._end_relayouting())})),this.container.on("plotly_relayouting",(()=>{"mouseup"!==this.model.viewport_update_policy&&(this._relayouting=!0,this._updateViewportProperty())})),this.container.on("plotly_restyle",(t=>{this.model.restyle_data=u(this.container,t,"restyle"),this._updateViewportProperty()})),this.container.on("plotly_click",(t=>{this.model.click_data=u(this.container,t,"click")})),this.container.on("plotly_hover",(t=>{this.model.hover_data=u(this.container,t,"hover")})),this.container.on("plotly_selected",(t=>{this.model.selected_data=u(this.container,t,"selected")})),this.container.on("plotly_clickannotation",(t=>{delete t.event,delete t.fullAnnotation,this.model.clickannotation_data=t})),this.container.on("plotly_deselect",(()=>{this.model.selected_data=null})),this.container.on("plotly_unhover",(()=>{this.model.hover_data=null}))}async plot(t=!1){if(!window.Plotly)return;const e=this._trace_data(),o=this._layout_data();if(this._reacting=!0,t){const t={data:e,layout:o,config:this.model.config,frames:this.model.frames};await window.Plotly.newPlot(this.container,t)}else await window.Plotly.react(this.container,e,o,this.model.config),null!=this.model.frames&&await window.Plotly.addFrames(this.container,this.model.frames);var i,s;this._updateSetViewportFunction(),this._updateViewportProperty(),this._plotInitialized?(i=this.container,(s=window.getComputedStyle(i).display)&&"none"!==s&&window.Plotly.Plots.resize(this.container)):this._install_callbacks(),this._reacting=!1,this._plotInitialized=!0}_get_trace(t,e){const o=(0,l.clone)(this.model.data[t]),i=this.model.data_sources[t];for(const t of i.columns()){let s=i.get_array(t)[0];if(null!=s.shape&&s.shape.length>1){const t=[],e=s.shape;for(let o=0;o<e[0];o++)t.push(s.slice(o*e[1],(o+1)*e[1]));s=t}let r=t.split("."),n=r[r.length-1],l=o;for(let t of r.slice(0,-1))l=l[t];e&&1==r.length?l[n]=[s]:l[n]=s}return o}_updateViewportFromProperty(){if(!window.Plotly||this._settingViewport||this._reacting||!this.model.viewport)return;const t=this.container._fullLayout;Object.keys(this.model.viewport).reduce(((e,o)=>{if((0,a.is_equal)((0,d.get)(t,o),e))return!0;{let t=(0,d.deepCopy)(this.model.viewport);return t._update_from_property=!0,this._settingViewport=!0,window.Plotly.relayout(this.el,t).then((()=>{this._settingViewport=!1})),!1}}),{})}_updateViewportProperty(){const t=this.container._fullLayout;let e={};for(let o in t){if(!t.hasOwnProperty(o))continue;let i=o.slice(0,5);"xaxis"!==i&&"yaxis"!==i||(e[o+".range"]=(0,d.deepCopy)(t[o].range))}(0,a.is_equal)(e,this.model.viewport)||this._setViewport(e)}_updateSetViewportFunction(){"continuous"===this.model.viewport_update_policy||"mouseup"===this.model.viewport_update_policy?this._setViewport=t=>{this._settingViewport||(this._settingViewport=!0,this.model.viewport=t,this._settingViewport=!1)}:this._setViewport=(0,d.throttle)((t=>{this._settingViewport||(this._settingViewport=!0,this.model.viewport=t,this._settingViewport=!1)}),this.model.viewport_update_throttle)}}o.PlotlyPlotView=y,y.__name__="PlotlyPlotView";class w extends p.HTMLBox{constructor(t){super(t)}}o.PlotlyPlot=w,r=w,w.__name__="PlotlyPlot",w.__module__="panel.models.plotly",r.prototype.default_view=y,r.define((({Array:t,Any:e,Nullable:o,Number:i,Ref:s,String:r})=>({data:[t(e),[]],layout:[e,{}],config:[e,{}],frames:[o(t(e)),null],data_sources:[t(s(h.ColumnDataSource)),[]],relayout:[o(e),{}],restyle:[o(e),{}],relayout_data:[e,{}],restyle_data:[t(e),[]],click_data:[e,{}],hover_data:[e,{}],clickannotation_data:[e,{}],selected_data:[e,{}],viewport:[e,{}],viewport_update_policy:[r,"mouseup"],viewport_update_throttle:[i,200],_render_count:[i,0]})))},
"990b5dd5c7": function _(t,n,r,e,o){e();r.get=(t,n,r=void 0)=>{const e=r=>String.prototype.split.call(n,r).filter(Boolean).reduce(((t,n)=>null!=t?t[n]:t),t),o=e(/[,[\]]+?/)||e(/[,[\].]+?/);return void 0===o||o===t?r:o},r.throttle=function(t,n){var r=0;return function(){var e=Number(new Date);e-r>=n&&(t(),r=e)}},r.deepCopy=function t(n){var r;if(null==n||"object"!=typeof n)return n;if(n instanceof Array){r=[];for(var e=0,o=n.length;e<o;e++)r[e]=t(n[e]);return r}if(n instanceof Object){const r={};for(const e in n){const o=e;n.hasOwnProperty(o)&&(r[o]=t(n[o]))}return r}throw new Error("Unable to copy obj! Its type isn't supported.")},r.isPlainObject=function(t){return"[object Object]"===Object.prototype.toString.call(t)}},
"e6caa5bc95": function _(e,s,t,o,i){var r;o();const l=e("@bokehjs/core/dom"),h=e("c64c1219c8");class n extends h.HTMLBoxView{connect_signals(){super.connect_signals();const e=()=>this.render();this.connect(this.model.properties.height.change,e),this.connect(this.model.properties.width.change,e),this.connect(this.model.properties.height_policy.change,e),this.connect(this.model.properties.width_policy.change,e),this.connect(this.model.properties.sizing_mode.change,e),this.connect(this.model.properties.active.change,(()=>this.setCSS())),this.connect(this.model.properties.bar_color.change,(()=>this.setCSS())),this.connect(this.model.properties.css_classes.change,(()=>this.setCSS())),this.connect(this.model.properties.value.change,(()=>this.setValue())),this.connect(this.model.properties.max.change,(()=>this.setMax()))}render(){super.render();const e=Object.assign(Object.assign({},this.model.styles),{display:"inline-block"});this.progressEl=document.createElement("progress"),this.setValue(),this.setMax(),this.setCSS();for(const s in e)this.progressEl.style.setProperty(s,e[s]);this.shadow_el.appendChild(this.progressEl)}stylesheets(){const e=super.stylesheets();for(const s of this.model.css)e.push(new l.ImportedStyleSheet(s));return e}setCSS(){let e=this.model.css_classes.join(" ")+" "+this.model.bar_color;this.model.active&&(e+=" active"),this.progressEl.className=e}setValue(){null==this.model.value?this.progressEl.value=0:this.model.value>=0?this.progressEl.value=this.model.value:this.model.value<0&&this.progressEl.removeAttribute("value")}setMax(){null!=this.model.max&&(this.progressEl.max=this.model.max)}}t.ProgressView=n,n.__name__="ProgressView";class c extends h.HTMLBox{constructor(e){super(e)}}t.Progress=c,r=c,c.__name__="Progress",c.__module__="panel.models.widgets",r.prototype.default_view=n,r.define((({Any:e,Array:s,Boolean:t,Number:o,String:i})=>({active:[t,!0],bar_color:[i,"primary"],css:[s(i),[]],max:[o,100],value:[e,null]})))},
"283ee868b0": function _(e,t,i,s,l){var o;s();const n=e("@bokehjs/core/dom"),a=e("c64c1219c8");class d extends a.HTMLBoxView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.disabled.change,(()=>this.quill.enable(!this.model.disabled))),this.connect(this.model.properties.visible.change,(()=>{this.model.visible&&(this.container.style.visibility="visible")})),this.connect(this.model.properties.text.change,(()=>{this._editing||(this._editing=!0,this.quill.enable(!1),this.quill.setContents([]),this.quill.clipboard.dangerouslyPasteHTML(this.model.text),this.quill.enable(!this.model.disabled),this._editing=!1)}));const{mode:e,toolbar:t,placeholder:i}=this.model.properties;this.on_change([i],(()=>{this.quill.root.setAttribute("data-placeholder",this.model.placeholder)})),this.on_change([e,t],(()=>{this.render(),this._layout_toolbar()}))}_layout_toolbar(){if(null==this._toolbar)this.el.style.removeProperty("padding-top");else{const e=this._toolbar.getBoundingClientRect().height+1;this.el.style.paddingTop=e+"px",this._toolbar.style.marginTop=-e+"px"}}render(){super.render(),this.container=(0,n.div)({style:"visibility: hidden;"}),this.shadow_el.appendChild(this.container);const e="bubble"===this.model.mode?"bubble":"snow";this.watch_stylesheets(),this.quill=new window.Quill(this.container,{modules:{toolbar:this.model.toolbar},readOnly:!0,placeholder:this.model.placeholder,theme:e}),void 0!==this.quill.root.getRootNode().getSelection&&(this.quill.selection.getNativeRange=()=>(e=>{var t,i;if(e){const s=e;if("ql-clipboard"===(null===(i=null===(t=s.baseNode)||void 0===t?void 0:t.classList)||void 0===i?void 0:i.value))return null;if(s.baseNode&&(s.startContainer=e.baseNode,s.endContainer=e.focusNode,s.startOffset=e.baseOffset,s.endOffset=e.focusOffset,s.endOffset<s.startOffset&&(s.startContainer=e.focusNode,s.endContainer=e.baseNode,s.startOffset=e.focusOffset,s.endOffset=e.baseOffset)),s.startContainer)return{start:{node:s.startContainer,offset:s.startOffset},end:{node:s.endContainer,offset:s.endOffset},native:s}}return null})(this.shadow_el.getSelection())),this._editor=this.shadow_el.querySelector(".ql-editor"),this._toolbar=this.shadow_el.querySelector(".ql-toolbar");const t=this.quill.clipboard.convert(this.model.text);this.quill.setContents(t),this.quill.on("text-change",(()=>{this._editing||(this._editing=!0,this.model.text=this._editor.innerHTML,this._editing=!1)})),this.model.disabled||this.quill.enable(!this.model.disabled),document.addEventListener("selectionchange",((...e)=>{this.quill.selection.update()}))}style_redraw(){this.model.visible&&(this.container.style.visibility="visible");const e=this.quill.clipboard.convert(this.model.text);this.quill.setContents(e),this.invalidate_layout()}after_layout(){super.after_layout(),this._layout_toolbar()}}i.QuillInputView=d,d.__name__="QuillInputView";class r extends a.HTMLBox{constructor(e){super(e)}}i.QuillInput=r,o=r,r.__name__="QuillInput",r.__module__="panel.models.quill",o.prototype.default_view=d,o.define((({Any:e,String:t})=>({mode:[t,"toolbar"],placeholder:[t,""],text:[t,""],toolbar:[e,null]}))),o.override({height:300})},
"81e6ca704a": function _(e,t,o,i,l){var s;i();const n=e("@bokehjs/models/ui/tooltip"),u=e("@bokehjs/core/build_views"),d=e("@bokehjs/models/widgets/radio_button_group");class r extends d.RadioButtonGroupView{*children(){yield*super.children(),null!=this.tooltip&&(yield this.tooltip)}async lazy_initialize(){await super.lazy_initialize();const{tooltip:e}=this.model;null!=e&&(this.tooltip=await(0,u.build_view)(e,{parent:this}))}remove(){var e;null===(e=this.tooltip)||void 0===e||e.remove(),super.remove()}render(){super.render();const e=e=>{var t;null===(t=this.tooltip)||void 0===t||t.model.setv({visible:e})};let t;this.el.addEventListener("mouseenter",(()=>{t=setTimeout((()=>e(!0)),this.model.tooltip_delay)})),this.el.addEventListener("mouseleave",(()=>{clearTimeout(t),e(!1)}))}}o.RadioButtonGroupView=r,r.__name__="RadioButtonGroupView";class a extends d.RadioButtonGroup{constructor(e){super(e)}}o.RadioButtonGroup=a,s=a,a.__name__="RadioButtonGroup",a.__module__="panel.models.widgets",s.prototype.default_view=r,s.define((({Nullable:e,Ref:t,Number:o})=>({tooltip:[e(t(n.Tooltip)),null],tooltip_delay:[o,500]})))},
"0590cf2a27": function _(e,t,n,s,i){var o;s();const r=e("1b70f5b1d3"),l=e("283ce7811c"),c=e("b3f51db71c"),d=e("@bokehjs/core/dom"),h=e("@bokehjs/core/util/types"),a=e("4e27eda472"),_=e("490942d778"),u=e("3db2e41978"),p=e("c64c1219c8");function m(e,t,n){const s={};for(const e of n)s[`{${e}}`]="(.*)";const i=[];let o="^"+(e.replace(/[-\/\\^$*+?.()|[\]]/g,"\\$&")+"$");let r,l,c;for(const t in s)if(l=e.indexOf(t),l>-1){for(o=o.replace(t,s[t]),c={index:l,token:t},r=0;r<i.length&&i[r].index<l;r++);r<i.length?i.splice(r,0,c):i.push(c)}o=o.replace(/\{[^{}]+\}/g,".*");var d=new RegExp(o).exec(t);let h=null;if(d)for(h={},r=0;r<i.length;r++)h[i[r].token.slice(1,-1)]=d[r+1];return h}function f(e,t){let n=e.getElementById(t);return null==n&&(n=document.getElementById(t)),n}class v extends p.HTMLBoxView{constructor(){super(...arguments),this._parent=null,this._changing=!1,this._event_listeners={},this._mutation_observers=[],this._script_fns={},this._state={}}initialize(){super.initialize(),this.html=(0,u.htmlDecode)(this.model.html)||this.model.html}_recursive_connect(e,t,n){for(const s in e.properties){let i;i=n.length?`${n}.${s}`:s;const o=e[s];null!=o&&(null!=o.properties&&this._recursive_connect(o,!0,i),this.connect(e.properties[s].change,(()=>{if(t)for(const t in this.model.children)if(this.model.children[t]==s){let n=e[s];return(0,h.isArray)(n)||(n=[n]),void this._render_node(t,n)}this._changing||this._update(i)})))}}connect_signals(){super.connect_signals(),this.connect(this.model.properties.children.change,(async()=>{this.html=(0,u.htmlDecode)(this.model.html)||this.model.html,await this.rebuild()})),this._recursive_connect(this.model.data,!0,""),this.connect(this.model.properties.events.change,(()=>{this._remove_event_listeners(),this._setup_event_listeners()})),this.connect_scripts()}connect_scripts(){const e=this.model.data.id;for(let t in this.model.scripts){const n=this.model.scripts[t];let s,i=this.model.data;if(t.indexOf(".")>=0){const e=t.split(".");s=e[e.length-1];for(const t of e.slice(0,-1))i=i[t]}else s=t;for(const o of n){const n=(0,u.htmlDecode)(o)||o,r=this._render_script(n,e);this._script_fns[t]=r;const l=i.properties[s];null!=l&&this.connect(l.change,(()=>{this._changing||this.run_script(t)}))}}}run_script(e,t=!1){const n=this._script_fns[e];if(void 0===n)return void(t||console.log(`Script '${e}' could not be found.`));const s={get_records:(e,t)=>this.get_records(e,t)};for(const e in this._script_fns)s[e]=()=>this.run_script(e);return n(this.model,this.model.data,this._state,this,(e=>this.run_script(e)),s)}get_records(e,t=!0){return(0,a.dict_to_records)(this.model.data[e],t)}disconnect_signals(){super.disconnect_signals(),this._remove_event_listeners(),this._remove_mutation_observers()}remove(){this.run_script("remove",!0),super.remove()}get child_models(){const e=[];for(const t in this.model.children)for(const n of this.model.children[t])"string"!=typeof n&&e.push(n);return e}_after_layout(){this.run_script("after_layout",!0)}render(){this.empty(),this._update_stylesheets(),this._update_css_classes(),this._apply_styles(),this._apply_visible(),this.container=(0,d.div)({style:"display: contents;"}),this.shadow_el.append(this.container),this._update(),this._render_children(),this._setup_mutation_observers(),this._setup_event_listeners(),this.run_script("render",!0)}_send_event(e,t,n){let s=(0,_.serializeEvent)(n);s.type=t;for(const e in s)void 0===s[e]&&delete s[e];this.model.trigger_event(new u.DOMEvent(e,s))}_render_child(e,t){const n=this._child_views.get(e);null==n?t.innerHTML=(0,u.htmlDecode)(e)||e:(t.appendChild(n.el),n.render(),n.after_render())}_render_node(e,t){const n=this.model.data.id;if(this.model.looped.indexOf(e)>-1)for(let s=0;s<t.length;s++){const i=f(this.shadow_el,`${e}-${s}-${n}`);null!=i?this._render_child(t[s],i):console.warn(`DOM node '${e}-${s}-${n}' could not be found. Cannot render children.`)}else{const s=f(this.shadow_el,`${e}-${n}`);if(null==s)return void console.warn(`DOM node '${e}-${n}' could not be found. Cannot render children.`);for(const e of t)this._render_child(e,s)}}_render_children(){for(const e in this.model.children){let t=this.model.children[e];"string"==typeof t&&(t=this.model.data[t],(0,h.isArray)(t)||(t=[t])),this._render_node(e,t)}}_render_html(e,t={}){let n=e.replace(/[`]/g,"\\$&"),s="";const i=[];for(const e in this.model.callbacks)for(const t of this.model.callbacks[e]){const[o,r]=t;let l;if(n=n.replaceAll("${"+r+"}","$--{"+r+"}"),r.startsWith("script(")){const e=r.replace("('","_").replace("')","").replace('("',"_").replace('")',"").replace("-","_"),t=e.replaceAll("script_","");n=n.replaceAll(r,e),l=`\n          const ${e} = (event) => {\n            view._state.event = event\n            view.run_script("${t}")\n            delete view._state.event\n          }\n          `}else l=`\n          const ${r} = (event) => {\n            let elname = "${e}"\n            if (RegExp("{{.*loop.index.*}}").test(elname)) {\n              const pattern = RegExp(elname.replace(/{{(.+?)}}/g, String.fromCharCode(92) + "d+"))\n              for (const p of event.path) {\n                if (pattern.exec(p.id) != null) {\n                  elname = p.id.split("-").slice(null, -1).join("-")\n                  break\n                }\n              }\n            }\n            view._send_event(elname, "${o}", event)\n          }\n          `;i.indexOf(r)>-1||(i.push(r),s+=l)}return n=n.replaceAll("${model.","$-{model.").replaceAll("${","${data.").replaceAll("$-{model.","${model.").replaceAll("$--{","${"),new Function("view, model, data, state, html, useCallback",s+"return html`"+n+"`;")(this,this.model,this.model.data,t,c.html,l.useCallback)}_render_script(e,t){const n=[];for(const s of this.model.nodes){const i=s.replace("-","_");if(-1===e.indexOf(i))continue;const o=`\n      let ${i} = view.shadow_el.getElementById('${s}-${t}')\n      if (${i} == null)\n        ${i} = document.getElementById('${s}-${t}')\n      if (${i} == null) {\n        console.warn("DOM node '${s}' could not be found. Cannot execute callback.")\n        return\n      }\n      `;n.push(o)}return n.push("\n    let event = null\n    if (state.event !== undefined) {\n      event = state.event\n    }\n    "),n.push(e),new Function("model, data, state, view, script, self",n.join("\n"))}_remove_mutation_observers(){for(const e of this._mutation_observers)e.disconnect();this._mutation_observers=[]}_setup_mutation_observers(){const e=this.model.data.id;for(const t in this.model.attrs){const n=f(this.shadow_el,`${t}-${e}`);if(null==n){console.warn(`DOM node '${t}-${e}' could not be found. Cannot set up MutationObserver.`);continue}const s=new MutationObserver((()=>{this._update_model(n,t)}));s.observe(n,{attributes:!0}),this._mutation_observers.push(s)}}_remove_event_listeners(){const e=this.model.data.id;for(const t in this._event_listeners){const n=f(this.shadow_el,`${t}-${e}`);if(null!=n)for(const e in this._event_listeners[t]){const s=this._event_listeners[t][e];n.removeEventListener(e,s)}}this._event_listeners={}}_setup_event_listeners(){const e=this.model.data.id;for(const t in this.model.events){const n=f(this.shadow_el,`${t}-${e}`);if(null==n){console.warn(`DOM node '${t}-${e}' could not be found. Cannot subscribe to DOM events.`);continue}const s=this.model.events[t];for(const e in s){const i=i=>{this._send_event(t,e,i),t in this.model.attrs&&s[e]&&this._update_model(n,t)};n.addEventListener(e,i),t in this._event_listeners||(this._event_listeners[t]={}),this._event_listeners[t][e]=i}}}_update(e=null){if(null==e||this.html.indexOf(`\${${e}}`)>-1){const e=this._render_html(this.html);if(null==e)return;try{this._changing=!0,(0,r.render)(e,this.container)}finally{this._changing=!1}}}_update_model(e,t){if(this._changing)return;const n={};for(const s of this.model.attrs[t]){const[i,o,r]=s;let l="children"===i?e.innerHTML:e[i];if(1===o.length&&`{${o[0]}}`===r)n[o[0]]=l;else if("string"==typeof l)if(l=m(r,l,o),null==l)console.warn(`Could not resolve parameters in ${t} element ${i} attribute value ${l}.`);else for(const e in l)void 0===l[e]?console.warn(`Could not resolve ${e} in ${t} element ${i} attribute value ${l}.`):n[e]=l[e]}try{this._changing=!0,this.model.data.setv(function(e){const t={};for(const n in e){let s=e[n];"string"!=typeof s||(""===s||"NaN"!==s&&isNaN(Number(s))?"false"!==s&&"true"!==s||(s="true"===s):s=Number(s)),t[n]=s}return t}(n))}catch(e){console.log("Could not serialize",n)}finally{this._changing=!1}}}n.ReactiveHTMLView=v,v.__name__="ReactiveHTMLView";class $ extends p.HTMLBox{constructor(e){super(e)}}n.ReactiveHTML=$,o=$,$.__name__="ReactiveHTML",$.__module__="panel.models.reactive_html",o.prototype.default_view=v,o.define((({Array:e,Any:t,String:n})=>({attrs:[t,{}],callbacks:[t,{}],children:[t,{}],data:[t],events:[t,{}],html:[n,""],looped:[e(n),[]],nodes:[e(n),[]],scripts:[t,{}]})))},
"1b70f5b1d3": function _(e,n,t,_,l){_();var o,r,i,u,s,c,f,p={},a=[],d=/acit|ex(?:s|g|n|p|$)|rph|grid|ows|mnc|ntw|ine[ch]|zoo|^ord|itera/i;function h(e,n){for(var t in n)e[t]=n[t];return e}function v(e){var n=e.parentNode;n&&n.removeChild(e)}function y(e,n,t){var _,l,r,i={};for(r in n)"key"==r?_=n[r]:"ref"==r?l=n[r]:i[r]=n[r];if(arguments.length>2&&(i.children=arguments.length>3?o.call(arguments,2):t),"function"==typeof e&&null!=e.defaultProps)for(r in e.defaultProps)void 0===i[r]&&(i[r]=e.defaultProps[r]);return m(e,i,_,l,null)}function m(e,n,t,_,l){var o={type:e,props:n,key:t,ref:_,__k:null,__:null,__b:0,__e:null,__d:void 0,__c:null,__h:null,constructor:void 0,__v:null==l?++i:l};return null==l&&null!=r.vnode&&r.vnode(o),o}function g(e){return e.children}function k(e,n){this.props=e,this.context=n}function b(e,n){if(null==n)return e.__?b(e.__,e.__.__k.indexOf(e)+1):null;for(var t;n<e.__k.length;n++)if(null!=(t=e.__k[n])&&null!=t.__e)return t.__e;return"function"==typeof e.type?b(e):null}function x(e){var n,t;if(null!=(e=e.__)&&null!=e.__c){for(e.__e=e.__c.base=null,n=0;n<e.__k.length;n++)if(null!=(t=e.__k[n])&&null!=t.__e){e.__e=e.__c.base=t.__e;break}return x(e)}}function C(e){(!e.__d&&(e.__d=!0)&&u.push(e)&&!S.__r++||s!==r.debounceRendering)&&((s=r.debounceRendering)||c)(S)}function S(){var e,n,t,_,l,o,r,i;for(u.sort((function(e,n){return e.__v.__b-n.__v.__b}));e=u.shift();)e.__d&&(n=u.length,_=void 0,l=void 0,r=(o=(t=e).__v).__e,(i=t.__P)&&(_=[],(l=h({},o)).__v=o.__v+1,W(i,o,l,t.__n,void 0!==i.ownerSVGElement,null!=o.__h?[r]:null,_,null==r?b(o):r,o.__h),L(_,o),o.__e!=r&&x(o)),u.length>n&&u.sort((function(e,n){return e.__v.__b-n.__v.__b})));S.__r=0}function P(e,n,t,_,l,o,r,i,u,s){var c,f,d,h,v,y,k,x=_&&_.__k||a,C=x.length;for(t.__k=[],c=0;c<n.length;c++)if(null!=(h=t.__k[c]=null==(h=n[c])||"boolean"==typeof h?null:"string"==typeof h||"number"==typeof h||"bigint"==typeof h?m(null,h,null,null,h):Array.isArray(h)?m(g,{children:h},null,null,null):h.__b>0?m(h.type,h.props,h.key,h.ref?h.ref:null,h.__v):h)){if(h.__=t,h.__b=t.__b+1,null===(d=x[c])||d&&h.key==d.key&&h.type===d.type)x[c]=void 0;else for(f=0;f<C;f++){if((d=x[f])&&h.key==d.key&&h.type===d.type){x[f]=void 0;break}d=null}W(e,h,d=d||p,l,o,r,i,u,s),v=h.__e,(f=h.ref)&&d.ref!=f&&(k||(k=[]),d.ref&&k.push(d.ref,null,h),k.push(f,h.__c||v,h)),null!=v?(null==y&&(y=v),"function"==typeof h.type&&h.__k===d.__k?h.__d=u=w(h,u,e):u=E(e,h,d,x,v,u),"function"==typeof t.type&&(t.__d=u)):u&&d.__e==u&&u.parentNode!=e&&(u=b(d))}for(t.__e=y,c=C;c--;)null!=x[c]&&("function"==typeof t.type&&null!=x[c].__e&&x[c].__e==t.__d&&(t.__d=U(_).nextSibling),H(x[c],x[c]));if(k)for(c=0;c<k.length;c++)F(k[c],k[++c],k[++c])}function w(e,n,t){for(var _,l=e.__k,o=0;l&&o<l.length;o++)(_=l[o])&&(_.__=e,n="function"==typeof _.type?w(_,n,t):E(t,_,_,l,_.__e,n));return n}function E(e,n,t,_,l,o){var r,i,u;if(void 0!==n.__d)r=n.__d,n.__d=void 0;else if(null==t||l!=o||null==l.parentNode)e:if(null==o||o.parentNode!==e)e.appendChild(l),r=null;else{for(i=o,u=0;(i=i.nextSibling)&&u<_.length;u+=1)if(i==l)break e;e.insertBefore(l,o),r=o}return void 0!==r?r:l.nextSibling}function U(e){var n,t,_;if(null==e.type||"string"==typeof e.type)return e.__e;if(e.__k)for(n=e.__k.length-1;n>=0;n--)if((t=e.__k[n])&&(_=U(t)))return _;return null}function A(e,n,t){"-"===n[0]?e.setProperty(n,null==t?"":t):e[n]=null==t?"":"number"!=typeof t||d.test(n)?t:t+"px"}function D(e,n,t,_,l){var o;e:if("style"===n)if("string"==typeof t)e.style.cssText=t;else{if("string"==typeof _&&(e.style.cssText=_=""),_)for(n in _)t&&n in t||A(e.style,n,"");if(t)for(n in t)_&&t[n]===_[n]||A(e.style,n,t[n])}else if("o"===n[0]&&"n"===n[1])o=n!==(n=n.replace(/Capture$/,"")),n=n.toLowerCase()in e?n.toLowerCase().slice(2):n.slice(2),e.l||(e.l={}),e.l[n+o]=t,t?_||e.addEventListener(n,o?N:T,o):e.removeEventListener(n,o?N:T,o);else if("dangerouslySetInnerHTML"!==n){if(l)n=n.replace(/xlink(H|:h)/,"h").replace(/sName$/,"s");else if("width"!==n&&"height"!==n&&"href"!==n&&"list"!==n&&"form"!==n&&"tabIndex"!==n&&"download"!==n&&n in e)try{e[n]=null==t?"":t;break e}catch(e){}"function"==typeof t||(null==t||!1===t&&-1==n.indexOf("-")?e.removeAttribute(n):e.setAttribute(n,t))}}function T(e){return this.l[e.type+!1](r.event?r.event(e):e)}function N(e){return this.l[e.type+!0](r.event?r.event(e):e)}function W(e,n,t,_,l,o,i,u,s){var c,f,p,a,d,v,y,m,b,x,C,S,w,E,U,A=n.type;if(void 0!==n.constructor)return null;null!=t.__h&&(s=t.__h,u=n.__e=t.__e,n.__h=null,o=[u]),(c=r.__b)&&c(n);try{e:if("function"==typeof A){if(m=n.props,b=(c=A.contextType)&&_[c.__c],x=c?b?b.props.value:c.__:_,t.__c?y=(f=n.__c=t.__c).__=f.__E:("prototype"in A&&A.prototype.render?n.__c=f=new A(m,x):(n.__c=f=new k(m,x),f.constructor=A,f.render=O),b&&b.sub(f),f.props=m,f.state||(f.state={}),f.context=x,f.__n=_,p=f.__d=!0,f.__h=[],f._sb=[]),null==f.__s&&(f.__s=f.state),null!=A.getDerivedStateFromProps&&(f.__s==f.state&&(f.__s=h({},f.__s)),h(f.__s,A.getDerivedStateFromProps(m,f.__s))),a=f.props,d=f.state,f.__v=n,p)null==A.getDerivedStateFromProps&&null!=f.componentWillMount&&f.componentWillMount(),null!=f.componentDidMount&&f.__h.push(f.componentDidMount);else{if(null==A.getDerivedStateFromProps&&m!==a&&null!=f.componentWillReceiveProps&&f.componentWillReceiveProps(m,x),!f.__e&&null!=f.shouldComponentUpdate&&!1===f.shouldComponentUpdate(m,f.__s,x)||n.__v===t.__v){for(n.__v!==t.__v&&(f.props=m,f.state=f.__s,f.__d=!1),f.__e=!1,n.__e=t.__e,n.__k=t.__k,n.__k.forEach((function(e){e&&(e.__=n)})),C=0;C<f._sb.length;C++)f.__h.push(f._sb[C]);f._sb=[],f.__h.length&&i.push(f);break e}null!=f.componentWillUpdate&&f.componentWillUpdate(m,f.__s,x),null!=f.componentDidUpdate&&f.__h.push((function(){f.componentDidUpdate(a,d,v)}))}if(f.context=x,f.props=m,f.__P=e,S=r.__r,w=0,"prototype"in A&&A.prototype.render){for(f.state=f.__s,f.__d=!1,S&&S(n),c=f.render(f.props,f.state,f.context),E=0;E<f._sb.length;E++)f.__h.push(f._sb[E]);f._sb=[]}else do{f.__d=!1,S&&S(n),c=f.render(f.props,f.state,f.context),f.state=f.__s}while(f.__d&&++w<25);f.state=f.__s,null!=f.getChildContext&&(_=h(h({},_),f.getChildContext())),p||null==f.getSnapshotBeforeUpdate||(v=f.getSnapshotBeforeUpdate(a,d)),U=null!=c&&c.type===g&&null==c.key?c.props.children:c,P(e,Array.isArray(U)?U:[U],n,t,_,l,o,i,u,s),f.base=n.__e,n.__h=null,f.__h.length&&i.push(f),y&&(f.__E=f.__=null),f.__e=!1}else null==o&&n.__v===t.__v?(n.__k=t.__k,n.__e=t.__e):n.__e=M(t.__e,n,t,_,l,o,i,s);(c=r.diffed)&&c(n)}catch(e){n.__v=null,(s||null!=o)&&(n.__e=u,n.__h=!!s,o[o.indexOf(u)]=null),r.__e(e,n,t)}}function L(e,n){r.__c&&r.__c(n,e),e.some((function(n){try{e=n.__h,n.__h=[],e.some((function(e){e.call(n)}))}catch(e){r.__e(e,n.__v)}}))}function M(e,n,t,_,l,r,i,u){var s,c,f,a=t.props,d=n.props,h=n.type,y=0;if("svg"===h&&(l=!0),null!=r)for(;y<r.length;y++)if((s=r[y])&&"setAttribute"in s==!!h&&(h?s.localName===h:3===s.nodeType)){e=s,r[y]=null;break}if(null==e){if(null===h)return document.createTextNode(d);e=l?document.createElementNS("http://www.w3.org/2000/svg",h):document.createElement(h,d.is&&d),r=null,u=!1}if(null===h)a===d||u&&e.data===d||(e.data=d);else{if(r=r&&o.call(e.childNodes),c=(a=t.props||p).dangerouslySetInnerHTML,f=d.dangerouslySetInnerHTML,!u){if(null!=r)for(a={},y=0;y<e.attributes.length;y++)a[e.attributes[y].name]=e.attributes[y].value;(f||c)&&(f&&(c&&f.__html==c.__html||f.__html===e.innerHTML)||(e.innerHTML=f&&f.__html||""))}if(function(e,n,t,_,l){var o;for(o in t)"children"===o||"key"===o||o in n||D(e,o,null,t[o],_);for(o in n)l&&"function"!=typeof n[o]||"children"===o||"key"===o||"value"===o||"checked"===o||t[o]===n[o]||D(e,o,n[o],t[o],_)}(e,d,a,l,u),f)n.__k=[];else if(y=n.props.children,P(e,Array.isArray(y)?y:[y],n,t,_,l&&"foreignObject"!==h,r,i,r?r[0]:t.__k&&b(t,0),u),null!=r)for(y=r.length;y--;)null!=r[y]&&v(r[y]);u||("value"in d&&void 0!==(y=d.value)&&(y!==e.value||"progress"===h&&!y||"option"===h&&y!==a.value)&&D(e,"value",y,a.value,!1),"checked"in d&&void 0!==(y=d.checked)&&y!==e.checked&&D(e,"checked",y,a.checked,!1))}return e}function F(e,n,t){try{"function"==typeof e?e(n):e.current=n}catch(e){r.__e(e,t)}}function H(e,n,t){var _,l;if(r.unmount&&r.unmount(e),(_=e.ref)&&(_.current&&_.current!==e.__e||F(_,null,n)),null!=(_=e.__c)){if(_.componentWillUnmount)try{_.componentWillUnmount()}catch(e){r.__e(e,n)}_.base=_.__P=null,e.__c=void 0}if(_=e.__k)for(l=0;l<_.length;l++)_[l]&&H(_[l],n,t||"function"!=typeof e.type);t||null==e.__e||v(e.__e),e.__=e.__e=e.__d=void 0}function O(e,n,t){return this.constructor(e,t)}function R(e,n,t){var _,l,i;r.__&&r.__(e,n),l=(_="function"==typeof t)?null:t&&t.__k||n.__k,i=[],W(n,e=(!_&&t||n).__k=y(g,null,[e]),l||p,p,void 0!==n.ownerSVGElement,!_&&t?[t]:l?null:n.firstChild?o.call(n.childNodes):null,i,!_&&t?t:l?l.__e:n.firstChild,_),L(i,e)}t.createElement=y,t.h=y,t.createRef=function(){return{current:null}},t.Fragment=g,t.Component=k,t.toChildArray=function e(n,t){return t=t||[],null==n||"boolean"==typeof n||(Array.isArray(n)?n.some((function(n){e(n,t)})):t.push(n)),t},t.render=R,t.hydrate=function e(n,t){R(n,t,e)},t.cloneElement=function(e,n,t){var _,l,r,i=h({},e.props);for(r in n)"key"==r?_=n[r]:"ref"==r?l=n[r]:i[r]=n[r];return arguments.length>2&&(i.children=arguments.length>3?o.call(arguments,2):t),m(e.type,i,_||e.key,l||e.ref,null)},t.createContext=function(e,n){var t={__c:n="__cC"+f++,__:e,Consumer:function(e,n){return e.children(n)},Provider:function(e){var t,_;return this.getChildContext||(t=[],(_={})[n]=this,this.getChildContext=function(){return _},this.shouldComponentUpdate=function(e){this.props.value!==e.value&&t.some((function(e){e.__e=!0,C(e)}))},this.sub=function(e){t.push(e);var n=e.componentWillUnmount;e.componentWillUnmount=function(){t.splice(t.indexOf(e),1),n&&n.call(e)}}),e.children}};return t.Provider.__=t.Consumer.contextType=t},o=a.slice,t.options=r={__e:function(e,n,t,_){for(var l,o,r;n=n.__;)if((l=n.__c)&&!l.__)try{if((o=l.constructor)&&null!=o.getDerivedStateFromError&&(l.setState(o.getDerivedStateFromError(e)),r=l.__d),null!=l.componentDidCatch&&(l.componentDidCatch(e,_||{}),r=l.__d),r)return l.__E=l}catch(n){e=n}throw e}},i=0,t.isValidElement=function(e){return null!=e&&void 0===e.constructor},k.prototype.setState=function(e,n){var t;t=null!=this.__s&&this.__s!==this.state?this.__s:this.__s=h({},this.state),"function"==typeof e&&(e=e(h({},t),this.props)),e&&h(t,e),null!=e&&this.__v&&(n&&this._sb.push(n),C(this))},k.prototype.forceUpdate=function(e){this.__v&&(this.__e=!0,e&&this.__h.push(e),C(this))},k.prototype.render=g,u=[],c="function"==typeof Promise?Promise.prototype.then.bind(Promise.resolve()):setTimeout,S.__r=0,f=0},
"283ce7811c": function _(_,n,t,o,u){o();const i=_("1b70f5b1d3");var r,e,c,f,a=0,s=[],h=[],p=i.options.__b,v=i.options.__r,l=i.options.diffed,m=i.options.__c,d=i.options.unmount;function H(_,n){i.options.__h&&i.options.__h(e,_,a||n),a=0;var t=e.__H||(e.__H={__:[],__h:[]});return _>=t.__.length&&t.__.push({__V:h}),t.__[_]}function E(_){return a=1,N(q,_)}function N(_,n,t){var o=H(r++,2);if(o.t=_,!o.__c&&(o.__=[t?t(n):q(void 0,n),function(_){var n=o.__N?o.__N[0]:o.__[0],t=o.t(n,_);n!==t&&(o.__N=[t,o.__[1]],o.__c.setState({}))}],o.__c=e,!e.u)){e.u=!0;var u=e.shouldComponentUpdate;e.shouldComponentUpdate=function(_,n,t){if(!o.__c.__H)return!0;var i=o.__c.__H.__.filter((function(_){return _.__c}));if(i.every((function(_){return!_.__N})))return!u||u.call(this,_,n,t);var r=!1;return i.forEach((function(_){if(_.__N){var n=_.__[0];_.__=_.__N,_.__N=void 0,n!==_.__[0]&&(r=!0)}})),!(!r&&o.__c.props===_)&&(!u||u.call(this,_,n,t))}}return o.__N||o.__}function y(_,n){var t=H(r++,4);!i.options.__s&&F(t.__H,n)&&(t.__=_,t.i=n,e.__h.push(t))}function V(_,n){var t=H(r++,7);return F(t.__H,n)?(t.__V=_(),t.i=n,t.__h=_,t.__V):t.__}function b(){for(var _;_=s.shift();)if(_.__P&&_.__H)try{_.__H.__h.forEach(A),_.__H.__h.forEach(D),_.__H.__h=[]}catch(n){_.__H.__h=[],i.options.__e(n,_.__v)}}t.useState=E,t.useReducer=N,t.useEffect=function(_,n){var t=H(r++,3);!i.options.__s&&F(t.__H,n)&&(t.__=_,t.i=n,e.__H.__h.push(t))},t.useLayoutEffect=y,t.useRef=function(_){return a=5,V((function(){return{current:_}}),[])},t.useImperativeHandle=function(_,n,t){a=6,y((function(){return"function"==typeof _?(_(n()),function(){return _(null)}):_?(_.current=n(),function(){return _.current=null}):void 0}),null==t?t:t.concat(_))},t.useMemo=V,t.useCallback=function(_,n){return a=8,V((function(){return _}),n)},t.useContext=function(_){var n=e.context[_.__c],t=H(r++,9);return t.c=_,n?(null==t.__&&(t.__=!0,n.sub(e)),n.props.value):_.__},t.useDebugValue=function(_,n){i.options.useDebugValue&&i.options.useDebugValue(n?n(_):_)},t.useErrorBoundary=function(_){var n=H(r++,10),t=E();return n.__=_,e.componentDidCatch||(e.componentDidCatch=function(_,o){n.__&&n.__(_,o),t[1](_)}),[t[0],function(){t[1](void 0)}]},t.useId=function(){var _=H(r++,11);if(!_.__){for(var n=e.__v;null!==n&&!n.__m&&null!==n.__;)n=n.__;var t=n.__m||(n.__m=[0,0]);_.__="P"+t[0]+"-"+t[1]++}return _.__},i.options.__b=function(_){e=null,p&&p(_)},i.options.__r=function(_){v&&v(_),r=0;var n=(e=_.__c).__H;n&&(c===e?(n.__h=[],e.__h=[],n.__.forEach((function(_){_.__N&&(_.__=_.__N),_.__V=h,_.__N=_.i=void 0}))):(n.__h.forEach(A),n.__h.forEach(D),n.__h=[])),c=e},i.options.diffed=function(_){l&&l(_);var n=_.__c;n&&n.__H&&(n.__H.__h.length&&(1!==s.push(n)&&f===i.options.requestAnimationFrame||((f=i.options.requestAnimationFrame)||C)(b)),n.__H.__.forEach((function(_){_.i&&(_.__H=_.i),_.__V!==h&&(_.__=_.__V),_.i=void 0,_.__V=h}))),c=e=null},i.options.__c=function(_,n){n.some((function(_){try{_.__h.forEach(A),_.__h=_.__h.filter((function(_){return!_.__||D(_)}))}catch(t){n.some((function(_){_.__h&&(_.__h=[])})),n=[],i.options.__e(t,_.__v)}})),m&&m(_,n)},i.options.unmount=function(_){d&&d(_);var n,t=_.__c;t&&t.__H&&(t.__H.__.forEach((function(_){try{A(_)}catch(_){n=_}})),t.__H=void 0,n&&i.options.__e(n,t.__v))};var g="function"==typeof requestAnimationFrame;function C(_){var n,t=function(){clearTimeout(o),g&&cancelAnimationFrame(n),setTimeout(_)},o=setTimeout(t,100);g&&(n=requestAnimationFrame(t))}function A(_){var n=e,t=_.__c;"function"==typeof t&&(_.__c=void 0,t()),e=n}function D(_){var n=e;_.__c=_.__(),e=n}function F(_,n){return!_||_.length!==n.length||n.some((function(n,t){return n!==_[t]}))}function q(_,n){return"function"==typeof n?n(_):n}},
"b3f51db71c": function _(n,t,d,e,b){e();const o=n("tslib"),r=n("1b70f5b1d3");var f=n("1b70f5b1d3");b("h",f.h),b("render",f.render),b("Component",f.Component);var a=o.__importDefault(n("ab33dd3f38")).default.bind(r.h);d.html=a},
"ab33dd3f38": function _(n,t,s,u,r){u();var e=function(n,t,s,u){var r;t[0]=0;for(var h=1;h<t.length;h++){var p=t[h++],a=t[h]?(t[0]|=p?1:2,s[t[h++]]):t[++h];3===p?u[0]=a:4===p?u[1]=Object.assign(u[1]||{},a):5===p?(u[1]=u[1]||{})[t[++h]]=a:6===p?u[1][t[++h]]+=a+"":p?(r=n.apply(a,e(n,a,s,["",null])),u.push(r),a[0]?t[0]|=2:(t[h-2]=0,t[h]=r)):u.push(a)}return u},h=new Map;s.default=function(n){var t=h.get(this);return t||(t=new Map,h.set(this,t)),(t=e(this,t.get(n)||(t.set(n,t=function(n){for(var t,s,u=1,r="",e="",h=[0],p=function(n){1===u&&(n||(r=r.replace(/^\s*\n\s*|\s*\n\s*$/g,"")))?h.push(0,n,r):3===u&&(n||r)?(h.push(3,n,r),u=2):2===u&&"..."===r&&n?h.push(4,n,0):2===u&&r&&!n?h.push(5,0,!0,r):u>=5&&((r||!n&&5===u)&&(h.push(u,0,r,s),u=6),n&&(h.push(u,n,0,s),u=6)),r=""},a=0;a<n.length;a++){a&&(1===u&&p(),p(a));for(var f=0;f<n[a].length;f++)t=n[a][f],1===u?"<"===t?(p(),h=[h],u=3):r+=t:4===u?"--"===r&&">"===t?(u=1,r=""):r=t+r[0]:e?t===e?e="":r+=t:'"'===t||"'"===t?e=t:">"===t?(p(),u=1):u&&("="===t?(u=5,s=r,r=""):"/"===t&&(u<5||">"===n[a][f+1])?(p(),3===u&&(h=h[0]),u=h,(h=h[0]).push(2,0,u),u=0):" "===t||"\t"===t||"\n"===t||"\r"===t?(p(),u=2):r+=t),3===u&&"!--"===r&&(u=4,h=h[0])}return p(),h}(n)),t),arguments,[])).length>1?t:t[0]}},
"665213fba5": function _(e,t,s,i,n){i();const l=e("tslib");var o;const d=e("@bokehjs/core/dom"),r=e("@bokehjs/core/util/types"),c=e("@bokehjs/models/widgets/input_widget"),h=l.__importStar(e("@bokehjs/styles/widgets/inputs.css"));class p extends c.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.value.change,(()=>this.render_selection())),this.connect(this.model.properties.options.change,(()=>this.render())),this.connect(this.model.properties.disabled_options.change,(()=>this.render())),this.connect(this.model.properties.size.change,(()=>this.render())),this.connect(this.model.properties.disabled.change,(()=>this.render()))}render(){super.render();const e=this.model.options.map((e=>{let t,s;(0,r.isString)(e)?t=s=e:[t,s]=e;let i=this.model.disabled_options.includes(t);return(0,d.option)({value:t,disabled:i},s)}));this.input_el=(0,d.select)({multiple:!1,class:h.input,name:this.model.name,disabled:this.model.disabled},e),this.input_el.style.backgroundImage="none",this.input_el.addEventListener("change",(()=>this.change_input())),this.group_el.appendChild(this.input_el),this.render_selection()}render_selection(){const e=this.model.value;for(const t of this.input_el.querySelectorAll("option"))t.value===e&&(t.selected=!0);this.input_el.size=this.model.size}change_input(){const e=null!=this.el.querySelector("select:focus");let t=null;for(const e of this.shadow_el.querySelectorAll("option"))if(e.selected){t=e.value;break}this.model.value=t,super.change_input(),e&&this.input_el.focus()}}s.SingleSelectView=p,p.__name__="SingleSelectView";class a extends c.InputWidget{constructor(e){super(e)}}s.SingleSelect=a,o=a,a.__name__="SingleSelect",a.__module__="panel.models.widgets",o.prototype.default_view=p,o.define((({Any:e,Array:t,Int:s,Nullable:i,String:n})=>({disabled_options:[t(n),[]],options:[t(e),[]],size:[s,4],value:[i(n),null]})))},
"7651136c44": function _(t,e,i,o,n){var s;o();const r=t("c64c1219c8"),h="Click to START the speech recognition.",{webkitSpeechRecognition:a}=window,{webkitSpeechGrammarList:l}=window;class c extends r.HTMLBoxView{initialize(){var t,e;super.initialize(),this.recognition=new a,this.recognition.lang=this.model.lang,this.recognition.continuous=this.model.continuous,this.recognition.interimResults=this.model.interim_results,this.recognition.maxAlternatives=this.model.max_alternatives,this.recognition.serviceURI=this.model.service_uri,this.setGrammars(),this.recognition.onresult=t=>{this.model.results=function(t){const e=[];for(let o of t){let t=[],n={is_final:o.isFinal,alternatives:t};for(let e=0;e<o.length;e++){let n={confidence:(i=o[e].confidence,Math.round(100*(i+Number.EPSILON))/100),transcript:o[e].transcript};t.push(n)}n.alternatives=t,e.push(n)}var i;return e}(t.results)},this.recognition.onerror=t=>{console.log("SpeechToText Error"),console.log(t)},this.recognition.onnomatch=t=>{console.log("SpeechToText No Match"),console.log(t)},this.recognition.onaudiostart=()=>this.model.audio_started=!0,this.recognition.onaudioend=()=>this.model.audio_started=!1,this.recognition.onsoundstart=()=>this.model.sound_started=!0,this.recognition.onsoundend=()=>this.model.sound_started=!1,this.recognition.onspeechstart=()=>this.model.speech_started=!0,this.recognition.onspeechend=()=>this.model.speech_started=!1,this.recognition.onstart=()=>{this.buttonEl.onclick=()=>{this.recognition.stop()},this.buttonEl.innerHTML=this.iconStarted(),this.buttonEl.setAttribute("title","Click to STOP the speech recognition."),this.model.started=!0},this.recognition.onend=()=>{this.buttonEl.onclick=()=>{this.recognition.start()},this.buttonEl.innerHTML=this.iconNotStarted(),this.buttonEl.setAttribute("title",h),this.model.started=!1},this.buttonEl=(t=`<button class="bk bk-btn bk-btn-${this.model.button_type}" type="button" title="${h}"></button>`,e=document.createElement("template"),t=t.trim(),e.innerHTML=t,e.content.firstChild),this.buttonEl.innerHTML=this.iconNotStarted(),this.buttonEl.onclick=()=>this.recognition.start()}iconStarted(){return""!==this.model.button_started?this.model.button_started:'<svg xmlns="http://www.w3.org/2000/svg" height="22px" style="vertical-align: middle;" fill="currentColor" class="bi bi-mic" viewBox="0 0 16 16">\n  <path fill-rule="evenodd" d="M3.5 6.5A.5.5 0 0 1 4 7v1a4 4 0 0 0 8 0V7a.5.5 0 0 1 1 0v1a5 5 0 0 1-4.5 4.975V15h3a.5.5 0 0 1 0 1h-7a.5.5 0 0 1 0-1h3v-2.025A5 5 0 0 1 3 8V7a.5.5 0 0 1 .5-.5z"/>\n  <path fill-rule="evenodd" d="M10 8V3a2 2 0 1 0-4 0v5a2 2 0 1 0 4 0zM8 0a3 3 0 0 0-3 3v5a3 3 0 0 0 6 0V3a3 3 0 0 0-3-3z"/>\n</svg>'}iconNotStarted(){return""!==this.model.button_not_started?this.model.button_not_started:'<svg xmlns="http://www.w3.org/2000/svg" height="22px" style="vertical-align: middle;" fill="currentColor" class="bi bi-mic-mute" viewBox="0 0 16 16">\n<path fill-rule="evenodd" d="M12.734 9.613A4.995 4.995 0 0 0 13 8V7a.5.5 0 0 0-1 0v1c0 .274-.027.54-.08.799l.814.814zm-2.522 1.72A4 4 0 0 1 4 8V7a.5.5 0 0 0-1 0v1a5 5 0 0 0 4.5 4.975V15h-3a.5.5 0 0 0 0 1h7a.5.5 0 0 0 0-1h-3v-2.025a4.973 4.973 0 0 0 2.43-.923l-.718-.719zM11 7.88V3a3 3 0 0 0-5.842-.963l.845.845A2 2 0 0 1 10 3v3.879l1 1zM8.738 9.86l.748.748A3 3 0 0 1 5 8V6.121l1 1V8a2 2 0 0 0 2.738 1.86zm4.908 3.494l-12-12 .708-.708 12 12-.708.707z"/>\n</svg>'}setIcon(){this.model.started?this.buttonEl.innerHTML=this.iconStarted():this.buttonEl.innerHTML=this.iconNotStarted()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.start.change,(()=>{this.model.start=!1,this.recognition.start()})),this.connect(this.model.properties.stop.change,(()=>{this.model.stop=!1,this.recognition.stop()})),this.connect(this.model.properties.abort.change,(()=>{this.model.abort=!1,this.recognition.abort()})),this.connect(this.model.properties.grammars.change,(()=>this.setGrammars())),this.connect(this.model.properties.lang.change,(()=>this.recognition.lang=this.model.lang)),this.connect(this.model.properties.continuous.change,(()=>this.recognition.continuous=this.model.continuous)),this.connect(this.model.properties.interim_results.change,(()=>this.recognition.interimResults=this.model.interim_results)),this.connect(this.model.properties.max_alternatives.change,(()=>this.recognition.maxAlternatives=this.model.max_alternatives)),this.connect(this.model.properties.service_uri.change,(()=>this.recognition.serviceURI=this.model.service_uri)),this.connect(this.model.properties.button_type.change,(()=>this.buttonEl.className=`bk bk-btn bk-btn-${this.model.button_type}`)),this.connect(this.model.properties.button_hide.change,(()=>this.render()));const{button_not_started:t,button_started:e}=this.model.properties;this.on_change([t,e],(()=>this.setIcon()))}setGrammars(){this.recognition.grammars=function(t){if(t){var e=new l;for(let i of t)i.src?e.addFromString(i.src,i.weight):i.uri&&e.addFromURI(i.uri,i.weight);return e}return null}(this.model.grammars)}render(){super.render(),this.model.button_hide||this.shadow_el.appendChild(this.buttonEl)}}i.SpeechToTextView=c,c.__name__="SpeechToTextView";class d extends r.HTMLBox{constructor(t){super(t)}}i.SpeechToText=d,s=d,d.__name__="SpeechToText",d.__module__="panel.models.speech_to_text",s.prototype.default_view=c,s.define((({Any:t,Array:e,Boolean:i,Number:o,String:n})=>({start:[i,!1],stop:[i,!1],abort:[i,!1],grammars:[e(t),[]],lang:[n,""],continuous:[i,!1],interim_results:[i,!1],max_alternatives:[o,1],service_uri:[n,""],started:[i,!1],audio_started:[i,!1],sound_started:[i,!1],speech_started:[i,!1],button_type:[n,"light"],button_hide:[i,!1],button_not_started:[n,""],button_started:[n,""],results:[e(t),[]]})))},
"1bb5a1aca6": function _(e,t,s,a,i){var o;a();const c=e("@bokehjs/core/view"),n=e("@bokehjs/core/util/array"),h=e("@bokehjs/model"),_=e("@bokehjs/protocol/receiver");class r extends c.View{}s.StateView=r,r.__name__="StateView";class p extends h.Model{constructor(e){super(e),this._receiver=new _.Receiver,this._cache={}}apply_state(e){this._receiver.consume(e.header),this._receiver.consume(e.metadata),this._receiver.consume(e.content),this._receiver.message&&this.document&&this.document.apply_json_patch(this._receiver.message.content)}_receive_json(e,t){const s=JSON.parse(e);this._cache[t]=s;let a=this.state;for(const e of this.values)a=a instanceof Map?a.get(e):a[e];a===t?this.apply_state(s):this._cache[a]&&this.apply_state(this._cache[a])}set_state(e,t){let s=(0,n.copy)(this.values);s[this.widgets[e.id]]=t;let a=this.state;for(const e of s)a=a instanceof Map?a.get(e):a[e];var i,o,c;this.values=s,this.json?this._cache[a]?this.apply_state(this._cache[a]):(i=a,o=e=>this._receive_json(e,a),(c=new XMLHttpRequest).overrideMimeType("application/json"),c.open("GET",i,!0),c.onreadystatechange=function(){4==c.readyState&&200==c.status&&o(c.responseText)},c.send(null)):this.apply_state(a)}}s.State=p,o=p,p.__name__="State",p.__module__="panel.models.state",o.prototype.default_view=r,o.define((({Any:e,Boolean:t})=>({json:[t,!1],state:[e,{}],widgets:[e,{}],values:[e,[]]})))},
"8013e805da": function _(e,t,s,i,l){i();var o;const a=e("tslib").__importStar(e("@bokehjs/styles/tabs.css")),n=e("@bokehjs/core/layout/grid"),c=e("@bokehjs/core/enums"),d=e("@bokehjs/models/layouts/alignments"),r=e("@bokehjs/models/layouts/tabs"),_=e("@bokehjs/models/layouts/layout_dom");function u(e){e.style.visibility="",e.style.opacity=""}function h(e){e.style.visibility="hidden",e.style.opacity="0"}class y extends r.TabsView{connect_signals(){super.connect_signals();let e=this;for(;null!=e;)e.model.type.endsWith("Tabs")&&e.connect(e.model.properties.active.change,(()=>this.update_zindex())),e=e.parent||e._parent}get is_visible(){let e=this.parent,t=this;for(;null!=e;){if(e.model.type.endsWith("Tabs")&&e.child_views.indexOf(t)!==e.model.active)return!1;t=e,e=e.parent||e._parent}return!0}render(){super.render(),this.update_zindex()}update_zindex(){const{child_views:e}=this;for(const t of e)null!=t&&null!=t.el&&(t.el.style.zIndex="");if(this.is_visible){const t=e[this.model.active];null!=t&&null!=t.el&&(t.el.style.zIndex="1")}}_after_layout(){_.LayoutDOMView.prototype._after_layout.call(this);const{child_views:e}=this;for(const t of e)void 0!==t&&h(t.el);const{active:t}=this.model;if(t in e){const s=e[t];void 0!==s&&u(s.el)}}_update_layout(){_.LayoutDOMView.prototype._update_layout.call(this);const e=this.model.tabs_location;this.class_list.remove([...c.Location].map((e=>a[e]))),this.class_list.add(a[e]);const t=new n.Container;for(const e of this.child_views)null!=e&&(e.style.append(":host",{grid_area:"stack"}),e instanceof _.LayoutDOMView&&null!=e.layout&&t.add({r0:0,c0:0,r1:1,c1:1},e));0!=t.size?(this.layout=new d.GridAlignmentLayout(t),this.layout.set_sizing()):delete this.layout}update_active(){const e=this.model.active,{header_els:t}=this;for(const e of t)e.classList.remove(a.active);e in t&&t[e].classList.add(a.active);const{child_views:s}=this;for(const e of s)h(e.el);if(e in s){const t=s[e];u(t.el),null==t.invalidate_render&&t.invalidate_render()}}}s.TabsView=y,y.__name__="TabsView";class p extends r.Tabs{}s.Tabs=p,o=p,p.__name__="Tabs",p.__module__="panel.models.tabs",o.prototype.default_view=y},
"4a0674b147": function _(e,t,n,s,i){var r,o;s();const a=e("@bokehjs/core/dom"),l=e("@bokehjs/core/bokeh_events"),h=e("c64c1219c8");class d extends l.ModelEvent{constructor(e){super(),this.key=e}get event_values(){return{model:this.origin,key:this.key}}}n.KeystrokeEvent=d,r=d,d.__name__="KeystrokeEvent",r.prototype.event_name="keystroke";class c extends h.HTMLBoxView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.output.change,this.write),this.connect(this.model.properties._clears.change,this.clear)}render(){super.render(),this.container=(0,a.div)({class:"terminal-container"}),(0,h.set_size)(this.container,this.model),this.term=this.getNewTerminal(),this.term.onData((e=>{this.handleOnData(e)})),this.webLinksAddon=this.getNewWebLinksAddon(),this.term.loadAddon(this.webLinksAddon),this.term.open(this.container),this.term.onRender((()=>{this._rendered||this.fit()})),this.write(),this.shadow_el.appendChild(this.container)}getNewTerminal(){const e=window;return e.Terminal?new e.Terminal(this.model.options):new e.xtermjs.Terminal(this.model.options)}getNewWebLinksAddon(){return new window.WebLinksAddon.WebLinksAddon}handleOnData(e){this.model.trigger_event(new d(e))}write(){const e=this.model.output;if(null==e||!e.length)return;const t=e.replace(/\r?\n/g,"\r\n");this.term.write(t)}clear(){this.term.clear()}fit(){const e=this.container.offsetWidth,t=this.container.offsetHeight,n=this.term._core._renderService,s=n.dimensions.actualCellWidth||9,i=n.dimensions.actualCellHeight||18;if(null==e||null==t||e<=0||t<=0)return;const r=Math.max(2,Math.floor(e/s)),o=Math.max(1,Math.floor(t/i));this.term.rows===o&&this.term.cols===r||this.term.resize(r,o),this.model.ncols=r,this.model.nrows=o,this._rendered=!0}after_layout(){super.after_layout(),this.fit()}}n.TerminalView=c,c.__name__="TerminalView";class m extends h.HTMLBox{constructor(e){super(e)}}n.Terminal=m,o=m,m.__name__="Terminal",m.__module__="panel.models.terminal",o.prototype.default_view=c,o.define((({Any:e,Int:t,String:n})=>({_clears:[t,0],options:[e,{}],output:[n,""],ncols:[t,0],nrows:[t,0]})))},
"59f46adc8c": function _(e,t,s,n,a){var o;n();const r=e("@bokehjs/models/widgets/textarea_input");class i extends r.TextAreaInputView{connect_signals(){super.connect_signals();const{value:e,max_rows:t}=this.model.properties;this.on_change([t,e],(()=>this.update_rows()))}update_rows(){if(!this.model.auto_grow)return;const e=this.input_el,t=e.value.split("\n"),s=Math.max(t.length,this.model.rows,1);e.rows=Math.min(s,this.model.max_rows||1/0)}render(){super.render(),this.update_rows(),this.el.addEventListener("input",(()=>{this.update_rows()}))}}s.TextAreaInputView=i,i.__name__="TextAreaInputView";class _ extends r.TextAreaInput{constructor(e){super(e)}}s.TextAreaInput=_,o=_,_.__name__="TextAreaInput",_.__module__="panel.models.widgets",o.prototype.default_view=i,o.define((({Boolean:e,Int:t,Nullable:s})=>({auto_grow:[e,!1],max_rows:[s(t),null]})))},
"a44f0bd49f": function _(e,s,i,t,n){var h;t();const o=e("c64c1219c8");function c(e){var s=[];for(let t of e){var i={default:t.default,lang:t.lang,local_service:t.localService,name:t.name,voice_uri:t.voiceURI};s.push(i)}return s}class p extends o.HTMLBoxView{initialize(){super.initialize(),this.model.paused=speechSynthesis.paused,this.model.pending=speechSynthesis.pending,this.model.speaking=speechSynthesis.speaking,this._callback=window.setInterval((function(){!speechSynthesis.paused&&speechSynthesis.speaking&&window.speechSynthesis.resume()}),1e4);const e=()=>{"undefined"!=typeof speechSynthesis&&(this.voices=speechSynthesis.getVoices(),this.voices&&(this.model.voices=c(this.voices)))};e(),"undefined"!=typeof speechSynthesis&&void 0!==speechSynthesis.onvoiceschanged&&(speechSynthesis.onvoiceschanged=e)}remove(){null!=this._callback&&clearInterval(this._callback),speechSynthesis.cancel(),super.remove()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.speak.change,(()=>{this.speak()})),this.connect(this.model.properties.pause.change,(()=>{this.model.pause=!1,speechSynthesis.pause()})),this.connect(this.model.properties.resume.change,(()=>{this.model.resume=!1,speechSynthesis.resume()})),this.connect(this.model.properties.cancel.change,(()=>{this.model.cancel=!1,speechSynthesis.cancel()}))}speak(){let e=new SpeechSynthesisUtterance(this.model.speak.text);if(e.pitch=this.model.speak.pitch,e.volume=this.model.speak.volume,e.rate=this.model.speak.rate,this.model.voices)for(let s of this.voices)s.name===this.model.speak.voice&&(e.voice=s);e.onpause=()=>this.model.paused=!0,e.onstart=()=>{this.model.speaking=!0,this.model.paused=!1,this.model.pending=speechSynthesis.pending},e.onresume=()=>this.model.paused=!1,e.onend=()=>{this.model.speaking=!1,this.model.paused=!1,this.model.pending=speechSynthesis.pending},speechSynthesis.speak(e),this.model.paused=speechSynthesis.paused,this.model.pending=speechSynthesis.pending}render(){super.render(),this.model.voices||(this.model.voices=c(this.voices)),null!=this.model.speak&&this.model.speak.text&&this.speak()}}i.TextToSpeechView=p,p.__name__="TextToSpeechView";class a extends o.HTMLBox{constructor(e){super(e)}}i.TextToSpeech=a,h=a,a.__name__="TextToSpeech",a.__module__="panel.models.text_to_speech",h.prototype.default_view=p,h.define((({Any:e,Array:s,Boolean:i})=>({paused:[i,!1],pending:[i,!1],speaking:[i,!1],voices:[s(e),[]],cancel:[i,!1],pause:[i,!1],resume:[i,!1],speak:[e,{}]})))},
"4c6dd3d1dc": function _(e,s,t,o,i){o();const l=e("tslib");var n;const d=e("@bokehjs/models/widgets/control"),c=e("@bokehjs/models/ui/tooltip"),r=e("@bokehjs/core/build_views"),a=e("@bokehjs/core/dom"),p=l.__importStar(e("@bokehjs/styles/widgets/inputs.css")),u=p,_=l.__importDefault(e("@bokehjs/styles/icons.css"));class h extends d.ControlView{*controls(){}*children(){yield*super.children(),yield this.description}async lazy_initialize(){await super.lazy_initialize();const{description:e}=this.model;this.description=await(0,r.build_view)(e,{parent:this})}remove(){var e;null===(e=this.description)||void 0===e||e.remove(),super.remove()}stylesheets(){return[...super.stylesheets(),p.default,_.default]}render(){super.render();const e=(0,a.div)({class:u.icon});this.desc_el=(0,a.div)({class:u.description},e);const{desc_el:s,description:t}=this;t.model.target=s;let o=!1;const i=s=>{t.model.setv({visible:s,closable:o}),e.classList.toggle(u.opaque,s&&o)};this.on_change(t.model.properties.visible,(()=>{const{visible:e}=t.model;e||(o=!1),i(e)})),s.addEventListener("mouseenter",(()=>{i(!0)})),s.addEventListener("mouseleave",(()=>{o||i(!1)})),document.addEventListener("mousedown",(e=>{const l=e.composedPath();l.includes(t.el)||(l.includes(s)?(o=!o,i(o)):(o=!1,i(!1)))})),window.addEventListener("blur",(()=>{o=!1,i(!1)})),this.shadow_el.appendChild((0,a.label)(this.desc_el))}change_input(){}}t.TooltipIconView=h,h.__name__="TooltipIconView";class m extends d.Control{constructor(e){super(e)}}t.TooltipIcon=m,n=m,m.__name__="TooltipIcon",m.__module__="panel.models.widgets",n.prototype.default_view=h,n.define((({Ref:e})=>({description:[e(c.Tooltip),new c.Tooltip]})))},
"c2c4524e04": function _(t,e,i,l,o){var s;l();const h=t("c64c1219c8"),a=t("@bokehjs/core/build_views"),n=t("@bokehjs/models/plots"),d=t("@bokehjs/models/glyphs"),r=t("@bokehjs/core/dom"),c=t("@bokehjs/models/sources/column_data_source"),p=t("@bokehjs/models/formatters");class _ extends h.HTMLBoxView{initialize(){super.initialize(),this.containerDiv=(0,r.div)({style:"height:100%; width:100%;"}),this.titleDiv=(0,r.div)({style:"font-size: 1em; word-wrap: break-word;"}),this.valueDiv=(0,r.div)({style:"font-size: 2em"}),this.value2Div=(0,r.div)({style:"font-size: 1em; opacity: 0.5; display: inline"}),this.changeDiv=(0,r.div)({style:"font-size: 1em; opacity: 0.5; display: inline"}),this.textDiv=(0,r.div)({},this.titleDiv,this.valueDiv,(0,r.div)({},this.changeDiv,this.value2Div)),this.updateTitle(),this.updateValue(),this.updateValue2(),this.updateValueChange(),this.updateTextFontSize(),this.plotDiv=(0,r.div)({}),this.containerDiv=(0,r.div)({style:"height:100%; width:100%"},this.textDiv,this.plotDiv),this.updateLayout()}connect_signals(){super.connect_signals();const{pos_color:t,neg_color:e}=this.model.properties;this.on_change([t,e],(()=>this.updateValueChange()));const{plot_color:i,plot_type:l,width:o,height:s,sizing_mode:h}=this.model.properties;this.on_change([i,l,o,s,h],(()=>this.render())),this.connect(this.model.properties.title.change,(()=>this.updateTitle(!0))),this.connect(this.model.properties.value.change,(()=>this.updateValue(!0))),this.connect(this.model.properties.value_change.change,(()=>this.updateValue2(!0))),this.connect(this.model.properties.layout.change,(()=>this.updateLayout()))}async render(){super.render(),this.shadow_el.appendChild(this.containerDiv),await this.setPlot()}async setPlot(){this.plot=new n.Plot({background_fill_color:null,border_fill_color:null,outline_line_color:null,min_border:0,sizing_mode:"stretch_both",toolbar_location:null});var t=this.model.source;if("line"===this.model.plot_type){var e=new d.Line({x:{field:this.model.plot_x},y:{field:this.model.plot_y},line_width:4,line_color:this.model.plot_color});this.plot.add_glyph(e,t)}else if("step"===this.model.plot_type){var i=new d.Step({x:{field:this.model.plot_x},y:{field:this.model.plot_y},line_width:3,line_color:this.model.plot_color});this.plot.add_glyph(i,t)}else if("area"===this.model.plot_type){var l=new d.VArea({x:{field:this.model.plot_x},y1:{field:this.model.plot_y},y2:0,fill_color:this.model.plot_color,fill_alpha:.5});this.plot.add_glyph(l,t);e=new d.Line({x:{field:this.model.plot_x},y:{field:this.model.plot_y},line_width:3,line_color:this.model.plot_color});this.plot.add_glyph(e,t)}else{var o=new d.VBar({x:{field:this.model.plot_x},top:{field:this.model.plot_y},width:.9,line_color:null,fill_color:this.model.plot_color});this.plot.add_glyph(o,t)}const s=await(0,a.build_view)(this.plot);this.plotDiv.innerHTML="",s.render_to(this.plotDiv)}after_layout(){super.after_layout(),this.updateTextFontSize()}updateTextFontSize(){this.updateTextFontSizeColumn()}updateTextFontSizeColumn(){let t=this.containerDiv.clientWidth,e=this.containerDiv.clientHeight;"column"===this.model.layout?e=Math.round(e/2):t=Math.round(t/2);const i=t/this.model.title.length*2,l=t/(2*this._value_format.length)*1.8,o=t/(this._value_change_format.length+1)*2,s=e/6,h=Math.min(i,l,o,s);this.textDiv.style.fontSize=Math.trunc(h)+"px",this.textDiv.style.lineHeight="1.3"}updateTitle(t=!1){this.titleDiv.innerText=this.model.title,t&&this.updateTextFontSize()}updateValue(t=!1){this._value_format=this.model.formatter.doFormat([this.model.value],{loc:0})[0],this.valueDiv.innerText=this._value_format,t&&this.updateTextFontSize()}updateValue2(t=!1){this._value_change_format=this.model.change_formatter.doFormat([this.model.value_change],{loc:0})[0],this.value2Div.innerText=this._value_change_format,this.updateValueChange(),t&&this.updateTextFontSize()}updateValueChange(){this.model.value_change>0?(this.changeDiv.innerHTML="&#9650;",this.changeDiv.style.color=this.model.pos_color):this.model.value_change<0?(this.changeDiv.innerHTML="&#9660;",this.changeDiv.style.color=this.model.neg_color):(this.changeDiv.innerHTML="&nbsp;",this.changeDiv.style.color="inherit")}updateLayout(){"column"===this.model.layout?(this.containerDiv.style.display="block",this.textDiv.style.height="50%",this.textDiv.style.width="100%",this.plotDiv.style.height="50%",this.plotDiv.style.width="100%"):(this.containerDiv.style.display="flex",this.textDiv.style.height="100%",this.textDiv.style.width="",this.plotDiv.style.height="100%",this.plotDiv.style.width="",this.textDiv.style.flex="1",this.plotDiv.style.flex="1"),this._has_finished&&this.invalidate_layout()}}i.TrendIndicatorView=_,_.__name__="TrendIndicatorView";class u extends h.HTMLBox{constructor(t){super(t)}}i.TrendIndicator=u,s=u,u.__name__="TrendIndicator",u.__module__="panel.models.trend",s.prototype.default_view=_,s.define((({Number:t,String:e,Ref:i})=>({description:[e,""],formatter:[i(p.TickFormatter),()=>new p.BasicTickFormatter],change_formatter:[i(p.TickFormatter),()=>new p.NumeralTickFormatter],layout:[e,"column"],source:[i(c.ColumnDataSource)],plot_x:[e,"x"],plot_y:[e,"y"],plot_color:[e,"#428bca"],plot_type:[e,"bar"],pos_color:[e,"#5cb85c"],neg_color:[e,"#d9534f"],title:[e,""],value:[t,0],value_change:[t,0]})))},
"b396729d22": function _(e,t,s,o,n){var i,a;o();const c=e("@bokehjs/core/dom"),r=e("@bokehjs/core/bokeh_events"),d=e("@bokehjs/core/util/types"),h=e("@bokehjs/models/layouts/layout_dom"),l=e("c64c1219c8"),_=e("99a25e6992");class u extends r.ModelEvent{constructor(e){super(),this.data=e}get event_values(){return{model:this.origin,data:this.data}}}s.VegaEvent=u,i=u,u.__name__="VegaEvent",i.prototype.event_name="vega_event";class v extends h.LayoutDOMView{constructor(){super(...arguments),this._rendered=!1}connect_signals(){super.connect_signals();const{data:e,show_actions:t,theme:s}=this.model.properties;this._replot=(0,_.debounce)((()=>this._plot()),20),this.on_change([e,t,s],(()=>{this._replot()})),this.connect(this.model.properties.data_sources.change,(()=>this._connect_sources())),this.connect(this.model.properties.events.change,(()=>{for(const e of this.model.events){if(this._callbacks.indexOf(e)>-1)continue;this._callbacks.push(e);const t=(e,t)=>this._dispatch_event(e,t),s=this.model.throttle[e]||20;this.vega_view.addSignalListener(e,(0,_.debounce)(t,s,!1))}})),this._connected=[],this._connect_sources()}_connect_sources(){for(const e in this.model.data_sources){const t=this.model.data_sources[e];this._connected.indexOf(e)<0&&(this.connect(t.properties.data.change,(()=>this._replot())),this._connected.push(e))}}remove(){this.vega_view&&this.vega_view.finalize(),super.remove()}_dispatch_event(e,t){if("vlPoint"in t&&null!=t.vlPoint.or){const e=[];for(const s of t.vlPoint.or)if(void 0!==s._vgsid_)e.push(s._vgsid_);else for(const t in s)s.hasOwnProperty(t)&&e.push({[t]:s[t]});t=e}this.model.trigger_event(new u({type:e,value:t}))}_fetch_datasets(){const e={};for(const t in this.model.data_sources){const s=this.model.data_sources[t],o=[],n=s.columns();for(let e=0;e<s.get_length();e++){const t={};for(const o of n)t[o]=s.data[o][e];o.push(t)}e[t]=o}return e}get child_models(){return[]}render(){super.render(),this._rendered=!1,this.container=(0,c.div)(),(0,l.set_size)(this.container,this.model),this._callbacks=[],this._plot(),this.shadow_el.append(this.container)}_plot(){const e=this.model.data;if(null==e||!window.vegaEmbed)return;if(this.model.data_sources&&Object.keys(this.model.data_sources).length>0){const t=this._fetch_datasets();if("data"in t&&(e.data.values=t.data,delete t.data),null!=e.data){const s=(0,d.isArray)(e.data)?e.data:[e.data];for(const e of s)e.name in t&&(e.values=t[e.name],delete t[e.name])}this.model.data.datasets=t}const t={actions:this.model.show_actions,theme:this.model.theme};window.vegaEmbed(this.container,this.model.data,t).then((e=>{this.vega_view=e.view,this._resize=(0,_.debounce)((()=>this.resize_view(e.view)),50);const t=(e,t)=>this._dispatch_event(e,t);for(const e of this.model.events){this._callbacks.push(e);const s=this.model.throttle[e]||20;this.vega_view.addSignalListener(e,(0,_.debounce)(t,s,!1))}}))}after_layout(){super.after_layout(),null!=this.vega_view&&this._resize()}resize_view(e){const t=e._renderer.canvas();if(!this._rendered&&null!==t){for(const t of e._eventListeners)"resize"===t.type&&t.handler(new Event("resize"));this._rendered=!0}}}s.VegaPlotView=v,v.__name__="VegaPlotView";class m extends h.LayoutDOM{constructor(e){super(e)}}s.VegaPlot=m,a=m,m.__name__="VegaPlot",m.__module__="panel.models.vega",a.prototype.default_view=v,a.define((({Any:e,Array:t,Boolean:s,Nullable:o,String:n})=>({data:[e,{}],data_sources:[e,{}],events:[t(n),[]],show_actions:[s,!1],theme:[o(n),null],throttle:[e,{}]})))},
"e6e8c94f32": function _(e,t,i,o,s){var l;o();const d=e("c64c1219c8");class h extends d.HTMLBoxView{initialize(){super.initialize(),this._blocked=!1,this._setting=!1,this._time=Date.now()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.loop.change,(()=>this.set_loop())),this.connect(this.model.properties.paused.change,(()=>this.set_paused())),this.connect(this.model.properties.muted.change,(()=>this.set_muted())),this.connect(this.model.properties.autoplay.change,(()=>this.set_autoplay())),this.connect(this.model.properties.time.change,(()=>this.set_time())),this.connect(this.model.properties.value.change,(()=>this.set_value())),this.connect(this.model.properties.volume.change,(()=>this.set_volume()))}render(){super.render(),this.videoEl=document.createElement("video"),this.containerEl=document.createElement("div"),this.containerEl.className="pn-video-container",this.containerEl.style.height="100%",this.containerEl.style.width="100%",this.videoEl.style.objectFit="fill",this.videoEl.style.width="100%",this.videoEl.style.height="100%",this.model.sizing_mode&&"fixed"!==this.model.sizing_mode||(this.model.height&&(this.videoEl.height=this.model.height),this.model.width&&(this.videoEl.width=this.model.width)),this.model.max_height&&(this.videoEl.style.maxHeight=`${this.model.max_height}px`),this.model.max_width&&(this.videoEl.style.maxWidth=`${this.model.max_width}px`),this.videoEl.controls=!0,this.videoEl.src=this.model.value,this.videoEl.currentTime=this.model.time,this.videoEl.loop=this.model.loop,this.videoEl.muted=this.model.muted,this.videoEl.autoplay=this.model.autoplay,null!=this.model.volume?this.videoEl.volume=this.model.volume/100:this.model.volume=100*this.videoEl.volume,this.videoEl.onpause=()=>this.model.paused=!0,this.videoEl.onplay=()=>this.model.paused=!1,this.videoEl.ontimeupdate=()=>this.update_time(this),this.videoEl.onvolumechange=()=>this.update_volume(this),this.containerEl.appendChild(this.videoEl),this.shadow_el.appendChild(this.containerEl),this.model.paused||this.videoEl.play()}update_time(e){e._setting?e._setting=!1:Date.now()-e._time<e.model.throttle||(e._blocked=!0,e.model.time=e.videoEl.currentTime,e._time=Date.now())}update_volume(e){e._setting?e._setting=!1:(e._blocked=!0,e.model.volume=100*e.videoEl.volume)}set_loop(){this.videoEl.loop=this.model.loop}set_muted(){this.videoEl.muted=this.model.muted}set_autoplay(){this.videoEl.autoplay=this.model.autoplay}set_paused(){!this.videoEl.paused&&this.model.paused&&this.videoEl.pause(),this.videoEl.paused&&!this.model.paused&&this.videoEl.play()}set_volume(){this._blocked?this._blocked=!1:(this._setting=!0,null!=this.model.volume&&(this.videoEl.volume=this.model.volume/100))}set_time(){this._blocked?this._blocked=!1:(this._setting=!0,this.videoEl.currentTime=this.model.time)}set_value(){this.videoEl.src=this.model.value}}i.VideoView=h,h.__name__="VideoView";class m extends d.HTMLBox{constructor(e){super(e)}}i.Video=m,l=m,m.__name__="Video",m.__module__="panel.models.widgets",l.prototype.default_view=h,l.define((({Any:e,Boolean:t,Int:i,Number:o,Nullable:s})=>({loop:[t,!1],paused:[t,!0],muted:[t,!1],autoplay:[t,!1],time:[o,0],throttle:[i,250],value:[e,""],volume:[s(i),null]})))},
"2dfabe6882": function _(e,t,i,s,o){var h;s();const l=e("c64c1219c8");class a extends l.HTMLBoxView{constructor(){super(...arguments),this.constraints={audio:!1,video:!0}}initialize(){super.initialize(),null!==this.model.timeout&&this.set_timeout()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.timeout.change,(()=>this.set_timeout())),this.connect(this.model.properties.snapshot.change,(()=>this.snapshot())),this.connect(this.model.properties.paused.change,(()=>this.pause()))}pause(){this.model.paused?(null!=this.timer&&(clearInterval(this.timer),this.timer=null),this.videoEl.pause()):this.videoEl.play(),this.set_timeout()}set_timeout(){this.timer&&(clearInterval(this.timer),this.timer=null),null!=this.model.timeout&&this.model.timeout>0&&(this.timer=setInterval((()=>this.snapshot()),this.model.timeout))}snapshot(){this.canvasEl.width=this.videoEl.videoWidth,this.canvasEl.height=this.videoEl.videoHeight;const e=this.canvasEl.getContext("2d");e&&e.drawImage(this.videoEl,0,0,this.canvasEl.width,this.canvasEl.height),this.model.value=this.canvasEl.toDataURL("image/"+this.model.format,.95)}remove(){super.remove(),this.timer&&(clearInterval(this.timer),this.timer=null)}render(){super.render(),this.videoEl||(this.videoEl=document.createElement("video"),this.model.sizing_mode&&"fixed"!==this.model.sizing_mode||(this.model.height&&(this.videoEl.height=this.model.height),this.model.width&&(this.videoEl.width=this.model.width)),this.videoEl.style.objectFit="fill",this.videoEl.style.minWidth="100%",this.videoEl.style.minHeight="100%",this.canvasEl=document.createElement("canvas"),this.shadow_el.appendChild(this.videoEl),navigator.mediaDevices.getUserMedia&&navigator.mediaDevices.getUserMedia(this.constraints).then((e=>{this.videoEl.srcObject=e,this.model.paused||this.videoEl.play()})).catch(console.error))}}i.VideoStreamView=a,a.__name__="VideoStreamView";class n extends l.HTMLBox{constructor(e){super(e)}}i.VideoStream=n,h=n,n.__name__="VideoStream",n.__module__="panel.models.widgets",h.prototype.default_view=a,h.define((({Any:e,Boolean:t,Int:i,Nullable:s,String:o})=>({format:[o,"png"],paused:[t,!1],snapshot:[t,!1],timeout:[s(i),null],value:[e]}))),h.override({height:240,width:320})},
"dfe3c4a2a9": function _(e,t,i,s,n){var o;s();const a=e("@bokehjs/core/dom"),c=e("@bokehjs/core/util/types"),l=e("@bokehjs/models/sources/column_data_source"),r=e("@bokehjs/core/bokeh_events"),h=e("99a25e6992"),d=e("c64c1219c8");class u extends r.ModelEvent{constructor(e){super(),this.data=e,this.event_name="vizzu_event",this.publish=!0}get event_values(){return{model:this.origin,data:this.data}}}i.VizzuEvent=u,u.__name__="VizzuEvent";const g=["x","y","color","label","lightness","size","splittedBy","dividedBy"];class m extends d.HTMLBoxView{constructor(){super(...arguments),this.update=[],this._animating=!1}connect_signals(){super.connect_signals();const e=(0,h.debounce)((()=>{if(this.valid_config){if(this.update.length&&!this._animating){let t={};for(const e of this.update)t="config"===e?Object.assign(Object.assign({},t),{config:this.config()}):"data"===e?Object.assign(Object.assign({},t),{data:this.data()}):Object.assign(Object.assign({},t),{style:this.model.style});this._animating=!0,this.vizzu_view.animate(t,this.model.duration+"ms").then((()=>{this._animating=!1,this.update.length&&e()})),this.update=[]}}else console.warn("Vizzu config not valid given current data.")}),20),t=t=>{this.update.includes(t)||this.update.push(t),e()};this.connect(this.model.properties.config.change,(()=>t("config"))),this.connect(this.model.source.properties.data.change,(()=>t("data"))),this.connect(this.model.source.streaming,(()=>t("data"))),this.connect(this.model.source.patching,(()=>t("data"))),this.connect(this.model.properties.tooltip.change,(()=>{this.vizzu_view.feature("tooltip",this.model.tooltip)})),this.connect(this.model.properties.style.change,(()=>t("style")))}get valid_config(){const e=this.model.source.columns();if("channels"in this.model.config){for(const t of Object.values(this.model.config.channels))if((0,c.isArray)(t)){for(const i of t)if(null!=t&&!e.includes(i))return!1}else if((0,c.isObject)(t)){for(const i of Object.keys(t))for(const s of t[i])if(null!=t&&!e.includes(s))return!1}else if(null!=t&&!e.includes(t))return!1}else for(const t of g)if(t in this.model.config&&!e.includes(this.model.config[t]))return!1;return!0}config(){let e=Object.assign({},this.model.config);return"channels"in e&&(e.channels=Object.assign({},e.channels)),null!=e.preset&&(e=window.Vizzu.presets[e.preset](e)),e}data(){const e=[];for(const t of this.model.columns){let i=[...this.model.source.get_array(t.name)];"datetime"!==t.type&&"date"!=t.type||(t.type="dimension"),"dimension"===t.type&&(i=i.map(String)),e.push(Object.assign(Object.assign({},t),{values:i}))}return{series:e}}render(){super.render(),this.container=(0,a.div)({style:"display: contents;"}),this.shadow_el.append(this.container);const e={config:this.config(),data:this.data(),style:this.model.style};this.vizzu_view=new window.Vizzu(this.container,e),this._animating=!0,this.vizzu_view.initializing.then((e=>{e.on("click",(e=>{this.model.trigger_event(new u(e.data))})),e.feature("tooltip",this.model.tooltip),this._animating=!1}))}remove(){this.vizzu_view&&this.vizzu_view.detach(),super.remove()}}i.VizzuChartView=m,m.__name__="VizzuChartView";class p extends d.HTMLBox{constructor(e){super(e)}}i.VizzuChart=p,o=p,p.__name__="VizzuChart",p.__module__="panel.models.vizzu",o.prototype.default_view=m,o.define((({Any:e,Array:t,Boolean:i,Number:s,Ref:n})=>({animation:[e,{}],config:[e,{}],columns:[t(e),[]],source:[n(l.ColumnDataSource)],duration:[s,500],style:[e,{}],tooltip:[i,!1]})))},
"c51f25e2a7": function _(o,V,l,K,T){K(),T("VTKJSPlot",o("173e6cb054").VTKJSPlot),T("VTKVolumePlot",o("9cb70c6ab6").VTKVolumePlot),T("VTKAxes",o("5a606f3f35").VTKAxes),T("VTKSynchronizedPlot",o("66775d6392").VTKSynchronizedPlot)},
"173e6cb054": function _(e,t,n,i,s){var a;i();const r=e("1de1ccb7ff"),_=e("a76a9b7c23");class o extends r.AbstractVTKView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.data.change,(()=>{this.invalidate_render()}))}render(){super.render(),this._create_orientation_widget(),this._set_axes()}invalidate_render(){this._vtk_renwin=null,super.invalidate_render()}init_vtk_renwin(){this._vtk_renwin=_.vtkns.FullScreenRenderWindow.newInstance({rootContainer:this._vtk_container,container:this._vtk_container})}plot(){if(null==this.model.data)return void this._vtk_renwin.getRenderWindow().render();const e=_.vtkns.DataAccessHelper.get("zip",{zipContent:atob(this.model.data),callback:t=>{const n=_.vtkns.HttpSceneLoader.newInstance({renderer:this._vtk_renwin.getRenderer(),dataAccessHelper:e}),i=window.vtk.macro.debounce((()=>{setTimeout((()=>{null==this._axes&&this.model.axes&&this._set_axes(),this._set_camera_state(),this._get_camera_state(),this._vtk_renwin.getRenderWindow().render()}),100)}),100);n.setUrl("index.json"),n.onReady(i)}})}}n.VTKJSPlotView=o,o.__name__="VTKJSPlotView";class d extends r.AbstractVTKPlot{}n.VTKJSPlot=d,a=d,d.__name__="VTKJSPlot",a.prototype.default_view=o,a.define((({Boolean:e,Nullable:t,String:n})=>({data:[t(n)],enable_keybindings:[e,!1]})))},
"1de1ccb7ff": function _(e,t,i,n,a){var s;n();const r=e("@bokehjs/core/dom"),o=e("@bokehjs/core/util/object"),_=e("@bokehjs/models/mappers/color_mapper"),d=e("@bokehjs/core/kinds"),h=e("c64c1219c8"),c=e("a76a9b7c23"),l=e("c010237f8b"),g=e("5a606f3f35"),p={padding:"0px 2px 0px 2px",maxHeight:"150px",height:"auto",backgroundColor:"rgba(255, 255, 255, 0.4)",borderRadius:"10px",margin:"2px",boxSizing:"border-box",overflow:"hidden",overflowY:"auto",transition:"width 0.1s linear",bottom:"0px",position:"absolute"},v=(0,d.Enum)("LowerLeft","LowerRight","UpperLeft","UpperRight","LowerEdge","RightEdge","LeftEdge","UpperEdge");class m extends h.HTMLBoxView{initialize(){super.initialize(),this._camera_callbacks=[],this._renderable=!0,this._setting_camera=!1,this._rendered=!1}_add_colorbars(){const e=this.shadow_el.querySelector(".vtk_info");if(e&&this.shadow_el.removeChild(e),this.model.color_mappers.length<1)return;const t=document.createElement("div"),i="350px",n="30px";t.classList.add("vtk_info"),(0,c.applyStyle)(t,p),(0,c.applyStyle)(t,{width:i}),this.shadow_el.appendChild(t);const a=[];this.model.color_mappers.forEach((e=>{const i=new l.VTKColorBar(t,e);a.push(i)}));const s=document.createElement("div");(0,c.applyStyle)(s,{textAlign:"center",fontSize:"20px"}),s.innerText="...",t.addEventListener("click",(()=>{t.style.width===n?(t.removeChild(s),(0,c.applyStyle)(t,{height:"auto",width:i}),a.forEach((e=>t.appendChild(e.canvas)))):(a.forEach((e=>t.removeChild(e.canvas))),(0,c.applyStyle)(t,{height:n,width:n}),t.appendChild(s))})),t.click()}_init_annotations_container(){this._annotations_container||(this._annotations_container=document.createElement("div"),this._annotations_container.style.position="absolute",this._annotations_container.style.width="100%",this._annotations_container.style.height="100%",this._annotations_container.style.top="0",this._annotations_container.style.left="0",this._annotations_container.style.pointerEvents="none")}_clean_annotations(){if(this._annotations_container)for(;this._annotations_container.firstElementChild;)this._annotations_container.firstElementChild.remove()}_add_annotations(){this._clean_annotations();const{annotations:e}=this.model;if(null!=e)for(let t of e){const{viewport:e,color:i,fontSize:n,fontFamily:a}=t;v.values.forEach((s=>{const r=t[s];if(r){const t=document.createElement("div");t.textContent=r;const{style:o}=t;o.position="absolute",o.color=`rgb(${i.map((e=>255*e)).join(",")})`,o.fontSize=`${n}px`,o.padding="5px",o.fontFamily=a,o.width="fit-content","UpperLeft"==s&&(o.top=100*(1-e[3])+"%",o.left=100*e[0]+"%"),"UpperRight"==s&&(o.top=100*(1-e[3])+"%",o.right=100*(1-e[2])+"%"),"LowerLeft"==s&&(o.bottom=100*e[1]+"%",o.left=100*e[0]+"%"),"LowerRight"==s&&(o.bottom=100*e[1]+"%",o.right=100*(1-e[2])+"%"),"UpperEdge"==s&&(o.top=100*(1-e[3])+"%",o.left=100*(e[0]+(e[2]-e[0])/2)+"%",o.transform="translateX(-50%)"),"LowerEdge"==s&&(o.bottom=100*e[1]+"%",o.left=100*(e[0]+(e[2]-e[0])/2)+"%",o.transform="translateX(-50%)"),"LeftEdge"==s&&(o.left=100*e[0]+"%",o.top=100*(1-e[3]+(e[3]-e[1])/2)+"%",o.transform="translateY(-50%)"),"RightEdge"==s&&(o.right=100*(1-e[2])+"%",o.top=100*(1-e[3]+(e[3]-e[1])/2)+"%",o.transform="translateY(-50%)"),this._annotations_container.appendChild(t)}}))}}connect_signals(){super.connect_signals(),this.on_change(this.model.properties.orientation_widget,(()=>{this._orientation_widget_visibility(this.model.orientation_widget)})),this.on_change(this.model.properties.camera,(()=>this._set_camera_state())),this.on_change(this.model.properties.axes,(()=>{this._delete_axes(),this.model.axes&&this._set_axes(),this._vtk_render()})),this.on_change(this.model.properties.color_mappers,(()=>this._add_colorbars())),this.on_change(this.model.properties.annotations,(()=>this._add_annotations()))}render(){if(super.render(),this._rendered=!1,this._vtk_renwin&&this._vtk_container)return this.shadow_el.appendChild(this._vtk_container),void this.shadow_el.appendChild(this._annotations_container);this._orientationWidget=null,this._axes=null,this._vtk_container=(0,r.div)(),this.init_vtk_renwin(),this._init_annotations_container(),(0,h.set_size)(this._vtk_container,this.model),this.shadow_el.appendChild(this._vtk_container),this._vtk_renwin.getInteractor().onEndAnimation((()=>this._get_camera_state())),this._remove_default_key_binding(),this._bind_key_events(),this.plot(),this.model.renderer_el=this._vtk_renwin,this.shadow_el.appendChild(this._annotations_container)}after_layout(){super.after_layout(),this._renderable&&this._vtk_renwin.resize(),this._vtk_render(),this._rendered||(this._add_colorbars(),this._add_annotations(),this._rendered=!0)}invalidate_render(){this._unsubscribe_camera_cb(),super.invalidate_render()}remove(){this._unsubscribe_camera_cb(),window.removeEventListener("resize",this._vtk_renwin.resize),null!=this._orientationWidget&&this._orientationWidget.delete(),this._vtk_renwin.getRenderWindow().getInteractor().delete(),this._vtk_renwin.delete(),super.remove()}get _vtk_camera_state(){const e=this._vtk_renwin.getRenderer().getActiveCamera();let t;return e&&(t=(0,o.clone)(e.get()),delete t.cameraLightTransform,delete t.classHierarchy,delete t.vtkObject,delete t.vtkCamera,delete t.viewPlaneNormal,delete t.flattenedDepIds,delete t.managedInstanceId,delete t.directionOfProjection),t}get _axes_canvas(){let e=this._vtk_container.querySelector(".axes-canvas");return e||(e=(0,r.canvas)({style:{position:"absolute",top:"0",left:"0",width:"100%",height:"100%"}}),e.classList.add("axes-canvas"),this._vtk_container.appendChild(e),this._vtk_renwin.setResizeCallback((()=>{if(this._axes_canvas){const e=this._vtk_container.getBoundingClientRect(),t=Math.floor(e.width*window.devicePixelRatio),i=Math.floor(e.height*window.devicePixelRatio);this._axes_canvas.setAttribute("width",t.toFixed()),this._axes_canvas.setAttribute("height",i.toFixed())}}))),e}_bind_key_events(){this.el.addEventListener("mouseenter",(()=>{const e=this._vtk_renwin.getInteractor();this.model.enable_keybindings&&(document.querySelector("body").addEventListener("keypress",e.handleKeyPress),document.querySelector("body").addEventListener("keydown",e.handleKeyDown),document.querySelector("body").addEventListener("keyup",e.handleKeyUp))})),this.el.addEventListener("mouseleave",(()=>{const e=this._vtk_renwin.getInteractor();document.querySelector("body").removeEventListener("keypress",e.handleKeyPress),document.querySelector("body").removeEventListener("keydown",e.handleKeyDown),document.querySelector("body").removeEventListener("keyup",e.handleKeyUp)}))}_create_orientation_widget(){const e=c.vtkns.AxesActor.newInstance();this._orientationWidget=c.vtkns.OrientationMarkerWidget.newInstance({actor:e,interactor:this._vtk_renwin.getInteractor()}),this._orientationWidget.setEnabled(!0),this._orientationWidget.setViewportCorner(c.vtkns.OrientationMarkerWidget.Corners.BOTTOM_RIGHT),this._orientationWidget.setViewportSize(.15),this._orientationWidget.setMinPixelSize(75),this._orientationWidget.setMaxPixelSize(300),this.model.interactive_orientation_widget&&this._make_orientation_widget_interactive(),this._orientation_widget_visibility(this.model.orientation_widget)}_make_orientation_widget_interactive(){this._widgetManager=c.vtkns.WidgetManager.newInstance(),this._widgetManager.setRenderer(this._orientationWidget.getRenderer());const e=this._orientationWidget.getActor(),t=c.vtkns.InteractiveOrientationWidget.newInstance();t.placeWidget(e.getBounds()),t.setBounds(e.getBounds()),t.setPlaceFactor(1);this._widgetManager.addWidget(t).onOrientationChange((({direction:e})=>{const t=this._vtk_renwin.getRenderer().getActiveCamera(),i=t.getFocalPoint(),n=t.getPosition(),a=t.getViewUp(),s=Math.sqrt(Math.pow(n[0]-i[0],2)+Math.pow(n[1]-i[1],2)+Math.pow(n[2]-i[2],2));t.setPosition(i[0]+e[0]*s,i[1]+e[1]*s,i[2]+e[2]*s),e[0]&&t.setViewUp((0,c.majorAxis)(a,1,2)),e[1]&&t.setViewUp((0,c.majorAxis)(a,0,2)),e[2]&&t.setViewUp((0,c.majorAxis)(a,0,1)),this._vtk_renwin.getRenderer().resetCameraClippingRange(),this._vtk_render(),this._get_camera_state()}))}_delete_axes(){if(this._axes){Object.keys(this._axes).forEach((e=>this._vtk_renwin.getRenderer().removeActor(this._axes[e]))),this._axes=null;const e=this._axes_canvas.getContext("2d");e&&e.clearRect(0,0,this._axes_canvas.clientWidth*window.devicePixelRatio,this._axes_canvas.clientHeight*window.devicePixelRatio)}}_get_camera_state(){this._setting_camera||(this._setting_camera=!0,this.model.camera=this._vtk_camera_state,this._setting_camera=!1)}_orientation_widget_visibility(e){this._orientationWidget.setEnabled(e),null!=this._widgetManager&&(e?this._widgetManager.enablePicking():this._widgetManager.disablePicking()),this._vtk_render()}_remove_default_key_binding(){const e=this._vtk_renwin.getInteractor();document.querySelector("body").removeEventListener("keypress",e.handleKeyPress),document.querySelector("body").removeEventListener("keydown",e.handleKeyDown),document.querySelector("body").removeEventListener("keyup",e.handleKeyUp)}_set_axes(){if(this.model.axes&&this._vtk_renwin.getRenderer()){const{psActor:e,axesActor:t,gridActor:i}=this.model.axes.create_axes(this._axes_canvas);this._axes={psActor:e,axesActor:t,gridActor:i},e&&this._vtk_renwin.getRenderer().addActor(e),t&&this._vtk_renwin.getRenderer().addActor(t),i&&this._vtk_renwin.getRenderer().addActor(i)}}_set_camera_state(){this._setting_camera||void 0===this._vtk_renwin.getRenderer()||(this._setting_camera=!0,this.model.camera&&JSON.stringify(this.model.camera)!=JSON.stringify(this._vtk_camera_state)&&this._vtk_renwin.getRenderer().getActiveCamera().set(this.model.camera),this._vtk_renwin.getRenderer().resetCameraClippingRange(),this._setting_camera=!1)}_unsubscribe_camera_cb(){this._camera_callbacks.splice(0,this._camera_callbacks.length).map((e=>e.unsubscribe()))}_vtk_render(){this._renderable&&(this._orientationWidget&&this._orientationWidget.updateMarkerOrientation(),this._vtk_renwin.getRenderWindow().render())}}i.AbstractVTKView=m,m.__name__="AbstractVTKView";class w extends h.HTMLBox{constructor(e){(0,c.setup_vtkns)(),super(e)}getActors(){return this.renderer_el.getRenderer().getActors()}}i.AbstractVTKPlot=w,s=w,w.__name__="AbstractVTKPlot",w.__module__="panel.models.vtk",s.define((({Any:e,Ref:t,Array:i,Boolean:n,Nullable:a})=>({axes:[a(t(g.VTKAxes)),null],camera:[e,{}],color_mappers:[i(t(_.ColorMapper)),[]],orientation_widget:[n,!1],interactive_orientation_widget:[n,!1],annotations:[a(i(e)),null]}))),s.override({height:300,width:300})},
"a76a9b7c23": function _(e,n,t,r,o){r();const a=e("@bokehjs/core/util/array"),i=e("@bokehjs/core/kinds");function s(){if(null!=t.vtkns.Actor)return;const e=window.vtk;t.vtkns.Actor=e.Rendering.Core.vtkActor,t.vtkns.AxesActor=e.Rendering.Core.vtkAxesActor,t.vtkns.Base64=e.Common.Core.vtkBase64,t.vtkns.BoundingBox=e.Common.DataModel.vtkBoundingBox,t.vtkns.Camera=e.Rendering.Core.vtkCamera,t.vtkns.ColorTransferFunction=e.Rendering.Core.vtkColorTransferFunction,t.vtkns.CubeSource=e.Filters.Sources.vtkCubeSource,t.vtkns.DataAccessHelper=e.IO.Core.DataAccessHelper,t.vtkns.DataArray=e.Common.Core.vtkDataArray,t.vtkns.Follower=e.Rendering.Core.vtkFollower,t.vtkns.FullScreenRenderWindow=e.Rendering.Misc.vtkFullScreenRenderWindow,t.vtkns.Glyph3DMapper=e.Rendering.Core.vtkGlyph3DMapper,t.vtkns.HttpSceneLoader=e.IO.Core.vtkHttpSceneLoader,t.vtkns.ImageData=e.Common.DataModel.vtkImageData,t.vtkns.ImageMapper=e.Rendering.Core.vtkImageMapper,t.vtkns.ImageProperty=e.Rendering.Core.vtkImageProperty,t.vtkns.ImageSlice=e.Rendering.Core.vtkImageSlice,t.vtkns.InteractiveOrientationWidget=e.Widgets.Widgets3D.vtkInteractiveOrientationWidget,t.vtkns.InteractorStyleTrackballCamera=e.Interaction.Style.vtkInteractorStyleTrackballCamera,t.vtkns.Light=e.Rendering.Core.vtkLight,t.vtkns.LineSource=e.Filters.Sources.vtkLineSource,t.vtkns.LookupTable=e.Common.Core.vtkLookupTable,t.vtkns.macro=e.macro,t.vtkns.Mapper=e.Rendering.Core.vtkMapper,t.vtkns.OpenGLRenderWindow=e.Rendering.OpenGL.vtkRenderWindow,t.vtkns.OrientationMarkerWidget=e.Interaction.Widgets.vtkOrientationMarkerWidget,t.vtkns.OutlineFilter=e.Filters.General.vtkOutlineFilter,t.vtkns.PiecewiseFunction=e.Common.DataModel.vtkPiecewiseFunction,t.vtkns.PixelSpaceCallbackMapper=e.Rendering.Core.vtkPixelSpaceCallbackMapper,t.vtkns.PlaneSource=e.Filters.Sources.vtkPlaneSource,t.vtkns.PointSource=e.Filters.Sources.vtkPointSource,t.vtkns.PolyData=e.Common.DataModel.vtkPolyData,t.vtkns.Property=e.Rendering.Core.vtkProperty,t.vtkns.Renderer=e.Rendering.Core.vtkRenderer,t.vtkns.RenderWindow=e.Rendering.Core.vtkRenderWindow,t.vtkns.RenderWindowInteractor=e.Rendering.Core.vtkRenderWindowInteractor,t.vtkns.SphereMapper=e.Rendering.Core.vtkSphereMapper,t.vtkns.SynchronizableRenderWindow=e.Rendering.Misc.vtkSynchronizableRenderWindow,t.vtkns.Texture=e.Rendering.Core.vtkTexture,t.vtkns.Volume=e.Rendering.Core.vtkVolume,t.vtkns.VolumeController=e.Interaction.UI.vtkVolumeController,t.vtkns.VolumeMapper=e.Rendering.Core.vtkVolumeMapper,t.vtkns.VolumeProperty=e.Rendering.Core.vtkVolumeProperty,t.vtkns.WidgetManager=e.Widgets.Core.vtkWidgetManager;const{vtkObjectManager:n}=t.vtkns.SynchronizableRenderWindow;n.setTypeMapping("vtkVolumeMapper",t.vtkns.VolumeMapper.newInstance,n.oneTimeGenericUpdater),n.setTypeMapping("vtkSmartVolumeMapper",t.vtkns.VolumeMapper.newInstance,n.oneTimeGenericUpdater),n.setTypeMapping("vtkFollower",t.vtkns.Follower.newInstance,n.genericUpdater),n.setTypeMapping("vtkOpenGLGlyph3DMapper",t.vtkns.Glyph3DMapper.newInstance,n.genericUpdater)}function k(e){const n=Math.min(Math.max(Math.round(e),0),255).toString(16);return 2==n.length?n:"0"+n}function c(e,n,t){return"#"+k(e)+k(n)+k(t)}function l(e){for(var n=new ArrayBuffer(e.length),t=new Uint8Array(n),r=0,o=e.length;r<o;r++)t[r]=e.charCodeAt(r);return n}t.ARRAY_TYPES={uint8:Uint8Array,int8:Int8Array,uint16:Uint16Array,int16:Int16Array,uint32:Uint32Array,int32:Int32Array,float32:Float32Array,float64:Float64Array},t.vtkns={},t.setup_vtkns=s,window.vtk&&s(),t.Interpolation=(0,i.Enum)("fast_linear","linear","nearest"),t.applyStyle=function(e,n){Object.keys(n).forEach((t=>{e.style[t]=n[t]}))},t.hexToRGB=function(e){return[parseInt(e.slice(1,3),16)/255,parseInt(e.slice(3,5),16)/255,parseInt(e.slice(5,7),16)/255]},t.rgbToHex=c,t.vtkLutToMapper=function(e){const{scale:n,nodes:r}=e.get("scale","nodes");if(n!==t.vtkns.ColorTransferFunction.Scale.LINEAR)throw"Error transfer function scale not handle";const o=r.map((e=>e.x)),i=Math.min(...o),s=Math.max(...o),k=(0,a.linspace)(i,s,255),l=[0,0,0];return{low:i,high:s,palette:k.map((n=>(e.getColor(n,l),c(255*l[0],255*l[1],255*l[2]))))}},t.data2VTKImageData=function(e){const n=t.vtkns.ImageData.newInstance({spacing:e.spacing});n.setDimensions(e.dims),n.setOrigin(null!=e.origin?e.origin:e.dims.map((e=>e/2)));const r=t.vtkns.DataArray.newInstance({name:"scalars",numberOfComponents:1,values:new t.ARRAY_TYPES[e.dtype](l(atob(e.buffer)))});return n.getPointData().setScalars(r),n},t.majorAxis=function(e,n,t){const r=[0,0,0],o=Math.abs(e[n])>Math.abs(e[t])?n:t,a=e[o]>0?1:-1;return r[o]=a,r},t.cartesian_product=function(...e){return e.reduce(((e,n)=>[...e].flatMap((e=>n.map((n=>[].concat(e,n)))))))}},
"c010237f8b": function _(t,i,e,s,h){s();const a=t("@bokehjs/models/mappers"),n=t("@bokehjs/core/util/array");class c{constructor(t,i,e={}){this.parent=t,this.mapper=i,this.options=e,e.ticksNum||(e.ticksNum=5),e.fontFamily||(e.fontFamily="Arial"),e.fontSize||(e.fontSize="12px"),e.ticksSize||(e.ticksSize=2),this.canvas=document.createElement("canvas"),this.canvas.style.width="100%",this.parent.appendChild(this.canvas),this.ctx=this.canvas.getContext("2d"),this.ctx.font=`${this.options.fontSize} ${this.options.fontFamily}`,this.ctx.lineWidth=e.ticksSize,e.height||(e.height=4*(this.font_height+1)+"px"),this.canvas.style.height=e.height,this.draw_colorbar()}get values(){const{min:t,max:i}=this.mapper.metrics;return(0,n.linspace)(t,i,this.options.ticksNum)}get ticks(){return this.values.map((t=>t.toExponential(3)))}get title(){return this.mapper.name?this.mapper.name:"scalars"}get font_height(){let t=0;return this.values.forEach((i=>{const{actualBoundingBoxAscent:e,actualBoundingBoxDescent:s}=this.ctx.measureText(`${i}`),h=e+s;t<h&&(t=h)})),t}draw_colorbar(){this.canvas.width=this.canvas.clientWidth,this.canvas.height=this.canvas.clientHeight;const{palette:t}=this.mapper;this.ctx.font=`${this.options.fontSize} ${this.options.fontFamily}`;const i=this.font_height;this.ctx.save();const e=document.createElement("canvas"),s=t.length;e.width=s,e.height=1;const h=e.getContext("2d"),c=h.getImageData(0,0,s,1),o=new a.LinearColorMapper({palette:t}).rgba_mapper.v_compute((0,n.range)(0,t.length));c.data.set(o),h.putImageData(c,0,0),this.ctx.drawImage(e,0,2*(this.font_height+1)+1,this.canvas.width,this.canvas.height),this.ctx.restore(),this.ctx.save(),this.ctx.textAlign="center",this.ctx.fillText(this.title,this.canvas.width/2,i+1),this.ctx.restore(),this.ctx.save();const r=(0,n.linspace)(0,this.canvas.width,5);r.forEach(((t,e)=>{let s=t;0==e?(s=t+Math.ceil(this.ctx.lineWidth/2),this.ctx.textAlign="left"):e==r.length-1?(s=t-Math.ceil(this.ctx.lineWidth/2),this.ctx.textAlign="right"):this.ctx.textAlign="center",this.ctx.moveTo(s,2*(i+1)),this.ctx.lineTo(s,2*(i+1)+5),this.ctx.stroke(),this.ctx.fillText(`${this.ticks[e]}`,t,2*(i+1))})),this.ctx.restore()}}e.VTKColorBar=c,c.__name__="VTKColorBar"},
"5a606f3f35": function _(t,i,s,e,n){var a;e();const r=t("@bokehjs/model"),c=t("2f3fd5db07"),l=t("a76a9b7c23");class h extends r.Model{constructor(t){super(t)}get xticks(){return this.xticker?this.xticker.ticks:[]}get yticks(){return this.yticker?this.yticker.ticks:[]}get zticks(){return this.zticker?this.zticker.ticks:[]}get xlabels(){var t;return(null===(t=this.xticker)||void 0===t?void 0:t.labels)?this.xticker.labels:this.xticks.map((t=>t.toFixed(this.digits)))}get ylabels(){var t;return(null===(t=this.yticker)||void 0===t?void 0:t.labels)?this.yticker.labels:this.yticks.map((t=>t.toFixed(this.digits)))}get zlabels(){var t;return(null===(t=this.zticker)||void 0===t?void 0:t.labels)?this.zticker.labels:this.zticks.map((t=>t.toFixed(this.digits)))}_make_grid_lines(t,i,s){const e=[];for(let n=0;n<t-1;n++)for(let t=0;t<i-1;t++){const a=n*i+t+s,r=[5,a,n*i+t+1+s,(n+1)*i+t+1+s,(n+1)*i+t+s,a];e.push(r)}return e}_create_grid_axes(){const t=[];t.push((0,l.cartesian_product)(this.xticks,this.yticks,[this.origin[2]])),t.push((0,l.cartesian_product)([this.origin[0]],this.yticks,this.zticks)),t.push((0,l.cartesian_product)(this.xticks,[this.origin[1]],this.zticks));const i=[];let s=0;i.push(this._make_grid_lines(this.xticks.length,this.yticks.length,s)),s+=this.xticks.length*this.yticks.length,i.push(this._make_grid_lines(this.yticks.length,this.zticks.length,s)),s+=this.yticks.length*this.zticks.length,i.push(this._make_grid_lines(this.xticks.length,this.zticks.length,s));const e=window.vtk({vtkClass:"vtkPolyData",points:{vtkClass:"vtkPoints",dataType:"Float32Array",numberOfComponents:3,values:t.flat(2)},lines:{vtkClass:"vtkCellArray",dataType:"Uint32Array",values:i.flat(2)}}),n=l.vtkns.Mapper.newInstance(),a=l.vtkns.Actor.newInstance();return n.setInputData(e),a.setMapper(n),a.getProperty().setOpacity(this.grid_opacity),a.setVisibility(this.show_grid),a}create_axes(t){if(null==this.origin)return{psActor:null,axesActor:null,gridActor:null};const i=[this.xticks,this.yticks,this.zticks].map(((t,i)=>{let s=null;switch(i){case 0:s=(0,l.cartesian_product)(t,[this.origin[1]],[this.origin[2]]);break;case 1:s=(0,l.cartesian_product)([this.origin[0]],t,[this.origin[2]]);break;case 2:s=(0,l.cartesian_product)([this.origin[0]],[this.origin[1]],t)}return s})).flat(2),s=window.vtk({vtkClass:"vtkPolyData",points:{vtkClass:"vtkPoints",dataType:"Float32Array",numberOfComponents:3,values:i},lines:{vtkClass:"vtkCellArray",dataType:"Uint32Array",values:[2,0,this.xticks.length-1,2,this.xticks.length,this.xticks.length+this.yticks.length-1,2,this.xticks.length+this.yticks.length,this.xticks.length+this.yticks.length+this.zticks.length-1]}}),e=l.vtkns.PixelSpaceCallbackMapper.newInstance();e.setInputData(s),e.setUseZValues(!0),e.setCallback(((i,s,n)=>{const a=t.getContext("2d");if(a){const r={height:t.clientHeight*window.devicePixelRatio,width:t.clientWidth*window.devicePixelRatio},l=e.getInputData().getPoints(),h=s.getViewMatrix();c.mat4.transpose(h,h);const o=s.getProjectionMatrix(n,-1,1);c.mat4.transpose(o,o),a.clearRect(0,0,r.width,r.height),i.forEach(((t,i)=>{const s=l.getPoint(i),e=c.vec3.fromValues(s[0],s[1],s[2]);if(c.vec3.transformMat4(e,e,h),e[2]+=.05,c.vec3.transformMat4(e,e,o),e[2]-.001<t[3]){let s;a.font="30px serif",a.textAlign="center",a.textBaseline="alphabetic",a.fillText(".",t[0],r.height-t[1]+2),a.font=this.fontsize*window.devicePixelRatio+"px serif",a.textAlign="right",a.textBaseline="top",s=i<this.xticks.length?this.xlabels[i]:i>=this.xticks.length&&i<this.xticks.length+this.yticks.length?this.ylabels[i-this.xticks.length]:this.zlabels[i-(this.xticks.length+this.yticks.length)],a.fillText(`${s}`,t[0],r.height-t[1])}}))}}));const n=l.vtkns.Actor.newInstance();n.setMapper(e);const a=l.vtkns.Mapper.newInstance();a.setInputData(s);const r=l.vtkns.Actor.newInstance();r.setMapper(a),r.getProperty().setOpacity(this.axes_opacity);return{psActor:n,axesActor:r,gridActor:this._create_grid_axes()}}}s.VTKAxes=h,a=h,h.__name__="VTKAxes",h.__module__="panel.models.vtk",a.define((({Any:t,Array:i,Boolean:s,Number:e})=>({origin:[i(e),[0,0,0]],xticker:[t,null],yticker:[t,null],zticker:[t,null],digits:[e,1],show_grid:[s,!0],grid_opacity:[e,.1],axes_opacity:[e,1],fontsize:[e,12]})))},
"2f3fd5db07": function _(t,c,a,o,r){o();const _=t("tslib"),m=_.__importStar(t("68ca94c15c"));a.glMatrix=m;const i=_.__importStar(t("7c0b8e6048"));a.mat2=i;const n=_.__importStar(t("dc03f0a621"));a.mat2d=n;const s=_.__importStar(t("0285c50a7e"));a.mat3=s;const p=_.__importStar(t("a427635f32"));a.mat4=p;const S=_.__importStar(t("eb06fc032a"));a.quat=S;const e=_.__importStar(t("277615c682"));a.quat2=e;const f=_.__importStar(t("c56d9ff837"));a.vec2=f;const b=_.__importStar(t("2c5eb22089"));a.vec3=b;const d=_.__importStar(t("c1aa33d719"));a.vec4=d},
"68ca94c15c": function _(t,a,r,n,o){n(),r.EPSILON=1e-6,r.ARRAY_TYPE="undefined"!=typeof Float32Array?Float32Array:Array,r.RANDOM=Math.random,r.setMatrixArrayType=function(t){r.ARRAY_TYPE=t};var h=Math.PI/180;r.toRadian=function(t){return t*h},r.equals=function(t,a){return Math.abs(t-a)<=r.EPSILON*Math.max(1,Math.abs(t),Math.abs(a))},Math.hypot||(Math.hypot=function(){for(var t=0,a=arguments.length;a--;)t+=arguments[a]*arguments[a];return Math.sqrt(t)})},
"7c0b8e6048": function _(t,n,r,a,u){a();const e=t("tslib").__importStar(t("68ca94c15c"));function o(t,n,r){var a=n[0],u=n[1],e=n[2],o=n[3],c=r[0],i=r[1],f=r[2],s=r[3];return t[0]=a*c+e*i,t[1]=u*c+o*i,t[2]=a*f+e*s,t[3]=u*f+o*s,t}function c(t,n,r){return t[0]=n[0]-r[0],t[1]=n[1]-r[1],t[2]=n[2]-r[2],t[3]=n[3]-r[3],t}r.create=function(){var t=new e.ARRAY_TYPE(4);return e.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0),t[0]=1,t[3]=1,t},r.clone=function(t){var n=new e.ARRAY_TYPE(4);return n[0]=t[0],n[1]=t[1],n[2]=t[2],n[3]=t[3],n},r.copy=function(t,n){return t[0]=n[0],t[1]=n[1],t[2]=n[2],t[3]=n[3],t},r.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t},r.fromValues=function(t,n,r,a){var u=new e.ARRAY_TYPE(4);return u[0]=t,u[1]=n,u[2]=r,u[3]=a,u},r.set=function(t,n,r,a,u){return t[0]=n,t[1]=r,t[2]=a,t[3]=u,t},r.transpose=function(t,n){if(t===n){var r=n[1];t[1]=n[2],t[2]=r}else t[0]=n[0],t[1]=n[2],t[2]=n[1],t[3]=n[3];return t},r.invert=function(t,n){var r=n[0],a=n[1],u=n[2],e=n[3],o=r*e-u*a;return o?(o=1/o,t[0]=e*o,t[1]=-a*o,t[2]=-u*o,t[3]=r*o,t):null},r.adjoint=function(t,n){var r=n[0];return t[0]=n[3],t[1]=-n[1],t[2]=-n[2],t[3]=r,t},r.determinant=function(t){return t[0]*t[3]-t[2]*t[1]},r.multiply=o,r.rotate=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=n[3],c=Math.sin(r),i=Math.cos(r);return t[0]=a*i+e*c,t[1]=u*i+o*c,t[2]=a*-c+e*i,t[3]=u*-c+o*i,t},r.scale=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=n[3],c=r[0],i=r[1];return t[0]=a*c,t[1]=u*c,t[2]=e*i,t[3]=o*i,t},r.fromRotation=function(t,n){var r=Math.sin(n),a=Math.cos(n);return t[0]=a,t[1]=r,t[2]=-r,t[3]=a,t},r.fromScaling=function(t,n){return t[0]=n[0],t[1]=0,t[2]=0,t[3]=n[1],t},r.str=function(t){return"mat2("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},r.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3])},r.LDU=function(t,n,r,a){return t[2]=a[2]/a[0],r[0]=a[0],r[1]=a[1],r[3]=a[3]-t[2]*r[1],[t,n,r]},r.add=function(t,n,r){return t[0]=n[0]+r[0],t[1]=n[1]+r[1],t[2]=n[2]+r[2],t[3]=n[3]+r[3],t},r.subtract=c,r.exactEquals=function(t,n){return t[0]===n[0]&&t[1]===n[1]&&t[2]===n[2]&&t[3]===n[3]},r.equals=function(t,n){var r=t[0],a=t[1],u=t[2],o=t[3],c=n[0],i=n[1],f=n[2],s=n[3];return Math.abs(r-c)<=e.EPSILON*Math.max(1,Math.abs(r),Math.abs(c))&&Math.abs(a-i)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(i))&&Math.abs(u-f)<=e.EPSILON*Math.max(1,Math.abs(u),Math.abs(f))&&Math.abs(o-s)<=e.EPSILON*Math.max(1,Math.abs(o),Math.abs(s))},r.multiplyScalar=function(t,n,r){return t[0]=n[0]*r,t[1]=n[1]*r,t[2]=n[2]*r,t[3]=n[3]*r,t},r.multiplyScalarAndAdd=function(t,n,r,a){return t[0]=n[0]+r[0]*a,t[1]=n[1]+r[1]*a,t[2]=n[2]+r[2]*a,t[3]=n[3]+r[3]*a,t},r.mul=o,r.sub=c},
"dc03f0a621": function _(t,n,a,r,u){r();const o=t("tslib").__importStar(t("68ca94c15c"));function e(t,n,a){var r=n[0],u=n[1],o=n[2],e=n[3],c=n[4],i=n[5],s=a[0],h=a[1],f=a[2],M=a[3],b=a[4],l=a[5];return t[0]=r*s+o*h,t[1]=u*s+e*h,t[2]=r*f+o*M,t[3]=u*f+e*M,t[4]=r*b+o*l+c,t[5]=u*b+e*l+i,t}function c(t,n,a){return t[0]=n[0]-a[0],t[1]=n[1]-a[1],t[2]=n[2]-a[2],t[3]=n[3]-a[3],t[4]=n[4]-a[4],t[5]=n[5]-a[5],t}a.create=function(){var t=new o.ARRAY_TYPE(6);return o.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[4]=0,t[5]=0),t[0]=1,t[3]=1,t},a.clone=function(t){var n=new o.ARRAY_TYPE(6);return n[0]=t[0],n[1]=t[1],n[2]=t[2],n[3]=t[3],n[4]=t[4],n[5]=t[5],n},a.copy=function(t,n){return t[0]=n[0],t[1]=n[1],t[2]=n[2],t[3]=n[3],t[4]=n[4],t[5]=n[5],t},a.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t[4]=0,t[5]=0,t},a.fromValues=function(t,n,a,r,u,e){var c=new o.ARRAY_TYPE(6);return c[0]=t,c[1]=n,c[2]=a,c[3]=r,c[4]=u,c[5]=e,c},a.set=function(t,n,a,r,u,o,e){return t[0]=n,t[1]=a,t[2]=r,t[3]=u,t[4]=o,t[5]=e,t},a.invert=function(t,n){var a=n[0],r=n[1],u=n[2],o=n[3],e=n[4],c=n[5],i=a*o-r*u;return i?(i=1/i,t[0]=o*i,t[1]=-r*i,t[2]=-u*i,t[3]=a*i,t[4]=(u*c-o*e)*i,t[5]=(r*e-a*c)*i,t):null},a.determinant=function(t){return t[0]*t[3]-t[1]*t[2]},a.multiply=e,a.rotate=function(t,n,a){var r=n[0],u=n[1],o=n[2],e=n[3],c=n[4],i=n[5],s=Math.sin(a),h=Math.cos(a);return t[0]=r*h+o*s,t[1]=u*h+e*s,t[2]=r*-s+o*h,t[3]=u*-s+e*h,t[4]=c,t[5]=i,t},a.scale=function(t,n,a){var r=n[0],u=n[1],o=n[2],e=n[3],c=n[4],i=n[5],s=a[0],h=a[1];return t[0]=r*s,t[1]=u*s,t[2]=o*h,t[3]=e*h,t[4]=c,t[5]=i,t},a.translate=function(t,n,a){var r=n[0],u=n[1],o=n[2],e=n[3],c=n[4],i=n[5],s=a[0],h=a[1];return t[0]=r,t[1]=u,t[2]=o,t[3]=e,t[4]=r*s+o*h+c,t[5]=u*s+e*h+i,t},a.fromRotation=function(t,n){var a=Math.sin(n),r=Math.cos(n);return t[0]=r,t[1]=a,t[2]=-a,t[3]=r,t[4]=0,t[5]=0,t},a.fromScaling=function(t,n){return t[0]=n[0],t[1]=0,t[2]=0,t[3]=n[1],t[4]=0,t[5]=0,t},a.fromTranslation=function(t,n){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t[4]=n[0],t[5]=n[1],t},a.str=function(t){return"mat2d("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+")"},a.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],1)},a.add=function(t,n,a){return t[0]=n[0]+a[0],t[1]=n[1]+a[1],t[2]=n[2]+a[2],t[3]=n[3]+a[3],t[4]=n[4]+a[4],t[5]=n[5]+a[5],t},a.subtract=c,a.multiplyScalar=function(t,n,a){return t[0]=n[0]*a,t[1]=n[1]*a,t[2]=n[2]*a,t[3]=n[3]*a,t[4]=n[4]*a,t[5]=n[5]*a,t},a.multiplyScalarAndAdd=function(t,n,a,r){return t[0]=n[0]+a[0]*r,t[1]=n[1]+a[1]*r,t[2]=n[2]+a[2]*r,t[3]=n[3]+a[3]*r,t[4]=n[4]+a[4]*r,t[5]=n[5]+a[5]*r,t},a.exactEquals=function(t,n){return t[0]===n[0]&&t[1]===n[1]&&t[2]===n[2]&&t[3]===n[3]&&t[4]===n[4]&&t[5]===n[5]},a.equals=function(t,n){var a=t[0],r=t[1],u=t[2],e=t[3],c=t[4],i=t[5],s=n[0],h=n[1],f=n[2],M=n[3],b=n[4],l=n[5];return Math.abs(a-s)<=o.EPSILON*Math.max(1,Math.abs(a),Math.abs(s))&&Math.abs(r-h)<=o.EPSILON*Math.max(1,Math.abs(r),Math.abs(h))&&Math.abs(u-f)<=o.EPSILON*Math.max(1,Math.abs(u),Math.abs(f))&&Math.abs(e-M)<=o.EPSILON*Math.max(1,Math.abs(e),Math.abs(M))&&Math.abs(c-b)<=o.EPSILON*Math.max(1,Math.abs(c),Math.abs(b))&&Math.abs(i-l)<=o.EPSILON*Math.max(1,Math.abs(i),Math.abs(l))},a.mul=e,a.sub=c},
"0285c50a7e": function _(t,a,n,r,u){r();const o=t("tslib").__importStar(t("68ca94c15c"));function e(t,a,n){var r=a[0],u=a[1],o=a[2],e=a[3],i=a[4],c=a[5],s=a[6],M=a[7],h=a[8],f=n[0],b=n[1],l=n[2],m=n[3],v=n[4],E=n[5],P=n[6],S=n[7],A=n[8];return t[0]=f*r+b*e+l*s,t[1]=f*u+b*i+l*M,t[2]=f*o+b*c+l*h,t[3]=m*r+v*e+E*s,t[4]=m*u+v*i+E*M,t[5]=m*o+v*c+E*h,t[6]=P*r+S*e+A*s,t[7]=P*u+S*i+A*M,t[8]=P*o+S*c+A*h,t}function i(t,a,n){return t[0]=a[0]-n[0],t[1]=a[1]-n[1],t[2]=a[2]-n[2],t[3]=a[3]-n[3],t[4]=a[4]-n[4],t[5]=a[5]-n[5],t[6]=a[6]-n[6],t[7]=a[7]-n[7],t[8]=a[8]-n[8],t}n.create=function(){var t=new o.ARRAY_TYPE(9);return o.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t},n.fromMat4=function(t,a){return t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[4],t[4]=a[5],t[5]=a[6],t[6]=a[8],t[7]=a[9],t[8]=a[10],t},n.clone=function(t){var a=new o.ARRAY_TYPE(9);return a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=t[3],a[4]=t[4],a[5]=t[5],a[6]=t[6],a[7]=t[7],a[8]=t[8],a},n.copy=function(t,a){return t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[3],t[4]=a[4],t[5]=a[5],t[6]=a[6],t[7]=a[7],t[8]=a[8],t},n.fromValues=function(t,a,n,r,u,e,i,c,s){var M=new o.ARRAY_TYPE(9);return M[0]=t,M[1]=a,M[2]=n,M[3]=r,M[4]=u,M[5]=e,M[6]=i,M[7]=c,M[8]=s,M},n.set=function(t,a,n,r,u,o,e,i,c,s){return t[0]=a,t[1]=n,t[2]=r,t[3]=u,t[4]=o,t[5]=e,t[6]=i,t[7]=c,t[8]=s,t},n.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=1,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},n.transpose=function(t,a){if(t===a){var n=a[1],r=a[2],u=a[5];t[1]=a[3],t[2]=a[6],t[3]=n,t[5]=a[7],t[6]=r,t[7]=u}else t[0]=a[0],t[1]=a[3],t[2]=a[6],t[3]=a[1],t[4]=a[4],t[5]=a[7],t[6]=a[2],t[7]=a[5],t[8]=a[8];return t},n.invert=function(t,a){var n=a[0],r=a[1],u=a[2],o=a[3],e=a[4],i=a[5],c=a[6],s=a[7],M=a[8],h=M*e-i*s,f=-M*o+i*c,b=s*o-e*c,l=n*h+r*f+u*b;return l?(l=1/l,t[0]=h*l,t[1]=(-M*r+u*s)*l,t[2]=(i*r-u*e)*l,t[3]=f*l,t[4]=(M*n-u*c)*l,t[5]=(-i*n+u*o)*l,t[6]=b*l,t[7]=(-s*n+r*c)*l,t[8]=(e*n-r*o)*l,t):null},n.adjoint=function(t,a){var n=a[0],r=a[1],u=a[2],o=a[3],e=a[4],i=a[5],c=a[6],s=a[7],M=a[8];return t[0]=e*M-i*s,t[1]=u*s-r*M,t[2]=r*i-u*e,t[3]=i*c-o*M,t[4]=n*M-u*c,t[5]=u*o-n*i,t[6]=o*s-e*c,t[7]=r*c-n*s,t[8]=n*e-r*o,t},n.determinant=function(t){var a=t[0],n=t[1],r=t[2],u=t[3],o=t[4],e=t[5],i=t[6],c=t[7],s=t[8];return a*(s*o-e*c)+n*(-s*u+e*i)+r*(c*u-o*i)},n.multiply=e,n.translate=function(t,a,n){var r=a[0],u=a[1],o=a[2],e=a[3],i=a[4],c=a[5],s=a[6],M=a[7],h=a[8],f=n[0],b=n[1];return t[0]=r,t[1]=u,t[2]=o,t[3]=e,t[4]=i,t[5]=c,t[6]=f*r+b*e+s,t[7]=f*u+b*i+M,t[8]=f*o+b*c+h,t},n.rotate=function(t,a,n){var r=a[0],u=a[1],o=a[2],e=a[3],i=a[4],c=a[5],s=a[6],M=a[7],h=a[8],f=Math.sin(n),b=Math.cos(n);return t[0]=b*r+f*e,t[1]=b*u+f*i,t[2]=b*o+f*c,t[3]=b*e-f*r,t[4]=b*i-f*u,t[5]=b*c-f*o,t[6]=s,t[7]=M,t[8]=h,t},n.scale=function(t,a,n){var r=n[0],u=n[1];return t[0]=r*a[0],t[1]=r*a[1],t[2]=r*a[2],t[3]=u*a[3],t[4]=u*a[4],t[5]=u*a[5],t[6]=a[6],t[7]=a[7],t[8]=a[8],t},n.fromTranslation=function(t,a){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=1,t[5]=0,t[6]=a[0],t[7]=a[1],t[8]=1,t},n.fromRotation=function(t,a){var n=Math.sin(a),r=Math.cos(a);return t[0]=r,t[1]=n,t[2]=0,t[3]=-n,t[4]=r,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},n.fromScaling=function(t,a){return t[0]=a[0],t[1]=0,t[2]=0,t[3]=0,t[4]=a[1],t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},n.fromMat2d=function(t,a){return t[0]=a[0],t[1]=a[1],t[2]=0,t[3]=a[2],t[4]=a[3],t[5]=0,t[6]=a[4],t[7]=a[5],t[8]=1,t},n.fromQuat=function(t,a){var n=a[0],r=a[1],u=a[2],o=a[3],e=n+n,i=r+r,c=u+u,s=n*e,M=r*e,h=r*i,f=u*e,b=u*i,l=u*c,m=o*e,v=o*i,E=o*c;return t[0]=1-h-l,t[3]=M-E,t[6]=f+v,t[1]=M+E,t[4]=1-s-l,t[7]=b-m,t[2]=f-v,t[5]=b+m,t[8]=1-s-h,t},n.normalFromMat4=function(t,a){var n=a[0],r=a[1],u=a[2],o=a[3],e=a[4],i=a[5],c=a[6],s=a[7],M=a[8],h=a[9],f=a[10],b=a[11],l=a[12],m=a[13],v=a[14],E=a[15],P=n*i-r*e,S=n*c-u*e,A=n*s-o*e,x=r*c-u*i,d=r*s-o*i,I=u*s-o*c,L=M*m-h*l,N=M*v-f*l,O=M*E-b*l,R=h*v-f*m,p=h*E-b*m,Y=f*E-b*v,y=P*Y-S*p+A*R+x*O-d*N+I*L;return y?(y=1/y,t[0]=(i*Y-c*p+s*R)*y,t[1]=(c*O-e*Y-s*N)*y,t[2]=(e*p-i*O+s*L)*y,t[3]=(u*p-r*Y-o*R)*y,t[4]=(n*Y-u*O+o*N)*y,t[5]=(r*O-n*p-o*L)*y,t[6]=(m*I-v*d+E*x)*y,t[7]=(v*A-l*I-E*S)*y,t[8]=(l*d-m*A+E*P)*y,t):null},n.projection=function(t,a,n){return t[0]=2/a,t[1]=0,t[2]=0,t[3]=0,t[4]=-2/n,t[5]=0,t[6]=-1,t[7]=1,t[8]=1,t},n.str=function(t){return"mat3("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+", "+t[8]+")"},n.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8])},n.add=function(t,a,n){return t[0]=a[0]+n[0],t[1]=a[1]+n[1],t[2]=a[2]+n[2],t[3]=a[3]+n[3],t[4]=a[4]+n[4],t[5]=a[5]+n[5],t[6]=a[6]+n[6],t[7]=a[7]+n[7],t[8]=a[8]+n[8],t},n.subtract=i,n.multiplyScalar=function(t,a,n){return t[0]=a[0]*n,t[1]=a[1]*n,t[2]=a[2]*n,t[3]=a[3]*n,t[4]=a[4]*n,t[5]=a[5]*n,t[6]=a[6]*n,t[7]=a[7]*n,t[8]=a[8]*n,t},n.multiplyScalarAndAdd=function(t,a,n,r){return t[0]=a[0]+n[0]*r,t[1]=a[1]+n[1]*r,t[2]=a[2]+n[2]*r,t[3]=a[3]+n[3]*r,t[4]=a[4]+n[4]*r,t[5]=a[5]+n[5]*r,t[6]=a[6]+n[6]*r,t[7]=a[7]+n[7]*r,t[8]=a[8]+n[8]*r,t},n.exactEquals=function(t,a){return t[0]===a[0]&&t[1]===a[1]&&t[2]===a[2]&&t[3]===a[3]&&t[4]===a[4]&&t[5]===a[5]&&t[6]===a[6]&&t[7]===a[7]&&t[8]===a[8]},n.equals=function(t,a){var n=t[0],r=t[1],u=t[2],e=t[3],i=t[4],c=t[5],s=t[6],M=t[7],h=t[8],f=a[0],b=a[1],l=a[2],m=a[3],v=a[4],E=a[5],P=a[6],S=a[7],A=a[8];return Math.abs(n-f)<=o.EPSILON*Math.max(1,Math.abs(n),Math.abs(f))&&Math.abs(r-b)<=o.EPSILON*Math.max(1,Math.abs(r),Math.abs(b))&&Math.abs(u-l)<=o.EPSILON*Math.max(1,Math.abs(u),Math.abs(l))&&Math.abs(e-m)<=o.EPSILON*Math.max(1,Math.abs(e),Math.abs(m))&&Math.abs(i-v)<=o.EPSILON*Math.max(1,Math.abs(i),Math.abs(v))&&Math.abs(c-E)<=o.EPSILON*Math.max(1,Math.abs(c),Math.abs(E))&&Math.abs(s-P)<=o.EPSILON*Math.max(1,Math.abs(s),Math.abs(P))&&Math.abs(M-S)<=o.EPSILON*Math.max(1,Math.abs(M),Math.abs(S))&&Math.abs(h-A)<=o.EPSILON*Math.max(1,Math.abs(h),Math.abs(A))},n.mul=e,n.sub=i},
"a427635f32": function _(t,a,n,r,h){r();const o=t("tslib").__importStar(t("68ca94c15c"));function u(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function M(t,a,n){var r=a[0],h=a[1],o=a[2],u=a[3],M=a[4],s=a[5],e=a[6],i=a[7],c=a[8],f=a[9],b=a[10],l=a[11],m=a[12],v=a[13],P=a[14],E=a[15],S=n[0],I=n[1],O=n[2],L=n[3];return t[0]=S*r+I*M+O*c+L*m,t[1]=S*h+I*s+O*f+L*v,t[2]=S*o+I*e+O*b+L*P,t[3]=S*u+I*i+O*l+L*E,S=n[4],I=n[5],O=n[6],L=n[7],t[4]=S*r+I*M+O*c+L*m,t[5]=S*h+I*s+O*f+L*v,t[6]=S*o+I*e+O*b+L*P,t[7]=S*u+I*i+O*l+L*E,S=n[8],I=n[9],O=n[10],L=n[11],t[8]=S*r+I*M+O*c+L*m,t[9]=S*h+I*s+O*f+L*v,t[10]=S*o+I*e+O*b+L*P,t[11]=S*u+I*i+O*l+L*E,S=n[12],I=n[13],O=n[14],L=n[15],t[12]=S*r+I*M+O*c+L*m,t[13]=S*h+I*s+O*f+L*v,t[14]=S*o+I*e+O*b+L*P,t[15]=S*u+I*i+O*l+L*E,t}function s(t,a,n){var r=a[0],h=a[1],o=a[2],u=a[3],M=r+r,s=h+h,e=o+o,i=r*M,c=r*s,f=r*e,b=h*s,l=h*e,m=o*e,v=u*M,P=u*s,E=u*e;return t[0]=1-(b+m),t[1]=c+E,t[2]=f-P,t[3]=0,t[4]=c-E,t[5]=1-(i+m),t[6]=l+v,t[7]=0,t[8]=f+P,t[9]=l-v,t[10]=1-(i+b),t[11]=0,t[12]=n[0],t[13]=n[1],t[14]=n[2],t[15]=1,t}function e(t,a){var n=a[0],r=a[1],h=a[2],o=a[4],u=a[5],M=a[6],s=a[8],e=a[9],i=a[10];return t[0]=Math.hypot(n,r,h),t[1]=Math.hypot(o,u,M),t[2]=Math.hypot(s,e,i),t}function i(t,a,n){return t[0]=a[0]-n[0],t[1]=a[1]-n[1],t[2]=a[2]-n[2],t[3]=a[3]-n[3],t[4]=a[4]-n[4],t[5]=a[5]-n[5],t[6]=a[6]-n[6],t[7]=a[7]-n[7],t[8]=a[8]-n[8],t[9]=a[9]-n[9],t[10]=a[10]-n[10],t[11]=a[11]-n[11],t[12]=a[12]-n[12],t[13]=a[13]-n[13],t[14]=a[14]-n[14],t[15]=a[15]-n[15],t}n.create=function(){var t=new o.ARRAY_TYPE(16);return o.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t},n.clone=function(t){var a=new o.ARRAY_TYPE(16);return a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=t[3],a[4]=t[4],a[5]=t[5],a[6]=t[6],a[7]=t[7],a[8]=t[8],a[9]=t[9],a[10]=t[10],a[11]=t[11],a[12]=t[12],a[13]=t[13],a[14]=t[14],a[15]=t[15],a},n.copy=function(t,a){return t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[3],t[4]=a[4],t[5]=a[5],t[6]=a[6],t[7]=a[7],t[8]=a[8],t[9]=a[9],t[10]=a[10],t[11]=a[11],t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15],t},n.fromValues=function(t,a,n,r,h,u,M,s,e,i,c,f,b,l,m,v){var P=new o.ARRAY_TYPE(16);return P[0]=t,P[1]=a,P[2]=n,P[3]=r,P[4]=h,P[5]=u,P[6]=M,P[7]=s,P[8]=e,P[9]=i,P[10]=c,P[11]=f,P[12]=b,P[13]=l,P[14]=m,P[15]=v,P},n.set=function(t,a,n,r,h,o,u,M,s,e,i,c,f,b,l,m,v){return t[0]=a,t[1]=n,t[2]=r,t[3]=h,t[4]=o,t[5]=u,t[6]=M,t[7]=s,t[8]=e,t[9]=i,t[10]=c,t[11]=f,t[12]=b,t[13]=l,t[14]=m,t[15]=v,t},n.identity=u,n.transpose=function(t,a){if(t===a){var n=a[1],r=a[2],h=a[3],o=a[6],u=a[7],M=a[11];t[1]=a[4],t[2]=a[8],t[3]=a[12],t[4]=n,t[6]=a[9],t[7]=a[13],t[8]=r,t[9]=o,t[11]=a[14],t[12]=h,t[13]=u,t[14]=M}else t[0]=a[0],t[1]=a[4],t[2]=a[8],t[3]=a[12],t[4]=a[1],t[5]=a[5],t[6]=a[9],t[7]=a[13],t[8]=a[2],t[9]=a[6],t[10]=a[10],t[11]=a[14],t[12]=a[3],t[13]=a[7],t[14]=a[11],t[15]=a[15];return t},n.invert=function(t,a){var n=a[0],r=a[1],h=a[2],o=a[3],u=a[4],M=a[5],s=a[6],e=a[7],i=a[8],c=a[9],f=a[10],b=a[11],l=a[12],m=a[13],v=a[14],P=a[15],E=n*M-r*u,S=n*s-h*u,I=n*e-o*u,O=r*s-h*M,L=r*e-o*M,N=h*e-o*s,p=i*m-c*l,R=i*v-f*l,x=i*P-b*l,A=c*v-f*m,y=c*P-b*m,Y=f*P-b*v,g=E*Y-S*y+I*A+O*x-L*R+N*p;return g?(g=1/g,t[0]=(M*Y-s*y+e*A)*g,t[1]=(h*y-r*Y-o*A)*g,t[2]=(m*N-v*L+P*O)*g,t[3]=(f*L-c*N-b*O)*g,t[4]=(s*x-u*Y-e*R)*g,t[5]=(n*Y-h*x+o*R)*g,t[6]=(v*I-l*N-P*S)*g,t[7]=(i*N-f*I+b*S)*g,t[8]=(u*y-M*x+e*p)*g,t[9]=(r*x-n*y-o*p)*g,t[10]=(l*L-m*I+P*E)*g,t[11]=(c*I-i*L-b*E)*g,t[12]=(M*R-u*A-s*p)*g,t[13]=(n*A-r*R+h*p)*g,t[14]=(m*S-l*O-v*E)*g,t[15]=(i*O-c*S+f*E)*g,t):null},n.adjoint=function(t,a){var n=a[0],r=a[1],h=a[2],o=a[3],u=a[4],M=a[5],s=a[6],e=a[7],i=a[8],c=a[9],f=a[10],b=a[11],l=a[12],m=a[13],v=a[14],P=a[15];return t[0]=M*(f*P-b*v)-c*(s*P-e*v)+m*(s*b-e*f),t[1]=-(r*(f*P-b*v)-c*(h*P-o*v)+m*(h*b-o*f)),t[2]=r*(s*P-e*v)-M*(h*P-o*v)+m*(h*e-o*s),t[3]=-(r*(s*b-e*f)-M*(h*b-o*f)+c*(h*e-o*s)),t[4]=-(u*(f*P-b*v)-i*(s*P-e*v)+l*(s*b-e*f)),t[5]=n*(f*P-b*v)-i*(h*P-o*v)+l*(h*b-o*f),t[6]=-(n*(s*P-e*v)-u*(h*P-o*v)+l*(h*e-o*s)),t[7]=n*(s*b-e*f)-u*(h*b-o*f)+i*(h*e-o*s),t[8]=u*(c*P-b*m)-i*(M*P-e*m)+l*(M*b-e*c),t[9]=-(n*(c*P-b*m)-i*(r*P-o*m)+l*(r*b-o*c)),t[10]=n*(M*P-e*m)-u*(r*P-o*m)+l*(r*e-o*M),t[11]=-(n*(M*b-e*c)-u*(r*b-o*c)+i*(r*e-o*M)),t[12]=-(u*(c*v-f*m)-i*(M*v-s*m)+l*(M*f-s*c)),t[13]=n*(c*v-f*m)-i*(r*v-h*m)+l*(r*f-h*c),t[14]=-(n*(M*v-s*m)-u*(r*v-h*m)+l*(r*s-h*M)),t[15]=n*(M*f-s*c)-u*(r*f-h*c)+i*(r*s-h*M),t},n.determinant=function(t){var a=t[0],n=t[1],r=t[2],h=t[3],o=t[4],u=t[5],M=t[6],s=t[7],e=t[8],i=t[9],c=t[10],f=t[11],b=t[12],l=t[13],m=t[14],v=t[15];return(a*u-n*o)*(c*v-f*m)-(a*M-r*o)*(i*v-f*l)+(a*s-h*o)*(i*m-c*l)+(n*M-r*u)*(e*v-f*b)-(n*s-h*u)*(e*m-c*b)+(r*s-h*M)*(e*l-i*b)},n.multiply=M,n.translate=function(t,a,n){var r,h,o,u,M,s,e,i,c,f,b,l,m=n[0],v=n[1],P=n[2];return a===t?(t[12]=a[0]*m+a[4]*v+a[8]*P+a[12],t[13]=a[1]*m+a[5]*v+a[9]*P+a[13],t[14]=a[2]*m+a[6]*v+a[10]*P+a[14],t[15]=a[3]*m+a[7]*v+a[11]*P+a[15]):(r=a[0],h=a[1],o=a[2],u=a[3],M=a[4],s=a[5],e=a[6],i=a[7],c=a[8],f=a[9],b=a[10],l=a[11],t[0]=r,t[1]=h,t[2]=o,t[3]=u,t[4]=M,t[5]=s,t[6]=e,t[7]=i,t[8]=c,t[9]=f,t[10]=b,t[11]=l,t[12]=r*m+M*v+c*P+a[12],t[13]=h*m+s*v+f*P+a[13],t[14]=o*m+e*v+b*P+a[14],t[15]=u*m+i*v+l*P+a[15]),t},n.scale=function(t,a,n){var r=n[0],h=n[1],o=n[2];return t[0]=a[0]*r,t[1]=a[1]*r,t[2]=a[2]*r,t[3]=a[3]*r,t[4]=a[4]*h,t[5]=a[5]*h,t[6]=a[6]*h,t[7]=a[7]*h,t[8]=a[8]*o,t[9]=a[9]*o,t[10]=a[10]*o,t[11]=a[11]*o,t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15],t},n.rotate=function(t,a,n,r){var h,u,M,s,e,i,c,f,b,l,m,v,P,E,S,I,O,L,N,p,R,x,A,y,Y=r[0],g=r[1],T=r[2],d=Math.hypot(Y,g,T);return d<o.EPSILON?null:(Y*=d=1/d,g*=d,T*=d,h=Math.sin(n),M=1-(u=Math.cos(n)),s=a[0],e=a[1],i=a[2],c=a[3],f=a[4],b=a[5],l=a[6],m=a[7],v=a[8],P=a[9],E=a[10],S=a[11],I=Y*Y*M+u,O=g*Y*M+T*h,L=T*Y*M-g*h,N=Y*g*M-T*h,p=g*g*M+u,R=T*g*M+Y*h,x=Y*T*M+g*h,A=g*T*M-Y*h,y=T*T*M+u,t[0]=s*I+f*O+v*L,t[1]=e*I+b*O+P*L,t[2]=i*I+l*O+E*L,t[3]=c*I+m*O+S*L,t[4]=s*N+f*p+v*R,t[5]=e*N+b*p+P*R,t[6]=i*N+l*p+E*R,t[7]=c*N+m*p+S*R,t[8]=s*x+f*A+v*y,t[9]=e*x+b*A+P*y,t[10]=i*x+l*A+E*y,t[11]=c*x+m*A+S*y,a!==t&&(t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15]),t)},n.rotateX=function(t,a,n){var r=Math.sin(n),h=Math.cos(n),o=a[4],u=a[5],M=a[6],s=a[7],e=a[8],i=a[9],c=a[10],f=a[11];return a!==t&&(t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[3],t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15]),t[4]=o*h+e*r,t[5]=u*h+i*r,t[6]=M*h+c*r,t[7]=s*h+f*r,t[8]=e*h-o*r,t[9]=i*h-u*r,t[10]=c*h-M*r,t[11]=f*h-s*r,t},n.rotateY=function(t,a,n){var r=Math.sin(n),h=Math.cos(n),o=a[0],u=a[1],M=a[2],s=a[3],e=a[8],i=a[9],c=a[10],f=a[11];return a!==t&&(t[4]=a[4],t[5]=a[5],t[6]=a[6],t[7]=a[7],t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15]),t[0]=o*h-e*r,t[1]=u*h-i*r,t[2]=M*h-c*r,t[3]=s*h-f*r,t[8]=o*r+e*h,t[9]=u*r+i*h,t[10]=M*r+c*h,t[11]=s*r+f*h,t},n.rotateZ=function(t,a,n){var r=Math.sin(n),h=Math.cos(n),o=a[0],u=a[1],M=a[2],s=a[3],e=a[4],i=a[5],c=a[6],f=a[7];return a!==t&&(t[8]=a[8],t[9]=a[9],t[10]=a[10],t[11]=a[11],t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15]),t[0]=o*h+e*r,t[1]=u*h+i*r,t[2]=M*h+c*r,t[3]=s*h+f*r,t[4]=e*h-o*r,t[5]=i*h-u*r,t[6]=c*h-M*r,t[7]=f*h-s*r,t},n.fromTranslation=function(t,a){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=a[0],t[13]=a[1],t[14]=a[2],t[15]=1,t},n.fromScaling=function(t,a){return t[0]=a[0],t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=a[1],t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=a[2],t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},n.fromRotation=function(t,a,n){var r,h,u,M=n[0],s=n[1],e=n[2],i=Math.hypot(M,s,e);return i<o.EPSILON?null:(M*=i=1/i,s*=i,e*=i,r=Math.sin(a),u=1-(h=Math.cos(a)),t[0]=M*M*u+h,t[1]=s*M*u+e*r,t[2]=e*M*u-s*r,t[3]=0,t[4]=M*s*u-e*r,t[5]=s*s*u+h,t[6]=e*s*u+M*r,t[7]=0,t[8]=M*e*u+s*r,t[9]=s*e*u-M*r,t[10]=e*e*u+h,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t)},n.fromXRotation=function(t,a){var n=Math.sin(a),r=Math.cos(a);return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=r,t[6]=n,t[7]=0,t[8]=0,t[9]=-n,t[10]=r,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},n.fromYRotation=function(t,a){var n=Math.sin(a),r=Math.cos(a);return t[0]=r,t[1]=0,t[2]=-n,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=n,t[9]=0,t[10]=r,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},n.fromZRotation=function(t,a){var n=Math.sin(a),r=Math.cos(a);return t[0]=r,t[1]=n,t[2]=0,t[3]=0,t[4]=-n,t[5]=r,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},n.fromRotationTranslation=s,n.fromQuat2=function(t,a){var n=new o.ARRAY_TYPE(3),r=-a[0],h=-a[1],u=-a[2],M=a[3],e=a[4],i=a[5],c=a[6],f=a[7],b=r*r+h*h+u*u+M*M;return b>0?(n[0]=2*(e*M+f*r+i*u-c*h)/b,n[1]=2*(i*M+f*h+c*r-e*u)/b,n[2]=2*(c*M+f*u+e*h-i*r)/b):(n[0]=2*(e*M+f*r+i*u-c*h),n[1]=2*(i*M+f*h+c*r-e*u),n[2]=2*(c*M+f*u+e*h-i*r)),s(t,a,n),t},n.getTranslation=function(t,a){return t[0]=a[12],t[1]=a[13],t[2]=a[14],t},n.getScaling=e,n.getRotation=function(t,a){var n=new o.ARRAY_TYPE(3);e(n,a);var r=1/n[0],h=1/n[1],u=1/n[2],M=a[0]*r,s=a[1]*h,i=a[2]*u,c=a[4]*r,f=a[5]*h,b=a[6]*u,l=a[8]*r,m=a[9]*h,v=a[10]*u,P=M+f+v,E=0;return P>0?(E=2*Math.sqrt(P+1),t[3]=.25*E,t[0]=(b-m)/E,t[1]=(l-i)/E,t[2]=(s-c)/E):M>f&&M>v?(E=2*Math.sqrt(1+M-f-v),t[3]=(b-m)/E,t[0]=.25*E,t[1]=(s+c)/E,t[2]=(l+i)/E):f>v?(E=2*Math.sqrt(1+f-M-v),t[3]=(l-i)/E,t[0]=(s+c)/E,t[1]=.25*E,t[2]=(b+m)/E):(E=2*Math.sqrt(1+v-M-f),t[3]=(s-c)/E,t[0]=(l+i)/E,t[1]=(b+m)/E,t[2]=.25*E),t},n.fromRotationTranslationScale=function(t,a,n,r){var h=a[0],o=a[1],u=a[2],M=a[3],s=h+h,e=o+o,i=u+u,c=h*s,f=h*e,b=h*i,l=o*e,m=o*i,v=u*i,P=M*s,E=M*e,S=M*i,I=r[0],O=r[1],L=r[2];return t[0]=(1-(l+v))*I,t[1]=(f+S)*I,t[2]=(b-E)*I,t[3]=0,t[4]=(f-S)*O,t[5]=(1-(c+v))*O,t[6]=(m+P)*O,t[7]=0,t[8]=(b+E)*L,t[9]=(m-P)*L,t[10]=(1-(c+l))*L,t[11]=0,t[12]=n[0],t[13]=n[1],t[14]=n[2],t[15]=1,t},n.fromRotationTranslationScaleOrigin=function(t,a,n,r,h){var o=a[0],u=a[1],M=a[2],s=a[3],e=o+o,i=u+u,c=M+M,f=o*e,b=o*i,l=o*c,m=u*i,v=u*c,P=M*c,E=s*e,S=s*i,I=s*c,O=r[0],L=r[1],N=r[2],p=h[0],R=h[1],x=h[2],A=(1-(m+P))*O,y=(b+I)*O,Y=(l-S)*O,g=(b-I)*L,T=(1-(f+P))*L,d=(v+E)*L,_=(l+S)*N,q=(v-E)*N,w=(1-(f+m))*N;return t[0]=A,t[1]=y,t[2]=Y,t[3]=0,t[4]=g,t[5]=T,t[6]=d,t[7]=0,t[8]=_,t[9]=q,t[10]=w,t[11]=0,t[12]=n[0]+p-(A*p+g*R+_*x),t[13]=n[1]+R-(y*p+T*R+q*x),t[14]=n[2]+x-(Y*p+d*R+w*x),t[15]=1,t},n.fromQuat=function(t,a){var n=a[0],r=a[1],h=a[2],o=a[3],u=n+n,M=r+r,s=h+h,e=n*u,i=r*u,c=r*M,f=h*u,b=h*M,l=h*s,m=o*u,v=o*M,P=o*s;return t[0]=1-c-l,t[1]=i+P,t[2]=f-v,t[3]=0,t[4]=i-P,t[5]=1-e-l,t[6]=b+m,t[7]=0,t[8]=f+v,t[9]=b-m,t[10]=1-e-c,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},n.frustum=function(t,a,n,r,h,o,u){var M=1/(n-a),s=1/(h-r),e=1/(o-u);return t[0]=2*o*M,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=2*o*s,t[6]=0,t[7]=0,t[8]=(n+a)*M,t[9]=(h+r)*s,t[10]=(u+o)*e,t[11]=-1,t[12]=0,t[13]=0,t[14]=u*o*2*e,t[15]=0,t},n.perspective=function(t,a,n,r,h){var o,u=1/Math.tan(a/2);return t[0]=u/n,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=u,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=h&&h!==1/0?(o=1/(r-h),t[10]=(h+r)*o,t[14]=2*h*r*o):(t[10]=-1,t[14]=-2*r),t},n.perspectiveFromFieldOfView=function(t,a,n,r){var h=Math.tan(a.upDegrees*Math.PI/180),o=Math.tan(a.downDegrees*Math.PI/180),u=Math.tan(a.leftDegrees*Math.PI/180),M=Math.tan(a.rightDegrees*Math.PI/180),s=2/(u+M),e=2/(h+o);return t[0]=s,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=-(u-M)*s*.5,t[9]=(h-o)*e*.5,t[10]=r/(n-r),t[11]=-1,t[12]=0,t[13]=0,t[14]=r*n/(n-r),t[15]=0,t},n.ortho=function(t,a,n,r,h,o,u){var M=1/(a-n),s=1/(r-h),e=1/(o-u);return t[0]=-2*M,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*s,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*e,t[11]=0,t[12]=(a+n)*M,t[13]=(h+r)*s,t[14]=(u+o)*e,t[15]=1,t},n.lookAt=function(t,a,n,r){var h,M,s,e,i,c,f,b,l,m,v=a[0],P=a[1],E=a[2],S=r[0],I=r[1],O=r[2],L=n[0],N=n[1],p=n[2];return Math.abs(v-L)<o.EPSILON&&Math.abs(P-N)<o.EPSILON&&Math.abs(E-p)<o.EPSILON?u(t):(f=v-L,b=P-N,l=E-p,h=I*(l*=m=1/Math.hypot(f,b,l))-O*(b*=m),M=O*(f*=m)-S*l,s=S*b-I*f,(m=Math.hypot(h,M,s))?(h*=m=1/m,M*=m,s*=m):(h=0,M=0,s=0),e=b*s-l*M,i=l*h-f*s,c=f*M-b*h,(m=Math.hypot(e,i,c))?(e*=m=1/m,i*=m,c*=m):(e=0,i=0,c=0),t[0]=h,t[1]=e,t[2]=f,t[3]=0,t[4]=M,t[5]=i,t[6]=b,t[7]=0,t[8]=s,t[9]=c,t[10]=l,t[11]=0,t[12]=-(h*v+M*P+s*E),t[13]=-(e*v+i*P+c*E),t[14]=-(f*v+b*P+l*E),t[15]=1,t)},n.targetTo=function(t,a,n,r){var h=a[0],o=a[1],u=a[2],M=r[0],s=r[1],e=r[2],i=h-n[0],c=o-n[1],f=u-n[2],b=i*i+c*c+f*f;b>0&&(i*=b=1/Math.sqrt(b),c*=b,f*=b);var l=s*f-e*c,m=e*i-M*f,v=M*c-s*i;return(b=l*l+m*m+v*v)>0&&(l*=b=1/Math.sqrt(b),m*=b,v*=b),t[0]=l,t[1]=m,t[2]=v,t[3]=0,t[4]=c*v-f*m,t[5]=f*l-i*v,t[6]=i*m-c*l,t[7]=0,t[8]=i,t[9]=c,t[10]=f,t[11]=0,t[12]=h,t[13]=o,t[14]=u,t[15]=1,t},n.str=function(t){return"mat4("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+", "+t[8]+", "+t[9]+", "+t[10]+", "+t[11]+", "+t[12]+", "+t[13]+", "+t[14]+", "+t[15]+")"},n.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15])},n.add=function(t,a,n){return t[0]=a[0]+n[0],t[1]=a[1]+n[1],t[2]=a[2]+n[2],t[3]=a[3]+n[3],t[4]=a[4]+n[4],t[5]=a[5]+n[5],t[6]=a[6]+n[6],t[7]=a[7]+n[7],t[8]=a[8]+n[8],t[9]=a[9]+n[9],t[10]=a[10]+n[10],t[11]=a[11]+n[11],t[12]=a[12]+n[12],t[13]=a[13]+n[13],t[14]=a[14]+n[14],t[15]=a[15]+n[15],t},n.subtract=i,n.multiplyScalar=function(t,a,n){return t[0]=a[0]*n,t[1]=a[1]*n,t[2]=a[2]*n,t[3]=a[3]*n,t[4]=a[4]*n,t[5]=a[5]*n,t[6]=a[6]*n,t[7]=a[7]*n,t[8]=a[8]*n,t[9]=a[9]*n,t[10]=a[10]*n,t[11]=a[11]*n,t[12]=a[12]*n,t[13]=a[13]*n,t[14]=a[14]*n,t[15]=a[15]*n,t},n.multiplyScalarAndAdd=function(t,a,n,r){return t[0]=a[0]+n[0]*r,t[1]=a[1]+n[1]*r,t[2]=a[2]+n[2]*r,t[3]=a[3]+n[3]*r,t[4]=a[4]+n[4]*r,t[5]=a[5]+n[5]*r,t[6]=a[6]+n[6]*r,t[7]=a[7]+n[7]*r,t[8]=a[8]+n[8]*r,t[9]=a[9]+n[9]*r,t[10]=a[10]+n[10]*r,t[11]=a[11]+n[11]*r,t[12]=a[12]+n[12]*r,t[13]=a[13]+n[13]*r,t[14]=a[14]+n[14]*r,t[15]=a[15]+n[15]*r,t},n.exactEquals=function(t,a){return t[0]===a[0]&&t[1]===a[1]&&t[2]===a[2]&&t[3]===a[3]&&t[4]===a[4]&&t[5]===a[5]&&t[6]===a[6]&&t[7]===a[7]&&t[8]===a[8]&&t[9]===a[9]&&t[10]===a[10]&&t[11]===a[11]&&t[12]===a[12]&&t[13]===a[13]&&t[14]===a[14]&&t[15]===a[15]},n.equals=function(t,a){var n=t[0],r=t[1],h=t[2],u=t[3],M=t[4],s=t[5],e=t[6],i=t[7],c=t[8],f=t[9],b=t[10],l=t[11],m=t[12],v=t[13],P=t[14],E=t[15],S=a[0],I=a[1],O=a[2],L=a[3],N=a[4],p=a[5],R=a[6],x=a[7],A=a[8],y=a[9],Y=a[10],g=a[11],T=a[12],d=a[13],_=a[14],q=a[15];return Math.abs(n-S)<=o.EPSILON*Math.max(1,Math.abs(n),Math.abs(S))&&Math.abs(r-I)<=o.EPSILON*Math.max(1,Math.abs(r),Math.abs(I))&&Math.abs(h-O)<=o.EPSILON*Math.max(1,Math.abs(h),Math.abs(O))&&Math.abs(u-L)<=o.EPSILON*Math.max(1,Math.abs(u),Math.abs(L))&&Math.abs(M-N)<=o.EPSILON*Math.max(1,Math.abs(M),Math.abs(N))&&Math.abs(s-p)<=o.EPSILON*Math.max(1,Math.abs(s),Math.abs(p))&&Math.abs(e-R)<=o.EPSILON*Math.max(1,Math.abs(e),Math.abs(R))&&Math.abs(i-x)<=o.EPSILON*Math.max(1,Math.abs(i),Math.abs(x))&&Math.abs(c-A)<=o.EPSILON*Math.max(1,Math.abs(c),Math.abs(A))&&Math.abs(f-y)<=o.EPSILON*Math.max(1,Math.abs(f),Math.abs(y))&&Math.abs(b-Y)<=o.EPSILON*Math.max(1,Math.abs(b),Math.abs(Y))&&Math.abs(l-g)<=o.EPSILON*Math.max(1,Math.abs(l),Math.abs(g))&&Math.abs(m-T)<=o.EPSILON*Math.max(1,Math.abs(m),Math.abs(T))&&Math.abs(v-d)<=o.EPSILON*Math.max(1,Math.abs(v),Math.abs(d))&&Math.abs(P-_)<=o.EPSILON*Math.max(1,Math.abs(P),Math.abs(_))&&Math.abs(E-q)<=o.EPSILON*Math.max(1,Math.abs(E),Math.abs(q))},n.mul=M,n.sub=i},
"eb06fc032a": function _(t,a,r,n,e){n();const o=t("tslib"),s=o.__importStar(t("68ca94c15c")),u=o.__importStar(t("0285c50a7e")),c=o.__importStar(t("2c5eb22089")),i=o.__importStar(t("c1aa33d719"));function h(){var t=new s.ARRAY_TYPE(4);return s.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t}function M(t,a,r){r*=.5;var n=Math.sin(r);return t[0]=n*a[0],t[1]=n*a[1],t[2]=n*a[2],t[3]=Math.cos(r),t}function l(t,a,r){var n=a[0],e=a[1],o=a[2],s=a[3],u=r[0],c=r[1],i=r[2],h=r[3];return t[0]=n*h+s*u+e*i-o*c,t[1]=e*h+s*c+o*u-n*i,t[2]=o*h+s*i+n*c-e*u,t[3]=s*h-n*u-e*c-o*i,t}function f(t,a){var r=a[0],n=a[1],e=a[2],o=a[3],s=Math.sqrt(r*r+n*n+e*e),u=Math.exp(o),c=s>0?u*Math.sin(s)/s:0;return t[0]=r*c,t[1]=n*c,t[2]=e*c,t[3]=u*Math.cos(s),t}function v(t,a){var r=a[0],n=a[1],e=a[2],o=a[3],s=Math.sqrt(r*r+n*n+e*e),u=s>0?Math.atan2(s,o)/s:0;return t[0]=r*u,t[1]=n*u,t[2]=e*u,t[3]=.5*Math.log(r*r+n*n+e*e+o*o),t}function m(t,a,r,n){var e,o,u,c,i,h=a[0],M=a[1],l=a[2],f=a[3],v=r[0],m=r[1],q=r[2],d=r[3];return(o=h*v+M*m+l*q+f*d)<0&&(o=-o,v=-v,m=-m,q=-q,d=-d),1-o>s.EPSILON?(e=Math.acos(o),u=Math.sin(e),c=Math.sin((1-n)*e)/u,i=Math.sin(n*e)/u):(c=1-n,i=n),t[0]=c*h+i*v,t[1]=c*M+i*m,t[2]=c*l+i*q,t[3]=c*f+i*d,t}function q(t,a){var r,n=a[0]+a[4]+a[8];if(n>0)r=Math.sqrt(n+1),t[3]=.5*r,r=.5/r,t[0]=(a[5]-a[7])*r,t[1]=(a[6]-a[2])*r,t[2]=(a[1]-a[3])*r;else{var e=0;a[4]>a[0]&&(e=1),a[8]>a[3*e+e]&&(e=2);var o=(e+1)%3,s=(e+2)%3;r=Math.sqrt(a[3*e+e]-a[3*o+o]-a[3*s+s]+1),t[e]=.5*r,r=.5/r,t[3]=(a[3*o+s]-a[3*s+o])*r,t[o]=(a[3*o+e]+a[3*e+o])*r,t[s]=(a[3*s+e]+a[3*e+s])*r}return t}var d,p,A,g,_,P;r.create=h,r.identity=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t},r.setAxisAngle=M,r.getAxisAngle=function(t,a){var r=2*Math.acos(a[3]),n=Math.sin(r/2);return n>s.EPSILON?(t[0]=a[0]/n,t[1]=a[1]/n,t[2]=a[2]/n):(t[0]=1,t[1]=0,t[2]=0),r},r.getAngle=function(t,a){var n=(0,r.dot)(t,a);return Math.acos(2*n*n-1)},r.multiply=l,r.rotateX=function(t,a,r){r*=.5;var n=a[0],e=a[1],o=a[2],s=a[3],u=Math.sin(r),c=Math.cos(r);return t[0]=n*c+s*u,t[1]=e*c+o*u,t[2]=o*c-e*u,t[3]=s*c-n*u,t},r.rotateY=function(t,a,r){r*=.5;var n=a[0],e=a[1],o=a[2],s=a[3],u=Math.sin(r),c=Math.cos(r);return t[0]=n*c-o*u,t[1]=e*c+s*u,t[2]=o*c+n*u,t[3]=s*c-e*u,t},r.rotateZ=function(t,a,r){r*=.5;var n=a[0],e=a[1],o=a[2],s=a[3],u=Math.sin(r),c=Math.cos(r);return t[0]=n*c+e*u,t[1]=e*c-n*u,t[2]=o*c+s*u,t[3]=s*c-o*u,t},r.calculateW=function(t,a){var r=a[0],n=a[1],e=a[2];return t[0]=r,t[1]=n,t[2]=e,t[3]=Math.sqrt(Math.abs(1-r*r-n*n-e*e)),t},r.exp=f,r.ln=v,r.pow=function(t,a,n){return v(t,a),(0,r.scale)(t,t,n),f(t,t),t},r.slerp=m,r.random=function(t){var a=s.RANDOM(),r=s.RANDOM(),n=s.RANDOM(),e=Math.sqrt(1-a),o=Math.sqrt(a);return t[0]=e*Math.sin(2*Math.PI*r),t[1]=e*Math.cos(2*Math.PI*r),t[2]=o*Math.sin(2*Math.PI*n),t[3]=o*Math.cos(2*Math.PI*n),t},r.invert=function(t,a){var r=a[0],n=a[1],e=a[2],o=a[3],s=r*r+n*n+e*e+o*o,u=s?1/s:0;return t[0]=-r*u,t[1]=-n*u,t[2]=-e*u,t[3]=o*u,t},r.conjugate=function(t,a){return t[0]=-a[0],t[1]=-a[1],t[2]=-a[2],t[3]=a[3],t},r.fromMat3=q,r.fromEuler=function(t,a,r,n){var e=.5*Math.PI/180;a*=e,r*=e,n*=e;var o=Math.sin(a),s=Math.cos(a),u=Math.sin(r),c=Math.cos(r),i=Math.sin(n),h=Math.cos(n);return t[0]=o*c*h-s*u*i,t[1]=s*u*h+o*c*i,t[2]=s*c*i-o*u*h,t[3]=s*c*h+o*u*i,t},r.str=function(t){return"quat("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},r.clone=i.clone,r.fromValues=i.fromValues,r.copy=i.copy,r.set=i.set,r.add=i.add,r.mul=l,r.scale=i.scale,r.dot=i.dot,r.lerp=i.lerp,r.length=i.length,r.len=r.length,r.squaredLength=i.squaredLength,r.sqrLen=r.squaredLength,r.normalize=i.normalize,r.exactEquals=i.exactEquals,r.equals=i.equals,r.rotationTo=(d=c.create(),p=c.fromValues(1,0,0),A=c.fromValues(0,1,0),function(t,a,n){var e=c.dot(a,n);return e<-.999999?(c.cross(d,p,a),c.len(d)<1e-6&&c.cross(d,A,a),c.normalize(d,d),M(t,d,Math.PI),t):e>.999999?(t[0]=0,t[1]=0,t[2]=0,t[3]=1,t):(c.cross(d,a,n),t[0]=d[0],t[1]=d[1],t[2]=d[2],t[3]=1+e,(0,r.normalize)(t,t))}),r.sqlerp=(g=h(),_=h(),function(t,a,r,n,e,o){return m(g,a,e,o),m(_,r,n,o),m(t,g,_,2*o*(1-o)),t}),r.setAxes=(P=u.create(),function(t,a,n,e){return P[0]=n[0],P[3]=n[1],P[6]=n[2],P[1]=e[0],P[4]=e[1],P[7]=e[2],P[2]=-a[0],P[5]=-a[1],P[8]=-a[2],(0,r.normalize)(t,q(t,P))})},
"2c5eb22089": function _(t,n,r,a,u){a();const e=t("tslib").__importStar(t("68ca94c15c"));function o(){var t=new e.ARRAY_TYPE(3);return e.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t}function i(t){var n=t[0],r=t[1],a=t[2];return Math.hypot(n,r,a)}function c(t,n,r){return t[0]=n[0]-r[0],t[1]=n[1]-r[1],t[2]=n[2]-r[2],t}function h(t,n,r){return t[0]=n[0]*r[0],t[1]=n[1]*r[1],t[2]=n[2]*r[2],t}function M(t,n,r){return t[0]=n[0]/r[0],t[1]=n[1]/r[1],t[2]=n[2]/r[2],t}function s(t,n){var r=n[0]-t[0],a=n[1]-t[1],u=n[2]-t[2];return Math.hypot(r,a,u)}function f(t,n){var r=n[0]-t[0],a=n[1]-t[1],u=n[2]-t[2];return r*r+a*a+u*u}function v(t){var n=t[0],r=t[1],a=t[2];return n*n+r*r+a*a}function l(t,n){return t[0]*n[0]+t[1]*n[1]+t[2]*n[2]}var m;r.create=o,r.clone=function(t){var n=new e.ARRAY_TYPE(3);return n[0]=t[0],n[1]=t[1],n[2]=t[2],n},r.length=i,r.fromValues=function(t,n,r){var a=new e.ARRAY_TYPE(3);return a[0]=t,a[1]=n,a[2]=r,a},r.copy=function(t,n){return t[0]=n[0],t[1]=n[1],t[2]=n[2],t},r.set=function(t,n,r,a){return t[0]=n,t[1]=r,t[2]=a,t},r.add=function(t,n,r){return t[0]=n[0]+r[0],t[1]=n[1]+r[1],t[2]=n[2]+r[2],t},r.subtract=c,r.multiply=h,r.divide=M,r.ceil=function(t,n){return t[0]=Math.ceil(n[0]),t[1]=Math.ceil(n[1]),t[2]=Math.ceil(n[2]),t},r.floor=function(t,n){return t[0]=Math.floor(n[0]),t[1]=Math.floor(n[1]),t[2]=Math.floor(n[2]),t},r.min=function(t,n,r){return t[0]=Math.min(n[0],r[0]),t[1]=Math.min(n[1],r[1]),t[2]=Math.min(n[2],r[2]),t},r.max=function(t,n,r){return t[0]=Math.max(n[0],r[0]),t[1]=Math.max(n[1],r[1]),t[2]=Math.max(n[2],r[2]),t},r.round=function(t,n){return t[0]=Math.round(n[0]),t[1]=Math.round(n[1]),t[2]=Math.round(n[2]),t},r.scale=function(t,n,r){return t[0]=n[0]*r,t[1]=n[1]*r,t[2]=n[2]*r,t},r.scaleAndAdd=function(t,n,r,a){return t[0]=n[0]+r[0]*a,t[1]=n[1]+r[1]*a,t[2]=n[2]+r[2]*a,t},r.distance=s,r.squaredDistance=f,r.squaredLength=v,r.negate=function(t,n){return t[0]=-n[0],t[1]=-n[1],t[2]=-n[2],t},r.inverse=function(t,n){return t[0]=1/n[0],t[1]=1/n[1],t[2]=1/n[2],t},r.normalize=function(t,n){var r=n[0],a=n[1],u=n[2],e=r*r+a*a+u*u;return e>0&&(e=1/Math.sqrt(e)),t[0]=n[0]*e,t[1]=n[1]*e,t[2]=n[2]*e,t},r.dot=l,r.cross=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=r[0],i=r[1],c=r[2];return t[0]=u*c-e*i,t[1]=e*o-a*c,t[2]=a*i-u*o,t},r.lerp=function(t,n,r,a){var u=n[0],e=n[1],o=n[2];return t[0]=u+a*(r[0]-u),t[1]=e+a*(r[1]-e),t[2]=o+a*(r[2]-o),t},r.hermite=function(t,n,r,a,u,e){var o=e*e,i=o*(2*e-3)+1,c=o*(e-2)+e,h=o*(e-1),M=o*(3-2*e);return t[0]=n[0]*i+r[0]*c+a[0]*h+u[0]*M,t[1]=n[1]*i+r[1]*c+a[1]*h+u[1]*M,t[2]=n[2]*i+r[2]*c+a[2]*h+u[2]*M,t},r.bezier=function(t,n,r,a,u,e){var o=1-e,i=o*o,c=e*e,h=i*o,M=3*e*i,s=3*c*o,f=c*e;return t[0]=n[0]*h+r[0]*M+a[0]*s+u[0]*f,t[1]=n[1]*h+r[1]*M+a[1]*s+u[1]*f,t[2]=n[2]*h+r[2]*M+a[2]*s+u[2]*f,t},r.random=function(t,n){n=n||1;var r=2*e.RANDOM()*Math.PI,a=2*e.RANDOM()-1,u=Math.sqrt(1-a*a)*n;return t[0]=Math.cos(r)*u,t[1]=Math.sin(r)*u,t[2]=a*n,t},r.transformMat4=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=r[3]*a+r[7]*u+r[11]*e+r[15];return o=o||1,t[0]=(r[0]*a+r[4]*u+r[8]*e+r[12])/o,t[1]=(r[1]*a+r[5]*u+r[9]*e+r[13])/o,t[2]=(r[2]*a+r[6]*u+r[10]*e+r[14])/o,t},r.transformMat3=function(t,n,r){var a=n[0],u=n[1],e=n[2];return t[0]=a*r[0]+u*r[3]+e*r[6],t[1]=a*r[1]+u*r[4]+e*r[7],t[2]=a*r[2]+u*r[5]+e*r[8],t},r.transformQuat=function(t,n,r){var a=r[0],u=r[1],e=r[2],o=r[3],i=n[0],c=n[1],h=n[2],M=u*h-e*c,s=e*i-a*h,f=a*c-u*i,v=u*f-e*s,l=e*M-a*f,m=a*s-u*M,d=2*o;return M*=d,s*=d,f*=d,v*=2,l*=2,m*=2,t[0]=i+M+v,t[1]=c+s+l,t[2]=h+f+m,t},r.rotateX=function(t,n,r,a){var u=[],e=[];return u[0]=n[0]-r[0],u[1]=n[1]-r[1],u[2]=n[2]-r[2],e[0]=u[0],e[1]=u[1]*Math.cos(a)-u[2]*Math.sin(a),e[2]=u[1]*Math.sin(a)+u[2]*Math.cos(a),t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t},r.rotateY=function(t,n,r,a){var u=[],e=[];return u[0]=n[0]-r[0],u[1]=n[1]-r[1],u[2]=n[2]-r[2],e[0]=u[2]*Math.sin(a)+u[0]*Math.cos(a),e[1]=u[1],e[2]=u[2]*Math.cos(a)-u[0]*Math.sin(a),t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t},r.rotateZ=function(t,n,r,a){var u=[],e=[];return u[0]=n[0]-r[0],u[1]=n[1]-r[1],u[2]=n[2]-r[2],e[0]=u[0]*Math.cos(a)-u[1]*Math.sin(a),e[1]=u[0]*Math.sin(a)+u[1]*Math.cos(a),e[2]=u[2],t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t},r.angle=function(t,n){var r=t[0],a=t[1],u=t[2],e=n[0],o=n[1],i=n[2],c=Math.sqrt(r*r+a*a+u*u)*Math.sqrt(e*e+o*o+i*i),h=c&&l(t,n)/c;return Math.acos(Math.min(Math.max(h,-1),1))},r.zero=function(t){return t[0]=0,t[1]=0,t[2]=0,t},r.str=function(t){return"vec3("+t[0]+", "+t[1]+", "+t[2]+")"},r.exactEquals=function(t,n){return t[0]===n[0]&&t[1]===n[1]&&t[2]===n[2]},r.equals=function(t,n){var r=t[0],a=t[1],u=t[2],o=n[0],i=n[1],c=n[2];return Math.abs(r-o)<=e.EPSILON*Math.max(1,Math.abs(r),Math.abs(o))&&Math.abs(a-i)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(i))&&Math.abs(u-c)<=e.EPSILON*Math.max(1,Math.abs(u),Math.abs(c))},r.sub=c,r.mul=h,r.div=M,r.dist=s,r.sqrDist=f,r.len=i,r.sqrLen=v,r.forEach=(m=o(),function(t,n,r,a,u,e){var o,i;for(n||(n=3),r||(r=0),i=a?Math.min(a*n+r,t.length):t.length,o=r;o<i;o+=n)m[0]=t[o],m[1]=t[o+1],m[2]=t[o+2],u(m,m,e),t[o]=m[0],t[o+1]=m[1],t[o+2]=m[2];return t})},
"c1aa33d719": function _(t,n,r,a,u){a();const e=t("tslib").__importStar(t("68ca94c15c"));function o(){var t=new e.ARRAY_TYPE(4);return e.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0,t[3]=0),t}function i(t,n,r){return t[0]=n[0]-r[0],t[1]=n[1]-r[1],t[2]=n[2]-r[2],t[3]=n[3]-r[3],t}function c(t,n,r){return t[0]=n[0]*r[0],t[1]=n[1]*r[1],t[2]=n[2]*r[2],t[3]=n[3]*r[3],t}function h(t,n,r){return t[0]=n[0]/r[0],t[1]=n[1]/r[1],t[2]=n[2]/r[2],t[3]=n[3]/r[3],t}function M(t,n){var r=n[0]-t[0],a=n[1]-t[1],u=n[2]-t[2],e=n[3]-t[3];return Math.hypot(r,a,u,e)}function f(t,n){var r=n[0]-t[0],a=n[1]-t[1],u=n[2]-t[2],e=n[3]-t[3];return r*r+a*a+u*u+e*e}function s(t){var n=t[0],r=t[1],a=t[2],u=t[3];return Math.hypot(n,r,a,u)}function l(t){var n=t[0],r=t[1],a=t[2],u=t[3];return n*n+r*r+a*a+u*u}var m;r.create=o,r.clone=function(t){var n=new e.ARRAY_TYPE(4);return n[0]=t[0],n[1]=t[1],n[2]=t[2],n[3]=t[3],n},r.fromValues=function(t,n,r,a){var u=new e.ARRAY_TYPE(4);return u[0]=t,u[1]=n,u[2]=r,u[3]=a,u},r.copy=function(t,n){return t[0]=n[0],t[1]=n[1],t[2]=n[2],t[3]=n[3],t},r.set=function(t,n,r,a,u){return t[0]=n,t[1]=r,t[2]=a,t[3]=u,t},r.add=function(t,n,r){return t[0]=n[0]+r[0],t[1]=n[1]+r[1],t[2]=n[2]+r[2],t[3]=n[3]+r[3],t},r.subtract=i,r.multiply=c,r.divide=h,r.ceil=function(t,n){return t[0]=Math.ceil(n[0]),t[1]=Math.ceil(n[1]),t[2]=Math.ceil(n[2]),t[3]=Math.ceil(n[3]),t},r.floor=function(t,n){return t[0]=Math.floor(n[0]),t[1]=Math.floor(n[1]),t[2]=Math.floor(n[2]),t[3]=Math.floor(n[3]),t},r.min=function(t,n,r){return t[0]=Math.min(n[0],r[0]),t[1]=Math.min(n[1],r[1]),t[2]=Math.min(n[2],r[2]),t[3]=Math.min(n[3],r[3]),t},r.max=function(t,n,r){return t[0]=Math.max(n[0],r[0]),t[1]=Math.max(n[1],r[1]),t[2]=Math.max(n[2],r[2]),t[3]=Math.max(n[3],r[3]),t},r.round=function(t,n){return t[0]=Math.round(n[0]),t[1]=Math.round(n[1]),t[2]=Math.round(n[2]),t[3]=Math.round(n[3]),t},r.scale=function(t,n,r){return t[0]=n[0]*r,t[1]=n[1]*r,t[2]=n[2]*r,t[3]=n[3]*r,t},r.scaleAndAdd=function(t,n,r,a){return t[0]=n[0]+r[0]*a,t[1]=n[1]+r[1]*a,t[2]=n[2]+r[2]*a,t[3]=n[3]+r[3]*a,t},r.distance=M,r.squaredDistance=f,r.length=s,r.squaredLength=l,r.negate=function(t,n){return t[0]=-n[0],t[1]=-n[1],t[2]=-n[2],t[3]=-n[3],t},r.inverse=function(t,n){return t[0]=1/n[0],t[1]=1/n[1],t[2]=1/n[2],t[3]=1/n[3],t},r.normalize=function(t,n){var r=n[0],a=n[1],u=n[2],e=n[3],o=r*r+a*a+u*u+e*e;return o>0&&(o=1/Math.sqrt(o)),t[0]=r*o,t[1]=a*o,t[2]=u*o,t[3]=e*o,t},r.dot=function(t,n){return t[0]*n[0]+t[1]*n[1]+t[2]*n[2]+t[3]*n[3]},r.cross=function(t,n,r,a){var u=r[0]*a[1]-r[1]*a[0],e=r[0]*a[2]-r[2]*a[0],o=r[0]*a[3]-r[3]*a[0],i=r[1]*a[2]-r[2]*a[1],c=r[1]*a[3]-r[3]*a[1],h=r[2]*a[3]-r[3]*a[2],M=n[0],f=n[1],s=n[2],l=n[3];return t[0]=f*h-s*c+l*i,t[1]=-M*h+s*o-l*e,t[2]=M*c-f*o+l*u,t[3]=-M*i+f*e-s*u,t},r.lerp=function(t,n,r,a){var u=n[0],e=n[1],o=n[2],i=n[3];return t[0]=u+a*(r[0]-u),t[1]=e+a*(r[1]-e),t[2]=o+a*(r[2]-o),t[3]=i+a*(r[3]-i),t},r.random=function(t,n){var r,a,u,o,i,c;n=n||1;do{i=(r=2*e.RANDOM()-1)*r+(a=2*e.RANDOM()-1)*a}while(i>=1);do{c=(u=2*e.RANDOM()-1)*u+(o=2*e.RANDOM()-1)*o}while(c>=1);var h=Math.sqrt((1-i)/c);return t[0]=n*r,t[1]=n*a,t[2]=n*u*h,t[3]=n*o*h,t},r.transformMat4=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=n[3];return t[0]=r[0]*a+r[4]*u+r[8]*e+r[12]*o,t[1]=r[1]*a+r[5]*u+r[9]*e+r[13]*o,t[2]=r[2]*a+r[6]*u+r[10]*e+r[14]*o,t[3]=r[3]*a+r[7]*u+r[11]*e+r[15]*o,t},r.transformQuat=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=r[0],i=r[1],c=r[2],h=r[3],M=h*a+i*e-c*u,f=h*u+c*a-o*e,s=h*e+o*u-i*a,l=-o*a-i*u-c*e;return t[0]=M*h+l*-o+f*-c-s*-i,t[1]=f*h+l*-i+s*-o-M*-c,t[2]=s*h+l*-c+M*-i-f*-o,t[3]=n[3],t},r.zero=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t},r.str=function(t){return"vec4("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},r.exactEquals=function(t,n){return t[0]===n[0]&&t[1]===n[1]&&t[2]===n[2]&&t[3]===n[3]},r.equals=function(t,n){var r=t[0],a=t[1],u=t[2],o=t[3],i=n[0],c=n[1],h=n[2],M=n[3];return Math.abs(r-i)<=e.EPSILON*Math.max(1,Math.abs(r),Math.abs(i))&&Math.abs(a-c)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(c))&&Math.abs(u-h)<=e.EPSILON*Math.max(1,Math.abs(u),Math.abs(h))&&Math.abs(o-M)<=e.EPSILON*Math.max(1,Math.abs(o),Math.abs(M))},r.sub=i,r.mul=c,r.div=h,r.dist=M,r.sqrDist=f,r.len=s,r.sqrLen=l,r.forEach=(m=o(),function(t,n,r,a,u,e){var o,i;for(n||(n=4),r||(r=0),i=a?Math.min(a*n+r,t.length):t.length,o=r;o<i;o+=n)m[0]=t[o],m[1]=t[o+1],m[2]=t[o+2],m[3]=t[o+3],u(m,m,e),t[o]=m[0],t[o+1]=m[1],t[o+2]=m[2],t[o+3]=m[3];return t})},
"277615c682": function _(t,a,n,r,e){r();const u=t("tslib"),o=u.__importStar(t("68ca94c15c")),i=u.__importStar(t("eb06fc032a")),s=u.__importStar(t("a427635f32"));function c(t,a,n){var r=.5*n[0],e=.5*n[1],u=.5*n[2],o=a[0],i=a[1],s=a[2],c=a[3];return t[0]=o,t[1]=i,t[2]=s,t[3]=c,t[4]=r*c+e*s-u*i,t[5]=e*c+u*o-r*s,t[6]=u*c+r*i-e*o,t[7]=-r*o-e*i-u*s,t}function h(t,a){return t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[3],t[4]=a[4],t[5]=a[5],t[6]=a[6],t[7]=a[7],t}function f(t,a,n){var r=a[0],e=a[1],u=a[2],o=a[3],i=n[4],s=n[5],c=n[6],h=n[7],f=a[4],M=a[5],b=a[6],l=a[7],v=n[0],m=n[1],R=n[2],A=n[3];return t[0]=r*A+o*v+e*R-u*m,t[1]=e*A+o*m+u*v-r*R,t[2]=u*A+o*R+r*m-e*v,t[3]=o*A-r*v-e*m-u*R,t[4]=r*h+o*i+e*c-u*s+f*A+l*v+M*R-b*m,t[5]=e*h+o*s+u*i-r*c+M*A+l*m+b*v-f*R,t[6]=u*h+o*c+r*s-e*i+b*A+l*R+f*m-M*v,t[7]=o*h-r*i-e*s-u*c+l*A-f*v-M*m-b*R,t}n.create=function(){var t=new o.ARRAY_TYPE(8);return o.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0),t[3]=1,t},n.clone=function(t){var a=new o.ARRAY_TYPE(8);return a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=t[3],a[4]=t[4],a[5]=t[5],a[6]=t[6],a[7]=t[7],a},n.fromValues=function(t,a,n,r,e,u,i,s){var c=new o.ARRAY_TYPE(8);return c[0]=t,c[1]=a,c[2]=n,c[3]=r,c[4]=e,c[5]=u,c[6]=i,c[7]=s,c},n.fromRotationTranslationValues=function(t,a,n,r,e,u,i){var s=new o.ARRAY_TYPE(8);s[0]=t,s[1]=a,s[2]=n,s[3]=r;var c=.5*e,h=.5*u,f=.5*i;return s[4]=c*r+h*n-f*a,s[5]=h*r+f*t-c*n,s[6]=f*r+c*a-h*t,s[7]=-c*t-h*a-f*n,s},n.fromRotationTranslation=c,n.fromTranslation=function(t,a){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t[4]=.5*a[0],t[5]=.5*a[1],t[6]=.5*a[2],t[7]=0,t},n.fromRotation=function(t,a){return t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[3],t[4]=0,t[5]=0,t[6]=0,t[7]=0,t},n.fromMat4=function(t,a){var n=i.create();s.getRotation(n,a);var r=new o.ARRAY_TYPE(3);return s.getTranslation(r,a),c(t,n,r),t},n.copy=h,n.identity=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t},n.set=function(t,a,n,r,e,u,o,i,s){return t[0]=a,t[1]=n,t[2]=r,t[3]=e,t[4]=u,t[5]=o,t[6]=i,t[7]=s,t},n.getReal=i.copy,n.getDual=function(t,a){return t[0]=a[4],t[1]=a[5],t[2]=a[6],t[3]=a[7],t},n.setReal=i.copy,n.setDual=function(t,a){return t[4]=a[0],t[5]=a[1],t[6]=a[2],t[7]=a[3],t},n.getTranslation=function(t,a){var n=a[4],r=a[5],e=a[6],u=a[7],o=-a[0],i=-a[1],s=-a[2],c=a[3];return t[0]=2*(n*c+u*o+r*s-e*i),t[1]=2*(r*c+u*i+e*o-n*s),t[2]=2*(e*c+u*s+n*i-r*o),t},n.translate=function(t,a,n){var r=a[0],e=a[1],u=a[2],o=a[3],i=.5*n[0],s=.5*n[1],c=.5*n[2],h=a[4],f=a[5],M=a[6],b=a[7];return t[0]=r,t[1]=e,t[2]=u,t[3]=o,t[4]=o*i+e*c-u*s+h,t[5]=o*s+u*i-r*c+f,t[6]=o*c+r*s-e*i+M,t[7]=-r*i-e*s-u*c+b,t},n.rotateX=function(t,a,n){var r=-a[0],e=-a[1],u=-a[2],o=a[3],s=a[4],c=a[5],h=a[6],f=a[7],M=s*o+f*r+c*u-h*e,b=c*o+f*e+h*r-s*u,l=h*o+f*u+s*e-c*r,v=f*o-s*r-c*e-h*u;return i.rotateX(t,a,n),r=t[0],e=t[1],u=t[2],o=t[3],t[4]=M*o+v*r+b*u-l*e,t[5]=b*o+v*e+l*r-M*u,t[6]=l*o+v*u+M*e-b*r,t[7]=v*o-M*r-b*e-l*u,t},n.rotateY=function(t,a,n){var r=-a[0],e=-a[1],u=-a[2],o=a[3],s=a[4],c=a[5],h=a[6],f=a[7],M=s*o+f*r+c*u-h*e,b=c*o+f*e+h*r-s*u,l=h*o+f*u+s*e-c*r,v=f*o-s*r-c*e-h*u;return i.rotateY(t,a,n),r=t[0],e=t[1],u=t[2],o=t[3],t[4]=M*o+v*r+b*u-l*e,t[5]=b*o+v*e+l*r-M*u,t[6]=l*o+v*u+M*e-b*r,t[7]=v*o-M*r-b*e-l*u,t},n.rotateZ=function(t,a,n){var r=-a[0],e=-a[1],u=-a[2],o=a[3],s=a[4],c=a[5],h=a[6],f=a[7],M=s*o+f*r+c*u-h*e,b=c*o+f*e+h*r-s*u,l=h*o+f*u+s*e-c*r,v=f*o-s*r-c*e-h*u;return i.rotateZ(t,a,n),r=t[0],e=t[1],u=t[2],o=t[3],t[4]=M*o+v*r+b*u-l*e,t[5]=b*o+v*e+l*r-M*u,t[6]=l*o+v*u+M*e-b*r,t[7]=v*o-M*r-b*e-l*u,t},n.rotateByQuatAppend=function(t,a,n){var r=n[0],e=n[1],u=n[2],o=n[3],i=a[0],s=a[1],c=a[2],h=a[3];return t[0]=i*o+h*r+s*u-c*e,t[1]=s*o+h*e+c*r-i*u,t[2]=c*o+h*u+i*e-s*r,t[3]=h*o-i*r-s*e-c*u,i=a[4],s=a[5],c=a[6],h=a[7],t[4]=i*o+h*r+s*u-c*e,t[5]=s*o+h*e+c*r-i*u,t[6]=c*o+h*u+i*e-s*r,t[7]=h*o-i*r-s*e-c*u,t},n.rotateByQuatPrepend=function(t,a,n){var r=a[0],e=a[1],u=a[2],o=a[3],i=n[0],s=n[1],c=n[2],h=n[3];return t[0]=r*h+o*i+e*c-u*s,t[1]=e*h+o*s+u*i-r*c,t[2]=u*h+o*c+r*s-e*i,t[3]=o*h-r*i-e*s-u*c,i=n[4],s=n[5],c=n[6],h=n[7],t[4]=r*h+o*i+e*c-u*s,t[5]=e*h+o*s+u*i-r*c,t[6]=u*h+o*c+r*s-e*i,t[7]=o*h-r*i-e*s-u*c,t},n.rotateAroundAxis=function(t,a,n,r){if(Math.abs(r)<o.EPSILON)return h(t,a);var e=Math.hypot(n[0],n[1],n[2]);r*=.5;var u=Math.sin(r),i=u*n[0]/e,s=u*n[1]/e,c=u*n[2]/e,f=Math.cos(r),M=a[0],b=a[1],l=a[2],v=a[3];t[0]=M*f+v*i+b*c-l*s,t[1]=b*f+v*s+l*i-M*c,t[2]=l*f+v*c+M*s-b*i,t[3]=v*f-M*i-b*s-l*c;var m=a[4],R=a[5],A=a[6],E=a[7];return t[4]=m*f+E*i+R*c-A*s,t[5]=R*f+E*s+A*i-m*c,t[6]=A*f+E*c+m*s-R*i,t[7]=E*f-m*i-R*s-A*c,t},n.add=function(t,a,n){return t[0]=a[0]+n[0],t[1]=a[1]+n[1],t[2]=a[2]+n[2],t[3]=a[3]+n[3],t[4]=a[4]+n[4],t[5]=a[5]+n[5],t[6]=a[6]+n[6],t[7]=a[7]+n[7],t},n.multiply=f,n.mul=f,n.scale=function(t,a,n){return t[0]=a[0]*n,t[1]=a[1]*n,t[2]=a[2]*n,t[3]=a[3]*n,t[4]=a[4]*n,t[5]=a[5]*n,t[6]=a[6]*n,t[7]=a[7]*n,t},n.dot=i.dot,n.lerp=function(t,a,r,e){var u=1-e;return(0,n.dot)(a,r)<0&&(e=-e),t[0]=a[0]*u+r[0]*e,t[1]=a[1]*u+r[1]*e,t[2]=a[2]*u+r[2]*e,t[3]=a[3]*u+r[3]*e,t[4]=a[4]*u+r[4]*e,t[5]=a[5]*u+r[5]*e,t[6]=a[6]*u+r[6]*e,t[7]=a[7]*u+r[7]*e,t},n.invert=function(t,a){var r=(0,n.squaredLength)(a);return t[0]=-a[0]/r,t[1]=-a[1]/r,t[2]=-a[2]/r,t[3]=a[3]/r,t[4]=-a[4]/r,t[5]=-a[5]/r,t[6]=-a[6]/r,t[7]=a[7]/r,t},n.conjugate=function(t,a){return t[0]=-a[0],t[1]=-a[1],t[2]=-a[2],t[3]=a[3],t[4]=-a[4],t[5]=-a[5],t[6]=-a[6],t[7]=a[7],t},n.length=i.length,n.len=n.length,n.squaredLength=i.squaredLength,n.sqrLen=n.squaredLength,n.normalize=function(t,a){var r=(0,n.squaredLength)(a);if(r>0){r=Math.sqrt(r);var e=a[0]/r,u=a[1]/r,o=a[2]/r,i=a[3]/r,s=a[4],c=a[5],h=a[6],f=a[7],M=e*s+u*c+o*h+i*f;t[0]=e,t[1]=u,t[2]=o,t[3]=i,t[4]=(s-e*M)/r,t[5]=(c-u*M)/r,t[6]=(h-o*M)/r,t[7]=(f-i*M)/r}return t},n.str=function(t){return"quat2("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+")"},n.exactEquals=function(t,a){return t[0]===a[0]&&t[1]===a[1]&&t[2]===a[2]&&t[3]===a[3]&&t[4]===a[4]&&t[5]===a[5]&&t[6]===a[6]&&t[7]===a[7]},n.equals=function(t,a){var n=t[0],r=t[1],e=t[2],u=t[3],i=t[4],s=t[5],c=t[6],h=t[7],f=a[0],M=a[1],b=a[2],l=a[3],v=a[4],m=a[5],R=a[6],A=a[7];return Math.abs(n-f)<=o.EPSILON*Math.max(1,Math.abs(n),Math.abs(f))&&Math.abs(r-M)<=o.EPSILON*Math.max(1,Math.abs(r),Math.abs(M))&&Math.abs(e-b)<=o.EPSILON*Math.max(1,Math.abs(e),Math.abs(b))&&Math.abs(u-l)<=o.EPSILON*Math.max(1,Math.abs(u),Math.abs(l))&&Math.abs(i-v)<=o.EPSILON*Math.max(1,Math.abs(i),Math.abs(v))&&Math.abs(s-m)<=o.EPSILON*Math.max(1,Math.abs(s),Math.abs(m))&&Math.abs(c-R)<=o.EPSILON*Math.max(1,Math.abs(c),Math.abs(R))&&Math.abs(h-A)<=o.EPSILON*Math.max(1,Math.abs(h),Math.abs(A))}},
"c56d9ff837": function _(n,t,r,a,u){a();const e=n("tslib").__importStar(n("68ca94c15c"));function o(){var n=new e.ARRAY_TYPE(2);return e.ARRAY_TYPE!=Float32Array&&(n[0]=0,n[1]=0),n}function c(n,t,r){return n[0]=t[0]-r[0],n[1]=t[1]-r[1],n}function i(n,t,r){return n[0]=t[0]*r[0],n[1]=t[1]*r[1],n}function f(n,t,r){return n[0]=t[0]/r[0],n[1]=t[1]/r[1],n}function s(n,t){var r=t[0]-n[0],a=t[1]-n[1];return Math.hypot(r,a)}function h(n,t){var r=t[0]-n[0],a=t[1]-n[1];return r*r+a*a}function M(n){var t=n[0],r=n[1];return Math.hypot(t,r)}function l(n){var t=n[0],r=n[1];return t*t+r*r}var v;r.create=o,r.clone=function(n){var t=new e.ARRAY_TYPE(2);return t[0]=n[0],t[1]=n[1],t},r.fromValues=function(n,t){var r=new e.ARRAY_TYPE(2);return r[0]=n,r[1]=t,r},r.copy=function(n,t){return n[0]=t[0],n[1]=t[1],n},r.set=function(n,t,r){return n[0]=t,n[1]=r,n},r.add=function(n,t,r){return n[0]=t[0]+r[0],n[1]=t[1]+r[1],n},r.subtract=c,r.multiply=i,r.divide=f,r.ceil=function(n,t){return n[0]=Math.ceil(t[0]),n[1]=Math.ceil(t[1]),n},r.floor=function(n,t){return n[0]=Math.floor(t[0]),n[1]=Math.floor(t[1]),n},r.min=function(n,t,r){return n[0]=Math.min(t[0],r[0]),n[1]=Math.min(t[1],r[1]),n},r.max=function(n,t,r){return n[0]=Math.max(t[0],r[0]),n[1]=Math.max(t[1],r[1]),n},r.round=function(n,t){return n[0]=Math.round(t[0]),n[1]=Math.round(t[1]),n},r.scale=function(n,t,r){return n[0]=t[0]*r,n[1]=t[1]*r,n},r.scaleAndAdd=function(n,t,r,a){return n[0]=t[0]+r[0]*a,n[1]=t[1]+r[1]*a,n},r.distance=s,r.squaredDistance=h,r.length=M,r.squaredLength=l,r.negate=function(n,t){return n[0]=-t[0],n[1]=-t[1],n},r.inverse=function(n,t){return n[0]=1/t[0],n[1]=1/t[1],n},r.normalize=function(n,t){var r=t[0],a=t[1],u=r*r+a*a;return u>0&&(u=1/Math.sqrt(u)),n[0]=t[0]*u,n[1]=t[1]*u,n},r.dot=function(n,t){return n[0]*t[0]+n[1]*t[1]},r.cross=function(n,t,r){var a=t[0]*r[1]-t[1]*r[0];return n[0]=n[1]=0,n[2]=a,n},r.lerp=function(n,t,r,a){var u=t[0],e=t[1];return n[0]=u+a*(r[0]-u),n[1]=e+a*(r[1]-e),n},r.random=function(n,t){t=t||1;var r=2*e.RANDOM()*Math.PI;return n[0]=Math.cos(r)*t,n[1]=Math.sin(r)*t,n},r.transformMat2=function(n,t,r){var a=t[0],u=t[1];return n[0]=r[0]*a+r[2]*u,n[1]=r[1]*a+r[3]*u,n},r.transformMat2d=function(n,t,r){var a=t[0],u=t[1];return n[0]=r[0]*a+r[2]*u+r[4],n[1]=r[1]*a+r[3]*u+r[5],n},r.transformMat3=function(n,t,r){var a=t[0],u=t[1];return n[0]=r[0]*a+r[3]*u+r[6],n[1]=r[1]*a+r[4]*u+r[7],n},r.transformMat4=function(n,t,r){var a=t[0],u=t[1];return n[0]=r[0]*a+r[4]*u+r[12],n[1]=r[1]*a+r[5]*u+r[13],n},r.rotate=function(n,t,r,a){var u=t[0]-r[0],e=t[1]-r[1],o=Math.sin(a),c=Math.cos(a);return n[0]=u*c-e*o+r[0],n[1]=u*o+e*c+r[1],n},r.angle=function(n,t){var r=n[0],a=n[1],u=t[0],e=t[1],o=Math.sqrt(r*r+a*a)*Math.sqrt(u*u+e*e),c=o&&(r*u+a*e)/o;return Math.acos(Math.min(Math.max(c,-1),1))},r.zero=function(n){return n[0]=0,n[1]=0,n},r.str=function(n){return"vec2("+n[0]+", "+n[1]+")"},r.exactEquals=function(n,t){return n[0]===t[0]&&n[1]===t[1]},r.equals=function(n,t){var r=n[0],a=n[1],u=t[0],o=t[1];return Math.abs(r-u)<=e.EPSILON*Math.max(1,Math.abs(r),Math.abs(u))&&Math.abs(a-o)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(o))},r.len=M,r.sub=c,r.mul=i,r.div=f,r.dist=s,r.sqrDist=h,r.sqrLen=l,r.forEach=(v=o(),function(n,t,r,a,u,e){var o,c;for(t||(t=2),r||(r=0),c=a?Math.min(a*t+r,n.length):n.length,o=r;o<c;o+=t)v[0]=n[o],v[1]=n[o+1],u(v,v,e),n[o]=v[0],n[o+1]=v[1];return n})},
"9cb70c6ab6": function _(e,t,i,s,n){var r;s();const o=e("1de1ccb7ff"),a=e("a76a9b7c23");class l extends o.AbstractVTKView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.data.change,(()=>{this._vtk_image_data=(0,a.data2VTKImageData)(this.model.data),this.invalidate_render()})),this.connect(this.model.properties.colormap.change,(()=>{this.colormap_selector.value=this.model.colormap;const e=new Event("change");this.colormap_selector.dispatchEvent(e)})),this.connect(this.model.properties.shadow.change,(()=>{this.shadow_selector.value=this.model.shadow?"1":"0";const e=new Event("change");this.shadow_selector.dispatchEvent(e)})),this.connect(this.model.properties.sampling.change,(()=>{this.sampling_slider.value=this.model.sampling.toFixed(2);const e=new Event("input");this.sampling_slider.dispatchEvent(e)})),this.connect(this.model.properties.edge_gradient.change,(()=>{this.edge_gradient_slider.value=this.model.edge_gradient.toFixed(2);const e=new Event("input");this.edge_gradient_slider.dispatchEvent(e)})),this.connect(this.model.properties.rescale.change,(()=>{this._controllerWidget.setRescaleColorMap(this.model.rescale),this._vtk_renwin.getRenderWindow().render()})),this.connect(this.model.properties.ambient.change,(()=>{this.volume.getProperty().setAmbient(this.model.ambient),this._vtk_renwin.getRenderWindow().render()})),this.connect(this.model.properties.diffuse.change,(()=>{this.volume.getProperty().setDiffuse(this.model.diffuse),this._vtk_renwin.getRenderWindow().render()})),this.connect(this.model.properties.camera.change,(()=>{this._setting_camera||(this._set_camera_state(),this._vtk_renwin.getRenderWindow().render())})),this.connect(this.model.properties.specular.change,(()=>{this.volume.getProperty().setSpecular(this.model.specular),this._vtk_renwin.getRenderWindow().render()})),this.connect(this.model.properties.specular_power.change,(()=>{this.volume.getProperty().setSpecularPower(this.model.specular_power),this._vtk_renwin.getRenderWindow().render()})),this.connect(this.model.properties.display_volume.change,(()=>{this._set_volume_visibility(this.model.display_volume),this._vtk_renwin.getRenderWindow().render()})),this.connect(this.model.properties.display_slices.change,(()=>{this._set_slices_visibility(this.model.display_slices),this._vtk_renwin.getRenderWindow().render()})),this.connect(this.model.properties.slice_i.change,(()=>{void 0!==this.image_actor_i&&(this.image_actor_i.getMapper().setISlice(this.model.slice_i),this._vtk_renwin.getRenderWindow().render())})),this.connect(this.model.properties.slice_j.change,(()=>{void 0!==this.image_actor_j&&(this.image_actor_j.getMapper().setJSlice(this.model.slice_j),this._vtk_renwin.getRenderWindow().render())})),this.connect(this.model.properties.slice_k.change,(()=>{void 0!==this.image_actor_k&&(this.image_actor_k.getMapper().setKSlice(this.model.slice_k),this._vtk_renwin.getRenderWindow().render())})),this.connect(this.model.properties.render_background.change,(()=>{this._vtk_renwin.getRenderer().setBackground(...(0,a.hexToRGB)(this.model.render_background)),this._vtk_renwin.getRenderWindow().render()})),this.connect(this.model.properties.interpolation.change,(()=>{this._set_interpolation(this.model.interpolation),this._vtk_renwin.getRenderWindow().render()})),this.connect(this.model.properties.controller_expanded.change,(()=>{null!=this._controllerWidget&&this._controllerWidget.setExpanded(this.model.controller_expanded)})),this.connect(this.model.properties.nan_opacity.change,(()=>{const e=this.image_actor_i.getProperty().getScalarOpacity();e.get(["nodes"]).nodes[0].y=this.model.nan_opacity,e.modified(),this._vtk_renwin.getRenderWindow().render()}))}render(){this._vtk_renwin=null,this._orientationWidget=null,this._axes=null,super.render(),this._create_orientation_widget(),this._set_axes(),this._vtk_renwin.getRenderer().resetCamera(),Object.keys(this.model.camera).length&&this._set_camera_state(),this._get_camera_state()}invalidate_render(){this._vtk_renwin=null,super.invalidate_render()}init_vtk_renwin(){this._vtk_renwin=a.vtkns.FullScreenRenderWindow.newInstance({rootContainer:this.shadow_el,container:this._vtk_container})}plot(){this._controllerWidget=a.vtkns.VolumeController.newInstance({size:[400,150],rescaleColorMap:this.model.rescale}),this._plot_volume(),this._plot_slices(),this._controllerWidget.setupContent(this._vtk_renwin.getRenderWindow(),this.volume,!0),this._controllerWidget.setContainer(this.el),this._controllerWidget.setExpanded(this.model.controller_expanded),this._connect_js_controls(),this._vtk_renwin.getRenderWindow().getInteractor(),this._vtk_renwin.getRenderWindow().getInteractor().setDesiredUpdateRate(45),this._set_volume_visibility(this.model.display_volume),this._set_slices_visibility(this.model.display_slices),this._vtk_renwin.getRenderer().setBackground(...(0,a.hexToRGB)(this.model.render_background)),this._set_interpolation(this.model.interpolation),this._set_camera_state()}get vtk_image_data(){return this._vtk_image_data||(this._vtk_image_data=(0,a.data2VTKImageData)(this.model.data)),this._vtk_image_data}get volume(){return this._vtk_renwin.getRenderer().getVolumes()[0]}get image_actor_i(){return this._vtk_renwin.getRenderer().getActors()[0]}get image_actor_j(){return this._vtk_renwin.getRenderer().getActors()[1]}get image_actor_k(){return this._vtk_renwin.getRenderer().getActors()[2]}get shadow_selector(){return this.el.querySelector(".js-shadow")}get edge_gradient_slider(){return this.el.querySelector(".js-edge")}get sampling_slider(){return this.el.querySelector(".js-spacing")}get colormap_selector(){return this.el.querySelector(".js-color-preset")}_connect_js_controls(){const{el:e}=this._controllerWidget.get("el");if(void 0!==e){e.querySelector(".js-button").addEventListener("click",(()=>this.model.controller_expanded=this._controllerWidget.getExpanded()))}this.colormap_selector.addEventListener("change",(()=>{this.model.colormap=this.colormap_selector.value})),this.model.colormap?this.model.properties.colormap.change.emit():this.model.colormap=this.colormap_selector.value,this.shadow_selector.addEventListener("change",(()=>{this.model.shadow=!!Number(this.shadow_selector.value)})),(this.model.shadow=!!Number(this.shadow_selector.value))&&this.model.properties.shadow.change.emit(),this.sampling_slider.addEventListener("input",(()=>{const e=Number(this.sampling_slider.value);Math.abs(this.model.sampling-e)>=.005&&(this.model.sampling=e)})),Math.abs(this.model.sampling-Number(this.shadow_selector.value))>=.005&&this.model.properties.sampling.change.emit(),this.edge_gradient_slider.addEventListener("input",(()=>{const e=Number(this.edge_gradient_slider.value);Math.abs(this.model.edge_gradient-e)>=.005&&(this.model.edge_gradient=e)})),Math.abs(this.model.edge_gradient-Number(this.edge_gradient_slider.value))>=.005&&this.model.properties.edge_gradient.change.emit()}_plot_slices(){const e=this._vtk_image_data,t=a.vtkns.ImageSlice.newInstance(),i=a.vtkns.ImageSlice.newInstance(),s=a.vtkns.ImageSlice.newInstance(),n=a.vtkns.ImageMapper.newInstance(),r=a.vtkns.ImageMapper.newInstance(),o=a.vtkns.ImageMapper.newInstance();n.setInputData(e),n.setISlice(this.model.slice_i),t.setMapper(n),r.setInputData(e),r.setJSlice(this.model.slice_j),i.setMapper(r),o.setInputData(e),o.setKSlice(this.model.slice_k),s.setMapper(o);const l=a.vtkns.PiecewiseFunction.newInstance(),d=this.volume.getProperty().getRGBTransferFunction(0),c=this.volume.getMapper().getInputData().getPointData().getScalars().getRange();l.removeAllPoints(),l.addPoint(c[0]-1,this.model.nan_opacity),l.addPoint(c[0],1),l.addPoint(c[1],1);const h=t.getProperty();i.setProperty(h),s.setProperty(h),h.setRGBTransferFunction(d),h.setScalarOpacity(l);const _=this._vtk_renwin.getRenderer();_.addActor(t),_.addActor(i),_.addActor(s)}_plot_volume(){const e=this.vtk_image_data,t=a.vtkns.Volume.newInstance(),i=a.vtkns.VolumeMapper.newInstance();t.setMapper(i),i.setInputData(e);const s=(e.getPointData().getScalars()||e.getPointData().getArrays()[0]).getRange(),n=a.vtkns.ColorTransferFunction.newInstance();if(null!=this.model.colormap){const e=a.vtkns.ColorTransferFunction.vtkColorMaps.getPresetByName(this.model.colormap);n.applyColorMap(e)}n.onModified((()=>this.model.mapper=(0,a.vtkLutToMapper)(n)));const r=a.vtkns.PiecewiseFunction.newInstance(),o=.7*Math.sqrt(e.getSpacing().map((e=>e*e)).reduce(((e,t)=>e+t),0));i.setSampleDistance(o),t.getProperty().setRGBTransferFunction(0,n),t.getProperty().setScalarOpacity(0,r),t.getProperty().setInterpolationTypeToFastLinear(),t.getProperty().setScalarOpacityUnitDistance(0,a.vtkns.BoundingBox.getDiagonalLength(e.getBounds())/Math.max(...e.getDimensions())),t.getProperty().setGradientOpacityMinimumValue(0,0),t.getProperty().setGradientOpacityMaximumValue(0,.05*(s[1]-s[0])),t.getProperty().setShade(this.model.shadow),t.getProperty().setUseGradientOpacity(0,!0),t.getProperty().setGradientOpacityMinimumOpacity(0,0),t.getProperty().setGradientOpacityMaximumOpacity(0,1),t.getProperty().setAmbient(this.model.ambient),t.getProperty().setDiffuse(this.model.diffuse),t.getProperty().setSpecular(this.model.specular),t.getProperty().setSpecularPower(this.model.specular_power),this._vtk_renwin.getRenderer().addVolume(t)}_set_interpolation(e){"fast_linear"==e?(this.volume.getProperty().setInterpolationTypeToFastLinear(),this.image_actor_i.getProperty().setInterpolationTypeToLinear()):"linear"==e?(this.volume.getProperty().setInterpolationTypeToLinear(),this.image_actor_i.getProperty().setInterpolationTypeToLinear()):(this.volume.getProperty().setInterpolationTypeToNearest(),this.image_actor_i.getProperty().setInterpolationTypeToNearest())}_set_slices_visibility(e){this.image_actor_i.setVisibility(e),this.image_actor_j.setVisibility(e),this.image_actor_k.setVisibility(e)}_set_volume_visibility(e){this.volume.setVisibility(e)}}i.VTKVolumePlotView=l,l.__name__="VTKVolumePlotView";class d extends o.AbstractVTKPlot{constructor(e){super(e)}}i.VTKVolumePlot=d,r=d,d.__name__="VTKVolumePlot",r.prototype.default_view=l,r.define((({Any:e,Array:t,Boolean:i,Int:s,Number:n,String:r,Struct:o})=>({ambient:[n,.2],colormap:[r],data:[e],diffuse:[n,.7],display_slices:[i,!1],display_volume:[i,!0],edge_gradient:[n,.2],interpolation:[a.Interpolation,"fast_linear"],mapper:[o({palette:t(r),low:n,high:n}),{palette:[],low:0,high:0}],nan_opacity:[n,1],render_background:[r,"#52576e"],rescale:[i,!1],sampling:[n,.4],shadow:[i,!0],slice_i:[s,0],slice_j:[s,0],slice_k:[s,0],specular:[n,.3],specular_power:[n,8],controller_expanded:[i,!0]}))),r.override({height:300,width:300})},
"66775d6392": function _(e,t,n,i,r){var s;i();const o=e("@bokehjs/core/util/object"),_=e("99a25e6992"),c=e("1de1ccb7ff"),a=e("877619fe71"),h=e("a76a9b7c23"),d="panel";class l extends c.AbstractVTKView{initialize(){super.initialize(),this._renderable=!1,this._synchronizer_context=h.vtkns.SynchronizableRenderWindow.getSynchronizerContext(`${d}-{this.model.id}`)}connect_signals(){super.connect_signals();const e=(0,_.debounce)((()=>{this._vtk_renwin.delete(),this._vtk_renwin=null,this.invalidate_render()}),20);this.connect(this.model.properties.arrays.change,e),this.connect(this.model.properties.scene.change,e),this.connect(this.model.properties.one_time_reset.change,(()=>{this._vtk_renwin.getRenderWindow().clearOneTimeUpdaters()}))}init_vtk_renwin(){this._vtk_renwin=h.vtkns.FullScreenRenderWindowSynchronized.newInstance({rootContainer:this.el,container:this._vtk_container,synchronizerContext:this._synchronizer_context})}remove(){this._vtk_renwin&&this._vtk_renwin.delete(),super.remove()}plot(){this._vtk_renwin.getRenderWindow().clearOneTimeUpdaters();const e=(0,o.clone)(this.model.scene);this._sync_plot(e,(()=>this._on_scene_ready())).then((()=>{this._set_camera_state(),this._get_camera_state()}))}_on_scene_ready(){this._renderable=!0,this._camera_callbacks.push(this._vtk_renwin.getRenderer().getActiveCamera().onModified((()=>this._vtk_render()))),this._orientationWidget||this._create_orientation_widget(),this._axes||this._set_axes(),this._vtk_renwin.resize(),this._vtk_render()}_sync_plot(e,t){this._renderable=!1,this._unsubscribe_camera_cb(),this._synchronizer_context.setFetchArrayFunction((e=>Promise.resolve(this.model.arrays[e])));const n=this._synchronizer_context.getInstance(this.model.scene.dependencies[0].id);return n&&!this._vtk_renwin.getRenderer()&&this._vtk_renwin.getRenderWindow().addRenderer(n),this._vtk_renwin.getRenderWindow().synchronize(e).then(t)}}n.VTKSynchronizedPlotView=l,l.__name__="VTKSynchronizedPlotView";class v extends c.AbstractVTKPlot{constructor(e){super(e),(0,a.initialize_fullscreen_render)(),this.outline=h.vtkns.OutlineFilter.newInstance();const t=h.vtkns.Mapper.newInstance();t.setInputConnection(this.outline.getOutputPort()),this.outline_actor=h.vtkns.Actor.newInstance(),this.outline_actor.setMapper(t)}getActors(e){let t=this.renderer_el.getRenderer().getActors();if(e){const n=this.renderer_el.getSynchronizerContext(d);t=t.filter((t=>{const i=n.getInstanceId(t);return!!i&&i.slice(-16)==e.slice(1,17)}))}return t}}n.VTKSynchronizedPlot=v,s=v,v.__name__="VTKSynchronizedPlot",v.__module__="panel.models.vtk",s.prototype.default_view=l,s.define((({Any:e,Array:t,Boolean:n,Bytes:i,Dict:r,String:s})=>({arrays:[r(i),{}],arrays_processed:[t(s),[]],enable_keybindings:[n,!1],one_time_reset:[n,!1],rebuild:[n,!1],scene:[e,{}]}))),s.override({height:300,width:300})},
"877619fe71": function _(e,n,o,t,r){t();const i=e("a76a9b7c23"),l={containerStyle:null,controlPanelStyle:null,listenWindowResize:!0,resizeCallback:null,controllerVisibility:!0,synchronizerContextName:"default"},a={position:"absolute",left:"25px",top:"25px",backgroundColor:"white",borderRadius:"5px",listStyle:"none",padding:"5px 10px",margin:"0",display:"block",border:"solid 1px black",maxWidth:"calc(100vw - 70px)",maxHeight:"calc(100vh - 60px)",overflow:"auto"};o.initialize_fullscreen_render=function(){let e={newInstance:window.vtk.macro.newInstance(((e,n,o={})=>{Object.assign(n,l,o),window.vtk.macro.obj(e,n),window.vtk.macro.get(e,n,["renderWindow","openGLRenderWindow","interactor","rootContainer","container","controlContainer","synchronizerContext"]),function(e,n){n.renderWindow=i.vtkns.SynchronizableRenderWindow.newInstance({synchronizerContext:n.synchronizerContext}),n.openGLRenderWindow=i.vtkns.OpenGLRenderWindow.newInstance(),n.openGLRenderWindow.setContainer(n.container),n.renderWindow.addView(n.openGLRenderWindow),n.interactor=i.vtkns.RenderWindowInteractor.newInstance(),n.interactor.setInteractorStyle(i.vtkns.InteractorStyleTrackballCamera.newInstance()),n.interactor.setView(n.openGLRenderWindow),n.interactor.initialize(),n.interactor.bindEvents(n.container),e.getRenderer=()=>n.renderWindow.getRenderers()[0],e.removeController=()=>{const e=n.controlContainer;e&&e.parentNode.removeChild(e)},e.setControllerVisibility=e=>{n.controllerVisibility=e,n.controlContainer&&(n.controlContainer.style.display=e?"block":"none")},e.toggleControllerVisibility=()=>{e.setControllerVisibility(!n.controllerVisibility)},e.addController=o=>{n.controlContainer=document.createElement("div"),(0,i.applyStyle)(n.controlContainer,n.controlPanelStyle||a),n.rootContainer.appendChild(n.controlContainer),n.controlContainer.innerHTML=o,e.setControllerVisibility(n.controllerVisibility),n.rootContainer.addEventListener("keypress",(n=>{"c"===String.fromCharCode(n.charCode)&&e.toggleControllerVisibility()}))},e.delete=window.vtk.macro.chain(e.setContainer,n.openGLRenderWindow.delete,e.delete),e.resize=()=>{const e=n.container.getBoundingClientRect(),o=window.devicePixelRatio||1;n.openGLRenderWindow.setSize(Math.floor(e.width*o),Math.floor(e.height*o)),n.resizeCallback&&n.resizeCallback(e),n.renderWindow.render()},e.setResizeCallback=o=>{n.resizeCallback=o,e.resize()},n.listenWindowResize&&window.addEventListener("resize",e.resize),e.resize()}(e,n)}))};i.vtkns.FullScreenRenderWindowSynchronized=e}},
}, "4e90918c0a", {"index":"4e90918c0a","models/index":"25913cabc4","models/ace":"464e3dc85c","models/layout":"c64c1219c8","models/audio":"d8d3afec63","models/browser":"af84f1061d","models/button":"0e384ee9c4","models/card":"eec4af24bc","models/column":"991bd33955","models/checkbox_button_group":"820473477c","models/comm_manager":"eca6f2cacb","models/customselect":"e258e515be","models/tabulator":"1629ba0343","models/data":"4e27eda472","models/datetime_picker":"5fd6501095","models/deckgl":"19b5a68a40","models/tooltips":"9588ab7c9e","models/echarts":"44fa3f3649","models/event-to-object":"490942d778","models/file_download":"e6943b23b3","models/html":"3db2e41978","models/ipywidget":"4dfd782539","models/json":"e954d48822","models/jsoneditor":"3c56a75fcf","models/katex":"001dfd2dde","models/location":"a85ed38ee9","models/mathjax":"ca760ebc92","models/pdf":"46cccf2270","models/perspective":"5f38562b04","models/player":"bd5015f776","models/plotly":"b6febc7d6f","models/util":"990b5dd5c7","models/progress":"e6caa5bc95","models/quill":"283ee868b0","models/radio_button_group":"81e6ca704a","models/reactive_html":"0590cf2a27","models/singleselect":"665213fba5","models/speech_to_text":"7651136c44","models/state":"1bb5a1aca6","models/tabs":"8013e805da","models/terminal":"4a0674b147","models/textarea_input":"59f46adc8c","models/text_to_speech":"a44f0bd49f","models/tooltip_icon":"4c6dd3d1dc","models/trend":"c2c4524e04","models/vega":"b396729d22","models/video":"e6e8c94f32","models/videostream":"2dfabe6882","models/vizzu":"dfe3c4a2a9","models/vtk/index":"c51f25e2a7","models/vtk/vtkjs":"173e6cb054","models/vtk/vtklayout":"1de1ccb7ff","models/vtk/util":"a76a9b7c23","models/vtk/vtkcolorbar":"c010237f8b","models/vtk/vtkaxes":"5a606f3f35","models/vtk/vtkvolume":"9cb70c6ab6","models/vtk/vtksynchronized":"66775d6392","models/vtk/panel_fullscreen_renwin_sync":"877619fe71"}, {});});
