"""Test relational expressions
"""

import unittest, datetime
from pyorq.interface.nodb import nodb
from pyorq import *
from pyorq.prel import *

db = nodb()
class A(pobject):
    database = db
    a = pint()
    b = pfloat()
    c = pstr()
    d = pdate()
    e = ptime()
    f = pdatetime()

class B(pobject):
    database = db
    b = pref(A)
    
class C(object):
    database = db
    c1 = pref(B)
    c1.name = 'c1'
    c2 = pref(B)
    c2.name = 'c2'

class test_simple(unittest.TestCase):
    def test_comp_eq(self):
        q = (A.a == 1)
        self.failUnless(q.free_variable() is A)
        self.failUnless(isinstance(q, comp_eq))
    def test_comp_ne(self):
        q = (A.a != 1)
        self.failUnless(q.free_variable() is A)
        self.failUnless(isinstance(q, comp_ne))
    def test_comp_ge(self):
        q = (A.a >= 1)
        self.failUnless(q.free_variable() is A)
        self.failUnless(isinstance(q, comp_ge))
    def test_comp_le(self):
        q = (A.a <= 1)
        self.failUnless(q.free_variable() is A)
        self.failUnless(isinstance(q, comp_le))
    def test_comp_gt(self):
        q = (A.a > 1)
        self.failUnless(q.free_variable() is A)
        self.failUnless(isinstance(q, comp_gt))
    def test_comp_lt(self):
        q = (A.a < 1)
        self.failUnless(q.free_variable() is A)
        self.failUnless(isinstance(q, comp_lt))

    def test_arith_add(self):
        q = (A.a+1 < 1)
        self.failUnless(q.free_variable() is A)
        self.failUnless(isinstance(q, comp_lt))
        self.failUnless(isinstance(q.lhs, expr_add))
    def test_arith_sub(self):
        q = (A.a-1 < 1)
        self.failUnless(q.free_variable() is A)
        self.failUnless(isinstance(q, comp_lt))
        self.failUnless(isinstance(q.lhs, expr_sub))
    def test_arith_mul(self):
        q = (A.a*2 < 1)
        self.failUnless(q.free_variable() is A)
        self.failUnless(isinstance(q, comp_lt))
        self.failUnless(isinstance(q.lhs, expr_mul))
    def test_arith_div(self):
        q = (A.a/2 < 1)
        self.failUnless(q.free_variable() is A)
        self.failUnless(isinstance(q, comp_lt))
        self.failUnless(isinstance(q.lhs, expr_div))
    def test_arith_neg(self):
        q = (-A.a < 1)
        self.failUnless(q.free_variable() is A)
        self.failUnless(isinstance(q, comp_lt))
        self.failUnless(isinstance(q.lhs, expr_neg))

    def test_and(self):
        q = (A.a == 1) & (A.b == 2.0)
        self.failUnless(q.free_variable() is A)
        self.failUnless(isinstance(q, rel_and))
    def test_or(self):
        q = (A.a == 1) | (A.b == 2.0)
        self.failUnless(q.free_variable() is A)
        self.failUnless(isinstance(q, rel_or))
    def test_not(self):
        q = ~(A.a == 1)
        self.failUnless(q.free_variable() is A)
        self.failUnless(isinstance(q, rel_not))
       
    def test_ref1(self):
        q = (B.b.a == 1)
        self.failUnless(q.free_variable() is B)
        self.failUnless(isinstance(q.lhs, value_attr))
        self.failUnless(isinstance(q.lhs.parent, ref_attr))
        self.failUnless(isinstance(q.rhs, value))

    def test_ref2(self):
        a = A()
        q = (B.b == a)
        self.failUnless(isinstance(q, comp_is))
        
class test_bad(unittest.TestCase):
    def test_bad_add(self):
        q = "(A.a == 1) & (B.b.b == 2.0)"
        self.failUnlessRaises(ValueError, eval, q, locals(), globals())
            
class test_expressions(unittest.TestCase):   
    def test_ref_eq(self):
        e = B.b.a == 1
        self.failUnless(isinstance(e, comp_eq))
        self.failUnless(e.free_variable() is B)
        b = {}
        e.update_bound_variables(b)
        self.failUnlessEqual(b, {('_x','b'):A})
    def test_ref_ne(self):
        e = B.b.a != 1
        self.failUnless(isinstance(e, comp_ne))
        self.failUnless(e.free_variable() is B)
        b = {}
        e.update_bound_variables(b)
        self.failUnlessEqual(b, {('_x','b'):A})
    def test_ref_ge(self):
        e = B.b.a >= 1
        self.failUnless(isinstance(e, comp_ge))
        self.failUnless(e.free_variable() is B)
        b = {}
        e.update_bound_variables(b)
        self.failUnlessEqual(b, {('_x','b'):A})
    def test_ref_gt(self):
        e = B.b.a > 1
        self.failUnless(isinstance(e, comp_gt))
        self.failUnless(e.free_variable() is B)
        b = {}
        e.update_bound_variables(b)
        self.failUnlessEqual(b, {('_x','b'):A})
    def test_ref_le(self):
        e = B.b.a <= 1
        self.failUnless(isinstance(e, comp_le))
        self.failUnless(e.free_variable() is B)
        b = {}
        e.update_bound_variables(b)
        self.failUnlessEqual(b, {('_x','b'):A})
    def test_ref_lt(self):
        e = B.b.a < 1
        self.failUnless(isinstance(e, comp_lt))
        self.failUnless(e.free_variable() is B)
        b = {}
        e.update_bound_variables(b)
        self.failUnlessEqual(b, {('_x','b'):A})
        
    def test_nested_eq(self):
        e = C.c1.b.a == 1
        self.failUnless(isinstance(e, comp_eq))
        self.failUnless(e.free_variable() is C)
        b = {}
        e.update_bound_variables(b)
        self.failUnlessEqual(b, {('_x', 'c1', 'b'):A, ('_x', 'c1'): B})
    def test_nested_ne(self):
        e = C.c1.b.a != 1
        self.failUnless(isinstance(e, comp_ne))
        self.failUnless(e.free_variable() is C)
        b = {}
        e.update_bound_variables(b)
        self.failUnlessEqual(b, {('_x', 'c1', 'b'):A, ('_x', 'c1'):B})
    def test_nested_ge(self):
        e = C.c1.b.a >= 1
        self.failUnless(isinstance(e, comp_ge))
        self.failUnless(e.free_variable() is C)
        b = {}
        e.update_bound_variables(b)
        self.failUnlessEqual(b, {('_x', 'c1', 'b'):A, ('_x', 'c1'):B})
    def test_nested_gt(self):
        e = C.c1.b.a > 1
        self.failUnless(isinstance(e, comp_gt))
        self.failUnless(e.free_variable() is C)
        b = {}
        e.update_bound_variables(b)
        self.failUnlessEqual(b, {('_x', 'c1', 'b'):A, ('_x', 'c1'):B})
    def test_nested_le(self):
        e = C.c1.b.a <= 1
        self.failUnless(isinstance(e, comp_le))
        self.failUnless(e.free_variable() is C)
        b = {}
        e.update_bound_variables(b)
        self.failUnlessEqual(b, {('_x', 'c1', 'b'):A, ('_x', 'c1'):B})
    def test_nested_lt(self):
        e = C.c1.b.a < 1
        self.failUnless(isinstance(e, comp_lt))
        self.failUnless(e.free_variable() is C)
        b = {}
        e.update_bound_variables(b)
        self.failUnlessEqual(b, {('_x', 'c1', 'b'):A, ('_x', 'c1'):B})
    
    def test_parallel_nested_and(self):
        e = (C.c1.b.a < 1) & (C.c2.b.a > 2)
        self.failUnless(isinstance(e, rel_and))
        self.failUnless(e.free_variable() is C)
        b = {}
        e.update_bound_variables(b)
        self.failUnlessEqual(b, {('_x', 'c1', 'b'):A, ('_x', 'c1'):B,
                                 ('_x', 'c2', 'b'):A, ('_x', 'c2'):B})

if __name__ == '__main__':
    unittest.main()
