# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210215

from .host_scan_agent_configuration import HostScanAgentConfiguration
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostScanAgentConfigurationQualys(HostScanAgentConfiguration):
    """
    Agent configuration options for vendor Qualys.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HostScanAgentConfigurationQualys object with values from keyword arguments. The default value of the :py:attr:`~oci.vulnerability_scanning.models.HostScanAgentConfigurationQualys.vendor` attribute
        of this class is ``QUALYS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vendor:
            The value to assign to the vendor property of this HostScanAgentConfigurationQualys.
            Allowed values for this property are: "OCI", "QUALYS"
        :type vendor: str

        :param vendor_type:
            The value to assign to the vendor_type property of this HostScanAgentConfigurationQualys.
            Allowed values for this property are: "OCI", "QUALYS"
        :type vendor_type: str

        :param vault_secret_id:
            The value to assign to the vault_secret_id property of this HostScanAgentConfigurationQualys.
        :type vault_secret_id: str

        :param should_un_install:
            The value to assign to the should_un_install property of this HostScanAgentConfigurationQualys.
        :type should_un_install: bool

        """
        self.swagger_types = {
            'vendor': 'str',
            'vendor_type': 'str',
            'vault_secret_id': 'str',
            'should_un_install': 'bool'
        }

        self.attribute_map = {
            'vendor': 'vendor',
            'vendor_type': 'vendorType',
            'vault_secret_id': 'vaultSecretId',
            'should_un_install': 'shouldUnInstall'
        }

        self._vendor = None
        self._vendor_type = None
        self._vault_secret_id = None
        self._should_un_install = None
        self._vendor = 'QUALYS'

    @property
    def vault_secret_id(self):
        """
        **[Required]** Gets the vault_secret_id of this HostScanAgentConfigurationQualys.
        Vault secret OCID which stores license information. Content inside this secret in vault would be base64 string containing information about customer's Qualys susbcription license.


        :return: The vault_secret_id of this HostScanAgentConfigurationQualys.
        :rtype: str
        """
        return self._vault_secret_id

    @vault_secret_id.setter
    def vault_secret_id(self, vault_secret_id):
        """
        Sets the vault_secret_id of this HostScanAgentConfigurationQualys.
        Vault secret OCID which stores license information. Content inside this secret in vault would be base64 string containing information about customer's Qualys susbcription license.


        :param vault_secret_id: The vault_secret_id of this HostScanAgentConfigurationQualys.
        :type: str
        """
        self._vault_secret_id = vault_secret_id

    @property
    def should_un_install(self):
        """
        **[Required]** Gets the should_un_install of this HostScanAgentConfigurationQualys.
        Boolean flag letting agent know if it should un-install the Qualys agent when it is stopped.


        :return: The should_un_install of this HostScanAgentConfigurationQualys.
        :rtype: bool
        """
        return self._should_un_install

    @should_un_install.setter
    def should_un_install(self, should_un_install):
        """
        Sets the should_un_install of this HostScanAgentConfigurationQualys.
        Boolean flag letting agent know if it should un-install the Qualys agent when it is stopped.


        :param should_un_install: The should_un_install of this HostScanAgentConfigurationQualys.
        :type: bool
        """
        self._should_un_install = should_un_install

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
