# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostPortScanResultSummary(object):
    """
    A summary of a result for a host agent scan
    """

    #: A constant which can be used with the highest_problem_severity property of a HostPortScanResultSummary.
    #: This constant has a value of "NONE"
    HIGHEST_PROBLEM_SEVERITY_NONE = "NONE"

    #: A constant which can be used with the highest_problem_severity property of a HostPortScanResultSummary.
    #: This constant has a value of "LOW"
    HIGHEST_PROBLEM_SEVERITY_LOW = "LOW"

    #: A constant which can be used with the highest_problem_severity property of a HostPortScanResultSummary.
    #: This constant has a value of "MEDIUM"
    HIGHEST_PROBLEM_SEVERITY_MEDIUM = "MEDIUM"

    #: A constant which can be used with the highest_problem_severity property of a HostPortScanResultSummary.
    #: This constant has a value of "HIGH"
    HIGHEST_PROBLEM_SEVERITY_HIGH = "HIGH"

    #: A constant which can be used with the highest_problem_severity property of a HostPortScanResultSummary.
    #: This constant has a value of "CRITICAL"
    HIGHEST_PROBLEM_SEVERITY_CRITICAL = "CRITICAL"

    #: A constant which can be used with the lifecycle_state property of a HostPortScanResultSummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a HostPortScanResultSummary.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a HostPortScanResultSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a HostPortScanResultSummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a HostPortScanResultSummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a HostPortScanResultSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new HostPortScanResultSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this HostPortScanResultSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this HostPortScanResultSummary.
        :type display_name: str

        :param instance_id:
            The value to assign to the instance_id property of this HostPortScanResultSummary.
        :type instance_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this HostPortScanResultSummary.
        :type compartment_id: str

        :param highest_problem_severity:
            The value to assign to the highest_problem_severity property of this HostPortScanResultSummary.
            Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type highest_problem_severity: str

        :param open_port_count:
            The value to assign to the open_port_count property of this HostPortScanResultSummary.
        :type open_port_count: int

        :param time_started:
            The value to assign to the time_started property of this HostPortScanResultSummary.
        :type time_started: datetime

        :param time_finished:
            The value to assign to the time_finished property of this HostPortScanResultSummary.
        :type time_finished: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this HostPortScanResultSummary.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'instance_id': 'str',
            'compartment_id': 'str',
            'highest_problem_severity': 'str',
            'open_port_count': 'int',
            'time_started': 'datetime',
            'time_finished': 'datetime',
            'lifecycle_state': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'instance_id': 'instanceId',
            'compartment_id': 'compartmentId',
            'highest_problem_severity': 'highestProblemSeverity',
            'open_port_count': 'openPortCount',
            'time_started': 'timeStarted',
            'time_finished': 'timeFinished',
            'lifecycle_state': 'lifecycleState'
        }

        self._id = None
        self._display_name = None
        self._instance_id = None
        self._compartment_id = None
        self._highest_problem_severity = None
        self._open_port_count = None
        self._time_started = None
        self._time_finished = None
        self._lifecycle_state = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this HostPortScanResultSummary.
        Unique identifier of the scan


        :return: The id of this HostPortScanResultSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this HostPortScanResultSummary.
        Unique identifier of the scan


        :param id: The id of this HostPortScanResultSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this HostPortScanResultSummary.
        Name of the resource


        :return: The display_name of this HostPortScanResultSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this HostPortScanResultSummary.
        Name of the resource


        :param display_name: The display_name of this HostPortScanResultSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this HostPortScanResultSummary.
        Instance ID of the Compute Instance scanned


        :return: The instance_id of this HostPortScanResultSummary.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this HostPortScanResultSummary.
        Instance ID of the Compute Instance scanned


        :param instance_id: The instance_id of this HostPortScanResultSummary.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this HostPortScanResultSummary.
        Compartment ID of the resource. This is set to the same as the compartment ID of the scan target


        :return: The compartment_id of this HostPortScanResultSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this HostPortScanResultSummary.
        Compartment ID of the resource. This is set to the same as the compartment ID of the scan target


        :param compartment_id: The compartment_id of this HostPortScanResultSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def highest_problem_severity(self):
        """
        **[Required]** Gets the highest_problem_severity of this HostPortScanResultSummary.
        Highest problem severity in this report

        Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The highest_problem_severity of this HostPortScanResultSummary.
        :rtype: str
        """
        return self._highest_problem_severity

    @highest_problem_severity.setter
    def highest_problem_severity(self, highest_problem_severity):
        """
        Sets the highest_problem_severity of this HostPortScanResultSummary.
        Highest problem severity in this report


        :param highest_problem_severity: The highest_problem_severity of this HostPortScanResultSummary.
        :type: str
        """
        allowed_values = ["NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"]
        if not value_allowed_none_or_none_sentinel(highest_problem_severity, allowed_values):
            highest_problem_severity = 'UNKNOWN_ENUM_VALUE'
        self._highest_problem_severity = highest_problem_severity

    @property
    def open_port_count(self):
        """
        **[Required]** Gets the open_port_count of this HostPortScanResultSummary.
        Total number of open ports across all attached VNICs found in this scan


        :return: The open_port_count of this HostPortScanResultSummary.
        :rtype: int
        """
        return self._open_port_count

    @open_port_count.setter
    def open_port_count(self, open_port_count):
        """
        Sets the open_port_count of this HostPortScanResultSummary.
        Total number of open ports across all attached VNICs found in this scan


        :param open_port_count: The open_port_count of this HostPortScanResultSummary.
        :type: int
        """
        self._open_port_count = open_port_count

    @property
    def time_started(self):
        """
        **[Required]** Gets the time_started of this HostPortScanResultSummary.
        Date and time the scan was started, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_started of this HostPortScanResultSummary.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this HostPortScanResultSummary.
        Date and time the scan was started, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_started: The time_started of this HostPortScanResultSummary.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_finished(self):
        """
        **[Required]** Gets the time_finished of this HostPortScanResultSummary.
        Date and time the scan was completed, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_finished of this HostPortScanResultSummary.
        :rtype: datetime
        """
        return self._time_finished

    @time_finished.setter
    def time_finished(self, time_finished):
        """
        Sets the time_finished of this HostPortScanResultSummary.
        Date and time the scan was completed, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_finished: The time_finished of this HostPortScanResultSummary.
        :type: datetime
        """
        self._time_finished = time_finished

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this HostPortScanResultSummary.
        The current state of the result.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this HostPortScanResultSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this HostPortScanResultSummary.
        The current state of the result.


        :param lifecycle_state: The lifecycle_state of this HostPortScanResultSummary.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
