# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180608


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RotationConfig(object):
    """
    Defines the frequency of the rotation and the information about the target system
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RotationConfig object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param rotation_interval:
            The value to assign to the rotation_interval property of this RotationConfig.
        :type rotation_interval: str

        :param target_system_details:
            The value to assign to the target_system_details property of this RotationConfig.
        :type target_system_details: oci.vault.models.TargetSystemDetails

        :param is_scheduled_rotation_enabled:
            The value to assign to the is_scheduled_rotation_enabled property of this RotationConfig.
        :type is_scheduled_rotation_enabled: bool

        """
        self.swagger_types = {
            'rotation_interval': 'str',
            'target_system_details': 'TargetSystemDetails',
            'is_scheduled_rotation_enabled': 'bool'
        }

        self.attribute_map = {
            'rotation_interval': 'rotationInterval',
            'target_system_details': 'targetSystemDetails',
            'is_scheduled_rotation_enabled': 'isScheduledRotationEnabled'
        }

        self._rotation_interval = None
        self._target_system_details = None
        self._is_scheduled_rotation_enabled = None

    @property
    def rotation_interval(self):
        """
        Gets the rotation_interval of this RotationConfig.
        The time interval that indicates the frequency for rotating secret data, as described in ISO 8601 format.
        The minimum value is 1 day and maximum value is 360 days.
        For example, if you want to set the time interval for rotating a secret data as 30 days, the duration is expressed as \"P30D.\"


        :return: The rotation_interval of this RotationConfig.
        :rtype: str
        """
        return self._rotation_interval

    @rotation_interval.setter
    def rotation_interval(self, rotation_interval):
        """
        Sets the rotation_interval of this RotationConfig.
        The time interval that indicates the frequency for rotating secret data, as described in ISO 8601 format.
        The minimum value is 1 day and maximum value is 360 days.
        For example, if you want to set the time interval for rotating a secret data as 30 days, the duration is expressed as \"P30D.\"


        :param rotation_interval: The rotation_interval of this RotationConfig.
        :type: str
        """
        self._rotation_interval = rotation_interval

    @property
    def target_system_details(self):
        """
        **[Required]** Gets the target_system_details of this RotationConfig.

        :return: The target_system_details of this RotationConfig.
        :rtype: oci.vault.models.TargetSystemDetails
        """
        return self._target_system_details

    @target_system_details.setter
    def target_system_details(self, target_system_details):
        """
        Sets the target_system_details of this RotationConfig.

        :param target_system_details: The target_system_details of this RotationConfig.
        :type: oci.vault.models.TargetSystemDetails
        """
        self._target_system_details = target_system_details

    @property
    def is_scheduled_rotation_enabled(self):
        """
        Gets the is_scheduled_rotation_enabled of this RotationConfig.
        Enables auto rotation, when set to true rotationInterval must be set.


        :return: The is_scheduled_rotation_enabled of this RotationConfig.
        :rtype: bool
        """
        return self._is_scheduled_rotation_enabled

    @is_scheduled_rotation_enabled.setter
    def is_scheduled_rotation_enabled(self, is_scheduled_rotation_enabled):
        """
        Sets the is_scheduled_rotation_enabled of this RotationConfig.
        Enables auto rotation, when set to true rotationInterval must be set.


        :param is_scheduled_rotation_enabled: The is_scheduled_rotation_enabled of this RotationConfig.
        :type: bool
        """
        self._is_scheduled_rotation_enabled = is_scheduled_rotation_enabled

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
