# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180608

from .target_system_details import TargetSystemDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FunctionTargetSystemDetails(TargetSystemDetails):
    """
    Details of the OCI function that vault secret connects to.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FunctionTargetSystemDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.vault.models.FunctionTargetSystemDetails.target_system_type` attribute
        of this class is ``FUNCTION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param target_system_type:
            The value to assign to the target_system_type property of this FunctionTargetSystemDetails.
            Allowed values for this property are: "ADB", "FUNCTION"
        :type target_system_type: str

        :param function_id:
            The value to assign to the function_id property of this FunctionTargetSystemDetails.
        :type function_id: str

        """
        self.swagger_types = {
            'target_system_type': 'str',
            'function_id': 'str'
        }

        self.attribute_map = {
            'target_system_type': 'targetSystemType',
            'function_id': 'functionId'
        }

        self._target_system_type = None
        self._function_id = None
        self._target_system_type = 'FUNCTION'

    @property
    def function_id(self):
        """
        **[Required]** Gets the function_id of this FunctionTargetSystemDetails.
        The unique identifier (OCID) of the OCI Functions that vault secret connects to.


        :return: The function_id of this FunctionTargetSystemDetails.
        :rtype: str
        """
        return self._function_id

    @function_id.setter
    def function_id(self, function_id):
        """
        Sets the function_id of this FunctionTargetSystemDetails.
        The unique identifier (OCID) of the OCI Functions that vault secret connects to.


        :param function_id: The function_id of this FunctionTargetSystemDetails.
        :type: str
        """
        self._function_id = function_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
