# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Queue(object):
    """
    A detailed representation of a queue and its configuration.
    """

    #: A constant which can be used with the lifecycle_state property of a Queue.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a Queue.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a Queue.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a Queue.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a Queue.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a Queue.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a Queue.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    def __init__(self, **kwargs):
        """
        Initializes a new Queue object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Queue.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this Queue.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this Queue.
        :type compartment_id: str

        :param time_created:
            The value to assign to the time_created property of this Queue.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this Queue.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this Queue.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this Queue.
        :type lifecycle_details: str

        :param messages_endpoint:
            The value to assign to the messages_endpoint property of this Queue.
        :type messages_endpoint: str

        :param retention_in_seconds:
            The value to assign to the retention_in_seconds property of this Queue.
        :type retention_in_seconds: int

        :param visibility_in_seconds:
            The value to assign to the visibility_in_seconds property of this Queue.
        :type visibility_in_seconds: int

        :param timeout_in_seconds:
            The value to assign to the timeout_in_seconds property of this Queue.
        :type timeout_in_seconds: int

        :param dead_letter_queue_delivery_count:
            The value to assign to the dead_letter_queue_delivery_count property of this Queue.
        :type dead_letter_queue_delivery_count: int

        :param custom_encryption_key_id:
            The value to assign to the custom_encryption_key_id property of this Queue.
        :type custom_encryption_key_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this Queue.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this Queue.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this Queue.
        :type system_tags: dict(str, dict(str, object))

        :param channel_consumption_limit:
            The value to assign to the channel_consumption_limit property of this Queue.
        :type channel_consumption_limit: int

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'messages_endpoint': 'str',
            'retention_in_seconds': 'int',
            'visibility_in_seconds': 'int',
            'timeout_in_seconds': 'int',
            'dead_letter_queue_delivery_count': 'int',
            'custom_encryption_key_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'channel_consumption_limit': 'int'
        }

        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'messages_endpoint': 'messagesEndpoint',
            'retention_in_seconds': 'retentionInSeconds',
            'visibility_in_seconds': 'visibilityInSeconds',
            'timeout_in_seconds': 'timeoutInSeconds',
            'dead_letter_queue_delivery_count': 'deadLetterQueueDeliveryCount',
            'custom_encryption_key_id': 'customEncryptionKeyId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'channel_consumption_limit': 'channelConsumptionLimit'
        }

        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._messages_endpoint = None
        self._retention_in_seconds = None
        self._visibility_in_seconds = None
        self._timeout_in_seconds = None
        self._dead_letter_queue_delivery_count = None
        self._custom_encryption_key_id = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._channel_consumption_limit = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Queue.
        A unique identifier for the queue that is immutable on creation.


        :return: The id of this Queue.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Queue.
        A unique identifier for the queue that is immutable on creation.


        :param id: The id of this Queue.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this Queue.
        A user-friendly name for the queue. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this Queue.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Queue.
        A user-friendly name for the queue. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this Queue.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this Queue.
        The `OCID`__ of the compartment containing the queue.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this Queue.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this Queue.
        The `OCID`__ of the compartment containing the queue.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this Queue.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this Queue.
        The time that the queue was created, expressed in `RFC 3339`__ timestamp format.

        Example: `2018-04-20T00:00:07.405Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_created of this Queue.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this Queue.
        The time that the queue was created, expressed in `RFC 3339`__ timestamp format.

        Example: `2018-04-20T00:00:07.405Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_created: The time_created of this Queue.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this Queue.
        The time that the queue was updated, expressed in `RFC 3339`__ timestamp format.

        Example: `2018-04-20T00:00:07.405Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_updated of this Queue.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this Queue.
        The time that the queue was updated, expressed in `RFC 3339`__ timestamp format.

        Example: `2018-04-20T00:00:07.405Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_updated: The time_updated of this Queue.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this Queue.
        The current state of the queue.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this Queue.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this Queue.
        The current state of the queue.


        :param lifecycle_state: The lifecycle_state of this Queue.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", "INACTIVE"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this Queue.
        Any additional details about the current state of the queue.


        :return: The lifecycle_details of this Queue.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this Queue.
        Any additional details about the current state of the queue.


        :param lifecycle_details: The lifecycle_details of this Queue.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def messages_endpoint(self):
        """
        **[Required]** Gets the messages_endpoint of this Queue.
        The endpoint to use to consume or publish messages in the queue.


        :return: The messages_endpoint of this Queue.
        :rtype: str
        """
        return self._messages_endpoint

    @messages_endpoint.setter
    def messages_endpoint(self, messages_endpoint):
        """
        Sets the messages_endpoint of this Queue.
        The endpoint to use to consume or publish messages in the queue.


        :param messages_endpoint: The messages_endpoint of this Queue.
        :type: str
        """
        self._messages_endpoint = messages_endpoint

    @property
    def retention_in_seconds(self):
        """
        **[Required]** Gets the retention_in_seconds of this Queue.
        The retention period of the messages in the queue, in seconds.


        :return: The retention_in_seconds of this Queue.
        :rtype: int
        """
        return self._retention_in_seconds

    @retention_in_seconds.setter
    def retention_in_seconds(self, retention_in_seconds):
        """
        Sets the retention_in_seconds of this Queue.
        The retention period of the messages in the queue, in seconds.


        :param retention_in_seconds: The retention_in_seconds of this Queue.
        :type: int
        """
        self._retention_in_seconds = retention_in_seconds

    @property
    def visibility_in_seconds(self):
        """
        **[Required]** Gets the visibility_in_seconds of this Queue.
        The default visibility timeout of the messages consumed from the queue, in seconds.


        :return: The visibility_in_seconds of this Queue.
        :rtype: int
        """
        return self._visibility_in_seconds

    @visibility_in_seconds.setter
    def visibility_in_seconds(self, visibility_in_seconds):
        """
        Sets the visibility_in_seconds of this Queue.
        The default visibility timeout of the messages consumed from the queue, in seconds.


        :param visibility_in_seconds: The visibility_in_seconds of this Queue.
        :type: int
        """
        self._visibility_in_seconds = visibility_in_seconds

    @property
    def timeout_in_seconds(self):
        """
        **[Required]** Gets the timeout_in_seconds of this Queue.
        The default polling timeout of the messages in the queue, in seconds.


        :return: The timeout_in_seconds of this Queue.
        :rtype: int
        """
        return self._timeout_in_seconds

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, timeout_in_seconds):
        """
        Sets the timeout_in_seconds of this Queue.
        The default polling timeout of the messages in the queue, in seconds.


        :param timeout_in_seconds: The timeout_in_seconds of this Queue.
        :type: int
        """
        self._timeout_in_seconds = timeout_in_seconds

    @property
    def dead_letter_queue_delivery_count(self):
        """
        **[Required]** Gets the dead_letter_queue_delivery_count of this Queue.
        The number of times a message can be delivered to a consumer before being moved to the dead letter queue. A value of 0 indicates that the DLQ is not used.


        :return: The dead_letter_queue_delivery_count of this Queue.
        :rtype: int
        """
        return self._dead_letter_queue_delivery_count

    @dead_letter_queue_delivery_count.setter
    def dead_letter_queue_delivery_count(self, dead_letter_queue_delivery_count):
        """
        Sets the dead_letter_queue_delivery_count of this Queue.
        The number of times a message can be delivered to a consumer before being moved to the dead letter queue. A value of 0 indicates that the DLQ is not used.


        :param dead_letter_queue_delivery_count: The dead_letter_queue_delivery_count of this Queue.
        :type: int
        """
        self._dead_letter_queue_delivery_count = dead_letter_queue_delivery_count

    @property
    def custom_encryption_key_id(self):
        """
        Gets the custom_encryption_key_id of this Queue.
        The `OCID`__ of the custom encryption key to be used to encrypt messages content.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The custom_encryption_key_id of this Queue.
        :rtype: str
        """
        return self._custom_encryption_key_id

    @custom_encryption_key_id.setter
    def custom_encryption_key_id(self, custom_encryption_key_id):
        """
        Sets the custom_encryption_key_id of this Queue.
        The `OCID`__ of the custom encryption key to be used to encrypt messages content.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param custom_encryption_key_id: The custom_encryption_key_id of this Queue.
        :type: str
        """
        self._custom_encryption_key_id = custom_encryption_key_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this Queue.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this Queue.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this Queue.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this Queue.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this Queue.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this Queue.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this Queue.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this Queue.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this Queue.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this Queue.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this Queue.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this Queue.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def channel_consumption_limit(self):
        """
        Gets the channel_consumption_limit of this Queue.
        The percentage of allocated queue resources that can be consumed by a single channel. For example, if a queue has a storage limit of 2Gb, and a single channel consumption limit is 0.1 (10%), that means data size of a single channel  can't exceed 200Mb. Consumption limit of 100% (default) means that a single channel can consume up-to all allocated queue's resources.


        :return: The channel_consumption_limit of this Queue.
        :rtype: int
        """
        return self._channel_consumption_limit

    @channel_consumption_limit.setter
    def channel_consumption_limit(self, channel_consumption_limit):
        """
        Sets the channel_consumption_limit of this Queue.
        The percentage of allocated queue resources that can be consumed by a single channel. For example, if a queue has a storage limit of 2Gb, and a single channel consumption limit is 0.1 (10%), that means data size of a single channel  can't exceed 200Mb. Consumption limit of 100% (default) means that a single channel can consume up-to all allocated queue's resources.


        :param channel_consumption_limit: The channel_consumption_limit of this Queue.
        :type: int
        """
        self._channel_consumption_limit = channel_consumption_limit

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
