# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ManageModuleStreamsOnManagedInstanceDetails(object):
    """
    The set of changes to make to the state of the modules, streams, and profiles on a managed instance
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ManageModuleStreamsOnManagedInstanceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_dry_run:
            The value to assign to the is_dry_run property of this ManageModuleStreamsOnManagedInstanceDetails.
        :type is_dry_run: bool

        :param enable:
            The value to assign to the enable property of this ManageModuleStreamsOnManagedInstanceDetails.
        :type enable: list[oci.os_management_hub.models.ModuleStreamDetails]

        :param disable:
            The value to assign to the disable property of this ManageModuleStreamsOnManagedInstanceDetails.
        :type disable: list[oci.os_management_hub.models.ModuleStreamDetails]

        :param install:
            The value to assign to the install property of this ManageModuleStreamsOnManagedInstanceDetails.
        :type install: list[oci.os_management_hub.models.ModuleStreamProfileDetails]

        :param remove:
            The value to assign to the remove property of this ManageModuleStreamsOnManagedInstanceDetails.
        :type remove: list[oci.os_management_hub.models.ModuleStreamProfileDetails]

        :param work_request_details:
            The value to assign to the work_request_details property of this ManageModuleStreamsOnManagedInstanceDetails.
        :type work_request_details: oci.os_management_hub.models.WorkRequestDetails

        """
        self.swagger_types = {
            'is_dry_run': 'bool',
            'enable': 'list[ModuleStreamDetails]',
            'disable': 'list[ModuleStreamDetails]',
            'install': 'list[ModuleStreamProfileDetails]',
            'remove': 'list[ModuleStreamProfileDetails]',
            'work_request_details': 'WorkRequestDetails'
        }

        self.attribute_map = {
            'is_dry_run': 'isDryRun',
            'enable': 'enable',
            'disable': 'disable',
            'install': 'install',
            'remove': 'remove',
            'work_request_details': 'workRequestDetails'
        }

        self._is_dry_run = None
        self._enable = None
        self._disable = None
        self._install = None
        self._remove = None
        self._work_request_details = None

    @property
    def is_dry_run(self):
        """
        Gets the is_dry_run of this ManageModuleStreamsOnManagedInstanceDetails.
        Indicates if this operation is a dry run or if the operation
        should be committed.  If set to true, the result of the operation
        will be evaluated but not committed.  If set to false, the
        operation is committed to the managed instance.  The default is
        false.


        :return: The is_dry_run of this ManageModuleStreamsOnManagedInstanceDetails.
        :rtype: bool
        """
        return self._is_dry_run

    @is_dry_run.setter
    def is_dry_run(self, is_dry_run):
        """
        Sets the is_dry_run of this ManageModuleStreamsOnManagedInstanceDetails.
        Indicates if this operation is a dry run or if the operation
        should be committed.  If set to true, the result of the operation
        will be evaluated but not committed.  If set to false, the
        operation is committed to the managed instance.  The default is
        false.


        :param is_dry_run: The is_dry_run of this ManageModuleStreamsOnManagedInstanceDetails.
        :type: bool
        """
        self._is_dry_run = is_dry_run

    @property
    def enable(self):
        """
        Gets the enable of this ManageModuleStreamsOnManagedInstanceDetails.
        The set of module streams to enable. If any streams of a module are already enabled, the service switches from the current stream to the new stream.
        Once complete, the streams will be in 'ENABLED' status.


        :return: The enable of this ManageModuleStreamsOnManagedInstanceDetails.
        :rtype: list[oci.os_management_hub.models.ModuleStreamDetails]
        """
        return self._enable

    @enable.setter
    def enable(self, enable):
        """
        Sets the enable of this ManageModuleStreamsOnManagedInstanceDetails.
        The set of module streams to enable. If any streams of a module are already enabled, the service switches from the current stream to the new stream.
        Once complete, the streams will be in 'ENABLED' status.


        :param enable: The enable of this ManageModuleStreamsOnManagedInstanceDetails.
        :type: list[oci.os_management_hub.models.ModuleStreamDetails]
        """
        self._enable = enable

    @property
    def disable(self):
        """
        Gets the disable of this ManageModuleStreamsOnManagedInstanceDetails.
        The set of module streams to disable. Any profiles that are installed for the module stream will be removed as part of the operation.
        Once complete, the streams will be in 'DISABLED' status.


        :return: The disable of this ManageModuleStreamsOnManagedInstanceDetails.
        :rtype: list[oci.os_management_hub.models.ModuleStreamDetails]
        """
        return self._disable

    @disable.setter
    def disable(self, disable):
        """
        Sets the disable of this ManageModuleStreamsOnManagedInstanceDetails.
        The set of module streams to disable. Any profiles that are installed for the module stream will be removed as part of the operation.
        Once complete, the streams will be in 'DISABLED' status.


        :param disable: The disable of this ManageModuleStreamsOnManagedInstanceDetails.
        :type: list[oci.os_management_hub.models.ModuleStreamDetails]
        """
        self._disable = disable

    @property
    def install(self):
        """
        Gets the install of this ManageModuleStreamsOnManagedInstanceDetails.
        The set of module stream profiles to install. Any packages that are part of the profile are installed on the managed instance.
        Once complete, the profile will be in 'INSTALLED' status. The operation will return an error if you attempt to install a profile from a disabled stream, unless enabling the new module stream is included in this operation.


        :return: The install of this ManageModuleStreamsOnManagedInstanceDetails.
        :rtype: list[oci.os_management_hub.models.ModuleStreamProfileDetails]
        """
        return self._install

    @install.setter
    def install(self, install):
        """
        Sets the install of this ManageModuleStreamsOnManagedInstanceDetails.
        The set of module stream profiles to install. Any packages that are part of the profile are installed on the managed instance.
        Once complete, the profile will be in 'INSTALLED' status. The operation will return an error if you attempt to install a profile from a disabled stream, unless enabling the new module stream is included in this operation.


        :param install: The install of this ManageModuleStreamsOnManagedInstanceDetails.
        :type: list[oci.os_management_hub.models.ModuleStreamProfileDetails]
        """
        self._install = install

    @property
    def remove(self):
        """
        Gets the remove of this ManageModuleStreamsOnManagedInstanceDetails.
        The set of module stream profiles to remove. Once complete, the profile will be in 'AVAILABLE' status.
        The status of packages within the profile after the operation is complete is defined by the package manager on the managed instance group.


        :return: The remove of this ManageModuleStreamsOnManagedInstanceDetails.
        :rtype: list[oci.os_management_hub.models.ModuleStreamProfileDetails]
        """
        return self._remove

    @remove.setter
    def remove(self, remove):
        """
        Sets the remove of this ManageModuleStreamsOnManagedInstanceDetails.
        The set of module stream profiles to remove. Once complete, the profile will be in 'AVAILABLE' status.
        The status of packages within the profile after the operation is complete is defined by the package manager on the managed instance group.


        :param remove: The remove of this ManageModuleStreamsOnManagedInstanceDetails.
        :type: list[oci.os_management_hub.models.ModuleStreamProfileDetails]
        """
        self._remove = remove

    @property
    def work_request_details(self):
        """
        Gets the work_request_details of this ManageModuleStreamsOnManagedInstanceDetails.

        :return: The work_request_details of this ManageModuleStreamsOnManagedInstanceDetails.
        :rtype: oci.os_management_hub.models.WorkRequestDetails
        """
        return self._work_request_details

    @work_request_details.setter
    def work_request_details(self, work_request_details):
        """
        Sets the work_request_details of this ManageModuleStreamsOnManagedInstanceDetails.

        :param work_request_details: The work_request_details of this ManageModuleStreamsOnManagedInstanceDetails.
        :type: oci.os_management_hub.models.WorkRequestDetails
        """
        self._work_request_details = work_request_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
