# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class WarehouseDataObjectSummary(object):
    """
    Summary of a Warehouse data object.
    """

    #: A constant which can be used with the data_object_type property of a WarehouseDataObjectSummary.
    #: This constant has a value of "VIEW"
    DATA_OBJECT_TYPE_VIEW = "VIEW"

    #: A constant which can be used with the data_object_type property of a WarehouseDataObjectSummary.
    #: This constant has a value of "TABLE"
    DATA_OBJECT_TYPE_TABLE = "TABLE"

    def __init__(self, **kwargs):
        """
        Initializes a new WarehouseDataObjectSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param data_object_type:
            The value to assign to the data_object_type property of this WarehouseDataObjectSummary.
            Allowed values for this property are: "VIEW", "TABLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type data_object_type: str

        :param name:
            The value to assign to the name property of this WarehouseDataObjectSummary.
        :type name: str

        :param owner:
            The value to assign to the owner property of this WarehouseDataObjectSummary.
        :type owner: str

        :param details:
            The value to assign to the details property of this WarehouseDataObjectSummary.
        :type details: oci.opsi.models.WarehouseDataObjectDetails

        """
        self.swagger_types = {
            'data_object_type': 'str',
            'name': 'str',
            'owner': 'str',
            'details': 'WarehouseDataObjectDetails'
        }

        self.attribute_map = {
            'data_object_type': 'dataObjectType',
            'name': 'name',
            'owner': 'owner',
            'details': 'details'
        }

        self._data_object_type = None
        self._name = None
        self._owner = None
        self._details = None

    @property
    def data_object_type(self):
        """
        **[Required]** Gets the data_object_type of this WarehouseDataObjectSummary.
        Type of the data object.

        Allowed values for this property are: "VIEW", "TABLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The data_object_type of this WarehouseDataObjectSummary.
        :rtype: str
        """
        return self._data_object_type

    @data_object_type.setter
    def data_object_type(self, data_object_type):
        """
        Sets the data_object_type of this WarehouseDataObjectSummary.
        Type of the data object.


        :param data_object_type: The data_object_type of this WarehouseDataObjectSummary.
        :type: str
        """
        allowed_values = ["VIEW", "TABLE"]
        if not value_allowed_none_or_none_sentinel(data_object_type, allowed_values):
            data_object_type = 'UNKNOWN_ENUM_VALUE'
        self._data_object_type = data_object_type

    @property
    def name(self):
        """
        Gets the name of this WarehouseDataObjectSummary.
        Name of the data object, which can be used in data object queries just like how view names are used in a query.


        :return: The name of this WarehouseDataObjectSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this WarehouseDataObjectSummary.
        Name of the data object, which can be used in data object queries just like how view names are used in a query.


        :param name: The name of this WarehouseDataObjectSummary.
        :type: str
        """
        self._name = name

    @property
    def owner(self):
        """
        Gets the owner of this WarehouseDataObjectSummary.
        Owner of the data object, which can be used in data object queries in front of data object names just like SCHEMA.VIEW notation in queries.


        :return: The owner of this WarehouseDataObjectSummary.
        :rtype: str
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """
        Sets the owner of this WarehouseDataObjectSummary.
        Owner of the data object, which can be used in data object queries in front of data object names just like SCHEMA.VIEW notation in queries.


        :param owner: The owner of this WarehouseDataObjectSummary.
        :type: str
        """
        self._owner = owner

    @property
    def details(self):
        """
        Gets the details of this WarehouseDataObjectSummary.

        :return: The details of this WarehouseDataObjectSummary.
        :rtype: oci.opsi.models.WarehouseDataObjectDetails
        """
        return self._details

    @details.setter
    def details(self, details):
        """
        Sets the details of this WarehouseDataObjectSummary.

        :param details: The details of this WarehouseDataObjectSummary.
        :type: oci.opsi.models.WarehouseDataObjectDetails
        """
        self._details = details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
