# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190506


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExportDigitalAssistantDetails(object):
    """
    Properties that specify where in Object Storage to export the Digital Assistant to.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExportDigitalAssistantDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param target:
            The value to assign to the target property of this ExportDigitalAssistantDetails.
        :type target: oci.oda.models.StorageLocation

        """
        self.swagger_types = {
            'target': 'StorageLocation'
        }

        self.attribute_map = {
            'target': 'target'
        }

        self._target = None

    @property
    def target(self):
        """
        **[Required]** Gets the target of this ExportDigitalAssistantDetails.

        :return: The target of this ExportDigitalAssistantDetails.
        :rtype: oci.oda.models.StorageLocation
        """
        return self._target

    @target.setter
    def target(self, target):
        """
        Sets the target of this ExportDigitalAssistantDetails.

        :param target: The target of this ExportDigitalAssistantDetails.
        :type: oci.oda.models.StorageLocation
        """
        self._target = target

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
