# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Offer(object):
    """
    Description of Offer.
    """

    #: A constant which can be used with the lifecycle_state property of a Offer.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a Offer.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a Offer.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a Offer.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a Offer.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a Offer.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the offer_status property of a Offer.
    #: This constant has a value of "DRAFT"
    OFFER_STATUS_DRAFT = "DRAFT"

    #: A constant which can be used with the offer_status property of a Offer.
    #: This constant has a value of "PENDING_MARKETPLACE"
    OFFER_STATUS_PENDING_MARKETPLACE = "PENDING_MARKETPLACE"

    #: A constant which can be used with the offer_status property of a Offer.
    #: This constant has a value of "PENDING_BUYER"
    OFFER_STATUS_PENDING_BUYER = "PENDING_BUYER"

    #: A constant which can be used with the offer_status property of a Offer.
    #: This constant has a value of "EXPIRED"
    OFFER_STATUS_EXPIRED = "EXPIRED"

    #: A constant which can be used with the offer_status property of a Offer.
    #: This constant has a value of "ACCEPTED"
    OFFER_STATUS_ACCEPTED = "ACCEPTED"

    #: A constant which can be used with the offer_status property of a Offer.
    #: This constant has a value of "ACTIVE"
    OFFER_STATUS_ACTIVE = "ACTIVE"

    #: A constant which can be used with the offer_status property of a Offer.
    #: This constant has a value of "ENDED"
    OFFER_STATUS_ENDED = "ENDED"

    #: A constant which can be used with the offer_status property of a Offer.
    #: This constant has a value of "FAILED_SEND"
    OFFER_STATUS_FAILED_SEND = "FAILED_SEND"

    #: A constant which can be used with the offer_status property of a Offer.
    #: This constant has a value of "FAILED_ACCEPT"
    OFFER_STATUS_FAILED_ACCEPT = "FAILED_ACCEPT"

    def __init__(self, **kwargs):
        """
        Initializes a new Offer object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Offer.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this Offer.
        :type display_name: str

        :param seller_compartment_id:
            The value to assign to the seller_compartment_id property of this Offer.
        :type seller_compartment_id: str

        :param buyer_compartment_id:
            The value to assign to the buyer_compartment_id property of this Offer.
        :type buyer_compartment_id: str

        :param description:
            The value to assign to the description property of this Offer.
        :type description: str

        :param time_start_date:
            The value to assign to the time_start_date property of this Offer.
        :type time_start_date: datetime

        :param duration:
            The value to assign to the duration property of this Offer.
        :type duration: str

        :param time_created:
            The value to assign to the time_created property of this Offer.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this Offer.
        :type time_updated: datetime

        :param time_accept_by:
            The value to assign to the time_accept_by property of this Offer.
        :type time_accept_by: datetime

        :param time_accepted:
            The value to assign to the time_accepted property of this Offer.
        :type time_accepted: datetime

        :param time_offer_end:
            The value to assign to the time_offer_end property of this Offer.
        :type time_offer_end: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this Offer.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this Offer.
        :type lifecycle_details: str

        :param offer_status:
            The value to assign to the offer_status property of this Offer.
            Allowed values for this property are: "DRAFT", "PENDING_MARKETPLACE", "PENDING_BUYER", "EXPIRED", "ACCEPTED", "ACTIVE", "ENDED", "FAILED_SEND", "FAILED_ACCEPT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type offer_status: str

        :param publisher_summary:
            The value to assign to the publisher_summary property of this Offer.
        :type publisher_summary: oci.marketplace_private_offer.models.PublisherSummary

        :param pricing:
            The value to assign to the pricing property of this Offer.
        :type pricing: oci.marketplace_private_offer.models.Pricing

        :param buyer_information:
            The value to assign to the buyer_information property of this Offer.
        :type buyer_information: oci.marketplace_private_offer.models.BuyerInformation

        :param seller_information:
            The value to assign to the seller_information property of this Offer.
        :type seller_information: oci.marketplace_private_offer.models.SellerInformation

        :param resource_bundles:
            The value to assign to the resource_bundles property of this Offer.
        :type resource_bundles: list[oci.marketplace_private_offer.models.ResourceBundle]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this Offer.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this Offer.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'seller_compartment_id': 'str',
            'buyer_compartment_id': 'str',
            'description': 'str',
            'time_start_date': 'datetime',
            'duration': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'time_accept_by': 'datetime',
            'time_accepted': 'datetime',
            'time_offer_end': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'offer_status': 'str',
            'publisher_summary': 'PublisherSummary',
            'pricing': 'Pricing',
            'buyer_information': 'BuyerInformation',
            'seller_information': 'SellerInformation',
            'resource_bundles': 'list[ResourceBundle]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'seller_compartment_id': 'sellerCompartmentId',
            'buyer_compartment_id': 'buyerCompartmentId',
            'description': 'description',
            'time_start_date': 'timeStartDate',
            'duration': 'duration',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'time_accept_by': 'timeAcceptBy',
            'time_accepted': 'timeAccepted',
            'time_offer_end': 'timeOfferEnd',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'offer_status': 'offerStatus',
            'publisher_summary': 'publisherSummary',
            'pricing': 'pricing',
            'buyer_information': 'buyerInformation',
            'seller_information': 'sellerInformation',
            'resource_bundles': 'resourceBundles',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._id = None
        self._display_name = None
        self._seller_compartment_id = None
        self._buyer_compartment_id = None
        self._description = None
        self._time_start_date = None
        self._duration = None
        self._time_created = None
        self._time_updated = None
        self._time_accept_by = None
        self._time_accepted = None
        self._time_offer_end = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._offer_status = None
        self._publisher_summary = None
        self._pricing = None
        self._buyer_information = None
        self._seller_information = None
        self._resource_bundles = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Offer.
        Unique identifier that is immutable on creation


        :return: The id of this Offer.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Offer.
        Unique identifier that is immutable on creation


        :param id: The id of this Offer.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this Offer.
        Offer Identifier, can be renamed


        :return: The display_name of this Offer.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Offer.
        Offer Identifier, can be renamed


        :param display_name: The display_name of this Offer.
        :type: str
        """
        self._display_name = display_name

    @property
    def seller_compartment_id(self):
        """
        **[Required]** Gets the seller_compartment_id of this Offer.
        OCID of the seller's tenancy (root compartment).


        :return: The seller_compartment_id of this Offer.
        :rtype: str
        """
        return self._seller_compartment_id

    @seller_compartment_id.setter
    def seller_compartment_id(self, seller_compartment_id):
        """
        Sets the seller_compartment_id of this Offer.
        OCID of the seller's tenancy (root compartment).


        :param seller_compartment_id: The seller_compartment_id of this Offer.
        :type: str
        """
        self._seller_compartment_id = seller_compartment_id

    @property
    def buyer_compartment_id(self):
        """
        Gets the buyer_compartment_id of this Offer.
        OCID of the buyer's tenancy (root compartment).


        :return: The buyer_compartment_id of this Offer.
        :rtype: str
        """
        return self._buyer_compartment_id

    @buyer_compartment_id.setter
    def buyer_compartment_id(self, buyer_compartment_id):
        """
        Sets the buyer_compartment_id of this Offer.
        OCID of the buyer's tenancy (root compartment).


        :param buyer_compartment_id: The buyer_compartment_id of this Offer.
        :type: str
        """
        self._buyer_compartment_id = buyer_compartment_id

    @property
    def description(self):
        """
        Gets the description of this Offer.
        The description of the offer


        :return: The description of this Offer.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Offer.
        The description of the offer


        :param description: The description of this Offer.
        :type: str
        """
        self._description = description

    @property
    def time_start_date(self):
        """
        Gets the time_start_date of this Offer.
        The time the Offer will become active after it has been accepted by the Buyer. An RFC3339 formatted datetime string


        :return: The time_start_date of this Offer.
        :rtype: datetime
        """
        return self._time_start_date

    @time_start_date.setter
    def time_start_date(self, time_start_date):
        """
        Sets the time_start_date of this Offer.
        The time the Offer will become active after it has been accepted by the Buyer. An RFC3339 formatted datetime string


        :param time_start_date: The time_start_date of this Offer.
        :type: datetime
        """
        self._time_start_date = time_start_date

    @property
    def duration(self):
        """
        Gets the duration of this Offer.
        Duration the Offer will be active after its start date. An ISO8601 extended formatted string.


        :return: The duration of this Offer.
        :rtype: str
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """
        Sets the duration of this Offer.
        Duration the Offer will be active after its start date. An ISO8601 extended formatted string.


        :param duration: The duration of this Offer.
        :type: str
        """
        self._duration = duration

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this Offer.
        The time the the Offer was created. An RFC3339 formatted datetime string


        :return: The time_created of this Offer.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this Offer.
        The time the the Offer was created. An RFC3339 formatted datetime string


        :param time_created: The time_created of this Offer.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this Offer.
        The time the Offer was updated. An RFC3339 formatted datetime string


        :return: The time_updated of this Offer.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this Offer.
        The time the Offer was updated. An RFC3339 formatted datetime string


        :param time_updated: The time_updated of this Offer.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def time_accept_by(self):
        """
        Gets the time_accept_by of this Offer.
        The time the Offer must be accepted by the Buyer before the Offer becomes invalid. An RFC3339 formatted datetime string


        :return: The time_accept_by of this Offer.
        :rtype: datetime
        """
        return self._time_accept_by

    @time_accept_by.setter
    def time_accept_by(self, time_accept_by):
        """
        Sets the time_accept_by of this Offer.
        The time the Offer must be accepted by the Buyer before the Offer becomes invalid. An RFC3339 formatted datetime string


        :param time_accept_by: The time_accept_by of this Offer.
        :type: datetime
        """
        self._time_accept_by = time_accept_by

    @property
    def time_accepted(self):
        """
        Gets the time_accepted of this Offer.
        The time the Offer was accepted by the Buyer of the Offer. An RFC3339 formatted datetime string


        :return: The time_accepted of this Offer.
        :rtype: datetime
        """
        return self._time_accepted

    @time_accepted.setter
    def time_accepted(self, time_accepted):
        """
        Sets the time_accepted of this Offer.
        The time the Offer was accepted by the Buyer of the Offer. An RFC3339 formatted datetime string


        :param time_accepted: The time_accepted of this Offer.
        :type: datetime
        """
        self._time_accepted = time_accepted

    @property
    def time_offer_end(self):
        """
        Gets the time_offer_end of this Offer.
        The time the accepted Offer will end. An RFC3339 formatted datetime string


        :return: The time_offer_end of this Offer.
        :rtype: datetime
        """
        return self._time_offer_end

    @time_offer_end.setter
    def time_offer_end(self, time_offer_end):
        """
        Sets the time_offer_end of this Offer.
        The time the accepted Offer will end. An RFC3339 formatted datetime string


        :param time_offer_end: The time_offer_end of this Offer.
        :type: datetime
        """
        self._time_offer_end = time_offer_end

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this Offer.
        The current state of the Offer.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this Offer.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this Offer.
        The current state of the Offer.


        :param lifecycle_state: The lifecycle_state of this Offer.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this Offer.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :return: The lifecycle_details of this Offer.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this Offer.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :param lifecycle_details: The lifecycle_details of this Offer.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def offer_status(self):
        """
        Gets the offer_status of this Offer.
        A substate for lifeCycleStatus to give a more human readable version of the offer

        Allowed values for this property are: "DRAFT", "PENDING_MARKETPLACE", "PENDING_BUYER", "EXPIRED", "ACCEPTED", "ACTIVE", "ENDED", "FAILED_SEND", "FAILED_ACCEPT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The offer_status of this Offer.
        :rtype: str
        """
        return self._offer_status

    @offer_status.setter
    def offer_status(self, offer_status):
        """
        Sets the offer_status of this Offer.
        A substate for lifeCycleStatus to give a more human readable version of the offer


        :param offer_status: The offer_status of this Offer.
        :type: str
        """
        allowed_values = ["DRAFT", "PENDING_MARKETPLACE", "PENDING_BUYER", "EXPIRED", "ACCEPTED", "ACTIVE", "ENDED", "FAILED_SEND", "FAILED_ACCEPT"]
        if not value_allowed_none_or_none_sentinel(offer_status, allowed_values):
            offer_status = 'UNKNOWN_ENUM_VALUE'
        self._offer_status = offer_status

    @property
    def publisher_summary(self):
        """
        Gets the publisher_summary of this Offer.

        :return: The publisher_summary of this Offer.
        :rtype: oci.marketplace_private_offer.models.PublisherSummary
        """
        return self._publisher_summary

    @publisher_summary.setter
    def publisher_summary(self, publisher_summary):
        """
        Sets the publisher_summary of this Offer.

        :param publisher_summary: The publisher_summary of this Offer.
        :type: oci.marketplace_private_offer.models.PublisherSummary
        """
        self._publisher_summary = publisher_summary

    @property
    def pricing(self):
        """
        Gets the pricing of this Offer.

        :return: The pricing of this Offer.
        :rtype: oci.marketplace_private_offer.models.Pricing
        """
        return self._pricing

    @pricing.setter
    def pricing(self, pricing):
        """
        Sets the pricing of this Offer.

        :param pricing: The pricing of this Offer.
        :type: oci.marketplace_private_offer.models.Pricing
        """
        self._pricing = pricing

    @property
    def buyer_information(self):
        """
        Gets the buyer_information of this Offer.

        :return: The buyer_information of this Offer.
        :rtype: oci.marketplace_private_offer.models.BuyerInformation
        """
        return self._buyer_information

    @buyer_information.setter
    def buyer_information(self, buyer_information):
        """
        Sets the buyer_information of this Offer.

        :param buyer_information: The buyer_information of this Offer.
        :type: oci.marketplace_private_offer.models.BuyerInformation
        """
        self._buyer_information = buyer_information

    @property
    def seller_information(self):
        """
        Gets the seller_information of this Offer.

        :return: The seller_information of this Offer.
        :rtype: oci.marketplace_private_offer.models.SellerInformation
        """
        return self._seller_information

    @seller_information.setter
    def seller_information(self, seller_information):
        """
        Sets the seller_information of this Offer.

        :param seller_information: The seller_information of this Offer.
        :type: oci.marketplace_private_offer.models.SellerInformation
        """
        self._seller_information = seller_information

    @property
    def resource_bundles(self):
        """
        Gets the resource_bundles of this Offer.
        A list of Resource Bundles associated with an Offer.


        :return: The resource_bundles of this Offer.
        :rtype: list[oci.marketplace_private_offer.models.ResourceBundle]
        """
        return self._resource_bundles

    @resource_bundles.setter
    def resource_bundles(self, resource_bundles):
        """
        Sets the resource_bundles of this Offer.
        A list of Resource Bundles associated with an Offer.


        :param resource_bundles: The resource_bundles of this Offer.
        :type: list[oci.marketplace_private_offer.models.ResourceBundle]
        """
        self._resource_bundles = resource_bundles

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this Offer.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this Offer.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this Offer.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this Offer.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this Offer.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this Offer.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this Offer.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this Offer.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
