# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181025


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ServiceSummary(object):
    """
    A specific OCI service supported by resource limits.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ServiceSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this ServiceSummary.
        :type name: str

        :param description:
            The value to assign to the description property of this ServiceSummary.
        :type description: str

        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'description': 'description'
        }

        self._name = None
        self._description = None

    @property
    def name(self):
        """
        Gets the name of this ServiceSummary.
        The service name. Use this when calling other APIs.


        :return: The name of this ServiceSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ServiceSummary.
        The service name. Use this when calling other APIs.


        :param name: The name of this ServiceSummary.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this ServiceSummary.
        The friendly service name.


        :return: The description of this ServiceSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ServiceSummary.
        The friendly service name.


        :param description: The description of this ServiceSummary.
        :type: str
        """
        self._description = description

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
