# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class JavaDownloadCountAggregationCollection(object):
    """
    Collection of download count aggregations.
    """

    #: A constant which can be used with the aggregation_type property of a JavaDownloadCountAggregationCollection.
    #: This constant has a value of "JAVA_FAMILY"
    AGGREGATION_TYPE_JAVA_FAMILY = "JAVA_FAMILY"

    #: A constant which can be used with the aggregation_type property of a JavaDownloadCountAggregationCollection.
    #: This constant has a value of "JAVA_RELEASE"
    AGGREGATION_TYPE_JAVA_RELEASE = "JAVA_RELEASE"

    #: A constant which can be used with the aggregation_type property of a JavaDownloadCountAggregationCollection.
    #: This constant has a value of "PLATFORM"
    AGGREGATION_TYPE_PLATFORM = "PLATFORM"

    def __init__(self, **kwargs):
        """
        Initializes a new JavaDownloadCountAggregationCollection object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param aggregation_type:
            The value to assign to the aggregation_type property of this JavaDownloadCountAggregationCollection.
            Allowed values for this property are: "JAVA_FAMILY", "JAVA_RELEASE", "PLATFORM", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type aggregation_type: str

        :param items:
            The value to assign to the items property of this JavaDownloadCountAggregationCollection.
        :type items: list[oci.jms_java_downloads.models.JavaDownloadCountAggregation]

        """
        self.swagger_types = {
            'aggregation_type': 'str',
            'items': 'list[JavaDownloadCountAggregation]'
        }

        self.attribute_map = {
            'aggregation_type': 'aggregationType',
            'items': 'items'
        }

        self._aggregation_type = None
        self._items = None

    @property
    def aggregation_type(self):
        """
        **[Required]** Gets the aggregation_type of this JavaDownloadCountAggregationCollection.
        Aggregation type

        Allowed values for this property are: "JAVA_FAMILY", "JAVA_RELEASE", "PLATFORM", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The aggregation_type of this JavaDownloadCountAggregationCollection.
        :rtype: str
        """
        return self._aggregation_type

    @aggregation_type.setter
    def aggregation_type(self, aggregation_type):
        """
        Sets the aggregation_type of this JavaDownloadCountAggregationCollection.
        Aggregation type


        :param aggregation_type: The aggregation_type of this JavaDownloadCountAggregationCollection.
        :type: str
        """
        allowed_values = ["JAVA_FAMILY", "JAVA_RELEASE", "PLATFORM"]
        if not value_allowed_none_or_none_sentinel(aggregation_type, allowed_values):
            aggregation_type = 'UNKNOWN_ENUM_VALUE'
        self._aggregation_type = aggregation_type

    @property
    def items(self):
        """
        **[Required]** Gets the items of this JavaDownloadCountAggregationCollection.
        A list of download count aggregations.


        :return: The items of this JavaDownloadCountAggregationCollection.
        :rtype: list[oci.jms_java_downloads.models.JavaDownloadCountAggregation]
        """
        return self._items

    @items.setter
    def items(self, items):
        """
        Sets the items of this JavaDownloadCountAggregationCollection.
        A list of download count aggregations.


        :param items: The items of this JavaDownloadCountAggregationCollection.
        :type: list[oci.jms_java_downloads.models.JavaDownloadCountAggregation]
        """
        self._items = items

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
