# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SettingsCertificateValidation(object):
    """
    Certificate Validation Config

    **Added In:** 2010242156

    **SCIM++ Properties:**
    - caseExact: false
    - multiValued: false
    - mutability: readWrite
    - required: false
    - returned: default
    - type: complex
    - uniqueness: none
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SettingsCertificateValidation object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param crl_enabled:
            The value to assign to the crl_enabled property of this SettingsCertificateValidation.
        :type crl_enabled: bool

        :param crl_check_on_ocsp_failure_enabled:
            The value to assign to the crl_check_on_ocsp_failure_enabled property of this SettingsCertificateValidation.
        :type crl_check_on_ocsp_failure_enabled: bool

        :param crl_location:
            The value to assign to the crl_location property of this SettingsCertificateValidation.
        :type crl_location: str

        :param crl_refresh_interval:
            The value to assign to the crl_refresh_interval property of this SettingsCertificateValidation.
        :type crl_refresh_interval: int

        :param ocsp_enabled:
            The value to assign to the ocsp_enabled property of this SettingsCertificateValidation.
        :type ocsp_enabled: bool

        :param ocsp_unknown_response_status_allowed:
            The value to assign to the ocsp_unknown_response_status_allowed property of this SettingsCertificateValidation.
        :type ocsp_unknown_response_status_allowed: bool

        :param ocsp_responder_url:
            The value to assign to the ocsp_responder_url property of this SettingsCertificateValidation.
        :type ocsp_responder_url: str

        :param ocsp_settings_responder_url_preferred:
            The value to assign to the ocsp_settings_responder_url_preferred property of this SettingsCertificateValidation.
        :type ocsp_settings_responder_url_preferred: bool

        :param ocsp_timeout_duration:
            The value to assign to the ocsp_timeout_duration property of this SettingsCertificateValidation.
        :type ocsp_timeout_duration: int

        :param ocsp_signing_certificate_alias:
            The value to assign to the ocsp_signing_certificate_alias property of this SettingsCertificateValidation.
        :type ocsp_signing_certificate_alias: str

        """
        self.swagger_types = {
            'crl_enabled': 'bool',
            'crl_check_on_ocsp_failure_enabled': 'bool',
            'crl_location': 'str',
            'crl_refresh_interval': 'int',
            'ocsp_enabled': 'bool',
            'ocsp_unknown_response_status_allowed': 'bool',
            'ocsp_responder_url': 'str',
            'ocsp_settings_responder_url_preferred': 'bool',
            'ocsp_timeout_duration': 'int',
            'ocsp_signing_certificate_alias': 'str'
        }

        self.attribute_map = {
            'crl_enabled': 'crlEnabled',
            'crl_check_on_ocsp_failure_enabled': 'crlCheckOnOCSPFailureEnabled',
            'crl_location': 'crlLocation',
            'crl_refresh_interval': 'crlRefreshInterval',
            'ocsp_enabled': 'ocspEnabled',
            'ocsp_unknown_response_status_allowed': 'ocspUnknownResponseStatusAllowed',
            'ocsp_responder_url': 'ocspResponderURL',
            'ocsp_settings_responder_url_preferred': 'ocspSettingsResponderURLPreferred',
            'ocsp_timeout_duration': 'ocspTimeoutDuration',
            'ocsp_signing_certificate_alias': 'ocspSigningCertificateAlias'
        }

        self._crl_enabled = None
        self._crl_check_on_ocsp_failure_enabled = None
        self._crl_location = None
        self._crl_refresh_interval = None
        self._ocsp_enabled = None
        self._ocsp_unknown_response_status_allowed = None
        self._ocsp_responder_url = None
        self._ocsp_settings_responder_url_preferred = None
        self._ocsp_timeout_duration = None
        self._ocsp_signing_certificate_alias = None

    @property
    def crl_enabled(self):
        """
        Gets the crl_enabled of this SettingsCertificateValidation.
        CRL is enabled Configuration

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The crl_enabled of this SettingsCertificateValidation.
        :rtype: bool
        """
        return self._crl_enabled

    @crl_enabled.setter
    def crl_enabled(self, crl_enabled):
        """
        Sets the crl_enabled of this SettingsCertificateValidation.
        CRL is enabled Configuration

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param crl_enabled: The crl_enabled of this SettingsCertificateValidation.
        :type: bool
        """
        self._crl_enabled = crl_enabled

    @property
    def crl_check_on_ocsp_failure_enabled(self):
        """
        Gets the crl_check_on_ocsp_failure_enabled of this SettingsCertificateValidation.
        Use CRL as Fallback.

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The crl_check_on_ocsp_failure_enabled of this SettingsCertificateValidation.
        :rtype: bool
        """
        return self._crl_check_on_ocsp_failure_enabled

    @crl_check_on_ocsp_failure_enabled.setter
    def crl_check_on_ocsp_failure_enabled(self, crl_check_on_ocsp_failure_enabled):
        """
        Sets the crl_check_on_ocsp_failure_enabled of this SettingsCertificateValidation.
        Use CRL as Fallback.

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param crl_check_on_ocsp_failure_enabled: The crl_check_on_ocsp_failure_enabled of this SettingsCertificateValidation.
        :type: bool
        """
        self._crl_check_on_ocsp_failure_enabled = crl_check_on_ocsp_failure_enabled

    @property
    def crl_location(self):
        """
        Gets the crl_location of this SettingsCertificateValidation.
        CRL Location.

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The crl_location of this SettingsCertificateValidation.
        :rtype: str
        """
        return self._crl_location

    @crl_location.setter
    def crl_location(self, crl_location):
        """
        Sets the crl_location of this SettingsCertificateValidation.
        CRL Location.

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param crl_location: The crl_location of this SettingsCertificateValidation.
        :type: str
        """
        self._crl_location = crl_location

    @property
    def crl_refresh_interval(self):
        """
        Gets the crl_refresh_interval of this SettingsCertificateValidation.
        The CRL refresh interval in minutes

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The crl_refresh_interval of this SettingsCertificateValidation.
        :rtype: int
        """
        return self._crl_refresh_interval

    @crl_refresh_interval.setter
    def crl_refresh_interval(self, crl_refresh_interval):
        """
        Sets the crl_refresh_interval of this SettingsCertificateValidation.
        The CRL refresh interval in minutes

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param crl_refresh_interval: The crl_refresh_interval of this SettingsCertificateValidation.
        :type: int
        """
        self._crl_refresh_interval = crl_refresh_interval

    @property
    def ocsp_enabled(self):
        """
        Gets the ocsp_enabled of this SettingsCertificateValidation.
        OCSP is enabled Configuration

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The ocsp_enabled of this SettingsCertificateValidation.
        :rtype: bool
        """
        return self._ocsp_enabled

    @ocsp_enabled.setter
    def ocsp_enabled(self, ocsp_enabled):
        """
        Sets the ocsp_enabled of this SettingsCertificateValidation.
        OCSP is enabled Configuration

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param ocsp_enabled: The ocsp_enabled of this SettingsCertificateValidation.
        :type: bool
        """
        self._ocsp_enabled = ocsp_enabled

    @property
    def ocsp_unknown_response_status_allowed(self):
        """
        Gets the ocsp_unknown_response_status_allowed of this SettingsCertificateValidation.
        OCSP Accept unknown response status from ocsp responder.

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The ocsp_unknown_response_status_allowed of this SettingsCertificateValidation.
        :rtype: bool
        """
        return self._ocsp_unknown_response_status_allowed

    @ocsp_unknown_response_status_allowed.setter
    def ocsp_unknown_response_status_allowed(self, ocsp_unknown_response_status_allowed):
        """
        Sets the ocsp_unknown_response_status_allowed of this SettingsCertificateValidation.
        OCSP Accept unknown response status from ocsp responder.

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param ocsp_unknown_response_status_allowed: The ocsp_unknown_response_status_allowed of this SettingsCertificateValidation.
        :type: bool
        """
        self._ocsp_unknown_response_status_allowed = ocsp_unknown_response_status_allowed

    @property
    def ocsp_responder_url(self):
        """
        Gets the ocsp_responder_url of this SettingsCertificateValidation.
        OCSP Responder URL

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The ocsp_responder_url of this SettingsCertificateValidation.
        :rtype: str
        """
        return self._ocsp_responder_url

    @ocsp_responder_url.setter
    def ocsp_responder_url(self, ocsp_responder_url):
        """
        Sets the ocsp_responder_url of this SettingsCertificateValidation.
        OCSP Responder URL

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param ocsp_responder_url: The ocsp_responder_url of this SettingsCertificateValidation.
        :type: str
        """
        self._ocsp_responder_url = ocsp_responder_url

    @property
    def ocsp_settings_responder_url_preferred(self):
        """
        Gets the ocsp_settings_responder_url_preferred of this SettingsCertificateValidation.
        This setting says, OCSP Responder URL present in the issued certificate must be used. Otherwise, OCSP Responder URL from IDP or Settings.

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The ocsp_settings_responder_url_preferred of this SettingsCertificateValidation.
        :rtype: bool
        """
        return self._ocsp_settings_responder_url_preferred

    @ocsp_settings_responder_url_preferred.setter
    def ocsp_settings_responder_url_preferred(self, ocsp_settings_responder_url_preferred):
        """
        Sets the ocsp_settings_responder_url_preferred of this SettingsCertificateValidation.
        This setting says, OCSP Responder URL present in the issued certificate must be used. Otherwise, OCSP Responder URL from IDP or Settings.

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param ocsp_settings_responder_url_preferred: The ocsp_settings_responder_url_preferred of this SettingsCertificateValidation.
        :type: bool
        """
        self._ocsp_settings_responder_url_preferred = ocsp_settings_responder_url_preferred

    @property
    def ocsp_timeout_duration(self):
        """
        Gets the ocsp_timeout_duration of this SettingsCertificateValidation.
        The OCSP Timeout duration in minutes

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - idcsMaxValue: 10
         - idcsMinValue: 1
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The ocsp_timeout_duration of this SettingsCertificateValidation.
        :rtype: int
        """
        return self._ocsp_timeout_duration

    @ocsp_timeout_duration.setter
    def ocsp_timeout_duration(self, ocsp_timeout_duration):
        """
        Sets the ocsp_timeout_duration of this SettingsCertificateValidation.
        The OCSP Timeout duration in minutes

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - idcsMaxValue: 10
         - idcsMinValue: 1
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param ocsp_timeout_duration: The ocsp_timeout_duration of this SettingsCertificateValidation.
        :type: int
        """
        self._ocsp_timeout_duration = ocsp_timeout_duration

    @property
    def ocsp_signing_certificate_alias(self):
        """
        Gets the ocsp_signing_certificate_alias of this SettingsCertificateValidation.
        OCSP Signing Certificate Alias

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The ocsp_signing_certificate_alias of this SettingsCertificateValidation.
        :rtype: str
        """
        return self._ocsp_signing_certificate_alias

    @ocsp_signing_certificate_alias.setter
    def ocsp_signing_certificate_alias(self, ocsp_signing_certificate_alias):
        """
        Sets the ocsp_signing_certificate_alias of this SettingsCertificateValidation.
        OCSP Signing Certificate Alias

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param ocsp_signing_certificate_alias: The ocsp_signing_certificate_alias of this SettingsCertificateValidation.
        :type: str
        """
        self._ocsp_signing_certificate_alias = ocsp_signing_certificate_alias

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
