# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SchemaLocalizedDisplayName(object):
    """
    Attribute's localized display name

    **SCIM++ Properties:**
    - multiValued: false
    - mutability: readWrite
    - required: false
    - returned: default
    - type: complex
    - uniqueness: none
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SchemaLocalizedDisplayName object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param value:
            The value to assign to the value property of this SchemaLocalizedDisplayName.
        :type value: str

        :param locale:
            The value to assign to the locale property of this SchemaLocalizedDisplayName.
        :type locale: str

        """
        self.swagger_types = {
            'value': 'str',
            'locale': 'str'
        }

        self.attribute_map = {
            'value': 'value',
            'locale': 'locale'
        }

        self._value = None
        self._locale = None

    @property
    def value(self):
        """
        Gets the value of this SchemaLocalizedDisplayName.
        Localized display value

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The value of this SchemaLocalizedDisplayName.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this SchemaLocalizedDisplayName.
        Localized display value

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param value: The value of this SchemaLocalizedDisplayName.
        :type: str
        """
        self._value = value

    @property
    def locale(self):
        """
        Gets the locale of this SchemaLocalizedDisplayName.
        Locale used

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The locale of this SchemaLocalizedDisplayName.
        :rtype: str
        """
        return self._locale

    @locale.setter
    def locale(self, locale):
        """
        Sets the locale of this SchemaLocalizedDisplayName.
        Locale used

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param locale: The locale of this SchemaLocalizedDisplayName.
        :type: str
        """
        self._locale = locale

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
