# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SchemaAttributes(object):
    """
    A complex type that specifies the set of Resource attributes
    """

    #: A constant which can be used with the type property of a SchemaAttributes.
    #: This constant has a value of "string"
    TYPE_STRING = "string"

    #: A constant which can be used with the type property of a SchemaAttributes.
    #: This constant has a value of "complex"
    TYPE_COMPLEX = "complex"

    #: A constant which can be used with the type property of a SchemaAttributes.
    #: This constant has a value of "boolean"
    TYPE_BOOLEAN = "boolean"

    #: A constant which can be used with the type property of a SchemaAttributes.
    #: This constant has a value of "decimal"
    TYPE_DECIMAL = "decimal"

    #: A constant which can be used with the type property of a SchemaAttributes.
    #: This constant has a value of "integer"
    TYPE_INTEGER = "integer"

    #: A constant which can be used with the type property of a SchemaAttributes.
    #: This constant has a value of "dateTime"
    TYPE_DATE_TIME = "dateTime"

    #: A constant which can be used with the type property of a SchemaAttributes.
    #: This constant has a value of "reference"
    TYPE_REFERENCE = "reference"

    #: A constant which can be used with the type property of a SchemaAttributes.
    #: This constant has a value of "binary"
    TYPE_BINARY = "binary"

    #: A constant which can be used with the mutability property of a SchemaAttributes.
    #: This constant has a value of "readOnly"
    MUTABILITY_READ_ONLY = "readOnly"

    #: A constant which can be used with the mutability property of a SchemaAttributes.
    #: This constant has a value of "readWrite"
    MUTABILITY_READ_WRITE = "readWrite"

    #: A constant which can be used with the mutability property of a SchemaAttributes.
    #: This constant has a value of "immutable"
    MUTABILITY_IMMUTABLE = "immutable"

    #: A constant which can be used with the mutability property of a SchemaAttributes.
    #: This constant has a value of "writeOnly"
    MUTABILITY_WRITE_ONLY = "writeOnly"

    #: A constant which can be used with the returned property of a SchemaAttributes.
    #: This constant has a value of "always"
    RETURNED_ALWAYS = "always"

    #: A constant which can be used with the returned property of a SchemaAttributes.
    #: This constant has a value of "never"
    RETURNED_NEVER = "never"

    #: A constant which can be used with the returned property of a SchemaAttributes.
    #: This constant has a value of "default"
    RETURNED_DEFAULT = "default"

    #: A constant which can be used with the returned property of a SchemaAttributes.
    #: This constant has a value of "request"
    RETURNED_REQUEST = "request"

    #: A constant which can be used with the uniqueness property of a SchemaAttributes.
    #: This constant has a value of "none"
    UNIQUENESS_NONE = "none"

    #: A constant which can be used with the uniqueness property of a SchemaAttributes.
    #: This constant has a value of "server"
    UNIQUENESS_SERVER = "server"

    #: A constant which can be used with the uniqueness property of a SchemaAttributes.
    #: This constant has a value of "global"
    UNIQUENESS_GLOBAL = "global"

    #: A constant which can be used with the idcs_icf_attribute_type property of a SchemaAttributes.
    #: This constant has a value of "string"
    IDCS_ICF_ATTRIBUTE_TYPE_STRING = "string"

    #: A constant which can be used with the idcs_icf_attribute_type property of a SchemaAttributes.
    #: This constant has a value of "long"
    IDCS_ICF_ATTRIBUTE_TYPE_LONG = "long"

    #: A constant which can be used with the idcs_icf_attribute_type property of a SchemaAttributes.
    #: This constant has a value of "char"
    IDCS_ICF_ATTRIBUTE_TYPE_CHAR = "char"

    #: A constant which can be used with the idcs_icf_attribute_type property of a SchemaAttributes.
    #: This constant has a value of "double"
    IDCS_ICF_ATTRIBUTE_TYPE_DOUBLE = "double"

    #: A constant which can be used with the idcs_icf_attribute_type property of a SchemaAttributes.
    #: This constant has a value of "float"
    IDCS_ICF_ATTRIBUTE_TYPE_FLOAT = "float"

    #: A constant which can be used with the idcs_icf_attribute_type property of a SchemaAttributes.
    #: This constant has a value of "integer"
    IDCS_ICF_ATTRIBUTE_TYPE_INTEGER = "integer"

    #: A constant which can be used with the idcs_icf_attribute_type property of a SchemaAttributes.
    #: This constant has a value of "boolean"
    IDCS_ICF_ATTRIBUTE_TYPE_BOOLEAN = "boolean"

    #: A constant which can be used with the idcs_icf_attribute_type property of a SchemaAttributes.
    #: This constant has a value of "bytes"
    IDCS_ICF_ATTRIBUTE_TYPE_BYTES = "bytes"

    #: A constant which can be used with the idcs_icf_attribute_type property of a SchemaAttributes.
    #: This constant has a value of "bigdecimal"
    IDCS_ICF_ATTRIBUTE_TYPE_BIGDECIMAL = "bigdecimal"

    #: A constant which can be used with the idcs_icf_attribute_type property of a SchemaAttributes.
    #: This constant has a value of "biginteger"
    IDCS_ICF_ATTRIBUTE_TYPE_BIGINTEGER = "biginteger"

    #: A constant which can be used with the idcs_icf_attribute_type property of a SchemaAttributes.
    #: This constant has a value of "guardedbytes"
    IDCS_ICF_ATTRIBUTE_TYPE_GUARDEDBYTES = "guardedbytes"

    #: A constant which can be used with the idcs_icf_attribute_type property of a SchemaAttributes.
    #: This constant has a value of "guardedstring"
    IDCS_ICF_ATTRIBUTE_TYPE_GUARDEDSTRING = "guardedstring"

    #: A constant which can be used with the idcs_sensitive property of a SchemaAttributes.
    #: This constant has a value of "encrypt"
    IDCS_SENSITIVE_ENCRYPT = "encrypt"

    #: A constant which can be used with the idcs_sensitive property of a SchemaAttributes.
    #: This constant has a value of "hash"
    IDCS_SENSITIVE_HASH = "hash"

    #: A constant which can be used with the idcs_sensitive property of a SchemaAttributes.
    #: This constant has a value of "hash_sc"
    IDCS_SENSITIVE_HASH_SC = "hash_sc"

    #: A constant which can be used with the idcs_sensitive property of a SchemaAttributes.
    #: This constant has a value of "checksum"
    IDCS_SENSITIVE_CHECKSUM = "checksum"

    #: A constant which can be used with the idcs_sensitive property of a SchemaAttributes.
    #: This constant has a value of "none"
    IDCS_SENSITIVE_NONE = "none"

    #: A constant which can be used with the idcs_canonical_value_type property of a SchemaAttributes.
    #: This constant has a value of "dynamic"
    IDCS_CANONICAL_VALUE_TYPE_DYNAMIC = "dynamic"

    #: A constant which can be used with the idcs_canonical_value_type property of a SchemaAttributes.
    #: This constant has a value of "static"
    IDCS_CANONICAL_VALUE_TYPE_STATIC = "static"

    #: A constant which can be used with the idcsui_widget property of a SchemaAttributes.
    #: This constant has a value of "inputtext"
    IDCSUI_WIDGET_INPUTTEXT = "inputtext"

    #: A constant which can be used with the idcsui_widget property of a SchemaAttributes.
    #: This constant has a value of "checkbox"
    IDCSUI_WIDGET_CHECKBOX = "checkbox"

    #: A constant which can be used with the idcsui_widget property of a SchemaAttributes.
    #: This constant has a value of "textarea"
    IDCSUI_WIDGET_TEXTAREA = "textarea"

    #: A constant which can be used with the idcsui_widget property of a SchemaAttributes.
    #: This constant has a value of "combobox"
    IDCSUI_WIDGET_COMBOBOX = "combobox"

    #: A constant which can be used with the idcs_features property of a SchemaAttributes.
    #: This constant has a value of "optionalPii"
    IDCS_FEATURES_OPTIONAL_PII = "optionalPii"

    #: A constant which can be used with the idcs_features property of a SchemaAttributes.
    #: This constant has a value of "mfa"
    IDCS_FEATURES_MFA = "mfa"

    #: A constant which can be used with the idcs_features property of a SchemaAttributes.
    #: This constant has a value of "social"
    IDCS_FEATURES_SOCIAL = "social"

    #: A constant which can be used with the idcs_features property of a SchemaAttributes.
    #: This constant has a value of "schemaCustomization"
    IDCS_FEATURES_SCHEMA_CUSTOMIZATION = "schemaCustomization"

    def __init__(self, **kwargs):
        """
        Initializes a new SchemaAttributes object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this SchemaAttributes.
        :type name: str

        :param idcs_display_name_message_id:
            The value to assign to the idcs_display_name_message_id property of this SchemaAttributes.
        :type idcs_display_name_message_id: str

        :param idcs_rtsa_hide_attribute:
            The value to assign to the idcs_rtsa_hide_attribute property of this SchemaAttributes.
        :type idcs_rtsa_hide_attribute: bool

        :param localized_display_name:
            The value to assign to the localized_display_name property of this SchemaAttributes.
        :type localized_display_name: oci.identity_domains.models.SchemaLocalizedDisplayName

        :param type:
            The value to assign to the type property of this SchemaAttributes.
            Allowed values for this property are: "string", "complex", "boolean", "decimal", "integer", "dateTime", "reference", "binary", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param multi_valued:
            The value to assign to the multi_valued property of this SchemaAttributes.
        :type multi_valued: bool

        :param description:
            The value to assign to the description property of this SchemaAttributes.
        :type description: str

        :param required:
            The value to assign to the required property of this SchemaAttributes.
        :type required: bool

        :param idcs_return_empty_when_null:
            The value to assign to the idcs_return_empty_when_null property of this SchemaAttributes.
        :type idcs_return_empty_when_null: bool

        :param canonical_values:
            The value to assign to the canonical_values property of this SchemaAttributes.
        :type canonical_values: list[str]

        :param idcs_default_value:
            The value to assign to the idcs_default_value property of this SchemaAttributes.
        :type idcs_default_value: str

        :param localized_canonical_values:
            The value to assign to the localized_canonical_values property of this SchemaAttributes.
        :type localized_canonical_values: list[oci.identity_domains.models.SchemaLocalizedCanonicalValues]

        :param case_exact:
            The value to assign to the case_exact property of this SchemaAttributes.
        :type case_exact: bool

        :param mutability:
            The value to assign to the mutability property of this SchemaAttributes.
            Allowed values for this property are: "readOnly", "readWrite", "immutable", "writeOnly", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type mutability: str

        :param returned:
            The value to assign to the returned property of this SchemaAttributes.
            Allowed values for this property are: "always", "never", "default", "request", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type returned: str

        :param uniqueness:
            The value to assign to the uniqueness property of this SchemaAttributes.
            Allowed values for this property are: "none", "server", "global", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type uniqueness: str

        :param idcs_csv_attribute_name:
            The value to assign to the idcs_csv_attribute_name property of this SchemaAttributes.
        :type idcs_csv_attribute_name: str

        :param idcs_complex_attribute_name_mappings:
            The value to assign to the idcs_complex_attribute_name_mappings property of this SchemaAttributes.
        :type idcs_complex_attribute_name_mappings: list[oci.identity_domains.models.SchemaIdcsComplexAttributeNameMappings]

        :param idcs_icf_bundle_attribute_name:
            The value to assign to the idcs_icf_bundle_attribute_name property of this SchemaAttributes.
        :type idcs_icf_bundle_attribute_name: str

        :param idcs_icf_required:
            The value to assign to the idcs_icf_required property of this SchemaAttributes.
        :type idcs_icf_required: bool

        :param idcs_icf_attribute_type:
            The value to assign to the idcs_icf_attribute_type property of this SchemaAttributes.
            Allowed values for this property are: "string", "long", "char", "double", "float", "integer", "boolean", "bytes", "bigdecimal", "biginteger", "guardedbytes", "guardedstring", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type idcs_icf_attribute_type: str

        :param idcs_csv_attribute_name_mappings:
            The value to assign to the idcs_csv_attribute_name_mappings property of this SchemaAttributes.
        :type idcs_csv_attribute_name_mappings: list[oci.identity_domains.models.SchemaIdcsCsvAttributeNameMappings]

        :param reference_types:
            The value to assign to the reference_types property of this SchemaAttributes.
        :type reference_types: list[str]

        :param idcs_deprecated_since_version:
            The value to assign to the idcs_deprecated_since_version property of this SchemaAttributes.
        :type idcs_deprecated_since_version: int

        :param idcs_added_since_version:
            The value to assign to the idcs_added_since_version property of this SchemaAttributes.
        :type idcs_added_since_version: int

        :param idcs_deprecated_since_release_number:
            The value to assign to the idcs_deprecated_since_release_number property of this SchemaAttributes.
        :type idcs_deprecated_since_release_number: str

        :param idcs_added_since_release_number:
            The value to assign to the idcs_added_since_release_number property of this SchemaAttributes.
        :type idcs_added_since_release_number: str

        :param idcs_min_length:
            The value to assign to the idcs_min_length property of this SchemaAttributes.
        :type idcs_min_length: int

        :param idcs_max_length:
            The value to assign to the idcs_max_length property of this SchemaAttributes.
        :type idcs_max_length: int

        :param idcs_min_value:
            The value to assign to the idcs_min_value property of this SchemaAttributes.
        :type idcs_min_value: int

        :param idcs_max_value:
            The value to assign to the idcs_max_value property of this SchemaAttributes.
        :type idcs_max_value: int

        :param idcs_multi_language:
            The value to assign to the idcs_multi_language property of this SchemaAttributes.
        :type idcs_multi_language: bool

        :param idcs_ref_resource_attributes:
            The value to assign to the idcs_ref_resource_attributes property of this SchemaAttributes.
        :type idcs_ref_resource_attributes: list[str]

        :param idcs_indirect_ref_resource_attributes:
            The value to assign to the idcs_indirect_ref_resource_attributes property of this SchemaAttributes.
        :type idcs_indirect_ref_resource_attributes: list[str]

        :param idcs_auto_increment_seq_name:
            The value to assign to the idcs_auto_increment_seq_name property of this SchemaAttributes.
        :type idcs_auto_increment_seq_name: str

        :param idcs_value_persisted:
            The value to assign to the idcs_value_persisted property of this SchemaAttributes.
        :type idcs_value_persisted: bool

        :param idcs_sensitive:
            The value to assign to the idcs_sensitive property of this SchemaAttributes.
            Allowed values for this property are: "encrypt", "hash", "hash_sc", "checksum", "none", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type idcs_sensitive: str

        :param idcs_internal:
            The value to assign to the idcs_internal property of this SchemaAttributes.
        :type idcs_internal: bool

        :param idcs_trim_string_value:
            The value to assign to the idcs_trim_string_value property of this SchemaAttributes.
        :type idcs_trim_string_value: bool

        :param idcs_searchable:
            The value to assign to the idcs_searchable property of this SchemaAttributes.
        :type idcs_searchable: bool

        :param idcs_generated:
            The value to assign to the idcs_generated property of this SchemaAttributes.
        :type idcs_generated: bool

        :param idcs_auditable:
            The value to assign to the idcs_auditable property of this SchemaAttributes.
        :type idcs_auditable: bool

        :param idcs_target_attribute_name:
            The value to assign to the idcs_target_attribute_name property of this SchemaAttributes.
        :type idcs_target_attribute_name: str

        :param idcs_maps_to_same_target_attribute_name_as:
            The value to assign to the idcs_maps_to_same_target_attribute_name_as property of this SchemaAttributes.
        :type idcs_maps_to_same_target_attribute_name_as: str

        :param idcs_target_norm_attribute_name:
            The value to assign to the idcs_target_norm_attribute_name property of this SchemaAttributes.
        :type idcs_target_norm_attribute_name: str

        :param idcs_target_attribute_name_to_migrate_from:
            The value to assign to the idcs_target_attribute_name_to_migrate_from property of this SchemaAttributes.
        :type idcs_target_attribute_name_to_migrate_from: str

        :param idcs_target_unique_constraint_name:
            The value to assign to the idcs_target_unique_constraint_name property of this SchemaAttributes.
        :type idcs_target_unique_constraint_name: str

        :param idcs_to_target_mapper:
            The value to assign to the idcs_to_target_mapper property of this SchemaAttributes.
        :type idcs_to_target_mapper: str

        :param idcs_from_target_mapper:
            The value to assign to the idcs_from_target_mapper property of this SchemaAttributes.
        :type idcs_from_target_mapper: str

        :param idcs_display_name:
            The value to assign to the idcs_display_name property of this SchemaAttributes.
        :type idcs_display_name: str

        :param idcs_canonical_value_source_resource_type:
            The value to assign to the idcs_canonical_value_source_resource_type property of this SchemaAttributes.
        :type idcs_canonical_value_source_resource_type: str

        :param idcs_canonical_value_source_filter:
            The value to assign to the idcs_canonical_value_source_filter property of this SchemaAttributes.
        :type idcs_canonical_value_source_filter: str

        :param idcs_canonical_value_source_resource_type_id:
            The value to assign to the idcs_canonical_value_source_resource_type_id property of this SchemaAttributes.
        :type idcs_canonical_value_source_resource_type_id: str

        :param idcs_canonical_value_source_display_attr_name:
            The value to assign to the idcs_canonical_value_source_display_attr_name property of this SchemaAttributes.
        :type idcs_canonical_value_source_display_attr_name: str

        :param idcs_canonical_value_source_key_attr_name:
            The value to assign to the idcs_canonical_value_source_key_attr_name property of this SchemaAttributes.
        :type idcs_canonical_value_source_key_attr_name: str

        :param idcs_canonical_value_type:
            The value to assign to the idcs_canonical_value_type property of this SchemaAttributes.
            Allowed values for this property are: "dynamic", "static", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type idcs_canonical_value_type: str

        :param idcs_validate_reference:
            The value to assign to the idcs_validate_reference property of this SchemaAttributes.
        :type idcs_validate_reference: bool

        :param idcs_composite_key:
            The value to assign to the idcs_composite_key property of this SchemaAttributes.
        :type idcs_composite_key: list[str]

        :param idcs_fetch_complex_attribute_values:
            The value to assign to the idcs_fetch_complex_attribute_values property of this SchemaAttributes.
        :type idcs_fetch_complex_attribute_values: bool

        :param idcs_scim_compliant:
            The value to assign to the idcs_scim_compliant property of this SchemaAttributes.
        :type idcs_scim_compliant: bool

        :param idcs_attribute_mappable:
            The value to assign to the idcs_attribute_mappable property of this SchemaAttributes.
        :type idcs_attribute_mappable: bool

        :param idcs_value_persisted_in_other_attribute:
            The value to assign to the idcs_value_persisted_in_other_attribute property of this SchemaAttributes.
        :type idcs_value_persisted_in_other_attribute: bool

        :param idcs_pii:
            The value to assign to the idcs_pii property of this SchemaAttributes.
        :type idcs_pii: bool

        :param idcs_exclude_from_upgrade_patch:
            The value to assign to the idcs_exclude_from_upgrade_patch property of this SchemaAttributes.
        :type idcs_exclude_from_upgrade_patch: bool

        :param sub_attributes:
            The value to assign to the sub_attributes property of this SchemaAttributes.
        :type sub_attributes: list[oci.identity_domains.models.SchemaSubAttributes]

        :param idcs_ref_resource_attribute:
            The value to assign to the idcs_ref_resource_attribute property of this SchemaAttributes.
        :type idcs_ref_resource_attribute: str

        :param idcs_attribute_cacheable:
            The value to assign to the idcs_attribute_cacheable property of this SchemaAttributes.
        :type idcs_attribute_cacheable: bool

        :param idcsui_order:
            The value to assign to the idcsui_order property of this SchemaAttributes.
        :type idcsui_order: int

        :param idcsui_regexp:
            The value to assign to the idcsui_regexp property of this SchemaAttributes.
        :type idcsui_regexp: str

        :param idcsui_visible:
            The value to assign to the idcsui_visible property of this SchemaAttributes.
        :type idcsui_visible: bool

        :param idcsui_widget:
            The value to assign to the idcsui_widget property of this SchemaAttributes.
            Allowed values for this property are: "inputtext", "checkbox", "textarea", "combobox", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type idcsui_widget: str

        :param idcs_features:
            The value to assign to the idcs_features property of this SchemaAttributes.
            Allowed values for items in this list are: "optionalPii", "mfa", "social", "schemaCustomization", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type idcs_features: list[str]

        :param idcs_optional_pii_canonical_values:
            The value to assign to the idcs_optional_pii_canonical_values property of this SchemaAttributes.
        :type idcs_optional_pii_canonical_values: list[str]

        :param idcs_sanitize:
            The value to assign to the idcs_sanitize property of this SchemaAttributes.
        :type idcs_sanitize: bool

        :param idcs_override_common_attribute:
            The value to assign to the idcs_override_common_attribute property of this SchemaAttributes.
        :type idcs_override_common_attribute: bool

        :param idcs_ignore_read_only_and_immutable_ref_attrs_during_force_delete:
            The value to assign to the idcs_ignore_read_only_and_immutable_ref_attrs_during_force_delete property of this SchemaAttributes.
        :type idcs_ignore_read_only_and_immutable_ref_attrs_during_force_delete: bool

        :param idcs_allow_updates_in_read_only_mode:
            The value to assign to the idcs_allow_updates_in_read_only_mode property of this SchemaAttributes.
        :type idcs_allow_updates_in_read_only_mode: bool

        :param idcs_paginate_response:
            The value to assign to the idcs_paginate_response property of this SchemaAttributes.
        :type idcs_paginate_response: bool

        :param idcs_requires_write_for_access_flows:
            The value to assign to the idcs_requires_write_for_access_flows property of this SchemaAttributes.
        :type idcs_requires_write_for_access_flows: bool

        :param idcs_requires_immediate_read_after_write_for_access_flows:
            The value to assign to the idcs_requires_immediate_read_after_write_for_access_flows property of this SchemaAttributes.
        :type idcs_requires_immediate_read_after_write_for_access_flows: bool

        """
        self.swagger_types = {
            'name': 'str',
            'idcs_display_name_message_id': 'str',
            'idcs_rtsa_hide_attribute': 'bool',
            'localized_display_name': 'SchemaLocalizedDisplayName',
            'type': 'str',
            'multi_valued': 'bool',
            'description': 'str',
            'required': 'bool',
            'idcs_return_empty_when_null': 'bool',
            'canonical_values': 'list[str]',
            'idcs_default_value': 'str',
            'localized_canonical_values': 'list[SchemaLocalizedCanonicalValues]',
            'case_exact': 'bool',
            'mutability': 'str',
            'returned': 'str',
            'uniqueness': 'str',
            'idcs_csv_attribute_name': 'str',
            'idcs_complex_attribute_name_mappings': 'list[SchemaIdcsComplexAttributeNameMappings]',
            'idcs_icf_bundle_attribute_name': 'str',
            'idcs_icf_required': 'bool',
            'idcs_icf_attribute_type': 'str',
            'idcs_csv_attribute_name_mappings': 'list[SchemaIdcsCsvAttributeNameMappings]',
            'reference_types': 'list[str]',
            'idcs_deprecated_since_version': 'int',
            'idcs_added_since_version': 'int',
            'idcs_deprecated_since_release_number': 'str',
            'idcs_added_since_release_number': 'str',
            'idcs_min_length': 'int',
            'idcs_max_length': 'int',
            'idcs_min_value': 'int',
            'idcs_max_value': 'int',
            'idcs_multi_language': 'bool',
            'idcs_ref_resource_attributes': 'list[str]',
            'idcs_indirect_ref_resource_attributes': 'list[str]',
            'idcs_auto_increment_seq_name': 'str',
            'idcs_value_persisted': 'bool',
            'idcs_sensitive': 'str',
            'idcs_internal': 'bool',
            'idcs_trim_string_value': 'bool',
            'idcs_searchable': 'bool',
            'idcs_generated': 'bool',
            'idcs_auditable': 'bool',
            'idcs_target_attribute_name': 'str',
            'idcs_maps_to_same_target_attribute_name_as': 'str',
            'idcs_target_norm_attribute_name': 'str',
            'idcs_target_attribute_name_to_migrate_from': 'str',
            'idcs_target_unique_constraint_name': 'str',
            'idcs_to_target_mapper': 'str',
            'idcs_from_target_mapper': 'str',
            'idcs_display_name': 'str',
            'idcs_canonical_value_source_resource_type': 'str',
            'idcs_canonical_value_source_filter': 'str',
            'idcs_canonical_value_source_resource_type_id': 'str',
            'idcs_canonical_value_source_display_attr_name': 'str',
            'idcs_canonical_value_source_key_attr_name': 'str',
            'idcs_canonical_value_type': 'str',
            'idcs_validate_reference': 'bool',
            'idcs_composite_key': 'list[str]',
            'idcs_fetch_complex_attribute_values': 'bool',
            'idcs_scim_compliant': 'bool',
            'idcs_attribute_mappable': 'bool',
            'idcs_value_persisted_in_other_attribute': 'bool',
            'idcs_pii': 'bool',
            'idcs_exclude_from_upgrade_patch': 'bool',
            'sub_attributes': 'list[SchemaSubAttributes]',
            'idcs_ref_resource_attribute': 'str',
            'idcs_attribute_cacheable': 'bool',
            'idcsui_order': 'int',
            'idcsui_regexp': 'str',
            'idcsui_visible': 'bool',
            'idcsui_widget': 'str',
            'idcs_features': 'list[str]',
            'idcs_optional_pii_canonical_values': 'list[str]',
            'idcs_sanitize': 'bool',
            'idcs_override_common_attribute': 'bool',
            'idcs_ignore_read_only_and_immutable_ref_attrs_during_force_delete': 'bool',
            'idcs_allow_updates_in_read_only_mode': 'bool',
            'idcs_paginate_response': 'bool',
            'idcs_requires_write_for_access_flows': 'bool',
            'idcs_requires_immediate_read_after_write_for_access_flows': 'bool'
        }

        self.attribute_map = {
            'name': 'name',
            'idcs_display_name_message_id': 'idcsDisplayNameMessageId',
            'idcs_rtsa_hide_attribute': 'idcsRtsaHideAttribute',
            'localized_display_name': 'localizedDisplayName',
            'type': 'type',
            'multi_valued': 'multiValued',
            'description': 'description',
            'required': 'required',
            'idcs_return_empty_when_null': 'idcsReturnEmptyWhenNull',
            'canonical_values': 'canonicalValues',
            'idcs_default_value': 'idcsDefaultValue',
            'localized_canonical_values': 'localizedCanonicalValues',
            'case_exact': 'caseExact',
            'mutability': 'mutability',
            'returned': 'returned',
            'uniqueness': 'uniqueness',
            'idcs_csv_attribute_name': 'idcsCsvAttributeName',
            'idcs_complex_attribute_name_mappings': 'idcsComplexAttributeNameMappings',
            'idcs_icf_bundle_attribute_name': 'idcsICFBundleAttributeName',
            'idcs_icf_required': 'idcsICFRequired',
            'idcs_icf_attribute_type': 'idcsICFAttributeType',
            'idcs_csv_attribute_name_mappings': 'idcsCsvAttributeNameMappings',
            'reference_types': 'referenceTypes',
            'idcs_deprecated_since_version': 'idcsDeprecatedSinceVersion',
            'idcs_added_since_version': 'idcsAddedSinceVersion',
            'idcs_deprecated_since_release_number': 'idcsDeprecatedSinceReleaseNumber',
            'idcs_added_since_release_number': 'idcsAddedSinceReleaseNumber',
            'idcs_min_length': 'idcsMinLength',
            'idcs_max_length': 'idcsMaxLength',
            'idcs_min_value': 'idcsMinValue',
            'idcs_max_value': 'idcsMaxValue',
            'idcs_multi_language': 'idcsMultiLanguage',
            'idcs_ref_resource_attributes': 'idcsRefResourceAttributes',
            'idcs_indirect_ref_resource_attributes': 'idcsIndirectRefResourceAttributes',
            'idcs_auto_increment_seq_name': 'idcsAutoIncrementSeqName',
            'idcs_value_persisted': 'idcsValuePersisted',
            'idcs_sensitive': 'idcsSensitive',
            'idcs_internal': 'idcsInternal',
            'idcs_trim_string_value': 'idcsTrimStringValue',
            'idcs_searchable': 'idcsSearchable',
            'idcs_generated': 'idcsGenerated',
            'idcs_auditable': 'idcsAuditable',
            'idcs_target_attribute_name': 'idcsTargetAttributeName',
            'idcs_maps_to_same_target_attribute_name_as': 'idcsMapsToSameTargetAttributeNameAs',
            'idcs_target_norm_attribute_name': 'idcsTargetNormAttributeName',
            'idcs_target_attribute_name_to_migrate_from': 'idcsTargetAttributeNameToMigrateFrom',
            'idcs_target_unique_constraint_name': 'idcsTargetUniqueConstraintName',
            'idcs_to_target_mapper': 'idcsToTargetMapper',
            'idcs_from_target_mapper': 'idcsFromTargetMapper',
            'idcs_display_name': 'idcsDisplayName',
            'idcs_canonical_value_source_resource_type': 'idcsCanonicalValueSourceResourceType',
            'idcs_canonical_value_source_filter': 'idcsCanonicalValueSourceFilter',
            'idcs_canonical_value_source_resource_type_id': 'idcsCanonicalValueSourceResourceTypeID',
            'idcs_canonical_value_source_display_attr_name': 'idcsCanonicalValueSourceDisplayAttrName',
            'idcs_canonical_value_source_key_attr_name': 'idcsCanonicalValueSourceKeyAttrName',
            'idcs_canonical_value_type': 'idcsCanonicalValueType',
            'idcs_validate_reference': 'idcsValidateReference',
            'idcs_composite_key': 'idcsCompositeKey',
            'idcs_fetch_complex_attribute_values': 'idcsFetchComplexAttributeValues',
            'idcs_scim_compliant': 'idcsScimCompliant',
            'idcs_attribute_mappable': 'idcsAttributeMappable',
            'idcs_value_persisted_in_other_attribute': 'idcsValuePersistedInOtherAttribute',
            'idcs_pii': 'idcsPii',
            'idcs_exclude_from_upgrade_patch': 'idcsExcludeFromUpgradePatch',
            'sub_attributes': 'subAttributes',
            'idcs_ref_resource_attribute': 'idcsRefResourceAttribute',
            'idcs_attribute_cacheable': 'idcsAttributeCacheable',
            'idcsui_order': 'idcsuiOrder',
            'idcsui_regexp': 'idcsuiRegexp',
            'idcsui_visible': 'idcsuiVisible',
            'idcsui_widget': 'idcsuiWidget',
            'idcs_features': 'idcsFeatures',
            'idcs_optional_pii_canonical_values': 'idcsOptionalPiiCanonicalValues',
            'idcs_sanitize': 'idcsSanitize',
            'idcs_override_common_attribute': 'idcsOverrideCommonAttribute',
            'idcs_ignore_read_only_and_immutable_ref_attrs_during_force_delete': 'idcsIgnoreReadOnlyAndImmutableRefAttrsDuringForceDelete',
            'idcs_allow_updates_in_read_only_mode': 'idcsAllowUpdatesInReadOnlyMode',
            'idcs_paginate_response': 'idcsPaginateResponse',
            'idcs_requires_write_for_access_flows': 'idcsRequiresWriteForAccessFlows',
            'idcs_requires_immediate_read_after_write_for_access_flows': 'idcsRequiresImmediateReadAfterWriteForAccessFlows'
        }

        self._name = None
        self._idcs_display_name_message_id = None
        self._idcs_rtsa_hide_attribute = None
        self._localized_display_name = None
        self._type = None
        self._multi_valued = None
        self._description = None
        self._required = None
        self._idcs_return_empty_when_null = None
        self._canonical_values = None
        self._idcs_default_value = None
        self._localized_canonical_values = None
        self._case_exact = None
        self._mutability = None
        self._returned = None
        self._uniqueness = None
        self._idcs_csv_attribute_name = None
        self._idcs_complex_attribute_name_mappings = None
        self._idcs_icf_bundle_attribute_name = None
        self._idcs_icf_required = None
        self._idcs_icf_attribute_type = None
        self._idcs_csv_attribute_name_mappings = None
        self._reference_types = None
        self._idcs_deprecated_since_version = None
        self._idcs_added_since_version = None
        self._idcs_deprecated_since_release_number = None
        self._idcs_added_since_release_number = None
        self._idcs_min_length = None
        self._idcs_max_length = None
        self._idcs_min_value = None
        self._idcs_max_value = None
        self._idcs_multi_language = None
        self._idcs_ref_resource_attributes = None
        self._idcs_indirect_ref_resource_attributes = None
        self._idcs_auto_increment_seq_name = None
        self._idcs_value_persisted = None
        self._idcs_sensitive = None
        self._idcs_internal = None
        self._idcs_trim_string_value = None
        self._idcs_searchable = None
        self._idcs_generated = None
        self._idcs_auditable = None
        self._idcs_target_attribute_name = None
        self._idcs_maps_to_same_target_attribute_name_as = None
        self._idcs_target_norm_attribute_name = None
        self._idcs_target_attribute_name_to_migrate_from = None
        self._idcs_target_unique_constraint_name = None
        self._idcs_to_target_mapper = None
        self._idcs_from_target_mapper = None
        self._idcs_display_name = None
        self._idcs_canonical_value_source_resource_type = None
        self._idcs_canonical_value_source_filter = None
        self._idcs_canonical_value_source_resource_type_id = None
        self._idcs_canonical_value_source_display_attr_name = None
        self._idcs_canonical_value_source_key_attr_name = None
        self._idcs_canonical_value_type = None
        self._idcs_validate_reference = None
        self._idcs_composite_key = None
        self._idcs_fetch_complex_attribute_values = None
        self._idcs_scim_compliant = None
        self._idcs_attribute_mappable = None
        self._idcs_value_persisted_in_other_attribute = None
        self._idcs_pii = None
        self._idcs_exclude_from_upgrade_patch = None
        self._sub_attributes = None
        self._idcs_ref_resource_attribute = None
        self._idcs_attribute_cacheable = None
        self._idcsui_order = None
        self._idcsui_regexp = None
        self._idcsui_visible = None
        self._idcsui_widget = None
        self._idcs_features = None
        self._idcs_optional_pii_canonical_values = None
        self._idcs_sanitize = None
        self._idcs_override_common_attribute = None
        self._idcs_ignore_read_only_and_immutable_ref_attrs_during_force_delete = None
        self._idcs_allow_updates_in_read_only_mode = None
        self._idcs_paginate_response = None
        self._idcs_requires_write_for_access_flows = None
        self._idcs_requires_immediate_read_after_write_for_access_flows = None

    @property
    def name(self):
        """
        Gets the name of this SchemaAttributes.
        Attribute's name

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The name of this SchemaAttributes.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SchemaAttributes.
        Attribute's name

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param name: The name of this SchemaAttributes.
        :type: str
        """
        self._name = name

    @property
    def idcs_display_name_message_id(self):
        """
        Gets the idcs_display_name_message_id of this SchemaAttributes.
        Localized schema attribute display name for use by UI client  for displaying attribute labels

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_display_name_message_id of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_display_name_message_id

    @idcs_display_name_message_id.setter
    def idcs_display_name_message_id(self, idcs_display_name_message_id):
        """
        Sets the idcs_display_name_message_id of this SchemaAttributes.
        Localized schema attribute display name for use by UI client  for displaying attribute labels

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_display_name_message_id: The idcs_display_name_message_id of this SchemaAttributes.
        :type: str
        """
        self._idcs_display_name_message_id = idcs_display_name_message_id

    @property
    def idcs_rtsa_hide_attribute(self):
        """
        Gets the idcs_rtsa_hide_attribute of this SchemaAttributes.
        Specifies if the attributes in this schema should be hidden externally

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The idcs_rtsa_hide_attribute of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_rtsa_hide_attribute

    @idcs_rtsa_hide_attribute.setter
    def idcs_rtsa_hide_attribute(self, idcs_rtsa_hide_attribute):
        """
        Sets the idcs_rtsa_hide_attribute of this SchemaAttributes.
        Specifies if the attributes in this schema should be hidden externally

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param idcs_rtsa_hide_attribute: The idcs_rtsa_hide_attribute of this SchemaAttributes.
        :type: bool
        """
        self._idcs_rtsa_hide_attribute = idcs_rtsa_hide_attribute

    @property
    def localized_display_name(self):
        """
        Gets the localized_display_name of this SchemaAttributes.

        :return: The localized_display_name of this SchemaAttributes.
        :rtype: oci.identity_domains.models.SchemaLocalizedDisplayName
        """
        return self._localized_display_name

    @localized_display_name.setter
    def localized_display_name(self, localized_display_name):
        """
        Sets the localized_display_name of this SchemaAttributes.

        :param localized_display_name: The localized_display_name of this SchemaAttributes.
        :type: oci.identity_domains.models.SchemaLocalizedDisplayName
        """
        self._localized_display_name = localized_display_name

    @property
    def type(self):
        """
        Gets the type of this SchemaAttributes.
        The attribute's data type--for example, String

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "string", "complex", "boolean", "decimal", "integer", "dateTime", "reference", "binary", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this SchemaAttributes.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this SchemaAttributes.
        The attribute's data type--for example, String

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param type: The type of this SchemaAttributes.
        :type: str
        """
        allowed_values = ["string", "complex", "boolean", "decimal", "integer", "dateTime", "reference", "binary"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def multi_valued(self):
        """
        Gets the multi_valued of this SchemaAttributes.
        Indicates the attribute's plurality

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The multi_valued of this SchemaAttributes.
        :rtype: bool
        """
        return self._multi_valued

    @multi_valued.setter
    def multi_valued(self, multi_valued):
        """
        Sets the multi_valued of this SchemaAttributes.
        Indicates the attribute's plurality

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param multi_valued: The multi_valued of this SchemaAttributes.
        :type: bool
        """
        self._multi_valued = multi_valued

    @property
    def description(self):
        """
        Gets the description of this SchemaAttributes.
        The attribute's human-readable description

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The description of this SchemaAttributes.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this SchemaAttributes.
        The attribute's human-readable description

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param description: The description of this SchemaAttributes.
        :type: str
        """
        self._description = description

    @property
    def required(self):
        """
        Gets the required of this SchemaAttributes.
        Specifies if the attribute is required

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The required of this SchemaAttributes.
        :rtype: bool
        """
        return self._required

    @required.setter
    def required(self, required):
        """
        Sets the required of this SchemaAttributes.
        Specifies if the attribute is required

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param required: The required of this SchemaAttributes.
        :type: bool
        """
        self._required = required

    @property
    def idcs_return_empty_when_null(self):
        """
        Gets the idcs_return_empty_when_null of this SchemaAttributes.
        Specifies if the attribute is required

        **Added In:** 2305190132

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_return_empty_when_null of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_return_empty_when_null

    @idcs_return_empty_when_null.setter
    def idcs_return_empty_when_null(self, idcs_return_empty_when_null):
        """
        Sets the idcs_return_empty_when_null of this SchemaAttributes.
        Specifies if the attribute is required

        **Added In:** 2305190132

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param idcs_return_empty_when_null: The idcs_return_empty_when_null of this SchemaAttributes.
        :type: bool
        """
        self._idcs_return_empty_when_null = idcs_return_empty_when_null

    @property
    def canonical_values(self):
        """
        Gets the canonical_values of this SchemaAttributes.
        A collection of canonical values. Applicable Service Providers MUST specify the canonical types specified in the core schema specification--for example, \\\"work\\\", \\\"home\\\".

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The canonical_values of this SchemaAttributes.
        :rtype: list[str]
        """
        return self._canonical_values

    @canonical_values.setter
    def canonical_values(self, canonical_values):
        """
        Sets the canonical_values of this SchemaAttributes.
        A collection of canonical values. Applicable Service Providers MUST specify the canonical types specified in the core schema specification--for example, \\\"work\\\", \\\"home\\\".

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param canonical_values: The canonical_values of this SchemaAttributes.
        :type: list[str]
        """
        self._canonical_values = canonical_values

    @property
    def idcs_default_value(self):
        """
        Gets the idcs_default_value of this SchemaAttributes.
        Specifies the default value for an attribute. The value must be one from canonicalValues if defined.

        **Added In:** 18.1.6

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_default_value of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_default_value

    @idcs_default_value.setter
    def idcs_default_value(self, idcs_default_value):
        """
        Sets the idcs_default_value of this SchemaAttributes.
        Specifies the default value for an attribute. The value must be one from canonicalValues if defined.

        **Added In:** 18.1.6

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_default_value: The idcs_default_value of this SchemaAttributes.
        :type: str
        """
        self._idcs_default_value = idcs_default_value

    @property
    def localized_canonical_values(self):
        """
        Gets the localized_canonical_values of this SchemaAttributes.
        A collection of Localized canonical values.

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex


        :return: The localized_canonical_values of this SchemaAttributes.
        :rtype: list[oci.identity_domains.models.SchemaLocalizedCanonicalValues]
        """
        return self._localized_canonical_values

    @localized_canonical_values.setter
    def localized_canonical_values(self, localized_canonical_values):
        """
        Sets the localized_canonical_values of this SchemaAttributes.
        A collection of Localized canonical values.

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex


        :param localized_canonical_values: The localized_canonical_values of this SchemaAttributes.
        :type: list[oci.identity_domains.models.SchemaLocalizedCanonicalValues]
        """
        self._localized_canonical_values = localized_canonical_values

    @property
    def case_exact(self):
        """
        Gets the case_exact of this SchemaAttributes.
        Specifies if the String attribute is case-sensitive

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The case_exact of this SchemaAttributes.
        :rtype: bool
        """
        return self._case_exact

    @case_exact.setter
    def case_exact(self, case_exact):
        """
        Sets the case_exact of this SchemaAttributes.
        Specifies if the String attribute is case-sensitive

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param case_exact: The case_exact of this SchemaAttributes.
        :type: bool
        """
        self._case_exact = case_exact

    @property
    def mutability(self):
        """
        Gets the mutability of this SchemaAttributes.
        Specifies if the attribute is mutable

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "readOnly", "readWrite", "immutable", "writeOnly", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The mutability of this SchemaAttributes.
        :rtype: str
        """
        return self._mutability

    @mutability.setter
    def mutability(self, mutability):
        """
        Sets the mutability of this SchemaAttributes.
        Specifies if the attribute is mutable

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param mutability: The mutability of this SchemaAttributes.
        :type: str
        """
        allowed_values = ["readOnly", "readWrite", "immutable", "writeOnly"]
        if not value_allowed_none_or_none_sentinel(mutability, allowed_values):
            mutability = 'UNKNOWN_ENUM_VALUE'
        self._mutability = mutability

    @property
    def returned(self):
        """
        Gets the returned of this SchemaAttributes.
        A single keyword that indicates when an attribute and associated values are returned in response to a GET request or in response to a PUT, POST, or PATCH request

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "always", "never", "default", "request", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The returned of this SchemaAttributes.
        :rtype: str
        """
        return self._returned

    @returned.setter
    def returned(self, returned):
        """
        Sets the returned of this SchemaAttributes.
        A single keyword that indicates when an attribute and associated values are returned in response to a GET request or in response to a PUT, POST, or PATCH request

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param returned: The returned of this SchemaAttributes.
        :type: str
        """
        allowed_values = ["always", "never", "default", "request"]
        if not value_allowed_none_or_none_sentinel(returned, allowed_values):
            returned = 'UNKNOWN_ENUM_VALUE'
        self._returned = returned

    @property
    def uniqueness(self):
        """
        Gets the uniqueness of this SchemaAttributes.
        A single keyword value that specifies how the Service Provider enforces uniqueness of attribute values. A server MAY reject an invalid value based on uniqueness by returning an HTTP response code of 400 (Bad Request). A client MAY enforce uniqueness on the client side to a greater degree than the Service Provider enforces. For example, a client could make a value unique while the server has the uniqueness of \\\"none\\\".

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "none", "server", "global", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The uniqueness of this SchemaAttributes.
        :rtype: str
        """
        return self._uniqueness

    @uniqueness.setter
    def uniqueness(self, uniqueness):
        """
        Sets the uniqueness of this SchemaAttributes.
        A single keyword value that specifies how the Service Provider enforces uniqueness of attribute values. A server MAY reject an invalid value based on uniqueness by returning an HTTP response code of 400 (Bad Request). A client MAY enforce uniqueness on the client side to a greater degree than the Service Provider enforces. For example, a client could make a value unique while the server has the uniqueness of \\\"none\\\".

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param uniqueness: The uniqueness of this SchemaAttributes.
        :type: str
        """
        allowed_values = ["none", "server", "global"]
        if not value_allowed_none_or_none_sentinel(uniqueness, allowed_values):
            uniqueness = 'UNKNOWN_ENUM_VALUE'
        self._uniqueness = uniqueness

    @property
    def idcs_csv_attribute_name(self):
        """
        Gets the idcs_csv_attribute_name of this SchemaAttributes.
        The attribute defining the CSV header name for import/export

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_csv_attribute_name of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_csv_attribute_name

    @idcs_csv_attribute_name.setter
    def idcs_csv_attribute_name(self, idcs_csv_attribute_name):
        """
        Sets the idcs_csv_attribute_name of this SchemaAttributes.
        The attribute defining the CSV header name for import/export

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_csv_attribute_name: The idcs_csv_attribute_name of this SchemaAttributes.
        :type: str
        """
        self._idcs_csv_attribute_name = idcs_csv_attribute_name

    @property
    def idcs_complex_attribute_name_mappings(self):
        """
        Gets the idcs_complex_attribute_name_mappings of this SchemaAttributes.
        Specifies the mapping between external identity source attributes and Oracle Identity Cloud Service complex attributes (e.g. email => emails[work].value)

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex


        :return: The idcs_complex_attribute_name_mappings of this SchemaAttributes.
        :rtype: list[oci.identity_domains.models.SchemaIdcsComplexAttributeNameMappings]
        """
        return self._idcs_complex_attribute_name_mappings

    @idcs_complex_attribute_name_mappings.setter
    def idcs_complex_attribute_name_mappings(self, idcs_complex_attribute_name_mappings):
        """
        Sets the idcs_complex_attribute_name_mappings of this SchemaAttributes.
        Specifies the mapping between external identity source attributes and Oracle Identity Cloud Service complex attributes (e.g. email => emails[work].value)

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex


        :param idcs_complex_attribute_name_mappings: The idcs_complex_attribute_name_mappings of this SchemaAttributes.
        :type: list[oci.identity_domains.models.SchemaIdcsComplexAttributeNameMappings]
        """
        self._idcs_complex_attribute_name_mappings = idcs_complex_attribute_name_mappings

    @property
    def idcs_icf_bundle_attribute_name(self):
        """
        Gets the idcs_icf_bundle_attribute_name of this SchemaAttributes.
        Maps to ICF target attribute name

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_icf_bundle_attribute_name of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_icf_bundle_attribute_name

    @idcs_icf_bundle_attribute_name.setter
    def idcs_icf_bundle_attribute_name(self, idcs_icf_bundle_attribute_name):
        """
        Sets the idcs_icf_bundle_attribute_name of this SchemaAttributes.
        Maps to ICF target attribute name

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_icf_bundle_attribute_name: The idcs_icf_bundle_attribute_name of this SchemaAttributes.
        :type: str
        """
        self._idcs_icf_bundle_attribute_name = idcs_icf_bundle_attribute_name

    @property
    def idcs_icf_required(self):
        """
        Gets the idcs_icf_required of this SchemaAttributes.
        Metadata to identify the ICF required attribute

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The idcs_icf_required of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_icf_required

    @idcs_icf_required.setter
    def idcs_icf_required(self, idcs_icf_required):
        """
        Sets the idcs_icf_required of this SchemaAttributes.
        Metadata to identify the ICF required attribute

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param idcs_icf_required: The idcs_icf_required of this SchemaAttributes.
        :type: bool
        """
        self._idcs_icf_required = idcs_icf_required

    @property
    def idcs_icf_attribute_type(self):
        """
        Gets the idcs_icf_attribute_type of this SchemaAttributes.
        Maps to ICF data type

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "string", "long", "char", "double", "float", "integer", "boolean", "bytes", "bigdecimal", "biginteger", "guardedbytes", "guardedstring", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The idcs_icf_attribute_type of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_icf_attribute_type

    @idcs_icf_attribute_type.setter
    def idcs_icf_attribute_type(self, idcs_icf_attribute_type):
        """
        Sets the idcs_icf_attribute_type of this SchemaAttributes.
        Maps to ICF data type

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_icf_attribute_type: The idcs_icf_attribute_type of this SchemaAttributes.
        :type: str
        """
        allowed_values = ["string", "long", "char", "double", "float", "integer", "boolean", "bytes", "bigdecimal", "biginteger", "guardedbytes", "guardedstring"]
        if not value_allowed_none_or_none_sentinel(idcs_icf_attribute_type, allowed_values):
            idcs_icf_attribute_type = 'UNKNOWN_ENUM_VALUE'
        self._idcs_icf_attribute_type = idcs_icf_attribute_type

    @property
    def idcs_csv_attribute_name_mappings(self):
        """
        Gets the idcs_csv_attribute_name_mappings of this SchemaAttributes.
        Csv meta data for those resource type attributes which can be imported / exported from / to csv.

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex


        :return: The idcs_csv_attribute_name_mappings of this SchemaAttributes.
        :rtype: list[oci.identity_domains.models.SchemaIdcsCsvAttributeNameMappings]
        """
        return self._idcs_csv_attribute_name_mappings

    @idcs_csv_attribute_name_mappings.setter
    def idcs_csv_attribute_name_mappings(self, idcs_csv_attribute_name_mappings):
        """
        Sets the idcs_csv_attribute_name_mappings of this SchemaAttributes.
        Csv meta data for those resource type attributes which can be imported / exported from / to csv.

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex


        :param idcs_csv_attribute_name_mappings: The idcs_csv_attribute_name_mappings of this SchemaAttributes.
        :type: list[oci.identity_domains.models.SchemaIdcsCsvAttributeNameMappings]
        """
        self._idcs_csv_attribute_name_mappings = idcs_csv_attribute_name_mappings

    @property
    def reference_types(self):
        """
        Gets the reference_types of this SchemaAttributes.
        The names of the Resource types that may be referenced--for example, User. This is only applicable for attributes that are of the \\\"reference\\\" data type.

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The reference_types of this SchemaAttributes.
        :rtype: list[str]
        """
        return self._reference_types

    @reference_types.setter
    def reference_types(self, reference_types):
        """
        Sets the reference_types of this SchemaAttributes.
        The names of the Resource types that may be referenced--for example, User. This is only applicable for attributes that are of the \\\"reference\\\" data type.

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param reference_types: The reference_types of this SchemaAttributes.
        :type: list[str]
        """
        self._reference_types = reference_types

    @property
    def idcs_deprecated_since_version(self):
        """
        Gets the idcs_deprecated_since_version of this SchemaAttributes.
        Indicates that the schema has been deprecated since version

        **Deprecated Since: 19.3.3**

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer


        :return: The idcs_deprecated_since_version of this SchemaAttributes.
        :rtype: int
        """
        return self._idcs_deprecated_since_version

    @idcs_deprecated_since_version.setter
    def idcs_deprecated_since_version(self, idcs_deprecated_since_version):
        """
        Sets the idcs_deprecated_since_version of this SchemaAttributes.
        Indicates that the schema has been deprecated since version

        **Deprecated Since: 19.3.3**

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer


        :param idcs_deprecated_since_version: The idcs_deprecated_since_version of this SchemaAttributes.
        :type: int
        """
        self._idcs_deprecated_since_version = idcs_deprecated_since_version

    @property
    def idcs_added_since_version(self):
        """
        Gets the idcs_added_since_version of this SchemaAttributes.
        Indicates that the schema has been added since version

        **Deprecated Since: 19.3.3**

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer


        :return: The idcs_added_since_version of this SchemaAttributes.
        :rtype: int
        """
        return self._idcs_added_since_version

    @idcs_added_since_version.setter
    def idcs_added_since_version(self, idcs_added_since_version):
        """
        Sets the idcs_added_since_version of this SchemaAttributes.
        Indicates that the schema has been added since version

        **Deprecated Since: 19.3.3**

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer


        :param idcs_added_since_version: The idcs_added_since_version of this SchemaAttributes.
        :type: int
        """
        self._idcs_added_since_version = idcs_added_since_version

    @property
    def idcs_deprecated_since_release_number(self):
        """
        Gets the idcs_deprecated_since_release_number of this SchemaAttributes.
        Indicates that the schema has been deprecated since this release number

        **Added In:** 17.3.4

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :return: The idcs_deprecated_since_release_number of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_deprecated_since_release_number

    @idcs_deprecated_since_release_number.setter
    def idcs_deprecated_since_release_number(self, idcs_deprecated_since_release_number):
        """
        Sets the idcs_deprecated_since_release_number of this SchemaAttributes.
        Indicates that the schema has been deprecated since this release number

        **Added In:** 17.3.4

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :param idcs_deprecated_since_release_number: The idcs_deprecated_since_release_number of this SchemaAttributes.
        :type: str
        """
        self._idcs_deprecated_since_release_number = idcs_deprecated_since_release_number

    @property
    def idcs_added_since_release_number(self):
        """
        Gets the idcs_added_since_release_number of this SchemaAttributes.
        Indicates that the schema has been added since this release number

        **Added In:** 17.3.4

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :return: The idcs_added_since_release_number of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_added_since_release_number

    @idcs_added_since_release_number.setter
    def idcs_added_since_release_number(self, idcs_added_since_release_number):
        """
        Sets the idcs_added_since_release_number of this SchemaAttributes.
        Indicates that the schema has been added since this release number

        **Added In:** 17.3.4

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :param idcs_added_since_release_number: The idcs_added_since_release_number of this SchemaAttributes.
        :type: str
        """
        self._idcs_added_since_release_number = idcs_added_since_release_number

    @property
    def idcs_min_length(self):
        """
        Gets the idcs_min_length of this SchemaAttributes.
        Specifies the minimum length of the attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer


        :return: The idcs_min_length of this SchemaAttributes.
        :rtype: int
        """
        return self._idcs_min_length

    @idcs_min_length.setter
    def idcs_min_length(self, idcs_min_length):
        """
        Sets the idcs_min_length of this SchemaAttributes.
        Specifies the minimum length of the attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer


        :param idcs_min_length: The idcs_min_length of this SchemaAttributes.
        :type: int
        """
        self._idcs_min_length = idcs_min_length

    @property
    def idcs_max_length(self):
        """
        Gets the idcs_max_length of this SchemaAttributes.
        Specifies the maximum length of the attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer


        :return: The idcs_max_length of this SchemaAttributes.
        :rtype: int
        """
        return self._idcs_max_length

    @idcs_max_length.setter
    def idcs_max_length(self, idcs_max_length):
        """
        Sets the idcs_max_length of this SchemaAttributes.
        Specifies the maximum length of the attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer


        :param idcs_max_length: The idcs_max_length of this SchemaAttributes.
        :type: int
        """
        self._idcs_max_length = idcs_max_length

    @property
    def idcs_min_value(self):
        """
        Gets the idcs_min_value of this SchemaAttributes.
        Specifies the minimum value of the integer attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: integer


        :return: The idcs_min_value of this SchemaAttributes.
        :rtype: int
        """
        return self._idcs_min_value

    @idcs_min_value.setter
    def idcs_min_value(self, idcs_min_value):
        """
        Sets the idcs_min_value of this SchemaAttributes.
        Specifies the minimum value of the integer attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: integer


        :param idcs_min_value: The idcs_min_value of this SchemaAttributes.
        :type: int
        """
        self._idcs_min_value = idcs_min_value

    @property
    def idcs_max_value(self):
        """
        Gets the idcs_max_value of this SchemaAttributes.
        Specifies the maximum value of the integer attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: integer


        :return: The idcs_max_value of this SchemaAttributes.
        :rtype: int
        """
        return self._idcs_max_value

    @idcs_max_value.setter
    def idcs_max_value(self, idcs_max_value):
        """
        Sets the idcs_max_value of this SchemaAttributes.
        Specifies the maximum value of the integer attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: integer


        :param idcs_max_value: The idcs_max_value of this SchemaAttributes.
        :type: int
        """
        self._idcs_max_value = idcs_max_value

    @property
    def idcs_multi_language(self):
        """
        Gets the idcs_multi_language of this SchemaAttributes.
        If true, specifies that the attribute can have multiple language values set for the attribute on which this is set.

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The idcs_multi_language of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_multi_language

    @idcs_multi_language.setter
    def idcs_multi_language(self, idcs_multi_language):
        """
        Sets the idcs_multi_language of this SchemaAttributes.
        If true, specifies that the attribute can have multiple language values set for the attribute on which this is set.

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param idcs_multi_language: The idcs_multi_language of this SchemaAttributes.
        :type: bool
        """
        self._idcs_multi_language = idcs_multi_language

    @property
    def idcs_ref_resource_attributes(self):
        """
        Gets the idcs_ref_resource_attributes of this SchemaAttributes.
        Specifies the directly referenced Resources

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :return: The idcs_ref_resource_attributes of this SchemaAttributes.
        :rtype: list[str]
        """
        return self._idcs_ref_resource_attributes

    @idcs_ref_resource_attributes.setter
    def idcs_ref_resource_attributes(self, idcs_ref_resource_attributes):
        """
        Sets the idcs_ref_resource_attributes of this SchemaAttributes.
        Specifies the directly referenced Resources

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :param idcs_ref_resource_attributes: The idcs_ref_resource_attributes of this SchemaAttributes.
        :type: list[str]
        """
        self._idcs_ref_resource_attributes = idcs_ref_resource_attributes

    @property
    def idcs_indirect_ref_resource_attributes(self):
        """
        Gets the idcs_indirect_ref_resource_attributes of this SchemaAttributes.
        Specifies the indirectly referenced Resources

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :return: The idcs_indirect_ref_resource_attributes of this SchemaAttributes.
        :rtype: list[str]
        """
        return self._idcs_indirect_ref_resource_attributes

    @idcs_indirect_ref_resource_attributes.setter
    def idcs_indirect_ref_resource_attributes(self, idcs_indirect_ref_resource_attributes):
        """
        Sets the idcs_indirect_ref_resource_attributes of this SchemaAttributes.
        Specifies the indirectly referenced Resources

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :param idcs_indirect_ref_resource_attributes: The idcs_indirect_ref_resource_attributes of this SchemaAttributes.
        :type: list[str]
        """
        self._idcs_indirect_ref_resource_attributes = idcs_indirect_ref_resource_attributes

    @property
    def idcs_auto_increment_seq_name(self):
        """
        Gets the idcs_auto_increment_seq_name of this SchemaAttributes.
        Sequence tracking ID name for the attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :return: The idcs_auto_increment_seq_name of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_auto_increment_seq_name

    @idcs_auto_increment_seq_name.setter
    def idcs_auto_increment_seq_name(self, idcs_auto_increment_seq_name):
        """
        Sets the idcs_auto_increment_seq_name of this SchemaAttributes.
        Sequence tracking ID name for the attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :param idcs_auto_increment_seq_name: The idcs_auto_increment_seq_name of this SchemaAttributes.
        :type: str
        """
        self._idcs_auto_increment_seq_name = idcs_auto_increment_seq_name

    @property
    def idcs_value_persisted(self):
        """
        Gets the idcs_value_persisted of this SchemaAttributes.
        Specifies whether the value of the Resource attribute is persisted

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_value_persisted of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_value_persisted

    @idcs_value_persisted.setter
    def idcs_value_persisted(self, idcs_value_persisted):
        """
        Sets the idcs_value_persisted of this SchemaAttributes.
        Specifies whether the value of the Resource attribute is persisted

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param idcs_value_persisted: The idcs_value_persisted of this SchemaAttributes.
        :type: bool
        """
        self._idcs_value_persisted = idcs_value_persisted

    @property
    def idcs_sensitive(self):
        """
        Gets the idcs_sensitive of this SchemaAttributes.
        Flag to specify if the attribute should be encrypted or hashed

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "encrypt", "hash", "hash_sc", "checksum", "none", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The idcs_sensitive of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_sensitive

    @idcs_sensitive.setter
    def idcs_sensitive(self, idcs_sensitive):
        """
        Sets the idcs_sensitive of this SchemaAttributes.
        Flag to specify if the attribute should be encrypted or hashed

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_sensitive: The idcs_sensitive of this SchemaAttributes.
        :type: str
        """
        allowed_values = ["encrypt", "hash", "hash_sc", "checksum", "none"]
        if not value_allowed_none_or_none_sentinel(idcs_sensitive, allowed_values):
            idcs_sensitive = 'UNKNOWN_ENUM_VALUE'
        self._idcs_sensitive = idcs_sensitive

    @property
    def idcs_internal(self):
        """
        Gets the idcs_internal of this SchemaAttributes.
        Specifies whether the schema attribute is for internal use only. Internal attributes are not exposed via REST. This attribute overrides mutability for create/update if the request is internal and the attribute internalflag is set to True. This attribute overrides the return attribute while building SCIM response attributes when both the request is internal and the schema attribute is internal.

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_internal of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_internal

    @idcs_internal.setter
    def idcs_internal(self, idcs_internal):
        """
        Sets the idcs_internal of this SchemaAttributes.
        Specifies whether the schema attribute is for internal use only. Internal attributes are not exposed via REST. This attribute overrides mutability for create/update if the request is internal and the attribute internalflag is set to True. This attribute overrides the return attribute while building SCIM response attributes when both the request is internal and the schema attribute is internal.

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param idcs_internal: The idcs_internal of this SchemaAttributes.
        :type: bool
        """
        self._idcs_internal = idcs_internal

    @property
    def idcs_trim_string_value(self):
        """
        Gets the idcs_trim_string_value of this SchemaAttributes.
        Trims any leading and trailing blanks from String values. Default is True.

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_trim_string_value of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_trim_string_value

    @idcs_trim_string_value.setter
    def idcs_trim_string_value(self, idcs_trim_string_value):
        """
        Sets the idcs_trim_string_value of this SchemaAttributes.
        Trims any leading and trailing blanks from String values. Default is True.

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param idcs_trim_string_value: The idcs_trim_string_value of this SchemaAttributes.
        :type: bool
        """
        self._idcs_trim_string_value = idcs_trim_string_value

    @property
    def idcs_searchable(self):
        """
        Gets the idcs_searchable of this SchemaAttributes.
        Specifies whether this attribute can be included in a search filter

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_searchable of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_searchable

    @idcs_searchable.setter
    def idcs_searchable(self, idcs_searchable):
        """
        Sets the idcs_searchable of this SchemaAttributes.
        Specifies whether this attribute can be included in a search filter

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param idcs_searchable: The idcs_searchable of this SchemaAttributes.
        :type: bool
        """
        self._idcs_searchable = idcs_searchable

    @property
    def idcs_generated(self):
        """
        Gets the idcs_generated of this SchemaAttributes.
        Specifies whether this attribute value was generated

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_generated of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_generated

    @idcs_generated.setter
    def idcs_generated(self, idcs_generated):
        """
        Sets the idcs_generated of this SchemaAttributes.
        Specifies whether this attribute value was generated

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param idcs_generated: The idcs_generated of this SchemaAttributes.
        :type: bool
        """
        self._idcs_generated = idcs_generated

    @property
    def idcs_auditable(self):
        """
        Gets the idcs_auditable of this SchemaAttributes.
        Specifies whether changes to this attribute value are audited

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_auditable of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_auditable

    @idcs_auditable.setter
    def idcs_auditable(self, idcs_auditable):
        """
        Sets the idcs_auditable of this SchemaAttributes.
        Specifies whether changes to this attribute value are audited

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param idcs_auditable: The idcs_auditable of this SchemaAttributes.
        :type: bool
        """
        self._idcs_auditable = idcs_auditable

    @property
    def idcs_target_attribute_name(self):
        """
        Gets the idcs_target_attribute_name of this SchemaAttributes.
        Target attribute name that this attribute gets mapped to for persistence

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_target_attribute_name of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_target_attribute_name

    @idcs_target_attribute_name.setter
    def idcs_target_attribute_name(self, idcs_target_attribute_name):
        """
        Sets the idcs_target_attribute_name of this SchemaAttributes.
        Target attribute name that this attribute gets mapped to for persistence

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_target_attribute_name: The idcs_target_attribute_name of this SchemaAttributes.
        :type: str
        """
        self._idcs_target_attribute_name = idcs_target_attribute_name

    @property
    def idcs_maps_to_same_target_attribute_name_as(self):
        """
        Gets the idcs_maps_to_same_target_attribute_name_as of this SchemaAttributes.
        Contains the canonical name of the other attribute sharing the same idcsTargetAttributeName

        **Added In:** 2209122038

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: always
         - type: string
         - uniqueness: none


        :return: The idcs_maps_to_same_target_attribute_name_as of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_maps_to_same_target_attribute_name_as

    @idcs_maps_to_same_target_attribute_name_as.setter
    def idcs_maps_to_same_target_attribute_name_as(self, idcs_maps_to_same_target_attribute_name_as):
        """
        Sets the idcs_maps_to_same_target_attribute_name_as of this SchemaAttributes.
        Contains the canonical name of the other attribute sharing the same idcsTargetAttributeName

        **Added In:** 2209122038

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: always
         - type: string
         - uniqueness: none


        :param idcs_maps_to_same_target_attribute_name_as: The idcs_maps_to_same_target_attribute_name_as of this SchemaAttributes.
        :type: str
        """
        self._idcs_maps_to_same_target_attribute_name_as = idcs_maps_to_same_target_attribute_name_as

    @property
    def idcs_target_norm_attribute_name(self):
        """
        Gets the idcs_target_norm_attribute_name of this SchemaAttributes.
        Target normalized attribute name that this normalized value of attribute gets mapped to for persistence. Only set for caseExact=false & searchable attributes. Do not use by default.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_target_norm_attribute_name of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_target_norm_attribute_name

    @idcs_target_norm_attribute_name.setter
    def idcs_target_norm_attribute_name(self, idcs_target_norm_attribute_name):
        """
        Sets the idcs_target_norm_attribute_name of this SchemaAttributes.
        Target normalized attribute name that this normalized value of attribute gets mapped to for persistence. Only set for caseExact=false & searchable attributes. Do not use by default.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_target_norm_attribute_name: The idcs_target_norm_attribute_name of this SchemaAttributes.
        :type: str
        """
        self._idcs_target_norm_attribute_name = idcs_target_norm_attribute_name

    @property
    def idcs_target_attribute_name_to_migrate_from(self):
        """
        Gets the idcs_target_attribute_name_to_migrate_from of this SchemaAttributes.
        Old Target attribute name from child table for CSVA attribute prior to migration. This maintains this attribute used to get mapped to for persistence

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_target_attribute_name_to_migrate_from of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_target_attribute_name_to_migrate_from

    @idcs_target_attribute_name_to_migrate_from.setter
    def idcs_target_attribute_name_to_migrate_from(self, idcs_target_attribute_name_to_migrate_from):
        """
        Sets the idcs_target_attribute_name_to_migrate_from of this SchemaAttributes.
        Old Target attribute name from child table for CSVA attribute prior to migration. This maintains this attribute used to get mapped to for persistence

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_target_attribute_name_to_migrate_from: The idcs_target_attribute_name_to_migrate_from of this SchemaAttributes.
        :type: str
        """
        self._idcs_target_attribute_name_to_migrate_from = idcs_target_attribute_name_to_migrate_from

    @property
    def idcs_target_unique_constraint_name(self):
        """
        Gets the idcs_target_unique_constraint_name of this SchemaAttributes.
        Target index name created for this attribute for performance

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_target_unique_constraint_name of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_target_unique_constraint_name

    @idcs_target_unique_constraint_name.setter
    def idcs_target_unique_constraint_name(self, idcs_target_unique_constraint_name):
        """
        Sets the idcs_target_unique_constraint_name of this SchemaAttributes.
        Target index name created for this attribute for performance

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_target_unique_constraint_name: The idcs_target_unique_constraint_name of this SchemaAttributes.
        :type: str
        """
        self._idcs_target_unique_constraint_name = idcs_target_unique_constraint_name

    @property
    def idcs_to_target_mapper(self):
        """
        Gets the idcs_to_target_mapper of this SchemaAttributes.
        Specifies the mapper to use when mapping this attribute value to DataProvider-specific semantics

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_to_target_mapper of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_to_target_mapper

    @idcs_to_target_mapper.setter
    def idcs_to_target_mapper(self, idcs_to_target_mapper):
        """
        Sets the idcs_to_target_mapper of this SchemaAttributes.
        Specifies the mapper to use when mapping this attribute value to DataProvider-specific semantics

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_to_target_mapper: The idcs_to_target_mapper of this SchemaAttributes.
        :type: str
        """
        self._idcs_to_target_mapper = idcs_to_target_mapper

    @property
    def idcs_from_target_mapper(self):
        """
        Gets the idcs_from_target_mapper of this SchemaAttributes.
        Specifies the mapper to use when mapping this attribute value from DataProvider-specific semantics

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_from_target_mapper of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_from_target_mapper

    @idcs_from_target_mapper.setter
    def idcs_from_target_mapper(self, idcs_from_target_mapper):
        """
        Sets the idcs_from_target_mapper of this SchemaAttributes.
        Specifies the mapper to use when mapping this attribute value from DataProvider-specific semantics

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_from_target_mapper: The idcs_from_target_mapper of this SchemaAttributes.
        :type: str
        """
        self._idcs_from_target_mapper = idcs_from_target_mapper

    @property
    def idcs_display_name(self):
        """
        Gets the idcs_display_name of this SchemaAttributes.
        Specifies the user-friendly displayable attribute name or catalog key used for localization

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_display_name of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_display_name

    @idcs_display_name.setter
    def idcs_display_name(self, idcs_display_name):
        """
        Sets the idcs_display_name of this SchemaAttributes.
        Specifies the user-friendly displayable attribute name or catalog key used for localization

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_display_name: The idcs_display_name of this SchemaAttributes.
        :type: str
        """
        self._idcs_display_name = idcs_display_name

    @property
    def idcs_canonical_value_source_resource_type(self):
        """
        Gets the idcs_canonical_value_source_resource_type of this SchemaAttributes.
        Specifies the Resource type to read from for dynamic canonical values

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_canonical_value_source_resource_type of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_canonical_value_source_resource_type

    @idcs_canonical_value_source_resource_type.setter
    def idcs_canonical_value_source_resource_type(self, idcs_canonical_value_source_resource_type):
        """
        Sets the idcs_canonical_value_source_resource_type of this SchemaAttributes.
        Specifies the Resource type to read from for dynamic canonical values

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_canonical_value_source_resource_type: The idcs_canonical_value_source_resource_type of this SchemaAttributes.
        :type: str
        """
        self._idcs_canonical_value_source_resource_type = idcs_canonical_value_source_resource_type

    @property
    def idcs_canonical_value_source_filter(self):
        """
        Gets the idcs_canonical_value_source_filter of this SchemaAttributes.
        Filter to use when getting canonical values for this schema attribute

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_canonical_value_source_filter of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_canonical_value_source_filter

    @idcs_canonical_value_source_filter.setter
    def idcs_canonical_value_source_filter(self, idcs_canonical_value_source_filter):
        """
        Sets the idcs_canonical_value_source_filter of this SchemaAttributes.
        Filter to use when getting canonical values for this schema attribute

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_canonical_value_source_filter: The idcs_canonical_value_source_filter of this SchemaAttributes.
        :type: str
        """
        self._idcs_canonical_value_source_filter = idcs_canonical_value_source_filter

    @property
    def idcs_canonical_value_source_resource_type_id(self):
        """
        Gets the idcs_canonical_value_source_resource_type_id of this SchemaAttributes.
        Specifies the Resource type ID to read from for dynamic canonical values

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_canonical_value_source_resource_type_id of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_canonical_value_source_resource_type_id

    @idcs_canonical_value_source_resource_type_id.setter
    def idcs_canonical_value_source_resource_type_id(self, idcs_canonical_value_source_resource_type_id):
        """
        Sets the idcs_canonical_value_source_resource_type_id of this SchemaAttributes.
        Specifies the Resource type ID to read from for dynamic canonical values

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_canonical_value_source_resource_type_id: The idcs_canonical_value_source_resource_type_id of this SchemaAttributes.
        :type: str
        """
        self._idcs_canonical_value_source_resource_type_id = idcs_canonical_value_source_resource_type_id

    @property
    def idcs_canonical_value_source_display_attr_name(self):
        """
        Gets the idcs_canonical_value_source_display_attr_name of this SchemaAttributes.
        Display name for the canonical value attribute name.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_canonical_value_source_display_attr_name of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_canonical_value_source_display_attr_name

    @idcs_canonical_value_source_display_attr_name.setter
    def idcs_canonical_value_source_display_attr_name(self, idcs_canonical_value_source_display_attr_name):
        """
        Sets the idcs_canonical_value_source_display_attr_name of this SchemaAttributes.
        Display name for the canonical value attribute name.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_canonical_value_source_display_attr_name: The idcs_canonical_value_source_display_attr_name of this SchemaAttributes.
        :type: str
        """
        self._idcs_canonical_value_source_display_attr_name = idcs_canonical_value_source_display_attr_name

    @property
    def idcs_canonical_value_source_key_attr_name(self):
        """
        Gets the idcs_canonical_value_source_key_attr_name of this SchemaAttributes.
        Source key attribute for the canonical value.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_canonical_value_source_key_attr_name of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_canonical_value_source_key_attr_name

    @idcs_canonical_value_source_key_attr_name.setter
    def idcs_canonical_value_source_key_attr_name(self, idcs_canonical_value_source_key_attr_name):
        """
        Sets the idcs_canonical_value_source_key_attr_name of this SchemaAttributes.
        Source key attribute for the canonical value.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_canonical_value_source_key_attr_name: The idcs_canonical_value_source_key_attr_name of this SchemaAttributes.
        :type: str
        """
        self._idcs_canonical_value_source_key_attr_name = idcs_canonical_value_source_key_attr_name

    @property
    def idcs_canonical_value_type(self):
        """
        Gets the idcs_canonical_value_type of this SchemaAttributes.
        Type of the canonical value.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "dynamic", "static", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The idcs_canonical_value_type of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_canonical_value_type

    @idcs_canonical_value_type.setter
    def idcs_canonical_value_type(self, idcs_canonical_value_type):
        """
        Sets the idcs_canonical_value_type of this SchemaAttributes.
        Type of the canonical value.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_canonical_value_type: The idcs_canonical_value_type of this SchemaAttributes.
        :type: str
        """
        allowed_values = ["dynamic", "static"]
        if not value_allowed_none_or_none_sentinel(idcs_canonical_value_type, allowed_values):
            idcs_canonical_value_type = 'UNKNOWN_ENUM_VALUE'
        self._idcs_canonical_value_type = idcs_canonical_value_type

    @property
    def idcs_validate_reference(self):
        """
        Gets the idcs_validate_reference of this SchemaAttributes.
        Validate payload reference value during create, replace, and update. Default is True.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The idcs_validate_reference of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_validate_reference

    @idcs_validate_reference.setter
    def idcs_validate_reference(self, idcs_validate_reference):
        """
        Sets the idcs_validate_reference of this SchemaAttributes.
        Validate payload reference value during create, replace, and update. Default is True.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param idcs_validate_reference: The idcs_validate_reference of this SchemaAttributes.
        :type: bool
        """
        self._idcs_validate_reference = idcs_validate_reference

    @property
    def idcs_composite_key(self):
        """
        Gets the idcs_composite_key of this SchemaAttributes.
        The set of one or more sub attributes' names of a CMVA, whose values uniquely identify an instance of a CMVA

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_composite_key of this SchemaAttributes.
        :rtype: list[str]
        """
        return self._idcs_composite_key

    @idcs_composite_key.setter
    def idcs_composite_key(self, idcs_composite_key):
        """
        Sets the idcs_composite_key of this SchemaAttributes.
        The set of one or more sub attributes' names of a CMVA, whose values uniquely identify an instance of a CMVA

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_composite_key: The idcs_composite_key of this SchemaAttributes.
        :type: list[str]
        """
        self._idcs_composite_key = idcs_composite_key

    @property
    def idcs_fetch_complex_attribute_values(self):
        """
        Gets the idcs_fetch_complex_attribute_values of this SchemaAttributes.
        **SCIM++ Properties:**
        - caseExact: false
        - multiValued: false
        - mutability: readOnly
        - required: false
        - returned: default
        - type: boolean
        - uniqueness: none
        Whether the CMVA attribute will be fetched or not for current resource in AbstractResourceManager update operation before calling data provider update. Default is true.


        :return: The idcs_fetch_complex_attribute_values of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_fetch_complex_attribute_values

    @idcs_fetch_complex_attribute_values.setter
    def idcs_fetch_complex_attribute_values(self, idcs_fetch_complex_attribute_values):
        """
        Sets the idcs_fetch_complex_attribute_values of this SchemaAttributes.
        **SCIM++ Properties:**
        - caseExact: false
        - multiValued: false
        - mutability: readOnly
        - required: false
        - returned: default
        - type: boolean
        - uniqueness: none
        Whether the CMVA attribute will be fetched or not for current resource in AbstractResourceManager update operation before calling data provider update. Default is true.


        :param idcs_fetch_complex_attribute_values: The idcs_fetch_complex_attribute_values of this SchemaAttributes.
        :type: bool
        """
        self._idcs_fetch_complex_attribute_values = idcs_fetch_complex_attribute_values

    @property
    def idcs_scim_compliant(self):
        """
        Gets the idcs_scim_compliant of this SchemaAttributes.
        Indicates if the attribute is scim compliant, default is true

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_scim_compliant of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_scim_compliant

    @idcs_scim_compliant.setter
    def idcs_scim_compliant(self, idcs_scim_compliant):
        """
        Sets the idcs_scim_compliant of this SchemaAttributes.
        Indicates if the attribute is scim compliant, default is true

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean


        :param idcs_scim_compliant: The idcs_scim_compliant of this SchemaAttributes.
        :type: bool
        """
        self._idcs_scim_compliant = idcs_scim_compliant

    @property
    def idcs_attribute_mappable(self):
        """
        Gets the idcs_attribute_mappable of this SchemaAttributes.
        Specifies if the attribute can be used for mapping with external identity sources such as AD or LDAP. If isSchemaMappable: false for the schema in which this attribute is defined, then this flag is ignored

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_attribute_mappable of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_attribute_mappable

    @idcs_attribute_mappable.setter
    def idcs_attribute_mappable(self, idcs_attribute_mappable):
        """
        Sets the idcs_attribute_mappable of this SchemaAttributes.
        Specifies if the attribute can be used for mapping with external identity sources such as AD or LDAP. If isSchemaMappable: false for the schema in which this attribute is defined, then this flag is ignored

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean


        :param idcs_attribute_mappable: The idcs_attribute_mappable of this SchemaAttributes.
        :type: bool
        """
        self._idcs_attribute_mappable = idcs_attribute_mappable

    @property
    def idcs_value_persisted_in_other_attribute(self):
        """
        Gets the idcs_value_persisted_in_other_attribute of this SchemaAttributes.
        If true, ARM should not validate the value of the attribute since it will be converted/migrated to another attribute internally by the manager which will build valid post, put, or patch payload, depending on the client requested operation

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_value_persisted_in_other_attribute of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_value_persisted_in_other_attribute

    @idcs_value_persisted_in_other_attribute.setter
    def idcs_value_persisted_in_other_attribute(self, idcs_value_persisted_in_other_attribute):
        """
        Sets the idcs_value_persisted_in_other_attribute of this SchemaAttributes.
        If true, ARM should not validate the value of the attribute since it will be converted/migrated to another attribute internally by the manager which will build valid post, put, or patch payload, depending on the client requested operation

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param idcs_value_persisted_in_other_attribute: The idcs_value_persisted_in_other_attribute of this SchemaAttributes.
        :type: bool
        """
        self._idcs_value_persisted_in_other_attribute = idcs_value_persisted_in_other_attribute

    @property
    def idcs_pii(self):
        """
        Gets the idcs_pii of this SchemaAttributes.
        Specifies whether the attribute is PII (personal information). False by default for all attributes. If attribute with idcsPii = true, it's value must be obfuscated before it's written to the Oracle Identity Cloud Service system logs.

        **Added In:** 18.4.2

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_pii of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_pii

    @idcs_pii.setter
    def idcs_pii(self, idcs_pii):
        """
        Sets the idcs_pii of this SchemaAttributes.
        Specifies whether the attribute is PII (personal information). False by default for all attributes. If attribute with idcsPii = true, it's value must be obfuscated before it's written to the Oracle Identity Cloud Service system logs.

        **Added In:** 18.4.2

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean


        :param idcs_pii: The idcs_pii of this SchemaAttributes.
        :type: bool
        """
        self._idcs_pii = idcs_pii

    @property
    def idcs_exclude_from_upgrade_patch(self):
        """
        Gets the idcs_exclude_from_upgrade_patch of this SchemaAttributes.
        Specifies whether the attribute should be excluded from the BulkApi patch generated by gradle task for upgrading OOTB resources.

        **Added In:** 2104150946

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: never
         - type: boolean


        :return: The idcs_exclude_from_upgrade_patch of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_exclude_from_upgrade_patch

    @idcs_exclude_from_upgrade_patch.setter
    def idcs_exclude_from_upgrade_patch(self, idcs_exclude_from_upgrade_patch):
        """
        Sets the idcs_exclude_from_upgrade_patch of this SchemaAttributes.
        Specifies whether the attribute should be excluded from the BulkApi patch generated by gradle task for upgrading OOTB resources.

        **Added In:** 2104150946

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: never
         - type: boolean


        :param idcs_exclude_from_upgrade_patch: The idcs_exclude_from_upgrade_patch of this SchemaAttributes.
        :type: bool
        """
        self._idcs_exclude_from_upgrade_patch = idcs_exclude_from_upgrade_patch

    @property
    def sub_attributes(self):
        """
        Gets the sub_attributes of this SchemaAttributes.
        A list specifying the contained attributes

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex


        :return: The sub_attributes of this SchemaAttributes.
        :rtype: list[oci.identity_domains.models.SchemaSubAttributes]
        """
        return self._sub_attributes

    @sub_attributes.setter
    def sub_attributes(self, sub_attributes):
        """
        Sets the sub_attributes of this SchemaAttributes.
        A list specifying the contained attributes

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex


        :param sub_attributes: The sub_attributes of this SchemaAttributes.
        :type: list[oci.identity_domains.models.SchemaSubAttributes]
        """
        self._sub_attributes = sub_attributes

    @property
    def idcs_ref_resource_attribute(self):
        """
        Gets the idcs_ref_resource_attribute of this SchemaAttributes.
        Specifies the referenced Resource attribute

        **Deprecated Since: 17.3.4**

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :return: The idcs_ref_resource_attribute of this SchemaAttributes.
        :rtype: str
        """
        return self._idcs_ref_resource_attribute

    @idcs_ref_resource_attribute.setter
    def idcs_ref_resource_attribute(self, idcs_ref_resource_attribute):
        """
        Sets the idcs_ref_resource_attribute of this SchemaAttributes.
        Specifies the referenced Resource attribute

        **Deprecated Since: 17.3.4**

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :param idcs_ref_resource_attribute: The idcs_ref_resource_attribute of this SchemaAttributes.
        :type: str
        """
        self._idcs_ref_resource_attribute = idcs_ref_resource_attribute

    @property
    def idcs_attribute_cacheable(self):
        """
        Gets the idcs_attribute_cacheable of this SchemaAttributes.
        Specifies whether the attribute is cacheable. True by default for all attributes. If attribute with idcsAttributeCachable = false, is present \\\"attributesToGet\\\" while executing GET/SEARCH on cacheable resource, Cache is missed and data is fetched from Data Provider.

        **Added In:** 17.3.4

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_attribute_cacheable of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_attribute_cacheable

    @idcs_attribute_cacheable.setter
    def idcs_attribute_cacheable(self, idcs_attribute_cacheable):
        """
        Sets the idcs_attribute_cacheable of this SchemaAttributes.
        Specifies whether the attribute is cacheable. True by default for all attributes. If attribute with idcsAttributeCachable = false, is present \\\"attributesToGet\\\" while executing GET/SEARCH on cacheable resource, Cache is missed and data is fetched from Data Provider.

        **Added In:** 17.3.4

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param idcs_attribute_cacheable: The idcs_attribute_cacheable of this SchemaAttributes.
        :type: bool
        """
        self._idcs_attribute_cacheable = idcs_attribute_cacheable

    @property
    def idcsui_order(self):
        """
        Gets the idcsui_order of this SchemaAttributes.
        Metadata used by Oracle Identity Cloud Service UI to sequence the attributes displayed on the Account Form.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer


        :return: The idcsui_order of this SchemaAttributes.
        :rtype: int
        """
        return self._idcsui_order

    @idcsui_order.setter
    def idcsui_order(self, idcsui_order):
        """
        Sets the idcsui_order of this SchemaAttributes.
        Metadata used by Oracle Identity Cloud Service UI to sequence the attributes displayed on the Account Form.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer


        :param idcsui_order: The idcsui_order of this SchemaAttributes.
        :type: int
        """
        self._idcsui_order = idcsui_order

    @property
    def idcsui_regexp(self):
        """
        Gets the idcsui_regexp of this SchemaAttributes.
        Metadata used by Oracle Identity Cloud Service UI to validate the attribute values using regular expressions.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :return: The idcsui_regexp of this SchemaAttributes.
        :rtype: str
        """
        return self._idcsui_regexp

    @idcsui_regexp.setter
    def idcsui_regexp(self, idcsui_regexp):
        """
        Sets the idcsui_regexp of this SchemaAttributes.
        Metadata used by Oracle Identity Cloud Service UI to validate the attribute values using regular expressions.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :param idcsui_regexp: The idcsui_regexp of this SchemaAttributes.
        :type: str
        """
        self._idcsui_regexp = idcsui_regexp

    @property
    def idcsui_visible(self):
        """
        Gets the idcsui_visible of this SchemaAttributes.
        Metadata used by Oracle Identity Cloud Service UI to decide whether the attribute must be displayed on the Account Form.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The idcsui_visible of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcsui_visible

    @idcsui_visible.setter
    def idcsui_visible(self, idcsui_visible):
        """
        Sets the idcsui_visible of this SchemaAttributes.
        Metadata used by Oracle Identity Cloud Service UI to decide whether the attribute must be displayed on the Account Form.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param idcsui_visible: The idcsui_visible of this SchemaAttributes.
        :type: bool
        """
        self._idcsui_visible = idcsui_visible

    @property
    def idcsui_widget(self):
        """
        Gets the idcsui_widget of this SchemaAttributes.
        Metadata used by Oracle Identity Cloud Service UI to render a widget for this attribute on the Account Form.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string

        Allowed values for this property are: "inputtext", "checkbox", "textarea", "combobox", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The idcsui_widget of this SchemaAttributes.
        :rtype: str
        """
        return self._idcsui_widget

    @idcsui_widget.setter
    def idcsui_widget(self, idcsui_widget):
        """
        Sets the idcsui_widget of this SchemaAttributes.
        Metadata used by Oracle Identity Cloud Service UI to render a widget for this attribute on the Account Form.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :param idcsui_widget: The idcsui_widget of this SchemaAttributes.
        :type: str
        """
        allowed_values = ["inputtext", "checkbox", "textarea", "combobox"]
        if not value_allowed_none_or_none_sentinel(idcsui_widget, allowed_values):
            idcsui_widget = 'UNKNOWN_ENUM_VALUE'
        self._idcsui_widget = idcsui_widget

    @property
    def idcs_features(self):
        """
        Gets the idcs_features of this SchemaAttributes.
        The list of features that require this attribute

        **Deprecated Since: 19.1.6**

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string

        Allowed values for items in this list are: "optionalPii", "mfa", "social", "schemaCustomization", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The idcs_features of this SchemaAttributes.
        :rtype: list[str]
        """
        return self._idcs_features

    @idcs_features.setter
    def idcs_features(self, idcs_features):
        """
        Sets the idcs_features of this SchemaAttributes.
        The list of features that require this attribute

        **Deprecated Since: 19.1.6**

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :param idcs_features: The idcs_features of this SchemaAttributes.
        :type: list[str]
        """
        allowed_values = ["optionalPii", "mfa", "social", "schemaCustomization"]
        if idcs_features:
            idcs_features[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in idcs_features]
        self._idcs_features = idcs_features

    @property
    def idcs_optional_pii_canonical_values(self):
        """
        Gets the idcs_optional_pii_canonical_values of this SchemaAttributes.
        A subset of \\\"canonicalValues\\\" that are not supported when the \\\"optionalPii\\\" feature is disabled in GlobalConfig.

        **Deprecated Since: 19.1.6**

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_optional_pii_canonical_values of this SchemaAttributes.
        :rtype: list[str]
        """
        return self._idcs_optional_pii_canonical_values

    @idcs_optional_pii_canonical_values.setter
    def idcs_optional_pii_canonical_values(self, idcs_optional_pii_canonical_values):
        """
        Sets the idcs_optional_pii_canonical_values of this SchemaAttributes.
        A subset of \\\"canonicalValues\\\" that are not supported when the \\\"optionalPii\\\" feature is disabled in GlobalConfig.

        **Deprecated Since: 19.1.6**

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_optional_pii_canonical_values: The idcs_optional_pii_canonical_values of this SchemaAttributes.
        :type: list[str]
        """
        self._idcs_optional_pii_canonical_values = idcs_optional_pii_canonical_values

    @property
    def idcs_sanitize(self):
        """
        Gets the idcs_sanitize of this SchemaAttributes.
        Specifies if the value of the attribute should be sanitized using OWASP library for HTML content

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The idcs_sanitize of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_sanitize

    @idcs_sanitize.setter
    def idcs_sanitize(self, idcs_sanitize):
        """
        Sets the idcs_sanitize of this SchemaAttributes.
        Specifies if the value of the attribute should be sanitized using OWASP library for HTML content

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param idcs_sanitize: The idcs_sanitize of this SchemaAttributes.
        :type: bool
        """
        self._idcs_sanitize = idcs_sanitize

    @property
    def idcs_override_common_attribute(self):
        """
        Gets the idcs_override_common_attribute of this SchemaAttributes.
        Specifies whether the attribute from resource schema should override from common schema with the same name.

        **Added In:** 2102181953

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_override_common_attribute of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_override_common_attribute

    @idcs_override_common_attribute.setter
    def idcs_override_common_attribute(self, idcs_override_common_attribute):
        """
        Sets the idcs_override_common_attribute of this SchemaAttributes.
        Specifies whether the attribute from resource schema should override from common schema with the same name.

        **Added In:** 2102181953

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean


        :param idcs_override_common_attribute: The idcs_override_common_attribute of this SchemaAttributes.
        :type: bool
        """
        self._idcs_override_common_attribute = idcs_override_common_attribute

    @property
    def idcs_ignore_read_only_and_immutable_ref_attrs_during_force_delete(self):
        """
        Gets the idcs_ignore_read_only_and_immutable_ref_attrs_during_force_delete of this SchemaAttributes.
        Specifies whether the readOnly and immutable reference attributes should be ignored when forceDelete=true.

        **Added In:** 2104220644

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The idcs_ignore_read_only_and_immutable_ref_attrs_during_force_delete of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_ignore_read_only_and_immutable_ref_attrs_during_force_delete

    @idcs_ignore_read_only_and_immutable_ref_attrs_during_force_delete.setter
    def idcs_ignore_read_only_and_immutable_ref_attrs_during_force_delete(self, idcs_ignore_read_only_and_immutable_ref_attrs_during_force_delete):
        """
        Sets the idcs_ignore_read_only_and_immutable_ref_attrs_during_force_delete of this SchemaAttributes.
        Specifies whether the readOnly and immutable reference attributes should be ignored when forceDelete=true.

        **Added In:** 2104220644

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param idcs_ignore_read_only_and_immutable_ref_attrs_during_force_delete: The idcs_ignore_read_only_and_immutable_ref_attrs_during_force_delete of this SchemaAttributes.
        :type: bool
        """
        self._idcs_ignore_read_only_and_immutable_ref_attrs_during_force_delete = idcs_ignore_read_only_and_immutable_ref_attrs_during_force_delete

    @property
    def idcs_allow_updates_in_read_only_mode(self):
        """
        Gets the idcs_allow_updates_in_read_only_mode of this SchemaAttributes.
        Set this attribute to True if the resource is eligibal for update while system is in readonly mode.

        **Added In:** 2106170416

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The idcs_allow_updates_in_read_only_mode of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_allow_updates_in_read_only_mode

    @idcs_allow_updates_in_read_only_mode.setter
    def idcs_allow_updates_in_read_only_mode(self, idcs_allow_updates_in_read_only_mode):
        """
        Sets the idcs_allow_updates_in_read_only_mode of this SchemaAttributes.
        Set this attribute to True if the resource is eligibal for update while system is in readonly mode.

        **Added In:** 2106170416

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param idcs_allow_updates_in_read_only_mode: The idcs_allow_updates_in_read_only_mode of this SchemaAttributes.
        :type: bool
        """
        self._idcs_allow_updates_in_read_only_mode = idcs_allow_updates_in_read_only_mode

    @property
    def idcs_paginate_response(self):
        """
        Gets the idcs_paginate_response of this SchemaAttributes.
        Set this attribute to True if the pagination is required on an attribute.

        **Added In:** 2202230830

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The idcs_paginate_response of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_paginate_response

    @idcs_paginate_response.setter
    def idcs_paginate_response(self, idcs_paginate_response):
        """
        Sets the idcs_paginate_response of this SchemaAttributes.
        Set this attribute to True if the pagination is required on an attribute.

        **Added In:** 2202230830

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param idcs_paginate_response: The idcs_paginate_response of this SchemaAttributes.
        :type: bool
        """
        self._idcs_paginate_response = idcs_paginate_response

    @property
    def idcs_requires_write_for_access_flows(self):
        """
        Gets the idcs_requires_write_for_access_flows of this SchemaAttributes.
        If true, indicates that the attribute value must be written to the home region for access flows initiated from a replica region.

        **Added In:** 2209220956

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The idcs_requires_write_for_access_flows of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_requires_write_for_access_flows

    @idcs_requires_write_for_access_flows.setter
    def idcs_requires_write_for_access_flows(self, idcs_requires_write_for_access_flows):
        """
        Sets the idcs_requires_write_for_access_flows of this SchemaAttributes.
        If true, indicates that the attribute value must be written to the home region for access flows initiated from a replica region.

        **Added In:** 2209220956

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param idcs_requires_write_for_access_flows: The idcs_requires_write_for_access_flows of this SchemaAttributes.
        :type: bool
        """
        self._idcs_requires_write_for_access_flows = idcs_requires_write_for_access_flows

    @property
    def idcs_requires_immediate_read_after_write_for_access_flows(self):
        """
        Gets the idcs_requires_immediate_read_after_write_for_access_flows of this SchemaAttributes.
        If true, indicates that the attribute value must be written to the home region and requires immediate read-after-write consistency for access flows initiated from a replica region.

        **Added In:** 2209220956

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: never
         - type: boolean


        :return: The idcs_requires_immediate_read_after_write_for_access_flows of this SchemaAttributes.
        :rtype: bool
        """
        return self._idcs_requires_immediate_read_after_write_for_access_flows

    @idcs_requires_immediate_read_after_write_for_access_flows.setter
    def idcs_requires_immediate_read_after_write_for_access_flows(self, idcs_requires_immediate_read_after_write_for_access_flows):
        """
        Sets the idcs_requires_immediate_read_after_write_for_access_flows of this SchemaAttributes.
        If true, indicates that the attribute value must be written to the home region and requires immediate read-after-write consistency for access flows initiated from a replica region.

        **Added In:** 2209220956

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: never
         - type: boolean


        :param idcs_requires_immediate_read_after_write_for_access_flows: The idcs_requires_immediate_read_after_write_for_access_flows of this SchemaAttributes.
        :type: bool
        """
        self._idcs_requires_immediate_read_after_write_for_access_flows = idcs_requires_immediate_read_after_write_for_access_flows

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
