# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Schema(object):
    """
    SCIM schema
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Schema object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param schemas:
            The value to assign to the schemas property of this Schema.
        :type schemas: list[str]

        :param idcs_maps_to_same_target_attribute_name_as:
            The value to assign to the idcs_maps_to_same_target_attribute_name_as property of this Schema.
        :type idcs_maps_to_same_target_attribute_name_as: str

        :param external_id:
            The value to assign to the external_id property of this Schema.
        :type external_id: str

        :param name:
            The value to assign to the name property of this Schema.
        :type name: str

        :param idcs_resource_types:
            The value to assign to the idcs_resource_types property of this Schema.
        :type idcs_resource_types: list[str]

        :param description:
            The value to assign to the description property of this Schema.
        :type description: str

        :param idcs_mappable:
            The value to assign to the idcs_mappable property of this Schema.
        :type idcs_mappable: bool

        :param idcs_attribute_cacheable:
            The value to assign to the idcs_attribute_cacheable property of this Schema.
        :type idcs_attribute_cacheable: bool

        :param idcs_override_common_attribute:
            The value to assign to the idcs_override_common_attribute property of this Schema.
        :type idcs_override_common_attribute: bool

        :param attributes:
            The value to assign to the attributes property of this Schema.
        :type attributes: list[oci.identity_domains.models.SchemaAttributes]

        """
        self.swagger_types = {
            'schemas': 'list[str]',
            'idcs_maps_to_same_target_attribute_name_as': 'str',
            'external_id': 'str',
            'name': 'str',
            'idcs_resource_types': 'list[str]',
            'description': 'str',
            'idcs_mappable': 'bool',
            'idcs_attribute_cacheable': 'bool',
            'idcs_override_common_attribute': 'bool',
            'attributes': 'list[SchemaAttributes]'
        }

        self.attribute_map = {
            'schemas': 'schemas',
            'idcs_maps_to_same_target_attribute_name_as': 'idcsMapsToSameTargetAttributeNameAs',
            'external_id': 'externalId',
            'name': 'name',
            'idcs_resource_types': 'idcsResourceTypes',
            'description': 'description',
            'idcs_mappable': 'idcsMappable',
            'idcs_attribute_cacheable': 'idcsAttributeCacheable',
            'idcs_override_common_attribute': 'idcsOverrideCommonAttribute',
            'attributes': 'attributes'
        }

        self._schemas = None
        self._idcs_maps_to_same_target_attribute_name_as = None
        self._external_id = None
        self._name = None
        self._idcs_resource_types = None
        self._description = None
        self._idcs_mappable = None
        self._idcs_attribute_cacheable = None
        self._idcs_override_common_attribute = None
        self._attributes = None

    @property
    def schemas(self):
        """
        **[Required]** Gets the schemas of this Schema.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The schemas of this Schema.
        :rtype: list[str]
        """
        return self._schemas

    @schemas.setter
    def schemas(self, schemas):
        """
        Sets the schemas of this Schema.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param schemas: The schemas of this Schema.
        :type: list[str]
        """
        self._schemas = schemas

    @property
    def idcs_maps_to_same_target_attribute_name_as(self):
        """
        Gets the idcs_maps_to_same_target_attribute_name_as of this Schema.
        Contains the canonical name of the other attribute sharing the same idcsTargetAttributeName

        **Added In:** 2209122038

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: always
         - type: string
         - uniqueness: none


        :return: The idcs_maps_to_same_target_attribute_name_as of this Schema.
        :rtype: str
        """
        return self._idcs_maps_to_same_target_attribute_name_as

    @idcs_maps_to_same_target_attribute_name_as.setter
    def idcs_maps_to_same_target_attribute_name_as(self, idcs_maps_to_same_target_attribute_name_as):
        """
        Sets the idcs_maps_to_same_target_attribute_name_as of this Schema.
        Contains the canonical name of the other attribute sharing the same idcsTargetAttributeName

        **Added In:** 2209122038

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: always
         - type: string
         - uniqueness: none


        :param idcs_maps_to_same_target_attribute_name_as: The idcs_maps_to_same_target_attribute_name_as of this Schema.
        :type: str
        """
        self._idcs_maps_to_same_target_attribute_name_as = idcs_maps_to_same_target_attribute_name_as

    @property
    def external_id(self):
        """
        Gets the external_id of this Schema.
        An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The external_id of this Schema.
        :rtype: str
        """
        return self._external_id

    @external_id.setter
    def external_id(self, external_id):
        """
        Sets the external_id of this Schema.
        An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param external_id: The external_id of this Schema.
        :type: str
        """
        self._external_id = external_id

    @property
    def name(self):
        """
        Gets the name of this Schema.
        Schema's human-readable name

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The name of this Schema.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Schema.
        Schema's human-readable name

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param name: The name of this Schema.
        :type: str
        """
        self._name = name

    @property
    def idcs_resource_types(self):
        """
        Gets the idcs_resource_types of this Schema.
        Resource types defs this resource refers to

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_resource_types of this Schema.
        :rtype: list[str]
        """
        return self._idcs_resource_types

    @idcs_resource_types.setter
    def idcs_resource_types(self, idcs_resource_types):
        """
        Sets the idcs_resource_types of this Schema.
        Resource types defs this resource refers to

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_resource_types: The idcs_resource_types of this Schema.
        :type: list[str]
        """
        self._idcs_resource_types = idcs_resource_types

    @property
    def description(self):
        """
        Gets the description of this Schema.
        Schema's human-readable description

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The description of this Schema.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Schema.
        Schema's human-readable description

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param description: The description of this Schema.
        :type: str
        """
        self._description = description

    @property
    def idcs_mappable(self):
        """
        **[Required]** Gets the idcs_mappable of this Schema.
        Specifies if the attributes in this schema can be used for mapping with external identity sources such as AD or LDAP

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The idcs_mappable of this Schema.
        :rtype: bool
        """
        return self._idcs_mappable

    @idcs_mappable.setter
    def idcs_mappable(self, idcs_mappable):
        """
        Sets the idcs_mappable of this Schema.
        Specifies if the attributes in this schema can be used for mapping with external identity sources such as AD or LDAP

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: boolean
         - uniqueness: none


        :param idcs_mappable: The idcs_mappable of this Schema.
        :type: bool
        """
        self._idcs_mappable = idcs_mappable

    @property
    def idcs_attribute_cacheable(self):
        """
        Gets the idcs_attribute_cacheable of this Schema.
        Specifies whether the attribute is cacheable. True by default for all attributes. If attribute with idcsAttributeCachable = false, is present \\\"attributesToGet\\\" while executing GET/SEARCH on cacheable resource, Cache is missed and data is fetched from Data Provider.

        **Added In:** 17.3.4

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_attribute_cacheable of this Schema.
        :rtype: bool
        """
        return self._idcs_attribute_cacheable

    @idcs_attribute_cacheable.setter
    def idcs_attribute_cacheable(self, idcs_attribute_cacheable):
        """
        Sets the idcs_attribute_cacheable of this Schema.
        Specifies whether the attribute is cacheable. True by default for all attributes. If attribute with idcsAttributeCachable = false, is present \\\"attributesToGet\\\" while executing GET/SEARCH on cacheable resource, Cache is missed and data is fetched from Data Provider.

        **Added In:** 17.3.4

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param idcs_attribute_cacheable: The idcs_attribute_cacheable of this Schema.
        :type: bool
        """
        self._idcs_attribute_cacheable = idcs_attribute_cacheable

    @property
    def idcs_override_common_attribute(self):
        """
        Gets the idcs_override_common_attribute of this Schema.
        Specifies whether the dataprovider mapping from resource schema should override from common schema with the same name.

        **Added In:** 2102181953

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_override_common_attribute of this Schema.
        :rtype: bool
        """
        return self._idcs_override_common_attribute

    @idcs_override_common_attribute.setter
    def idcs_override_common_attribute(self, idcs_override_common_attribute):
        """
        Sets the idcs_override_common_attribute of this Schema.
        Specifies whether the dataprovider mapping from resource schema should override from common schema with the same name.

        **Added In:** 2102181953

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param idcs_override_common_attribute: The idcs_override_common_attribute of this Schema.
        :type: bool
        """
        self._idcs_override_common_attribute = idcs_override_common_attribute

    @property
    def attributes(self):
        """
        Gets the attributes of this Schema.
        A complex type that specifies the set of Resource attributes

        **SCIM++ Properties:**
         - idcsCompositeKey: []
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex


        :return: The attributes of this Schema.
        :rtype: list[oci.identity_domains.models.SchemaAttributes]
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """
        Sets the attributes of this Schema.
        A complex type that specifies the set of Resource attributes

        **SCIM++ Properties:**
         - idcsCompositeKey: []
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex


        :param attributes: The attributes of this Schema.
        :type: list[oci.identity_domains.models.SchemaAttributes]
        """
        self._attributes = attributes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
