# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .serving_mode import ServingMode
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OnDemandServingMode(ServingMode):
    """
    The model's serving mode is on-demand serving on a shared infrastructure.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OnDemandServingMode object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.OnDemandServingMode.serving_type` attribute
        of this class is ``ON_DEMAND`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param serving_type:
            The value to assign to the serving_type property of this OnDemandServingMode.
            Allowed values for this property are: "ON_DEMAND", "DEDICATED"
        :type serving_type: str

        :param model_id:
            The value to assign to the model_id property of this OnDemandServingMode.
        :type model_id: str

        """
        self.swagger_types = {
            'serving_type': 'str',
            'model_id': 'str'
        }

        self.attribute_map = {
            'serving_type': 'servingType',
            'model_id': 'modelId'
        }

        self._serving_type = None
        self._model_id = None
        self._serving_type = 'ON_DEMAND'

    @property
    def model_id(self):
        """
        **[Required]** Gets the model_id of this OnDemandServingMode.
        The unique ID of a model to use. You can use the :func:`list_models` API to list the available models.


        :return: The model_id of this OnDemandServingMode.
        :rtype: str
        """
        return self._model_id

    @model_id.setter
    def model_id(self, model_id):
        """
        Sets the model_id of this OnDemandServingMode.
        The unique ID of a model to use. You can use the :func:`list_models` API to list the available models.


        :param model_id: The model_id of this OnDemandServingMode.
        :type: str
        """
        self._model_id = model_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
