# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .llm_inference_response import LlmInferenceResponse
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LlamaLlmInferenceResponse(LlmInferenceResponse):
    """
    The generated text result to return.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LlamaLlmInferenceResponse object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.LlamaLlmInferenceResponse.runtime_type` attribute
        of this class is ``LLAMA`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param runtime_type:
            The value to assign to the runtime_type property of this LlamaLlmInferenceResponse.
            Allowed values for this property are: "COHERE", "LLAMA"
        :type runtime_type: str

        :param created:
            The value to assign to the created property of this LlamaLlmInferenceResponse.
        :type created: datetime

        :param choices:
            The value to assign to the choices property of this LlamaLlmInferenceResponse.
        :type choices: list[oci.generative_ai_inference.models.Choice]

        """
        self.swagger_types = {
            'runtime_type': 'str',
            'created': 'datetime',
            'choices': 'list[Choice]'
        }

        self.attribute_map = {
            'runtime_type': 'runtimeType',
            'created': 'created',
            'choices': 'choices'
        }

        self._runtime_type = None
        self._created = None
        self._choices = None
        self._runtime_type = 'LLAMA'

    @property
    def created(self):
        """
        **[Required]** Gets the created of this LlamaLlmInferenceResponse.
        The Unix timestamp (in seconds) of when the generation was created.


        :return: The created of this LlamaLlmInferenceResponse.
        :rtype: datetime
        """
        return self._created

    @created.setter
    def created(self, created):
        """
        Sets the created of this LlamaLlmInferenceResponse.
        The Unix timestamp (in seconds) of when the generation was created.


        :param created: The created of this LlamaLlmInferenceResponse.
        :type: datetime
        """
        self._created = created

    @property
    def choices(self):
        """
        **[Required]** Gets the choices of this LlamaLlmInferenceResponse.
        A list of generated texts. Can be more than one if n is greater than 1.


        :return: The choices of this LlamaLlmInferenceResponse.
        :rtype: list[oci.generative_ai_inference.models.Choice]
        """
        return self._choices

    @choices.setter
    def choices(self, choices):
        """
        Sets the choices of this LlamaLlmInferenceResponse.
        A list of generated texts. Can be more than one if n is greater than 1.


        :param choices: The choices of this LlamaLlmInferenceResponse.
        :type: list[oci.generative_ai_inference.models.Choice]
        """
        self._choices = choices

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
