# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CohereToolCall(object):
    """
    A tool call generated by the model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CohereToolCall object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this CohereToolCall.
        :type name: str

        :param parameters:
            The value to assign to the parameters property of this CohereToolCall.
        :type parameters: object

        """
        self.swagger_types = {
            'name': 'str',
            'parameters': 'object'
        }

        self.attribute_map = {
            'name': 'name',
            'parameters': 'parameters'
        }

        self._name = None
        self._parameters = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CohereToolCall.
        Name of the tool to call.


        :return: The name of this CohereToolCall.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CohereToolCall.
        Name of the tool to call.


        :param name: The name of this CohereToolCall.
        :type: str
        """
        self._name = name

    @property
    def parameters(self):
        """
        **[Required]** Gets the parameters of this CohereToolCall.
        The parameters to use when invoking a tool.


        :return: The parameters of this CohereToolCall.
        :rtype: object
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters):
        """
        Sets the parameters of this CohereToolCall.
        The parameters to use when invoking a tool.


        :param parameters: The parameters of this CohereToolCall.
        :type: object
        """
        self._parameters = parameters

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
