# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210929


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateGoldenGateServiceDetails(object):
    """
    Details about Oracle GoldenGate GGS Deployment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateGoldenGateServiceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_db_credentials:
            The value to assign to the source_db_credentials property of this CreateGoldenGateServiceDetails.
        :type source_db_credentials: oci.database_migration.models.DatabaseCredentials

        :param source_container_db_credentials:
            The value to assign to the source_container_db_credentials property of this CreateGoldenGateServiceDetails.
        :type source_container_db_credentials: oci.database_migration.models.DatabaseCredentials

        :param target_db_credentials:
            The value to assign to the target_db_credentials property of this CreateGoldenGateServiceDetails.
        :type target_db_credentials: oci.database_migration.models.DatabaseCredentials

        :param settings:
            The value to assign to the settings property of this CreateGoldenGateServiceDetails.
        :type settings: oci.database_migration.models.CreateGoldenGateSettings

        """
        self.swagger_types = {
            'source_db_credentials': 'DatabaseCredentials',
            'source_container_db_credentials': 'DatabaseCredentials',
            'target_db_credentials': 'DatabaseCredentials',
            'settings': 'CreateGoldenGateSettings'
        }

        self.attribute_map = {
            'source_db_credentials': 'sourceDbCredentials',
            'source_container_db_credentials': 'sourceContainerDbCredentials',
            'target_db_credentials': 'targetDbCredentials',
            'settings': 'settings'
        }

        self._source_db_credentials = None
        self._source_container_db_credentials = None
        self._target_db_credentials = None
        self._settings = None

    @property
    def source_db_credentials(self):
        """
        Gets the source_db_credentials of this CreateGoldenGateServiceDetails.

        :return: The source_db_credentials of this CreateGoldenGateServiceDetails.
        :rtype: oci.database_migration.models.DatabaseCredentials
        """
        return self._source_db_credentials

    @source_db_credentials.setter
    def source_db_credentials(self, source_db_credentials):
        """
        Sets the source_db_credentials of this CreateGoldenGateServiceDetails.

        :param source_db_credentials: The source_db_credentials of this CreateGoldenGateServiceDetails.
        :type: oci.database_migration.models.DatabaseCredentials
        """
        self._source_db_credentials = source_db_credentials

    @property
    def source_container_db_credentials(self):
        """
        Gets the source_container_db_credentials of this CreateGoldenGateServiceDetails.

        :return: The source_container_db_credentials of this CreateGoldenGateServiceDetails.
        :rtype: oci.database_migration.models.DatabaseCredentials
        """
        return self._source_container_db_credentials

    @source_container_db_credentials.setter
    def source_container_db_credentials(self, source_container_db_credentials):
        """
        Sets the source_container_db_credentials of this CreateGoldenGateServiceDetails.

        :param source_container_db_credentials: The source_container_db_credentials of this CreateGoldenGateServiceDetails.
        :type: oci.database_migration.models.DatabaseCredentials
        """
        self._source_container_db_credentials = source_container_db_credentials

    @property
    def target_db_credentials(self):
        """
        Gets the target_db_credentials of this CreateGoldenGateServiceDetails.

        :return: The target_db_credentials of this CreateGoldenGateServiceDetails.
        :rtype: oci.database_migration.models.DatabaseCredentials
        """
        return self._target_db_credentials

    @target_db_credentials.setter
    def target_db_credentials(self, target_db_credentials):
        """
        Sets the target_db_credentials of this CreateGoldenGateServiceDetails.

        :param target_db_credentials: The target_db_credentials of this CreateGoldenGateServiceDetails.
        :type: oci.database_migration.models.DatabaseCredentials
        """
        self._target_db_credentials = target_db_credentials

    @property
    def settings(self):
        """
        Gets the settings of this CreateGoldenGateServiceDetails.

        :return: The settings of this CreateGoldenGateServiceDetails.
        :rtype: oci.database_migration.models.CreateGoldenGateSettings
        """
        return self._settings

    @settings.setter
    def settings(self, settings):
        """
        Sets the settings of this CreateGoldenGateServiceDetails.

        :param settings: The settings of this CreateGoldenGateServiceDetails.
        :type: oci.database_migration.models.CreateGoldenGateSettings
        """
        self._settings = settings

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
